/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-debugger.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_debugger_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-debugger-quark");
	}
	
	return quark;
}

/**
* ianjuta_debugger_breakpoint_delete:
* @obj: Self
* @uri: fixme
* @line: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_breakpoint_delete (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	g_return_if_fail (uri != NULL);
	IANJUTA_DEBUGGER_GET_IFACE (obj)->breakpoint_delete (obj, uri, line, err);
}

/**
* ianjuta_debugger_breakpoint_set:
* @obj: Self
* @uri: fixme
* @line: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_breakpoint_set (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	g_return_if_fail (uri != NULL);
	IANJUTA_DEBUGGER_GET_IFACE (obj)->breakpoint_set (obj, uri, line, err);
}

/**
* ianjuta_debugger_breakpoint_toggle:
* @obj: Self
* @uri: fixme
* @line: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_breakpoint_toggle (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	g_return_if_fail (uri != NULL);
	IANJUTA_DEBUGGER_GET_IFACE (obj)->breakpoint_toggle (obj, uri, line, err);
}

/**
* ianjuta_debugger_is_busy:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_debugger_is_busy (IAnjutaDebugger *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER(obj), FALSE);
	return IANJUTA_DEBUGGER_GET_IFACE (obj)->is_busy (obj, err);
}

/**
* ianjuta_debugger_load:
* @obj: Self
* @prog_uri: fixme
* @source_search_directories: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_load (IAnjutaDebugger *obj, const gchar *prog_uri, const GList *source_search_directories, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	g_return_if_fail (prog_uri != NULL);
	IANJUTA_DEBUGGER_GET_IFACE (obj)->load (obj, prog_uri, source_search_directories, err);
}

/**
* ianjuta_debugger_run_continue:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_run_continue (IAnjutaDebugger *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	IANJUTA_DEBUGGER_GET_IFACE (obj)->run_continue (obj, err);
}

/**
* ianjuta_debugger_run_to_position:
* @obj: Self
* @uri: fixme
* @line: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_run_to_position (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	g_return_if_fail (uri != NULL);
	IANJUTA_DEBUGGER_GET_IFACE (obj)->run_to_position (obj, uri, line, err);
}

/**
* ianjuta_debugger_step_in:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_step_in (IAnjutaDebugger *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	IANJUTA_DEBUGGER_GET_IFACE (obj)->step_in (obj, err);
}

/**
* ianjuta_debugger_step_out:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_step_out (IAnjutaDebugger *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	IANJUTA_DEBUGGER_GET_IFACE (obj)->step_out (obj, err);
}

/**
* ianjuta_debugger_step_over:
* @obj: Self
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_debugger_step_over (IAnjutaDebugger *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DEBUGGER(obj));
	IANJUTA_DEBUGGER_GET_IFACE (obj)->step_over (obj, err);
}

static void
ianjuta_debugger_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("busy",
			IANJUTA_TYPE_DEBUGGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDebuggerIface, busy),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__BOOLEAN,
			G_TYPE_NONE,
			1,
			G_TYPE_BOOLEAN);


		initialized = TRUE;
	}
}

GType
ianjuta_debugger_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDebuggerIface),
			ianjuta_debugger_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDebugger", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
