/*
 */

/*
WNN7 CLIENT LIBRARY--SOFTWARE LICENSE TERMS AND CONDITIONS


Wnn7 Client Library :
(C) Copyright OMRON Corporation.       1995,1998,2000,2001 all rights reserved.
(C) Copyright OMRON Software Co., Ltd. 1995,1998,2000,2001 all rights reserved.

Wnn Software :
(C) Copyright Kyoto University Research Institute for Mathematical Sciences
     1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright ASCTEC, Inc.  1987, 1988, 1989, 1990, 1991, 1992, 1993

Preamble

These Wnn7 Client Library--Software License Terms and Conditions
 (the "License Agreement") shall state the conditions under which you are
 permitted to copy, distribute or modify the software which can be used
 to create Wnn7 Client Library (the "Wnn7 Client Library").  The License
 Agreement can be freely copied and distributed verbatim, however, you
 shall NOT add, delete or change anything on the License Agreement.

OMRON Corporation and OMRON Software Co., Ltd. (collectively referred to
 as "OMRON") jointly developed the Wnn7 Software (development code name
 is FI-Wnn), based on the Wnn Software.  Starting from November, 1st, 1998,
 OMRON publishes the source code of the Wnn7 Client Library, and OMRON
 permits anyone to copy, distribute or change the Wnn7 Client Library under
 the License Agreement.

Wnn7 Client Library is based on the original version of Wnn developed by
 Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 OMRON Corporation and ASTEC Inc.

Article 1.  Definition.

"Source Code" means the embodiment of the computer code, readable and
 understandable by a programmer of ordinary skills.  It includes related
 source code level system documentation, comments and procedural code.

"Object File" means a file, in substantially binary form, which is directly
 executable by a computer after linking applicable files.

"Library" means a file, composed of several Object Files, which is directly
 executable by a computer after linking applicable files.

"Software" means a set of Source Code including information on its use.

"Wnn7 Client Library" the computer program, originally supplied by OMRON,
 which can be used to create Wnn7 Client Library.

"Executable Module" means a file, created after linking Object Files or
 Library, which is directly executable by a computer.

"User" means anyone who uses the Wnn7 Client Library under the License
 Agreement.

Article 2.  Copyright

2.1  OMRON Corporation and OMRON Software Co., Ltd. jointly own the Wnn7
 Client Library, including, without limitation, its copyright.

2.2  Following words followed by the above copyright notices appear
 in all supporting documentation of software based on Wnn7 Client Library:

  This software is based on the original version of Wnn7 Client Library
  developed by OMRON Corporation and OMRON Software Co., Ltd. and also based on
  the original version of Wnn developed by Kyoto University Research Institute
  for Mathematical Sciences (KURIMS), OMRON Corporation and ASTEC Inc.

Article 3.  Grant

3.1  A User is permitted to make and distribute verbatim copies of
 the Wnn7 Client Library, including verbatim of copies of the License
 Agreement, under the License Agreement.

3.2  A User is permitted to modify the Wnn7 Client Library to create
 Software ("Modified Software") under the License Agreement.  A User
 is also permitted to make or distribute copies of Modified Software,
 including verbatim copies of the License Agreement with the following
 information.  Upon modifying the Wnn7 Client Library, a User MUST insert
 comments--stating the name of the User, the reason for the modifications,
 the date of the modifications, additional terms and conditions on the
 part of the modifications if there is any, and potential risks of using
 the Modified Software if they are known--right after the end of the
 License Agreement (or the last comment, if comments are inserted already).

3.3  A User is permitted to create Library or Executable Modules by
 modifying the Wnn7 Client Library in whole or in part under the License
 Agreement.  A User is also permitted to make or distribute copies of
 Library or Executable Modules with verbatim copies of the License
 Agreement under the License Agreement.  Upon modifying the Wnn7 Client
 Library for creating Library or Executable Modules, except for porting
 a computer, a User MUST add a text file to a package of the Wnn7 Client
 Library, providing information on the name of the User, the reason for
 the modifications, the date of the modifications, additional terms and
 conditions on the part of the modifications if there is any, and potential
 risks associated with using the modified Wnn7 Client Library, Library or
 Executable Modules if they are known.

3.4  A User is permitted to incorporate the Wnn7 Client Library in whole
 or in part into another Software, although its license terms and
 conditions may be different from the License Agreement, if such
 incorporation or use associated with the incorporation does NOT violate
 the License Agreement.

Article 4. Warranty

THE WNN7 CLIENT LIBRARY IS PROVIDED BY OMRON ON AN "AS IS" BAISIS.
  OMRON EXPRESSLY DISLCIAMS ANY AND ALL WRRANTIES, EXPRESS OR IMPLIED,
 INCLUDING, WITHOUT LIMITATION, WARRANTIES OF MERCHANTABILITY AND FITNESS
 FOR A PARTICULAR PURPOSE, IN CONNECTION WITH THE WNN7 CLIENT LIBRARY
 OR THE USE OR OTHER DEALING IN THE WNN7 CLIENT LIBRARY.  IN NO EVENT
 SHALL OMRON BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, PUNITIVE
 OR CONSEQUENTIAL DAMAGES OF ANY KIND WHATSOEVER IN CONNECTION WITH THE
 WNN7 CLIENT LIBRARY OR THE USE OR OTHER DEALING IN THE WNN7 CLIENT
LIBRARY.

***************************************************************************
Wnn7 Client Library :
(C) Copyright OMRON Corporation.       1995,1998,2000,2001 all rights reserved.
(C) Copyright OMRON Software Co., Ltd. 1995,1998,2000,2001 all rights reserved.

Wnn Software :
(C) Copyright Kyoto University Research Institute for Mathematical Sciences
     1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright ASCTEC, Inc.  1987, 1988, 1989, 1990, 1991, 1992, 1993
***************************************************************************

Comments on Modifications:
*/

/*	Version 4
 */
/*
	Nihongo Henkan Library
*/
/*
	entry functions

	js_open_lang	js_close
	js_change_current_jserver
	js_connect_lang	js_disconnect
	js_isconnect

	js_param_get	js_param_set

	js_access	js_mkdir

	js_get_lang	js_set_lang


extern	Variables
	int	wnn_errorno;
*/


extern	char	*malloc();

#include <stdio.h>
#include <ctype.h>
#ifdef UX386
#include <X11/Xos.h>
#else
#include <fcntl.h>
#endif
#include <pwd.h>
#ifndef UX386
#include <sys/types.h>
#endif
#include <sys/stat.h>
#include <errno.h>
extern int errno;
#include <signal.h>
#include "jd_sock.h"
#include "commonhd.h"
#include "demcom.h"
#include "config.h"

#include "wnnerror.h"
#include "jslib.h"
#include "jllib.h"
#include "mt_jlib.h"
#include "jh.h"

#include "msg.h"

#define JS			/* For include ../etc/bdic.c */
#include "../etc/bdic.c"
/*
 * (Jul. 11, 1994)
 * New bdic function for FI-Wnn
 */
#include "../etc/fi_bdic.c"
#include "../etc/pwd.c"


char *malloc();

typedef struct _host_address {
	int address_len;
	char *address;
} host_address;

int	wnn_errorno	=0;

struct msg_cat *wnn_msg_cat = NULL;

/*	j Lib.	*/

static	int		current_sd;		/** åfd	**/
static	WNN_JSERVER_ID_INT	*current_js = NULL;

/*	Packet Buffers		*/
static	unsigned char	snd_buf[S_BUF_SIZ];	/**  **/
static	int	sbp=0;			/** Хåեݥ󥿡 **/
static	int	rbc= -1;		/** Хåեݥ󥿡 **/
static	int rbp=0;
static	unsigned char rcv_buf[R_BUF_SIZ]; /**  **/

#if defined(EAGAIN)
# if defined(EWOULDBLOCK)
# define ERRNO_CHECK(no) 	((no) == EAGAIN || (no) == EWOULDBLOCK)
# else /* defined(EWOULDBLOCK) */
# define ERRNO_CHECK(no)	((no) == EAGAIN)
# endif /* defined(EWOULDBLOCK) */
#else /* defined(EAGAIN) */
# if defined(EWOULDBLOCK)
# define ERRNO_CHECK(no)	((no) == EWOULDBLOCK)
# else /* defined(EWOULDBLOCK) */
# define ERRNO_CHECK(no)	(0)
# endif /* defined(EWOULDBLOCK) */
#endif /* defined(EAGAIN) */

static int _get_server_name(
char *server,
char *pserver,
int pserver_size,
int *portNO
);
static int writen();

static WNN_JSERVER_ID *js_open_lang_core(
char *servername, char *lang, int tmout
);


/*********	V4	*****************/
/***
	jserver_dead Macro
***/

static	jmp_buf	current_jserver_dead;

#define	handler_of_jserver_dead(current_js) \
{ \
    if (current_js) { \
	if(current_js->js_dead){ \
	    js_wnn_errorno_set=WNN_JSERVER_DEAD; \
	} else \
	if(setjmp(js_current_jserver_dead)){ \
	    if (!js_wnn_errorno_eql) js_wnn_errorno_set=WNN_JSERVER_DEAD; \
	} else \
	js_wnn_errorno_set = 0; /* here initialize wnn_errorno; */    \
    } \
}

#define handler_of_jserver_dead_env(env) \
{ \
    if (env->js_id) { \
        if(env->js_id->js_dead){ \
            env_wnn_errorno_set=WNN_JSERVER_DEAD; \
        } else \
        if(setjmp(env_current_jserver_dead)){ \
            if (!env_wnn_errorno_eql) env_wnn_errorno_set=WNN_JSERVER_DEAD; \
        } else \
        env_wnn_errorno_set = 0; /* here initialize wnn_errorno; */    \
    } \
}

/* put1com(), put2com(), put4com() Υޥ */
/* 2000/09/22  */
/**	Ф1Х	**/
#define JS_Put1Com(data, server) { \
	snd_buf[sbp++] = (data) & 0xff; \
	if (sbp >= S_BUF_SIZ) { \
		writen(S_BUF_SIZ, (server)); \
		sbp = 0; \
	} \
}

/**	Ф2Х	**/
#define JS_Put2Com(data, server) { \
	JS_Put1Com(data>>8, server); \
	JS_Put1Com(data, server); \
}

/**	Ф4Х	**/
#define JS_Put4Com(data, server) { \
	JS_Put1Com(data>>24, server); \
	JS_Put1Com(data>>16, server); \
	JS_Put1Com(data>>8, server); \
	JS_Put1Com(data, server); \
}

static void
set_current_js(server)
register WNN_JSERVER_ID *server;
{
	current_js = (WNN_JSERVER_ID_INT *)server;
	current_sd = current_js->orig.sd;
}

#undef ARGS
#define ARGS char
#define js_wnn_errorno_set wnn_errorno
#define js_wnn_errorno_eql wnn_errorno
#define env_wnn_errorno_set wnn_errorno
#define env_wnn_errorno_eql wnn_errorno
#define js_current_jserver_dead current_jserver_dead
#define env_current_jserver_dead current_jserver_dead

/**	ǡ󤬻Τθ	**/
static void
demon_dead(server)
ARGS *server;
{
	current_js->orig.js_dead= -1;
	js_wnn_errorno_set = WNN_JSERVER_DEAD;
	shutdown(current_sd, 2);
	close(current_sd);
	if(current_js->orig.js_dead_env_flg){
		longjmp(current_js->orig.js_dead_env,666);
	}
	longjmp(js_current_jserver_dead,666);
	/* never reach */
}


/**
	åȤ򥪡ץ󤷤current_sd˥åfd֤
			(cdȤΤϥߥ˥ǥХ̾)
**/
static int
cd_open(lang)
register char *lang;
{
#ifdef AF_UNIX
	int sd;
	struct sockaddr_un saddr;		/** å **/
	char *sock_name = NULL;
	saddr.sun_family = AF_UNIX;

	/* find socket name from table by lang */
	sock_name = UNIX_SOCKET_NAME;		/* Jserver */
	strcpy(saddr.sun_path, sock_name);
#if ((defined AIXV3) || (defined FREEBSD))
	strcat(saddr.sun_path, "=");
#endif

	if ((sd = socket(AF_UNIX,SOCK_STREAM, 0)) == ERROR) {
		return -1;
	}
	if (connect(sd,(struct sockaddr *)&saddr,strlen(saddr.sun_path)+sizeof(saddr.sun_family)) == ERROR) {
		close(sd);
		return -1;
	}
	return sd;
#else
	return -1;
#endif
}

static intfntype
connect_timeout()
{
	SIGNAL_RETURN;
}

static int
cd_open_in_core(sa, tmout)
register struct sockaddr_in *sa;
register int tmout;
{
	int sd;
	int ret;
	int old_alarm = 0;
	intfntype (*save_alarm_proc)() = NULL;

	if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == ERROR){
		return -1 ;
	}

	if (tmout > 0) {
		save_alarm_proc = signal(SIGALRM, connect_timeout);
		old_alarm = alarm(tmout);
	}
	ret = connect(sd, (struct sockaddr *)sa, sizeof(struct sockaddr_in));
	if (tmout > 0) {
		alarm(old_alarm);
		if (save_alarm_proc)
			signal(SIGALRM, save_alarm_proc);
			else
			signal(SIGALRM, SIG_IGN);
	}
	if (ret == ERROR) {
		close(sd);
		return -1 ;
	}
	return sd;
}

static int
cd_open_in_by_addr(addr, addrlen, port, tmout)
char *addr;
int addrlen, port, tmout;
{
	struct sockaddr_in saddr_in;

	memset((char *)&saddr_in,0,sizeof(saddr_in));
	memcpy((char *)&saddr_in.sin_addr, addr, addrlen);
	saddr_in.sin_family = AF_INET;
	saddr_in.sin_port = port;
	return(cd_open_in_core(&saddr_in, tmout));
}

typedef struct _my_serv_struct {
	char *name;
	int port;
	struct _my_serv_struct *next;
} my_serv_struct;

static int my_getservbyname(name)
register char *name;
{
	static my_serv_struct *tbl = NULL;
	register my_serv_struct *p;
	struct servent *sp = NULL;
	register int len;

	for (p = tbl; p; p = p->next) {
		if (p->name && !strcmp(p->name, name)) return(p->port);
	}
	sp = getservbyname(name,"tcp");
	endservent();
	if (!sp) return(-1);
	len = strlen(name);
	if (!(p = (my_serv_struct *)malloc(sizeof(my_serv_struct) + len + 1)))
		return(-1);
	p->name = ((char *)p) + sizeof(my_serv_struct);
	strcpy(p->name, name);
	p->port = ntohs(sp->s_port);
	p->next = tbl;
	tbl = p;
	return(p->port);
}

static int
cd_open_in(server, lang, tmout)
register char *server;
register char *lang;
register int tmout;
{
	struct sockaddr_in saddr_in;		/** å **/
	register struct hostent *hp;
	int serverNO, port_num;
	char pserver[MAXHOSTNAMELEN];
	char sserver[64];
	unsigned long ia;
	char *inet_ntoa();

	serverNO = _get_server_name(server, pserver, sizeof(pserver), &port_num);

	if (port_num > 0) {
		/* absolute port number is specified */
		serverNO += port_num;
	} else {
		/* find service name from table by lang */
		strncpy(sserver, SERVERNAME, sizeof(sserver) - 1);
		sserver[sizeof(sserver) - 1] = 0;
		if ((port_num = my_getservbyname(sserver)) != -1) {
			serverNO += port_num;
		} else {
			serverNO += WNN_PORT_IN;
		}
	}
	memset((char *)&saddr_in,0,sizeof(saddr_in));

	if (isascii((unsigned char)pserver[0]) && isdigit((unsigned char)pserver[0])) {
		ia = inet_addr(pserver);
		saddr_in.sin_addr.s_addr = ia;
	} else {
		hp = gethostbyname(pserver);
		endhostent();
		if (!hp)
			return -1;
		memcpy((char *)&saddr_in.sin_addr, hp->h_addr, hp->h_length);
	}
	saddr_in.sin_family = AF_INET;
	saddr_in.sin_port = htons(serverNO);
	return(cd_open_in_core(&saddr_in, tmout));
}

/* get server name and return serverNo */
/* and return absolute port number 1993/12/07 */
static int
_get_server_name(server, pserver, pserver_size, portNO)
char *server;
char *pserver;
int pserver_size;
int *portNO;
{
	register char *p;
	register int port = 0, offset = 0;

	strncpy(pserver, server, pserver_size - 1);
	pserver[pserver_size - 1] = '\0';
	if ((p = strchr(pserver, ':'))) {
		*p = '\0';
		if (*(p+1)) offset = atoi(p+1);
	}
	if ((p = strchr(pserver, '/'))) {
		*p = '\0';
		if (*(p+1)) port = atoi(p+1);
	}
	*portNO = port;
	return(offset);
}

/* Фץȥ򥵥ݡȤƤ뤫ɤΥå */
#define check_version(cmd) \
	(((cmd>>12) & 0xFFF) > (current_js->version & 0xFFF))

/* Фƣɴط򥵥ݡȤƤ뤫ɤΥå */
#define CHECK_FI \
        ((current_js->version & 0xFFF) >= 0xF00)

/* Ф Wnn7 ط򥵥ݡȤƤ뤫ɤΥå */
#define CHECK_VERSION_WNN7 \
        ((current_js->version & 0xFFF) >= 0xF01)

/**	ѥåȤΥإå	**/
static void
snd_head(cmd, server)
int cmd;	/** cmd=ޥ **/
ARGS *server;
{
	sbp=0;
	if (check_version(cmd)) {
		js_wnn_errorno_set = WNN_NOT_SUPPORT_PACKET;
		longjmp(js_current_jserver_dead,666);
	}
	JS_Put4Com(cmd, server);
	rbc= -1;
}

/**	ѥåȤΥإå	**/
static int
snd_env_head(env,cmd)
register struct wnn_env *env;
int cmd;	/** cmd=ޥ **/
{
	ARGS *args = NULL;

	snd_head(cmd, args);
	JS_Put4Com(env->env_id, args);
	return 0;
}

/**	ѥåȤΥإå	**/
static int
snd_server_head(server,cmd)
register WNN_JSERVER_ID *server;
int cmd;	/** cmd=ޥ **/
{
	ARGS *args = NULL;

	snd_head(cmd, args);
	return 0;
}

/**	Хåեեå夹	**/
static int
snd_flush(server)
ARGS *server;
{
	if(sbp==0)return(-1);
	writen(sbp, server);
	sbp=0;
	return(0);
}

static int
writen(n, server)
int n;
ARGS *server;
{
	int cc,x;
	for(cc=0;cc<n;){
		errno = 0;
		x=write(current_sd, &(snd_buf[cc]), n-cc );
		if(x < 0) {
			if (ERRNO_CHECK(errno) || errno == EINTR) {
				continue;
			} else {
				demon_dead(server);
				return -1;
			}
		}
		cc+=x;
	}
	return(0);
}

/**	Фʸ	**/
static void
putwscom(p, server)
register w_char *p;
ARGS *server;
{
	if (p != NULL) {
		while (*p) {
			JS_Put2Com(*p, server);
			p++;
		}
	}
	JS_Put2Com(0, server);
	return;
}

/**	Фʸ	**/
static void
putscom(p, server)
register char *p;
ARGS *server;
{
	if (p != NULL) {
		while (*p) {
			JS_Put1Com(*p, server);
			p++;
		}
	}
	JS_Put1Com(0, server);
	return;
}

static int
rcv_1_client(server)
ARGS *server;
{
	while(1) {
		errno = 0;
		rbc = read(current_sd, rcv_buf, R_BUF_SIZ);
		if (rbc <= 0) {
			if (ERRNO_CHECK(errno)) {
				continue;
			} else if (rbc == 0) {
				demon_dead(server);
				return -1;
			} else {
				if (errno != EINTR) {
					demon_dead(server);
					return -1;
				}
				continue;
			}
		}
		rbp = 0;
		break;
	}
	return rbc;
}

/**	Ф1Хȼ	**/
static int
get1com(server)
ARGS *server;
{
	if (rbc <= 0) {
		rbc = rcv_1_client(server);
	}
	rbc--;
	return rcv_buf[rbp++] & 0xFF ;
}

/**	Ф2Хȼ	**/
static int
get2com(server)
ARGS *server;
{
	register int i;
	int x[2];

	for (i = 0; i < 2; i++) {
		if (rbc <= 0) {
			rbc = rcv_1_client(server);
		}
		rbc--;
		x[i] = rcv_buf[rbp++] & 0xFF;
	}
	return (x[0] << 8) | x[1];
}

/**	Ф4Хȼ	**/
static int
get4com(server)
ARGS *server;
{
	register int i;
	int x[4];

	for (i = 0; i < 4; i++) {
		if (rbc <= 0) {
			rbc = rcv_1_client(server);
		}
		rbc--;
		x[i] = rcv_buf[rbp++] & 0xFF;
	}
	return (x[0] << 24) | (x[1] << 16) | (x[2] << 8) | x[3];
}

/**	Фʸ	**/
static void
getscom(cp, server, buflen)
register char *cp;
ARGS *server;
register int buflen;
{
	register int i;

	for (i = 0 ; i < buflen ; i++) {
		if (rbc <= 0) {
			rbc = rcv_1_client(server);
		}
		rbc--;
		if ((*cp++ = rcv_buf[rbp++] & 0xFF) == '\0') {
			break;
		}
	}

	/* Buffer Overflow size? */
	if (i >= buflen) {
		/* ĤΥǡ˴ */
		while(1) {
			if (rbc <= 0) {
				rbc = rcv_1_client(server);
			}
			rbc--;
			if (rcv_buf[rbp++] == '\0') {
				break;
			}
		}
		if (i > 0) {
			*(cp - 1) = '\0'; /* set null terminate */
		}
	}
}

/**	Фʸ	**/
static void
getwscom(wp, server, buflen)
register w_char *wp;
ARGS *server;
register int buflen; /* not bytes. "buflen" is word length. */
{
	register int i, j;
	int x[2];

	for (i = 0 ; i < buflen ; i++) {
		for (j = 0; j < 2; j++) {
			if (rbc <= 0) {
				rbc = rcv_1_client(server);
			}
			rbc--;
			x[j] = rcv_buf[rbp++] & 0xFF;
		}
		if ((*wp++ = ((x[0] << 8) | x[1])) == '\0') {
			break;
		}
	}

	/* Buffer Overflow size? */
	if (i >= buflen) {
		/* ĤΥǡ˴ */
		while(1) {
			for (j = 0; j < 2; j++) {
				if (rbc <= 0) {
					rbc = rcv_1_client(server);
				}
				rbc--;
				x[j] = rcv_buf[rbp++] & 0xFF;
			}
			if (((x[0] << 8) | x[1]) == '\0') {
				break;
			}
		}
		if (i > 0) {
			*(wp - 1) = '\0'; /* set null terminate */
		}
	}
}

/*	get login name form /etc/passwd file	*/
static char*	
getlogname()
{
	extern struct passwd *getpwuid();
	struct passwd *pw;

	pw = getpwuid(getuid());
	endpwent();
	if (pw == NULL)
		return NULL;
	return pw->pw_name;
}

static int
send_js_open_core(server, host, user, version)
WNN_JSERVER_ID *server;
char *host, *user;
int version;
{
	int x;

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) return(-1);
	snd_head(JS_OPEN, server);
	JS_Put4Com(version, server);		/* H.T. */
	putscom(host, server);
	putscom(user, server);
	snd_flush(server);
	if((x = get4com(server)) == -1){
		js_wnn_errorno_set=get4com(server);
		return(-1);
	}
	return(x);
}



/*:::DOC_START
 *
 *    Function Name: version_negotiation
 *    Description  : 
 *	   饤ȡд֤ΥץȥСĴԤ
 *    Parameter    :
 *	   server :       (InOut) о¤ΤؤΥݥ
 *	   host :         (In) 饤Ȼѥۥ̾
 *	   user :         (In) 饤Ȼѥ桼̾
 *	   init_version : (In) 饤ȤΥץȥСֹ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
static int
version_negotiation(server, host, user, init_version)
WNN_JSERVER_ID *server;
char *host, *user;
int init_version;
{
	int version, dummy;

	/* ᥸㡼Сå */
	if((init_version >> 12) != 4) return(-1);

	if (init_version > 0x4F00) {
		/* 4.F00 礭 4.F00 Ǻƥȥ饤 */
		if (send_js_open_core(server, host, user, 0x4F00) < 0) {
			if (js_wnn_errorno_eql == WNN_BAD_VERSION) {
				/* 4.003 Ǻƥȥ饤 */
				if (send_js_open_core(server, host, user, 0x4003) < 0)
					return(-1);
				((WNN_JSERVER_ID_INT *)server)->version = 0x4003;
				return(0);
			}
			return(-1);
		}
		/* ХСΥå */
		if (js_version(server, &version, &dummy) == -1) return(-1);
		if (version > 0x4F00) {
			/* ХСǺƥȥ饤 */
			if (send_js_open_core(server, host, user, version) >= 0) {
				((WNN_JSERVER_ID_INT *)server)->version = version;
				return(0);
			}
		}
		((WNN_JSERVER_ID_INT *)server)->version = 0x4F00;
	} else {
		/* 4.003 Ǻƥȥ饤 */
		if (send_js_open_core(server, host, user, 0x4003) < 0)
			return(-1);
		((WNN_JSERVER_ID_INT *)server)->version = 0x4003;
	}

	return(0);

} /* End of version_negotiation */



static  WNN_JSERVER_ID *
reconnect_other_host(server, user, host, tmout)
WNN_JSERVER_ID *server;
char *user, *host;
int tmout;
{
	char addr[32];
	int addrlen, i, port;
	char *new_js;
	int x;
	struct hostent *hp;

	addrlen = get4com(server);
	/* Buffer Overflow size? */
	if (addrlen > sizeof(addr)) {
		for (i = 0; i < addrlen; i++) get1com(server);
	} else {
		for (i = 0; i < addrlen; i++) addr[i] = get1com(server);
	}
	port = get4com(server);
	js_close(server);

	/* Buffer Overflow size? */
	if (addrlen > sizeof(addr)) {
		js_wnn_errorno_set = WNN_SOME_ERROR;
		return NULL;
	}
	hp = gethostbyaddr(addr, addrlen, AF_INET);
	endhostent();
	if (!hp) {
		js_wnn_errorno_set = WNN_NO_JSERVER;
		return NULL;
	}
	sbp=0;	/* init sndBufPointer */
	if(!(new_js=(char *)malloc(sizeof(WNN_JSERVER_ID_INT)))){
		js_wnn_errorno_set=WNN_ALLOC_FAIL;
		return NULL;
	}
	server =(WNN_JSERVER_ID *) new_js;
	strncpy(server->js_name, hp->h_name, sizeof(server->js_name) - 1);
	server->js_name[sizeof(server->js_name) - 1] = '\0';
	server->js_dead= 0;
	server->js_dead_env_flg= 0;
	if((current_sd= cd_open_in_by_addr(addr, addrlen, port, tmout))==-1){
		js_wnn_errorno_set = WNN_NO_JSERVER;
		free((char*)server);
		current_js=NULL;
		return NULL;
	}
	server->sd= current_sd;
	((WNN_JSERVER_ID_INT *)server)->version = JLIB_VERSION;
	((WNN_JSERVER_ID_INT *)server)->extensions = NULL;
	if ((x = send_js_open_core(server, host, user, JLIB_VERSION)) == -1) {
		x = js_wnn_errorno_eql;
		js_wnn_errorno_set = 0;
		if ((x != WNN_BAD_VERSION) ||
		    version_negotiation(server, host, user, JLIB_VERSION)) {
			js_close(server);		/* H.T. */
			current_js = NULL;
			return NULL;
		}
	} else if (x == 1) {
		/* re-connect to other server */
		return(reconnect_other_host(server, user, host, tmout));
	}
	return(server);
}

/*
 *		Lib. Functions
 *		raw lib.
 */

/***
	js
	global
***/


/**	  jserver ³롣jserver_id ֤	**/
WNN_JSERVER_ID *
js_open_lang(servername, lang, tmout)
register char *servername, *lang;
register int tmout;
{
	return(js_open_lang_core(servername, lang, tmout
	    ));
}



static WNN_JSERVER_ID *
js_open_lang_core(servername, lang, tmout
)
register char *servername, *lang;
register int tmout;
{
	char *new_js, *username;
	char host[MAXHOSTNAMELEN],user[WNN_ENVNAME_LEN];
	int x;
	WNN_JSERVER_ID_INT *server;

	if (wnn_msg_cat == NULL){
		wnn_msg_cat = msg_open("libwnn.msg");
		if(wnn_msg_cat == NULL){
			fprintf(stderr, "libwnn: Can't open message file for libwnn.a\n");
		}
	}


	if(!(new_js=(char *)malloc(sizeof(WNN_JSERVER_ID_INT)))){
		wnn_errorno=WNN_ALLOC_FAIL;
		return NULL;
	}


	current_js =(WNN_JSERVER_ID_INT *) new_js;
	if (servername == NULL) {
		current_js->orig.js_name[0] = '\0';
	} else {
		strncpy(current_js->orig.js_name, servername, sizeof(current_js->orig.js_name) - 1);
		current_js->orig.js_name[sizeof(current_js->orig.js_name) - 1] = '\0';
	}
	current_js->orig.js_dead= 0;
	current_js->orig.js_dead_env_flg= 0;

	/*
	 if(user == NULL || 0==strcmp(user,""))
	*/
	username = getlogname();
	if (username) {
		strncpy(user, username, WNN_ENVNAME_LEN);
		user[WNN_ENVNAME_LEN-1] = '\0';	/* truncate by WNN_ENVNAME_LEN */
	} else {
		user[0] = '\0';
	}
	if(servername == NULL || 0==strcmp(servername,"") || 0==strcmp(servername,"unix")){
		strcpy(host,"unix");
		if((current_sd= cd_open(lang))==-1){

			wnn_errorno=WNN_SOCK_OPEN_FAIL;
			free((char*)current_js);
			current_js=NULL;
			return NULL;
		}
	} else{
		gethostname(host, sizeof(host) - 1);
		host[sizeof(host) - 1] = '\0';
		if((current_sd= cd_open_in(servername, lang, tmout))==-1){

			wnn_errorno=WNN_SOCK_OPEN_FAIL;
			free((char*)current_js);
			current_js=NULL;
			return NULL;
		}
	}
	current_js->orig.sd= current_sd;
	current_js->version= JLIB_VERSION;
	current_js->extensions= NULL;
	server = current_js;
		x = send_js_open_core(server, host, user, JLIB_VERSION);
	if (x == -1) {
		x = wnn_errorno;
		wnn_errorno = 0;
		if ((x != WNN_BAD_VERSION) ||
		    version_negotiation(server, host, user, JLIB_VERSION)) {
			js_close(current_js);
			current_js = NULL;
			wnn_errorno = x;

			return NULL;
		}
	} else if (x == 1) {
		/* re-connect to other server */
		return(reconnect_other_host(server, user, host, tmout));
	}

	return (WNN_JSERVER_ID *)current_js;
}


/**	åȤ򥯥	**/
/**	  jserver Ȥ³ close 롣	**/
int
js_close(server)
WNN_JSERVER_ID *server;
{
	register int x;
	WNN_JSERVER_ID_INT tmp_js_id;

	if(server==0) return(-1);
	tmp_js_id = *(WNN_JSERVER_ID_INT *)server;
	free((char *)server);
	current_js = &tmp_js_id;
	server = (WNN_JSERVER_ID *)current_js;
	set_current_js(server);

	/*	handler of jserver dead */
	handler_of_jserver_dead(server);
	if(wnn_errorno) {

		return(-1);
	}
	snd_head(JS_CLOSE, server);
	snd_flush(server);
	x=get4com(server);
	if(x==-1)wnn_errorno=get4com(server);
	close(current_sd);

	return x;
}


/*
	jserver Ȥδ֤ connection ĥꡢƱ jserver ˴
	롣env_name ˴¸ߤĶꤷˤϤδĶ
	֤NULL ꤷˤϿĶä֤
*/

struct wnn_env *
js_connect_lang(server, env_name, lang)
register char *env_name;
WNN_JSERVER_ID *server;
char *lang;
{
	register int e_id;
	register struct wnn_env_int *env;
	void js_set_lang();

	set_current_js(server);
	if(!(env=(struct wnn_env_int *)malloc(sizeof(struct wnn_env_int)))){
		js_wnn_errorno_set=WNN_ALLOC_FAIL;
		return NULL;
	}

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		free(env);
		return(NULL);
	}
	snd_head(JS_CONNECT, server);
	putscom(env_name, server);
	snd_flush(server);
	e_id=get4com(server);
	if(e_id==-1){ 
		js_wnn_errorno_set= get4com(server); 
		free(env); 
		return NULL; 
	}

	env->orig.env_id = e_id;
	env->orig.js_id  = (WNN_JSERVER_ID *)server;
	env->orig.muhenkan_mode = WNN_DIC_RDONLY;
	env->orig.bunsetsugiri_mode = WNN_DIC_RDONLY;
	env->orig.kutouten_mode = 1;
	env->orig.kakko_mode = 1;
	env->orig.kigou_mode = 1;
	/* set language name */
	strncpy(env->orig.lang, lang, sizeof(env->orig.lang) - 1);
	env->orig.lang[sizeof(env->orig.lang) - 1] = 0;
	/* ؽư֤γʥǥե 50 */
	env->orig.autosave = 50;
	/* ͽ¬(ǥեȤϡֻѡס֥ꥢ륿) */
	env->orig.yosoku_use_mode = 1;
	env->orig.yosoku_realtime = 1;
	return (struct wnn_env *)env;
}


/* get language value from env */
char *
js_get_lang(env)
struct wnn_env *env;
{
	return(env->lang);
}

int
js_env_exist(server,env_name)
register char *env_name;
register WNN_JSERVER_ID *server;
{
	int x;

	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_head(JS_ENV_EXIST, server);
	putscom(env_name, server);
	snd_flush(server);
	x =get4com(server);

	return x;
}

int
js_env_sticky(env)
register struct wnn_env *env;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_ENV_STICKY);
	snd_flush(env->js_id);
	x = get4com(env->js_id);

	return x;
}

int
js_env_un_sticky(env)
register struct wnn_env *env;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_ENV_UN_STICKY);
	snd_flush(env->js_id);
	x = get4com(env->js_id);

	return x;
}

/**
	  env ǼĶ̵
**/
int
js_disconnect(env)
register struct wnn_env *env;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		free(env);
		return(-1);
	}
	snd_env_head(env,JS_DISCONNECT);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){ 
		env_wnn_errorno_set= get4com(env->js_id); 
	}
	free(env);
	return x;
}


/**	ФȥͥȤƤ뤫	**/
int
js_isconnect(env)
struct wnn_env *env;
{
	if (env && env->js_id)
		return(env->js_id->js_dead);
	return(-1);
}

/**
	  env  Ķ Ȥ̿Хåե flush 롣
**/
void
js_flush(env)
struct wnn_env *env;
{
}



/*	Parameter set/get	*/
/**	Ѵ parameter ꤹ롣	**/
/**	js_param_set  	**/
int
js_param_set(env,para)
struct wnn_env *env;
register struct wnn_param *para;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_PARAM_SET);
	JS_Put4Com(para->n, env->js_id);	/* ()ʸϤΣ */
	JS_Put4Com(para->nsho, env->js_id);	/* ʸξʸκ */
	JS_Put4Com(para->p1, env->js_id);	/* ٤Υѥ᡼ */
	JS_Put4Com(para->p2, env->js_id);	/* ʸĹΥѥ᡼ */
	JS_Put4Com(para->p3, env->js_id);	/* ĹΥѥ᡼ */
	JS_Put4Com(para->p4, env->js_id);	/* ȤäӥåȤΥѥ᡼ */
	JS_Put4Com(para->p5, env->js_id);	/* Υѥ᡼ */
	JS_Put4Com(para->p6, env->js_id);	/* ʸɾͤΥѥ᡼ */
	JS_Put4Com(para->p7, env->js_id);	/* ʸĹΥѥ᡼ */
	JS_Put4Com(para->p8, env->js_id);	/* ʸΥѥ᡼ */

	JS_Put4Com(para->p9, env->js_id);	/* ʻ  */
	JS_Put4Com(para->p10, env->js_id);	/* ʻ ʤ */
	/* CWNN ѿ */
	JS_Put4Com(para->p11, env->js_id);	/* ʻ ѿ */
	/* CWNN  */
	JS_Put4Com(para->p12, env->js_id);	/* ʻ  */
	/* CWNN ̤ */
	JS_Put4Com(para->p13, env->js_id);	/* ʻ ĳ̤ */
	/* CWNN ĳ̤ */
	JS_Put4Com(para->p14, env->js_id);	/* ʻ ° */
	/* BWNN No of koho */
	JS_Put4Com(para->p15, env->js_id);	/* ʻ ̤ */
	/* CWNN Not used */

	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);
		return -1;
	}
	return 0;
}

extern int js_get_autolearning_mode_core();

#define WNN_ENV_LOCAL_MASK \
	(WNN_ENV_KUTOUTEN_MASK|WNN_ENV_KAKKO_MASK|WNN_ENV_KIGOU_MASK|WNN_ENV_YOSOKU_USE_MASK|WNN_ENV_YOSOKU_REALTIME_MASK)

/*:::DOC_START
 *
 *    Function Name: js_set_henkan_env
 *    Description  : ѴĶꤹ
 *    Parameter    :
 *         env :       (In) ĶؤΥݥ
 *	   valuemask : (In) ͭͥӥåȥޥ
 *         henv :      (In) ѴĶι¤ΤؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_set_henkan_env(env,valuemask,henv)
struct wnn_env *env;
unsigned long valuemask;
register struct wnn_henkan_env *henv;
{
	register int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	if (valuemask & WNN_ENV_LOCAL_MASK){
		if (valuemask & WNN_ENV_KUTOUTEN_MASK)
			env->kutouten_mode = henv->kutouten_flag;
		if (valuemask & WNN_ENV_KAKKO_MASK)
			env->kakko_mode = henv->kakko_flag;
		if (valuemask & WNN_ENV_KIGOU_MASK)
			env->kigou_mode = henv->kigou_flag;
		if (valuemask & WNN_ENV_YOSOKU_USE_MASK)
			env->yosoku_use_mode = henv->yosoku_use_flag;
		if (valuemask & WNN_ENV_YOSOKU_REALTIME_MASK)
			env->yosoku_realtime = henv->yosoku_realtime_flag;
	}
	if (!(valuemask & ~WNN_ENV_LOCAL_MASK)) {

		return 0;
	}
	snd_env_head(env,JS_SET_HENKAN_ENV);
	JS_Put4Com(valuemask, env->js_id);	/* ӥåȥޥ */
	JS_Put4Com(henv->last_is_first_flag, env->js_id); /* ǽѺͥ */
	JS_Put4Com(henv->complex_flag, env->js_id);       /* ʣͥ */
	JS_Put4Com(henv->okuri_learn_flag, env->js_id);   /* ؽ */
	JS_Put4Com(henv->okuri_flag, env->js_id);         /*  */
	JS_Put4Com(henv->prefix_learn_flag, env->js_id);  /* Ƭؽ */
	JS_Put4Com(henv->prefix_flag, env->js_id);        /* Ƭ */
	JS_Put4Com(henv->suffix_learn_flag, env->js_id);  /* ؽ */
	JS_Put4Com(henv->common_learn_flag, env->js_id);  /* Ѹؽ */
	JS_Put4Com(henv->freq_func_flag, env->js_id);     /* پ徺Ψؿ */
	JS_Put4Com(henv->numeric_flag, env->js_id);       /* νɽˡ */
	JS_Put4Com(henv->alphabet_flag, env->js_id);      /* ե٥åȤνɽˡ */
	JS_Put4Com(henv->symbol_flag, env->js_id);        /* νɽˡ */
	JS_Put4Com(henv->yuragi_flag, env->js_id);	/* Ĺ餮 */
	JS_Put4Com(henv->rendaku_flag, env->js_id);	/* Ϣ */
	JS_Put4Com(henv->bunsetsugiri_flag, env->js_id);	/* ʸڤؽ⡼ */
	JS_Put4Com(henv->muhenkan_flag, env->js_id);	/* ̵Ѵؽ⡼ */
	JS_Put4Com(henv->fi_relation_learn_flag, env->js_id); /* ƣɴطؽ⡼ */
	JS_Put4Com(henv->fi_freq_func_flag, env->js_id);	/* ƣɴطپ徺Ψؿ */
	/* ͽ¬ɲʬ Jun. 1,2000 */
	JS_Put4Com(henv->yosoku_learn_flag, env->js_id); /* ͽ¬ؽ */
	JS_Put4Com(henv->yosoku_max_disp, env->js_id); /* ͽ¬ɽ */
	JS_Put4Com(henv->yosoku_last_is_first_flag, env->js_id); /* ͽ¬ǽͥ */
	/*  2000/07/21 NTWnnή */
	JS_Put4Com(henv->boin_kabusoku_flag, env->js_id); /* 첻β­ */
	JS_Put4Com(henv->shiin_choka_flag, env->js_id);   /* ҲĶ */
	JS_Put4Com(henv->n_choka_flag, env->js_id);    /* [N]Ķ */

	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);

		return -1;
	}
	if (valuemask & WNN_ENV_BUNSETSUGIRI_LEARN_MASK)
		env->bunsetsugiri_mode = henv->bunsetsugiri_flag;
	if (valuemask & WNN_ENV_MUHENKAN_LEARN_MASK)
		env->muhenkan_mode = henv->muhenkan_flag;

	return 0;
} /* End of js_set_henkan_env */

/*:::DOC_START
 *
 *    Function Name: js_set_henkan_hinsi
 *    Description  : ѴˡʻѡԻѡˤʻ췲ꤹ
 *    Parameter    :
 *         env :    (In) ĶؤΥݥ
 *	   mode :   (In) ⡼ɡ0 == , else 
 *	   nhinsi : (In) ʻ == Ի,  ѡ
 *         hlist :  (In) ʻꥹȤؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_set_henkan_hinsi(env,mode,nhinsi,hlist)
struct wnn_env *env;
int mode, nhinsi, *hlist;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_SET_HENKAN_HINSI);
	JS_Put4Com(mode, env->js_id);
	JS_Put4Com(nhinsi, env->js_id);
	for(x = 0; x < abs(nhinsi); x++) JS_Put4Com(hlist[x], env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);
		return -1;
	}
	return 0;
}

/**	js_param_get  	**/
/**	env ǼĶѴ parameter Ф	**/
int
js_param_get(env,para)
struct wnn_env *env;
register struct wnn_param *para;
{
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_PARAM_GET);
	snd_flush(env->js_id);
	if(get4com(env->js_id) == -1){
		env_wnn_errorno_set= get4com(env->js_id);

	}
	para->n=get4com(env->js_id);	/* ()ʸϤΣ */
	para->nsho=get4com(env->js_id);	/* ʸξʸκ */
	para->p1=get4com(env->js_id);	/* ٤Υѥ᡼ */
	para->p2=get4com(env->js_id);	/* ʸĹΥѥ᡼ */
	para->p3=get4com(env->js_id);	/* ĹΥѥ᡼ */
	para->p4=get4com(env->js_id);	/* ȤäӥåȤΥѥ᡼ */
	para->p5=get4com(env->js_id);	/* Υѥ᡼ */
	para->p6=get4com(env->js_id);	/* ʸɾͤΥѥ᡼ */
	para->p7=get4com(env->js_id);	/* ʸĹΥѥ᡼ */
	para->p8=get4com(env->js_id);	/* ʸΥѥ᡼ */
	para->p9=get4com(env->js_id);	/* ʻ  */
	para->p10=get4com(env->js_id);	/* ʻ ʤ */
	para->p11=get4com(env->js_id);	/* ʻ ѿ */
	para->p12=get4com(env->js_id);	/* ʻ  */
	para->p13=get4com(env->js_id);	/* ʻ ĳ̤ */
	para->p14=get4com(env->js_id);	/* ʻ ° */
	para->p15=get4com(env->js_id);	/* ʻ ̤ */

	return 0;
}

/*:::DOC_START
 *
 *    Function Name: js_get_henkan_env
 *    Description  : ѴĶ
 *    Parameter    :
 *         env :       (In) ĶؤΥݥ
 *         henv :      (Out) ѴĶι¤ΤؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_get_henkan_env(env,henv)
struct wnn_env *env;
register struct wnn_henkan_env *henv;
{
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_GET_HENKAN_ENV);
	snd_flush(env->js_id);
	if(get4com(env->js_id) == -1){
		env_wnn_errorno_set= get4com(env->js_id);

	}
	henv->last_is_first_flag=get4com(env->js_id);  /* ǽѺͥ */
	henv->complex_flag=get4com(env->js_id);        /* ʣͥ */
	henv->okuri_learn_flag=get4com(env->js_id);    /* ؽ */
	henv->okuri_flag=get4com(env->js_id);          /*  */
	henv->prefix_learn_flag=get4com(env->js_id);   /* Ƭؽ */
	henv->prefix_flag=get4com(env->js_id);         /* Ƭ */
	henv->suffix_learn_flag=get4com(env->js_id);   /* ؽ */
	henv->common_learn_flag=get4com(env->js_id);   /* Ѹؽ */
	henv->freq_func_flag=get4com(env->js_id);      /* پ徺Ψؿ */
	henv->numeric_flag=get4com(env->js_id);        /* νɽˡ */
	henv->alphabet_flag=get4com(env->js_id);       /* ե٥åȤνɽˡ */
	henv->symbol_flag=get4com(env->js_id);         /* νɽˡ */
	henv->yuragi_flag=get4com(env->js_id);		/* Ĺ餮 */
	henv->rendaku_flag=get4com(env->js_id);	/* Ϣ */
	henv->bunsetsugiri_flag=get4com(env->js_id);	/* ʸڤؽ⡼ */
	henv->muhenkan_flag=get4com(env->js_id);	/* ̵Ѵؽ⡼ */
	henv->fi_relation_learn_flag=get4com(env->js_id); /* ƣɴطؽ⡼ */
	henv->fi_freq_func_flag=get4com(env->js_id);	/* ƣɴطپ徺Ψؿ */
	/* ͽ¬ɲʬ S.Fuki Jun. 1, 2000 */
	henv->yosoku_learn_flag=get4com(env->js_id);/* ͽ¬ؽ */
	henv->yosoku_max_disp=get4com(env->js_id);/* ͽ¬ɽ */
	henv->yosoku_last_is_first_flag=get4com(env->js_id);/* ͽ¬ǽͥ */
	/*  2000/07/21 NTWnnή */
	henv->boin_kabusoku_flag=get4com(env->js_id);  /* 첻β­ */
	henv->shiin_choka_flag=get4com(env->js_id);    /* ҲĶ */
	henv->n_choka_flag=get4com(env->js_id);     /* [N]Ķ */

	env->bunsetsugiri_mode = henv->bunsetsugiri_flag;
	env->muhenkan_mode = henv->muhenkan_flag;

	henv->kutouten_flag = env->kutouten_mode;	/*  */
	henv->kakko_flag = env->kakko_mode;		/*  */
	henv->kigou_flag = env->kigou_mode;		/*  */
	henv->yosoku_use_flag = env->yosoku_use_mode;
	henv->yosoku_realtime_flag = env->yosoku_realtime;


	return 0;
} /* End of js_get_henkan_env */

/*:::DOC_START
 *
 *    Function Name: js_get_henkan_env_local
 *    Description  : ѴδĶ⡤饤֥ˤΤ
 *                   ̡
 *    Parameter    :
 *	   env :          (In) ĶؤΥݥ
 *	   henv :         (In) ѴĶι¤ΤؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *      ͽ¬Υѥ᡼ɲ
 *
 *:::DOC_END
 */
int
js_get_henkan_env_local(env,henv)
struct wnn_env *env;
register struct wnn_henkan_env *henv;
{
	if(env==0) return(-1);

	if(env_wnn_errorno_eql) {

		return(-1);
	}
	henv->kutouten_flag = env->kutouten_mode;	/*  */
	henv->kakko_flag = env->kakko_mode;		/*  */
	henv->kigou_flag = env->kigou_mode;		/*  */
	henv->yosoku_use_flag = env->yosoku_use_mode;
	henv->yosoku_realtime_flag = env->yosoku_realtime;

	return 0;
}

/*:::DOC_START
 *
 *    Function Name: js_get_henkan_hinsi
 *    Description  : ѴˡʻѡԻѡˤʻ췲
 *    Parameter    :
 *         env :    (In) ĶؤΥݥ
 *         nhinsi : (Out) ʻ == Ի,  ѡ
 *         hlist :  (Out) ʻꥹȤؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_get_henkan_hinsi(env,nhinsi,hlist)
struct wnn_env *env;
int *nhinsi, **hlist;
{
	int i;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_GET_HENKAN_HINSI);
	snd_flush(env->js_id);
	if(get4com(env->js_id) == -1){
		env_wnn_errorno_set= get4com(env->js_id);

	}
	*nhinsi = get4com(env->js_id);
	if(((*hlist) = (int *)malloc(abs(*nhinsi) * sizeof(int))) == NULL) {
		int dummy;
		for(i = 0; i < abs(*nhinsi); i++) dummy = get4com(env->js_id);
		env_wnn_errorno_set = WNN_ALLOC_FAIL;

	}
	for(i = 0; i < abs(*nhinsi); i++) (*hlist)[i] = get4com(env->js_id);

	return 0;
} /* End of js_get_henkan_hinsi */

/*
	global File Operation
*/
/**	js_mkdir	**/
int
js_mkdir(env,path)
struct wnn_env *env;
char *path;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_MKDIR);
	putscom(path, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

/**	js_access	**/
int
js_access(env,path,amode)
struct wnn_env *env;
char *path;
int amode;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_ACCESS);
	JS_Put4Com(amode, env->js_id);
	putscom(path, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);

	return x;
}

/**	js_file_list_all	**/
static int rcv_file_list();

int
js_file_list_all(server,ret)
WNN_JSERVER_ID *server;
struct wnn_ret_buf *ret;
{
	int x;

	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server,JS_FILE_LIST_ALL);
	snd_flush(server);
	x = rcv_file_list(ret, server);

	return x;
}

/**	js_file_list	**/
int
js_file_list(env,ret)
struct wnn_env *env;
struct wnn_ret_buf *ret;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FILE_LIST);
	snd_flush(env->js_id);
	x = rcv_file_list(ret, env->js_id);

	return x;
}

static void re_alloc();

static int
rcv_file_list(ret, server)
struct wnn_ret_buf *ret;
ARGS *server;
{
	register int i,count;
	WNN_FILE_INFO_STRUCT	*files;
	count=get4com(server);
	re_alloc(ret,sizeof(WNN_FILE_INFO_STRUCT)*count);
	files=(WNN_FILE_INFO_STRUCT *)ret->buf;
	for(i=0;i<count;i++){
		files->fid= get4com(server);
		files->localf= get4com(server);
		files->ref_count= get4com(server);
		files->type= get4com(server);
		getscom(files->name, server, WNN_F_NAMELEN);
		files++;
	}
	return count;
}

/**	js_file_stat	**/
int
js_file_stat(env,path, s)
struct wnn_env *env;
char *path;
WNN_FILE_STAT *s;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FILE_STAT);
	putscom(path, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);

	s->type = x;
	return x;
}


/**	js_file_info	**/
int
js_file_info(env,fid,file)
struct wnn_env *env;
int fid;
register WNN_FILE_INFO_STRUCT *file;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FILE_INFO);
	JS_Put4Com(fid, env->js_id);
	snd_flush(env->js_id);
	file->fid= fid;
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);

		return(-1);
	}
	getscom(file->name, env->js_id, WNN_F_NAMELEN);
	file->localf= get4com(env->js_id);
	file->ref_count= get4com(env->js_id);
	file->type= get4com(env->js_id);

	return 0;
}

/**	js_file_loaded	**/
int
js_file_loaded(server,path)
WNN_JSERVER_ID *server;
char *path;
{
	register int x;
	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server,JS_FILE_LOADED);
	putscom(path, server);
	snd_flush(server);
	x=get4com(server);

	return x;
}

/**	js_file_loaded_local	**/
static int check_local_file();
static int file_loaded_local();

static int
js_file_loaded_local_body(server,path)
WNN_JSERVER_ID *server;
char *path;
{
	int x;

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {
		return(-1);
	}
	if(check_local_file(path, server) == -1) return (-1);
	snd_server_head(server, JS_FILE_LOADED_LOCAL);
	x=file_loaded_local(path, server);
	return x;
}

int
js_file_loaded_local(server,path)
WNN_JSERVER_ID *server;
char *path;
{
	int x;
	set_current_js(server);

	x = js_file_loaded_local_body(server,path);

	return x;
}

static int
check_local_file(path, server)
char *path;
ARGS *server;
{
	register FILE *f;
	register int x;
	struct wnn_file_head fh;

#ifdef WRITE_CHECK
	check_backup(path);
#endif /* WRITE_CHECK */
	f=dic_fopen(path,"r");
	if(f == NULL){
		js_wnn_errorno_set = WNN_OPENF_ERR;
		return -1;
	}
	x=input_file_header(f, &fh);
	if(x==-1){
		dic_fclose(f);
		js_wnn_errorno_set = WNN_NOT_A_FILE;
		return -1;
	}

#ifdef WNN_CHECK_INODE
	if(dic_check_inode(f, &fh) == -1){
		change_file_uniq(&fh, path);
#ifdef WRITE_CHECK
		dic_fclose(f);
		f=dic_fopen(path,"r");
		if(f == NULL){
			js_wnn_errorno_set = WNN_OPENF_ERR;
			return (-1);
		}
#endif /* WRITE_CHECK */
		if(dic_check_inode(f, &fh) == -1){
			dic_fclose(f);
			js_wnn_errorno_set = WNN_INODE_CHECK_ERROR;
			return (-1);
		}
	}
#endif /* WNN_CHECK_INODE */

	dic_fclose(f);
	return 0;
}


static int
file_loaded_local(path, server)
char *path;
ARGS *server;
{
	register int x,i;
	FILE *f;
	struct wnn_file_head fh;

#ifdef WRITE_CHECK
	check_backup(path);
#endif /* WRITE_CHECK */
	f=dic_fopen(path,"r");
	if(f == NULL){
		js_wnn_errorno_set = WNN_OPENF_ERR;
		return -1;
	}
	x=input_file_header(f, &fh);
	if(x==-1){
		dic_fclose(f);
		js_wnn_errorno_set = WNN_NOT_A_FILE;
		return -1;
	}
	JS_Put4Com(fh.file_uniq.time, server);
	JS_Put4Com(fh.file_uniq.dev, server);
	JS_Put4Com(fh.file_uniq.inode, server);
	for(i=0;i<WNN_HOSTLEN;i++){
		JS_Put1Com(fh.file_uniq.createhost[i], server);
	}

	snd_flush(server);
	x=get4com(server);
	dic_fclose(f);
	return x;
}

/**	js_hindo_file_create	**/
int
js_hindo_file_create(env,fid,fn,comment,hpasswd)
struct wnn_env *env;
int	fid;
char *fn;
w_char *comment;
char *hpasswd;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_HINDO_FILE_CREATE);
	JS_Put4Com(fid, env->js_id);
	putscom(fn, env->js_id);
	putwscom(comment, env->js_id);
	putscom(hpasswd, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

/*:::DOC_START
 *
 *    Function Name: js_fi_hindo_file_create
 *    Description  : ¦ˣƣɴط٥ե
 *    Parameter    :
 *         env :     (In) ĶؤΥݥ
 *	   fid :     (In) бƣɴطեɣ
 *	   fn :      (In) ƣɴط٥ե̾
 *	   comment : (In) ƣɴط٥ե륳
 * 	   hpasswd : (In) ƣɴط٥եѥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_fi_hindo_file_create(env, fid, fn, comment, hpasswd)
struct wnn_env *env;
int     fid;
char *fn;
w_char *comment;
char *hpasswd;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FI_HINDO_FILE_CREATE);
	JS_Put4Com(fid, env->js_id);
	putscom(fn, env->js_id);
	putwscom(comment, env->js_id);
	putscom(hpasswd, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
} /* End of js_fi_hindo_file_create */

/*:::DOC_START
 *
 *    Function Name: js_dic_file_create
 *    Description  : ¦˼ե
 *    Parameter    :
 *         env :     (In) ĶؤΥݥ
 *         fn :      (In) ե̾
 *         type :    (In) ե륿
 *         comment : (In) ե륳
 *         passwd    (In) եѥ
 *         hpasswd : (In) ٥ѥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_dic_file_create(env, fn, type, comment, passwd, hpasswd)
struct wnn_env *env;
char *fn;
w_char *comment;
char *passwd, *hpasswd;
int type;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_DIC_FILE_CREATE);
	putscom(fn, env->js_id);
	putwscom(comment, env->js_id);
	putscom(passwd, env->js_id);
	putscom(hpasswd, env->js_id);
	JS_Put4Com(type, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
} /* End of js_dic_file_create */


/**	js_file_discard	**/
int
js_file_discard(env,fid)
struct wnn_env *env;
int	fid;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FILE_DISCARD);
	JS_Put4Com(fid, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

/**	js_file_read	**/
int
js_file_read(env,fn)
struct wnn_env *env;
char	*fn;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FILE_READ);
	putscom(fn, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

/**	js_file_write	**/
int
js_file_write(env,fid,fn)
struct wnn_env *env;
int	fid;
char	*fn;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FILE_WRITE);
	JS_Put4Com(fid, env->js_id);
	putscom(fn, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

/**	js_file_receive	**/
static int xget1com();
static void xput1com();

int
js_file_receive(env,fid,fn)
struct wnn_env *env;
int	fid;
char	*fn;
{
	register int mode, x;
	char file_name[MAXPATHLEN];
	char buf[MAXHOSTNAMELEN + 1]; /* 1=C_LOCAL */
	FILE *f;
	int n;
	struct wnn_file_head fh;
	int i;
#ifdef WRITE_CHECK
	char *tmp = NULL, *backup = NULL, tmp_x;
	int tmp_err = 0;
#endif /* WRITE_CHECK */

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql)
		return(-1);

	snd_env_head(env,JS_FILE_RECEIVE);
	JS_Put4Com(fid, env->js_id);
	snd_flush(env->js_id);
	getscom(file_name, env->js_id, sizeof(file_name));
	if(fn ==NULL || strcmp(fn,"")==0){
		gethostname(buf, sizeof(buf) - 1 - 1); /* 1=C_LOCAL, 1=NULL */
		buf[sizeof(buf) - 1 - 1] = '\0';
		n = strlen(buf);
		buf[n] = C_LOCAL;
		buf[n+1] = 0;
		if(strncmp(buf, file_name, n + 1) == 0)
			fn = file_name + n + 1;
	}
#ifdef WRITE_CHECK
	check_backup(fn);
#endif /* WRITE_CHECK */
	if((f = dic_fopen(fn, "r")) == NULL){ /* New File */
		fh.file_uniq.time = fh.file_uniq.dev = fh.file_uniq.inode = 0;
	} else{			/* Old File Exists */
		if(input_file_header(f, &fh) == -1){
			env_wnn_errorno_set=WNN_NOT_A_FILE;
			dic_fclose(f);
			JS_Put4Com(-1, env->js_id);
			snd_flush(env->js_id);
			return(-1);
		}
		dic_fclose(f);
	}
	JS_Put4Com(0, env->js_id);                    /* Ack */
	JS_Put4Com(fh.file_uniq.time, env->js_id);
	JS_Put4Com(fh.file_uniq.dev, env->js_id);
	JS_Put4Com(fh.file_uniq.inode, env->js_id);
	for(i=0;i<WNN_HOSTLEN;i++){
		JS_Put1Com(fh.file_uniq.createhost[i], env->js_id);
	}

	snd_flush(env->js_id);

	if((mode=get4com(env->js_id))==-1){ /* check stat */
		env_wnn_errorno_set= get4com(env->js_id);
		return -1;
	}
	if(mode==WNN_NEED_WRITE_NO){
		return 0; /* need not saving */
	}
	if(mode == WNN_NEED_WRITE_ALL || mode == WNN_NEED_WRITE_NOTREAD){
#ifdef WRITE_CHECK
		backup = make_backup_file(fn);
		if ((tmp = make_tmp_file(fn, 0, &f)) == NULL) {
			delete_tmp_file(backup);
			env_wnn_errorno_set=WNN_FILE_WRITE_ERROR;
			JS_Put4Com(-1, env->js_id);
			snd_flush(env->js_id);
			return(-1);
		}
#else /* WRITE_CHECK */
		if((f = fopen(fn, "w+")) == NULL){
			env_wnn_errorno_set=WNN_FILE_WRITE_ERROR;
			JS_Put4Com(-1, env->js_id);
			snd_flush(env->js_id);
			return(-1);
		}
#endif /* WRITE_CHECK */
	} else if(mode == WNN_NEED_WRITE_HINDO){
#ifdef WRITE_CHECK
		backup = make_backup_file(fn);
		if ((tmp = make_tmp_file(fn, 1, &f)) == NULL) {
			delete_tmp_file(backup);
			env_wnn_errorno_set=WNN_FILE_WRITE_ERROR;
			JS_Put4Com(-1, env->js_id);
			snd_flush(env->js_id);
			return(-1);
		}
#else /* WRITE_CHECK */
		if((f = fopen(fn, "r+")) == NULL){ /* New File */
			env_wnn_errorno_set=WNN_FILE_WRITE_ERROR;
			JS_Put4Com(-1, env->js_id);
			snd_flush(env->js_id);
			return(-1);
		}
#endif /* WRITE_CHECK */
	}
	JS_Put4Com(0, env->js_id); 
	snd_flush(env->js_id); /* ACK */
	for(;;){
		if((x=xget1com(env->js_id))== -1) break; /* EOF */
#ifdef WRITE_CHECK
		tmp_x = (char)x;
		if (fwrite(&tmp_x, sizeof(char), 1, f) == -1) tmp_err = 1;
#else /* WRITE_CHECK */
		fputc(x,f);
#endif /* WRITE_CHECK */
	}
#ifdef WRITE_CHECK
	if (tmp_err == 0) {
		rewind(f);
		x = input_file_header(f, &fh);
		fclose(f);
		write_file_move_tmp_to_org(tmp, fn,
			fh.file_type, fh.file_passwd, &(fh.file_uniq_org));
	} else {
		fclose(f);
		delete_tmp_file(tmp);
	}
	delete_tmp_file(backup);
#else 
#ifndef WNN_CHECK_INODE
    rewind(f);
	if (input_file_header(f, &fh) != -1) {
		change_file_uniq1(f,
			fh.file_type, fh.file_passwd, &(fh.file_uniq_org));
	}
#endif 
	fclose(f);
#endif /* WRITE_CHECK */

	x=get4com(env->js_id);
	if(x==-1) env_wnn_errorno_set= get4com(env->js_id);
#ifdef WRITE_CHECK
	if (tmp_err) {
		env_wnn_errorno_set = WNN_FILE_WRITE_ERROR;
		return(-1);
	}
#endif /* WRITE_CHECK */

	return x;
}

static int
xget1com(server)
ARGS *server;
{
	register int x;
	if((x= get1com(server)) != 0xFF) return x;
	if(get1com(server) == 0xFF) return -1; /* EOF */
	return 0xFF;
}

/**	js_file_send	**/
int
js_file_send(env,fn)
struct wnn_env *env;
char	*fn;
{
	register int x;
	FILE *f;
	int n;
	char buf[MAXHOSTNAMELEN + 1 + MAXPATHLEN]; /* 1=C_LOCAL */
	char *b;
	register int cc,i;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	if(check_local_file(fn, env->js_id) == -1) {

		return (-1);
	}
	snd_env_head(env,JS_FILE_SEND);
	x=file_loaded_local(fn, env->js_id);
	if(x!= -1){ /* file is already loaded */
		if(get4com(env->js_id) == -1) {
			env_wnn_errorno_set= get4com(env->js_id);

			return(-1);
		}
		return x;

	}

	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);

		return -1;
	}

	gethostname(buf, sizeof(buf) - 1 - 1); /* 1=C_LOCAL, 1=NULL */
	buf[sizeof(buf) - 1 - 1] = '\0';
	n = strlen(buf);
	buf[n] = C_LOCAL;
	strncpy(buf + n + 1, fn, sizeof(buf) - n - 1);
	buf[sizeof(buf) - 1] = '\0';
	putscom(buf, env->js_id);

#ifdef WRITE_CHECK
	check_backup(fn);
#endif /* WRITE_CHECK */
	if((f=dic_fopen(fn,"r"))== NULL){
		xput1com(-1, env->js_id); /* EOF */

		return -1;
	}

	/* send contents of file */
	for(;;){
		cc = fread(buf,1,sizeof(buf),f);
		if(cc <= 0) break; /* EOF */
		for(b=buf,i=0;i<cc;i++){
			xput1com((int)*b++ & 0xff, env->js_id);
		}
	}
	dic_fclose(f);
	xput1com(-1, env->js_id); /* EOF */
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1) env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

static void
xput1com(d, server)
int d;
ARGS *server;
{
	if(d == -1){ 
		JS_Put1Com(0xFF, server); 
		JS_Put1Com(0xFF, server); 
		return;/* EOF */
	}
	JS_Put1Com(d, server);
	if(d == 0xFF){ 
		JS_Put1Com(0x00, server);
	}
}


/***	Dic. Operation for Env.	 ***/

/**	js_dic_add	**/
static int
js_dic_add_body(env,fid,hfid,rev, jnice,rw,hrw, pw1, pw2)
struct wnn_env *env;
int	fid,hfid,rev,jnice,rw,hrw;
char *pw1, *pw2;
{
	register int x;
	snd_env_head(env,JS_DIC_ADD);
	JS_Put4Com(fid, env->js_id);
	JS_Put4Com(hfid, env->js_id);
	JS_Put4Com(jnice, env->js_id);
	JS_Put4Com(rw, env->js_id);
	JS_Put4Com(hrw, env->js_id);
	putscom(pw1, env->js_id);
	putscom(pw2, env->js_id);
	JS_Put4Com(rev, env->js_id);		/* rev is to add it as reverse dict */
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);
	return x;
}
int
js_dic_add(env,fid,hfid,rev, jnice,rw,hrw, pw1, pw2)
struct wnn_env *env;
int	fid,hfid,rev,jnice,rw,hrw;
char *pw1, *pw2;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	x = js_dic_add_body(env,fid,hfid,rev, jnice,rw,hrw, pw1, pw2);

	return x;
}

/*:::DOC_START
 *
 *    Function Name: js_fi_dic_add_body
 *    Description  : js_fi_dic_add Υ֥롼ؿ
 *    Parameter    :
 *         env :    (In) ĶؤΥݥ
 *	   fid :    (In) ƣɴطեɣ
 *	   hfid :   (In) ƣɴط٥եɣ
 * 	   suflag : (In) ƥ༭桼
 * 	   rw :     (In) 񹹿ǽԲǽ
 *	   hrw :    (In) ٹǽԲǽ
 *	   pw1 :    (In) ƣɴطեΥѥ
 *	   pw2 :    (In) ƣɴط٥եΥѥ
 *
 *    Return value : -1==ERROR, else Ͽֹ
 *
 *    Revision history:
 *
 *:::DOC_END
 */
static int
js_fi_dic_add_body(env, fid, hfid, suflag, rw, hrw, pw1, pw2)
struct wnn_env *env;
int     fid,hfid,suflag,rw,hrw;
char *pw1, *pw2;
{
	register int x;
	snd_env_head(env,JS_FI_DIC_ADD);
	JS_Put4Com(fid, env->js_id);
	JS_Put4Com(hfid, env->js_id);
	JS_Put4Com(suflag, env->js_id);
	JS_Put4Com(rw, env->js_id);
	JS_Put4Com(hrw, env->js_id);
	putscom(pw1, env->js_id);
	putscom(pw2, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);
	return x;
} /* End of js_fi_dic_add_body */

/*:::DOC_START
 *
 *    Function Name: js_fi_dic_add
 *    Description  : Ķˣƣɼɲä
 *    Parameter    :
 *         env :    (In) ĶؤΥݥ
 *	   fid :    (In) ƣɴطեɣ
 *	   hfid :   (In) ƣɴط٥եɣ
 * 	   suflag : (In) ƥ༭桼
 * 	   rw :     (In) 񹹿ǽԲǽ
 *	   hrw :    (In) ٹǽԲǽ
 *	   pw1 :    (In) ƣɴطեΥѥ
 *	   pw2 :    (In) ƣɴط٥եΥѥ
 *
 *    Return value : -1==ERROR, else Ͽֹ
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_fi_dic_add(env, fid, hfid, suflag, rw, hrw, pw1, pw2)
struct wnn_env *env;
int     fid,hfid,suflag,rw,hrw;
char *pw1, *pw2;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	/* call sub routine function */
	x = js_fi_dic_add_body(env, fid, hfid, suflag, rw, hrw, pw1, pw2);

	return x;
} /* End of js_fi_dic_add */

/**	js_dic_delete	**/
int
js_dic_delete(env,dicno)
struct wnn_env *env;
int	dicno;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_DIC_DELETE);
	JS_Put4Com(dicno, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

/**	js_dic_use	**/
int
js_dic_use(env,dic_no,flag)
struct wnn_env *env;
int	dic_no,flag;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_DIC_USE);
	JS_Put4Com(dic_no, env->js_id);
	JS_Put4Com(flag, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

/**	js_fuzokugo_set	**/
int
js_fuzokugo_set(env,fid)
struct wnn_env *env;
int	fid;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FUZOKUGO_SET);
	JS_Put4Com(fid, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

/**	js_fuzokugo_get	**/
int
js_fuzokugo_get(env)
struct wnn_env *env;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FUZOKUGO_GET);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

static int rcv_dic_list();
static void get_dic_info();

/*:::DOC_START
 *
 *    Function Name: js_dic_list_all
 *    Description  : ꤵ줿ФĶϿƤף
 *		     ֤
 *    Parameter    :
 *         server : (In) ФؤΥݥ
 *	   ret :    (Out) ǡѹ¤ΤؤΥݥ
 *
 *    Return value : -1==ERROR, else Ͽ
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_dic_list_all(server,ret)
WNN_JSERVER_ID *server;
struct wnn_ret_buf *ret;
{
	int x;

	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server,JS_DIC_LIST_ALL);
	snd_flush(server);
	x = rcv_dic_list(ret, server);

	return x;
} /* End of js_dic_list_all */

/*:::DOC_START
 *
 *    Function Name: js_dic_list
 *    Description  : ꤵ줿ĶϿƤףξ֤
 *    Parameter    :
 *         env : (In) ĶؤΥݥ
 *         ret : (Out) ǡѹ¤ΤؤΥݥ
 *
 *    Return value : -1==ERROR, else Ͽ
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_dic_list(env,ret)
struct wnn_env *env;
struct wnn_ret_buf *ret;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_DIC_LIST);
	snd_flush(env->js_id);
	x = rcv_dic_list(ret, env->js_id);

	return x;
} /* End of js_dic_list */

/*:::DOC_START
 *
 *    Function Name: js_fi_dic_list_all
 *    Description  : ꤵ줿ФĶϿƤ뼭⡢
 *                   ꤵ줿񷲤ξ֤
 *    Parameter    :
 *         server : (In) ФؤΥݥ
 *	   dmask :  (In) ޥ
 *         ret :    (Out) ǡѹ¤ΤؤΥݥ
 *
 *    Return value : -1==ERROR, else Ͽ
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_fi_dic_list_all(server, dmask, ret)
WNN_JSERVER_ID *server;
unsigned long dmask;
struct wnn_ret_buf *ret;
{
	int x;

	set_current_js(server);

	/* Ф FI-Wnn ΥСʤ顢 dic_list ̿ */
	if(!CHECK_FI) return(js_dic_list_all(server, ret));


	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server,JS_FI_DIC_LIST_ALL);
	JS_Put4Com(dmask, server);
	snd_flush(server);
	x = rcv_dic_list(ret, server);

	return x;
} /* End of js_fi_dic_list_all */

/*:::DOC_START
 *
 *    Function Name: js_fi_dic_list
 *    Description  : ꤵ줿ĶϿƤ뼭⡢
 *		     ꤵ줿񷲤ξ֤
 *    Parameter    :
 *         env :   (In) ĶؤΥݥ
 *	   dmask : (In) ޥ
 *         ret :   (Out) ǡѹ¤ΤؤΥݥ
 *
 *    Return value : -1==ERROR, else Ͽ
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_fi_dic_list(env, dmask, ret)
struct wnn_env *env;
unsigned long dmask;
struct wnn_ret_buf *ret;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	/* Ф FI-Wnn ΥСʤ顢 dic_list ̿ */
	if(!CHECK_FI) return(js_dic_list(env, ret));


	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FI_DIC_LIST);
	JS_Put4Com(dmask, env->js_id);
	snd_flush(env->js_id);
	x = rcv_dic_list(ret, env->js_id);

	return x;
} /* End of js_fi_dic_list */

/*:::DOC_START
 *
 *    Function Name: rcv_dic_list
 *    Description  : ѹ¤Τΰݤ
 *    Parameter    :
 *         ret :    (Out) ǡѹ¤ΤؤΥݥ
 *	   server : (In) ФؤΥݥ
 *
 *    Return value : -1==ERROR, else Ͽ
 *
 *    Revision history:
 *
 *:::DOC_END
 */
static int
rcv_dic_list(ret, server)
struct wnn_ret_buf *ret;
ARGS *server;
{
	register int i,count;
	register WNN_DIC_INFO *dic;
	if((count=get4com(server)) == -1) {
		js_wnn_errorno_set = get4com(server);
		return(-1);
	}
	re_alloc(ret, sizeof(WNN_DIC_INFO)*(count + 1));

	dic=(WNN_DIC_INFO *)ret->buf;
	for(i=0;i<count;i++){
		get_dic_info(dic, server);
		dic++;
	}
	dic->dic_no = -1;
	return count;
} /* End of rcv_dic_list */

/*:::DOC_START
 *
 *    Function Name: get_dic_info
 *    Description  : 򥵡Ф
 *    Parameter    :
 *         dic :    (Out) ѹ¤ΤؤΥݥ
 *         server : (In) ФؤΥݥ
 *
 *    Return value : -1==ERROR, else Ͽ
 *
 *    Revision history:
 *
 *:::DOC_END
 */
static void
get_dic_info(dic, server)
register WNN_DIC_INFO *dic;
ARGS *server;
{
	dic->dic_no =get4com(server);	/* dic_No */
	dic->body =get4com(server);	/* body fid */
	dic->hindo =get4com(server);	/* hindo fid */
	dic->rw =get4com(server);	/* r/w */
	dic->hindo_rw =get4com(server);	/* hindo r/w */
	dic->enablef =get4com(server);	/* enable/disable */
	dic->nice =get4com(server);	/* nice */
	dic->rev = get4com(server);
	/* added H.T */
	getwscom(dic->comment, server, WNN_COMMENT_LEN);
	getscom(dic->fname, server, WNN_F_NAMELEN);
	getscom(dic->hfname, server, WNN_F_NAMELEN);
	getscom(dic->passwd, server, WNN_PASSWD_LEN);
	getscom(dic->hpasswd, server, WNN_PASSWD_LEN);
	dic->type = get4com(server);
	dic->gosuu = get4com(server);
	dic->localf = get4com(server);
	dic->hlocalf = get4com(server);
} /* End of get_dic_info */

/*:::DOC_START
 *
 *    Function Name: rcv_fzk_list
 *    Description  : °ѹ¤Τΰݤ
 *		     Ф
 *    Parameter    :
 *         curfzk : (Out) ߻ѥե뼱̻
 *         ret :    (Out) °ѹ¤ΤؤΥݥ
 *         server : (In) ФؤΥݥ
 *
 *    Return value : -1==ERROR, else ɹ°
 *
 *    Revision history:
 *
 *:::DOC_END
 */
static int
rcv_fzk_list(curfzk, ret, server)
int *curfzk;
WNN_FZK_INFO **ret;
ARGS *server;
{
	register int i, count;
	register WNN_FZK_INFO *fzk;

	/* ɹ°߻ѥե뼱̻Ҥ */
	if((count = get4com(server)) == -1) {
		js_wnn_errorno_set = get4com(server);
		return(-1);
	}
	*curfzk = get4com(server);

	/* ѹ¤Τΰݤ */
	if(((*ret) = (WNN_FZK_INFO *)malloc((count + 1) *
	    sizeof(WNN_FZK_INFO))) == NULL) {
		WNN_FZK_INFO dummy;
		for(i = 0; i < count; i++){
			getwscom(dummy.comment, server, WNN_COMMENT_LEN);
			getscom(dummy.fname, server, WNN_F_NAMELEN);
		}
		js_wnn_errorno_set = WNN_ALLOC_FAIL;
		return(-1);
	}
	fzk = (WNN_FZK_INFO *)*ret;

	/* ° */
	for(i = 0; i < count; i++){
		getwscom(fzk->comment, server, WNN_COMMENT_LEN);
		getscom(fzk->fname, server, WNN_F_NAMELEN);
		fzk++;
	}

	fzk->fname[0] = 0;
	return count;
} /* End of rcv_fzk_list */

/*:::DOC_START
 *
 *    Function Name: js_fuzokugo_list
 *    Description  : ꤵ줿Фɤ߹ޤƤ°
 *                   Ķ˸ꤵƤμ̻Ҥ֤
 *    Parameter    :
 *         env :    (In) ĶؤΥݥ
 *         curfzk : (Out) ߻ѥե뼱̻
 *         ret :    (Out) °ѹ¤ΤؤΥݥ
 *
 *    Return value : -1==ERROR, else ɹ°
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_fuzokugo_list(env, curfzk, ret)
struct wnn_env *env;
int *curfzk;
WNN_FZK_INFO **ret;
{
	register int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FUZOKUGO_LIST);
	snd_flush(env->js_id);
	x = rcv_fzk_list(curfzk, ret, env->js_id);

	return x;
} /* End of js_fuzokugo_list */

/***	Dic. Operation by dic_No.	***/

/**	js_word_add		**/
int
js_word_add(env,dic_no,yomi,kanji,comment,hinshi,init_hindo)
struct wnn_env *env;
int	dic_no;
w_char	*yomi,*kanji,*comment;
int	hinshi,init_hindo;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_WORD_ADD);
	JS_Put4Com(dic_no, env->js_id);
	putwscom(yomi, env->js_id);
	putwscom(kanji, env->js_id);
	putwscom(comment, env->js_id);
	JS_Put4Com(hinshi, env->js_id);
	JS_Put4Com(init_hindo, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}

/**	js_word_delete		**/
int
js_word_delete(env,dic_no,entry)
struct wnn_env *env;
int	dic_no;
int	entry;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_WORD_DELETE);
	JS_Put4Com(dic_no, env->js_id);
	JS_Put4Com(entry, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1)env_wnn_errorno_set= get4com(env->js_id);

	return x;
}


/**	js_word_search		**/
static int rcv_word_data();

int
js_word_search(env,dic_no,yomi,ret)
struct wnn_env *env;
int	dic_no;
w_char	*yomi;
struct wnn_ret_buf *ret;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_WORD_SEARCH);
	JS_Put4Com(dic_no, env->js_id);
	putwscom(yomi, env->js_id);
	snd_flush(env->js_id);
	x = rcv_word_data(ret, yomi, env->js_id);

	return x;
}

/**	js_word_search_by_env	**/
int
js_word_search_by_env(env,yomi,ret)
struct wnn_env *env;
w_char	*yomi;
struct wnn_ret_buf *ret;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_WORD_SEARCH_BY_ENV);
	putwscom(yomi, env->js_id);
	snd_flush(env->js_id);
	x = rcv_word_data(ret, yomi, env->js_id);

	return x;
}

/**	js_word_info		**/
int
js_word_info(env,dic_no,entry,ret)
struct wnn_env *env;
int	dic_no,entry;
struct wnn_ret_buf *ret;
{
	register int x;
	w_char yomi[LENGTHYOMI];

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_WORD_INFO);
	JS_Put4Com(dic_no, env->js_id);
	JS_Put4Com(entry, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);

		return(-1);
	}
	getwscom(yomi, env->js_id, sizeof(yomi) / sizeof(w_char));
	rcv_word_data(ret, yomi, env->js_id);

	return(0);
}

int
js_word_comment_set(env, dic_no, entry, comment)
struct wnn_env *env;
int	dic_no,entry;
w_char *comment;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_WORD_COMMENT_SET);
	JS_Put4Com(dic_no, env->js_id);
	JS_Put4Com(entry, env->js_id);
	putwscom(comment, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);

		return(-1);
	}

	return(0);
}

/**	rcv for word_search		**/
static int
rcv_word_data(ret, yomi, server)
struct wnn_ret_buf *ret;
w_char *yomi;			/* Yomi is not sent from server
				 *  (at least for the time being).
				 */
ARGS *server;
{
	register int x, j_c,k_c, databytes, wlen;
	w_char *k;
	w_char wbuf[LENGTHKANJI];
	register struct wnn_jdata *jd;
	register int cnt, error_flag;

	j_c = get4com(server);
	k_c = get4com(server);
	databytes = sizeof(w_char)*(k_c + j_c * 3 + j_c * wnn_Strlen(yomi));
	re_alloc(ret, sizeof(struct wnn_jdata)*(j_c + 1) + databytes);
	jd=(struct wnn_jdata *)ret->buf;
	for(cnt = 0;;cnt++){
		jd->dic_no = x = get4com(server);
		if(x==-1) break;
		jd->serial  = get4com(server);
		jd->hinshi = get4com(server);
		jd->hindo = get4com(server);  
		jd->ima = get4com(server);
		jd->int_hindo = get4com(server); 
		jd->int_ima = get4com(server);
		jd++;
	}
	jd++;
	k= (w_char *)jd;
	jd=(struct wnn_jdata *)ret->buf;
	error_flag = 0;
	for(;;){
		if(jd->dic_no==-1) break;

		if (!error_flag) {
			wlen = wnn_Strlen(yomi) + 1;
			if ((wlen * sizeof(w_char)) > databytes) {
				error_flag = 1;
			} else {
				jd->yomi = k;           /* Copy Yomi */
				wnn_Strcpy(k, yomi);
				k+= wlen;
				databytes -= (wlen * sizeof(w_char));
			}
		}

		getwscom(wbuf, server, sizeof(wbuf) / sizeof(w_char));
		if (!error_flag) {
			wlen = wnn_Strlen(wbuf) + 1;
			if ((wlen * sizeof(w_char)) > databytes) {
				error_flag = 1;
			} else {
				jd->kanji = k;          /* Get Kanji */
				wnn_Strcpy(k, wbuf);
				k+= wlen;
				databytes -= (wlen * sizeof(w_char));
			}
		}

		getwscom(wbuf, server, sizeof(wbuf) / sizeof(w_char));
		if (!error_flag) {
			wlen = wnn_Strlen(wbuf) + 1;
			if ((wlen * sizeof(w_char)) > databytes) {
				error_flag = 1;
			} else {
				jd->com = k;            /* Get Comment */
				wnn_Strcpy(k, wbuf);
				k+= wlen;
				databytes -= (wlen * sizeof(w_char));
			}
		}
		jd++;
	}
	return cnt;
}


/**	js_dic_info	**/
int
js_dic_info(env,dic_no,ret)
struct wnn_env *env;
int	dic_no;
register WNN_DIC_INFO *ret;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_DIC_INFO);
	JS_Put4Com(dic_no, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set = get4com(env->js_id);

		return x;
	}
	get_dic_info(ret, env->js_id);

	return dic_no;
}

/**	js_who		**/
int
js_who(server,ret)
WNN_JSERVER_ID *server;
struct wnn_ret_buf *ret;
{
	register int i,j,c;
	WNN_JWHO *w;
	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server,JS_WHO);
	snd_flush(server);

	c=get4com(server);
	if(c==-1){
		js_wnn_errorno_set= get4com(server);

		return -1;
	}

	re_alloc(ret, sizeof(WNN_JWHO)*c);
	w=(WNN_JWHO *)ret->buf;
	for(i=0;i<c;i++){
		w->sd=get4com(server);
		getscom(w->user_name, server, sizeof(w->user_name));
		getscom(w->host_name, server, sizeof(w->host_name));
		for(j=0;j<WNN_MAX_ENV_OF_A_CLIENT;j++){
			(w->env)[j]=get4com(server);
		}
		w++;
	}

	return(c);
}

/**	jserver ƤδĶ˴ؤ롣
	(鵻)
**/
int
js_env_list(server,ret)
WNN_JSERVER_ID *server;
struct wnn_ret_buf *ret;
{
	register int i,j,c;
	WNN_ENV_INFO *w;
	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server,JS_ENV_LIST);
	snd_flush(server);

	c=get4com(server);
	if(c==-1){
		js_wnn_errorno_set= get4com(server);

		return -1;
	}

	re_alloc(ret, sizeof(WNN_ENV_INFO)*c);
	w=(WNN_ENV_INFO *)ret->buf;
	for(i=0;i<c;i++){
		w->env_id = get4com(server);
		getscom(w->env_name, server, WNN_ENVNAME_LEN);
		w->ref_count=get4com(server);
		w->fzk_fid=get4com(server);
		w->jishomax=get4com(server);
		for(j=0;j<WNN_MAX_JISHO_OF_AN_ENV;j++){
			(w->jisho)[j]= get4com(server);
		}
		for(j=0;j<WNN_MAX_FILE_OF_AN_ENV;j++){
			(w->file)[j]= get4com(server);
		}
		w++;
	}

	return(c);
}

/****

****/
/*:::DOC_START
 *
 *    Function Name: js_hindo_set
 *    Description  : ꤵ줿κӥåȡ٤ꤹ
 *    Parameter    :
 *         env :   (In) ĶؤΥݥ
 *	   dic :   (In) 䤬ϿƤ뼭ֹ
 *	   entry : (In) Υȥֹ
 *	   ima :   (In) ӥåȤˡե饰
 *	   hindo : (In) ٤ˡե饰
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_hindo_set(env,dic,entry,ima,hindo)
struct wnn_env *env;
int dic, entry, ima,hindo;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_HINDO_SET);

	JS_Put4Com(dic, env->js_id);
	JS_Put4Com(entry, env->js_id);
	JS_Put4Com(ima, env->js_id);
	JS_Put4Com(hindo, env->js_id);
	snd_flush(env->js_id);
	if((x=get4com(env->js_id))==-1){
		env_wnn_errorno_set= get4com(env->js_id);

	}

	return x;
} /* End of js_hindo_set */

/*:::DOC_START
 *
 *    Function Name: js_set_fi_priority
 *    Description  : ƣɴطǡΣƣɴط³ӥåȤ
 *		     ƣɴط³٤ꤹ
 *    Parameter    :
 *         env :          (In) ĶؤΥݥ
 *	   fi_rel_entry : (In) ѣƣɴطѹ¤ΤؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_set_fi_priority(env, fi_rel_entry)
struct wnn_env *env;
struct wnn_fi_rel_buf *fi_rel_entry;
{
	register int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	/* Фƣɳؽ򥵥ݡȤƤʤϲ⤷ʤ */
	if(!CHECK_FI) return(0);


	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_SET_FI_PRIORITY);

	JS_Put4Com(fi_rel_entry->num, env->js_id);
	for(x = 0; x < fi_rel_entry->num; x++) {
		JS_Put4Com(fi_rel_entry->fi_buf[x].fi_dic_no, env->js_id);
		JS_Put4Com(fi_rel_entry->fi_buf[x].dic_no, env->js_id);
		JS_Put4Com(fi_rel_entry->fi_buf[x].entry, env->js_id);
		JS_Put4Com(fi_rel_entry->fi_buf[x].offset, env->js_id);
		JS_Put4Com(fi_rel_entry->fi_buf[x].fi_hindo, env->js_id);
		JS_Put4Com(fi_rel_entry->fi_buf[x].fi_ima, env->js_id);
	}
	snd_flush(env->js_id);

	if((x = get4com(env->js_id)) == -1) {
		env_wnn_errorno_set= get4com(env->js_id);

	}

	return x;
} /* End of js_set_fi_priority */

/*:::DOC_START
 *
 *    Function Name: js_optimize_fi
 *    Description  : ꤵ줿κӥåȡ٤ꤷƳؽ
 *                   Ƭ졦ࡦѸ졦졦ƣɡˤԤ
 *    Parameter    :
 *         env :    (In) ĶؤΥݥ
 *         nkouho : (In) 
 *         dic :    (In) 䤬ϿƤ뼭ֹؤΥݥ
 *         entry    (In) ΥȥֹؤΥݥ
 *         ima :    (In) ӥåȤˡե饰ؤΥݥ
 *         hindo :  (In) ٤ˡե饰ؤΥݥ
 *         kmoji :  (In) ʸ°ʤؤΥݥ
 *         kouho :  (In) ʸ°줢ؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_optimize_fi(env,nkouho,dic,entry,ima,hindo,kmoji,kouho)
struct wnn_env *env;
int nkouho, *dic, *entry, *ima, *hindo, *kmoji;
w_char **kouho;
{
	register int x, i;

	x = 0;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	/* Фƣɳؽ򥵥ݡȤƤʤϡ
	       ץȥ */
	if(!CHECK_FI) {
		for(i = 0; i < nkouho; i++) {
			x = js_hindo_set(env, dic[i], entry[i], ima[i], hindo[i]);
			if(x == -1) return(-1);
		}
		return(x);
	}


	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_OPTIMIZE_FI);

	JS_Put4Com(nkouho, env->js_id);
	for(x = 0; x < nkouho; x++) {
		JS_Put4Com(dic[x], env->js_id);
		JS_Put4Com(entry[x], env->js_id);
		JS_Put4Com(ima[x], env->js_id);
		JS_Put4Com(hindo[x], env->js_id);
		JS_Put4Com(kmoji[x], env->js_id);
		putwscom(kouho[x], env->js_id);
	}
	snd_flush(env->js_id);

	if((x = get4com(env->js_id)) == -1) {
		env_wnn_errorno_set= get4com(env->js_id);

	}

	return x;
} /* End of js_optimize_fi */


/****
	Henkan
****/

static void
put_fzk_vec(hinsi,fzk,vec,vec1, server)
int hinsi;
w_char *fzk;
int vec;
int vec1;
ARGS *server;
{
	JS_Put4Com(hinsi, server);
	putwscom(fzk, server);
	JS_Put4Com(vec, server);
	JS_Put4Com(vec1, server);
}

/**
	kanren
**/
static int rcv_dai(), rcv_fi_rel_data();
static void rcv_sho_x();
static void rcv_sho_kanji();

int
js_kanren(env,yomi,hinsi,fzk,vec,vec1,vec2,rb)
struct wnn_env *env;
w_char	*yomi;
int	hinsi;
w_char	*fzk;
int	vec;
int	vec1;
int	vec2;
struct wnn_ret_buf *rb;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_KANREN);
	putwscom(yomi, env->js_id);
	put_fzk_vec(hinsi,fzk,vec,vec1, env->js_id);
	JS_Put4Com(vec2, env->js_id);
	snd_flush(env->js_id);
	x = rcv_dai(rb, env->js_id);

	return x;
}

/*:::DOC_START
 *
 *    Function Name: js_fi_kanren
 *    Description  : ϢʸƣѴԤ̤
 *    Parameter    :
 *         env :   (In) ĶؤΥݥ
 *	   yomi:   (In) ѴɤʸؤΥݥ
 *	   hinsi   (In) ʸʻֹ
 *	   fzk :   (In) ʸ°ʸؤΥݥ
 *	   vec :   (In) ü٥ȥ룱
 *	   vec1 :  (In) ü٥ȥ룲
 *	   vec2 :  (In) ϢʸѴʸνü٥ȥ
 *	   prev :  (In) ľʸ¤ΤؤΥݥ
 *	   rb :    (Out) Ѵѹ¤ΤؤΥݥ
 *	   fi_rb : (Out) ѣƣɴطѹ¤ΤؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_fi_kanren(env,yomi,hinsi,fzk,vec,vec1,vec2,prev,rb,fi_rb)
struct wnn_env *env;
w_char  *yomi;
int     hinsi;
w_char  *fzk;
int     vec;
int     vec1;
int     vec2;
struct wnn_prev_bun *prev;
struct wnn_ret_buf *rb;
struct wnn_fi_rel_buf *fi_rb;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	/* ФƣѴ򥵥ݡȤƤʤϡϢʸ
	    ץȥ */
	if(!CHECK_FI) return(js_kanren(env,yomi,hinsi,fzk,vec,vec1,vec2,rb));


	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FI_KANREN);
	putwscom(yomi, env->js_id);
	put_fzk_vec(hinsi,fzk,vec,vec1, env->js_id);
	JS_Put4Com(vec2, env->js_id);
	/* ľʸ */
	for(x = 0; x < WNN_PREV_BUN_SUU; x++) {
		JS_Put4Com(prev[x].dic_no, env->js_id);	/* Wnn ֹ */
		JS_Put4Com(prev[x].entry, env->js_id);	/* ȥֹ */
		JS_Put4Com(prev[x].jirilen, env->js_id);	/* ΩɤĹ */
		JS_Put4Com(prev[x].hinsi, env->js_id);	/* ʻֹ */
		putwscom((prev[x].kouho + prev[x].real_kanjilen), env->js_id);
		/* °ʸ */
	}
	snd_flush(env->js_id);

	/* ϢʸƣѴ̤ */
	x = rcv_dai(rb, env->js_id);
	/* ѣƣɴط */
	if(x != -1) {
		if(rcv_fi_rel_data(fi_rb, env->js_id) == -1) x = -1;
	}


	return x;
} /* End of js_fi_kanren */

/*	rcv dai		*/
static int
rcv_dai(ret, server)
struct wnn_ret_buf *ret;
ARGS *server;
{
	int dai_cnt,sho_sum,kanji_sum,d_size,s_size,k_size,x;
	register int i;
	struct wnn_dai_bunsetsu *dai_list;
	register struct wnn_dai_bunsetsu *dp;
	struct wnn_sho_bunsetsu *sho_list;
	register struct wnn_sho_bunsetsu *sp;
	w_char *kanji,*kp;

	dai_cnt = get4com(server);
	if(dai_cnt == -1){     /* error dayo */
		js_wnn_errorno_set = get4com(server);
		return -1;
	}
	sho_sum = get4com(server);
	kanji_sum = get4com(server);

	d_size=sizeof(struct wnn_dai_bunsetsu)*dai_cnt;
	s_size=sizeof(struct wnn_sho_bunsetsu)*sho_sum;
	k_size=sizeof(w_char)*kanji_sum;

	/* re_alloc(ret, d_size+s_size+k_size); Seems This cause Bug?? H.T.*/
	re_alloc(ret, d_size+s_size+k_size);

	dai_list = ( struct wnn_dai_bunsetsu *) ret->buf;
	sho_list = ( struct wnn_sho_bunsetsu *)((char *)ret->buf + d_size);
	kanji = (w_char *)((char *)ret->buf + d_size + s_size);

	for(dp = dai_list,i=0; i<dai_cnt; i++){
		dp -> end = get4com(server);
		dp -> start = get4com(server);
		dp -> sbncnt = get4com(server);
		dp -> hyoka = get4com(server);
		dp++;
	}

	for(dp = dai_list, sp = sho_list, i=0; i<dai_cnt; i++){
		dp -> sbn = sp;
		x = dp -> sbncnt;
		rcv_sho_x(sp,x, server);
		sp += x;
		dp++;
	}

	for(dp=dai_list, kp=kanji, i=0; i<dai_cnt; i++){
		rcv_sho_kanji(dp->sbn,dp->sbncnt,&kp,&k_size,server);
		dp++;
	}
	return dai_cnt;
}

/*	rcv sho routines	*/
static void
rcv_sho_x(sho_list,sho_cnt, server)
register struct wnn_sho_bunsetsu *sho_list;
int sho_cnt;
ARGS *server;
{
	register int i;
	for(i=0;i<sho_cnt;i++){
		sho_list -> end = get4com(server);
		sho_list -> start = get4com(server);
		sho_list -> jiriend = get4com(server);
		sho_list -> dic_no = get4com(server);
		sho_list -> entry = get4com(server);
		sho_list -> hindo = get4com(server);
		sho_list -> ima = get4com(server);
		sho_list -> hinsi = get4com(server);
		sho_list -> status = get4com(server);
		sho_list -> status_bkwd = get4com(server);
		sho_list ->kangovect = get4com(server);
		sho_list -> hyoka = get4com(server);
		sho_list++;
	}
}

static void
rcv_sho_kanji(sho_list,sho_cnt,kanji,kanjibytes,server)
struct wnn_sho_bunsetsu *sho_list;
int sho_cnt;
w_char **kanji;
int *kanjibytes;
ARGS *server;
{
	register w_char *k;
	register int i, bytes, error_flag, wlen;
	w_char wbuf[LENGTHKANJI];

	k = *kanji;
	bytes = *kanjibytes;
	if (bytes <= 0)
		error_flag = 1;
		else
		error_flag = 0;

	for(i=0;i<sho_cnt;i++){
		getwscom(wbuf, server, sizeof(wbuf) / sizeof(w_char));
		if (!error_flag) {
			wlen = wnn_Strlen(wbuf) + 1;
			if ((wlen * sizeof(w_char)) > bytes) {
				error_flag = 1;
			} else {
				sho_list->kanji = k;
				wnn_Strcpy(k, wbuf);
				k += wlen;
				bytes -= (wlen * sizeof(w_char));
			}
		}

		getwscom(wbuf, server, sizeof(wbuf) / sizeof(w_char));
		if (!error_flag) {
			wlen = wnn_Strlen(wbuf) + 1;
			if ((wlen * sizeof(w_char)) > bytes) {
				error_flag = 1;
			} else {
				sho_list->yomi = k;
				wnn_Strcpy(k, wbuf);
				k += wlen;
				bytes -= (wlen * sizeof(w_char));
			}
		}

		getwscom(wbuf, server, sizeof(wbuf) / sizeof(w_char));
		if (!error_flag) {
			wlen = wnn_Strlen(wbuf) + 1;
			if ((wlen * sizeof(w_char)) > bytes) { /* '>=' ǤϤʤ */
				error_flag = 1;
			} else {
				sho_list->fuzoku = k;
				wnn_Strcpy(k, wbuf);
				k += wlen;
				bytes -= (wlen * sizeof(w_char));
			}
		}
		sho_list++;
	}
	*kanji = k;
	*kanjibytes = bytes;
}


static int
rcv_sho(ret, server)
struct wnn_ret_buf *ret;
ARGS *server;
{
	int sho_sum,kanji_sum,s_size,k_size;
	struct wnn_sho_bunsetsu *sho_list;
	w_char *kanji,*kp;

	sho_sum = get4com(server);
	if(sho_sum == -1){     /* error dayo */
		js_wnn_errorno_set = get4com(server);
		return -1;
	}
	kanji_sum = get4com(server);

	s_size=sizeof(struct wnn_sho_bunsetsu)*sho_sum;
	k_size=sizeof(w_char)*kanji_sum;

	re_alloc(ret, s_size+k_size);

	sho_list = ( struct wnn_sho_bunsetsu *)((char *)ret->buf);
	kanji = (w_char *)((char *)ret->buf + s_size);

	rcv_sho_x(sho_list,sho_sum, server);
	kp=kanji;
	rcv_sho_kanji(sho_list,sho_sum,&kp,&k_size,server);
	return sho_sum;
}

/*:::DOC_START
 *
 *    Function Name: rcv_fi_rel_data
 *    Description  : ϢʸƣѴ˻Ѥƣɴط
 *    Parameter    :
 *         ret :    (Out) ѣƣɴطѹ¤ΤؤΥݥ
 *	   server : (In) о jserver ¤ΤؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
static int
rcv_fi_rel_data(ret, server)
struct wnn_fi_rel_buf *ret;
ARGS *server;
{
	register int i, fi_num;
	struct fi_rel_data *fi_data;

	fi_num = get4com(server);	/* ѣƣɴط */
	if(fi_num == 0) return(0);  /* ѣƣɴطʤä */

	if(ret->size < ret->num + fi_num) {
		/* ˣƣɴطǡ¤ݤ */
		fi_data = (struct fi_rel_data *)
		    malloc((ret->num + fi_num) * sizeof(struct fi_rel_data));

		/* ˻ѤƤƣɴطǡ򥳥ԡ */
		if(fi_data) {
			if(ret->fi_buf) {
				memcpy(fi_data, ret->fi_buf, ret->num * sizeof(struct fi_rel_data));
				free((char *)ret->fi_buf);
			}
		}
		ret->fi_buf = fi_data;
		ret->size = ret->num + fi_num;
	}

	/* ƣɴطǡ¤󤬳ݤǤ */
	if(ret->fi_buf == NULL) {
		int dummy;
		for(i = 0; i < 4 * fi_num; i++) dummy = get4com(server);
		js_wnn_errorno_set = WNN_MALLOC_ERR;
		return(-1);
	}

	/* ѣƣɴطǡ */
	fi_data = ret->fi_buf + ret->num;
	for(i = 0; i < fi_num; i++, fi_data++) {
		fi_data->fi_dic_no = get4com(server);
		fi_data->dic_no = get4com(server);
		fi_data->entry = get4com(server);
		fi_data->offset = get4com(server);
		fi_data->fi_hindo = WNN_HINDO_NOP;
		fi_data->fi_ima = WNN_IMA_OFF;
	}
	ret->num = ret->num + fi_num;
	return(0);
} /* End of rcv_fi_rel_data */


/**
	kantan
**/
int
js_kantan_dai(env,yomi,hinsi,fzk,vec,vec1,rb)
struct wnn_env *env;
w_char	*yomi;
int	hinsi;
w_char	*fzk;
int	vec;
int	vec1;
struct wnn_ret_buf *rb;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_KANTAN_DAI);
	putwscom(yomi, env->js_id);
	put_fzk_vec(hinsi,fzk,vec,vec1, env->js_id);
	snd_flush(env->js_id);
	x = rcv_dai(rb, env->js_id);

	return x;
}

int
js_kantan_sho(env,yomi,hinsi,fzk,vec,vec1,rb)
struct wnn_env *env;
w_char	*yomi;
int	hinsi;
w_char	*fzk;
int	vec;
int	vec1;
struct wnn_ret_buf *rb;
{
	int sbncnt;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_KANTAN_SHO);
	putwscom(yomi, env->js_id);
	put_fzk_vec(hinsi,fzk,vec,vec1, env->js_id);
	snd_flush(env->js_id);

	sbncnt = rcv_sho(rb, env->js_id);

	return sbncnt;
}

/**
	kanzen
**/
int
js_kanzen_dai(env,yomi,hinsi,fzk,vec,vec1,rb)
struct wnn_env *env;
w_char	*yomi;
int	hinsi;
w_char	*fzk;
int	vec;
int	vec1;
struct wnn_ret_buf *rb;
{
	int x;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_KANZEN_DAI);
	putwscom(yomi, env->js_id);
	put_fzk_vec(hinsi,fzk,vec,vec1, env->js_id);
	snd_flush(env->js_id);
	x = rcv_dai(rb, env->js_id);

	return x;
}


int
js_kanzen_sho(env,yomi,hinsi,fzk,vec,vec1,rb)
struct wnn_env *env;
w_char	*yomi;
int	hinsi;
w_char	*fzk;
int	vec;
int	vec1;
struct wnn_ret_buf *rb;
{
	int sbncnt;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_KANZEN_SHO);
	putwscom(yomi, env->js_id);
	put_fzk_vec(hinsi,fzk,vec,vec1, env->js_id);
	snd_flush(env->js_id);

	sbncnt = rcv_sho(rb, env->js_id);

	return sbncnt;
}

/**	
        henkan with data
**/
int
js_henkan_with_data(env,fuku,nhinsi,hlist,henkan,yomi,hinsi,fzk,vec,vec1,vec2,rb)
struct wnn_env *env;
int fuku, nhinsi, *hlist, henkan;
w_char  *yomi;
int     hinsi;
w_char  *fzk;
int     vec;
int     vec1;
int	vec2;
struct wnn_ret_buf *rb;
{
	int x, i, loop = abs(nhinsi);

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_HENKAN_WITH_DATA);
	JS_Put4Com(fuku, env->js_id);		/* ʣͥ */
	JS_Put4Com(nhinsi, env->js_id);		/* Ѵʻ */
	for(i = 0; i < loop; i++)
		JS_Put4Com(hlist[i], env->js_id);	/* Ѵʻֹ */
	JS_Put4Com(henkan, env->js_id);		/* Ѵ */
	putwscom(yomi, env->js_id);
	put_fzk_vec(hinsi,fzk,vec,vec1, env->js_id);
	JS_Put4Com(vec2, env->js_id);
	snd_flush(env->js_id);

	switch(henkan) {
	case WNN_KANREN:
	case WNN_KANTAN_DAI:
	case WNN_KANZEN_DAI:
		x = rcv_dai(rb, env->js_id);
		break;
	case WNN_KANTAN_SHO:
	case WNN_KANZEN_SHO:
		x = rcv_sho(rb, env->js_id);
		break;
	default:
		x = get4com(env->js_id);
		env_wnn_errorno_set= get4com(env->js_id);
	}

	return x;
}

/**	js_version		**/
int
js_version(server,serv,libv)
int *serv,*libv;
WNN_JSERVER_ID *server;
{
	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server, JS_VERSION);
	snd_flush(server);
	*libv= JLIB_VERSION;
	*serv = get4com(server);

	return *serv;
}

static void
re_alloc(ret,size)
register struct wnn_ret_buf *ret;
int size;
{
	if(ret->size < size){
		if(ret->buf)
			free((char *)ret->buf);
		ret->buf = malloc(size);
		ret->size = size;
	}
}

int
js_kill(server)
WNN_JSERVER_ID *server;
{
	int x;
	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server, JS_KILL);
	snd_flush(server);
	x = get4com(server);

	return(x);
}

int
js_file_remove(server, n, pwd)
WNN_JSERVER_ID *server;
char *n, *pwd;
{
	register int x;
	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server,JS_FILE_REMOVE);
	putscom(n, server);
	putscom(pwd, server);
	snd_flush(server);
	if((x=get4com(server))==-1){
		js_wnn_errorno_set= get4com(server);

		return -1;
	}

	return(x);
}

int
js_file_remove_client(server, n, pwd)
WNN_JSERVER_ID *server;
char *n, *pwd;
{
	struct wnn_file_head fh;
	register FILE *fp;

	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	if(js_file_loaded_local_body(server, n) != -1){
		js_wnn_errorno_set = WNN_FILE_IN_USE;

		return(-1);
	}
#ifdef WRITE_CHECK
	check_backup(n);
#endif /* WRITE_CHECK */
	if((fp=dic_fopen(n,"r")) == NULL){
		js_wnn_errorno_set = WNN_FILE_READ_ERROR;

		return(-1);
	}
	if(input_file_header(fp, &fh) == -1){
		dic_fclose(fp);

		return(-1);
	}
	dic_fclose(fp);
	if(!check_pwd(pwd, fh.file_passwd)){
		js_wnn_errorno_set = WNN_INCORRECT_PASSWD;

		return(-1);
	}
	if(unlink(n) == -1){
		js_wnn_errorno_set = WNN_UNLINK;

		return(-1);
	}

	return(0);
}

/*:::DOC_START
 *
 *    Function Name: js_dic_file_create_client
 *    Description  : 饤¦˼ե
 *    Parameter    :
 *         env :     (In) ĶؤΥݥ
 *	   fn :      (In) ե̾
 *	   type :    (In) ե륿
 *	   com :     (In) ե륳
 *	   passwd    (In) եѥ
 *         hpasswd : (In) ٥ѥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_dic_file_create_client(env, fn, type, com, passwd, hpasswd)
struct wnn_env *env;
int type;
char *fn;
w_char *com;
char *passwd, *hpasswd;
{
	int x, js_jishonum;

	if(env==0) return(-1);

	/*
	     * (Jul. 7, 1994)
	     * ƣɴط񡢥롼׼񡢥ޡκɲ
	     */
	if(type != WNN_REV_DICT &&
	    type != WNN_UD_DICT &&
	    type != WNN_FI_USER_DICT &&
	    type != WNN_GROUP_DICT &&
	    type != WNN_MERGE_DICT){
		env_wnn_errorno_set = WNN_NOT_A_UD;

		return(-1);
	}
	if(type == WNN_FI_USER_DICT) { /* ƣɴطؿƤ */
		int i, j;
		unsigned char njisho;
		struct wnn_file_uniq duniq[WNN_MAX_JISHO_OF_AN_ENV];
		int dprimary[WNN_MAX_JISHO_OF_AN_ENV];

		/* ³primary index tablefile uniqˤμ */
		set_current_js(env->js_id);
		handler_of_jserver_dead_env(env);
		if(env_wnn_errorno_eql) {

			return(-1);
		}
		snd_env_head(env, JS_DIC_FILE_CREATE_CLIENT);
		snd_flush(env->js_id);
		x = get4com(env->js_id);
		if(x == -1) {
			env_wnn_errorno_set = get4com(env->js_id);

			return(-1);
		}
		js_jishonum = get1com(env->js_id); /* ³ */
		if (js_jishonum > WNN_MAX_JISHO_OF_AN_ENV)
			njisho = WNN_MAX_JISHO_OF_AN_ENV;
			else
			njisho = js_jishonum;
		for(i = 0; i < njisho; i++) {
			/* ³ file uniq */
			duniq[i].time = get4com(env->js_id);
			duniq[i].dev = get4com(env->js_id);
			duniq[i].inode = get4com(env->js_id);
			for(j = 0; j < WNN_HOSTLEN; j++){
				duniq[i].createhost[j] = get1com(env->js_id);
			}
			/* ³Ͽÿ */
			dprimary[i] = get4com(env->js_id);
		}
		if (js_jishonum > WNN_MAX_JISHO_OF_AN_ENV) {
			js_jishonum -= WNN_MAX_JISHO_OF_AN_ENV;
			for(i = 0; i < js_jishonum; i++) {
				get4com(env->js_id);
				get4com(env->js_id);
				get4com(env->js_id);
				for(j = 0; j < WNN_HOSTLEN; j++){
					get1com(env->js_id);
				}
				get4com(env->js_id);
			}
		}
		x = create_null_fi_dic(fn, com, passwd, hpasswd, type, njisho, duniq, dprimary);

	} else /* ףؿƤ */
		x = create_null_dic(fn,com, passwd, hpasswd, type);

	if(x == -1){
		env_wnn_errorno_set = WNN_FILE_CREATE_ERROR;

		return(-1);
	}

	return(0);
} /* End of js_dic_file_create_client */


/**	js_hindo_file_create_client	**/
int
js_hindo_file_create_client(env,fid,fn,com,hpasswd)
struct wnn_env *env;
int	fid;
char *fn;
w_char *com;
char *hpasswd;
{
	register int x;
	struct wnn_file_uniq funiq;
	int serial;
	register int i;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_HINDO_FILE_CREATE_CLIENT);
	JS_Put4Com(fid, env->js_id);
	snd_flush(env->js_id);
	x = get4com(env->js_id);
	if(x == -1){
		env_wnn_errorno_set = get4com(env->js_id);

		return(-1);
	}
	serial = get4com(env->js_id);
	funiq.time = get4com(env->js_id);
	funiq.dev =  get4com(env->js_id);
	funiq.inode = get4com(env->js_id);
	for(i=0;i<WNN_HOSTLEN;i++){
		funiq.createhost[i]=get1com(env->js_id);
	}
	if(create_hindo_file(&funiq,fn,com,hpasswd,serial) == -1){
		env_wnn_errorno_set = WNN_FILE_CREATE_ERROR;

		return(-1);
	}

	return(0);
}

/*:::DOC_START
 *
 *    Function Name: js_fi_hindo_file_create_client
 *    Description  : 饤¦ˣƣɴط٥ե
 *    Parameter    :
 *         env :     (In) ĶؤΥݥ
 *	   fid :     (In) бƣɴطեɣ
 *	   fn :      (In) ƣɴط٥ե̾
 *	   com :     (In) ƣɴط٥ե륳
 * 	   hpasswd : (In) ƣɴط٥եѥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_fi_hindo_file_create_client(env, fid, fn, com, hpasswd)
struct wnn_env *env;
int     fid;
char *fn;
w_char *com;
char *hpasswd;
{
	register int x;
	struct wnn_file_uniq funiq;
	unsigned char njisho;
	int *primary;
	register int i;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FI_HINDO_FILE_CREATE_CLIENT);
	JS_Put4Com(fid, env->js_id);
	snd_flush(env->js_id);
	x = get4com(env->js_id);
	if(x == -1){
		env_wnn_errorno_set = get4com(env->js_id);

		return(-1);
	}
	funiq.time = get4com(env->js_id);
	funiq.dev =  get4com(env->js_id);
	funiq.inode = get4com(env->js_id);
	for(i=0;i<WNN_HOSTLEN;i++){
		funiq.createhost[i]=get1com(env->js_id);
	}
	njisho = get1com(env->js_id);
	if((primary = (int *)malloc(njisho * sizeof(int))) == NULL) {
		env_wnn_errorno_set = WNN_MALLOC_ERR;

		return(-1);
	}
	for(i = 0; i < njisho; i++)
		primary[i] = get4com(env->js_id);
	if(create_fi_hindo_file(&funiq,fn,com,hpasswd,njisho,primary) == -1){
		free(primary);
		env_wnn_errorno_set = WNN_FILE_CREATE_ERROR;

		return(-1);
	}
	free(primary);

	return(0);
} /* End of js_fi_hindo_file_create_client */

int
js_file_comment_set(env, fid, comment)
struct wnn_env *env;
int fid;
w_char *comment;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FILE_COMMENT_SET);
	JS_Put4Com(fid, env->js_id);
	putwscom(comment, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);

		return(-1);
	}

	return(0);
}

/* 
 * Hinsi Primitives
 */

int
js_hinsi_name(server, no, rb)
WNN_JSERVER_ID *server;
int no;
struct wnn_ret_buf *rb;
{
	register int size;

	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server,JS_HINSI_NAME);
	JS_Put4Com(no, server);
	snd_flush(server);
	if((size = get4com(server)) == -1){
		js_wnn_errorno_set = get4com(server);

		return(-1);
	}
	re_alloc(rb,sizeof(w_char)*(size + 1));
	getwscom((w_char *)rb->buf, server, size + 1);

	return(0);
}


int 
js_hinsi_number(server, name)
WNN_JSERVER_ID *server;
w_char *name;
{
	register int no;

	set_current_js(server);

	handler_of_jserver_dead(server);
	if(js_wnn_errorno_eql) {

		return(-1);
	}
	snd_server_head(server,JS_HINSI_NUMBER);
	putwscom(name, server);
	snd_flush(server);
	if((no = get4com(server)) == -1){
		js_wnn_errorno_set = get4com(server);

		return(-1);
	}

	return(no);
}

int
js_hinsi_list(env, dic_no, name, rb)
struct wnn_env *env;
int dic_no;
w_char *name;
struct wnn_ret_buf *rb;
{
	int size;
	int count;
	register w_char *s;
	register w_char **r;
	register int k, wlen, error_flag;
	w_char wbuf[LENGTHKANJI];

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_HINSI_LIST);
	JS_Put4Com(dic_no, env->js_id);
	putwscom(name, env->js_id);
	snd_flush(env->js_id);
	if((count = get4com(env->js_id)) == -1){
		env_wnn_errorno_set = get4com(env->js_id);

		return(-1);
	}
	size = get4com(env->js_id);
	size += 1;
	re_alloc(rb,sizeof(w_char)*(size) + count * sizeof(w_char *) );
	r = (w_char **)rb->buf;
	s = (w_char *)((w_char **)rb->buf + count);
	error_flag = 0;
	for(k = 0 ; k < count ; k++){
		getwscom(wbuf, env->js_id, sizeof(wbuf) / sizeof(w_char));
		if (!error_flag) {
			wlen = wnn_Strlen(wbuf) + 1;
			if (wlen > size) {
				error_flag = 1;
			} else {
				*r++ = s;
				wnn_Strcpy(s, wbuf);
				s += wlen;
				size -= wlen;
			}
		}
	}

	return(count);
}

int 
js_hinsi_dicts(env, no,  rb)
struct wnn_env *env;
int no;
struct wnn_ret_buf *rb;
{
	register int k, count;
	int *p;

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_HINSI_DICTS);
	JS_Put4Com(no, env->js_id);
	snd_flush(env->js_id);
	if((count = get4com(env->js_id)) == -1){
		env_wnn_errorno_set = get4com(env->js_id);

		return(-1);
	}
	re_alloc(rb,sizeof(int) * (count + 1));
	p = (int *)rb->buf;

	for(k = 0 ; k < count ; k++){
		*p++ = get4com(env->js_id);
	}

	return(count);
}


char *wnn_dic_types[] = {
	"","","Ͽ","հ","","","FI","FI桼","FI","롼","ޡ","",""};

char *cwnn_dic_types[] = {
	"","̶","¼","ƴ",""};
char *bwnn_dic_types[] = {
	"","̶","¼","",""};

char *kwnn_dic_types[] = {
	"","","","",""};
/*    ͳ         Ю */


/* New primitives  9/8 */

int
js_file_password_set(env, fid, which, old, new)
struct wnn_env *env;
int fid;
int which;			/* 1 for dic, 2 for hindo 3(0) for both*/
char *old, *new;
{
	register int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_FILE_PASSWORD_SET);
	JS_Put4Com(fid, env->js_id);
	JS_Put4Com(which, env->js_id);
	putscom(old, env->js_id);
	putscom(new, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);

		return(-1);
	}

	return(0);
}

int
js_hinsi_table_set(env, dic_no, hinsi_table)
struct wnn_env *env;
int dic_no;
w_char *hinsi_table;
{
	int x;
	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_HINSI_TABLE_SET);
	JS_Put4Com(dic_no, env->js_id);
	putwscom(hinsi_table, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if(x==-1){
		env_wnn_errorno_set= get4com(env->js_id);

		return(-1);
	}

	return(0);
}

/* Start of packets in 4004 */
int
js_open_extension(server, ext_name)
WNN_JSERVER_ID *server;
char *ext_name;
{
	register wnn_extension_set *p;

	if (!ext_name || !*ext_name) {
		js_wnn_errorno_set = WNN_NOT_SUPPORT_EXTENSION;
		return(-1);
	}
	for (p = ((WNN_JSERVER_ID_INT *)server)->extensions;
	    p && p->id && p->name; p++) {
		if (!strcmp(p->name, ext_name)) {
			return(p->id);
		}
	}
	js_wnn_errorno_set = WNN_NOT_SUPPORT_EXTENSION;
	return(0);
}

int
js_get_extension(server, ret)
WNN_JSERVER_ID *server;
char ***ret;
{
	register wnn_extension_set *p;
	register char *s, **l;
	int total = 0, num = 0;

	if (!((WNN_JSERVER_ID_INT *)server)->extensions) {
		js_wnn_errorno_set = WNN_NOT_SUPPORT_PACKET;
		return(-1);
	}
	for (p = ((WNN_JSERVER_ID_INT *)server)->extensions;
	    p && p->id && p->name; p++) {
		total += strlen(p->name) + 1;
		num++;
	}
	if (num == 0) return(0);
	if (!(l = (char **)(s = malloc((sizeof(char *) * num) + total)))) {
		js_wnn_errorno_set = WNN_MALLOC_ERR;
		return(-1);
	}
	*ret = l;
	s += sizeof(char *) * num;
	for (p = ((WNN_JSERVER_ID_INT *)server)->extensions;
	    p && p->id && p->name; p++) {
		*l++ = s;
		strcpy(s, p->name);
		s += strlen(s) + 1;
	}
	return(num);
}


static int
access_host_core(server, ha, enable, ule)
WNN_JSERVER_ID *server;
host_address *ha;
int enable, ule;
{
	register int x;
	register char *p;

	handler_of_jserver_dead(server);
	if (js_wnn_errorno_eql) return(-1);
	if (enable) {
		snd_server_head(server, JS_ACCESS_ADD_HOST);
		JS_Put4Com(ule, server);
	} else {
		snd_server_head(server, JS_ACCESS_REMOVE_HOST);
	}
	JS_Put4Com(ha->address_len, server);
	p = ha->address;
	for (x = 0; x < ha->address_len; x++) {
		JS_Put1Com(*p, server);
		p++;
	}
	snd_flush(server);
	x=get4com(server);
	if(x==-1){
		js_wnn_errorno_set= get4com(server);
		return(-1);
	}
	return(x);
}

static int
access_host(server, host, enable, ule)
WNN_JSERVER_ID *server;
char *host;
int enable, ule;
{
	struct hostent *hp;
	struct in_addr addr;
	host_address ha;
	char **l;
	int x;

	if ((addr.s_addr = inet_addr(host)) != -1) {
		ha.address = (char *)&addr.s_addr;
		ha.address_len = sizeof(addr.s_addr);
		x = access_host_core(server, &ha, enable, ule);
		return(x);
	}
	hp = gethostbyname(host);
	endhostent();
	if (hp && hp->h_addrtype == AF_INET) {
		ha.address_len = sizeof(addr.s_addr);
		for (l = hp->h_addr_list; *l; l++) {
			ha.address = *l;
			if ((x = access_host_core(server, &ha, enable, ule)) == -1) {
				return(-1);
			}
		}
		return(0);
	} else {
		js_wnn_errorno_set = WNN_ACCESS_NO_HOST;
		return(-1);
	}
}

int
js_access_add_host(server, host, ule)
WNN_JSERVER_ID *server;
char *host;
int ule;
{
	int x;

	set_current_js(server);

	x = access_host(server, host, 1, ule);

	return(x);
}

int
js_access_remove_host(server, host)
WNN_JSERVER_ID *server;
char *host;
{
	int x;

	set_current_js(server);

	x = access_host(server, host, 0, 0);

	return(x);
}

static int
access_user_core(server, ha, user, enable)
WNN_JSERVER_ID *server;
host_address *ha;
char *user;
int enable;
{
	register int x;
	register char *p;

	handler_of_jserver_dead(server);
	if (js_wnn_errorno_eql) return(-1);
	if (enable) {
		snd_server_head(server, JS_ACCESS_ADD_USER);
	} else {
		snd_server_head(server, JS_ACCESS_REMOVE_USER);
	}
	JS_Put4Com(ha->address_len, server);
	p = ha->address;
	for (x = 0; x < ha->address_len; x++) {
		JS_Put1Com(*p, server);
		p++;
	}
	putscom(user, server);
	snd_flush(server);
	x=get4com(server);
	if(x==-1){
		js_wnn_errorno_set= get4com(server);
		return(-1);
	}
	return(x);
}

static int
access_user(server, host, user, enable)
WNN_JSERVER_ID *server;
char *host, *user;
int enable;
{
	struct hostent *hp;
	struct in_addr addr;
	host_address ha;
	char **l;
	int x;

	if (!host || !*host) {
		ha.address = NULL;
		ha.address_len = 0;
		x = access_user_core(server, &ha, user, enable);
		return(x);
	} else if ((addr.s_addr = inet_addr(host)) != -1) {
		ha.address = (char *)&addr.s_addr;
		ha.address_len = sizeof(addr.s_addr);
		x = access_user_core(server, &ha, user, enable);
		return(x);
	}
	hp = gethostbyname(host);
	endhostent();
	if (hp && hp->h_addrtype == AF_INET) {
		ha.address_len = sizeof(addr.s_addr);
		for (l = hp->h_addr_list; *l; l++) {
			ha.address = *l;
			if ((x = access_user_core(server, &ha, user, enable)) == -1) {
				return(-1);
			}
		}
		return(0);
	} else {
		js_wnn_errorno_set = WNN_ACCESS_NO_USER;
		return(-1);
	}
}

int
js_access_add_user(server, host, user)
WNN_JSERVER_ID *server;
char *host, *user;
{
	int x;

	set_current_js(server);

	x = access_user(server, host, user, 1);

	return(x);
}

int
js_access_remove_user(server, host, user)
WNN_JSERVER_ID *server;
char *host, *user;
{
	int x;

	set_current_js(server);

	x = access_user(server, host, user, 0);

	return(x);
}

static int
access_control(server, enable)
WNN_JSERVER_ID *server;
int enable;
{
	int x;

	handler_of_jserver_dead(server);
	if (js_wnn_errorno_eql) return(-1);
	if (enable) {
		snd_server_head(server, JS_ACCESS_ENABLE);
	} else {
		snd_server_head(server, JS_ACCESS_DISABLE);
	}
	snd_flush(server);
	x=get4com(server);
	if(x==-1){
		js_wnn_errorno_set= get4com(server);
		return(-1);
	}
	return(x);
}

int
js_access_enable(server)
WNN_JSERVER_ID *server;
{
	int x;

	set_current_js(server);

	x = access_control(server, 1);

	return(x);
}

int
js_access_disable(server)
WNN_JSERVER_ID *server;
{
	int x;

	set_current_js(server);

	x = access_control(server, 0);

	return(x);
}

static int
get_host_name_len(host_p)
host_address *host_p;
{
	char *p;
	register struct hostent *hp;
	int user_len = 0;
	char address[32];
	char *inet_ntoa();

	if ((p = strchr(host_p->address, ':'))) {
		user_len = strlen(p);
	}
	if (sizeof(address) < host_p->address_len)
		return 0;
	memcpy(address, (char *)host_p->address, host_p->address_len);
	hp = gethostbyaddr (address, host_p->address_len, AF_INET);
	endhostent();
	if (hp)
		return(strlen(hp->h_name) + user_len);
	if (!(p = inet_ntoa(*((struct in_addr *)(address))))) return(0);
	return(strlen(p) + user_len);
}

static int
get_host_name(host_p, host)
host_address *host_p;
char *host;
{
	char *p, *user;
	register struct hostent *hp;
	int user_len = 0;
	char address[32];
	char *inet_ntoa();

	if ((user = strchr(host_p->address, ':'))) {
		user_len = strlen(user);
	}
	if (sizeof(address) < host_p->address_len)
		return 0;
	memcpy(address, (char *)host_p->address, host_p->address_len);
	hp = gethostbyaddr (address, host_p->address_len, AF_INET);
	endhostent();
	if (hp) {
		strcpy(host, hp->h_name);
		if (user) strcat(host, user);
		return(strlen(host));
	}
	if (!(p = inet_ntoa(*((struct in_addr *)(address))))) return(0);
	strcpy(host, p);
	if (user) strcat(host, user);
	return(strlen(host));
}

char **
js_access_get_info(server, enable, ret_num)
WNN_JSERVER_ID *server;
int *enable;
int *ret_num;
{
	int i, j, host_num, except_num, total_num, bytes, total, error_flag;
	register char *p, **out, *save, **out_save;
	host_address *host_p;
	char dummy[1024];

	*ret_num = -1;
	set_current_js(server);

	handler_of_jserver_dead(server);
	if (js_wnn_errorno_eql) {

		return(NULL);
	}
	snd_server_head(server, JS_ACCESS_GET_INFO);
	snd_flush(server);
	*enable = get4com(server);
	if(*enable == -1){
		js_wnn_errorno_set= get4com(server);

		return((char **)NULL);
	}
	bytes = get4com(server);
	host_num = get4com(server);
	except_num = get4com(server);
	total_num = host_num + except_num;
	if (total_num == 0) {
		*ret_num = 0;

		return((char **)NULL);
	}
	if (!(save = p = malloc((sizeof(host_address) * total_num) + bytes))) {
		for (i = 0; i < bytes; i++) get1com(server);
		js_wnn_errorno_set = WNN_MALLOC_ERR;
		return((char **)NULL);
	}
	host_p = (host_address *)p;
	p +=  sizeof(host_address) * total_num;
	error_flag = 0;
	for (i = 0; i < host_num; i++, host_p++) {
		host_p->address_len = get4com(server);
		if ((host_p->address_len >= bytes) || (bytes <= 0) || error_flag) {
			error_flag = 1;
			for (j = 0; j < host_p->address_len; j++) get1com(server);
			if (get4com(server))
				getscom(dummy, server, sizeof(dummy));
		} else {
			for (j = 0; j < host_p->address_len; j++) p[j] = get1com(server);
			host_p->address = p;
			p += host_p->address_len;
			bytes -= host_p->address_len;
			if (get4com(server)) {
				*p++ = ':';
				bytes--;
				getscom(p, server, bytes);
				if (bytes > 0) {
					p += strlen(p) + 1;
					bytes -= strlen(p) + 1;
				}
			} else {
				*p++ = '\0';
				bytes--;
			}
		}
	}
	for (i = 0; i < except_num; i++, host_p++) {
		if ((bytes <= 0) || error_flag) {
			error_flag = 1;
			getscom(dummy, server, sizeof(dummy));
		} else {
			host_p->address = p;
			*p++ = '@';
			bytes--;
			getscom(p, server, bytes);
			if (bytes > 0) {
				p += strlen(p) + 1;
				bytes -= strlen(p) + 1;
				host_p->address_len = strlen(host_p->address);
			}
		}
	}
	if (error_flag) {
		free((char *)save);
		js_wnn_errorno_set = WNN_SOME_ERROR;

		return((char **)NULL);
	}
	for (host_p = (host_address *)save, total = 0, i = 0;
	    i < total_num; i++, host_p++) {
		if (host_p->address_len > 0 && host_p->address[0] == '@')
			total += strlen(host_p->address);	/* exceptional user name */
			else
			total += get_host_name_len(host_p);
	}
	if (!(p = malloc((sizeof(char *) * total_num) + total + total_num))) {
		free((char *)save);
		js_wnn_errorno_set = WNN_MALLOC_ERR;

		return((char **)NULL);
	}
	out = out_save = (char **)p;
	p += (sizeof(char *) * total_num);
	for (host_p = (host_address *)save, i = 0; i < total_num; i++, host_p++) {
		*out++ = p;
		if (host_p->address_len > 0 && host_p->address[0] == '@') {
			strcpy(p, host_p->address)	/* exceptional user name */;
			p += strlen(host_p->address) + 1;
		} else
			p += get_host_name(host_p, p) + 1;
	}
	free((char *)save);
	*ret_num = total_num;

	return(out_save);
}

/*:::DOC_START
 *
 *    Function Name: js_is_loaded_temporary_dic
 *    Description  : 
 *	   ƥݥ꼭񤬴Ķˤ뤫ɤĴ٤
 *    Parameter    :
 *	   env :      (In) ĶؤΥݥ
 *
 *    Return value : 1==EXIST, 0==NO EXIST, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_is_loaded_temporary_dic(env)
struct wnn_env *env;
{
	register int x = 0;

	if(!env) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_IS_LOADED_TEMPORARY_DIC);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if (x == -1) {
		wnn_errorno = get4com(env->js_id);
	}

	return x;
}

/*:::DOC_START
 *
 *    Function Name: js_temporary_dic_delete
 *    Description  : 
 *	   ƥݥ꼭Ķɲä
 *    Parameter    :
 *	   env :      (In) ĶؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_temporary_dic_add(env, rev)
struct wnn_env *env;
int rev;
{
	register int x = 0;

	if(!env) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_TEMPORARY_DIC_ADD);
	JS_Put4Com(rev, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if (x == -1) wnn_errorno = get4com(env->js_id);

	return x;
}

/*:::DOC_START
 *
 *    Function Name: js_temporary_dic_delete
 *    Description  : 
 *	   ƥݥ꼭Ķ
 *    Parameter    :
 *	   env :      (In) ĶؤΥݥ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_temporary_dic_delete(env)
struct wnn_env *env;
{
	register int x;

	if(!env) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_TEMPORARY_DIC_DELETE);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if (x == -1) wnn_errorno = get4com(env->js_id);

	return x;
}

/*:::DOC_START
 *
 *    Function Name: js_temporary_word_add
 *    Description  : 
 *	   ƥݥ꼭ñϿ롣
 *    Parameter    :
 *	   env :      (In) ĶؤΥݥ
 *	   yomi :     (In) ɤ
 *	   kanji :    (In) 
 *	   comment :  (In) 
 *	   hinsi :    (In) ʻ
 *	   init_hindo :(In) 
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_temporary_word_add(env, yomi, kanji, comment, hinshi, init_hindo)
struct wnn_env *env;
w_char	*yomi,*kanji,*comment;
int	hinshi,init_hindo;
{
	register int x;

	if(!env) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_TEMPORARY_WORD_ADD);
	putwscom(yomi, env->js_id);
	putwscom(kanji, env->js_id);
	putwscom(comment, env->js_id);
	JS_Put4Com(hinshi, env->js_id);
	JS_Put4Com(init_hindo, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if (x == -1) wnn_errorno = get4com(env->js_id);

	return x;
}

/*:::DOC_START
 *
 *    Function Name: js_autolearning_word_add
 *    Description  : 
 *	   ưϿñϿ롣
 *    Parameter    :
 *	   env :      (In) ĶؤΥݥ
 *	   type :     (In) ؽ륿(/ʸڤ)
 *	   yomi :     (In) ɤ
 *	   kanji :    (In) 
 *	   comment :  (In) 
 *	   hinsi :    (In) ʻ
 *	   init_hindo :(In) 
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_autolearning_word_add(env, type, yomi, kanji, comment, hinshi, init_hindo)
struct wnn_env *env;
w_char	*yomi,*kanji,*comment;
int	type, hinshi,init_hindo;
{
	register int x;

	if(!env) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_AUTOLEARNING_WORD_ADD);
	JS_Put4Com(type, env->js_id);
	putwscom(yomi, env->js_id);
	putwscom(kanji, env->js_id);
	putwscom(comment, env->js_id);
	JS_Put4Com(hinshi, env->js_id);
	JS_Put4Com(init_hindo, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if (x == -1) wnn_errorno = get4com(env->js_id);

	return x;
}

/*:::DOC_START
 *
 *    Function Name: js_set_autolearning_dic
 *    Description  : 
 *	   ưϿѤμϿ
 *    Parameter    :
 *	   env :      (In) ĶؤΥݥ
 *	   type :     (In) Υ(/ʸڤ)
 *	   dic_no :   (In) ֹ
 *
 *    Return value : 0==SUCCESS, -1==ERROR
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_set_autolearning_dic(env, type, dic_no)
register struct wnn_env *env;
register int type, dic_no;
{
	int x;

	if(!env) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_SET_AUTOLEARNING_DIC);
	JS_Put4Com(type, env->js_id);
	JS_Put4Com(dic_no, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if (x == -1) wnn_errorno = get4com(env->js_id);

	return(x);
}

/*:::DOC_START
 *
 *    Function Name: js_get_autolearning_dic
 *    Description  : 
 *	   ưϿѤμĴ٤
 *    Parameter    :
 *	   env :      (In) ĶؤΥݥ
 *	   type :     (In) Υ(/ʸڤ)
 *
 *    Return value : -1==ERROR, ELSE==ֹ
 *
 *    Revision history:
 *
 *:::DOC_END
 */
int
js_get_autolearning_dic(env, type)
register struct wnn_env *env;
register int type;
{
	register int x;

	if(!env) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}
	snd_env_head(env,JS_GET_AUTOLEARNING_DIC);
	JS_Put4Com(type, env->js_id);
	snd_flush(env->js_id);
	x=get4com(env->js_id);
	if (x == -1) {

		wnn_errorno = get4com(env->js_id);
		return -1;
	}
	x=get4com(env->js_id);

	return(x);
}


/*:::DOC_START
 *
 *    Function Name:
 *	   rcv_dai_sim, rcv_sho_x_sim, rcv_sho_kanji_sim, rcv_sho_sim
 *    Description  : 
 *	   emulate rcv_dai etc. for local test
 *    Parameter    : same as emulated (omitted)
 *
 *    Return value : same as emulated (omitted)
 *
 *    Revision history:
 *         20-Dec-94: initial release
 *
 *:::DOC_END
 */



/*:::DOC_START
 *
 *    Function Name: js_ikeiji_with_data
 *    Description  : 
 *	   ѴѳƼǡʣѴѴʻꥹȡˤ
 *	   ꤷơ۷ ѴԤʤ
 *    Parameter    :
 *	   env :      (In) ĶؤΥݥ
 *	   fuku :     (In) ʣѴ
 *	   nhinsi :     (In) ʻο
 *	   hlist :     (In) ʻꥹ
 *	   henkan :     (In) ѴΥ
 *	   yomi :     (In) Υ
 *	   hinsi :     (In) ̤ʻ
 *	   fzk :     (In) °ξ
 *	   vec :     (In) ³ξ
 *	   vec1 :     (In) ³ξ 1
 *	   vec2 :     (In) ³ξ 2
 *	   cur_bun :     (In) ʸξ
 *	   yomi_orig :     (In) ɤ
 *	   rb :     (Out) η
 *
 *    Return value : ʸο
 *
 *    Revision history:
 *         20-Dec-94: initial release
 *
 *:::DOC_END
 */
int
js_ikeiji_with_data(env,fuku,nhinsi,hlist,henkan,yomi,hinsi,fzk,vec,vec1,vec2,
cur_bun, yomi_orig,
rb)
struct wnn_env *env;
int fuku, nhinsi, *hlist, henkan;
w_char  *yomi;
int     hinsi;
w_char  *fzk;
int     vec;
int     vec1;
int	vec2;
WNN_BUN *cur_bun;
w_char  *yomi_orig;
struct wnn_ret_buf *rb;
{
	int x;
	int i, loop = abs(nhinsi);
	register int put_val;

	int for_ret_status;
	int for_ret_status_bkwd;

	for_ret_status = (cur_bun->dai_top)? WNN_NOT_CONNECT : WNN_CONNECT;
	/* where are WNN_SENTOU and WNN_GIJI gone to ? */
	for_ret_status_bkwd = (cur_bun->dai_end)? WNN_NOT_CONNECT_BK : WNN_CONNECT_BK;


	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {

		return(-1);
	}


	snd_env_head(env,JS_HENKAN_IKEIJI);
	JS_Put4Com(fuku, env->js_id);		/* ʣͥ */
	JS_Put4Com(nhinsi, env->js_id);		/* Ѵʻ */
	for(i = 0; i < loop; i++)
		JS_Put4Com(hlist[i], env->js_id);	/* Ѵʻֹ */
	JS_Put4Com(henkan, env->js_id);		/* Ѵ */
	putwscom(yomi, env->js_id);
	put_fzk_vec(hinsi,fzk,vec,vec1, env->js_id);
	JS_Put4Com(vec2, env->js_id);
	/* need fugokugo-len, hinsi, etc */
	put_val = (int) (cur_bun->yomilen - cur_bun->jirilen);
	JS_Put4Com(put_val, env->js_id);
	JS_Put4Com(cur_bun->hinsi, env->js_id);

	/* more */
	JS_Put4Com( cur_bun->hyoka, env->js_id);
	/* for ret_sho_hyoka in jserver */
	JS_Put4Com( cur_bun->daihyoka, env->js_id);
	/* for ret_hyoka in jserver */
	JS_Put4Com( for_ret_status /* (wnn_sho_bunsetsu*)->status */ , env->js_id);
	/* for ret_status in jserver */
	JS_Put4Com( for_ret_status_bkwd /* (wnn_sho_bunsetsu*)->status_bkwd */ , env->js_id);
	/* for int ret_status_bkwd in jserver */
	JS_Put4Com( cur_bun->kangovect, env->js_id);
	/* for ret_kangovect in jserver */
	/* Ѵɤʸ򥵡Ф   Ϥ */
	putwscom(yomi_orig, env->js_id);
	/* for ret_yomi_orig[i] in jserver */
	JS_Put4Com( cur_bun->jirilen, env->js_id);
	/* for ret_jirilen_orig in jserver */
	JS_Put4Com( cur_bun->yomilen, env->js_id);
	/* for ret_yomilen_orig in jserver */
	JS_Put4Com( cur_bun->kanjilen, env->js_id);
	/* for ret_kanjilen_orig in jserver */
	JS_Put4Com( cur_bun->real_kanjilen, env->js_id);
	/* for ret_real_kanjilen_orig in jserver */

	snd_flush(env->js_id);

	switch(henkan) {
	case WNN_IKEIJI_DAI:
		x = rcv_dai(rb, env->js_id);
		break;
	default:
		x = get4com(env->js_id);
		env_wnn_errorno_set= get4com(env->js_id);
	}

	return x;
}
/* end of js_ikeiji_with_data */


/*:::DOC_START
 *
 *    Function Name: js_yosoku_init
 *
 *    Description  : ͽ¬ 
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_init(struct wnn_env *env)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	if (env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	snd_env_head(env,JS_YOSOKU_INIT);
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_set_param
 *
 *    Description  : ͽ¬Ķ
 *
 *    Parameter    : 
 *         env                : (In) Ķǡ
 *         learn_flag         : (In) ͽ¬ؽ(=1)  ʤ(=0)
 *         max_disp           : (In) ͽ¬ɽ (110)
 *         last_is_first_flag : (In) ǽͥ褹(=1) ʤ(=0)
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_set_param(struct wnn_env *env, int learn_flag, int max_disp, int last_is_first_flag)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	if (env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_SET_PARAM);

	/* ѥ᡼  */
	JS_Put4Com(learn_flag, env->js_id);
	JS_Put4Com(max_disp, env->js_id);
	JS_Put4Com(last_is_first_flag, env->js_id);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_free
 *
 *    Description  : ͽ¬ǡ 
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_free(struct wnn_env *env)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	snd_env_head(env, JS_YOSOKU_FREE);
	snd_flush(env->js_id);

	x=get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;
}

int ykYosokuKouhoNum = 0;		/* ͽ¬ */
char **ykYosokuKouho = NULL;	/* ͽ¬(ʸ) */

/*:::DOC_START
 *
 *    Function Name: js_yosoku_yosoku
 *
 *    Description  : ͽ¬ 
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *         yosoku_moji : (In) ʸ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_yosoku(struct wnn_env *env, char *yosoku_moji)
{

	register int i, j;
	int x;
	int kanjisize;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env, JS_YOSOKU_YOSOKU);

	/* Сʸ */
	putscom(yosoku_moji, env->js_id);

	/* Хåեեå  */
	snd_flush(env->js_id);

	/* С饹ơ */
	x = get4com(env->js_id);
	if(x != 0){
		env_wnn_errorno_set = get4com(env->js_id);  /* 顼NO  */
		return(-1);
	}

	/* ⤷ͽ¬ΰݺ(free˺) Ǥаö */
	if (ykYosokuKouhoNum != 0 || ykYosokuKouho != NULL)
		js_yosoku_kouho_free();

	/* Сͽ¬ */
	ykYosokuKouhoNum = get4com(env->js_id);
	if (ykYosokuKouhoNum < 0) {
		env_wnn_errorno_set = WNN_YOSOKU_ETC_ERROR;
		return (-1);
	}
	if (ykYosokuKouhoNum == 0)
		return(0);  /* ｪλ */

	ykYosokuKouho = (char **)calloc(ykYosokuKouhoNum, sizeof(char *));
	if (ykYosokuKouho == NULL) {
		/* ɤ */
		for (i = 0; i < ykYosokuKouhoNum; i++) {
			kanjisize = get4com(env->js_id);
			for (j = 0; j < kanjisize; j++)
				get1com(env->js_id);
		}
		ykYosokuKouhoNum = 0;
		env_wnn_errorno_set = WNN_MALLOC_ERR;
		return (-1);
	}

	/* ͽ¬ʬ롼פơͽ¬̤ */
	for (i = 0; i < ykYosokuKouhoNum; i++) {
		kanjisize = get4com(env->js_id);
		ykYosokuKouho[i] = (char *)calloc(kanjisize + 1, sizeof(char));
		if (ykYosokuKouho[i] == NULL) {
			/* ޤǤʬ */
			for (j = 0; j < i; j++)
				free(ykYosokuKouho[j]);
			/* 椫ɤ */
			for (j = 0; j < kanjisize; j++)
				get1com(env->js_id);
			for (i=i+1 ; i < ykYosokuKouhoNum; i++) {
				kanjisize = get4com(env->js_id);
				for (j = 0; j < kanjisize; j++)
					get1com(env->js_id);
			}
			ykYosokuKouhoNum = 0;
			free(ykYosokuKouho);
			env_wnn_errorno_set = WNN_MALLOC_ERR;
			return (-1);
		}
		getscom(ykYosokuKouho[i], env->js_id, kanjisize + 1);
	}

	return(0);  /* ｪλ */

}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_kouho_free()
 *
 *    Description  : ͽ¬ǡΰβ
 *
 *    Parameter    : ʤ
 *                      
 *    Return value : ʤ
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
void js_yosoku_kouho_free()
{
	register int i;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return;

	for (i = 0; i < ykYosokuKouhoNum; i++)
		if (ykYosokuKouho[i] != NULL)
			free(ykYosokuKouho[i]);

	free(ykYosokuKouho);

	ykYosokuKouhoNum = 0;
	ykYosokuKouho = NULL;
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_toroku
 *
 *    Description  : ͽ¬ Ͽ
 *
 *    Parameter    : 
 *         env          : (In) Ķǡ
 *         bunsetsu_num : (In) Ͽʸ
 *         ykbun        : (In) Ͽʸ¤ΤؤΥݥ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_toroku(struct wnn_env *env, int bunsetsu_num, struct wnn_yosoku_bunsetsu *ykbun)
{
	register int i;
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env, JS_YOSOKU_TOROKU);

	/* Сʸ  */
	JS_Put4Com(bunsetsu_num, env->js_id);

	/* Сʸ  */
	for(i = 0; i < bunsetsu_num; i++){
		putscom(ykbun[i].yomi, env->js_id); /* ɤʸ  */
		JS_Put4Com(ykbun[i].jirilen, env->js_id);	/* ΩĹ    */
		putscom(ykbun[i].kanji, env->js_id); /* ʸ  */
		JS_Put4Com(ykbun[i].real_kanjilen, env->js_id); /* ʬĹ  */
		JS_Put4Com(ykbun[i].hinsi, env->js_id); /* ʻ        */
	}

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_selected_cand
 *
 *    Description  : ͽ¬
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *         selectpos   : (In) 
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_selected_cand(struct wnn_env *env, int selectpos)
{

	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_SELECTED_CAND);

	/* 򤵤줿֤  */
	JS_Put4Com(selectpos, env->js_id);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x >= 0) {
		return(x);
	} else {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}

}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_delete_cand
 *
 *    Description  : ͽ¬
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *         selectpos   : (In) 
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_delete_cand(struct wnn_env *env, int selectpos)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_DELETE_CAND);

	/* 򤵤줿֤  */
	JS_Put4Com(selectpos, env->js_id);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;

}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_cancel_latest_toroku
 *
 *    Description  : ľϿǡ
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_cancel_latest_toroku(struct wnn_env *env)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_CANCEL_LATEST_TOROKU);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;

}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_reset_pre_yosoku
 *
 *    Description  : ͽ¬󥯥ꥢ
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_reset_pre_yosoku(struct wnn_env *env)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_RESET_PRE_YOSOKU);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;

}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_ikkatsu_toroku
 *
 *    Description  : Ͽ (ɽʸ)
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *         toroku_data : (In) Ͽǡ
 *         size        : (In) ǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_ikkatsu_toroku(struct wnn_env *env, char *toroku_data, int size)
{
	int x;
	register int i, data;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_IKKATSU_TOROKU);

	/* ǡ򥵡С */
	JS_Put4Com(size, env->js_id);

	/* ǡ򥵡С */
	for(i=0; i<size; i++){
		data = (int)*(toroku_data + i) & 0xff;
		JS_Put1Com(data, env->js_id);
	}

	/* Хåեեå  */
	snd_flush(env->js_id);

	/* С饹ơ */
	x = get4com(env->js_id);
	if (x != 0){
		env_wnn_errorno_set = get4com(env->js_id);  /* 顼NO  */
		return(-1);
	}

	/* ｪλ */
	return(0);

}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_ikkatsu_toroku_init
 *
 *    Description  : Ͽ
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_ikkatsu_toroku_init(struct wnn_env *env)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_IKKATSU_TOROKU_INIT);
	snd_flush(env->js_id);

	/* С饹ơ */
	x=get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}

	/* ｪλ */
	return(0);
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_ikkatsu_toroku_end
 *
 *    Description  : Ͽλ
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_ikkatsu_toroku_end(struct wnn_env *env)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	if(env==0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_IKKATSU_TOROKU_END);
	snd_flush(env->js_id);

	/* С饹ơ */
	x=get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}

	/* ｪλ */
	return(0);
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_save_datalist
 *
 *    Description  : ͽ¬ǡ¸
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_save_datalist(struct wnn_env *env)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_SAVE_DATALIST);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;

}


/*:::DOC_START
 *
 *    Function Name: js_yosoku_init_time_keydata
 *
 *    Description  : Ͽϻ֤ν
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_init_time_keydata(struct wnn_env *env)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_INIT_TIME_KEYDATA);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_init_inputinfo
 *
 *    Description  : ϻ֤˴Ϣѿ
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_init_inputinfo(struct wnn_env *env)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_INIT_INPUTINFO);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_set_user_inputinfo 
 *
 *    Description  : Ͽ򥻥å
 *
 *    Parameter    : 
 *         env         : (In) Ķǡ
 *         allkey      : (In) ͽ¬ޤ᤿Ͽ
 *         userkey     : (In) 桼ºݤϤϿ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_set_user_inputinfo(struct wnn_env *env, int allkey, int userkey)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_SET_USER_INPUTINFO);

	/* ͽ¬ޤ᤿Ͽ  */
	JS_Put4Com(allkey, env->js_id);

	/* 桼ºݤϤϿ  */
	JS_Put4Com(userkey, env->js_id);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_set_timeinfo
 *
 *    Description  : ϻ֤򥻥å
 *
 *    Parameter    : 
 *         env           : (In) Ķǡ
 *         yosokuselect  : (In) 򤵤Ƥ뤫ե饰
 *         throughyosoku : (In) 򤷤ե饰
 *         inputtime     : (In) ϻ
 *         keylen        : (In) Ĺ
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_set_timeinfo(struct wnn_env *env, int yosokuselect, int throughyosoku, unsigned int inputtime, int keylen)
{
	int x;

	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_SET_TIMEINFO);

	/* ѥ᡼  */
	JS_Put4Com(yosokuselect, env->js_id);
	JS_Put4Com(throughyosoku, env->js_id);
	JS_Put4Com((int)inputtime, env->js_id);
	JS_Put4Com(keylen, env->js_id);

	/* Хåեեå  */
	snd_flush(env->js_id);

	x = get4com(env->js_id);
	if (x != 0) {
		env_wnn_errorno_set = get4com(env->js_id);
		return -1;
	}
	return 0;
}

/*:::DOC_START
 *
 *    Function Name: js_yosoku_status
 *
 *    Description  : ͽ¬Ψǡ
 *
 *    Parameter    : 
 *         env           : (In) Ķǡ
 *         ykinfo        : (Out) ͽ¬Ψǡ¤
 *                  
 *    Return value : 
 *         0           = ｪλ
 *        -1           = 顼
 *
 *    Revision history: Ver 1.00
 *
 *:::DOC_END
 */
int js_yosoku_status(struct wnn_env *env, struct wnn_yosoku_info *ykinfo)
{
	/* Ф Wnn7 Ǥʤϲ⤷ʤ */
	if(!CHECK_VERSION_WNN7) return(0);

	/* ĶIDФ */
	if(env == 0) return(-1);
	set_current_js(env->js_id);

	handler_of_jserver_dead_env(env);
	if(env_wnn_errorno_eql) {
		return(-1);
	}

	/* ̻Ҥ򥵡С */
	snd_env_head(env,JS_YOSOKU_STATUS);

	/* Хåեեå  */
	snd_flush(env->js_id);

	ykinfo->nTotalRod = get4com(env->js_id);
	ykinfo->nTotalAllKey = get4com(env->js_id);
	ykinfo->nTotalUserKey = get4com(env->js_id);
	ykinfo->nTotalRot = get4com(env->js_id);
	ykinfo->nTotalAllTime = get4com(env->js_id);
	ykinfo->nTotalUserTime = get4com(env->js_id);
	ykinfo->st_mday = get4com(env->js_id);
	ykinfo->st_hour = get4com(env->js_id);
	ykinfo->st_min = get4com(env->js_id);
	ykinfo->lt_mday = get4com(env->js_id);
	ykinfo->lt_hour = get4com(env->js_id);
	ykinfo->lt_min = get4com(env->js_id);
	ykinfo->nTotalRoYkInput = get4com(env->js_id);
	ykinfo->nTotalAllYkKey = get4com(env->js_id);
	ykinfo->nNowRod = get4com(env->js_id);
	ykinfo->nNowAllKey = get4com(env->js_id);
	ykinfo->nNowUserKey = get4com(env->js_id);
	ykinfo->nNowRot = get4com(env->js_id);
	ykinfo->nNowAllTime = get4com(env->js_id);
	ykinfo->nNowUserTime = get4com(env->js_id);
	ykinfo->nTimePerOneKey = get4com(env->js_id);

	return 0;
}

/*:::DOC_START
 *
 *  Function Name   :   js_assoc_with_data()
 *  Description     :   ϢѴprotocol
 *
 *  Parameter       :
 *      env         :   Ķؤpointer
 *      fuku        :   ʣͥflag
 *      nhinsi      :   ꤵ줿ʻο
 *      hlist       :   ʻlist
 *      henkan      :   Ѵμ
 *      yomi        :   ɤ
 *      hinsi       :   ľʸʻ
 *      fzk         :   ľʸ°
 *      vec         :   vector
 *      vec1        :   vector
 *      vec2        :   vector
 *      cur_bun     :   оʸ
 *      yomi_orig   :   ȤȤɤ
 *      rb_l        :   Ѵ̤֤¤
 *
 *  Return Value    :   serverο
 *  Revision History:
 *
 *:::DOC_END
 */
int
js_assoc_with_data(env, fuku, nhinsi, henkan, yomi, hinsi,
fzk, vec, vec1, vec2, cur_bun, yomi_orig, rb_l)
struct wnn_env *env;
int fuku, nhinsi, henkan;
w_char  *yomi;
int hinsi;
w_char  *fzk;
int vec, vec1, vec2;
WNN_BUN *cur_bun;
w_char  *yomi_orig;
struct wnn_ret_buf *rb_l;
{
	int sbncnt;

	if(env==0) return(-1);
	set_current_js(env->js_id);
	handler_of_jserver_dead_env(env);

	if(env_wnn_errorno_eql) {
		return(-1);
	}

	snd_env_head(env,JS_HENKAN_ASSOC);
	/* Ѵʸ */
	putwscom(yomi, (ARGS *)(env->js_id));
	put_fzk_vec(hinsi,fzk,vec,vec1, (ARGS *)(env->js_id));
	/* ѴμΩʻ */
	JS_Put4Com(cur_bun->hinsi, (ARGS *)env->js_id);
	/* for ret_kangovect in jserver */
	/* Ѵɤʸ򥵡Ф   Ϥ */
	putwscom(yomi_orig, (ARGS *)env->js_id);
	/* for ret_yomi_orig[i] in jserver */
	/* ѴμΩɤߤĹ */
	JS_Put4Com(cur_bun->jirilen, (ARGS *)env->js_id);
	/* for ret_jirilen_orig in jserver */
	/* ѴɤߤĹ */
	JS_Put4Com(cur_bun->yomilen, (ARGS *)env->js_id);
	/* for ret_yomilen_orig in jserver */
	/* ѴɤߤĹ */
	JS_Put4Com(cur_bun->kanjilen, (ARGS *)env->js_id);
	/* for ret_kanjilen_orig in jserver */
	/* ѴμΩĹ */
	JS_Put4Com(cur_bun->real_kanjilen, (ARGS *)env->js_id);
	/* for ret_real_kanjilen_orig in jserver */

	snd_flush((ARGS *)env->js_id);

	sbncnt = rcv_sho(rb_l, (ARGS *)(env->js_id));

	return sbncnt;
}
/* End of js_assoc_with_data() */

/*:::DOC_START
 *
 *  Function Name   :   js_set_henkan_hinsi_group()
 *  Description     :   Ѵ˻ȤȤʤʻꤹ롣
 *
 *  Parameter       :
 *      env         :   ĶؤΥݥ
 *      hinsi       :   ʻֹ
 *      start       :   ʣʻ줬ΡʻֹϰϤƬ
 *      end         :   ʣʻ줬ΡʻֹϰϤ
 *      use         :   True:Ȥ FalSe:Ȥʤ
 *
 *  Return Value    :   0==SUCCESS, -1==ERROR
 *  Revision History:
 *
 *:::DOC_END
 */
int
js_set_henkan_hinsi_group(env, hinsi, start, end, use)
struct wnn_env_int *env;
int hinsi;
int start;
int use;
{
	int *hlist;
	int ii;
	int nhinsi;
	int ret;

	if (start > end)
		return -1;
	hlist = (int *)malloc((1 + end - start + 1 + 1) * sizeof(int));
	if (!hlist)
		return -1;

	nhinsi = 0;
	hlist[nhinsi++] = hinsi;
	for (ii = start; ii <= end ; ii++)
		hlist[nhinsi++] = ii;
	hlist[nhinsi] = 0;

	/* use == FALSE Ѵ˻Ѥʤʻˤ */
	if (!use)
		nhinsi *= -1;
	if(js_set_henkan_hinsi(env, 1, nhinsi, hlist) < 0)
		ret = -1;
	else
		ret = 0;
	free(hlist);
	return ret;
}
