/*
 * Mesa 3-D graphics library
 * Version:  6.5
 *
 * Copyright (C) 2006  Brian Paul   All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#if !defined SLANG_LINK_H
#define SLANG_LINK_H

#include "slang_compile.h"

#if defined __cplusplus
extern "C" {
#endif

enum
{
	SLANG_SHADER_VERTEX,
	SLANG_SHADER_FRAGMENT,
	SLANG_SHADER_MAX
};

typedef struct
{
	slang_export_data_quant *quant;
	char *name;
	GLuint address[SLANG_SHADER_MAX];
} slang_uniform_binding;

typedef struct
{
	slang_uniform_binding *table;
	GLuint count;
} slang_uniform_bindings;

typedef struct
{
	slang_export_data_quant *quant;
	char *name;
} slang_active_uniform;

typedef struct
{
	slang_active_uniform *table;
	GLuint count;
} slang_active_uniforms;

typedef struct
{
	slang_export_data_quant *quant;
	GLuint frag_address;
} slang_texture_usage;

typedef struct
{
	slang_texture_usage *table;
	GLuint count;
} slang_texture_usages;

GLvoid slang_texture_usages_ctr (slang_texture_usages *);
GLvoid slang_texture_usages_dtr (slang_texture_usages *);

enum
{
	SLANG_COMMON_FIXED_MODELVIEWMATRIX,
	SLANG_COMMON_FIXED_PROJECTIONMATRIX,
	SLANG_COMMON_FIXED_MODELVIEWPROJECTIONMATRIX,
	SLANG_COMMON_FIXED_TEXTUREMATRIX,
	SLANG_COMMON_FIXED_NORMALMATRIX,
	SLANG_COMMON_FIXED_MODELVIEWMATRIXINVERSE,
	SLANG_COMMON_FIXED_PROJECTIONMATRIXINVERSE,
	SLANG_COMMON_FIXED_MODELVIEWPROJECTIONMATRIXINVERSE,
	SLANG_COMMON_FIXED_TEXTUREMATRIXINVERSE,
	SLANG_COMMON_FIXED_MODELVIEWMATRIXTRANSPOSE,
	SLANG_COMMON_FIXED_PROJECTIONMATRIXTRANSPOSE,
	SLANG_COMMON_FIXED_MODELVIEWPROJECTIONMATRIXTRANSPOSE,
	SLANG_COMMON_FIXED_TEXTUREMATRIXTRANSPOSE,
	SLANG_COMMON_FIXED_MODELVIEWMATRIXINVERSETRANSPOSE,
	SLANG_COMMON_FIXED_PROJECTIONMATRIXINVERSETRANSPOSE,
	SLANG_COMMON_FIXED_MODELVIEWPROJECTIONMATRIXINVERSETRANSPOSE,
	SLANG_COMMON_FIXED_TEXTUREMATRIXINVERSETRANSPOSE,
	SLANG_COMMON_FIXED_NORMALSCALE,
	SLANG_COMMON_FIXED_DEPTHRANGE,
	SLANG_COMMON_FIXED_CLIPPLANE,
	SLANG_COMMON_FIXED_POINT,
	SLANG_COMMON_FIXED_FRONTMATERIAL,
	SLANG_COMMON_FIXED_BACKMATERIAL,
	SLANG_COMMON_FIXED_LIGHTSOURCE,
	SLANG_COMMON_FIXED_LIGHTMODEL,
	SLANG_COMMON_FIXED_FRONTLIGHTMODELPRODUCT,
	SLANG_COMMON_FIXED_BACKLIGHTMODELPRODUCT,
	SLANG_COMMON_FIXED_FRONTLIGHTPRODUCT,
	SLANG_COMMON_FIXED_BACKLIGHTPRODUCT,
	SLANG_COMMON_FIXED_TEXTUREENVCOLOR,
	SLANG_COMMON_FIXED_EYEPLANES,
	SLANG_COMMON_FIXED_EYEPLANET,
	SLANG_COMMON_FIXED_EYEPLANER,
	SLANG_COMMON_FIXED_EYEPLANEQ,
	SLANG_COMMON_FIXED_OBJECTPLANES,
	SLANG_COMMON_FIXED_OBJECTPLANET,
	SLANG_COMMON_FIXED_OBJECTPLANER,
	SLANG_COMMON_FIXED_OBJECTPLANEQ,
	SLANG_COMMON_FIXED_FOG,
	SLANG_COMMON_FIXED_MAX
};

enum
{
	SLANG_VERTEX_FIXED_POSITION,
	SLANG_VERTEX_FIXED_POINTSIZE,
	SLANG_VERTEX_FIXED_CLIPVERTEX,
	SLANG_VERTEX_FIXED_COLOR,
	SLANG_VERTEX_FIXED_SECONDARYCOLOR,
	SLANG_VERTEX_FIXED_NORMAL,
	SLANG_VERTEX_FIXED_VERTEX,
	SLANG_VERTEX_FIXED_MULTITEXCOORD0,
	SLANG_VERTEX_FIXED_MULTITEXCOORD1,
	SLANG_VERTEX_FIXED_MULTITEXCOORD2,
	SLANG_VERTEX_FIXED_MULTITEXCOORD3,
	SLANG_VERTEX_FIXED_MULTITEXCOORD4,
	SLANG_VERTEX_FIXED_MULTITEXCOORD5,
	SLANG_VERTEX_FIXED_MULTITEXCOORD6,
	SLANG_VERTEX_FIXED_MULTITEXCOORD7,
	SLANG_VERTEX_FIXED_FOGCOORD,
	SLANG_VERTEX_FIXED_FRONTCOLOR,
	SLANG_VERTEX_FIXED_BACKCOLOR,
	SLANG_VERTEX_FIXED_FRONTSECONDARYCOLOR,
	SLANG_VERTEX_FIXED_BACKSECONDARYCOLOR,
	SLANG_VERTEX_FIXED_TEXCOORD,
	SLANG_VERTEX_FIXED_FOGFRAGCOORD,
	SLANG_VERTEX_FIXED_MAX
};

enum
{
	SLANG_FRAGMENT_FIXED_FRAGCOORD,
	SLANG_FRAGMENT_FIXED_FRONTFACING,
	SLANG_FRAGMENT_FIXED_FRAGCOLOR,
	SLANG_FRAGMENT_FIXED_FRAGDATA,
	SLANG_FRAGMENT_FIXED_FRAGDEPTH,
	SLANG_FRAGMENT_FIXED_COLOR,
	SLANG_FRAGMENT_FIXED_SECONDARYCOLOR,
	SLANG_FRAGMENT_FIXED_TEXCOORD,
	SLANG_FRAGMENT_FIXED_FOGFRAGCOORD,
	SLANG_FRAGMENT_FIXED_MAX
};

enum
{
	SLANG_COMMON_CODE_MAIN,
	SLANG_COMMON_CODE_MAX
};

typedef struct
{
	slang_uniform_bindings uniforms;
	slang_active_uniforms active_uniforms;
	slang_texture_usages texture_usage;
	GLuint common_fixed_entries[SLANG_SHADER_MAX][SLANG_COMMON_FIXED_MAX];
	GLuint vertex_fixed_entries[SLANG_VERTEX_FIXED_MAX];
	GLuint fragment_fixed_entries[SLANG_FRAGMENT_FIXED_MAX];
	GLuint code[SLANG_SHADER_MAX][SLANG_COMMON_CODE_MAX];
	slang_machine *machines[SLANG_SHADER_MAX];
	slang_assembly_file *assemblies[SLANG_SHADER_MAX];
} slang_program;

GLvoid slang_program_ctr (slang_program *);
GLvoid slang_program_dtr (slang_program *);

GLboolean _slang_link (slang_program *, slang_translation_unit **, GLuint);

#ifdef __cplusplus
}
#endif

#endif

