/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: basesitebuild.cpp,v 1.4.4.1 2004/07/09 01:59:28 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxcom.h"
#include "hxtypes.h"
#include "hxwintyp.h"

#ifdef _WINDOWS
#include "winsite.h"
#include "winroot.h"
#include "winsurf.h"

#if defined (HELIX_FEATURE_VS2)
#include "winsurf2.h"
#endif

#endif

#if defined(_MACINTOSH) || defined(_MAC_UNIX)
#include "platform/mac/macsite.h"
#include "platform/mac/macroot.h"
#include "platform/mac/macsurf.h"
#endif

#if defined(_UNIX) && !defined(_MAC_UNIX)
#include "hlxclib/string.h"
#include "unixsite.h"
#include "unixroot.h"
#include "unixsurf.h"
#endif

CHXBaseSite* CHXBaseSite::CreateSite(IUnknown* pContext, 
				     IUnknown* pUnkOuter, 
				     INT32 lZorder)
{
// need to create OS spcific subclass
#if defined(_WINDOWS)
    return new CHXWinSite(pContext, pUnkOuter, lZorder);    
#elif defined (_MACINTOSH) || defined(_MAC_UNIX)
    return new CHXMacSite(pContext, pUnkOuter, lZorder);
#elif defined(_UNIX) && !defined(_MAC_UNIX)
    return new CHXUnixSite(pContext, pUnkOuter, lZorder);
#else
    return new CHXBaseSite(pContext, pUnkOuter, lZorder);    
#endif
}

/*static*/
CBaseRootSurface*
CBaseRootSurface::Create(IUnknown* pContext, CHXBaseSite* pSite)
{
#if defined(_WINDOWS)
    return new CWinBaseRootSurface(pContext, pSite);
#elif defined(_UNIX) && !defined(_MAC_UNIX)
    return new CUnixRootSurf(pContext, pSite);
#elif defined(_MACINTOSH) || defined(_MAC_UNIX)
    return new CMacRootSurface(pContext, pSite);
#endif   

}

/*static*/
CBaseSurface* CBaseSurface::Create(IUnknown* pContext, CHXBaseSite* pSite)
{
    CBaseSurface* pSurf = NULL;
#if defined(_WINDOWS)
# if defined (HELIX_FEATURE_VS2)
    pSurf = new CWinSurface2(pContext, pSite );
# else  
    pSurf = new CWinSurface(pContext, pSite );
# endif                                         
#elif defined(_UNIX) && !defined(_MAC_UNIX)
    pSurf = new CUnixSurf(pContext, pSite);
#elif defined(_MACINTOSH) || defined(_MAC_UNIX)
    pSurf = new CMacSurface(pContext, pSite);
#endif   

    if (pSurf)
    {
	pSurf->InitSurface(pContext);
    }
    
    return pSurf;
}
