/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: testembedder.c,v 1.1.16.3 2004/07/09 01:48:51 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <stdlib.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xatom.h>


#define HXPLAY "dbg/hxplay"

int run_player(void)
{
    pid_t pid;
    int result;
    int sv[2];
    char str_fd[32];
    
    // PF_INET is an alternative here
    result = socketpair(PF_LOCAL, SOCK_STREAM, IPPROTO_IP, sv);
    if(result < 0)
    {
	perror("socketpair");
	return result;
    }
    
    pid = fork();
    if(pid < 0)
    {
        // Error
        close(sv[0]);
        close(sv[1]);
        return pid;
    }
    else if(pid == 0)
    {
	/* We're the child */
//        close(sv[0]); 
		
	snprintf(str_fd, sizeof(str_fd), "%d", sv[1]);
        
        // The child -- exec helixplay, searching the path
	printf("Sending child fd %s\n", str_fd);
        result = execlp(HXPLAY, "hxplay", "--embedded", str_fd, NULL);
        if(result < 0)
        {
            perror("execlp");
            _exit(EXIT_FAILURE);
        }
    }
    else
    {
        int pos = 0;

        printf("Forked %d\n", pid);
        
        // The parent 
//        close(sv[1]); // close writing end
    }

    printf("Returning fd %d\n", sv[0]);
    return sv[0];    
}

gulong create_socket_window(void)
{
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *socket;

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      (GtkSignalFunc) gtk_main_quit, NULL);

    gtk_window_set_title (GTK_WINDOW (window), "Test Embedded");
    gtk_container_set_border_width (GTK_CONTAINER (window), 0);
    gtk_window_resize (GTK_WINDOW (window), 100, 100);
    
    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), vbox);

    socket = gtk_socket_new ();
    gtk_box_pack_start(GTK_BOX(vbox), socket, TRUE, TRUE, 0);

    gtk_widget_show_all (window);

    return gtk_socket_get_id (GTK_SOCKET(socket));
}

int
main (int argc, char *argv[])
{
    int fd_command;
    FILE *f;
    XID xid;
    int result, i;
    gchar *command;
    
    gtk_init(&argc, &argv);

    xid = create_socket_window();

    printf("Writing 0x%08x\n", xid);

    fd_command = run_player();
    if(fd_command < 0)
    {
        return EXIT_FAILURE;
    }

//    printf("Press a key...\n");
//    getchar();
    
    command = g_strdup_printf("SetWindow 0 %d 0 0 0 0 0 0 0 0 0\n", xid);
    
    result = write(fd_command, command, strlen(command));
    printf("Wrote %d\n", result);

    g_free(command);
    
    //f = fdopen(fd_command, "rw");
    //fwrite(&xid, sizeof(xid), 1, f);

    gtk_main();

    return EXIT_SUCCESS;
}
