/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: macsite.h,v 1.5.20.2 2004/07/09 01:58:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _MACSITE_H_
#define _MACSITE_H_

#include "hxslist.h"
#include "hxmap.h"
#include "chxpckts.h"
#include "hxwin.h"
#include "hxsite2.h"
#include "hxcomm.h"
#include "hxengin.h"

#include "basesite.h"

#ifdef THREADS_SUPPORTED
#ifndef _MAC_MACHO
#include <Multiprocessing.h>
#endif
#endif

struct IHXCoreMutex;
struct IHXMacBlitMutex;
struct IHXClientEngine;

#define USE_CARBON_TIMER


void SetOriginAndMaintainClipRgn(short horizOffset, short vertOffset);


class CHXMacSite : public CHXBaseSite
{
public:
	friend class	CMacRootSurface;
	friend class	CMacSurface;
			CHXMacSite(IUnknown* pContext, IUnknown* pUnkOuter = NULL, INT32 lZOrder = 0);
	virtual		~CHXMacSite();
	
    STDMETHOD_(HXxWindow*,GetWindow)(THIS);
    //HXxWindow*		GetWindow();
	
protected:
    virtual void	_NeedWindowedSite();
    virtual void	_AttachWindow();
    virtual void	_DetachWindow();
    virtual void*	_Create(void* ParentWindow, UINT32 style);
    virtual void	_Destroy(HXxWindow* pWindow);
    virtual void	_SetSize(HXxSize size);
    virtual void	_SetPosition(HXxPoint position);
    virtual void	_DamageRect(HXxRect rect);
    virtual void        _DamageRegion(HXxRegion rgn);
    virtual BOOL	_ShouldEnterForceRedraw();
    virtual void	_ExitForceRedraw();
    virtual void	_SendOSUpdateMessage();
    virtual void	_ShowSite(BOOL bShow);
    virtual BOOL	_AtSystemTime();
    virtual HX_RESULT	_EventOccurred(HXxEvent* pEvent);
    virtual void	_GetDeviceCaps(void* hdc, UINT16& uBytesPerPixel, UINT16& uHorizRes, UINT16& uVertRes);
    virtual void	_GetWindowRect(HXxRect* destRect);
    virtual void	_DestroySliders();
    virtual BOOL	_HandleOSEvents(HXxEvent* pEvent);
public:
    static void		_HandleAllOSEvents(HXxEvent* pEvent);
    static RgnHandle	_ConvertRegionToMacRegion(HXREGION* pRegion);
protected:
    virtual BOOL        _ConvertToHXEvent( HXxEvent* pEvent );
    virtual void	_GenerateOSEvent(HXxEvent* pEvent, HXxEvent* pEvent2);
    virtual void	_GenerateSetCursorEvent();
    virtual void	_ScaleFullScreen(HXxWindow* pWindow);
    virtual HX_RESULT	_EnterFullScreen();
    virtual HX_RESULT	_ExitFullScreen();
    virtual HX_RESULT	_TestFullScreen(void* hTestBitmap, const char* pszStatusText);
    virtual void	_TryCreateXSlider();
    virtual void	_SetXSliderValues(INT32 range, INT32 pageSize);
    virtual void	_TryCreateYSlider();
    virtual void	_SetYSliderValues(INT32 range, INT32 pageSize);
    virtual void	_GetSystemSizeOfSliders(INT32* pWidth, INT32* pHeight);
    virtual BOOL	_IsWindowVisible();
	    void	ShowMacControl(ControlHandle theControl, BOOL bShow);
	    void	SetMacControlRectangle(ControlHandle,
	    			INT32 left, INT32 top, INT32 right, INT32 bottom);
	    void	SetMacControlRange(ControlHandle theControl, INT32 controlMax);
    virtual void	_ShowXSlider(BOOL bShow);
    virtual void	_MoveXSlider(INT32 left, INT32 top, INT32 right, INT32 bottom, BOOL bRedraw);
    virtual void	_ShowYSlider(BOOL bShow);
    virtual void	_MoveYSlider(INT32 left, INT32 top, INT32 right, INT32 bottom, BOOL bRedraw);
    virtual BOOL	_DoesXSliderExist();
    virtual void*	_GetContainingWindow();
    virtual void	_GetCursorPos(HXxPoint* pPoint);
    virtual void	_MapPointToOSWindow(HXxPoint* pPt, void** pWindowHandle);
    virtual void*	_GetWindowWithCursor();
    virtual void	_ReInitPrimarySurface();
    virtual BOOL	_MoveWindow(void*, INT32 X, INT32 Y, INT32 nWidth, INT32 nHeight, BOOL bRepaint);
    virtual BOOL	_UpdateWindow(void* hWnd);
    virtual BOOL	_ShowWindow(void* hWnd, INT32 nCmdShow);
    virtual BOOL	_SetWindowPos(void* hWnd, void* hWndInsertAfter, INT32 X, INT32 Y, INT32 cx, INT32 cy, INT32 uFlags);
    virtual BOOL	_SetWindowRgn(void* hWnd, HXREGION* hRgn, BOOL bRedraw);
    virtual void	_SetFocus(void* pWindow);
    
	    void	GetMacContentAreaOffset(REF(HXxPoint) offset );
    
private:

    class MacSiteRedrawCallback : public IHXCallback
    {
    private:
	LONG32		m_lRefCount;
	
			~MacSiteRedrawCallback();
		PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

    public:
    			MacSiteRedrawCallback(CHXMacSite* pMacSite);
    	
    	// IUnknown methods
    	STDMETHOD(QueryInterface) (THIS_ REFIID riid, void** ppvObj);
    	STDMETHOD_(ULONG32, AddRef) (THIS);
    	STDMETHOD_(ULONG32, Release) (THIS);
    	
    	// IHXCallback methods
    	STDMETHOD(Func) (THIS);
    	
    	// MacSiteRedrawCallback stuff
    	CallbackHandle	m_ulMacSiteRedrawCallbackPendingID;
    	CHXMacSite*	m_pMacSite;
    };
    
    MacSiteRedrawCallback*	m_pMacSiteRedrawCallback;

protected:

    ControlHandle	m_hHScrollBar;
    ControlHandle	m_hVScrollBar;
    ControlActionUPP	m_ScrollBarActionProc;
    INT32		m_nHorizPageSize;
    INT32		m_nVertPageSize;
    
    GrafPtr		m_RememberMacPort;
    
    BOOL		m_bCreatedOSWindow;
    
    HXxPoint		m_MostRecentConvertedMouseLoc;
    
    static CHXSimpleList	zm_ListOfMacSites;
    static BOOL			zm_bFullScreenActive;
    HXxWindow*			m_pHXxFullScreenWindow;
    double			m_fStretchMultiple;
    static Ptr			zm_pRememberFullScreenInformation;
    
    BOOL			m_bInternalResizeOnFullscreen;
    HXxSize			m_RememberNonFullscreenSize;
    HXxPoint			m_RememberNonFullscreenPosition;
    
    BOOL			m_bThisOrAChildHasBlitted;
#ifdef THREADS_SUPPORTED

#ifdef USE_CARBON_TIMER
#ifdef _MAC_MACHO
    CFRunLoopTimerRef		m_RedrawCFTimerRef;
    CFRunLoopTimerContext	m_RedrawCFTimerContext;
    
    static void			RedrawCFTimer(CFRunLoopTimerRef, CHXMacSite* pMacSite);
#else
    // keep Carbon Timer around for CFM builds since I
    // think CFTimers need mach-o -- at least, that's
    // the implication of the callback when creating
    // a new CFTimer.
    EventLoopTimerRef		m_RedrawCarbonTimerRef;
    EventLoopTimerUPP		m_RedrawCarbonTimerUPP;

    static void			RedrawCarbonTimer(EventLoopTimerRef, CHXMacSite* pMacSite);
#endif
#endif
    
    IHXCoreMutex*		m_pIHXCoreMutex;
    IHXClientEngine*		m_pClientEngine;

#endif
};


#endif
