#ifndef __chxmimemanager_h
#define __chxmimemanager_h


#include "hxtypes.h"
#include "hxcom.h"
#include "hxplugn.h"
#include "hxmap.h"


_INTERFACE IHXMimeAssocManager;
_INTERFACE IHXFileFormatObject;


class CHXMimeManager
{
 public:
    CHXMimeManager();
    virtual ~CHXMimeManager();

    // setup/shutdown
    HX_RESULT Init(IUnknown* pContext);
    void      Reset();
    void      Reload();
    void      Commit();

    // get a mime database by name
    IHXMimeAssocManager* GetMimeAssocManager(const char* pName);

    // get a file format by mime type
    IHXFileFormatObject* GetFileFormat(const char* pMimeType);

    // iterate through known mime databases
    POSITION GetFirstMimeAssocManager(REF(const char*) pName, 
				      REF(IHXMimeAssocManager*) pMimeMgr);
    POSITION GetNextMimeAssocManager(POSITION p,
				     REF(const char*) pName,
				     REF(IHXMimeAssocManager*) pMimeMgr);

    // iterate through known mime types
    POSITION GetFirstFileFormat(REF(const char*) pMimeType, 
				REF(IHXFileFormatObject*) pFileFormat);
    POSITION GetNextFileFormat(POSITION p,
			       REF(const char*) pMimeType, 
			       REF(IHXFileFormatObject*) pFileFormat);

    // ensure all file formats are configured in all mime databases
    void SetupAllFileFormats(const char* pIconPath, BOOL bOverride);

    // ensure a file format is configured in all known mime databases
    void SetupFileFormat(IHXFileFormatObject* pFileFormat,
			 const char* pIconPath,
			 BOOL bOverride);

    // ensure a mime type is configured in all known mime databases
    void SetupMimeType(const char*  pMimeType,
		       const char** ppExtensions,
		       const char** ppOpenNames,
		       const char*  pIconPath,
		       BOOL bOverride);

    // ensure a protocol is configured in all known mime databases
    void SetupProtocol(const char* pMimeType,
		       const char* pProtocol,
		       const char* pDescription,
		       const char* pIconPath);


    // ensure an app is configured in all known mime databases
    void SetupApp(const char* pAppId,
		  const char* pName, 
		  const char* pCommand, 
		  BOOL bCanOpenMultiple,
		  BOOL bRequiresTerminal);
    
    // ensure an app is associated in all known mime databases
    void SetAssoc(const char* pMime, const char* pApp, BOOL bOverride);

    // ensure an app is associated with all (substr) matching mime types
    void SetMatchingAssocs(const char* pMatch, 
			   const char* pApp,
			   BOOL bOverride);

    // ensure all mime type(s) for a file format object are configured in
    // a specific mime database
    static void SetupFileFormat(IHXMimeAssocManager* pMimeMgr,
				IHXFileFormatObject* pFileFormat,
				const char* pIconPath,
				BOOL bOverride);

    // ensure a mime type is configured in a *specific* mime database
    static void SetupMimeType(IHXMimeAssocManager* pMimeMgr,
			      const char*  pMimeType,
			      const char** ppExtensions,
			      const char** ppOpenNames,
			      const char*  pIconPath,
			      BOOL bOverride);

    // ensure a protocol is configured in a specific mime database
    static void SetupProtocol(IHXMimeAssocManager* pMimeMgr,
			      const char* pMimeType,
			      const char* pProtocol,
			      const char* pDescription,
			      const char* pIconPath);

    // ensure an app is configured in a *specific* mime database
    static void SetupApp(IHXMimeAssocManager* pMimeMgr,
			 const char* pAppId,
			 const char* pName,
			 const char* pCommand,
			 BOOL bCanOpenMultiple,
			 BOOL bRequiresTerminal);

    // ensure an app is associated in a *specific* mime database
    static void SetAssoc(IHXMimeAssocManager* pMimeMgr,
			 const char* pMime,
			 const char* pApp,
			 BOOL bOverride);

 protected:
    CHXMapStringToOb m_mapMimeTypes;
    CHXMapStringToOb m_mapMimeMgrs;
};



#endif /* #ifndef __chxmimemanager_h */
