#
# ***** BEGIN LICENSE BLOCK *****
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s): See changelog
# 
# ***** END LICENSE BLOCK *****
# 

%define desktop_file_utils_version 0.9

Summary:        RealPlayer 10 for Linux
Name:           RealPlayer
Version:        10.0.5
Release:        1
Group:          Applications/Multimedia
License:        RPSL, EULA
URL:            http://www.real.com/linux
Source:         install.bz2
Obsoletes:      G2player, RealOne, HelixPlayer
ExcludeArch:    x86_64 ppc64 ppc s390 s390x ia64
BuildRoot:      %{_tmppath}/%{name}-%{version}-buildroot
Patch1:         RealPlayer-helixlibs.patch
PreReq:         desktop-file-utils >= %{desktop_file_utils_version}

%description
RealPlayer is a media player providing solid media playback locally 
and via streaming. It plays RealAudio, RealVideo, MP3, 3GPP Video, 
Flash, SMIL 2.0, JPEG, GIF, PNG, RealPix and RealText and 
more. The RealPlayer 10 for Linux builds on top of the popular 
GPL/RPSL Helix Player 1.0.

%prep
%setup -q -c -n realplay-10.0.5
%patch1 -p1 -b .helixlibs

%build

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/{16x16,32x32,48x48,192x192}/{apps,mimetypes}
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/mime/packages
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/applications
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/pixmaps
mkdir -p $RPM_BUILD_ROOT/%{_bindir}
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/helix
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/helix/share
cp -a ./codecs $RPM_BUILD_ROOT/%{_libdir}/helix
cp -a ./common $RPM_BUILD_ROOT/%{_libdir}/helix
cp -a ./plugins $RPM_BUILD_ROOT/%{_libdir}/helix
cp -a ./share/default $RPM_BUILD_ROOT/%{_libdir}/helix/share
cp -a ./share/realplay $RPM_BUILD_ROOT/%{_libdir}/helix/share
cp ./README $RPM_BUILD_ROOT/%{_libdir}/helix
cp ./LICENSE $RPM_BUILD_ROOT/%{_libdir}/helix

for LANGUAGE in de es fr hi it ja ko pl pt_BR zh_CN zh_TW; do
    mkdir -p $RPM_BUILD_ROOT/%{_datadir}/locale/$LANGUAGE/LC_MESSAGES
    mkdir -p $RPM_BUILD_ROOT/%{_libdir}/helix/share/locale/$LANGUAGE
    cp "./share/locale/$LANGUAGE/player.mo" "$RPM_BUILD_ROOT/%{_datadir}/locale/$LANGUAGE/LC_MESSAGES/realplay.mo"
    cp "./share/locale/$LANGUAGE/widget.mo" "$RPM_BUILD_ROOT/%{_datadir}/locale/$LANGUAGE/LC_MESSAGES/libgtkhx.mo"
    cp "./share/locale/$LANGUAGE/README" "$RPM_BUILD_ROOT/%{_libdir}/helix/share/locale/$LANGUAGE"
    cp "./share/locale/$LANGUAGE/LICENSE" "$RPM_BUILD_ROOT/%{_libdir}/helix/share/locale/$LANGUAGE"
done

for SIZE in "48x48" "192x192" ; do
    for MIME in \
        "application-ram"     \
        "application-rpm"     \
        "application-rm"      \
        "text-realtext"	      \
        "audio-mp4"           \
        "audio-ra"            \
        "video-rv" ; do
        ICON="./share/icons/mime-${MIME}_$SIZE.png"
        cp "$ICON" "$RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/$SIZE/mimetypes/realplay-${MIME}.png"
    done
done

for SIZE in "16x16" "32x32" "48x48" "192x192" ; do
    cp ./share/icons/realplay_${SIZE}.png $RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/${SIZE}/apps/realplay.png
done

cp ./share/realplay.png $RPM_BUILD_ROOT/%{_datadir}/pixmaps
cp ./share/realplay.desktop $RPM_BUILD_ROOT/%{_datadir}/applications
cp ./share/realplay.xml $RPM_BUILD_ROOT/%{_datadir}/mime/packages/realplay.xml

cp ./mozilla/nphelix.so $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins
cp ./mozilla/nphelix.xpt $RPM_BUILD_ROOT/%{_libdir}/mozilla/plugins

cp ./realplay.bin $RPM_BUILD_ROOT/%{_libdir}/helix
cp ./realplay $RPM_BUILD_ROOT/%{_libdir}/helix
ln -s %{_libdir}/helix/realplay $RPM_BUILD_ROOT/usr/bin

%clean
rm -rf $RPM_BUILD_ROOT

%post
update-desktop-database %{_datadir}/applications

%postun
update-desktop-database %{_datadir}/applications

%files
%defattr(-,root,root)
%{_bindir}/realplay
%{_libdir}/helix/*
%{_libdir}/mozilla/*
%{_datadir}/icons/hicolor/*
%{_datadir}/pixmaps/*
%{_datadir}/applications/realplay.desktop
%{_datadir}/mime/packages/*
%{_datadir}/pixmaps/*.png
%{_datadir}/locale/*/LC_MESSAGES/*

%changelog
* Fri May 13 2005 Ryan Gammon <rgammon@real.com> 10.0.5-1
- Updating to 10.0.5

* Wed Mar 23 2005 Ryan Gammon <rgammon@real.com> 10.0.4-1
- Updating to 10.0.4

* Thu Feb 10 2005 Ryan Gammon <rgammon@real.com> 10.0.3-1
- Updating to 10.0.3

* Tue Dec 07 2004 Ryan Gammon <rgammon@real.com> 10.0.2-1pre1
- Updating to 10.0.2

* Tue Oct 05 2004 Ryan Gammon <rgammon@real.com> 10.0.1-2
- Switching over to using the binary tarball instead of the
- source tarball -- RealNetworks requires that it build
- the bits that get shipped.
- Adding translations and new mime realplay.xml file.

* Mon Oct 04 2004 Colin Walters <walters@redhat.com> 10.0.1-1
- Update to 10.0.1
- Drop upstreamed HelixPlayer-1.0.beta20040615-mmx-clobber.patch
- Drop HelixPlayer-1.0.beta20040615-desktop.patch per request
- Drop upstreamed HelixPlayer-1.0-filechooser.patch
- Drop upstreamed HelixPlayer-1.0-clobberedx.patch

* Thu Sep 30 2004 Christopher Aillon <caillon@redhat.com> 10-5
- PreReq desktop-file-utils >= 0.9

* Tue Sep 14 2004 Colin Walters <walters@redhat.com> 10-4
- Add patch from Real to fix math64.h compilation
- Invoke update-desktop-database in post and postun, in
  preparation for fixing .desktop file for mime system
- Address some issues from #130744, thanks Ling Li:
  - Do release build
  - Install release binary
  - Fix typo in png installation
- Remove hack for installing debug ogg format

* Mon Aug 23 2004 Colin Walters <walters@redhat.com> 10-3
- Install README and LICENSE (#130209).

* Mon Aug 09 2004 Colin Walters <walters@redhat.com> 10-2
- Put mozilla plugins in correct directory (#129305)

* Wed Aug 04 2004 Colin Walters <walters@redhat.com> 10-1
- Bump version to 10, to override existing realplayer 8.

* Tue Aug 03 2004 Colin Walters <walters@redhat.com> 1.0.gold-1
- Fork from HelixPlayer

* Mon Aug 02 2004 Colin Walters <walters@redhat.com> 1.0.gold-1
- Update to gold
- Use setup -n to set directory instead of repacking tarball
- Switch bif target to bingo-gold-free

* Thu Jul 29 2004 Colin Walters <walters@redhat.com> 1.0.beta20040615-6
- Rework Summary a bit
- Minor spec cleanups

* Mon Jul 26 2004 Colin Walters <walters@redhat.com> 1.0.beta20040615-5
- Add patch to port to GtkFileChooser
- ExcludeArch ppc

* Fri Jul 16 2004 Colin Walters <walters@redhat.com> 1.0.beta20040615-4
- Restore MIME icon installation into hicolor directory 

* Fri Jul 16 2004 Colin Walters <walters@redhat.com> 1.0.beta20040615-3
- Add patch to fix desktop file name
- Set build failure color to "green" to exit on any error
- Add smp_mflags variable for parallel building

* Thu Jul 15 2004 Colin Walters <walters@redhat.com> 1.0.beta20040615-2
- BR latest theora
- More spec file bits
- Install logo for real

* Mon Jul 12 2004 Colin Walters <walters@redhat.com> 1.0.beta20040615-1
- Some spec file cleanups

* Mon Jun 8 2004 Ryan Gammon <rgammon@real.com>
- Adding /usr/share/pixmap, document icons

* Mon Jun 7 2004 Nicholas Hart <nhart@real.com>
- added .mime/.keys/.applications files

* Wed May 5 2004 Ryan Gammon <rggammon@helixcommunity.org>
- Updating icons

* Thu Jan 13 2004  Nicholas Hart <nhart@helixcommunity.org>
- tweaked some paths to deal with tarball generated by player/installer/app
- changed, reformatted some of the package info

* Sat Dec 27 2003 Thomas Chung <tchung@linuxinstall.org> 0.2.0.0-20031224
- First RPM build for Fedora Core 1
