#!/bin/sh

LOGFILE=$1

( 
    cd .. 
    INSTDIR=`pwd`
    DEFPREFIX=/usr/local

    echo "configure system-wide symbolic links? [Y/n]: "
    read DOSYMLINKS
    echo ""

    if [ -z "$DOSYMLINKS" -o "$DOSYMLINKS" = "y" -o "$DOSYMLINKS" = "Y" ] ; then

	echo "enter the prefix for symolic links [$DEFPREFIX]: "
	read PREFIX
	echo ""

	test -z "$PREFIX" && PREFIX=$DEFPREFIX

	if [ -f $INSTDIR/hxplay ] ; then
	    echo "Setting up hxplay symlinks in $PREFIX..."
	    test -L $PREFIX/share/hxplay && rm -f $PREFIX/share/hxplay
	    ln -s $INSTDIR/share $PREFIX/share/hxplay
	    test -L $PREFIX/bin/hxplay && rm -f $PREFIX/bin/hxplay
	    ln -s $INSTDIR/hxplay $PREFIX/bin/hxplay
	    test -L $PREFIX/lib/hxplay && rm -f $PREFIX/lib/hxplay
	    ln -s $INSTDIR/lib $PREFIX/lib/hxplay
	fi
	if [ -f $INSTDIR/realplay ] ; then
	    echo "Setting up realplay symlinks in $PREFIX..."
	    test -L $PREFIX/share/realplay && rm -f $PREFIX/share/realplay
	    ln -s $INSTDIR/share $PREFIX/share/realplay
	    test -L $PREFIX/bin/realplay && rm -f $PREFIX/bin/realplay
	    ln -s $INSTDIR/realplay $PREFIX/bin/realplay
	    test -L $PREFIX/lib/realplay && rm -f $PREFIX/lib/realplay
	    ln -s $INSTDIR/lib $PREFIX/lib/realplay
	fi
    fi

    echo ""
)
