/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: HXEventRecordUtils.m,v 1.2.6.3 2004/07/09 01:49:35 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#import "HXEventRecordUtils.h"
#include "CHXClientDebug.h"

@implementation HXEventRecordUtils

+ (id)alloc
{
	CHXASSERT( NO ); // @"Why is an HXEventRecordUtils being allocated?"
	return nil;
}

+ (Point)convertToPoint:(NSPoint)nativePt
{
	Point point;
	point.h = nativePt.x;
	NSScreen* mainScreen = [NSScreen mainScreen]; // XXXSEH: Is this correct? Doc.'s indicate that this is the screen with the key window. Odd?
	NSRect mainFrame = [mainScreen frame];
	point.v = NSHeight( mainFrame ) - nativePt.y;
	return point;
}

+ (void)createNullEvent:(EventRecord *)classicEvent
{
	classicEvent->what = nullEvent;
	classicEvent->when = ( double ) 60 * GetCurrentEventTime();
	classicEvent->message = 0; // Undefined.
	classicEvent->modifiers = GetCurrentKeyModifiers();
	classicEvent->where = [HXEventRecordUtils convertToPoint:[NSEvent mouseLocation]];
}

+ (void)convertEvent:(NSEvent *)theEvent toEventRecord:(EventRecord *)classicEvent
{
	classicEvent->when = ( double ) 60 * [theEvent timestamp];
	
	classicEvent->modifiers = 0;
	unsigned int modifierFlags = [theEvent modifierFlags];
	if ( modifierFlags & NSAlphaShiftKeyMask )	classicEvent->modifiers |= alphaLock;
	if ( modifierFlags & NSShiftKeyMask )		classicEvent->modifiers |= shiftKey;
	if ( modifierFlags & NSControlKeyMask )		classicEvent->modifiers |= controlKey;
	if ( modifierFlags & NSAlternateKeyMask )	classicEvent->modifiers |= optionKey;
	if ( modifierFlags & NSCommandKeyMask )		classicEvent->modifiers |= cmdKey;
	if ( [theEvent buttonNumber] != 0 )			classicEvent->modifiers |= btnState;
	
	NSEventType eventType = [theEvent type];
	switch ( eventType )
	{
		case NSLeftMouseDown:
		case NSRightMouseDown:
		case NSOtherMouseDown:
		{
			classicEvent->what = mouseDown;
			classicEvent->message = 0; // Undefined.
			classicEvent->where = [HXEventRecordUtils convertToPoint:[[theEvent window] convertBaseToScreen:[theEvent locationInWindow]]];
			if ( eventType == NSRightMouseDown ) classicEvent->modifiers |= controlKey; // Fake a control click.
		}
		break;

		case NSLeftMouseUp:
		case NSRightMouseUp:
		case NSOtherMouseUp:
		{
			classicEvent->what = mouseUp;
			classicEvent->message = 0; // Undefined.
			classicEvent->where = [HXEventRecordUtils convertToPoint:[[theEvent window] convertBaseToScreen:[theEvent locationInWindow]]];
			if ( eventType == NSRightMouseDown ) classicEvent->modifiers |= controlKey; // Fake a control click.
		}
		break;
		
		case NSMouseMoved:
		case NSLeftMouseDragged:
		case NSRightMouseDragged:
		case NSOtherMouseDragged:
		case NSMouseEntered:
		case NSMouseExited:
		{
			classicEvent->what = osEvt; // XXXSEH: Is this the best event to set?
			classicEvent->message = mouseMovedMessage << 24;
			classicEvent->where = [HXEventRecordUtils convertToPoint:[[theEvent window] convertBaseToScreen:[theEvent locationInWindow]]];
		}
		break;
		
		case NSKeyDown:
		case NSKeyUp:
		{
			classicEvent->what = ( eventType == NSKeyDown ) ? ( [theEvent isARepeat] ? autoKey : keyDown ) : keyUp;
			UInt8 keyCode  = [theEvent keyCode];
			UInt8 charCode = *[[theEvent charactersIgnoringModifiers] lossyCString]; // XXXSEH: Is this the best way?
			classicEvent->message = ( keyCode << 8 ) | charCode;
			classicEvent->where = [HXEventRecordUtils convertToPoint:[NSEvent mouseLocation]];
		}
		break;
		
		default:
		{
			classicEvent->what = nullEvent;
			classicEvent->message = 0; // Undefined.
			classicEvent->where = [HXEventRecordUtils convertToPoint:[NSEvent mouseLocation]];
		}
		break;
	}
}

@end
