/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: IHXClientPlayer.h,v 1.11.2.3 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _IHX_CLIENT_PLAYER_H_
#define _IHX_CLIENT_PLAYER_H_

#include "enter_hx_headers.h"
#include "hxcom.h"
#include "hxwintyp.h"
#include "exit_hx_headers.h"

#include "HXClientCallbacks.h"

#include "hlxclib/assert.h"

_INTERFACE IHXClientEngine;
_INTERFACE IHXPlayer;

class IHXClientPlayer
{
private:

    LONG32 m_lCount;
	
public:

	IHXClientPlayer( void )
		: m_lCount( 0 ) {}
	virtual ~IHXClientPlayer( void ) {}
		
	ULONG32 AddRef( void )
	{
		return InterlockedIncrement( &m_lCount );
	}
	ULONG32 Release( void )
	{
		assert( m_lCount > 0 );
		if ( InterlockedDecrement( &m_lCount ) > 0 )
		{
			return m_lCount;
		}
		delete this;
		return 0;
	}

    /* IHXClientPlayer methods */
	virtual HX_RESULT GetHXClientEngine( IHXClientEngine** ppIClientEngine ) = 0;
	virtual HX_RESULT GetHXPlayer( IHXPlayer** ppIPlayer ) = 0;
	virtual HX_RESULT OpenURL( const char* pURL, const char* pMimeType ) = 0;
	virtual HX_RESULT OpenData( const char* pURL, const char* pMimeType, UINT32 dataLength, bool autoPlay, void** ppOutData ) = 0;
	virtual HX_RESULT WriteData( void* pData, UINT32 bufferLength, unsigned char* pBuffer ) = 0;
	virtual void CloseData( void* pData ) = 0;
	virtual bool GetOpenedURL( char* pURLBuffer, UINT32 bufferLength, UINT32* pUsedBufferLength ) const = 0;
	virtual bool CanViewSource( void ) = 0;
	virtual void ViewSource( void ) = 0;
	virtual bool CanViewRights( void ) = 0;
	virtual void ViewRights( void ) = 0;
	virtual HX_RESULT Authenticate( bool shouldValidateUser, const char* pUsername, const char* pPassword ) = 0;
	virtual int GetContentState( void ) const = 0;
	virtual bool SetStatus( const char* pStatus ) = 0;
	virtual void Play( void ) = 0;
	virtual void Pause( void ) = 0;
	virtual void Stop( void ) = 0;
	virtual bool StartSeeking( void ) = 0;
	virtual HX_RESULT SetPosition( UINT32 position ) = 0;
	virtual void StopSeeking( void ) = 0;
	virtual UINT32 GetPosition( void ) const = 0;
	virtual UINT32 GetLength( void ) const = 0;
	virtual bool IsLive( void ) const = 0;
	virtual const char* GetTitle( void ) const = 0;
	virtual const char* GetContextURL( void ) const = 0;
	virtual bool HasVisualContent( void ) const = 0;
	virtual void GetIdealSize( INT32* pSiteIdealWidth, INT32* pSiteIdealHeight ) const = 0;
	virtual INT32 GetClipBandwidth( void ) const = 0;
	virtual void SetSize( INT32 siteWidth, INT32 siteHeight ) = 0;
	virtual UINT16 GetSourceCount( void ) const = 0;
	virtual UINT16 GetGroupCount( void ) const = 0;
	virtual UINT16 GetCurrentGroup( void ) const = 0;
	virtual bool GetGroupURL( UINT16 groupIndex, char* pURLBuffer, UINT32 bufferLength, UINT32* pUsedBufferLength ) const = 0;
	virtual bool GetGroupTitle( UINT16 groupIndex, char* pTitleBuffer, UINT32 bufferLength, UINT32* pUsedBufferLength ) const = 0;
	virtual HX_RESULT SetCurrentGroup( UINT16 groupIndex ) = 0;
	virtual void DrawSite( const HXxRect* pSiteRect ) = 0;
	virtual void SetVolume( UINT16 volume ) = 0;
	virtual UINT16 GetVolume( void ) const = 0;
	virtual void Mute( bool shouldMute ) = 0;
	virtual bool IsMuted( void ) const = 0;
	virtual void EnableEQ( bool enable ) = 0;
	virtual bool IsEQEnabled( void ) const = 0;
	virtual void SetEQGain( int band, INT32 gain ) = 0;
	virtual INT32 GetEQGain( int band ) const = 0;
	virtual void SetEQPreGain( INT32 preGain ) = 0;
	virtual INT32 GetEQPreGain( void ) const = 0;
	virtual void EnableEQAutoPreGain( bool enable ) = 0;
	virtual bool IsEQAutoPreGainEnabled( void ) const = 0;
	virtual void SetEQReverb( INT32 roomSize, INT32 reverb ) = 0;
	virtual void GetEQReverb( INT32* pRoomSize, INT32* pReverb ) const = 0;
	virtual bool GetVideoAttribute( int attributeKey, float* pAttributeValue ) const = 0;
	virtual bool SetVideoAttribute( int attributeKey, float attributeValue ) = 0;
	virtual bool GetStatistic( const char* pStatisticKey, unsigned char* pValueBuffer, UINT32 bufferLength, int* pValueType, UINT32* pUsedBufferLength ) = 0;
	virtual bool AddStatisticObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo ) = 0;
	virtual void RemoveStatisticObserver( const char* pStatisticKey, const HXStatisticsCallbacks* pStatisticsCallbacks, void* observerInfo ) = 0;
};

#endif
