/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXClientSiteSupplier.h,v 1.6.2.4 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CHXCLIENT_SITE_SUPPLIER_H_
#define _CHXCLIENT_SITE_SUPPLIER_H_

#include "CHXClientUnknown.h"

#include "enter_hx_headers.h"
#include "hxwintyp.h"
#include "hxwin.h" // IHXSiteSupplier
#include "hxvctrl.h"

#include "hxsmartptr.h"
HX_SMART_POINTER_INLINE( SPIHXVideoControl, IHXVideoControl );
#include "exit_hx_headers.h"

#include "HXClientCallbacks.h"

class CHXFlatArray;
_INTERFACE IHXPlayer;

class CHXClientSiteSupplier : public IHXSiteSupplier
{
    DECLARE_UNKNOWN_NOCREATE( CHXClientSiteSupplier )
	
private:

	friend class CHXClientSite;
	
	LONG32 m_lCount;
	IHXPlayer* m_pIHXCorePlayer;
	
    // The core is only gonna keep a pointer to the HXxWindow, so we need to keep this allocated as long as the site is valid
    HXxWindow* m_pHXxWindow;
	void* m_UserInfo;
	const HXClientCallbacks* m_pClientCallbacks;
    CHXClientSite* m_pSiteContainer;
	CHXFlatArray* m_pSites;
    HXxSize m_IdealSize;
	bool m_HadVisualContent;

	void OnChangedIdealSize( CHXClientSite* pSite, const HXxSize& newIdealSiteSize );
	HXxWindow* GetHXxWindow( void ) const
	{
		return m_pHXxWindow;
	}

public:

    virtual ~CHXClientSiteSupplier( void );
    CHXClientSiteSupplier( IHXPlayer* pIHXPlayer, HXxWindow* pHXxWindow, void* userInfo, const HXClientCallbacks* pClientCallbacks );

	// IHXSiteSupplier
	STDMETHOD ( SitesNeeded ) ( THIS_ UINT32 uReqestID, IHXValues* pSiteProps );
	STDMETHOD ( SitesNotNeeded ) ( THIS_ UINT32 uReqestID );
	STDMETHOD ( BeginChangeLayout ) ( THIS );
	STDMETHOD ( DoneChangeLayout ) ( THIS );
	
	bool HasVisualContent( void ) const
	{
		// This value sync.'s up with what the user was last notified of.
		return m_HadVisualContent;
	}
	void GetIdealSize( HXxSize& siteIdealSize ) const
	{
		siteIdealSize = m_IdealSize;
	}
	void SetSize( const HXxSize& siteSize );
	bool SetStatus( const char* pStatus );
	void DrawSite( const HXxRect& siteRect );
	SPIHXVideoControl GetVideoControl( void ) const;
};

#endif
