/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: error.cpp,v 1.1.2.3 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */


#include "error.h"

#include "commonapp.h"

#include "hxgerror.h"


typedef struct
{
    GladeXML* xml;
    
} HXErrorDialog;


static void
hxplay_error_dialog_destroy(GtkWidget* /* widget */,
                            HXErrorDialog* dialog)
{
    glade_xml_destroy (dialog->xml);

    g_free(dialog);
}


GtkDialog*
hxplay_error_dialog_new(guint        hxcode,
                        guint        user_code,
                        const gchar* error_string,
                        const gchar* user_string,
                        const gchar* more_info_url)
{
    GladeXML *xml;
    GtkWidget *dialog;
    gchar *filename;
    GtkWidget* label;
    GError* error;
    HXErrorDialog* info = NULL;
    
    error = hx_error_new(hxcode, user_code, error_string, user_string, more_info_url);
    
    filename = hxcommon_locate_file("error.glade");
    xml = glade_xml_new (filename, NULL, NULL);
    g_free(filename);
    g_return_val_if_fail(xml != NULL, NULL);

    dialog = glade_xml_get_widget (xml, "hxplayer_error_dialog");
    label = glade_xml_get_widget (xml, "hed_error_label");

    g_object_set_data(G_OBJECT(dialog), "error_code", (gpointer)hxcode);
    
    g_return_val_if_fail(dialog != NULL && label != NULL, NULL);

    gtk_label_set_text(GTK_LABEL(label), error->message);

    info = g_new0(HXErrorDialog, 1);
    info->xml = xml;
    
    g_signal_connect (G_OBJECT (dialog), "destroy",
                      G_CALLBACK (hxplay_error_dialog_destroy),
                      info);

    g_error_free(error);

    return GTK_DIALOG(dialog);
}
