/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: prodinstlib.h,v 1.2.2.2 2004/07/09 02:02:49 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _PRODINSTLIB_H_
#define _PRODINSTLIB_H_

class ConsoleUI;

/***********************************************************************
 * defines
 */
#define PROG PACKAGE_NAME

#ifdef _WIN32
#define PATH_MAX MAX_PATH
#define OS_SEPARATOR_CHAR '\\'

#define random() rand()
#define srandom(i) srand(i)
#define mkdir(n,p) mkdir(n)

#elif defined _UNIX 
#define OS_SEPARATOR_CHAR '/'
#endif /* _UNIX */

#define DEFAULT_USERNAME "letmein"

class ProductInstaller
{
public:
    ProductInstaller();
    virtual ~ProductInstaller();

    virtual void Init(void);
    virtual void SetDefaults(void);
    virtual void ParseCmdLine(int argc, const char* argv[]);
    virtual int  RandomPort(int nMin, int nMax);
    virtual int  GenerateRandomPort(int nMin, int nMax, int pUsedPorts[]);
    virtual void GenerateRandomPasswords(void);
    virtual void UpdatePasswordDatabases();
    virtual void CreateConfigFile(const char* szOutputCfg);
    virtual char* FormatConfigFile(void) = 0;
    virtual int  ReadInstallerDefaults(const char* szFile);
    static  const char* VersionBanner(void);
    virtual void SetDefaultDir(char* &szDestDir);
    static  BOOL GetLocalHostName(char* &szHostname);
    virtual void BackupOldFiles(void);
    virtual void BackupIfPresent(const char* szFile);
    virtual void CleanUp(const char* szDestDir);
    virtual void CleanUpAndExit(int nErr, ConsoleUI* pCUI);
    virtual int System(const char* szCmd);


    // note - this is for reading an _installer_ config file,
    // not a product config file
    typedef enum InstCfgType { CFG_STR, CFG_BOOL, CFG_INT } InstCfgTypeEnum;
    typedef struct
    {
        const char* szName;
        void**      ppValue;
        InstCfgType eType;
    } InstCfgItem;

    virtual int ReadInstallerConfigItems(const char*        szFile,
                                         const InstCfgItem* pCfg,
                                         ConsoleUI*         pCUI);

    typedef struct { int nPort; BOOL bSet; const char* szName; } InstPort;

    inline int GetInstPort(int nPortID) { return m_pPorts[nPortID].nPort; }
    void SetInstPort(int nPortID, int nPort);
    static BOOL ValidPort(const char* szPort, int& nPort);
    BOOL CheckDupePort(int nPort, int nPortID, const char*& szName);
    BOOL PortInUse(int nPort);
    void SetInstallLog(const char* pPath);
    const char* GetInstallLog() const { return m_szInstallLog; }

    enum
    { 
        MON_PORT = 0, 
        RTSP_PORT,
        PNA_PORT,
        HTTP_PORT,
        ADMIN_PORT,

        NUM_PORTS
    };

    InstPort* m_pPorts;
    UINT32 m_ulNumPorts;
    char* m_szAdminUser;
    char* m_szAdminPass;
    char* m_szAdminRealm;
    char* m_szEncUser;
    char* m_szEncPass;
    char* m_szEncRealm;
    char* m_szContentRealm;
    char* m_szBaseRealm;
    char* m_szMonPass;
    char* m_szOutputCfg;
    char* m_szBackupCfg;
    char* m_szInstallerConfigFile;
    char* m_szLoggingStyle;
    char* m_szHostname;
    char* m_szDestDir;
    //char* m_szConfigText;
    BOOL m_bNonInteractive;
    BOOL m_bSilent;
    BOOL m_bBackupOldFiles;
    BOOL m_bDebug;
    char* m_szInstallLog;

#ifdef _WIN32
    char* m_szArchDir;
    char* m_szServiceUser;
    char* m_szServiceName;
    char* m_szServicePass;
    BOOL m_bNTService;

    BOOL m_bWSAStarted;

    BOOL InitWinsock();
#endif // _WIN32

    ConsoleUI* m_pCUI;
};


#endif // _PRODINSTLIB_H_
