/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smlrendr.h,v 1.4.2.1 2004/07/09 01:57:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SMLRENDR_H_
#define _SMLRENDR_H_

#include "baseobj.h"

#define STREAM_MAJOR_VERSION  0
#define STREAM_MINOR_VERSION  0

#define CONTENT_MAJOR_VERSION 0
#define CONTENT_MINOR_VERSION 0

#define HANDLE_BETA1_SMIL_1_0_STREAM
// /XXXEH- HELIX TO DO: shouldn't HANDLE_SMIL_1_0_STREAM be surrounded by
// #if !defined(HELIX_FEATURE_SMIL_SMIL1) ?  If so, then this would handle
// all SMIL files, and would do so differently, in some cases, from RealPlayer
// in that it would be more SMIL 1.0 compliant due to bug fixes.  See also
// errHandler.ReportError(SMILErrorSMIL10Document...) calls that would need
// the same treatment.
#if 0 // /20010417- removed this and added in old SMIL 1.0 renderer to installer:
#define HANDLE_SMIL_1_0_STREAM
#endif

#define HANDLE_SMIL_2_0_LASTCALL_STREAM
#define HANDLE_SMIL_2_0_CANDIDATE_REC_STREAM
#define HANDLE_SMIL_2_0_STREAM

#if defined(HANDLE_SMIL_2_0_STREAM)
#define NUM_RECOGNIZED_DEFAULT_NAMESPACES   5
#else
#define NUM_RECOGNIZED_DEFAULT_NAMESPACES   4
#endif

// Forward declarations
typedef _INTERFACE IHXCommonClassFactory             IHXCommonClassFactory;
typedef _INTERFACE IHXClientEngine                   IHXClientEngine;
typedef _INTERFACE IHXPlayer                         IHXPlayer;
typedef _INTERFACE IHXStream                         IHXStream;
typedef _INTERFACE IHXValues                         IHXValues;
typedef _INTERFACE IHXPacket                         IHXPacket;
typedef _INTERFACE IHXBuffer                         IHXBuffer;
typedef _INTERFACE IHXPersistentRenderer             IHXPersistentRenderer;
typedef _INTERFACE IHXPersistentComponentManager     IHXPersistentComponentManager;
typedef _INTERFACE IHXSmilToSmilRendererCommunicator IHXSmilToSmilRendererCommunicator;
typedef _INTERFACE IHXErrorMessages                  IHXErrorMessages;
class CHXString;
class CSmilPacketParser;
class CSmilDocumentRenderer;
class CSmilDocumentPacket;


class CSmilRenderer : public IHXPlugin,
                      public IHXRenderer,
                      public IHXStatistics,
		      public IHXSmilToSmilRendererCommunicator,
		      public IHXPersistentRenderer,
		      public CHXBaseCountingObject
{
public:
    CSmilRenderer();
    virtual ~CSmilRenderer();

    IHXCommonClassFactory* getFactory()       { return m_pCommonClassFactory; }
    IHXClientEngine*       getClientEngine()  { return m_pEngine; }
    IUnknown*               getClientContext() { return m_pClientContext; }
    IHXPlayer*             getPlayer()        { return m_pPlayer; }
    CHXString&              getURLPrefix()     { return m_urlPrefix; }
    CHXString&              getURLRoot()       { return m_urlRoot; } 
    UINT32                  getGranularity()   { return m_ulGranularity; }
    HX_RESULT               HandleAddLayoutSiteGroup(IUnknown* pLSG);
    HX_RESULT               HandleRemoveLayoutSiteGroup(IUnknown* pLSG);
    HX_RESULT		    HandleAttachElementLayout(IUnknown* pLSG, IHXValues* pProps);
    void                    generatePreFix(void);
    BOOL		    isStreamProxiedByOtherRenderer() 
			    {	return m_bStreamProxiedByOtherRenderer; }

    // /These call the respective IHXRendererAdviseSink methods:
    HX_RESULT		    SmilDocTrackDurationSet(UINT32 ulGroupIndex,
				    UINT32 ulTrackIndex, UINT32 ulDuration,
				    UINT32 ulDelay, BOOL bIsLive);
    HX_RESULT		    SmilDocRepeatedTrackDurationSet(const char* pID,
				    UINT32 ulDuration, BOOL bIsLive);
    HX_RESULT		    SmilDocTrackUpdated(UINT32 ulGroupIndex,
				    UINT32 ulTrackIndex, IHXValues* pValues);
    HX_RESULT		    SmilDocRendererInitialized(IHXRenderer* pRend,
				    IUnknown* pStream, IHXValues* pInfo);
    HX_RESULT		    SmilDocRendererClosed(IHXRenderer* pRend,
				    IHXValues* pInfo);

    // /These call their respective IHXGroupSink methods:
    HX_RESULT		    SmilDocGroupAdded(UINT16 uGroupIndex,
				    IHXGroup* pGroup);
    HX_RESULT		    SmilDocGroupRemoved(UINT16 uGroupIndex,
				    IHXGroup* pGroup);
    HX_RESULT		    SmilDocAllGroupsRemoved();
    HX_RESULT		    SmilDocTrackAdded(UINT16 uGroupIndex,
				    UINT16 uTrackIndex, IHXValues* pTrack);
    HX_RESULT		    SmilDocTrackRemoved(UINT16 uGroupIndex,
				    UINT16 uTrackIndex, IHXValues* pTrack);
    HX_RESULT		    SmilDocTrackStarted(UINT16 uGroupIndex,
				    UINT16 uTrackIndex, IHXValues* pTrack);
    HX_RESULT		    SmilDocTrackStopped(UINT16 uGroupIndex,
				    UINT16 uTrackIndex, IHXValues* pTrack);
    HX_RESULT		    SmilDocCurrentGroupSet(UINT16 uGroupIndex,
				    IHXGroup* pGroup);


    // IHXPlugin methods
    STDMETHOD(GetPluginInfo) (THIS_ REF(BOOL)        bLoadMultiple,
                                    REF(const char*) pDescription,
                                    REF(const char*) pCopyright,
                                    REF(const char*) pMoreInfoURL,
                                    REF(ULONG32)     ulVersionNumber);
    STDMETHOD(InitPlugin)    (THIS_ IUnknown* pContext);

    // IUnknown methods
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)  (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    // IHXRenderer methods
    STDMETHOD(GetRendererInfo) (THIS_ REF(const char**) pStreamMimeTypes,
                                      REF(UINT32)       unInitialGranularity);
    STDMETHOD(StartStream)     (THIS_ IHXStream* pStream, IHXPlayer* pPlayer);
    STDMETHOD(EndStream)       (THIS);
    STDMETHOD(OnHeader)        (THIS_ IHXValues* pHeader);
    STDMETHOD(OnPacket)        (THIS_ IHXPacket* pPacket, LONG32 lTimeOffset);
    STDMETHOD(OnTimeSync)      (THIS_ ULONG32 ulTime);
    STDMETHOD(OnPreSeek)       (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(OnPostSeek)      (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(OnPause)         (THIS_ ULONG32 ulTime);
    STDMETHOD(OnBegin)         (THIS_ ULONG32 ulTime);
    STDMETHOD(OnBuffering)     (THIS_ ULONG32 ulFlags, UINT16 unPercentComplete);
    STDMETHOD(GetDisplayType)  (THIS_ REF(HX_DISPLAY_TYPE) ulFlags,
                                      REF(IHXBuffer*)      pBuffer);
    STDMETHOD(OnEndofPackets)  (THIS);

    // IHXStatistics methods
    STDMETHOD(InitializeStatistics) (THIS_ UINT32 ulRegistryID);
    STDMETHOD(UpdateStatistics)     (THIS);

    // IHXPersistentRenderer methods
    STDMETHOD(InitPersistent)		(THIS_
					UINT32			ulPersistentComponentID,
					UINT16			uPersistentGroupID,
					UINT16			uPersistentTrackID,
					IHXPersistentRenderer*	pPersistentParent);

    STDMETHOD(GetPersistentID)		(THIS_
					REF(UINT32) ulPersistentComponentID);

    STDMETHOD(GetPersistentProperties)	(THIS_
                               		REF(IHXValues*)    pProperties);				

    STDMETHOD(GetElementProperties)	(THIS_
					UINT16		    uGroupID,
					UINT16		    uTrackID,
                               		REF(IHXValues*)    pProperties);

    STDMETHOD(AttachElementLayout)	(THIS_
					UINT16		    uGroupID,
					UINT16		    uTrackID,
					IHXRenderer*	    pRenderer,
					IHXStream*	    pStream,
					IHXValues*	    pProps);

    STDMETHOD(DetachElementLayout)	(THIS_
					IUnknown*	    pLSG);

    STDMETHOD(GetElementStatus)		(THIS_
					UINT16		    uGroupID,
					UINT16		    uTrackID,
					UINT32		    ulCurrentTime,
					REF(IHXValues*)    pStatus);

    // IHXSmilToSmilRendererCommunicator methods:
    STDMETHOD(InitSmilStreamProxiedByOtherRenderer) (THIS_
						    IHXBuffer* pVersionNamespace);


    // CSmilRenderer methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
    static HX_RESULT STDAPICALLTYPE CanUnload2(void);

    BOOL		    m_bUseNestedMeta;

    IHXBuffer*		    m_pVersionNamespaceFromProxyRenderer;

private:
    LONG32                  m_lRefCount;
    IUnknown*               m_pContext;
    IHXStream*             m_pStream;
    IHXPlayer*             m_pPlayer;
    IHXValues*             m_pHeader;
    IHXClientEngine*       m_pEngine;
    IHXErrorMessages*      m_pErrorMessages;
    IUnknown*               m_pClientContext;
    ULONG32                 m_ulLastTime;
    UINT32		    m_ulPersistentVersion;
    PersistentType	    m_persistentType;
    UINT32                  m_ulGranularity;
    UINT16                  m_uLayoutRule;
    UINT16                  m_uSourceRule;
    CHXString               m_urlPrefix;
    CHXString               m_urlRoot;
    char*                   m_pURLFragment;
    CSmilPacketParser*      m_pPacketParser;
    CSmilDocumentRenderer*  m_pSmilDocRenderer;
    CHXString               m_smilDocument;
    UINT32                  m_ulTotalSMILPackets;
    IHXCommonClassFactory* m_pCommonClassFactory;
    HX_RESULT               m_lastOnPacketResult;
    IHXPersistentComponentManager* m_pPersistentComponentManager;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD             m_bInMetadata : 1;
    HX_BITFIELD             m_bStreamProxiedByOtherRenderer : 1;

    static const char* const zm_pName;
    static const char* const zm_pDescription;
    static const char* const zm_pCopyright;
    static const char* const zm_pMoreInfoURL;
    static const char* const zm_pStreamMimeTypes[];
    static const char* const zm_pRecognizedDefaultNamespaces[NUM_RECOGNIZED_DEFAULT_NAMESPACES + 1];

    HX_RESULT handleSMILDocumentPacket(CSmilDocumentPacket* pPacket);
    HX_RESULT getErrorString(SMILErrorTag tag, CHXString& str);
};


#endif // _SMLRENDR_H_

