/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: stream_info.cpp,v 1.2.4.2 2005/01/21 19:30:13 nhart Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#include "stream_info.h"

#include "theora_codec_info.h"
#include "vorbis_codec_info.h"

#include "debug.h" // DPRINTF()
#define D_STREAM_INFO 0 //0x2000000

const COggStreamInfo::BuildFunc 
COggStreamInfo::zm_pBuildFuncs[] = {
    &CTheoraCodecInfo::Build,
    &CVorbisCodecInfo::Build
};
        
COggStreamInfo::COggStreamInfo(UINT32 uSerialNum) :
    m_state(Start),
    m_pCodecInfo(NULL)
{
#ifdef _DEBUG
    debug_level() |= D_STREAM_INFO;
#endif // _DEBUG

    DPRINTF(D_STREAM_INFO, ("COggStreamInfo::COggStreamInfo(%u)\n", uSerialNum));

    ogg_stream_init(&m_os, (int)uSerialNum);
}

COggStreamInfo::~COggStreamInfo()
{
    DPRINTF(D_STREAM_INFO, ("COggStreamInfo::~COggStreamInfo(%u)\n", 
                         m_os.serialno));
    ogg_stream_clear(&m_os);
    HX_DELETE(m_pCodecInfo);
}

HX_RESULT 
COggStreamInfo::OnPage(ogg_page* pPage)
{
    HX_RESULT res = HXR_INVALID_PARAMETER;

    if (pPage)
    {
        int err = ogg_stream_pagein(&m_os, pPage);

        if (0 == err)
        {
            ogg_packet op;
            err = 1;
            res = HXR_OK;
            while((HXR_OK == res) && (0 < err))
            {
                err = ogg_stream_packetout(&m_os, &op);

                if (1 == err)
                {
                    res = onPacket(&op); 
                }
                else if (0 > err)
                {
                    if (m_pCodecInfo &&
                        m_pCodecInfo->AllowPacketOutError())
                    {
                        // The m_pCodecInfo object says we can
                        // ignore this error so set err to 1 so
                        // the loop continues
                        DPRINTF(D_STREAM_INFO, ("COggStreamInfo::OnPage() : ignoring ogg_stream_packetout() error\n"));
                        err = 1;
                    }
                    else
                    {
                        res = HXR_UNEXPECTED;
                    }
                }
            }
        }
        else
        {
            DPRINTF(D_STREAM_INFO, ("COggStreamInfo::OnPage() : ogg_stream_pagein() err %d\n", err));
        }
    }

    return res;
}

BOOL COggStreamInfo::HaveHeaders() const
{
    return (m_pCodecInfo) ? m_pCodecInfo->HaveHeaders() : FALSE;
}
BOOL COggStreamInfo::HaveBaseGranulePos() const
{
    return (m_pCodecInfo) ? m_pCodecInfo->HaveBaseGranulePos() : FALSE;
}

HX_RESULT 
COggStreamInfo::SetBaseTimestamp(const COggTimestamp& timestamp)
{
    HX_RESULT res = HXR_UNEXPECTED;

    if (m_pCodecInfo)
    {
        res = m_pCodecInfo->SetBaseTimestamp(timestamp);
    }

    return res;
}

static const char* z_pStreamInfoStateNames[] = {
    "Start",
    "WaitingForTSInit",
    "Ready"
};

void 
COggStreamInfo::changeState(State newState)
{
    DPRINTF(D_STREAM_INFO, ("COggStreamInfo::changeState() : %s -> %s\n",
                         z_pStreamInfoStateNames[m_state],
                         z_pStreamInfoStateNames[newState]));
    m_state = newState;
}

HX_RESULT 
COggStreamInfo::onPacket(ogg_packet* pPkt)
{
    HX_RESULT res = HXR_INVALID_PARAMETER;
    
    if (pPkt)
    {
        if (pPkt->b_o_s)
        {
            res = createCodecInfo(pPkt);
        }
        else
        {
            res = HXR_OK;
        }
        
        if (HXR_OK == res)
        {
            if (m_pCodecInfo)
            {
                res = m_pCodecInfo->OnPacket(pPkt);
            }
            else
            {
                res = HXR_UNEXPECTED;
            }
        }
    }
    return res;
}

HX_RESULT 
COggStreamInfo::createCodecInfo(ogg_packet* pPkt)
{
    DPRINTF(D_STREAM_INFO, ("COggStreamInfo::createCodecInfo()\n"));
    HX_RESULT res = HXR_INVALID_PARAMETER;
    
    if (pPkt)
    {
        switch(m_state) {
        case Start:
        {
            UINT32 uBuilderCt = sizeof(zm_pBuildFuncs) / sizeof(BuildFunc);

            for (UINT32 i = 0; !m_pCodecInfo && (i < uBuilderCt); i++)
            {
                m_pCodecInfo = zm_pBuildFuncs[i](pPkt);
                res = HXR_OK;
            }
        }break;
        default:
            res = HXR_UNEXPECTED;
            break;
        };
    }
    return res;
}
