/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: ogg_stream.h,v 1.3.4.1 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef OGG_STREAM_H
#define OGG_STREAM_H

#include "ogg/ogg.h"

#include "hxcom.h"
#include "hxresult.h"
#include "ihxpckts.h"
#include "hxccf.h"
#include "hxslist.h"

#include "codec_info.h"
class COggPayload;

typedef enum {
    ostUnknown,
    ostAudioStream,
    ostVideoStream
} OggStreamType;

class COggStream
{
public:
    COggStream();
    ~COggStream();

    HX_RESULT Init(UINT16 uStreamNum, OggStreamType type, IUnknown* pContext);
    HX_RESULT CreateStreamHeader(REF(IHXValues*) pStreamHdr);
    HX_RESULT SetCodecInfo(int serialNum, const COggCodecInfo* pCodecInfo);
    void SetIsFirstStream();

    HX_RESULT OnPage(ogg_page* pPage);
    HX_RESULT OnEndOfGroup();
    HX_RESULT OnEndOfFile();
    HX_RESULT OnSeek(UINT32 uRequestedTime);
    HX_RESULT GetStartTimestamp(COggTimestamp& timestamp);

    BOOL IsActive() const { return (m_pCodecInfo) ? TRUE : FALSE;}

    HX_RESULT NextPacketTimestamp(REF(UINT32) uTimestamp) const;
    HX_RESULT GetNextPacket(REF(IHXPacket*) pPkt);

private:
    HX_RESULT onPacket(ogg_packet* pPkt);

    HX_RESULT processUntimedPackets();
    HX_RESULT cachePacket(ogg_packet* pPkt);
    void flushUntimedPkts();

    OggStreamType m_type;
    IHXCommonClassFactory* m_pCCF;

    int m_serialNum;
    COggCodecInfo* m_pCodecInfo;

    ogg_stream_state m_os;

    COggPayload* m_pPayload;
    
    BOOL m_bNeedStartTime;
    CHXSimpleList m_untimedPkts;

    BOOL m_bIsFirstStream;
};
#endif /* OGG_STREAM_H */
