/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxmapmgr.cpp,v 1.1.26.1 2004/07/09 01:54:51 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxcom.h"

// hxmisc
#include "baseobj.h"
#include "unkimp.h"

// hxcont
#include "hxmap.h"

// pxcomlib
#include "pxmapmgr.h"

// hxdebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

PXMapManager::PXMapManager()
{
    m_lRefCount    = 0;
    m_ulNextHandle = 1;
    m_pMap         = NULL;
    m_pIterator    = NULL;
}

PXMapManager::~PXMapManager()
{
    HX_DELETE(m_pMap);
}

STDMETHODIMP PXMapManager::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (IsEqualIID(riid, IID_IUnknown))
    {
        AddRef();
        *ppvObj = (IUnknown *) this;
    }
    else
    {
        *ppvObj = NULL;
        retVal  = HXR_NOINTERFACE;
    }

    return retVal;
}

STDMETHODIMP_(UINT32) PXMapManager::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(UINT32) PXMapManager::Release()
{
    
    if (InterlockedDecrement(&m_lRefCount) > 0)
        return m_lRefCount;

    delete this;

    return 0;
}

STDMETHODIMP_(BOOL) PXMapManager::IsEntryPresent(UINT32 ulHandle)
{
    BOOL bRet = FALSE;

    if (m_pMap)
    {
        void* pVoid = NULL;
        bRet        = m_pMap->Lookup((LONG32) ulHandle, pVoid);
    }

    return bRet;
}

STDMETHODIMP PXMapManager::AddEntry(void* pEntry, REF(UINT32) rulHandle)
{
    HX_RESULT retVal = HXR_OK;

    if (pEntry)
    {
        // Create a map if we don't already have one
        if (!m_pMap)
        {
            m_pMap = new CHXMapLongToObj();
            if (!m_pMap)
            {
                retVal = HXR_OUTOFMEMORY;
            }
        }

        if (SUCCEEDED(retVal))
        {
            // Make sure we don't already have a map entry
            // for this handle
            void* pVoid    = NULL;
            BOOL  bPresent = m_pMap->Lookup((LONG32) m_ulNextHandle, pVoid);
            if (!bPresent)
            {
                // There's no current entry, so we can add this
                // to the map.
                m_pMap->SetAt((LONG32) m_ulNextHandle, pEntry);
                // Set the outgoing session handle
                rulHandle      = m_ulNextHandle;
                // Increment the session handle
                m_ulNextHandle = (m_ulNextHandle == 0x7FFFFFFF ? 1 : m_ulNextHandle + 1);
            }
            else
            {
                retVal = HXR_FAIL;
            }
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

STDMETHODIMP PXMapManager::DeleteEntry(UINT32 ulHandle, void** ppEntry)
{
    HX_RESULT retVal = HXR_OK;

    if (ppEntry && m_pMap)
    {
        void* pVoid    = NULL;
        BOOL  bPresent = m_pMap->Lookup((LONG32) ulHandle, pVoid);
        if (bPresent)
        {
            // Get the entry
            *ppEntry = pVoid;
            // Remove it from the map
            m_pMap->RemoveKey((LONG32) ulHandle);
        }
    }

    return retVal;
}

STDMETHODIMP PXMapManager::DeleteAllEntries()
{
    HX_RESULT retVal = HXR_OK;

    if (m_pMap)
    {
        m_pMap->RemoveAll();
    }

    return retVal;
}

STDMETHODIMP PXMapManager::GetEntry(UINT32 ulHandle, void** ppEntry)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pMap && ppEntry)
    {
        void* pVoid    = NULL;
        BOOL  bPresent = m_pMap->Lookup((LONG32) ulHandle, pVoid);
        if (bPresent)
        {
            // Get the entry
            *ppEntry = pVoid;
            // Make the return value ok
            retVal = HXR_OK;
        }
    }

    return retVal;
}

STDMETHODIMP PXMapManager::GetFirstEntry(REF(UINT32) rulHandle, void** ppEntry)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pMap && ppEntry)
    {
        m_pIterator = m_pMap->GetStartPosition();
        if (m_pIterator)
        {
            // Get the object pointer at the current position
            // and advance to the next position
            LONG32 lKey     = 0;
            void*  pElement = NULL;
            m_pMap->GetNextAssoc(m_pIterator, lKey, pElement);

            if (pElement)
            {
                rulHandle = (UINT32) lKey;
                *ppEntry  = pElement;
                retVal    = HXR_OK;
            }
        }
    }

    return retVal;
}

STDMETHODIMP PXMapManager::GetNextEntry(REF(UINT32) rulHandle, void** ppEntry)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pMap && ppEntry)
    {
        if (m_pIterator)
        {
            // Get the object pointer at the current position
            // and advance to the next position
            LONG32 lKey     = 0;
            void*  pElement = NULL;
            m_pMap->GetNextAssoc(m_pIterator, lKey, pElement);

            if (pElement)
            {
                rulHandle = (UINT32) lKey;
                *ppEntry  = pElement;
                retVal    = HXR_OK;
            }
        }
    }

    return retVal;
}

