/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: decoder.h,v 1.1.8.1 2004/07/09 01:50:08 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/*
 * Copyright (c) 1993-1995 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and the Network Research Group at
 *      Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef vic_decoder_h
#define vic_decoder_h

//
// Following is bare minimum to get the VIC decoder to run in place...
//

#ifdef _MACINTOSH
#   include "config.h"
#else
 #ifndef WIN32
 #  include <sys/param.h>
 #  include <sys/uio.h>
 #  include "hxtypes.h"
 #endif
#endif

#include "sys-time.h"
#include "inet.h"
#include "rv.h"
//#include "ntp-time.h"

class Renderer;
class Assistor;
class VideoWindow;

struct dmabuf {
	int shmid;
	u_char* bp;
};

class Decoder {
    public:
	virtual ~Decoder();
	Decoder(int hdrlen);
	inline int hdrlen() const { return (hdrlen_); }
	virtual void recv(BOOL bMarker,
			  const u_char* data, int len) = 0;
	inline u_int32_t delvar() const { return (delvar_); }
	inline void delvar(u_int32_t v) { delvar_ = v; }
	public:
		virtual void stats(char* wrk);

    protected:
	int hdrlen_;
	int delvar_;
 protected:
/*XXX*/
#define MAXSTAT 16
	struct statcntr {
		const char* name;
		u_int cnt;
	} stat_[MAXSTAT];
	int nstat_;
	inline void count(int statno) { ++stat_[statno].cnt; }
	inline void setstat(int statno, u_int v) { stat_[statno].cnt = v; }

	/*XXX steal back from rcvr */
	int color_;
	int decimation_;	/* 422 or 411 */
	int inw_;		/* native image width */
	int inh_;		/* native image height */

	int now_;
	u_char* rvts_;
	int nblk_;		/* number of 8x8 blocks */
	int ndblk_;	/* number of blocks decoded in most recent frame */

};

class H261Decoder : public Decoder {
    public:
	H261Decoder();
	virtual ~H261Decoder();
	virtual void info(char* wrk) const;
	virtual void recv(BOOL bMarker, const u_char* bp, int cc);
	int colorhist(u_int* hist) const;
	virtual void stats(char* wrk);
    protected:
	void decode(const u_char* vh, const u_char* bp, int cc);
	void resize(int width, int height);

	P64Decoder* codec_;
	int h261_rtp_bug_;

	// sdw added following to remove Tk type virtual callbacks
	int frame_needs_rendering_;
	int frame_needs_resizing_;
};

#define STAT_BAD_PSC	0
#define STAT_BAD_GOB	1
#define STAT_BAD_SYNTAX	2
#define STAT_BAD_FMT	3
#define STAT_FMT_CHANGE 4	/* # times fmt changed */
#define STAT_BAD_HEADER 5


#endif
