/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: siteprxy.h,v 1.1.1.1.50.1 2004/07/09 02:08:40 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SITEPRXY_H_
#define _SITEPRXY_H_

struct	IHXSiteUserSupplier;
struct  IHXSiteUser;
class	CHXSiteManager;

/****************************************************************************
 * 
 *  Class:
 *
 *	CHXSiteUserSupplierProxy
 *
 *  Purpose:
 *
 *	Proxy for IHXSiteUserSupplier so events can be hooked by
 *	IHXEventHookMgr
 *
 */
class CHXSiteUserSupplierProxy : public IHXSiteUserSupplier
{
private:
    LONG32				m_lRefCount;
    CHXSiteManager*			m_pSiteMgr;
    IHXSiteUserSupplier*		m_pSUS;
    char*				m_pRegionName;

    ~CHXSiteUserSupplierProxy		();
    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

public:
    CHXSiteUserSupplierProxy		(CHXSiteManager* pSiteMgr,
					IHXSiteUserSupplier* pSUS,
					const char* pRegionName);
    
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					REFIID riid,
					void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)		(THIS);

    STDMETHOD_(ULONG32,Release)		(THIS);

    /*
     * IHXSiteUserSupplier methods
     */
    STDMETHOD(CreateSiteUser)		(REF(IHXSiteUser*) pSiteUser);
    STDMETHOD(DestroySiteUser)		(IHXSiteUser* pSiteUser);
    STDMETHOD_(BOOL,NeedsWindowedSites)	();
};

/****************************************************************************
 * 
 *  Class:
 *
 *	CHXSiteUserProxy
 *
 *  Purpose:
 *
 *	Proxy for IHXSiteUser so events can be hooked by
 *	IHXEventHookMgr
 *
 */
class CHXSiteUserProxy : public IHXSiteUser
{
private:
    LONG32				m_lRefCount;
    CHXSiteManager*			m_pSiteMgr;
    IHXSiteUser*			m_pSU;
    IHXSite*				m_pSite;
    char*				m_pRegionName;

    ~CHXSiteUserProxy			();
    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

public:
    CHXSiteUserProxy			(CHXSiteManager* pSiteMgr,
					IHXSiteUser* pSU,
					const char* pRegionName);
    
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					REFIID riid,
					void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)		(THIS);

    STDMETHOD_(ULONG32,Release)		(THIS);

    /*
     * IHXSiteUser methods
     */
    STDMETHOD(AttachSite)		(IHXSite* pSite);
    STDMETHOD(DetachSite)		();
    STDMETHOD(HandleEvent)		(HXxEvent* pEvent);
    STDMETHOD_(BOOL,NeedsWindowedSites)	();
};

#endif // _SITEPRXY_H_
