/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxsched.h,v 1.4.32.1 2004/07/09 02:06:18 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxthread.h"

#ifndef _IHXSCHEDULER_
#define _IHXSCHEDULER_

#include "hxengin.h"

class ClientPQ;
class Timeline;
class HXMutex;
struct IUnknown;
class CHXID;

typedef struct _HXTimeval HXTimeval;

#include "timeval.h"

class CAsyncTimer;

class HXScheduler : public IHXScheduler
{
protected:
    LONG32	m_lRefCount;
    ClientPQ*	m_pScheduler;
    BOOL        m_bUseDeferredTask;

    // Is set to TRUE for most of the time except when we need to remove all
    // callbacks from the scheduler without actually exectuing the functions..
    static BOOL	m_sbProcess;
    
    /* special PQ for interrupt safe tasks */
    ClientPQ*   m_pInterruptTimeScheduler;
    CHXID*      m_pID;

    IUnknown*   m_pContext;

    /* semaphore to prevent a deferred interrupt task from interrupting
     * a system task
     */
    BOOL		m_bLocked; 

public:
			HXScheduler(IUnknown* pContext);
			~HXScheduler();

    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    /*
     * HXScheduler methods
     */
    /************************************************************************
     *	Method:
     *	    IHXScheduler::RelativeEnter
     *	Purpose:
     *	    enter objects in the service queue offset from time now
     */
    STDMETHOD_(CallbackHandle,RelativeEnter)	(THIS_
						IHXCallback* pCallback,
						UINT32 ms);

    /************************************************************************
     *	Method:
     *	    IHXScheduler::AbsoluteEnter
     *	Purpose:
     *	    enter objects in the service queue at absolute time
     */
    STDMETHOD_(CallbackHandle,AbsoluteEnter)	(THIS_
						IHXCallback* pCallback,
						HXTimeval tVal);

    /************************************************************************
     *	Method:
     *	    IHXScheduler::Remove
     *	Purpose:
     *	    remove objects from the service queue
     */
    STDMETHOD(Remove)		(THIS_
			    	CallbackHandle Handle);

    /************************************************************************
     *	Method:
     *	    IHXScheduler::GetCurrentSchedulerTime
     *	Purpose:
     *	    gives the current time in the timeline of the scheduler...
     */
    STDMETHOD_(HXTimeval,GetCurrentSchedulerTime)	(THIS);

    /************************************************************************
     *	Method:
     *		OnTimeSync
     *	Purpose:
     *		called by audio services OR the player timer to set the 
     *		current time of playback..
     *
     */
    HX_RESULT	OnTimeSync(BOOL bAtInterrupt=FALSE);

    HX_RESULT	ExecuteCurrentFunctions(BOOL bAtInterrupt=FALSE);

    HX_RESULT	StartScheduler();

    void	UseDeferredTask(BOOL bUseDeferredTask) 
		    {m_bUseDeferredTask = bUseDeferredTask;};
    HX_RESULT	StartSchedulerTimerFixup();
    HX_RESULT   StartSchedulerImplementation(BOOL TimerFixup);
    
    void	StopScheduler();
    BOOL	GetNextEventDueTimeDiff(ULONG32 &ulEarliestDueTimeDiff);
    BOOL	IsEmpty();

    BOOL	IsAtInterruptTime();

    void	SetCoreMutex(HXMutex* pMutex) {m_pCoreMutex = pMutex;};
    void	SetInterrupt(BOOL bInterruptenable) 
		    {m_bIsInterruptEnabled = bInterruptenable;};

    void	NotifyPlayState(BOOL bInPlayingState);

    BOOL	AreImmediatesPending(void)  { return m_bImmediatesPending; }

protected:
    Timeval	    m_CurrentTimeVal;
    UINT32	    m_ulLastUpdateTime;
    HXMutex*	    m_pCoreMutex;
    BOOL	    m_bIsInterruptEnabled;
    Timeval 	    m_headTime;
    Timeval	    m_interruptHeadTime;
    UINT32	    m_ulSystemNextDueTime;
    UINT32	    m_ulInterruptNextDueTime;

    BOOL	    m_bImmediatesPending;

#if defined(_WIN32) || defined(THREADS_SUPPORTED)
    CAsyncTimer*    m_pAsyncTimer;
#endif 

    Timeline*		m_pTimeline;
    ULONG32		m_ulCurrentGranularity;
    inline BOOL	UpdateCurrentTime(BOOL bAtInterrupt,BOOL& bShouldServiceSystem, 
				  BOOL& bShouldServiceInterrupt);
};

#endif // _IHXSCHEDULER_
