/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: mmxfilters.c,v 1.2.36.1 2004/07/09 02:01:17 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/*
 * Precomputed polyphase filter and state-machine tables.
 * by Ken Cooke
 *
 * ATTEN 100.0f
 * TRANS 0.134f (proportionally larger when downsampling)
 * DCGAIN 1.0f
 *
 * NOTE: Scaled using block floating point.
 * scale = { 15, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 0 }
 * delta = { 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3 }
 */

#define NWING 48
typedef short filtwing[NWING];

#ifdef __INTEL_COMPILER
#define ALIGN __declspec(align(8))
#else
#define ALIGN
#endif

#ifdef HELIX_FEATURE_MMXFILTER_6_1
/*
 * inrate=8000 outrate=48000 up=6 dn=1
 */

ALIGN
filtwing filter_6_1[6] = {
	{ -1124,   133,  3400, -11084,  6186, -11543, 19194, -29277, 10396, -13854, 17366, -20427, 11174, -11134,  9596, -6028,   -42,  4589, -10768, 18604, -13984, 19267, -24881, 30438, -17717, 19631, -20615, 20301, -9158,  7156, -3995,  -431,  3088, -6612, 10739, -15380, 10200, -12809, 15405, -17852,  9994, -10810, 11246, -11107,  1252,  -872,  -324, 30269, },
	{  1161, -4122, 10085, -20251,  8922, -14256, 21020, -28861,  9254, -11057, 12175, -12028,  4962, -2553, -1590,  7798, -8149, 13575, -20095, 27478, -17665, 21536, -24972, 27511, -14312, 13873, -12154,  8893, -1936, -1525,  5961, -11330,  8762, -12175, 15766, -19357, 11361, -12798, 13833, -14280,  6958, -6222,  4716, -2060,  -318,  1407, -4149, 27905, },
	{  2641, -6655, 13450, -23599,  9313, -13456, 17928, -21992,  6134, -6013,  4670, -1580, -1899,  5980, -11632, 18922, -13878, 18912, -24283, 29571, -17108, 18763, -19352, 18443, -7802,  5218, -1309, -4026,  5402, -9471, 14113, -19158, 12181, -14706, 16962, -18723,  9868, -9858,  9172, -7629,  2502,  -497, -2435,  6718, -1657,  3060, -6212, 23511, },
	{  3150, -7207, 13262, -21195,  7569, -9735, 11146, -10875,  1930,   -66, -3250,  8378, -7801, 12527, -18324, 24993, -16077, 19608, -22685, 24799, -12679, 11857, -9605,  5622,   169, -4211,  9322, -15424, 11170, -14891, 18671, -22253, 12660, -13756, 14216, -13825,  6180, -4795,  2635,   432, -2285,  5004, -8557, 13295, -2497,  3825, -6537, 17696, },
	{  2803, -6035, 10145, -14410,  4362, -4277,  2613,  1544, -2303,  5355, -9755, 15628, -11476, 15748, -20380, 24970, -14475, 15796, -16015, 14651, -5606,  2621,  1818, -7823,  7702, -12216, 17313, -22759, 14115, -16655, 18748, -20109, 10215, -9693,  8329, -5971,  1239,  1136, -4196,  7993, -6296,  9046, -12340, 16376, -2701,  3654, -5415, 11244, },
	{  1906, -3753,  5302, -5423,   608,  1474, -5551, 12321, -5605,  9070, -13491, 18746, -12265, 15157, -17664, 19276, -9687,  8631, -6104,  1760,  2342, -6705, 12217, -18784, 13094, -17034, 20958, -24539, 13692, -14523, 14523, -13449,  5532, -3581,   786,  2910, -3767,  6539, -9747, 13356, -8661, 10799, -13083, 15535, -2282,  2698, -3333,  4989, },
};

int nextstate_6_1[6] = {
	0x00100400, 0x00200300, 0x00300200, 0x00400100, 0x00500000, 0x00000501, 
};
#endif // HELIX_FEATURE_MMXFILTER_6_1

#ifdef HELIX_FEATURE_MMXFILTER_640_147
/*
 * inrate=11025 outrate=48000 up=640 dn=147
 */

ALIGN
filtwing filter_640_147[640] = {
	{ -2569,  2771,  -842, -4937,  4166, -9157, 16742, -27309, 10239, -14333, 18870, -23425, 13682, -14918, 14901, -13036,  4350,  -648, -4836, 12257, -10817, 16402, -22691, 29369, -17993, 20983, -23308, 24574, -12180, 11121, -8910,  5370,  -185, -3083,  7124, -11904,  8673, -11666, 14853, -18140, 10709, -12286, 13742, -15019,  2008, -2102,  2150, 30573, },
	{   989, -3881,  9831, -20111,  8973, -14483, 21553, -29872,  9680, -11717, 13135, -13350,  5829, -3639,  -292,  6323, -7358, 12786, -19387, 26957, -17561, 21663, -25410, 28342, -14964, 14793, -13365, 10400, -2831,  -509,  4857, -10190,  8208, -11680, 15384, -19146, 11376, -12970, 14203, -14892,  7409, -6846,  5547, -3148,  -139,  1165, -3790, 28297, },
	{  3071, -7347, 14296, -24301,  9312, -13060, 16827, -19794,  5196, -4566,  2605,  1182, -3639,  8043, -13923, 21273, -14956, 19721, -24607, 29159, -16395, 17402, -17211, 15415, -5813,  2752,  1597, -7287,  7141, -11218, 15740, -20507, 12625, -14816, 16630, -17838,  9095, -8703,  7592, -5587,  1238,  1015, -4195,  8714, -1933,  3351, -6457, 22101, },
	{  3248, -6986, 12037, -17854,  5806, -6529,  5897, -2957,  -854,  3604, -7792, 13631, -10603, 15203, -20433, 25949, -15617, 17791, -19061, 18922, -8415,  6122, -2339, -3119,  5173, -9656, 14917, -20771, 13470, -16520, 19295, -21512, 11425, -11482, 10749, -9044,  3097, -1017, -1801,  5441, -5002,  7821, -11306, 15717, -2704,  3818, -5959, 13593, },
	{  2056, -3926,  5447, -5460,   562,  1611, -5816, 12752, -5761,  9278, -13747, 19039, -12419, 15303, -17780, 19338, -9676,  8563, -5967,  1545,  2492, -6895, 12442, -19033, 13222, -17155, 21058, -24603, 13698, -14495, 14454, -13333,  5449, -3473,   654,  3063, -3851,  6625, -9830, 13429, -8687, 10810, -13072, 15491, -2271,  2677, -3293,  4888, },
	{  -157, -1796,  6632, -15848,  7753, -13369, 21002, -30581, 10411, -13307, 15939, -17752,  9016, -7964,  5259,  -436, -3457,  8541, -15084, 23005, -16028, 20898, -25786, 30261, -16897, 17888, -17773, 16217, -6450,  3776,    14, -4971,  5539, -9125, 13155, -17499, 10991, -13191, 15214, -16900,  9028, -9218,  8849, -7638,   626,    79, -2036, 29606, },
	{  2554, -6569, 13531, -24166,  9705, -14288, 19449, -24515,  7103, -7411,  6578, -4051,  -379,  4207, -9687, 16947, -12979, 18243, -24024, 29933, -17716, 19920, -21174, 21031, -9513,  7358, -3856, -1130,  3833, -7856, 12558, -17793, 11671, -14457, 17070, -19291, 10434, -10756, 10451, -9331,  3583, -1824,  -849,  4861, -1390,  2757, -5903, 24657, },
	{  3385, -7510, 13501, -21121,  7374, -9224, 10148, -9191,  1288,   837, -4436,  9838, -8638, 13413, -19161, 25646, -16224, 19468, -22138, 23721, -11815, 10617, -7958,  3562,  1391, -5589, 10795, -16904, 11856, -15451, 19024, -22307, 12490, -13343, 13514, -12797,  5489, -3920,  1579,  1657, -2969,  5738, -9308, 14010, -2571,  3858, -6449, 16738, },
	{  2574, -5198,  8048, -10129,  2455, -1209, -1931,  7789, -4302,  7727, -12333, 18107, -12433, 16100, -19719, 22814, -12383, 12420, -11109,  8028, -1393, -2467,  7660, -14186, 10964, -15312, 19928, -24520, 14357, -16032, 17034, -17090,  7962, -6633,  4434, -1262, -1483,  4152, -7390, 11202, -7797, 10294, -13131, 16412, -2551,  3230, -4396,  7856, },
	{ -1445,   615,  2752, -10309,  5988, -11395, 19182, -29530, 10569, -14193, 17937, -21304, 11804, -11990, 10705, -7402,   772,  3669, -9781, 17614, -13530, 18911, -24692, 30494, -17910, 20033, -21268, 21239, -9783,  7941, -4935,   646,  2496, -5992, 10125, -14815,  9969, -12661, 15379, -17992, 10175, -11135, 11760, -11879,  1397, -1100,   110, 30370, },
	{  1792, -5293, 11869, -22561,  9544, -14744, 21074, -28046,  8689, -9956, 10343, -9267,  3032,   -16, -4739, 11491, -10187, 15667, -22039, 29007, -18056, 21363, -24028, 25585, -12761, 11655, -9219,  5235,   229, -3970,  8588, -14002, 10030, -13263, 16544, -19673, 11207, -12242, 12781, -12635,  5786, -4644,  2660,   570,  -738,  1959, -4923, 26834, },
	{  3311, -7615, 14268, -23369,  8610, -11543, 14048, -15222,  3463, -2110,  -673,  5313, -6093, 10777, -16734, 23851, -15914, 20076, -24036, 27299, -14633, 14627, -13272, 10212, -2566, -1101,  5956, -11979,  9526, -13474, 17659, -21843, 12864, -14480, 15567, -15900,  7620, -6666,  4950, -2316,  -712,  3264, -6708, 11429, -2283,  3674, -6608, 19761, },
	{  3000, -6288, 10401, -14567,  4338, -4140,  2301,  2095, -2515,  5650, -10135, 16082, -11725, 15994, -20588, 25093, -14467, 15686, -15771, 14245, -5311,  2227,  2309, -8398,  8020, -12546, 17629, -23030, 14210, -16687, 18697, -19953, 10074, -9482,  8044, -5609,  1022,  1385, -4469,  8279, -6437,  9173, -12438, 16422, -2696,  3628, -5343, 10971, },
	{  1590, -2806,  3232, -1626,  -935,  3749, -8625, 16129, -6673, 10116, -14292, 18977, -11882, 14017, -15472, 15726, -7089,  5094, -1568, -3755,  5526, -10184, 15785, -22152, 14491, -17922, 21082, -23627, 12581, -12630, 11744, -9712,  3175,  -755, -2449,  6450, -5612,  8353, -11396, 14667, -9041, 10770, -12472, 14099, -1952,  2130, -2311,  2604, },
	{   804, -3548,  9332, -19472,  8802, -14353, 21548, -30116,  9845, -12038, 13670, -14161,  6401, -4398,   662,  5185, -6715, 12107, -18724, 26385, -17368, 21619, -25579, 28790, -15359, 15389, -14182, 11449, -3469,   231,  4038, -9328,  7779, -11285, 15060, -18939, 11356, -13061, 14436, -15300,  7719, -7283,  6138, -3932,    -9,   986, -3516, 28560, },
	{  3000, -7249, 14227, -24380,  9418, -13323, 17344, -20683,  5544, -5073,  3297,   288, -3093,  7416, -13251, 20615, -14677, 19547, -24607, 29412, -16690, 17908, -17966, 16449, -6476,  3560,   660, -6252,  6598, -10682, 15253, -20120, 12511, -14815, 16774, -18163,  9364, -9094,  8118, -6257,  1648,   530, -3635,  8087, -1848,  3264, -6391, 22567, },
	{  3285, -7103, 12334, -18482,  6097, -7015,  6647, -4035,  -490,  3144, -7248, 13035, -10308, 14957, -20297, 26003, -15785, 18153, -19670, 19827, -9036,  6924, -3320, -1977,  4540, -8992, 14265, -20187, 13245, -16402, 19327, -21737, 11656, -11851, 11271, -9731,  3524, -1523, -1224,  4809, -4672,  7493, -11008, 15487, -2692,  3840, -6065, 14142, },
	{  2150, -4155,  5908, -6272,   885,  1138, -5177, 11956, -5535,  9050, -13561, 18957, -12472, 15503, -18187, 20015, -10182,  9263, -6878,  2670,  1832, -6159, 11667, -18273, 12886, -16906, 20949, -24689, 13868, -14820, 14960, -14038,  5907, -4034,  1311,  2327, -3457,  6224, -9448, 13099, -8569, 10765, -13135, 15712, -2328,  2782, -3492,  5387, },
	{  -372, -1399,  6004, -14975,  7485, -13088, 20778, -30527, 10481, -13513, 16347, -18435,  9532, -8690,  6218, -1638, -2742,  7735, -14231, 22168, -15662, 20640, -25702, 30425, -17141, 18332, -18450, 17152, -7053,  4512,  -842, -4019,  5035, -8619, 12684, -17106, 10859, -13153, 15304, -17158,  9263, -9586,  9386, -8397,   760,  -120, -1692, 29778, },
	{  2440, -6384, 13308, -23995,  9718, -14424, 19807, -25220,  7404, -7878,  7251, -4964,   206,  3498, -8875, 16076, -12551, 17874, -23779, 29895, -17847, 20251, -21754, 21904, -10114,  8131, -4800,   -33,  3225, -7216, 11922, -17209, 11435, -14309, 17049, -19436, 10610, -11057, 10897, -9940,  3978, -2317,  -248,  4144, -1284,  2633, -5764, 25063, },
	{  3388, -7560, 13687, -21590,  7614, -9657, 10855, -10260,  1666,   335, -3809,  9101, -8236, 13014, -18822, 25442, -16237, 19652, -22556, 24436, -12350, 11353, -8909,  4725,   713, -4836, 10002, -16121, 11501, -15172, 18865, -22318, 12606, -13594, 13924, -13386,  5881, -4412,  2169,   977, -2591,  5334, -8898, 13624, -2532,  3842, -6502, 17273, },
	{  2656, -5402,  8478, -10922,  2785, -1713, -1217,  6848, -4014,  7403, -12007, 17834, -12362, 16148, -19949, 23299, -12793, 13034, -11958,  9134, -2075, -1667,  6767, -13244, 10500, -14896, 19612, -24362, 14390, -16211, 17391, -17656,  8360, -7153,  5077, -2019, -1056,  3690, -6915, 10743, -7594, 10143, -13065, 16480, -2586,  3311, -4573,  8387, },
	{ -1678,  1057,  2024, -9238,  5632, -10970, 18740, -29166, 10535, -14268, 18189, -21814, 12233, -12638, 11613, -8599,  1520,  2781, -8781, 16553, -13007, 18448, -24354, 30357, -17985, 20296, -21763, 22005, -10315,  8631, -5782,  1636,  1944, -5403,  9530, -14254,  9730, -12494, 15318, -18081, 10319, -11411, 12210, -12570,  1527, -1309,   518, 30445, },
	{  1636, -5023, 11491, -22132,  9458, -14738, 21242, -28516,  8923, -10354, 10956, -10146,  3623,  -770, -3828, 10452, -9630, 15117, -21557, 28673, -18011, 21495, -24394, 26244, -13262, 12348, -10115,  6332,  -410, -3259,  7835, -13250,  9681, -12975, 16355, -19627, 11278, -12434, 13119, -13147,  6144, -5118,  3270,  -201,  -616,  1802, -4710, 27167, },
	{  3275, -7586, 14321, -23638,  8783, -11894, 14668, -16219,  3833, -2627,     6,  4471, -5603, 10243, -16203, 23391, -15766, 20067, -24233, 27775, -15048, 15254, -14137, 11331, -3253,  -300,  5064, -11037,  9058, -13046, 17315, -21634, 12856, -14597, 15839, -16357,  7953, -7114,  5518, -3007,  -307,  2806, -6206, 10902, -2217,  3619, -6599, 20265, },
	{  3061, -6451, 10770, -15290,  4655, -4647,  3052,  1056, -2179,  5244, -9682, 15625, -11530, 15881, -20622, 25353, -14753, 16175, -16508, 15266, -5976,  3047,  1346, -7323,  7451, -11983, 17119, -22632, 14101, -16706, 18882, -20343, 10389, -9931,  8635, -6345,  1459,   888, -3926,  7713, -6158,  8921, -12242, 16328, -2706,  3679, -5485, 11518, },
	{  1689, -3042,  3695, -2418,  -630,  3320, -8073, 15483, -6506,  9975, -14225, 19051, -12032, 14329, -16002, 16528, -7651,  5833, -2490, -2662,  4911, -9531, 15138, -21572, 14273, -17819, 21145, -23907, 12855, -13061, 12348, -10500,  3661, -1326, -1808,  5763, -5262,  8019, -11105, 14456, -8996, 10813, -12637, 14434, -2025,  2250, -2520,  3067, },
	{   612, -3203,  8810, -18791,  8615, -14197, 21506, -30311,  9994, -12340, 14186, -14953,  6966, -5155,  1621,  4031, -6058, 11402, -18025, 25765, -17144, 21538, -25704, 29190, -15730, 15960, -14978, 12483, -4104,   973,  3210, -8447,  7336, -10870, 14710, -18699, 11316, -13130, 14645, -15683,  8017, -7710,  6722, -4714,   122,   803, -3229, 28809, },
	{  2921, -7135, 14132, -24416,  9508, -13566, 17836, -21544,  5885, -5574,  3989,  -613, -2539,  6772, -12552, 19918, -14370, 19338, -24565, 29615, -16958, 18386, -18694, 17459, -7132,  4365,  -281, -5201,  6041, -10125, 14739, -19699, 12376, -14788, 16890, -18457,  9618, -9471,  8631, -6919,  2057,    41, -3067,  7442, -1759,  3170, -6312, 23023, },
	{  3317, -7210, 12614, -19085,  6380, -7494,  7392, -5115,  -123,  2676, -6688, 12413, -9995, 14684, -20126, 26013, -15927, 18486, -20248, 20704, -9645,  7717, -4299,  -827,  3897, -8310, 13586, -19566, 12998, -16256, 19326, -21927, 11868, -12201, 11776, -10403,  3946, -2029,  -642,  4166, -4331,  7151, -10689, 15230, -2675,  3856, -6163, 14690, },
	{  2243, -4381,  6365, -7084,  1211,   657, -4523, 11133, -5298,  8805, -13350, 18842, -12504, 15677, -18564, 20663, -10674,  9951, -7783,  3796,  1165, -5408, 10868, -17479, 12526, -16628, 20803, -24733, 14015, -15121, 15442, -14721,  6355, -4591,  1968,  1584, -3055,  5811, -9049, 12745, -8435, 10702, -13177, 15908, -2382,  2883, -3688,  5893, },
	{  -590,  -993,  5358, -14064,  7201, -12781, 20516, -30420, 10533, -13698, 16730, -19091, 10035, -9405,  7172, -2844, -2019,  6913, -13349, 21289, -15268, 20346, -25574, 30537, -17357, 18746, -19098, 18061, -7647,  5244, -1701, -3056,  4520, -8098, 12190, -16682, 10708, -13092, 15369, -17387,  9483, -9940,  9911, -9147,   894,  -321, -1336, 29934, },
	{  2318, -6183, 13057, -23780,  9714, -14537, 20134, -25887,  7694, -8334,  7916, -5874,   794,  2778, -8043, 15173, -12099, 17472, -23493, 29806, -17949, 20548, -22299, 22744, -10699,  8893, -5739,  1068,  2609, -6560, 11263, -16594, 11178, -14137, 16998, -19548, 10769, -11340, 11326, -10535,  4368, -2810,   356,  3414, -1175,  2503, -5612, 25457, },
	{  3385, -7597, 13852, -22027,  7845, -10078, 11551, -11321,  2044,  -171, -3170,  8343, -7817, 12591, -18448, 25193, -16222, 19804, -22937, 25112, -12866, 12073, -9849,  5886,    30, -4071,  9189, -15307, 11125, -14866, 18674, -22290, 12701, -13823, 14313, -13955,  6263, -4897,  2757,   292, -2207,  4920, -8471, 13211, -2488,  3820, -6545, 17803, },
	{  2735, -5600,  8900, -11707,  3114, -2219,  -494,  5887, -3716,  7064, -11657, 17528, -12270, 16168, -20147, 23748, -13183, 13629, -12792, 10229, -2757,  -859,  5858, -12275, 10016, -14453, 19261, -24162, 14399, -16363, 17720, -18193,  8746, -7663,  5714, -2777,  -625,  3220, -6426, 10262, -7377,  9973, -12977, 16521, -2617,  3387, -4745,  8922, },
	{ -1912,  1505,  1282, -8137,  5262, -10521, 18261, -28749, 10482, -14319, 18411, -22290, 12643, -13269, 12507, -9789,  2270,  1883, -7761, 15459, -12460, 17952, -23972, 30168, -18030, 20526, -22222, 22736, -10833,  9310, -6623,  2627,  1386, -4803,  8917, -13667,  9473, -12305, 15232, -18139, 10446, -11669, 12643, -13243,  1657, -1518,   936, 30503, },
	{  1474, -4739, 11087, -21658,  9354, -14707, 21375, -28940,  9143, -10737, 11555, -11013,  4213, -1528, -2906,  9389, -9054, 14539, -21036, 28288, -17935, 21590, -24720, 26860, -13743, 13023, -10998,  7422, -1051, -2540,  7066, -12473,  9315, -12663, 16137, -19546, 11331, -12605, 13437, -13639,  6492, -5586,  3877,  -977,  -493,  1640, -4484, 27486, },
	{  3231, -7543, 14350, -23868,  8943, -12228, 15269, -17196,  4200, -3143,   689,  3617, -5099,  9688, -15641, 22889, -15590, 20023, -24389, 28206, -15439, 15857, -14982, 12437, -3937,   506,  4160, -10072,  8573, -12594, 16939, -21387, 12825, -14690, 16086, -16787,  8274, -7550,  6079, -3696,   100,  2340, -5691, 10351, -2148,  3558, -6578, 20762, },
	{  3117, -6606, 11126, -15996,  4967, -5151,  3805,     6, -1836,  4826, -9208, 15138, -11313, 15740, -20621, 25570, -15016, 16640, -17221, 16267, -6634,  3866,   376, -6230,  6867, -11397, 16578, -22194, 13967, -16696, 19036, -20700, 10688, -10365,  9214, -7074,  1896,   386, -3374,  7131, -5868,  8652, -12025, 16206, -2712,  3724, -5621, 12067, },
	{  1787, -3278,  4160, -3216,  -320,  2881, -7501, 14804, -6326,  9816, -14133, 19093, -12163, 14620, -16509, 17308, -8203,  6567, -3413, -1558,  4284, -8858, 14462, -20953, 14029, -17686, 21172, -24148, 13108, -13471, 12934, -11274,  4142, -1897, -1161,  5063, -4902,  7670, -10795, 14219, -8936, 10838, -12782, 14746, -2094,  2367, -2727,  3538, },
	{   415, -2846,  8264, -18068,  8410, -14014, 21425, -30454, 10127, -12623, 14681, -15726,  7522, -5907,  2584,  2863, -5387, 10675, -17292, 25098, -16890, 21420, -25787, 29542, -16075, 16507, -15752, 13499, -4734,  1716,  2373, -7548,  6878, -10434, 14334, -18426, 11257, -13177, 14830, -16042,  8303, -8126,  7299, -5495,   255,   616, -2930, 29042, },
	{  2834, -7006, 14010, -24410,  9582, -13788, 18302, -22375,  6219, -6070,  4679, -1519, -1977,  6113, -11827, 19182, -14038, 19096, -24481, 29769, -17199, 18835, -19393, 18444, -7778,  5166, -1227, -4138,  5472, -9550, 14197, -19241, 12219, -14735, 16978, -18721,  9856, -9833,  9133, -7573,  2465,  -451, -2490,  6781, -1666,  3069, -6221, 23470, },
	{  3344, -7306, 12876, -19663,  6655, -7965,  8132, -6197,   247,  2199, -6112, 11765, -9661, 14384, -19920, 25978, -16043, 18788, -20795, 21549, -10241,  8501, -5275,   330,  3245, -7611, 12880, -18909, 12727, -16082, 19292, -22079, 12061, -12532, 12264, -11061,  4363, -2534,   -57,  3513, -3982,  6795, -10351, 14945, -2654,  3866, -6252, 15235, },
	{  2334, -4603,  6818, -7895,  1539,   171, -3855, 10282, -5049,  8543, -13115, 18694, -12515, 15826, -18913, 21278, -11150, 10626, -8678,  4922,   493, -4645, 10047, -16651, 12143, -16319, 20621, -24735, 14138, -15398, 15899, -15382,  6795, -5141,  2625,   836, -2647,  5386, -8632, 12368, -8287, 10620, -13196, 16079, -2432,  2981, -3881,  6405, },
	{  -812,  -578,  4692, -13118,  6901, -12448, 20215, -30259, 10568, -13861, 17087, -19719, 10525, -10108,  8120, -4052, -1288,  6073, -12439, 20370, -14845, 20015, -25402, 30598, -17544, 19131, -19717, 18944, -8229,  5969, -2560, -2085,  3996, -7560, 11673, -16228, 10538, -13010, 15408, -17588,  9688, -10279, 10421, -9888,  1028,  -525,  -968, 30073, },
	{  2188, -5968, 12780, -23519,  9693, -14626, 20428, -26516,  7974, -8780,  8573, -6781,  1385,  2049, -7191, 14239, -11624, 17037, -23165, 29666, -18020, 20812, -22808, 23548, -11269,  9644, -6672,  2171,  1986, -5891, 10583, -15948, 10901, -13939, 16918, -19628, 10910, -11605, 11737, -11114,  4753, -3300,   964,  2674, -1063,  2367, -5448, 25839, },
	{  3375, -7620, 13994, -22431,  8064, -10486, 12233, -12372,  2421,  -681, -2521,  7566, -7382, 12143, -18040, 24899, -16179, 19923, -23282, 25749, -13363, 12776, -10776,  7043,  -656, -3296,  8357, -14464, 10729, -14533, 18450, -22225, 12774, -14030, 14678, -14502,  6637, -5376,  3343,  -396, -1818,  4495, -8026, 12773, -2440,  3791, -6577, 18329, },
	{  2810, -5792,  9312, -12481,  3441, -2727,   237,  4906, -3410,  6709, -11285, 17189, -12156, 16161, -20311, 24159, -13553, 14204, -13608, 11313, -3437,   -47,  4935, -11280,  9512, -13984, 18875, -23920, 14383, -16488, 18020, -18701,  9118, -8162,  6343, -3532,  -191,  2743, -5924,  9763, -7146,  9786, -12865, 16534, -2644,  3458, -4911,  9460, },
	{ -2148,  1957,   528, -7008,  4879, -10050, 17746, -28278, 10411, -14346, 18604, -22731, 13035, -13881, 13385, -10969,  3020,   977, -6723, 14332, -11889, 17422, -23548, 29927, -18044, 20721, -22646, 23431, -11333,  9975, -7455,  3617,   823, -4192,  8286, -13054,  9200, -12094, 15119, -18167, 10557, -11908, 13056, -13899,  1785, -1729,  1365, 30543, },
	{  1305, -4442, 10657, -21140,  9232, -14649, 21471, -29318,  9349, -11104, 12139, -11868,  4799, -2287, -1973,  8303, -8459, 13932, -20476, 27853, -17828, 21649, -25005, 27433, -14203, 13679, -11865,  8504, -1692, -1813,  6283, -11671,  8931, -12329, 15890, -19432, 11364, -12755, 13732, -14110,  6831, -6047,  4482, -1756,  -367,  1473, -4246, 27791, },
	{  3180, -7486, 14353, -24060,  9088, -12544, 15850, -18152,  4563, -3657,  1377,  2750, -4583,  9112, -15048, 22344, -15386, 19945, -24504, 28591, -15806, 16436, -15805, 13526, -4617,  1314,  3246, -9087,  8071, -12118, 16534, -21103, 12772, -14758, 16306, -17190,  8581, -7976,  6632, -4381,   509,  1868, -5162,  9780, -2074,  3489, -6545, 21251, },
	{  3168, -6751, 11468, -16684,  5274, -5651,  4559, -1054, -1487,  4395, -8715, 14621, -11076, 15572, -20585, 25745, -15254, 17078, -17907, 17245, -7283,  4682,  -599, -5122,  6269, -10789, 16006, -21716, 13810, -16658, 19158, -21024, 10969, -10782,  9780, -7793,  2331,  -117, -2814,  6534, -5566,  8366, -11785, 16055, -2713,  3763, -5750, 12616, },
	{  1885, -3513,  4624, -4021,    -6,  2432, -6910, 14092, -6133,  9638, -14017, 19103, -12273, 14887, -16990, 18062, -8744,  7294, -4335,  -447,  3647, -8166, 13758, -20295, 13761, -17522, 21163, -24348, 13340, -13859, 13500, -12031,  4618, -2466,  -511,  4352, -4531,  7306, -10464, 13957, -8860, 10845, -12905, 15036, -2161,  2481, -2932,  4017, },
	{   214, -2477,  7696, -17304,  8188, -13805, 21307, -30546, 10244, -12887, 15154, -16476,  8069, -6654,  3547,  1683, -4702,  9925, -16526, 24384, -16606, 21265, -25826, 29845, -16395, 17028, -16502, 14496, -5358,  2459,  1529, -6633,  6407, -9979, 13932, -18121, 11178, -13202, 14990, -16374,  8576, -8531,  7866, -6271,   388,   425, -2619, 29259, },
	{  2740, -6862, 13862, -24361,  9641, -13987, 18740, -23175,  6545, -6560,  5367, -2429, -1407,  5439, -11078, 18409, -13679, 18819, -24354, 29873, -17411, 19253, -20062, 19401, -8413,  5961, -2174, -3063,  4891, -8955, 13630, -18750, 12040, -14657, 17037, -18955, 10079, -10180,  9620, -8216,  2870,  -945, -1905,  6103, -1570,  2963, -6118, 23907, },
	{  3364, -7390, 13119, -20213,  6922, -8427,  8865, -7278,   620,  1714, -5521, 11092, -9309, 14058, -19678, 25899, -16132, 19061, -21309, 22362, -10821,  9274, -6247,  1491,  2584, -6896, 12151, -18217, 12433, -15879, 19225, -22194, 12233, -12842, 12732, -11702,  4775, -3036,   531,  2852, -3624,  6426, -9992, 14632, -2628,  3869, -6331, 15779, },
	{  2423, -4821,  7266, -8704,  1868,  -322, -3173,  9406, -4789,  8264, -12855, 18512, -12505, 15948, -19231, 21862, -11609, 11286, -9564,  6045,  -184, -3870,  9205, -15791, 11738, -15982, 20403, -24695, 14238, -15649, 16331, -16020,  7225, -5685,  3279,    83, -2233,  4951, -8198, 11968, -8123, 10519, -13193, 16222, -2478,  3074, -4070,  6923, },
	{ -1038,  -155,  4008, -12136,  6586, -12091, 19877, -30045, 10584, -14001, 17418, -20317, 10999, -10798,  9060, -5260,  -551,  5219, -11504, 19411, -14395, 19649, -25185, 30607, -17702, 19484, -20304, 19798, -8800,  6687, -3418, -1106,  3463, -7008, 11134, -15745, 10349, -12904, 15421, -17760,  9877, -10601, 10917, -10616,  1161,  -731,  -590, 30195, },
	{  2052, -5737, 12476, -23214,  9655, -14691, 20691, -27104,  8242, -9215,  9220, -7682,  1977,  1311, -6322, 13275, -11126, 16571, -22796, 29474, -18060, 21042, -23281, 24316, -11822, 10381, -7598,  3276,  1358, -5209,  9881, -15273, 10604, -13717, 16809, -19674, 11033, -11852, 12130, -11677,  5131, -3788,  1574,  1924,  -948,  2225, -5271, 26209, },
	{  3358, -7631, 14114, -22800,  8271, -10880, 12901, -13411,  2798, -1194, -1863,  6770, -6931, 11671, -17599, 24561, -16109, 20008, -23588, 26344, -13839, 13460, -11689,  8192, -1343, -2513,  7507, -13593, 10313, -14174, 18194, -22121, 12826, -14213, 15020, -15027,  7000, -5848,  3925, -1087, -1423,  4060, -7565, 12311, -2387,  3755, -6598, 18850, },
	{  2882, -5977,  9714, -13244,  3767, -3236,   975,  3908, -3095,  6340, -10890, 16819, -12020, 16125, -20441, 24531, -13901, 14757, -14405, 12383, -4115,   770,  3999, -10262,  8990, -13488, 18456, -23637, 14342, -16584, 18291, -19180,  9475, -8649,  6964, -4284,   245,  2259, -5410,  9244, -6902,  9581, -12732, 16519, -2666,  3524, -5072, 10002, },
	{ -2384,  2413,  -239, -5852,  4483, -9556, 17195, -27753, 10322, -14348, 18766, -23136, 13407, -14472, 14245, -12137,  3769,    65, -5667, 13176, -11295, 16861, -23082, 29633, -18027, 20882, -23033, 24089, -11817, 10626, -8277,  4605,   257, -3572,  7639, -12416,  8910, -11861, 14979, -18164, 10649, -12128, 13450, -14537,  1911, -1939,  1803, 30567, },
	{  1130, -4132, 10202, -20578,  9093, -14566, 21532, -29649,  9541, -11455, 12706, -12708,  5381, -3048, -1031,  7197, -7846, 13298, -19878, 27368, -17690, 21671, -25249, 27962, -14640, 14314, -12716,  9575, -2334, -1081,  5485, -10846,  8530, -11973, 15616, -19284, 11378, -12885, 14006, -14559,  7160, -6500,  5083, -2539,  -239,  1302, -3994, 28081, },
	{  3122, -7414, 14331, -24211,  9220, -12842, 16409, -19085,  4921, -4170,  2067,  1871, -4056,  8518, -14427, 21758, -15155, 19833, -24579, 28929, -16148, 16990, -16605, 14596, -5292,  2123,  2321, -8082,  7554, -11620, 16099, -20782, 12698, -14800, 16499, -17566,  8876, -8390,  7176, -5062,   919,  1390, -4622,  9188, -1996,  3414, -6500, 21732, },
	{  3215, -6887, 11794, -17350,  5576, -6147,  5312, -2122, -1133,  3954, -8203, 14075, -10818, 15375, -20513, 25877, -15468, 17490, -18567, 18198, -7924,  5494, -1577, -4000,  5657, -10159, 15404, -21200, 13628, -16591, 19248, -21312, 11233, -11183, 10331, -8501,  2763,  -623, -2247,  5924, -5253,  8066, -11524, 15876, -2709,  3797, -5871, 13166, },
	{  1981, -3746,  5088, -4829,   312,  1973, -6301, 13350, -5929,  9442, -13875, 19080, -12363, 15130, -17445, 18790, -9273,  8012, -5255,   672,  3001, -7458, 13028, -19599, 13467, -17327, 21118, -24507, 13550, -14226, 14045, -12771,  5088, -3033,   143,  3630, -4152,  6928, -10115, 13670, -8769, 10832, -13007, 15301, -2224,  2593, -3136,  4504, },
	{     7, -2098,  7105, -16500,  7950, -13570, 21150, -30586, 10345, -13131, 15605, -17203,  8606, -7394,  4511,   494, -4006,  9154, -15727, 23625, -16292, 21073, -25820, 30099, -16688, 17523, -17227, 15473, -5975,  3201,   679, -5703,  5924, -9505, 13504, -17783, 11080, -13204, 15126, -16681,  8836, -8922,  8423, -7043,   522,   232, -2296, 29460, },
	{  2638, -6703, 13687, -24269,  9683, -14165, 19150, -23942,  6862, -7042,  6050, -3341,  -831,  4751, -10304, 17600, -13295, 18508, -24185, 29926, -17594, 19641, -20700, 20330, -9037,  6750, -3121, -1979,  4299, -8344, 13036, -18224, 11841, -14555, 17067, -19156, 10285, -10511, 10093, -8848,  3272, -1439, -1313,  5410, -1470,  2849, -6002, 24333, },
	{  3378, -7462, 13342, -20736,  7180, -8880,  9590, -8356,   995,  1223, -4916, 10396, -8939, 13705, -19401, 25774, -16194, 19302, -21789, 23140, -11387, 10035, -7213,  2656,  1915, -6166, 11397, -17491, 12117, -15649, 19125, -22272, 12386, -13132, 13180, -12325,  5179, -3535,  1121,  2182, -3259,  6044, -9615, 14293, -2598,  3865, -6402, 16320, },
	{  2509, -5035,  7709, -9508,  2198,  -819, -2478,  8506, -4519,  7968, -12570, 18297, -12473, 16044, -19518, 22411, -12052, 11931, -10438,  7163,  -863, -3084,  8343, -14900, 11311, -15616, 20150, -24613, 14314, -15875, 16737, -16632,  7644, -6222,  3931,  -673, -1813,  4505, -7750, 11546, -7946, 10400, -13167, 16339, -2520,  3164, -4255,  7446, },
	{ -1266,   276,  3308, -11121,  6255, -11709, 19501, -29776, 10583, -14118, 17721, -20885, 11458, -11475,  9990, -6466,   192,  4352, -10544, 18414, -13919, 19248, -24925, 30564, -17831, 19805, -20859, 20621, -9358,  7396, -4273,  -122,  2922, -6442, 10574, -15233, 10142, -12776, 15407, -17902, 10051, -10908, 11398, -11332,  1294,  -938,  -201, 30300, },
	{  1908, -5493, 12145, -22864,  9599, -14730, 20920, -27651,  8498, -9637,  9856, -8577,  2570,   567, -5437, 12282, -10606, 16075, -22386, 29231, -18070, 21236, -23716, 25045, -12358, 11104, -8514,  4379,   724, -4516,  9161, -14569, 10288, -13471, 16671, -19687, 11138, -12079, 12504, -12223,  5503, -4271,  2185,  1165,  -831,  2077, -5080, 26566, },
	{  3334, -7627, 14210, -23134,  8467, -11259, 13552, -14436,  3173, -1709, -1196,  5956, -6466, 11177, -17125, 24179, -16010, 20060, -23855, 26898, -14294, 14125, -12586,  9332, -2031, -1721,  6640, -12695,  9877, -13790, 17905, -21980, 12856, -14373, 15337, -15528,  7354, -6312,  4504, -1778, -1024,  3616, -7089, 11824, -2330,  3712, -6608, 19365, },
	{  2950, -6155, 10105, -13994,  4090, -3745,  1719,  2893, -2772,  5957, -10474, 16417, -11863, 16062, -20537, 24863, -14228, 15289, -15182, 13437, -4790,  1589,  3052, -9222,  8451, -12968, 18003, -23312, 14277, -16653, 18531, -19627,  9818, -9123,  7575, -5032,   682,  1770, -4885,  8708, -6645,  9358, -12575, 16476, -2685,  3585, -5227, 10546, },
	{  1513, -2621,  2873, -1015, -1168,  4074, -9040, 16609, -6794, 10213, -14326, 18897, -11752, 13758, -15043, 15086, -6645,  4516,  -852, -4597,  5996, -10678, 16267, -22575, 14644, -17980, 21008, -23382, 12354, -12282, 11261, -9089,  2794,  -312, -2943,  6976, -5877,  8603, -11607, 14814, -9065, 10724, -12329, 13823, -1894,  2035, -2149,  2250, },
	{   949, -3808,  9722, -19972,  8936, -14457, 21555, -29931,  9718, -11790, 13256, -13532,  5957, -3808,   -81,  6072, -7216, 12637, -19243, 26834, -17521, 21656, -25451, 28446, -15054, 14927, -13548, 10635, -2973,  -344,  4676, -10000,  8114, -11594, 15314, -19103, 11373, -12992, 14257, -14985,  7479, -6944,  5679, -3322,  -110,  1126, -3730, 28357, },
	{  3056, -7327, 14283, -24322,  9337, -13120, 16944, -19994,  5274, -4679,  2759,   984, -3518,  7905, -13776, 21131, -14896, 19685, -24611, 29220, -16463, 17517, -17381, 15647, -5961,  2932,  1390, -7059,  7021, -11100, 15634, -20424, 12601, -14818, 16664, -17913,  9156, -8791,  7710, -5737,  1329,   908, -4071,  8576, -1914,  3332, -6443, 22205, },
	{  3257, -7013, 12105, -17996,  5871, -6638,  6064, -3196,  -773,  3502, -7672, 13501, -10539, 15151, -20406, 25965, -15656, 17874, -19199, 19126, -8554,  6301, -2557, -2866,  5034, -9510, 14774, -20645, 13422, -16496, 19305, -21565, 11478, -11566, 10866, -9198,  3193, -1129, -1673,  5302, -4930,  7750, -11242, 15668, -2701,  3824, -5983, 13715, },
	{  2077, -3977,  5550, -5640,   633,  1506, -5676, 12577, -5712,  9229, -13708, 19024, -12433, 15349, -17873, 19491, -9790,  8720, -6170,  1794,  2346, -6733, 12272, -18867, 13149, -17102, 21037, -24626, 13737, -14569, 14568, -13491,  5552, -3598,   800,  2900, -3764,  6537, -9747, 13358, -8662, 10802, -13088, 15542, -2284,  2700, -3337,  4998, },
	{  -204, -1709,  6494, -15657,  7695, -13309, 20956, -30573, 10428, -13354, 16032, -17906,  9131, -8126,  5473,  -703, -3299,  8363, -14897, 22822, -15949, 20843, -25771, 30302, -16954, 17989, -17926, 16426, -6585,  3940,  -176, -4760,  5428, -9014, 13052, -17414, 10963, -13184, 15236, -16960,  9081, -9301,  8970, -7807,   656,    35, -1961, 29645, },
	{  2529, -6529, 13484, -24132,  9709, -14320, 19531, -24675,  7171, -7515,  6728, -4254,  -250,  4051, -9509, 16756, -12886, 18164, -23973, 29929, -17748, 19996, -21306, 21228, -9648,  7530, -4066,  -887,  3698, -7715, 12419, -17666, 11620, -14426, 17068, -19326, 10475, -10825, 10552, -9467,  3671, -1933,  -716,  4703, -1367,  2730, -5873, 24748, },
	{  3387, -7522, 13544, -21228,  7428, -9322, 10306, -9430,  1372,   726, -4298,  9676, -8550, 13326, -19088, 25605, -16229, 19512, -22234, 23883, -11935, 10782, -8171,  3820,  1241, -5423, 10621, -16733, 11779, -15391, 18992, -22313, 12518, -13400, 13607, -12930,  5577, -4030,  1710,  1507, -2886,  5649, -9219, 13927, -2562,  3855, -6462, 16857, },
	{  2593, -5243,  8144, -10306,  2529, -1320, -1773,  7582, -4239,  7657, -12262, 18049, -12419, 16113, -19773, 22925, -12476, 12558, -11299,  8275, -1545, -2290,  7463, -13979, 10863, -15222, 19861, -24488, 14366, -16075, 17116, -17218,  8052, -6749,  4578, -1430, -1388,  4050, -7286, 11102, -7753, 10262, -13118, 16429, -2559,  3248, -4436,  7973, },
	{ -1497,   713,  2591, -10074,  5910, -11302, 19087, -29454, 10563, -14212, 17995, -21420, 11901, -12136, 10908, -7668,   938,  3472, -9561, 17381, -13416, 18811, -24620, 30468, -17929, 20094, -21381, 21412, -9902,  8095, -5124,   866,  2374, -5862,  9994, -14693,  9917, -12626, 15367, -18014, 10208, -11198, 11862, -12034,  1426, -1146,   200, 30389, },
	{  1758, -5234, 11787, -22470,  9527, -14745, 21114, -28154,  8742, -10045, 10480, -9463,  3163,  -184, -4538, 11263, -10065, 15548, -21935, 28937, -18049, 21396, -24113, 25735, -12874, 11810, -9420,  5479,    88, -3812,  8422, -13837,  9954, -13201, 16504, -19666, 11224, -12286, 12858, -12750,  5866, -4750,  2795,   399,  -711,  1925, -4877, 26909, },
	{  3304, -7610, 14282, -23432,  8650, -11623, 14187, -15445,  3546, -2225,  -522,  5127, -5985, 10660, -16619, 23753, -15884, 20077, -24083, 27409, -14727, 14769, -13466, 10462, -2719,  -924,  5759, -11771,  9424, -13381, 17585, -21800, 12864, -14508, 15629, -16004,  7695, -6767,  5077, -2470,  -622,  3163, -6598, 11314, -2268,  3663, -6607, 19874, },
	{  3014, -6325, 10484, -14730,  4409, -4253,  2467,  1865, -2441,  5561, -10036, 15983, -11684, 15971, -20599, 25155, -14532, 15797, -15937, 14473, -5459,  2409,  2095, -8161,  7895, -12423, 17518, -22945, 14188, -16694, 18741, -20043, 10146, -9583,  8176, -5773,  1119,  1275, -4349,  8154, -6376,  9119, -12397, 16404, -2698,  3640, -5375, 11092, },
	{  1612, -2858,  3335, -1801,  -867,  3654, -8504, 15989, -6637, 10087, -14279, 18996, -11917, 14088, -15592, 15906, -7214,  5259, -1773, -3513,  5390, -10041, 15644, -22026, 14445, -17902, 21099, -23693, 12644, -12728, 11880, -9888,  3283,  -882, -2307,  6299, -5536,  8280, -11333, 14623, -9032, 10781, -12510, 14175, -1969,  2157, -2358,  2706, },
	{   762, -3472,  9218, -19324,  8762, -14321, 21542, -30164,  9879, -12106, 13787, -14339,  6527, -4567,   875,  4929, -6571, 11952, -18572, 26251, -17321, 21604, -25610, 28883, -15444, 15518, -14361, 11680, -3611,   396,  3855, -9134,  7682, -11195, 14985, -18889, 11349, -13079, 14484, -15387,  7786, -7379,  6269, -4106,    20,   946, -3453, 28617, },
	{  2983, -7225, 14208, -24391,  9439, -13379, 17456, -20877,  5620, -5184,  3451,    88, -2971,  7274, -13098, 20464, -14611, 19504, -24602, 29461, -16752, 18017, -18130, 16675, -6623,  3739,   451, -6020,  6475, -10560, 15141, -20030, 12483, -14811, 16802, -18231,  9421, -9179,  8233, -6405,  1739,   421, -3510,  7945, -1828,  3243, -6374, 22669, },
	{  3293, -7128, 12398, -18618,  6160, -7122,  6813, -4275,  -409,  3041, -7125, 12899, -10240, 14899, -20262, 26009, -15819, 18229, -19801, 20025, -9173,  7101, -3537, -1722,  4398, -8842, 14116, -20052, 13192, -16372, 19330, -21783, 11705, -11931, 11385, -9881,  3618, -1636, -1095,  4667, -4597,  7419, -10939, 15432, -2689,  3844, -6088, 14264, },
	{  2171, -4205,  6010, -6452,   958,  1032, -5033, 11776, -5483,  8997, -13516, 18935, -12481, 15544, -18273, 20162, -10293,  9417, -7080,  2920,  1684, -5993, 11491, -18100, 12808, -16847, 20919, -24702, 13902, -14889, 15069, -14191,  6007, -4158,  1457,  2162, -3368,  6133, -9361, 13022, -8541, 10753, -13146, 15758, -2340,  2805, -3536,  5499, },
	{  -420, -1310,  5862, -14776,  7423, -13022, 20723, -30508, 10494, -13556, 16435, -18583,  9645, -8850,  6431, -1906, -2582,  7554, -14037, 21976, -15577, 20578, -25678, 30454, -17192, 18426, -18597, 17356, -7186,  4675, -1033, -3806,  4922, -8505, 12576, -17014, 10827, -13141, 15321, -17211,  9313, -9666,  9504, -8565,   790,  -165, -1614, 29814, },
	{  2413, -6340, 13255, -23951,  9718, -14452, 19882, -25371,  7469, -7980,  7399, -5166,   336,  3339, -8692, 15878, -12452, 17787, -23719, 29880, -17872, 20320, -21878, 22094, -10245,  8301, -5009,   211,  3088, -7071, 11777, -17075, 11379, -14273, 17040, -19464, 10647, -11122, 10993, -10073,  4065, -2427,  -114,  3983, -1260,  2605, -5731, 25151, },
	{  3388, -7569, 13726, -21690,  7666, -9752, 11011, -10497,  1750,   223, -3668,  8934, -8144, 12922, -18741, 25391, -16236, 19689, -22644, 24589, -12466, 11515, -9119,  4984,   561, -4667,  9823, -15943, 11419, -15106, 18826, -22315, 12629, -13647, 14013, -13515,  5966, -4520,  2300,   825, -2507,  5243, -8805, 13534, -2523,  3838, -6512, 17391, },
	{  2674, -5446,  8572, -11097,  2858, -1825, -1057,  6636, -3948,  7329, -11931, 17769, -12344, 16154, -19996, 23402, -12881, 13168, -12145,  9378, -2227, -1488,  6566, -13031, 10394, -14800, 19537, -24321, 14394, -16247, 17467, -17778,  8447, -7268,  5219, -2188,  -960,  3586, -6807, 10638, -7547, 10107, -13047, 16492, -2593,  3328, -4612,  8505, },
	{ -1730,  1156,  1860, -8996,  5551, -10872, 18637, -29078, 10525, -14281, 18241, -21923, 12326, -12780, 11813, -8864,  1686,  2582, -8556, 16313, -12888, 18341, -24273, 30320, -17998, 20350, -21868, 22170, -10432,  8783, -5970,  1857,  1820, -5270,  9395, -14126,  9674, -12454, 15301, -18096, 10349, -11470, 12308, -12721,  1556, -1355,   610, 30460, },
	{  1601, -4961, 11403, -22030,  9436, -14733, 21274, -28614,  8973, -10440, 11091, -10340,  3754,  -938, -3624, 10218, -9504, 14991, -21445, 28592, -17997, 21519, -24470, 26384, -13371, 12500, -10313,  6575,  -552, -3100,  7666, -13080,  9601, -12908, 16309, -19612, 11291, -12473, 13192, -13258,  6222, -5222,  3405,  -373,  -589,  1767, -4661, 27239, },
	{  3266, -7578, 14330, -23692,  8820, -11970, 14803, -16437,  3915, -2741,   157,  4283, -5492, 10121, -16081, 23283, -15729, 20060, -24271, 27875, -15137, 15390, -14327, 11578, -3405,  -121,  4865, -10824,  8952, -12947, 17234, -21583, 12851, -14620, 15896, -16455,  8026, -7212,  5643, -3160,  -216,  2703, -6093, 10781, -2202,  3606, -6595, 20376, },
	{  3073, -6486, 10851, -15449,  4725, -4759,  3219,   823, -2104,  5152, -9578, 15519, -11484, 15852, -20625, 25405, -14813, 16281, -16668, 15491, -6122,  3229,  1131, -7082,  7322, -11854, 17001, -22538, 14073, -16706, 18919, -20426, 10457, -10029,  8765, -6508,  1556,   777, -3804,  7585, -6095,  8862, -12196, 16304, -2708,  3690, -5516, 11640, },
	{  1711, -3095,  3798, -2595,  -561,  3223, -7947, 15335, -6467,  9941, -14207, 19063, -12063, 14396, -16117, 16704, -7774,  5997, -2695, -2417,  4773, -9383, 14990, -21438, 14221, -17792, 21154, -23964, 12913, -13154, 12480, -10673,  3768, -1453, -1665,  5608, -5183,  7943, -11038, 14405, -8984, 10820, -12671, 14505, -2040,  2276, -2566,  3171, },
	{   569, -3124,  8691, -18634,  8571, -14159, 21491, -30347, 10025, -12405, 14298, -15127,  7090, -5322,  1835,  3772, -5910, 11243, -17865, 25621, -17091, 21515, -25727, 29272, -15809, 16084, -15152, 12710, -4244,  1138,  3025, -8249,  7235, -10775, 14629, -18641, 11305, -13143, 14688, -15765,  8082, -7804,  6851, -4888,   152,   762, -3164, 28862, },
	{  2902, -7108, 14107, -24419,  9526, -13617, 17942, -21731,  5960, -5685,  4143,  -814, -2415,  6627, -12393, 19758, -14299, 19287, -24550, 29654, -17014, 18488, -18852, 17680, -7276,  4543,  -491, -4966,  5915, -9999, 14621, -19600, 12343, -14778, 16912, -18519,  9672, -9553,  8744, -7065,  2148,   -68, -2939,  7297, -1739,  3148, -6293, 23123, },
	{  3324, -7232, 12674, -19216,  6442, -7599,  7557, -5356,   -41,  2570, -6561, 12271, -9922, 14620, -20084, 26009, -15955, 18555, -20372, 20894, -9779,  7892, -4516,  -570,  3753, -8156, 13431, -19423, 12939, -16220, 19321, -21964, 11913, -12277, 11886, -10551,  4040, -2142,  -512,  4022, -4254,  7073, -10616, 15169, -2671,  3859, -6184, 14811, },
	{  2263, -4431,  6466, -7265,  1284,   550, -4376, 10946, -5243,  8748, -13300, 18812, -12509, 15712, -18644, 20802, -10781, 10102, -7982,  4046,  1016, -5240, 10687, -17298, 12443, -16562, 20766, -24737, 14044, -15185, 15545, -14870,  6454, -4713,  2114,  1418, -2965,  5717, -8957, 12663, -8404, 10685, -13183, 15948, -2393,  2905, -3731,  6007, },
	{  -639,  -901,  5211, -13857,  7135, -12709, 20452, -30389, 10542, -13736, 16812, -19233, 10145, -9562,  7384, -3112, -1857,  6727, -13149, 21089, -15176, 20275, -25540, 30555, -17401, 18834, -19238, 18260, -7777,  5406, -1892, -2841,  4405, -7980, 12077, -16584, 10672, -13076, 15380, -17434,  9530, -10017, 10025, -9313,   924,  -367, -1255, 29966, },
	{  2289, -6136, 12998, -23726,  9711, -14559, 20202, -26030,  7757, -8434,  8063, -6076,   925,  2617, -7855, 14968, -11995, 17378, -23424, 29780, -17967, 20610, -22415, 22925, -10827,  9061, -5947,  1313,  2471, -6413, 11114, -16453, 11118, -14095, 16983, -19569, 10802, -11401, 11418, -10665,  4454, -2919,   491,  3251, -1150,  2473, -5577, 25543, },
	{  3383, -7603, 13885, -22120,  7894, -10170, 11703, -11555,  2128,  -284, -3027,  8172, -7722, 12493, -18360, 25132, -16215, 19833, -23017, 25257, -12978, 12231, -10056,  6144,  -122, -3900,  9006, -15122, 11039, -14794, 18627, -22279, 12719, -13871, 14396, -14079,  6347, -5004,  2887,   140, -2121,  4826, -8373, 13116, -2478,  3814, -6553, 17921, },
	{  2752, -5643,  8992, -11880,  3187, -2332,  -332,  5670, -3649,  6986, -11576, 17455, -12246, 16169, -20186, 23843, -13267, 13758, -12975, 10471, -2908,  -679,  5654, -12056,  9905, -14351, 19178, -24112, 14397, -16393, 17790, -18309,  8829, -7775,  5855, -2945,  -528,  3115, -6315, 10153, -7327,  9933, -12954, 16527, -2623,  3403, -4782,  9041, },
	{ -1964,  1605,  1116, -7888,  5178, -10418, 18149, -28649, 10468, -14327, 18457, -22391, 12732, -13406, 12703, -10052,  2436,  1682, -7532, 15211, -12335, 17837, -23882, 30119, -18036, 20572, -22320, 22893, -10945,  9459, -6808,  2847,  1261, -4668,  8778, -13533,  9414, -12260, 15209, -18148, 10472, -11723, 12736, -13391,  1686, -1565,  1031, 30513, },
	{  1437, -4674, 10993, -21547,  9328, -14696, 21399, -29028,  9190, -10820, 11686, -11204,  4343, -1696, -2699,  9149, -8923, 14406, -20915, 28196, -17914, 21606, -24787, 26991, -13847, 13171, -11192,  7663, -1193, -2379,  6893, -12297,  9231, -12591, 16084, -19524, 11340, -12640, 13504, -13745,  6568, -5689,  4012, -1150,  -465,  1604, -4432, 27555, },
	{  3220, -7532, 14353, -23914,  8976, -12300, 15400, -17410,  4281, -3257,   842,  3425, -4985,  9561, -15512, 22771, -15547, 20009, -24418, 28296, -15523, 15988, -15167, 12680, -4088,   685,  3958, -9855,  8463, -12490, 16852, -21327, 12815, -14707, 16137, -16879,  8343, -7646,  6203, -3848,   191,  2236, -5574, 10226, -2132,  3543, -6571, 20871, },
	{  3129, -6639, 11204, -16151,  5036, -5262,  3972,  -229, -1759,  4731, -9100, 15025, -11262, 15705, -20616, 25613, -15071, 16740, -17375, 16486, -6779,  4048,   160, -5985,  6735, -11263, 16453, -22091, 13934, -16690, 19066, -20775, 10752, -10459,  9341, -7234,  1992,   275, -3250,  7000, -5801,  8590, -11973, 16175, -2712,  3733, -5651, 12189, },
	{  1809, -3331,  4263, -3395,  -251,  2782, -7371, 14648, -6284,  9778, -14109, 19098, -12189, 14681, -16618, 17478, -8324,  6729, -3618, -1312,  4144, -8705, 14308, -20810, 13972, -17652, 21173, -24196, 13162, -13559, 13062, -11443,  4248, -2023, -1017,  4906, -4820,  7590, -10723, 14163, -8920, 10841, -12811, 14813, -2109,  2393, -2773,  3644, },
	{   371, -2765,  8140, -17902,  8362, -13970, 21402, -30479, 10155, -12684, 14788, -15894,  7644, -6073,  2798,  2602, -5236, 10510, -17125, 24943, -16830, 21389, -25799, 29614, -16149, 16625, -15921, 13722, -4873,  1881,  2186, -7346,  6775, -10335, 14247, -18361, 11241, -13185, 14867, -16118,  8365, -8217,  7426, -5668,   284,   574, -2862, 29092, },
	{  2814, -6975, 13980, -24403,  9597, -13834, 18402, -22555,  6292, -6180,  4832, -1721, -1851,  5964, -11663, 19014, -13960, 19037, -24456, 29797, -17248, 18930, -19544, 18659, -7920,  5343, -1437, -3900,  5343, -9419, 14073, -19135, 12181, -14720, 16993, -18776,  9907, -9911,  9242, -7716,  2555,  -561, -2360,  6631, -1645,  3046, -6199, 23568, },
	{  3349, -7326, 12932, -19787,  6715, -8068,  8296, -6437,   330,  2092, -5982, 11618, -9585, 14314, -19869, 25964, -16065, 18852, -20912, 21733, -10371,  8674, -5492,   588,  3098, -7454, 12720, -18758, 12663, -16039, 19280, -22108, 12101, -12603, 12369, -11205,  4455, -2646,    74,  3367, -3903,  6714, -10273, 14878, -2649,  3867, -6270, 15356, },
	{  2354, -4652,  6918, -8075,  1612,    62, -3704, 10090, -4992,  8482, -13059, 18656, -12515, 15855, -18986, 21411, -11253, 10774, -8876,  5171,   343, -4473,  9861, -16462, 12055, -16247, 20576, -24730, 14163, -15456, 15997, -15526,  6892, -5263,  2771,   669, -2555,  5290, -8537, 12281, -8252, 10599, -13197, 16113, -2442,  3002, -3923,  6520, },
	{  -862,  -484,  4541, -12903,  6832, -12371, 20143, -30216, 10573, -13894, 17163, -19854, 10632, -10263,  8330, -4320, -1124,  5885, -12233, 20160, -14748, 19937, -25357, 30605, -17582, 19212, -19850, 19136, -8357,  6129, -2751, -1868,  3878, -7439, 11555, -16123, 10498, -12988, 15413, -17629,  9731, -10352, 10533, -10051,  1058,  -571,  -885, 30101, },
	{  2158, -5918, 12715, -23455,  9686, -14643, 20490, -26650,  8034, -8878,  8718, -6982,  1516,  1886, -7000, 14027, -11515, 16936, -23087, 29628, -18031, 20866, -22917, 23722, -11394,  9809, -6878,  2417,  1847, -5741, 10429, -15801, 10837, -13892, 16897, -19641, 10939, -11662, 11826, -11241,  4837, -3409,  1100,  2508, -1038,  2336, -5410, 25923, },
	{  3372, -7624, 14023, -22516,  8111, -10575, 12382, -12604,  2505,  -795, -2375,  7390, -7283, 12040, -17945, 24828, -16166, 19945, -23353, 25884, -13470, 12930, -10980,  7299,  -808, -3123,  8169, -14273, 10638, -14456, 18396, -22205, 12787, -14072, 14756, -14621,  6719, -5482,  3473,  -549, -1730,  4399, -7925, 12673, -2429,  3783, -6582, 18445, },
	{  2826, -5834,  9402, -12652,  3514, -2840,   401,  4686, -3341,  6628, -11199, 17110, -12127, 16155, -20343, 24245, -13632, 14329, -13787, 11552, -3588,   134,  4728, -11056,  9398, -13876, 18785, -23861, 14376, -16511, 18083, -18810,  9198, -8272,  6482, -3699,   -94,  2636, -5811,  9649, -7093,  9742, -12838, 16533, -2649,  3473, -4948,  9581, },
	{ -2200,  2058,   358, -6753,  4792, -9942, 17626, -28166, 10393, -14349, 18643, -22824, 13119, -14014, 13577, -11230,  3186,   775, -6490, 14078, -11759, 17300, -23449, 29866, -18043, 20760, -22735, 23580, -11442, 10121, -7638,  3837,   697, -4055,  8144, -12914,  9137, -12044, 15090, -18169, 10579, -11959, 13146, -14043,  1813, -1775,  1461, 30550, },
	{  1266, -4374, 10558, -21019,  9203, -14633, 21488, -29395,  9393, -11184, 12267, -12056,  4928, -2456, -1764,  8059, -8324, 13793, -20346, 27749, -17800, 21657, -25063, 27555, -14302, 13822, -12056,  8743, -1835, -1651,  6107, -11490,  8843, -12252, 15832, -19402, 11369, -12786, 13795, -14212,  6905, -6148,  4616, -1930,  -339,  1436, -4191, 27857, },
	{  3168, -7471, 14350, -24097,  9119, -12612, 15976, -18361,  4643, -3771,  1530,  2555, -4467,  8982, -14913, 22217, -15337, 19923, -24525, 28670, -15884, 16561, -15985, 13765, -4767,  1493,  3041, -8865,  7958, -12009, 16440, -21035, 12758, -14769, 16351, -17276,  8648, -8069,  6754, -4533,   600,  1762, -5043,  9650, -2057,  3473, -6536, 21359, },
	{  3179, -6782, 11542, -16834,  5342, -5762,  4726, -1291, -1409,  4298, -8602, 14502, -11020, 15530, -20572, 25778, -15304, 17172, -18056, 17459, -7427,  4863,  -816, -4874,  6134, -10651, 15875, -21605, 13771, -16646, 19181, -21091, 11029, -10873,  9903, -7951,  2427,  -230, -2688,  6400, -5497,  8301, -11729, 16018, -2713,  3771, -5777, 12739, },
	{  1906, -3565,  4727, -4200,    64,  2331, -6776, 13930, -6089,  9596, -13987, 19101, -12295, 14943, -17093, 18226, -8863,  7454, -4540,  -199,  3504, -8010, 13598, -20143, 13697, -17481, 21156, -24387, 13388, -13943, 13623, -12197,  4723, -2592,  -366,  4192, -4448,  7223, -10388, 13895, -8841, 10843, -12930, 15097, -2175,  2506, -2978,  4125, },
	{   168, -2394,  7566, -17129,  8137, -13755, 21275, -30559, 10268, -12943, 15256, -16640,  8189, -6819,  3762,  1420, -4548,  9755, -16351, 24219, -16539, 21225, -25828, 29906, -16462, 17141, -16665, 14715, -5496,  2624,  1340, -6428,  6301, -9876, 13839, -18049, 11158, -13205, 15022, -16445,  8635, -8619,  7991, -6443,   417,   383, -2548, 29305, },
	{  2718, -6828, 13825, -24345,  9652, -14029, 18834, -23348,  6616, -6667,  5519, -2631, -1279,  5287, -10908, 18232, -13596, 18753, -24320, 29889, -17454, 19342, -20207, 19610, -8553,  6137, -2384, -2823,  4760, -8821, 13500, -18636, 11998, -14637, 17046, -19002, 10126, -10255,  9727, -8357,  2960, -1054, -1774,  5950, -1548,  2938, -6093, 24002, },
	{  3368, -7407, 13170, -20332,  6980, -8529,  9027, -7518,   703,  1606, -5388, 10940, -9228, 13982, -19619, 25875, -16148, 19117, -21418, 22538, -10948,  9444, -6462,  1750,  2436, -6735, 11985, -18059, 12365, -15831, 19206, -22215, 12269, -12909, 12833, -11842,  4865, -3147,   662,  2704, -3544,  6342, -9910, 14559, -2622,  3868, -6348, 15899, },
	{  2442, -4869,  7365, -8883,  1942,  -432, -3020,  9208, -4730,  8200, -12793, 18467, -12500, 15972, -19297, 21987, -11709, 11431, -9759,  6294,  -335, -3696,  9015, -15595, 11645, -15903, 20350, -24681, 14257, -15702, 16424, -16158,  7319, -5805,  3424,   -85, -2140,  4853, -8100, 11876, -8085, 10494, -13189, 16251, -2488,  3095, -4111,  7039, },
	{ -1088,   -60,  3854, -11914,  6513, -12008, 19796, -29990, 10586, -14029, 17487, -20446, 11103, -10950,  9267, -5528,  -386,  5028, -11292, 19193, -14292, 19563, -25131, 30602, -17733, 19558, -20430, 19983, -8925,  6845, -3608,  -888,  3344, -6883, 11011, -15633, 10305, -12878, 15420, -17794,  9917, -10671, 11025, -10777,  1191,  -776,  -504, 30220, },
	{  2020, -5684, 12404, -23140,  9644, -14702, 20744, -27229,  8300, -9310,  9363, -7882,  2109,  1146, -6127, 13057, -11012, 16464, -22708, 29425, -18065, 21088, -23381, 24481, -11943, 10543, -7802,  3521,  1217, -5056,  9723, -15119, 10536, -13665, 16781, -19680, 11058, -11904, 12215, -11800,  5214, -3895,  1710,  1756,  -923,  2193, -5229, 26289, },
	{  3354, -7631, 14137, -22878,  8316, -10965, 13047, -13640,  2881, -1308, -1715,  6590, -6829, 11563, -17497, 24480, -16089, 20023, -23650, 26471, -13942, 13610, -11890,  8446, -1496, -2337,  7315, -13395, 10218, -14091, 18132, -22093, 12834, -14250, 15092, -15140,  7080, -5952,  4054, -1240, -1335,  3962, -7461, 12205, -2375,  3746, -6601, 18965, },
	{  2897, -6017,  9802, -13412,  3839, -3349,  1140,  3684, -3024,  6256, -10800, 16732, -11987, 16114, -20466, 24608, -13976, 14877, -14580, 12619, -4266,   951,  3789, -10033,  8872, -13375, 18358, -23568, 14330, -16602, 18347, -19282,  9553, -8756,  7101, -4451,   342,  2151, -5294,  9127, -6846,  9533, -12699, 16512, -2671,  3538, -5107, 10123, },
	{ -2437,  2515,  -410, -5592,  4393, -9443, 17068, -27630, 10299, -14346, 18798, -23221, 13487, -14601, 14433, -12395,  3935,  -138, -5431, 12915, -11160, 16731, -22973, 29561, -18020, 20913, -23114, 24230, -11922, 10769, -8459,  4824,   131, -3433,  7493, -12271,  8843, -11806, 14945, -18159, 10667, -12175, 13535, -14676,  1939, -1985,  1901, 30569, },
	{  1090, -4061, 10097, -20447,  9060, -14544, 21540, -29715,  9581, -11531, 12830, -12893,  5509, -3217,  -820,  6948, -7708, 13153, -19740, 27254, -17655, 21671, -25298, 28074, -14734, 14452, -12902,  9812, -2476,  -918,  5306, -10660,  8439, -11890, 15551, -19247, 11379, -12910, 14063, -14656,  7232, -6599,  5216, -2713,  -211,  1263, -3936, 28144, },
	{  3108, -7396, 14322, -24239,  9247, -12906, 16530, -19289,  5000, -4283,  2221,  1675, -3937,  8383, -14284, 21622, -15100, 19803, -24589, 28998, -16220, 17109, -16780, 14832, -5441,  2302,  2115, -7856,  7437, -11507, 15998, -20705, 12678, -14807, 16538, -17646,  8939, -8480,  7295, -5212,  1010,  1283, -4501,  9054, -1978,  3396, -6488, 21838, },
	{  3225, -6916, 11865, -17496,  5642, -6257,  5479, -2360, -1053,  3855, -8086, 13950, -10757, 15328, -20492, 25900, -15512, 17578, -18710, 18407, -8065,  5674, -1795, -3749,  5520, -10017, 15267, -21080, 13584, -16573, 19263, -21371, 11289, -11270, 10451, -8657,  2859,  -735, -2120,  5787, -5182,  7997, -11463, 15832, -2708,  3803, -5896, 13288, },
	{  2003, -3798,  5191, -5009,   383,  1870, -6164, 13181, -5881,  9396, -13840, 19070, -12380, 15181, -17542, 18948, -9389,  8170, -5459,   921,  2856, -7298, 12862, -19440, 13399, -17280, 21103, -24537, 13593, -14304, 14163, -12932,  5192, -3159,   289,  3469, -4066,  6842, -10035, 13603, -8747, 10827, -13027, 15357, -2237,  2617, -3181,  4613, },
	{   -40, -2013,  6971, -16316,  7894, -13514, 21111, -30588, 10365, -13183, 15702, -17362,  8724, -7558,  4725,   229, -3850,  8980, -15545, 23451, -16218, 21025, -25813, 30148, -16749, 17629, -17385, 15687, -6112,  3366,   489, -5495,  5815, -9398, 13406, -17704, 11056, -13202, 15152, -16745,  8891, -9008,  8546, -7213,   551,   188, -2222, 29503, },
	{  2615, -6666, 13644, -24242,  9690, -14202, 19238, -24108,  6932, -7148,  6201, -3544,  -702,  4596, -10130, 17416, -13206, 18435, -24141, 29931, -17631, 19722, -20838, 20532, -9174,  6924, -3331, -1737,  4167, -8205, 12901, -18103, 11794, -14528, 17069, -19197, 10329, -10582, 10197, -8986,  3361, -1549, -1181,  5254, -1447,  2823, -5974, 24426, },
	{  3381, -7476, 13388, -20848,  7236, -8979,  9750, -8595,  1079,  1113, -4780, 10238, -8854, 13623, -19334, 25740, -16204, 19351, -21891, 23309, -11510, 10202, -7426,  2914,  1766, -6002, 11226, -17326, 12044, -15594, 19098, -22285, 12417, -13193, 13276, -12461,  5268, -3645,  1252,  2033, -3176,  5957, -9528, 14214, -2590,  3863, -6416, 16439, },
	{  2528, -5082,  7806, -9686,  2272,  -930, -2323,  8302, -4458,  7900, -12504, 18245, -12463, 16061, -19577, 22528, -12147, 12072, -10631,  7411, -1015, -2909,  8149, -14698, 11213, -15531, 20089, -24589, 14328, -15922, 16824, -16765,  7736, -6340,  4075,  -841, -1719,  4405, -7648, 11449, -7904, 10371, -13158, 16362, -2529,  3183, -4296,  7563, },
	{ -1317,   372,  3150, -10891,  6180, -11620, 19412, -29709, 10580, -14141, 17784, -21006, 11558, -11623, 10195, -6734,   357,  4157, -10327, 18188, -13809, 19154, -24861, 30547, -17855, 19872, -20978, 20800, -9480,  7552, -4462,    98,  2801, -6314, 10447, -15115, 10094, -12745, 15401, -17929, 10087, -10974, 11502, -11489,  1323,  -984,  -113, 30321, },
	{  1875, -5437, 12067, -22781,  9585, -14736, 20966, -27766,  8554, -9729,  9996, -8775,  2702,   400, -5239, 12058, -10488, 15960, -22289, 29170, -18068, 21275, -23808, 25202, -12474, 11262, -8716,  4624,   583, -4361,  8998, -14409, 10216, -13413, 16637, -19685, 11159, -12127, 12584, -12342,  5584, -4378,  2320,   996,  -805,  2044, -5036, 26643, },
	{  3328, -7625, 14228, -23204,  8508, -11341, 13695, -14662,  3256, -1823, -1047,  5773, -6360, 11064, -17015, 24088, -15985, 20067, -23909, 27015, -14392, 14270, -12783,  9584, -2184, -1545,  6446, -12492,  9778, -13701, 17837, -21943, 12860, -14405, 15404, -15636,  7431, -6414,  4631, -1932,  -935,  3516, -6981, 11713, -2317,  3702, -6609, 19479, },
	{  2964, -6193, 10190, -14159,  4161, -3858,  1885,  2666, -2699,  5871, -10379, 16323, -11825, 16045, -20554, 24932, -14298, 15404, -15352, 13669, -4939,  1771,  2840, -8988,  8329, -12849, 17898, -23234, 14259, -16665, 18580, -19722,  9892, -9227,  7710, -5197,   779,  1660, -4767,  8586, -6586,  9306, -12538, 16462, -2688,  3598, -5260, 10667, },
	{  1535, -2674,  2975, -1189, -1102,  3982, -8923, 16474, -6760, 10187, -14318, 18922, -11790, 13833, -15167, 15270, -6773,  4681, -1056, -4357,  5862, -10538, 16131, -22456, 14602, -17965, 21031, -23454, 12420, -12383, 11400, -9268,  2903,  -438, -2802,  6827, -5802,  8533, -11548, 14774, -9059, 10739, -12371, 13903, -1911,  2062, -2195,  2351, },
	{   907, -3735,  9612, -19832,  8899, -14429, 21556, -29987,  9755, -11862, 13375, -13713,  6084, -3977,   131,  5819, -7074, 12487, -19097, 26709, -17479, 21648, -25490, 28547, -15142, 15061, -13730, 10868, -3115,  -180,  4494, -9810,  8019, -11507, 15243, -19058, 11369, -13013, 14309, -15076,  7548, -7042,  5811, -3497,   -82,  1086, -3669, 28416, },
	{  3040, -7305, 14268, -24341,  9361, -13180, 17060, -20193,  5351, -4792,  2913,   786, -3397,  7766, -13628, 20986, -14835, 19648, -24613, 29278, -16530, 17631, -17550, 15877, -6109,  3111,  1182, -6829,  6901, -10982, 15527, -20339, 12577, -14819, 16697, -17986,  9216, -8878,  7827, -5886,  1421,   800, -3947,  8438, -1896,  3313, -6429, 22309, },
	{  3265, -7039, 12171, -18136,  5936, -6746,  6231, -3436,  -693,  3401, -7552, 13369, -10474, 15097, -20377, 25979, -15695, 17955, -19335, 19328, -8693,  6479, -2775, -2613,  4893, -9364, 14630, -20516, 13373, -16471, 19313, -21617, 11530, -11649, 10983, -9351,  3288, -1242, -1545,  5161, -4857,  7677, -11176, 15618, -2699,  3829, -6007, 13837, },
	{  2098, -4028,  5652, -5821,   705,  1401, -5534, 12402, -5662,  9179, -13668, 19007, -12445, 15395, -17964, 19642, -9903,  8876, -6373,  2044,  2200, -6570, 12100, -18700, 13075, -17048, 21014, -24646, 13776, -14642, 14682, -13649,  5654, -3723,   946,  2737, -3677,  6448, -9663, 13286, -8637, 10793, -13103, 15592, -2297,  2724, -3382,  5109, },
	{  -252, -1621,  6355, -15464,  7636, -13247, 20907, -30563, 10444, -13401, 16123, -18059,  9247, -8288,  5686,  -970, -3140,  8185, -14708, 22638, -15869, 20787, -25754, 30340, -17009, 18089, -18077, 16635, -6720,  4104,  -366, -4549,  5317, -8902, 12948, -17328, 10935, -13177, 15257, -17018,  9134, -9384,  9089, -7976,   685,    -9, -1884, 29684, },
	{  2504, -6489, 13435, -24096,  9713, -14351, 19612, -24833,  7238, -7619,  6878, -4457,  -120,  3893, -9329, 16564, -12792, 18083, -23920, 29922, -17778, 20071, -21436, 21423, -9782,  7703, -4276,  -643,  3563, -7573, 12278, -17537, 11569, -14394, 17064, -19360, 10514, -10892, 10651, -9603,  3759, -2043,  -583,  4544, -1343,  2703, -5842, 24839, },
	{  3388, -7533, 13586, -21334,  7482, -9418, 10464, -9667,  1456,   614, -4159,  9513, -8462, 13239, -19014, 25561, -16233, 19554, -22328, 24044, -12055, 10946, -8382,  4079,  1090, -5256, 10445, -16560, 11701, -15330, 18958, -22316, 12544, -13457, 13699, -13061,  5664, -4139,  1841,  1356, -2802,  5560, -9128, 13842, -2554,  3851, -6474, 16976, },
	{  2611, -5289,  8240, -10483,  2602, -1432, -1615,  7373, -4175,  7585, -12191, 17990, -12404, 16124, -19825, 23034, -12568, 12695, -11488,  8521, -1696, -2112,  7265, -13771, 10760, -15131, 19792, -24455, 14375, -16115, 17196, -17345,  8141, -6865,  4721, -1598, -1294,  3948, -7180, 11001, -7709, 10229, -13105, 16446, -2567,  3266, -4475,  8091, },
	{ -1548,   811,  2430, -9837,  5832, -11209, 18990, -29375, 10556, -14229, 18052, -21535, 11997, -12280, 11110, -7935,  1104,  3275, -9339, 17146, -13301, 18710, -24547, 30439, -17947, 20154, -21492, 21584, -10021,  8249, -5312,  1086,  2252, -5732,  9863, -14569,  9865, -12590, 15355, -18035, 10241, -11259, 11962, -12188,  1455, -1192,   290, 30406, },
	{  1723, -5175, 11704, -22376,  9508, -14744, 21153, -28260,  8794, -10134, 10617, -9659,  3295,  -351, -4336, 11033, -9942, 15427, -21829, 28865, -18040, 21426, -24196, 25883, -12986, 11965, -9619,  5723,   -54, -3655,  8255, -13671,  9877, -13138, 16463, -19657, 11241, -12329, 12934, -12865,  5946, -4855,  2931,   228,  -684,  1890, -4830, 26984, },
	{  3296, -7604, 14295, -23493,  8689, -11701, 14326, -15667,  3628, -2340,  -372,  4940, -5877, 10542, -16502, 23652, -15852, 20076, -24128, 27516, -14820, 14909, -13659, 10711, -2872,  -746,  5562, -11563,  9320, -13287, 17510, -21755, 12863, -14535, 15691, -16106,  7770, -6866,  5203, -2623,  -532,  3061, -6487, 11198, -2254,  3651, -6606, 19986, },
	{  3027, -6361, 10567, -14891,  4480, -4366,  2634,  1634, -2367,  5471, -9936, 15883, -11641, 15947, -20608, 25214, -14597, 15907, -16102, 14701, -5607,  2591,  1882, -7923,  7769, -12298, 17406, -22858, 14164, -16699, 18783, -20131, 10216, -9684,  8308, -5937,  1216,  1165, -4229,  8029, -6314,  9063, -12354, 16384, -2701,  3652, -5407, 11214, },
	{  1634, -2911,  3438, -1977,  -800,  3560, -8382, 15846, -6600, 10056, -14265, 19014, -11951, 14158, -15710, 16085, -7340,  5423, -1978, -3270,  5254, -9896, 15501, -21899, 14398, -17880, 21114, -23756, 12705, -12824, 12015, -10064,  3391, -1009, -2165,  6146, -5458,  8207, -11269, 14577, -9023, 10792, -12548, 14251, -1985,  2184, -2404,  2809, },
	{   719, -3396,  9103, -19174,  8721, -14287, 21534, -30209,  9913, -12174, 13902, -14516,  6653, -4735,  1088,  4674, -6425, 11796, -18418, 26115, -17272, 21588, -25640, 28973, -15527, 15646, -14538, 11910, -3752,   561,  3671, -8939,  7584, -11103, 14908, -18836, 11340, -13095, 14531, -15473,  7853, -7474,  6399, -4280,    49,   905, -3390, 28673, },
	{  2965, -7200, 14188, -24401,  9460, -13434, 17566, -21069,  5696, -5296,  3605,  -112, -2848,  7132, -12944, 20310, -14544, 19458, -24594, 29508, -16813, 18124, -18293, 16901, -6769,  3918,   242, -5787,  6352, -10437, 15028, -19937, 12454, -14806, 16829, -18297,  9478, -9263,  8347, -6553,  1830,   313, -3384,  7803, -1809,  3223, -6357, 22771, },
	{  3300, -7152, 12461, -18753,  6223, -7229,  6979, -4515,  -328,  2937, -7001, 12762, -10171, 14839, -20226, 26013, -15852, 18304, -19931, 20221, -9309,  7277, -3755, -1467,  4256, -8691, 13966, -19915, 13138, -16341, 19331, -21826, 11753, -12009, 11498, -10031,  3712, -1748,  -966,  4524, -4521,  7343, -10869, 15376, -2685,  3848, -6110, 14386, },
	{  2192, -4256,  6111, -6633,  1030,   925, -4889, 11594, -5431,  8943, -13470, 18910, -12489, 15583, -18358, 20307, -10403,  9571, -7281,  3170,  1536, -5827, 11314, -17924, 12729, -16786, 20888, -24714, 13936, -14957, 15177, -14344,  6107, -4282,  1603,  1998, -3279,  6042, -9273, 12945, -8511, 10739, -13156, 15803, -2352,  2827, -3579,  5611, },
	{  -468, -1220,  5719, -14575,  7360, -12955, 20666, -30486, 10506, -13598, 16521, -18730,  9757, -9009,  6643, -2174, -2422,  7372, -13842, 21783, -15490, 20513, -25651, 30481, -17241, 18520, -18742, 17559, -7318,  4838, -1224, -3592,  4808, -8390, 12467, -16921, 10794, -13129, 15336, -17263,  9362, -9745,  9621, -8732,   820,  -209, -1535, 29849, },
	{  2386, -6296, 13200, -23905,  9718, -14478, 19956, -25521,  7534, -8082,  7548, -5369,   467,  3179, -8508, 15679, -12353, 17699, -23657, 29862, -17896, 20387, -22000, 22281, -10376,  8471, -5218,   456,  2952, -6926, 11632, -16940, 11323, -14236, 17030, -19490, 10683, -11185, 11089, -10206,  4152, -2537,    20,  3821, -1236,  2576, -5698, 25239, },
	{  3388, -7578, 13763, -21788,  7718, -9846, 11166, -10733,  1834,   111, -3526,  8767, -8052, 12829, -18660, 25337, -16234, 19724, -22730, 24741, -12581, 11675, -9328,  5242,   410, -4497,  9643, -15763, 11336, -15039, 18784, -22310, 12651, -13699, 14100, -13642,  6052, -4628,  2430,   673, -2421,  5152, -8710, 13443, -2513,  3833, -6522, 17509, },
	{  2691, -5491,  8666, -11272,  2931, -1937,  -897,  6423, -3883,  7254, -11854, 17702, -12324, 16160, -20041, 23504, -12969, 13301, -12331,  9622, -2378, -1309,  6365, -12817, 10287, -14703, 19460, -24279, 14397, -16282, 17541, -17898,  8533, -7381,  5361, -2356,  -864,  3482, -6699, 10532, -7499, 10070, -13029, 16502, -2600,  3345, -4650,  8624, },
	{ -1782,  1256,  1696, -8752,  5469, -10773, 18531, -28987, 10514, -14294, 18291, -22030, 12417, -12921, 12012, -9129,  1853,  2383, -8330, 16071, -12767, 18232, -24190, 30279, -18009, 20402, -21971, 22334, -10547,  8934, -6157,  2077,  1696, -5137,  9260, -13996,  9618, -12413, 15283, -18110, 10378, -11528, 12405, -12871,  1585, -1402,   703, 30473, },
	{  1565, -4899, 11314, -21927,  9414, -14727, 21305, -28710,  9022, -10526, 11224, -10533,  3885, -1107, -3420,  9982, -9377, 14864, -21330, 28508, -17981, 21541, -24544, 26523, -13479, 12650, -10509,  6817,  -694, -2940,  7495, -12908,  9520, -12839, 16261, -19595, 11304, -12512, 13263, -13368,  6300, -5327,  3540,  -545,  -562,  1731, -4611, 27310, },
	{  3256, -7569, 14337, -23745,  8856, -12045, 14938, -16655,  3997, -2856,   309,  4093, -5380,  9998, -15957, 23173, -15691, 20052, -24307, 27972, -15225, 15525, -14515, 11825, -3557,    58,  4664, -10611,  8845, -12848, 17152, -21529, 12845, -14641, 15952, -16551,  8097, -7309,  5768, -3313,  -126,  2600, -5979, 10660, -2187,  3593, -6591, 20487, },
	{  3086, -6521, 10930, -15606,  4794, -4871,  3386,   590, -2028,  5060, -9474, 15412, -11436, 15822, -20626, 25455, -14873, 16385, -16828, 15714, -6269,  3411,   916, -6839,  7193, -11725, 16882, -22443, 14045, -16705, 18954, -20506, 10524, -10126,  8894, -6670,  1653,   665, -3682,  7456, -6030,  8803, -12148, 16277, -2709,  3700, -5547, 11762, },
	{  1733, -3147,  3902, -2772,  -493,  3126, -7821, 15185, -6427,  9907, -14187, 19074, -12093, 14461, -16230, 16878, -7897,  6160, -2900, -2172,  4634, -9234, 14841, -21301, 14168, -17764, 21161, -24019, 12970, -13246, 12611, -10846,  3875, -1580, -1521,  5453, -5103,  7866, -10970, 14354, -8971, 10827, -12704, 14576, -2056,  2302, -2612,  3275, },
	{   525, -3046,  8570, -18475,  8526, -14119, 21474, -30381, 10055, -12468, 14408, -15299,  7214, -5490,  2049,  3513, -5761, 11082, -17704, 25474, -17035, 21490, -25746, 29352, -15887, 16207, -15325, 12936, -4384,  1303,  2839, -8050,  7134, -10679, 14546, -18582, 11292, -13154, 14730, -15846,  8146, -7897,  6980, -5062,   181,   720, -3098, 28914, },
	{  2883, -7080, 14081, -24419,  9543, -13667, 18046, -21917,  6034, -5795,  4296, -1015, -2290,  6481, -12233, 19595, -14226, 19235, -24533, 29690, -17069, 18589, -19008, 17900, -7420,  4721,  -701, -4730,  5789, -9872, 14501, -19500, 12309, -14767, 16932, -18578,  9725, -9634,  8856, -7211,  2239,  -178, -2811,  7150, -1718,  3126, -6273, 23223, },
	{  3330, -7254, 12733, -19345,  6503, -7704,  7722, -5596,    41,  2465, -6434, 12128, -9849, 14554, -20039, 26003, -15982, 18624, -20495, 21083, -9912,  8066, -4733,  -313,  3608, -8002, 13275, -19278, 12880, -16182, 19315, -21999, 11956, -12351, 11995, -10697,  4132, -2254,  -382,  3877, -4177,  6995, -10541, 15107, -2666,  3861, -6204, 14932, },
	{  2284, -4480,  6567, -7445,  1357,   442, -4228, 10758, -5188,  8691, -13248, 18780, -12512, 15746, -18723, 20940, -10887, 10253, -8182,  4296,   867, -5070, 10506, -17115, 12358, -16494, 20726, -24739, 14073, -15247, 15648, -15018,  6552, -4836,  2260,  1252, -2875,  5623, -8865, 12580, -8371, 10667, -13188, 15987, -2404,  2927, -3774,  6120, },
	{  -689,  -809,  5064, -13648,  7069, -12636, 20387, -30355, 10551, -13773, 16892, -19374, 10255, -9719,  7595, -3381, -1695,  6541, -12948, 20886, -15083, 20203, -25503, 30571, -17444, 18921, -19377, 18457, -7907,  5567, -2083, -2625,  4289, -7861, 11963, -16484, 10635, -13058, 15390, -17480,  9576, -10092, 10139, -9478,   954,  -412, -1174, 29998, },
	{  2261, -6089, 12937, -23669,  9707, -14580, 20269, -26171,  7820, -8534,  8210, -6278,  1056,  2455, -7667, 14762, -11890, 17283, -23353, 29750, -17984, 20670, -22530, 23106, -10955,  9229, -6155,  1558,  2333, -6264, 10963, -16311, 11057, -14052, 16966, -19588, 10834, -11461, 11511, -10794,  4540, -3028,   626,  3086, -1126,  2443, -5541, 25628, },
	{  3381, -7609, 13918, -22211,  7943, -10261, 11856, -11789,  2212,  -397, -2883,  8000, -7626, 12395, -18271, 25068, -16206, 19861, -23095, 25400, -13089, 12388, -10262,  6401,  -274, -3728,  8821, -14936, 10952, -14721, 18578, -22266, 12736, -13918, 14478, -14201,  6430, -5111,  3018,   -13, -2035,  4732, -8275, 13020, -2467,  3808, -6560, 18038, },
	{  2769, -5686,  9084, -12052,  3260, -2445,  -170,  5453, -3581,  6908, -11494, 17381, -12222, 16168, -20224, 23936, -13350, 13887, -13157, 10713, -3060,  -499,  5449, -11836,  9794, -14248, 19093, -24060, 14395, -16422, 17857, -18423,  8913, -7887,  5995, -3113,  -432,  3009, -6204, 10043, -7276,  9892, -12930, 16531, -2629,  3419, -4820,  9161, },
	{ -2017,  1705,   948, -7639,  5093, -10314, 18036, -28546, 10453, -14334, 18501, -22490, 12820, -13543, 12899, -10315,  2603,  1481, -7302, 14962, -12209, 17721, -23789, 30067, -18040, 20617, -22415, 23049, -11057,  9607, -6994,  3067,  1136, -4532,  8639, -13397,  9354, -12214, 15185, -18155, 10497, -11777, 12829, -13537,  1714, -1612,  1126, 30523, },
	{  1399, -4609, 10899, -21433,  9302, -14684, 21422, -29114,  9236, -10902, 11817, -11395,  4474, -1865, -2492,  8909, -8792, 14272, -20792, 28101, -17891, 21621, -24852, 27120, -13950, 13317, -11385,  7904, -1336, -2218,  6720, -12119,  9146, -12518, 16031, -19499, 11348, -12674, 13571, -13851,  6644, -5792,  4147, -1323,  -437,  1567, -4380, 27623, },
	{  3209, -7520, 14354, -23958,  9009, -12371, 15530, -17623,  4362, -3371,   994,  3233, -4871,  9434, -15381, 22652, -15503, 19993, -24445, 28383, -15605, 16117, -15351, 12923, -4239,   864,  3755, -9637,  8352, -12385, 16763, -21266, 12804, -14723, 16187, -16970,  8412, -7741,  6326, -4001,   282,  2131, -5457, 10100, -2116,  3528, -6564, 20980, },
	{  3140, -6671, 11280, -16304,  5104, -5373,  4140,  -464, -1682,  4636, -8991, 14911, -11210, 15669, -20610, 25653, -15125, 16838, -17529, 16705, -6923,  4229,   -57, -5739,  6603, -11129, 16327, -21987, 13900, -16683, 19094, -20848, 10815, -10552,  9467, -7395,  2089,   163, -3126,  6868, -5735,  8527, -11921, 16142, -2713,  3742, -5679, 12311, },
	{  1831, -3383,  4366, -3573,  -181,  2682, -7241, 14491, -6242,  9739, -14084, 19102, -12214, 14742, -16726, 17646, -8445,  6891, -3823, -1065,  4002, -8553, 14153, -20665, 13913, -17617, 21173, -24242, 13214, -13646, 13188, -11612,  4354, -2150,  -873,  4748, -4738,  7510, -10650, 14106, -8904, 10843, -12839, 14878, -2124,  2418, -2818,  3750, },
	{   326, -2683,  8014, -17733,  8314, -13925, 21377, -30501, 10181, -12743, 14894, -16062,  7766, -6240,  3012,  2340, -5084, 10344, -16955, 24786, -16768, 21356, -25810, 29683, -16221, 16742, -16088, 13944, -5012,  2047,  1998, -7143,  6671, -10234, 14158, -18294, 11224, -13191, 14904, -16193,  8426, -8307,  7552, -5840,   314,   532, -2793, 29140, },
	{  2793, -6944, 13948, -24394,  9610, -13879, 18500, -22734,  6365, -6289,  4985, -1923, -1724,  5815, -11497, 18843, -13881, 18977, -24429, 29822, -17296, 19024, -19694, 18873, -8061,  5520, -1647, -3662,  5215, -9288, 13948, -19027, 12142, -14704, 17007, -18829,  9957, -9989,  9351, -7860,  2645,  -670, -2231,  6481, -1624,  3023, -6177, 23666, },
	{  3353, -7345, 12986, -19911,  6775, -8171,  8459, -6678,   413,  1984, -5851, 11469, -9507, 14243, -19817, 25948, -16086, 18913, -21027, 21914, -10501,  8846, -5708,   846,  2952, -7295, 12559, -18606, 12599, -15995, 19266, -22135, 12140, -12672, 12474, -11348,  4547, -2757,   204,  3220, -3824,  6633, -10194, 14809, -2643,  3868, -6288, 15477, },
	{  2374, -4701,  7018, -8255,  1685,   -48, -3553,  9896, -4935,  8421, -13002, 18617, -12513, 15883, -19058, 21542, -11356, 10921, -9073,  5421,   192, -4302,  9675, -16272, 11966, -16173, 20529, -24723, 14186, -15513, 16094, -15669,  6987, -5384,  2916,   501, -2463,  5194, -8441, 12193, -8216, 10577, -13197, 16146, -2453,  3023, -3965,  6635, },
	{  -912,  -391,  4390, -12686,  6763, -12293, 20069, -30170, 10577, -13926, 17238, -19988, 10738, -10417,  8539, -4589,  -961,  5696, -12026, 19949, -14649, 19857, -25311, 30609, -17618, 19291, -19982, 19327, -8484,  6289, -2941, -1650,  3760, -7317, 11436, -16017, 10456, -12965, 15417, -17668,  9774, -10424, 10644, -10213,  1087,  -616,  -802, 30129, },
	{  2128, -5867, 12648, -23389,  9678, -14658, 20549, -26782,  8095, -8975,  8862, -7182,  1648,  1722, -6807, 13814, -11405, 16834, -23006, 29587, -18041, 20918, -23023, 23894, -11517,  9973, -7084,  2662,  1708, -5590, 10273, -15652, 10771, -13844, 16873, -19652, 10967, -11717, 11914, -11367,  4922, -3517,  1235,  2342, -1013,  2304, -5371, 26005, },
	{  3368, -7627, 14050, -22599,  8157, -10663, 12531, -12835,  2589,  -909, -2229,  7214, -7184, 11936, -17848, 24754, -16152, 19965, -23422, 26018, -13577, 13083, -11183,  7554,  -961, -2949,  7981, -14080, 10546, -14377, 18340, -22184, 12800, -14114, 14833, -14738,  6800, -5587,  3602,  -703, -1643,  4303, -7823, 12571, -2417,  3776, -6587, 18561, },
	{  2842, -5875,  9492, -12822,  3586, -2953,   565,  4464, -3271,  6547, -11112, 17029, -12098, 16148, -20373, 24329, -13710, 14452, -13965, 11790, -3739,   316,  4520, -10831,  9282, -13767, 18693, -23800, 14368, -16534, 18144, -18918,  9278, -8380,  6620, -3867,     3,  2529, -5697,  9535, -7039,  9697, -12809, 16531, -2654,  3488, -4984,  9701, },
	{ -2253,  2160,   188, -6498,  4704, -9833, 17505, -28051, 10374, -14350, 18680, -22915, 13203, -14146, 13769, -11490,  3353,   573, -6256, 13822, -11628, 17177, -23347, 29802, -18040, 20797, -22823, 23728, -11550, 10266, -7822,  4057,   572, -3917,  8000, -12773,  9073, -11993, 15060, -18169, 10600, -12008, 13234, -14185,  1841, -1822,  1558, 30556, },
	{  1228, -4306, 10458, -20895,  9172, -14616, 21503, -29471,  9436, -11262, 12393, -12243,  5058, -2625, -1555,  7814, -8189, 13653, -20215, 27643, -17770, 21663, -25119, 27674, -14400, 13964, -12245,  8981, -1977, -1489,  5930, -11307,  8755, -12173, 15772, -19370, 11373, -12815, 13857, -14312,  6979, -6249,  4750, -2104,  -310,  1398, -4135, 27922, },
	{  3155, -7456, 14346, -24132,  9149, -12679, 16101, -18570,  4723, -3885,  1683,  2361, -4350,  8850, -14776, 22088, -15287, 19900, -24543, 28747, -15961, 16685, -16164, 14004, -4917,  1673,  2836, -8642,  7843, -11900, 16344, -20965, 12742, -14780, 16395, -17361,  8714, -8162,  6875, -4684,   691,  1656, -4924,  9519, -2040,  3457, -6526, 21466, },
	{  3190, -6813, 11615, -16983,  5409, -5872,  4894, -1528, -1330,  4201, -8489, 14382, -10963, 15488, -20557, 25809, -15352, 17265, -18204, 17672, -7569,  5044, -1033, -4625,  5999, -10511, 15742, -21492, 13732, -16632, 19202, -21156, 11088, -10962, 10026, -8109,  2523,  -342, -2562,  6265, -5428,  8235, -11672, 15979, -2712,  3779, -5805, 12861, },
	{  1928, -3617,  4830, -4379,   135,  2229, -6642, 13766, -6044,  9553, -13957, 19097, -12316, 14998, -17195, 18389, -8981,  7614, -4744,    50,  3361, -7853, 13437, -19990, 13633, -17439, 21148, -24424, 13436, -14025, 13745, -12362,  4828, -2719,  -220,  4032, -4364,  7139, -10312, 13832, -8821, 10841, -12953, 15157, -2189,  2531, -3023,  4233, },
	{   122, -2310,  7436, -16952,  8084, -13704, 21242, -30570, 10291, -12998, 15357, -16802,  8309, -6984,  3976,  1156, -4394,  9585, -16174, 24052, -16470, 21184, -25829, 29964, -16529, 17251, -16827, 14933, -5633,  2789,  1151, -6222,  6194, -9771, 13745, -17975, 11137, -13206, 15053, -16514,  8693, -8706,  8115, -6615,   447,   340, -2477, 29351, },
	{  2696, -6793, 13787, -24326,  9662, -14069, 18926, -23520,  6687, -6775,  5671, -2834, -1152,  5135, -10737, 18054, -13511, 18685, -24284, 29903, -17496, 19429, -20350, 19818, -8692,  6313, -2595, -2582,  4629, -8686, 13369, -18520, 11954, -14615, 17053, -19048, 10172, -10329,  9832, -8498,  3049, -1164, -1643,  5797, -1526,  2913, -6068, 24098, },
	{  3371, -7424, 13220, -20449,  7038, -8630,  9189, -7757,   787,  1497, -5254, 10786, -9147, 13904, -19559, 25849, -16163, 19172, -21526, 22712, -11075,  9614, -6677,  2009,  2287, -6574, 11818, -17899, 12295, -15780, 19184, -22234, 12304, -12974, 12933, -11981,  4956, -3258,   793,  2555, -3463,  6258, -9827, 14485, -2615,  3868, -6364, 16020, },
	{  2461, -4917,  7464, -9062,  2015,  -542, -2866,  9009, -4670,  8135, -12731, 18421, -12493, 15994, -19362, 22110, -11808, 11575, -9954,  6542,  -485, -3522,  8824, -15398, 11551, -15823, 20295, -24664, 14275, -15753, 16515, -16295,  7413, -5925,  3569,  -253, -2047,  4754, -8001, 11783, -8046, 10468, -13184, 16278, -2497,  3115, -4153,  7155, },
	{ -1139,    36,  3699, -11689,  6441, -11924, 19714, -29932, 10586, -14056, 17556, -20573, 11205, -11101,  9474, -5797,  -221,  4835, -11080, 18973, -14187, 19475, -25075, 30594, -17763, 19631, -20555, 20167, -9050,  7003, -3798,  -669,  3224, -6758, 10888, -15521, 10260, -12850, 15418, -17826,  9956, -10740, 11133, -10936,  1220,  -822,  -418, 30244, },
	{  1989, -5631, 12332, -23064,  9632, -14711, 20797, -27352,  8357, -9404,  9504, -8081,  2241,   981, -5931, 12837, -10897, 16354, -22619, 29373, -18068, 21133, -23479, 24645, -12063, 10704, -8006,  3767,  1077, -4903,  9564, -14963, 10466, -13611, 16752, -19684, 11082, -11955, 12298, -11922,  5297, -4003,  1845,  1588,  -897,  2160, -5188, 26369, },
	{  3349, -7631, 14159, -22953,  8360, -11050, 13192, -13868,  2965, -1423, -1567,  6410, -6726, 11454, -17392, 24396, -16069, 20035, -23711, 26596, -14044, 13758, -12090,  8700, -1649, -2162,  7124, -13197, 10122, -14007, 18069, -22063, 12842, -14287, 15164, -15252,  7159, -6055,  4183, -1394, -1246,  3863, -7356, 12097, -2363,  3737, -6604, 19080, },
	{  2912, -6057,  9889, -13579,  3911, -3462,  1305,  3459, -2952,  6172, -10708, 16644, -11953, 16101, -20488, 24684, -14049, 14996, -14753, 12853, -4416,  1133,  3579, -9802,  8753, -13260, 18259, -23497, 14317, -16618, 18401, -19382,  9630, -8862,  7237, -4617,   439,  2042, -5178,  9008, -6790,  9484, -12665, 16503, -2675,  3552, -5142, 10244, },
	{ -2489,  2617,  -583, -5331,  4303, -9329, 16939, -27503, 10276, -14342, 18828, -23304, 13565, -14729, 14621, -12652,  4101,  -342, -5193, 12653, -11023, 16601, -22862, 29486, -18010, 20943, -23193, 24369, -12026, 10910, -8640,  5043,     4, -3293,  7346, -12125,  8775, -11751, 14909, -18152, 10685, -12220, 13619, -14814,  1966, -2032,  2000, 30571, },
	{  1050, -3989,  9992, -20314,  9025, -14521, 21547, -29780,  9621, -11606, 12953, -13076,  5638, -3386,  -609,  6699, -7568, 13007, -19600, 27137, -17618, 21669, -25344, 28183, -14826, 14589, -13088, 10048, -2618,  -754,  5127, -10473,  8347, -11807, 15485, -19208, 11378, -12935, 14120, -14751,  7303, -6699,  5349, -2887,  -182,  1224, -3878, 28205, },
	{  3093, -7377, 14313, -24266,  9274, -12968, 16650, -19492,  5079, -4397,  2374,  1478, -3818,  8248, -14141, 21484, -15043, 19771, -24598, 29064, -16291, 17227, -16953, 15066, -5590,  2482,  1908, -7629,  7319, -11392, 15896, -20627, 12658, -14811, 16576, -17724,  9002, -8570,  7414, -5363,  1101,  1176, -4379,  8918, -1960,  3378, -6476, 21944, },
	{  3234, -6944, 11934, -17640,  5708, -6366,  5647, -2599,  -974,  3755, -7969, 13823, -10696, 15279, -20470, 25921, -15555, 17664, -18852, 18614, -8205,  5853, -2012, -3497,  5382, -9873, 15128, -20958, 13539, -16552, 19277, -21429, 11344, -11355, 10571, -8812,  2954,  -848, -1992,  5649, -5111,  7927, -11401, 15787, -2706,  3809, -5922, 13410, },
	{  2024, -3849,  5293, -5189,   454,  1767, -6025, 13010, -5834,  9350, -13804, 19059, -12397, 15231, -17639, 19105, -9505,  8328, -5662,  1170,  2711, -7137, 12695, -19278, 13329, -17231, 21086, -24565, 13636, -14381, 14281, -13093,  5295, -3285,   435,  3307, -3980,  6756, -9954, 13534, -8723, 10821, -13046, 15411, -2251,  2641, -3226,  4723, },
	{   -87, -1926,  6836, -16130,  7838, -13457, 21069, -30587, 10384, -13233, 15797, -17519,  8841, -7721,  4939,   -37, -3693,  8805, -15362, 23274, -16143, 20975, -25804, 30195, -16809, 17733, -17541, 15899, -6247,  3530,   299, -5286,  5705, -9289, 13306, -17623, 11031, -13198, 15178, -16808,  8947, -9093,  8668, -7383,   581,   145, -2148, 29545, },
	{  2591, -6628, 13600, -24213,  9697, -14237, 19323, -24272,  7001, -7253,  6352, -3747,  -573,  4441, -9953, 17229, -13116, 18359, -24096, 29934, -17666, 19803, -20974, 20733, -9310,  7098, -3541, -1494,  4033, -8066, 12765, -17980, 11746, -14501, 17071, -19236, 10371, -10652, 10299, -9125,  3450, -1659, -1049,  5097, -1424,  2797, -5946, 24519, },
	{  3383, -7490, 13434, -20958,  7291, -9077,  9910, -8834,  1163,  1003, -4643, 10078, -8768, 13540, -19266, 25704, -16213, 19399, -21991, 23475, -11633, 10369, -7640,  3173,  1616, -5837, 11055, -17158, 11969, -15538, 19070, -22295, 12447, -13254, 13372, -12596,  5357, -3756,  1383,  1883, -3094,  5870, -9441, 14133, -2583,  3861, -6430, 16559, },
	{  2547, -5128,  7903, -9864,  2345, -1041, -2166,  8098, -4396,  7832, -12436, 18191, -12452, 16078, -19635, 22644, -12242, 12212, -10823,  7658, -1166, -2732,  7954, -14494, 11114, -15444, 20026, -24563, 14341, -15967, 16909, -16896,  7827, -6457,  4219, -1009, -1625,  4304, -7545, 11351, -7862, 10341, -13148, 16383, -2538,  3202, -4336,  7680, },
	{ -1368,   469,  2991, -10660,  6104, -11531, 19321, -29640, 10576, -14162, 17846, -21127, 11657, -11771, 10399, -7001,   523,  3962, -10110, 17959, -13698, 19058, -24795, 30528, -17878, 19938, -21095, 20977, -9602,  7708, -4652,   317,  2679, -6186, 10319, -14996, 10044, -12712, 15393, -17955, 10123, -11039, 11606, -11646,  1353, -1030,   -24, 30342, },
	{  1842, -5380, 11989, -22694,  9569, -14740, 21010, -27880,  8608, -9820, 10135, -8972,  2834,   234, -5039, 11832, -10368, 15844, -22190, 29107, -18064, 21311, -23897, 25357, -12590, 11420, -8918,  4869,   442, -4205,  8835, -14247, 10142, -13354, 16601, -19682, 11179, -12173, 12664, -12460,  5665, -4484,  2456,   826,  -778,  2010, -4992, 26720, },
	{  3322, -7621, 14245, -23271,  8550, -11423, 13837, -14887,  3339, -1938,  -898,  5590, -6254, 10950, -16904, 23995, -15958, 20072, -23961, 27130, -14489, 14414, -12979,  9836, -2337, -1368,  6250, -12287,  9678, -13611, 17767, -21905, 12862, -14436, 15470, -15742,  7507, -6515,  4759, -2086,  -846,  3415, -6873, 11600, -2303,  3691, -6609, 19592, },
	{  2979, -6231, 10275, -14323,  4232, -3971,  2051,  2438, -2626,  5783, -10282, 16228, -11786, 16025, -20569, 24998, -14366, 15518, -15520, 13900, -5088,  1953,  2628, -8753,  8206, -12728, 17792, -23154, 14240, -16675, 18628, -19816,  9966, -9329,  7844, -5362,   876,  1550, -4648,  8464, -6527,  9254, -12499, 16447, -2691,  3610, -5293, 10789, },
	{  1557, -2727,  3078, -1363, -1035,  3889, -8805, 16337, -6726, 10159, -14308, 18945, -11828, 13907, -15290, 15453, -6899,  4846, -1261, -4117,  5728, -10397, 15994, -22336, 14559, -17949, 21053, -23525, 12485, -12483, 11538, -9446,  3012,  -565, -2661,  6677, -5727,  8462, -11488, 14732, -9052, 10752, -12412, 13983, -1928,  2089, -2242,  2452, },
	{   866, -3661,  9501, -19690,  8861, -14400, 21554, -30041,  9791, -11933, 13494, -13893,  6211, -4145,   343,  5566, -6931, 12336, -18949, 26581, -17436, 21638, -25527, 28646, -15230, 15193, -13912, 11101, -3257,   -16,  4312, -9618,  7924, -11419, 15171, -19012, 11365, -13033, 14361, -15167,  7617, -7139,  5942, -3671,   -53,  1046, -3608, 28474, },
	{  3024, -7283, 14253, -24358,  9384, -13238, 17175, -20390,  5429, -4904,  3067,   587, -3276,  7627, -13478, 20839, -14773, 19609, -24612, 29333, -16595, 17743, -17717, 16107, -6256,  3291,   973, -6599,  6780, -10863, 15419, -20253, 12551, -14818, 16729, -18058,  9276, -8965,  7944, -6035,  1512,   692, -3823,  8298, -1877,  3293, -6414, 22413, },
	{  3273, -7065, 12237, -18275,  6001, -6854,  6397, -3675,  -612,  3298, -7431, 13237, -10409, 15042, -20346, 25990, -15732, 18035, -19470, 19529, -8831,  6657, -2993, -2359,  4753, -9216, 14485, -20386, 13323, -16444, 19320, -21666, 11581, -11730, 11099, -9503,  3382, -1355, -1417,  5021, -4783,  7604, -11110, 15567, -2696,  3834, -6031, 13959, },
	{  2119, -4079,  5755, -6001,   777,  1296, -5392, 12225, -5612,  9128, -13626, 18988, -12457, 15439, -18054, 19793, -10015,  9031, -6575,  2294,  2053, -6406, 11928, -18530, 13000, -16992, 20989, -24665, 13814, -14714, 14794, -13805,  5755, -3847,  1092,  2573, -3589,  6359, -9578, 13212, -8610, 10782, -13116, 15641, -2309,  2747, -3426,  5220, },
	{  -300, -1533,  6216, -15270,  7576, -13185, 20857, -30551, 10460, -13447, 16214, -18210,  9361, -8449,  5899, -1237, -2981,  8006, -14518, 22452, -15787, 20730, -25735, 30376, -17063, 18187, -18227, 16843, -6853,  4268,  -557, -4337,  5204, -8790, 12843, -17240, 10905, -13168, 15277, -17075,  9186, -9465,  9209, -8145,   715,   -53, -1808, 29722, },
	{  2479, -6447, 13385, -24057,  9715, -14381, 19691, -24989,  7305, -7723,  7027, -4660,    10,  3736, -9148, 16370, -12696, 18001, -23866, 29913, -17807, 20144, -21564, 21617, -9915,  7874, -4486,  -400,  3428, -7431, 12137, -17407, 11516, -14361, 17059, -19392, 10553, -10959, 10750, -9738,  3847, -2153,  -449,  4384, -1320,  2675, -5811, 24929, },
	{  3388, -7544, 13628, -21437,  7535, -9514, 10621, -9905,  1540,   503, -4019,  9349, -8372, 13150, -18938, 25515, -16235, 19594, -22421, 24202, -12173, 11110, -8593,  4338,   939, -5088, 10269, -16386, 11622, -15268, 18922, -22318, 12570, -13513, 13790, -13192,  5751, -4248,  1972,  1204, -2718,  5470, -9037, 13755, -2545,  3848, -6486, 17095, },
	{  2629, -5334,  8336, -10659,  2675, -1544, -1456,  7164, -4111,  7513, -12118, 17929, -12388, 16135, -19876, 23142, -12658, 12832, -11677,  8766, -1848, -1934,  7066, -13561, 10657, -15038, 19721, -24419, 14382, -16155, 17275, -17470,  8229, -6981,  4864, -1767, -1199,  3845, -7075, 10898, -7663, 10195, -13090, 16461, -2574,  3284, -4514,  8209, },
	{ -1600,   909,  2268, -9599,  5752, -11114, 18891, -29294, 10548, -14246, 18108, -21648, 12092, -12424, 11312, -8201,  1270,  3078, -9117, 16910, -13184, 18606, -24471, 30408, -17964, 20212, -21601, 21753, -10139,  8402, -5501,  1306,  2129, -5601,  9730, -14444,  9812, -12552, 15341, -18054, 10273, -11321, 12062, -12341,  1484, -1239,   381, 30422, },
	{  1689, -5114, 11620, -22280,  9488, -14743, 21190, -28364,  8846, -10223, 10753, -9854,  3426,  -519, -4133, 10801, -9818, 15304, -21722, 28790, -18030, 21455, -24277, 26029, -13098, 12119, -9818,  5967,  -197, -3497,  8088, -13504,  9799, -13074, 16421, -19646, 11256, -12372, 13009, -12978,  6025, -4960,  3066,    57,  -657,  1855, -4783, 27057, },
	{  3288, -7597, 14306, -23552,  8727, -11779, 14463, -15889,  3710, -2454,  -221,  4753, -5768, 10423, -16384, 23549, -15819, 20074, -24171, 27621, -14912, 15048, -13851, 10960, -3024,  -568,  5363, -11353,  9216, -13191, 17433, -21708, 12861, -14561, 15751, -16207,  7844, -6966,  5329, -2777,  -442,  2959, -6375, 11080, -2240,  3638, -6603, 20098, },
	{  3041, -6398, 10649, -15051,  4550, -4478,  2801,  1403, -2292,  5381, -9835, 15781, -11597, 15922, -20615, 25271, -14660, 16015, -16265, 14928, -5755,  2774,  1668, -7684,  7642, -12173, 17292, -22770, 14140, -16703, 18824, -20217, 10286, -9783,  8439, -6101,  1313,  1054, -4108,  7903, -6252,  9007, -12310, 16363, -2703,  3663, -5439, 11336, },
	{  1656, -2964,  3541, -2153,  -732,  3464, -8259, 15702, -6563, 10024, -14250, 19030, -11984, 14228, -15828, 16263, -7464,  5588, -2183, -3027,  5117, -9751, 15357, -21770, 14349, -17857, 21128, -23818, 12766, -12920, 12149, -10239,  3499, -1136, -2022,  5994, -5380,  8132, -11204, 14529, -9013, 10801, -12584, 14325, -2001,  2210, -2450,  2912, },
	{   677, -3319,  8987, -19023,  8679, -14252, 21524, -30251,  9946, -12241, 14016, -14692,  6778, -4903,  1301,  4417, -6279, 11640, -18262, 25977, -17222, 21569, -25667, 29062, -15609, 15773, -14715, 12140, -3893,   725,  3487, -8743,  7485, -11011, 14830, -18783, 11331, -13110, 14578, -15558,  7919, -7569,  6528, -4454,    78,   865, -3326, 28728, },
	{  2948, -7174, 14167, -24409,  9479, -13487, 17675, -21260,  5772, -5408,  3759,  -312, -2725,  6989, -12788, 20155, -14475, 19412, -24584, 29553, -16872, 18230, -18454, 17125, -6914,  4097,    33, -5553,  6228, -10313, 14913, -19843, 12423, -14799, 16854, -18362,  9535, -9347,  8461, -6700,  1921,   204, -3257,  7659, -1789,  3202, -6340, 22872, },
	{  3307, -7176, 12523, -18887,  6286, -7335,  7144, -4755,  -246,  2833, -6876, 12623, -10101, 14778, -20187, 26015, -15883, 18378, -20059, 20415, -9444,  7453, -3973, -1211,  4113, -8540, 13815, -19777, 13083, -16308, 19330, -21868, 11800, -12087, 11610, -10181,  3806, -1861,  -836,  4381, -4446,  7267, -10798, 15319, -2681,  3852, -6131, 14507, },
	{  2212, -4306,  6213, -6814,  1102,   818, -4743, 11410, -5378,  8889, -13423, 18884, -12496, 15622, -18442, 20450, -10512,  9723, -7482,  3421,  1388, -5660, 11137, -17747, 12648, -16724, 20855, -24723, 13968, -15024, 15284, -14496,  6207, -4406,  1749,  1832, -3190,  5950, -9184, 12866, -8482, 10725, -13165, 15846, -2364,  2850, -3623,  5724, },
	{  -517, -1129,  5575, -14372,  7297, -12886, 20607, -30461, 10518, -13639, 16605, -18876,  9869, -9168,  6855, -2442, -2261,  7189, -13646, 21587, -15402, 20448, -25622, 30506, -17288, 18611, -18885, 17761, -7450,  5001, -1415, -3378,  4693, -8273, 12357, -16827, 10760, -13115, 15350, -17314,  9411, -9824,  9737, -8898,   849,  -254, -1456, 29884, },
	{  2359, -6251, 13144, -23856,  9717, -14502, 20028, -25669,  7599, -8183,  7695, -5571,   597,  3019, -8322, 15478, -12252, 17609, -23593, 29842, -17918, 20453, -22121, 22468, -10506,  8640, -5427,   700,  2815, -6780, 11485, -16803, 11266, -14197, 17018, -19515, 10718, -11248, 11184, -10338,  4239, -2646,   154,  3659, -1212,  2547, -5664, 25327, },
	{  3387, -7586, 13799, -21885,  7769, -9939, 11320, -10968,  1918,    -2, -3384,  8598, -7959, 12735, -18576, 25281, -16230, 19757, -22814, 24891, -12696, 11835, -9537,  5500,   258, -4327,  9462, -15582, 11253, -14971, 18741, -22304, 12672, -13749, 14186, -13768,  6137, -4736,  2561,   521, -2336,  5059, -8615, 13351, -2503,  3828, -6532, 17627, },
	{  2709, -5535,  8760, -11446,  3004, -2050,  -736,  6209, -3817,  7178, -11776, 17633, -12303, 16164, -20085, 23603, -13055, 13433, -12516,  9865, -2530, -1129,  6163, -12601, 10179, -14604, 19381, -24234, 14399, -16315, 17614, -18017,  8619, -7495,  5503, -2524,  -769,  3378, -6590, 10425, -7451, 10032, -13009, 16511, -2607,  3362, -4688,  8743, },
	{ -1834,  1355,  1531, -8507,  5387, -10673, 18425, -28894, 10502, -14305, 18340, -22135, 12509, -13061, 12211, -9393,  2020,  2183, -8103, 15827, -12645, 18121, -24104, 30237, -18018, 20453, -22073, 22496, -10662,  9085, -6343,  2297,  1572, -5004,  9123, -13865,  9561, -12370, 15263, -18123, 10406, -11585, 12501, -13021,  1614, -1448,   796, 30486, },
	{  1529, -4835, 11224, -21821,  9390, -14720, 21334, -28803,  9071, -10611, 11357, -10725,  4016, -1275, -3215,  9746, -9248, 14735, -21214, 28422, -17964, 21562, -24616, 26659, -13585, 12800, -10705,  7059,  -837, -2780,  7324, -12735,  9439, -12770, 16212, -19577, 11315, -12550, 13333, -13477,  6377, -5431,  3675,  -718,  -534,  1695, -4561, 27381, },
	{  3246, -7559, 14343, -23796,  8891, -12119, 15071, -16872,  4078, -2971,   461,  3903, -5268,  9875, -15832, 23061, -15652, 20042, -24341, 28068, -15311, 15659, -14703, 12070, -3709,   237,  4463, -10396,  8737, -12747, 17068, -21474, 12838, -14662, 16006, -16647,  8168, -7406,  5893, -3466,   -36,  2496, -5864, 10537, -2172,  3579, -6586, 20597, },
	{  3099, -6555, 11009, -15763,  4864, -4983,  3554,   357, -1951,  4967, -9368, 15303, -11388, 15791, -20626, 25502, -14931, 16488, -16986, 15936, -6415,  3593,   700, -6596,  7063, -11594, 16762, -22345, 14015, -16703, 18988, -20585, 10590, -10222,  9023, -6832,  1750,   554, -3559,  7327, -5966,  8743, -12100, 16250, -2710,  3710, -5577, 11884, },
	{  1754, -3200,  4005, -2949,  -424,  3028, -7694, 15034, -6387,  9871, -14167, 19083, -12121, 14526, -16343, 17051, -8020,  6323, -3105, -1927,  4494, -9084, 14690, -21163, 14113, -17734, 21167, -24072, 13026, -13337, 12741, -11018,  3982, -1706, -1377,  5298, -5023,  7788, -10900, 14301, -8958, 10832, -12736, 14645, -2071,  2328, -2658,  3380, },
	{   482, -2966,  8449, -18313,  8480, -14078, 21456, -30412, 10085, -12531, 14518, -15471,  7337, -5657,  2263,  3254, -5612, 10920, -17540, 25325, -16978, 21463, -25764, 29430, -15963, 16328, -15497, 13162, -4524,  1468,  2653, -7850,  7032, -10582, 14462, -18521, 11279, -13164, 14771, -15925,  8209, -7989,  7108, -5235,   210,   679, -3031, 28966, },
	{  2864, -7051, 14054, -24417,  9559, -13716, 18150, -22101,  6108, -5906,  4450, -1216, -2165,  6334, -12072, 19432, -14151, 19180, -24513, 29724, -17122, 18688, -19163, 18118, -7563,  4899,  -911, -4494,  5663, -9744, 14381, -19398, 12274, -14755, 16951, -18637,  9778, -9714,  8967, -7356,  2329,  -287, -2683,  7003, -1698,  3104, -6253, 23322, },
	{  3336, -7275, 12791, -19473,  6564, -7809,  7886, -5836,   123,  2359, -6306, 11984, -9774, 14487, -19993, 25995, -16008, 18691, -20616, 21271, -10044,  8241, -4950,   -56,  3463, -7846, 13118, -19132, 12820, -16143, 19307, -22032, 11999, -12424, 12103, -10843,  4225, -2366,  -252,  3732, -4099,  6916, -10466, 15043, -2662,  3863, -6223, 15054, },
	{  2304, -4529,  6667, -7625,  1430,   334, -4079, 10569, -5133,  8632, -13196, 18747, -12514, 15779, -18800, 21077, -10993, 10403, -8381,  4547,   717, -4901, 10323, -16930, 12273, -16425, 20686, -24739, 14100, -15309, 15749, -15165,  6650, -4958,  2406,  1086, -2784,  5529, -8772, 12496, -8338, 10649, -13192, 16025, -2415,  2949, -3817,  6234, },
	{  -738,  -717,  4916, -13437,  7003, -12562, 20320, -30319, 10558, -13809, 16971, -19513, 10363, -9875,  7805, -3649, -1532,  6355, -12745, 20681, -14989, 20129, -25464, 30584, -17485, 19006, -19514, 18653, -8036,  5728, -2274, -2409,  4172, -7741, 11847, -16383, 10597, -13040, 15398, -17524,  9621, -10167, 10253, -9642,   983,  -457, -1092, 30028, },
	{  2232, -6041, 12875, -23611,  9702, -14599, 20334, -26310,  7882, -8633,  8355, -6479,  1188,  2293, -7477, 14554, -11785, 17186, -23279, 29718, -17999, 20728, -22643, 23284, -11081,  9395, -6362,  1803,  2194, -6116, 10812, -16167, 10995, -14008, 16948, -19605, 10865, -11519, 11602, -10923,  4625, -3137,   761,  2922, -1101,  2413, -5504, 25713, },
	{  3379, -7614, 13949, -22300,  7992, -10352, 12007, -12023,  2296,  -511, -2738,  7827, -7529, 12295, -18180, 25002, -16197, 19887, -23171, 25541, -13199, 12544, -10468,  6658,  -427, -3556,  8636, -14748, 10863, -14647, 18528, -22251, 12752, -13963, 14559, -14322,  6513, -5217,  3148,  -166, -1948,  4638, -8176, 12922, -2457,  3801, -6567, 18155, },
	{  2785, -5729,  9175, -12224,  3333, -2558,    -7,  5235, -3513,  6829, -11411, 17306, -12196, 16166, -20260, 24027, -13432, 14014, -13338, 10953, -3211,  -318,  5244, -11615,  9682, -14143, 19007, -24006, 14391, -16449, 17924, -18535,  8995, -7997,  6134, -3280,  -336,  2903, -6093,  9931, -7224,  9850, -12905, 16533, -2635,  3435, -4856,  9281, },
	{ -2069,  1806,   780, -7387,  5008, -10209, 17921, -28440, 10437, -14340, 18543, -22588, 12907, -13679, 13094, -10577,  2770,  1280, -7071, 14711, -12082, 17602, -23695, 30013, -18043, 20660, -22509, 23203, -11168,  9755, -7178,  3287,  1011, -4396,  8498, -13261,  9293, -12166, 15159, -18161, 10522, -11830, 12921, -13683,  1742, -1658,  1221, 30532, },
	{  1362, -4543, 10803, -21317,  9275, -14671, 21443, -29197,  9282, -10983, 11946, -11584,  4604, -2034, -2285,  8667, -8659, 14137, -20667, 28003, -17867, 21633, -24915, 27247, -14052, 13463, -11578,  8144, -1478, -2056,  6546, -11941,  9061, -12443, 15976, -19474, 11355, -12707, 13636, -13955,  6719, -5894,  4281, -1496,  -409,  1530, -4327, 27691, },
	{  3198, -7507, 14355, -24000,  9041, -12441, 15659, -17836,  4443, -3486,  1147,  3040, -4756,  9306, -15249, 22530, -15457, 19975, -24471, 28468, -15687, 16246, -15533, 13165, -4390,  1044,  3552, -9417,  8240, -12279, 16672, -21202, 12792, -14738, 16235, -17059,  8480, -7836,  6449, -4153,   373,  2026, -5340,  9973, -2099,  3513, -6557, 21089, },
	{  3152, -6704, 11356, -16457,  5172, -5485,  4307,  -700, -1604,  4540, -8881, 14796, -11157, 15631, -20601, 25691, -15177, 16935, -17681, 16922, -7068,  4410,  -273, -5493,  6470, -10994, 16200, -21880, 13865, -16674, 19121, -20920, 10877, -10645,  9593, -7554,  2186,    51, -3001,  6735, -5668,  8463, -11867, 16109, -2713,  3751, -5708, 12433, },
	{  1852, -3435,  4469, -3752,  -111,  2582, -7109, 14333, -6199,  9699, -14058, 19104, -12238, 14801, -16832, 17814, -8565,  7052, -4028,  -818,  3861, -8399, 13996, -20518, 13853, -17580, 21170, -24286, 13265, -13732, 13314, -11780,  4460, -2276,  -728,  4590, -4656,  7429, -10577, 14047, -8887, 10844, -12866, 14942, -2139,  2444, -2864,  3857, },
	{   281, -2601,  7888, -17563,  8264, -13878, 21351, -30521, 10207, -12802, 14999, -16228,  7888, -6406,  3226,  2078, -4932, 10177, -16785, 24627, -16704, 21321, -25818, 29750, -16291, 16858, -16255, 14166, -5150,  2212,  1811, -6940,  6566, -10133, 14069, -18226, 11207, -13196, 14939, -16266,  8486, -8397,  7678, -6013,   343,   489, -2724, 29189, },
	{  2772, -6912, 13914, -24383,  9623, -13923, 18597, -22912,  6437, -6397,  5138, -2125, -1597,  5665, -11330, 18671, -13801, 18915, -24401, 29844, -17343, 19117, -19843, 19085, -8202,  5697, -1858, -3423,  5086, -9155, 13822, -18917, 12102, -14686, 17020, -18880, 10006, -10066,  9459, -8002,  2735,  -780, -2101,  6330, -1602,  2999, -6154, 23762, },
	{  3358, -7363, 13040, -20033,  6834, -8274,  8622, -6918,   496,  1877, -5719, 11319, -9429, 14170, -19763, 25930, -16106, 18973, -21141, 22095, -10630,  9017, -5924,  1104,  2805, -7136, 12397, -18452, 12533, -15950, 19251, -22160, 12178, -12741, 12578, -11490,  4638, -2869,   335,  3073, -3744,  6551, -10114, 14739, -2637,  3868, -6306, 15598, },
	{  2393, -4749,  7117, -8435,  1759,  -157, -3402,  9701, -4877,  8359, -12944, 18576, -12511, 15910, -19128, 21671, -11458, 11068, -9270,  5671,    42, -4129,  9488, -16081, 11875, -16098, 20480, -24713, 14208, -15568, 16190, -15810,  7083, -5505,  3062,   334, -2371,  5097, -8345, 12103, -8180, 10554, -13196, 16177, -2463,  3044, -4007,  6750, },
	{  -962,  -297,  4238, -12467,  6692, -12213, 19994, -30122, 10581, -13957, 17311, -20121, 10843, -10570,  8748, -4858,  -797,  5506, -11818, 19735, -14548, 19775, -25262, 30610, -17653, 19369, -20112, 19516, -8611,  6448, -3132, -1433,  3642, -7194, 11316, -15909, 10414, -12942, 15419, -17706,  9816, -10496, 10754, -10375,  1117,  -662,  -717, 30156, },
	{  2098, -5816, 12580, -23321,  9670, -14672, 20607, -26912,  8154, -9071,  9006, -7382,  1780,  1558, -6614, 13599, -11294, 16730, -22924, 29544, -18050, 20969, -23128, 24064, -11640, 10137, -7290,  2908,  1568, -5438, 10117, -15501, 10705, -13794, 16849, -19662, 10994, -11772, 12001, -11492,  5006, -3626,  1371,  2175,  -987,  2273, -5331, 26087, },
	{  3365, -7629, 14076, -22681,  8203, -10750, 12680, -13066,  2673, -1023, -2083,  7037, -7083, 11831, -17750, 24679, -16136, 19984, -23490, 26150, -13683, 13234, -11386,  7810, -1114, -2775,  7792, -13886, 10454, -14297, 18283, -22160, 12811, -14154, 14908, -14855,  6880, -5692,  3732,  -856, -1555,  4206, -7721, 12468, -2405,  3768, -6592, 18677, },
	{  2858, -5916,  9581, -12991,  3659, -3066,   729,  4242, -3201,  6465, -11024, 16946, -12068, 16140, -20402, 24412, -13787, 14575, -14142, 12028, -3890,   497,  4312, -10604,  9166, -13656, 18599, -23736, 14359, -16555, 18204, -19024,  9358, -8488,  6758, -4034,    99,  2421, -5583,  9419, -6985,  9651, -12779, 16527, -2659,  3503, -5019,  9821, },
	{ -2305,  2261,    18, -6240,  4616, -9723, 17382, -27934, 10354, -14350, 18715, -23005, 13285, -14277, 13960, -11749,  3519,   370, -6021, 13565, -11495, 17051, -23242, 29737, -18036, 20832, -22908, 23873, -11658, 10411, -8004,  4276,   446, -3779,  7856, -12631,  9008, -11941, 15029, -18168, 10620, -12057, 13321, -14327,  1869, -1869,  1656, 30561, },
	{  1189, -4237, 10356, -20770,  9141, -14597, 21516, -29544,  9478, -11340, 12519, -12430,  5187, -2794, -1346,  7568, -8052, 13512, -20081, 27535, -17739, 21668, -25173, 27791, -14496, 14105, -12434,  9219, -2120, -1326,  5753, -11124,  8666, -12094, 15711, -19337, 11376, -12844, 13917, -14412,  7052, -6350,  4883, -2278,  -282,  1360, -4079, 27986, },
	{  3142, -7439, 14341, -24165,  9178, -12745, 16225, -18777,  4802, -3999,  1837,  2165, -4233,  8718, -14637, 21958, -15235, 19874, -24558, 28822, -16037, 16808, -16341, 14242, -5067,  1853,  2630, -8419,  7728, -11789, 16247, -20893, 12725, -14789, 16437, -17444,  8779, -8253,  6996, -4835,   782,  1550, -4804,  9387, -2023,  3440, -6516, 21573, },
	{  3200, -6843, 11687, -17130,  5476, -5982,  5061, -1765, -1252,  4102, -8375, 14260, -10906, 15444, -20541, 25838, -15399, 17356, -18350, 17883, -7712,  5224, -1251, -4375,  5863, -10371, 15608, -21376, 13691, -16617, 19221, -21220, 11147, -11051, 10149, -8266,  2619,  -454, -2436,  6129, -5358,  8168, -11613, 15939, -2711,  3786, -5831, 12983, },
	{  1949, -3669,  4933, -4559,   206,  2127, -6506, 13601, -5998,  9510, -13925, 19091, -12335, 15052, -17296, 18551, -9098,  7773, -4949,   298,  3217, -7696, 13274, -19835, 13568, -17395, 21137, -24459, 13482, -14106, 13866, -12526,  4932, -2845,   -75,  3872, -4279,  7055, -10234, 13768, -8801, 10839, -12975, 15215, -2203,  2556, -3068,  4341, },
	{    76, -2226,  7305, -16772,  8031, -13651, 21207, -30578, 10313, -13052, 15457, -16964,  8428, -7148,  4190,   892, -4239,  9413, -15996, 23883, -16400, 21141, -25827, 30020, -16593, 17361, -16988, 15149, -5770,  2954,   963, -6015,  6086, -9665, 13649, -17899, 11115, -13206, 15083, -16582,  8750, -8793,  8239, -6786,   477,   297, -2405, 29395, },
	{  2673, -6758, 13748, -24304,  9671, -14108, 19017, -23690,  6758, -6882,  5823, -3037, -1024,  4982, -10565, 17874, -13426, 18615, -24246, 29914, -17536, 19515, -20491, 20024, -8830,  6488, -2805, -2341,  4498, -8549, 13237, -18403, 11910, -14592, 17060, -19093, 10218, -10402,  9937, -8638,  3139, -1274, -1511,  5642, -1504,  2888, -6042, 24192, },
	{  3374, -7439, 13270, -20565,  7095, -8730,  9350, -7997,   870,  1388, -5119, 10630, -9064, 13825, -19497, 25821, -16177, 19225, -21633, 22885, -11200,  9783, -6892,  2267,  2139, -6411, 11651, -17737, 12225, -15729, 19162, -22250, 12337, -13038, 13033, -12119,  5045, -3369,   924,  2406, -3381,  6173, -9743, 14409, -2608,  3867, -6379, 16140, },
	{  2480, -4964,  7562, -9240,  2088,  -653, -2711,  8808, -4610,  8069, -12668, 18373, -12486, 16015, -19426, 22231, -11906, 11718, -10148,  6791,  -637, -3347,  8632, -15200, 11455, -15741, 20238, -24645, 14292, -15803, 16605, -16431,  7506, -6044,  3714,  -421, -1953,  4655, -7901, 11689, -8006, 10441, -13178, 16303, -2507,  3134, -4194,  7271, },
	{ -1190,   132,  3543, -11463,  6367, -11839, 19630, -29872, 10585, -14081, 17623, -20699, 11307, -11251,  9681, -6065,   -56,  4642, -10866, 18751, -14080, 19385, -25016, 30584, -17791, 19702, -20678, 20350, -9174,  7161, -3988,  -450,  3103, -6632, 10763, -15407, 10213, -12821, 15415, -17858,  9995, -10808, 11239, -11095,  1250,  -868,  -332, 30267, },
	{  1957, -5576, 12258, -22986,  9620, -14720, 20847, -27473,  8414, -9497,  9646, -8280,  2373,   816, -5734, 12616, -10782, 16244, -22527, 29318, -18070, 21175, -23575, 24806, -12181, 10864, -8210,  4012,   936, -4748,  9403, -14807, 10396, -13556, 16720, -19686, 11105, -12005, 12381, -12043,  5380, -4110,  1981,  1419,  -870,  2127, -5145, 26448, },
	{  3343, -7630, 14180, -23027,  8403, -11134, 13337, -14096,  3048, -1537, -1419,  6229, -6622, 11344, -17287, 24311, -16046, 20046, -23770, 26718, -14145, 13906, -12289,  8953, -1802, -1986,  6931, -12997, 10025, -13921, 18005, -22031, 12848, -14322, 15234, -15363,  7237, -6158,  4311, -1548, -1158,  3765, -7250, 11989, -2350,  3727, -6606, 19194, },
	{  2927, -6097,  9976, -13746,  3982, -3575,  1471,  3233, -2880,  6087, -10615, 16554, -11917, 16087, -20509, 24757, -14121, 15114, -14925, 13087, -4565,  1315,  3369, -9571,  8633, -13144, 18158, -23425, 14302, -16633, 18454, -19481,  9706, -8967,  7373, -4783,   536,  1933, -5061,  8889, -6732,  9434, -12630, 16493, -2679,  3565, -5176, 10365, },
	{ -2542,  2719,  -755, -5068,  4212, -9215, 16808, -27375, 10252, -14336, 18857, -23385, 13643, -14855, 14808, -12908,  4267,  -546, -4955, 12389, -10886, 16469, -22749, 29408, -17999, 20970, -23270, 24506, -12129, 11051, -8820,  5261,  -122, -3153,  7198, -11978,  8707, -11694, 14872, -18144, 10701, -12265, 13701, -14951,  1994, -2079,  2100, 30572, },
	{  1010, -3917,  9885, -20179,  8990, -14496, 21552, -29842,  9660, -11680, 13075, -13259,  5766, -3555,  -398,  6449, -7428, 12860, -19459, 27017, -17581, 21665, -25389, 28290, -14918, 14725, -13273, 10283, -2760,  -590,  4947, -10285,  8254, -11723, 15418, -19167, 11377, -12959, 14176, -14845,  7374, -6797,  5481, -3061,  -154,  1185, -3819, 28266, },
	{  3079, -7357, 14302, -24290,  9300, -13030, 16768, -19694,  5157, -4510,  2528,  1281, -3699,  8111, -13996, 21344, -14986, 19738, -24605, 29128, -16361, 17344, -17125, 15299, -5739,  2662,  1701, -7401,  7200, -11276, 15792, -20547, 12636, -14815, 16612, -17800,  9064, -8659,  7533, -5512,  1193,  1069, -4256,  8782, -1942,  3360, -6464, 22049, },
	{  3243, -6972, 12003, -17783,  5774, -6475,  5814, -2838,  -894,  3654, -7851, 13695, -10634, 15229, -20445, 25940, -15596, 17749, -18992, 18820, -8345,  6033, -2230, -3245,  5243, -9729, 14987, -20834, 13493, -16531, 19290, -21485, 11398, -11440, 10689, -8967,  3050,  -961, -1865,  5510, -5039,  7857, -11338, 15740, -2705,  3815, -5947, 13532, },
	{  2045, -3901,  5396, -5370,   526,  1663, -5886, 12838, -5785,  9302, -13766, 19046, -12412, 15279, -17733, 19260, -9619,  8485, -5866,  1420,  2565, -6976, 12527, -19115, 13258, -17180, 21068, -24591, 13677, -14457, 14397, -13253,  5398, -3410,   581,  3145, -3894,  6669, -9872, 13465, -8700, 10814, -13063, 15464, -2264,  2665, -3270,  4833, },
	{  -134, -1840,  6700, -15942,  7781, -13399, 21025, -30583, 10402, -13282, 15892, -17675,  8958, -7883,  5152,  -303, -3536,  8629, -15177, 23095, -16067, 20924, -25792, 30240, -16868, 17837, -17696, 16111, -6383,  3694,   109, -5076,  5595, -9180, 13205, -17541, 11004, -13193, 15202, -16870,  9001, -9177,  8789, -7553,   611,   101, -2074, 29586, },
	{  2567, -6589, 13555, -24183,  9702, -14271, 19408, -24434,  7069, -7359,  6503, -3950,  -444,  4285, -9776, 17041, -13025, 18283, -24048, 29934, -17700, 19881, -21108, 20932, -9446,  7271, -3751, -1252,  3900, -7926, 12627, -17856, 11696, -14472, 17071, -19273, 10413, -10722, 10401, -9262,  3539, -1769,  -916,  4940, -1401,  2771, -5917, 24611, },
	{  3385, -7503, 13479, -21067,  7346, -9175, 10069, -9072,  1247,   892, -4505,  9918, -8682, 13455, -19196, 25666, -16220, 19445, -22090, 23640, -11754, 10535, -7852,  3432,  1466, -5672, 10882, -16989, 11894, -15480, 19040, -22303, 12476, -13313, 13467, -12730,  5445, -3866,  1514,  1732, -3011,  5782, -9353, 14052, -2575,  3859, -6443, 16678, },
	{  2565, -5175,  8000, -10041,  2419, -1153, -2009,  7892, -4333,  7762, -12368, 18136, -12439, 16093, -19692, 22757, -12337, 12351, -11014,  7905, -1317, -2556,  7758, -14289, 11014, -15356, 19961, -24535, 14352, -16011, 16993, -17026,  7917, -6575,  4363, -1178, -1530,  4203, -7442, 11252, -7819, 10310, -13137, 16402, -2546,  3220, -4376,  7797, },
	{ -1420,   567,  2832, -10427,  6027, -11440, 19229, -29567, 10572, -14183, 17907, -21245, 11755, -11917, 10603, -7268,   689,  3767, -9891, 17729, -13586, 18961, -24727, 30506, -17900, 20001, -21210, 21152, -9722,  7863, -4841,   537,  2558, -6057, 10190, -14876,  9994, -12679, 15384, -17980, 10158, -11103, 11709, -11802,  1382, -1076,    65, 30361, },
	{  1809, -5322, 11909, -22606,  9553, -14743, 21053, -27991,  8662, -9911, 10274, -9169,  2966,    67, -4839, 11605, -10248, 15727, -22090, 29041, -18059, 21346, -23985, 25510, -12704, 11577, -9119,  5113,   300, -4048,  8670, -14084, 10067, -13294, 16563, -19677, 11197, -12219, 12742, -12577,  5746, -4591,  2592,   655,  -751,  1976, -4946, 26796, },
	{  3315, -7617, 14261, -23337,  8590, -11503, 13978, -15111,  3422, -2053,  -748,  5405, -6147, 10834, -16791, 23899, -15929, 20075, -24011, 27243, -14585, 14556, -13175, 10086, -2490, -1190,  6054, -12082,  9577, -13520, 17695, -21864, 12864, -14466, 15535, -15848,  7583, -6616,  4886, -2239,  -756,  3315, -6763, 11487, -2290,  3680, -6609, 19705, },
	{  2993, -6269, 10359, -14486,  4303, -4084,  2218,  2209, -2552,  5695, -10185, 16131, -11746, 16005, -20582, 25062, -14433, 15630, -15688, 14130, -5237,  2135,  2415, -8517,  8082, -12607, 17684, -23072, 14220, -16684, 18674, -19908, 10038, -9432,  7977, -5527,   973,  1440, -4529,  8341, -6467,  9200, -12459, 16431, -2694,  3622, -5326, 10910, },
	{  1579, -2779,  3181, -1538,  -968,  3796, -8685, 16199, -6691, 10131, -14297, 18967, -11864, 13980, -15411, 15635, -7026,  5011, -1466, -3875,  5594, -10255, 15855, -22214, 14514, -17931, 21073, -23593, 12549, -12581, 11675, -9623,  3120,  -692, -2520,  6526, -5651,  8390, -11427, 14689, -9045, 10764, -12452, 14060, -1944,  2116, -2288,  2553, },
	{   825, -3586,  9389, -19545,  8822, -14369, 21551, -30092,  9827, -12003, 13612, -14072,  6338, -4314,   556,  5312, -6788, 12183, -18800, 26451, -17391, 21626, -25562, 28742, -15316, 15324, -14092, 11333, -3399,   149,  4130, -9425,  7828, -11330, 15098, -18964, 11359, -13052, 14411, -15256,  7685, -7235,  6073, -3845,   -24,  1006, -3547, 28532, },
	{  3008, -7260, 14236, -24373,  9407, -13295, 17288, -20586,  5505, -5017,  3220,   388, -3154,  7486, -13327, 20690, -14709, 19568, -24609, 29386, -16659, 17853, -17883, 16335, -6403,  3470,   765, -6368,  6659, -10742, 15309, -20165, 12525, -14816, 16759, -18128,  9334, -9051,  8060, -6183,  1603,   584, -3698,  8158, -1858,  3274, -6399, 22515, },
	{  3281, -7091, 12302, -18413,  6065, -6961,  6564, -3915,  -531,  3196, -7309, 13103, -10342, 14986, -20314, 25999, -15768, 18114, -19604, 19728, -8968,  6835, -3211, -2104,  4611, -9067, 14338, -20254, 13272, -16417, 19325, -21714, 11631, -11811, 11214, -9655,  3477, -1467, -1288,  4880, -4709,  7531, -11042, 15514, -2693,  3838, -6054, 14081, },
	{  2140, -4130,  5857, -6182,   849,  1191, -5249, 12046, -5561,  9076, -13583, 18968, -12467, 15482, -18143, 19941, -10127,  9186, -6777,  2545,  1905, -6241, 11754, -18359, 12924, -16935, 20962, -24681, 13850, -14785, 14905, -13960,  5856, -3972,  1238,  2409, -3501,  6269, -9492, 13137, -8583, 10771, -13129, 15689, -2322,  2770, -3470,  5332, },
	{  -348, -1444,  6075, -15074,  7515, -13120, 20805, -30535, 10474, -13491, 16303, -18361,  9475, -8610,  6112, -1504, -2822,  7826, -14327, 22263, -15704, 20670, -25714, 30409, -17115, 18284, -18376, 17049, -6987,  4431,  -747, -4125,  5092, -8676, 12737, -17151, 10875, -13158, 15295, -17130,  9237, -9546,  9327, -8313,   745,   -98, -1731, 29760, },
	{  2453, -6405, 13334, -24016,  9717, -14410, 19769, -25143,  7371, -7826,  7176, -4862,   140,  3577, -8967, 16175, -12600, 17917, -23809, 29902, -17834, 20216, -21691, 21809, -10048,  8045, -4695,  -156,  3293, -7287, 11994, -17276, 11462, -14327, 17052, -19422, 10591, -11025, 10848, -9873,  3934, -2263,  -315,  4224, -1296,  2647, -5780, 25018, },
	{  3388, -7555, 13668, -21540,  7588, -9610, 10777, -10142,  1624,   391, -3879,  9184, -8282, 13060, -18861, 25467, -16237, 19633, -22511, 24358, -12291, 11272, -8804,  4596,   788, -4920, 10091, -16210, 11541, -15204, 18885, -22318, 12594, -13567, 13880, -13322,  5837, -4357,  2103,  1053, -2634,  5380, -8945, 13668, -2536,  3844, -6497, 17214, },
	{  2647, -5379,  8431, -10835,  2748, -1657, -1297,  6954, -4046,  7440, -12044, 17866, -12371, 16144, -19925, 23247, -12748, 12967, -11865,  9011, -1999, -1756,  6867, -13350, 10552, -14944, 19649, -24382, 14388, -16193, 17353, -17594,  8317, -7096,  5006, -1935, -1103,  3742, -6968, 10795, -7617, 10161, -13074, 16474, -2582,  3302, -4553,  8328, },
	{ -1652,  1008,  2106, -9359,  5672, -11018, 18791, -29209, 10540, -14261, 18162, -21759, 12186, -12567, 11513, -8467,  1437,  2880, -8893, 16672, -13067, 18502, -24393, 30375, -17978, 20268, -21709, 21921, -10257,  8555, -5688,  1526,  2005, -5469,  9597, -14318,  9757, -12514, 15326, -18072, 10304, -11381, 12161, -12494,  1513, -1285,   472, 30438, },
	{  1654, -5054, 11534, -22182,  9468, -14740, 21225, -28466,  8897, -10310, 10889, -10049,  3558,  -686, -3930, 10569, -9693, 15180, -21612, 28712, -18018, 21482, -24355, 26173, -13208, 12272, -10016,  6210,  -339, -3338,  7920, -13335,  9721, -13008, 16377, -19633, 11271, -12413, 13083, -13091,  6104, -5066,  3202,  -115,  -630,  1820, -4735, 27131, },
	{  3279, -7590, 14317, -23610,  8765, -11856, 14600, -16109,  3792, -2569,   -70,  4566, -5658, 10303, -16264, 23444, -15784, 20070, -24213, 27724, -15003, 15185, -14042, 11208, -3176,  -389,  5164, -11142,  9111, -13095, 17354, -21659, 12858, -14585, 15810, -16307,  7917, -7064,  5455, -2930,  -352,  2857, -6263, 10961, -2225,  3626, -6600, 20210, },
	{  3054, -6433, 10730, -15211,  4620, -4590,  2968,  1172, -2217,  5290, -9733, 15677, -11553, 15895, -20620, 25326, -14722, 16122, -16427, 15154, -5902,  2956,  1453, -7443,  7515, -12046, 17177, -22679, 14114, -16705, 18863, -20302, 10355, -9882,  8570, -6264,  1411,   943, -3987,  7776, -6190,  8950, -12265, 16340, -2705,  3674, -5470, 11457, },
	{  1678, -3016,  3644, -2329,  -664,  3368, -8135, 15556, -6525,  9992, -14234, 19045, -12016, 14296, -15944, 16440, -7589,  5752, -2388, -2784,  4980, -9604, 15211, -21638, 14299, -17832, 21140, -23878, 12826, -13014, 12282, -10413,  3607, -1262, -1879,  5840, -5302,  8057, -11138, 14481, -9002, 10809, -12620, 14398, -2017,  2237, -2497,  3015, },
	{   634, -3242,  8869, -18869,  8637, -14216, 21512, -30291,  9978, -12307, 14129, -14866,  6903, -5071,  1515,  4160, -6132, 11482, -18105, 25836, -17171, 21549, -25693, 29148, -15690, 15898, -14891, 12369, -4033,   890,  3302, -8546,  7386, -10917, 14751, -18727, 11321, -13124, 14623, -15642,  7984, -7663,  6658, -4628,   108,   824, -3261, 28782, },
	{  2930, -7148, 14144, -24414,  9499, -13540, 17783, -21449,  5847, -5519,  3912,  -512, -2601,  6845, -12631, 19997, -14406, 19363, -24572, 29595, -16930, 18334, -18614, 17348, -7059,  4275,  -177, -5319,  6103, -10188, 14797, -19747, 12392, -14792, 16878, -18426,  9590, -9430,  8575, -6846,  2012,    95, -3130,  7515, -1769,  3181, -6322, 22973, },
	{  3314, -7199, 12584, -19019,  6349, -7441,  7310, -4995,  -164,  2728, -6751, 12484, -10030, 14716, -20147, 26014, -15913, 18450, -20185, 20608, -9578,  7629, -4190,  -955,  3969, -8387, 13662, -19637, 13026, -16274, 19328, -21907, 11846, -12163, 11721, -10329,  3900, -1973,  -707,  4238, -4369,  7190, -10726, 15260, -2677,  3855, -6153, 14629, },
	{  2233, -4356,  6314, -6994,  1175,   711, -4597, 11226, -5324,  8833, -13375, 18857, -12502, 15659, -18524, 20592, -10620,  9875, -7683,  3671,  1239, -5492, 10958, -17569, 12567, -16660, 20821, -24730, 14000, -15089, 15389, -14646,  6306, -4529,  1895,  1667, -3100,  5857, -9094, 12786, -8451, 10710, -13173, 15888, -2376,  2872, -3666,  5837, },
	{  -566, -1038,  5430, -14167,  7233, -12816, 20547, -30434, 10528, -13679, 16689, -19020,  9980, -9326,  7067, -2710, -2099,  7005, -13448, 21389, -15313, 20380, -25591, 30528, -17335, 18702, -19028, 17962, -7581,  5163, -1606, -3163,  4578, -8156, 12246, -16731, 10725, -13100, 15363, -17363,  9459, -9901,  9853, -9065,   879,  -299, -1376, 29917, },
	{  2331, -6206, 13087, -23806,  9715, -14526, 20099, -25815,  7662, -8284,  7843, -5773,   728,  2859, -8136, 15275, -12150, 17518, -23527, 29819, -17939, 20517, -22240, 22652, -10635,  8809, -5635,   945,  2678, -6634, 11337, -16664, 11207, -14157, 17005, -19538, 10752, -11310, 11279, -10469,  4325, -2755,   289,  3496, -1187,  2518, -5630, 25414, },
	{  3386, -7593, 13835, -21980,  7819, -10032, 11474, -11203,  2002,  -115, -3242,  8429, -7865, 12639, -18491, 25223, -16225, 19789, -22897, 25039, -12809, 11994, -9745,  5758,   106, -4157,  9280, -15399, 11168, -14901, 18697, -22295, 12691, -13799, 14271, -13893,  6221, -4843,  2692,   368, -2250,  4966, -8519, 13258, -2493,  3823, -6540, 17745, },
	{  2726, -5579,  8853, -11620,  3077, -2163,  -575,  5994, -3750,  7102, -11697, 17563, -12281, 16167, -20126, 23700, -13140, 13564, -12700, 10108, -2681,  -949,  5960, -12384, 10070, -14504, 19301, -24187, 14399, -16348, 17685, -18135,  8703, -7607,  5644, -2693,  -673,  3273, -6481, 10317, -7402,  9993, -12988, 16518, -2614,  3379, -4726,  8862, },
	{ -1886,  1455,  1365, -8261,  5304, -10572, 18316, -28798, 10489, -14315, 18388, -22239, 12599, -13200, 12408, -9657,  2186,  1983, -7876, 15582, -12522, 18009, -24017, 30192, -18026, 20502, -22173, 22656, -10776,  9235, -6530,  2517,  1448, -4870,  8986, -13733,  9503, -12327, 15243, -18134, 10433, -11641, 12596, -13169,  1643, -1495,   889, 30497, },
	{  1492, -4771, 11133, -21713,  9366, -14711, 21362, -28895,  9119, -10695, 11489, -10917,  4147, -1443, -3009,  9508, -9119, 14604, -21096, 28333, -17945, 21581, -24686, 26794, -13691, 12949, -10901,  7301,  -979, -2620,  7153, -12560,  9356, -12699, 16162, -19557, 11326, -12587, 13402, -13585,  6454, -5534,  3810,  -890,  -507,  1658, -4510, 27451, },
	{  3236, -7549, 14348, -23845,  8926, -12192, 15203, -17088,  4160, -3085,   613,  3712, -5156,  9750, -15705, 22947, -15611, 20030, -24374, 28161, -15397, 15791, -14889, 12315, -3861,   416,  4261, -10180,  8628, -12645, 16983, -21417, 12830, -14681, 16060, -16741,  8239, -7502,  6017, -3619,    55,  2392, -5749, 10414, -2156,  3565, -6581, 20707, },
	{  3111, -6589, 11088, -15919,  4933, -5095,  3721,   123, -1875,  4873, -9262, 15193, -11338, 15758, -20623, 25548, -14988, 16589, -17143, 16157, -6561,  3775,   484, -6352,  6933, -11463, 16639, -22245, 13983, -16699, 19021, -20662, 10655, -10317,  9151, -6993,  1847,   442, -3436,  7196, -5900,  8682, -12050, 16221, -2711,  3720, -5607, 12006, },
	{  1776, -3252,  4108, -3127,  -355,  2930, -7565, 14881, -6346,  9834, -14145, 19090, -12149, 14589, -16454, 17222, -8142,  6486, -3311, -1681,  4354, -8933, 14539, -21023, 14058, -17702, 21171, -24123, 13081, -13426, 12870, -11189,  4089, -1833, -1234,  5141, -4942,  7709, -10830, 14247, -8943, 10836, -12766, 14713, -2087,  2354, -2704,  3485, },
	{   438, -2886,  8326, -18150,  8434, -14036, 21436, -30440, 10113, -12593, 14627, -15641,  7460, -5824,  2477,  2993, -5462, 10757, -17375, 25174, -16920, 21435, -25780, 29505, -16038, 16448, -15667, 13387, -4664,  1634,  2466, -7649,  6930, -10484, 14377, -18458, 11264, -13173, 14810, -16003,  8272, -8081,  7235, -5408,   240,   637, -2964, 29017, },
	{  2844, -7021, 14025, -24413,  9575, -13764, 18251, -22284,  6182, -6015,  4603, -1418, -2039,  6187, -11909, 19266, -14076, 19124, -24492, 29755, -17173, 18786, -19317, 18335, -7706,  5077, -1121, -4257,  5535, -9615, 14259, -19294, 12237, -14742, 16969, -18694,  9830, -9793,  9077, -7500,  2420,  -396, -2554,  6855, -1677,  3081, -6232, 23421, },
	{  3341, -7296, 12848, -19600,  6625, -7913,  8050, -6077,   206,  2252, -6177, 11838, -9699, 14419, -19945, 25984, -16032, 18756, -20735, 21457, -10175,  8414, -5167,   201,  3318, -7690, 12960, -18984, 12758, -16103, 19297, -22064, 12040, -12496, 12210, -10988,  4317, -2478,  -122,  3586, -4021,  6836, -10389, 14978, -2657,  3865, -6242, 15175, },
	{  2324, -4579,  6768, -7805,  1503,   225, -3930, 10378, -5077,  8573, -13142, 18712, -12515, 15810, -18875, 21212, -11098, 10552, -8579,  4797,   568, -4730, 10139, -16744, 12187, -16355, 20643, -24737, 14126, -15368, 15849, -15310,  6747, -5080,  2552,   919, -2693,  5434, -8679, 12411, -8304, 10630, -13195, 16061, -2426,  2970, -3860,  6348, },
	{  -788,  -624,  4767, -13225,  6935, -12487, 20250, -30280, 10565, -13844, 17049, -19651, 10471, -10030,  8015, -3918, -1369,  6167, -12541, 20474, -14893, 20054, -25423, 30594, -17525, 19089, -19649, 18847, -8165,  5889, -2464, -2193,  4055, -7621, 11731, -16280, 10558, -13020, 15405, -17567,  9666, -10242, 10365, -9806,  1013,  -502, -1010, 30058, },
	{  2203, -5992, 12812, -23550,  9696, -14618, 20397, -26448,  7943, -8731,  8501, -6680,  1319,  2130, -7287, 14344, -11678, 17087, -23204, 29684, -18013, 20785, -22753, 23460, -11207,  9561, -6569,  2049,  2056, -5966, 10659, -16021, 10933, -13962, 16929, -19621, 10895, -11577, 11692, -11051,  4710, -3246,   897,  2757, -1076,  2382, -5467, 25797, },
	{  3377, -7618, 13979, -22387,  8040, -10441, 12158, -12255,  2379,  -624, -2594,  7653, -7431, 12194, -18087, 24934, -16186, 19911, -23245, 25680, -13308, 12699, -10673,  6914,  -579, -3383,  8450, -14559, 10774, -14571, 18476, -22234, 12767, -14008, 14639, -14443,  6596, -5323,  3278,  -319, -1861,  4542, -8076, 12823, -2446,  3794, -6573, 18271, },
	{  2802, -5771,  9266, -12396,  3405, -2671,   156,  5016, -3444,  6749, -11327, 17229, -12169, 16163, -20294, 24115, -13512, 14141, -13518, 11193, -3362,  -137,  5038, -11392,  9569, -14037, 18920, -23949, 14386, -16475, 17989, -18646,  9077, -8108,  6274, -3448,  -239,  2796, -5980,  9819, -7172,  9807, -12879, 16534, -2641,  3451, -4893,  9400, },
	{ -2121,  1907,   612, -7135,  4922, -10103, 17805, -28332, 10420, -14344, 18584, -22684, 12992, -13814, 13288, -10838,  2936,  1078, -6839, 14459, -11954, 17483, -23598, 29956, -18044, 20701, -22601, 23355, -11279,  9902, -7363,  3507,   886, -4260,  8357, -13123,  9231, -12118, 15132, -18165, 10545, -11882, 13011, -13827,  1771, -1705,  1317, 30540, },
	{  1324, -4476, 10706, -21200,  9246, -14657, 21462, -29278,  9327, -11064, 12075, -11773,  4734, -2203, -2077,  8425, -8526, 14000, -20540, 27904, -17841, 21644, -24976, 27372, -14153, 13607, -11770,  8384, -1621, -1894,  6371, -11761,  8974, -12367, 15919, -19446, 11361, -12740, 13700, -14059,  6794, -5996,  4415, -1670,  -381,  1492, -4273, 27758, },
	{  3186, -7493, 14354, -24040,  9073, -12510, 15786, -18047,  4523, -3600,  1300,  2846, -4641,  9177, -15116, 22407, -15410, 19956, -24494, 28551, -15767, 16373, -15715, 13406, -4541,  1224,  3348, -9197,  8128, -12172, 16580, -21137, 12779, -14751, 16283, -17147,  8548, -7929,  6571, -4305,   464,  1921, -5222,  9844, -2083,  3497, -6549, 21197, },
	{  3163, -6735, 11431, -16608,  5240, -5596,  4475,  -936, -1526,  4444, -8770, 14679, -11103, 15592, -20591, 25728, -15229, 17031, -17832, 17137, -7212,  4592,  -490, -5246,  6336, -10857, 16071, -21771, 13828, -16664, 19146, -20989, 10939, -10737,  9718, -7713,  2282,   -61, -2876,  6601, -5600,  8399, -11813, 16073, -2713,  3759, -5736, 12555, },
	{  1874, -3487,  4572, -3931,   -41,  2482, -6977, 14173, -6155,  9659, -14031, 19104, -12262, 14859, -16938, 17980, -8684,  7213, -4233,  -570,  3719, -8244, 13838, -20370, 13792, -17542, 21166, -24328, 13315, -13817, 13438, -11948,  4566, -2403,  -583,  4431, -4573,  7347, -10502, 13987, -8869, 10845, -12892, 15005, -2153,  2469, -2910,  3964, },
	{   236, -2519,  7760, -17391,  8214, -13830, 21322, -30538, 10232, -12859, 15102, -16394,  8009, -6571,  3440,  1815, -4779, 10009, -16612, 24466, -16639, 21284, -25824, 29814, -16361, 16972, -16420, 14386, -5289,  2377,  1623, -6736,  6460, -10031, 13978, -18156, 11188, -13200, 14974, -16339,  8546, -8486,  7803, -6185,   373,   447, -2654, 29236, },
	{  2751, -6879, 13880, -24369,  9635, -13966, 18693, -23088,  6509, -6506,  5291, -2328, -1470,  5514, -11162, 18497, -13720, 18851, -24370, 29864, -17388, 19208, -19989, 19296, -8343,  5873, -2068, -3183,  4956, -9022, 13694, -18806, 12061, -14667, 17031, -18930, 10055, -10142,  9567, -8145,  2825,  -890, -1970,  6179, -1581,  2975, -6130, 23859, },
	{  3362, -7381, 13093, -20153,  6893, -8376,  8784, -7158,   579,  1769, -5587, 11168, -9349, 14095, -19707, 25910, -16124, 19032, -21253, 22273, -10758,  9189, -6139,  1362,  2657, -6976, 12233, -18296, 12467, -15903, 19234, -22183, 12215, -12809, 12681, -11631,  4729, -2980,   466,  2926, -3664,  6468, -10033, 14668, -2631,  3869, -6323, 15719, },
	{  2413, -4797,  7217, -8614,  1832,  -267, -3249,  9505, -4819,  8296, -12885, 18534, -12507, 15936, -19197, 21798, -11559, 11214, -9466,  5920,  -108, -3956,  9299, -15888, 11784, -16021, 20429, -24702, 14228, -15623, 16284, -15950,  7178, -5625,  3207,   167, -2279,  5000, -8247, 12013, -8142, 10531, -13194, 16208, -2473,  3064, -4049,  6865, },
	{ -1013,  -202,  4085, -12247,  6621, -12132, 19916, -30071, 10583, -13986, 17382, -20252, 10947, -10722,  8956, -5126,  -633,  5315, -11609, 19520, -14447, 19691, -25211, 30609, -17686, 19446, -20240, 19704, -8737,  6607, -3322, -1215,  3523, -7070, 11195, -15800, 10371, -12917, 15421, -17742,  9857, -10566, 10863, -10536,  1147,  -708,  -633, 30182, },
	{  2067, -5764, 12511, -23250,  9660, -14685, 20663, -27041,  8213, -9167,  9149, -7582,  1911,  1394, -6420, 13383, -11182, 16625, -22839, 29498, -18057, 21018, -23230, 24232, -11762, 10300, -7495,  3153,  1428, -5286,  9960, -15349, 10638, -13743, 16823, -19670, 11020, -11825, 12087, -11616,  5089, -3734,  1506,  2008,  -961,  2241, -5291, 26169, },
	{  3360, -7630, 14102, -22761,  8249, -10837, 12827, -13296,  2756, -1137, -1936,  6859, -6982, 11725, -17650, 24601, -16118, 20000, -23556, 26280, -13787, 13385, -11588,  8064, -1267, -2600,  7602, -13691, 10360, -14216, 18224, -22135, 12821, -14194, 14983, -14970,  6961, -5796,  3861, -1010, -1467,  4108, -7617, 12363, -2393,  3759, -6596, 18792, },
	{  2874, -5957,  9670, -13160,  3731, -3180,   893,  4019, -3130,  6382, -10935, 16862, -12036, 16131, -20428, 24492, -13863, 14697, -14318, 12265, -4040,   679,  4104, -10376,  9049, -13545, 18504, -23670, 14348, -16575, 18262, -19128,  9436, -8596,  6896, -4201,   196,  2313, -5468,  9303, -6930,  9604, -12748, 16522, -2664,  3517, -5055,  9942, },
	{ -2358,  2363,  -153, -5982,  4527, -9612, 17258, -27814, 10332, -14349, 18749, -23093, 13366, -14408, 14150, -12008,  3686,   167, -5785, 13306, -11362, 16925, -23136, 29668, -18031, 20866, -22992, 24017, -11764, 10554, -8187,  4495,   320, -3641,  7711, -12488,  8943, -11888, 14996, -18165, 10640, -12105, 13407, -14467,  1897, -1915,  1754, 30565, },
	{  1149, -4167, 10254, -20642,  9109, -14577, 21527, -29614,  9520, -11417, 12644, -12615,  5316, -2963, -1136,  7321, -7915, 13369, -19946, 27424, -17707, 21670, -25224, 27906, -14592, 14245, -12622,  9457, -2262, -1163,  5575, -10939,  8576, -12013, 15648, -19302, 11378, -12871, 13977, -14510,  7124, -6450,  5017, -2452,  -254,  1321, -4023, 28050, },
	{  3129, -7422, 14335, -24196,  9206, -12810, 16348, -18983,  4882, -4113,  1990,  1970, -4115,  8585, -14497, 21825, -15182, 19847, -24572, 28894, -16111, 16930, -16518, 14478, -5217,  2033,  2425, -8194,  7612, -11677, 16148, -20819, 12707, -14797, 16479, -17526,  8844, -8345,  7116, -4986,   874,  1444, -4683,  9255, -2005,  3423, -6506, 21679, },
	{  3210, -6872, 11759, -17277,  5543, -6092,  5228, -2003, -1172,  4004, -8260, 14137, -10847, 15398, -20523, 25864, -15445, 17446, -18495, 18094, -7853,  5404, -1468, -4125,  5726, -10230, 15473, -21259, 13649, -16600, 19239, -21282, 11204, -11139, 10270, -8423,  2715,  -567, -2310,  5993, -5288,  8100, -11554, 15897, -2710,  3793, -5858, 13105, },
	{  1971, -3721,  5036, -4739,   277,  2025, -6370, 13434, -5952,  9465, -13892, 19084, -12354, 15105, -17396, 18711, -9215,  7932, -5153,   547,  3073, -7537, 13110, -19678, 13501, -17350, 21125, -24492, 13528, -14186, 13986, -12689,  5036, -2971,    71,  3711, -4194,  6971, -10155, 13703, -8780, 10835, -12997, 15273, -2217,  2580, -3113,  4450, },
	{    30, -2141,  7172, -16591,  7977, -13598, 21170, -30584, 10334, -13105, 15556, -17124,  8547, -7312,  4404,   627, -4084,  9241, -15817, 23712, -16329, 21096, -25823, 30073, -16657, 17469, -17148, 15365, -5907,  3119,   773, -5807,  5978, -9559, 13553, -17822, 11092, -13205, 15112, -16648,  8807, -8880,  8362, -6957,   507,   253, -2332, 29439, },
	{  2650, -6722, 13707, -24281,  9679, -14147, 19106, -23859,  6828, -6989,  5974, -3240,  -895,  4828, -10391, 17692, -13339, 18544, -24205, 29923, -17575, 19599, -20631, 20228, -8968,  6663, -3016, -2100,  4366, -8412, 13103, -18284, 11864, -14567, 17065, -19136, 10263, -10475, 10042, -8778,  3228, -1384, -1379,  5487, -1481,  2862, -6015, 24286, },
	{  3377, -7455, 13318, -20679,  7152, -8830,  9510, -8236,   954,  1278, -4984, 10474, -8981, 13745, -19433, 25790, -16189, 19277, -21737, 23056, -11325,  9951, -7106,  2526,  1990, -6248, 11482, -17574, 12153, -15676, 19138, -22265, 12370, -13101, 13131, -12257,  5135, -3480,  1055,  2257, -3300,  6087, -9658, 14332, -2601,  3866, -6394, 16260, },
	{  2500, -5011,  7660, -9419,  2162,  -764, -2556,  8607, -4549,  8002, -12603, 18323, -12477, 16034, -19487, 22351, -12003, 11860, -10342,  7039,  -788, -3172,  8440, -15000, 11359, -15658, 20180, -24624, 14307, -15851, 16693, -16565,  7598, -6162,  3859,  -589, -1860,  4555, -7800, 11594, -7966, 10414, -13171, 16328, -2516,  3154, -4235,  7387, },
	{ -1241,   228,  3386, -11236,  6293, -11752, 19544, -29809, 10584, -14106, 17688, -20823, 11408, -11400,  9887, -6332,   109,  4449, -10652, 18527, -13973, 19294, -24956, 30571, -17818, 19771, -20799, 20531, -9297,  7318, -4178,  -231,  2983, -6505, 10637, -15291, 10166, -12792, 15410, -17887, 10032, -10875, 11345, -11253,  1279,  -915,  -244, 30289, },
	{  1924, -5521, 12183, -22905,  9606, -14727, 20896, -27592,  8470, -9590,  9786, -8478,  2505,   650, -5536, 12394, -10665, 16131, -22433, 29261, -18070, 21216, -23670, 24966, -12299, 11024, -8413,  4257,   795, -4594,  9242, -14648, 10324, -13500, 16688, -19687, 11127, -12055, 12463, -12163,  5462, -4217,  2117,  1250,  -844,  2094, -5102, 26527, },
	{  3337, -7628, 14200, -23099,  8446, -11218, 13481, -14323,  3131, -1652, -1271,  6048, -6518, 11233, -17179, 24223, -16023, 20056, -23827, 26839, -14245, 14052, -12487,  9206, -1955, -1810,  6737, -12796,  9927, -13834, 17939, -21997, 12854, -14356, 15303, -15473,  7315, -6261,  4440, -1701, -1069,  3665, -7143, 11879, -2337,  3717, -6608, 19308, },
	{  2942, -6136, 10062, -13911,  4054, -3688,  1636,  3007, -2808,  6001, -10521, 16463, -11881, 16071, -20528, 24828, -14193, 15231, -15097, 13321, -4715,  1498,  3158, -9338,  8512, -13027, 18055, -23350, 14286, -16647, 18506, -19579,  9781, -9071,  7508, -4949,   633,  1824, -4944,  8768, -6674,  9384, -12594, 16482, -2683,  3578, -5210, 10486, },
	{  1502, -2595,  2822,  -928, -1201,  4120, -9099, 16676, -6811, 10226, -14330, 18884, -11732, 13720, -14981, 14993, -6582,  4433,  -750, -4716,  6062, -10748, 16335, -22633, 14664, -17987, 20996, -23345, 12321, -12231, 11191, -8999,  2740,  -248, -3013,  7050, -5915,  8638, -11637, 14834, -9067, 10717, -12308, 13783, -1886,  2021, -2125,  2200, },
	{   969, -3845,  9777, -20042,  8955, -14470, 21555, -29902,  9699, -11753, 13196, -13441,  5893, -3724,  -187,  6197, -7287, 12712, -19315, 26896, -17541, 21660, -25431, 28394, -15009, 14860, -13456, 10518, -2902,  -427,  4766, -10095,  8161, -11637, 15349, -19125, 11375, -12982, 14230, -14939,  7444, -6895,  5613, -3235,  -125,  1146, -3760, 28327, },
	{  3064, -7337, 14289, -24312,  9325, -13091, 16886, -19894,  5235, -4623,  2682,  1083, -3579,  7974, -13850, 21202, -14927, 19703, -24610, 29190, -16430, 17460, -17296, 15531, -5887,  2842,  1493, -7173,  7081, -11159, 15687, -20465, 12613, -14817, 16647, -17876,  9125, -8747,  7651, -5662,  1284,   962, -4133,  8645, -1924,  3341, -6450, 22153, },
	{  3252, -6999, 12071, -17925,  5839, -6583,  5981, -3077,  -813,  3553, -7732, 13566, -10571, 15177, -20419, 25957, -15637, 17833, -19130, 19024, -8485,  6212, -2448, -2993,  5103, -9584, 14845, -20708, 13446, -16508, 19300, -21539, 11452, -11524, 10807, -9121,  3145, -1073, -1737,  5371, -4966,  7785, -11274, 15693, -2702,  3821, -5971, 13654, },
	{  2066, -3952,  5499, -5550,   598,  1559, -5746, 12665, -5736,  9253, -13728, 19032, -12426, 15326, -17827, 19414, -9733,  8642, -6069,  1670,  2419, -6814, 12357, -18950, 13186, -17129, 21048, -24615, 13718, -14532, 14511, -13412,  5501, -3535,   727,  2982, -3807,  6581, -9789, 13394, -8675, 10806, -13080, 15516, -2277,  2689, -3315,  4943, },
	{  -181, -1753,  6563, -15753,  7724, -13339, 20979, -30577, 10420, -13331, 15986, -17829,  9074, -8046,  5366,  -570, -3378,  8452, -14990, 22914, -15989, 20871, -25779, 30282, -16926, 17938, -17849, 16322, -6518,  3858,   -81, -4866,  5484, -9069, 13103, -17457, 10977, -13187, 15225, -16930,  9055, -9260,  8909, -7723,   641,    57, -1998, 29626, },
	{  2542, -6549, 13508, -24149,  9707, -14304, 19491, -24595,  7137, -7463,  6653, -4153,  -314,  4129, -9598, 16852, -12933, 18204, -23999, 29931, -17732, 19959, -21240, 21130, -9581,  7444, -3961, -1009,  3765, -7786, 12488, -17730, 11646, -14442, 17069, -19309, 10454, -10791, 10501, -9399,  3627, -1878,  -783,  4782, -1378,  2744, -5888, 24702, },
	{  3386, -7516, 13523, -21175,  7401, -9273, 10227, -9311,  1330,   781, -4367,  9757, -8594, 13370, -19125, 25626, -16226, 19490, -22187, 23803, -11875, 10700, -8065,  3691,  1316, -5506, 10708, -16819, 11817, -15421, 19008, -22310, 12504, -13372, 13561, -12863,  5533, -3975,  1645,  1582, -2928,  5694, -9264, 13969, -2567,  3856, -6456, 16798, },
	{  2584, -5221,  8096, -10218,  2492, -1265, -1852,  7685, -4270,  7692, -12298, 18079, -12426, 16106, -19746, 22869, -12430, 12489, -11204,  8152, -1469, -2379,  7562, -14083, 10913, -15267, 19895, -24504, 14362, -16054, 17075, -17155,  8007, -6691,  4506, -1346, -1436,  4101, -7338, 11152, -7775, 10278, -13125, 16421, -2555,  3239, -4416,  7915, },
	{ -1471,   664,  2672, -10192,  5949, -11349, 19135, -29493, 10566, -14202, 17966, -21362, 11852, -12063, 10806, -7535,   855,  3570, -9671, 17497, -13473, 18862, -24656, 30481, -17920, 20064, -21324, 21326, -9843,  8018, -5030,   756,  2435, -5927, 10060, -14754,  9943, -12644, 15373, -18003, 10191, -11166, 11811, -11957,  1411, -1123,   155, 30380, },
	{  1775, -5263, 11828, -22516,  9535, -14744, 21094, -28100,  8716, -10001, 10412, -9365,  3097,  -100, -4638, 11377, -10126, 15608, -21987, 28972, -18053, 21380, -24071, 25661, -12818, 11733, -9320,  5357,   158, -3891,  8505, -13920,  9992, -13232, 16524, -19670, 11215, -12264, 12820, -12693,  5826, -4697,  2728,   485,  -725,  1942, -4900, 26872, },
	{  3307, -7612, 14275, -23401,  8630, -11583, 14117, -15334,  3504, -2168,  -598,  5220, -6039, 10718, -16677, 23802, -15899, 20077, -24060, 27354, -14680, 14698, -13369, 10337, -2643, -1013,  5858, -11875,  9475, -13428, 17622, -21822, 12865, -14494, 15598, -15952,  7658, -6716,  5013, -2393,  -667,  3214, -6653, 11372, -2276,  3668, -6608, 19818, },
	{  3007, -6306, 10443, -14649,  4374, -4197,  2384,  1980, -2478,  5606, -10086, 16033, -11705, 15983, -20594, 25124, -14500, 15742, -15854, 14359, -5385,  2318,  2202, -8280,  7957, -12485, 17574, -22988, 14199, -16691, 18719, -19998, 10110, -9533,  8110, -5691,  1070,  1330, -4409,  8217, -6406,  9146, -12418, 16413, -2697,  3634, -5359, 11032, },
	{  1601, -2832,  3283, -1713,  -901,  3702, -8565, 16059, -6655, 10102, -14285, 18987, -11900, 14052, -15532, 15816, -7152,  5176, -1670, -3634,  5458, -10112, 15714, -22089, 14468, -17912, 21091, -23660, 12613, -12679, 11812, -9800,  3229,  -819, -2378,  6375, -5574,  8317, -11364, 14645, -9037, 10776, -12491, 14137, -1961,  2143, -2335,  2655, },
	{   783, -3510,  9275, -19398,  8782, -14337, 21545, -30140,  9862, -12072, 13729, -14250,  6464, -4482,   768,  5057, -6643, 12029, -18648, 26318, -17345, 21612, -25595, 28837, -15401, 15453, -14271, 11565, -3540,   313,  3947, -9231,  7731, -11240, 15023, -18914, 11352, -13070, 14460, -15344,  7753, -7331,  6203, -4019,     5,   966, -3484, 28589, },
	{  2991, -7237, 14218, -24386,  9428, -13351, 17400, -20780,  5582, -5129,  3374,   188, -3032,  7345, -13175, 20540, -14644, 19525, -24605, 29437, -16722, 17963, -18048, 16562, -6550,  3649,   556, -6136,  6536, -10621, 15197, -20075, 12497, -14813, 16788, -18197,  9393, -9136,  8175, -6331,  1694,   475, -3573,  8016, -1838,  3253, -6383, 22618, },
	{  3289, -7116, 12366, -18550,  6128, -7069,  6730, -4155,  -450,  3093, -7187, 12967, -10274, 14928, -20280, 26006, -15802, 18191, -19735, 19926, -9105,  7012, -3428, -1850,  4469, -8918, 14190, -20120, 13219, -16387, 19328, -21760, 11681, -11891, 11328, -9806,  3571, -1580, -1159,  4738, -4634,  7456, -10974, 15460, -2690,  3842, -6077, 14203, },
	{  2161, -4180,  5959, -6362,   921,  1085, -5106, 11866, -5509,  9024, -13539, 18946, -12477, 15523, -18230, 20089, -10238,  9340, -6979,  2795,  1758, -6076, 11579, -18187, 12847, -16877, 20934, -24696, 13885, -14855, 15014, -14115,  5957, -4096,  1384,  2245, -3412,  6179, -9405, 13061, -8555, 10759, -13141, 15735, -2334,  2793, -3514,  5443, },
	{  -396, -1354,  5934, -14875,  7454, -13055, 20751, -30518, 10488, -13535, 16391, -18509,  9589, -8770,  6324, -1772, -2662,  7645, -14134, 22073, -15619, 20609, -25690, 30440, -17167, 18379, -18523, 17254, -7120,  4594,  -938, -3912,  4979, -8562, 12630, -17060, 10843, -13147, 15313, -17184,  9288, -9626,  9445, -8481,   775,  -142, -1653, 29796, },
	{  2426, -6362, 13281, -23973,  9718, -14438, 19845, -25296,  7437, -7929,  7325, -5065,   271,  3419, -8784, 15978, -12502, 17831, -23750, 29888, -17860, 20286, -21816, 21999, -10179,  8216, -4904,    89,  3157, -7143, 11850, -17142, 11407, -14291, 17044, -19450, 10629, -11090, 10945, -10007,  4022, -2372,  -181,  4063, -1272,  2619, -5748, 25107, },
	{  3388, -7564, 13707, -21640,  7640, -9705, 10933, -10378,  1708,   279, -3738,  9018, -8190, 12968, -18782, 25417, -16236, 19671, -22600, 24513, -12408, 11434, -9014,  4855,   637, -4751,  9913, -16032, 11460, -15139, 18846, -22316, 12618, -13621, 13969, -13451,  5924, -4466,  2234,   901, -2549,  5289, -8852, 13579, -2527,  3840, -6507, 17332, },
	{  2665, -5424,  8525, -11010,  2822, -1769, -1137,  6742, -3981,  7366, -11969, 17802, -12353, 16151, -19973, 23351, -12837, 13101, -12052,  9256, -2151, -1577,  6667, -13138, 10447, -14848, 19574, -24342, 14392, -16229, 17429, -17717,  8404, -7211,  5148, -2104, -1008,  3638, -6861, 10690, -7570, 10125, -13056, 16486, -2589,  3319, -4592,  8446, },
	{ -1704,  1107,  1942, -9117,  5592, -10921, 18688, -29123, 10530, -14275, 18215, -21869, 12279, -12709, 11713, -8732,  1603,  2681, -8669, 16433, -12948, 18395, -24313, 30339, -17992, 20323, -21815, 22088, -10374,  8707, -5876,  1746,  1882, -5337,  9463, -14190,  9702, -12474, 15310, -18089, 10334, -11440, 12259, -12645,  1542, -1332,   564, 30453, },
	{  1618, -4992, 11447, -22081,  9447, -14736, 21258, -28565,  8948, -10397, 11023, -10243,  3689,  -854, -3726, 10335, -9567, 15054, -21501, 28632, -18004, 21507, -24432, 26314, -13317, 12424, -10214,  6453,  -481, -3179,  7750, -13165,  9641, -12941, 16332, -19619, 11285, -12454, 13155, -13203,  6183, -5170,  3337,  -287,  -603,  1784, -4686, 27203, },
	{  3270, -7582, 14326, -23665,  8801, -11932, 14736, -16328,  3874, -2684,    81,  4377, -5547, 10182, -16142, 23338, -15748, 20064, -24252, 27825, -15093, 15322, -14232, 11455, -3329,  -211,  4965, -10931,  9005, -12997, 17274, -21609, 12853, -14609, 15868, -16406,  7989, -7163,  5581, -3084,  -262,  2754, -6150, 10841, -2210,  3613, -6597, 20321, },
	{  3067, -6469, 10811, -15370,  4690, -4703,  3135,   940, -2141,  5198, -9630, 15572, -11507, 15867, -20624, 25379, -14783, 16228, -16588, 15379, -6049,  3138,  1238, -7202,  7387, -11919, 17060, -22586, 14087, -16706, 18901, -20385, 10423, -9980,  8700, -6427,  1508,   832, -3865,  7649, -6126,  8892, -12219, 16316, -2707,  3684, -5501, 11579, },
	{  1700, -3069,  3747, -2506,  -596,  3272, -8010, 15409, -6486,  9959, -14216, 19058, -12048, 14363, -16060, 16616, -7712,  5915, -2593, -2539,  4842, -9457, 15064, -21505, 14247, -17806, 21150, -23936, 12884, -13108, 12414, -10587,  3714, -1389, -1736,  5686, -5223,  7981, -11072, 14431, -8990, 10817, -12654, 14470, -2033,  2263, -2543,  3119, },
	{   591, -3164,  8750, -18713,  8593, -14178, 21498, -30329, 10010, -12372, 14242, -15040,  7028, -5238,  1728,  3901, -5984, 11323, -17946, 25693, -17118, 21527, -25716, 29231, -15769, 16022, -15065, 12596, -4174,  1056,  3117, -8348,  7286, -10822, 14670, -18670, 11310, -13137, 14666, -15724,  8049, -7757,  6787, -4801,   137,   782, -3196, 28836, },
	{  2911, -7121, 14120, -24418,  9517, -13592, 17889, -21638,  5922, -5630,  4066,  -713, -2477,  6700, -12473, 19838, -14335, 19313, -24558, 29635, -16986, 18437, -18773, 17570, -7204,  4454,  -386, -5084,  5978, -10062, 14680, -19649, 12359, -14783, 16901, -18488,  9645, -9512,  8688, -6992,  2103,   -14, -3003,  7370, -1749,  3159, -6303, 23073, },
	{  3321, -7221, 12644, -19150,  6411, -7547,  7475, -5235,   -82,  2623, -6625, 12342, -9958, 14652, -20105, 26011, -15942, 18521, -20310, 20799, -9712,  7804, -4407,  -699,  3825, -8234, 13508, -19495, 12969, -16238, 19324, -21945, 11891, -12239, 11831, -10477,  3993, -2086,  -577,  4094, -4293,  7112, -10653, 15200, -2673,  3858, -6173, 14750, },
	{  2253, -4406,  6415, -7175,  1248,   604, -4450, 11040, -5270,  8777, -13325, 18827, -12507, 15695, -18605, 20733, -10727, 10027, -7883,  3921,  1090, -5324, 10778, -17388, 12484, -16595, 20784, -24736, 14030, -15153, 15494, -14796,  6405, -4652,  2041,  1501, -3010,  5764, -9003, 12704, -8420, 10693, -13180, 15928, -2387,  2894, -3710,  5950, },
	{  -615,  -947,  5284, -13961,  7168, -12745, 20484, -30405, 10538, -13717, 16771, -19162, 10090, -9483,  7278, -2978, -1938,  6820, -13249, 21189, -15222, 20311, -25557, 30547, -17379, 18790, -19168, 18161, -7712,  5325, -1796, -2949,  4463, -8039, 12133, -16633, 10690, -13084, 15375, -17411,  9506, -9978,  9968, -9230,   909,  -344, -1296, 29950, },
	{  2303, -6160, 13028, -23753,  9712, -14548, 20168, -25959,  7726, -8384,  7990, -5975,   859,  2697, -7949, 15071, -12047, 17425, -23459, 29793, -17958, 20579, -22357, 22835, -10763,  8977, -5843,  1190,  2540, -6486, 11189, -16524, 11148, -14116, 16991, -19559, 10786, -11371, 11372, -10600,  4411, -2865,   424,  3332, -1163,  2488, -5595, 25500, },
	{  3384, -7600, 13869, -22073,  7869, -10124, 11627, -11438,  2086,  -228, -3098,  8258, -7770, 12542, -18404, 25162, -16219, 19819, -22978, 25185, -12922, 12152, -9952,  6015,   -46, -3986,  9097, -15215, 11082, -14830, 18651, -22285, 12710, -13847, 14354, -14017,  6305, -4951,  2822,   216, -2164,  4873, -8422, 13164, -2483,  3817, -6549, 17862, },
	{  2743, -5622,  8946, -11793,  3150, -2275,  -413,  5779, -3683,  7025, -11617, 17492, -12258, 16168, -20167, 23796, -13225, 13694, -12884, 10350, -2833,  -769,  5756, -12166,  9961, -14402, 19219, -24137, 14398, -16378, 17755, -18251,  8788, -7719,  5784, -2861,  -577,  3168, -6371, 10208, -7352,  9953, -12965, 16524, -2620,  3395, -4764,  8982, },
	{ -1938,  1555,  1199, -8013,  5220, -10470, 18205, -28699, 10475, -14323, 18434, -22341, 12688, -13338, 12605, -9921,  2353,  1783, -7647, 15335, -12398, 17895, -23927, 30144, -18033, 20549, -22271, 22815, -10889,  9385, -6715,  2737,  1323, -4735,  8848, -13600,  9444, -12282, 15220, -18144, 10459, -11696, 12690, -13317,  1671, -1542,   984, 30508, },
	{  1455, -4707, 11040, -21603,  9341, -14702, 21387, -28984,  9166, -10778, 11621, -11109,  4278, -1612, -2803,  9269, -8989, 14472, -20975, 28242, -17925, 21598, -24754, 26926, -13795, 13097, -11095,  7542, -1122, -2459,  6980, -12385,  9273, -12627, 16111, -19535, 11335, -12623, 13470, -13692,  6530, -5638,  3945, -1063,  -479,  1622, -4458, 27521, },
	{  3226, -7538, 14351, -23892,  8960, -12264, 15335, -17303,  4241, -3200,   765,  3521, -5042,  9625, -15577, 22830, -15569, 20017, -24404, 28251, -15481, 15923, -15075, 12559, -4012,   595,  4059, -9964,  8518, -12542, 16896, -21358, 12820, -14698, 16111, -16833,  8309, -7598,  6141, -3772,   146,  2288, -5633, 10289, -2140,  3550, -6575, 20817, },
	{  3123, -6622, 11165, -16074,  5001, -5206,  3888,  -112, -1798,  4778, -9154, 15082, -11288, 15723, -20619, 25592, -15043, 16690, -17298, 16377, -6706,  3957,   268, -6108,  6801, -11330, 16516, -22143, 13951, -16694, 19051, -20738, 10720, -10412,  9278, -7154,  1944,   331, -3312,  7065, -5835,  8621, -11999, 16191, -2712,  3729, -5636, 12128, },
	{  1798, -3305,  4211, -3306,  -285,  2831, -7436, 14726, -6305,  9797, -14122, 19096, -12176, 14651, -16563, 17393, -8263,  6648, -3516, -1435,  4214, -8782, 14385, -20881, 14001, -17669, 21173, -24172, 13135, -13515, 12998, -11359,  4195, -1960, -1089,  4984, -4861,  7630, -10759, 14191, -8928, 10840, -12796, 14780, -2102,  2380, -2750,  3591, },
	{   393, -2805,  8202, -17985,  8386, -13992, 21414, -30467, 10141, -12654, 14734, -15810,  7583, -5990,  2691,  2732, -5311, 10592, -17209, 25021, -16860, 21405, -25793, 29578, -16112, 16567, -15836, 13611, -4803,  1799,  2279, -7447,  6827, -10385, 14291, -18394, 11249, -13181, 14849, -16080,  8334, -8172,  7362, -5581,   269,   595, -2896, 29067, },
	{  2824, -6991, 13995, -24407,  9590, -13811, 18352, -22465,  6256, -6125,  4756, -1620, -1914,  6039, -11745, 19098, -13999, 19066, -24469, 29783, -17224, 18883, -19469, 18551, -7849,  5254, -1332, -4019,  5408, -9485, 14136, -19189, 12200, -14728, 16986, -18749,  9882, -9872,  9187, -7645,  2510,  -506, -2425,  6706, -1656,  3058, -6210, 23519, },
	{  3346, -7316, 12904, -19725,  6685, -8017,  8214, -6317,   288,  2145, -6047, 11692, -9623, 14349, -19895, 25971, -16055, 18820, -20853, 21641, -10306,  8587, -5383,   459,  3172, -7533, 12801, -18834, 12695, -16061, 19286, -22094, 12081, -12567, 12317, -11133,  4409, -2590,     9,  3440, -3943,  6755, -10312, 14911, -2652,  3866, -6261, 15296, },
	{  2344, -4627,  6868, -7985,  1576,   116, -3780, 10186, -5020,  8513, -13087, 18675, -12515, 15840, -18950, 21345, -11202, 10700, -8777,  5047,   418, -4559,  9954, -16557, 12099, -16283, 20599, -24733, 14151, -15427, 15948, -15454,  6843, -5202,  2698,   752, -2601,  5338, -8584, 12324, -8269, 10609, -13197, 16096, -2437,  2992, -3902,  6463, },
	{  -837,  -531,  4617, -13011,  6867, -12410, 20179, -30238, 10571, -13877, 17125, -19787, 10578, -10185,  8225, -4186, -1206,  5979, -12336, 20265, -14796, 19976, -25380, 30602, -17563, 19171, -19783, 19040, -8293,  6049, -2655, -1976,  3937, -7500, 11614, -16176, 10518, -12999, 15411, -17608,  9710, -10315, 10477, -9969,  1043,  -548,  -927, 30087, },
	{  2173, -5943, 12747, -23488,  9690, -14635, 20459, -26583,  8004, -8829,  8646, -6881,  1451,  1967, -7096, 14133, -11569, 16987, -23126, 29647, -18026, 20839, -22863, 23635, -11332,  9726, -6775,  2294,  1917, -5816, 10506, -15875, 10869, -13916, 16908, -19635, 10925, -11634, 11781, -11178,  4795, -3355,  1032,  2591, -1051,  2351, -5429, 25881, },
	{  3374, -7622, 14009, -22473,  8087, -10530, 12308, -12488,  2463,  -738, -2448,  7478, -7333, 12092, -17993, 24864, -16173, 19934, -23317, 25817, -13417, 12853, -10878,  7171,  -732, -3210,  8263, -14368, 10684, -14495, 18423, -22215, 12781, -14051, 14717, -14562,  6678, -5429,  3408,  -473, -1774,  4447, -7976, 12723, -2434,  3787, -6579, 18387, },
	{  2818, -5813,  9357, -12567,  3478, -2784,   319,  4796, -3375,  6669, -11242, 17150, -12142, 16158, -20327, 24202, -13592, 14266, -13698, 11433, -3513,    44,  4831, -11168,  9455, -13930, 18830, -23891, 14380, -16500, 18052, -18756,  9158, -8217,  6413, -3616,  -143,  2689, -5868,  9706, -7120,  9764, -12852, 16534, -2647,  3466, -4929,  9521, },
	{ -2174,  2008,   443, -6881,  4835, -9996, 17686, -28222, 10402, -14347, 18623, -22778, 13077, -13947, 13481, -11099,  3103,   876, -6606, 14205, -11824, 17362, -23499, 29896, -18044, 20741, -22691, 23506, -11388, 10048, -7547,  3727,   760, -4123,  8215, -12984,  9168, -12069, 15104, -18168, 10568, -11933, 13101, -13971,  1799, -1752,  1413, 30547, },
	{  1286, -4408, 10608, -21080,  9217, -14642, 21480, -29357,  9371, -11144, 12203, -11962,  4864, -2372, -1868,  8181, -8392, 13863, -20411, 27801, -17814, 21653, -25035, 27494, -14252, 13751, -11960,  8623, -1764, -1732,  6195, -11581,  8887, -12291, 15861, -19417, 11367, -12771, 13764, -14161,  6868, -6098,  4549, -1843,  -353,  1455, -4218, 27824, },
	{  3174, -7479, 14352, -24079,  9104, -12578, 15913, -18257,  4603, -3714,  1453,  2652, -4525,  9047, -14981, 22281, -15362, 19935, -24515, 28631, -15845, 16499, -15895, 13646, -4692,  1403,  3143, -8976,  8014, -12064, 16487, -21069, 12765, -14764, 16328, -17234,  8615, -8023,  6693, -4457,   555,  1815, -5103,  9715, -2066,  3481, -6540, 21305, },
	{  3174, -6767, 11505, -16759,  5308, -5706,  4642, -1173, -1448,  4347, -8659, 14561, -11048, 15551, -20579, 25762, -15279, 17125, -17982, 17352, -7355,  4773,  -707, -4998,  6201, -10720, 15940, -21661, 13791, -16652, 19170, -21057, 10999, -10828,  9842, -7872,  2379,  -173, -2751,  6467, -5531,  8334, -11757, 16037, -2713,  3767, -5764, 12678, },
	{  1896, -3539,  4676, -4110,    29,  2381, -6843, 14011, -6111,  9617, -14002, 19102, -12284, 14915, -17042, 18145, -8803,  7374, -4437,  -323,  3576, -8088, 13678, -20219, 13729, -17502, 21160, -24368, 13364, -13901, 13562, -12114,  4671, -2529,  -438,  4272, -4490,  7264, -10427, 13926, -8851, 10844, -12917, 15066, -2168,  2494, -2955,  4071, },
	{   191, -2436,  7631, -17217,  8163, -13780, 21291, -30553, 10256, -12915, 15205, -16558,  8129, -6736,  3654,  1552, -4625,  9840, -16438, 24302, -16573, 21245, -25827, 29876, -16429, 17085, -16584, 14606, -5427,  2542,  1434, -6530,  6354, -9927, 13885, -18085, 11168, -13203, 15006, -16410,  8605, -8575,  7928, -6357,   403,   404, -2584, 29282, },
	{  2729, -6845, 13844, -24353,  9646, -14008, 18787, -23262,  6581, -6614,  5443, -2530, -1343,  5363, -10993, 18321, -13638, 18786, -24337, 29882, -17432, 19298, -20135, 19506, -8483,  6049, -2279, -2943,  4826, -8888, 13565, -18693, 12019, -14647, 17041, -18979, 10102, -10217,  9674, -8286,  2915,  -999, -1839,  6026, -1559,  2950, -6105, 23955, },
	{  3366, -7399, 13144, -20273,  6951, -8478,  8946, -7398,   662,  1660, -5454, 11016, -9269, 14020, -19649, 25887, -16141, 19089, -21364, 22450, -10885,  9359, -6355,  1621,  2510, -6816, 12068, -18138, 12399, -15855, 19215, -22205, 12251, -12876, 12782, -11772,  4820, -3092,   597,  2778, -3584,  6384, -9951, 14596, -2625,  3869, -6340, 15839, },
	{  2432, -4845,  7316, -8793,  1905,  -377, -3096,  9307, -4760,  8232, -12824, 18490, -12502, 15960, -19264, 21924, -11659, 11359, -9662,  6169,  -259, -3783,  9110, -15693, 11691, -15943, 20377, -24688, 14248, -15676, 16378, -16089,  7272, -5745,  3352,    -1, -2186,  4902, -8149, 11922, -8104, 10507, -13191, 16237, -2483,  3084, -4091,  6981, },
	{ -1063,  -107,  3931, -12025,  6550, -12050, 19837, -30017, 10585, -14015, 17453, -20382, 11051, -10874,  9164, -5394,  -468,  5124, -11398, 19302, -14344, 19606, -25158, 30605, -17718, 19521, -20367, 19891, -8863,  6766, -3513,  -997,  3403, -6946, 11073, -15689, 10327, -12891, 15421, -17777,  9897, -10636, 10971, -10696,  1176,  -753,  -547, 30208, },
	{  2036, -5711, 12440, -23178,  9650, -14696, 20718, -27167,  8271, -9262,  9292, -7782,  2043,  1229, -6225, 13166, -11069, 16518, -22752, 29450, -18063, 21065, -23331, 24399, -11883, 10462, -7700,  3399,  1288, -5133,  9802, -15196, 10570, -13691, 16795, -19677, 11046, -11878, 12172, -11739,  5173, -3842,  1642,  1840,  -936,  2209, -5250, 26249, },
	{  3356, -7631, 14126, -22839,  8294, -10923, 12974, -13525,  2840, -1251, -1789,  6680, -6880, 11618, -17548, 24521, -16099, 20016, -23619, 26408, -13891, 13535, -11789,  8319, -1419, -2425,  7411, -13494, 10265, -14133, 18163, -22108, 12830, -14232, 15056, -15084,  7040, -5900,  3990, -1163, -1379,  4011, -7513, 12258, -2381,  3750, -6599, 18908, },
	{  2889, -5997,  9758, -13328,  3803, -3293,  1058,  3796, -3059,  6298, -10845, 16776, -12004, 16120, -20454, 24570, -13939, 14817, -14493, 12501, -4190,   860,  3894, -10148,  8931, -13432, 18407, -23603, 14336, -16593, 18319, -19231,  9514, -8703,  7033, -4367,   293,  2205, -5352,  9186, -6874,  9557, -12715, 16516, -2669,  3531, -5090, 10062, },
	{ -2410,  2464,  -324, -5723,  4438, -9500, 17131, -27692, 10311, -14347, 18782, -23179, 13447, -14537, 14339, -12266,  3852,   -37, -5549, 13046, -11227, 16796, -23028, 29597, -18024, 20898, -23074, 24159, -11869, 10697, -8368,  4714,   194, -3502,  7566, -12344,  8876, -11834, 14962, -18161, 10659, -12152, 13493, -14606,  1925, -1962,  1852, 30568, },
	{  1110, -4096, 10150, -20513,  9076, -14555, 21536, -29682,  9561, -11493, 12768, -12800,  5445, -3132,  -925,  7073, -7777, 13226, -19809, 27311, -17673, 21671, -25274, 28018, -14687, 14383, -12809,  9693, -2405, -1000,  5396, -10754,  8485, -11932, 15584, -19266, 11379, -12898, 14035, -14607,  7196, -6550,  5150, -2626,  -225,  1283, -3965, 28112, },
	{  3115, -7405, 14327, -24226,  9234, -12874, 16469, -19188,  4961, -4226,  2144,  1773, -3997,  8451, -14356, 21690, -15128, 19818, -24584, 28964, -16184, 17050, -16693, 14714, -5367,  2213,  2218, -7969,  7495, -11563, 16048, -20744, 12688, -14804, 16518, -17606,  8907, -8435,  7236, -5137,   965,  1337, -4562,  9121, -1987,  3405, -6494, 21785, },
	{  3220, -6901, 11830, -17423,  5609, -6202,  5396, -2241, -1093,  3904, -8144, 14012, -10788, 15352, -20503, 25889, -15490, 17534, -18639, 18303, -7994,  5584, -1686, -3874,  5589, -10088, 15336, -21140, 13606, -16582, 19256, -21342, 11261, -11226, 10391, -8579,  2811,  -679, -2183,  5856, -5217,  8031, -11494, 15854, -2709,  3800, -5884, 13227, },
	{  1992, -3772,  5139, -4919,   348,  1922, -6233, 13266, -5905,  9419, -13857, 19075, -12372, 15156, -17494, 18870, -9331,  8091, -5357,   796,  2928, -7378, 12945, -19520, 13433, -17304, 21111, -24523, 13572, -14265, 14104, -12852,  5140, -3096,   216,  3550, -4109,  6885, -10075, 13636, -8758, 10830, -13017, 15329, -2231,  2605, -3158,  4559, },
	{   -16, -2055,  7039, -16408,  7922, -13542, 21131, -30587, 10355, -13157, 15653, -17283,  8665, -7476,  4618,   362, -3928,  9067, -15636, 23538, -16256, 21049, -25817, 30124, -16719, 17576, -17306, 15580, -6044,  3283,   584, -5599,  5869, -9452, 13455, -17744, 11068, -13203, 15139, -16713,  8864, -8965,  8485, -7128,   536,   210, -2259, 29482, },
	{  2627, -6685, 13665, -24256,  9687, -14183, 19194, -24025,  6897, -7095,  6126, -3442,  -767,  4674, -10217, 17508, -13251, 18472, -24163, 29929, -17612, 19682, -20769, 20431, -9105,  6837, -3226, -1858,  4233, -8275, 12969, -18164, 11817, -14542, 17068, -19177, 10307, -10546, 10145, -8917,  3317, -1494, -1247,  5332, -1459,  2837, -5988, 24380, },
	{  3380, -7469, 13365, -20792,  7208, -8929,  9670, -8475,  1037,  1168, -4848, 10317, -8896, 13664, -19368, 25758, -16199, 19327, -21840, 23225, -11448, 10119, -7320,  2785,  1841, -6084, 11312, -17409, 12080, -15622, 19112, -22279, 12402, -13163, 13228, -12393,  5224, -3590,  1186,  2108, -3218,  6001, -9572, 14253, -2594,  3864, -6409, 16380, },
	{  2518, -5058,  7757, -9597,  2235,  -875, -2401,  8404, -4488,  7934, -12537, 18271, -12468, 16053, -19548, 22470, -12100, 12001, -10535,  7287,  -939, -2996,  8246, -14799, 11262, -15574, 20119, -24601, 14321, -15899, 16780, -16699,  7690, -6281,  4003,  -757, -1766,  4455, -7699, 11497, -7925, 10385, -13163, 16351, -2525,  3173, -4275,  7504, },
	{ -1292,   324,  3229, -11007,  6218, -11665, 19457, -29743, 10582, -14129, 17753, -20946, 11508, -11549, 10092, -6600,   274,  4255, -10436, 18301, -13864, 19201, -24893, 30556, -17843, 19839, -20919, 20710, -9419,  7474, -4368,   -12,  2862, -6378, 10511, -15174, 10118, -12761, 15404, -17916, 10069, -10941, 11450, -11411,  1309,  -961,  -157, 30311, },
	{  1892, -5465, 12106, -22823,  9592, -14733, 20943, -27709,  8526, -9683,  9926, -8676,  2636,   484, -5338, 12170, -10547, 16018, -22338, 29201, -18069, 21256, -23762, 25124, -12416, 11183, -8615,  4502,   654, -4438,  9080, -14489, 10252, -13442, 16654, -19686, 11148, -12103, 12544, -12283,  5543, -4324,  2253,  1081,  -818,  2061, -5058, 26605, },
	{  3331, -7626, 14219, -23169,  8488, -11300, 13624, -14549,  3214, -1766, -1122,  5865, -6413, 11120, -17070, 24133, -15998, 20063, -23882, 26957, -14343, 14198, -12685,  9458, -2108, -1633,  6543, -12593,  9828, -13746, 17871, -21962, 12858, -14389, 15371, -15582,  7392, -6363,  4568, -1855,  -980,  3566, -7035, 11769, -2324,  3707, -6609, 19422, },
	{  2957, -6174, 10148, -14077,  4125, -3802,  1802,  2780, -2736,  5914, -10426, 16370, -11844, 16054, -20546, 24898, -14263, 15346, -15267, 13553, -4864,  1680,  2946, -9105,  8390, -12908, 17951, -23273, 14269, -16659, 18556, -19675,  9855, -9175,  7643, -5114,   730,  1715, -4826,  8647, -6616,  9332, -12557, 16469, -2686,  3591, -5244, 10607, },
	{  1524, -2648,  2924, -1102, -1135,  4028, -8982, 16542, -6777, 10200, -14322, 18909, -11771, 13796, -15105, 15178, -6709,  4598,  -954, -4477,  5929, -10608, 16200, -22516, 14623, -17973, 21020, -23418, 12387, -12332, 11331, -9178,  2849,  -375, -2873,  6901, -5840,  8568, -11578, 14794, -9062, 10732, -12350, 13864, -1903,  2049, -2172,  2300, },
	{   928, -3772,  9667, -19903,  8918, -14443, 21556, -29959,  9736, -11826, 13316, -13623,  6021, -3892,    25,  5945, -7145, 12563, -19170, 26771, -17500, 21652, -25471, 28497, -15098, 14994, -13639, 10751, -3044,  -262,  4585, -9905,  8067, -11551, 15279, -19081, 11371, -13003, 14283, -15031,  7514, -6993,  5745, -3409,   -96,  1106, -3700, 28386, },
	{  3048, -7316, 14276, -24332,  9349, -13150, 17002, -20094,  5313, -4735,  2836,   885, -3458,  7836, -13702, 21058, -14866, 19667, -24612, 29249, -16497, 17574, -17465, 15762, -6035,  3021,  1286, -6944,  6961, -11041, 15581, -20382, 12589, -14819, 16681, -17950,  9186, -8835,  7768, -5811,  1375,   854, -4009,  8507, -1905,  3322, -6436, 22257, },
	{  3261, -7026, 12138, -18066,  5904, -6692,  6147, -3316,  -733,  3452, -7612, 13435, -10507, 15124, -20391, 25972, -15676, 17915, -19267, 19227, -8623,  6390, -2666, -2739,  4963, -9437, 14702, -20581, 13398, -16484, 19309, -21591, 11504, -11607, 10925, -9275,  3240, -1186, -1609,  5232, -4893,  7713, -11209, 15643, -2700,  3826, -5995, 13776, },
	{  2087, -4003,  5601, -5730,   669,  1454, -5605, 12490, -5687,  9204, -13688, 19016, -12439, 15372, -17919, 19567, -9847,  8798, -6272,  1919,  2273, -6651, 12186, -18784, 13112, -17075, 21026, -24636, 13757, -14606, 14625, -13570,  5603, -3660,   873,  2819, -3720,  6493, -9705, 13322, -8650, 10797, -13095, 15567, -2290,  2712, -3359,  5054, },
	{  -228, -1665,  6425, -15561,  7665, -13278, 20932, -30569, 10436, -13378, 16078, -17983,  9189, -8207,  5579,  -836, -3220,  8274, -14803, 22731, -15909, 20816, -25763, 30321, -16982, 18039, -18002, 16531, -6652,  4022,  -271, -4655,  5373, -8958, 13000, -17371, 10949, -13180, 15247, -16989,  9108, -9343,  9030, -7892,   671,    13, -1923, 29665, },
	{  2517, -6509, 13460, -24114,  9711, -14336, 19572, -24754,  7204, -7568,  6803, -4355,  -185,  3972, -9419, 16660, -12839, 18124, -23947, 29926, -17763, 20034, -21371, 21326, -9715,  7617, -4171,  -765,  3631, -7644, 12349, -17602, 11595, -14411, 17066, -19343, 10495, -10859, 10601, -9535,  3715, -1988,  -650,  4623, -1355,  2716, -5858, 24793, },
	{  3387, -7528, 13565, -21281,  7455, -9370, 10385, -9548,  1414,   670, -4229,  9595, -8506, 13283, -19052, 25583, -16231, 19533, -22282, 23964, -11995, 10864, -8276,  3950,  1166, -5339, 10533, -16647, 11740, -15361, 18975, -22315, 12531, -13429, 13653, -12996,  5621, -4085,  1776,  1431, -2844,  5605, -9174, 13884, -2558,  3853, -6468, 16917, },
	{  2602, -5266,  8192, -10395,  2565, -1376, -1694,  7478, -4207,  7621, -12227, 18020, -12412, 16119, -19799, 22980, -12522, 12627, -11394,  8398, -1620, -2201,  7364, -13875, 10811, -15176, 19826, -24472, 14371, -16095, 17156, -17282,  8096, -6807,  4649, -1514, -1341,  3999, -7233, 11051, -7731, 10246, -13112, 16438, -2563,  3257, -4455,  8032, },
	{ -1523,   762,  2511, -9956,  5871, -11256, 19039, -29415, 10560, -14220, 18024, -21478, 11949, -12208, 11009, -7802,  1021,  3374, -9450, 17264, -13359, 18761, -24584, 30454, -17938, 20124, -21436, 21498, -9962,  8172, -5218,   976,  2313, -5797,  9929, -14631,  9891, -12608, 15361, -18025, 10225, -11229, 11912, -12111,  1440, -1169,   245, 30397, },
	{  1741, -5204, 11746, -22423,  9517, -14745, 21134, -28208,  8768, -10090, 10549, -9561,  3229,  -267, -4437, 11148, -10004, 15487, -21883, 28901, -18045, 21411, -24155, 25809, -12931, 11888, -9519,  5601,    17, -3734,  8339, -13754,  9916, -13170, 16484, -19662, 11232, -12308, 12896, -12808,  5906, -4802,  2863,   314,  -698,  1907, -4854, 26946, },
	{  3300, -7607, 14289, -23463,  8669, -11662, 14257, -15557,  3587, -2282,  -447,  5034, -5931, 10601, -16561, 23703, -15868, 20077, -24106, 27463, -14774, 14839, -13562, 10586, -2795,  -835,  5660, -11667,  9372, -13334, 17548, -21778, 12864, -14522, 15660, -16055,  7733, -6816,  5140, -2547,  -577,  3112, -6543, 11256, -2261,  3657, -6606, 19930, },
	{  3021, -6343, 10526, -14810,  4444, -4309,  2551,  1750, -2404,  5516, -9986, 15933, -11663, 15960, -20603, 25184, -14565, 15852, -16019, 14587, -5533,  2500,  1989, -8042,  7832, -12361, 17462, -22902, 14176, -16697, 18762, -20087, 10181, -9634,  8242, -5855,  1168,  1220, -4289,  8092, -6345,  9091, -12375, 16394, -2700,  3646, -5391, 11153, },
	{  1623, -2885,  3386, -1889,  -834,  3607, -8443, 15918, -6619, 10071, -14272, 19005, -11934, 14123, -15651, 15996, -7277,  5341, -1875, -3392,  5322, -9968, 15572, -21963, 14422, -17891, 21107, -23725, 12675, -12776, 11947, -9976,  3337,  -945, -2236,  6223, -5497,  8244, -11301, 14600, -9028, 10787, -12529, 14213, -1977,  2170, -2381,  2757, },
	{   740, -3434,  9161, -19250,  8742, -14304, 21538, -30187,  9896, -12140, 13844, -14428,  6590, -4651,   981,  4802, -6498, 11874, -18495, 26183, -17297, 21596, -25625, 28928, -15485, 15582, -14450, 11795, -3681,   478,  3763, -9037,  7633, -11149, 14947, -18863, 11345, -13087, 14508, -15431,  7820, -7427,  6334, -4193,    35,   926, -3421, 28645, },
	{  2974, -7212, 14198, -24397,  9449, -13407, 17511, -20973,  5658, -5240,  3528,   -12, -2910,  7203, -13021, 20387, -14577, 19481, -24598, 29485, -16783, 18071, -18211, 16788, -6696,  3828,   347, -5903,  6413, -10498, 15085, -19984, 12468, -14808, 16816, -18264,  9450, -9221,  8290, -6479,  1785,   367, -3447,  7874, -1819,  3233, -6366, 22720, },
	{  3297, -7140, 12430, -18686,  6192, -7175,  6896, -4395,  -369,  2989, -7063, 12831, -10206, 14869, -20244, 26011, -15835, 18267, -19866, 20123, -9241,  7189, -3646, -1595,  4327, -8767, 14041, -19984, 13165, -16357, 19330, -21805, 11729, -11970, 11442, -9957,  3665, -1692, -1030,  4596, -4559,  7381, -10904, 15405, -2687,  3846, -6099, 14325, },
	{  2181, -4231,  6060, -6543,   994,   978, -4961, 11685, -5457,  8970, -13494, 18923, -12485, 15564, -18316, 20234, -10348,  9494, -7181,  3045,  1610, -5910, 11403, -18012, 12768, -16817, 20904, -24708, 13919, -14923, 15123, -14268,  6057, -4220,  1530,  2080, -3324,  6088, -9317, 12984, -8526, 10746, -13151, 15780, -2346,  2816, -3558,  5555, },
	{  -444, -1265,  5791, -14675,  7392, -12988, 20695, -30497, 10500, -13577, 16478, -18657,  9701, -8929,  6537, -2040, -2502,  7463, -13940, 21880, -15534, 20546, -25664, 30468, -17216, 18473, -18669, 17458, -7252,  4757, -1128, -3699,  4865, -8447, 12522, -16968, 10811, -13135, 15329, -17237,  9338, -9706,  9563, -8648,   805,  -187, -1574, 29832, },
	{  2400, -6318, 13227, -23928,  9718, -14465, 19919, -25446,  7502, -8031,  7474, -5267,   401,  3259, -8600, 15779, -12403, 17743, -23689, 29871, -17884, 20354, -21939, 22188, -10311,  8386, -5113,   333,  3020, -6999, 11705, -17008, 11351, -14254, 17035, -19477, 10665, -11154, 11042, -10140,  4109, -2482,   -47,  3902, -1248,  2590, -5715, 25196, },
	{  3388, -7573, 13745, -21739,  7692, -9799, 11088, -10615,  1792,   167, -3597,  8851, -8098, 12876, -18701, 25364, -16235, 19707, -22687, 24665, -12524, 11595, -9223,  5113,   486, -4582,  9733, -15853, 11378, -15073, 18805, -22313, 12640, -13673, 14056, -13578,  6009, -4574,  2365,   749, -2464,  5197, -8758, 13489, -2518,  3835, -6517, 17450, },
	{  2683, -5469,  8619, -11185,  2895, -1881,  -977,  6530, -3916,  7292, -11893, 17736, -12334, 16157, -20019, 23453, -12925, 13235, -12238,  9500, -2302, -1398,  6466, -12924, 10340, -14752, 19498, -24300, 14396, -16265, 17504, -17838,  8490, -7325,  5290, -2272,  -912,  3534, -6753, 10585, -7523, 10088, -13038, 16497, -2597,  3337, -4631,  8565, },
	{ -1756,  1206,  1778, -8874,  5510, -10823, 18584, -29033, 10519, -14288, 18266, -21976, 12372, -12851, 11913, -8997,  1770,  2482, -8443, 16192, -12828, 18287, -24231, 30300, -18003, 20376, -21920, 22252, -10490,  8859, -6063,  1967,  1758, -5204,  9328, -14061,  9646, -12433, 15292, -18103, 10363, -11499, 12357, -12796,  1571, -1378,   656, 30466, },
	{  1583, -4930, 11359, -21979,  9425, -14730, 21290, -28662,  8997, -10483, 11158, -10436,  3820, -1022, -3522, 10100, -9440, 14928, -21388, 28550, -17989, 21530, -24507, 26454, -13425, 12575, -10411,  6696,  -623, -3020,  7581, -12994,  9561, -12874, 16285, -19603, 11298, -12493, 13227, -13313,  6261, -5275,  3472,  -459,  -575,  1749, -4636, 27275, },
	{  3261, -7574, 14334, -23719,  8838, -12007, 14871, -16546,  3956, -2799,   233,  4188, -5436, 10060, -16019, 23228, -15711, 20056, -24289, 27924, -15181, 15458, -14421, 11702, -3481,   -32,  4764, -10718,  8898, -12898, 17193, -21556, 12848, -14631, 15924, -16503,  8061, -7260,  5706, -3237,  -171,  2651, -6036, 10721, -2195,  3600, -6593, 20432, },
	{  3080, -6504, 10891, -15528,  4760, -4815,  3302,   707, -2066,  5106, -9526, 15466, -11460, 15837, -20626, 25430, -14843, 16333, -16748, 15602, -6196,  3320,  1023, -6961,  7258, -11790, 16942, -22491, 14059, -16706, 18937, -20466, 10491, -10077,  8830, -6589,  1605,   721, -3743,  7520, -6063,  8833, -12172, 16291, -2708,  3695, -5532, 11701, },
	{  1722, -3121,  3850, -2683,  -527,  3175, -7884, 15260, -6447,  9924, -14197, 19069, -12078, 14429, -16174, 16791, -7836,  6079, -2798, -2295,  4703, -9308, 14916, -21370, 14195, -17778, 21158, -23992, 12942, -13200, 12546, -10760,  3822, -1516, -1593,  5531, -5143,  7904, -11004, 14380, -8978, 10824, -12687, 14541, -2048,  2289, -2589,  3223, },
	{   547, -3085,  8630, -18554,  8549, -14139, 21483, -30364, 10040, -12437, 14353, -15213,  7152, -5406,  1942,  3643, -5836, 11162, -17785, 25548, -17063, 21503, -25737, 29313, -15848, 16146, -15239, 12823, -4314,  1221,  2932, -8149,  7185, -10727, 14588, -18612, 11298, -13149, 14709, -15806,  8114, -7850,  6915, -4975,   166,   741, -3131, 28888, },
	{  2893, -7094, 14094, -24419,  9534, -13642, 17994, -21824,  5997, -5740,  4220,  -914, -2352,  6554, -12313, 19677, -14262, 19261, -24542, 29672, -17042, 18539, -18930, 17790, -7348,  4632,  -596, -4848,  5852, -9936, 14561, -19550, 12326, -14773, 16922, -18549,  9699, -9593,  8800, -7138,  2193,  -123, -2875,  7224, -1728,  3137, -6283, 23173, },
	{  3327, -7243, 12704, -19280,  6472, -7652,  7639, -5476,     0,  2518, -6498, 12200, -9886, 14587, -20062, 26006, -15969, 18590, -20434, 20989, -9845,  7979, -4625,  -442,  3681, -8079, 13353, -19351, 12910, -16201, 19318, -21981, 11935, -12314, 11941, -10624,  4086, -2198,  -447,  3949, -4216,  7034, -10579, 15138, -2669,  3860, -6194, 14872, },
	{  2273, -4455,  6516, -7355,  1320,   496, -4302, 10852, -5216,  8720, -13274, 18796, -12510, 15729, -18684, 20871, -10834, 10178, -8082,  4171,   941, -5155, 10597, -17206, 12401, -16528, 20746, -24739, 14059, -15216, 15597, -14944,  6503, -4775,  2187,  1335, -2920,  5671, -8911, 12622, -8388, 10676, -13185, 15968, -2399,  2916, -3753,  6063, },
	{  -664,  -855,  5138, -13753,  7103, -12673, 20420, -30372, 10547, -13755, 16852, -19304, 10200, -9640,  7489, -3246, -1776,  6635, -13048, 20987, -15130, 20239, -25522, 30564, -17423, 18878, -19308, 18359, -7842,  5486, -1987, -2733,  4347, -7920, 12020, -16534, 10653, -13067, 15385, -17457,  9553, -10055, 10082, -9395,   939,  -389, -1215, 29982, },
	{  2275, -6113, 12968, -23698,  9709, -14570, 20235, -26101,  7789, -8484,  8136, -6177,   991,  2536, -7761, 14865, -11943, 17330, -23389, 29765, -17976, 20640, -22473, 23016, -10891,  9145, -6051,  1435,  2402, -6339, 11039, -16382, 11088, -14074, 16975, -19579, 10818, -11431, 11465, -10730,  4497, -2974,   559,  3169, -1138,  2458, -5559, 25586, },
	{  3383, -7606, 13902, -22165,  7919, -10216, 11780, -11672,  2170,  -341, -2955,  8086, -7674, 12444, -18316, 25100, -16211, 19847, -23056, 25329, -13034, 12310, -10159,  6272,  -198, -3814,  8914, -15029, 10995, -14758, 18603, -22273, 12728, -13894, 14437, -14140,  6389, -5058,  2953,    63, -2078,  4779, -8324, 13068, -2473,  3811, -6556, 17979, },
	{  2760, -5665,  9038, -11966,  3223, -2388,  -251,  5562, -3615,  6947, -11536, 17419, -12234, 16168, -20205, 23890, -13308, 13823, -13066, 10592, -2984,  -589,  5552, -11946,  9850, -14300, 19136, -24086, 14396, -16408, 17824, -18366,  8871, -7831,  5925, -3029,  -480,  3062, -6260, 10098, -7301,  9913, -12942, 16529, -2626,  3411, -4801,  9101, },
	{ -1990,  1655,  1032, -7764,  5136, -10366, 18093, -28598, 10461, -14331, 18479, -22441, 12776, -13475, 12801, -10184,  2520,  1582, -7417, 15087, -12272, 17779, -23836, 30093, -18038, 20595, -22368, 22971, -11001,  9533, -6901,  2957,  1198, -4600,  8708, -13465,  9384, -12237, 15197, -18152, 10485, -11750, 12783, -13464,  1700, -1588,  1078, 30518, },
	{  1418, -4642, 10946, -21490,  9315, -14691, 21411, -29071,  9213, -10861, 11752, -11300,  4408, -1781, -2596,  9029, -8858, 14339, -20853, 28148, -17903, 21614, -24820, 27056, -13899, 13244, -11289,  7783, -1265, -2298,  6807, -12208,  9189, -12554, 16058, -19512, 11344, -12657, 13538, -13798,  6606, -5740,  4079, -1236,  -451,  1585, -4406, 27589, },
	{  3215, -7526, 14354, -23937,  8993, -12336, 15465, -17517,  4322, -3314,   918,  3329, -4928,  9498, -15447, 22712, -15525, 20001, -24432, 28340, -15564, 16053, -15259, 12802, -4164,   775,  3857, -9746,  8407, -12438, 16808, -21297, 12810, -14715, 16162, -16925,  8378, -7694,  6264, -3924,   237,  2183, -5516, 10163, -2124,  3536, -6568, 20926, },
	{  3134, -6655, 11242, -16228,  5070, -5318,  4056,  -347, -1721,  4684, -9046, 14969, -11236, 15687, -20613, 25633, -15098, 16789, -17452, 16596, -6851,  4138,    52, -5862,  6669, -11196, 16390, -22039, 13918, -16687, 19080, -20812, 10783, -10506,  9404, -7315,  2041,   219, -3188,  6934, -5768,  8558, -11947, 16159, -2713,  3738, -5665, 12250, },
	{  1820, -3357,  4314, -3484,  -216,  2732, -7306, 14570, -6263,  9759, -14097, 19100, -12202, 14712, -16672, 17562, -8384,  6810, -3721, -1189,  4073, -8629, 14231, -20738, 13942, -17635, 21173, -24219, 13188, -13603, 13125, -11528,  4301, -2087,  -945,  4827, -4779,  7550, -10687, 14134, -8912, 10842, -12825, 14845, -2117,  2405, -2796,  3697, },
	{   349, -2724,  8077, -17818,  8338, -13948, 21390, -30490, 10168, -12714, 14841, -15978,  7705, -6157,  2905,  2471, -5160, 10427, -17040, 24865, -16799, 21372, -25805, 29649, -16185, 16684, -16005, 13833, -4942,  1964,  2092, -7245,  6723, -10285, 14203, -18328, 11233, -13188, 14886, -16156,  8395, -8262,  7489, -5754,   299,   553, -2828, 29116, },
	{  2803, -6960, 13964, -24399,  9604, -13857, 18451, -22645,  6329, -6234,  4909, -1822, -1787,  5890, -11580, 18929, -13921, 19007, -24443, 29810, -17272, 18977, -19619, 18766, -7991,  5432, -1542, -3781,  5279, -9354, 14011, -19081, 12162, -14712, 17000, -18803,  9932, -9950,  9297, -7788,  2600,  -615, -2296,  6556, -1634,  3035, -6188, 23617, },
	{  3351, -7335, 12959, -19849,  6745, -8120,  8377, -6557,   371,  2038, -5916, 11544, -9546, 14278, -19843, 25957, -16076, 18883, -20970, 21824, -10436,  8760, -5600,   717,  3025, -7375, 12640, -18682, 12631, -16017, 19273, -22122, 12121, -12638, 12422, -11276,  4501, -2702,   139,  3294, -3864,  6674, -10233, 14844, -2646,  3867, -6279, 15417, },
	{  2364, -4676,  6968, -8165,  1649,     7, -3629,  9993, -4963,  8452, -13031, 18637, -12514, 15869, -19022, 21477, -11305, 10848, -8975,  5296,   268, -4388,  9768, -16368, 12010, -16210, 20552, -24727, 14174, -15485, 16046, -15597,  6940, -5323,  2843,   585, -2509,  5242, -8489, 12237, -8234, 10588, -13197, 16129, -2447,  3013, -3944,  6577, },
	{  -887,  -438,  4466, -12795,  6797, -12332, 20107, -30194, 10575, -13910, 17201, -19922, 10685, -10340,  8434, -4455, -1043,  5790, -12130, 20055, -14698, 19897, -25334, 30607, -17600, 19252, -19916, 19232, -8421,  6209, -2846, -1759,  3819, -7378, 11495, -16070, 10477, -12977, 15415, -17648,  9753, -10388, 10588, -10132,  1073,  -593,  -844, 30115, },
	{  2143, -5892, 12682, -23423,  9682, -14651, 20520, -26716,  8065, -8926,  8790, -7082,  1582,  1804, -6904, 13921, -11460, 16885, -23047, 29608, -18036, 20893, -22970, 23808, -11456,  9891, -6982,  2540,  1777, -5665, 10351, -15726, 10804, -13868, 16885, -19647, 10953, -11690, 11870, -11304,  4880, -3463,  1167,  2425, -1025,  2320, -5390, 25964, },
	{  3370, -7625, 14037, -22558,  8134, -10619, 12457, -12719,  2547,  -852, -2303,  7302, -7234, 11988, -17897, 24791, -16159, 19955, -23388, 25952, -13524, 13006, -11082,  7426,  -885, -3036,  8075, -14177, 10592, -14416, 18368, -22195, 12794, -14093, 14795, -14680,  6759, -5534,  3537,  -626, -1687,  4351, -7874, 12622, -2423,  3780, -6585, 18503, },
	{  2834, -5855,  9447, -12737,  3550, -2897,   483,  4575, -3306,  6588, -11156, 17069, -12113, 16152, -20358, 24288, -13671, 14391, -13876, 11671, -3664,   225,  4624, -10944,  9340, -13821, 18739, -23831, 14372, -16523, 18114, -18864,  9238, -8326,  6551, -3783,   -46,  2582, -5754,  9592, -7066,  9719, -12823, 16532, -2652,  3481, -4966,  9641, },
	{ -2226,  2109,   273, -6626,  4748, -9887, 17566, -28109, 10383, -14350, 18661, -22870, 13161, -14080, 13673, -11360,  3270,   674, -6373, 13950, -11693, 17239, -23398, 29834, -18042, 20779, -22779, 23654, -11497, 10194, -7730,  3947,   635, -3986,  8072, -12844,  9105, -12018, 15075, -18169, 10589, -11984, 13190, -14114,  1827, -1799,  1510, 30553, },
	{  1247, -4340, 10508, -20957,  9188, -14625, 21496, -29433,  9414, -11223, 12330, -12149,  4993, -2541, -1660,  7936, -8257, 13723, -20281, 27697, -17785, 21660, -25091, 27615, -14351, 13893, -12151,  8862, -1906, -1570,  6018, -11399,  8799, -12213, 15802, -19386, 11371, -12801, 13826, -14262,  6942, -6199,  4683, -2017,  -325,  1417, -4163, 27889, },
	{  3161, -7464, 14349, -24115,  9134, -12646, 16039, -18466,  4683, -3828,  1606,  2458, -4409,  8916, -14844, 22153, -15312, 19912, -24534, 28709, -15923, 16624, -16075, 13885, -4842,  1583,  2938, -8754,  7900, -11955, 16392, -21000, 12750, -14775, 16373, -17319,  8681, -8115,  6814, -4608,   646,  1709, -4984,  9585, -2049,  3465, -6531, 21413, },
	{  3184, -6798, 11578, -16908,  5376, -5817,  4810, -1410, -1370,  4249, -8546, 14442, -10992, 15509, -20565, 25794, -15328, 17218, -18130, 17566, -7498,  4953,  -924, -4749,  6066, -10581, 15809, -21549, 13752, -16639, 19192, -21124, 11059, -10918,  9965, -8030,  2475,  -286, -2625,  6333, -5463,  8268, -11700, 15998, -2712,  3775, -5791, 12800, },
	{  1917, -3591,  4779, -4290,   100,  2280, -6709, 13848, -6066,  9575, -13972, 19099, -12305, 14971, -17145, 18308, -8922,  7534, -4642,   -74,  3433, -7932, 13518, -20067, 13665, -17460, 21152, -24406, 13412, -13984, 13684, -12280,  4776, -2655,  -293,  4112, -4406,  7181, -10350, 13864, -8831, 10843, -12941, 15127, -2182,  2519, -3001,  4179, },
	{   145, -2352,  7501, -17040,  8111, -13730, 21259, -30565, 10280, -12971, 15307, -16721,  8249, -6901,  3869,  1288, -4471,  9670, -16263, 24136, -16505, 21205, -25829, 29935, -16496, 17196, -16747, 14824, -5564,  2707,  1246, -6325,  6248, -9823, 13792, -18012, 11148, -13205, 15038, -16479,  8664, -8663,  8053, -6529,   432,   361, -2513, 29328, },
	{  2707, -6811, 13806, -24335,  9657, -14049, 18880, -23434,  6652, -6721,  5595, -2733, -1216,  5211, -10822, 18143, -13554, 18719, -24302, 29897, -17475, 19386, -20278, 19714, -8622,  6225, -2489, -2703,  4695, -8753, 13435, -18578, 11976, -14626, 17050, -19025, 10149, -10292,  9780, -8428,  3005, -1109, -1708,  5873, -1537,  2926, -6080, 24050, },
	{  3370, -7415, 13195, -20391,  7009, -8579,  9108, -7638,   745,  1551, -5321, 10863, -9188, 13943, -19589, 25862, -16156, 19145, -21472, 22625, -11012,  9529, -6570,  1879,  2362, -6654, 11902, -17979, 12330, -15806, 19195, -22225, 12287, -12941, 12883, -11911,  4910, -3203,   728,  2629, -3503,  6300, -9868, 14522, -2619,  3868, -6356, 15959, },
	{  2452, -4893,  7414, -8972,  1978,  -487, -2943,  9109, -4700,  8167, -12762, 18444, -12497, 15983, -19330, 22048, -11759, 11503, -9857,  6418,  -410, -3609,  8920, -15497, 11598, -15863, 20323, -24673, 14266, -15727, 16469, -16227,  7366, -5865,  3497,  -169, -2093,  4803, -8051, 11829, -8066, 10481, -13186, 16264, -2492,  3105, -4132,  7097, },
	{ -1114,   -12,  3777, -11802,  6477, -11966, 19756, -29961, 10586, -14042, 17522, -20510, 11154, -11026,  9371, -5663,  -304,  4932, -11186, 19083, -14239, 19519, -25103, 30598, -17748, 19594, -20493, 20075, -8988,  6924, -3703,  -778,  3284, -6821, 10950, -15577, 10282, -12864, 15419, -17810,  9937, -10705, 11079, -10856,  1206,  -799,  -461, 30232, },
	{  2005, -5658, 12368, -23103,  9638, -14707, 20771, -27291,  8329, -9357,  9434, -7981,  2175,  1064, -6029, 12947, -10955, 16409, -22664, 29399, -18067, 21110, -23430, 24563, -12003, 10624, -7904,  3644,  1147, -4979,  9643, -15041, 10501, -13638, 16766, -19682, 11070, -11930, 12257, -11861,  5256, -3949,  1778,  1672,  -910,  2176, -5209, 26329, },
	{  3351, -7631, 14148, -22916,  8338, -11008, 13120, -13754,  2923, -1365, -1641,  6500, -6778, 11509, -17445, 24438, -16079, 20029, -23681, 26534, -13993, 13684, -11990,  8573, -1572, -2250,  7220, -13296, 10170, -14049, 18101, -22078, 12838, -14269, 15128, -15196,  7119, -6004,  4119, -1317, -1291,  3913, -7408, 12151, -2369,  3741, -6602, 19022, },
	{  2905, -6037,  9846, -13496,  3875, -3406,  1223,  3571, -2988,  6214, -10754, 16688, -11970, 16108, -20477, 24646, -14013, 14937, -14667, 12736, -4341,  1042,  3685, -9918,  8812, -13317, 18309, -23533, 14323, -16610, 18374, -19332,  9591, -8809,  7169, -4534,   390,  2097, -5236,  9068, -6818,  9508, -12682, 16508, -2673,  3545, -5124, 10183, },
	{ -2463,  2566,  -496, -5462,  4348, -9386, 17003, -27567, 10288, -14344, 18813, -23263, 13526, -14665, 14527, -12523,  4018,  -240, -5312, 12784, -11092, 16666, -22918, 29523, -18015, 20928, -23154, 24299, -11974, 10840, -8549,  4933,    68, -3363,  7419, -12198,  8809, -11779, 14927, -18156, 10676, -12198, 13577, -14745,  1953, -2009,  1951, 30570, },
	{  1070, -4025, 10045, -20381,  9043, -14533, 21544, -29748,  9601, -11569, 12891, -12985,  5573, -3301,  -715,  6824, -7638, 13080, -19670, 27195, -17637, 21670, -25321, 28129, -14780, 14521, -12995,  9930, -2547,  -836,  5217, -10567,  8393, -11849, 15518, -19228, 11379, -12923, 14092, -14703,  7268, -6649,  5282, -2800,  -197,  1244, -3907, 28175, },
	{  3101, -7386, 14318, -24253,  9261, -12937, 16590, -19391,  5039, -4340,  2297,  1577, -3878,  8315, -14213, 21553, -15072, 19787, -24594, 29031, -16256, 17169, -16867, 14949, -5516,  2392,  2012, -7742,  7378, -11449, 15947, -20667, 12668, -14809, 16557, -17685,  8970, -8525,  7355, -5287,  1056,  1230, -4440,  8986, -1969,  3387, -6482, 21891, },
	{  3230, -6930, 11900, -17568,  5675, -6311,  5563, -2480, -1013,  3805, -8028, 13886, -10727, 15303, -20481, 25911, -15533, 17621, -18781, 18510, -8135,  5764, -1904, -3623,  5451, -9945, 15197, -21019, 13562, -16563, 19270, -21400, 11317, -11313, 10511, -8735,  2907,  -792, -2056,  5718, -5146,  7962, -11432, 15810, -2707,  3806, -5909, 13349, },
	{  2013, -3824,  5242, -5099,   419,  1818, -6095, 13096, -5858,  9373, -13822, 19065, -12389, 15206, -17591, 19027, -9447,  8249, -5560,  1045,  2783, -7218, 12779, -19359, 13364, -17255, 21095, -24551, 13615, -14343, 14222, -13013,  5244, -3222,   362,  3388, -4023,  6799, -9994, 13569, -8735, 10824, -13036, 15384, -2244,  2629, -3203,  4668, },
	{   -63, -1970,  6904, -16223,  7867, -13486, 21090, -30588, 10374, -13208, 15750, -17440,  8782, -7639,  4832,    96, -3771,  8892, -15453, 23363, -16181, 21000, -25809, 30172, -16780, 17681, -17463, 15793, -6180,  3448,   394, -5390,  5760, -9344, 13356, -17664, 11044, -13200, 15165, -16777,  8919, -9050,  8607, -7298,   566,   166, -2185, 29524, },
	{  2603, -6647, 13622, -24228,  9694, -14219, 19281, -24190,  6966, -7201,  6277, -3645,  -638,  4519, -10042, 17323, -13161, 18397, -24119, 29933, -17648, 19763, -20906, 20633, -9242,  7011, -3436, -1616,  4100, -8136, 12833, -18042, 11770, -14515, 17070, -19217, 10350, -10617, 10248, -9056,  3406, -1604, -1115,  5175, -1436,  2810, -5960, 24472, },
	{  3382, -7483, 13411, -20903,  7264, -9028,  9830, -8714,  1121,  1058, -4711, 10158, -8811, 13582, -19300, 25723, -16209, 19376, -21941, 23392, -11571, 10286, -7533,  3044,  1691, -5920, 11141, -17242, 12006, -15566, 19084, -22290, 12432, -13224, 13324, -12529,  5313, -3701,  1317,  1958, -3135,  5914, -9485, 14174, -2586,  3862, -6423, 16499, },
	{  2537, -5105,  7855, -9775,  2308,  -986, -2244,  8200, -4427,  7866, -12470, 18218, -12457, 16070, -19606, 22586, -12195, 12142, -10727,  7534, -1090, -2820,  8052, -14596, 11164, -15488, 20057, -24576, 14335, -15944, 16866, -16830,  7781, -6399,  4147,  -925, -1672,  4354, -7597, 11400, -7883, 10356, -13153, 16372, -2534,  3192, -4316,  7621, },
	{ -1343,   421,  3071, -10776,  6142, -11576, 19367, -29675, 10578, -14152, 17815, -21067, 11608, -11697, 10297, -6868,   440,  4060, -10219, 18074, -13754, 19106, -24828, 30538, -17867, 19905, -21037, 20888, -9541,  7630, -4557,   207,  2740, -6250, 10383, -15056, 10069, -12729, 15397, -17943, 10105, -11006, 11554, -11568,  1338, -1007,   -68, 30332, },
	{  1859, -5408, 12028, -22738,  9577, -14738, 20988, -27823,  8581, -9774, 10066, -8873,  2768,   317, -5139, 11945, -10428, 15902, -22240, 29139, -18066, 21293, -23853, 25280, -12532, 11341, -8817,  4746,   513, -4283,  8916, -14328, 10179, -13384, 16619, -19683, 11169, -12150, 12624, -12401,  5625, -4431,  2388,   911,  -791,  2027, -5014, 26682, },
	{  3325, -7623, 14237, -23238,  8529, -11382, 13766, -14774,  3297, -1881,  -972,  5682, -6307, 11007, -16960, 24041, -15971, 20069, -23935, 27073, -14441, 14342, -12881,  9710, -2261, -1456,  6348, -12390,  9728, -13657, 17802, -21924, 12861, -14420, 15437, -15689,  7469, -6464,  4695, -2009,  -890,  3466, -6927, 11657, -2310,  3696, -6609, 19535, },
	{  2971, -6212, 10233, -14241,  4197, -3914,  1968,  2552, -2663,  5827, -10330, 16276, -11805, 16035, -20562, 24965, -14332, 15461, -15436, 13785, -5013,  1862,  2734, -8870,  8267, -12789, 17845, -23194, 14250, -16670, 18604, -19769,  9929, -9278,  7777, -5279,   827,  1605, -4707,  8525, -6557,  9280, -12518, 16455, -2690,  3604, -5277, 10728, },
	{  1546, -2700,  3027, -1276, -1068,  3936, -8864, 16406, -6743, 10173, -14313, 18933, -11809, 13870, -15228, 15362, -6836,  4764, -1159, -4237,  5795, -10468, 16063, -22396, 14580, -17957, 21042, -23490, 12453, -12433, 11469, -9357,  2957,  -502, -2732,  6752, -5765,  8497, -11518, 14753, -9056, 10745, -12392, 13943, -1919,  2076, -2218,  2401, },
	{   887, -3698,  9557, -19761,  8880, -14414, 21555, -30014,  9773, -11897, 13435, -13803,  6148, -4061,   237,  5693, -7003, 12412, -19023, 26645, -17458, 21643, -25509, 28597, -15186, 15127, -13821, 10985, -3186,   -98,  4403, -9714,  7972, -11463, 15207, -19035, 11367, -13024, 14335, -15122,  7583, -7090,  5876, -3584,   -67,  1066, -3639, 28445, },
	{  3032, -7294, 14261, -24350,  9373, -13209, 17117, -20291,  5390, -4848,  2990,   686, -3337,  7696, -13553, 20913, -14804, 19629, -24613, 29306, -16563, 17687, -17633, 15992, -6182,  3201,  1077, -6714,  6841, -10923, 15473, -20296, 12564, -14819, 16713, -18022,  9246, -8922,  7885, -5960,  1466,   746, -3885,  8368, -1886,  3303, -6422, 22361, },
	{  3269, -7052, 12204, -18206,  5968, -6800,  6314, -3555,  -652,  3350, -7492, 13303, -10442, 15070, -20362, 25985, -15713, 17996, -19403, 19429, -8762,  6568, -2884, -2486,  4823, -9290, 14558, -20451, 13348, -16458, 19317, -21642, 11556, -11690, 11041, -9427,  3335, -1298, -1481,  5091, -4820,  7641, -11143, 15593, -2698,  3831, -6019, 13898, },
	{  2108, -4054,  5703, -5911,   741,  1349, -5463, 12313, -5637,  9153, -13647, 18998, -12451, 15417, -18010, 19718, -9959,  8954, -6474,  2169,  2126, -6488, 12014, -18615, 13038, -17020, 21002, -24656, 13795, -14679, 14738, -13727,  5704, -3785,  1019,  2655, -3633,  6404, -9620, 13249, -8623, 10788, -13110, 15617, -2303,  2736, -3404,  5165, },
	{  -276, -1577,  6286, -15367,  7606, -13216, 20883, -30557, 10452, -13424, 16169, -18135,  9304, -8369,  5792, -1103, -3061,  8095, -14613, 22545, -15828, 20759, -25745, 30359, -17036, 18138, -18152, 16739, -6787,  4186,  -461, -4443,  5261, -8846, 12896, -17284, 10920, -13172, 15267, -17047,  9160, -9424,  9149, -8061,   700,   -31, -1846, 29703, },
	{  2491, -6468, 13411, -24077,  9714, -14366, 19652, -24911,  7271, -7671,  6953, -4558,   -55,  3815, -9239, 16467, -12744, 18042, -23893, 29918, -17793, 20108, -21500, 21520, -9849,  7788, -4381,  -522,  3496, -7502, 12208, -17473, 11542, -14378, 17062, -19376, 10534, -10926, 10701, -9671,  3803, -2098,  -516,  4464, -1331,  2689, -5827, 24884, },
	{  3388, -7539, 13607, -21386,  7509, -9466, 10542, -9786,  1498,   559, -4089,  9431, -8417, 13194, -18977, 25538, -16234, 19574, -22375, 24123, -12114, 11028, -8488,  4208,  1015, -5172, 10357, -16473, 11661, -15299, 18940, -22318, 12557, -13485, 13745, -13127,  5708, -4194,  1907,  1280, -2760,  5515, -9083, 13799, -2550,  3850, -6480, 17036, },
	{  2620, -5312,  8288, -10571,  2639, -1488, -1535,  7269, -4143,  7549, -12154, 17960, -12396, 16130, -19851, 23088, -12613, 12764, -11583,  8644, -1772, -2023,  7166, -13666, 10709, -15084, 19757, -24437, 14378, -16135, 17236, -17408,  8185, -6923,  4792, -1683, -1246,  3896, -7128, 10949, -7686, 10212, -13097, 16453, -2571,  3275, -4495,  8150, },
	{ -1574,   860,  2349, -9718,  5792, -11161, 18941, -29335, 10552, -14237, 18080, -21591, 12044, -12352, 11211, -8068,  1187,  3177, -9228, 17029, -13243, 18658, -24509, 30424, -17956, 20183, -21547, 21669, -10080,  8326, -5407,  1196,  2190, -5666,  9797, -14507,  9838, -12571, 15348, -18045, 10257, -11290, 12012, -12265,  1469, -1216,   335, 30414, },
	{  1706, -5145, 11662, -22328,  9498, -14744, 21172, -28312,  8820, -10178, 10685, -9757,  3360,  -435, -4235, 10917, -9880, 15365, -21776, 28827, -18035, 21441, -24236, 25956, -13042, 12042, -9719,  5845,  -125, -3576,  8172, -13588,  9838, -13106, 16442, -19652, 11249, -12351, 12971, -12922,  5986, -4908,  2999,   143,  -671,  1873, -4807, 27021, },
	{  3292, -7601, 14301, -23523,  8708, -11740, 14395, -15778,  3669, -2397,  -297,  4847, -5822, 10483, -16443, 23601, -15836, 20075, -24150, 27569, -14866, 14978, -13755, 10835, -2948,  -657,  5462, -11458,  9268, -13239, 17471, -21732, 12862, -14548, 15721, -16157,  7807, -6916,  5266, -2700,  -487,  3010, -6431, 11139, -2247,  3645, -6604, 20042, },
	{  3034, -6379, 10608, -14971,  4515, -4422,  2718,  1519, -2329,  5426, -9886, 15832, -11619, 15935, -20611, 25243, -14629, 15961, -16183, 14815, -5681,  2682,  1775, -7803,  7706, -12236, 17350, -22814, 14152, -16701, 18804, -20174, 10251, -9734,  8374, -6019,  1265,  1109, -4169,  7966, -6283,  9035, -12332, 16374, -2702,  3657, -5423, 11275, },
	{  1645, -2937,  3489, -2065,  -766,  3512, -8321, 15774, -6582, 10040, -14258, 19022, -11968, 14193, -15769, 16174, -7402,  5505, -2080, -3149,  5186, -9823, 15429, -21834, 14373, -17869, 21121, -23787, 12736, -12872, 12082, -10152,  3445, -1072, -2094,  6070, -5419,  8170, -11237, 14553, -9018, 10796, -12566, 14288, -1993,  2197, -2427,  2860, },
	{   698, -3358,  9045, -19099,  8700, -14270, 21529, -30230,  9930, -12208, 13959, -14604,  6716, -4819,  1195,  4545, -6352, 11718, -18340, 26046, -17248, 21579, -25654, 29018, -15568, 15709, -14627, 12025, -3822,   643,  3579, -8841,  7535, -11057, 14869, -18810, 11336, -13102, 14555, -15516,  7886, -7522,  6464, -4367,    64,   885, -3358, 28700, },
	{  2957, -7187, 14178, -24405,  9470, -13461, 17621, -21165,  5734, -5352,  3682,  -212, -2786,  7060, -12866, 20233, -14510, 19435, -24589, 29531, -16843, 18177, -18374, 17013, -6841,  4007,   138, -5670,  6290, -10375, 14971, -19890, 12439, -14803, 16842, -18330,  9507, -9305,  8404, -6626,  1876,   258, -3321,  7731, -1799,  3212, -6349, 22822, },
	{  3304, -7164, 12492, -18820,  6255, -7282,  7061, -4635,  -287,  2885, -6939, 12693, -10136, 14809, -20207, 26014, -15867, 18341, -19995, 20318, -9376,  7365, -3864, -1339,  4184, -8616, 13891, -19846, 13111, -16324, 19330, -21847, 11776, -12048, 11554, -10106,  3759, -1805,  -901,  4453, -4484,  7305, -10834, 15348, -2683,  3850, -6121, 14446, },
	{  2202, -4281,  6162, -6723,  1066,   872, -4816, 11502, -5405,  8916, -13447, 18897, -12493, 15603, -18400, 20379, -10457,  9647, -7382,  3295,  1462, -5743, 11226, -17836, 12689, -16755, 20872, -24719, 13952, -14991, 15230, -14420,  6157, -4344,  1676,  1915, -3235,  5996, -9228, 12905, -8497, 10732, -13161, 15824, -2358,  2839, -3601,  5668, },
	{  -493, -1175,  5647, -14474,  7329, -12920, 20637, -30474, 10512, -13619, 16563, -18803,  9813, -9088,  6749, -2308, -2341,  7280, -13744, 21685, -15446, 20481, -25636, 30494, -17265, 18566, -18814, 17660, -7384,  4919, -1319, -3485,  4750, -8332, 12412, -16874, 10777, -13122, 15343, -17289,  9387, -9785,  9679, -8815,   835,  -232, -1495, 29867, },
	{  2373, -6274, 13172, -23881,  9718, -14490, 19992, -25595,  7566, -8133,  7622, -5470,   532,  3099, -8415, 15579, -12303, 17654, -23626, 29852, -17907, 20420, -22061, 22375, -10441,  8556, -5322,   578,  2883, -6853, 11559, -16871, 11294, -14216, 17024, -19503, 10701, -11217, 11137, -10272,  4195, -2591,    87,  3740, -1224,  2561, -5681, 25283, },
	{  3387, -7582, 13781, -21837,  7744, -9893, 11243, -10850,  1876,    54, -3455,  8683, -8005, 12782, -18618, 25309, -16232, 19741, -22773, 24816, -12639, 11755, -9432,  5371,   334, -4412,  9553, -15673, 11295, -15005, 18763, -22307, 12661, -13724, 14143, -13705,  6094, -4682,  2496,   597, -2379,  5105, -8663, 13398, -2508,  3830, -6527, 17568, },
	{  2700, -5513,  8713, -11359,  2968, -1994,  -816,  6316, -3850,  7216, -11815, 17668, -12314, 16162, -20063, 23553, -13012, 13367, -12424,  9744, -2454, -1219,  6264, -12709, 10233, -14653, 19421, -24256, 14398, -16299, 17578, -17958,  8576, -7438,  5432, -2440,  -817,  3430, -6645, 10478, -7475, 10051, -13019, 16507, -2604,  3354, -4669,  8684, },
	{ -1808,  1305,  1614, -8630,  5428, -10723, 18478, -28941, 10508, -14299, 18316, -22083, 12463, -12991, 12111, -9261,  1936,  2283, -8217, 15949, -12706, 18177, -24147, 30258, -18014, 20428, -22022, 22415, -10605,  9010, -6250,  2187,  1634, -5071,  9192, -13931,  9590, -12392, 15273, -18117, 10392, -11556, 12453, -12946,  1600, -1425,   749, 30479, },
	{  1547, -4867, 11269, -21874,  9402, -14724, 21320, -28757,  9047, -10568, 11291, -10629,  3951, -1191, -3317,  9864, -9313, 14799, -21272, 28465, -17973, 21552, -24580, 26591, -13532, 12725, -10607,  6938,  -766, -2860,  7410, -12821,  9480, -12805, 16237, -19586, 11310, -12531, 13298, -13423,  6338, -5379,  3608,  -631,  -548,  1713, -4586, 27346, },
	{  3251, -7564, 14340, -23771,  8873, -12082, 15005, -16764,  4038, -2913,   385,  3998, -5324,  9937, -15895, 23117, -15672, 20047, -24324, 28020, -15268, 15592, -14609, 11947, -3633,   147,  4564, -10504,  8791, -12797, 17110, -21502, 12841, -14652, 15979, -16599,  8133, -7358,  5831, -3390,   -81,  2548, -5921, 10599, -2179,  3586, -6588, 20542, },
	{  3092, -6538, 10970, -15685,  4829, -4927,  3470,   474, -1990,  5013, -9421, 15358, -11412, 15807, -20626, 25479, -14902, 16437, -16907, 15825, -6342,  3502,   808, -6718,  7128, -11660, 16822, -22394, 14030, -16704, 18972, -20546, 10557, -10174,  8958, -6751,  1702,   610, -3620,  7391, -5998,  8773, -12124, 16264, -2710,  3705, -5562, 11823, },
	{  1744, -3174,  3953, -2861,  -458,  3077, -7757, 15110, -6407,  9889, -14177, 19079, -12107, 14494, -16287, 16964, -7959,  6242, -3003, -2050,  4564, -9159, 14766, -21233, 14141, -17749, 21164, -24046, 12998, -13291, 12676, -10932,  3929, -1643, -1449,  5375, -5063,  7827, -10935, 14327, -8965, 10829, -12720, 14610, -2064,  2315, -2635,  3328, },
	{   504, -3006,  8509, -18394,  8503, -14099, 21466, -30396, 10070, -12500, 14463, -15385,  7276, -5573,  2156,  3383, -5687, 11001, -17622, 25400, -17007, 21477, -25756, 29392, -15925, 16267, -15411, 13049, -4454,  1386,  2746, -7950,  7083, -10630, 14505, -18551, 11286, -13159, 14750, -15886,  8177, -7943,  7044, -5148,   196,   700, -3064, 28940, },
	{  2873, -7065, 14068, -24418,  9551, -13692, 18098, -22009,  6071, -5850,  4373, -1116, -2227,  6408, -12152, 19514, -14189, 19208, -24523, 29707, -17095, 18639, -19086, 18009, -7492,  4810,  -806, -4612,  5726, -9808, 14441, -19449, 12291, -14762, 16942, -18608,  9752, -9674,  8911, -7283,  2284,  -232, -2747,  7077, -1708,  3115, -6263, 23273, },
	{  3333, -7265, 12762, -19409,  6534, -7757,  7804, -5716,    82,  2412, -6370, 12056, -9812, 14521, -20016, 25999, -15995, 18658, -20556, 21177, -9978,  8154, -4842,  -185,  3536, -7924, 13197, -19205, 12850, -16163, 19311, -22016, 11978, -12387, 12049, -10770,  4179, -2310,  -317,  3805, -4138,  6955, -10504, 15075, -2664,  3862, -6213, 14993, },
	{  2294, -4505,  6617, -7535,  1393,   388, -4154, 10664, -5161,  8662, -13222, 18764, -12513, 15763, -18762, 21009, -10940, 10328, -8281,  4422,   792, -4986, 10414, -17023, 12316, -16460, 20706, -24740, 14086, -15278, 15699, -15091,  6601, -4897,  2333,  1169, -2829,  5576, -8819, 12538, -8355, 10658, -13190, 16006, -2410,  2938, -3796,  6177, },
	{  -713,  -763,  4990, -13543,  7036, -12599, 20353, -30337, 10555, -13791, 16932, -19443, 10309, -9797,  7700, -3515, -1613,  6448, -12847, 20784, -15036, 20166, -25484, 30578, -17465, 18964, -19446, 18555, -7972,  5648, -2178, -2517,  4230, -7801, 11905, -16433, 10616, -13049, 15394, -17502,  9599, -10130, 10196, -9560,   969,  -434, -1133, 30013, },
	{  2247, -6065, 12907, -23641,  9704, -14590, 20301, -26241,  7851, -8584,  8283, -6378,  1122,  2374, -7572, 14658, -11838, 17234, -23316, 29735, -17992, 20699, -22586, 23195, -11018,  9312, -6258,  1681,  2264, -6190, 10888, -16239, 11026, -14030, 16957, -19597, 10850, -11490, 11556, -10859,  4583, -3083,   694,  3004, -1113,  2428, -5523, 25671, },
	{  3380, -7612, 13934, -22255,  7968, -10306, 11931, -11906,  2254,  -454, -2811,  7914, -7577, 12345, -18226, 25035, -16202, 19874, -23133, 25471, -13144, 12466, -10365,  6529,  -351, -3642,  8729, -14842, 10907, -14684, 18553, -22259, 12744, -13941, 14518, -14262,  6472, -5164,  3083,   -90, -1991,  4685, -8226, 12971, -2462,  3804, -6564, 18096, },
	{  2777, -5708,  9130, -12138,  3296, -2501,   -89,  5344, -3547,  6869, -11453, 17344, -12209, 16167, -20242, 23981, -13391, 13951, -13248, 10833, -3135,  -409,  5347, -11725,  9738, -14196, 19051, -24033, 14393, -16436, 17891, -18479,  8954, -7942,  6065, -3197,  -384,  2956, -6149,  9987, -7250,  9871, -12918, 16532, -2632,  3427, -4838,  9221, },
	{ -2043,  1756,   864, -7513,  5051, -10262, 17979, -28493, 10445, -14337, 18522, -22539, 12863, -13611, 12997, -10446,  2686,  1381, -7187, 14837, -12146, 17662, -23742, 30040, -18042, 20639, -22462, 23126, -11113,  9681, -7086,  3177,  1074, -4464,  8568, -13329,  9324, -12190, 15172, -18158, 10510, -11804, 12875, -13610,  1728, -1635,  1173, 30528, },
	{  1381, -4576, 10851, -21376,  9288, -14678, 21433, -29156,  9259, -10943, 11882, -11490,  4539, -1950, -2389,  8788, -8726, 14205, -20729, 28052, -17879, 21627, -24884, 27184, -14001, 13390, -11482,  8024, -1407, -2137,  6633, -12030,  9103, -12480, 16003, -19487, 11352, -12691, 13604, -13903,  6682, -5843,  4214, -1409,  -423,  1548, -4353, 27657, },
	{  3204, -7513, 14355, -23980,  9025, -12406, 15594, -17730,  4402, -3429,  1071,  3136, -4814,  9370, -15315, 22591, -15480, 19984, -24458, 28426, -15646, 16182, -15442, 13044, -4315,   954,  3653, -9527,  8296, -12332, 16718, -21234, 12799, -14730, 16211, -17015,  8446, -7788,  6387, -4077,   327,  2078, -5399, 10037, -2108,  3520, -6561, 21035, },
	{  3146, -6688, 11318, -16381,  5138, -5429,  4224,  -582, -1643,  4588, -8936, 14854, -11184, 15650, -20606, 25673, -15151, 16887, -17605, 16813, -6996,  4320,  -165, -5616,  6536, -11061, 16264, -21934, 13883, -16679, 19108, -20884, 10846, -10599,  9530, -7475,  2137,   107, -3064,  6801, -5701,  8495, -11894, 16126, -2713,  3747, -5694, 12372, },
	{  1842, -3409,  4418, -3663,  -146,  2632, -7175, 14412, -6220,  9719, -14072, 19103, -12226, 14771, -16779, 17730, -8505,  6972, -3926,  -942,  3932, -8476, 14074, -20592, 13883, -17599, 21172, -24264, 13240, -13689, 13251, -11697,  4407, -2213,  -800,  4669, -4697,  7469, -10614, 14076, -8896, 10844, -12853, 14910, -2131,  2431, -2841,  3803, },
	{   304, -2642,  7951, -17649,  8289, -13901, 21364, -30511, 10194, -12773, 14946, -16145,  7827, -6323,  3119,  2209, -5008, 10261, -16870, 24707, -16736, 21338, -25814, 29717, -16256, 16800, -16172, 14055, -5081,  2129,  1905, -7042,  6618, -10184, 14114, -18260, 11216, -13194, 14922, -16230,  8456, -8352,  7615, -5927,   329,   511, -2759, 29165, },
	{  2783, -6928, 13931, -24389,  9617, -13901, 18549, -22823,  6401, -6343,  5062, -2024, -1661,  5740, -11414, 18757, -13842, 18946, -24415, 29833, -17320, 19071, -19769, 18979, -8132,  5608, -1753, -3542,  5150, -9222, 13885, -18973, 12122, -14695, 17014, -18855,  9982, -10027,  9405, -7931,  2690,  -725, -2166,  6406, -1613,  3011, -6165, 23714, },
	{  3356, -7354, 13013, -19972,  6804, -8223,  8540, -6798,   454,  1931, -5785, 11394, -9468, 14206, -19790, 25939, -16096, 18944, -21084, 22005, -10565,  8932, -5816,   975,  2878, -7216, 12478, -18529, 12566, -15973, 19259, -22148, 12159, -12707, 12526, -11419,  4593, -2813,   270,  3147, -3784,  6592, -10154, 14775, -2640,  3868, -6297, 15538, },
	{  2383, -4725,  7068, -8345,  1722,  -102, -3478,  9799, -4906,  8390, -12973, 18597, -12512, 15897, -19093, 21607, -11407, 10995, -9172,  5546,   117, -4216,  9581, -16177, 11921, -16136, 20504, -24718, 14197, -15541, 16142, -15739,  7035, -5444,  2989,   418, -2417,  5146, -8393, 12148, -8198, 10566, -13197, 16162, -2458,  3033, -3986,  6692, },
	{  -937,  -344,  4314, -12577,  6728, -12253, 20032, -30147, 10579, -13941, 17274, -20055, 10790, -10493,  8643, -4723,  -879,  5601, -11923, 19842, -14599, 19816, -25287, 30610, -17636, 19331, -20047, 19422, -8548,  6369, -3037, -1542,  3701, -7255, 11376, -15963, 10435, -12954, 15418, -17687,  9795, -10460, 10699, -10294,  1102,  -639,  -760, 30143, },
	{  2113, -5842, 12614, -23355,  9674, -14665, 20578, -26847,  8124, -9023,  8934, -7282,  1714,  1640, -6711, 13707, -11350, 16782, -22965, 29566, -18046, 20944, -23076, 23979, -11579, 10055, -7187,  2785,  1638, -5514, 10196, -15577, 10738, -13819, 16861, -19657, 10981, -11745, 11957, -11429,  4964, -3572,  1303,  2258, -1000,  2289, -5351, 26046, },
	{  3367, -7628, 14063, -22640,  8180, -10707, 12606, -12950,  2631,  -966, -2156,  7126, -7134, 11884, -17799, 24717, -16144, 19975, -23456, 26085, -13630, 13159, -11285,  7682, -1037, -2862,  7886, -13983, 10500, -14337, 18311, -22172, 12806, -14134, 14871, -14797,  6840, -5639,  3667,  -779, -1599,  4254, -7772, 12519, -2411,  3772, -6590, 18619, },
	{  2850, -5896,  9537, -12907,  3623, -3010,   647,  4353, -3236,  6506, -11068, 16987, -12083, 16145, -20387, 24371, -13749, 14514, -14053, 11909, -3814,   406,  4416, -10718,  9224, -13712, 18646, -23768, 14363, -16545, 18174, -18971,  9318, -8434,  6689, -3950,    51,  2475, -5640,  9477, -7012,  9674, -12794, 16529, -2657,  3496, -5001,  9761, },
	{ -2279,  2210,   103, -6369,  4660, -9778, 17444, -27993, 10364, -14350, 18698, -22960, 13244, -14212, 13865, -11619,  3436,   471, -6138, 13694, -11562, 17114, -23295, 29770, -18039, 20815, -22866, 23801, -11604, 10339, -7913,  4166,   509, -3848,  7928, -12702,  9041, -11967, 15044, -18169, 10610, -12033, 13278, -14256,  1855, -1845,  1607, 30558, },
	{  1208, -4271, 10407, -20833,  9157, -14606, 21509, -29507,  9457, -11301, 12456, -12336,  5123, -2710, -1450,  7691, -8121, 13583, -20148, 27590, -17755, 21666, -25146, 27733, -14448, 14034, -12340,  9100, -2049, -1407,  5841, -11216,  8710, -12134, 15741, -19354, 11374, -12830, 13887, -14362,  7015, -6300,  4817, -2191,  -296,  1379, -4107, 27954, },
	{  3149, -7448, 14344, -24149,  9163, -12712, 16163, -18673,  4763, -3942,  1760,  2263, -4292,  8784, -14707, 22023, -15261, 19887, -24551, 28785, -15999, 16747, -16253, 14123, -4992,  1763,  2733, -8530,  7786, -11844, 16296, -20929, 12734, -14784, 16416, -17402,  8746, -8208,  6935, -4760,   737,  1603, -4864,  9454, -2031,  3448, -6521, 21520, },
	{  3195, -6828, 11651, -17057,  5443, -5927,  4977, -1647, -1291,  4152, -8432, 14321, -10935, 15466, -20549, 25824, -15376, 17310, -18277, 17778, -7640,  5134, -1142, -4500,  5931, -10442, 15675, -21434, 13712, -16625, 19212, -21188, 11118, -11007, 10088, -8188,  2571,  -398, -2499,  6197, -5393,  8201, -11643, 15959, -2712,  3783, -5818, 12922, },
	{  1939, -3643,  4882, -4469,   170,  2178, -6574, 13684, -6021,  9532, -13941, 19094, -12326, 15025, -17246, 18470, -9040,  7694, -4846,   174,  3289, -7775, 13356, -19913, 13600, -17417, 21143, -24442, 13459, -14066, 13806, -12444,  4880, -2782,  -148,  3952, -4322,  7097, -10273, 13800, -8811, 10840, -12964, 15186, -2196,  2544, -3046,  4287, },
	{    99, -2268,  7370, -16862,  8058, -13678, 21225, -30575, 10302, -13025, 15407, -16883,  8368, -7066,  4083,  1024, -4317,  9499, -16086, 23968, -16435, 21163, -25828, 29992, -16561, 17306, -16908, 15041, -5702,  2872,  1057, -6118,  6140, -9718, 13697, -17937, 11126, -13206, 15069, -16548,  8722, -8750,  8177, -6700,   462,   318, -2441, 29373, },
	{  2684, -6776, 13768, -24315,  9666, -14089, 18972, -23605,  6722, -6828,  5747, -2935, -1088,  5058, -10651, 17964, -13469, 18650, -24265, 29909, -17516, 19472, -20421, 19921, -8761,  6400, -2700, -2462,  4563, -8618, 13303, -18462, 11932, -14603, 17057, -19071, 10195, -10366,  9885, -8568,  3094, -1219, -1577,  5720, -1515,  2901, -6055, 24145, },
	{  3373, -7432, 13245, -20507,  7066, -8680,  9269, -7877,   828,  1442, -5186, 10708, -9106, 13865, -19528, 25835, -16170, 19199, -21580, 22799, -11137,  9698, -6784,  2138,  2213, -6492, 11735, -17818, 12260, -15755, 19173, -22242, 12321, -13006, 12983, -12050,  5000, -3314,   859,  2481, -3422,  6215, -9785, 14447, -2612,  3867, -6372, 16080, },
	{  2471, -4941,  7513, -9151,  2052,  -598, -2789,  8909, -4640,  8102, -12700, 18397, -12490, 16005, -19394, 22171, -11857, 11646, -10051,  6667,  -561, -3435,  8728, -15299, 11503, -15782, 20267, -24655, 14284, -15778, 16560, -16363,  7459, -5984,  3642,  -337, -2000,  4704, -7951, 11736, -8026, 10455, -13181, 16291, -2502,  3124, -4173,  7213, },
	{ -1164,    84,  3621, -11577,  6404, -11882, 19672, -29902, 10586, -14069, 17589, -20636, 11256, -11176,  9578, -5931,  -139,  4739, -10973, 18862, -14134, 19430, -25046, 30589, -17777, 19666, -20616, 20259, -9112,  7082, -3893,  -560,  3163, -6695, 10826, -15464, 10237, -12836, 15416, -17842,  9976, -10774, 11186, -11016,  1235,  -845,  -375, 30256, },
	{  1973, -5603, 12295, -23025,  9626, -14716, 20822, -27413,  8386, -9451,  9575, -8180,  2307,   898, -5833, 12727, -10840, 16299, -22573, 29346, -18069, 21154, -23528, 24726, -12122, 10784, -8108,  3889,  1006, -4826,  9483, -14885, 10431, -13584, 16736, -19685, 11094, -11980, 12340, -11983,  5338, -4057,  1913,  1503,  -884,  2144, -5166, 26409, },
	{  3346, -7631, 14170, -22990,  8381, -11092, 13265, -13982,  3006, -1480, -1493,  6320, -6674, 11399, -17340, 24354, -16058, 20041, -23741, 26657, -14095, 13832, -12189,  8827, -1725, -2074,  7027, -13097, 10073, -13964, 18037, -22047, 12845, -14304, 15199, -15308,  7198, -6107,  4247, -1471, -1202,  3814, -7303, 12043, -2356,  3732, -6605, 19137, },
	{  2920, -6077,  9933, -13662,  3947, -3519,  1388,  3346, -2916,  6129, -10662, 16599, -11935, 16094, -20499, 24721, -14085, 15055, -14839, 12971, -4491,  1224,  3474, -9687,  8693, -13202, 18209, -23461, 14309, -16626, 18428, -19432,  9668, -8914,  7305, -4700,   487,  1988, -5120,  8949, -6761,  9459, -12648, 16499, -2677,  3559, -5159, 10304, },
	{ -2516,  2668,  -669, -5200,  4257, -9272, 16874, -27439, 10264, -14339, 18843, -23345, 13605, -14792, 14714, -12780,  4184,  -444, -5074, 12521, -10955, 16535, -22805, 29447, -18005, 20957, -23232, 24437, -12078, 10981, -8730,  5152,   -59, -3223,  7272, -12051,  8741, -11723, 14891, -18148, 10693, -12242, 13660, -14882,  1980, -2055,  2050, 30572, },
	{  1030, -3954,  9938, -20247,  9008, -14509, 21549, -29811,  9641, -11643, 13014, -13168,  5702, -3470,  -504,  6574, -7498, 12934, -19530, 27077, -17600, 21667, -25367, 28237, -14872, 14658, -13180, 10165, -2689,  -672,  5037, -10379,  8301, -11765, 15452, -19188, 11378, -12947, 14148, -14798,  7339, -6748,  5415, -2974,  -168,  1205, -3849, 28236, },
	{  3086, -7367, 14307, -24278,  9287, -12999, 16709, -19593,  5118, -4453,  2451,  1379, -3759,  8179, -14069, 21414, -15015, 19755, -24602, 29097, -16326, 17286, -17039, 15183, -5664,  2572,  1805, -7515,  7260, -11334, 15844, -20587, 12647, -14813, 16594, -17762,  9033, -8614,  7474, -5438,  1147,  1123, -4317,  8850, -1951,  3369, -6470, 21996, },
	{  3239, -6958, 11969, -17712,  5741, -6420,  5730, -2718,  -934,  3704, -7910, 13759, -10665, 15254, -20458, 25931, -15576, 17707, -18922, 18717, -8275,  5943, -2121, -3371,  5312, -9801, 15058, -20896, 13516, -16542, 19284, -21457, 11371, -11398, 10630, -8890,  3002,  -904, -1929,  5580, -5075,  7892, -11370, 15764, -2705,  3812, -5934, 13471, },
	{  2035, -3875,  5345, -5279,   490,  1715, -5956, 12924, -5810,  9326, -13785, 19053, -12404, 15255, -17686, 19183, -9562,  8406, -5764,  1295,  2638, -7057, 12611, -19197, 13293, -17206, 21077, -24578, 13657, -14419, 14339, -13173,  5347, -3347,   508,  3226, -3937,  6712, -9913, 13500, -8712, 10818, -13055, 15438, -2258,  2653, -3248,  4778, },
	{  -110, -1883,  6768, -16036,  7810, -13428, 21047, -30585, 10393, -13258, 15845, -17597,  8899, -7802,  5045,  -170, -3614,  8717, -15269, 23185, -16105, 20950, -25798, 30218, -16839, 17785, -17619, 16005, -6315,  3612,   204, -5181,  5650, -9234, 13256, -17582, 11018, -13196, 15190, -16839,  8974, -9135,  8728, -7468,   596,   123, -2111, 29565, },
	{  2579, -6608, 13577, -24198,  9700, -14254, 19366, -24353,  7035, -7306,  6427, -3848,  -509,  4363, -9865, 17135, -13071, 18321, -24072, 29934, -17683, 19842, -21041, 20833, -9378,  7185, -3646, -1373,  3967, -7996, 12696, -17918, 11721, -14486, 17071, -19255, 10392, -10687, 10350, -9193,  3494, -1714,  -982,  5019, -1413,  2784, -5932, 24565, },
	{  3384, -7497, 13457, -21013,  7319, -9127,  9989, -8953,  1205,   947, -4574,  9999, -8725, 13498, -19232, 25686, -16217, 19422, -22041, 23558, -11694, 10452, -7746,  3303,  1541, -5755, 10968, -17074, 11932, -15509, 19055, -22299, 12462, -13284, 13420, -12663,  5401, -3811,  1448,  1808, -3052,  5826, -9397, 14093, -2579,  3860, -6436, 16619, },
	{  2556, -5151,  7952, -9952,  2382, -1097, -2088,  7995, -4364,  7797, -12402, 18164, -12446, 16085, -19664, 22701, -12290, 12282, -10918,  7782, -1242, -2644,  7856, -14392, 11064, -15401, 19993, -24549, 14346, -15989, 16951, -16961,  7872, -6516,  4291, -1093, -1578,  4253, -7494, 11302, -7840, 10326, -13143, 16393, -2542,  3211, -4356,  7738, },
	{ -1394,   518,  2912, -10543,  6065, -11486, 19275, -29604, 10574, -14173, 17877, -21186, 11706, -11844, 10501, -7135,   606,  3865, -10000, 17844, -13643, 19010, -24761, 30517, -17889, 19970, -21153, 21065, -9662,  7786, -4746,   427,  2619, -6121, 10255, -14936, 10019, -12696, 15388, -17968, 10140, -11071, 11657, -11724,  1367, -1053,    20, 30351, },
	{  1825, -5351, 11949, -22651,  9561, -14741, 21032, -27936,  8635, -9865, 10205, -9071,  2900,   150, -4939, 11719, -10308, 15786, -22140, 29074, -18062, 21329, -23941, 25434, -12647, 11498, -9019,  4991,   371, -4126,  8752, -14166, 10105, -13324, 16582, -19679, 11188, -12196, 12703, -12518,  5706, -4537,  2524,   741,  -765,  1993, -4969, 26758, },
	{  3318, -7619, 14253, -23304,  8570, -11463, 13907, -14999,  3380, -1995,  -823,  5497, -6201, 10892, -16848, 23947, -15944, 20074, -23987, 27187, -14538, 14485, -13077,  9961, -2413, -1279,  6153, -12185,  9627, -13566, 17731, -21885, 12863, -14451, 15503, -15795,  7545, -6566,  4823, -2163,  -801,  3365, -6818, 11544, -2296,  3685, -6609, 19649, },
	{  2986, -6250, 10317, -14405,  4268, -4027,  2134,  2324, -2589,  5739, -10233, 16180, -11766, 16015, -20576, 25030, -14400, 15574, -15604, 14015, -5162,  2044,  2522, -8635,  8144, -12668, 17738, -23113, 14230, -16679, 18651, -19862, 10002, -9381,  7910, -5444,   925,  1495, -4589,  8403, -6497,  9227, -12479, 16439, -2693,  3616, -5310, 10849, },
	{  1568, -2753,  3129, -1451, -1002,  3842, -8745, 16268, -6708, 10145, -14303, 18956, -11846, 13944, -15351, 15544, -6963,  4929, -1363, -3996,  5661, -10327, 15925, -22275, 14537, -17940, 21063, -23559, 12517, -12532, 11607, -9535,  3066,  -628, -2590,  6601, -5689,  8426, -11457, 14711, -9049, 10758, -12432, 14022, -1936,  2103, -2265,  2502, },
	{   845, -3623,  9445, -19618,  8842, -14384, 21553, -30066,  9809, -11968, 13553, -13983,  6275, -4230,   450,  5439, -6859, 12260, -18875, 26516, -17414, 21632, -25545, 28694, -15273, 15258, -14002, 11217, -3328,    66,  4221, -9521,  7876, -11375, 15135, -18988, 11362, -13043, 14386, -15211,  7651, -7187,  6007, -3758,   -38,  1026, -3578, 28503, },
	{  3016, -7272, 14245, -24366,  9396, -13267, 17231, -20488,  5467, -4960,  3143,   487, -3215,  7557, -13403, 20765, -14741, 19589, -24611, 29360, -16627, 17798, -17800, 16221, -6330,  3380,   869, -6483,  6720, -10803, 15364, -20209, 12538, -14817, 16744, -18093,  9305, -9008,  8002, -6109,  1557,   638, -3760,  8228, -1867,  3284, -6406, 22464, },
	{  3277, -7078, 12270, -18344,  6033, -6908,  6480, -3795,  -572,  3247, -7370, 13170, -10376, 15014, -20330, 25995, -15750, 18075, -19537, 19629, -8899,  6746, -3102, -2232,  4682, -9142, 14412, -20320, 13297, -16431, 19323, -21690, 11607, -11771, 11156, -9579,  3430, -1411, -1352,  4950, -4746,  7568, -11076, 15541, -2695,  3836, -6042, 14020, },
	{  2129, -4104,  5806, -6091,   813,  1243, -5321, 12136, -5586,  9102, -13605, 18978, -12462, 15460, -18099, 19867, -10071,  9109, -6676,  2420,  1979, -6324, 11841, -18445, 12962, -16964, 20976, -24673, 13832, -14750, 14849, -13883,  5806, -3910,  1165,  2491, -3545,  6314, -9535, 13175, -8597, 10777, -13123, 15665, -2315,  2759, -3448,  5276, },
	{  -324, -1488,  6146, -15172,  7546, -13153, 20831, -30543, 10467, -13469, 16259, -18286,  9418, -8529,  6005, -1370, -2902,  7916, -14423, 22358, -15746, 20700, -25725, 30393, -17089, 18236, -18302, 16946, -6920,  4349,  -652, -4231,  5148, -8733, 12790, -17196, 10890, -13163, 15286, -17103,  9212, -9506,  9268, -8229,   730,   -76, -1769, 29741, },
	{  2466, -6426, 13360, -24037,  9716, -14396, 19730, -25066,  7338, -7775,  7102, -4761,    75,  3657, -9058, 16273, -12648, 17959, -23837, 29908, -17821, 20180, -21628, 21713, -9981,  7960, -4591,  -278,  3360, -7359, 12065, -17342, 11489, -14344, 17056, -19407, 10573, -10992, 10799, -9806,  3891, -2208,  -382,  4304, -1308,  2661, -5796, 24973, },
	{  3388, -7550, 13648, -21489,  7562, -9562, 10699, -10023,  1582,   447, -3949,  9267, -8327, 13105, -18900, 25491, -16236, 19614, -22466, 24280, -12232, 11191, -8699,  4467,   864, -5004, 10180, -16298, 11582, -15236, 18904, -22319, 12582, -13540, 13835, -13257,  5794, -4303,  2038,  1129, -2676,  5425, -8991, 13712, -2541,  3846, -6491, 17154, },
	{  2638, -5357,  8383, -10747,  2712, -1600, -1376,  7059, -4079,  7476, -12081, 17898, -12380, 16139, -19901, 23195, -12703, 12899, -11771,  8889, -1923, -1845,  6967, -13456, 10605, -14991, 19685, -24401, 14385, -16174, 17314, -17532,  8273, -7039,  4935, -1851, -1151,  3793, -7022, 10846, -7640, 10178, -13082, 16468, -2578,  3293, -4534,  8269, },
	{ -1626,   959,  2187, -9479,  5712, -11066, 18841, -29252, 10544, -14253, 18135, -21704, 12139, -12496, 11412, -8334,  1353,  2979, -9005, 16792, -13126, 18554, -24433, 30392, -17971, 20240, -21656, 21837, -10198,  8479, -5595,  1416,  2067, -5535,  9664, -14381,  9785, -12533, 15334, -18063, 10288, -11351, 12112, -12418,  1499, -1262,   426, 30430, },
	{  1671, -5084, 11577, -22231,  9478, -14741, 21208, -28415,  8872, -10266, 10821, -9951,  3492,  -602, -4032, 10685, -9756, 15242, -21667, 28751, -18024, 21469, -24316, 26101, -13153, 12195, -9917,  6089,  -268, -3418,  8004, -13420,  9760, -13041, 16399, -19640, 11264, -12393, 13046, -13035,  6065, -5013,  3134,   -29,  -644,  1838, -4759, 27094, },
	{  3283, -7594, 14312, -23581,  8746, -11818, 14532, -15999,  3751, -2512,  -146,  4660, -5713, 10363, -16324, 23497, -15802, 20072, -24192, 27673, -14958, 15117, -13946, 11084, -3100,  -478,  5264, -11248,  9164, -13143, 17394, -21684, 12860, -14573, 15781, -16258,  7880, -7015,  5392, -2854,  -397,  2908, -6319, 11021, -2232,  3632, -6602, 20154, },
	{  3047, -6415, 10690, -15131,  4585, -4534,  2885,  1288, -2255,  5336, -9784, 15729, -11575, 15909, -20618, 25299, -14691, 16069, -16346, 15041, -5828,  2865,  1560, -7564,  7579, -12110, 17235, -22724, 14127, -16704, 18844, -20260, 10321, -9833,  8505, -6182,  1362,   999, -4047,  7840, -6221,  8978, -12288, 16352, -2704,  3668, -5454, 11397, },
	{  1667, -2990,  3592, -2241,  -698,  3416, -8197, 15630, -6544, 10008, -14242, 19037, -12000, 14262, -15886, 16352, -7527,  5670, -2285, -2905,  5049, -9677, 15284, -21704, 14324, -17845, 21134, -23848, 12796, -12967, 12216, -10326,  3553, -1199, -1951,  5917, -5341,  8095, -11171, 14505, -9007, 10805, -12602, 14362, -2009,  2223, -2474,  2963, },
	{   655, -3281,  8928, -18946,  8658, -14234, 21518, -30272,  9962, -12274, 14073, -14779,  6841, -4987,  1408,  4288, -6205, 11561, -18184, 25907, -17197, 21559, -25680, 29105, -15650, 15835, -14803, 12254, -3963,   808,  3395, -8644,  7436, -10964, 14791, -18755, 11327, -13117, 14600, -15600,  7952, -7616,  6593, -4541,    93,   844, -3294, 28755, },
	{  2939, -7161, 14155, -24412,  9489, -13514, 17729, -21355,  5810, -5463,  3836,  -412, -2663,  6917, -12710, 20076, -14441, 19388, -24578, 29574, -16901, 18282, -18534, 17237, -6987,  4186,   -72, -5436,  6166, -10251, 14856, -19795, 12408, -14796, 16867, -18394,  9562, -9388,  8518, -6773,  1967,   150, -3194,  7587, -1779,  3191, -6331, 22923, },
	{  3311, -7187, 12554, -18953,  6317, -7388,  7227, -4875,  -205,  2781, -6814, 12554, -10066, 14747, -20167, 26015, -15898, 18414, -20122, 20512, -9511,  7541, -4081, -1083,  4041, -8463, 13739, -19707, 13055, -16291, 19329, -21888, 11823, -12125, 11666, -10255,  3853, -1917,  -771,  4310, -4408,  7229, -10762, 15289, -2679,  3853, -6142, 14568, },
	{  2222, -4331,  6264, -6904,  1139,   765, -4670, 11318, -5351,  8861, -13399, 18871, -12499, 15640, -18483, 20521, -10566,  9799, -7582,  3546,  1314, -5576, 11047, -17658, 12608, -16692, 20838, -24727, 13984, -15057, 15337, -14571,  6256, -4467,  1822,  1750, -3145,  5904, -9139, 12826, -8466, 10717, -13169, 15867, -2370,  2861, -3645,  5780, },
	{  -541, -1084,  5503, -14270,  7265, -12851, 20577, -30448, 10523, -13659, 16647, -18948,  9925, -9247,  6961, -2576, -2180,  7097, -13547, 21488, -15358, 20414, -25606, 30517, -17312, 18657, -18957, 17862, -7516,  5082, -1510, -3271,  4636, -8215, 12301, -16779, 10743, -13108, 15357, -17339,  9435, -9863,  9795, -8982,   864,  -277, -1416, 29901, },
	{  2345, -6229, 13115, -23831,  9716, -14514, 20064, -25742,  7631, -8234,  7769, -5672,   663,  2939, -8229, 15377, -12201, 17564, -23560, 29830, -17929, 20485, -22181, 22560, -10570,  8725, -5531,   823,  2746, -6707, 11411, -16733, 11237, -14177, 17012, -19526, 10735, -11279, 11232, -10404,  4282, -2701,   222,  3577, -1200,  2532, -5647, 25370, },
	{  3386, -7590, 13817, -21933,  7794, -9986, 11397, -11086,  1960,   -58, -3313,  8513, -7912, 12687, -18534, 25252, -16228, 19773, -22856, 24965, -12753, 11915, -9641,  5629,   182, -4242,  9371, -15491, 11210, -14936, 18719, -22300, 12682, -13774, 14228, -13831,  6179, -4790,  2626,   445, -2293,  5013, -8567, 13305, -2498,  3825, -6536, 17686, },
	{  2717, -5557,  8807, -11533,  3041, -2106,  -655,  6102, -3783,  7140, -11737, 17599, -12292, 16166, -20106, 23652, -13098, 13498, -12608,  9987, -2605, -1039,  6061, -12493, 10125, -14554, 19342, -24210, 14399, -16332, 17650, -18076,  8661, -7551,  5573, -2608,  -721,  3325, -6536, 10371, -7426, 10012, -12998, 16515, -2610,  3370, -4707,  8803, },
	{ -1860,  1405,  1448, -8384,  5345, -10623, 18370, -28846, 10496, -14310, 18364, -22187, 12554, -13130, 12310, -9525,  2103,  2083, -7990, 15705, -12584, 18065, -24061, 30215, -18023, 20478, -22123, 22576, -10719,  9160, -6437,  2407,  1510, -4937,  9055, -13799,  9532, -12349, 15253, -18129, 10420, -11613, 12548, -13095,  1628, -1472,   843, 30492, },
	{  1510, -4804, 11179, -21767,  9378, -14716, 21348, -28850,  9095, -10653, 11423, -10821,  4082, -1359, -3112,  9627, -9184, 14670, -21155, 28378, -17955, 21572, -24651, 26727, -13638, 12875, -10803,  7180,  -908, -2700,  7239, -12648,  9398, -12735, 16188, -19567, 11321, -12569, 13368, -13531,  6415, -5483,  3743,  -804,  -520,  1677, -4536, 27416, },
	{  3241, -7554, 14346, -23820,  8908, -12155, 15137, -16980,  4119, -3028,   537,  3808, -5212,  9813, -15768, 23004, -15632, 20036, -24358, 28114, -15354, 15725, -14796, 12192, -3785,   326,  4362, -10288,  8682, -12696, 17025, -21445, 12834, -14671, 16033, -16694,  8204, -7454,  5955, -3543,    10,  2444, -5806, 10476, -2164,  3572, -6583, 20652, },
	{  3105, -6572, 11048, -15841,  4898, -5039,  3637,   240, -1913,  4920, -9315, 15248, -11363, 15774, -20625, 25526, -14959, 16539, -17064, 16047, -6488,  3684,   592, -6474,  6998, -11529, 16701, -22295, 13999, -16701, 19005, -20624, 10623, -10270,  9087, -6913,  1799,   498, -3497,  7261, -5933,  8713, -12075, 16236, -2711,  3715, -5592, 11945, },
	{  1765, -3226,  4056, -3038,  -389,  2979, -7630, 14957, -6367,  9853, -14156, 19087, -12135, 14557, -16398, 17137, -8081,  6405, -3208, -1804,  4424, -9009, 14615, -21094, 14086, -17718, 21169, -24098, 13054, -13382, 12806, -11103,  4035, -1770, -1306,  5220, -4983,  7748, -10865, 14274, -8951, 10834, -12751, 14679, -2079,  2341, -2681,  3433, },
	{   460, -2926,  8387, -18232,  8457, -14057, 21446, -30426, 10099, -12562, 14572, -15556,  7399, -5740,  2370,  3123, -5537, 10838, -17458, 25250, -16949, 21449, -25772, 29468, -16001, 16388, -15582, 13275, -4594,  1551,  2560, -7749,  6981, -10533, 14420, -18490, 11272, -13169, 14791, -15964,  8240, -8035,  7171, -5322,   225,   658, -2998, 28992, },
	{  2854, -7036, 14040, -24415,  9567, -13740, 18201, -22193,  6145, -5960,  4526, -1317, -2102,  6261, -11990, 19349, -14114, 19152, -24503, 29740, -17148, 18737, -19240, 18227, -7635,  4988, -1016, -4375,  5599, -9679, 14320, -19346, 12256, -14749, 16961, -18665,  9804, -9754,  9022, -7428,  2375,  -342, -2619,  6929, -1687,  3092, -6243, 23372, },
	{  3338, -7286, 12819, -19537,  6594, -7861,  7968, -5957,   164,  2306, -6241, 11911, -9737, 14453, -19969, 25990, -16020, 18724, -20676, 21364, -10110,  8327, -5059,    72,  3390, -7768, 13039, -19058, 12789, -16123, 19302, -22048, 12020, -12460, 12157, -10916,  4271, -2422,  -187,  3659, -4060,  6876, -10428, 15011, -2659,  3864, -6233, 15114, },
	{  2314, -4554,  6718, -7715,  1466,   279, -4005, 10474, -5105,  8603, -13169, 18730, -12515, 15795, -18838, 21144, -11045, 10477, -8480,  4672,   642, -4815, 10231, -16838, 12230, -16390, 20664, -24739, 14113, -15339, 15800, -15237,  6698, -5019,  2479,  1002, -2738,  5481, -8726, 12454, -8321, 10639, -13193, 16043, -2421,  2960, -3838,  6291, },
	{  -763,  -671,  4841, -13331,  6969, -12525, 20285, -30299, 10562, -13826, 17010, -19582, 10417, -9953,  7910, -3783, -1451,  6261, -12643, 20578, -14941, 20092, -25444, 30589, -17505, 19048, -19582, 18750, -8101,  5808, -2369, -2301,  4113, -7681, 11789, -16331, 10577, -13030, 15402, -17546,  9644, -10205, 10309, -9724,   998,  -480, -1051, 30043, },
	{  2218, -6017, 12844, -23581,  9699, -14609, 20366, -26379,  7913, -8682,  8428, -6580,  1253,  2212, -7382, 14449, -11731, 17137, -23242, 29702, -18006, 20757, -22698, 23372, -11144,  9478, -6465,  1926,  2125, -6041, 10736, -16094, 10964, -13985, 16938, -19613, 10880, -11548, 11647, -10987,  4668, -3192,   829,  2839, -1088,  2397, -5486, 25755, },
	{  3378, -7616, 13965, -22344,  8016, -10397, 12082, -12139,  2337,  -567, -2666,  7740, -7480, 12244, -18134, 24968, -16191, 19899, -23208, 25611, -13254, 12622, -10571,  6786,  -503, -3469,  8543, -14654, 10819, -14609, 18503, -22243, 12760, -13986, 14599, -14383,  6555, -5270,  3213,  -243, -1905,  4590, -8126, 12873, -2451,  3798, -6570, 18213, },
	{  2794, -5750,  9221, -12310,  3369, -2614,    74,  5125, -3479,  6789, -11370, 17267, -12183, 16165, -20277, 24071, -13472, 14078, -13428, 11073, -3286,  -228,  5141, -11504,  9626, -14090, 18964, -23978, 14389, -16462, 17956, -18591,  9036, -8053,  6204, -3364,  -287,  2850, -6037,  9875, -7198,  9829, -12892, 16534, -2638,  3443, -4875,  9341, },
	{ -2095,  1856,   696, -7261,  4965, -10156, 17863, -28387, 10429, -14342, 18564, -22636, 12950, -13746, 13191, -10708,  2853,  1179, -6955, 14585, -12018, 17543, -23646, 29985, -18044, 20681, -22555, 23279, -11224,  9829, -7271,  3397,   948, -4328,  8428, -13192,  9262, -12142, 15146, -18163, 10534, -11856, 12966, -13755,  1757, -1682,  1269, 30536, },
	{  1343, -4509, 10755, -21259,  9261, -14664, 21453, -29238,  9304, -11024, 12011, -11679,  4669, -2118, -2181,  8546, -8593, 14069, -20604, 27954, -17854, 21639, -24946, 27310, -14102, 13535, -11674,  8264, -1550, -1975,  6458, -11851,  9018, -12405, 15948, -19460, 11358, -12724, 13668, -14007,  6757, -5945,  4348, -1583,  -395,  1511, -4300, 27724, },
	{  3192, -7500, 14355, -24021,  9057, -12476, 15723, -17941,  4483, -3543,  1224,  2943, -4699,  9242, -15183, 22469, -15434, 19966, -24482, 28510, -15727, 16310, -15624, 13285, -4466,  1134,  3450, -9307,  8184, -12226, 16627, -21169, 12786, -14745, 16259, -17103,  8514, -7883,  6510, -4229,   418,  1973, -5281,  9909, -2091,  3505, -6553, 21143, },
	{  3157, -6720, 11393, -16533,  5206, -5540,  4391,  -818, -1565,  4492, -8826, 14738, -11130, 15612, -20596, 25710, -15203, 16983, -17757, 17030, -7140,  4501,  -382, -5369,  6403, -10926, 16136, -21826, 13847, -16669, 19134, -20955, 10908, -10691,  9655, -7634,  2234,    -5, -2939,  6668, -5634,  8431, -11840, 16091, -2713,  3755, -5722, 12494, },
	{  1863, -3461,  4521, -3842,   -76,  2532, -7043, 14253, -6177,  9679, -14045, 19104, -12250, 14830, -16885, 17897, -8625,  7133, -4130,  -694,  3790, -8321, 13917, -20444, 13822, -17561, 21168, -24307, 13290, -13775, 13376, -11864,  4513, -2340,  -656,  4511, -4614,  7388, -10540, 14017, -8878, 10845, -12879, 14973, -2146,  2456, -2887,  3910, },
	{   259, -2560,  7824, -17477,  8239, -13854, 21336, -30530, 10220, -12830, 15051, -16311,  7948, -6488,  3333,  1946, -4855, 10093, -16699, 24547, -16672, 21303, -25821, 29782, -16326, 16915, -16337, 14276, -5220,  2294,  1717, -6838,  6513, -10082, 14023, -18191, 11197, -13199, 14957, -16303,  8516, -8442,  7741, -6099,   358,   468, -2689, 29212, },
	{  2761, -6896, 13897, -24376,  9629, -13945, 18645, -23000,  6473, -6451,  5214, -2226, -1534,  5590, -11246, 18584, -13761, 18883, -24386, 29854, -17366, 19163, -19916, 19191, -8273,  5785, -1963, -3303,  5021, -9089, 13758, -18862, 12082, -14677, 17026, -18905, 10031, -10104,  9513, -8074,  2780,  -835, -2035,  6255, -1592,  2987, -6142, 23811, },
	{  3360, -7372, 13066, -20093,  6863, -8325,  8703, -7038,   537,  1823, -5653, 11244, -9389, 14133, -19735, 25920, -16115, 19003, -21197, 22184, -10694,  9103, -6032,  1233,  2731, -7056, 12315, -18374, 12500, -15927, 19243, -22172, 12197, -12775, 12629, -11561,  4684, -2925,   401,  2999, -3704,  6509, -10073, 14704, -2634,  3869, -6315, 15658, },
	{  2403, -4773,  7167, -8524,  1795,  -212, -3326,  9603, -4848,  8327, -12914, 18555, -12509, 15923, -19163, 21735, -11509, 11141, -9368,  5795,   -33, -4043,  9394, -15985, 11830, -16060, 20455, -24708, 14218, -15596, 16237, -15880,  7130, -5565,  3134,   250, -2325,  5048, -8296, 12058, -8161, 10543, -13195, 16193, -2468,  3054, -4028,  6807, },
	{  -987,  -249,  4162, -12358,  6657, -12173, 19955, -30097, 10582, -13972, 17347, -20187, 10895, -10646,  8852, -4992,  -715,  5410, -11714, 19628, -14498, 19733, -25237, 30610, -17670, 19408, -20176, 19610, -8674,  6528, -3227, -1324,  3582, -7132, 11255, -15855, 10393, -12929, 15420, -17724,  9837, -10531, 10808, -10455,  1132,  -685,  -675, 30169, },
	{  2083, -5790, 12546, -23286,  9665, -14679, 20635, -26977,  8183, -9119,  9078, -7482,  1846,  1476, -6517, 13492, -11238, 16678, -22882, 29521, -18054, 20994, -23179, 24148, -11701, 10218, -7393,  3031,  1498, -5362, 10039, -15425, 10672, -13769, 16836, -19667, 11007, -11799, 12044, -11554,  5048, -3680,  1438,  2091,  -974,  2257, -5311, 26128, },
	{  3363, -7630, 14089, -22721,  8226, -10794, 12753, -13181,  2714, -1080, -2010,  6948, -7033, 11778, -17700, 24640, -16127, 19992, -23523, 26216, -13735, 13310, -11487,  7937, -1190, -2688,  7697, -13789, 10407, -14256, 18253, -22148, 12816, -14174, 14946, -14912,  6921, -5744,  3796,  -933, -1511,  4157, -7669, 12416, -2400,  3763, -6594, 18735, },
	{  2866, -5937,  9626, -13076,  3695, -3123,   811,  4131, -3166,  6424, -10980, 16904, -12052, 16136, -20415, 24452, -13826, 14636, -14230, 12146, -3965,   588,  4208, -10490,  9108, -13601, 18552, -23703, 14354, -16565, 18233, -19076,  9397, -8542,  6827, -4117,   148,  2367, -5525,  9361, -6957,  9628, -12763, 16525, -2662,  3510, -5037,  9881, },
	{ -2332,  2312,   -67, -6111,  4572, -9667, 17320, -27874, 10343, -14350, 18733, -23049, 13326, -14343, 14055, -11879,  3602,   268, -5903, 13436, -11429, 16988, -23190, 29703, -18034, 20849, -22950, 23946, -11711, 10483, -8095,  4386,   383, -3710,  7784, -12560,  8976, -11915, 15012, -18167, 10630, -12081, 13364, -14397,  1883, -1892,  1705, 30563, },
	{  1169, -4202, 10305, -20707,  9125, -14587, 21521, -29579,  9499, -11379, 12582, -12523,  5252, -2879, -1241,  7444, -7984, 13441, -20014, 27480, -17723, 21669, -25199, 27849, -14544, 14175, -12528,  9338, -2191, -1244,  5664, -11032,  8621, -12054, 15679, -19320, 11377, -12858, 13947, -14461,  7088, -6400,  4950, -2365,  -268,  1340, -4051, 28018, },
	{  3135, -7431, 14338, -24181,  9192, -12777, 16286, -18880,  4842, -4056,  1913,  2067, -4174,  8652, -14567, 21891, -15209, 19861, -24566, 28858, -16074, 16869, -16430, 14360, -5142,  1943,  2528, -8306,  7670, -11733, 16198, -20856, 12716, -14793, 16458, -17485,  8811, -8299,  7056, -4911,   828,  1497, -4743,  9321, -2014,  3431, -6511, 21626, },
	{  3205, -6858, 11723, -17204,  5509, -6037,  5145, -1884, -1212,  4053, -8318, 14199, -10877, 15421, -20532, 25851, -15422, 17401, -18423, 17989, -7782,  5314, -1359, -4250,  5794, -10301, 15541, -21318, 13670, -16609, 19231, -21251, 11176, -11095, 10210, -8345,  2667,  -510, -2373,  6061, -5323,  8134, -11584, 15918, -2711,  3790, -5844, 13044, },
	{  1960, -3695,  4985, -4649,   241,  2076, -6438, 13518, -5975,  9487, -13908, 19088, -12345, 15078, -17346, 18631, -9157,  7853, -5051,   423,  3145, -7617, 13192, -19757, 13534, -17373, 21131, -24475, 13505, -14146, 13926, -12608,  4985, -2908,    -2,  3792, -4237,  7013, -10194, 13736, -8791, 10837, -12986, 15244, -2210,  2568, -3091,  4395, },
	{    53, -2183,  7238, -16682,  8004, -13625, 21189, -30581, 10324, -13079, 15506, -17044,  8487, -7230,  4297,   759, -4162,  9327, -15907, 23798, -16365, 21118, -25825, 30047, -16625, 17415, -17068, 15257, -5839,  3036,   868, -5911,  6032, -9612, 13601, -17861, 11104, -13206, 15098, -16615,  8779, -8837,  8300, -6872,   492,   275, -2369, 29417, },
	{  2662, -6740, 13728, -24293,  9675, -14128, 19062, -23775,  6793, -6935,  5899, -3138,  -959,  4905, -10478, 17783, -13382, 18580, -24226, 29919, -17556, 19557, -20561, 20126, -8899,  6575, -2910, -2221,  4432, -8481, 13170, -18344, 11887, -14580, 17062, -19114, 10241, -10438,  9990, -8708,  3183, -1329, -1445,  5565, -1492,  2875, -6029, 24239, },
	{  3376, -7447, 13294, -20622,  7123, -8780,  9430, -8117,   912,  1333, -5052, 10552, -9023, 13786, -19465, 25806, -16183, 19251, -21685, 22970, -11262,  9867, -6999,  2397,  2064, -6330, 11566, -17656, 12189, -15703, 19150, -22258, 12354, -13069, 13082, -12188,  5090, -3425,   990,  2332, -3341,  6130, -9700, 14371, -2605,  3866, -6387, 16200, },
	{  2490, -4988,  7611, -9330,  2125,  -708, -2634,  8708, -4580,  8035, -12636, 18348, -12482, 16025, -19457, 22292, -11955, 11789, -10245,  6915,  -712, -3260,  8536, -15100, 11407, -15700, 20209, -24635, 14300, -15827, 16649, -16498,  7552, -6103,  3786,  -505, -1907,  4605, -7851, 11641, -7986, 10428, -13174, 16316, -2511,  3144, -4214,  7329, },
	{ -1215,   180,  3465, -11350,  6330, -11796, 19587, -29841, 10585, -14094, 17656, -20761, 11358, -11326,  9784, -6199,    26,  4546, -10759, 18639, -14027, 19340, -24986, 30578, -17805, 19737, -20738, 20441, -9235,  7239, -4083,  -341,  3043, -6569, 10700, -15349, 10190, -12807, 15413, -17873, 10014, -10841, 11292, -11174,  1265,  -891,  -288, 30278, },
	{  1941, -5548, 12220, -22946,  9613, -14724, 20872, -27533,  8442, -9544,  9716, -8379,  2439,   733, -5635, 12505, -10723, 16188, -22480, 29290, -18070, 21196, -23623, 24886, -12240, 10944, -8311,  4134,   866, -4671,  9323, -14728, 10360, -13528, 16704, -19687, 11116, -12030, 12422, -12103,  5421, -4164,  2049,  1335,  -857,  2111, -5124, 26488, },
	{  3340, -7629, 14191, -23063,  8424, -11176, 13409, -14209,  3090, -1594, -1345,  6139, -6570, 11289, -17233, 24267, -16035, 20051, -23799, 26779, -14195, 13979, -12388,  9080, -1878, -1898,  6834, -12896,  9976, -13878, 17972, -22015, 12851, -14339, 15269, -15418,  7276, -6209,  4376, -1625, -1113,  3715, -7196, 11934, -2343,  3722, -6607, 19251, },
	{  2935, -6116, 10019, -13829,  4018, -3632,  1553,  3120, -2844,  6044, -10568, 16509, -11899, 16079, -20519, 24793, -14157, 15173, -15011, 13204, -4640,  1406,  3263, -9455,  8572, -13086, 18107, -23387, 14294, -16640, 18480, -19530,  9743, -9019,  7440, -4866,   585,  1879, -5003,  8829, -6703,  9409, -12612, 16488, -2681,  3572, -5193, 10425, },
};

int nextstate_640_147[640] = {
	0x00116400, 0x00216300, 0x00316200, 0x00416100, 0x00516001, 0x00615f00, 0x00715e00, 0x00815d00, 
	0x00915c01, 0x00a15b00, 0x00b15a00, 0x00c15900, 0x00d15800, 0x00e15701, 0x00f15600, 0x01015500, 
	0x01115400, 0x01215301, 0x01315200, 0x01415100, 0x01515000, 0x01614f01, 0x01714e00, 0x01814d00, 
	0x01914c00, 0x01a14b00, 0x01b14a01, 0x01c14900, 0x01d14800, 0x01e14700, 0x01f14601, 0x02014500, 
	0x02114400, 0x02214300, 0x02314201, 0x02414100, 0x02514000, 0x02613f00, 0x02713e00, 0x02813d01, 
	0x02913c00, 0x02a13b00, 0x02b13a00, 0x02c13901, 0x02d13800, 0x02e13700, 0x02f13600, 0x03013501, 
	0x03113400, 0x03213300, 0x03313200, 0x03413100, 0x03513001, 0x03612f00, 0x03712e00, 0x03812d00, 
	0x03912c01, 0x03a12b00, 0x03b12a00, 0x03c12900, 0x03d12801, 0x03e12700, 0x03f12600, 0x04012500, 
	0x04112400, 0x04212301, 0x04312200, 0x04412100, 0x04512000, 0x04611f01, 0x04711e00, 0x04811d00, 
	0x04911c00, 0x04a11b00, 0x04b11a01, 0x04c11900, 0x04d11800, 0x04e11700, 0x04f11601, 0x05011500, 
	0x05111400, 0x05211300, 0x05311201, 0x05411100, 0x05511000, 0x05610f00, 0x05710e00, 0x05810d01, 
	0x05910c00, 0x05a10b00, 0x05b10a00, 0x05c10901, 0x05d10800, 0x05e10700, 0x05f10600, 0x06010501, 
	0x06110400, 0x06210300, 0x06310200, 0x06410100, 0x06510001, 0x0660ff00, 0x0670fe00, 0x0680fd00, 
	0x0690fc01, 0x06a0fb00, 0x06b0fa00, 0x06c0f900, 0x06d0f801, 0x06e0f700, 0x06f0f600, 0x0700f500, 
	0x0710f400, 0x0720f301, 0x0730f200, 0x0740f100, 0x0750f000, 0x0760ef01, 0x0770ee00, 0x0780ed00, 
	0x0790ec00, 0x07a0eb01, 0x07b0ea00, 0x07c0e900, 0x07d0e800, 0x07e0e700, 0x07f0e601, 0x0800e500, 
	0x0810e400, 0x0820e300, 0x0830e201, 0x0840e100, 0x0850e000, 0x0860df00, 0x0870de01, 0x0880dd00, 
	0x0890dc00, 0x08a0db00, 0x08b0da00, 0x08c0d901, 0x08d0d800, 0x08e0d700, 0x08f0d600, 0x0900d501, 
	0x0910d400, 0x0920d300, 0x0930d200, 0x0940d100, 0x0950d001, 0x0960cf00, 0x0970ce00, 0x0980cd00, 
	0x0990cc01, 0x09a0cb00, 0x09b0ca00, 0x09c0c900, 0x09d0c801, 0x09e0c700, 0x09f0c600, 0x0a00c500, 
	0x0a10c400, 0x0a20c301, 0x0a30c200, 0x0a40c100, 0x0a50c000, 0x0a60bf01, 0x0a70be00, 0x0a80bd00, 
	0x0a90bc00, 0x0aa0bb01, 0x0ab0ba00, 0x0ac0b900, 0x0ad0b800, 0x0ae0b700, 0x0af0b601, 0x0b00b500, 
	0x0b10b400, 0x0b20b300, 0x0b30b201, 0x0b40b100, 0x0b50b000, 0x0b60af00, 0x0b70ae01, 0x0b80ad00, 
	0x0b90ac00, 0x0ba0ab00, 0x0bb0aa00, 0x0bc0a901, 0x0bd0a800, 0x0be0a700, 0x0bf0a600, 0x0c00a501, 
	0x0c10a400, 0x0c20a300, 0x0c30a200, 0x0c40a101, 0x0c50a000, 0x0c609f00, 0x0c709e00, 0x0c809d00, 
	0x0c909c01, 0x0ca09b00, 0x0cb09a00, 0x0cc09900, 0x0cd09801, 0x0ce09700, 0x0cf09600, 0x0d009500, 
	0x0d109401, 0x0d209300, 0x0d309200, 0x0d409100, 0x0d509000, 0x0d608f01, 0x0d708e00, 0x0d808d00, 
	0x0d908c00, 0x0da08b01, 0x0db08a00, 0x0dc08900, 0x0dd08800, 0x0de08700, 0x0df08601, 0x0e008500, 
	0x0e108400, 0x0e208300, 0x0e308201, 0x0e408100, 0x0e508000, 0x0e607f00, 0x0e707e01, 0x0e807d00, 
	0x0e907c00, 0x0ea07b00, 0x0eb07a00, 0x0ec07901, 0x0ed07800, 0x0ee07700, 0x0ef07600, 0x0f007501, 
	0x0f107400, 0x0f207300, 0x0f307200, 0x0f407101, 0x0f507000, 0x0f606f00, 0x0f706e00, 0x0f806d00, 
	0x0f906c01, 0x0fa06b00, 0x0fb06a00, 0x0fc06900, 0x0fd06801, 0x0fe06700, 0x0ff06600, 0x10006500, 
	0x10106401, 0x10206300, 0x10306200, 0x10406100, 0x10506000, 0x10605f01, 0x10705e00, 0x10805d00, 
	0x10905c00, 0x10a05b01, 0x10b05a00, 0x10c05900, 0x10d05800, 0x10e05701, 0x10f05600, 0x11005500, 
	0x11105400, 0x11205300, 0x11305201, 0x11405100, 0x11505000, 0x11604f00, 0x11704e01, 0x11804d00, 
	0x11904c00, 0x11a04b00, 0x11b04a01, 0x11c04900, 0x11d04800, 0x11e04700, 0x11f04600, 0x12004501, 
	0x12104400, 0x12204300, 0x12304200, 0x12404101, 0x12504000, 0x12603f00, 0x12703e00, 0x12803d00, 
	0x12903c01, 0x12a03b00, 0x12b03a00, 0x12c03900, 0x12d03801, 0x12e03700, 0x12f03600, 0x13003500, 
	0x13103401, 0x13203300, 0x13303200, 0x13403100, 0x13503000, 0x13602f01, 0x13702e00, 0x13802d00, 
	0x13902c00, 0x13a02b01, 0x13b02a00, 0x13c02900, 0x13d02800, 0x13e02701, 0x13f02600, 0x14002500, 
	0x14102400, 0x14202300, 0x14302201, 0x14402100, 0x14502000, 0x14601f00, 0x14701e01, 0x14801d00, 
	0x14901c00, 0x14a01b00, 0x14b01a01, 0x14c01900, 0x14d01800, 0x14e01700, 0x14f01600, 0x15001501, 
	0x15101400, 0x15201300, 0x15301200, 0x15401101, 0x15501000, 0x15600f00, 0x15700e00, 0x15800d01, 
	0x15900c00, 0x15a00b00, 0x15b00a00, 0x15c00900, 0x15d00801, 0x15e00700, 0x15f00600, 0x16000500, 
	0x16100401, 0x16200300, 0x16300200, 0x16400100, 0x16500000, 0x16627f01, 0x16727e00, 0x16827d00, 
	0x16927c00, 0x16a27b01, 0x16b27a00, 0x16c27900, 0x16d27800, 0x16e27701, 0x16f27600, 0x17027500, 
	0x17127400, 0x17227300, 0x17327201, 0x17427100, 0x17527000, 0x17626f00, 0x17726e01, 0x17826d00, 
	0x17926c00, 0x17a26b00, 0x17b26a01, 0x17c26900, 0x17d26800, 0x17e26700, 0x17f26600, 0x18026501, 
	0x18126400, 0x18226300, 0x18326200, 0x18426101, 0x18526000, 0x18625f00, 0x18725e00, 0x18825d01, 
	0x18925c00, 0x18a25b00, 0x18b25a00, 0x18c25900, 0x18d25801, 0x18e25700, 0x18f25600, 0x19025500, 
	0x19125401, 0x19225300, 0x19325200, 0x19425100, 0x19525001, 0x19624f00, 0x19724e00, 0x19824d00, 
	0x19924c00, 0x19a24b01, 0x19b24a00, 0x19c24900, 0x19d24800, 0x19e24701, 0x19f24600, 0x1a024500, 
	0x1a124400, 0x1a224301, 0x1a324200, 0x1a424100, 0x1a524000, 0x1a623f00, 0x1a723e01, 0x1a823d00, 
	0x1a923c00, 0x1aa23b00, 0x1ab23a01, 0x1ac23900, 0x1ad23800, 0x1ae23700, 0x1af23600, 0x1b023501, 
	0x1b123400, 0x1b223300, 0x1b323200, 0x1b423101, 0x1b523000, 0x1b622f00, 0x1b722e00, 0x1b822d01, 
	0x1b922c00, 0x1ba22b00, 0x1bb22a00, 0x1bc22900, 0x1bd22801, 0x1be22700, 0x1bf22600, 0x1c022500, 
	0x1c122401, 0x1c222300, 0x1c322200, 0x1c422100, 0x1c522001, 0x1c621f00, 0x1c721e00, 0x1c821d00, 
	0x1c921c00, 0x1ca21b01, 0x1cb21a00, 0x1cc21900, 0x1cd21800, 0x1ce21701, 0x1cf21600, 0x1d021500, 
	0x1d121400, 0x1d221301, 0x1d321200, 0x1d421100, 0x1d521000, 0x1d620f00, 0x1d720e01, 0x1d820d00, 
	0x1d920c00, 0x1da20b00, 0x1db20a01, 0x1dc20900, 0x1dd20800, 0x1de20700, 0x1df20601, 0x1e020500, 
	0x1e120400, 0x1e220300, 0x1e320200, 0x1e420101, 0x1e520000, 0x1e61ff00, 0x1e71fe00, 0x1e81fd01, 
	0x1e91fc00, 0x1ea1fb00, 0x1eb1fa00, 0x1ec1f901, 0x1ed1f800, 0x1ee1f700, 0x1ef1f600, 0x1f01f500, 
	0x1f11f401, 0x1f21f300, 0x1f31f200, 0x1f41f100, 0x1f51f001, 0x1f61ef00, 0x1f71ee00, 0x1f81ed00, 
	0x1f91ec00, 0x1fa1eb01, 0x1fb1ea00, 0x1fc1e900, 0x1fd1e800, 0x1fe1e701, 0x1ff1e600, 0x2001e500, 
	0x2011e400, 0x2021e301, 0x2031e200, 0x2041e100, 0x2051e000, 0x2061df00, 0x2071de01, 0x2081dd00, 
	0x2091dc00, 0x20a1db00, 0x20b1da01, 0x20c1d900, 0x20d1d800, 0x20e1d700, 0x20f1d601, 0x2101d500, 
	0x2111d400, 0x2121d300, 0x2131d200, 0x2141d101, 0x2151d000, 0x2161cf00, 0x2171ce00, 0x2181cd01, 
	0x2191cc00, 0x21a1cb00, 0x21b1ca00, 0x21c1c901, 0x21d1c800, 0x21e1c700, 0x21f1c600, 0x2201c500, 
	0x2211c401, 0x2221c300, 0x2231c200, 0x2241c100, 0x2251c001, 0x2261bf00, 0x2271be00, 0x2281bd00, 
	0x2291bc01, 0x22a1bb00, 0x22b1ba00, 0x22c1b900, 0x22d1b800, 0x22e1b701, 0x22f1b600, 0x2301b500, 
	0x2311b400, 0x2321b301, 0x2331b200, 0x2341b100, 0x2351b000, 0x2361af01, 0x2371ae00, 0x2381ad00, 
	0x2391ac00, 0x23a1ab00, 0x23b1aa01, 0x23c1a900, 0x23d1a800, 0x23e1a700, 0x23f1a601, 0x2401a500, 
	0x2411a400, 0x2421a300, 0x2431a200, 0x2441a101, 0x2451a000, 0x24619f00, 0x24719e00, 0x24819d01, 
	0x24919c00, 0x24a19b00, 0x24b19a00, 0x24c19901, 0x24d19800, 0x24e19700, 0x24f19600, 0x25019500, 
	0x25119401, 0x25219300, 0x25319200, 0x25419100, 0x25519001, 0x25618f00, 0x25718e00, 0x25818d00, 
	0x25918c01, 0x25a18b00, 0x25b18a00, 0x25c18900, 0x25d18800, 0x25e18701, 0x25f18600, 0x26018500, 
	0x26118400, 0x26218301, 0x26318200, 0x26418100, 0x26518000, 0x26617f01, 0x26717e00, 0x26817d00, 
	0x26917c00, 0x26a17b00, 0x26b17a01, 0x26c17900, 0x26d17800, 0x26e17700, 0x26f17601, 0x27017500, 
	0x27117400, 0x27217300, 0x27317201, 0x27417100, 0x27517000, 0x27616f00, 0x27716e00, 0x27816d01, 
	0x27916c00, 0x27a16b00, 0x27b16a00, 0x27c16901, 0x27d16800, 0x27e16700, 0x27f16600, 0x00016501, 
};
#endif // HELIX_FEATURE_MMXFILTER_640_147

#ifdef HELIX_FEATURE_MMXFILTER_3_1
/*
 * inrate=16000 outrate=48000 up=3 dn=1
 */

ALIGN
filtwing filter_3_1[3] = {
	{    91, -2069,  6833, -15806,  7615, -13009, 20293, -29359,  9929, -12593, 14937, -16406,  8148, -6889,  3978,  1026, -4252,  9357, -15858, 23651, -16233, 20921, -25556, 29700, -16411, 17161, -16774, 14927, -5658,  2843,  1068, -6111,  6128, -9698, 13670, -17904, 11108, -13186, 15048, -16526,  8710, -8738,  8163, -6684,   459,   322, -2447, 29369, },
	{  2803, -6808, 13216, -22265,  8417, -11586, 14541, -16437,  4024, -3008,   631,  3561, -4995,  9488, -15331, 22458, -15313, 19688, -24003, 27782, -15217, 15635, -14773, 12253, -3863,   457,  4180, -10059,  8549, -12552, 16881, -21313, 12781, -14639, 16029, -16725,  8240, -7514,  6040, -3654,    78,  2365, -5717, 10380, -2152,  3561, -6579, 20735, },
	{  2202, -4707,  7510, -9677,  2415, -1312, -1601,  7143, -4040,  7349, -11831, 17490, -12079, 15725, -19359, 22514, -12292, 12418, -11227,  8295, -1611, -2160,  7265, -13716, 10702, -15041, 19670, -24301, 14283, -16010, 17079, -17218,  8073, -6794,  4648, -1525, -1330,  3984, -7214, 11030, -7720, 10236, -13104, 16434, -2563,  3258, -4459,  8042, },
};

int nextstate_3_1[3] = {
	0x00100100, 0x00200000, 0x00000201, 
};

/*
 * inrate=22050 outrate=48000 up=320 dn=147
 */

ALIGN
filtwing filter_320_147[320] = {
	{ -2554,  2744,  -798, -5001,  4188, -9184, 16772, -27337, 10244, -14333, 18861, -23403, 13661, -14885, 14853, -12971,  4308,  -597, -4895, 12323, -10851, 16434, -22719, 29387, -17995, 20976, -23288, 24539, -12154, 11086, -8865,  5316,  -154, -3118,  7161, -11941,  8690, -11680, 14862, -18142, 10705, -12275, 13722, -14985,  2001, -2090,  2125, 30572, },
	{  3073, -7349, 14293, -24288,  9303, -13042, 16794, -19740,  5175, -4537,  2566,  1231, -3668,  8076, -13958, 21307, -14970, 19728, -24604, 29142, -16377, 17372, -17167, 15357, -5776,  2707,  1649, -7344,  7171, -11247, 15766, -20527, 12630, -14816, 16621, -17819,  9079, -8681,  7562, -5550,  1215,  1042, -4225,  8748, -1938,  3355, -6460, 22075, },
	{  2049, -3911,  5419, -5413,   544,  1636, -5850, 12792, -5772,  9288, -13755, 19040, -12414, 15289, -17755, 19297, -9647,  8524, -5916,  1482,  2529, -6935, 12484, -19073, 13239, -17167, 21062, -24596, 13687, -14476, 14425, -13293,  5424, -3441,   617,  3104, -3872,  6647, -9851, 13447, -8693, 10812, -13067, 15478, -2267,  2671, -3282,  4860, },
	{  2559, -6576, 13538, -24167,  9701, -14276, 19424, -24470,  7085, -7384,  6539, -4000,  -412,  4246, -9731, 16992, -13001, 18262, -24034, 29931, -17707, 19900, -21140, 20981, -9479,  7314, -3804, -1191,  3866, -7891, 12592, -17824, 11684, -14464, 17070, -19282, 10424, -10739, 10426, -9296,  3561, -1796,  -883,  4900, -1396,  2764, -5910, 24634, },
	{  2568, -5183,  8021, -10082,  2436, -1181, -1969,  7839, -4317,  7743, -12348, 18119, -12435, 16094, -19703, 22783, -12359, 12385, -11060,  7966, -1355, -2511,  7709, -14237, 10989, -15334, 19944, -24526, 14354, -16021, 17013, -17058,  7939, -6604,  4398, -1220, -1507,  4177, -7416, 11227, -7808, 10302, -13134, 16407, -2548,  3225, -4386,  7826, },
	{  1799, -5305, 11885, -22577,  9546, -14740, 21059, -28013,  8674, -9932, 10307, -9217,  2998,    25, -4788, 11547, -10217, 15696, -22063, 29022, -18057, 21354, -24005, 25546, -12732, 11615, -9169,  5174,   265, -4009,  8629, -14043, 10048, -13278, 16553, -19675, 11202, -12230, 12761, -12606,  5766, -4617,  2626,   613,  -745,  1968, -4935, 26815, },
	{  2994, -6275, 10376, -14522,  4319, -4111,  2259,  2151, -2533,  5672, -10158, 16105, -11734, 15998, -20583, 25075, -14449, 15657, -15728, 14186, -5273,  2181,  2362, -8457,  8050, -12576, 17656, -23050, 14215, -16685, 18685, -19930, 10056, -9457,  8010, -5568,   998,  1413, -4499,  8310, -6452,  9187, -12449, 16427, -2695,  3625, -5334, 10941, },
	{   814, -3565,  9357, -19503,  8810, -14358, 21545, -30098,  9834, -12018, 13639, -14115,  6369, -4356,   609,  5248, -6751, 12144, -18761, 26416, -17378, 21621, -25569, 28765, -15337, 15356, -14136, 11391, -3434,   190,  4084, -9376,  7803, -11308, 15079, -18951, 11357, -13057, 14423, -15278,  7702, -7259,  6106, -3888,   -16,   996, -3531, 28546, },
	{  3281, -7094, 12313, -18441,  6079, -6986,  6604, -3974,  -511,  3169, -7278, 13067, -10324, 14970, -20304, 25999, -15775, 18132, -19635, 19777, -9002,  6879, -3265, -2041,  4576, -9029, 14301, -20220, 13258, -16409, 19326, -21725, 11644, -11831, 11242, -9693,  3500, -1495, -1256,  4844, -4690,  7512, -11025, 15501, -2693,  3839, -6060, 14112, },
	{  -359, -1421,  6038, -15020,  7498, -13101, 20787, -30525, 10476, -13500, 16323, -18395,  9502, -8649,  6164, -1571, -2782,  7780, -14278, 22214, -15682, 20654, -25707, 30416, -17128, 18307, -18412, 17100, -7020,  4472,  -795, -4072,  5063, -8648, 12710, -17128, 10867, -13155, 15300, -17144,  9250, -9566,  9357, -8355,   753,  -109, -1711, 29769, },
	{  3386, -7554, 13672, -21558,  7599, -9631, 10814, -10199,  1645,   363, -3844,  9141, -8258, 13035, -18839, 25452, -16235, 19641, -22532, 24395, -12320, 11312, -8856,  4661,   751, -4878, 10046, -16165, 11521, -15188, 18875, -22318, 12600, -13580, 13902, -13354,  5859, -4384,  2136,  1015, -2613,  5357, -8921, 13646, -2534,  3843, -6499, 17243, },
	{ -1664,  1032,  2064, -9296,  5651, -10991, 18761, -29182, 10536, -14262, 18173, -21784, 12208, -12601, 11562, -8532,  1478,  2830, -8837, 16612, -13036, 18474, -24372, 30365, -17981, 20281, -21735, 21962, -10286,  8593, -5735,  1581,  1975, -5436,  9564, -14286,  9744, -12504, 15322, -18076, 10311, -11396, 12186, -12532,  1520, -1297,   495, 30442, },
	{  3275, -7585, 14314, -23616,  8771, -11872, 14631, -16161,  3812, -2597,   -32,  4518, -5630, 10272, -16232, 23416, -15774, 20067, -24221, 27748, -15025, 15219, -14089, 11269, -3214,  -345,  5114, -11089,  9084, -13070, 17334, -21646, 12857, -14591, 15824, -16332,  7935, -7089,  5486, -2969,  -329,  2831, -6235, 10931, -2221,  3623, -6600, 20237, },
	{  1682, -3028,  3668, -2373,  -647,  3343, -8102, 15517, -6514,  9982, -14227, 19045, -12023, 14311, -15972, 16483, -7619,  5792, -2439, -2722,  4945, -9567, 15174, -21604, 14285, -17825, 21142, -23892, 12840, -13037, 12315, -10457,  3634, -1294, -1844,  5801, -5282,  8038, -11122, 14468, -8999, 10811, -12628, 14416, -2021,  2243, -2508,  3041, },
	{  2923, -7138, 14133, -24408,  9501, -13550, 17806, -21492,  5865, -5546,  3950,  -562, -2570,  6808, -12590, 19956, -14387, 19349, -24567, 29603, -16943, 18359, -18653, 17403, -7095,  4320,  -229, -5260,  6072, -10157, 14768, -19723, 12384, -14790, 16884, -18441,  9604, -9450,  8603, -6883,  2035,    68, -3099,  7479, -1764,  3175, -6317, 22998, },
	{  2236, -4366,  6337, -7037,  1193,   684, -4559, 11177, -5310,  8818, -13360, 18847, -12502, 15666, -18542, 20625, -10646,  9913, -7732,  3733,  1202, -5450, 10912, -17523, 12546, -16643, 20811, -24731, 14007, -15105, 15415, -14684,  6331, -4560,  1932,  1625, -3078,  5834, -9071, 12765, -8443, 10706, -13175, 15898, -2379,  2878, -3677,  5865, },
	{  2323, -6192, 13067, -23785,  9712, -14528, 20112, -25846,  7677, -8308,  7879, -5823,   761,  2818, -8089, 15223, -12124, 17493, -23509, 29811, -17943, 20532, -22268, 22697, -10667,  8851, -5687,  1006,  2643, -6597, 11300, -16629, 11192, -14147, 17001, -19543, 10761, -11325, 11302, -10502,  4347, -2783,   323,  3455, -1181,  2510, -5621, 25436, },
	{  2728, -5587,  8873, -11659,  3095, -2190,  -534,  5939, -3732,  7082, -11675, 17543, -12274, 16166, -20135, 23722, -13161, 13595, -12745, 10168, -2719,  -904,  5909, -12329, 10042, -14478, 19280, -24174, 14399, -16355, 17702, -18164,  8724, -7635,  5679, -2735,  -649,  3246, -6453, 10290, -7389,  9983, -12982, 16520, -2615,  3383, -4735,  8892, },
	{  1482, -4753, 11106, -21679,  9357, -14706, 21364, -28912,  9129, -10714, 11521, -10964,  4179, -1485, -2957,  9448, -9086, 14570, -21064, 28309, -17939, 21584, -24702, 26826, -13716, 12986, -10949,  7361, -1015, -2580,  7109, -12516,  9335, -12681, 16149, -19551, 11328, -12596, 13419, -13612,  6473, -5560,  3844,  -933,  -500,  1649, -4497, 27469, },
	{  3112, -6594, 11103, -15952,  4948, -5121,  3762,    64, -1855,  4848, -9233, 15163, -11324, 15747, -20620, 25557, -15000, 16613, -17180, 16211, -6597,  3820,   430, -6291,  6899, -11429, 16608, -22219, 13975, -16697, 19028, -20681, 10671, -10341,  9182, -7034,  1871,   414, -3405,  7164, -5884,  8667, -12037, 16213, -2712,  3722, -5614, 12037, },
	{   426, -2865,  8292, -18104,  8420, -14022, 21426, -30442, 10119, -12606, 14652, -15681,  7490, -5865,  2530,  2928, -5424, 10715, -17333, 25134, -16904, 21426, -25782, 29522, -16056, 16477, -15709, 13442, -4699,  1675,  2419, -7598,  6904, -10459, 14355, -18442, 11261, -13175, 14820, -16022,  8287, -8103,  7267, -5451,   247,   626, -2947, 29029, },
	{  3340, -7297, 12857, -19625,  6638, -7937,  8089, -6136,   226,  2225, -6143, 11800, -9679, 14400, -19930, 25979, -16036, 18771, -20764, 21501, -10207,  8457, -5221,   266,  3281, -7650, 12920, -18946, 12742, -16092, 19294, -22071, 12050, -12514, 12237, -11024,  4340, -2506,   -89,  3550, -4002,  6815, -10370, 14961, -2655,  3865, -6247, 15205, },
	{  -800,  -601,  4728, -13167,  6916, -12465, 20229, -30264, 10565, -13850, 17066, -19682, 10497, -10068,  8067, -3984, -1328,  6120, -12489, 20421, -14868, 20033, -25411, 30595, -17534, 19109, -19682, 18895, -8197,  5929, -2512, -2139,  4025, -7590, 11702, -16254, 10548, -13015, 15406, -17577,  9677, -10260, 10393, -9847,  1021,  -514,  -989, 30066, },
	{  3374, -7616, 13981, -22402,  8050, -10461, 12193, -12311,  2400,  -653, -2557,  7609, -7406, 12167, -18062, 24914, -16181, 19916, -23262, 25712, -13335, 12737, -10724,  6978,  -617, -3340,  8403, -14511, 10751, -14552, 18463, -22229, 12770, -14018, 14658, -14472,  6616, -5350,  3310,  -358, -1839,  4519, -8051, 12798, -2443,  3792, -6575, 18300, },
	{ -2133,  1931,   570, -7069,  4899, -10074, 17771, -28300, 10414, -14343, 18591, -22704, 13012, -13846, 13335, -10903,  2978,  1028, -6780, 14395, -11921, 17452, -23572, 29940, -18043, 20710, -22623, 23392, -11306,  9938, -7409,  3562,   854, -4226,  8321, -13088,  9215, -12106, 15125, -18166, 10551, -11895, 13034, -13863,  1778, -1717,  1341, 30542, },
	{  3181, -7486, 14348, -24043,  9078, -12524, 15815, -18096,  4542, -3628,  1338,  2798, -4612,  9144, -15081, 22373, -15397, 19949, -24497, 28569, -15785, 16404, -15759, 13465, -4579,  1269,  3297, -9142,  8099, -12145, 16557, -21119, 12776, -14754, 16294, -17169,  8565, -7953,  6601, -4343,   487,  1894, -5192,  9812, -2078,  3493, -6547, 21224, },
	{  1878, -3498,  4596, -3974,   -24,  2456, -6942, 14130, -6143,  9647, -14022, 19101, -12266, 14871, -16962, 18019, -8713,  7253, -4284,  -508,  3683, -8205, 13797, -20331, 13775, -17531, 21164, -24337, 13327, -13838, 13469, -11989,  4592, -2434,  -547,  4391, -4552,  7326, -10483, 13972, -8865, 10845, -12899, 15020, -2157,  2475, -2921,  3991, },
	{  2744, -6867, 13866, -24358,  9635, -13974, 18713, -23127,  6526, -6532,  5328, -2378, -1438,  5476, -11119, 18451, -13698, 18833, -24360, 29867, -17399, 19230, -20025, 19348, -8378,  5917, -2121, -3123,  4923, -8989, 13661, -18778, 12051, -14662, 17034, -18942, 10067, -10161,  9593, -8180,  2848,  -917, -1938,  6141, -1575,  2969, -6124, 23883, },
	{  2416, -4807,  7239, -8656,  1850,  -294, -3210,  9454, -4803,  8278, -12868, 18521, -12504, 15940, -19212, 21828, -11583, 11249, -9514,  5982,  -146, -3913,  9251, -15839, 11760, -16001, 20415, -24698, 14233, -15636, 16307, -15985,  7201, -5655,  3243,   125, -2256,  4975, -8223, 11990, -8133, 10525, -13193, 16215, -2475,  3069, -4060,  6894, },
	{  2058, -5748, 12489, -23225,  9655, -14684, 20673, -27067,  8226, -9189,  9183, -7631,  1944,  1352, -6371, 13328, -11153, 16597, -22816, 29484, -18058, 21029, -23255, 24273, -11792, 10340, -7546,  3214,  1393, -5247,  9921, -15311, 10621, -13730, 16816, -19672, 11027, -11838, 12108, -11646,  5110, -3761,  1540,  1966,  -955,  2233, -5281, 26189, },
	{  2876, -5964,  9688, -13198,  3748, -3207,   934,  3963, -3112,  6360, -10911, 16838, -12027, 16126, -20433, 24509, -13881, 14726, -14360, 12323, -4078,   724,  4051, -10319,  9019, -13516, 18479, -23653, 14345, -16579, 18276, -19154,  9456, -8622,  6930, -4242,   221,  2286, -5439,  9274, -6916,  9592, -12740, 16521, -2665,  3521, -5063,  9972, },
	{  1139, -4147, 10224, -20604,  9099, -14568, 21525, -29626,  9529, -11435, 12673, -12660,  5348, -3005, -1083,  7258, -7880, 13333, -19911, 27394, -17697, 21669, -25236, 27933, -14615, 14279, -12668,  9516, -2298, -1122,  5530, -10893,  8553, -11993, 15632, -19293, 11378, -12878, 13991, -14534,  7142, -6475,  5050, -2495,  -247,  1312, -4008, 28065, },
	{  3210, -6876, 11772, -17308,  5558, -6118,  5269, -2062, -1152,  3978, -8230, 14104, -10831, 15385, -20516, 25868, -15455, 17466, -18530, 18145, -7888,  5449, -1522, -4062,  5691, -10195, 15438, -21229, 13638, -16595, 19243, -21297, 11218, -11161, 10300, -8462,  2739,  -595, -2278,  5959, -5271,  8083, -11539, 15886, -2710,  3795, -5864, 13136, },
	{    18, -2119,  7136, -16541,  7961, -13581, 21156, -30579, 10338, -13116, 15578, -17161,  8575, -7352,  4457,   560, -4044,  9197, -15771, 23667, -16309, 21083, -25821, 30085, -16672, 17495, -17187, 15418, -5941,  3160,   726, -5755,  5951, -9532, 13528, -17803, 11086, -13205, 15119, -16664,  8821, -8901,  8393, -7000,   514,   243, -2314, 29450, },
	{  3376, -7455, 13325, -20701,  7164, -8853,  9548, -8294,   974,  1250, -4949, 10433, -8959, 13724, -19415, 25780, -16190, 19288, -21761, 23097, -11355,  9992, -7159,  2591,  1953, -6207, 11439, -17532, 12135, -15662, 19131, -22269, 12378, -13116, 13155, -12291,  5157, -3507,  1088,  2220, -3279,  6065, -9636, 14312, -2600,  3865, -6398, 16290, },
	{ -1253,   252,  3346, -11175,  6272, -11728, 19518, -29787, 10582, -14110, 17702, -20851, 11432, -11436,  9937, -6399,   150,  4400, -10597, 18469, -13945, 19270, -24939, 30566, -17824, 19787, -20828, 20575, -9327,  7357, -4225,  -177,  2952, -6473, 10606, -15262, 10154, -12784, 15409, -17895, 10042, -10891, 11371, -11293,  1287,  -926,  -222, 30295, },
	{  3334, -7624, 14200, -23109,  8454, -11236, 13514, -14376,  3152, -1680, -1233,  6001, -6491, 11204, -17151, 24199, -16015, 20056, -23839, 26867, -14269, 14088, -12536,  9269, -1993, -1765,  6689, -12745,  9902, -13812, 17922, -21988, 12855, -14364, 15320, -15500,  7334, -6286,  4472, -1740, -1046,  3640, -7116, 11852, -2333,  3715, -6608, 19337, },
	{  1506, -2607,  2846,  -972, -1184,  4096, -9068, 16639, -6801, 10218, -14326, 18888, -11741, 13737, -15010, 15038, -6613,  4474,  -801, -4656,  6029, -10712, 16300, -22603, 14653, -17983, 21001, -23363, 12337, -12256, 11226, -9044,  2767,  -280, -2978,  7013, -5896,  8620, -11622, 14824, -9066, 10721, -12319, 13803, -1890,  2028, -2137,  2225, },
	{  3058, -7328, 14281, -24309,  9328, -13102, 16911, -19940,  5253, -4650,  2720,  1033, -3548,  7938, -13812, 21164, -14910, 19693, -24609, 29203, -16445, 17487, -17337, 15588, -5924,  2886,  1441, -7116,  7051, -11130, 15660, -20444, 12607, -14818, 16656, -17894,  9140, -8769,  7680, -5699,  1307,   935, -4102,  8611, -1919,  3337, -6447, 22179, },
	{  2070, -3962,  5522, -5593,   615,  1532, -5709, 12618, -5723,  9239, -13716, 19025, -12428, 15336, -17848, 19451, -9761,  8680, -6119,  1732,  2382, -6773, 12314, -18908, 13167, -17115, 21042, -24619, 13727, -14550, 14540, -13451,  5526, -3567,   763,  2941, -3786,  6559, -9768, 13376, -8669, 10804, -13084, 15529, -2280,  2695, -3326,  4971, },
	{  2534, -6536, 13491, -24133,  9706, -14309, 19507, -24630,  7153, -7488,  6690, -4203,  -282,  4089, -9553, 16802, -12908, 18183, -23984, 29928, -17739, 19976, -21272, 21178, -9614,  7487, -4014,  -948,  3732, -7750, 12453, -17697, 11633, -14434, 17068, -19318, 10464, -10808, 10526, -9433,  3649, -1906,  -750,  4742, -1372,  2737, -5880, 24725, },
	{  2586, -5229,  8117, -10259,  2509, -1292, -1812,  7632, -4254,  7673, -12278, 18062, -12421, 16108, -19758, 22895, -12452, 12523, -11251,  8213, -1507, -2334,  7512, -14031, 10887, -15244, 19877, -24496, 14364, -16064, 17095, -17186,  8029, -6720,  4542, -1388, -1412,  4076, -7312, 11127, -7764, 10270, -13122, 16425, -2557,  3244, -4426,  7944, },
	{  1765, -5246, 11803, -22486,  9528, -14741, 21100, -28122,  8727, -10021, 10444, -9413,  3130,  -142, -4587, 11319, -10095, 15577, -21960, 28953, -18050, 21386, -24091, 25697, -12846, 11771, -9369,  5418,   123, -3852,  8463, -13878,  9973, -13217, 16514, -19668, 11220, -12275, 12839, -12721,  5846, -4723,  2761,   442,  -718,  1933, -4889, 26890, },
	{  3008, -6312, 10459, -14684,  4390, -4224,  2425,  1922, -2459,  5583, -10060, 16006, -11693, 15975, -20594, 25137, -14515, 15768, -15894, 14415, -5422,  2363,  2149, -8220,  7926, -12453, 17546, -22966, 14193, -16692, 18729, -20020, 10128, -9558,  8143, -5732,  1095,  1303, -4379,  8186, -6391,  9132, -12407, 16409, -2698,  3637, -5367, 11062, },
	{   772, -3490,  9244, -19355,  8770, -14326, 21539, -30146,  9869, -12087, 13756, -14293,  6495, -4524,   822,  4993, -6606, 11990, -18609, 26283, -17332, 21607, -25601, 28858, -15422, 15485, -14316, 11622, -3575,   355,  3901, -9182,  7706, -11217, 15004, -18901, 11350, -13074, 14472, -15366,  7769, -7355,  6236, -4062,    13,   956, -3469, 28603, },
	{  3289, -7118, 12377, -18578,  6143, -7094,  6770, -4214,  -429,  3066, -7155, 12932, -10256, 14912, -20269, 26005, -15809, 18209, -19767, 19974, -9138,  7056, -3483, -1786,  4434, -8880, 14153, -20085, 13205, -16379, 19329, -21771, 11693, -11911, 11356, -9844,  3595, -1608, -1127,  4703, -4615,  7437, -10956, 15446, -2689,  3843, -6082, 14233, },
	{  -408, -1331,  5896, -14821,  7437, -13035, 20733, -30507, 10489, -13543, 16410, -18544,  9616, -8809,  6377, -1839, -2622,  7599, -14084, 22023, -15597, 20592, -25683, 30446, -17178, 18402, -18559, 17305, -7153,  4635,  -985, -3859,  4950, -8533, 12603, -17037, 10835, -13144, 15317, -17198,  9300, -9646,  9475, -8523,   782,  -153, -1633, 29805, },
	{  3386, -7563, 13711, -21658,  7651, -9726, 10970, -10435,  1729,   251, -3703,  8975, -8166, 12944, -18760, 25401, -16235, 19678, -22621, 24549, -12436, 11474, -9066,  4919,   599, -4709,  9868, -15987, 11439, -15122, 18835, -22315, 12623, -13634, 13990, -13482,  5945, -4493,  2267,   863, -2528,  5266, -8828, 13557, -2525,  3839, -6510, 17362, },
	{ -1716,  1131,  1901, -9054,  5570, -10894, 18659, -29095, 10526, -14276, 18225, -21893, 12301, -12743, 11762, -8797,  1645,  2631, -8612, 16372, -12917, 18367, -24292, 30328, -17994, 20336, -21841, 22128, -10402,  8745, -5923,  1801,  1851, -5304,  9429, -14158,  9688, -12464, 15306, -18092, 10341, -11455, 12284, -12683,  1549, -1344,   587, 30456, },
	{  3266, -7577, 14322, -23671,  8808, -11948, 14766, -16380,  3894, -2712,   119,  4329, -5519, 10150, -16110, 23308, -15737, 20061, -24260, 27848, -15114, 15355, -14279, 11516, -3367,  -166,  4914, -10877,  8978, -12972, 17254, -21595, 12852, -14614, 15882, -16430,  8007, -7187,  5612, -3122,  -239,  2729, -6121, 10811, -2206,  3610, -6596, 20349, },
	{  1704, -3080,  3771, -2549,  -578,  3247, -7977, 15369, -6475,  9948, -14209, 19058, -12054, 14378, -16087, 16658, -7743,  5956, -2644, -2478,  4807, -9419, 15026, -21470, 14234, -17798, 21151, -23949, 12898, -13130, 12447, -10630,  3741, -1421, -1700,  5647, -5203,  7962, -11055, 14418, -8987, 10819, -12663, 14488, -2037,  2270, -2554,  3145, },
	{  2905, -7111, 14108, -24411,  9519, -13601, 17912, -21680,  5940, -5656,  4104,  -763, -2445,  6663, -12432, 19796, -14315, 19299, -24552, 29643, -16999, 18462, -18811, 17624, -7240,  4498,  -439, -5025,  5947, -10031, 14650, -19624, 12351, -14780, 16906, -18503,  9658, -9532,  8716, -7029,  2125,   -41, -2971,  7333, -1744,  3153, -6298, 23099, },
	{  2256, -4416,  6438, -7217,  1266,   577, -4412, 10991, -5256,  8761, -13311, 18817, -12506, 15702, -18623, 20765, -10753, 10064, -7932,  3983,  1053, -5281, 10732, -17342, 12463, -16578, 20774, -24736, 14037, -15169, 15519, -14833,  6429, -4683,  2078,  1460, -2988,  5741, -8980, 12684, -8412, 10689, -13181, 15938, -2390,  2900, -3720,  5978, },
	{  2295, -6145, 13008, -23732,  9709, -14550, 20181, -25989,  7740, -8408,  8025, -6025,   892,  2657, -7901, 15018, -12020, 17400, -23440, 29784, -17961, 20594, -22385, 22879, -10795,  9019, -5895,  1252,  2505, -6449, 11151, -16488, 11133, -14105, 16987, -19564, 10794, -11386, 11395, -10632,  4433, -2892,   458,  3292, -1157,  2481, -5586, 25522, },
	{  2745, -5630,  8965, -11833,  3168, -2303,  -372,  5723, -3665,  7004, -11595, 17471, -12251, 16167, -20174, 23817, -13245, 13725, -12928, 10410, -2870,  -724,  5705, -12110,  9932, -14376, 19198, -24124, 14397, -16385, 17772, -18279,  8808, -7747,  5819, -2903,  -552,  3141, -6343, 10180, -7339,  9943, -12960, 16525, -2622,  3399, -4773,  9011, },
	{  1445, -4689, 11013, -21568,  9332, -14695, 21389, -29001,  9176, -10797, 11652, -11155,  4310, -1654, -2751,  9208, -8955, 14438, -20944, 28217, -17918, 21601, -24769, 26957, -13821, 13133, -11143,  7603, -1158, -2419,  6937, -12341,  9252, -12609, 16097, -19529, 11337, -12631, 13487, -13719,  6549, -5663,  3978, -1106,  -472,  1613, -4445, 27538, },
	{  3123, -6627, 11180, -16107,  5017, -5233,  3929,  -170, -1778,  4754, -9126, 15051, -11274, 15712, -20616, 25600, -15056, 16713, -17336, 16430, -6742,  4002,   214, -6046,  6768, -11296, 16484, -22117, 13942, -16692, 19058, -20756, 10736, -10435,  9309, -7194,  1968,   303, -3281,  7032, -5818,  8605, -11986, 16183, -2712,  3731, -5643, 12159, },
	{   382, -2784,  8168, -17938,  8372, -13978, 21404, -30467, 10146, -12667, 14759, -15850,  7613, -6031,  2744,  2667, -5273, 10550, -17165, 24980, -16844, 21396, -25795, 29595, -16130, 16595, -15878, 13666, -4838,  1840,  2233, -7397,  6801, -10360, 14269, -18377, 11245, -13183, 14858, -16099,  8349, -8194,  7394, -5624,   277,   584, -2879, 29079, },
	{  3345, -7317, 12913, -19750,  6698, -8041,  8253, -6376,   309,  2118, -6013, 11653, -9603, 14330, -19880, 25965, -16059, 18834, -20881, 21685, -10338,  8630, -5437,   523,  3135, -7493, 12760, -18795, 12679, -16050, 19283, -22100, 12091, -12585, 12343, -11168,  4432, -2618,    41,  3404, -3923,  6735, -10292, 14895, -2650,  3867, -6266, 15326, },
	{  -849,  -508,  4577, -12953,  6848, -12388, 20157, -30221, 10570, -13883, 17142, -19818, 10604, -10223,  8277, -4253, -1165,  5932, -12284, 20212, -14771, 19956, -25367, 30602, -17572, 19191, -19816, 19088, -8325,  6089, -2703, -1922,  3908, -7469, 11584, -16149, 10508, -12993, 15412, -17618,  9721, -10333, 10505, -10010,  1050,  -559,  -906, 30094, },
	{  3370, -7619, 14010, -22487,  8097, -10550, 12342, -12543,  2484,  -766, -2412,  7433, -7307, 12065, -17967, 24843, -16168, 19938, -23334, 25849, -13443, 12891, -10928,  7234,  -770, -3166,  8216, -14320, 10661, -14475, 18409, -22210, 12784, -14062, 14736, -14591,  6698, -5455,  3440,  -511, -1752,  4423, -7950, 12698, -2432,  3785, -6581, 18416, },
	{ -2186,  2032,   400, -6815,  4812, -9967, 17653, -28189, 10396, -14346, 18630, -22798, 13097, -13979, 13528, -11163,  3144,   826, -6548, 14141, -11791, 17330, -23473, 29880, -18043, 20750, -22712, 23542, -11415, 10084, -7592,  3782,   729, -4089,  8179, -12949,  9153, -12056, 15097, -18168, 10573, -11946, 13123, -14007,  1806, -1764,  1437, 30548, },
	{  3169, -7471, 14346, -24080,  9109, -12592, 15941, -18305,  4622, -3742,  1491,  2604, -4496,  9014, -14945, 22247, -15348, 19927, -24518, 28649, -15864, 16529, -15940, 13705, -4729,  1448,  3092, -8920,  7986, -12036, 16463, -21052, 12761, -14766, 16340, -17255,  8631, -8046,  6723, -4495,   578,  1789, -5073,  9683, -2062,  3477, -6538, 21332, },
	{  1899, -3550,  4699, -4154,    47,  2355, -6808, 13968, -6099,  9605, -13993, 19099, -12288, 14928, -17066, 18184, -8832,  7413, -4488,  -261,  3540, -8049, 13638, -20180, 13713, -17491, 21157, -24376, 13376, -13922, 13592, -12155,  4697, -2561,  -402,  4232, -4469,  7244, -10407, 13911, -8846, 10844, -12923, 15082, -2171,  2500, -2967,  4098, },
	{  2722, -6834, 13829, -24341,  9646, -14015, 18807, -23301,  6597, -6639,  5480, -2580, -1311,  5325, -10949, 18275, -13616, 18768, -24327, 29884, -17442, 19319, -20170, 19557, -8517,  6093, -2331, -2883,  4793, -8854, 13532, -18664, 12008, -14642, 17043, -18990, 10114, -10236,  9700, -8322,  2937, -1027, -1807,  5988, -1553,  2944, -6099, 23979, },
	{  2435, -4855,  7337, -8835,  1923,  -404, -3057,  9256, -4744,  8214, -12807, 18476, -12499, 15964, -19279, 21953, -11683, 11394, -9710,  6231,  -297, -3739,  9062, -15644, 11668, -15923, 20363, -24684, 14252, -15688, 16400, -16123,  7295, -5775,  3388,   -43, -2163,  4877, -8125, 11899, -8095, 10500, -13190, 16244, -2485,  3090, -4101,  7010, },
	{  2027, -5695, 12418, -23152,  9644, -14696, 20727, -27193,  8284, -9285,  9326, -7831,  2076,  1187, -6175, 13110, -11040, 16489, -22729, 29435, -18063, 21075, -23355, 24439, -11912, 10502, -7751,  3460,  1252, -5094,  9762, -15157, 10553, -13678, 16788, -19678, 11052, -11891, 12193, -11770,  5194, -3868,  1676,  1798,  -929,  2201, -5240, 26269, },
	{  2891, -6004,  9776, -13366,  3820, -3320,  1099,  3739, -3041,  6276, -10821, 16752, -11994, 16115, -20457, 24587, -13956, 14846, -14535, 12559, -4228,   906,  3842, -10090,  8901, -13403, 18382, -23585, 14333, -16597, 18333, -19256,  9533, -8729,  7067, -4409,   318,  2178, -5323,  9156, -6860,  9545, -12707, 16514, -2670,  3535, -5098, 10093, },
	{  1099, -4077, 10120, -20474,  9066, -14546, 21534, -29693,  9570, -11511, 12797, -12845,  5476, -3174,  -873,  7010, -7742, 13188, -19773, 27281, -17663, 21670, -25285, 28045, -14710, 14417, -12855,  9752, -2440,  -959,  5351, -10707,  8462, -11911, 15567, -19256, 11379, -12904, 14049, -14631,  7214, -6575,  5183, -2669,  -218,  1273, -3951, 28128, },
	{  3220, -6905, 11842, -17454,  5624, -6228,  5436, -2300, -1073,  3879, -8114, 13979, -10771, 15338, -20496, 25892, -15500, 17554, -18673, 18354, -8029,  5629, -1740, -3811,  5554, -10052, 15301, -21109, 13595, -16577, 19259, -21356, 11275, -11248, 10421, -8618,  2835,  -707, -2151,  5821, -5200,  8014, -11478, 15843, -2708,  3802, -5890, 13258, },
	{   -28, -2033,  7002, -16357,  7906, -13525, 21116, -30582, 10358, -13168, 15675, -17320,  8693, -7516,  4671,   295, -3888,  9023, -15589, 23493, -16236, 21036, -25814, 30135, -16733, 17602, -17345, 15633, -6077,  3324,   536, -5547,  5842, -9425, 13430, -17724, 11062, -13202, 15146, -16729,  8877, -8987,  8515, -7170,   544,   199, -2241, 29492, },
	{  3378, -7469, 13372, -20813,  7220, -8952,  9708, -8534,  1058,  1140, -4813, 10276, -8874, 13642, -19349, 25747, -16201, 19338, -21864, 23265, -11479, 10160, -7373,  2850,  1803, -6043, 11269, -17367, 12062, -15608, 19104, -22281, 12409, -13178, 13252, -12427,  5246, -3618,  1219,  2070, -3197,  5979, -9550, 14234, -2592,  3864, -6412, 16410, },
	{ -1304,   348,  3188, -10946,  6197, -11640, 19430, -29721, 10579, -14133, 17766, -20973, 11532, -11585, 10142, -6666,   316,  4206, -10381, 18243, -13836, 19176, -24876, 30550, -17849, 19855, -20947, 20754, -9449,  7513, -4415,    43,  2831, -6346, 10479, -15144, 10106, -12753, 15402, -17923, 10078, -10957, 11476, -11450,  1316,  -972,  -135, 30316, },
	{  3328, -7622, 14218, -23179,  8496, -11318, 13656, -14602,  3235, -1794, -1084,  5818, -6386, 11091, -17041, 24108, -15990, 20063, -23894, 26984, -14367, 14233, -12733,  9521, -2146, -1589,  6494, -12542,  9803, -13723, 17854, -21952, 12859, -14397, 15387, -15609,  7411, -6388,  4599, -1894,  -957,  3541, -7008, 11741, -2320,  3704, -6609, 19450, },
	{  1528, -2659,  2949, -1145, -1118,  4004, -8950, 16504, -6768, 10192, -14318, 18913, -11779, 13813, -15134, 15222, -6740,  4639, -1005, -4417,  5895, -10573, 16165, -22485, 14612, -17968, 21025, -23436, 12403, -12357, 11365, -9223,  2876,  -407, -2837,  6864, -5821,  8550, -11563, 14784, -9060, 10735, -12361, 13884, -1907,  2055, -2183,  2325, },
	{  3042, -7307, 14267, -24329,  9352, -13162, 17027, -20139,  5331, -4763,  2874,   835, -3427,  7800, -13664, 21020, -14849, 19656, -24611, 29261, -16512, 17601, -17507, 15819, -6072,  3066,  1234, -6886,  6931, -11012, 15554, -20360, 12583, -14818, 16689, -17968,  9201, -8857,  7798, -5849,  1398,   827, -3978,  8472, -1900,  3318, -6433, 22283, },
	{  2091, -4013,  5624, -5773,   687,  1427, -5568, 12443, -5673,  9190, -13676, 19009, -12441, 15382, -17940, 19603, -9874,  8836, -6322,  1982,  2236, -6610, 12143, -18741, 13093, -17061, 21019, -24641, 13766, -14624, 14653, -13609,  5628, -3691,   909,  2778, -3698,  6470, -9684, 13304, -8643, 10795, -13099, 15580, -2293,  2718, -3370,  5081, },
	{  2509, -6496, 13443, -24097,  9709, -14340, 19588, -24789,  7220, -7592,  6839, -4406,  -152,  3932, -9373, 16611, -12814, 18102, -23932, 29922, -17770, 20052, -21403, 21373, -9748,  7659, -4224,  -704,  3597, -7609, 12313, -17569, 11581, -14402, 17065, -19351, 10504, -10875, 10626, -9569,  3737, -2016,  -616,  4583, -1349,  2710, -5850, 24816, },
	{  2605, -5275,  8213, -10435,  2583, -1404, -1654,  7424, -4190,  7602, -12207, 18002, -12406, 16120, -19810, 23005, -12544, 12660, -11440,  8459, -1658, -2157,  7314, -13823, 10785, -15153, 19808, -24463, 14372, -16105, 17176, -17313,  8118, -6836,  4685, -1556, -1317,  3973, -7207, 11026, -7720, 10238, -13108, 16442, -2565,  3262, -4465,  8062, },
	{  1731, -5187, 11720, -22393,  9510, -14741, 21139, -28229,  8780, -10111, 10581, -9609,  3261,  -309, -4386, 11089, -9972, 15456, -21854, 28881, -18041, 21417, -24174, 25845, -12958, 11926, -9569,  5662,   -19, -3694,  8297, -13713,  9896, -13154, 16473, -19659, 11237, -12319, 12915, -12836,  5926, -4829,  2897,   271,  -691,  1899, -4842, 26965, },
	{  3022, -6349, 10542, -14846,  4461, -4336,  2592,  1692, -2385,  5493, -9960, 15906, -11650, 15952, -20603, 25197, -14579, 15878, -16059, 14643, -5570,  2546,  1935, -7982,  7800, -12329, 17434, -22880, 14170, -16698, 18772, -20108, 10198, -9658,  8275, -5896,  1192,  1192, -4259,  8061, -6330,  9077, -12365, 16389, -2700,  3649, -5399, 11184, },
	{   729, -3414,  9129, -19206,  8729, -14292, 21531, -30192,  9903, -12155, 13871, -14470,  6621, -4692,  1035,  4737, -6461, 11835, -18455, 26148, -17284, 21591, -25631, 28950, -15506, 15613, -14494, 11853, -3716,   519,  3717, -8988,  7608, -11126, 14927, -18849, 11342, -13091, 14520, -15452,  7836, -7451,  6366, -4236,    42,   915, -3406, 28659, },
	{  3296, -7143, 12440, -18713,  6206, -7200,  6936, -4454,  -348,  2963, -7031, 12795, -10187, 14853, -20233, 26010, -15842, 18284, -19897, 20170, -9274,  7233, -3700, -1531,  4291, -8729, 14003, -19949, 13151, -16348, 19330, -21815, 11741, -11990, 11470, -9994,  3689, -1720,  -998,  4560, -4540,  7362, -10887, 15390, -2686,  3847, -6104, 14355, },
	{  -456, -1242,  5753, -14621,  7374, -12968, 20676, -30486, 10502, -13585, 16497, -18691,  9728, -8968,  6589, -2106, -2462,  7417, -13890, 21830, -15511, 20529, -25656, 30473, -17228, 18496, -18705, 17508, -7285,  4797, -1176, -3645,  4836, -8418, 12494, -16944, 10802, -13132, 15332, -17250,  9350, -9726,  9592, -8690,   812,  -198, -1555, 29841, },
	{  3386, -7572, 13749, -21757,  7703, -9820, 11125, -10672,  1813,   139, -3561,  8808, -8074, 12851, -18678, 25348, -16233, 19714, -22707, 24702, -12552, 11635, -9275,  5177,   448, -4540,  9688, -15808, 11357, -15056, 18794, -22311, 12645, -13686, 14078, -13610,  6030, -4601,  2398,   711, -2443,  5175, -8734, 13466, -2515,  3834, -6520, 17480, },
	{ -1768,  1230,  1737, -8811,  5488, -10795, 18554, -29005, 10515, -14288, 18276, -22000, 12393, -12884, 11961, -9062,  1811,  2432, -8386, 16130, -12797, 18258, -24209, 30288, -18005, 20389, -21945, 22292, -10518,  8897, -6110,  2022,  1727, -5171,  9294, -14029,  9632, -12423, 15288, -18107, 10370, -11513, 12381, -12834,  1578, -1390,   680, 30470, },
	{  3256, -7568, 14330, -23724,  8844, -12023, 14901, -16598,  3976, -2827,   271,  4140, -5408, 10028, -15986, 23199, -15700, 20053, -24296, 27946, -15202, 15490, -14467, 11762, -3519,    13,  4714, -10664,  8871, -12872, 17172, -21542, 12846, -14636, 15938, -16527,  8079, -7285,  5737, -3275,  -149,  2625, -6007, 10690, -2191,  3596, -6592, 20459, },
	{  1726, -3133,  3874, -2727,  -510,  3150, -7851, 15220, -6436,  9914, -14190, 19069, -12084, 14443, -16200, 16833, -7866,  6119, -2849, -2233,  4668, -9271, 14878, -21335, 14181, -17770, 21159, -24005, 12956, -13223, 12578, -10803,  3848, -1548, -1557,  5492, -5123,  7885, -10987, 14367, -8974, 10825, -12696, 14558, -2052,  2296, -2600,  3249, },
	{  2886, -7083, 14083, -24411,  9536, -13651, 18016, -21866,  6015, -5767,  4257,  -964, -2321,  6517, -12272, 19634, -14243, 19246, -24535, 29679, -17054, 18563, -18968, 17844, -7384,  4677,  -649, -4789,  5821, -9903, 14531, -19525, 12317, -14770, 16927, -18563,  9712, -9613,  8828, -7174,  2216,  -150, -2843,  7187, -1723,  3132, -6278, 23198, },
	{  2277, -4465,  6539, -7397,  1338,   469, -4264, 10803, -5201,  8704, -13259, 18786, -12510, 15736, -18701, 20904, -10860, 10214, -8131,  4234,   904, -5112, 10551, -17160, 12379, -16511, 20736, -24738, 14065, -15232, 15622, -14981,  6527, -4805,  2224,  1294, -2897,  5647, -8888, 12601, -8379, 10672, -13187, 15978, -2401,  2922, -3763,  6092, },
	{  2267, -6098, 12948, -23676,  9705, -14571, 20248, -26131,  7803, -8508,  8172, -6226,  1023,  2495, -7713, 14812, -11916, 17305, -23369, 29756, -17979, 20654, -22500, 23060, -10922,  9186, -6102,  1497,  2367, -6301, 11001, -16346, 11072, -14063, 16970, -19583, 10826, -11446, 11488, -10762,  4518, -3001,   592,  3128, -1132,  2451, -5550, 25607, },
	{  2762, -5673,  9057, -12005,  3241, -2416,  -210,  5506, -3598,  6926, -11513, 17398, -12226, 16166, -20212, 23910, -13328, 13854, -13111, 10652, -3022,  -544,  5500, -11891,  9822, -14273, 19114, -24072, 14395, -16414, 17840, -18394,  8892, -7859,  5960, -3071,  -456,  3035, -6232, 10070, -7289,  9902, -12936, 16530, -2628,  3415, -4810,  9131, },
	{  1408, -4623, 10919, -21455,  9306, -14684, 21412, -29087,  9223, -10880, 11783, -11346,  4440, -1823, -2544,  8968, -8824, 14305, -20821, 28123, -17896, 21616, -24835, 27087, -13924, 13280, -11337,  7843, -1300, -2258,  6763, -12164,  9167, -12536, 16044, -19505, 11346, -12666, 13554, -13825,  6625, -5766,  4113, -1279,  -444,  1576, -4393, 27606, },
	{  3135, -6660, 11256, -16260,  5086, -5344,  4097,  -405, -1701,  4659, -9017, 14938, -11222, 15676, -20609, 25641, -15110, 16812, -17489, 16649, -6887,  4183,    -2, -5801,  6636, -11162, 16358, -22012, 13909, -16684, 19087, -20830, 10799, -10529,  9436, -7355,  2065,   191, -3157,  6901, -5751,  8543, -11934, 16151, -2713,  3740, -5672, 12281, },
	{   337, -2703,  8043, -17770,  8324, -13933, 21379, -30490, 10173, -12726, 14865, -16018,  7735, -6197,  2958,  2405, -5121, 10385, -16997, 24824, -16782, 21363, -25806, 29664, -16202, 16713, -16046, 13889, -4977,  2005,  2045, -7194,  6697, -10259, 14180, -18311, 11229, -13190, 14895, -16174,  8410, -8285,  7520, -5797,   306,   542, -2811, 29128, },
	{  3350, -7336, 12968, -19874,  6758, -8144,  8416, -6616,   392,  2011, -5883, 11505, -9525, 14259, -19828, 25950, -16080, 18897, -20997, 21868, -10468,  8802, -5653,   781,  2988, -7335, 12599, -18643, 12615, -16006, 19269, -22128, 12130, -12655, 12448, -11312,  4524, -2730,   172,  3257, -3844,  6653, -10213, 14826, -2645,  3868, -6284, 15447, },
	{  -899,  -414,  4426, -12736,  6778, -12310, 20084, -30176, 10575, -13916, 17217, -19953, 10710, -10377,  8486, -4521, -1002,  5743, -12077, 20000, -14673, 19876, -25322, 30607, -17609, 19271, -19948, 19279, -8452,  6249, -2894, -1705,  3790, -7347, 11466, -16043, 10467, -12971, 15416, -17658,  9763, -10406, 10616, -10172,  1080,  -605,  -823, 30122, },
	{  3367, -7622, 14038, -22571,  8143, -10638, 12492, -12775,  2567,  -880, -2266,  7257, -7208, 11961, -17871, 24771, -16154, 19959, -23403, 25983, -13550, 13044, -11132,  7490,  -923, -2992,  8028, -14128, 10569, -14396, 18354, -22189, 12797, -14103, 14814, -14709,  6779, -5561,  3570,  -664, -1665,  4327, -7849, 12596, -2420,  3778, -6586, 18532, },
	{ -2238,  2133,   231, -6560,  4725, -9858, 17532, -28075, 10377, -14348, 18668, -22890, 13180, -14112, 13720, -11424,  3311,   623, -6314, 13885, -11660, 17207, -23371, 29817, -18041, 20787, -22800, 23690, -11523, 10230, -7776,  4002,   603, -3952,  8036, -12808,  9089, -12006, 15067, -18169, 10595, -11996, 13212, -14150,  1834, -1810,  1534, 30554, },
	{  3156, -7456, 14342, -24116,  9139, -12659, 16066, -18514,  4702, -3856,  1645,  2409, -4379,  8882, -14809, 22119, -15298, 19904, -24536, 28726, -15941, 16654, -16119, 13944, -4880,  1628,  2887, -8698,  7872, -11927, 16368, -20982, 12746, -14777, 16384, -17340,  8697, -8139,  6845, -4646,   669,  1683, -4954,  9552, -2044,  3461, -6529, 21439, },
	{  1921, -3602,  4802, -4333,   117,  2254, -6674, 13804, -6054,  9562, -13962, 19095, -12309, 14983, -17168, 18347, -8951,  7573, -4693,   -12,  3397, -7892, 13477, -20028, 13649, -17449, 21149, -24414, 13424, -14004, 13714, -12321,  4802, -2687,  -257,  4072, -4385,  7160, -10331, 13848, -8826, 10842, -12947, 15142, -2186,  2525, -3012,  4206, },
	{  2700, -6799, 13792, -24323,  9657, -14056, 18899, -23473,  6668, -6747,  5632, -2783, -1183,  5172, -10779, 18097, -13531, 18700, -24291, 29898, -17484, 19406, -20313, 19765, -8657,  6269, -2542, -2643,  4662, -8719, 13402, -18549, 11965, -14620, 17051, -19037, 10161, -10310,  9806, -8463,  3027, -1137, -1676,  5835, -1531,  2919, -6074, 24074, },
	{  2455, -4902,  7436, -9014,  1996,  -515, -2904,  9057, -4684,  8150, -12745, 18430, -12493, 15987, -19344, 22077, -11782, 11538, -9905,  6480,  -448, -3565,  8871, -15447, 11574, -15843, 20308, -24668, 14270, -15740, 16492, -16261,  7389, -5895,  3533,  -211, -2070,  4779, -8026, 11806, -8056, 10475, -13185, 16271, -2495,  3110, -4142,  7126, },
	{  1996, -5642, 12345, -23076,  9633, -14706, 20779, -27316,  8342, -9379,  9468, -8030,  2208,  1022, -5980, 12891, -10925, 16381, -22640, 29384, -18066, 21120, -23454, 24603, -12032, 10663, -7955,  3705,  1112, -4941,  9603, -15002, 10483, -13624, 16759, -19683, 11076, -11942, 12277, -11892,  5276, -3976,  1811,  1630,  -903,  2168, -5198, 26349, },
	{  2906, -6044,  9863, -13533,  3892, -3433,  1264,  3514, -2970,  6192, -10729, 16664, -11960, 16102, -20480, 24663, -14030, 14965, -14709, 12794, -4378,  1088,  3632, -9860,  8782, -13288, 18283, -23514, 14320, -16614, 18387, -19357,  9610, -8835,  7203, -4575,   415,  2069, -5207,  9038, -6804,  9496, -12673, 16506, -2674,  3548, -5133, 10213, },
	{  1059, -4006, 10015, -20341,  9032, -14523, 21541, -29758,  9610, -11586, 12920, -13029,  5605, -3343,  -662,  6761, -7603, 13043, -19634, 27164, -17627, 21668, -25332, 28154, -14803, 14555, -13041,  9988, -2583,  -795,  5172, -10520,  8370, -11828, 15502, -19218, 11378, -12929, 14106, -14727,  7286, -6674,  5316, -2843,  -189,  1234, -3893, 28190, },
	{  3230, -6934, 11912, -17598,  5690, -6337,  5604, -2539,  -993,  3779, -7997, 13853, -10710, 15289, -20473, 25914, -15543, 17641, -18815, 18561, -8170,  5808, -1958, -3560,  5416, -9909, 15162, -20988, 13550, -16557, 19273, -21414, 11330, -11334, 10541, -8774,  2931,  -820, -2024,  5684, -5128,  7944, -11417, 15798, -2707,  3808, -5915, 13380, },
	{   -75, -1947,  6868, -16172,  7850, -13468, 21075, -30581, 10377, -13218, 15771, -17477,  8811, -7679,  4885,    29, -3732,  8848, -15406, 23317, -16161, 20987, -25805, 30182, -16794, 17707, -17501, 15846, -6213,  3489,   347, -5338,  5732, -9316, 13331, -17643, 11037, -13199, 15172, -16792,  8933, -9071,  8637, -7341,   574,   155, -2167, 29534, },
	{  3380, -7483, 13418, -20924,  7275, -9051,  9868, -8772,  1142,  1030, -4676, 10117, -8789, 13559, -19281, 25711, -16210, 19386, -21965, 23432, -11601, 10327, -7586,  3108,  1654, -5878, 11097, -17200, 11988, -15552, 19077, -22292, 12439, -13239, 13348, -12562,  5335, -3728,  1350,  1920, -3115,  5892, -9463, 14153, -2585,  3862, -6426, 16529, },
	{ -1355,   445,  3030, -10715,  6121, -11551, 19340, -29652, 10576, -14155, 17828, -21094, 11631, -11732, 10347, -6934,   481,  4011, -10163, 18015, -13725, 19081, -24810, 30531, -17872, 19921, -21065, 20932, -9571,  7669, -4604,   262,  2710, -6218, 10351, -15026, 10057, -12720, 15395, -17949, 10114, -11023, 11580, -11607,  1345, -1018,   -46, 30337, },
	{  3321, -7619, 14235, -23247,  8537, -11400, 13798, -14827,  3318, -1909,  -935,  5635, -6280, 10977, -16930, 24016, -15963, 20069, -23947, 27100, -14464, 14377, -12930,  9772, -2299, -1412,  6299, -12338,  9703, -13634, 17784, -21914, 12862, -14428, 15453, -15716,  7488, -6490,  4727, -2047,  -868,  3441, -6900, 11629, -2307,  3694, -6609, 19564, },
	{  1550, -2712,  3051, -1319, -1051,  3911, -8832, 16368, -6733, 10165, -14308, 18937, -11817, 13887, -15257, 15406, -6867,  4805, -1210, -4176,  5761, -10432, 16027, -22365, 14569, -17952, 21047, -23507, 12469, -12457, 11503, -9401,  2985,  -533, -2696,  6714, -5746,  8479, -11503, 14742, -9054, 10749, -12402, 13963, -1924,  2083, -2230,  2426, },
	{  3026, -7285, 14251, -24346,  9376, -13220, 17142, -20337,  5408, -4875,  3028,   636, -3306,  7661, -13514, 20874, -14787, 19617, -24611, 29317, -16578, 17714, -17674, 16049, -6219,  3246,  1025, -6656,  6810, -10892, 15446, -20274, 12558, -14818, 16721, -18040,  9261, -8944,  7914, -5998,  1489,   719, -3854,  8333, -1881,  3298, -6418, 22387, },
	{  2112, -4064,  5727, -5954,   759,  1322, -5426, 12266, -5623,  9139, -13634, 18990, -12452, 15426, -18030, 19753, -9986,  8992, -6524,  2232,  2089, -6447, 11970, -18572, 13019, -17006, 20995, -24660, 13804, -14696, 14765, -13766,  5730, -3816,  1055,  2614, -3611,  6381, -9599, 13230, -8617, 10785, -13113, 15629, -2306,  2741, -3415,  5192, },
	{  2484, -6455, 13393, -24059,  9712, -14370, 19667, -24945,  7287, -7696,  6989, -4608,   -22,  3775, -9193, 16417, -12719, 18020, -23878, 29914, -17799, 20125, -21531, 21567, -9881,  7831, -4433,  -461,  3462, -7466, 12172, -17440, 11529, -14369, 17060, -19384, 10544, -10942, 10725, -9704,  3825, -2126,  -483,  4424, -1326,  2682, -5819, 24906, },
	{  2623, -5320,  8308, -10611,  2656, -1516, -1495,  7215, -4126,  7530, -12134, 17942, -12391, 16130, -19862, 23113, -12635, 12797, -11629,  8704, -1810, -1979,  7116, -13613, 10682, -15061, 19738, -24428, 14380, -16144, 17255, -17439,  8207, -6952,  4828, -1725, -1222,  3871, -7101, 10924, -7675, 10204, -13094, 16457, -2573,  3280, -4505,  8180, },
	{  1696, -5127, 11637, -22297,  9491, -14740, 21176, -28333,  8832, -10199, 10718, -9804,  3393,  -477, -4183, 10858, -9848, 15334, -21747, 28807, -18031, 21447, -24255, 25991, -13069, 12080, -9768,  5906,  -161, -3536,  8130, -13545,  9819, -13090, 16431, -19649, 11252, -12361, 12990, -12950,  6006, -4934,  3033,   100,  -664,  1864, -4795, 27039, },
	{  3035, -6385, 10624, -15006,  4531, -4449,  2759,  1461, -2310,  5403, -9859, 15804, -11607, 15927, -20611, 25254, -14643, 15987, -16223, 14870, -5718,  2728,  1721, -7743,  7674, -12204, 17320, -22791, 14146, -16702, 18813, -20195, 10268, -9758,  8406, -6060,  1289,  1082, -4138,  7935, -6268,  9021, -12321, 16368, -2703,  3660, -5431, 11305, },
	{   687, -3337,  9013, -19055,  8688, -14257, 21522, -30235,  9936, -12223, 13986, -14646,  6746, -4860,  1248,  4481, -6315, 11678, -18300, 26010, -17234, 21573, -25659, 29039, -15588, 15740, -14670, 12082, -3857,   684,  3533, -8792,  7510, -11034, 14850, -18796, 11334, -13106, 14566, -15537,  7902, -7545,  6496, -4410,    71,   875, -3342, 28714, },
	{  3303, -7166, 12503, -18847,  6269, -7307,  7101, -4694,  -267,  2859, -6907, 12656, -10118, 14792, -20195, 26012, -15874, 18358, -20025, 20365, -9409,  7409, -3918, -1275,  4148, -8577, 13852, -19811, 13096, -16316, 19330, -21857, 11788, -12067, 11582, -10143,  3783, -1833,  -869,  4417, -4465,  7286, -10816, 15333, -2682,  3851, -6126, 14477, },
	{  -505, -1151,  5609, -14418,  7311, -12900, 20618, -30462, 10513, -13627, 16582, -18837,  9840, -9127,  6801, -2374, -2301,  7234, -13694, 21635, -15423, 20463, -25628, 30498, -17276, 18588, -18849, 17710, -7417,  4960, -1367, -3431,  4722, -8302, 12384, -16850, 10769, -13119, 15347, -17301,  9399, -9804,  9708, -8857,   842,  -243, -1476, 29875, },
	{  3385, -7580, 13785, -21854,  7754, -9914, 11279, -10907,  1896,    26, -3419,  8639, -7981, 12757, -18595, 25293, -16230, 19747, -22792, 24852, -12667, 11795, -9484,  5435,   296, -4370,  9507, -15627, 11273, -14988, 18752, -22305, 12666, -13736, 14164, -13736,  6115, -4709,  2528,   559, -2357,  5082, -8639, 13375, -2506,  3829, -6529, 17598, },
	{ -1820,  1330,  1572, -8566,  5406, -10696, 18448, -28912, 10503, -14300, 18326, -22106, 12484, -13024, 12160, -9327,  1978,  2233, -8160, 15887, -12675, 18148, -24125, 30246, -18015, 20440, -22047, 22455, -10633,  9047, -6297,  2242,  1603, -5037,  9157, -13898,  9575, -12381, 15268, -18120, 10399, -11570, 12477, -12983,  1607, -1437,   772, 30483, },
	{  3247, -7558, 14336, -23776,  8880, -12097, 15035, -16815,  4057, -2941,   423,  3950, -5296,  9905, -15861, 23087, -15661, 20043, -24331, 28042, -15289, 15624, -14655, 12008, -3671,   192,  4513, -10449,  8763, -12772, 17089, -21487, 12839, -14656, 15993, -16623,  8151, -7382,  5862, -3428,   -58,  2522, -5893, 10568, -2175,  3582, -6587, 20570, },
	{  1748, -3185,  3977, -2904,  -441,  3052, -7724, 15069, -6396,  9878, -14170, 19078, -12113, 14508, -16313, 17006, -7989,  6282, -3054, -1988,  4529, -9121, 14727, -21197, 14126, -17741, 21165, -24058, 13012, -13314, 12708, -10975,  3955, -1675, -1413,  5336, -5043,  7807, -10918, 14314, -8961, 10831, -12728, 14628, -2068,  2322, -2647,  3354, },
	{  2867, -7055, 14056, -24410,  9553, -13701, 18120, -22051,  6089, -5877,  4411, -1166, -2196,  6370, -12111, 19471, -14169, 19192, -24517, 29713, -17107, 18663, -19123, 18063, -7527,  4855,  -859, -4553,  5694, -9776, 14411, -19423, 12282, -14758, 16947, -18622,  9765, -9694,  8939, -7320,  2307,  -260, -2715,  7040, -1703,  3109, -6258, 23298, },
	{  2297, -4515,  6640, -7578,  1411,   361, -4116, 10614, -5146,  8645, -13207, 18753, -12512, 15769, -18779, 21041, -10965, 10364, -8331,  4484,   755, -4943, 10368, -16976, 12294, -16442, 20695, -24739, 14093, -15293, 15724, -15128,  6625, -4928,  2370,  1127, -2806,  5553, -8796, 12517, -8346, 10654, -13191, 16015, -2413,  2943, -3806,  6205, },
	{  2238, -6050, 12886, -23618,  9701, -14591, 20313, -26271,  7865, -8607,  8318, -6428,  1155,  2333, -7524, 14605, -11810, 17209, -23296, 29725, -17994, 20712, -22613, 23238, -11049,  9353, -6310,  1742,  2229, -6153, 10850, -16203, 11011, -14019, 16952, -19601, 10857, -11505, 11579, -10891,  4604, -3110,   728,  2963, -1107,  2420, -5513, 25692, },
	{  2779, -5715,  9149, -12177,  3313, -2529,   -48,  5288, -3530,  6848, -11431, 17322, -12201, 16165, -20249, 24002, -13410, 13981, -13292, 10892, -3173,  -363,  5295, -11670,  9710, -14169, 19028, -24019, 14392, -16442, 17907, -18507,  8974, -7970,  6099, -3238,  -360,  2929, -6121,  9959, -7237,  9861, -12911, 16533, -2634,  3431, -4847,  9251, },
	{  1370, -4557, 10823, -21340,  9279, -14671, 21433, -29171,  9269, -10961, 11912, -11535,  4571, -1992, -2337,  8727, -8692, 14170, -20697, 28026, -17872, 21629, -24898, 27214, -14026, 13426, -11529,  8084, -1443, -2097,  6589, -11985,  9082, -12462, 15989, -19480, 11353, -12699, 13620, -13929,  6701, -5869,  4247, -1453,  -416,  1539, -4340, 27674, },
	{  3147, -6692, 11332, -16413,  5154, -5455,  4264,  -641, -1623,  4563, -8907, 14823, -11169, 15639, -20601, 25680, -15163, 16910, -17642, 16866, -7031,  4365,  -219, -5554,  6503, -11027, 16231, -21906, 13874, -16676, 19114, -20902, 10861, -10622,  9561, -7514,  2162,    79, -3032,  6768, -5684,  8479, -11881, 16117, -2713,  3749, -5701, 12403, },
	{   292, -2621,  7917, -17601,  8274, -13886, 21353, -30510, 10199, -12785, 14970, -16185,  7856, -6363,  3172,  2143, -4969, 10218, -16826, 24665, -16719, 21328, -25814, 29732, -16273, 16828, -16213, 14110, -5116,  2170,  1858, -6991,  6592, -10158, 14091, -18243, 11211, -13195, 14931, -16248,  8471, -8375,  7646, -5970,   336,   500, -2741, 29177, },
	{  3355, -7355, 13022, -19996,  6817, -8246,  8579, -6856,   475,  1903, -5752, 11355, -9447, 14186, -19774, 25932, -16099, 18957, -21111, 22048, -10597,  8974, -5869,  1039,  2841, -7176, 12437, -18490, 12549, -15961, 19254, -22153, 12168, -12724, 12552, -11454,  4616, -2841,   302,  3110, -3764,  6571, -10134, 14757, -2639,  3868, -6302, 15568, },
	{  -949,  -320,  4275, -12518,  6708, -12230, 20009, -30129, 10578, -13947, 17290, -20085, 10815, -10530,  8695, -4790,  -838,  5553, -11870, 19787, -14573, 19795, -25273, 30609, -17644, 19349, -20079, 19469, -8579,  6408, -3084, -1487,  3671, -7224, 11346, -15936, 10425, -12948, 15419, -17696,  9806, -10478, 10726, -10334,  1110,  -650,  -738, 30150, },
	{  3363, -7625, 14065, -22653,  8190, -10726, 12640, -13005,  2651,  -994, -2119,  7081, -7108, 11856, -17773, 24695, -16138, 19978, -23471, 26116, -13656, 13196, -11335,  7745, -1075, -2818,  7839, -13934, 10477, -14317, 18297, -22166, 12808, -14144, 14889, -14825,  6860, -5665,  3699,  -818, -1577,  4230, -7746, 12494, -2408,  3770, -6591, 18648, },
	{ -2291,  2235,    61, -6303,  4637, -9748, 17410, -27958, 10357, -14348, 18704, -22980, 13263, -14243, 13911, -11683,  3477,   420, -6079, 13628, -11528, 17082, -23267, 29752, -18037, 20823, -22886, 23837, -11631, 10374, -7959,  4221,   477, -3814,  7892, -12667,  9024, -11954, 15036, -18168, 10615, -12045, 13299, -14291,  1862, -1857,  1631, 30560, },
	{  3143, -7440, 14337, -24149,  9168, -12725, 16190, -18721,  4782, -3970,  1798,  2214, -4262,  8750, -14670, 21988, -15247, 19879, -24553, 28802, -16017, 16777, -16296, 14182, -5030,  1808,  2682, -8474,  7757, -11816, 16271, -20911, 12729, -14786, 16427, -17423,  8763, -8230,  6965, -4798,   760,  1577, -4834,  9421, -2027,  3444, -6519, 21546, },
	{  1942, -3654,  4906, -4513,   188,  2152, -6539, 13639, -6009,  9519, -13931, 19090, -12329, 15037, -17269, 18509, -9068,  7733, -4897,   236,  3253, -7735, 13314, -19873, 13583, -17406, 21139, -24449, 13470, -14086, 13835, -12485,  4906, -2813,  -111,  3912, -4300,  7076, -10253, 13784, -8806, 10839, -12970, 15201, -2200,  2550, -3057,  4314, },
	{  2677, -6764, 13753, -24302,  9666, -14095, 18990, -23643,  6739, -6854,  5784, -2986, -1055,  5020, -10607, 17917, -13446, 18631, -24254, 29910, -17525, 19493, -20455, 19971, -8795,  6444, -2752, -2402,  4530, -8583, 13270, -18432, 11921, -14597, 17058, -19082, 10207, -10384,  9911, -8603,  3116, -1247, -1544,  5681, -1509,  2894, -6048, 24168, },
	{  2474, -4950,  7534, -9193,  2069,  -625, -2749,  8857, -4624,  8084, -12682, 18382, -12486, 16008, -19408, 22199, -11881, 11681, -10099,  6728,  -599, -3391,  8680, -15249, 11479, -15761, 20252, -24649, 14287, -15790, 16582, -16397,  7482, -6014,  3678,  -379, -1977,  4680, -7926, 11712, -8016, 10448, -13179, 16297, -2504,  3129, -4184,  7242, },
	{  1964, -5587, 12272, -22999,  9620, -14714, 20830, -27438,  8399, -9473,  9609, -8229,  2339,   857, -5783, 12670, -10810, 16270, -22549, 29330, -18069, 21164, -23550, 24765, -12151, 10824, -8159,  3950,   971, -4787,  9443, -14846, 10413, -13570, 16728, -19685, 11099, -11993, 12361, -12013,  5359, -4084,  1947,  1461,  -877,  2135, -5156, 26429, },
	{  2922, -6084,  9950, -13699,  3963, -3546,  1429,  3289, -2898,  6107, -10637, 16574, -11925, 16088, -20502, 24736, -14102, 15084, -14881, 13028, -4528,  1270,  3421, -9628,  8662, -13173, 18183, -23442, 14305, -16629, 18441, -19456,  9686, -8940,  7339, -4741,   512,  1961, -5090,  8919, -6747,  9447, -12639, 16496, -2678,  3562, -5167, 10334, },
	{  1019, -3934,  9908, -20207,  8997, -14499, 21546, -29821,  9649, -11660, 13042, -13212,  5733, -3512,  -451,  6511, -7463, 12896, -19493, 27046, -17589, 21665, -25376, 28262, -14895, 14691, -13226, 10224, -2725,  -631,  4992, -10332,  8278, -11744, 15435, -19177, 11377, -12953, 14162, -14822,  7356, -6773,  5448, -3018,  -161,  1195, -3834, 28251, },
	{  3239, -6962, 11981, -17742,  5756, -6446,  5771, -2777,  -913,  3679, -7879, 13725, -10648, 15240, -20450, 25933, -15585, 17726, -18955, 18767, -8310,  5988, -2176, -3308,  5277, -9765, 15022, -20864, 13504, -16536, 19286, -21471, 11385, -11419, 10660, -8928,  3026,  -932, -1897,  5545, -5057,  7874, -11354, 15752, -2705,  3814, -5941, 13502, },
	{  -122, -1861,  6732, -15985,  7794, -13410, 21032, -30579, 10396, -13268, 15866, -17634,  8927, -7842,  5098,  -237, -3575,  8672, -15222, 23138, -16085, 20936, -25794, 30228, -16853, 17810, -17657, 16058, -6349,  3653,   157, -5128,  5622, -9207, 13231, -17561, 11011, -13195, 15196, -16854,  8987, -9156,  8759, -7511,   603,   112, -2092, 29575, },
	{  3382, -7496, 13463, -21033,  7331, -9149, 10027, -9011,  1225,   920, -4539,  9957, -8702, 13475, -19212, 25674, -16217, 19432, -22064, 23597, -11723, 10493, -7799,  3367,  1504, -5713, 10925, -17031, 11912, -15494, 19047, -22301, 12469, -13298, 13443, -12697,  5423, -3838,  1481,  1770, -3032,  5804, -9375, 14072, -2577,  3859, -6440, 16649, },
	{ -1406,   542,  2871, -10482,  6045, -11461, 19248, -29580, 10571, -14176, 17889, -21213, 11729, -11879, 10551, -7201,   647,  3815, -9945, 17786, -13614, 18984, -24743, 30510, -17894, 19985, -21181, 21108, -9692,  7824, -4794,   482,  2588, -6089, 10222, -14906, 10007, -12687, 15386, -17974, 10149, -11087, 11683, -11763,  1375, -1065,    43, 30356, },
	{  3314, -7615, 14251, -23313,  8578, -11480, 13939, -15052,  3400, -2024,  -785,  5451, -6173, 10862, -16818, 23921, -15935, 20073, -23997, 27213, -14561, 14520, -13125, 10023, -2451, -1235,  6103, -12133,  9602, -13543, 17713, -21874, 12864, -14458, 15518, -15822,  7564, -6591,  4854, -2201,  -779,  3340, -6791, 11515, -2293,  3683, -6609, 19677, },
	{  1572, -2765,  3154, -1494,  -985,  3818, -8713, 16231, -6698, 10136, -14298, 18959, -11854, 13961, -15379, 15588, -6993,  4970, -1414, -3936,  5627, -10290, 15889, -22243, 14525, -17935, 21067, -23576, 12533, -12556, 11641, -9579,  3093,  -660, -2555,  6564, -5670,  8408, -11442, 14700, -9047, 10761, -12442, 14041, -1940,  2110, -2276,  2528, },
	{  3010, -7263, 14235, -24362,  9399, -13278, 17256, -20533,  5485, -4988,  3181,   437, -3185,  7521, -13363, 20726, -14724, 19577, -24608, 29371, -16642, 17825, -17841, 16277, -6366,  3425,   817, -6425,  6689, -10772, 15336, -20187, 12531, -14816, 16752, -18110,  9320, -9030,  8031, -6146,  1580,   611, -3729,  8193, -1862,  3279, -6403, 22490, },
	{  2133, -4115,  5829, -6134,   831,  1217, -5284, 12088, -5572,  9088, -13592, 18971, -12463, 15469, -18119, 19902, -10098,  9147, -6726,  2482,  1942, -6282, 11797, -18401, 12943, -16949, 20969, -24677, 13841, -14767, 14877, -13921,  5831, -3941,  1201,  2450, -3523,  6292, -9513, 13156, -8590, 10774, -13126, 15677, -2319,  2765, -3459,  5304, },
	{  2458, -6413, 13342, -24019,  9714, -14400, 19745, -25100,  7353, -7799,  7138, -4811,   108,  3617, -9011, 16222, -12623, 17936, -23821, 29903, -17826, 20197, -21658, 21760, -10014,  8002, -4643,  -217,  3326, -7323, 12029, -17308, 11475, -14335, 17054, -19414, 10582, -11008, 10823, -9839,  3912, -2235,  -349,  4264, -1302,  2654, -5788, 24996, },
	{  2641, -5365,  8404, -10787,  2729, -1628, -1336,  7005, -4062,  7457, -12061, 17879, -12374, 16140, -19911, 23219, -12725, 12932, -11817,  8950, -1961, -1800,  6916, -13402, 10578, -14967, 19666, -24391, 14386, -16183, 17333, -17563,  8295, -7067,  4971, -1893, -1127,  3768, -6995, 10821, -7629, 10169, -13078, 16471, -2580,  3298, -4544,  8298, },
	{  1661, -5067, 11551, -22200,  9471, -14737, 21212, -28435,  8883, -10287, 10853, -9999,  3524,  -644, -3981, 10626, -9724, 15210, -21638, 28730, -18020, 21474, -24335, 26136, -13180, 12233, -9967,  6149,  -303, -3378,  7961, -13377,  9740, -13024, 16388, -19637, 11267, -12403, 13064, -13063,  6085, -5039,  3168,   -72,  -637,  1829, -4747, 27112, },
	{  3048, -6421, 10706, -15166,  4601, -4561,  2926,  1230, -2235,  5312, -9757, 15701, -11562, 15900, -20617, 25310, -14706, 16094, -16386, 15096, -5865,  2910,  1507, -7503,  7546, -12078, 17206, -22701, 14120, -16704, 18853, -20280, 10338, -9857,  8537, -6223,  1386,   971, -4017,  7808, -6205,  8964, -12277, 16346, -2705,  3671, -5462, 11427, },
	{   644, -3260,  8895, -18901,  8645, -14221, 21511, -30276,  9969, -12289, 14099, -14821,  6871, -5028,  1461,  4224, -6168, 11520, -18143, 25870, -17183, 21553, -25685, 29125, -15669, 15866, -14846, 12311, -3998,   849,  3348, -8595,  7411, -10940, 14770, -18741, 11324, -13120, 14611, -15621,  7968, -7640,  6626, -4584,   100,   834, -3278, 28769, },
	{  3310, -7190, 12564, -18980,  6331, -7413,  7267, -4934,  -185,  2754, -6781, 12517, -10047, 14730, -20155, 26012, -15904, 18431, -20152, 20558, -9544,  7585, -4136, -1019,  4005, -8425, 13700, -19671, 13040, -16282, 19328, -21897, 11834, -12144, 11693, -10292,  3876, -1945,  -739,  4274, -4389,  7209, -10744, 15275, -2678,  3854, -6147, 14598, },
	{  -553, -1061,  5465, -14214,  7247, -12831, 20558, -30436, 10524, -13667, 16666, -18981,  9951, -9285,  7013, -2642, -2140,  7050, -13497, 21437, -15334, 20396, -25597, 30521, -17322, 18679, -18992, 17911, -7548,  5122, -1558, -3217,  4607, -8186, 12273, -16755, 10734, -13104, 15360, -17351,  9447, -9882,  9824, -9023,   872,  -288, -1396, 29909, },
	{  3384, -7588, 13821, -21949,  7805, -10006, 11433, -11142,  1980,   -86, -3277,  8470, -7887, 12662, -18511, 25235, -16225, 19780, -22875, 25000, -12780, 11954, -9692,  5693,   144, -4199,  9325, -15444, 11189, -14918, 18708, -22297, 12686, -13786, 14249, -13862,  6200, -4817,  2659,   407, -2272,  4990, -8543, 13282, -2496,  3824, -6538, 17715, },
	{ -1872,  1429,  1406, -8320,  5323, -10595, 18339, -28817, 10491, -14310, 18374, -22210, 12575, -13164, 12358, -9591,  2144,  2033, -7932, 15642, -12552, 18036, -24038, 30202, -18024, 20489, -22147, 22616, -10747,  9197, -6483,  2462,  1479, -4903,  9020, -13766,  9517, -12338, 15248, -18131, 10426, -11627, 12572, -13132,  1635, -1483,   866, 30495, },
	{  3237, -7548, 14341, -23825,  8915, -12171, 15167, -17031,  4139, -3056,   575,  3759, -5183,  9780, -15735, 22973, -15620, 20032, -24364, 28136, -15375, 15757, -14842, 12253, -3823,   371,  4312, -10234,  8655, -12670, 17004, -21431, 12832, -14676, 16046, -16717,  8221, -7478,  5986, -3581,    32,  2418, -5778, 10445, -2160,  3568, -6582, 20680, },
	{  1769, -3237,  4081, -3082,  -372,  2954, -7596, 14916, -6356,  9842, -14148, 19086, -12141, 14571, -16424, 17178, -8111,  6445, -3259, -1743,  4389, -8971, 14576, -21058, 14071, -17710, 21169, -24110, 13067, -13404, 12838, -11146,  4062, -1801, -1270,  5180, -4962,  7729, -10848, 14260, -8947, 10835, -12759, 14696, -2083,  2348, -2692,  3459, },
	{  2847, -7025, 14027, -24407,  9568, -13749, 18222, -22234,  6163, -5987,  4564, -1367, -2071,  6223, -11948, 19305, -14094, 19137, -24496, 29745, -17159, 18761, -19277, 18280, -7670,  5032, -1069, -4316,  5567, -9647, 14289, -19320, 12246, -14745, 16965, -18679,  9817, -9774,  9050, -7464,  2397,  -369, -2586,  6892, -1682,  3087, -6237, 23396, },
	{  2317, -4564,  6740, -7758,  1484,   252, -3966, 10424, -5090,  8586, -13154, 18718, -12513, 15801, -18855, 21176, -11070, 10514, -8529,  4734,   605, -4773, 10185, -16790, 12208, -16372, 20653, -24737, 14119, -15353, 15824, -15273,  6722, -5050,  2516,   961, -2715,  5458, -8702, 12432, -8313, 10634, -13194, 16052, -2424,  2965, -3849,  6320, },
	{  2209, -6002, 12823, -23558,  9695, -14610, 20377, -26408,  7927, -8705,  8463, -6629,  1286,  2171, -7334, 14396, -11703, 17111, -23221, 29691, -18009, 20769, -22725, 23415, -11175,  9519, -6517,  1987,  2090, -6003, 10697, -16058, 10948, -13974, 16933, -19617, 10888, -11563, 11669, -11019,  4689, -3219,   863,  2798, -1082,  2390, -5476, 25776, },
	{  2796, -5758,  9240, -12349,  3386, -2642,   115,  5070, -3461,  6768, -11347, 17246, -12175, 16162, -20284, 24091, -13491, 14108, -13472, 11133, -3324,  -183,  5089, -11447,  9597, -14063, 18941, -23963, 14387, -16468, 17972, -18618,  9056, -8080,  6239, -3406,  -263,  2823, -6009,  9847, -7185,  9818, -12885, 16534, -2640,  3447, -4884,  9370, },
	{  1333, -4491, 10726, -21223,  9251, -14657, 21453, -29253,  9314, -11042, 12041, -11725,  4701, -2160, -2129,  8485, -8559, 14034, -20570, 27927, -17847, 21640, -24960, 27340, -14127, 13571, -11721,  8324, -1585, -1935,  6414, -11806,  8996, -12386, 15933, -19453, 11360, -12732, 13684, -14033,  6775, -5971,  4382, -1626,  -388,  1502, -4286, 27741, },
	{  3158, -6724, 11407, -16565,  5222, -5566,  4432,  -877, -1546,  4467, -8797, 14707, -11115, 15600, -20591, 25716, -15215, 17006, -17793, 17082, -7175,  4546,  -436, -5307,  6369, -10891, 16103, -21798, 13837, -16666, 19139, -20972, 10923, -10714,  9686, -7674,  2258,   -33, -2908,  6635, -5617,  8415, -11826, 16082, -2713,  3757, -5729, 12525, },
	{   247, -2538,  7789, -17429,  8224, -13839, 21325, -30528, 10224, -12843, 15074, -16350,  7977, -6529,  3386,  1881, -4817, 10050, -16654, 24505, -16655, 21292, -25821, 29797, -16343, 16943, -16378, 14331, -5254,  2335,  1670, -6787,  6487, -10056, 14000, -18174, 11193, -13199, 14965, -16321,  8531, -8464,  7772, -6142,   366,   457, -2672, 29224, },
	{  3359, -7373, 13074, -20117,  6876, -8349,  8742, -7096,   558,  1795, -5620, 11205, -9368, 14112, -19719, 25912, -16118, 19016, -21224, 22227, -10725,  9145, -6085,  1298,  2694, -7016, 12273, -18334, 12483, -15915, 19238, -22177, 12206, -12792, 12655, -11596,  4707, -2953,   433,  2962, -3684,  6488, -10053, 14686, -2633,  3869, -6319, 15688, },
	{  -999,  -226,  4122, -12299,  6637, -12149, 19932, -30078, 10581, -13977, 17362, -20217, 10920, -10683,  8903, -5058,  -674,  5362, -11660, 19572, -14471, 19711, -25223, 30608, -17677, 19426, -20208, 19657, -8706,  6568, -3275, -1269,  3552, -7101, 11225, -15827, 10382, -12923, 15420, -17733,  9847, -10549, 10836, -10496,  1139,  -696,  -654, 30176, },
	{  3359, -7626, 14090, -22734,  8235, -10813, 12787, -13236,  2735, -1108, -1973,  6903, -7007, 11750, -17673, 24618, -16121, 19995, -23538, 26246, -13760, 13347, -11537,  8000, -1228, -2644,  7649, -13739, 10383, -14236, 18238, -22141, 12819, -14184, 14964, -14941,  6941, -5770,  3829,  -971, -1489,  4133, -7643, 12390, -2397,  3761, -6595, 18764, },
	{ -2343,  2336,  -110, -6045,  4548, -9637, 17285, -27839, 10336, -14347, 18738, -23068, 13345, -14374, 14101, -11942,  3644,   218, -5844, 13370, -11395, 16955, -23162, 29684, -18032, 20857, -22970, 23981, -11737, 10518, -8141,  4440,   351, -3675,  7748, -12524,  8959, -11901, 15004, -18166, 10635, -12093, 13386, -14432,  1890, -1904,  1729, 30564, },
	{  3130, -7423, 14331, -24181,  9197, -12791, 16313, -18928,  4861, -4084,  1951,  2018, -4144,  8617, -14531, 21856, -15194, 19852, -24567, 28874, -16092, 16898, -16473, 14419, -5180,  1988,  2476, -8250,  7641, -11704, 16173, -20838, 12712, -14795, 16468, -17505,  8827, -8322,  7086, -4949,   851,  1470, -4713,  9288, -2010,  3427, -6508, 21653, },
	{  1964, -3706,  5008, -4692,   259,  2050, -6403, 13473, -5962,  9475, -13898, 19084, -12348, 15090, -17369, 18669, -9185,  7892, -5101,   485,  3109, -7576, 13151, -19717, 13517, -17361, 21127, -24483, 13516, -14166, 13956, -12648,  5010, -2939,    34,  3751, -4216,  6992, -10175, 13719, -8785, 10836, -12992, 15259, -2214,  2574, -3102,  4423, },
	{  2654, -6728, 13713, -24280,  9675, -14134, 19080, -23812,  6809, -6961,  5936, -3188,  -927,  4866, -10434, 17736, -13360, 18561, -24214, 29919, -17564, 19577, -20595, 20176, -8933,  6619, -2963, -2160,  4398, -8446, 13137, -18314, 11875, -14573, 17063, -19125, 10252, -10456, 10016, -8743,  3206, -1356, -1412,  5526, -1487,  2869, -6022, 24263, },
	{  2493, -4997,  7632, -9371,  2143,  -736, -2594,  8656, -4564,  8017, -12618, 18333, -12478, 16028, -19470, 22319, -11978, 11823, -10293,  6976,  -750, -3216,  8487, -15050, 11383, -15679, 20194, -24629, 14303, -15839, 16671, -16531,  7575, -6133,  3822,  -547, -1883,  4580, -7825, 11617, -7976, 10421, -13173, 16322, -2513,  3149, -4225,  7358, },
	{  1931, -5532, 12197, -22919,  9607, -14722, 20879, -27557,  8455, -9566,  9750, -8427,  2471,   691, -5585, 12448, -10693, 16158, -22455, 29273, -18069, 21205, -23645, 24925, -12269, 10984, -8362,  4195,   830, -4632,  9282, -14688, 10342, -13514, 16696, -19687, 11122, -12042, 12443, -12133,  5441, -4191,  2083,  1292,  -851,  2102, -5113, 26507, },
	{  2937, -6123, 10037, -13865,  4035, -3659,  1595,  3063, -2826,  6021, -10543, 16484, -11889, 16073, -20521, 24808, -14174, 15201, -15053, 13262, -4677,  1452,  3210, -9396,  8542, -13056, 18080, -23368, 14289, -16643, 18493, -19554,  9762, -9045,  7474, -4907,   609,  1852, -4973,  8799, -6689,  9396, -12603, 16485, -2682,  3575, -5201, 10455, },
	{   979, -3861,  9800, -20070,  8961, -14473, 21549, -29881,  9687, -11733, 13164, -13394,  5861, -3681,  -239,  6260, -7322, 12748, -19350, 26924, -17550, 21660, -25419, 28367, -14986, 14826, -13410, 10459, -2867,  -468,  4811, -10143,  8184, -11659, 15366, -19135, 11375, -12976, 14216, -14915,  7427, -6871,  5580, -3192,  -132,  1156, -3775, 28312, },
	{  3248, -6989, 12049, -17884,  5821, -6555,  5938, -3016,  -833,  3578, -7761, 13596, -10585, 15188, -20424, 25951, -15625, 17810, -19094, 18972, -8449,  6167, -2394, -3056,  5138, -9620, 14881, -20739, 13458, -16513, 19297, -21525, 11438, -11503, 10778, -9083,  3121, -1045, -1769,  5406, -4984,  7803, -11290, 15705, -2703,  3820, -5965, 13624, },
	{  -169, -1774,  6595, -15795,  7736, -13351, 20987, -30573, 10414, -13316, 15960, -17789,  9044, -8004,  5312,  -503, -3417,  8496, -15036, 22958, -16007, 20883, -25781, 30270, -16911, 17912, -17811, 16269, -6484,  3817,   -33, -4918,  5512, -9097, 13129, -17478, 10984, -13189, 15219, -16915,  9041, -9239,  8879, -7680,   633,    68, -2017, 29616, },
	{  3383, -7509, 13507, -21141,  7385, -9246, 10185, -9249,  1309,   809, -4401,  9796, -8615, 13390, -19141, 25634, -16224, 19477, -22161, 23761, -11844, 10658, -8011,  3626,  1354, -5547, 10751, -16861, 11836, -15436, 19016, -22308, 12497, -13357, 13537, -12830,  5511, -3948,  1612,  1620, -2949,  5716, -9286, 13989, -2569,  3857, -6453, 16768, },
	{ -1457,   639,  2711, -10248,  5967, -11369, 19155, -29506, 10566, -14195, 17949, -21330, 11827, -12025, 10755, -7468,   813,  3619, -9725, 17554, -13501, 18885, -24673, 30486, -17914, 20047, -21295, 21282, -9812,  7979, -4982,   701,  2466, -5959, 10092, -14785,  9956, -12653, 15376, -17997, 10183, -11150, 11785, -11918,  1404, -1111,   132, 30375, },
	{  3307, -7610, 14266, -23377,  8618, -11560, 14079, -15275,  3483, -2138,  -635,  5265, -6066, 10746, -16704, 23824, -15906, 20075, -24046, 27325, -14656, 14662, -13320, 10274, -2604, -1057,  5907, -11926,  9500, -13451, 17640, -21832, 12864, -14487, 15582, -15926,  7639, -6691,  4981, -2355,  -689,  3239, -6681, 11401, -2279,  3671, -6608, 19790, },
	{  1594, -2817,  3256, -1669,  -918,  3724, -8593, 16091, -6663, 10107, -14286, 18979, -11889, 14033, -15500, 15769, -7119,  5135, -1619, -3694,  5492, -10148, 15749, -22119, 14479, -17916, 21086, -23643, 12596, -12655, 11777, -9756,  3202,  -787, -2413,  6413, -5593,  8335, -11380, 14656, -9039, 10773, -12482, 14118, -1957,  2137, -2323,  2629, },
	{  2993, -7239, 14217, -24375,  9420, -13334, 17368, -20727,  5562, -5100,  3335,   238, -3062,  7380, -13211, 20576, -14659, 19535, -24604, 29423, -16705, 17934, -18006, 16505, -6513,  3604,   608, -6194,  6567, -10651, 15225, -20098, 12504, -14814, 16781, -18180,  9378, -9115,  8146, -6294,  1671,   503, -3604,  8052, -1843,  3259, -6387, 22592, },
	{  2154, -4165,  5931, -6315,   903,  1111, -5140, 11909, -5521,  9035, -13548, 18949, -12473, 15511, -18206, 20050, -10209,  9301, -6928,  2732,  1795, -6117, 11622, -18229, 12866, -16891, 20941, -24692, 13876, -14837, 14987, -14076,  5932, -4065,  1347,  2286, -3435,  6201, -9426, 13080, -8562, 10762, -13138, 15724, -2331,  2788, -3503,  5415, },
	{  2431, -6370, 13290, -23977,  9715, -14428, 19822, -25253,  7419, -7902,  7287, -5014,   238,  3458, -8829, 16026, -12525, 17851, -23763, 29890, -17853, 20267, -21784, 21951, -10146,  8173, -4852,    28,  3191, -7179, 11886, -17175, 11421, -14300, 17046, -19443, 10619, -11073, 10921, -9973,  4000, -2345,  -215,  4103, -1278,  2626, -5756, 25085, },
	{  2659, -5410,  8498, -10962,  2803, -1740, -1177,  6794, -3997,  7383, -11986, 17815, -12356, 16147, -19959, 23323, -12814, 13067, -12004,  9194, -2113, -1622,  6716, -13190, 10473, -14872, 19592, -24351, 14391, -16220, 17410, -17686,  8382, -7182,  5113, -2062, -1032,  3664, -6888, 10716, -7582, 10134, -13061, 16483, -2588,  3315, -4583,  8417, },
	{  1626, -5005, 11465, -22100,  9450, -14733, 21246, -28535,  8934, -10374, 10988, -10193,  3656,  -812, -3777, 10393, -9598, 15085, -21527, 28651, -18007, 21500, -24412, 26278, -13289, 12386, -10164,  6392,  -445, -3219,  7793, -13207,  9661, -12958, 16343, -19623, 11281, -12443, 13137, -13175,  6163, -5144,  3303,  -244,  -610,  1793, -4698, 27185, },
	{  3062, -6457, 10786, -15325,  4671, -4674,  3093,   998, -2160,  5220, -9654, 15597, -11517, 15872, -20621, 25363, -14767, 16201, -16547, 15321, -6012,  3092,  1292, -7262,  7418, -11950, 17089, -22608, 14094, -16706, 18891, -20364, 10406, -9955,  8668, -6386,  1483,   860, -3895,  7681, -6142,  8906, -12231, 16322, -2706,  3682, -5493, 11549, },
	{   601, -3182,  8777, -18746,  8602, -14184, 21498, -30314, 10000, -12354, 14212, -14995,  6996, -5196,  1675,  3966, -6021, 11362, -17984, 25727, -17130, 21531, -25709, 29209, -15749, 15991, -15021, 12539, -4139,  1014,  3163, -8397,  7311, -10846, 14690, -18685, 11313, -13134, 14655, -15704,  8033, -7734,  6755, -4758,   130,   793, -3213, 28822, },
	{  3317, -7212, 12624, -19112,  6393, -7518,  7432, -5174,  -103,  2649, -6655, 12376, -9975, 14667, -20114, 26010, -15933, 18502, -20278, 20750, -9678,  7760, -4353,  -763,  3861, -8272, 13547, -19530, 12983, -16247, 19324, -21936, 11879, -12220, 11804, -10440,  3970, -2057,  -609,  4130, -4312,  7132, -10671, 15215, -2674,  3857, -6168, 14720, },
	{  -602,  -970,  5319, -14009,  7183, -12760, 20496, -30406, 10534, -13705, 16748, -19124, 10062, -9443,  7225, -2911, -1978,  6866, -13298, 21238, -15244, 20327, -25564, 30541, -17368, 18768, -19133, 18111, -7679,  5284, -1749, -3002,  4492, -8068, 12161, -16657, 10699, -13088, 15372, -17399,  9495, -9959,  9939, -9189,   902,  -333, -1316, 29942, },
	{  3382, -7595, 13855, -22043,  7855, -10099, 11586, -11377,  2064,  -199, -3134,  8300, -7793, 12565, -18424, 25175, -16219, 19810, -22956, 25147, -12893, 12112, -9900,  5951,    -8, -4028,  9143, -15261, 11103, -14848, 18662, -22287, 12705, -13835, 14333, -13986,  6284, -4924,  2790,   254, -2186,  4896, -8446, 13187, -2486,  3818, -6547, 17833, },
	{ -1924,  1529,  1240, -8073,  5240, -10493, 18229, -28718, 10477, -14319, 18420, -22313, 12664, -13302, 12555, -9854,  2311,  1833, -7704, 15396, -12428, 17922, -23949, 30155, -18031, 20537, -22246, 22775, -10861,  9347, -6669,  2682,  1354, -4769,  8882, -13633,  9459, -12293, 15226, -18141, 10453, -11682, 12666, -13280,  1664, -1530,   960, 30506, },
	{  3226, -7537, 14345, -23872,  8949, -12243, 15299, -17246,  4220, -3171,   727,  3568, -5070,  9655, -15607, 22857, -15578, 20018, -24395, 28227, -15459, 15889, -15028, 12497, -3974,   550,  4110, -10018,  8545, -12567, 16917, -21372, 12823, -14694, 16098, -16810,  8291, -7574,  6110, -3734,   123,  2314, -5662, 10320, -2144,  3554, -6576, 20789, },
	{  1791, -3290,  4184, -3260,  -303,  2855, -7467, 14762, -6314,  9805, -14125, 19092, -12168, 14634, -16534, 17349, -8232,  6607, -3464, -1497,  4249, -8819, 14423, -20916, 14014, -17677, 21172, -24159, 13121, -13493, 12966, -11316,  4169, -1928, -1125,  5024, -4881,  7650, -10777, 14205, -8932, 10839, -12789, 14763, -2098,  2373, -2738,  3565, },
	{  2827, -6995, 13998, -24401,  9583, -13796, 18323, -22416,  6236, -6097,  4717, -1569, -1945,  6075, -11785, 19138, -14017, 19080, -24473, 29774, -17210, 18858, -19430, 18497, -7813,  5210, -1279, -4078,  5439, -9517, 14166, -19215, 12209, -14731, 16981, -18735,  9869, -9852,  9160, -7609,  2488,  -478, -2457,  6743, -1661,  3064, -6216, 23495, },
	{  2337, -4613,  6840, -7938,  1557,   143, -3816, 10232, -5034,  8526, -13099, 18682, -12514, 15831, -18929, 21310, -11175, 10662, -8727,  4984,   455, -4602, 10000, -16603, 12121, -16301, 20609, -24733, 14144, -15412, 15923, -15418,  6819, -5172,  2661,   794, -2624,  5362, -8608, 12346, -8278, 10614, -13196, 16087, -2434,  2986, -3891,  6434, },
	{  2179, -5952, 12759, -23496,  9689, -14627, 20440, -26544,  7988, -8803,  8608, -6830,  1417,  2008, -7143, 14185, -11596, 17011, -23144, 29655, -18021, 20825, -22834, 23591, -11300,  9685, -6723,  2233,  1951, -5853, 10544, -15911, 10885, -13927, 16913, -19631, 10917, -11620, 11759, -11146,  4774, -3328,   998,  2633, -1057,  2359, -5438, 25860, },
	{  2812, -5800,  9331, -12520,  3459, -2755,   278,  4850, -3392,  6688, -11262, 17167, -12147, 16157, -20317, 24179, -13571, 14234, -13652, 11372, -3475,    -2,  4883, -11224,  9483, -13956, 18852, -23905, 14381, -16493, 18036, -18728,  9138, -8190,  6378, -3574,  -167,  2716, -5896,  9734, -7133,  9775, -12859, 16534, -2645,  3462, -4920,  9490, },
	{  1294, -4423, 10628, -21103,  9222, -14642, 21471, -29332,  9358, -11122, 12169, -11913,  4831, -2329, -1920,  8241, -8425, 13896, -20442, 27825, -17820, 21650, -25019, 27463, -14227, 13714, -11912,  8563, -1728, -1773,  6239, -11626,  8909, -12310, 15876, -19424, 11365, -12763, 13748, -14135,  6850, -6072,  4516, -1800,  -360,  1464, -4232, 27807, },
	{  3169, -6756, 11482, -16716,  5290, -5677,  4599, -1113, -1468,  4370, -8685, 14589, -11061, 15560, -20580, 25751, -15265, 17100, -17943, 17297, -7319,  4727,  -653, -5060,  6235, -10754, 15973, -21688, 13800, -16655, 19163, -21040, 10984, -10805,  9811, -7832,  2355,  -145, -2782,  6501, -5549,  8350, -11771, 16046, -2713,  3765, -5757, 12647, },
	{   202, -2456,  7661, -17255,  8173, -13790, 21295, -30544, 10249, -12899, 15177, -16515,  8098, -6694,  3601,  1617, -4663,  9882, -16481, 24342, -16589, 21254, -25825, 29859, -16411, 17056, -16542, 14550, -5392,  2500,  1482, -6582,  6381, -9953, 13908, -18103, 11173, -13203, 14998, -16392,  8591, -8553,  7897, -6314,   395,   415, -2601, 29271, },
	{  3363, -7391, 13126, -20236,  6934, -8450,  8904, -7336,   641,  1687, -5487, 11053, -9288, 14037, -19661, 25890, -16135, 19074, -21335, 22404, -10853,  9316, -6301,  1556,  2547, -6856, 12109, -18177, 12416, -15867, 19220, -22199, 12242, -12859, 12757, -11737,  4797, -3064,   564,  2815, -3604,  6405, -9972, 14614, -2627,  3869, -6336, 15809, },
	{ -1050,  -131,  3968, -12077,  6566, -12068, 19853, -30025, 10583, -14006, 17433, -20347, 11024, -10835,  9111, -5327,  -509,  5171, -11450, 19355, -14369, 19627, -25171, 30605, -17710, 19502, -20335, 19844, -8831,  6726, -3465, -1051,  3433, -6977, 11103, -15717, 10338, -12898, 15421, -17768,  9887, -10619, 10944, -10656,  1169,  -742,  -569, 30201, },
	{  3355, -7627, 14114, -22812,  8280, -10899, 12934, -13465,  2818, -1222, -1826,  6724, -6905, 11643, -17572, 24539, -16103, 20010, -23602, 26374, -13864, 13497, -11738,  8255, -1381, -2469,  7459, -13543, 10289, -14153, 18178, -22114, 12828, -14222, 15038, -15055,  7020, -5874,  3958, -1125, -1401,  4035, -7539, 12284, -2384,  3753, -6599, 18879, },
	{ -2396,  2438,  -281, -5786,  4459, -9526, 17160, -27718, 10314, -14346, 18771, -23154, 13425, -14503, 14291, -12200,  3810,    14, -5608, 13110, -11260, 16828, -23054, 29614, -18025, 20889, -23053, 24123, -11843, 10661, -8323,  4660,   225, -3537,  7602, -12380,  8893, -11847, 14971, -18162, 10654, -12140, 13471, -14572,  1918, -1950,  1827, 30567, },
	{  3116, -7406, 14323, -24211,  9224, -12855, 16435, -19133,  4940, -4197,  2105,  1822, -4026,  8483, -14390, 21722, -15140, 19824, -24580, 28945, -16165, 17019, -16648, 14655, -5329,  2167,  2270, -8025,  7524, -11592, 16073, -20762, 12693, -14802, 16508, -17586,  8891, -8413,  7206, -5099,   942,  1364, -4592,  9154, -1992,  3410, -6497, 21759, },
	{  1985, -3757,  5111, -4872,   330,  1947, -6266, 13305, -5916,  9429, -13864, 19075, -12366, 15141, -17468, 18828, -9302,  8051, -5305,   734,  2964, -7417, 12986, -19559, 13449, -17315, 21114, -24514, 13560, -14245, 14075, -12811,  5114, -3065,   180,  3590, -4131,  6906, -10095, 13653, -8763, 10831, -13012, 15315, -2227,  2599, -3147,  4532, },
	{  2631, -6691, 13671, -24255,  9682, -14171, 19168, -23979,  6879, -7067,  6087, -3391,  -799,  4712, -10260, 17552, -13272, 18488, -24172, 29926, -17602, 19660, -20734, 20380, -9071,  6793, -3173, -1918,  4266, -8309, 13002, -18194, 11829, -14548, 17067, -19167, 10296, -10528, 10119, -8882,  3295, -1466, -1280,  5371, -1464,  2843, -5995, 24356, },
	{  2512, -5044,  7730, -9549,  2216,  -847, -2439,  8453, -4503,  7950, -12552, 18282, -12469, 16046, -19531, 22438, -12075, 11965, -10486,  7224,  -901, -3040,  8294, -14849, 11286, -15594, 20134, -24606, 14318, -15886, 16758, -16665,  7667, -6251,  3967,  -715, -1789,  4480, -7724, 11521, -7935, 10393, -13165, 16345, -2523,  3168, -4265,  7475, },
	{  1899, -5476, 12121, -22837,  9593, -14728, 20927, -27674,  8511, -9658,  9890, -8625,  2603,   525, -5387, 12225, -10576, 16045, -22360, 29214, -18068, 21245, -23738, 25083, -12386, 11143, -8564,  4440,   689, -4477,  9120, -14529, 10270, -13457, 16663, -19686, 11143, -12091, 12524, -12253,  5523, -4298,  2219,  1123,  -824,  2069, -5069, 26585, },
	{  2951, -6161, 10122, -14031,  4106, -3772,  1760,  2836, -2753,  5935, -10449, 16391, -11852, 16056, -20539, 24878, -14244, 15316, -15223, 13494, -4827,  1634,  2999, -9163,  8420, -12938, 17977, -23292, 14273, -16656, 18543, -19651,  9837, -9149,  7609, -5073,   706,  1742, -4855,  8678, -6631,  9345, -12566, 16473, -2685,  3588, -5235, 10576, },
	{   938, -3788,  9691, -19931,  8925, -14446, 21551, -29939,  9725, -11806, 13284, -13576,  5988, -3850,   -28,  6008, -7180, 12599, -19205, 26801, -17509, 21653, -25460, 28470, -15075, 14960, -13593, 10693, -3009,  -303,  4630, -9953,  8090, -11572, 15296, -19092, 11372, -12998, 14270, -15008,  7496, -6969,  5712, -3366,  -103,  1116, -3715, 28371, },
	{  3257, -7016, 12117, -18025,  5886, -6663,  6104, -3255,  -753,  3476, -7641, 13466, -10522, 15136, -20396, 25966, -15665, 17893, -19232, 19175, -8588,  6345, -2611, -2803,  4998, -9473, 14738, -20612, 13409, -16489, 19307, -21578, 11491, -11587, 10895, -9236,  3216, -1158, -1641,  5267, -4911,  7732, -11226, 15656, -2701,  3825, -5989, 13746, },
	{  -216, -1686,  6457, -15604,  7678, -13291, 20940, -30565, 10430, -13364, 16053, -17942,  9159, -8166,  5525,  -769, -3259,  8318, -14849, 22775, -15928, 20828, -25766, 30310, -16967, 18013, -17963, 16478, -6619,  3981,  -223, -4707,  5400, -8986, 13026, -17393, 10956, -13182, 15241, -16974,  9095, -9322,  9000, -7850,   663,    24, -1942, 29655, },
	{  3385, -7521, 13550, -21248,  7440, -9343, 10343, -9487,  1393,   698, -4263,  9634, -8527, 13303, -19068, 25592, -16228, 19521, -22256, 23922, -11964, 10823, -8223,  3885,  1203, -5381, 10577, -16689, 11759, -15376, 18983, -22313, 12524, -13414, 13630, -12963,  5599, -4057,  1743,  1469, -2865,  5627, -9196, 13905, -2560,  3854, -6465, 16887, },
	{ -1509,   737,  2550, -10012,  5889, -11276, 19059, -29429, 10560, -14214, 18007, -21446, 11923, -12171, 10957, -7734,   979,  3423, -9505, 17321, -13387, 18785, -24601, 30460, -17933, 20108, -21408, 21455, -9932,  8133, -5171,   921,  2343, -5829,  9962, -14662,  9904, -12617, 15364, -18019, 10216, -11213, 11887, -12073,  1433, -1158,   222, 30393, },
	{  3299, -7605, 14280, -23440,  8657, -11640, 14219, -15498,  3566, -2253,  -485,  5080, -5958, 10629, -16588, 23725, -15875, 20076, -24093, 27434, -14750, 14803, -13513, 10524, -2757,  -879,  5710, -11719,  9397, -13357, 17566, -21789, 12864, -14515, 15645, -16029,  7714, -6791,  5108, -2508,  -599,  3138, -6570, 11285, -2265,  3660, -6607, 19902, },
	{  1616, -2870,  3359, -1844,  -850,  3630, -8472, 15950, -6627, 10077, -14273, 18998, -11924, 14104, -15620, 15949, -7245,  5299, -1824, -3452,  5356, -10004, 15607, -21994, 14433, -17896, 21102, -23708, 12659, -12752, 11913, -9932,  3310,  -914, -2271,  6261, -5516,  8262, -11317, 14611, -9030, 10784, -12520, 14194, -1973,  2163, -2369,  2732, },
	{  2976, -7215, 14198, -24386,  9442, -13390, 17480, -20921,  5638, -5212,  3489,    38, -2940,  7238, -13058, 20423, -14593, 19491, -24598, 29471, -16767, 18043, -18170, 16731, -6659,  3783,   399, -5961,  6444, -10529, 15113, -20006, 12475, -14809, 16809, -18247,  9436, -9200,  8261, -6442,  1762,   394, -3478,  7910, -1824,  3238, -6370, 22695, },
	{  2174, -4216,  6033, -6495,   975,  1005, -4996, 11728, -5469,  8982, -13503, 18926, -12482, 15552, -18293, 20196, -10319,  9455, -7130,  2982,  1647, -5951, 11446, -18055, 12787, -16831, 20911, -24705, 13910, -14906, 15096, -14229,  6032, -4189,  1494,  2121, -3346,  6110, -9339, 13003, -8533, 10749, -13149, 15769, -2343,  2810, -3547,  5527, },
	{  2405, -6326, 13236, -23932,  9716, -14455, 19897, -25404,  7484, -8004,  7435, -5216,   369,  3299, -8645, 15827, -12427, 17764, -23702, 29874, -17877, 20336, -21908, 22140, -10277,  8344, -5061,   272,  3054, -7035, 11741, -17041, 11365, -14264, 17037, -19470, 10656, -11138, 11017, -10106,  4087, -2454,   -81,  3942, -1254,  2597, -5723, 25173, },
	{  2676, -5455,  8592, -11137,  2876, -1853, -1017,  6582, -3931,  7309, -11910, 17750, -12337, 16154, -20005, 23426, -12902, 13200, -12191,  9439, -2264, -1443,  6516, -12977, 10367, -14775, 19517, -24310, 14395, -16256, 17485, -17807,  8468, -7296,  5255, -2230,  -936,  3560, -6780, 10611, -7535, 10097, -13043, 16495, -2595,  3332, -4621,  8535, },
	{  1591, -4943, 11377, -21998,  9428, -14728, 21278, -28632,  8984, -10460, 11122, -10387,  3787,  -980, -3573, 10158, -9471, 14958, -21415, 28569, -17992, 21524, -24488, 26418, -13398, 12537, -10362,  6635,  -588, -3060,  7623, -13036,  9581, -12890, 16297, -19607, 11294, -12483, 13209, -13286,  6241, -5249,  3439,  -416,  -582,  1758, -4649, 27257, },
	{  3074, -6492, 10866, -15483,  4741, -4786,  3260,   765, -2084,  5128, -9551, 15490, -11470, 15843, -20623, 25415, -14827, 16306, -16707, 15545, -6159,  3274,  1077, -7021,  7290, -11822, 16971, -22514, 14066, -16706, 18928, -20446, 10474, -10053,  8797, -6549,  1580,   749, -3773,  7553, -6078,  8848, -12184, 16297, -2708,  3692, -5524, 11671, },
	{   558, -3103,  8657, -18588,  8557, -14145, 21482, -30350, 10031, -12419, 14323, -15168,  7120, -5363,  1888,  3707, -5872, 11202, -17824, 25582, -17076, 21508, -25730, 29291, -15828, 16114, -15195, 12766, -4279,  1179,  2978, -8199,  7210, -10751, 14608, -18626, 11301, -13146, 14698, -15785,  8098, -7827,  6883, -4932,   159,   751, -3147, 28875, },
	{  3323, -7234, 12684, -19242,  6455, -7624,  7597, -5415,   -21,  2544, -6528, 12234, -9903, 14602, -20071, 26005, -15961, 18571, -20402, 20940, -9811,  7935, -4570,  -506,  3717, -8118, 13392, -19386, 12924, -16210, 19319, -21972, 11923, -12295, 11913, -10587,  4063, -2170,  -480,  3986, -4235,  7054, -10597, 15153, -2670,  3860, -6189, 14841, },
	{  -651,  -878,  5173, -13801,  7117, -12688, 20432, -30375, 10543, -13743, 16830, -19266, 10172, -9600,  7436, -3179, -1816,  6680, -13098, 21037, -15152, 20256, -25529, 30558, -17411, 18855, -19272, 18309, -7809,  5446, -1940, -2787,  4376, -7950, 12048, -16559, 10662, -13072, 15382, -17446,  9541, -10036, 10054, -9354,   931,  -378, -1235, 29974, },
	{  3381, -7601, 13888, -22135,  7904, -10190, 11739, -11611,  2148,  -312, -2990,  8128, -7697, 12467, -18336, 25113, -16211, 19839, -23035, 25291, -13005, 12270, -10107,  6208,  -160, -3857,  8959, -15075, 11017, -14776, 18615, -22276, 12723, -13883, 14416, -14109,  6368, -5031,  2920,   101, -2100,  4803, -8349, 13092, -2475,  3812, -6554, 17950, },
	{ -1976,  1629,  1073, -7824,  5156, -10390, 18118, -28618, 10463, -14327, 18465, -22413, 12753, -13439, 12751, -10117,  2478,  1632, -7474, 15148, -12303, 17807, -23858, 30105, -18036, 20583, -22343, 22932, -10973,  9496, -6854,  2902,  1230, -4634,  8743, -13499,  9399, -12248, 15203, -18150, 10479, -11737, 12760, -13427,  1693, -1577,  1054, 30516, },
	{  3215, -7525, 14348, -23918,  8982, -12315, 15429, -17460,  4301, -3285,   880,  3376, -4956,  9529, -15478, 22739, -15535, 20004, -24423, 28316, -15543, 16020, -15212, 12740, -4126,   730,  3907, -9800,  8435, -12463, 16829, -21312, 12812, -14711, 16149, -16902,  8360, -7670,  6233, -3886,   214,  2209, -5545, 10195, -2128,  3539, -6570, 20899, },
	{  1813, -3342,  4287, -3438,  -233,  2756, -7337, 14606, -6272,  9767, -14101, 19097, -12194, 14695, -16643, 17518, -8353,  6769, -3669, -1250,  4108, -8667, 14269, -20773, 13957, -17643, 21172, -24206, 13174, -13581, 13093, -11486,  4275, -2055,  -981,  4866, -4800,  7570, -10705, 14149, -8916, 10842, -12818, 14829, -2113,  2399, -2784,  3671, },
	{  2807, -6964, 13967, -24393,  9598, -13842, 18422, -22596,  6309, -6206,  4870, -1771, -1819,  5926, -11620, 18969, -13939, 19021, -24448, 29801, -17259, 18953, -19581, 18711, -7955,  5387, -1490, -3840,  5311, -9386, 14042, -19108, 12171, -14716, 16997, -18789,  9919, -9931,  9269, -7752,  2578,  -588, -2328,  6594, -1640,  3040, -6194, 23593, },
	{  2357, -4662,  6940, -8118,  1630,    34, -3666, 10040, -4977,  8466, -13043, 18644, -12513, 15860, -19002, 21442, -11278, 10810, -8925,  5233,   305, -4430,  9814, -16414, 12032, -16228, 20563, -24728, 14168, -15470, 16021, -15561,  6915, -5293,  2807,   627, -2532,  5266, -8513, 12259, -8243, 10593, -13197, 16121, -2445,  3007, -3934,  6549, },
	{  2150, -5902, 12693, -23432,  9682, -14643, 20500, -26678,  8048, -8901,  8753, -7031,  1549,  1844, -6951, 13973, -11487, 16910, -23065, 29616, -18033, 20878, -22942, 23764, -11424,  9850, -6930,  2478,  1812, -5703, 10390, -15763, 10820, -13880, 16891, -19644, 10946, -11676, 11848, -11272,  4859, -3436,  1133,  2467, -1032,  2328, -5400, 25943, },
	{  2828, -5841,  9421, -12690,  3531, -2868,   442,  4629, -3323,  6607, -11176, 17087, -12119, 16152, -20348, 24264, -13650, 14358, -13830, 11611, -3626,   180,  4676, -10999,  9369, -13848, 18761, -23845, 14374, -16517, 18098, -18837,  9218, -8299,  6517, -3741,   -70,  2609, -5782,  9621, -7080,  9730, -12830, 16533, -2651,  3477, -4957,  9611, },
	{  1256, -4355, 10529, -20982,  9193, -14625, 21487, -29409,  9402, -11202, 12297, -12101,  4960, -2498, -1712,  7997, -8290, 13757, -20312, 27721, -17792, 21657, -25076, 27584, -14326, 13857, -12103,  8802, -1871, -1610,  6062, -11444,  8821, -12232, 15817, -19394, 11370, -12793, 13810, -14237,  6924, -6174,  4650, -1974,  -332,  1426, -4177, 27873, },
	{  3180, -6786, 11556, -16865,  5357, -5788,  4767, -1350, -1389,  4273, -8573, 14470, -11005, 15518, -20566, 25783, -15315, 17194, -18092, 17511, -7462,  4908,  -870, -4811,  6100, -10615, 15841, -21576, 13761, -16642, 19186, -21107, 11044, -10895,  9934, -7991,  2451,  -258, -2657,  6366, -5480,  8284, -11715, 16008, -2712,  3773, -5784, 12769, },
	{   156, -2372,  7531, -17080,  8122, -13739, 21263, -30556, 10272, -12955, 15279, -16678,  8218, -6859,  3815,  1354, -4510,  9712, -16306, 24176, -16521, 21214, -25827, 29919, -16478, 17168, -16705, 14769, -5530,  2665,  1293, -6376,  6274, -9849, 13815, -18030, 11153, -13205, 15030, -16462,  8649, -8641,  8022, -6486,   425,   372, -2530, 29317, },
	{  3366, -7408, 13177, -20355,  6992, -8552,  9066, -7576,   724,  1578, -5353, 10900, -9207, 13961, -19602, 25866, -16151, 19129, -21444, 22580, -10979,  9486, -6516,  1815,  2399, -6695, 11943, -18018, 12347, -15818, 19200, -22219, 12278, -12925, 12858, -11876,  4888, -3175,   695,  2666, -3523,  6321, -9889, 14541, -2620,  3868, -6352, 15929, },
	{ -1100,   -36,  3814, -11854,  6494, -11984, 19772, -29970, 10584, -14033, 17502, -20475, 11127, -10987,  9318, -5595,  -345,  4979, -11239, 19137, -14265, 19540, -25116, 30599, -17740, 19576, -20461, 20029, -8956,  6885, -3655,  -833,  3314, -6852, 10980, -15605, 10294, -12871, 15420, -17802,  9927, -10688, 11052, -10816,  1198,  -788,  -483, 30226, },
	{  3350, -7628, 14137, -22889,  8324, -10984, 13080, -13694,  2902, -1337, -1678,  6545, -6803, 11535, -17469, 24457, -16083, 20024, -23664, 26501, -13967, 13646, -11939,  8509, -1534, -2293,  7267, -13345, 10193, -14070, 18116, -22085, 12836, -14259, 15110, -15168,  7100, -5978,  4086, -1279, -1313,  3937, -7435, 12178, -2372,  3744, -6602, 18994, },
	{ -2449,  2540,  -453, -5525,  4369, -9413, 17032, -27593, 10292, -14342, 18803, -23239, 13505, -14632, 14479, -12458,  3976,  -189, -5371, 12849, -11125, 16698, -22944, 29541, -18017, 20920, -23133, 24264, -11948, 10804, -8504,  4878,    99, -3398,  7456, -12235,  8826, -11793, 14936, -18157, 10672, -12186, 13556, -14710,  1946, -1997,  1926, 30570, },
	{  3102, -7388, 14315, -24238,  9251, -12918, 16556, -19337,  5019, -4311,  2259,  1626, -3907,  8348, -14247, 21585, -15085, 19794, -24590, 29013, -16237, 17138, -16822, 14890, -5478,  2347,  2063, -7799,  7407, -11478, 15972, -20686, 12673, -14808, 16547, -17665,  8955, -8503,  7325, -5250,  1033,  1257, -4470,  9020, -1974,  3392, -6485, 21865, },
	{  2006, -3809,  5214, -5052,   401,  1844, -6128, 13136, -5869,  9383, -13829, 19065, -12383, 15192, -17565, 18986, -9417,  8209, -5509,   983,  2820, -7257, 12820, -19399, 13381, -17267, 21098, -24544, 13604, -14323, 14192, -12972,  5218, -3191,   326,  3428, -4045,  6821, -10015, 13586, -8741, 10826, -13032, 15370, -2241,  2623, -3192,  4641, },
	{  2607, -6653, 13628, -24228,  9689, -14207, 19255, -24144,  6948, -7173,  6238, -3594,  -670,  4557, -10085, 17368, -13183, 18414, -24128, 29930, -17639, 19742, -20871, 20581, -9207,  6967, -3384, -1676,  4133, -8170, 12867, -18072, 11782, -14521, 17070, -19207, 10339, -10599, 10222, -9021,  3384, -1576, -1148,  5215, -1442,  2817, -5967, 24449, },
	{  2531, -5091,  7827, -9727,  2289,  -958, -2283,  8250, -4441,  7882, -12485, 18229, -12458, 16064, -19590, 22555, -12170, 12106, -10678,  7472, -1052, -2864,  8100, -14646, 11188, -15509, 20072, -24582, 14331, -15933, 16845, -16797,  7758, -6369,  4111,  -883, -1695,  4380, -7622, 11424, -7894, 10363, -13156, 16367, -2531,  3187, -4306,  7592, },
	{  1866, -5420, 12043, -22752,  9578, -14733, 20973, -27789,  8566, -9750, 10030, -8823,  2735,   359, -5188, 12000, -10457, 15930, -22263, 29153, -18066, 21283, -23829, 25240, -12503, 11301, -8766,  4685,   548, -4321,  8957, -14368, 10197, -13398, 16628, -19684, 11164, -12138, 12604, -12371,  5604, -4404,  2354,   953,  -798,  2036, -5025, 26662, },
	{  2966, -6200, 10208, -14195,  4178, -3885,  1926,  2609, -2680,  5848, -10353, 16297, -11814, 16038, -20556, 24946, -14313, 15431, -15393, 13726, -4976,  1816,  2787, -8929,  8298, -12818, 17871, -23213, 14254, -16667, 18592, -19745,  9911, -9252,  7743, -5238,   803,  1633, -4737,  8556, -6572,  9293, -12528, 16459, -2689,  3601, -5269, 10698, },
	{   897, -3715,  9581, -19791,  8887, -14418, 21551, -29995,  9762, -11878, 13403, -13756,  6115, -4019,   184,  5755, -7038, 12449, -19059, 26675, -17467, 21644, -25498, 28571, -15164, 15093, -13775, 10926, -3151,  -139,  4449, -9761,  7995, -11485, 15225, -19047, 11368, -13018, 14322, -15099,  7565, -7066,  5843, -3540,   -74,  1076, -3654, 28430, },
	{  3265, -7042, 12183, -18165,  5951, -6771,  6271, -3495,  -672,  3375, -7521, 13335, -10457, 15082, -20367, 25979, -15703, 17974, -19368, 19377, -8727,  6523, -2829, -2549,  4858, -9326, 14593, -20483, 13360, -16464, 19315, -21629, 11543, -11669, 11012, -9389,  3311, -1270, -1513,  5126, -4838,  7659, -11160, 15605, -2698,  3830, -6013, 13868, },
	{  -264, -1598,  6318, -15411,  7619, -13229, 20891, -30555, 10446, -13410, 16144, -18095,  9274, -8327,  5739, -1036, -3100,  8140, -14660, 22590, -15847, 20772, -25748, 30348, -17022, 18113, -18114, 16687, -6753,  4145,  -414, -4496,  5289, -8874, 12922, -17306, 10927, -13174, 15262, -17032,  9147, -9404,  9119, -8019,   693,   -20, -1865, 29694, },
	{  3385, -7533, 13592, -21353,  7493, -9440, 10501, -9725,  1477,   586, -4124,  9471, -8438, 13215, -18994, 25547, -16232, 19563, -22350, 24082, -12084, 10987, -8435,  4144,  1053, -5214, 10401, -16516, 11681, -15314, 18948, -22317, 12551, -13471, 13722, -13094,  5686, -4167,  1874,  1318, -2781,  5538, -9105, 13820, -2552,  3851, -6477, 17006, },
	{ -1560,   835,  2389, -9775,  5810, -11182, 18962, -29350, 10553, -14231, 18064, -21560, 12019, -12315, 11160, -8001,  1145,  3226, -9283, 17086, -13271, 18683, -24527, 30431, -17951, 20168, -21519, 21626, -10051,  8287, -5359,  1141,  2221, -5699,  9830, -14538,  9851, -12580, 15352, -18040, 10249, -11275, 11987, -12226,  1462, -1204,   313, 30410, },
	{  3292, -7599, 14292, -23501,  8696, -11718, 14357, -15720,  3648, -2368,  -334,  4893, -5849, 10511, -16471, 23624, -15842, 20074, -24137, 27541, -14842, 14943, -13706, 10773, -2910,  -701,  5512, -11510,  9294, -13263, 17490, -21743, 12863, -14542, 15706, -16132,  7788, -6891,  5235, -2662,  -509,  3036, -6459, 11168, -2251,  3648, -6605, 20014, },
	{  1638, -2923,  3462, -2020,  -783,  3535, -8349, 15807, -6590, 10046, -14259, 19015, -11958, 14174, -15738, 16128, -7370,  5464, -2029, -3209,  5220, -9859, 15464, -21866, 14385, -17874, 21117, -23771, 12720, -12848, 12048, -10108,  3418, -1040, -2129,  6108, -5439,  8188, -11253, 14565, -9020, 10794, -12557, 14269, -1989,  2190, -2416,  2834, },
	{  2959, -7190, 14177, -24396,  9462, -13444, 17589, -21113,  5714, -5323,  3643,  -162, -2817,  7095, -12903, 20269, -14526, 19445, -24590, 29518, -16827, 18150, -18332, 16956, -6805,  3962,   190, -5728,  6321, -10406, 14999, -19914, 12446, -14804, 16835, -18313,  9492, -9284,  8376, -6589,  1853,   285, -3352,  7767, -1804,  3217, -6353, 22796, },
	{  2195, -4266,  6134, -6676,  1048,   898, -4851, 11546, -5417,  8928, -13457, 18901, -12489, 15591, -18377, 20341, -10429,  9608, -7331,  3233,  1499, -5785, 11270, -17879, 12708, -16770, 20879, -24716, 13944, -14973, 15203, -14382,  6132, -4313,  1640,  1956, -3257,  6019, -9251, 12925, -8504, 10736, -13159, 15813, -2355,  2833, -3590,  5640, },
	{  2378, -6282, 13181, -23885,  9715, -14480, 19970, -25553,  7549, -8106,  7584, -5418,   499,  3139, -8461, 15627, -12327, 17675, -23640, 29855, -17901, 20403, -22030, 22327, -10408,  8513, -5270,   517,  2918, -6889, 11595, -16905, 11309, -14226, 17027, -19496, 10692, -11201, 11113, -10239,  4174, -2564,    54,  3780, -1230,  2569, -5690, 25261, },
	{  2694, -5499,  8686, -11312,  2949, -1965,  -856,  6369, -3866,  7234, -11833, 17683, -12317, 16159, -20050, 23526, -12989, 13333, -12376,  9682, -2416, -1264,  6314, -12762, 10260, -14677, 19440, -24267, 14397, -16290, 17559, -17928,  8554, -7410,  5396, -2398,  -840,  3456, -6672, 10505, -7487, 10060, -13024, 16504, -2602,  3350, -4660,  8654, },
	{  1555, -4881, 11288, -21894,  9405, -14722, 21308, -28728,  9033, -10545, 11256, -10580,  3918, -1149, -3368,  9922, -9344, 14830, -21300, 28485, -17976, 21546, -24561, 26556, -13505, 12687, -10558,  6878,  -730, -2900,  7453, -12864,  9500, -12822, 16249, -19590, 11307, -12522, 13280, -13395,  6319, -5353,  3574,  -588,  -555,  1722, -4599, 27328, },
	{  3087, -6526, 10946, -15640,  4810, -4898,  3427,   532, -2008,  5036, -9446, 15383, -11423, 15813, -20624, 25464, -14886, 16409, -16866, 15768, -6305,  3456,   862, -6778,  7160, -11692, 16852, -22418, 14037, -16704, 18963, -20526, 10540, -10150,  8926, -6711,  1678,   637, -3651,  7424, -6014,  8788, -12136, 16271, -2709,  3702, -5554, 11793, },
	{   514, -3024,  8537, -18429,  8512, -14106, 21466, -30383, 10061, -12482, 14434, -15340,  7244, -5531,  2102,  3448, -5724, 11040, -17662, 25435, -17020, 21483, -25750, 29371, -15905, 16236, -15367, 12993, -4419,  1345,  2792, -8000,  7109, -10654, 14525, -18566, 11289, -13157, 14740, -15866,  8161, -7920,  7012, -5105,   188,   710, -3081, 28927, },
	{  3329, -7256, 12742, -19371,  6516, -7729,  7761, -5655,    61,  2438, -6401, 12091, -9829, 14536, -20026, 25999, -15987, 18639, -20524, 21129, -9944,  8110, -4787,  -249,  3572, -7963, 13236, -19241, 12865, -16172, 19313, -22007, 11967, -12369, 12022, -10734,  4156, -2282,  -350,  3841, -4158,  6975, -10522, 15091, -2665,  3862, -6209, 14963, },
	{  -701,  -786,  5025, -13591,  7051, -12615, 20366, -30340, 10551, -13780, 16910, -19406, 10281, -9757,  7646, -3447, -1654,  6494, -12896, 20833, -15059, 20184, -25492, 30573, -17454, 18942, -19411, 18506, -7939,  5607, -2130, -2571,  4259, -7831, 11934, -16459, 10625, -13054, 15392, -17491,  9587, -10111, 10168, -9519,   961,  -423, -1154, 30005, },
	{  3379, -7607, 13920, -22226,  7953, -10281, 11891, -11845,  2232,  -426, -2846,  7956, -7601, 12368, -18246, 25049, -16203, 19866, -23113, 25434, -13116, 12426, -10313,  6465,  -312, -3685,  8775, -14889, 10929, -14702, 18566, -22262, 12740, -13929, 14498, -14231,  6451, -5138,  3050,   -52, -2013,  4709, -8250, 12995, -2465,  3806, -6562, 18067, },
	{ -2029,  1730,   906, -7574,  5071, -10286, 18004, -28514, 10447, -14333, 18509, -22512, 12840, -13576, 12947, -10379,  2644,  1431, -7244, 14898, -12177, 17690, -23765, 30052, -18040, 20627, -22438, 23087, -11085,  9644, -7040,  3122,  1105, -4498,  8603, -13363,  9339, -12202, 15178, -18157, 10504, -11791, 12852, -13574,  1721, -1623,  1149, 30525, },
	{  3204, -7513, 14349, -23961,  9015, -12385, 15559, -17673,  4382, -3400,  1032,  3184, -4842,  9401, -15347, 22619, -15490, 19987, -24450, 28403, -15625, 16149, -15396, 12983, -4277,   909,  3704, -9582,  8324, -12358, 16740, -21249, 12801, -14726, 16199, -16992,  8429, -7765,  6356, -4039,   305,  2105, -5428, 10068, -2112,  3524, -6563, 21008, },
	{  1835, -3394,  4390, -3617,  -163,  2657, -7206, 14449, -6230,  9728, -14076, 19100, -12219, 14755, -16751, 17687, -8474,  6931, -3874, -1003,  3967, -8514, 14113, -20627, 13897, -17607, 21171, -24252, 13226, -13667, 13219, -11654,  4381, -2181,  -837,  4709, -4718,  7489, -10632, 14091, -8900, 10844, -12846, 14894, -2128,  2425, -2830,  3777, },
	{  2786, -6933, 13934, -24384,  9611, -13887, 18520, -22775,  6382, -6315,  5023, -1973, -1692,  5777, -11454, 18798, -13860, 18960, -24421, 29826, -17307, 19047, -19730, 18925, -8096,  5564, -1700, -3602,  5182, -9255, 13916, -19000, 12132, -14699, 17010, -18842,  9969, -10008,  9378, -7895,  2668,  -698, -2198,  6444, -1618,  3017, -6171, 23690, },
	{  2377, -4710,  7040, -8297,  1703,   -75, -3515,  9845, -4919,  8404, -12986, 18605, -12511, 15888, -19074, 21572, -11381, 10957, -9122,  5483,   155, -4258,  9628, -16224, 11943, -16154, 20516, -24720, 14191, -15526, 16118, -15704,  7011, -5414,  2952,   460, -2440,  5170, -8417, 12170, -8207, 10571, -13197, 16154, -2455,  3028, -3976,  6663, },
	{  2120, -5852, 12626, -23365,  9673, -14658, 20559, -26810,  8108, -8998,  8897, -7231,  1681,  1681, -6758, 13759, -11376, 16807, -22984, 29575, -18043, 20930, -23048, 23935, -11548, 10014, -7136,  2724,  1673, -5552, 10234, -15614, 10755, -13831, 16867, -19655, 10974, -11731, 11936, -11398,  4943, -3544,  1269,  2300, -1006,  2296, -5361, 26026, },
	{  2844, -5883,  9510, -12860,  3603, -2981,   605,  4408, -3253,  6525, -11089, 17006, -12089, 16145, -20378, 24348, -13728, 14482, -14008, 11849, -3777,   361,  4468, -10774,  9253, -13739, 18669, -23783, 14365, -16539, 18159, -18944,  9298, -8407,  6655, -3908,    27,  2502, -5669,  9506, -7026,  9685, -12801, 16530, -2656,  3492, -4992,  9731, },
	{  1217, -4287, 10429, -20858,  9162, -14608, 21502, -29484,  9445, -11280, 12423, -12288,  5090, -2667, -1503,  7752, -8154, 13617, -20180, 27615, -17762, 21663, -25131, 27702, -14423, 13999, -12292,  9040, -2013, -1448,  5886, -11261,  8732, -12153, 15757, -19362, 11373, -12822, 13872, -14337,  6997, -6274,  4783, -2147,  -303,  1388, -4121, 27938, },
	{  3190, -6817, 11628, -17014,  5424, -5898,  4934, -1587, -1311,  4175, -8460, 14349, -10948, 15475, -20551, 25814, -15363, 17286, -18239, 17724, -7604,  5088, -1087, -4562,  5964, -10476, 15708, -21462, 13721, -16628, 19206, -21172, 11103, -10985, 10057, -8148,  2547,  -370, -2531,  6231, -5411,  8218, -11657, 15969, -2712,  3781, -5811, 12891, },
	{   111, -2288,  7401, -16902,  8069, -13688, 21229, -30567, 10295, -13010, 15380, -16840,  8338, -7024,  4029,  1090, -4355,  9541, -16129, 24009, -16452, 21172, -25827, 29977, -16544, 17278, -16867, 14987, -5667,  2830,  1104, -6170,  6167, -9744, 13721, -17956, 11132, -13206, 15061, -16531,  8707, -8728,  8146, -6658,   455,   329, -2459, 29362, },
	{  3370, -7424, 13228, -20471,  7050, -8653,  9227, -7816,   807,  1469, -5219, 10745, -9125, 13883, -19542, 25839, -16165, 19184, -21551, 22754, -11105,  9655, -6730,  2073,  2250, -6533, 11776, -17858, 12277, -15767, 19179, -22238, 12312, -12990, 12958, -12015,  4978, -3286,   826,  2518, -3442,  6236, -9806, 14466, -2614,  3868, -6368, 16050, },
	{ -1151,    60,  3659, -11630,  6421, -11900, 19689, -29912, 10584, -14060, 17570, -20602, 11230, -11137,  9525, -5863,  -180,  4787, -11026, 18916, -14159, 19452, -25059, 30591, -17770, 19648, -20585, 20213, -9080,  7042, -3846,  -614,  3193, -6726, 10857, -15492, 10248, -12843, 15417, -17834,  9966, -10757, 11159, -10976,  1228,  -834,  -397, 30250, },
	{  3345, -7627, 14159, -22964,  8368, -11069, 13226, -13922,  2985, -1451, -1530,  6364, -6699, 11426, -17364, 24373, -16062, 20037, -23724, 26625, -14069, 13795, -12139,  8763, -1687, -2118,  7075, -13146, 10097, -13985, 18053, -22055, 12843, -14295, 15181, -15280,  7178, -6081,  4215, -1432, -1224,  3839, -7329, 12070, -2359,  3734, -6604, 19108, },
	{ -2501,  2642,  -626, -5264,  4279, -9299, 16903, -27466, 10268, -14338, 18833, -23322, 13583, -14759, 14666, -12715,  4142,  -393, -5133, 12586, -10989, 16567, -22833, 29465, -18007, 20949, -23211, 24402, -12051, 10945, -8684,  5097,   -27, -3258,  7309, -12088,  8758, -11737, 14900, -18150, 10689, -12231, 13639, -14848,  1973, -2044,  2025, 30572, },
	{  3088, -7369, 14305, -24264,  9278, -12981, 16676, -19539,  5097, -4424,  2412,  1429, -3788,  8213, -14103, 21447, -15028, 19762, -24598, 29079, -16308, 17256, -16995, 15124, -5627,  2527,  1856, -7572,  7289, -11363, 15870, -20607, 12652, -14812, 16585, -17743,  9017, -8592,  7444, -5400,  1124,  1150, -4348,  8884, -1956,  3374, -6473, 21970, },
	{  2028, -3860,  5317, -5233,   472,  1740, -5989, 12965, -5821,  9336, -13792, 19053, -12399, 15241, -17661, 19142, -9533,  8366, -5713,  1232,  2674, -7097, 12652, -19237, 13311, -17218, 21081, -24571, 13646, -14400, 14309, -13133,  5321, -3316,   471,  3266, -3959,  6734, -9933, 13517, -8718, 10819, -13050, 15425, -2254,  2647, -3237,  4750, },
	{  2583, -6615, 13584, -24198,  9696, -14242, 19341, -24308,  7017, -7279,  6389, -3797,  -541,  4402, -9908, 17181, -13092, 18339, -24082, 29932, -17674, 19821, -21006, 20782, -9344,  7141, -3594, -1434,  4000, -8031, 12730, -17949, 11733, -14493, 17071, -19245, 10382, -10670, 10324, -9159,  3472, -1686, -1015,  5058, -1419,  2791, -5939, 24542, },
	{  2549, -5137,  7924, -9905,  2363, -1069, -2127,  8045, -4379,  7813, -12417, 18175, -12447, 16080, -19647, 22670, -12265, 12246, -10870,  7719, -1204, -2688,  7905, -14442, 11089, -15422, 20009, -24555, 14343, -15978, 16929, -16928,  7849, -6487,  4255, -1051, -1601,  4279, -7519, 11326, -7851, 10333, -13145, 16388, -2540,  3206, -4346,  7709, },
	{  1833, -5363, 11965, -22666,  9563, -14737, 21017, -27902,  8620, -9841, 10168, -9020,  2867,   192, -4989, 11775, -10337, 15814, -22164, 29088, -18062, 21319, -23918, 25394, -12618, 11459, -8968,  4930,   406, -4165,  8793, -14206, 10123, -13339, 16591, -19680, 11183, -12185, 12683, -12489,  5685, -4511,  2490,   783,  -771,  2002, -4980, 26739, },
	{  2980, -6238, 10292, -14359,  4249, -3998,  2092,  2380, -2607,  5760, -10256, 16202, -11774, 16019, -20570, 25012, -14382, 15545, -15561, 13957, -5125,  1999,  2575, -8693,  8174, -12698, 17764, -23133, 14235, -16677, 18639, -19839,  9984, -9355,  7877, -5403,   900,  1523, -4618,  8433, -6512,  9240, -12489, 16443, -2692,  3613, -5302, 10819, },
	{   855, -3640,  9470, -19648,  8849, -14389, 21549, -30048,  9799, -11948, 13522, -13936,  6242, -4187,   396,  5502, -6895, 12297, -18911, 26547, -17424, 21634, -25535, 28669, -15251, 15225, -13956, 11159, -3292,    25,  4267, -9569,  7900, -11397, 15153, -19000, 11363, -13038, 14373, -15189,  7634, -7163,  5975, -3714,   -45,  1036, -3593, 28489, },
	{  3273, -7068, 12249, -18304,  6015, -6879,  6437, -3734,  -592,  3272, -7400, 13202, -10391, 15027, -20336, 25990, -15739, 18054, -19502, 19577, -8864,  6701, -3047, -2295,  4717, -9178, 14448, -20352, 13310, -16437, 19321, -21678, 11594, -11751, 11127, -9541,  3406, -1383, -1385,  4986, -4764,  7586, -11093, 15554, -2695,  3835, -6037, 13990, },
	{  -312, -1510,  6179, -15216,  7559, -13166, 20840, -30541, 10461, -13456, 16234, -18246,  9389, -8488,  5952, -1304, -2941,  7960, -14469, 22403, -15765, 20714, -25729, 30383, -17075, 18211, -18264, 16894, -6887,  4308,  -604, -4284,  5176, -8761, 12817, -17218, 10897, -13165, 15282, -17089,  9199, -9485,  9238, -8187,   723,   -65, -1789, 29732, },
	{  3386, -7543, 13632, -21456,  7546, -9536, 10657, -9962,  1561,   475, -3984,  9307, -8348, 13126, -18917, 25501, -16234, 19603, -22442, 24239, -12202, 11150, -8646,  4402,   902, -5046, 10224, -16341, 11601, -15252, 18912, -22318, 12576, -13526, 13812, -13225,  5773, -4276,  2005,  1166, -2697,  5448, -9014, 13734, -2543,  3847, -6488, 17125, },
	{ -1612,   934,  2227, -9536,  5731, -11087, 18863, -29267, 10544, -14247, 18119, -21673, 12114, -12459, 11361, -8267,  1312,  3028, -9060, 16850, -13154, 18579, -24451, 30399, -17967, 20225, -21628, 21795, -10169,  8440, -5548,  1361,  2098, -5568,  9697, -14412,  9798, -12543, 15338, -18059, 10280, -11336, 12087, -12379,  1491, -1250,   404, 30426, },
	{  3283, -7592, 14304, -23559,  8734, -11795, 14494, -15941,  3730, -2483,  -183,  4706, -5740, 10392, -16352, 23521, -15809, 20072, -24180, 27645, -14934, 15081, -13898, 11021, -3062,  -523,  5313, -11300,  9190, -13167, 17413, -21696, 12860, -14567, 15766, -16232,  7862, -6990,  5361, -2815,  -419,  2934, -6347, 11050, -2236,  3635, -6603, 20126, },
	{  1660, -2975,  3565, -2196,  -715,  3439, -8226, 15663, -6552, 10015, -14244, 19031, -11991, 14243, -15856, 16306, -7495,  5628, -2234, -2966,  5083, -9713, 15320, -21736, 14336, -17850, 21130, -23832, 12781, -12943, 12182, -10282,  3526, -1167, -1987,  5955, -5360,  8113, -11188, 14517, -9010, 10803, -12593, 14343, -2005,  2217, -2462,  2937, },
	{  2941, -7165, 14156, -24403,  9482, -13497, 17698, -21303,  5790, -5434,  3797,  -362, -2694,  6952, -12747, 20113, -14457, 19398, -24579, 29562, -16886, 18255, -18493, 17180, -6950,  4141,   -19, -5494,  6197, -10282, 14884, -19819, 12415, -14797, 16860, -18378,  9548, -9367,  8490, -6736,  1944,   177, -3226,  7623, -1784,  3196, -6335, 22897, },
	{  2216, -4316,  6236, -6856,  1120,   791, -4706, 11362, -5364,  8873, -13409, 18875, -12496, 15629, -18460, 20484, -10538,  9761, -7532,  3483,  1351, -5618, 11091, -17702, 12628, -16707, 20846, -24724, 13976, -15040, 15310, -14533,  6232, -4436,  1786,  1791, -3167,  5927, -9161, 12846, -8474, 10721, -13167, 15856, -2367,  2856, -3634,  5752, },
	{  2351, -6237, 13125, -23836,  9714, -14505, 20042, -25700,  7613, -8207,  7731, -5621,   630,  2979, -8275, 15426, -12226, 17585, -23575, 29834, -17922, 20468, -22150, 22513, -10538,  8682, -5478,   761,  2781, -6743, 11448, -16768, 11251, -14187, 17015, -19520, 10727, -11264, 11208, -10371,  4260, -2673,   188,  3618, -1206,  2540, -5656, 25349, },
	{  2711, -5543,  8780, -11486,  3022, -2078,  -695,  6154, -3799,  7158, -11755, 17614, -12296, 16163, -20093, 23625, -13075, 13465, -12561,  9925, -2567, -1084,  6112, -12546, 10152, -14578, 19361, -24221, 14398, -16323, 17631, -18046,  8640, -7523,  5538, -2566,  -745,  3351, -6563, 10398, -7438, 10022, -13003, 16513, -2609,  3366, -4698,  8773, },
	{  1519, -4817, 11197, -21787,  9382, -14714, 21337, -28821,  9081, -10630, 11389, -10772,  4049, -1317, -3163,  9686, -9215, 14701, -21183, 28398, -17958, 21566, -24632, 26692, -13611, 12837, -10754,  7120,  -873, -2740,  7281, -12691,  9418, -12752, 16200, -19572, 11318, -12559, 13350, -13504,  6396, -5457,  3709,  -761,  -527,  1686, -4548, 27399, },
	{  3099, -6560, 11025, -15797,  4879, -5010,  3595,   298, -1932,  4942, -9340, 15274, -11374, 15781, -20623, 25512, -14944, 16512, -17024, 15990, -6451,  3638,   646, -6535,  7030, -11561, 16731, -22319, 14007, -16702, 18996, -20604, 10606, -10246,  9055, -6872,  1774,   526, -3528,  7294, -5949,  8728, -12087, 16243, -2711,  3712, -5584, 11915, },
	{   470, -2945,  8415, -18267,  8466, -14064, 21447, -30413, 10090, -12545, 14543, -15511,  7367, -5698,  2316,  3188, -5574, 10878, -17498, 25286, -16963, 21455, -25767, 29448, -15981, 16357, -15539, 13218, -4559,  1510,  2606, -7799,  7007, -10557, 14441, -18505, 11275, -13166, 14781, -15945,  8225, -8012,  7139, -5278,   218,   668, -3014, 28979, },
	{  3335, -7277, 12800, -19498,  6577, -7833,  7925, -5895,   144,  2332, -6272, 11946, -9755, 14469, -19979, 25990, -16012, 18706, -20644, 21316, -10076,  8284, -5004,     8,  3427, -7807, 13078, -19094, 12804, -16133, 19304, -22040, 12009, -12442, 12130, -10880,  4248, -2394,  -219,  3695, -4080,  6896, -10447, 15027, -2660,  3864, -6228, 15084, },
	{  -750,  -694,  4877, -13380,  6984, -12540, 20298, -30303, 10558, -13816, 16988, -19545, 10389, -9913,  7857, -3716, -1491,  6308, -12693, 20628, -14964, 20109, -25453, 30585, -17494, 19026, -19547, 18701, -8068,  5768, -2321, -2355,  4143, -7711, 11818, -16357, 10587, -13035, 15400, -17535,  9632, -10186, 10281, -9683,   991,  -468, -1072, 30036, },
	{  3376, -7612, 13952, -22315,  8002, -10372, 12042, -12078,  2316,  -539, -2702,  7783, -7504, 12268, -18155, 24983, -16193, 19892, -23188, 25574, -13226, 12582, -10519,  6722,  -465, -3512,  8589, -14701, 10841, -14628, 18515, -22247, 12756, -13974, 14579, -14352,  6534, -5244,  3180,  -205, -1926,  4614, -8151, 12897, -2454,  3799, -6569, 18184, },
	{ -2081,  1830,   738, -7322,  4985, -10180, 17889, -28408, 10431, -14339, 18551, -22609, 12927, -13711, 13141, -10641,  2811,  1229, -7013, 14647, -12049, 17572, -23669, 29998, -18042, 20670, -22531, 23241, -11196,  9792, -7224,  3342,   980, -4362,  8463, -13226,  9278, -12154, 15153, -18162, 10528, -11843, 12943, -13719,  1750, -1670,  1245, 30534, },
	{  3193, -7500, 14349, -24003,  9047, -12455, 15687, -17885,  4462, -3514,  1185,  2991, -4727,  9273, -15214, 22497, -15444, 19969, -24475, 28487, -15706, 16277, -15578, 13224, -4428,  1089,  3501, -9362,  8212, -12252, 16649, -21185, 12789, -14741, 16247, -17081,  8497, -7859,  6479, -4191,   396,  2000, -5310,  9941, -2095,  3509, -6555, 21116, },
	{  1856, -3446,  4493, -3795,   -94,  2557, -7074, 14290, -6187,  9688, -14049, 19101, -12243, 14813, -16857, 17854, -8594,  7092, -4079,  -756,  3825, -8360, 13956, -20480, 13837, -17570, 21168, -24296, 13277, -13753, 13345, -11822,  4486, -2308,  -692,  4550, -4635,  7408, -10558, 14032, -8883, 10845, -12873, 14958, -2142,  2450, -2876,  3884, },
	{  2765, -6901, 13901, -24372,  9624, -13931, 18617, -22951,  6454, -6423,  5175, -2175, -1566,  5627, -11287, 18626, -13780, 18897, -24391, 29847, -17354, 19139, -19878, 19137, -8237,  5741, -1910, -3363,  5053, -9122, 13790, -18889, 12092, -14681, 17023, -18893, 10018, -10085,  9486, -8038,  2758,  -807, -2068,  6293, -1597,  2993, -6148, 23787, },
	{  2396, -4759,  7139, -8477,  1776,  -184, -3363,  9650, -4861,  8342, -12927, 18563, -12508, 15915, -19143, 21701, -11482, 11103, -9318,  5733,     4, -4086,  9440, -16032, 11852, -16078, 20467, -24710, 14213, -15582, 16213, -15845,  7107, -5535,  3098,   292, -2348,  5073, -8320, 12081, -8170, 10549, -13196, 16185, -2465,  3049, -4018,  6779, },
	{  2089, -5800, 12558, -23296,  9665, -14672, 20617, -26939,  8167, -9094,  9040, -7432,  1812,  1517, -6565, 13544, -11265, 16703, -22901, 29531, -18051, 20980, -23152, 24105, -11670, 10177, -7341,  2969,  1533, -5400, 10078, -15463, 10688, -13781, 16842, -19664, 11001, -11785, 12022, -11523,  5027, -3653,  1404,  2133,  -981,  2265, -5321, 26108, },
	{  2860, -5924,  9599, -13029,  3676, -3094,   770,  4186, -3183,  6443, -11000, 16923, -12058, 16136, -20406, 24429, -13805, 14605, -14185, 12086, -3927,   542,  4260, -10547,  9137, -13628, 18575, -23719, 14356, -16560, 18218, -19049,  9377, -8515,  6793, -4075,   124,  2394, -5554,  9390, -6971,  9639, -12771, 16526, -2661,  3506, -5028,  9851, },
	{  1178, -4217, 10327, -20732,  9131, -14588, 21514, -29556,  9487, -11358, 12549, -12474,  5219, -2836, -1293,  7505, -8017, 13475, -20046, 27506, -17730, 21667, -25184, 27819, -14520, 14139, -12481,  9278, -2156, -1285,  5708, -11078,  8643, -12074, 15695, -19328, 11376, -12851, 13932, -14436,  7070, -6375,  4917, -2321,  -275,  1350, -4065, 28002, },
	{  3200, -6847, 11701, -17162,  5491, -6008,  5102, -1825, -1232,  4077, -8345, 14227, -10890, 15431, -20535, 25842, -15410, 17377, -18385, 17935, -7747,  5269, -1305, -4313,  5828, -10336, 15574, -21346, 13680, -16612, 19226, -21235, 11161, -11073, 10179, -8306,  2643,  -482, -2405,  6095, -5341,  8151, -11599, 15928, -2711,  3788, -5838, 13013, },
	{    65, -2204,  7269, -16722,  8016, -13635, 21193, -30574, 10317, -13063, 15480, -17001,  8457, -7188,  4243,   825, -4200,  9369, -15951, 23839, -16381, 21129, -25825, 30032, -16609, 17387, -17028, 15203, -5804,  2995,   915, -5963,  6059, -9639, 13625, -17880, 11109, -13206, 15090, -16598,  8765, -8815,  8270, -6829,   484,   286, -2387, 29406, },
	{  3373, -7440, 13277, -20587,  7107, -8753,  9388, -8055,   891,  1360, -5085, 10590, -9042, 13804, -19479, 25811, -16178, 19237, -21657, 22926, -11231,  9824, -6945,  2332,  2102, -6370, 11608, -17696, 12206, -15715, 19155, -22254, 12345, -13053, 13057, -12153,  5068, -3397,   957,  2369, -3361,  6151, -9721, 14390, -2607,  3867, -6383, 16170, },
	{ -1202,   155,  3503, -11403,  6347, -11815, 19605, -29851, 10583, -14086, 17637, -20727, 11331, -11287,  9731, -6131,   -15,  4594, -10812, 18694, -14053, 19362, -25000, 30580, -17797, 19718, -20707, 20395, -9204,  7200, -4036,  -396,  3073, -6600, 10732, -15378, 10202, -12814, 15414, -17865, 10004, -10824, 11266, -11135,  1257,  -880,  -310, 30273, },
	{  3340, -7626, 14180, -23038,  8411, -11153, 13370, -14150,  3068, -1565, -1382,  6183, -6596, 11315, -17258, 24287, -16039, 20047, -23783, 26747, -14169, 13942, -12338,  9016, -1840, -1942,  6882, -12946, 10000, -13899, 17988, -22023, 12850, -14330, 15251, -15391,  7256, -6184,  4343, -1586, -1135,  3740, -7223, 11962, -2347,  3725, -6606, 19223, },
};

int nextstate_320_147[320] = {
	0x00102400, 0x00202300, 0x00302201, 0x00402100, 0x00502001, 0x00601f00, 0x00701e01, 0x00801d00, 
	0x00901c01, 0x00a01b00, 0x00b01a01, 0x00c01900, 0x00d01800, 0x00e01701, 0x00f01600, 0x01001501, 
	0x01101400, 0x01201301, 0x01301200, 0x01401101, 0x01501000, 0x01600f01, 0x01700e00, 0x01800d01, 
	0x01900c00, 0x01a00b00, 0x01b00a01, 0x01c00900, 0x01d00801, 0x01e00700, 0x01f00601, 0x02000500, 
	0x02100401, 0x02200300, 0x02300201, 0x02400100, 0x02500000, 0x02613f01, 0x02713e00, 0x02813d01, 
	0x02913c00, 0x02a13b01, 0x02b13a00, 0x02c13901, 0x02d13800, 0x02e13701, 0x02f13600, 0x03013501, 
	0x03113400, 0x03213300, 0x03313201, 0x03413100, 0x03513001, 0x03612f00, 0x03712e01, 0x03812d00, 
	0x03912c01, 0x03a12b00, 0x03b12a01, 0x03c12900, 0x03d12801, 0x03e12700, 0x03f12600, 0x04012501, 
	0x04112400, 0x04212301, 0x04312200, 0x04412101, 0x04512000, 0x04611f01, 0x04711e00, 0x04811d01, 
	0x04911c00, 0x04a11b00, 0x04b11a01, 0x04c11900, 0x04d11801, 0x04e11700, 0x04f11601, 0x05011500, 
	0x05111401, 0x05211300, 0x05311201, 0x05411100, 0x05511001, 0x05610f00, 0x05710e00, 0x05810d01, 
	0x05910c00, 0x05a10b01, 0x05b10a00, 0x05c10901, 0x05d10800, 0x05e10701, 0x05f10600, 0x06010501, 
	0x06110400, 0x06210301, 0x06310200, 0x06410100, 0x06510001, 0x0660ff00, 0x0670fe01, 0x0680fd00, 
	0x0690fc01, 0x06a0fb00, 0x06b0fa01, 0x06c0f900, 0x06d0f801, 0x06e0f700, 0x06f0f600, 0x0700f501, 
	0x0710f400, 0x0720f301, 0x0730f200, 0x0740f101, 0x0750f000, 0x0760ef01, 0x0770ee00, 0x0780ed01, 
	0x0790ec00, 0x07a0eb01, 0x07b0ea00, 0x07c0e900, 0x07d0e801, 0x07e0e700, 0x07f0e601, 0x0800e500, 
	0x0810e401, 0x0820e300, 0x0830e201, 0x0840e100, 0x0850e001, 0x0860df00, 0x0870de01, 0x0880dd00, 
	0x0890dc00, 0x08a0db01, 0x08b0da00, 0x08c0d901, 0x08d0d800, 0x08e0d701, 0x08f0d600, 0x0900d501, 
	0x0910d400, 0x0920d301, 0x0930d200, 0x0940d100, 0x0950d001, 0x0960cf00, 0x0970ce01, 0x0980cd00, 
	0x0990cc01, 0x09a0cb00, 0x09b0ca01, 0x09c0c900, 0x09d0c801, 0x09e0c700, 0x09f0c601, 0x0a00c500, 
	0x0a10c400, 0x0a20c301, 0x0a30c200, 0x0a40c101, 0x0a50c000, 0x0a60bf01, 0x0a70be00, 0x0a80bd01, 
	0x0a90bc00, 0x0aa0bb01, 0x0ab0ba00, 0x0ac0b901, 0x0ad0b800, 0x0ae0b700, 0x0af0b601, 0x0b00b500, 
	0x0b10b401, 0x0b20b300, 0x0b30b201, 0x0b40b100, 0x0b50b001, 0x0b60af00, 0x0b70ae01, 0x0b80ad00, 
	0x0b90ac00, 0x0ba0ab01, 0x0bb0aa00, 0x0bc0a901, 0x0bd0a800, 0x0be0a701, 0x0bf0a600, 0x0c00a501, 
	0x0c10a400, 0x0c20a301, 0x0c30a200, 0x0c40a101, 0x0c50a000, 0x0c609f00, 0x0c709e01, 0x0c809d00, 
	0x0c909c01, 0x0ca09b00, 0x0cb09a01, 0x0cc09900, 0x0cd09801, 0x0ce09700, 0x0cf09601, 0x0d009500, 
	0x0d109401, 0x0d209300, 0x0d309200, 0x0d409101, 0x0d509000, 0x0d608f01, 0x0d708e00, 0x0d808d01, 
	0x0d908c00, 0x0da08b01, 0x0db08a00, 0x0dc08901, 0x0dd08800, 0x0de08700, 0x0df08601, 0x0e008500, 
	0x0e108401, 0x0e208300, 0x0e308201, 0x0e408100, 0x0e508001, 0x0e607f00, 0x0e707e01, 0x0e807d00, 
	0x0e907c01, 0x0ea07b00, 0x0eb07a00, 0x0ec07901, 0x0ed07800, 0x0ee07701, 0x0ef07600, 0x0f007501, 
	0x0f107400, 0x0f207301, 0x0f307200, 0x0f407101, 0x0f507000, 0x0f606f01, 0x0f706e00, 0x0f806d00, 
	0x0f906c01, 0x0fa06b00, 0x0fb06a01, 0x0fc06900, 0x0fd06801, 0x0fe06700, 0x0ff06601, 0x10006500, 
	0x10106401, 0x10206300, 0x10306200, 0x10406101, 0x10506000, 0x10605f01, 0x10705e00, 0x10805d01, 
	0x10905c00, 0x10a05b01, 0x10b05a00, 0x10c05901, 0x10d05800, 0x10e05701, 0x10f05600, 0x11005500, 
	0x11105401, 0x11205300, 0x11305201, 0x11405100, 0x11505001, 0x11604f00, 0x11704e01, 0x11804d00, 
	0x11904c01, 0x11a04b00, 0x11b04a01, 0x11c04900, 0x11d04800, 0x11e04701, 0x11f04600, 0x12004501, 
	0x12104400, 0x12204301, 0x12304200, 0x12404101, 0x12504000, 0x12603f01, 0x12703e00, 0x12803d00, 
	0x12903c01, 0x12a03b00, 0x12b03a01, 0x12c03900, 0x12d03801, 0x12e03700, 0x12f03601, 0x13003500, 
	0x13103401, 0x13203300, 0x13303201, 0x13403100, 0x13503000, 0x13602f01, 0x13702e00, 0x13802d01, 
	0x13902c00, 0x13a02b01, 0x13b02a00, 0x13c02901, 0x13d02800, 0x13e02701, 0x13f02600, 0x00002501, 
};
#endif // HELIX_FEATURE_MMXFILTER_3_1

#ifdef HELIX_FEATURE_MMXFILTER_3_2
/*
 * inrate=32000 outrate=48000 up=3 dn=2
 */

ALIGN
filtwing filter_3_2[3] = {
	{    91, -2069,  6833, -15806,  7615, -13009, 20293, -29359,  9929, -12593, 14937, -16406,  8148, -6889,  3978,  1026, -4252,  9357, -15858, 23651, -16233, 20921, -25556, 29700, -16411, 17161, -16774, 14927, -5658,  2843,  1068, -6111,  6128, -9698, 13670, -17904, 11108, -13186, 15048, -16526,  8710, -8738,  8163, -6684,   459,   322, -2447, 29369, },
	{  2202, -4707,  7510, -9677,  2415, -1312, -1601,  7143, -4040,  7349, -11831, 17490, -12079, 15725, -19359, 22514, -12292, 12418, -11227,  8295, -1611, -2160,  7265, -13716, 10702, -15041, 19670, -24301, 14283, -16010, 17079, -17218,  8073, -6794,  4648, -1525, -1330,  3984, -7214, 11030, -7720, 10236, -13104, 16434, -2563,  3258, -4459,  8042, },
	{  2803, -6808, 13216, -22265,  8417, -11586, 14541, -16437,  4024, -3008,   631,  3561, -4995,  9488, -15331, 22458, -15313, 19688, -24003, 27782, -15217, 15635, -14773, 12253, -3863,   457,  4180, -10059,  8549, -12552, 16881, -21313, 12781, -14639, 16029, -16725,  8240, -7514,  6040, -3654,    78,  2365, -5717, 10380, -2152,  3561, -6579, 20735, },
};

int nextstate_3_2[3] = {
	0x00100000, 0x00200201, 0x00000101, 
};
#endif // HELIX_FEATURE_MMXFILTER_3_2

#ifdef HELIX_FEATURE_MMXFILTER_160_147
/*
 * inrate=44100 outrate=48000 up=160 dn=147
 */

ALIGN
filtwing filter_160_147[160] = {
	{ -2525,  2691,  -711, -5130,  4231, -9237, 16830, -27392, 10252, -14331, 18842, -23356, 13619, -14819, 14757, -12840,  4224,  -495, -5014, 12453, -10919, 16499, -22774, 29424, -18000, 20961, -23249, 24470, -12102, 11015, -8774,  5206,   -90, -3188,  7235, -12014,  8724, -11708, 14881, -18146, 10697, -12253, 13681, -14916,  1987, -2067,  2075, 30572, },
	{  2035, -3882,  5364, -5319,   508,  1688, -5917, 12873, -5794,  9309, -13770, 19042, -12403, 15262, -17704, 19216, -9588,  8444, -5813,  1357,  2601, -7015, 12567, -19153, 13274, -17191, 21070, -24582, 13666, -14437, 14367, -13212,  5372, -3379,   544,  3185, -3916,  6690, -9892, 13482, -8706, 10816, -13059, 15451, -2261,  2659, -3259,  4805, },
	{  2555, -5155,  7966, -9986,  2398, -1124, -2047,  7939, -4346,  7776, -12379, 18142, -12438, 16084, -19671, 22722, -12310, 12313, -10963,  7842, -1279, -2599,  7806, -14339, 11038, -15377, 19975, -24539, 14348, -15999, 16971, -16993,  7894, -6545,  4327, -1135, -1554,  4228, -7468, 11277, -7830, 10318, -13140, 16398, -2544,  3216, -4366,  7768, },
	{  2983, -6250, 10326, -14431,  4282, -4052,  2175,  2265, -2569,  5714, -10204, 16149, -11751, 16005, -20572, 25039, -14413, 15598, -15643, 14070, -5198,  2090,  2468, -8575,  8112, -12636, 17709, -23090, 14224, -16680, 18662, -19884, 10020, -9406,  7943, -5485,   949,  1468, -4559,  8372, -6482,  9214, -12469, 16435, -2694,  3619, -5318, 10880, },
	{  3273, -7074, 12272, -18361,  6044, -6929,  6518, -3853,  -551,  3220, -7337, 13131, -10355, 14995, -20316, 25990, -15755, 18090, -19566, 19674, -8932,  6789, -3156, -2168,  4646, -9103, 14374, -20285, 13283, -16422, 19323, -21701, 11618, -11791, 11185, -9617,  3453, -1439, -1320,  4915, -4727,  7549, -11059, 15527, -2694,  3837, -6048, 14051, },
	{  3382, -7541, 13642, -21493,  7569, -9579, 10731, -10077,  1602,   419, -3913,  9222, -8301, 13078, -18875, 25472, -16232, 19619, -22484, 24314, -12259, 11230, -8750,  4531,   826, -4962, 10135, -16252, 11561, -15219, 18893, -22317, 12588, -13553, 13857, -13289,  5816, -4330,  2071,  1091, -2655,  5402, -8968, 13690, -2539,  3845, -6494, 17184, },
	{  3275, -7581, 14298, -23573,  8748, -11828, 14556, -16044,  3770, -2539,  -108,  4611, -5683, 10330, -16289, 23464, -15789, 20066, -24197, 27693, -14978, 15148, -13992, 11144, -3138,  -434,  5213, -11194,  9137, -13118, 17373, -21670, 12858, -14579, 15795, -16282,  7898, -7040,  5424, -2892,  -374,  2883, -6291, 10991, -2229,  3629, -6601, 20182, },
	{  2929, -7145, 14134, -24390,  9486, -13517, 17744, -21390,  5826, -5488,  3872,  -462, -2631,  6878, -12666, 20031, -14419, 19371, -24570, 29579, -16913, 18305, -18571, 17290, -7022,  4230,  -124, -5377,  6134, -10219, 14826, -19770, 12399, -14793, 16872, -18410,  9576, -9409,  8546, -6809,  1989,   122, -3162,  7551, -1774,  3186, -6326, 22948, },
	{  2334, -6209, 13087, -23796,  9708, -14510, 20068, -25763,  7643, -8255,  7803, -5720,   695,  2898, -8180, 15322, -12173, 17537, -23539, 29819, -17930, 20498, -22207, 22603, -10601,  8766, -5582,   884,  2712, -6670, 11374, -16698, 11221, -14167, 17008, -19531, 10744, -11294, 11255, -10436,  4303, -2728,   255,  3537, -1193,  2525, -5638, 25392, },
	{  1498, -4781, 11144, -21720,  9365, -14703, 21341, -28856,  9102, -10669, 11452, -10865,  4113, -1401, -3059,  9565, -9149, 14634, -21121, 28350, -17947, 21573, -24665, 26757, -13663, 12911, -10851,  7240,  -944, -2660,  7195, -12603,  9376, -12716, 16174, -19561, 11323, -12577, 13385, -13558,  6435, -5508,  3776,  -847,  -513,  1668, -4523, 27434, },
	{   448, -2902,  8348, -18175,  8439, -14037, 21428, -30416, 10101, -12572, 14593, -15592,  7427, -5780,  2422,  3058, -5498, 10795, -17413, 25207, -16932, 21439, -25772, 29483, -16018, 16416, -15623, 13329, -4629,  1592,  2513, -7699,  6955, -10508, 14398, -18473, 11268, -13171, 14800, -15984,  8256, -8058,  7203, -5365,   233,   647, -2981, 29004, },
	{  -774,  -647,  4799, -13266,  6946, -12497, 20255, -30272, 10558, -13829, 17023, -19609, 10441, -9988,  7960, -3849, -1410,  6213, -12590, 20522, -14915, 20069, -25430, 30588, -17513, 19067, -19614, 18797, -8132,  5848, -2417, -2247,  4084, -7651, 11760, -16305, 10567, -13025, 15403, -17556,  9655, -10223, 10337, -9765,  1006,  -491, -1030, 30051, },
	{ -2105,  1879,   653, -7192,  4940, -10123, 17823, -28344, 10419, -14337, 18566, -22651, 12966, -13776, 13236, -10770,  2894,  1128, -6896, 14519, -11984, 17510, -23619, 29966, -18042, 20689, -22576, 23315, -11250,  9865, -7316,  3452,   917, -4294,  8392, -13157,  9246, -12130, 15139, -18164, 10539, -11869, 12989, -13791,  1764, -1693,  1293, 30538, },
	{  1864, -3469,  4541, -3882,   -59,  2505, -7005, 14204, -6163,  9664, -14031, 19096, -12251, 14839, -16906, 17933, -8652,  7171, -4181,  -632,  3753, -8281, 13875, -20404, 13805, -17549, 21165, -24315, 13302, -13795, 13406, -11905,  4539, -2371,  -619,  4471, -4594,  7367, -10521, 14002, -8874, 10845, -12886, 14989, -2150,  2462, -2898,  3937, },
	{  2402, -4778,  7183, -8561,  1812,  -239, -3285,  9548, -4830,  8307, -12894, 18537, -12503, 15924, -19174, 21760, -11531, 11174, -9415,  5856,   -71, -3999,  9345, -15934, 11805, -16038, 20440, -24703, 14222, -15608, 16260, -15914,  7154, -5595,  3170,   209, -2302,  5024, -8272, 12036, -8152, 10537, -13195, 16200, -2470,  3059, -4039,  6836, },
	{  2864, -5938,  9636, -13105,  3710, -3149,   851,  4073, -3146,  6400, -10953, 16876, -12040, 16128, -20415, 24465, -13841, 14663, -14271, 12203, -4002,   633,  4155, -10432,  9077, -13571, 18526, -23685, 14350, -16569, 18247, -19101,  9416, -8569,  6861, -4159,   172,  2340, -5497,  9332, -6944,  9616, -12755, 16524, -2663,  3514, -5046,  9912, },
	{  3201, -6855, 11727, -17224,  5521, -6060,  5183, -1943, -1192,  4026, -8285, 14162, -10858, 15405, -20521, 25850, -15430, 17419, -18455, 18038, -7816,  5358, -1414, -4187,  5759, -10265, 15505, -21286, 13659, -16603, 19234, -21265, 11189, -11117, 10240, -8384,  2691,  -539, -2341,  6027, -5306,  8117, -11569, 15908, -2710,  3792, -5851, 13074, },
	{  3370, -7440, 13290, -20630,  7131, -8798,  9464, -8172,   932,  1305, -5015, 10509, -8998, 13761, -19443, 25791, -16182, 19259, -21706, 23008, -11291,  9907, -7051,  2461,  2027, -6288, 11523, -17613, 12170, -15688, 19143, -22261, 12361, -13085, 13106, -12222,  5112, -3452,  1022,  2294, -3320,  6108, -9679, 14351, -2603,  3866, -6391, 16230, },
	{  3332, -7618, 14179, -23059,  8428, -11189, 13436, -14258,  3109, -1622, -1307,  6091, -6542, 11257, -17201, 24238, -16025, 20049, -23808, 26803, -14217, 14013, -12436,  9142, -1916, -1853,  6785, -12845,  9950, -13855, 17954, -22005, 12852, -14347, 15285, -15445,  7295, -6235,  4408, -1663, -1091,  3690, -7170, 11907, -2340,  3720, -6607, 19280, },
	{  3062, -7332, 14276, -24283,  9311, -13066, 16846, -19833,  5213, -4592,  2642,  1132, -3607,  8005, -13882, 21232, -14938, 19708, -24603, 29169, -16410, 17428, -17251, 15471, -5849,  2796,  1545, -7230,  7111, -11188, 15713, -20485, 12618, -14816, 16638, -17856,  9110, -8725,  7621, -5625,  1261,   988, -4164,  8679, -1928,  3346, -6454, 22127, },
	{  2543, -6550, 13505, -24135,  9698, -14285, 19457, -24541,  7116, -7434,  6613, -4100,  -347,  4167, -9640, 16894, -12952, 18219, -24006, 29926, -17721, 19936, -21204, 21077, -9546,  7400, -3909, -1069,  3799, -7820, 12522, -17760, 11658, -14449, 17069, -19300, 10444, -10773, 10476, -9365,  3605, -1851,  -816,  4821, -1384,  2750, -5895, 24679, },
	{  1780, -5271, 11835, -22518,  9532, -14733, 21071, -28057,  8698, -9973, 10373, -9313,  3063,   -58, -4687, 11431, -10154, 15634, -22008, 28984, -18051, 21368, -24046, 25620, -12788, 11692, -9268,  5296,   194, -3930,  8546, -13960, 10010, -13247, 16534, -19671, 11211, -12253, 12800, -12664,  5806, -4670,  2694,   527,  -731,  1951, -4912, 26853, },
	{   792, -3525,  9294, -19417,  8785, -14335, 21533, -30111,  9848, -12049, 13694, -14200,  6430, -4439,   715,  5120, -6678, 12065, -18682, 26346, -17353, 21612, -25583, 28809, -15378, 15419, -14225, 11506, -3504,   272,  3992, -9279,  7755, -11262, 15041, -18926, 11354, -13065, 14448, -15322,  7736, -7307,  6171, -3975,    -2,   976, -3500, 28575, },
	{  -383, -1375,  5963, -14911,  7463, -13062, 20752, -30505, 10479, -13518, 16362, -18465,  9557, -8727,  6269, -1704, -2701,  7688, -14179, 22116, -15638, 20621, -25692, 30428, -17152, 18353, -18485, 17201, -7086,  4553,  -890, -3965,  5007, -8590, 12656, -17083, 10851, -13150, 15308, -17171,  9275, -9606,  9416, -8439,   767,  -131, -1672, 29787, },
	{ -1688,  1081,  1981, -9169,  5607, -10938, 18703, -29128, 10527, -14265, 18194, -21833, 12252, -12670, 11660, -8663,  1561,  2730, -8723, 16490, -12975, 18419, -24330, 30344, -17986, 20307, -21787, 22044, -10344,  8669, -5829,  1691,  1913, -5370,  9496, -14222,  9716, -12484, 15314, -18084, 10326, -11425, 12235, -12607,  1535, -1320,   541, 30449, },
	{  1690, -3051,  3716, -2459,  -612,  3293, -8036, 15437, -6492,  9962, -14214, 19046, -12035, 14341, -16026, 16567, -7679,  5873, -2541, -2600,  4875, -9492, 15099, -21535, 14258, -17810, 21145, -23919, 12869, -13083, 12380, -10543,  3687, -1358, -1772,  5724, -5242,  8000, -11088, 14443, -8993, 10815, -12645, 14452, -2029,  2256, -2531,  3093, },
	{  2243, -4386,  6382, -7122,  1228,   630, -4484, 11080, -5281,  8787, -13332, 18827, -12501, 15680, -18579, 20692, -10698,  9987, -7831,  3858,  1127, -5365, 10821, -17431, 12503, -16609, 20791, -24732, 14021, -15136, 15467, -14758,  6380, -4621,  2005,  1543, -3033,  5787, -9026, 12724, -8427, 10698, -13178, 15918, -2384,  2889, -3699,  5922, },
	{  2733, -5602,  8912, -11738,  3130, -2246,  -453,  5829, -3698,  7041, -11632, 17503, -12259, 16163, -20150, 23765, -13200, 13658, -12835, 10288, -2794,  -814,  5806, -12219,  9987, -14426, 19238, -24148, 14397, -16369, 17737, -18221,  8766, -7691,  5749, -2819,  -601,  3194, -6398, 10235, -7364,  9963, -12971, 16523, -2619,  3391, -4754,  8952, },
	{  3113, -6604, 11132, -16019,  4980, -5175,  3844,   -53, -1816,  4800, -9177, 15103, -11296, 15726, -20614, 25574, -15026, 16661, -17256, 16319, -6669,  3911,   322, -6168,  6833, -11362, 16545, -22167, 13958, -16694, 19042, -20718, 10703, -10388,  9246, -7114,  1920,   359, -3343,  7098, -5851,  8636, -12012, 16198, -2712,  3727, -5629, 12098, },
	{  3338, -7300, 12875, -19675,  6664, -7985,  8168, -6253,   268,  2171, -6077, 11724, -9639, 14362, -19901, 25967, -16045, 18800, -20819, 21591, -10271,  8543, -5329,   394,  3208, -7571, 12839, -18870, 12710, -16070, 19288, -22085, 12070, -12549, 12290, -11096,  4386, -2562,   -24,  3477, -3962,  6775, -10331, 14928, -2653,  3866, -6256, 15266, },
	{  3368, -7610, 13985, -22430,  8069, -10501, 12262, -12422,  2441,  -709, -2484,  7519, -7355, 12113, -18011, 24874, -16172, 19924, -23294, 25777, -13387, 12812, -10825,  7106,  -694, -3253,  8309, -14415, 10705, -14513, 18435, -22219, 12777, -14040, 14697, -14532,  6657, -5403,  3375,  -434, -1796,  4471, -8001, 12748, -2437,  3789, -6578, 18358, },
	{  3171, -7472, 14336, -24046,  9089, -12552, 15871, -18194,  4581, -3684,  1414,  2700, -4553,  9077, -15010, 22306, -15370, 19935, -24504, 28606, -15823, 16465, -15848, 13584, -4654,  1358,  3194, -9030,  8042, -12090, 16509, -21085, 12768, -14760, 16316, -17211,  8598, -7999,  6662, -4419,   532,  1842, -5133,  9748, -2070,  3485, -6543, 21278, },
	{  2729, -6844, 13837, -24334,  9636, -13988, 18752, -23205,  6559, -6583,  5403, -2478, -1375,  5399, -11032, 18360, -13655, 18798, -24340, 29872, -17418, 19272, -20095, 19451, -8447,  6005, -2226, -3003,  4858, -8921, 13596, -18720, 12029, -14652, 17038, -18966, 10090, -10198,  9647, -8251,  2893,  -972, -1872,  6065, -1564,  2957, -6112, 23931, },
	{  2040, -5716, 12444, -23174,  9644, -14683, 20691, -27120,  8252, -9234,  9252, -7729,  2010,  1270, -6272, 13217, -11095, 16541, -22769, 29456, -18058, 21050, -23303, 24354, -11851, 10420, -7648,  3337,  1323, -5171,  9841, -15234, 10587, -13704, 16802, -19675, 11039, -11865, 12151, -11708,  5152, -3815,  1608,  1882,  -942,  2217, -5260, 26229, },
	{  1118, -4108, 10165, -20526,  9077, -14550, 21520, -29649,  9546, -11469, 12732, -12749,  5411, -3089,  -978,  7133, -7810, 13259, -19839, 27334, -17678, 21667, -25258, 27987, -14661, 14347, -12761,  9633, -2369, -1040,  5440, -10799,  8507, -11952, 15599, -19274, 11378, -12891, 14020, -14583,  7178, -6525,  5116, -2582,  -232,  1292, -3980, 28097, },
	{    -5, -2074,  7064, -16439,  7930, -13547, 21127, -30569, 10345, -13138, 15622, -17236,  8632, -7433,  4563,   428, -3966,  9108, -15678, 23577, -16271, 21057, -25815, 30107, -16701, 17547, -17265, 15525, -6009,  3242,   631, -5651,  5896, -9478, 13479, -17763, 11074, -13204, 15132, -16697,  8849, -8944,  8454, -7085,   529,   221, -2277, 29471, },
	{ -1277,   300,  3265, -11054,  6232, -11679, 19466, -29743, 10577, -14117, 17729, -20907, 11479, -11508, 10038, -6531,   233,  4302, -10487, 18354, -13889, 19221, -24905, 30556, -17835, 19820, -20887, 20664, -9388,  7434, -4320,   -67,  2892, -6409, 10542, -15203, 10130, -12768, 15405, -17909, 10060, -10924, 11424, -11372,  1301,  -949,  -179, 30306, },
	{  1515, -2630,  2895, -1058, -1151,  4048, -9005, 16565, -6782, 10202, -14317, 18895, -11757, 13772, -15069, 15127, -6675,  4556,  -903, -4536,  5961, -10641, 16231, -22542, 14631, -17974, 21012, -23398, 12369, -12306, 11295, -9133,  2821,  -343, -2908,  6938, -5859,  8585, -11592, 14804, -9063, 10728, -12340, 13843, -1898,  2042, -2160,  2275, },
	{  2077, -3984,  5569, -5679,   651,  1479, -5636, 12526, -5696,  9212, -13692, 19012, -12431, 15356, -17890, 19523, -9816,  8757, -6219,  1857,  2309, -6691, 12227, -18823, 13129, -17087, 21029, -24629, 13746, -14586, 14596, -13530,  5577, -3629,   836,  2859, -3742,  6515, -9726, 13340, -8656, 10800, -13091, 15555, -2287,  2706, -3348,  5026, },
	{  2592, -5247,  8158, -10340,  2545, -1347, -1732,  7525, -4220,  7635, -12239, 18027, -12411, 16110, -19780, 22945, -12496, 12590, -11344,  8335, -1582, -2245,  7412, -13925, 10836, -15197, 19841, -24478, 14367, -16084, 17135, -17249,  8073, -6778,  4613, -1472, -1365,  4024, -7259, 11077, -7742, 10254, -13115, 16434, -2561,  3253, -4446,  8003, },
	{  3011, -6324, 10492, -14755,  4423, -4278,  2507,  1806, -2421,  5536, -10007, 15952, -11669, 15960, -20594, 25162, -14545, 15821, -15975, 14528, -5495,  2454,  2042, -8100,  7862, -12390, 17489, -22922, 14181, -16694, 18750, -20064, 10163, -9608,  8209, -5814,  1143,  1247, -4319,  8123, -6361,  9105, -12386, 16399, -2699,  3643, -5383, 11123, },
	{  3288, -7124, 12399, -18633,  6171, -7143,  6850, -4332,  -389,  3014, -7091, 12860, -10219, 14879, -20247, 26003, -15823, 18244, -19829, 20070, -9205,  7144, -3591, -1658,  4362, -8804, 14077, -20016, 13178, -16363, 19329, -21792, 11716, -11950, 11413, -9919,  3642, -1664, -1062,  4631, -4578,  7400, -10922, 15419, -2688,  3845, -6093, 14294, },
	{  3381, -7560, 13719, -21694,  7673, -9768, 11042, -10549,  1770,   195, -3631,  8889, -8118, 12895, -18715, 25370, -16231, 19693, -22661, 24622, -12493, 11553, -9170,  5048,   523, -4624,  9777, -15896, 11398, -15088, 18814, -22313, 12634, -13659, 14034, -13546,  5988, -4547,  2332,   787, -2485,  5220, -8781, 13512, -2520,  3837, -6515, 17421, },
	{  3257, -7565, 14315, -23683,  8821, -11980, 14827, -16482,  3934, -2769,   195,  4234, -5462, 10087, -16045, 23249, -15716, 20054, -24275, 27894, -15156, 15421, -14372, 11638, -3442,   -76,  4814, -10770,  8924, -12922, 17212, -21568, 12849, -14625, 15910, -16478,  8043, -7236,  5674, -3198,  -194,  2677, -6064, 10751, -2199,  3603, -6594, 20404, },
	{  2892, -7091, 14085, -24396,  9522, -13620, 17956, -21765,  5975, -5710,  4179,  -864, -2383,  6588, -12349, 19712, -14277, 19270, -24540, 29657, -17025, 18510, -18888, 17733, -7311,  4587,  -544, -4907,  5883, -9967, 14590, -19574, 12334, -14775, 16916, -18533,  9685, -9573,  8772, -7102,  2171,   -96, -2907,  7260, -1734,  3143, -6288, 23148, },
	{  2278, -6116, 12969, -23690,  9702, -14554, 20206, -26050,  7769, -8455,  8096, -6124,   957,  2576, -7806, 14913, -11966, 17350, -23401, 29767, -17968, 20622, -22441, 22967, -10858,  9102, -5998,  1374,  2436, -6375, 11076, -16417, 11102, -14084, 16978, -19573, 10810, -11416, 11441, -10697,  4476, -2947,   525,  3210, -1144,  2466, -5568, 25564, },
	{  1425, -4652, 10958, -21498,  9314, -14683, 21391, -29033,  9197, -10835, 11714, -11247,  4374, -1738, -2647,  9087, -8888, 14369, -20880, 28167, -17905, 21606, -24800, 27020, -13871, 13206, -11239,  7723, -1229, -2338,  6850, -12252,  9209, -12572, 16070, -19517, 11342, -12648, 13521, -13772,  6587, -5715,  4046, -1193,  -458,  1594, -4419, 27572, },
	{   359, -2741,  8100, -17843,  8344, -13949, 21383, -30467, 10156, -12693, 14808, -15930,  7672, -6113,  2850,  2536, -5196, 10466, -17079, 24899, -16811, 21377, -25798, 29627, -16165, 16653, -15961, 13777, -4907,  1923,  2139, -7295,  6749, -10309, 14224, -18344, 11237, -13186, 14876, -16137,  8380, -8240,  7457, -5711,   292,   563, -2845, 29104, },
	{  -873,  -460,  4499, -12837,  6809, -12343, 20112, -30188, 10569, -13895, 17175, -19880, 10654, -10298,  8380, -4386, -1083,  5836, -12179, 20104, -14720, 19914, -25342, 30602, -17589, 19230, -19881, 19182, -8388,  6169, -2798, -1813,  3849, -7408, 11525, -16096, 10487, -12982, 15414, -17638,  9742, -10370, 10561, -10091,  1065,  -582,  -864, 30108, },
	{ -2210,  2081,   316, -6684,  4766, -9908, 17585, -28121, 10383, -14343, 18644, -22838, 13136, -14042, 13621, -11292,  3227,   724, -6430, 14011, -11724, 17267, -23420, 29846, -18040, 20767, -22755, 23615, -11469, 10157, -7684,  3892,   666, -4020,  8107, -12878,  9121, -12031, 15082, -18169, 10584, -11971, 13168, -14078,  1820, -1787,  1485, 30552, },
	{  1907, -3572,  4747, -4240,    82,  2303, -6738, 13881, -6074,  9581, -13973, 19092, -12295, 14952, -17113, 18262, -8890,  7492, -4590,  -136,  3468, -7970, 13556, -20102, 13680, -17469, 21152, -24394, 13399, -13962, 13653, -12238,  4749, -2624,  -329,  4152, -4427,  7202, -10369, 13879, -8836, 10843, -12935, 15112, -2178,  2513, -2989,  4152, },
	{  2441, -4873,  7381, -8919,  1958,  -459, -2979,  9153, -4713,  8179, -12772, 18448, -12493, 15972, -19307, 22011, -11731, 11464, -9806,  6354,  -372, -3652,  8966, -15544, 11620, -15881, 20334, -24674, 14261, -15713, 16445, -16191,  7342, -5835,  3461,  -127, -2116,  4828, -8075, 11852, -8075, 10488, -13188, 16258, -2490,  3100, -4122,  7068, },
	{  2895, -6018,  9812, -13440,  3854, -3375,  1181,  3625, -3004,  6232, -10772, 16703, -11974, 16105, -20465, 24620, -13990, 14904, -14620, 12675, -4302,   997,  3736, -9974,  8841, -13345, 18332, -23548, 14326, -16605, 18359, -19306,  9572, -8782,  7135, -4492,   366,  2124, -5265,  9097, -6832,  9520, -12690, 16510, -2672,  3542, -5116, 10153, },
	{  3220, -6913, 11868, -17515,  5654, -6279,  5518, -2419, -1033,  3828, -8053, 13912, -10738, 15310, -20480, 25898, -15519, 17595, -18741, 18455, -8099,  5718, -1849, -3686,  5485, -9980, 15231, -21047, 13572, -16566, 19266, -21385, 11302, -11291, 10481, -8696,  2883,  -764, -2088,  5752, -5164,  7979, -11448, 15821, -2708,  3805, -5903, 13319, },
	{  3374, -7469, 13384, -20855,  7244, -8997,  9784, -8650,  1099,  1085, -4743, 10194, -8829, 13598, -19311, 25724, -16202, 19359, -21911, 23346, -11539, 10242, -7479,  2979,  1728, -5960, 11182, -17282, 12024, -15579, 19090, -22286, 12424, -13208, 13300, -12494,  5290, -3673,  1284,  1995, -3156,  5935, -9506, 14194, -2588,  3863, -6419, 16469, },
	{  3320, -7613, 14216, -23198,  8512, -11353, 13721, -14709,  3275, -1851, -1009,  5725, -6331, 11032, -16982, 24058, -15974, 20063, -23917, 27039, -14414, 14304, -12830,  9646, -2222, -1500,  6396, -12439,  9752, -13678, 17818, -21932, 12860, -14412, 15420, -15662,  7449, -6439,  4663, -1970,  -913,  3491, -6954, 11685, -2313,  3699, -6609, 19507, },
	{  3031, -7290, 14248, -24322,  9359, -13185, 17078, -20230,  5368, -4818,  2950,   736, -3366,  7729, -13586, 20943, -14816, 19634, -24607, 29286, -16543, 17656, -17589, 15933, -6145,  3156,  1129, -6771,  6870, -10952, 15499, -20317, 12570, -14818, 16705, -18004,  9231, -8900,  7856, -5923,  1443,   773, -3916,  8403, -1891,  3308, -6425, 22335, },
	{  2493, -6469, 13408, -24064,  9705, -14348, 19619, -24857,  7251, -7642,  6912, -4506,   -87,  3853, -9281, 16511, -12765, 18059, -23902, 29914, -17782, 20086, -21465, 21469, -9814,  7745, -4328,  -582,  3529, -7537, 12242, -17504, 11555, -14386, 17062, -19367, 10524, -10909, 10676, -9637,  3781, -2071,  -550,  4504, -1337,  2696, -5835, 24861, },
	{  1712, -5153, 11670, -22331,  9495, -14733, 21149, -28270,  8803, -10152, 10647, -9704,  3326,  -393, -4284, 10972, -9909, 15392, -21798, 28840, -18034, 21430, -24212, 25916, -13013, 12002, -9668,  5784,   -90, -3615,  8213, -13629,  9857, -13121, 16452, -19654, 11244, -12340, 12952, -12893,  5966, -4881,  2965,   185,  -678,  1881, -4819, 27002, },
	{   707, -3372,  9064, -19119,  8704, -14268, 21518, -30202,  9916, -12185, 13925, -14554,  6682, -4775,  1141,  4608, -6387, 11755, -18375, 26076, -17257, 21580, -25643, 28992, -15546, 15676, -14581, 11967, -3787,   602,  3625, -8889,  7559, -11080, 14888, -18823, 11338, -13098, 14543, -15495,  7869, -7498,  6431, -4323,    56,   895, -3374, 28687, },
	{  -480, -1196,  5677, -14511,  7339, -12928, 20639, -30463, 10504, -13602, 16535, -18759,  9782, -9046,  6694, -2240, -2381,  7324, -13790, 21730, -15465, 20494, -25640, 30484, -17251, 18541, -18776, 17608, -7351,  4878, -1271, -3538,  4779, -8360, 12439, -16897, 10785, -13125, 15340, -17276,  9375, -9765,  9650, -8773,   827,  -220, -1515, 29858, },
	{ -1792,  1279,  1653, -8683,  5445, -10741, 18493, -28948, 10506, -14290, 18296, -22048, 12436, -12952, 12058, -9193,  1894,  2332, -8272, 16007, -12735, 18201, -24165, 30265, -18009, 20413, -21995, 22373, -10575,  8972, -6203,  2132,  1665, -5104,  9225, -13963,  9604, -12402, 15278, -18113, 10385, -11542, 12429, -12908,  1592, -1413,   726, 30476, },
	{  1734, -3155,  3922, -2813,  -475,  3099, -7784, 15138, -6414,  9893, -14176, 19068, -12095, 14472, -16253, 16916, -7926,  6200, -2951, -2111,  4598, -9195, 14801, -21264, 14152, -17754, 21161, -24030, 12983, -13268, 12643, -10888,  3902, -1611, -1485,  5414, -5083,  7846, -10952, 14340, -8968, 10828, -12712, 14593, -2060,  2309, -2624,  3302, },
	{  2283, -4485,  6584, -7482,  1374,   414, -4188, 10704, -5172,  8672, -13229, 18764, -12508, 15749, -18736, 20968, -10911, 10288, -8230,  4358,   829, -5027, 10458, -17066, 12336, -16475, 20714, -24737, 14078, -15262, 15672, -15054,  6576, -4866,  2297,  1210, -2852,  5600, -8842, 12559, -8363, 10663, -13189, 15997, -2407,  2933, -3785,  6149, },
	{  2767, -5688,  9096, -12083,  3275, -2471,  -129,  5395, -3562,  6885, -11469, 17355, -12211, 16162, -20227, 23952, -13367, 13915, -13199, 10771, -3097,  -454,  5397, -11779,  9765, -14220, 19070, -24044, 14393, -16427, 17873, -18450,  8933, -7914,  6029, -3154,  -408,  2982, -6176, 10015, -7263,  9882, -12924, 16531, -2631,  3423, -4829,  9191, },
	{  3136, -6670, 11286, -16326,  5117, -5397,  4179,  -523, -1662,  4610, -8960, 14877, -11193, 15654, -20601, 25655, -15134, 16858, -17563, 16755, -6958,  4274,  -111, -5677,  6569, -11094, 16294, -21958, 13890, -16680, 19100, -20865, 10830, -10575,  9498, -7434,  2113,   135, -3095,  6834, -5718,  8511, -11907, 16134, -2713,  3745, -5687, 12342, },
	{  3348, -7339, 12985, -19922,  6784, -8191,  8494, -6734,   433,  1957, -5816, 11427, -9484, 14220, -19797, 25936, -16087, 18924, -21051, 21955, -10531,  8887, -5761,   910,  2915, -7255, 12517, -18566, 12582, -15983, 19261, -22140, 12149, -12689, 12500, -11383,  4570, -2785,   237,  3183, -3804,  6612, -10174, 14792, -2642,  3868, -6293, 15507, },
	{  3361, -7616, 14041, -22598,  8162, -10677, 12560, -12885,  2608,  -937, -2192,  7167, -7156, 11906, -17818, 24729, -16143, 19965, -23434, 26046, -13601, 13118, -11232,  7617,  -999, -2905,  7933, -14030, 10522, -14356, 18325, -22177, 12802, -14123, 14851, -14767,  6820, -5613,  3635,  -741, -1621,  4278, -7798, 12545, -2414,  3774, -6588, 18590, },
	{  3146, -7441, 14329, -24117,  9148, -12686, 16121, -18611,  4740, -3912,  1721,  2311, -4319,  8814, -14737, 22050, -15270, 19889, -24541, 28760, -15977, 16713, -16206, 14061, -4954,  1718,  2784, -8586,  7814, -11871, 16319, -20946, 12737, -14781, 16405, -17381,  8730, -8184,  6905, -4722,   714,  1630, -4894,  9486, -2036,  3452, -6524, 21493, },
	{  2685, -6775, 13762, -24297,  9656, -14069, 18937, -23549,  6701, -6798,  5707, -2884, -1119,  5095, -10691, 18004, -13487, 18663, -24269, 29900, -17503, 19448, -20382, 19866, -8725,  6356, -2647, -2522,  4596, -8651, 13335, -18490, 11943, -14609, 17055, -19059, 10184, -10347,  9859, -8533,  3072, -1192, -1610,  5758, -1520,  2907, -6061, 24121, },
	{  1977, -5609, 12300, -23023,  9621, -14703, 20796, -27367,  8367, -9423,  9536, -8127,  2273,   939, -5880, 12778, -10866, 16323, -22591, 29353, -18066, 21140, -23500, 24682, -12091, 10743, -8056,  3827,  1042, -4864,  9523, -14923, 10448, -13597, 16743, -19684, 11088, -11967, 12319, -11952,  5318, -4030,  1879,  1546,  -890,  2152, -5177, 26389, },
	{  1038, -3966,  9954, -20262,  9010, -14504, 21535, -29779,  9626, -11619, 12978, -13117,  5668, -3427,  -556,  6635, -7531, 12968, -19561, 27102, -17606, 21665, -25352, 28206, -14848, 14622, -13133, 10106, -2654,  -713,  5082, -10425,  8324, -11786, 15468, -19197, 11378, -12941, 14134, -14775,  7321, -6723,  5382, -2930,  -175,  1215, -3863, 28221, },
	{   -98, -1902,  6795, -16069,  7818, -13433, 21045, -30569, 10383, -13239, 15814, -17551,  8867, -7759,  4991,  -103, -3653,  8759, -15312, 23225, -16121, 20959, -25797, 30203, -16822, 17757, -17578, 15951, -6281,  3571,   252, -5233,  5677, -9261, 13281, -17602, 11024, -13197, 15184, -16823,  8960, -9114,  8698, -7426,   589,   134, -2130, 29555, },
	{ -1379,   493,  2948, -10592,  6080, -11500, 19286, -29605, 10570, -14161, 17854, -21148, 11678, -11803, 10447, -7066,   564,  3913, -10053, 17898, -13668, 19031, -24774, 30518, -17882, 19952, -21122, 21019, -9631,  7746, -4699,   372,  2649, -6153, 10286, -14966, 10032, -12704, 15390, -17961, 10131, -11055, 11632, -11685,  1360, -1042,    -2, 30347, },
	{  1559, -2735,  3100, -1406, -1018,  3863, -8769, 16293, -6713, 10147, -14299, 18942, -11832, 13921, -15315, 15494, -6929,  4886, -1312, -4055,  5694, -10360, 15957, -22302, 14546, -17942, 21056, -23540, 12500, -12506, 11572, -9490,  3039,  -597, -2626,  6639, -5708,  8443, -11472, 14721, -9050, 10755, -12422, 14002, -1932,  2096, -2253,  2477, },
	{  2119, -4085,  5773, -6040,   794,  1269, -5353, 12173, -5596,  9110, -13609, 18976, -12455, 15444, -18071, 19824, -10040,  9068, -6624,  2356,  2016, -6364, 11883, -18485, 12980, -16976, 20980, -24667, 13822, -14731, 14821, -13843,  5780, -3878,  1128,  2532, -3567,  6336, -9556, 13193, -8603, 10780, -13120, 15653, -2312,  2753, -3437,  5248, },
	{  2628, -5337,  8349, -10692,  2691, -1571, -1415,  7107, -4092,  7491, -12094, 17906, -12379, 16131, -19882, 23161, -12678, 12862, -11721,  8826, -1885, -1889,  7015, -13507, 10629, -15013, 19701, -24408, 14382, -16163, 17294, -17500,  8250, -7009,  4899, -1809, -1175,  3819, -7048, 10872, -7652, 10187, -13086, 16464, -2576,  3289, -4524,  8239, },
	{  3037, -6397, 10656, -15076,  4564, -4503,  2841,  1345, -2272,  5356, -9805, 15749, -11582, 15910, -20610, 25278, -14672, 16038, -16302, 14981, -5791,  2819,  1614, -7622,  7609, -12140, 17262, -22745, 14132, -16702, 18833, -20237, 10303, -9808,  8472, -6141,  1338,  1026, -4078,  7871, -6237,  8992, -12299, 16357, -2704,  3666, -5446, 11366, },
	{  3302, -7171, 12524, -18901,  6296, -7356,  7181, -4812,  -226,  2805, -6842, 12583, -10080, 14758, -20171, 26007, -15886, 18392, -20086, 20459, -9476,  7496, -4026, -1147,  4076, -8501, 13775, -19740, 13068, -16298, 19328, -21876, 11811, -12105, 11637, -10218,  3829, -1889,  -804,  4346, -4427,  7248, -10780, 15304, -2680,  3852, -6137, 14538, },
	{  3380, -7577, 13792, -21887,  7775, -9955, 11351, -11021,  1938,   -30, -3347,  8552, -7932, 12706, -18549, 25259, -16225, 19761, -22830, 24923, -12722, 11873, -9587,  5564,   220, -4284,  9416, -15535, 11231, -14952, 18729, -22300, 12676, -13761, 14206, -13799,  6158, -4763,  2594,   483, -2315,  5036, -8591, 13328, -2501,  3827, -6534, 17656, },
	{  3238, -7546, 14328, -23785,  8892, -12128, 15094, -16916,  4097, -2998,   499,  3854, -5238,  9840, -15795, 23026, -15638, 20034, -24344, 28085, -15330, 15689, -14747, 12130, -3746,   281,  4412, -10341,  8709, -12721, 17046, -21458, 12835, -14666, 16019, -16670,  8186, -7430,  5924, -3505,   -13,  2470, -5835, 10506, -2168,  3575, -6585, 20625, },
	{  2853, -7034, 14031, -24393,  9555, -13718, 18163, -22134,  6124, -5930,  4486, -1266, -2133,  6295, -12027, 19385, -14129, 19162, -24503, 29726, -17132, 18710, -19199, 18170, -7598,  4943,  -964, -4434,  5630, -9711, 14349, -19371, 12264, -14752, 16955, -18650,  9791, -9734,  8994, -7392,  2352,  -314, -2651,  6966, -1692,  3098, -6248, 23347, },
	{  2221, -6021, 12846, -23574,  9693, -14594, 20337, -26330,  7893, -8653,  8388, -6527,  1220,  2251, -7427, 14498, -11755, 17157, -23256, 29704, -18000, 20739, -22667, 23325, -11111,  9436, -6413,  1865,  2160, -6078, 10773, -16130, 10979, -13996, 16943, -19608, 10872, -11533, 11624, -10955,  4647, -3164,   795,  2881, -1095,  2405, -5495, 25734, },
	{  1350, -4520, 10767, -21268,  9260, -14658, 21434, -29201,  9288, -10998, 11973, -11627,  4635, -2075, -2232,  8604, -8624, 14100, -20631, 27973, -17858, 21633, -24927, 27275, -14075, 13497, -11625,  8203, -1514, -2016,  6501, -11895,  9039, -12424, 15961, -19466, 11356, -12715, 13652, -13981,  6738, -5920,  4315, -1539,  -402,  1520, -4313, 27708, },
	{   270, -2577,  7847, -17504,  8245, -13856, 21330, -30508, 10208, -12810, 15018, -16263,  7915, -6445,  3279,  2012, -4892, 10133, -16738, 24582, -16685, 21308, -25815, 29762, -16307, 16884, -16295, 14220, -5185,  2253,  1764, -6888,  6539, -10107, 14046, -18208, 11202, -13197, 14948, -16284,  8501, -8419,  7709, -6056,   351,   479, -2707, 29200, },
	{  -973,  -273,  4195, -12401,  6669, -12184, 19962, -30093, 10576, -13958, 17321, -20146, 10865, -10605,  8797, -4923,  -756,  5457, -11764, 19677, -14520, 19751, -25246, 30606, -17659, 19387, -20142, 19562, -8642,  6488, -3179, -1378,  3612, -7162, 11285, -15881, 10403, -12935, 15420, -17715,  9826, -10513, 10781, -10415,  1124,  -673,  -696, 30163, },
	{ -2315,  2283,   -25, -6170,  4590, -9688, 17341, -27889, 10343, -14344, 18716, -23018, 13301, -14305, 14004, -11811,  3560,   319, -5961, 13498, -11460, 17017, -23213, 29716, -18033, 20839, -22927, 23908, -11683, 10446, -8049,  4331,   414, -3745,  7820, -12595,  8992, -11928, 15020, -18167, 10625, -12069, 13343, -14362,  1876, -1880,  1680, 30562, },
	{  1950, -3676,  4953, -4599,   223,  2100, -6468, 13551, -5983,  9494, -13910, 19082, -12335, 15060, -17316, 18585, -9125,  7811, -4998,   360,  3181, -7655, 13231, -19793, 13549, -17382, 21132, -24465, 13493, -14125, 13895, -12566,  4958, -2876,   -39,  3832, -4258,  7034, -10214, 13752, -8796, 10838, -12981, 15230, -2207,  2562, -3080,  4368, },
	{  2480, -4968,  7577, -9276,  2105,  -680, -2671,  8753, -4593,  8048, -12646, 18353, -12479, 16014, -19435, 22255, -11927, 11750, -10194,  6851,  -674, -3303,  8583, -15148, 11430, -15719, 20221, -24638, 14295, -15814, 16626, -16464,  7528, -6073,  3750,  -463, -1930,  4630, -7876, 11665, -7996, 10435, -13176, 16310, -2509,  3139, -4204,  7300, },
	{  2925, -6097,  9986, -13773,  3997, -3601,  1511,  3175, -2861,  6062, -10587, 16525, -11904, 16077, -20507, 24768, -14136, 15140, -14965, 13143, -4602,  1361,  3316, -9512,  8601, -13113, 18130, -23404, 14297, -16636, 18466, -19505,  9724, -8992,  7406, -4824,   560,  1906, -5032,  8859, -6718,  9422, -12621, 16491, -2680,  3569, -5184, 10395, },
	{  3239, -6968, 12006, -17801,  5785, -6497,  5851, -2896,  -873,  3627, -7818, 13657, -10614, 15211, -20433, 25937, -15602, 17766, -19022, 18867, -8379,  6076, -2284, -3182,  5207, -9692, 14950, -20801, 13480, -16524, 19291, -21497, 11411, -11461, 10719, -9005,  3074,  -989, -1833,  5476, -5020,  7839, -11322, 15729, -2704,  3817, -5953, 13563, },
	{  3378, -7496, 13474, -21074,  7354, -9193, 10102, -9126,  1267,   864, -4469,  9874, -8657, 13429, -19173, 25649, -16218, 19452, -22109, 23676, -11782, 10574, -7904,  3496,  1429, -5630, 10837, -16945, 11874, -15464, 19031, -22304, 12483, -13327, 13490, -12763,  5467, -3893,  1547,  1695, -2990,  5760, -9330, 14031, -2573,  3858, -6446, 16708, },
	{  3306, -7605, 14248, -23331,  8593, -11515, 14003, -15158,  3440, -2080,  -710,  5357, -6118, 10802, -16757, 23868, -15918, 20071, -24018, 27266, -14606, 14589, -13221, 10148, -2528, -1146,  6005, -12029,  9551, -13496, 17676, -21853, 12864, -14472, 15550, -15874,  7601, -6641,  4918, -2278,  -734,  3290, -6736, 11458, -2286,  3677, -6609, 19733, },
	{  2998, -7244, 14215, -24353,  9404, -13300, 17305, -20622,  5522, -5042,  3257,   338, -3123,  7449, -13285, 20647, -14689, 19553, -24603, 29393, -16672, 17878, -17922, 16390, -6439,  3514,   712, -6309,  6628, -10711, 15280, -20142, 12517, -14815, 16766, -18145,  9349, -9072,  8088, -6220,  1625,   557, -3667,  8122, -1853,  3269, -6395, 22541, },
	{  2442, -6385, 13306, -23983,  9710, -14407, 19775, -25167,  7383, -7848,  7211, -4911,   173,  3537, -8918, 16121, -12572, 17891, -23789, 29893, -17838, 20230, -21719, 21853, -10079,  8087, -4747,   -95,  3258, -7251, 11957, -17241, 11448, -14318, 17050, -19428, 10601, -11041, 10872, -9906,  3956, -2290,  -282,  4184, -1290,  2640, -5772, 25040, },
	{  1642, -5032, 11500, -22136,  9455, -14728, 21220, -28474,  8905, -10327, 10918, -10093,  3589,  -728, -3878, 10508, -9659, 15145, -21580, 28687, -18011, 21485, -24371, 26205, -13233, 12309, -10065,  6270,  -374, -3298,  7877, -13292,  9700, -12991, 16365, -19629, 11274, -12423, 13101, -13119,  6124, -5092,  3236,  -158,  -623,  1811, -4723, 27149, },
	{   622, -3218,  8830, -18812,  8619, -14196, 21495, -30284,  9981, -12318, 14152, -14904,  6932, -5111,  1567,  4094, -6093, 11439, -18061, 25795, -17154, 21540, -25695, 29165, -15708, 15928, -14933, 12424, -4068,   932,  3256, -8496,  7361, -10893, 14730, -18713, 11318, -13127, 14633, -15663,  8001, -7687,  6690, -4671,   115,   813, -3245, 28796, },
	{  -577, -1014,  5388, -14103,  7211, -12790, 20518, -30410, 10525, -13682, 16703, -19048, 10004, -9362,  7117, -2776, -2059,  6957, -13395, 21335, -15287, 20360, -25579, 30528, -17344, 18722, -19061, 18010, -7613,  5203, -1653, -3110,  4549, -8127, 12217, -16706, 10716, -13096, 15366, -17375,  9471, -9921,  9882, -9106,   887,  -310, -1356, 29926, },
	{ -1896,  1478,  1322, -8192,  5279, -10539, 18277, -28757, 10480, -14310, 18392, -22256, 12617, -13230, 12454, -9721,  2227,  1933, -7817, 15517, -12489, 17977, -23991, 30176, -18026, 20511, -22196, 22694, -10803,  9272, -6576,  2572,  1417, -4836,  8951, -13699,  9488, -12316, 15237, -18136, 10440, -11655, 12619, -13206,  1650, -1507,   913, 30500, },
	{  1777, -3260,  4129, -3169,  -337,  2903, -7528, 14833, -6333,  9820, -14133, 19084, -12151, 14599, -16476, 17260, -8170,  6525, -3361, -1619,  4319, -8894, 14498, -20985, 14042, -17692, 21169, -24133, 13094, -13448, 12901, -11230,  4115, -1865, -1197,  5102, -4922,  7689, -10812, 14233, -8939, 10837, -12774, 14730, -2090,  2361, -2715,  3512, },
	{  2323, -4584,  6785, -7842,  1520,   198, -3890, 10324, -5060,  8554, -13122, 18695, -12511, 15813, -18888, 21239, -11121, 10586, -8627,  4858,   530, -4687, 10091, -16695, 12163, -16335, 20630, -24734, 14131, -15382, 15873, -15345,  6771, -5111,  2588,   877, -2670,  5410, -8655, 12389, -8295, 10624, -13195, 16070, -2429,  2976, -3870,  6377, },
	{  2800, -5773,  9278, -12426,  3420, -2697,   196,  4958, -3425,  6726, -11301, 17202, -12158, 16156, -20296, 24130, -13529, 14169, -13560, 11251, -3399,   -92,  4986, -11335,  9539, -14009, 18895, -23933, 14383, -16480, 18003, -18673,  9097, -8135,  6308, -3490,  -215,  2770, -5952,  9791, -7159,  9796, -12872, 16534, -2642,  3454, -4902,  9430, },
	{  3159, -6733, 11436, -16629,  5253, -5619,  4514,  -995, -1506,  4417, -8739, 14644, -11085, 15576, -20581, 25729, -15237, 17050, -17866, 17188, -7246,  4636,  -544, -5183,  6302, -10822, 16037, -21742, 13818, -16660, 19151, -21005, 10953, -10759,  9748, -7753,  2306,   -89, -2845,  6568, -5583,  8383, -11799, 16064, -2713,  3761, -5743, 12586, },
	{  3356, -7375, 13090, -20164,  6901, -8395,  8819, -7213,   599,  1741, -5552, 11126, -9326, 14072, -19686, 25897, -16124, 19042, -21276, 22313, -10788,  9230, -6192,  1427,  2620, -6935, 12190, -18255, 12449, -15890, 19228, -22188, 12224, -12825, 12706, -11666,  4752, -3008,   499,  2889, -3644,  6447, -10012, 14650, -2630,  3869, -6327, 15749, },
	{  3353, -7620, 14091, -22758,  8253, -10850, 12855, -13345,  2776, -1165, -1899,  6812, -6954, 11694, -17619, 24574, -16109, 20000, -23566, 26307, -13811, 13421, -11637,  8127, -1305, -2556,  7554, -13640, 10336, -14194, 18207, -22127, 12823, -14203, 15001, -14998,  6980, -5822,  3893, -1048, -1445,  4084, -7591, 12337, -2390,  3757, -6597, 18821, },
	{  3119, -7408, 14316, -24181,  9205, -12817, 16367, -19023,  4899, -4139,  2028,  1920, -4084,  8548, -14457, 21785, -15165, 19835, -24570, 28906, -16126, 16957, -16559, 14535, -5254,  2077,  2373, -8137,  7582, -11648, 16122, -20799, 12702, -14798, 16488, -17545,  8859, -8367,  7146, -5024,   896,  1417, -4653,  9221, -2001,  3418, -6503, 21706, },
	{  2639, -6703, 13682, -24252,  9673, -14146, 19116, -23886,  6841, -7012,  6010, -3289,  -863,  4788, -10345, 17641, -13313, 18522, -24190, 29919, -17581, 19617, -20663, 20276, -9001,  6706, -3068, -2039,  4332, -8377, 13069, -18253, 11852, -14560, 17065, -19145, 10274, -10492, 10067, -8813,  3250, -1411, -1346,  5449, -1476,  2856, -6008, 24309, },
	{  1913, -5499, 12150, -22864,  9595, -14718, 20894, -27605,  8480, -9609,  9817, -8524,  2537,   608, -5485, 12335, -10633, 16099, -22405, 29240, -18067, 21223, -23689, 25002, -12327, 11063, -8462,  4318,   760, -4555,  9201, -14608, 10306, -13485, 16679, -19686, 11132, -12066, 12483, -12193,  5482, -4244,  2151,  1208,  -838,  2086, -5091, 26546, },
	{   957, -3821,  9739, -19989,  8938, -14453, 21541, -29899,  9703, -11766, 13220, -13482,  5923, -3765,  -134,  6133, -7250, 12672, -19275, 26860, -17528, 21654, -25437, 28416, -15029, 14892, -13501, 10575, -2938,  -385,  4721, -10047,  8137, -11615, 15331, -19113, 11374, -12987, 14243, -14962,  7461, -6920,  5646, -3279,  -118,  1136, -3745, 28342, },
	{  -192, -1728,  6522, -15690,  7703, -13315, 20955, -30558, 10419, -13336, 16002, -17861,  9099, -8083,  5418,  -636, -3337,  8406, -14940, 22864, -15966, 20854, -25771, 30288, -16938, 17962, -17886, 16373, -6551,  3899,  -128, -4813,  5456, -9041, 13077, -17435, 10970, -13186, 15230, -16945,  9068, -9281,  8940, -7765,   648,    46, -1979, 29636, },
	{ -1481,   688,  2629, -10124,  5925, -11318, 19099, -29457, 10559, -14200, 17973, -21383, 11872, -12095, 10854, -7600,   896,  3521, -9614, 17436, -13442, 18833, -24635, 30470, -17923, 20077, -21350, 21367, -9872,  8056, -5077,   811,  2405, -5894, 10027, -14723,  9930, -12635, 15370, -18008, 10200, -11182, 11836, -11996,  1419, -1134,   177, 30384, },
	{  1603, -2840,  3305, -1755,  -883,  3675, -8528, 16014, -6642, 10089, -14276, 18983, -11904, 14065, -15557, 15856, -7181,  5216, -1721, -3573,  5423, -10075, 15676, -22055, 14455, -17905, 21093, -23674, 12627, -12703, 11845, -9843,  3256,  -850, -2342,  6337, -5555,  8299, -11348, 14634, -9034, 10779, -12501, 14156, -1965,  2150, -2346,  2681, },
	{  2161, -4186,  5977, -6401,   939,  1057, -5066, 11814, -5493,  9006, -13521, 18933, -12474, 15528, -18246, 20119, -10262,  9377, -7028,  2857,  1721, -6034, 11533, -18141, 12826, -16860, 20924, -24697, 13893, -14871, 15041, -14152,  5982, -4127,  1421,  2204, -3390,  6156, -9383, 13042, -8548, 10756, -13143, 15747, -2337,  2799, -3525,  5471, },
	{  2663, -5427,  8538, -11042,  2837, -1796, -1096,  6685, -3963,  7344, -11945, 17778, -12344, 16147, -19978, 23370, -12856, 13131, -12096,  9315, -2188, -1532,  6615, -13082, 10419, -14822, 19553, -24329, 14392, -16237, 17447, -17746,  8425, -7239,  5184, -2146,  -984,  3612, -6834, 10664, -7559, 10116, -13052, 16489, -2591,  3324, -4602,  8476, },
	{  3064, -6468, 10818, -15394,  4703, -4727,  3175,   881, -2121,  5173, -9600, 15539, -11491, 15854, -20618, 25385, -14794, 16251, -16625, 15431, -6085,  3183,  1184, -7141,  7354, -11885, 17029, -22560, 14079, -16705, 18909, -20404, 10440, -10004,  8732, -6467,  1532,   804, -3834,  7617, -6110,  8877, -12208, 16310, -2707,  3687, -5509, 11610, },
	{  3315, -7216, 12644, -19164,  6421, -7567,  7511, -5292,   -62,  2596, -6590, 12302, -9937, 14631, -20088, 26003, -15944, 18534, -20337, 20843, -9744,  7847, -4461,  -634,  3789, -8194, 13468, -19457, 12953, -16228, 19321, -21953, 11901, -12257, 11858, -10514,  4016, -2114,  -544,  4058, -4274,  7093, -10634, 15184, -2672,  3858, -6178, 14781, },
	{  3377, -7591, 13861, -22075,  7875, -10140, 11658, -11490,  2106,  -256, -3061,  8212, -7743, 12513, -18377, 25140, -16213, 19822, -22992, 25216, -12948, 12190, -10003,  6079,   -84, -3942,  9051, -15167, 11060, -14811, 18638, -22281, 12714, -13858, 14375, -14047,  6326, -4977,  2855,   178, -2143,  4850, -8398, 13140, -2481,  3815, -6551, 17891, },
	{  3217, -7524, 14336, -23880,  8960, -12273, 15357, -17346,  4259, -3227,   803,  3472, -5012,  9590, -15539, 22794, -15554, 20008, -24406, 28268, -15499, 15953, -15119, 12618, -4050,   640,  4008, -9908,  8490, -12515, 16873, -21341, 12817, -14702, 16124, -16856,  8326, -7622,  6172, -3810,   168,  2262, -5603, 10258, -2136,  3547, -6573, 20844, },
	{  2814, -6973, 13972, -24382,  9585, -13812, 18365, -22497,  6271, -6149,  4792, -1670, -1881,  6000, -11700, 19050, -13976, 19047, -24457, 29784, -17233, 18903, -19504, 18603, -7883,  5298, -1384, -3959,  5375, -9451, 14104, -19161, 12190, -14723, 16989, -18762,  9894, -9892,  9215, -7680,  2533,  -533, -2393,  6669, -1650,  3052, -6205, 23544, },
	{  2162, -5922, 12717, -23450,  9680, -14628, 20461, -26601,  8015, -8849,  8678, -6929,  1483,  1926, -7046, 14076, -11539, 16958, -23102, 29632, -18025, 20849, -22886, 23675, -11361,  9767, -6826,  2355,  1882, -5778, 10466, -15837, 10852, -13903, 16901, -19637, 10932, -11648, 11803, -11209,  4816, -3382,  1066,  2550, -1044,  2343, -5419, 25902, },
	{  1274, -4385, 10571, -21030,  9203, -14627, 21470, -29359,  9377, -11159, 12230, -12004,  4894, -2413, -1816,  8118, -8356, 13825, -20374, 27770, -17804, 21651, -25045, 27521, -14275, 13785, -12007,  8682, -1799, -1692,  6150, -11535,  8865, -12271, 15846, -19409, 11367, -12778, 13779, -14186,  6887, -6123,  4583, -1887,  -346,  1445, -4205, 27840, },
	{   179, -2412,  7591, -17157,  8143, -13758, 21270, -30539, 10257, -12923, 15224, -16592,  8156, -6775,  3707,  1485, -4586,  9795, -16391, 24256, -16553, 21232, -25824, 29887, -16444, 17111, -16623, 14659, -5461,  2583,  1387, -6479,  6327, -9901, 13862, -18066, 11163, -13204, 15014, -16427,  8620, -8597,  7960, -6400,   410,   393, -2566, 29294, },
	{ -1074,   -83,  3888, -11959,  6526, -12021, 19804, -29987, 10580, -14015, 17463, -20406, 11073, -10909,  9213, -5460,  -427,  5075, -11343, 19244, -14315, 19581, -25141, 30599, -17724, 19537, -20397, 19935, -8893,  6805, -3560,  -942,  3373, -6914, 11042, -15661, 10316, -12884, 15420, -17785,  9907, -10654, 10998, -10737,  1184,  -765,  -526, 30214, },
	{ -2420,  2487,  -367, -5652,  4412, -9465, 17089, -27645, 10300, -14340, 18782, -23191, 13462, -14564, 14382, -12327,  3892,   -87, -5489, 12978, -11191, 16761, -22997, 29575, -18019, 20903, -23091, 24192, -11895, 10732, -8413,  4769,   162, -3467,  7529, -12307,  8859, -11820, 14953, -18160, 10663, -12163, 13514, -14641,  1932, -1974,  1877, 30569, },
	{  1993, -3779,  5158, -4959,   365,  1894, -6194, 13215, -5890,  9403, -13842, 19065, -12371, 15163, -17513, 18904, -9358,  8128, -5406,   858,  2892, -7337, 12902, -19477, 13414, -17290, 21105, -24528, 13581, -14283, 14133, -12891,  5166, -3128,   253,  3509, -4088,  6863, -10055, 13619, -8752, 10829, -13022, 15343, -2234,  2611, -3170,  4586, },
	{  2517, -5062,  7772, -9632,  2251,  -902, -2360,  8348, -4470,  7913, -12515, 18251, -12461, 16052, -19556, 22492, -12120, 12033, -10580,  7347,  -977, -2952,  8196, -14746, 11236, -15551, 20102, -24593, 14324, -15909, 16801, -16731,  7712, -6310,  4039,  -799, -1742,  4430, -7673, 11473, -7914, 10378, -13160, 16356, -2527,  3178, -4285,  7533, },
	{  2954, -6174, 10157, -14104,  4140, -3827,  1842,  2721, -2716,  5889, -10398, 16340, -11830, 16044, -20543, 24907, -14276, 15371, -15306, 13608, -4901,  1725,  2893, -9045,  8358, -12877, 17923, -23251, 14263, -16661, 18567, -19697,  9873, -9200,  7676, -5155,   755,  1687, -4796,  8617, -6601,  9319, -12547, 16466, -2687,  3595, -5252, 10637, },
	{  3256, -7022, 12140, -18083,  5915, -6714,  6185, -3374,  -712,  3424, -7579, 13397, -10487, 15106, -20378, 25968, -15681, 17931, -19297, 19273, -8656,  6434, -2720, -2676,  4928, -9399, 14665, -20547, 13384, -16476, 19310, -21603, 11517, -11628, 10953, -9312,  3264, -1214, -1577,  5196, -4875,  7695, -11193, 15631, -2699,  3828, -6001, 13807, },
	{  3380, -7520, 13560, -21287,  7462, -9387, 10417, -9602,  1434,   642, -4192,  9550, -8481, 13256, -19027, 25565, -16228, 19539, -22300, 23999, -12023, 10904, -8328,  4014,  1128, -5297, 10488, -16602, 11719, -15344, 18965, -22314, 12537, -13442, 13676, -13028,  5642, -4112,  1809,  1393, -2823,  5582, -9151, 13863, -2556,  3852, -6471, 16947, },
	{  3291, -7595, 14275, -23455,  8672, -11673, 14282, -15603,  3605, -2310,  -409,  4985, -5902, 10568, -16526, 23671, -15856, 20072, -24112, 27484, -14794, 14871, -13609, 10647, -2833,  -790,  5610, -11614,  9345, -13309, 17528, -21765, 12863, -14528, 15675, -16080,  7751, -6841,  5171, -2585,  -554,  3087, -6515, 11227, -2258,  3654, -6606, 19958, },
	{  2964, -7196, 14177, -24376,  9447, -13410, 17527, -21009,  5674, -5266,  3565,   -61, -2878,  7165, -12978, 20343, -14557, 19465, -24591, 29491, -16795, 18094, -18249, 16842, -6731,  3873,   295, -5844,  6382, -10467, 15056, -19959, 12460, -14806, 16822, -18280,  9464, -9242,  8319, -6516,  1808,   340, -3415,  7839, -1814,  3228, -6362, 22745, },
	{  2389, -6299, 13199, -23894,  9710, -14461, 19925, -25469,  7514, -8053,  7507, -5316,   434,  3218, -8551, 15725, -12375, 17717, -23668, 29861, -17887, 20367, -21967, 22232, -10342,  8428, -5165,   394,  2986, -6962, 11668, -16973, 11337, -14244, 17032, -19483, 10674, -11169, 11065, -10173,  4130, -2509,   -14,  3861, -1242,  2583, -5706, 25218, },
	{  1571, -4908, 11324, -21932,  9412, -14718, 21284, -28669,  9005, -10499, 11186, -10480,  3851, -1064, -3470, 10039, -9406, 14892, -21354, 28523, -17982, 21532, -24522, 26485, -13450, 12611, -10459,  6756,  -659, -2980,  7538, -12950,  9540, -12856, 16273, -19599, 11300, -12502, 13245, -13341,  6280, -5301,  3506,  -502,  -569,  1740, -4624, 27293, },
	{   535, -3061,  8591, -18498,  8530, -14119, 21465, -30355, 10043, -12447, 14375, -15250,  7180, -5446,  1995,  3577, -5797, 11119, -17740, 25506, -17046, 21493, -25738, 29329, -15865, 16174, -15280, 12879, -4349,  1262,  2885, -8099,  7159, -10702, 14567, -18596, 11295, -13151, 14719, -15826,  8129, -7873,  6947, -5018,   174,   731, -3114, 28901, },
	{  -675,  -831,  5095, -13688,  7080, -12646, 20391, -30346, 10543, -13758, 16865, -19331, 10224, -9676,  7540, -3313, -1735,  6587, -12995, 20933, -15104, 20218, -25509, 30563, -17431, 18897, -19340, 18406, -7874,  5526, -2035, -2679,  4317, -7890, 11991, -16508, 10644, -13063, 15387, -17468,  9564, -10073, 10111, -9437,   946,  -400, -1194, 29990, },
	{ -2000,  1678,   989, -7694,  5111, -10333, 18053, -28556, 10452, -14326, 18482, -22457, 12793, -13505, 12846, -10246,  2561,  1531, -7358, 15021, -12239, 17747, -23809, 30076, -18037, 20603, -22389, 23008, -11029,  9570, -6947,  3012,  1167, -4566,  8673, -13431,  9369, -12225, 15190, -18153, 10491, -11764, 12806, -13501,  1707, -1600,  1102, 30521, },
	{  1821, -3365,  4335, -3525,  -198,  2705, -7268, 14522, -6249,  9744, -14084, 19093, -12203, 14721, -16693, 17599, -8412,  6849, -3771, -1127,  4037, -8589, 14189, -20698, 13926, -17624, 21171, -24228, 13200, -13623, 13156, -11570,  4328, -2118,  -909,  4787, -4759,  7530, -10668, 14120, -8908, 10843, -12832, 14862, -2120,  2412, -2807,  3724, },
	{  2363, -4681,  6984, -8202,  1666,   -20, -3589,  9939, -4946,  8432, -13010, 18619, -12509, 15871, -19034, 21503, -11327, 10882, -9022,  5358,   230, -4344,  9720, -16318, 11986, -16190, 20538, -24722, 14179, -15498, 16069, -15632,  6963, -5353,  2880,   543, -2486,  5218, -8465, 12215, -8225, 10582, -13197, 16138, -2450,  3018, -3955,  6606, },
	{  2832, -5856,  9458, -12766,  3565, -2923,   523,  4517, -3287,  6564, -11129, 17042, -12101, 16145, -20359, 24301, -13687, 14418, -13917, 11728, -3701,   270,  4572, -10886,  9310, -13792, 18714, -23813, 14369, -16527, 18128, -18890,  9258, -8353,  6586, -3825,   -22,  2555, -5726,  9563, -7053,  9708, -12816, 16532, -2653,  3484, -4975,  9671, },
	{  3180, -6795, 11583, -16929,  5388, -5840,  4849, -1468, -1349,  4223, -8514, 14406, -10974, 15493, -20555, 25794, -15336, 17237, -18163, 17615, -7532,  4998,  -979, -4686,  6032, -10545, 15774, -21518, 13741, -16634, 19195, -21139, 11073, -10940,  9995, -8069,  2499,  -314, -2594,  6299, -5445,  8251, -11686, 15989, -2712,  3777, -5798, 12830, },
	{  3363, -7409, 13192, -20400,  7017, -8598,  9142, -7693,   765,  1523, -5285, 10820, -9164, 13919, -19568, 25848, -16155, 19154, -21495, 22664, -11041,  9570, -6622,  1944,  2324, -6613, 11859, -17937, 12312, -15792, 19189, -22228, 12295, -12957, 12908, -11946,  4933, -3231,   760,  2592, -3483,  6279, -9848, 14503, -2617,  3868, -6360, 15990, },
	{  3343, -7620, 14138, -22912,  8342, -11021, 13147, -13803,  2942, -1393, -1604,  6453, -6749, 11478, -17413, 24411, -16070, 20028, -23691, 26559, -14016, 13719, -12038,  8635, -1610, -2205,  7171, -13245, 10145, -14027, 18084, -22070, 12840, -14277, 15145, -15224,  7139, -6029,  4151, -1355, -1268,  3888, -7382, 12124, -2366,  3739, -6603, 19051, },
	{  3091, -7371, 14299, -24236,  9260, -12943, 16609, -19430,  5056, -4366,  2335,  1527, -3847,  8279, -14173, 21512, -15054, 19775, -24591, 29042, -16271, 17195, -16907, 15005, -5552,  2437,  1960, -7685,  7348, -11420, 15920, -20646, 12662, -14810, 16566, -17704,  8986, -8547,  7385, -5325,  1079,  1203, -4409,  8952, -1965,  3383, -6479, 21917, },
	{  2592, -6628, 13596, -24198,  9687, -14218, 19290, -24217,  6980, -7224,  6312, -3695,  -605,  4479, -9995, 17271, -13135, 18374, -24102, 29927, -17654, 19780, -20937, 20680, -9275,  7054, -3488, -1555,  4066, -8100, 12798, -18010, 11757, -14507, 17070, -19226, 10360, -10635, 10273, -9090,  3428, -1631, -1082,  5136, -1430,  2804, -5953, 24496, },
	{  1847, -5387, 11995, -22695,  9565, -14728, 20986, -27836,  8590, -9793, 10096, -8919,  2800,   275, -5088, 11885, -10395, 15870, -22210, 29117, -18062, 21299, -23872, 25315, -12559, 11379, -8867,  4807,   477, -4243,  8875, -14287, 10160, -13368, 16609, -19682, 11173, -12162, 12644, -12430,  5645, -4458,  2422,   868,  -785,  2019, -5003, 26701, },
	{   875, -3674,  9519, -19707,  8864, -14397, 21541, -30010,  9777, -11909, 13459, -13843,  6177, -4102,   290,  5628, -6965, 12371, -18982, 26608, -17444, 21637, -25514, 28617, -15206, 15158, -13865, 11042, -3221,   -57,  4357, -9665,  7947, -11441, 15189, -19023, 11366, -13028, 14348, -15144,  7600, -7115,  5909, -3627,   -60,  1056, -3624, 28460, },
	{  -287, -1553,  6244, -15305,  7585, -13191, 20857, -30537, 10450, -13429, 16184, -18166,  9329, -8406,  5844, -1170, -3020,  8049, -14563, 22494, -15805, 20741, -25736, 30363, -17047, 18160, -18188, 16789, -6819,  4226,  -509, -4390,  5232, -8817, 12869, -17262, 10912, -13170, 15272, -17060,  9173, -9445,  9179, -8103,   708,   -42, -1827, 29713, },
	{ -1585,   884,  2306, -9650,  5768, -11130, 18904, -29298, 10545, -14235, 18087, -21611, 12064, -12384, 11258, -8132,  1228,  3126, -9171, 16966, -13211, 18629, -24487, 30412, -17957, 20195, -21572, 21709, -10109,  8364, -5453,  1251,  2159, -5633,  9763, -14475,  9825, -12561, 15345, -18049, 10265, -11305, 12037, -12303,  1477, -1227,   358, 30418, },
	{  1646, -2946,  3511, -2107,  -748,  3485, -8284, 15729, -6569, 10027, -14247, 19018, -11971, 14205, -15794, 16214, -7431,  5545, -2131, -3087,  5150, -9785, 15390, -21799, 14359, -17861, 21122, -23801, 12750, -12895, 12114, -10195,  3472, -1104, -2058,  6032, -5399,  8151, -11220, 14541, -9015, 10799, -12575, 14306, -1997,  2203, -2439,  2886, },
	{  2202, -4287,  6180, -6762,  1083,   844, -4776, 11449, -5388,  8898, -13429, 18883, -12490, 15607, -18415, 20408, -10482,  9683, -7430,  3357,  1425, -5701, 11179, -17789, 12667, -16737, 20862, -24719, 13959, -15006, 15256, -14457,  6182, -4375,  1713,  1874, -3212,  5973, -9206, 12885, -8489, 10729, -13163, 15835, -2361,  2844, -3612,  5696, },
	{  2698, -5515,  8726, -11391,  2984, -2020,  -775,  6259, -3831,  7194, -11790, 17643, -12304, 16158, -20068, 23571, -13030, 13397, -12467,  9803, -2491, -1174,  6212, -12653, 10205, -14627, 19399, -24243, 14397, -16306, 17595, -17986,  8597, -7466,  5467, -2482,  -793,  3404, -6617, 10451, -7463, 10041, -13014, 16509, -2605,  3358, -4679,  8713, },
	{  3089, -6537, 10976, -15708,  4842, -4951,  3509,   415, -1969,  4987, -9390, 15324, -11396, 15793, -20619, 25483, -14912, 16458, -16943, 15877, -6377,  3547,   754, -6656,  7095, -11626, 16790, -22367, 14021, -16702, 18979, -20564, 10573, -10198,  8990, -6791,  1726,   582, -3589,  7359, -5982,  8758, -12112, 16257, -2710,  3707, -5569, 11854, },
	{  3327, -7259, 12761, -19422,  6543, -7777,  7840, -5773,   103,  2384, -6335, 12015, -9789, 14499, -19998, 25989, -15997, 18670, -20581, 21220, -10009,  8196, -4895,  -120,  3499, -7884, 13156, -19167, 12834, -16152, 19308, -22023, 11988, -12405, 12076, -10807,  4202, -2338,  -284,  3768, -4119,  6935, -10485, 15059, -2663,  3863, -6218, 15023, },
	{  3373, -7602, 13925, -22256,  7973, -10321, 11961, -11957,  2273,  -482, -2773,  7867, -7550, 12316, -18197, 25012, -16195, 19876, -23147, 25501, -13169, 12503, -10415,  6593,  -389, -3598,  8682, -14794, 10884, -14665, 18540, -22254, 12747, -13951, 14538, -14292,  6493, -5191,  3115,  -128, -1970,  4661, -8201, 12947, -2459,  3803, -6565, 18125, },
	{  3194, -7499, 14339, -23967,  9026, -12414, 15616, -17772,  4420, -3456,  1108,  3087, -4783,  9335, -15278, 22554, -15465, 19975, -24459, 28441, -15663, 16211, -15485, 13102, -4352,   999,  3602, -9471,  8268, -12305, 16694, -21217, 12795, -14733, 16223, -17036,  8463, -7812,  6418, -4115,   350,  2052, -5369, 10005, -2103,  3517, -6559, 21062, },
	{  2772, -6910, 13907, -24362,  9612, -13902, 18561, -22854,  6416, -6367,  5098, -2074, -1629,  5701, -11368, 18709, -13818, 18926, -24403, 29833, -17328, 19091, -19803, 19029, -8166,  5652, -1805, -3482,  5118, -9188, 13853, -18944, 12112, -14690, 17016, -18867,  9994, -10046,  9432, -7967,  2713,  -752, -2133,  6368, -1608,  3005, -6159, 23738, },
	{  2102, -5821, 12583, -23316,  9664, -14658, 20579, -26864,  8135, -9043,  8966, -7330,  1746,  1598, -6660, 13649, -11319, 16752, -22940, 29549, -18045, 20953, -23098, 24018, -11608, 10095, -7238,  2846,  1603, -5475, 10156, -15538, 10721, -13806, 16854, -19659, 10987, -11758, 11979, -11460,  4985, -3599,  1337,  2217,  -993,  2281, -5341, 26067, },
	{  1196, -4248, 10371, -20782,  9142, -14591, 21499, -29509,  9463, -11315, 12482, -12378,  5153, -2751, -1397,  7627, -8084, 13544, -20111, 27557, -17744, 21663, -25156, 27758, -14471, 14068, -12386,  9159, -2084, -1366,  5797, -11169,  8688, -12113, 15725, -19345, 11375, -12837, 13902, -14387,  7034, -6325,  4850, -2234,  -289,  1369, -4093, 27970, },
	{    88, -2244,  7330, -16802,  8038, -13655, 21202, -30559, 10302, -13033, 15425, -16917,  8395, -7105,  4135,   957, -4277,  9454, -16038, 23921, -16415, 21148, -25824, 30002, -16575, 17332, -16947, 15094, -5736,  2913,  1010, -6066,  6113, -9691, 13673, -17918, 11121, -13206, 15076, -16564,  8736, -8772,  8208, -6743,   469,   307, -2423, 29384, },
	{ -1175,   107,  3578, -11510,  6380, -11852, 19639, -29870, 10580, -14069, 17599, -20660, 11278, -11210,  9626, -5996,   -97,  4690, -10918, 18803, -14105, 19405, -25028, 30583, -17782, 19682, -20645, 20303, -9142,  7121, -3940,  -505,  3133, -6663, 10794, -15435, 10225, -12828, 15415, -17850,  9985, -10791, 11213, -11055,  1243,  -857,  -353, 30261, },
};

int nextstate_160_147[160] = {
	0x00102400, 0x00202301, 0x00302201, 0x00402101, 0x00502001, 0x00601f01, 0x00701e01, 0x00801d01, 
	0x00901c01, 0x00a01b01, 0x00b01a01, 0x00c01901, 0x00d01800, 0x00e01701, 0x00f01601, 0x01001501, 
	0x01101401, 0x01201301, 0x01301201, 0x01401101, 0x01501001, 0x01600f01, 0x01700e01, 0x01800d01, 
	0x01900c00, 0x01a00b01, 0x01b00a01, 0x01c00901, 0x01d00801, 0x01e00701, 0x01f00601, 0x02000501, 
	0x02100401, 0x02200301, 0x02300201, 0x02400101, 0x02500000, 0x02609f01, 0x02709e01, 0x02809d01, 
	0x02909c01, 0x02a09b01, 0x02b09a01, 0x02c09901, 0x02d09801, 0x02e09701, 0x02f09601, 0x03009501, 
	0x03109401, 0x03209300, 0x03309201, 0x03409101, 0x03509001, 0x03608f01, 0x03708e01, 0x03808d01, 
	0x03908c01, 0x03a08b01, 0x03b08a01, 0x03c08901, 0x03d08801, 0x03e08700, 0x03f08601, 0x04008501, 
	0x04108401, 0x04208301, 0x04308201, 0x04408101, 0x04508001, 0x04607f01, 0x04707e01, 0x04807d01, 
	0x04907c01, 0x04a07b00, 0x04b07a01, 0x04c07901, 0x04d07801, 0x04e07701, 0x04f07601, 0x05007501, 
	0x05107401, 0x05207301, 0x05307201, 0x05407101, 0x05507001, 0x05606f01, 0x05706e00, 0x05806d01, 
	0x05906c01, 0x05a06b01, 0x05b06a01, 0x05c06901, 0x05d06801, 0x05e06701, 0x05f06601, 0x06006501, 
	0x06106401, 0x06206301, 0x06306200, 0x06406101, 0x06506001, 0x06605f01, 0x06705e01, 0x06805d01, 
	0x06905c01, 0x06a05b01, 0x06b05a01, 0x06c05901, 0x06d05801, 0x06e05701, 0x06f05600, 0x07005501, 
	0x07105401, 0x07205301, 0x07305201, 0x07405101, 0x07505001, 0x07604f01, 0x07704e01, 0x07804d01, 
	0x07904c01, 0x07a04b01, 0x07b04a01, 0x07c04900, 0x07d04801, 0x07e04701, 0x07f04601, 0x08004501, 
	0x08104401, 0x08204301, 0x08304201, 0x08404101, 0x08504001, 0x08603f01, 0x08703e01, 0x08803d00, 
	0x08903c01, 0x08a03b01, 0x08b03a01, 0x08c03901, 0x08d03801, 0x08e03701, 0x08f03601, 0x09003501, 
	0x09103401, 0x09203301, 0x09303201, 0x09403100, 0x09503001, 0x09602f01, 0x09702e01, 0x09802d01, 
	0x09902c01, 0x09a02b01, 0x09b02a01, 0x09c02901, 0x09d02801, 0x09e02701, 0x09f02601, 0x00002501, 
};
#endif // HELIX_FEATURE_MMXFILTER_160_147

#ifdef HELIX_FEATURE_MMXFILTER_441_80
/*
 * inrate=8000 outrate=44100 up=441 dn=80
 */

ALIGN
filtwing filter_441_80[441] = {
	{ -2562,  2758,  -822, -4966,  4176, -9169, 16755, -27322, 10241, -14333, 18866, -23415, 13672, -14903, 14879, -13006,  4331,  -625, -4863, 12287, -10832, 16417, -22704, 29377, -17994, 20980, -23299, 24558, -12168, 11105, -8889,  5346,  -171, -3099,  7141, -11920,  8680, -11672, 14857, -18141, 10707, -12281, 13733, -15003,  2005, -2097,  2138, 30572, },
	{   334, -2696,  8033, -17759,  8321, -13931, 21379, -30495, 10176, -12733, 14876, -16034,  7746, -6212,  2977,  2383, -5109, 10371, -16983, 24811, -16777, 21361, -25807, 29671, -16209, 16723, -16061, 13908, -4989,  2020,  2029, -7176,  6688, -10251, 14173, -18305, 11227, -13190, 14898, -16181,  8416, -8293,  7531, -5812,   309,   539, -2805, 29133, },
	{  2431, -6370, 13291, -23979,  9717, -14431, 19827, -25261,  7422, -7906,  7293, -5021,   243,  3452, -8822, 16019, -12522, 17849, -23762, 29890, -17854, 20270, -21789, 21958, -10151,  8180, -4860,    37,  3186, -7174, 11880, -17171, 11419, -14299, 17046, -19444, 10621, -11076, 10925, -9978,  4003, -2349,  -210,  4097, -1277,  2625, -5755, 25088, },
	{  3346, -7629, 14162, -22967,  8369, -11069, 13225, -13921,  2984, -1450, -1532,  6367, -6701, 11428, -17367, 24375, -16063, 20037, -23725, 26624, -14068, 13793, -12137,  8760, -1685, -2120,  7078, -13149, 10099, -13986, 18054, -22056, 12844, -14295, 15180, -15279,  7177, -6080,  4213, -1430, -1225,  3840, -7330, 12072, -2360,  3734, -6604, 19107, },
	{  3124, -6627, 11177, -16100,  5014, -5227,  3919,  -156, -1783,  4760, -9133, 15060, -11278, 15716, -20617, 25599, -15053, 16708, -17327, 16417, -6733,  3991,   228, -6062,  6776, -11305, 16492, -22124, 13945, -16692, 19057, -20752, 10732, -10429,  9301, -7184,  1962,   310, -3289,  7041, -5822,  8609, -11989, 16185, -2712,  3731, -5641, 12151, },
	{  2131, -4110,  5819, -6115,   823,  1229, -5301, 12110, -5579,  9094, -13598, 18974, -12463, 15465, -18110, 19887, -10086,  9130, -6704,  2454,  1959, -6301, 11817, -18421, 12952, -16956, 20972, -24675, 13837, -14759, 14864, -13904,  5820, -3927,  1185,  2469, -3533,  6302, -9523, 13164, -8593, 10775, -13125, 15672, -2317,  2762, -3454,  5291, },
	{ -1092,   -51,  3840, -11893,  6506, -12000, 19787, -29982, 10585, -14030, 17492, -20456, 11111, -10963,  9285, -5552,  -372,  5011, -11274, 19173, -14282, 19555, -25126, 30601, -17736, 19564, -20441, 19999, -8936,  6859, -3625,  -869,  3333, -6872, 11000, -15623, 10301, -12875, 15420, -17797,  9921, -10677, 11035, -10791,  1194,  -780,  -497, 30222, },
	{  1490, -4768, 11128, -21706,  9364, -14710, 21361, -28896,  9120, -10697, 11494, -10924,  4152, -1450, -3001,  9499, -9114, 14599, -21090, 28329, -17944, 21581, -24688, 26798, -13695, 12954, -10908,  7310,  -985, -2614,  7146, -12554,  9353, -12696, 16160, -19556, 11326, -12588, 13405, -13589,  6457, -5538,  3815,  -897,  -505,  1657, -4508, 27454, },
	{  3032, -7293, 14259, -24346,  9371, -13207, 17114, -20287,  5389, -4846,  2987,   689, -3338,  7698, -13554, 20914, -14804, 19628, -24612, 29304, -16561, 17685, -17631, 15989, -6180,  3199,  1080, -6717,  6842, -10924, 15474, -20297, 12564, -14818, 16713, -18021,  9245, -8921,  7884, -5959,  1465,   747, -3887,  8370, -1886,  3303, -6422, 22360, },
	{  3363, -7387, 13113, -20203,  6917, -8420,  8854, -7262,   615,  1721, -5529, 11101, -9314, 14062, -19681, 25899, -16131, 19057, -21301, 22350, -10813,  9263, -6234,  1475,  2593, -6906, 12161, -18227, 12437, -15882, 19226, -22193, 12231, -12838, 12725, -11693,  4769, -3029,   523,  2861, -3629,  6431, -9997, 14637, -2629,  3869, -6330, 15771, },
	{  2706, -5529,  8748, -11425,  2996, -2037,  -754,  6233, -3824,  7186, -11784, 17640, -12305, 16163, -20079, 23591, -13045, 13418, -12495,  9838, -2513, -1149,  6185, -12625, 10191, -14615, 19390, -24238, 14398, -16312, 17606, -18004,  8609, -7482,  5487, -2506,  -779,  3389, -6603, 10437, -7456, 10036, -13011, 16510, -2606,  3360, -4684,  8730, },
	{  1520, -2638,  2907, -1074, -1146,  4043, -9000, 16562, -6782, 10204, -14322, 18904, -11764, 13783, -15084, 15147, -6688,  4571,  -921, -4516,  5951, -10631, 16221, -22534, 14629, -17975, 21016, -23406, 12376, -12316, 11308, -9149,  2831,  -355, -2895,  6925, -5852,  8579, -11587, 14800, -9063, 10729, -12344, 13851, -1900,  2044, -2164,  2284, },
	{   268, -2577,  7850, -17511,  8249, -13863, 21340, -30524, 10214, -12817, 15028, -16275,  7922, -6453,  3288,  2002, -4888, 10129, -16735, 24580, -16685, 21310, -25819, 29768, -16311, 16890, -16302, 14229, -5190,  2259,  1757, -6881,  6536, -10104, 14042, -18206, 11201, -13198, 14949, -16287,  8504, -8423,  7714, -6063,   352,   477, -2704, 29202, },
	{  2393, -6307, 13212, -23914,  9717, -14469, 19935, -25480,  7517, -8055,  7508, -5315,   432,  3221, -8556, 15731, -12379, 17722, -23673, 29866, -17889, 20369, -21968, 22232, -10341,  8427, -5163,   391,  2988, -6964, 11670, -16975, 11338, -14245, 17032, -19483, 10674, -11169, 11064, -10171,  4129, -2508,   -15,  3863, -1242,  2583, -5707, 25217, },
	{  3338, -7627, 14192, -23073,  8431, -11191, 13435, -14251,  3105, -1616, -1317,  6104, -6550, 11267, -17212, 24250, -16030, 20052, -23809, 26801, -14213, 14006, -12425,  9127, -1907, -1865,  6798, -12858,  9957, -13861, 17959, -22008, 12852, -14345, 15282, -15439,  7291, -6229,  4400, -1653, -1096,  3696, -7176, 11914, -2341,  3720, -6607, 19273, },
	{  3141, -6674, 11288, -16323,  5113, -5388,  4162,  -497, -1671,  4622, -8975, 14895, -11202, 15663, -20608, 25657, -15131, 16851, -17550, 16734, -6943,  4254,   -87, -5705,  6584, -11110, 16309, -21972, 13895, -16682, 19098, -20858, 10823, -10565,  9485, -7417,  2103,   147, -3109,  6849, -5725,  8518, -11913, 16138, -2713,  3744, -5683, 12328, },
	{  2162, -4184,  5967, -6377,   928,  1075, -5092, 11849, -5504,  9018, -13534, 18943, -12477, 15526, -18237, 20101, -10247,  9354, -6997,  2817,  1745, -6061, 11563, -18171, 12840, -16871, 20931, -24697, 13888, -14861, 15024, -14128,  5966, -4107,  1397,  2230, -3405,  6171, -9397, 13054, -8552, 10758, -13142, 15739, -2335,  2795, -3518,  5453, },
	{ -1166,    87,  3615, -11566,  6400, -11877, 19667, -29897, 10585, -14069, 17591, -20640, 11260, -11181,  9585, -5941,  -132,  4731, -10965, 18853, -14129, 19426, -25043, 30588, -17778, 19669, -20621, 20266, -9116,  7088, -3901,  -551,  3159, -6690, 10821, -15459, 10235, -12835, 15416, -17843,  9977, -10776, 11190, -11022,  1236,  -847,  -372, 30257, },
	{  1437, -4674, 10993, -21545,  9327, -14695, 21397, -29024,  9188, -10818, 11684, -11201,  4341, -1694, -2702,  9152, -8925, 14407, -20915, 28196, -17914, 21605, -24786, 26989, -13846, 13169, -11190,  7660, -1192, -2381,  6895, -12298,  9232, -12592, 16085, -19524, 11340, -12640, 13503, -13744,  6568, -5688,  4011, -1148,  -465,  1604, -4433, 27554, },
	{  3008, -7260, 14235, -24369,  9404, -13290, 17279, -20572,  5500, -5009,  3211,   400, -3162,  7494, -13336, 20699, -14712, 19570, -24609, 29382, -16655, 17846, -17873, 16321, -6394,  3459,   777, -6382,  6666, -10750, 15315, -20170, 12526, -14816, 16757, -18124,  9331, -9046,  8053, -6174,  1597,   590, -3706,  8166, -1859,  3275, -6400, 22509, },
	{  3368, -7412, 13187, -20375,  7001, -8567,  9089, -7610,   736,  1563, -5335, 10879, -9196, 13951, -19595, 25864, -16154, 19138, -21460, 22605, -10997,  9510, -6546,  1851,  2378, -6672, 11920, -17996, 12338, -15811, 19197, -22222, 12283, -12934, 12872, -11896,  4900, -3191,   713,  2646, -3512,  6309, -9878, 14530, -2619,  3868, -6354, 15946, },
	{  2731, -5592,  8883, -11677,  3102, -2201,  -520,  5921, -3727,  7076, -11669, 17538, -12273, 16167, -20139, 23732, -13169, 13607, -12762, 10190, -2732,  -888,  5891, -12310, 10033, -14469, 19273, -24170, 14399, -16358, 17709, -18174,  8732, -7645,  5691, -2750,  -640,  3237, -6444, 10280, -7385,  9980, -12980, 16520, -2616,  3384, -4739,  8903, },
	{  1552, -2715,  3056, -1326, -1049,  3908, -8829, 16365, -6733, 10164, -14309, 18939, -11819, 13891, -15263, 15414, -6872,  4811, -1218, -4167,  5756, -10427, 16023, -22361, 14568, -17952, 21048, -23510, 12471, -12461, 11509, -9408,  2989,  -538, -2691,  6708, -5743,  8477, -11501, 14741, -9054, 10749, -12404, 13966, -1924,  2084, -2232,  2430, },
	{   203, -2457,  7664, -17260,  8175, -13792, 21298, -30547, 10249, -12900, 15177, -16514,  8097, -6693,  3598,  1620, -4665,  9884, -16483, 24344, -16590, 21255, -25826, 29859, -16411, 17055, -16541, 14548, -5391,  2499,  1484, -6584,  6382, -9954, 13910, -18104, 11174, -13203, 14998, -16391,  8590, -8552,  7896, -6312,   395,   415, -2602, 29270, },
	{  2353, -6242, 13131, -23844,  9716, -14505, 20040, -25694,  7610, -8202,  7723, -5609,   622,  2989, -8287, 15439, -12232, 17592, -23580, 29837, -17922, 20465, -22143, 22502, -10530,  8672, -5466,   747,  2789, -6752, 11457, -16776, 11255, -14189, 17016, -19519, 10725, -11260, 11202, -10363,  4255, -2667,   180,  3628, -1207,  2541, -5658, 25344, },
	{  3329, -7624, 14219, -23176,  8492, -11310, 13642, -14579,  3226, -1782, -1101,  5839, -6398, 11104, -17054, 24120, -15994, 20064, -23889, 26972, -14357, 14217, -12712,  9493, -2129, -1608,  6516, -12565,  9814, -13733, 17861, -21956, 12858, -14393, 15380, -15597,  7403, -6377,  4585, -1877,  -967,  3552, -7020, 11753, -2322,  3706, -6609, 19438, },
	{  3157, -6721, 11398, -16544,  5212, -5549,  4406,  -839, -1558,  4483, -8815, 14727, -11125, 15607, -20594, 25712, -15207, 16991, -17770, 17048, -7152,  4517,  -401, -5347,  6391, -10913, 16124, -21816, 13843, -16668, 19136, -20961, 10913, -10699,  9666, -7648,  2243,   -15, -2928,  6656, -5628,  8425, -11835, 16088, -2713,  3756, -5724, 12505, },
	{  2192, -4257,  6114, -6639,  1033,   921, -4882, 11585, -5428,  8941, -13468, 18908, -12489, 15584, -18361, 20312, -10406,  9576, -7289,  3180,  1530, -5820, 11307, -17917, 12725, -16783, 20887, -24714, 13937, -14960, 15181, -14350,  6111, -4287,  1609,  1991, -3276,  6038, -9269, 12941, -8510, 10739, -13157, 15804, -2353,  2828, -3581,  5616, },
	{ -1240,   227,  3387, -11237,  6293, -11752, 19543, -29807, 10583, -14105, 17687, -20821, 11407, -11398,  9884, -6329,   107,  4451, -10653, 18529, -13974, 19294, -24956, 30571, -17817, 19770, -20797, 20529, -9295,  7316, -4176,  -234,  2984, -6506, 10639, -15292, 10167, -12792, 15410, -17887, 10032, -10874, 11344, -11252,  1279,  -914,  -245, 30289, },
	{  1383, -4579, 10855, -21380,  9289, -14677, 21429, -29148,  9256, -10937, 11873, -11477,  4531, -1939, -2401,  8802, -8733, 14212, -20736, 28057, -17880, 21626, -24879, 27176, -13995, 13381, -11470,  8009, -1399, -2147,  6643, -12041,  9108, -12485, 16006, -19488, 11351, -12689, 13600, -13897,  6677, -5837,  4206, -1399,  -425,  1550, -4356, 27653, },
	{  2984, -7226, 14208, -24387,  9436, -13372, 17442, -20854,  5611, -5172,  3434,   110, -2984,  7289, -13114, 20479, -14618, 19508, -24602, 29455, -16745, 18005, -18112, 16650, -6607,  3719,   474, -6045,  6488, -10573, 15154, -20040, 12486, -14811, 16799, -18223,  9415, -9170,  8220, -6389,  1729,   433, -3524,  7961, -1831,  3246, -6376, 22658, },
	{  3373, -7435, 13259, -20543,  7085, -8713,  9323, -7958,   857,  1405, -5140, 10655, -9077, 13837, -19506, 25824, -16174, 19216, -21615, 22857, -11180,  9755, -6857,  2226,  2163, -6437, 11677, -17763, 12236, -15737, 19165, -22248, 12332, -13028, 13017, -12097,  5031, -3352,   903,  2430, -3394,  6186, -9756, 14421, -2610,  3867, -6377, 16121, },
	{  2756, -5655,  9017, -11928,  3208, -2364,  -285,  5607, -3629,  6963, -11552, 17433, -12239, 16168, -20196, 23869, -13290, 13795, -13027, 10541, -2952,  -627,  5595, -11992,  9873, -14321, 19153, -24097, 14397, -16401, 17809, -18342,  8854, -7808,  5895, -2993,  -500,  3084, -6283, 10121, -7312,  9921, -12947, 16528, -2625,  3408, -4793,  9076, },
	{  1584, -2791,  3205, -1580,  -952,  3773, -8655, 16164, -6682, 10123, -14294, 18970, -11872, 13997, -15440, 15678, -7056,  5051, -1515, -3817,  5561, -10221, 15821, -22183, 14503, -17926, 21077, -23609, 12565, -12605, 11708, -9666,  3146,  -722, -2486,  6490, -5632,  8372, -11412, 14679, -9043, 10767, -12462, 14079, -1948,  2123, -2299,  2578, },
	{   136, -2336,  7475, -17004,  8100, -13719, 21251, -30564, 10283, -12980, 15325, -16751,  8271, -6932,  3909,  1238, -4442,  9637, -16229, 24104, -16491, 21196, -25828, 29946, -16508, 17217, -16777, 14865, -5591,  2738,  1210, -6285,  6227, -9803, 13774, -17998, 11144, -13206, 15044, -16493,  8675, -8679,  8077, -6562,   438,   353, -2499, 29337, },
	{  2313, -6175, 13047, -23769,  9712, -14539, 20141, -25905,  7703, -8348,  7937, -5902,   812,  2755, -8016, 15144, -12084, 17458, -23483, 29802, -17951, 20557, -22315, 22769, -10717,  8917, -5768,  1102,  2589, -6539, 11242, -16574, 11169, -14131, 16996, -19551, 10774, -11349, 11339, -10553,  4380, -2825,   375,  3391, -1172,  2499, -5607, 25469, },
	{  3320, -7619, 14244, -23274,  8552, -11429, 13848, -14906,  3346, -1948,  -884,  5573, -6244, 10939, -16893, 23985, -15954, 20071, -23965, 27140, -14498, 14426, -12997,  9858, -2351, -1351,  6233, -12268,  9669, -13603, 17760, -21901, 12863, -14439, 15476, -15752,  7514, -6524,  4771, -2100,  -838,  3406, -6863, 11590, -2302,  3690, -6609, 19602, },
	{  3173, -6766, 11506, -16762,  5310, -5710,  4649, -1182, -1445,  4343, -8653, 14556, -11045, 15549, -20577, 25762, -15280, 17129, -17988, 17360, -7361,  4780,  -716, -4988,  6196, -10714, 15935, -21656, 13789, -16651, 19170, -21060, 11002, -10831,  9847, -7879,  2383,  -178, -2746,  6462, -5529,  8331, -11755, 16035, -2713,  3768, -5765, 12683, },
	{  2221, -4329,  6261, -6901,  1138,   766, -4671, 11319, -5351,  8861, -13399, 18870, -12498, 15639, -18481, 20519, -10564,  9798, -7580,  3543,  1315, -5577, 11049, -17659, 12608, -16692, 20838, -24727, 13984, -15056, 15335, -14570,  6256, -4466,  1821,  1751, -3146,  5904, -9140, 12826, -8467, 10718, -13169, 15867, -2370,  2861, -3644,  5779, },
	{ -1314,   367,  3159, -10904,  6184, -11625, 19415, -29711, 10579, -14138, 17779, -20998, 11552, -11614, 10182, -6718,   347,  4169, -10340, 18201, -13815, 19159, -24864, 30547, -17854, 19868, -20970, 20789, -9473,  7543, -4451,    85,  2808, -6321, 10455, -15122, 10097, -12747, 15401, -17928, 10085, -10970, 11496, -11480,  1322,  -981,  -118, 30320, },
	{  1328, -4482, 10715, -21210,  9248, -14657, 21458, -29267,  9321, -11055, 12060, -11752,  4719, -2184, -2099,  8451, -8540, 14015, -20553, 27914, -17844, 21642, -24969, 27358, -14141, 13591, -11749,  8358, -1606, -1912,  6389, -11781,  8984, -12376, 15925, -19449, 11361, -12736, 13694, -14047,  6786, -5985,  4401, -1651,  -384,  1496, -4279, 27750, },
	{  2959, -7190, 14179, -24401,  9465, -13451, 17602, -21132,  5722, -5334,  3657,  -180, -2806,  7083, -12890, 20256, -14520, 19442, -24590, 29523, -16833, 18160, -18348, 16977, -6818,  3979,   171, -5707,  6309, -10395, 14989, -19905, 12443, -14804, 16838, -18320,  9498, -9292,  8386, -6603,  1861,   276, -3341,  7754, -1802,  3216, -6351, 22806, },
	{  3377, -7457, 13329, -20709,  7167, -8858,  9556, -8305,   978,  1246, -4944, 10428, -8956, 13721, -19413, 25780, -16191, 19291, -21767, 23104, -11361, 10000, -7168,  2602,  1946, -6200, 11432, -17525, 12132, -15660, 19130, -22269, 12379, -13119, 13159, -12296,  5161, -3512,  1093,  2214, -3276,  6062, -9633, 14309, -2599,  3865, -6399, 16295, },
	{  2780, -5717,  9150, -12178,  3313, -2528,   -49,  5291, -3530,  6849, -11432, 17324, -12202, 16166, -20250, 24002, -13410, 13981, -13291, 10891, -3172,  -365,  5297, -11672,  9711, -14170, 19030, -24020, 14392, -16442, 17906, -18506,  8974, -7969,  6098, -3237,  -361,  2930, -6122,  9960, -7238,  9861, -12912, 16533, -2634,  3431, -4847,  9250, },
	{  1616, -2868,  3354, -1834,  -854,  3636, -8480, 15960, -6629, 10080, -14275, 18998, -11923, 14101, -15614, 15940, -7238,  5290, -1812, -3466,  5364, -10013, 15616, -22002, 14436, -17897, 21102, -23705, 12655, -12746, 11905, -9922,  3304,  -906, -2280,  6270, -5521,  8266, -11321, 14614, -9030, 10783, -12518, 14190, -1972,  2162, -2367,  2726, },
	{    70, -2213,  7285, -16745,  8023, -13642, 21200, -30577, 10315, -13059, 15470, -16985,  8444, -7171,  4220,   854, -4217,  9388, -15971, 23858, -16390, 21134, -25826, 30027, -16602, 17376, -17011, 15180, -5790,  2977,   936, -5985,  6071, -9650, 13636, -17888, 11112, -13206, 15087, -16591,  8759, -8806,  8256, -6810,   481,   290, -2395, 29401, },
	{  2272, -6107, 12960, -23689,  9707, -14570, 20240, -26112,  7794, -8493,  8149, -6195,  1003,  2521, -7743, 14846, -11933, 17321, -23381, 29762, -17977, 20645, -22483, 23032, -10903,  9160, -6070,  1458,  2389, -6325, 11025, -16369, 11082, -14070, 16973, -19580, 10821, -11436, 11473, -10742,  4505, -2984,   571,  3153, -1136,  2455, -5556, 25594, },
	{  3310, -7613, 14266, -23368,  8611, -11545, 14052, -15230,  3466, -2115,  -666,  5304, -6089, 10771, -16728, 23846, -15913, 20076, -24037, 27303, -14636, 14633, -13280, 10222, -2573, -1094,  5948, -11970,  9522, -13470, 17656, -21841, 12864, -14481, 15569, -15905,  7624, -6671,  4955, -2323,  -708,  3260, -6704, 11425, -2282,  3674, -6608, 19766, },
	{  3189, -6811, 11612, -16979,  5408, -5870,  4892, -1526, -1331,  4201, -8490, 14382, -10963, 15487, -20557, 25808, -15351, 17263, -18202, 17670, -7568,  5042, -1031, -4627,  6000, -10512, 15743, -21492, 13732, -16632, 19202, -21155, 11088, -10962, 10025, -8108,  2522,  -341, -2563,  6266, -5428,  8235, -11672, 15979, -2712,  3779, -5804, 12860, },
	{  2251, -4402,  6408, -7163,  1243,   610, -4458, 11050, -5273,  8779, -13327, 18828, -12506, 15692, -18599, 20724, -10721, 10018, -7871,  3907,  1099, -5334, 10788, -17398, 12489, -16598, 20786, -24735, 14028, -15149, 15488, -14787,  6399, -4645,  2033,  1511, -3015,  5770, -9008, 12709, -8421, 10694, -13179, 15926, -2387,  2893, -3707,  5943, },
	{ -1388,   507,  2928, -10567,  6073, -11494, 19284, -29609, 10574, -14170, 17869, -21172, 11695, -11828, 10479, -7106,   588,  3885, -10024, 17869, -13654, 19020, -24768, 30519, -17887, 19963, -21140, 21045, -9649,  7769, -4726,   403,  2632, -6135, 10268, -14949, 10025, -12699, 15389, -17965, 10137, -11064, 11646, -11707,  1364, -1048,    11, 30349, },
	{  1272, -4384, 10572, -21035,  9206, -14634, 21483, -29381,  9385, -11170, 12246, -12025,  4908, -2430, -1797,  8097, -8345, 13815, -20366, 27765, -17804, 21655, -25054, 27535, -14286, 13799, -12026,  8705, -1812, -1677,  6134, -11518,  8857, -12264, 15841, -19407, 11368, -12781, 13785, -14196,  6894, -6132,  4595, -1903,  -343,  1442, -4199, 27846, },
	{  2933, -7152, 14146, -24410,  9493, -13528, 17759, -21408,  5831, -5495,  3880,  -471, -2627,  6874, -12663, 20029, -14420, 19373, -24574, 29586, -16918, 18312, -18581, 17301, -7029,  4238,  -133, -5367,  6129, -10214, 14821, -19767, 12398, -14793, 16873, -18413,  9579, -9412,  8551, -6816,  1993,   118, -3157,  7545, -1773,  3185, -6325, 22952, },
	{  3380, -7478, 13397, -20872,  7248, -9002,  9788, -8652,  1099,  1086, -4746, 10198, -8833, 13602, -19317, 25731, -16206, 19362, -21915, 23349, -11540, 10242, -7478,  2977,  1730, -5962, 11185, -17285, 12025, -15580, 19091, -22287, 12424, -13208, 13300, -12494,  5290, -3672,  1283,  1996, -3156,  5936, -9507, 14194, -2588,  3863, -6419, 16469, },
	{  2804, -5778,  9282, -12427,  3419, -2692,   187,  4973, -3431,  6733, -11310, 17212, -12164, 16161, -20300, 24131, -13527, 14165, -13553, 11239, -3391,  -103,  4998, -11349,  9547, -14016, 18902, -23938, 14385, -16480, 18001, -18667,  9093, -8129,  6301, -3480,  -221,  2776, -5959,  9797, -7162,  9799, -12874, 16534, -2642,  3454, -4900,  9424, },
	{  1648, -2944,  3503, -2089,  -756,  3498, -8302, 15752, -6576, 10035, -14254, 19023, -11972, 14202, -15785, 16199, -7420,  5529, -2109, -3114,  5166, -9802, 15408, -21815, 14366, -17865, 21123, -23796, 12744, -12886, 12101, -10176,  3460, -1090, -2073,  6048, -5408,  8159, -11227, 14546, -9016, 10798, -12571, 14299, -1995,  2201, -2434,  2875, },
	{     2, -2090,  7092, -16481,  7944, -13564, 21145, -30584, 10346, -13135, 15613, -17217,  8616, -7409,  4531,   470, -3991,  9137, -15709, 23609, -16285, 21068, -25819, 30103, -16693, 17532, -17242, 15492, -5988,  3216,   661, -5684,  5914, -9495, 13495, -17776, 11078, -13204, 15128, -16687,  8841, -8930,  8435, -7058,   524,   228, -2289, 29464, },
	{  2230, -6038, 12871, -23605,  9700, -14599, 20335, -26314,  7884, -8637,  8361, -6487,  1193,  2286, -7469, 14544, -11779, 17181, -23275, 29716, -17999, 20730, -22647, 23291, -11086,  9402, -6371,  1814,  2188, -6109, 10805, -16160, 10992, -14006, 16947, -19606, 10866, -11522, 11606, -10928,  4629, -3142,   767,  2915, -1100,  2411, -5502, 25717, },
	{  3299, -7605, 14286, -23459,  8668, -11660, 14254, -15554,  3586, -2281,  -448,  5035, -5932, 10601, -16561, 23702, -15868, 20076, -24105, 27461, -14773, 14837, -13561, 10585, -2794,  -836,  5662, -11668,  9373, -13334, 17548, -21778, 12864, -14522, 15660, -16055,  7732, -6816,  5139, -2546,  -577,  3113, -6543, 11257, -2261,  3657, -6607, 19929, },
	{  3204, -6854, 11717, -17193,  5505, -6030,  5135, -1871, -1216,  4058, -8324, 14205, -10879, 15423, -20532, 25849, -15419, 17395, -18414, 17976, -7774,  5304, -1347, -4264,  5802, -10309, 15548, -21324, 13673, -16609, 19229, -21247, 11172, -11090, 10203, -8336,  2662,  -504, -2380,  6069, -5327,  8138, -11587, 15920, -2711,  3789, -5843, 13037, },
	{  2281, -4474,  6555, -7425,  1349,   453, -4243, 10777, -5194,  8696, -13253, 18783, -12511, 15742, -18714, 20925, -10875, 10236, -8160,  4270,   883, -5088, 10525, -17134, 12367, -16501, 20730, -24739, 14069, -15241, 15637, -15002,  6542, -4823,  2245,  1270, -2884,  5633, -8875, 12589, -8375, 10669, -13187, 15983, -2403,  2925, -3770,  6108, },
	{ -1463,   649,  2696, -10227,  5961, -11362, 19148, -29502, 10566, -14198, 17956, -21343, 11837, -12040, 10774, -7493,   829,  3601, -9705, 17533, -13491, 18877, -24667, 30484, -17917, 20054, -21306, 21299, -9824,  7994, -5000,   722,  2454, -5947, 10080, -14773,  9951, -12649, 15375, -18000, 10186, -11156, 11795, -11933,  1407, -1115,   141, 30377, },
	{  1216, -4285, 10426, -20856,  9162, -14609, 21505, -29490,  9448, -11284, 12429, -12297,  5096, -2675, -1493,  7741, -8149, 13611, -20175, 27611, -17761, 21664, -25134, 27708, -14428, 14005, -12301,  9051, -2019, -1441,  5878, -11253,  8729, -12150, 15754, -19361, 11374, -12824, 13874, -14342,  7000, -6279,  4789, -2155,  -302,  1387, -4119, 27941, },
	{  2906, -7113, 14111, -24415,  9520, -13603, 17913, -21681,  5940, -5656,  4103,  -762, -2446,  6664, -12433, 19798, -14317, 19300, -24553, 29643, -17000, 18462, -18811, 17623, -7239,  4497,  -438, -5026,  5947, -10031, 14651, -19625, 12351, -14781, 16906, -18503,  9658, -9532,  8715, -7028,  2125,   -41, -2972,  7334, -1744,  3154, -6298, 23098, },
	{  3383, -7498, 13463, -21031,  7329, -9144, 10019, -8998,  1221,   926, -4547,  9967, -8708, 13481, -19217, 25677, -16218, 19431, -22059, 23589, -11717, 10484, -7787,  3353,  1512, -5723, 10935, -17041, 11917, -15498, 19049, -22301, 12467, -13295, 13438, -12689,  5418, -3832,  1474,  1778, -3036,  5809, -9380, 14077, -2577,  3860, -6439, 16642, },
	{  2828, -5839,  9413, -12674,  3524, -2856,   424,  4653, -3330,  6616, -11186, 17097, -12123, 16153, -20346, 24256, -13643, 14346, -13812, 11586, -3610,   160,  4698, -11023,  9381, -13860, 18771, -23852, 14375, -16515, 18092, -18826,  9210, -8287,  6502, -3723,   -80,  2620, -5795,  9633, -7085,  9735, -12833, 16533, -2650,  3475, -4953,  9598, },
	{  1679, -3020,  3653, -2345,  -657,  3359, -8123, 15541, -6521,  9988, -14231, 19045, -12019, 14301, -15955, 16456, -7600,  5767, -2407, -2761,  4967, -9590, 15197, -21625, 14294, -17829, 21140, -23883, 12831, -13023, 12294, -10430,  3617, -1274, -1866,  5825, -5294,  8050, -11132, 14476, -9001, 10810, -12623, 14405, -2018,  2239, -2501,  3025, },
	{   -65, -1965,  6897, -16213,  7863, -13482, 21086, -30585, 10374, -13209, 15753, -17446,  8787, -7646,  4841,    84, -3764,  8884, -15445, 23354, -16177, 20998, -25808, 30174, -16782, 17686, -17470, 15802, -6186,  3455,   386, -5381,  5755, -9339, 13352, -17660, 11042, -13200, 15166, -16779,  8921, -9054,  8612, -7306,   568,   164, -2182, 29526, },
	{  2188, -5967, 12778, -23516,  9692, -14625, 20426, -26512,  7973, -8779,  8572, -6779,  1384,  2050, -7192, 14240, -11624, 17037, -23165, 29665, -18019, 20811, -22807, 23547, -11268,  9643, -6671,  2170,  1987, -5892, 10583, -15949, 10901, -13939, 16918, -19628, 10910, -11605, 11736, -11114,  4752, -3300,   964,  2675, -1063,  2367, -5448, 25839, },
	{  3287, -7596, 14303, -23546,  8724, -11773, 14454, -15875,  3705, -2448,  -230,  4764, -5773, 10429, -16389, 23554, -15820, 20073, -24168, 27615, -14907, 15039, -13840, 10946, -3016,  -577,  5374, -11365,  9222, -13196, 17437, -21711, 12861, -14559, 15748, -16202,  7840, -6960,  5322, -2768,  -447,  2965, -6381, 11086, -2240,  3639, -6603, 20092, },
	{  3218, -6897, 11820, -17405,  5601, -6190,  5378, -2216, -1101,  3915, -8156, 14025, -10793, 15356, -20504, 25885, -15485, 17524, -18623, 18280, -7979,  5565, -1663, -3901,  5603, -10103, 15350, -21152, 13611, -16584, 19254, -21335, 11255, -11217, 10378, -8563,  2801,  -667, -2196,  5870, -5225,  8038, -11500, 15859, -2709,  3799, -5881, 13214, },
	{  2310, -4545,  6701, -7686,  1455,   296, -4027, 10502, -5113,  8611, -13176, 18734, -12514, 15789, -18825, 21122, -11029, 10454, -8449,  4633,   666, -4842, 10259, -16866, 12243, -16401, 20671, -24738, 14109, -15329, 15784, -15215,  6683, -5000,  2457,  1028, -2752,  5496, -8740, 12467, -8326, 10642, -13193, 16037, -2419,  2956, -3832,  6273, },
	{ -1537,   791,  2463, -9885,  5847, -11227, 19008, -29389, 10557, -14225, 18040, -21510, 11976, -12250, 11068, -7880,  1070,  3316, -9385, 17194, -13324, 18730, -24562, 30445, -17943, 20141, -21469, 21548, -9997,  8217, -5274,  1041,  2277, -5758,  9890, -14594,  9876, -12597, 15358, -18031, 10234, -11247, 11942, -12157,  1449, -1183,   271, 30402, },
	{  1159, -4184, 10278, -20672,  9116, -14580, 21522, -29594,  9509, -11397, 12611, -12567,  5283, -2920, -1189,  7383, -7950, 13405, -19980, 27452, -17715, 21669, -25211, 27876, -14568, 14209, -12574,  9396, -2226, -1204,  5620, -10986,  8599, -12034, 15664, -19311, 11377, -12864, 13961, -14485,  7106, -6425,  4983, -2407,  -261,  1331, -4037, 28033, },
	{  2878, -7072, 14074, -24415,  9545, -13675, 18065, -21951,  6048, -5816,  4326, -1054, -2265,  6452, -12201, 19563, -14211, 19223, -24528, 29696, -17079, 18608, -19038, 17942, -7448,  4756,  -742, -4684,  5765, -9847, 14478, -19480, 12302, -14765, 16936, -18590,  9736, -9649,  8877, -7239,  2256,  -199, -2786,  7122, -1714,  3122, -6269, 23243, },
	{  3385, -7516, 13527, -21187,  7408, -9286, 10249, -9344,  1342,   765, -4347,  9733, -8581, 13356, -19113, 25619, -16226, 19496, -22200, 23825, -11892, 10724, -8095,  3728,  1294, -5482, 10682, -16794, 11806, -15412, 19003, -22311, 12508, -13380, 13574, -12883,  5546, -3991,  1664,  1560, -2916,  5681, -9250, 13956, -2565,  3856, -6458, 16815, },
	{  2851, -5898,  9543, -12921,  3629, -3020,   662,  4332, -3229,  6498, -11059, 16978, -12079, 16143, -20389, 24377, -13756, 14525, -14070, 11931, -3829,   424,  4396, -10696,  9213, -13701, 18637, -23762, 14362, -16547, 18180, -18981,  9326, -8445,  6703, -3966,    60,  2465, -5629,  9466, -7007,  9670, -12791, 16529, -2657,  3497, -5005,  9773, },
	{  1711, -3097,  3802, -2602,  -558,  3219, -7941, 15327, -6465,  9939, -14205, 19063, -12064, 14398, -16121, 16711, -7779,  6004, -2704, -2406,  4766, -9376, 14983, -21431, 14218, -17791, 21154, -23966, 12916, -13158, 12486, -10681,  3773, -1459, -1658,  5601, -5179,  7939, -11035, 14403, -8983, 10821, -12672, 14509, -2041,  2277, -2568,  3176, },
	{  -133, -1840,  6700, -15941,  7781, -13398, 21023, -30581, 10401, -13281, 15891, -17673,  8957, -7882,  5151,  -302, -3536,  8629, -15177, 23095, -16067, 20924, -25792, 30239, -16868, 17836, -17695, 16110, -6382,  3693,   110, -5077,  5595, -9180, 13206, -17541, 11005, -13193, 15202, -16869,  9001, -9176,  8788, -7553,   611,   101, -2074, 29585, },
	{  2145, -5894, 12683, -23423,  9681, -14648, 20514, -26707,  8061, -8921,  8782, -7071,  1575,  1813, -6914, 13932, -11466, 16890, -23050, 29609, -18035, 20889, -22964, 23798, -11449,  9882, -6970,  2526,  1785, -5673, 10359, -15734, 10807, -13870, 16886, -19646, 10952, -11687, 11865, -11297,  4875, -3457,  1160,  2434, -1027,  2322, -5392, 25959, },
	{  3275, -7586, 14318, -23629,  8778, -11885, 14653, -16194,  3825, -2614,   -10,  4491, -5614, 10255, -16215, 23401, -15769, 20067, -24228, 27764, -15038, 15239, -14117, 11305, -3237,  -318,  5085, -11059,  9069, -13056, 17323, -21639, 12856, -14595, 15833, -16346,  7946, -7103,  5505, -2991,  -316,  2816, -6218, 10914, -2219,  3621, -6599, 20254, },
	{  3232, -6938, 11921, -17615,  5697, -6348,  5620, -2562,  -986,  3770, -7987, 13842, -10705, 15286, -20472, 25917, -15548, 17650, -18829, 18581, -8184,  5826, -1979, -3536,  5403, -9895, 15149, -20976, 13546, -16555, 19275, -21420, 11336, -11342, 10552, -8789,  2940,  -831, -2012,  5670, -5122,  7938, -11411, 15794, -2707,  3808, -5918, 13391, },
	{  2339, -4616,  6846, -7947,  1561,   138, -3810, 10225, -5032,  8524, -13097, 18682, -12515, 15834, -18934, 21317, -11180, 10669, -8737,  4995,   448, -4594,  9992, -16595, 12117, -16298, 20607, -24734, 14145, -15415, 15928, -15425,  6824, -5177,  2668,   786, -2620,  5358, -8604, 12342, -8277, 10613, -13196, 16089, -2435,  2987, -3893,  6439, },
	{ -1612,   933,  2228, -9538,  5732, -11089, 18865, -29271, 10546, -14248, 18120, -21674, 12114, -12459, 11361, -8266,  1311,  3029, -9062, 16851, -13155, 18580, -24452, 30400, -17967, 20226, -21628, 21795, -10168,  8440, -5547,  1360,  2098, -5568,  9698, -14413,  9798, -12543, 15338, -18059, 10280, -11336, 12087, -12379,  1491, -1250,   403, 30426, },
	{  1102, -4082, 10128, -20484,  9069, -14549, 21536, -29693,  9568, -11507, 12792, -12836,  5470, -3165,  -884,  7024, -7749, 13197, -19782, 27288, -17665, 21670, -25283, 28040, -14705, 14410, -12846,  9740, -2433,  -967,  5361, -10717,  8467, -11915, 15571, -19258, 11379, -12903, 14046, -14626,  7210, -6569,  5176, -2660,  -220,  1275, -3954, 28125, },
	{  2850, -7030, 14033, -24411,  9568, -13746, 18214, -22218,  6156, -5976,  4548, -1346, -2084,  6239, -11966, 19324, -14102, 19144, -24499, 29743, -17155, 18751, -19262, 18258, -7656,  5014, -1047, -4341,  5580, -9660, 14302, -19331, 12250, -14747, 16963, -18674,  9812, -9765,  9038, -7449,  2388,  -358, -2600,  6907, -1684,  3089, -6239, 23386, },
	{  3387, -7533, 13588, -21340,  7486, -9426, 10478, -9689,  1464,   604, -4145,  9497, -8452, 13229, -19006, 25556, -16232, 19557, -22337, 24058, -12066, 10962, -8402,  4104,  1076, -5240, 10428, -16543, 11693, -15324, 18954, -22316, 12547, -13462, 13708, -13074,  5673, -4150,  1854,  1341, -2794,  5551, -9119, 13833, -2553,  3851, -6475, 16988, },
	{  2874, -5958,  9672, -13166,  3734, -3184,   901,  4009, -3127,  6378, -10930, 16857, -12034, 16129, -20429, 24494, -13866, 14702, -14325, 12275, -4047,   687,  4094, -10366,  9043, -13539, 18499, -23667, 14347, -16576, 18265, -19133,  9440, -8601,  6902, -4208,   201,  2308, -5462,  9297, -6927,  9602, -12746, 16522, -2664,  3518, -5056,  9947, },
	{  1743, -3173,  3952, -2860,  -459,  3077, -7757, 15109, -6407,  9888, -14176, 19077, -12106, 14493, -16285, 16963, -7958,  6241, -3002, -2051,  4564, -9159, 14766, -21233, 14141, -17749, 21164, -24045, 12998, -13291, 12676, -10931,  3928, -1643, -1450,  5376, -5063,  7827, -10935, 14328, -8965, 10829, -12720, 14610, -2064,  2315, -2635,  3327, },
	{  -202, -1713,  6500, -15665,  7697, -13311, 20956, -30571, 10426, -13351, 16026, -17897,  9125, -8117,  5461,  -689, -3307,  8372, -14906, 22832, -15953, 20846, -25771, 30299, -16950, 17983, -17917, 16415, -6578,  3931,  -166, -4771,  5434, -9020, 13057, -17419, 10965, -13184, 15235, -16956,  9079, -9297,  8963, -7799,   654,    37, -1965, 29643, },
	{  2101, -5820, 12585, -23325,  9669, -14669, 20599, -26897,  8147, -9061,  8990, -7361,  1766,  1575, -6634, 13621, -11305, 16740, -22932, 29548, -18049, 20963, -23116, 24046, -11627, 10120, -7269,  2883,  1582, -5453, 10133, -15517, 10712, -13799, 16851, -19661, 10991, -11766, 11992, -11479,  4997, -3615,  1357,  2192,  -990,  2276, -5335, 26079, },
	{  3261, -7573, 14330, -23707,  8831, -11995, 14849, -16512,  3943, -2781,   210,  4217, -5453, 10078, -16037, 23244, -15716, 20057, -24283, 27908, -15167, 15436, -14392, 11664, -3458,   -59,  4795, -10750,  8915, -12913, 17205, -21564, 12849, -14627, 15916, -16488,  8050, -7245,  5687, -3213,  -185,  2667, -6053, 10739, -2197,  3602, -6594, 20415, },
	{  3245, -6979, 12021, -17823,  5792, -6506,  5863, -2908,  -870,  3624, -7815, 13656, -10615, 15213, -20437, 25945, -15608, 17773, -19032, 18880, -8387,  6086, -2295, -3170,  5201, -9686, 14945, -20796, 13479, -16524, 19293, -21501, 11414, -11465, 10725, -9013,  3078,  -994, -1827,  5469, -5017,  7835, -11319, 15726, -2704,  3817, -5954, 13569, },
	{  2368, -4687,  6991, -8208,  1667,   -20, -3591,  9944, -4949,  8436, -13016, 18626, -12513, 15875, -19039, 21508, -11330, 10884, -9023,  5358,   230, -4345,  9722, -16320, 11988, -16192, 20540, -24725, 14180, -15498, 16070, -15633,  6963, -5353,  2879,   544, -2487,  5218, -8465, 12215, -8225, 10583, -13197, 16138, -2450,  3018, -3955,  6606, },
	{ -1688,  1077,  1992, -9189,  5615, -10949, 18718, -29147, 10532, -14270, 18198, -21834, 12250, -12666, 11652, -8651,  1553,  2741, -8737, 16505, -12984, 18427, -24337, 30349, -17987, 20306, -21783, 22037, -10338,  8661, -5819,  1680,  1919, -5377,  9504, -14229,  9719, -12486, 15315, -18084, 10325, -11422, 12230, -12599,  1533, -1318,   536, 30448, },
	{  1044, -3978,  9975, -20292,  9019, -14516, 21546, -29787,  9626, -11616, 12970, -13103,  5656, -3411,  -578,  6662, -7547, 12985, -19579, 27118, -17613, 21668, -25350, 28198, -14840, 14609, -13115, 10082, -2639,  -730,  5100, -10445,  8333, -11795, 15475, -19202, 11378, -12939, 14128, -14765,  7314, -6713,  5368, -2913,  -178,  1219, -3869, 28214, },
	{  2821, -6986, 13990, -24403,  9590, -13814, 18360, -22481,  6262, -6135,  4771, -1639, -1901,  6024, -11729, 19081, -13991, 19060, -24465, 29785, -17228, 18891, -19483, 18572, -7862,  5272, -1352, -3996,  5395, -9472, 14123, -19178, 12196, -14726, 16987, -18754,  9887, -9880,  9198, -7659,  2519,  -517, -2412,  6692, -1654,  3056, -6208, 23529, },
	{  3387, -7548, 13647, -21490,  7563, -9566, 10705, -10034,  1586,   442, -3942,  9258, -8322, 13100, -18895, 25488, -16235, 19615, -22470, 24287, -12238, 11199, -8708,  4479,   857, -4996, 10172, -16289, 11578, -15233, 18902, -22318, 12583, -13543, 13839, -13263,  5798, -4308,  2044,  1121, -2672,  5421, -8986, 13708, -2540,  3846, -6492, 17160, },
	{  2896, -6016,  9800, -13410,  3838, -3349,  1140,  3684, -3024,  6256, -10799, 16731, -11986, 16113, -20464, 24607, -13975, 14877, -14579, 12618, -4265,   951,  3790, -10033,  8872, -13375, 18358, -23568, 14330, -16602, 18347, -19281,  9553, -8755,  7101, -4450,   342,  2151, -5295,  9127, -6846,  9533, -12699, 16512, -2671,  3538, -5107, 10123, },
	{  1775, -3249,  4102, -3118,  -358,  2935, -7571, 14887, -6348,  9836, -14145, 19089, -12147, 14585, -16447, 17213, -8135,  6477, -3300, -1694,  4362, -8941, 14546, -21030, 14060, -17704, 21170, -24120, 13078, -13422, 12863, -11180,  4083, -1827, -1241,  5149, -4946,  7713, -10834, 14249, -8944, 10836, -12765, 14709, -2086,  2353, -2702,  3480, },
	{  -271, -1586,  6299, -15385,  7611, -13221, 20886, -30556, 10450, -13418, 16159, -18118,  9292, -8352,  5770, -1076, -3077,  8113, -14632, 22564, -15836, 20764, -25746, 30354, -17030, 18128, -18137, 16718, -6773,  4169,  -442, -4465,  5272, -8857, 12907, -17293, 10923, -13173, 15265, -17041,  9155, -9416,  9137, -8044,   697,   -27, -1854, 29700, },
	{  2056, -5744, 12484, -23222,  9655, -14687, 20680, -27082,  8233, -9200,  9198, -7651,  1957,  1336, -6352, 13307, -11142, 16587, -22808, 29481, -18059, 21034, -23265, 24290, -11804, 10356, -7566,  3239,  1379, -5232,  9905, -15296, 10614, -13725, 16813, -19673, 11029, -11844, 12117, -11659,  5119, -3771,  1553,  1949,  -952,  2230, -5277, 26197, },
	{  3247, -7560, 14340, -23782,  8883, -12103, 15043, -16827,  4062, -2947,   430,  3941, -5291,  9899, -15856, 23083, -15659, 20043, -24334, 28048, -15294, 15631, -14665, 12020, -3678,   201,  4504, -10439,  8758, -12767, 17085, -21485, 12839, -14658, 15995, -16627,  8154, -7387,  5868, -3436,   -54,  2517, -5887, 10562, -2175,  3582, -6587, 20575, },
	{  3258, -7018, 12119, -18028,  5887, -6664,  6105, -3255,  -753,  3477, -7642, 13467, -10522, 15137, -20398, 25967, -15665, 17894, -19232, 19175, -8588,  6345, -2611, -2803,  4999, -9474, 14738, -20613, 13410, -16490, 19307, -21578, 11491, -11587, 10895, -9236,  3216, -1157, -1641,  5267, -4912,  7732, -11226, 15656, -2701,  3825, -5989, 13746, },
	{  2396, -4757,  7136, -8469,  1773,  -179, -3371,  9661, -4865,  8346, -12931, 18567, -12509, 15914, -19141, 21695, -11478, 11096, -9309,  5720,    12, -4095,  9450, -16042, 11857, -16082, 20470, -24711, 14212, -15579, 16209, -15838,  7102, -5529,  3090,   301, -2353,  5078, -8325, 12086, -8172, 10550, -13196, 16184, -2465,  3048, -4016,  6773, },
	{ -1763,  1220,  1754, -8837,  5497, -10807, 18567, -29017, 10517, -14288, 18273, -21991, 12385, -12871, 11942, -9036,  1794,  2453, -8410, 16155, -12809, 18270, -24218, 30293, -18005, 20384, -21935, 22276, -10507,  8881, -6091,  1999,  1740, -5184,  9307, -14042,  9638, -12427, 15290, -18106, 10368, -11507, 12371, -12818,  1575, -1385,   670, 30468, },
	{   985, -3873,  9819, -20094,  8968, -14479, 21552, -29876,  9683, -11723, 13146, -13368,  5842, -3656,  -272,  6298, -7344, 12771, -19373, 26944, -17557, 21661, -25413, 28352, -14972, 14806, -13383, 10423, -2845,  -492,  4839, -10171,  8198, -11672, 15377, -19142, 11376, -12973, 14208, -14901,  7416, -6856,  5560, -3165,  -136,  1162, -3784, 28303, },
	{  2791, -6941, 13944, -24390,  9610, -13880, 18503, -22741,  6368, -6293,  4992, -1933, -1718,  5807, -11488, 18834, -13877, 18973, -24427, 29822, -17298, 19028, -19701, 18883, -8068,  5529, -1658, -3650,  5208, -9281, 13942, -19022, 12140, -14703, 17008, -18831,  9959, -9993,  9356, -7867,  2650,  -676, -2224,  6474, -1623,  3022, -6176, 23670, },
	{  3387, -7563, 13704, -21637,  7639, -9704, 10932, -10377,  1708,   279, -3738,  9017, -8190, 12968, -18781, 25416, -16236, 19670, -22599, 24512, -12407, 11434, -9014,  4854,   637, -4752,  9913, -16032, 11460, -15139, 18846, -22316, 12618, -13620, 13968, -13450,  5923, -4466,  2234,   901, -2549,  5289, -8852, 13579, -2527,  3840, -6507, 17332, },
	{  2918, -6074,  9926, -13652,  3942, -3513,  1379,  3357, -2920,  6133, -10666, 16603, -11936, 16094, -20497, 24716, -14081, 15049, -14830, 12958, -4483,  1215,  3485, -9698,  8699, -13208, 18213, -23465, 14310, -16625, 18425, -19427,  9664, -8909,  7298, -4691,   482,  1993, -5126,  8955, -6764,  9462, -12649, 16499, -2677,  3558, -5157, 10298, },
	{  1806, -3325,  4252, -3376,  -258,  2792, -7384, 14663, -6288,  9781, -14111, 19097, -12186, 14674, -16606, 17460, -8311,  6713, -3597, -1337,  4158, -8721, 14323, -20824, 13977, -17655, 21173, -24191, 13156, -13550, 13049, -11426,  4238, -2010, -1032,  4922, -4828,  7598, -10730, 14169, -8922, 10841, -12808, 14806, -2108,  2390, -2768,  3633, },
	{  -340, -1457,  6095, -15101,  7524, -13129, 20811, -30535, 10471, -13484, 16289, -18337,  9458, -8585,  6079, -1464, -2846,  7853, -14355, 22291, -15716, 20679, -25716, 30404, -17107, 18269, -18353, 17018, -6967,  4406,  -718, -4157,  5109, -8693, 12753, -17165, 10879, -13160, 15293, -17122,  9230, -9534,  9309, -8288,   741,   -91, -1742, 29754, },
	{  2010, -5667, 12381, -23115,  9639, -14703, 20758, -27264,  8317, -9337,  9405, -7941,  2148,  1097, -6068, 12991, -10977, 16431, -22681, 29408, -18066, 21101, -23410, 24530, -11979, 10591, -7863,  3595,  1175, -5010,  9675, -15072, 10515, -13649, 16772, -19681, 11065, -11919, 12240, -11837,  5239, -3928,  1750,  1706,  -915,  2183, -5217, 26313, },
	{  3233, -7545, 14346, -23853,  8933, -12209, 15235, -17140,  4180, -3114,   651,  3664, -5127,  9719, -15672, 22917, -15600, 20026, -24381, 28183, -15418, 15824, -14935, 12375, -3899,   461,  4211, -10126,  8600, -12619, 16961, -21402, 12827, -14685, 16073, -16764,  8256, -7526,  6048, -3657,    78,  2366, -5720, 10383, -2152,  3561, -6579, 20735, },
	{  3270, -7056, 12215, -18231,  5981, -6821,  6347, -3603,  -636,  3329, -7467, 13276, -10428, 15058, -20355, 25986, -15720, 18011, -19429, 19468, -8789,  6604, -2927, -2435,  4795, -9260, 14528, -20425, 13338, -16452, 19318, -21651, 11566, -11706, 11064, -9458,  3354, -1321, -1455,  5063, -4805,  7626, -11130, 15582, -2697,  3832, -6024, 13923, },
	{  2425, -4827,  7280, -8729,  1879,  -338, -3150,  9376, -4780,  8254, -12845, 18504, -12503, 15951, -19240, 21879, -11624, 11307, -9593,  6082,  -206, -3844,  9176, -15761, 11724, -15970, 20395, -24693, 14241, -15657, 16345, -16040,  7239, -5703,  3301,    58, -2219,  4936, -8184, 11954, -8118, 10515, -13192, 16227, -2479,  3077, -4076,  6940, },
	{ -1839,  1365,  1514, -8482,  5378, -10662, 18412, -28882, 10500, -14305, 18344, -22144, 12517, -13074, 12230, -9419,  2036,  2163, -8080, 15802, -12633, 18110, -24095, 30232, -18019, 20457, -22083, 22512, -10673,  9100, -6362,  2319,  1560, -4990,  9109, -13852,  9555, -12366, 15261, -18124, 10409, -11590, 12510, -13036,  1617, -1453,   805, 30487, },
	{   926, -3767,  9660, -19893,  8915, -14440, 21554, -29959,  9737, -11829, 13321, -13631,  6027, -3901,    36,  5933, -7138, 12555, -19162, 26764, -17498, 21651, -25472, 28501, -15102, 15001, -13648, 10763, -3051,  -254,  4576, -9895,  8062, -11546, 15275, -19079, 11371, -13004, 14286, -15035,  7517, -6998,  5751, -3418,   -95,  1104, -3697, 28389, },
	{  2761, -6894, 13895, -24373,  9628, -13943, 18643, -22998,  6473, -6451,  5214, -2226, -1534,  5590, -11246, 18583, -13760, 18882, -24385, 29854, -17366, 19162, -19916, 19190, -8273,  5785, -1963, -3303,  5021, -9089, 13758, -18862, 12082, -14677, 17026, -18905, 10031, -10104,  9513, -8074,  2780,  -835, -2035,  6255, -1592,  2987, -6142, 23811, },
	{  3387, -7576, 13759, -21780,  7714, -9840, 11157, -10720,  1829,   116, -3533,  8775, -8056, 12833, -18663, 25339, -16233, 19721, -22725, 24733, -12575, 11667, -9317,  5229,   417, -4506,  9652, -15772, 11340, -15042, 18786, -22310, 12650, -13696, 14095, -13635,  6048, -4623,  2424,   681, -2426,  5156, -8715, 13448, -2514,  3833, -6522, 17503, },
	{  2940, -6130, 10052, -13893,  4046, -3677,  1620,  3029, -2815,  6009, -10530, 16471, -11884, 16072, -20525, 24820, -14185, 15219, -15079, 13297, -4700,  1479,  3179, -9361,  8524, -13038, 18065, -23357, 14287, -16645, 18501, -19569,  9773, -9061,  7495, -4932,   623,  1835, -4956,  8780, -6680,  9389, -12597, 16483, -2682,  3577, -5206, 10474, },
	{  1838, -3400,  4401, -3635,  -157,  2647, -7194, 14435, -6226,  9725, -14074, 19101, -12222, 14762, -16762, 17704, -8487,  6947, -3895,  -979,  3953, -8498, 14098, -20613, 13892, -17604, 21172, -24257, 13232, -13676, 13232, -11671,  4391, -2194,  -822,  4693, -4709,  7481, -10625, 14085, -8898, 10844, -12849, 14900, -2129,  2427, -2835,  3788, },
	{  -410, -1327,  5890, -14814,  7435, -13034, 20732, -30509, 10491, -13547, 16416, -18553,  9622, -8817,  6388, -1852, -2614,  7590, -14075, 22014, -15593, 20590, -25682, 30448, -17181, 18407, -18567, 17315, -7160,  4643,  -995, -3848,  4944, -8528, 12597, -17033, 10833, -13144, 15318, -17200,  9303, -9650,  9481, -8531,   784,  -156, -1629, 29807, },
	{  1964, -5589, 12274, -23003,  9622, -14716, 20833, -27441,  8399, -9474,  9610, -8230,  2340,   857, -5783, 12671, -10810, 16271, -22549, 29331, -18069, 21164, -23551, 24766, -12152, 10824, -8159,  3951,   971, -4787,  9443, -14846, 10413, -13570, 16728, -19686, 11099, -11993, 12361, -12013,  5359, -4084,  1947,  1461,  -877,  2135, -5156, 26429, },
	{  3217, -7528, 14351, -23920,  8982, -12313, 15425, -17451,  4297, -3280,   872,  3386, -4962,  9536, -15485, 22747, -15538, 20005, -24423, 28313, -15539, 16014, -15204, 12729, -4118,   721,  3917, -9811,  8441, -12469, 16834, -21315, 12813, -14710, 16147, -16897,  8357, -7665,  6227, -3879,   209,  2215, -5551, 10201, -2129,  3540, -6570, 20893, },
	{  3282, -7093, 12310, -18431,  6074, -6977,  6588, -3951,  -519,  3180, -7290, 13082, -10331, 14977, -20308, 25999, -15772, 18125, -19623, 19758, -8988,  6861, -3243, -2066,  4590, -9044, 14316, -20233, 13264, -16412, 19325, -21721, 11639, -11823, 11231, -9678,  3491, -1484, -1269,  4858, -4698,  7519, -11032, 15506, -2693,  3839, -6057, 14100, },
	{  2453, -4897,  7423, -8989,  1986,  -498, -2927,  9088, -4694,  8160, -12755, 18438, -12495, 15984, -19335, 22060, -11768, 11517, -9876,  6443,  -425, -3591,  8900, -15477, 11588, -15855, 20317, -24671, 14268, -15732, 16478, -16240,  7375, -5877,  3512,  -186, -2084,  4793, -8040, 11820, -8062, 10479, -13186, 16267, -2493,  3107, -4136,  7108, },
	{ -1914,  1510,  1274, -8123,  5257, -10515, 18254, -28741, 10481, -14319, 18413, -22294, 12647, -13275, 12516, -9802,  2278,  1873, -7749, 15446, -12453, 17946, -23967, 30165, -18030, 20528, -22227, 22743, -10838,  9317, -6632,  2639,  1379, -4796,  8910, -13660,  9470, -12302, 15230, -18139, 10448, -11671, 12648, -13251,  1658, -1521,   941, 30504, },
	{   866, -3660,  9500, -19687,  8860, -14398, 21552, -30038,  9791, -11932, 13493, -13892,  6211, -4145,   344,  5565, -6931, 12335, -18948, 26580, -17435, 21637, -25527, 28645, -15230, 15193, -13912, 11101, -3257,   -16,  4312, -9617,  7924, -11419, 15171, -19012, 11365, -13033, 14361, -15167,  7617, -7139,  5942, -3671,   -53,  1046, -3608, 28474, },
	{  2729, -6846, 13843, -24351,  9645, -14005, 18781, -23251,  6577, -6608,  5435, -2520, -1349,  5370, -11001, 18329, -13641, 18788, -24338, 29880, -17430, 19293, -20127, 19495, -8476,  6041, -2269, -2955,  4832, -8895, 13571, -18698, 12021, -14648, 17041, -18976, 10100, -10214,  9668, -8280,  2911,  -994, -1846,  6034, -1560,  2952, -6107, 23950, },
	{  3386, -7587, 13811, -21920,  7788, -9976, 11381, -11062,  1951,   -47, -3327,  8530, -7921, 12696, -18541, 25257, -16227, 19769, -22847, 24950, -12741, 11899, -9620,  5603,   197, -4259,  9389, -15508, 11219, -14943, 18724, -22300, 12679, -13769, 14220, -13818,  6171, -4779,  2614,   460, -2302,  5022, -8577, 13314, -2499,  3826, -6535, 17674, },
	{  2961, -6186, 10176, -14132,  4150, -3841,  1860,  2700, -2710,  5883, -10392, 16336, -11830, 16047, -20551, 24920, -14287, 15386, -15326, 13634, -4917,  1744,  2872, -9022,  8347, -12866, 17914, -23245, 14262, -16663, 18573, -19708,  9881, -9211,  7690, -5172,   764,  1676, -4784,  8604, -6595,  9314, -12543, 16464, -2688,  3596, -5255, 10649, },
	{  1869, -3476,  4551, -3895,   -55,  2502, -7002, 14204, -6164,  9666, -14035, 19103, -12257, 14846, -16916, 17946, -8660,  7181, -4192,  -620,  3747, -8274, 13869, -20399, 13804, -17549, 21167, -24319, 13305, -13800, 13413, -11915,  4545, -2378,  -612,  4463, -4589,  7363, -10517, 13999, -8873, 10845, -12887, 14992, -2151,  2464, -2901,  3943, },
	{  -480, -1197,  5682, -14522,  7344, -12936, 20650, -30477, 10508, -13607, 16541, -18766,  9785, -9048,  6696, -2241, -2381,  7325, -13792, 21733, -15468, 20497, -25643, 30487, -17252, 18543, -18778, 17610, -7351,  4879, -1272, -3538,  4779, -8360, 12439, -16897, 10786, -13125, 15340, -17276,  9375, -9765,  9650, -8774,   827,  -221, -1515, 29858, },
	{  1917, -5508, 12165, -22886,  9602, -14727, 20903, -27613,  8481, -9608,  9814, -8517,  2531,   616, -5496, 12348, -10641, 16108, -22413, 29248, -18070, 21224, -23688, 24998, -12323, 11056, -8453,  4306,   767, -4562,  9209, -14616, 10310, -13488, 16681, -19687, 11132, -12064, 12480, -12187,  5478, -4239,  2144,  1216,  -839,  2087, -5093, 26543, },
	{  3201, -7510, 14352, -23983,  9029, -12415, 15612, -17760,  4414, -3446,  1094,  3107, -4796,  9351, -15295, 22572, -15473, 19981, -24461, 28438, -15658, 16201, -15470, 13080, -4338,   981,  3622, -9494,  8279, -12316, 16704, -21224, 12797, -14733, 16218, -17028,  8457, -7803,  6406, -4100,   341,  2062, -5381, 10017, -2105,  3518, -6560, 21051, },
	{  3293, -7129, 12402, -18629,  6166, -7132,  6829, -4299,  -401,  3030, -7112, 12885, -10233, 14892, -20258, 26009, -15822, 18236, -19814, 20044, -9186,  7118, -3560, -1696,  4384, -8827, 14100, -20038, 13187, -16369, 19330, -21787, 11710, -11939, 11396, -9897,  3628, -1647, -1082,  4652, -4589,  7411, -10932, 15427, -2688,  3845, -6090, 14276, },
	{  2481, -4965,  7566, -9248,  2092,  -659, -2703,  8797, -4607,  8065, -12664, 18369, -12485, 16015, -19428, 22237, -11911, 11725, -10158,  6804,  -644, -3338,  8622, -15189, 11450, -15737, 20235, -24644, 14292, -15805, 16609, -16438,  7510, -6050,  3722,  -429, -1948,  4649, -7896, 11684, -8004, 10440, -13178, 16305, -2507,  3135, -4196,  7277, },
	{ -1990,  1655,  1032, -7762,  5135, -10365, 18091, -28595, 10460, -14330, 18478, -22440, 12776, -13475, 12801, -10184,  2520,  1581, -7416, 15086, -12272, 17778, -23835, 30093, -18038, 20594, -22368, 22971, -11002,  9533, -6901,  2958,  1198, -4600,  8708, -13465,  9384, -12237, 15197, -18152, 10485, -11751, 12783, -13464,  1700, -1589,  1078, 30518, },
	{   805, -3551,  9336, -19476,  8803, -14353, 21546, -30111,  9842, -12033, 13664, -14152,  6395, -4390,   652,  5197, -6722, 12113, -18731, 26390, -17370, 21619, -25577, 28785, -15355, 15382, -14173, 11438, -3462,   223,  4047, -9337,  7784, -11290, 15064, -18941, 11356, -13060, 14433, -15296,  7716, -7279,  6132, -3924,   -10,   988, -3518, 28558, },
	{  2697, -6795, 13789, -24324,  9660, -14064, 18915, -23501,  6680, -6764,  5656, -2814, -1164,  5149, -10753, 18071, -13519, 18691, -24287, 29901, -17491, 19420, -20335, 19797, -8678,  6295, -2574, -2606,  4642, -8699, 13382, -18532, 11959, -14617, 17053, -19044, 10168, -10322,  9822, -8484,  3041, -1154, -1656,  5811, -1528,  2916, -6070, 24088, },
	{  3384, -7597, 13861, -22057,  7861, -10110, 11603, -11402,  2073,  -211, -3119,  8283, -7783, 12556, -18416, 25170, -16219, 19814, -22965, 25162, -12905, 12129, -9922,  5977,   -24, -4011,  9124, -15242, 11095, -14840, 18657, -22286, 12707, -13840, 14342, -13999,  6293, -4935,  2803,   238, -2177,  4887, -8436, 13178, -2485,  3818, -6547, 17845, },
	{  2982, -6241, 10299, -14370,  4253, -4005,  2101,  2369, -2603,  5756, -10252, 16198, -11773, 16019, -20572, 25016, -14386, 15551, -15571, 13969, -5133,  2008,  2564, -8681,  8168, -12692, 17759, -23129, 14234, -16677, 18642, -19844,  9988, -9360,  7884, -5412,   906,  1517, -4612,  8427, -6509,  9238, -12487, 16443, -2692,  3614, -5303, 10826, },
	{  1900, -3552,  4701, -4155,    47,  2355, -6809, 13969, -6099,  9606, -13994, 19100, -12289, 14929, -17067, 18185, -8833,  7414, -4489,  -260,  3540, -8049, 13638, -20181, 13713, -17491, 21158, -24377, 13376, -13922, 13593, -12156,  4697, -2561,  -401,  4232, -4468,  7243, -10407, 13910, -8846, 10844, -12924, 15082, -2171,  2500, -2967,  4098, },
	{  -551, -1065,  5473, -14226,  7251, -12836, 20563, -30440, 10524, -13666, 16663, -18976,  9947, -9278,  7004, -2630, -2147,  7059, -13506, 21447, -15339, 20400, -25599, 30521, -17321, 18675, -18985, 17902, -7542,  5115, -1549, -3227,  4612, -8191, 12279, -16759, 10736, -13105, 15359, -17348,  9445, -9878,  9819, -9015,   870,  -286, -1400, 29907, },
	{  1870, -5427, 12053, -22764,  9581, -14735, 20971, -27781,  8561, -9742, 10017, -8804,  2722,   375, -5208, 12023, -10469, 15942, -22273, 29160, -18067, 21280, -23821, 25225, -12492, 11286, -8747,  4661,   562, -4337,  8973, -14384, 10204, -13404, 16631, -19684, 11162, -12134, 12596, -12360,  5597, -4394,  2341,   970,  -801,  2039, -5029, 26655, },
	{  3184, -7490, 14351, -24041,  9075, -12516, 15798, -18067,  4531, -3612,  1316,  2826, -4629,  9163, -15101, 22393, -15405, 19953, -24495, 28558, -15774, 16386, -15733, 13430, -4557,  1242,  3327, -9174,  8116, -12161, 16571, -21129, 12778, -14752, 16287, -17156,  8555, -7939,  6584, -4321,   473,  1910, -5209,  9831, -2081,  3495, -6548, 21208, },
	{  3303, -7164, 12493, -18824,  6257, -7287,  7069, -4647,  -283,  2879, -6932, 12685, -10132, 14805, -20204, 26013, -15868, 18345, -20001, 20328, -9383,  7375, -3875, -1325,  4177, -8607, 13882, -19839, 13108, -16323, 19330, -21849, 11779, -12052, 11560, -10114,  3764, -1811,  -894,  4445, -4480,  7301, -10830, 15345, -2683,  3850, -6122, 14453, },
	{  2508, -5034,  7708, -9507,  2198,  -819, -2478,  8504, -4518,  7967, -12569, 18296, -12472, 16043, -19517, 22410, -12051, 11931, -10438,  7164,  -864, -3084,  8342, -14899, 11310, -15616, 20149, -24613, 14314, -15875, 16737, -16632,  7644, -6222,  3931,  -673, -1813,  4505, -7749, 11545, -7945, 10400, -13167, 16340, -2520,  3164, -4255,  7446, },
	{ -2066,  1801,   788, -7398,  5011, -10213, 17925, -28443, 10437, -14339, 18540, -22582, 12902, -13672, 13084, -10564,  2762,  1289, -7081, 14723, -12088, 17608, -23698, 30015, -18042, 20658, -22504, 23196, -11163,  9748, -7170,  3277,  1017, -4403,  8505, -13267,  9296, -12169, 15160, -18161, 10521, -11828, 12916, -13676,  1741, -1656,  1216, 30531, },
	{   744, -3441,  9170, -19261,  8745, -14306, 21537, -30180,  9892, -12133, 13832, -14410,  6578, -4634,   961,  4826, -6512, 11889, -18509, 26196, -17301, 21597, -25622, 28919, -15477, 15569, -14432, 11773, -3668,   462,  3781, -9055,  7642, -11158, 14954, -18868, 11345, -13085, 14503, -15422,  7813, -7418,  6321, -4176,    32,   930, -3427, 28640, },
	{  2664, -6744, 13731, -24293,  9673, -14120, 19047, -23748,  6782, -6919,  5876, -3108,  -978,  4927, -10503, 17809, -13395, 18590, -24231, 29917, -17549, 19544, -20540, 20096, -8879,  6550, -2880, -2256,  4451, -8501, 13190, -18361, 11894, -14583, 17062, -19108, 10234, -10428,  9974, -8688,  3170, -1313, -1465,  5588, -1496,  2879, -6032, 24225, },
	{  3381, -7606, 13909, -22190,  7933, -10242, 11825, -11742,  2195,  -375, -2911,  8034, -7644, 12413, -18288, 25079, -16208, 19855, -23079, 25371, -13067, 12357, -10222,  6350,  -244, -3762,  8857, -14972, 10969, -14735, 18588, -22269, 12733, -13909, 14462, -14177,  6414, -5090,  2992,    17, -2052,  4751, -8294, 13039, -2470,  3809, -6559, 18015, },
	{  3002, -6296, 10420, -14606,  4356, -4168,  2343,  2036, -2496,  5627, -10110, 16056, -11714, 15988, -20590, 25108, -14483, 15714, -15813, 14303, -5348,  2273,  2255, -8338,  7988, -12515, 17601, -23009, 14204, -16689, 18708, -19976, 10092, -9508,  8077, -5651,  1047,  1357, -4439,  8247, -6421,  9159, -12428, 16418, -2696,  3631, -5351, 11002, },
	{  1932, -3627,  4850, -4415,   149,  2208, -6614, 13731, -6034,  9544, -13949, 19095, -12319, 15008, -17215, 18422, -9004,  7646, -4786,   100,  3332, -7821, 13404, -19958, 13620, -17430, 21145, -24431, 13445, -14041, 13770, -12395,  4849, -2744,  -191,  4000, -4347,  7122, -10296, 13819, -8817, 10841, -12958, 15169, -2192,  2536, -3032,  4255, },
	{  -622,  -933,  5261, -13927,  7157, -12733, 20472, -30397, 10539, -13722, 16783, -19183, 10107, -9507,  7310, -3019, -1913,  6791, -13218, 21158, -15207, 20299, -25551, 30549, -17386, 18804, -19190, 18191, -7732,  5350, -1826, -2915,  4445, -8020, 12116, -16618, 10684, -13082, 15376, -17418,  9514, -9990,  9986, -9256,   914,  -351, -1283, 29955, },
	{  1821, -5344, 11939, -22638,  9558, -14740, 21035, -27945,  8640, -9874, 10218, -9090,  2913,   133, -4918, 11695, -10295, 15773, -22129, 29066, -18061, 21332, -23950, 25449, -12659, 11514, -9039,  5016,   356, -4110,  8735, -14149, 10097, -13318, 16578, -19679, 11190, -12201, 12711, -12531,  5714, -4549,  2538,   723,  -762,  1990, -4964, 26766, },
	{  3166, -7469, 14348, -24095,  9119, -12614, 15981, -18371,  4647, -3777,  1538,  2545, -4460,  8974, -14905, 22209, -15334, 19921, -24525, 28674, -15888, 16568, -15995, 13778, -4775,  1503,  3030, -8853,  7951, -12003, 16434, -21031, 12757, -14770, 16353, -17281,  8652, -8074,  6760, -4541,   605,  1756, -5037,  9643, -2056,  3472, -6535, 21365, },
	{  3313, -7197, 12582, -19017,  6348, -7441,  7310, -4996,  -164,  2728, -6750, 12482, -10029, 14715, -20146, 26013, -15912, 18450, -20185, 20608, -9579,  7630, -4191,  -954,  3968, -8386, 13661, -19636, 13026, -16273, 19327, -21907, 11846, -12164, 11722, -10330,  3900, -1974,  -706,  4237, -4369,  7190, -10725, 15260, -2677,  3855, -6153, 14629, },
	{  2536, -5102,  7849, -9765,  2305,  -981, -2251,  8209, -4429,  7869, -12473, 18220, -12457, 16068, -19603, 22580, -12190, 12135, -10718,  7523, -1083, -2828,  8060, -14605, 11168, -15492, 20060, -24577, 14334, -15942, 16862, -16824,  7777, -6393,  4140,  -917, -1676,  4359, -7601, 11404, -7885, 10357, -13154, 16372, -2533,  3191, -4314,  7616, },
	{ -2142,  1947,   544, -7031,  4887, -10059, 17755, -28286, 10412, -14345, 18599, -22721, 13026, -13867, 13366, -10944,  3004,   997, -6745, 14356, -11901, 17433, -23557, 29932, -18044, 20717, -22637, 23416, -11323,  9961, -7437,  3596,   835, -4205,  8299, -13067,  9206, -12098, 15121, -18166, 10554, -11903, 13048, -13886,  1782, -1724,  1356, 30543, },
	{   683, -3330,  9002, -19042,  8684, -14256, 21523, -30243,  9940, -12231, 13999, -14665,  6760, -4878,  1270,  4454, -6300, 11662, -18284, 25996, -17229, 21571, -25663, 29049, -15597, 15754, -14689, 12107, -3872,   702,  3514, -8771,  7500, -11024, 14841, -18791, 11333, -13108, 14571, -15546,  7909, -7555,  6510, -4429,    74,   870, -3335, 28720, },
	{  2631, -6691, 13671, -24257,  9684, -14175, 19175, -23991,  6883, -7074,  6096, -3403,  -792,  4704, -10251, 17543, -13267, 18485, -24171, 29927, -17605, 19665, -20742, 20391, -9078,  6803, -3185, -1905,  4259, -8301, 12995, -18187, 11827, -14547, 17068, -19169, 10298, -10532, 10125, -8890,  3300, -1472, -1273,  5362, -1463,  2842, -5993, 24361, },
	{  3378, -7614, 13955, -22319,  8003, -10373, 12044, -12081,  2317,  -540, -2701,  7782, -7504, 12269, -18156, 24984, -16193, 19893, -23189, 25576, -13227, 12583, -10520,  6723,  -466, -3512,  8589, -14700, 10840, -14628, 18515, -22247, 12756, -13975, 14579, -14353,  6534, -5244,  3181,  -205, -1926,  4613, -8151, 12897, -2454,  3799, -6569, 18184, },
	{  3022, -6349, 10541, -14841,  4458, -4332,  2585,  1702, -2389,  5498, -9965, 15912, -11653, 15954, -20604, 25196, -14577, 15874, -16053, 14634, -5563,  2537,  1945, -7993,  7806, -12335, 17439, -22884, 14171, -16698, 18771, -20105, 10195, -9654,  8269, -5889,  1188,  1197, -4264,  8066, -6333,  9079, -12367, 16390, -2700,  3648, -5398, 11178, },
	{  1963, -3702,  5000, -4676,   252,  2060, -6416, 13490, -5967,  9480, -13902, 19086, -12347, 15086, -17361, 18655, -9175,  7877, -5082,   461,  3123, -7592, 13167, -19732, 13524, -17366, 21129, -24480, 13512, -14159, 13944, -12633,  5001, -2927,    21,  3767, -4224,  7000, -10182, 13725, -8787, 10836, -12990, 15253, -2212,  2572, -3098,  4412, },
	{  -694,  -800,  5048, -13624,  7062, -12627, 20378, -30349, 10551, -13776, 16900, -19387, 10266, -9735,  7616, -3409, -1678,  6522, -12926, 20864, -15073, 20195, -25498, 30572, -17448, 18930, -19391, 18478, -7921,  5584, -2103, -2602,  4276, -7848, 11950, -16473, 10631, -13056, 15390, -17485,  9581, -10100, 10151, -9495,   957,  -416, -1165, 30001, },
	{  1772, -5259, 11822, -22508,  9533, -14743, 21095, -28104,  8718, -10005, 10418, -9376,  3104,  -109, -4627, 11364, -10119, 15601, -21981, 28967, -18052, 21381, -24075, 25668, -12824, 11741, -9331,  5371,   151, -3882,  8495, -13911,  9988, -13229, 16522, -19669, 11216, -12267, 12824, -12699,  5831, -4703,  2735,   475,  -723,  1940, -4898, 26876, },
	{  3148, -7446, 14341, -24146,  9162, -12711, 16162, -18673,  4763, -3943,  1761,  2262, -4291,  8783, -14705, 22022, -15260, 19886, -24550, 28784, -15999, 16747, -16253, 14124, -4993,  1764,  2732, -8529,  7785, -11843, 16295, -20929, 12734, -14784, 16416, -17403,  8747, -8208,  6936, -4761,   737,  1603, -4863,  9453, -2031,  3448, -6521, 21520, },
	{  3322, -7230, 12669, -19207,  6438, -7594,  7549, -5345,   -45,  2575, -6566, 12277, -9925, 14622, -20085, 26008, -15954, 18552, -20366, 20885, -9773,  7884, -4506,  -582,  3759, -8163, 13438, -19429, 12942, -16221, 19321, -21962, 11911, -12273, 11881, -10544,  4035, -2137,  -518,  4028, -4258,  7077, -10619, 15172, -2671,  3859, -6183, 14806, },
	{  2563, -5169,  7989, -10023,  2411, -1142, -2024,  7911, -4339,  7768, -12373, 18140, -12440, 16091, -19685, 22746, -12327, 12338, -10995,  7882, -1303, -2572,  7777, -14308, 11023, -15365, 19967, -24537, 14351, -16007, 16985, -17014,  7909, -6563,  4349, -1162, -1539,  4212, -7452, 11261, -7823, 10313, -13138, 16401, -2546,  3219, -4372,  7786, },
	{ -2218,  2094,   298, -6662,  4760, -9902, 17582, -28123, 10385, -14348, 18655, -22856, 13148, -14060, 13645, -11322,  3245,   703, -6406, 13987, -11712, 17256, -23412, 29843, -18042, 20773, -22766, 23633, -11481, 10173, -7704,  3915,   653, -4006,  8093, -12864,  9114, -12026, 15079, -18169, 10586, -11976, 13177, -14094,  1823, -1792,  1496, 30552, },
	{   620, -3217,  8831, -18818,  8622, -14203, 21506, -30301,  9987, -12326, 14163, -14919,  6941, -5122,  1580,  4080, -6086, 11433, -18056, 25792, -17154, 21542, -25699, 29173, -15714, 15936, -14944, 12438, -4076,   941,  3246, -8485,  7355, -10888, 14726, -18710, 11318, -13128, 14636, -15667,  8004, -7692,  6697, -4681,   117,   811, -3242, 28799, },
	{  2596, -6636, 13608, -24217,  9694, -14227, 19301, -24230,  6983, -7227,  6315, -3697,  -605,  4479, -9996, 17274, -13138, 18377, -24106, 29932, -17657, 19783, -20940, 20684, -9277,  7055, -3490, -1554,  4066, -8100, 12798, -18010, 11757, -14507, 17070, -19226, 10361, -10635, 10274, -9091,  3428, -1632, -1081,  5135, -1430,  2804, -5953, 24496, },
	{  3373, -7620, 13998, -22445,  8072, -10503, 12263, -12418,  2438,  -704, -2491,  7529, -7361, 12121, -18020, 24884, -16176, 19927, -23296, 25776, -13385, 12808, -10818,  7095,  -687, -3261,  8318, -14424, 10710, -14517, 18439, -22221, 12777, -14038, 14694, -14527,  6654, -5398,  3370,  -428, -1800,  4475, -8005, 12753, -2438,  3789, -6578, 18353, },
	{  3042, -6402, 10660, -15074,  4560, -4495,  2827,  1367, -2280,  5366, -9819, 15764, -11590, 15917, -20615, 25279, -14669, 16031, -16290, 14963, -5778,  2802,  1634, -7646,  7622, -12153, 17274, -22755, 14136, -16703, 18830, -20230, 10297, -9799,  8460, -6126,  1329,  1037, -4089,  7883, -6243,  8998, -12303, 16359, -2703,  3665, -5444, 11355, },
	{  1994, -3777,  5149, -4937,   355,  1911, -6217, 13246, -5900,  9414, -13853, 19073, -12373, 15161, -17503, 18886, -9343,  8107, -5378,   823,  2913, -7361, 12927, -19502, 13425, -17298, 21109, -24525, 13576, -14273, 14117, -12869,  5151, -3110,   232,  3532, -4100,  6876, -10067, 13629, -8755, 10829, -13019, 15335, -2232,  2607, -3163,  4571, },
	{  -765,  -665,  4832, -13318,  6964, -12519, 20279, -30295, 10561, -13827, 17014, -19589, 10423, -9961,  7922, -3798, -1442,  6250, -12632, 20565, -14936, 20087, -25441, 30589, -17507, 19052, -19589, 18761, -8108,  5818, -2380, -2289,  4107, -7674, 11783, -16326, 10575, -13029, 15402, -17548,  9646, -10209, 10315, -9733,  1000,  -482, -1046, 30045, },
	{  1723, -5173, 11701, -22372,  9507, -14743, 21151, -28258,  8794, -10134, 10617, -9660,  3295,  -352, -4334, 11031, -9941, 15425, -21828, 28863, -18039, 21426, -24196, 25884, -12987, 11966, -9620,  5725,   -55, -3654,  8254, -13670,  9876, -13137, 16463, -19657, 11241, -12330, 12934, -12866,  5947, -4856,  2932,   227,  -684,  1890, -4830, 26984, },
	{  3128, -7422, 14332, -24192,  9204, -12806, 16341, -18972,  4878, -4108,  1983,  1978, -4120,  8590, -14502, 21830, -15184, 19847, -24571, 28890, -16107, 16924, -16510, 14468, -5211,  2025,  2433, -8204,  7617, -11681, 16152, -20822, 12708, -14796, 16477, -17522,  8841, -8341,  7111, -4980,   870,  1448, -4688,  9260, -2006,  3423, -6506, 21675, },
	{  3331, -7261, 12754, -19394,  6527, -7746,  7788, -5693,    74,  2422, -6381, 12069, -9818, 14527, -20019, 25999, -15992, 18651, -20544, 21159, -9965,  8137, -4821,  -209,  3549, -7938, 13211, -19219, 12855, -16166, 19312, -22013, 11974, -12381, 12039, -10757,  4170, -2300,  -329,  3818, -4145,  6963, -10511, 15081, -2665,  3862, -6212, 14982, },
	{  2589, -5236,  8129, -10279,  2518, -1304, -1795,  7611, -4247,  7666, -12272, 18057, -12420, 16110, -19764, 22908, -12462, 12538, -11272,  8239, -1523, -2315,  7491, -14009, 10877, -15235, 19870, -24493, 14365, -16068, 17104, -17200,  8039, -6733,  4557, -1406, -1402,  4065, -7300, 11116, -7760, 10267, -13120, 16427, -2558,  3246, -4430,  7957, },
	{ -2295,  2241,    51, -6289,  4633, -9743, 17404, -27954, 10357, -14349, 18707, -22987, 13269, -14252, 13923, -11699,  3487,   409, -6066, 13614, -11521, 17075, -23262, 29749, -18037, 20825, -22891, 23845, -11637, 10383, -7969,  4234,   470, -3806,  7884, -12659,  9021, -11951, 15035, -18168, 10616, -12048, 13304, -14299,  1864, -1860,  1637, 30560, },
	{   558, -3104,  8658, -18590,  8558, -14147, 21485, -30353, 10032, -12420, 14325, -15170,  7121, -5365,  1890,  3705, -5872, 11201, -17823, 25582, -17076, 21508, -25731, 29293, -15829, 16116, -15196, 12768, -4280,  1181,  2977, -8197,  7209, -10750, 14608, -18626, 11301, -13146, 14699, -15786,  8098, -7828,  6884, -4933,   159,   751, -3147, 28876, },
	{  2561, -6579, 13543, -24172,  9702, -14276, 19423, -24466,  7083, -7380,  6533, -3992,  -417,  4253, -9739, 17001, -13005, 18266, -24037, 29932, -17706, 19897, -21135, 20973, -9474,  7307, -3795, -1201,  3872, -7897, 12598, -17829, 11686, -14466, 17070, -19281, 10422, -10736, 10422, -9291,  3557, -1791,  -888,  4907, -1397,  2765, -5911, 24630, },
	{  3369, -7624, 14038, -22568,  8140, -10632, 12479, -12755,  2560,  -870, -2279,  7274, -7217, 11971, -17881, 24779, -16156, 19958, -23398, 25972, -13540, 13030, -11114,  7467,  -909, -3009,  8045, -14146, 10578, -14404, 18359, -22191, 12796, -14100, 14807, -14698,  6772, -5551,  3558,  -650, -1673,  4336, -7858, 12606, -2421,  3778, -6586, 18522, },
	{  3061, -6453, 10777, -15305,  4662, -4658,  3069,  1031, -2171,  5234, -9670, 15613, -11524, 15877, -20622, 25357, -14759, 16186, -16525, 15290, -5991,  3066,  1323, -7297,  7437, -11969, 17106, -22622, 14098, -16706, 18886, -20352, 10396, -9942,  8649, -6363,  1470,   876, -3913,  7699, -6151,  8914, -12237, 16326, -2706,  3680, -5489, 11532, },
	{  2025, -3851,  5298, -5199,   459,  1761, -6017, 12999, -5830,  9346, -13801, 19057, -12397, 15233, -17643, 19113, -9511,  8337, -5674,  1185,  2702, -7128, 12685, -19269, 13324, -17228, 21085, -24566, 13638, -14386, 14287, -13102,  5301, -3292,   443,  3298, -3975,  6751, -9949, 13530, -8722, 10821, -13047, 15414, -2252,  2642, -3228,  4729, },
	{  -837,  -530,  4615, -13007,  6865, -12408, 20177, -30235, 10570, -13877, 17125, -19787, 10579, -10186,  8226, -4188, -1205,  5978, -12334, 20263, -14795, 19975, -25379, 30601, -17563, 19172, -19784, 19042, -8294,  6050, -2657, -1974,  3936, -7499, 11613, -16175, 10517, -12999, 15411, -17609,  9710, -10316, 10478, -9971,  1043,  -548,  -926, 30087, },
	{  1672, -5086, 11579, -22232,  9478, -14740, 21204, -28408,  8869, -10262, 10815, -9943,  3486,  -595, -4040, 10695, -9761, 15247, -21671, 28754, -18024, 21467, -24312, 26094, -13148, 12189, -9909,  6078,  -262, -3424,  8011, -13426,  9763, -13044, 16401, -19640, 11263, -12391, 13043, -13030,  6062, -5009,  3129,   -22,  -645,  1839, -4761, 27091, },
	{  3108, -7396, 14321, -24234,  9244, -12898, 16517, -19269,  4992, -4272,  2206,  1693, -3948,  8395, -14297, 21633, -15104, 19805, -24588, 28991, -16213, 17098, -16764, 14810, -5427,  2286,  2134, -7876,  7447, -11517, 16007, -20712, 12680, -14806, 16534, -17638,  8933, -8472,  7284, -5199,  1002,  1293, -4512,  9066, -1980,  3398, -6490, 21829, },
	{  3339, -7291, 12838, -19579,  6615, -7897,  8026, -6042,   194,  2267, -6195, 11858, -9709, 14428, -19951, 25985, -16028, 18746, -20718, 21430, -10156,  8389, -5136,   165,  3338, -7712, 12982, -19005, 12767, -16108, 19299, -22059, 12034, -12486, 12195, -10968,  4304, -2462,  -140,  3607, -4032,  6847, -10400, 14987, -2657,  3865, -6240, 15158, },
	{  2616, -5302,  8268, -10535,  2624, -1467, -1566,  7308, -4155,  7562, -12168, 17970, -12399, 16127, -19840, 23066, -12595, 12737, -11546,  8596, -1743, -2057,  7204, -13706, 10728, -15102, 19770, -24444, 14377, -16127, 17221, -17384,  8168, -6901,  4765, -1650, -1264,  3916, -7148, 10969, -7695, 10219, -13100, 16450, -2569,  3272, -4487,  8128, },
	{ -2371,  2388,  -197, -5914,  4504, -9582, 17224, -27781, 10326, -14348, 18757, -23114, 13387, -14440, 14198, -12074,  3728,   114, -5724, 13239, -11327, 16891, -23108, 29649, -18029, 20874, -23013, 24054, -11791, 10591, -8233,  4552,   287, -3605,  7674, -12451,  8926, -11874, 14987, -18165, 10645, -12117, 13430, -14503,  1904, -1927,  1779, 30566, },
	{   494, -2989,  8483, -18358,  8493, -14089, 21460, -30400, 10075, -12512, 14485, -15420,  7301, -5608,  2200,  3329, -5655, 10967, -17588, 25368, -16995, 21471, -25759, 29407, -15941, 16292, -15446, 13096, -4483,  1420,  2707, -7908,  7062, -10610, 14487, -18539, 11283, -13161, 14759, -15902,  8190, -7962,  7070, -5185,   202,   691, -3051, 28951, },
	{  2525, -6522, 13474, -24123,  9709, -14323, 19542, -24698,  7181, -7531,  6751, -4286,  -229,  4026, -9480, 16725, -12870, 18151, -23964, 29927, -17752, 20008, -21326, 21258, -9669,  7558, -4100,  -848,  3677, -7693, 12396, -17645, 11612, -14421, 17067, -19332, 10481, -10836, 10567, -9489,  3685, -1951,  -695,  4677, -1363,  2726, -5868, 24762, },
	{  3363, -7627, 14077, -22686,  8207, -10758, 12694, -13090,  2681, -1035, -2067,  7017, -7072, 11819, -17738, 24669, -16133, 19985, -23496, 26164, -13694, 13251, -11408,  7837, -1130, -2756,  7771, -13865, 10443, -14288, 18276, -22157, 12812, -14159, 14917, -14867,  6889, -5703,  3746,  -873, -1545,  4195, -7709, 12456, -2404,  3767, -6592, 18690, },
	{  3080, -6504, 10893, -15535,  4763, -4821,  3312,   693, -2061,  5100, -9519, 15459, -11457, 15835, -20625, 25432, -14846, 16339, -16757, 15615, -6204,  3331,  1011, -6946,  7250, -11782, 16935, -22485, 14057, -16706, 18939, -20471, 10494, -10083,  8837, -6599,  1611,   714, -3736,  7513, -6059,  8829, -12169, 16289, -2709,  3695, -5533, 11708, },
	{  2055, -3926,  5447, -5460,   562,  1610, -5814, 12749, -5760,  9276, -13746, 19038, -12418, 15303, -17780, 19338, -9677,  8565, -5969,  1547,  2491, -6894, 12440, -19031, 13221, -17154, 21057, -24603, 13698, -14495, 14455, -13334,  5450, -3474,   655,  3062, -3850,  6624, -9830, 13429, -8687, 10810, -13072, 15491, -2271,  2677, -3293,  4889, },
	{  -910,  -394,  4396, -12693,  6765, -12295, 20071, -30170, 10576, -13924, 17234, -19982, 10733, -10410,  8530, -4578,  -967,  5703, -12035, 19957, -14652, 19860, -25312, 30608, -17616, 19288, -19976, 19319, -8479,  6282, -2934, -1659,  3765, -7321, 11441, -16021, 10458, -12966, 15417, -17666,  9772, -10421, 10639, -10206,  1086,  -614,  -805, 30128, },
	{  1621, -4997, 11453, -22088,  9448, -14735, 21253, -28554,  8942, -10388, 11011, -10225,  3677,  -839, -3745, 10356, -9578, 15065, -21510, 28639, -18005, 21504, -24425, 26301, -13307, 12410, -10196,  6431,  -468, -3194,  7766, -13180,  9648, -12947, 16336, -19621, 11284, -12450, 13149, -13193,  6176, -5161,  3325,  -271,  -605,  1788, -4690, 27197, },
	{  3087, -7368, 14306, -24271,  9282, -12989, 16691, -19563,  5106, -4437,  2429,  1407, -3775,  8198, -14088, 21433, -15022, 19759, -24600, 29087, -16316, 17269, -17015, 15150, -5643,  2547,  1834, -7547,  7276, -11350, 15858, -20598, 12650, -14813, 16589, -17751,  9024, -8602,  7457, -5417,  1134,  1138, -4335,  8869, -1954,  3372, -6472, 21981, },
	{  3347, -7320, 12919, -19761,  6703, -8048,  8264, -6391,   314,  2112, -6006, 11645, -9599, 14327, -19878, 25966, -16061, 18839, -20889, 21697, -10346,  8640, -5450,   539,  3126, -7484, 12751, -18787, 12675, -16047, 19282, -22102, 12093, -12589, 12349, -11177,  4438, -2625,    49,  3395, -3918,  6730, -10287, 14891, -2650,  3867, -6267, 15333, },
	{  2642, -5367,  8406, -10791,  2730, -1629, -1335,  7004, -4062,  7457, -12061, 17880, -12375, 16141, -19913, 23221, -12726, 12934, -11819,  8952, -1963, -1799,  6915, -13401, 10577, -14966, 19666, -24391, 14386, -16183, 17334, -17564,  8296, -7068,  4972, -1895, -1126,  3767, -6994, 10820, -7628, 10169, -13078, 16471, -2580,  3298, -4544,  8299, },
	{ -2447,  2536,  -446, -5537,  4374, -9418, 17039, -27601, 10294, -14344, 18803, -23237, 13503, -14627, 14472, -12448,  3970,  -181, -5381, 12860, -11131, 16704, -22949, 29545, -18017, 20919, -23130, 24259, -11944, 10798, -8497,  4870,   104, -3403,  7462, -12240,  8829, -11795, 14937, -18157, 10671, -12184, 13553, -14705,  1945, -1995,  1922, 30570, },
	{   430, -2873,  8305, -18122,  8425, -14027, 21431, -30442, 10117, -12602, 14643, -15667,  7480, -5850,  2511,  2951, -5438, 10730, -17348, 25149, -16910, 21430, -25782, 29517, -16050, 16467, -15694, 13422, -4686,  1660,  2436, -7617,  6913, -10468, 14363, -18448, 11262, -13175, 14816, -16016,  8282, -8095,  7255, -5436,   245,   630, -2953, 29025, },
	{  2488, -6462, 13403, -24069,  9713, -14368, 19659, -24926,  7278, -7682,  6969, -4580,   -41,  3797, -9219, 16445, -12733, 18032, -23886, 29916, -17795, 20115, -21514, 21541, -9863,  7807, -4404,  -495,  3481, -7486, 12192, -17458, 11536, -14374, 17061, -19379, 10538, -10933, 10712, -9686,  3813, -2110,  -501,  4446, -1329,  2686, -5824, 24894, },
	{  3357, -7629, 14113, -22802,  8273, -10884, 12908, -13423,  2803, -1201, -1854,  6759, -6925, 11664, -17592, 24555, -16107, 20008, -23591, 26351, -13845, 13469, -11701,  8207, -1352, -2502,  7495, -13581, 10307, -14169, 18190, -22120, 12826, -14215, 15024, -15034,  7005, -5854,  3933, -1096, -1418,  4054, -7559, 12304, -2387,  3754, -6598, 18857, },
	{  3098, -6554, 11008, -15762,  4864, -4984,  3555,   354, -1950,  4965, -9366, 15301, -11387, 15789, -20625, 25502, -14931, 16488, -16987, 15938, -6416,  3595,   698, -6594,  7062, -11593, 16760, -22343, 14014, -16703, 18988, -20586, 10591, -10223,  9024, -6834,  1751,   553, -3557,  7325, -5965,  8742, -12099, 16250, -2710,  3710, -5577, 11885, },
	{  2086, -4000,  5596, -5722,   666,  1458, -5610, 12496, -5689,  9205, -13689, 19015, -12438, 15370, -17914, 19560, -9842,  8792, -6263,  1909,  2279, -6658, 12193, -18790, 13115, -17077, 21026, -24635, 13755, -14603, 14621, -13564,  5599, -3655,   867,  2825, -3724,  6496, -9708, 13325, -8651, 10798, -13095, 15565, -2290,  2711, -3358,  5049, },
	{  -983,  -258,  4175, -12376,  6663, -12179, 19960, -30099, 10581, -13968, 17339, -20174, 10885, -10632,  8833, -4967,  -730,  5427, -11732, 19646, -14506, 19740, -25241, 30609, -17666, 19401, -20164, 19593, -8663,  6514, -3210, -1343,  3593, -7143, 11266, -15864, 10397, -12932, 15420, -17721,  9833, -10525, 10799, -10441,  1129,  -681,  -683, 30167, },
	{  1569, -4906, 11325, -21938,  9416, -14727, 21299, -28694,  9015, -10513, 11205, -10505,  3867, -1083, -3448, 10015, -9394, 14881, -21346, 28519, -17983, 21538, -24533, 26503, -13464, 12629, -10482,  6783,  -675, -2962,  7519, -12932,  9532, -12849, 16268, -19597, 11302, -12507, 13253, -13353,  6289, -5312,  3521,  -521,  -566,  1736, -4618, 27301, },
	{  3066, -7339, 14289, -24304,  9319, -13078, 16862, -19855,  5220, -4601,  2653,  1120, -3601,  7999, -13877, 21228, -14937, 19709, -24608, 29177, -16416, 17438, -17263, 15487, -5859,  2808,  1533, -7216,  7104, -11181, 15707, -20481, 12617, -14817, 16641, -17862,  9114, -8731,  7629, -5634,  1267,   982, -4156,  8671, -1927,  3345, -6453, 22133, },
	{  3354, -7348, 12998, -19940,  6789, -8197,  8501, -6740,   434,  1956, -5816, 11430, -9486, 14223, -19802, 25943, -16091, 18928, -21056, 21961, -10534,  8890, -5764,   913,  2913, -7254, 12517, -18565, 12582, -15983, 19262, -22141, 12150, -12690, 12501, -11385,  4571, -2787,   239,  3182, -3803,  6611, -10173, 14791, -2642,  3868, -6293, 15509, },
	{  2668, -5432,  8544, -11045,  2837, -1792, -1103,  6697, -3967,  7350, -11952, 17787, -12348, 16152, -19982, 23372, -12855, 13129, -12091,  9307, -2183, -1539,  6624, -13092, 10424, -14828, 19558, -24333, 14393, -16237, 17445, -17742,  8422, -7235,  5178, -2139,  -988,  3616, -6838, 10668, -7560, 10117, -13053, 16489, -2591,  3323, -4600,  8471, },
	{ -2524,  2684,  -697, -5157,  4242, -9253, 16851, -27416, 10259, -14337, 18846, -23357, 13616, -14812, 14744, -12821,  4211,  -477, -5036, 12479, -10932, 16513, -22787, 29434, -18003, 20961, -23244, 24459, -12094, 11004, -8759,  5187,   -79, -3201,  7248, -12028,  8730, -11714, 14885, -18147, 10696, -12250, 13673, -14904,  1985, -2063,  2066, 30572, },
	{   366, -2755,  8125, -17881,  8356, -13964, 21397, -30479, 10157, -12690, 14799, -15912,  7657, -6092,  2821,  2573, -5219, 10491, -17105, 24925, -16822, 21385, -25800, 29621, -16156, 16638, -15939, 13747, -4888,  1900,  2165, -7324,  6763, -10324, 14237, -18354, 11239, -13186, 14872, -16126,  8371, -8227,  7440, -5687,   287,   569, -2854, 29097, },
	{  2450, -6401, 13329, -24010,  9716, -14410, 19771, -25150,  7374, -7832,  7185, -4874,   148,  3567, -8955, 16162, -12593, 17911, -23804, 29900, -17835, 20220, -21698, 21820, -10056,  8056, -4708,  -141,  3284, -7279, 11985, -17267, 11459, -14325, 17052, -19423, 10594, -11029, 10854, -9881,  3940, -2269,  -307,  4214, -1294,  2645, -5778, 25024, },
	{  3350, -7630, 14146, -22913,  8337, -11008, 13120, -13755,  2924, -1367, -1640,  6498, -6776, 11507, -17443, 24436, -16078, 20029, -23681, 26534, -13994, 13686, -11992,  8576, -1574, -2248,  7217, -13294, 10169, -14048, 18100, -22078, 12838, -14269, 15129, -15198,  7120, -6005,  4120, -1319, -1290,  3911, -7407, 12150, -2369,  3741, -6602, 19024, },
	{  3115, -6603, 11121, -15988,  4964, -5146,  3798,    15, -1839,  4829, -9211, 15141, -11315, 15741, -20620, 25567, -15013, 16635, -17214, 16258, -6628,  3859,   384, -6240,  6872, -11401, 16582, -22198, 13968, -16696, 19035, -20697, 10685, -10361,  9209, -7068,  1892,   391, -3379,  7136, -5870,  8654, -12027, 16207, -2712,  3724, -5620, 12062, },
	{  2116, -4074,  5744, -5984,   771,  1305, -5404, 12239, -5616,  9132, -13629, 18989, -12455, 15434, -18046, 19778, -10005,  9017, -6557,  2272,  2066, -6420, 11943, -18545, 13007, -16997, 20991, -24663, 13810, -14708, 14784, -13791,  5746, -3836,  1079,  2588, -3597,  6367, -9585, 13218, -8612, 10783, -13115, 15637, -2308,  2745, -3422,  5210, },
	{ -1056,  -120,  3952, -12055,  6559, -12060, 19846, -30023, 10584, -14010, 17442, -20363, 11036, -10853,  9134, -5357,  -491,  5150, -11427, 19332, -14358, 19618, -25165, 30605, -17713, 19510, -20349, 19865, -8845,  6744, -3487, -1027,  3420, -6963, 11090, -15704, 10333, -12895, 15421, -17772,  9892, -10627, 10957, -10674,  1172,  -747,  -559, 30204, },
	{  1517, -4815, 11194, -21784,  9382, -14716, 21341, -28830,  9085, -10636, 11398, -10785,  4057, -1327, -3150,  9671, -9208, 14694, -21176, 28394, -17958, 21568, -24637, 26701, -13618, 12847, -10766,  7135,  -881, -2730,  7271, -12680,  9413, -12748, 16197, -19570, 11319, -12562, 13355, -13511,  6401, -5463,  3717,  -771,  -526,  1683, -4545, 27403, },
	{  3043, -7309, 14269, -24333,  9354, -13164, 17031, -20144,  5332, -4765,  2876,   833, -3426,  7799, -13663, 21020, -14849, 19656, -24612, 29263, -16514, 17603, -17509, 15822, -6073,  3068,  1231, -6884,  6930, -11010, 15553, -20359, 12583, -14819, 16690, -17969,  9202, -8858,  7799, -5851,  1399,   826, -3977,  8471, -1900,  3317, -6432, 22284, },
	{  3360, -7374, 13075, -20116,  6875, -8346,  8737, -7088,   555,  1800, -5625, 11211, -9372, 14116, -19722, 25915, -16118, 19015, -21220, 22221, -10721,  9139, -6077,  1288,  2700, -7022, 12280, -18340, 12486, -15917, 19239, -22177, 12205, -12789, 12651, -11591,  4703, -2948,   428,  2968, -3687,  6492, -10056, 14689, -2633,  3869, -6318, 15684, },
	{  2693, -5497,  8680, -11299,  2943, -1955,  -870,  6388, -3872,  7241, -11841, 17690, -12320, 16160, -20047, 23519, -12982, 13322, -12361,  9661, -2403, -1280,  6332, -12781, 10269, -14686, 19447, -24271, 14397, -16287, 17553, -17917,  8547, -7400,  5384, -2383,  -849,  3465, -6681, 10514, -7491, 10064, -13025, 16504, -2601,  3348, -4656,  8644, },
	{  1504, -2600,  2833,  -948, -1194,  4110, -9085, 16659, -6807, 10223, -14328, 18886, -11736, 13728, -14994, 15013, -6596,  4451,  -773, -4689,  6047, -10732, 16319, -22620, 14659, -17985, 20998, -23353, 12328, -12242, 11207, -9019,  2752,  -263, -2997,  7034, -5906,  8630, -11630, 14829, -9067, 10719, -12313, 13792, -1888,  2024, -2130,  2211, },
	{   301, -2637,  7942, -17636,  8285, -13897, 21360, -30510, 10195, -12775, 14952, -16155,  7834, -6333,  3132,  2193, -4998, 10250, -16859, 24696, -16732, 21336, -25814, 29720, -16260, 16807, -16182, 14069, -5090,  2139,  1893, -7029,  6612, -10177, 14108, -18256, 11215, -13194, 14924, -16234,  8460, -8358,  7623, -5937,   330,   508, -2754, 29168, },
	{  2412, -6338, 13252, -23947,  9717, -14450, 19881, -25371,  7469, -7981,  7401, -5168,   338,  3337, -8689, 15875, -12451, 17786, -23718, 29879, -17872, 20320, -21879, 22095, -10247,  8303, -5012,   214,  3087, -7069, 11776, -17073, 11379, -14272, 17040, -19464, 10647, -11123, 10995, -10075,  4066, -2429,  -113,  3980, -1260,  2604, -5731, 25153, },
	{  3342, -7628, 14177, -23021,  8400, -11130, 13330, -14086,  3045, -1533, -1425,  6236, -6626, 11348, -17290, 24313, -16047, 20045, -23767, 26713, -14141, 13900, -12281,  8944, -1796, -1992,  6938, -13004, 10028, -13924, 18007, -22032, 12848, -14321, 15231, -15359,  7234, -6154,  4307, -1542, -1161,  3768, -7254, 11993, -2350,  3727, -6606, 19190, },
	{  3132, -6651, 11233, -16212,  5063, -5307,  4041,  -326, -1727,  4691, -9055, 14978, -11240, 15690, -20613, 25629, -15093, 16780, -17438, 16576, -6838,  4122,    71, -5884,  6681, -11208, 16401, -22048, 13920, -16687, 19078, -20805, 10778, -10498,  9393, -7301,  2032,   229, -3199,  6945, -5774,  8564, -11952, 16162, -2713,  3737, -5663, 12240, },
	{  2147, -4147,  5893, -6246,   875,  1152, -5197, 11980, -5542,  9057, -13566, 18959, -12470, 15496, -18174, 19994, -10167,  9242, -6850,  2635,  1852, -6181, 11690, -18296, 12896, -16914, 20952, -24687, 13863, -14810, 14944, -14016,  5893, -4017,  1291,  2350, -3469,  6236, -9460, 13109, -8573, 10767, -13134, 15706, -2326,  2779, -3486,  5372, },
	{ -1129,    18,  3727, -11730,  6454, -11939, 19728, -29940, 10585, -14050, 17542, -20548, 11186, -11072,  9435, -5746,  -252,  4871, -11119, 19013, -14206, 19491, -25085, 30595, -17757, 19617, -20531, 20133, -9026,  6974, -3763,  -710,  3246, -6781, 10911, -15542, 10268, -12855, 15418, -17820,  9949, -10727, 11113, -10906,  1215,  -814,  -434, 30240, },
	{  1464, -4721, 11060, -21626,  9346, -14703, 21379, -28961,  9154, -10758, 11589, -11063,  4247, -1572, -2851,  9325, -9020, 14503, -21003, 28263, -17929, 21594, -24737, 26894, -13770, 13062, -11049,  7485, -1088, -2497,  7021, -12426,  9293, -12644, 16123, -19540, 11333, -12614, 13454, -13667,  6512, -5613,  3913, -1022,  -485,  1631, -4471, 27504, },
	{  3020, -7277, 14247, -24358,  9388, -13249, 17197, -20430,  5444, -4928,  3099,   544, -3250,  7596, -13445, 20807, -14759, 19600, -24611, 29344, -16608, 17766, -17752, 16155, -6287,  3329,   929, -6549,  6754, -10837, 15395, -20234, 12546, -14818, 16736, -18073,  9288, -8984,  7968, -6066,  1531,   669, -3796,  8268, -1873,  3289, -6411, 22435, },
	{  3366, -7400, 13150, -20289,  6960, -8494,  8972, -7436,   675,  1642, -5432, 10990, -9255, 14007, -19638, 25882, -16143, 19098, -21381, 22478, -10906,  9387, -6390,  1663,  2485, -6789, 12041, -18112, 12388, -15847, 19212, -22208, 12257, -12886, 12799, -11795,  4835, -3110,   618,  2753, -3571,  6370, -9938, 14584, -2624,  3869, -6342, 15859, },
	{  2719, -5560,  8816, -11551,  3049, -2119,  -637,  6077, -3775,  7131, -11727, 17590, -12289, 16165, -20110, 23662, -13107, 13513, -12629, 10014, -2623, -1019,  6038, -12468, 10112, -14542, 19332, -24205, 14399, -16335, 17658, -18089,  8671, -7564,  5589, -2628,  -710,  3313, -6523, 10359, -7421, 10008, -12996, 16515, -2611,  3372, -4711,  8816, },
	{  1536, -2677,  2981, -1200, -1097,  3976, -8915, 16464, -6758, 10184, -14316, 18922, -11792, 13837, -15174, 15281, -6780,  4691, -1069, -4342,  5854, -10529, 16122, -22448, 14599, -17964, 21033, -23459, 12424, -12389, 11409, -9279,  2910,  -446, -2793,  6817, -5798,  8528, -11544, 14771, -9058, 10739, -12374, 13909, -1912,  2064, -2198,  2357, },
	{   236, -2517,  7757, -17386,  8212, -13828, 21319, -30536, 10232, -12859, 15103, -16395,  8010, -6573,  3443,  1811, -4777, 10007, -16609, 24463, -16638, 21283, -25823, 29814, -16361, 16973, -16422, 14389, -5291,  2379,  1620, -6733,  6459, -10029, 13976, -18155, 11188, -13200, 14974, -16340,  8547, -8487,  7805, -6188,   373,   446, -2653, 29237, },
	{  2373, -6274, 13172, -23879,  9717, -14488, 19988, -25587,  7563, -8128,  7616, -5462,   527,  3105, -8422, 15585, -12306, 17657, -23627, 29852, -17906, 20417, -22056, 22368, -10436,  8550, -5315,   569,  2888, -6858, 11564, -16876, 11296, -14218, 17024, -19502, 10699, -11215, 11134, -10267,  4192, -2587,    82,  3746, -1225,  2562, -5682, 25280, },
	{  3334, -7626, 14206, -23125,  8462, -11251, 13539, -14415,  3165, -1699, -1209,  5972, -6474, 11186, -17134, 24185, -16012, 20058, -23849, 26887, -14285, 14112, -12569,  9310, -2018, -1736,  6657, -12712,  9886, -13798, 17911, -21983, 12856, -14370, 15331, -15518,  7347, -6303,  4493, -1765, -1032,  3624, -7098, 11834, -2331,  3713, -6608, 19355, },
	{  3149, -6698, 11343, -16433,  5163, -5469,  4284,  -668, -1615,  4553, -8896, 14811, -11164, 15636, -20601, 25685, -15170, 16921, -17660, 16892, -7048,  4386,  -244, -5526,  6488, -11012, 16217, -21894, 13870, -16675, 19117, -20910, 10869, -10632,  9576, -7533,  2173,    66, -3018,  6753, -5677,  8472, -11875, 16113, -2713,  3750, -5704, 12417, },
	{  2177, -4220,  6040, -6508,   980,   998, -4988, 11718, -5466,  8980, -13501, 18926, -12483, 15555, -18299, 20207, -10327,  9465, -7143,  2998,  1638, -5941, 11435, -18044, 12783, -16828, 20909, -24706, 13913, -14910, 15103, -14239,  6039, -4197,  1503,  2111, -3340,  6104, -9333, 12998, -8531, 10749, -13150, 15772, -2344,  2812, -3549,  5535, },
	{ -1203,   157,  3501, -11402,  6347, -11815, 19606, -29853, 10584, -14087, 17639, -20731, 11333, -11290,  9735, -6135,   -13,  4591, -10809, 18691, -14052, 19361, -25000, 30580, -17798, 19720, -20709, 20398, -9206,  7202, -4038,  -392,  3071, -6598, 10730, -15376, 10201, -12814, 15414, -17866, 10005, -10825, 11267, -11137,  1258,  -881,  -309, 30273, },
	{  1410, -4627, 10924, -21463,  9308, -14686, 21414, -29087,  9222, -10878, 11779, -11340,  4436, -1817, -2551,  8977, -8829, 14310, -20826, 28127, -17897, 21616, -24833, 27083, -13921, 13275, -11330,  7835, -1295, -2264,  6769, -12170,  9170, -12539, 16046, -19506, 11346, -12665, 13552, -13821,  6623, -5762,  4108, -1273,  -445,  1577, -4395, 27604, },
	{  2996, -7243, 14222, -24378,  9420, -13331, 17361, -20713,  5556, -5091,  3322,   255, -3073,  7392, -13225, 20590, -14665, 19539, -24606, 29419, -16700, 17926, -17992, 16486, -6500,  3589,   626, -6214,  6577, -10662, 15235, -20105, 12506, -14814, 16779, -18174,  9373, -9108,  8137, -6282,  1663,   512, -3615,  8064, -1845,  3260, -6388, 22584, },
	{  3371, -7424, 13224, -20459,  7043, -8640,  9206, -7784,   796,  1484, -5238, 10767, -9137, 13895, -19551, 25845, -16164, 19177, -21538, 22731, -11089,  9633, -6702,  2038,  2270, -6555, 11799, -17880, 12287, -15774, 19182, -22235, 12308, -12981, 12945, -11997,  4966, -3271,   808,  2538, -3453,  6248, -9817, 14476, -2614,  3868, -6366, 16033, },
	{  2743, -5623,  8950, -11803,  3155, -2282,  -402,  5764, -3678,  7019, -11611, 17486, -12256, 16168, -20168, 23801, -13230, 13702, -12895, 10366, -2842,  -758,  5743, -12151,  9953, -14395, 19214, -24134, 14398, -16380, 17759, -18258,  8793, -7727,  5793, -2872,  -570,  3161, -6364, 10201, -7349,  9951, -12964, 16525, -2621,  3396, -4766,  8989, },
	{  1568, -2753,  3130, -1453, -1001,  3841, -8742, 16265, -6707, 10144, -14302, 18955, -11846, 13944, -15352, 15546, -6964,  4931, -1366, -3992,  5659, -10324, 15922, -22273, 14536, -17940, 21063, -23560, 12518, -12533, 11609, -9537,  3068,  -630, -2588,  6599, -5688,  8425, -11456, 14710, -9048, 10758, -12433, 14023, -1936,  2103, -2266,  2504, },
	{   170, -2397,  7570, -17133,  8138, -13756, 21275, -30556, 10267, -12940, 15251, -16633,  8184, -6813,  3754,  1429, -4554,  9761, -16356, 24225, -16541, 21226, -25828, 29903, -16460, 17136, -16659, 14707, -5491,  2619,  1347, -6435,  6305, -9879, 13842, -18051, 11159, -13204, 15021, -16442,  8633, -8616,  7986, -6437,   416,   384, -2551, 29304, },
	{  2333, -6209, 13089, -23807,  9714, -14522, 20091, -25800,  7656, -8275,  7830, -5755,   717,  2872, -8152, 15292, -12158, 17525, -23532, 29820, -17937, 20511, -22230, 22636, -10624,  8795, -5617,   924,  2689, -6646, 11350, -16676, 11212, -14160, 17006, -19536, 10749, -11305, 11271, -10458,  4318, -2746,   278,  3510, -1189,  2520, -5633, 25407, },
	{  3325, -7622, 14232, -23225,  8523, -11370, 13745, -14742,  3286, -1865,  -992,  5706, -6321, 11022, -16974, 24053, -15974, 20068, -23928, 27057, -14428, 14322, -12855,  9676, -2240, -1480,  6374, -12417,  9742, -13669, 17811, -21929, 12861, -14416, 15428, -15675,  7458, -6451,  4678, -1988,  -902,  3479, -6942, 11672, -2312,  3698, -6609, 19520, },
	{  3165, -6744, 11452, -16653,  5261, -5630,  4527, -1011, -1502,  4413, -8735, 14642, -11085, 15578, -20586, 25738, -15244, 17060, -17879, 17205, -7257,  4649,  -559, -5168,  6293, -10814, 16030, -21737, 13817, -16660, 19153, -21011, 10958, -10765,  9757, -7764,  2313,   -97, -2837,  6559, -5578,  8378, -11795, 16062, -2713,  3762, -5745, 12594, },
	{  2207, -4293,  6188, -6770,  1085,   843, -4777, 11453, -5390,  8901, -13433, 18889, -12494, 15612, -18421, 20416, -10486,  9687, -7435,  3362,  1423, -5699, 11178, -17789, 12667, -16738, 20863, -24721, 13961, -15008, 15259, -14460,  6183, -4377,  1715,  1871, -3211,  5971, -9205, 12884, -8489, 10728, -13163, 15836, -2361,  2845, -3613,  5698, },
	{ -1277,   297,  3273, -11071,  6238, -11689, 19480, -29760, 10582, -14122, 17733, -20910, 11479, -11506, 10033, -6524,   227,  4310, -10497, 18365, -13895, 19227, -24911, 30560, -17836, 19819, -20884, 20659, -9384,  7430, -4314,   -75,  2896, -6414, 10547, -15207, 10132, -12770, 15406, -17908, 10059, -10922, 11420, -11366,  1300,  -948,  -182, 30305, },
	{  1355, -4531, 10785, -21295,  9269, -14668, 21444, -29208,  9289, -10996, 11967, -11615,  4625, -2062, -2250,  8627, -8637, 14114, -20645, 27986, -17862, 21635, -24925, 27267, -14068, 13486, -11609,  8184, -1502, -2029,  6517, -11911,  9046, -12430, 15966, -19469, 11356, -12713, 13647, -13973,  6732, -5911,  4303, -1525,  -404,  1523, -4318, 27702, },
	{  2971, -7208, 14194, -24394,  9451, -13411, 17522, -20993,  5667, -5253,  3546,   -35, -2895,  7186, -13002, 20368, -14569, 19475, -24596, 29490, -16789, 18083, -18230, 16814, -6712,  3849,   323, -5876,  6399, -10484, 15072, -19973, 12465, -14808, 16819, -18272,  9456, -9231,  8303, -6496,  1795,   354, -3432,  7858, -1816,  3231, -6364, 22732, },
	{  3375, -7446, 13295, -20626,  7126, -8786,  9440, -8132,   917,  1326, -5042, 10542, -9017, 13780, -19460, 25803, -16183, 19254, -21691, 22981, -11270,  9878, -7013,  2414,  2055, -6319, 11555, -17645, 12184, -15699, 19148, -22259, 12356, -13074, 13088, -12197,  5096, -3432,   998,  2322, -3335,  6124, -9695, 14365, -2604,  3866, -6388, 16208, },
	{  2768, -5686,  9084, -12053,  3260, -2446,  -167,  5449, -3580,  6906, -11492, 17379, -12221, 16167, -20223, 23936, -13350, 13888, -13159, 10716, -3062,  -496,  5446, -11832,  9792, -14246, 19092, -24059, 14395, -16422, 17858, -18424,  8914, -7888,  5997, -3115,  -431,  3007, -6203, 10041, -7275,  9891, -12930, 16531, -2629,  3420, -4820,  9163, },
	{  1600, -2829,  3279, -1707,  -903,  3704, -8568, 16063, -6656, 10102, -14285, 18985, -11898, 14049, -15527, 15809, -7147,  5171, -1663, -3642,  5463, -10117, 15719, -22093, 14470, -17912, 21090, -23657, 12610, -12676, 11807, -9794,  3225,  -814, -2383,  6380, -5577,  8320, -11366, 14647, -9037, 10776, -12490, 14135, -1960,  2142, -2333,  2652, },
	{   103, -2275,  7380, -16875,  8061, -13681, 21226, -30571, 10300, -13020, 15398, -16868,  8358, -7052,  4065,  1046, -4330,  9513, -16100, 23982, -16441, 21166, -25828, 29987, -16555, 17297, -16894, 15023, -5690,  2858,  1073, -6136,  6149, -9727, 13705, -17943, 11128, -13206, 15066, -16542,  8717, -8743,  8167, -6686,   460,   322, -2447, 29369, },
	{  2293, -6141, 13004, -23730,  9710, -14555, 20191, -26009,  7748, -8420,  8043, -6049,   907,  2638, -7880, 14995, -12009, 17390, -23433, 29782, -17964, 20601, -22399, 22901, -10810,  9039, -5919,  1280,  2489, -6432, 11134, -16472, 11126, -14100, 16985, -19566, 10798, -11393, 11406, -10648,  4443, -2905,   473,  3272, -1154,  2477, -5582, 25532, },
	{  3315, -7616, 14255, -23322,  8582, -11487, 13950, -15068,  3406, -2032,  -775,  5439, -6166, 10855, -16811, 23916, -15934, 20074, -24002, 27222, -14567, 14530, -13138, 10040, -2462, -1223,  6090, -12119,  9595, -13537, 17708, -21872, 12864, -14460, 15523, -15829,  7569, -6598,  4863, -2211,  -773,  3333, -6783, 11508, -2292,  3682, -6609, 19684, },
	{  3181, -6789, 11559, -16871,  5359, -5790,  4770, -1354, -1388,  4272, -8572, 14469, -11005, 15518, -20567, 25785, -15316, 17196, -18095, 17515, -7464,  4911,  -874, -4807,  6098, -10613, 15839, -21575, 13761, -16642, 19186, -21108, 11045, -10897,  9936, -7993,  2453,  -260, -2655,  6364, -5479,  8283, -11714, 16007, -2712,  3773, -5785, 12771, },
	{  2236, -4366,  6335, -7032,  1191,   688, -4565, 11185, -5312,  8820, -13363, 18849, -12502, 15666, -18541, 20622, -10643,  9908, -7726,  3725,  1207, -5456, 10919, -17529, 12549, -16646, 20813, -24731, 14006, -15103, 15412, -14679,  6327, -4556,  1927,  1631, -3081,  5837, -9074, 12768, -8444, 10706, -13175, 15897, -2378,  2877, -3676,  5861, },
	{ -1351,   437,  3044, -10736,  6128, -11560, 19350, -29661, 10577, -14154, 17825, -21086, 11624, -11721, 10331, -6912,   468,  4027, -10182, 18035, -13735, 19090, -24817, 30534, -17871, 19916, -21056, 20918, -9561,  7656, -4589,   244,  2720, -6228, 10362, -15036, 10061, -12723, 15396, -17947, 10111, -11017, 11572, -11594,  1343, -1015,   -54, 30335, },
	{  1300, -4433, 10644, -21123,  9228, -14646, 21471, -29325,  9353, -11113, 12153, -11889,  4814, -2307, -1948,  8274, -8443, 13915, -20460, 27840, -17824, 21649, -25012, 27447, -14214, 13695, -11887,  8531, -1709, -1794,  6262, -11650,  8921, -12320, 15883, -19428, 11365, -12759, 13740, -14122,  6840, -6059,  4498, -1777,  -364,  1469, -4239, 27799, },
	{  2946, -7171, 14163, -24406,  9480, -13490, 17680, -21271,  5777, -5415,  3769,  -325, -2716,  6979, -12777, 20143, -14470, 19408, -24582, 29555, -16876, 18236, -18464, 17140, -6924,  4109,    19, -5537,  6219, -10305, 14905, -19837, 12421, -14799, 16856, -18367,  9538, -9352,  8469, -6709,  1927,   197, -3249,  7650, -1788,  3200, -6339, 22879, },
	{  3379, -7468, 13364, -20791,  7208, -8930,  9672, -8479,  1039,  1166, -4845, 10313, -8894, 13662, -19366, 25756, -16199, 19327, -21841, 23227, -11450, 10121, -7323,  2789,  1838, -6081, 11309, -17406, 12079, -15621, 19111, -22279, 12402, -13164, 13230, -12395,  5226, -3592,  1188,  2105, -3216,  5999, -9570, 14252, -2594,  3864, -6409, 16382, },
	{  2792, -5747,  9216, -12302,  3366, -2610,    69,  5132, -3481,  6791, -11372, 17269, -12183, 16164, -20275, 24067, -13469, 14073, -13422, 11065, -3281,  -234,  5148, -11511,  9629, -14093, 18966, -23979, 14389, -16461, 17954, -18587,  9033, -8049,  6200, -3359,  -291,  2853, -6040,  9879, -7200,  9830, -12893, 16534, -2638,  3442, -4874,  9337, },
	{  1632, -2906,  3429, -1962,  -805,  3567, -8391, 15857, -6603, 10058, -14265, 19011, -11948, 14152, -15700, 16070, -7329,  5409, -1961, -3290,  5265, -9908, 15512, -21909, 14401, -17881, 21113, -23751, 12700, -12816, 12003, -10049,  3382,  -998, -2176,  6159, -5464,  8213, -11274, 14580, -9024, 10791, -12545, 14245, -1984,  2181, -2400,  2800, },
	{    36, -2152,  7189, -16613,  7983, -13603, 21173, -30581, 10331, -13097, 15542, -17101,  8530, -7290,  4375,   662, -4104,  9263, -15840, 23734, -16338, 21101, -25823, 30066, -16648, 17455, -17127, 15336, -5889,  3097,   798, -5835,  5993, -9573, 13566, -17833, 11095, -13205, 15108, -16639,  8800, -8868,  8346, -6935,   503,   259, -2342, 29433, },
	{  2251, -6073, 12916, -23648,  9704, -14585, 20288, -26213,  7839, -8565,  8255, -6341,  1098,  2403, -7606, 14695, -11856, 17251, -23329, 29740, -17988, 20688, -22565, 23162, -10995,  9281, -6220,  1636,  2289, -6217, 10915, -16265, 11037, -14038, 16960, -19593, 10844, -11479, 11540, -10835,  4567, -3063,   669,  3034, -1118,  2433, -5529, 25656, },
	{  3304, -7609, 14276, -23414,  8640, -11603, 14153, -15392,  3526, -2198,  -557,  5170, -6010, 10686, -16645, 23775, -15890, 20076, -24071, 27383, -14705, 14735, -13421, 10403, -2683,  -965,  5805, -11819,  9447, -13403, 17602, -21810, 12864, -14502, 15615, -15980,  7678, -6743,  5047, -2434,  -643,  3187, -6624, 11341, -2272,  3665, -6608, 19848, },
	{  3196, -6833, 11665, -17086,  5456, -5950,  5013, -1698, -1274,  4130, -8407, 14293, -10922, 15456, -20545, 25829, -15386, 17329, -18309, 17823, -7671,  5173, -1189, -4446,  5901, -10411, 15646, -21409, 13703, -16621, 19216, -21202, 11130, -11026, 10114, -8222,  2592,  -423, -2472,  6168, -5378,  8187, -11630, 15950, -2711,  3784, -5824, 12948, },
	{  2266, -4438,  6482, -7294,  1296,   532, -4351, 10914, -5234,  8738, -13290, 18806, -12509, 15717, -18657, 20825, -10798, 10127, -8016,  4088,   991, -5211, 10657, -17267, 12428, -16550, 20759, -24737, 14049, -15195, 15563, -14895,  6470, -4734,  2139,  1390, -2950,  5702, -8942, 12649, -8398, 10682, -13184, 15955, -2395,  2909, -3738,  6026, },
	{ -1425,   578,  2813, -10398,  6017, -11428, 19216, -29556, 10570, -14184, 17913, -21258, 11766, -11934, 10627, -7299,   708,  3743, -9865, 17701, -13573, 18949, -24718, 30502, -17902, 20009, -21224, 21172, -9737,  7881, -4863,   563,  2543, -6041, 10174, -14861,  9988, -12675, 15382, -17983, 10162, -11110, 11721, -11820,  1385, -1082,    76, 30363, },
	{  1244, -4335, 10500, -20946,  9184, -14622, 21494, -29436,  9417, -11228, 12338, -12161,  5002, -2552, -1645,  7919, -8247, 13713, -20271, 27689, -17783, 21660, -25095, 27622, -14357, 13902, -12163,  8878, -1916, -1559,  6006, -11386,  8793, -12207, 15798, -19384, 11371, -12803, 13830, -14269,  6947, -6206,  4692, -2029,  -323,  1414, -4159, 27894, },
	{  2919, -7133, 14129, -24413,  9507, -13565, 17836, -21545,  5886, -5576,  3992,  -616, -2537,  6769, -12549, 19914, -14368, 19337, -24564, 29615, -16959, 18387, -18696, 17463, -7134,  4368,  -285, -5197,  6038, -10123, 14737, -19697, 12375, -14787, 16890, -18458,  9618, -9472,  8633, -6922,  2059,    39, -3064,  7440, -1759,  3169, -6312, 23025, },
	{  3382, -7488, 13430, -20952,  7289, -9073,  9904, -8825,  1160,  1006, -4647, 10083, -8770, 13542, -19268, 25705, -16212, 19397, -21987, 23469, -11628, 10363, -7633,  3165,  1621, -5843, 11060, -17163, 11971, -15540, 19070, -22294, 12446, -13252, 13369, -12592,  5354, -3752,  1379,  1887, -3096,  5873, -9444, 14136, -2583,  3861, -6429, 16555, },
	{  2816, -5808,  9348, -12551,  3471, -2774,   306,  4814, -3381,  6675, -11248, 17155, -12143, 16158, -20323, 24194, -13585, 14256, -13683, 11413, -3500,    29,  4848, -11186,  9464, -13938, 18837, -23895, 14380, -16497, 18047, -18747,  9151, -8208,  6401, -3602,  -150,  2698, -5877,  9715, -7124,  9767, -12854, 16534, -2646,  3465, -4927,  9511, },
	{  1663, -2982,  3578, -2217,  -707,  3428, -8213, 15647, -6548, 10012, -14243, 19034, -11996, 14252, -15870, 16328, -7510,  5648, -2258, -2937,  5066, -9696, 15303, -21721, 14330, -17848, 21132, -23840, 12788, -12955, 12198, -10303,  3539, -1182, -1970,  5937, -5351,  8104, -11180, 14511, -9009, 10804, -12597, 14352, -2007,  2220, -2467,  2950, },
	{   -31, -2028,  6995, -16347,  7904, -13523, 21116, -30585, 10360, -13172, 15683, -17332,  8702, -7528,  4686,   277, -3878,  9011, -15577, 23482, -16232, 21033, -25814, 30139, -16738, 17609, -17356, 15648, -6087,  3336,   523, -5533,  5834, -9417, 13424, -17718, 11061, -13202, 15148, -16733,  8881, -8992,  8524, -7182,   546,   196, -2236, 29495, },
	{  2209, -6002, 12825, -23561,  9696, -14612, 20381, -26414,  7929, -8708,  8467, -6633,  1289,  2168, -7331, 14392, -11702, 17109, -23221, 29691, -18010, 20771, -22727, 23419, -11178,  9523, -6521,  1992,  2088, -6001, 10695, -16055, 10947, -13973, 16933, -19617, 10888, -11564, 11671, -11021,  4691, -3221,   865,  2795, -1082,  2389, -5475, 25778, },
	{  3293, -7601, 14295, -23503,  8696, -11717, 14354, -15714,  3646, -2365,  -339,  4899, -5853, 10515, -16475, 23629, -15844, 20075, -24137, 27539, -14840, 14939, -13701, 10765, -2905,  -707,  5518, -11517,  9297, -13266, 17493, -21745, 12863, -14541, 15704, -16129,  7786, -6888,  5231, -2657,  -512,  3039, -6463, 11172, -2251,  3648, -6605, 20011, },
	{  3211, -6876, 11769, -17300,  5553, -6110,  5256, -2043, -1159,  3987, -8240, 14115, -10837, 15390, -20519, 25867, -15452, 17460, -18519, 18129, -7877,  5435, -1505, -4083,  5703, -10206, 15449, -21239, 13642, -16597, 19242, -21292, 11214, -11154, 10291, -8450,  2731,  -586, -2288,  5970, -5276,  8088, -11544, 15890, -2710,  3794, -5862, 13126, },
	{  2295, -4510,  6628, -7555,  1402,   375, -4136, 10640, -5154,  8654, -13215, 18759, -12513, 15766, -18770, 21024, -10952, 10345, -8305,  4451,   774, -4965, 10392, -17000, 12305, -16452, 20701, -24739, 14089, -15285, 15711, -15109,  6613, -4912,  2351,  1149, -2818,  5565, -8808, 12528, -8351, 10656, -13190, 16011, -2411,  2941, -3801,  6191, },
	{ -1500,   720,  2580, -10056,  5904, -11295, 19079, -29446, 10562, -14212, 17998, -21427, 11907, -12145, 10921, -7687,   949,  3458, -9545, 17364, -13408, 18804, -24615, 30465, -17930, 20098, -21388, 21424, -9910,  8106, -5137,   882,  2366, -5853,  9985, -14684,  9914, -12624, 15367, -18016, 10210, -11202, 11869, -12045,  1428, -1149,   206, 30390, },
	{  1188, -4234, 10353, -20765,  9140, -14595, 21514, -29542,  9478, -11341, 12521, -12432,  5189, -2797, -1341,  7563, -8049, 13509, -20078, 27532, -17738, 21667, -25173, 27793, -14498, 14107, -12438,  9224, -2123, -1323,  5749, -11120,  8664, -12092, 15709, -19336, 11376, -12844, 13918, -14414,  7053, -6352,  4886, -2281,  -282,  1359, -4078, 27987, },
	{  2892, -7093, 14093, -24416,  9533, -13639, 17989, -21817,  5994, -5736,  4215,  -908, -2356,  6558, -12318, 19681, -14264, 19262, -24541, 29670, -17039, 18535, -18925, 17783, -7344,  4627,  -590, -4855,  5856, -9939, 14565, -19553, 12327, -14773, 16922, -18547,  9697, -9591,  8796, -7134,  2191,  -120, -2879,  7228, -1729,  3138, -6284, 23170, },
	{  3384, -7507, 13495, -21110,  7368, -9215, 10134, -9171,  1282,   846, -4447,  9850, -8645, 13419, -19166, 25648, -16222, 19464, -22130, 23708, -11805, 10604, -7941,  3541,  1403, -5602, 10809, -16918, 11862, -15455, 19026, -22306, 12488, -13338, 13506, -12786,  5482, -3912,  1569,  1669, -2976,  5745, -9315, 14017, -2571,  3858, -6448, 16729, },
	{  2839, -5869,  9478, -12798,  3576, -2938,   543,  4493, -3280,  6557, -11123, 17038, -12101, 16149, -20368, 24317, -13699, 14436, -13941, 11759, -3719,   292,  4547, -10860,  9297, -13781, 18705, -23807, 14369, -16531, 18136, -18904,  9268, -8366,  6602, -3845,   -10,  2543, -5712,  9550, -7046,  9703, -12812, 16531, -2654,  3486, -4979,  9685, },
	{  1695, -3058,  3728, -2474,  -608,  3289, -8032, 15434, -6493,  9964, -14218, 19054, -12041, 14350, -16038, 16584, -7690,  5886, -2556, -2583,  4867, -9483, 15090, -21529, 14256, -17810, 21148, -23925, 12874, -13091, 12390, -10556,  3695, -1366, -1762,  5713, -5237,  7995, -11084, 14440, -8992, 10816, -12648, 14457, -2030,  2258, -2535,  3100, },
	{   -99, -1903,  6799, -16077,  7822, -13440, 21055, -30583, 10388, -13245, 15822, -17560,  8872, -7764,  4996,  -109, -3650,  8757, -15311, 23225, -16122, 20961, -25801, 30207, -16825, 17761, -17583, 15956, -6284,  3574,   248, -5229,  5675, -9260, 13279, -17601, 11024, -13197, 15185, -16825,  8961, -9115,  8700, -7429,   589,   133, -2128, 29556, },
	{  2166, -5931, 12731, -23470,  9687, -14637, 20471, -26610,  8017, -8850,  8677, -6925,  1479,  1931, -7053, 14086, -11545, 16964, -23108, 29638, -18028, 20851, -22886, 23673, -11359,  9763, -6821,  2348,  1886, -5783, 10472, -15842, 10855, -13905, 16903, -19637, 10931, -11646, 11801, -11206,  4814, -3379,  1062,  2554, -1045,  2344, -5420, 25899, },
	{  3281, -7591, 14311, -23588,  8751, -11829, 14554, -16035,  3765, -2531,  -120,  4627, -5694, 10342, -16303, 23478, -15795, 20071, -24198, 27690, -14973, 15140, -13979, 11126, -3126,  -448,  5230, -11212,  9146, -13126, 17380, -21675, 12859, -14577, 15791, -16274,  7893, -7032,  5414, -2880,  -382,  2891, -6300, 11001, -2230,  3630, -6601, 20173, },
	{  3225, -6918, 11871, -17511,  5649, -6269,  5499, -2389, -1044,  3842, -8072, 13934, -10749, 15321, -20489, 25902, -15516, 17587, -18727, 18431, -8082,  5695, -1821, -3719,  5503, -10000, 15250, -21065, 13579, -16570, 19265, -21378, 11295, -11280, 10465, -8676,  2870,  -749, -2104,  5770, -5173,  7988, -11456, 15827, -2708,  3804, -5899, 13303, },
	{  2324, -4581,  6774, -7817,  1508,   217, -3919, 10364, -5073,  8568, -13137, 18708, -12515, 15812, -18880, 21220, -11104, 10562, -8593,  4814,   557, -4718, 10126, -16731, 12180, -16350, 20640, -24737, 14127, -15372, 15856, -15320,  6754, -5089,  2562,   907, -2686,  5427, -8672, 12405, -8302, 10628, -13195, 16063, -2427,  2972, -3863,  6356, },
	{ -1575,   862,  2346, -9712,  5790, -11158, 18937, -29331, 10551, -14237, 18080, -21593, 12046, -12355, 11215, -8073,  1190,  3172, -9223, 17023, -13240, 18656, -24507, 30423, -17956, 20184, -21549, 21672, -10083,  8329, -5410,  1201,  2188, -5663,  9794, -14504,  9837, -12570, 15348, -18045, 10258, -11291, 12014, -12268,  1470, -1217,   337, 30414, },
	{  1131, -4133, 10203, -20579,  9093, -14565, 21529, -29644,  9539, -11452, 12702, -12702,  5376, -3043, -1037,  7204, -7850, 13301, -19881, 27371, -17690, 21670, -25247, 27958, -14637, 14310, -12710,  9568, -2329, -1086,  5491, -10852,  8533, -11975, 15618, -19285, 11378, -12884, 14004, -14556,  7158, -6497,  5079, -2534,  -240,  1303, -3996, 28079, },
	{  2864, -7052, 14054, -24414,  9557, -13711, 18140, -22085,  6102, -5896,  4437, -1200, -2175,  6346, -12084, 19444, -14157, 19184, -24514, 29720, -17117, 18680, -19150, 18101, -7552,  4885,  -895, -4513,  5673, -9754, 14390, -19406, 12276, -14756, 16950, -18632,  9774, -9707,  8958, -7344,  2322,  -278, -2693,  7015, -1699,  3105, -6255, 23315, },
	{  3386, -7525, 13558, -21264,  7447, -9356, 10363, -9517,  1403,   684, -4246,  9615, -8517, 13293, -19060, 25588, -16230, 19527, -22269, 23942, -11979, 10843, -8249,  3916,  1185, -5361, 10556, -16669, 11750, -15369, 18979, -22314, 12528, -13421, 13641, -12979,  5609, -4071,  1759,  1451, -2855,  5616, -9185, 13895, -2559,  3854, -6467, 16901, },
	{  2862, -5928,  9608, -13043,  3681, -3102,   781,  4171, -3178,  6438, -10995, 16918, -12057, 16137, -20409, 24436, -13811, 14614, -14198, 12104, -3938,   555,  4245, -10531,  9129, -13620, 18569, -23715, 14355, -16561, 18223, -19057,  9383, -8523,  6802, -4087,   130,  2386, -5546,  9382, -6967,  9636, -12769, 16526, -2661,  3507, -5031,  9860, },
	{  1727, -3135,  3877, -2731,  -508,  3148, -7849, 15218, -6436,  9914, -14191, 19071, -12085, 14446, -16204, 16837, -7869,  6123, -2853, -2228,  4665, -9268, 14875, -21332, 14180, -17770, 21159, -24006, 12957, -13225, 12581, -10806,  3851, -1551, -1554,  5489, -5121,  7883, -10985, 14366, -8974, 10825, -12696, 14560, -2052,  2296, -2601,  3251, },
	{  -168, -1777,  6600, -15804,  7739, -13355, 20990, -30577, 10414, -13316, 15959, -17785,  9041, -8000,  5306,  -495, -3422,  8501, -15042, 22964, -16010, 20885, -25782, 30270, -16909, 17910, -17806, 16263, -6480,  3812,   -28, -4924,  5515, -9100, 13132, -17480, 10985, -13189, 15219, -16913,  9040, -9237,  8876, -7676,   632,    69, -2019, 29615, },
	{  2123, -5857, 12634, -23375,  9676, -14659, 20557, -26802,  8104, -8991,  8886, -7216,  1670,  1694, -6774, 13777, -11386, 16816, -22992, 29579, -18042, 20927, -23041, 23923, -11538, 10001, -7120,  2704,  1684, -5564, 10247, -15626, 10760, -13835, 16869, -19654, 10972, -11727, 11929, -11388,  4936, -3536,  1258,  2313, -1008,  2299, -5364, 26019, },
	{  3268, -7580, 14324, -23669,  8805, -11940, 14751, -16353,  3884, -2698,   100,  4354, -5534, 10167, -16126, 23323, -15743, 20062, -24256, 27837, -15103, 15338, -14255, 11485, -3347,  -189,  4940, -10905,  8992, -12985, 17264, -21602, 12853, -14611, 15875, -16418,  7998, -7175,  5596, -3102,  -251,  2742, -6136, 10827, -2208,  3611, -6597, 20334, },
	{  3238, -6959, 11971, -17719,  5745, -6427,  5741, -2735,  -928,  3697, -7901, 13749, -10660, 15250, -20455, 25931, -15578, 17712, -18931, 18731, -8285,  5956, -2137, -3353,  5302, -9791, 15047, -20887, 13513, -16540, 19284, -21461, 11375, -11404, 10639, -8901,  3009,  -912, -1920,  5570, -5069,  7887, -11365, 15761, -2705,  3813, -5936, 13480, },
	{  2353, -4652,  6919, -8078,  1614,    59, -3701, 10085, -4990,  8480, -13057, 18654, -12514, 15855, -18987, 21413, -11255, 10777, -8880,  5177,   339, -4470,  9857, -16458, 12053, -16245, 20574, -24730, 14163, -15457, 15999, -15529,  6894, -5265,  2774,   665, -2553,  5288, -8535, 12279, -8251, 10598, -13197, 16114, -2442,  3003, -3924,  6522, },
	{ -1650,  1005,  2110, -9364,  5674, -11020, 18792, -29209, 10539, -14259, 18159, -21755, 12183, -12563, 11507, -8459,  1432,  2885, -8899, 16679, -13070, 18504, -24395, 30375, -17978, 20266, -21706, 21916, -10253,  8551, -5683,  1520,  2009, -5473,  9601, -14321,  9759, -12515, 15327, -18072, 10303, -11379, 12158, -12489,  1512, -1284,   470, 30437, },
	{  1073, -4030, 10051, -20388,  9044, -14533, 21541, -29740,  9597, -11562, 12881, -12969,  5563, -3288,  -731,  6843, -7649, 13091, -19681, 27204, -17639, 21670, -25317, 28119, -14773, 14510, -12981,  9911, -2536,  -849,  5231, -10581,  8400, -11855, 15524, -19230, 11379, -12921, 14087, -14696,  7262, -6641,  5272, -2786,  -199,  1247, -3912, 28170, },
	{  2836, -7009, 14012, -24408,  9579, -13780, 18287, -22350,  6209, -6056,  4659, -1493, -1993,  6132, -11848, 19203, -14047, 19102, -24483, 29765, -17192, 18822, -19373, 18416, -7759,  5143, -1200, -4168,  5488, -9566, 14213, -19255, 12223, -14737, 16975, -18714,  9849, -9823,  9118, -7554,  2453,  -437, -2506,  6800, -1669,  3072, -6224, 23458, },
	{  3387, -7541, 13618, -21416,  7525, -9496, 10592, -9862,  1525,   523, -4044,  9378, -8388, 13165, -18951, 25522, -16234, 19587, -22404, 24173, -12152, 11080, -8556,  4292,   966, -5118, 10300, -16416, 11636, -15279, 18928, -22318, 12565, -13503, 13774, -13169,  5736, -4229,  1949,  1231, -2733,  5486, -9053, 13771, -2547,  3849, -6484, 17074, },
	{  2885, -5987,  9736, -13288,  3786, -3267,  1020,  3847, -3075,  6317, -10865, 16794, -12010, 16122, -20447, 24551, -13921, 14790, -14452, 12447, -4156,   819,  3942, -10200,  8958, -13457, 18429, -23618, 14339, -16589, 18306, -19207,  9496, -8678,  7001, -4329,   271,  2230, -5379,  9212, -6887,  9568, -12723, 16517, -2668,  3528, -5082, 10035, },
	{  1759, -3211,  4027, -2988,  -408,  3006, -7664, 14999, -6378,  9862, -14161, 19084, -12127, 14539, -16367, 17088, -8047,  6359, -3151, -1872,  4463, -9050, 14656, -21132, 14101, -17727, 21168, -24083, 13038, -13356, 12770, -11056,  4006, -1735, -1345,  5263, -5005,  7770, -10885, 14289, -8954, 10833, -12743, 14660, -2075,  2334, -2668,  3404, },
	{  -236, -1649,  6400, -15526,  7654, -13266, 20922, -30564, 10438, -13385, 16092, -18008,  9208, -8235,  5616,  -882, -3192,  8243, -14770, 22698, -15895, 20805, -25759, 30327, -16991, 18056, -18027, 16567, -6676,  4050,  -304, -4618,  5353, -8939, 12982, -17356, 10944, -13179, 15250, -16999,  9117, -9357,  9050, -7921,   676,     5, -1909, 29672, },
	{  2078, -5782, 12535, -23274,  9662, -14679, 20640, -26990,  8190, -9130,  9094, -7507,  1862,  1456, -6493, 13465, -11224, 16664, -22871, 29515, -18054, 20999, -23191, 24168, -11716, 10238, -7418,  3061,  1481, -5343, 10020, -15407, 10663, -13762, 16833, -19667, 11011, -11805, 12055, -11569,  5058, -3693,  1455,  2071,  -971,  2253, -5306, 26138, },
	{  3254, -7567, 14335, -23745,  8857, -12049, 14946, -16670,  4003, -2864,   320,  4079, -5372,  9989, -15947, 23164, -15688, 20051, -24309, 27979, -15231, 15534, -14529, 11842, -3568,    71,  4649, -10595,  8837, -12840, 17145, -21525, 12844, -14643, 15956, -16558,  8102, -7316,  5777, -3325,  -119,  2592, -5970, 10651, -2186,  3592, -6590, 20495, },
	{  3251, -6998, 12070, -17926,  5840, -6585,  5984, -3082,  -812,  3550, -7729, 13562, -10569, 15175, -20418, 25957, -15637, 17834, -19133, 19028, -8488,  6215, -2453, -2987,  5100, -9580, 14842, -20705, 13445, -16507, 19300, -21540, 11453, -11526, 10810, -9125,  3147, -1076, -1734,  5368, -4964,  7784, -11273, 15691, -2702,  3821, -5972, 13657, },
	{  2382, -4722,  7064, -8339,  1720,   -99, -3481,  9803, -4907,  8391, -12974, 18597, -12512, 15895, -19090, 21602, -11404, 10990, -9166,  5539,   121, -4220,  9586, -16182, 11923, -16137, 20505, -24718, 14196, -15539, 16140, -15735,  7033, -5441,  2985,   422, -2420,  5148, -8396, 12151, -8199, 10566, -13197, 16161, -2458,  3033, -3985,  6689, },
	{ -1725,  1148,  1873, -9013,  5557, -10878, 18643, -29083, 10525, -14279, 18236, -21913, 12318, -12769, 11797, -8844,  1673,  2597, -8573, 16331, -12897, 18349, -24278, 30322, -17997, 20345, -21859, 22157, -10423,  8771, -5955,  1840,  1830, -5281,  9406, -14136,  9679, -12457, 15303, -18095, 10346, -11465, 12301, -12709,  1554, -1352,   603, 30459, },
	{  1014, -3926,  9897, -20194,  8994, -14498, 21549, -29832,  9655, -11670, 13058, -13235,  5749, -3533,  -425,  6480, -7446, 12879, -19476, 27032, -17585, 21665, -25382, 28276, -14906, 14708, -13249, 10253, -2742,  -611,  4970, -10309,  8266, -11733, 15426, -19172, 11377, -12956, 14169, -14834,  7365, -6785,  5464, -3039,  -157,  1190, -3827, 28259, },
	{  2806, -6964, 13967, -24397,  9600, -13847, 18432, -22611,  6315, -6214,  4882, -1786, -1810,  5916, -11609, 18958, -13934, 19017, -24447, 29804, -17263, 18960, -19592, 18728, -7965,  5400, -1505, -3823,  5302, -9377, 14033, -19100, 12169, -14715, 16998, -18793,  9923, -9936,  9277, -7763,  2584,  -596, -2318,  6583, -1638,  3039, -6192, 23600, },
	{  3387, -7556, 13676, -21564,  7602, -9635, 10819, -10205,  1647,   360, -3841,  9138, -8256, 13034, -18839, 25452, -16236, 19643, -22535, 24400, -12323, 11316, -8861,  4667,   747, -4874, 10042, -16161, 11519, -15186, 18874, -22318, 12601, -13582, 13904, -13357,  5861, -4387,  2139,  1011, -2611,  5355, -8919, 13644, -2534,  3843, -6500, 17246, },
	{  2907, -6045,  9863, -13531,  3890, -3431,  1259,  3521, -2972,  6195, -10733, 16667, -11962, 16104, -20481, 24662, -14028, 14963, -14705, 12788, -4374,  1083,  3637, -9866,  8786, -13292, 18286, -23517, 14320, -16614, 18386, -19355,  9608, -8832,  7199, -4571,   412,  2072, -5210,  9041, -6805,  9497, -12674, 16506, -2674,  3548, -5132, 10210, },
	{  1790, -3287,  4177, -3247,  -308,  2863, -7478, 14776, -6318,  9809, -14128, 19093, -12167, 14630, -16527, 17337, -8223,  6595, -3449, -1515,  4260, -8831, 14435, -20928, 14019, -17680, 21172, -24156, 13117, -13486, 12956, -11303,  4161, -1919, -1136,  5036, -4887,  7656, -10782, 14209, -8933, 10839, -12787, 14758, -2097,  2371, -2735,  3557, },
	{  -306, -1521,  6197, -15244,  7568, -13175, 20849, -30546, 10461, -13451, 16224, -18228,  9375, -8469,  5925, -1270, -2962,  7983, -14494, 22428, -15776, 20722, -25732, 30380, -17069, 18199, -18246, 16868, -6870,  4288,  -580, -4311,  5191, -8776, 12830, -17229, 10901, -13167, 15279, -17082,  9192, -9475,  9223, -8166,   719,   -59, -1798, 29727, },
	{  2033, -5706, 12433, -23169,  9648, -14696, 20720, -27174,  8275, -9269,  9301, -7796,  2053,  1217, -6210, 13149, -11060, 16509, -22745, 29445, -18063, 21068, -23338, 24410, -11891, 10474, -7715,  3417,  1277, -5121,  9791, -15184, 10565, -13687, 16793, -19677, 11048, -11882, 12179, -11748,  5179, -3850,  1652,  1828,  -934,  2206, -5247, 26255, },
	{  3240, -7552, 14343, -23818,  8908, -12156, 15139, -16984,  4121, -3030,   540,  3803, -5209,  9809, -15765, 23000, -15630, 20035, -24358, 28116, -15356, 15728, -14800, 12198, -3788,   331,  4357, -10283,  8679, -12693, 17023, -21444, 12834, -14672, 16034, -16696,  8205, -7457,  5958, -3547,    12,  2442, -5804, 10473, -2163,  3572, -6583, 20655, },
	{  3264, -7037, 12167, -18130,  5934, -6742,  6226, -3429,  -695,  3403, -7555, 13372, -10475, 15098, -20377, 25977, -15693, 17953, -19331, 19322, -8689,  6474, -2769, -2619,  4897, -9367, 14634, -20519, 13374, -16471, 19313, -21615, 11529, -11646, 10980, -9347,  3285, -1239, -1548,  5165, -4858,  7679, -11178, 15620, -2699,  3829, -6007, 13834, },
	{  2411, -4792,  7208, -8599,  1826,  -258, -3261,  9519, -4823,  8300, -12888, 18536, -12507, 15933, -19191, 21788, -11551, 11202, -9451,  5901,   -97, -3969,  9313, -15902, 11791, -16027, 20433, -24702, 14227, -15618, 16277, -15939,  7171, -5616,  3196,   179, -2286,  5007, -8255, 12020, -8145, 10533, -13194, 16205, -2472,  3063, -4046,  6856, },
	{ -1801,  1293,  1634, -8660,  5438, -10735, 18490, -28950, 10509, -14297, 18309, -22068, 12451, -12973, 12086, -9228,  1915,  2308, -8245, 15979, -12721, 18190, -24157, 30263, -18012, 20421, -22009, 22394, -10590,  8991, -6227,  2159,  1650, -5087,  9209, -13947,  9597, -12397, 15276, -18115, 10388, -11549, 12441, -12927,  1596, -1419,   738, 30478, },
	{   955, -3820,  9740, -19994,  8942, -14460, 21553, -29918,  9710, -11776, 13234, -13500,  5934, -3778,  -118,  6116, -7241, 12663, -19268, 26855, -17527, 21657, -25443, 28427, -15038, 14904, -13516, 10593, -2948,  -373,  4707, -10034,  8130, -11609, 15326, -19111, 11374, -12989, 14247, -14969,  7467, -6927,  5656, -3292,  -115,  1133, -3740, 28346, },
	{  2776, -6918, 13920, -24382,  9619, -13912, 18574, -22870,  6420, -6372,  5103, -2079, -1626,  5699, -11367, 18709, -13819, 18928, -24407, 29838, -17332, 19096, -19809, 19037, -8171,  5657, -1810, -3477,  5115, -9185, 13850, -18942, 12111, -14690, 17017, -18869,  9995, -10049,  9435, -7970,  2715,  -755, -2130,  6364, -1607,  3004, -6159, 23741, },
	{  3387, -7569, 13732, -21709,  7677, -9772, 11045, -10549,  1769,   198, -3636,  8896, -8123, 12901, -18722, 25378, -16235, 19696, -22663, 24623, -12492, 11551, -9166,  5042,   527, -4629,  9783, -15902, 11401, -15091, 18816, -22314, 12634, -13658, 14032, -13543,  5986, -4544,  2329,   791, -2487,  5223, -8783, 13514, -2520,  3837, -6515, 17418, },
	{  2929, -6102,  9989, -13773,  3994, -3595,  1499,  3194, -2868,  6071, -10598, 16537, -11910, 16083, -20512, 24769, -14133, 15134, -14955, 13128, -4591,  1347,  3332, -9530,  8611, -13123, 18140, -23411, 14299, -16636, 18463, -19498,  9719, -8985,  7396, -4812,   553,  1914, -5041,  8868, -6722,  9425, -12624, 16492, -2680,  3568, -5182, 10386, },
	{  1822, -3363,  4326, -3506,  -207,  2719, -7289, 14549, -6257,  9753, -14093, 19100, -12204, 14718, -16684, 17582, -8399,  6830, -3746, -1158,  4055, -8610, 14211, -20719, 13935, -17630, 21173, -24224, 13194, -13614, 13141, -11549,  4315, -2102,  -927,  4807, -4769,  7540, -10678, 14127, -8910, 10843, -12829, 14854, -2119,  2409, -2801,  3710, },
	{  -375, -1392,  5993, -14958,  7479, -13082, 20772, -30523, 10481, -13515, 16353, -18445,  9540, -8701,  6234, -1658, -2730,  7722, -14216, 22153, -15655, 20635, -25700, 30427, -17145, 18339, -18461, 17167, -7063,  4525,  -857, -4003,  5027, -8611, 12676, -17099, 10856, -13152, 15306, -17162,  9267, -9592,  9395, -8410,   762,  -123, -1686, 29781, },
	{  1987, -5628, 12328, -23059,  9631, -14710, 20796, -27353,  8358, -9406,  9507, -8085,  2244,   977, -5926, 12831, -10894, 16351, -22616, 29370, -18068, 21133, -23481, 24648, -12065, 10708, -8011,  3773,  1073, -4899,  9559, -14959, 10464, -13609, 16751, -19684, 11083, -11956, 12300, -11925,  5299, -4006,  1849,  1583,  -896,  2159, -5187, 26371, },
	{  3225, -7536, 14349, -23887,  8958, -12261, 15330, -17296,  4239, -3197,   761,  3525, -5045,  9627, -15579, 22832, -15569, 20016, -24402, 28248, -15479, 15919, -15070, 12552, -4008,   591,  4064, -9969,  8521, -12544, 16898, -21359, 12820, -14698, 16110, -16831,  8307, -7596,  6138, -3768,   144,  2290, -5635, 10292, -2140,  3551, -6575, 20814, },
	{  3276, -7075, 12263, -18331,  6027, -6899,  6467, -3777,  -578,  3255, -7379, 13179, -10380, 15018, -20332, 25993, -15747, 18068, -19526, 19613, -8889,  6733, -3085, -2251,  4692, -9153, 14423, -20330, 13301, -16433, 19322, -21687, 11603, -11765, 11148, -9568,  3423, -1402, -1362,  4961, -4751,  7573, -11081, 15545, -2695,  3836, -6041, 14011, },
	{  2439, -4862,  7351, -8859,  1932,  -418, -3038,  9232, -4737,  8207, -12800, 18472, -12500, 15968, -19288, 21970, -11696, 11412, -9735,  6262,  -316, -3718,  9038, -15619, 11656, -15913, 20356, -24682, 14255, -15695, 16412, -16141,  7307, -5790,  3406,   -64, -2151,  4865, -8112, 11887, -8090, 10497, -13189, 16247, -2486,  3092, -4106,  7024, },
	{ -1876,  1437,  1394, -8303,  5318, -10589, 18333, -28812, 10491, -14312, 18379, -22220, 12582, -13175, 12373, -9611,  2157,  2018, -7915, 15624, -12543, 18028, -24032, 30199, -18025, 20493, -22155, 22628, -10756,  9209, -6497,  2479,  1469, -4893,  9010, -13756,  9513, -12334, 15246, -18132, 10428, -11631, 12579, -13143,  1638, -1487,   873, 30495, },
	{   896, -3714,  9580, -19790,  8888, -14419, 21553, -29999,  9764, -11880, 13407, -13762,  6119, -4023,   190,  5749, -7035, 12445, -19056, 26673, -17467, 21645, -25500, 28574, -15166, 15097, -13780, 10932, -3154,  -135,  4444, -9757,  7993, -11483, 15223, -19046, 11368, -13019, 14323, -15101,  7567, -7069,  5847, -3545,   -74,  1075, -3653, 28432, },
	{  2745, -6870, 13869, -24362,  9637, -13974, 18712, -23125,  6525, -6530,  5325, -2373, -1442,  5480, -11123, 18457, -13701, 18836, -24362, 29867, -17398, 19228, -20022, 19343, -8374,  5913, -2116, -3129,  4926, -8992, 13665, -18781, 12052, -14663, 17034, -18941, 10066, -10159,  9591, -8177,  2846,  -914, -1941,  6144, -1576,  2969, -6124, 23881, },
	{  3386, -7582, 13785, -21851,  7752, -9908, 11269, -10891,  1890,    35, -3430,  8652, -7989, 12765, -18603, 25298, -16231, 19746, -22787, 24842, -12659, 11783, -9469,  5416,   307, -4382,  9521, -15640, 11280, -14993, 18755, -22306, 12665, -13733, 14158, -13727,  6109, -4701,  2519,   570, -2364,  5089, -8646, 13381, -2506,  3830, -6529, 17589, },
	{  2951, -6158, 10114, -14013,  4098, -3759,  1740,  2865, -2763,  5946, -10461, 16404, -11857, 16059, -20538, 24871, -14236, 15303, -15203, 13466, -4808,  1612,  3025, -9192,  8435, -12953, 17990, -23302, 14275, -16655, 18537, -19639,  9827, -9136,  7592, -5052,   694,  1756, -4870,  8693, -6638,  9352, -12571, 16474, -2685,  3587, -5231, 10562, },
	{  1853, -3438,  4476, -3765,  -106,  2575, -7098, 14320, -6195,  9696, -14055, 19102, -12240, 14804, -16840, 17826, -8574,  7064, -4043,  -799,  3850, -8387, 13984, -20507, 13848, -17577, 21170, -24289, 13269, -13739, 13323, -11793,  4468, -2286,  -717,  4578, -4649,  7422, -10571, 14042, -8886, 10844, -12868, 14947, -2140,  2445, -2868,  3865, },
	{  -445, -1262,  5786, -14668,  7389, -12985, 20692, -30494, 10500, -13577, 16479, -18660,  9704, -8933,  6542, -2046, -2498,  7458, -13934, 21874, -15531, 20544, -25663, 30468, -17217, 18475, -18673, 17463, -7256,  4761, -1133, -3693,  4862, -8444, 12519, -16965, 10810, -13135, 15329, -17239,  9339, -9708,  9566, -8653,   806,  -188, -1572, 29833, },
	{  1941, -5549, 12220, -22945,  9612, -14722, 20869, -27527,  8440, -9541,  9712, -8374,  2435,   737, -5640, 12510, -10726, 16190, -22482, 29290, -18070, 21195, -23620, 24882, -12237, 10940, -8306,  4128,   869, -4675,  9326, -14731, 10362, -13529, 16705, -19687, 11116, -12029, 12420, -12101,  5419, -4161,  2046,  1338,  -858,  2111, -5125, 26486, },
	{  3209, -7519, 14352, -23952,  9006, -12364, 15519, -17606,  4356, -3363,   983,  3247, -4879,  9443, -15390, 22660, -15506, 19994, -24443, 28376, -15599, 16108, -15337, 12905, -4228,   851,  3770, -9653,  8360, -12393, 16769, -21270, 12805, -14722, 16183, -16963,  8407, -7734,  6317, -3990,   275,  2139, -5466, 10109, -2117,  3529, -6565, 20972, },
	{  3287, -7111, 12356, -18530,  6120, -7055,  6708, -4125,  -460,  3105, -7201, 12983, -10282, 14935, -20283, 26005, -15797, 18181, -19719, 19901, -9088,  6990, -3402, -1881,  4487, -8936, 14209, -20136, 13225, -16391, 19328, -21754, 11675, -11881, 11314, -9788,  3560, -1566, -1175,  4756, -4643,  7465, -10982, 15467, -2691,  3842, -6074, 14188, },
	{  2467, -4931,  7494, -9119,  2039,  -578, -2815,  8943, -4650,  8112, -12710, 18404, -12490, 16000, -19382, 22149, -11840, 11621, -10017,  6623,  -535, -3465,  8761, -15334, 11519, -15796, 20276, -24658, 14281, -15769, 16544, -16339,  7443, -5964,  3617,  -308, -2016,  4721, -7968, 11752, -8033, 10460, -13182, 16286, -2500,  3121, -4166,  7193, },
	{ -1952,  1582,  1153, -7943,  5196, -10440, 18173, -28669, 10471, -14325, 18446, -22367, 12712, -13375, 12659, -9993,  2399,  1727, -7583, 15266, -12363, 17862, -23902, 30129, -18034, 20561, -22298, 22858, -10920,  9426, -6767,  2798,  1289, -4698,  8809, -13562,  9427, -12270, 15214, -18146, 10467, -11711, 12716, -13358,  1679, -1555,  1010, 30511, },
	{   836, -3606,  9418, -19582,  8832, -14376, 21550, -30075,  9817, -11983, 13579, -14022,  6303, -4268,   498,  5381, -6827, 12225, -18840, 26486, -17403, 21628, -25552, 28716, -15292, 15288, -14043, 11270, -3360,   104,  4180, -9478,  7854, -11355, 15118, -18977, 11361, -13047, 14397, -15232,  7666, -7209,  6037, -3797,   -31,  1017, -3563, 28516, },
	{  2713, -6821, 13816, -24338,  9652, -14035, 18848, -23377,  6628, -6686,  5546, -2667, -1257,  5260, -10877, 18200, -13580, 18740, -24313, 29891, -17461, 19357, -20232, 19646, -8577,  6168, -2421, -2780,  4737, -8797, 13477, -18615, 11990, -14633, 17047, -19010, 10134, -10268,  9745, -8382,  2976, -1074, -1751,  5923, -1544,  2934, -6089, 24019, },
	{  3385, -7592, 13837, -21989,  7825, -10043, 11492, -11232,  2012,  -129, -3223,  8406, -7852, 12626, -18479, 25214, -16224, 19792, -22907, 25057, -12823, 12014, -9771,  5790,    87, -4135,  9257, -15376, 11157, -14892, 18691, -22294, 12694, -13805, 14281, -13909,  6232, -4857,  2708,   349, -2239,  4955, -8507, 13246, -2492,  3822, -6541, 17760, },
	{  2972, -6214, 10238, -14251,  4201, -3923,  1981,  2534, -2657,  5820, -10322, 16267, -11802, 16033, -20562, 24969, -14337, 15469, -15449, 13802, -5025,  1876,  2718, -8852,  8258, -12779, 17837, -23188, 14248, -16671, 18608, -19776,  9935, -9286,  7787, -5292,   835,  1597, -4698,  8516, -6552,  9276, -12515, 16454, -2690,  3605, -5279, 10737, },
	{  1885, -3514,  4626, -4025,    -4,  2429, -6906, 14087, -6132,  9636, -14015, 19102, -12273, 14888, -16992, 18066, -8747,  7298, -4341,  -440,  3643, -8162, 13754, -20290, 13759, -17520, 21163, -24349, 13341, -13861, 13503, -12035,  4621, -2469,  -507,  4347, -4529,  7303, -10462, 13955, -8860, 10844, -12906, 15037, -2161,  2482, -2934,  4020, },
	{  -516, -1131,  5578, -14375,  7298, -12886, 20607, -30459, 10517, -13637, 16602, -18871,  9866, -9164,  6850, -2435, -2264,  7193, -13650, 21591, -15404, 20449, -25622, 30505, -17287, 18609, -18882, 17756, -7447,  4997, -1410, -3383,  4696, -8276, 12359, -16829, 10761, -13115, 15350, -17313,  9410, -9822,  9735, -8895,   849,  -253, -1457, 29883, },
	{  1894, -5468, 12110, -22826,  9592, -14731, 20938, -27698,  8521, -9675,  9916, -8661,  2627,   496, -5352, 12186, -10555, 16025, -22344, 29205, -18069, 21252, -23755, 25112, -12407, 11171, -8600,  4484,   664, -4450,  9091, -14500, 10257, -13446, 16657, -19686, 11147, -12099, 12538, -12274,  5537, -4317,  2243,  1093,  -820,  2063, -5062, 26599, },
	{  3192, -7500, 14352, -24012,  9052, -12466, 15705, -17914,  4473, -3529,  1205,  2967, -4713,  9257, -15198, 22483, -15439, 19967, -24479, 28499, -15716, 16294, -15602, 13255, -4447,  1112,  3475, -9334,  8198, -12239, 16638, -21177, 12788, -14743, 16253, -17092,  8506, -7871,  6495, -4210,   407,  1986, -5295,  9924, -2093,  3507, -6554, 21130, },
	{  3298, -7147, 12448, -18727,  6212, -7210,  6949, -4473,  -342,  2955, -7022, 12785, -10183, 14849, -20231, 26011, -15845, 18291, -19908, 20186, -9285,  7247, -3717, -1511,  4280, -8717, 13992, -19939, 13147, -16346, 19330, -21818, 11745, -11996, 11478, -10006,  3696, -1729,  -988,  4549, -4534,  7356, -10881, 15386, -2686,  3848, -6106, 14365, },
	{  2494, -5000,  7637, -9378,  2145,  -739, -2590,  8651, -4563,  8016, -12617, 18333, -12479, 16029, -19473, 22324, -11981, 11828, -10298,  6984,  -754, -3211,  8482, -15044, 11380, -15677, 20192, -24629, 14304, -15840, 16673, -16535,  7578, -6136,  3826,  -551, -1881,  4577, -7823, 11615, -7975, 10420, -13172, 16323, -2514,  3150, -4226,  7362, },
	{ -2028,  1728,   910, -7580,  5073, -10289, 18009, -28520, 10449, -14334, 18509, -22511, 12839, -13573, 12943, -10374,  2641,  1435, -7249, 14904, -12180, 17693, -23767, 30054, -18040, 20626, -22436, 23084, -11083,  9641, -7036,  3118,  1107, -4501,  8607, -13366,  9340, -12203, 15179, -18157, 10503, -11789, 12850, -13570,  1721, -1622,  1147, 30525, },
	{   775, -3496,  9254, -19369,  8774, -14330, 21542, -30146,  9867, -12083, 13748, -14281,  6486, -4512,   806,  5012, -6617, 12002, -18620, 26294, -17336, 21609, -25600, 28852, -15416, 15476, -14303, 11606, -3565,   343,  3914, -9196,  7713, -11224, 15009, -18905, 11351, -13073, 14469, -15359,  7765, -7348,  6227, -4050,    11,   959, -3473, 28599, },
	{  2681, -6770, 13760, -24309,  9666, -14092, 18981, -23625,  6731, -6842,  5766, -2961, -1071,  5038, -10628, 17940, -13457, 18641, -24259, 29910, -17521, 19483, -20438, 19947, -8779,  6423, -2727, -2431,  4546, -8600, 13286, -18447, 11926, -14600, 17058, -19076, 10201, -10375,  9898, -8586,  3106, -1233, -1560,  5700, -1512,  2897, -6051, 24157, },
	{  3382, -7602, 13886, -22123,  7897, -10176, 11714, -11572,  2134,  -293, -3015,  8158, -7714, 12485, -18352, 25126, -16214, 19835, -23023, 25267, -12986, 12243, -10072,  6164,  -134, -3886,  8991, -15107, 11032, -14788, 18623, -22278, 12720, -13875, 14402, -14088,  6354, -5013,  2898,   128, -2114,  4819, -8366, 13108, -2477,  3813, -6553, 17930, },
	{  2992, -6269, 10360, -14488,  4304, -4086,  2222,  2203, -2550,  5692, -10181, 16127, -11744, 16003, -20581, 25063, -14435, 15633, -15692, 14136, -5241,  2141,  2409, -8510,  8078, -12603, 17680, -23069, 14219, -16684, 18675, -19910, 10040, -9434,  7981, -5531,   976,  1437, -4525,  8337, -6465,  9199, -12458, 16431, -2694,  3623, -5327, 10914, },
	{  1916, -3589,  4776, -4285,    98,  2282, -6711, 13851, -6067,  9575, -13972, 19098, -12304, 14969, -17141, 18304, -8919,  7530, -4637,   -80,  3436, -7935, 13521, -20070, 13667, -17461, 21152, -24404, 13411, -13982, 13681, -12276,  4773, -2653,  -296,  4116, -4408,  7183, -10352, 13865, -8832, 10843, -12941, 15126, -2182,  2518, -3000,  4177, },
	{  -587,  -999,  5367, -14077,  7205, -12785, 20518, -30419, 10532, -13694, 16723, -19080, 10027, -9393,  7157, -2825, -2030,  6925, -13362, 21303, -15274, 20350, -25576, 30535, -17354, 18740, -19088, 18047, -7637,  5232, -1687, -3071,  4529, -8106, 12197, -16689, 10710, -13094, 15368, -17384,  9480, -9935,  9902, -9136,   892,  -318, -1341, 29931, },
	{  1846, -5385, 11997, -22702,  9570, -14738, 21003, -27864,  8601, -9808, 10118, -8948,  2818,   254, -5063, 11859, -10382, 15858, -22202, 29114, -18064, 21307, -23886, 25338, -12576, 11400, -8893,  4839,   459, -4223,  8854, -14267, 10151, -13361, 16605, -19682, 11176, -12168, 12654, -12445,  5655, -4471,  2440,   846,  -781,  2014, -4997, 26711, },
	{  3175, -7480, 14350, -24069,  9097, -12565, 15890, -18219,  4589, -3694,  1427,  2686, -4545,  9069, -15003, 22302, -15370, 19938, -24510, 28617, -15831, 16477, -15864, 13604, -4666,  1373,  3178, -9014,  8034, -12082, 16503, -21081, 12768, -14761, 16321, -17219,  8603, -8007,  6672, -4431,   539,  1833, -5123,  9737, -2069,  3484, -6542, 21287, },
	{  3308, -7181, 12538, -18921,  6303, -7364,  7190, -4821,  -223,  2804, -6841, 12584, -10081, 14760, -20175, 26014, -15891, 18397, -20093, 20468, -9481,  7502, -4033, -1140,  4073, -8497, 13772, -19738, 13067, -16298, 19329, -21879, 11813, -12108, 11641, -10222,  3832, -1892,  -800,  4341, -4424,  7246, -10778, 15302, -2680,  3853, -6137, 14541, },
	{  2522, -5068,  7778, -9636,  2252,  -900, -2365,  8357, -4474,  7918, -12521, 18258, -12465, 16056, -19560, 22495, -12121, 12033, -10578,  7343,  -974, -2956,  8201, -14752, 11239, -15554, 20105, -24595, 14324, -15909, 16800, -16729,  7711, -6308,  4036,  -795, -1744,  4432, -7675, 11475, -7915, 10379, -13161, 16356, -2527,  3178, -4285,  7531, },
	{ -2104,  1874,   666, -7215,  4949, -10136, 17841, -28365, 10425, -14342, 18570, -22652, 12964, -13770, 13225, -10754,  2883,  1143, -6913, 14540, -11995, 17521, -23628, 29974, -18043, 20688, -22571, 23306, -11243,  9855, -7304,  3437,   926, -4304,  8402, -13167,  9251, -12134, 15141, -18164, 10538, -11866, 12982, -13781,  1762, -1690,  1286, 30537, },
	{   714, -3386,  9087, -19152,  8715, -14281, 21531, -30212,  9917, -12182, 13916, -14538,  6669, -4756,  1115,  4640, -6406, 11776, -18397, 26097, -17266, 21585, -25643, 28984, -15537, 15662, -14561, 11940, -3770,   582,  3647, -8913,  7571, -11091, 14898, -18830, 11339, -13097, 14537, -15484,  7861, -7487,  6416, -4302,    53,   900, -3381, 28680, },
	{  2647, -6717, 13702, -24276,  9679, -14148, 19112, -23870,  6833, -6996,  5986, -3255,  -885,  4816, -10377, 17677, -13331, 18538, -24201, 29923, -17578, 19605, -20642, 20244, -8979,  6676, -3032, -2081,  4355, -8401, 13093, -18275, 11860, -14565, 17065, -19139, 10266, -10480, 10050, -8789,  3235, -1393, -1369,  5475, -1479,  2860, -6013, 24294, },
	{  3379, -7610, 13932, -22255,  7968, -10308, 11935, -11912,  2256,  -457, -2806,  7908, -7574, 12341, -18222, 25032, -16201, 19874, -23135, 25474, -13147, 12470, -10371,  6537,  -355, -3637,  8723, -14836, 10905, -14682, 18552, -22258, 12745, -13942, 14521, -14265,  6474, -5167,  3087,   -94, -1989,  4682, -8223, 12968, -2462,  3804, -6564, 18100, },
	{  3012, -6323, 10481, -14724,  4407, -4250,  2464,  1869, -2443,  5563, -10038, 15984, -11684, 15971, -20597, 25152, -14530, 15794, -15933, 14468, -5456,  2405,  2100, -8166,  7897, -12425, 17520, -22947, 14188, -16694, 18740, -20041, 10144, -9581,  8173, -5770,  1117,  1277, -4352,  8157, -6377,  9120, -12398, 16404, -2698,  3640, -5374, 11090, },
	{  1947, -3664,  4925, -4546,   201,  2134, -6515, 13611, -6001,  9512, -13926, 19091, -12333, 15047, -17288, 18539, -9090,  7762, -4934,   281,  3227, -7707, 13285, -19846, 13572, -17398, 21138, -24456, 13479, -14100, 13857, -12515,  4925, -2836,   -85,  3883, -4285,  7061, -10239, 13773, -8802, 10839, -12974, 15211, -2202,  2554, -3065,  4334, },
	{  -658,  -866,  5155, -13776,  7110, -12680, 20426, -30374, 10545, -13749, 16842, -19286, 10186, -9621,  7463, -3214, -1795,  6657, -13072, 21011, -15141, 20248, -25525, 30561, -17417, 18867, -19291, 18335, -7826,  5467, -1964, -2759,  4361, -7934, 12033, -16546, 10658, -13069, 15384, -17452,  9547, -10045, 10069, -9376,   935,  -384, -1224, 29978, },
	{  1797, -5302, 11881, -22574,  9546, -14742, 21065, -28025,  8679, -9940, 10319, -9233,  3009,    12, -4773, 11530, -10207, 15687, -22055, 29017, -18057, 21357, -24013, 25559, -12742, 11628, -9185,  5194,   253, -3996,  8616, -14030, 10043, -13274, 16550, -19674, 11203, -12234, 12768, -12615,  5773, -4626,  2637,   599,  -743,  1965, -4931, 26821, },
	{  3157, -7458, 14345, -24121,  9141, -12663, 16072, -18522,  4705, -3860,  1649,  2403, -4376,  8879, -14805, 22116, -15298, 19904, -24538, 28730, -15944, 16658, -16124, 13951, -4884,  1633,  2881, -8691,  7868, -11924, 16365, -20980, 12745, -14777, 16385, -17342,  8699, -8141,  6848, -4651,   671,  1680, -4950,  9548, -2044,  3460, -6529, 21443, },
	{  3318, -7214, 12626, -19112,  6393, -7517,  7429, -5170,  -105,  2651, -6658, 12380, -9977, 14669, -20116, 26011, -15933, 18501, -20276, 20747, -9676,  7757, -4349,  -768,  3864, -8275, 13550, -19533, 12984, -16248, 19325, -21935, 11878, -12219, 11802, -10437,  3968, -2055,  -612,  4133, -4314,  7133, -10672, 15216, -2674,  3857, -6168, 14718, },
	{  2549, -5135,  7919, -9894,  2358, -1061, -2138,  8060, -4384,  7819, -12423, 18180, -12449, 16080, -19644, 22663, -12259, 12236, -10857,  7702, -1193, -2700,  7919, -14457, 11096, -15428, 20014, -24558, 14343, -15975, 16924, -16919,  7843, -6478,  4245, -1040, -1608,  4286, -7527, 11333, -7854, 10335, -13146, 16386, -2539,  3205, -4343,  7701, },
	{ -2180,  2020,   421, -6847,  4824, -9981, 17669, -28205, 10399, -14347, 18627, -22789, 13088, -13964, 13506, -11133,  3125,   850, -6576, 14172, -11807, 17345, -23485, 29888, -18043, 20746, -22702, 23525, -11402, 10067, -7571,  3756,   744, -4105,  8196, -12966,  9160, -12062, 15101, -18168, 10571, -11940, 13113, -13990,  1803, -1758,  1426, 30548, },
	{   652, -3274,  8917, -18931,  8654, -14229, 21515, -30272,  9964, -12279, 14081, -14792,  6850, -5000,  1425,  4267, -6193, 11548, -18170, 25895, -17192, 21557, -25682, 29111, -15656, 15845, -14817, 12273, -3974,   821,  3380, -8628,  7428, -10956, 14784, -18751, 11326, -13118, 14604, -15607,  7957, -7624,  6604, -4555,    95,   841, -3289, 28760, },
	{  2613, -6663, 13640, -24238,  9689, -14201, 19238, -24111,  6933, -7150,  6205, -3550,  -698,  4592, -10124, 17409, -13203, 18432, -24139, 29931, -17631, 19724, -20841, 20538, -9178,  6929, -3337, -1729,  4162, -8201, 12897, -18099, 11792, -14527, 17069, -19198, 10330, -10584, 10200, -8991,  3364, -1552, -1177,  5249, -1447,  2823, -5973, 24429, },
	{  3376, -7617, 13976, -22383,  8038, -10438, 12154, -12250,  2378,  -622, -2596,  7656, -7433, 12195, -18088, 24934, -16185, 19910, -23243, 25676, -13306, 12696, -10669,  6909,  -576, -3386,  8453, -14562, 10775, -14573, 18477, -22234, 12767, -14007, 14637, -14440,  6594, -5321,  3275,  -317, -1863,  4544, -8078, 12825, -2446,  3794, -6573, 18269, },
	{  3032, -6376, 10600, -14958,  4509, -4414,  2706,  1535, -2334,  5432, -9892, 15838, -11622, 15936, -20610, 25238, -14624, 15953, -16172, 14799, -5671,  2670,  1789, -7820,  7714, -12244, 17357, -22820, 14154, -16701, 18801, -20168, 10246, -9727,  8365, -6008,  1258,  1117, -4177,  7975, -6288,  9039, -12335, 16375, -2702,  3657, -5421, 11267, },
	{  1978, -3739,  5075, -4807,   304,  1985, -6317, 13369, -5934,  9447, -13878, 19080, -12360, 15124, -17432, 18771, -9259,  7993, -5230,   642,  3018, -7476, 13047, -19618, 13475, -17332, 21119, -24503, 13544, -14216, 14031, -12751,  5076, -3019,   126,  3650, -4162,  6938, -10125, 13678, -8771, 10833, -13005, 15294, -2222,  2590, -3131,  4491, },
	{  -729,  -733,  4940, -13471,  7013, -12573, 20329, -30322, 10556, -13802, 16957, -19488, 10344, -9848,  7769, -3604, -1560,  6386, -12779, 20715, -15005, 20141, -25470, 30581, -17478, 18991, -19491, 18620, -8014,  5701, -2241, -2446,  4192, -7761, 11867, -16400, 10603, -13043, 15397, -17517,  9614, -10155, 10234, -9614,   978,  -449, -1106, 30023, },
	{  1748, -5216, 11762, -22440,  9520, -14743, 21123, -28182,  8756, -10070, 10518, -9518,  3200,  -231, -4481, 11198, -10030, 15513, -21905, 28916, -18046, 21404, -24136, 25777, -12906, 11854, -9476,  5548,    48, -3768,  8375, -13791,  9932, -13183, 16493, -19663, 11229, -12298, 12879, -12783,  5889, -4779,  2834,   351,  -704,  1915, -4864, 26930, },
	{  3138, -7434, 14337, -24169,  9183, -12759, 16252, -18823,  4820, -4025,  1872,  2120, -4206,  8687, -14604, 21926, -15222, 19867, -24561, 28838, -16054, 16836, -16382, 14296, -5102,  1894,  2583, -8367,  7701, -11763, 16224, -20876, 12721, -14791, 16447, -17463,  8794, -8275,  7023, -4870,   804,  1525, -4776,  9357, -2019,  3436, -6514, 21598, },
	{  3327, -7246, 12712, -19301,  6483, -7670,  7669, -5519,    15,  2498, -6474, 12173, -9872, 14575, -20052, 26004, -15973, 18602, -20455, 21023, -9869,  8011, -4664,  -395,  3654, -8051, 13325, -19324, 12899, -16194, 19317, -21988, 11942, -12327, 11961, -10651,  4103, -2218,  -423,  3923, -4202,  7020, -10565, 15127, -2668,  3861, -6197, 14894, },
	{  2576, -5202,  8059, -10151,  2464, -1223, -1910,  7761, -4293,  7717, -12323, 18099, -12430, 16101, -19725, 22827, -12395, 12438, -11134,  8061, -1413, -2444,  7634, -14159, 10950, -15300, 19919, -24515, 14358, -16038, 17045, -17107,  7974, -6648,  4453, -1284, -1471,  4139, -7376, 11189, -7791, 10290, -13130, 16414, -2552,  3232, -4401,  7871, },
	{ -2256,  2167,   175, -6476,  4697, -9823, 17494, -28039, 10371, -14349, 18682, -22922, 13209, -14156, 13784, -11510,  3366,   556, -6236, 13801, -11617, 17166, -23338, 29797, -18040, 20800, -22829, 23739, -11559, 10278, -7837,  4075,   561, -3906,  7988, -12762,  9068, -11989, 15057, -18169, 10602, -12012, 13241, -14197,  1843, -1826,  1566, 30556, },
	{   589, -3161,  8745, -18705,  8591, -14175, 21496, -30328, 10010, -12374, 14244, -15045,  7031, -5243,  1735,  3893, -5979, 11317, -17940, 25688, -17115, 21526, -25716, 29233, -15772, 16026, -15070, 12603, -4178,  1061,  3111, -8342,  7283, -10819, 14667, -18668, 11310, -13137, 14668, -15727,  8051, -7760,  6791, -4807,   138,   781, -3194, 28837, },
	{  2579, -6608, 13576, -24195,  9698, -14252, 19362, -24348,  7033, -7304,  6424, -3844,  -511,  4366, -9868, 17138, -13072, 18322, -24072, 29933, -17682, 19840, -21038, 20829, -9375,  7181, -3643, -1377,  3969, -7999, 12699, -17920, 11722, -14487, 17071, -19254, 10392, -10686, 10348, -9191,  3493, -1712,  -985,  5021, -1413,  2784, -5932, 24563, },
	{  3371, -7622, 14018, -22507,  8107, -10568, 12371, -12587,  2499,  -787, -2385,  7402, -7290, 12047, -17951, 24832, -16166, 19943, -23347, 25875, -13463, 12919, -10966,  7281,  -798, -3135,  8182, -14285, 10644, -14461, 18399, -22206, 12786, -14069, 14751, -14613,  6713, -5475,  3464,  -539, -1736,  4405, -7932, 12680, -2430,  3784, -6582, 18438, },
	{  3051, -6428, 10719, -15190,  4611, -4577,  2948,  1199, -2226,  5300, -9745, 15689, -11557, 15898, -20619, 25319, -14714, 16109, -16408, 15127, -5885,  2934,  1478, -7472,  7530, -12061, 17191, -22689, 14117, -16705, 18858, -20292, 10347, -9870,  8555, -6245,  1399,   956, -4001,  7791, -6197,  8956, -12271, 16343, -2705,  3673, -5466, 11443, },
	{  2009, -3814,  5224, -5068,   407,  1836, -6117, 13123, -5865,  9380, -13827, 19066, -12385, 15197, -17574, 19000, -9427,  8222, -5526,  1004,  2808, -7245, 12806, -19386, 13375, -17263, 21097, -24546, 13608, -14330, 14202, -12986,  5226, -3201,   338,  3415, -4038,  6813, -10008, 13580, -8739, 10825, -13033, 15375, -2242,  2625, -3196,  4650, },
	{  -801,  -598,  4724, -13163,  6915, -12464, 20229, -30266, 10566, -13852, 17070, -19688, 10501, -10074,  8074, -3993, -1323,  6114, -12483, 20415, -14866, 20031, -25411, 30596, -17536, 19112, -19687, 18902, -8201,  5934, -2518, -2132,  4022, -7586, 11698, -16251, 10546, -13014, 15407, -17579,  9678, -10263, 10397, -9852,  1022,  -515,  -986, 30066, },
	{  1698, -5130, 11640, -22303,  9493, -14742, 21178, -28334,  8832, -10198, 10716, -9801,  3391,  -474, -4187, 10863, -9851, 15336, -21750, 28809, -18032, 21447, -24255, 25990, -13068, 12078, -9765,  5902,  -159, -3539,  8133, -13549,  9820, -13091, 16432, -19649, 11252, -12361, 12989, -12948,  6004, -4932,  3030,   103,  -664,  1864, -4796, 27038, },
	{  3118, -7409, 14327, -24213,  9224, -12852, 16429, -19121,  4935, -4190,  2095,  1836, -4034,  8493, -14400, 21732, -15144, 19827, -24580, 28941, -16161, 17011, -16637, 14639, -5319,  2155,  2284, -8040,  7532, -11599, 16080, -20768, 12694, -14802, 16506, -17580,  8887, -8407,  7198, -5089,   936,  1371, -4600,  9163, -1993,  3411, -6498, 21752, },
	{  3335, -7276, 12796, -19487,  6571, -7822,  7907, -5868,   134,  2344, -6288, 11964, -9764, 14478, -19985, 25992, -16010, 18699, -20631, 21295, -10061,  8263, -4979,   -22,  3444, -7825, 13097, -19112, 12811, -16138, 19306, -22036, 12004, -12434, 12118, -10863,  4237, -2381,  -235,  3713, -4089,  6905, -10456, 15034, -2661,  3864, -6226, 15070, },
	{  2603, -5269,  8199, -10408,  2571, -1385, -1680,  7460, -4201,  7614, -12220, 18014, -12410, 16119, -19803, 22988, -12529, 12638, -11409,  8418, -1633, -2186,  7348, -13858, 10803, -15169, 19820, -24469, 14371, -16098, 17163, -17292,  8103, -6817,  4661, -1528, -1333,  3990, -7224, 11043, -7727, 10243, -13111, 16439, -2563,  3259, -4459,  8042, },
	{ -2333,  2315,   -73, -6102,  4568, -9663, 17315, -27868, 10342, -14349, 18733, -23051, 13328, -14346, 14061, -11887,  3608,   262, -5895, 13427, -11424, 16984, -23186, 29700, -18033, 20850, -22953, 23950, -11714, 10487, -8101,  4393,   379, -3706,  7779, -12555,  8973, -11913, 15011, -18167, 10631, -12083, 13367, -14402,  1884, -1894,  1708, 30563, },
	{   526, -3046,  8571, -18475,  8526, -14118, 21473, -30377, 10054, -12466, 14405, -15295,  7211, -5486,  2045,  3517, -5764, 11084, -17706, 25476, -17036, 21490, -25746, 29350, -15885, 16204, -15322, 12932, -4382,  1300,  2842, -8053,  7136, -10680, 14548, -18583, 11292, -13154, 14729, -15844,  8144, -7895,  6977, -5059,   181,   721, -3099, 28914, },
	{  2543, -6551, 13509, -24148,  9706, -14300, 19483, -24582,  7132, -7456,  6642, -4139,  -323,  4139, -9610, 16864, -12938, 18209, -24001, 29930, -17730, 19953, -21231, 21116, -9571,  7432, -3947, -1025,  3774, -7795, 12498, -17738, 11649, -14444, 17069, -19307, 10452, -10786, 10495, -9390,  3621, -1871,  -792,  4792, -1380,  2745, -5890, 24696, },
	{  3366, -7626, 14058, -22627,  8174, -10695, 12587, -12922,  2621,  -952, -2173,  7146, -7145, 11896, -17810, 24725, -16145, 19972, -23448, 26068, -13617, 13141, -11261,  7652, -1019, -2882,  7908, -14006, 10511, -14346, 18318, -22175, 12804, -14129, 14862, -14783,  6831, -5627,  3652,  -762, -1609,  4265, -7784, 12531, -2413,  3773, -6589, 18606, },
	{  3070, -6479, 10835, -15420,  4712, -4740,  3191,   862, -2116,  5167, -9595, 15536, -11491, 15857, -20624, 25395, -14803, 16263, -16641, 15453, -6098,  3199,  1167, -7122,  7344, -11876, 17021, -22554, 14078, -16706, 18913, -20412, 10446, -10013,  8743, -6481,  1540,   795, -3824,  7606, -6105,  8872, -12204, 16308, -2707,  3688, -5511, 11620, },
	{  2040, -3889,  5373, -5330,   510,  1685, -5916, 12874, -5795,  9312, -13774, 19048, -12408, 15268, -17712, 19226, -9594,  8451, -5821,  1366,  2597, -7011, 12563, -19150, 13273, -17191, 21072, -24585, 13668, -14441, 14371, -13219,  5376, -3383,   549,  3180, -3913,  6687, -9890, 13480, -8705, 10816, -13060, 15453, -2261,  2660, -3261,  4809, },
	{  -874,  -463,  4505, -12851,  6815, -12352, 20124, -30203, 10573, -13900, 17180, -19885, 10656, -10298,  8378, -4383, -1086,  5841, -12185, 20110, -14724, 19918, -25346, 30605, -17590, 19230, -19881, 19181, -8387,  6167, -2795, -1817,  3851, -7410, 11527, -16098, 10488, -12983, 15414, -17638,  9741, -10369, 10559, -10089,  1065,  -581,  -866, 30108, },
	{  1647, -5041, 11516, -22160,  9463, -14738, 21229, -28482,  8906, -10325, 10913, -10084,  3581,  -717, -3893, 10526, -9670, 15156, -21591, 28697, -18015, 21486, -24369, 26198, -13228, 12300, -10053,  6255,  -365, -3309,  7888, -13304,  9706, -12996, 16369, -19631, 11274, -12421, 13096, -13112,  6119, -5085,  3227,  -146,  -625,  1813, -4726, 27144, },
	{  3098, -7382, 14314, -24253,  9263, -12944, 16604, -19416,  5049, -4355,  2318,  1550, -3862,  8297, -14193, 21534, -15064, 19782, -24594, 29039, -16265, 17184, -16889, 14980, -5535,  2416,  1984, -7712,  7362, -11434, 15933, -20656, 12665, -14810, 16562, -17695,  8979, -8537,  7371, -5308,  1068,  1216, -4423,  8968, -1967,  3385, -6481, 21905, },
	{  3343, -7306, 12878, -19670,  6659, -7973,  8145, -6217,   254,  2190, -6101, 11752, -9654, 14378, -19915, 25976, -16045, 18793, -20804, 21564, -10251,  8515, -5293,   352,  3232, -7598, 12867, -18896, 12721, -16078, 19291, -22081, 12064, -12538, 12272, -11073,  4371, -2543,   -46,  3501, -3975,  6789, -10344, 14939, -2654,  3866, -6253, 15246, },
	{  2629, -5335,  8337, -10663,  2677, -1548, -1450,  7156, -4108,  7510, -12115, 17926, -12387, 16134, -19877, 23144, -12661, 12836, -11683,  8774, -1853, -1928,  7059, -13554, 10653, -15034, 19718, -24418, 14382, -16156, 17278, -17474,  8232, -6985,  4869, -1773, -1195,  3841, -7071, 10895, -7662, 10194, -13089, 16461, -2575,  3285, -4516,  8213, },
	{ -2409,  2462,  -322, -5726,  4439, -9500, 17132, -27692, 10310, -14346, 18780, -23176, 13445, -14534, 14336, -12261,  3849,   -33, -5553, 13050, -11229, 16798, -23029, 29598, -18023, 20897, -23072, 24157, -11868, 10695, -8365,  4711,   196, -3504,  7568, -12346,  8877, -11835, 14963, -18161, 10658, -12151, 13491, -14604,  1924, -1961,  1850, 30568, },
	{   462, -2931,  8394, -18240,  8459, -14058, 21446, -30422, 10097, -12557, 14564, -15544,  7390, -5729,  2355,  3140, -5547, 10849, -17468, 25259, -16953, 21451, -25771, 29462, -15996, 16380, -15571, 13260, -4585,  1540,  2572, -7762,  6988, -10539, 14425, -18494, 11273, -13168, 14788, -15959,  8236, -8029,  7163, -5310,   223,   661, -3002, 28988, },
	{  2506, -6492, 13439, -24097,  9711, -14346, 19601, -24812,  7230, -7607,  6860, -4433,  -135,  3911, -9349, 16586, -12802, 18092, -23926, 29922, -17774, 20062, -21421, 21400, -9766,  7683, -4252,  -672,  3579, -7590, 12294, -17552, 11575, -14398, 17065, -19356, 10510, -10884, 10640, -9587,  3749, -2031,  -598,  4562, -1346,  2706, -5846, 24828, },
	{  3360, -7628, 14095, -22744,  8240, -10821, 12801, -13257,  2742, -1118, -1960,  6888, -6999, 11742, -17666, 24613, -16120, 19997, -23544, 26258, -13770, 13360, -11554,  8022, -1241, -2629,  7633, -13723, 10375, -14229, 18233, -22139, 12820, -14187, 14971, -14951,  6947, -5779,  3840,  -984, -1482,  4125, -7634, 12381, -2395,  3761, -6595, 18773, },
	{  3089, -6529, 10951, -15649,  4813, -4902,  3433,   524, -2006,  5033, -9443, 15380, -11422, 15812, -20625, 25467, -14889, 16414, -16872, 15777, -6310,  3463,   854, -6770,  7156, -11688, 16848, -22415, 14036, -16705, 18964, -20529, 10543, -10153,  8931, -6716,  1681,   634, -3647,  7419, -6012,  8786, -12135, 16270, -2709,  3703, -5555, 11797, },
	{  2071, -3963,  5522, -5591,   614,  1534, -5712, 12623, -5724,  9241, -13718, 19027, -12428, 15336, -17848, 19449, -9760,  8678, -6116,  1728,  2385, -6776, 12317, -18911, 13168, -17116, 21042, -24619, 13727, -14549, 14538, -13449,  5524, -3565,   761,  2944, -3787,  6560, -9769, 13377, -8669, 10804, -13084, 15529, -2280,  2694, -3325,  4969, },
	{  -946,  -326,  4285, -12535,  6714, -12237, 20016, -30135, 10579, -13946, 17287, -20078, 10809, -10521,  8681, -4773,  -849,  5565, -11884, 19802, -14580, 19800, -25277, 30609, -17642, 19345, -20071, 19457, -8571,  6398, -3072, -1501,  3679, -7232, 11354, -15943, 10427, -12949, 15419, -17694,  9803, -10473, 10719, -10324,  1108,  -647,  -744, 30148, },
	{  1595, -4952, 11389, -22013,  9432, -14731, 21277, -28624,  8979, -10451, 11108, -10365,  3772,  -961, -3597, 10186, -9487, 14974, -21428, 28580, -17994, 21522, -24480, 26403, -13385, 12520, -10339,  6607,  -571, -3078,  7643, -13056,  9590, -12898, 16302, -19609, 11293, -12479, 13201, -13273,  6232, -5237,  3423,  -396,  -585,  1762, -4655, 27249, },
	{  3077, -7354, 14298, -24288,  9301, -13034, 16777, -19709,  5163, -4519,  2541,  1264, -3688,  8099, -13983, 21331, -14980, 19735, -24605, 29133, -16366, 17354, -17139, 15319, -5751,  2677,  1683, -7382,  7190, -11266, 15783, -20540, 12634, -14815, 16615, -17807,  9069, -8666,  7543, -5525,  1200,  1060, -4245,  8770, -1941,  3358, -6462, 22058, },
	{  3350, -7334, 12959, -19851,  6746, -8123,  8382, -6565,   374,  2034, -5911, 11538, -9543, 14275, -19840, 25955, -16076, 18884, -20973, 21829, -10440,  8766, -5607,   726,  3020, -7369, 12634, -18677, 12629, -16016, 19273, -22122, 12122, -12640, 12425, -11281,  4505, -2706,   144,  3288, -3861,  6671, -10230, 14841, -2646,  3867, -6280, 15421, },
	{  2655, -5400,  8475, -10918,  2784, -1711, -1219,  6851, -4014,  7404, -12007, 17834, -12362, 16147, -19948, 23297, -12791, 13032, -11955,  9130, -2073, -1669,  6770, -13247, 10501, -14897, 19612, -24362, 14390, -16211, 17390, -17654,  8359, -7152,  5075, -2017, -1057,  3692, -6916, 10744, -7595, 10143, -13065, 16480, -2586,  3311, -4572,  8385, },
	{ -2485,  2610,  -571, -5347,  4308, -9336, 16945, -27509, 10277, -14341, 18825, -23297, 13560, -14720, 14608, -12635,  4090,  -329, -5208, 12670, -11032, 16609, -22869, 29490, -18010, 20940, -23187, 24359, -12019, 10901, -8628,  5028,    13, -3302,  7355, -12134,  8780, -11754, 14911, -18153, 10684, -12217, 13613, -14805,  1965, -2029,  1994, 30571, },
	{   398, -2814,  8215, -18002,  8391, -13996, 21414, -30461, 10137, -12646, 14721, -15790,  7569, -5971,  2666,  2762, -5328, 10611, -17227, 25038, -16867, 21408, -25791, 29569, -16104, 16553, -15817, 13585, -4787,  1780,  2301, -7470,  6839, -10396, 14300, -18401, 11251, -13180, 14844, -16071,  8327, -8161,  7348, -5561,   266,   600, -2904, 29061, },
	{  2469, -6432, 13366, -24040,  9715, -14390, 19715, -25039,  7326, -7757,  7077, -4727,    54,  3682, -9087, 16304, -12663, 17972, -23846, 29909, -17816, 20168, -21607, 21681, -9959,  7932, -4556,  -318,  3383, -7383, 12089, -17363, 11498, -14350, 17057, -19402, 10566, -10981, 10783, -9784,  3876, -2190,  -404,  4330, -1312,  2666, -5801, 24959, },
	{  3354, -7630, 14130, -22858,  8305, -10946, 13014, -13589,  2863, -1284, -1747,  6629, -6851, 11586, -17518, 24496, -16093, 20019, -23636, 26443, -13920, 13578, -11846,  8391, -1463, -2375,  7356, -13437, 10238, -14109, 18145, -22099, 12833, -14242, 15077, -15116,  7063, -5930,  4027, -1207, -1354,  3983, -7483, 12228, -2378,  3748, -6600, 18940, },
	{  3107, -6579, 11065, -15875,  4914, -5065,  3676,   185, -1895,  4897, -9289, 15222, -11351, 15766, -20623, 25535, -14972, 16562, -17101, 16098, -6522,  3727,   541, -6417,  6967, -11497, 16671, -22271, 13992, -16700, 19012, -20642, 10638, -10292,  9117, -6951,  1822,   472, -3468,  7231, -5918,  8698, -12063, 16229, -2711,  3717, -5599, 11974, },
	{  2101, -4037,  5670, -5853,   718,  1382, -5507, 12368, -5652,  9169, -13659, 19002, -12447, 15402, -17980, 19670, -9923,  8905, -6410,  2091,  2172, -6539, 12068, -18668, 13061, -17037, 21009, -24650, 13783, -14656, 14702, -13678,  5672, -3746,   973,  2706, -3660,  6432, -9647, 13272, -8632, 10791, -13105, 15601, -2299,  2728, -3390,  5130, },
	{ -1019,  -189,  4064, -12216,  6611, -12120, 19904, -30061, 10583, -13989, 17391, -20269, 10961, -10743,  8984, -5162,  -610,  5289, -11580, 19489, -14432, 19679, -25204, 30608, -17690, 19456, -20257, 19729, -8754,  6629, -3348, -1185,  3506, -7053, 11178, -15785, 10365, -12913, 15421, -17747,  9863, -10576, 10878, -10558,  1151,  -714,  -621, 30186, },
	{  1543, -4861, 11260, -21862,  9399, -14722, 21320, -28762,  9050, -10575, 11302, -10645,  3962, -1205, -3299,  9843, -9301, 14788, -21262, 28457, -17971, 21553, -24586, 26603, -13541, 12738, -10624,  6959,  -778, -2846,  7395, -12806,  9472, -12799, 16233, -19584, 11311, -12534, 13304, -13432,  6345, -5388,  3619,  -646,  -546,  1710, -4582, 27352, },
	{  3054, -7324, 14280, -24319,  9337, -13121, 16947, -20000,  5276, -4683,  2764,   977, -3514,  7899, -13770, 21124, -14894, 19683, -24610, 29221, -16465, 17521, -17387, 15655, -5966,  2938,  1382, -7050,  7017, -11096, 15630, -20421, 12600, -14818, 16665, -17916,  9158, -8794,  7714, -5742,  1333,   904, -4067,  8571, -1914,  3331, -6443, 22209, },
	{  3357, -7361, 13037, -20028,  6832, -8272,  8619, -6914,   494,  1878, -5721, 11321, -9429, 14170, -19762, 25929, -16105, 18972, -21139, 22091, -10628,  9015, -5921,  1100,  2807, -7138, 12399, -18453, 12534, -15950, 19251, -22160, 12178, -12740, 12576, -11488,  4637, -2868,   333,  3075, -3745,  6552, -10115, 14740, -2638,  3868, -6306, 15596, },
	{  2681, -5465,  8612, -11172,  2890, -1874,  -987,  6543, -3920,  7296, -11897, 17739, -12334, 16156, -20015, 23446, -12919, 13226, -12226,  9484, -2293, -1410,  6478, -12937, 10347, -14757, 19503, -24303, 14395, -16262, 17499, -17830,  8485, -7317,  5281, -2261,  -918,  3541, -6760, 10591, -7526, 10091, -13039, 16497, -2596,  3336, -4628,  8557, },
};

int nextstate_441_80[441] = {
	0x0010e100, 0x0020e000, 0x0030df00, 0x0040de00, 0x0050dd00, 0x0060dc01, 0x0070db00, 0x0080da00, 
	0x0090d900, 0x00a0d800, 0x00b0d700, 0x00c0d601, 0x00d0d500, 0x00e0d400, 0x00f0d300, 0x0100d200, 
	0x0110d101, 0x0120d000, 0x0130cf00, 0x0140ce00, 0x0150cd00, 0x0160cc00, 0x0170cb01, 0x0180ca00, 
	0x0190c900, 0x01a0c800, 0x01b0c700, 0x01c0c601, 0x01d0c500, 0x01e0c400, 0x01f0c300, 0x0200c200, 
	0x0210c100, 0x0220c001, 0x0230bf00, 0x0240be00, 0x0250bd00, 0x0260bc00, 0x0270bb01, 0x0280ba00, 
	0x0290b900, 0x02a0b800, 0x02b0b700, 0x02c0b600, 0x02d0b501, 0x02e0b400, 0x02f0b300, 0x0300b200, 
	0x0310b100, 0x0320b001, 0x0330af00, 0x0340ae00, 0x0350ad00, 0x0360ac00, 0x0370ab00, 0x0380aa01, 
	0x0390a900, 0x03a0a800, 0x03b0a700, 0x03c0a600, 0x03d0a501, 0x03e0a400, 0x03f0a300, 0x0400a200, 
	0x0410a100, 0x0420a000, 0x04309f01, 0x04409e00, 0x04509d00, 0x04609c00, 0x04709b00, 0x04809a01, 
	0x04909900, 0x04a09800, 0x04b09700, 0x04c09600, 0x04d09500, 0x04e09401, 0x04f09300, 0x05009200, 
	0x05109100, 0x05209000, 0x05308f01, 0x05408e00, 0x05508d00, 0x05608c00, 0x05708b00, 0x05808a00, 
	0x05908901, 0x05a08800, 0x05b08700, 0x05c08600, 0x05d08500, 0x05e08401, 0x05f08300, 0x06008200, 
	0x06108100, 0x06208000, 0x06307f00, 0x06407e01, 0x06507d00, 0x06607c00, 0x06707b00, 0x06807a00, 
	0x06907901, 0x06a07800, 0x06b07700, 0x06c07600, 0x06d07500, 0x06e07400, 0x06f07301, 0x07007200, 
	0x07107100, 0x07207000, 0x07306f00, 0x07406e01, 0x07506d00, 0x07606c00, 0x07706b00, 0x07806a00, 
	0x07906900, 0x07a06801, 0x07b06700, 0x07c06600, 0x07d06500, 0x07e06400, 0x07f06301, 0x08006200, 
	0x08106100, 0x08206000, 0x08305f00, 0x08405e00, 0x08505d01, 0x08605c00, 0x08705b00, 0x08805a00, 
	0x08905900, 0x08a05801, 0x08b05700, 0x08c05600, 0x08d05500, 0x08e05400, 0x08f05300, 0x09005201, 
	0x09105100, 0x09205000, 0x09304f00, 0x09404e00, 0x09504d01, 0x09604c00, 0x09704b00, 0x09804a00, 
	0x09904900, 0x09a04800, 0x09b04701, 0x09c04600, 0x09d04500, 0x09e04400, 0x09f04300, 0x0a004201, 
	0x0a104100, 0x0a204000, 0x0a303f00, 0x0a403e00, 0x0a503d00, 0x0a603c01, 0x0a703b00, 0x0a803a00, 
	0x0a903900, 0x0aa03800, 0x0ab03701, 0x0ac03600, 0x0ad03500, 0x0ae03400, 0x0af03300, 0x0b003200, 
	0x0b103101, 0x0b203000, 0x0b302f00, 0x0b402e00, 0x0b502d00, 0x0b602c01, 0x0b702b00, 0x0b802a00, 
	0x0b902900, 0x0ba02800, 0x0bb02700, 0x0bc02601, 0x0bd02500, 0x0be02400, 0x0bf02300, 0x0c002200, 
	0x0c102101, 0x0c202000, 0x0c301f00, 0x0c401e00, 0x0c501d00, 0x0c601c00, 0x0c701b01, 0x0c801a00, 
	0x0c901900, 0x0ca01800, 0x0cb01700, 0x0cc01601, 0x0cd01500, 0x0ce01400, 0x0cf01300, 0x0d001200, 
	0x0d101100, 0x0d201001, 0x0d300f00, 0x0d400e00, 0x0d500d00, 0x0d600c00, 0x0d700b01, 0x0d800a00, 
	0x0d900900, 0x0da00800, 0x0db00700, 0x0dc00600, 0x0dd00501, 0x0de00400, 0x0df00300, 0x0e000200, 
	0x0e100100, 0x0e200000, 0x0e31b801, 0x0e41b700, 0x0e51b600, 0x0e61b500, 0x0e71b400, 0x0e81b301, 
	0x0e91b200, 0x0ea1b100, 0x0eb1b000, 0x0ec1af00, 0x0ed1ae00, 0x0ee1ad01, 0x0ef1ac00, 0x0f01ab00, 
	0x0f11aa00, 0x0f21a900, 0x0f31a801, 0x0f41a700, 0x0f51a600, 0x0f61a500, 0x0f71a400, 0x0f81a300, 
	0x0f91a201, 0x0fa1a100, 0x0fb1a000, 0x0fc19f00, 0x0fd19e00, 0x0fe19d01, 0x0ff19c00, 0x10019b00, 
	0x10119a00, 0x10219900, 0x10319800, 0x10419701, 0x10519600, 0x10619500, 0x10719400, 0x10819300, 
	0x10919201, 0x10a19100, 0x10b19000, 0x10c18f00, 0x10d18e00, 0x10e18d00, 0x10f18c01, 0x11018b00, 
	0x11118a00, 0x11218900, 0x11318800, 0x11418701, 0x11518600, 0x11618500, 0x11718400, 0x11818300, 
	0x11918200, 0x11a18101, 0x11b18000, 0x11c17f00, 0x11d17e00, 0x11e17d00, 0x11f17c01, 0x12017b00, 
	0x12117a00, 0x12217900, 0x12317800, 0x12417700, 0x12517601, 0x12617500, 0x12717400, 0x12817300, 
	0x12917200, 0x12a17101, 0x12b17000, 0x12c16f00, 0x12d16e00, 0x12e16d00, 0x12f16c00, 0x13016b01, 
	0x13116a00, 0x13216900, 0x13316800, 0x13416700, 0x13516601, 0x13616500, 0x13716400, 0x13816300, 
	0x13916200, 0x13a16100, 0x13b16001, 0x13c15f00, 0x13d15e00, 0x13e15d00, 0x13f15c00, 0x14015b01, 
	0x14115a00, 0x14215900, 0x14315800, 0x14415700, 0x14515600, 0x14615501, 0x14715400, 0x14815300, 
	0x14915200, 0x14a15100, 0x14b15001, 0x14c14f00, 0x14d14e00, 0x14e14d00, 0x14f14c00, 0x15014b00, 
	0x15114a01, 0x15214900, 0x15314800, 0x15414700, 0x15514600, 0x15614501, 0x15714400, 0x15814300, 
	0x15914200, 0x15a14100, 0x15b14000, 0x15c13f01, 0x15d13e00, 0x15e13d00, 0x15f13c00, 0x16013b00, 
	0x16113a01, 0x16213900, 0x16313800, 0x16413700, 0x16513600, 0x16613500, 0x16713401, 0x16813300, 
	0x16913200, 0x16a13100, 0x16b13000, 0x16c12f01, 0x16d12e00, 0x16e12d00, 0x16f12c00, 0x17012b00, 
	0x17112a00, 0x17212901, 0x17312800, 0x17412700, 0x17512600, 0x17612500, 0x17712401, 0x17812300, 
	0x17912200, 0x17a12100, 0x17b12000, 0x17c11f00, 0x17d11e01, 0x17e11d00, 0x17f11c00, 0x18011b00, 
	0x18111a00, 0x18211901, 0x18311800, 0x18411700, 0x18511600, 0x18611500, 0x18711400, 0x18811301, 
	0x18911200, 0x18a11100, 0x18b11000, 0x18c10f00, 0x18d10e01, 0x18e10d00, 0x18f10c00, 0x19010b00, 
	0x19110a00, 0x19210900, 0x19310801, 0x19410700, 0x19510600, 0x19610500, 0x19710400, 0x19810301, 
	0x19910200, 0x19a10100, 0x19b10000, 0x19c0ff00, 0x19d0fe00, 0x19e0fd01, 0x19f0fc00, 0x1a00fb00, 
	0x1a10fa00, 0x1a20f900, 0x1a30f801, 0x1a40f700, 0x1a50f600, 0x1a60f500, 0x1a70f400, 0x1a80f300, 
	0x1a90f201, 0x1aa0f100, 0x1ab0f000, 0x1ac0ef00, 0x1ad0ee00, 0x1ae0ed01, 0x1af0ec00, 0x1b00eb00, 
	0x1b10ea00, 0x1b20e900, 0x1b30e800, 0x1b40e701, 0x1b50e600, 0x1b60e500, 0x1b70e400, 0x1b80e300, 
	0x0000e201, 
};
#endif // HELIX_FEATURE_MMXFILTER_441_80

#ifdef HELIX_FEATURE_MMXFILTER_4_1
/*
 * inrate=11025 outrate=44100 up=4 dn=1
 */

ALIGN
filtwing filter_4_1[4] = {
	{  -483, -1032,  5231, -13641,  6979, -12395, 19914, -29549, 10237, -13314, 16254, -18523,  9711, -9048,  6798, -2472, -2191,  7055, -13443, 21315, -15235, 20255, -25412, 30293, -17188, 18525, -18821, 17727, -7451,  5022, -1457, -3315,  4652, -8226, 12305, -16775, 10737, -13097, 15340, -17314,  9418, -9839,  9764, -8938,   857,  -265, -1436, 29892, },
	{  2281, -6053, 12689, -22934,  9294, -13785, 18890, -23961,  6989, -7352,  6610, -4214,  -213,  3941, -9311, 16460, -12687, 17916, -23684, 29611, -17584, 19839, -21167, 21121, -9617,  7528, -4096,  -822,  3648, -7650, 12341, -17580, 11577, -14385, 17033, -19302, 10470, -10829, 10566, -9494,  3691, -1960,  -683,  4662, -1361,  2723, -5865, 24771, },
	{  3016, -6869, 12450, -19484,  6767, -8365,  8986, -7689,   825,  1378, -5032, 10440, -8906, 13596, -19190, 25435, -15948, 18966, -21352, 22595, -11059,  9652, -6782,  2186,  2161, -6412, 11627, -17688, 12187, -15679, 19099, -22176, 12295, -12991, 12981, -12063,  5015, -3337,   890,  2442, -3400,  6191, -9760, 14425, -2610,  3867, -6375, 16110, },
	{  2069, -4261,  6452, -7602,  1521,    85, -3608,  9813, -4861,  8274, -12759, 18256, -12264, 15556, -18647, 21046, -11067, 10596, -8721,  5053,   376, -4475,  9824, -16383, 11993, -16162, 20469, -24604, 14091, -15378, 15914, -15440,  6848, -5219,  2728,   709, -2574,  5307, -8551, 12292, -8255, 10599, -13192, 16100, -2439,  2997, -3912,  6491, },
};

int nextstate_4_1[4] = {
	0x00100200, 0x00200100, 0x00300000, 0x00000301, 
};
#endif HELIX_FEATURE_MMXFILTER_4_1

#ifdef HELIX_FEATURE_MMXFILTER_441_160
/*
 * inrate=16000 outrate=44100 up=441 dn=160
 */

ALIGN
filtwing filter_441_160[441] = {
	{ -2562,  2758,  -822, -4966,  4176, -9169, 16755, -27322, 10241, -14333, 18866, -23415, 13672, -14903, 14879, -13006,  4331,  -625, -4863, 12287, -10832, 16417, -22704, 29377, -17994, 20980, -23299, 24558, -12168, 11105, -8889,  5346,  -171, -3099,  7141, -11920,  8680, -11672, 14857, -18141, 10707, -12281, 13733, -15003,  2005, -2097,  2138, 30572, },
	{  2431, -6370, 13291, -23979,  9717, -14431, 19827, -25261,  7422, -7906,  7293, -5021,   243,  3452, -8822, 16019, -12522, 17849, -23762, 29890, -17854, 20270, -21789, 21958, -10151,  8180, -4860,    37,  3186, -7174, 11880, -17171, 11419, -14299, 17046, -19444, 10621, -11076, 10925, -9978,  4003, -2349,  -210,  4097, -1277,  2625, -5755, 25088, },
	{  3124, -6627, 11177, -16100,  5014, -5227,  3919,  -156, -1783,  4760, -9133, 15060, -11278, 15716, -20617, 25599, -15053, 16708, -17327, 16417, -6733,  3991,   228, -6062,  6776, -11305, 16492, -22124, 13945, -16692, 19057, -20752, 10732, -10429,  9301, -7184,  1962,   310, -3289,  7041, -5822,  8609, -11989, 16185, -2712,  3731, -5641, 12151, },
	{ -1092,   -51,  3840, -11893,  6506, -12000, 19787, -29982, 10585, -14030, 17492, -20456, 11111, -10963,  9285, -5552,  -372,  5011, -11274, 19173, -14282, 19555, -25126, 30601, -17736, 19564, -20441, 19999, -8936,  6859, -3625,  -869,  3333, -6872, 11000, -15623, 10301, -12875, 15420, -17797,  9921, -10677, 11035, -10791,  1194,  -780,  -497, 30222, },
	{  3032, -7293, 14259, -24346,  9371, -13207, 17114, -20287,  5389, -4846,  2987,   689, -3338,  7698, -13554, 20914, -14804, 19628, -24612, 29304, -16561, 17685, -17631, 15989, -6180,  3199,  1080, -6717,  6842, -10924, 15474, -20297, 12564, -14818, 16713, -18021,  9245, -8921,  7884, -5959,  1465,   747, -3887,  8370, -1886,  3303, -6422, 22360, },
	{  2706, -5529,  8748, -11425,  2996, -2037,  -754,  6233, -3824,  7186, -11784, 17640, -12305, 16163, -20079, 23591, -13045, 13418, -12495,  9838, -2513, -1149,  6185, -12625, 10191, -14615, 19390, -24238, 14398, -16312, 17606, -18004,  8609, -7482,  5487, -2506,  -779,  3389, -6603, 10437, -7456, 10036, -13011, 16510, -2606,  3360, -4684,  8730, },
	{   268, -2577,  7850, -17511,  8249, -13863, 21340, -30524, 10214, -12817, 15028, -16275,  7922, -6453,  3288,  2002, -4888, 10129, -16735, 24580, -16685, 21310, -25819, 29768, -16311, 16890, -16302, 14229, -5190,  2259,  1757, -6881,  6536, -10104, 14042, -18206, 11201, -13198, 14949, -16287,  8504, -8423,  7714, -6063,   352,   477, -2704, 29202, },
	{  3338, -7627, 14192, -23073,  8431, -11191, 13435, -14251,  3105, -1616, -1317,  6104, -6550, 11267, -17212, 24250, -16030, 20052, -23809, 26801, -14213, 14006, -12425,  9127, -1907, -1865,  6798, -12858,  9957, -13861, 17959, -22008, 12852, -14345, 15282, -15439,  7291, -6229,  4400, -1653, -1096,  3696, -7176, 11914, -2341,  3720, -6607, 19273, },
	{  2162, -4184,  5967, -6377,   928,  1075, -5092, 11849, -5504,  9018, -13534, 18943, -12477, 15526, -18237, 20101, -10247,  9354, -6997,  2817,  1745, -6061, 11563, -18171, 12840, -16871, 20931, -24697, 13888, -14861, 15024, -14128,  5966, -4107,  1397,  2230, -3405,  6171, -9397, 13054, -8552, 10758, -13142, 15739, -2335,  2795, -3518,  5453, },
	{  1437, -4674, 10993, -21545,  9327, -14695, 21397, -29024,  9188, -10818, 11684, -11201,  4341, -1694, -2702,  9152, -8925, 14407, -20915, 28196, -17914, 21605, -24786, 26989, -13846, 13169, -11190,  7660, -1192, -2381,  6895, -12298,  9232, -12592, 16085, -19524, 11340, -12640, 13503, -13744,  6568, -5688,  4011, -1148,  -465,  1604, -4433, 27554, },
	{  3368, -7412, 13187, -20375,  7001, -8567,  9089, -7610,   736,  1563, -5335, 10879, -9196, 13951, -19595, 25864, -16154, 19138, -21460, 22605, -10997,  9510, -6546,  1851,  2378, -6672, 11920, -17996, 12338, -15811, 19197, -22222, 12283, -12934, 12872, -11896,  4900, -3191,   713,  2646, -3512,  6309, -9878, 14530, -2619,  3868, -6354, 15946, },
	{  1552, -2715,  3056, -1326, -1049,  3908, -8829, 16365, -6733, 10164, -14309, 18939, -11819, 13891, -15263, 15414, -6872,  4811, -1218, -4167,  5756, -10427, 16023, -22361, 14568, -17952, 21048, -23510, 12471, -12461, 11509, -9408,  2989,  -538, -2691,  6708, -5743,  8477, -11501, 14741, -9054, 10749, -12404, 13966, -1924,  2084, -2232,  2430, },
	{  2353, -6242, 13131, -23844,  9716, -14505, 20040, -25694,  7610, -8202,  7723, -5609,   622,  2989, -8287, 15439, -12232, 17592, -23580, 29837, -17922, 20465, -22143, 22502, -10530,  8672, -5466,   747,  2789, -6752, 11457, -16776, 11255, -14189, 17016, -19519, 10725, -11260, 11202, -10363,  4255, -2667,   180,  3628, -1207,  2541, -5658, 25344, },
	{  3157, -6721, 11398, -16544,  5212, -5549,  4406,  -839, -1558,  4483, -8815, 14727, -11125, 15607, -20594, 25712, -15207, 16991, -17770, 17048, -7152,  4517,  -401, -5347,  6391, -10913, 16124, -21816, 13843, -16668, 19136, -20961, 10913, -10699,  9666, -7648,  2243,   -15, -2928,  6656, -5628,  8425, -11835, 16088, -2713,  3756, -5724, 12505, },
	{ -1240,   227,  3387, -11237,  6293, -11752, 19543, -29807, 10583, -14105, 17687, -20821, 11407, -11398,  9884, -6329,   107,  4451, -10653, 18529, -13974, 19294, -24956, 30571, -17817, 19770, -20797, 20529, -9295,  7316, -4176,  -234,  2984, -6506, 10639, -15292, 10167, -12792, 15410, -17887, 10032, -10874, 11344, -11252,  1279,  -914,  -245, 30289, },
	{  2984, -7226, 14208, -24387,  9436, -13372, 17442, -20854,  5611, -5172,  3434,   110, -2984,  7289, -13114, 20479, -14618, 19508, -24602, 29455, -16745, 18005, -18112, 16650, -6607,  3719,   474, -6045,  6488, -10573, 15154, -20040, 12486, -14811, 16799, -18223,  9415, -9170,  8220, -6389,  1729,   433, -3524,  7961, -1831,  3246, -6376, 22658, },
	{  2756, -5655,  9017, -11928,  3208, -2364,  -285,  5607, -3629,  6963, -11552, 17433, -12239, 16168, -20196, 23869, -13290, 13795, -13027, 10541, -2952,  -627,  5595, -11992,  9873, -14321, 19153, -24097, 14397, -16401, 17809, -18342,  8854, -7808,  5895, -2993,  -500,  3084, -6283, 10121, -7312,  9921, -12947, 16528, -2625,  3408, -4793,  9076, },
	{   136, -2336,  7475, -17004,  8100, -13719, 21251, -30564, 10283, -12980, 15325, -16751,  8271, -6932,  3909,  1238, -4442,  9637, -16229, 24104, -16491, 21196, -25828, 29946, -16508, 17217, -16777, 14865, -5591,  2738,  1210, -6285,  6227, -9803, 13774, -17998, 11144, -13206, 15044, -16493,  8675, -8679,  8077, -6562,   438,   353, -2499, 29337, },
	{  3320, -7619, 14244, -23274,  8552, -11429, 13848, -14906,  3346, -1948,  -884,  5573, -6244, 10939, -16893, 23985, -15954, 20071, -23965, 27140, -14498, 14426, -12997,  9858, -2351, -1351,  6233, -12268,  9669, -13603, 17760, -21901, 12863, -14439, 15476, -15752,  7514, -6524,  4771, -2100,  -838,  3406, -6863, 11590, -2302,  3690, -6609, 19602, },
	{  2221, -4329,  6261, -6901,  1138,   766, -4671, 11319, -5351,  8861, -13399, 18870, -12498, 15639, -18481, 20519, -10564,  9798, -7580,  3543,  1315, -5577, 11049, -17659, 12608, -16692, 20838, -24727, 13984, -15056, 15335, -14570,  6256, -4466,  1821,  1751, -3146,  5904, -9140, 12826, -8467, 10718, -13169, 15867, -2370,  2861, -3644,  5779, },
	{  1328, -4482, 10715, -21210,  9248, -14657, 21458, -29267,  9321, -11055, 12060, -11752,  4719, -2184, -2099,  8451, -8540, 14015, -20553, 27914, -17844, 21642, -24969, 27358, -14141, 13591, -11749,  8358, -1606, -1912,  6389, -11781,  8984, -12376, 15925, -19449, 11361, -12736, 13694, -14047,  6786, -5985,  4401, -1651,  -384,  1496, -4279, 27750, },
	{  3377, -7457, 13329, -20709,  7167, -8858,  9556, -8305,   978,  1246, -4944, 10428, -8956, 13721, -19413, 25780, -16191, 19291, -21767, 23104, -11361, 10000, -7168,  2602,  1946, -6200, 11432, -17525, 12132, -15660, 19130, -22269, 12379, -13119, 13159, -12296,  5161, -3512,  1093,  2214, -3276,  6062, -9633, 14309, -2599,  3865, -6399, 16295, },
	{  1616, -2868,  3354, -1834,  -854,  3636, -8480, 15960, -6629, 10080, -14275, 18998, -11923, 14101, -15614, 15940, -7238,  5290, -1812, -3466,  5364, -10013, 15616, -22002, 14436, -17897, 21102, -23705, 12655, -12746, 11905, -9922,  3304,  -906, -2280,  6270, -5521,  8266, -11321, 14614, -9030, 10783, -12518, 14190, -1972,  2162, -2367,  2726, },
	{  2272, -6107, 12960, -23689,  9707, -14570, 20240, -26112,  7794, -8493,  8149, -6195,  1003,  2521, -7743, 14846, -11933, 17321, -23381, 29762, -17977, 20645, -22483, 23032, -10903,  9160, -6070,  1458,  2389, -6325, 11025, -16369, 11082, -14070, 16973, -19580, 10821, -11436, 11473, -10742,  4505, -2984,   571,  3153, -1136,  2455, -5556, 25594, },
	{  3189, -6811, 11612, -16979,  5408, -5870,  4892, -1526, -1331,  4201, -8490, 14382, -10963, 15487, -20557, 25808, -15351, 17263, -18202, 17670, -7568,  5042, -1031, -4627,  6000, -10512, 15743, -21492, 13732, -16632, 19202, -21155, 11088, -10962, 10025, -8108,  2522,  -341, -2563,  6266, -5428,  8235, -11672, 15979, -2712,  3779, -5804, 12860, },
	{ -1388,   507,  2928, -10567,  6073, -11494, 19284, -29609, 10574, -14170, 17869, -21172, 11695, -11828, 10479, -7106,   588,  3885, -10024, 17869, -13654, 19020, -24768, 30519, -17887, 19963, -21140, 21045, -9649,  7769, -4726,   403,  2632, -6135, 10268, -14949, 10025, -12699, 15389, -17965, 10137, -11064, 11646, -11707,  1364, -1048,    11, 30349, },
	{  2933, -7152, 14146, -24410,  9493, -13528, 17759, -21408,  5831, -5495,  3880,  -471, -2627,  6874, -12663, 20029, -14420, 19373, -24574, 29586, -16918, 18312, -18581, 17301, -7029,  4238,  -133, -5367,  6129, -10214, 14821, -19767, 12398, -14793, 16873, -18413,  9579, -9412,  8551, -6816,  1993,   118, -3157,  7545, -1773,  3185, -6325, 22952, },
	{  2804, -5778,  9282, -12427,  3419, -2692,   187,  4973, -3431,  6733, -11310, 17212, -12164, 16161, -20300, 24131, -13527, 14165, -13553, 11239, -3391,  -103,  4998, -11349,  9547, -14016, 18902, -23938, 14385, -16480, 18001, -18667,  9093, -8129,  6301, -3480,  -221,  2776, -5959,  9797, -7162,  9799, -12874, 16534, -2642,  3454, -4900,  9424, },
	{     2, -2090,  7092, -16481,  7944, -13564, 21145, -30584, 10346, -13135, 15613, -17217,  8616, -7409,  4531,   470, -3991,  9137, -15709, 23609, -16285, 21068, -25819, 30103, -16693, 17532, -17242, 15492, -5988,  3216,   661, -5684,  5914, -9495, 13495, -17776, 11078, -13204, 15128, -16687,  8841, -8930,  8435, -7058,   524,   228, -2289, 29464, },
	{  3299, -7605, 14286, -23459,  8668, -11660, 14254, -15554,  3586, -2281,  -448,  5035, -5932, 10601, -16561, 23702, -15868, 20076, -24105, 27461, -14773, 14837, -13561, 10585, -2794,  -836,  5662, -11668,  9373, -13334, 17548, -21778, 12864, -14522, 15660, -16055,  7732, -6816,  5139, -2546,  -577,  3113, -6543, 11257, -2261,  3657, -6607, 19929, },
	{  2281, -4474,  6555, -7425,  1349,   453, -4243, 10777, -5194,  8696, -13253, 18783, -12511, 15742, -18714, 20925, -10875, 10236, -8160,  4270,   883, -5088, 10525, -17134, 12367, -16501, 20730, -24739, 14069, -15241, 15637, -15002,  6542, -4823,  2245,  1270, -2884,  5633, -8875, 12589, -8375, 10669, -13187, 15983, -2403,  2925, -3770,  6108, },
	{  1216, -4285, 10426, -20856,  9162, -14609, 21505, -29490,  9448, -11284, 12429, -12297,  5096, -2675, -1493,  7741, -8149, 13611, -20175, 27611, -17761, 21664, -25134, 27708, -14428, 14005, -12301,  9051, -2019, -1441,  5878, -11253,  8729, -12150, 15754, -19361, 11374, -12824, 13874, -14342,  7000, -6279,  4789, -2155,  -302,  1387, -4119, 27941, },
	{  3383, -7498, 13463, -21031,  7329, -9144, 10019, -8998,  1221,   926, -4547,  9967, -8708, 13481, -19217, 25677, -16218, 19431, -22059, 23589, -11717, 10484, -7787,  3353,  1512, -5723, 10935, -17041, 11917, -15498, 19049, -22301, 12467, -13295, 13438, -12689,  5418, -3832,  1474,  1778, -3036,  5809, -9380, 14077, -2577,  3860, -6439, 16642, },
	{  1679, -3020,  3653, -2345,  -657,  3359, -8123, 15541, -6521,  9988, -14231, 19045, -12019, 14301, -15955, 16456, -7600,  5767, -2407, -2761,  4967, -9590, 15197, -21625, 14294, -17829, 21140, -23883, 12831, -13023, 12294, -10430,  3617, -1274, -1866,  5825, -5294,  8050, -11132, 14476, -9001, 10810, -12623, 14405, -2018,  2239, -2501,  3025, },
	{  2188, -5967, 12778, -23516,  9692, -14625, 20426, -26512,  7973, -8779,  8572, -6779,  1384,  2050, -7192, 14240, -11624, 17037, -23165, 29665, -18019, 20811, -22807, 23547, -11268,  9643, -6671,  2170,  1987, -5892, 10583, -15949, 10901, -13939, 16918, -19628, 10910, -11605, 11736, -11114,  4752, -3300,   964,  2675, -1063,  2367, -5448, 25839, },
	{  3218, -6897, 11820, -17405,  5601, -6190,  5378, -2216, -1101,  3915, -8156, 14025, -10793, 15356, -20504, 25885, -15485, 17524, -18623, 18280, -7979,  5565, -1663, -3901,  5603, -10103, 15350, -21152, 13611, -16584, 19254, -21335, 11255, -11217, 10378, -8563,  2801,  -667, -2196,  5870, -5225,  8038, -11500, 15859, -2709,  3799, -5881, 13214, },
	{ -1537,   791,  2463, -9885,  5847, -11227, 19008, -29389, 10557, -14225, 18040, -21510, 11976, -12250, 11068, -7880,  1070,  3316, -9385, 17194, -13324, 18730, -24562, 30445, -17943, 20141, -21469, 21548, -9997,  8217, -5274,  1041,  2277, -5758,  9890, -14594,  9876, -12597, 15358, -18031, 10234, -11247, 11942, -12157,  1449, -1183,   271, 30402, },
	{  2878, -7072, 14074, -24415,  9545, -13675, 18065, -21951,  6048, -5816,  4326, -1054, -2265,  6452, -12201, 19563, -14211, 19223, -24528, 29696, -17079, 18608, -19038, 17942, -7448,  4756,  -742, -4684,  5765, -9847, 14478, -19480, 12302, -14765, 16936, -18590,  9736, -9649,  8877, -7239,  2256,  -199, -2786,  7122, -1714,  3122, -6269, 23243, },
	{  2851, -5898,  9543, -12921,  3629, -3020,   662,  4332, -3229,  6498, -11059, 16978, -12079, 16143, -20389, 24377, -13756, 14525, -14070, 11931, -3829,   424,  4396, -10696,  9213, -13701, 18637, -23762, 14362, -16547, 18180, -18981,  9326, -8445,  6703, -3966,    60,  2465, -5629,  9466, -7007,  9670, -12791, 16529, -2657,  3497, -5005,  9773, },
	{  -133, -1840,  6700, -15941,  7781, -13398, 21023, -30581, 10401, -13281, 15891, -17673,  8957, -7882,  5151,  -302, -3536,  8629, -15177, 23095, -16067, 20924, -25792, 30239, -16868, 17836, -17695, 16110, -6382,  3693,   110, -5077,  5595, -9180, 13206, -17541, 11005, -13193, 15202, -16869,  9001, -9176,  8788, -7553,   611,   101, -2074, 29585, },
	{  3275, -7586, 14318, -23629,  8778, -11885, 14653, -16194,  3825, -2614,   -10,  4491, -5614, 10255, -16215, 23401, -15769, 20067, -24228, 27764, -15038, 15239, -14117, 11305, -3237,  -318,  5085, -11059,  9069, -13056, 17323, -21639, 12856, -14595, 15833, -16346,  7946, -7103,  5505, -2991,  -316,  2816, -6218, 10914, -2219,  3621, -6599, 20254, },
	{  2339, -4616,  6846, -7947,  1561,   138, -3810, 10225, -5032,  8524, -13097, 18682, -12515, 15834, -18934, 21317, -11180, 10669, -8737,  4995,   448, -4594,  9992, -16595, 12117, -16298, 20607, -24734, 14145, -15415, 15928, -15425,  6824, -5177,  2668,   786, -2620,  5358, -8604, 12342, -8277, 10613, -13196, 16089, -2435,  2987, -3893,  6439, },
	{  1102, -4082, 10128, -20484,  9069, -14549, 21536, -29693,  9568, -11507, 12792, -12836,  5470, -3165,  -884,  7024, -7749, 13197, -19782, 27288, -17665, 21670, -25283, 28040, -14705, 14410, -12846,  9740, -2433,  -967,  5361, -10717,  8467, -11915, 15571, -19258, 11379, -12903, 14046, -14626,  7210, -6569,  5176, -2660,  -220,  1275, -3954, 28125, },
	{  3387, -7533, 13588, -21340,  7486, -9426, 10478, -9689,  1464,   604, -4145,  9497, -8452, 13229, -19006, 25556, -16232, 19557, -22337, 24058, -12066, 10962, -8402,  4104,  1076, -5240, 10428, -16543, 11693, -15324, 18954, -22316, 12547, -13462, 13708, -13074,  5673, -4150,  1854,  1341, -2794,  5551, -9119, 13833, -2553,  3851, -6475, 16988, },
	{  1743, -3173,  3952, -2860,  -459,  3077, -7757, 15109, -6407,  9888, -14176, 19077, -12106, 14493, -16285, 16963, -7958,  6241, -3002, -2051,  4564, -9159, 14766, -21233, 14141, -17749, 21164, -24045, 12998, -13291, 12676, -10931,  3928, -1643, -1450,  5376, -5063,  7827, -10935, 14328, -8965, 10829, -12720, 14610, -2064,  2315, -2635,  3327, },
	{  2101, -5820, 12585, -23325,  9669, -14669, 20599, -26897,  8147, -9061,  8990, -7361,  1766,  1575, -6634, 13621, -11305, 16740, -22932, 29548, -18049, 20963, -23116, 24046, -11627, 10120, -7269,  2883,  1582, -5453, 10133, -15517, 10712, -13799, 16851, -19661, 10991, -11766, 11992, -11479,  4997, -3615,  1357,  2192,  -990,  2276, -5335, 26079, },
	{  3245, -6979, 12021, -17823,  5792, -6506,  5863, -2908,  -870,  3624, -7815, 13656, -10615, 15213, -20437, 25945, -15608, 17773, -19032, 18880, -8387,  6086, -2295, -3170,  5201, -9686, 14945, -20796, 13479, -16524, 19293, -21501, 11414, -11465, 10725, -9013,  3078,  -994, -1827,  5469, -5017,  7835, -11319, 15726, -2704,  3817, -5954, 13569, },
	{ -1688,  1077,  1992, -9189,  5615, -10949, 18718, -29147, 10532, -14270, 18198, -21834, 12250, -12666, 11652, -8651,  1553,  2741, -8737, 16505, -12984, 18427, -24337, 30349, -17987, 20306, -21783, 22037, -10338,  8661, -5819,  1680,  1919, -5377,  9504, -14229,  9719, -12486, 15315, -18084, 10325, -11422, 12230, -12599,  1533, -1318,   536, 30448, },
	{  2821, -6986, 13990, -24403,  9590, -13814, 18360, -22481,  6262, -6135,  4771, -1639, -1901,  6024, -11729, 19081, -13991, 19060, -24465, 29785, -17228, 18891, -19483, 18572, -7862,  5272, -1352, -3996,  5395, -9472, 14123, -19178, 12196, -14726, 16987, -18754,  9887, -9880,  9198, -7659,  2519,  -517, -2412,  6692, -1654,  3056, -6208, 23529, },
	{  2896, -6016,  9800, -13410,  3838, -3349,  1140,  3684, -3024,  6256, -10799, 16731, -11986, 16113, -20464, 24607, -13975, 14877, -14579, 12618, -4265,   951,  3790, -10033,  8872, -13375, 18358, -23568, 14330, -16602, 18347, -19281,  9553, -8755,  7101, -4450,   342,  2151, -5295,  9127, -6846,  9533, -12699, 16512, -2671,  3538, -5107, 10123, },
	{  -271, -1586,  6299, -15385,  7611, -13221, 20886, -30556, 10450, -13418, 16159, -18118,  9292, -8352,  5770, -1076, -3077,  8113, -14632, 22564, -15836, 20764, -25746, 30354, -17030, 18128, -18137, 16718, -6773,  4169,  -442, -4465,  5272, -8857, 12907, -17293, 10923, -13173, 15265, -17041,  9155, -9416,  9137, -8044,   697,   -27, -1854, 29700, },
	{  3247, -7560, 14340, -23782,  8883, -12103, 15043, -16827,  4062, -2947,   430,  3941, -5291,  9899, -15856, 23083, -15659, 20043, -24334, 28048, -15294, 15631, -14665, 12020, -3678,   201,  4504, -10439,  8758, -12767, 17085, -21485, 12839, -14658, 15995, -16627,  8154, -7387,  5868, -3436,   -54,  2517, -5887, 10562, -2175,  3582, -6587, 20575, },
	{  2396, -4757,  7136, -8469,  1773,  -179, -3371,  9661, -4865,  8346, -12931, 18567, -12509, 15914, -19141, 21695, -11478, 11096, -9309,  5720,    12, -4095,  9450, -16042, 11857, -16082, 20470, -24711, 14212, -15579, 16209, -15838,  7102, -5529,  3090,   301, -2353,  5078, -8325, 12086, -8172, 10550, -13196, 16184, -2465,  3048, -4016,  6773, },
	{   985, -3873,  9819, -20094,  8968, -14479, 21552, -29876,  9683, -11723, 13146, -13368,  5842, -3656,  -272,  6298, -7344, 12771, -19373, 26944, -17557, 21661, -25413, 28352, -14972, 14806, -13383, 10423, -2845,  -492,  4839, -10171,  8198, -11672, 15377, -19142, 11376, -12973, 14208, -14901,  7416, -6856,  5560, -3165,  -136,  1162, -3784, 28303, },
	{  3387, -7563, 13704, -21637,  7639, -9704, 10932, -10377,  1708,   279, -3738,  9017, -8190, 12968, -18781, 25416, -16236, 19670, -22599, 24512, -12407, 11434, -9014,  4854,   637, -4752,  9913, -16032, 11460, -15139, 18846, -22316, 12618, -13620, 13968, -13450,  5923, -4466,  2234,   901, -2549,  5289, -8852, 13579, -2527,  3840, -6507, 17332, },
	{  1806, -3325,  4252, -3376,  -258,  2792, -7384, 14663, -6288,  9781, -14111, 19097, -12186, 14674, -16606, 17460, -8311,  6713, -3597, -1337,  4158, -8721, 14323, -20824, 13977, -17655, 21173, -24191, 13156, -13550, 13049, -11426,  4238, -2010, -1032,  4922, -4828,  7598, -10730, 14169, -8922, 10841, -12808, 14806, -2108,  2390, -2768,  3633, },
	{  2010, -5667, 12381, -23115,  9639, -14703, 20758, -27264,  8317, -9337,  9405, -7941,  2148,  1097, -6068, 12991, -10977, 16431, -22681, 29408, -18066, 21101, -23410, 24530, -11979, 10591, -7863,  3595,  1175, -5010,  9675, -15072, 10515, -13649, 16772, -19681, 11065, -11919, 12240, -11837,  5239, -3928,  1750,  1706,  -915,  2183, -5217, 26313, },
	{  3270, -7056, 12215, -18231,  5981, -6821,  6347, -3603,  -636,  3329, -7467, 13276, -10428, 15058, -20355, 25986, -15720, 18011, -19429, 19468, -8789,  6604, -2927, -2435,  4795, -9260, 14528, -20425, 13338, -16452, 19318, -21651, 11566, -11706, 11064, -9458,  3354, -1321, -1455,  5063, -4805,  7626, -11130, 15582, -2697,  3832, -6024, 13923, },
	{ -1839,  1365,  1514, -8482,  5378, -10662, 18412, -28882, 10500, -14305, 18344, -22144, 12517, -13074, 12230, -9419,  2036,  2163, -8080, 15802, -12633, 18110, -24095, 30232, -18019, 20457, -22083, 22512, -10673,  9100, -6362,  2319,  1560, -4990,  9109, -13852,  9555, -12366, 15261, -18124, 10409, -11590, 12510, -13036,  1617, -1453,   805, 30487, },
	{  2761, -6894, 13895, -24373,  9628, -13943, 18643, -22998,  6473, -6451,  5214, -2226, -1534,  5590, -11246, 18583, -13760, 18882, -24385, 29854, -17366, 19162, -19916, 19190, -8273,  5785, -1963, -3303,  5021, -9089, 13758, -18862, 12082, -14677, 17026, -18905, 10031, -10104,  9513, -8074,  2780,  -835, -2035,  6255, -1592,  2987, -6142, 23811, },
	{  2940, -6130, 10052, -13893,  4046, -3677,  1620,  3029, -2815,  6009, -10530, 16471, -11884, 16072, -20525, 24820, -14185, 15219, -15079, 13297, -4700,  1479,  3179, -9361,  8524, -13038, 18065, -23357, 14287, -16645, 18501, -19569,  9773, -9061,  7495, -4932,   623,  1835, -4956,  8780, -6680,  9389, -12597, 16483, -2682,  3577, -5206, 10474, },
	{  -410, -1327,  5890, -14814,  7435, -13034, 20732, -30509, 10491, -13547, 16416, -18553,  9622, -8817,  6388, -1852, -2614,  7590, -14075, 22014, -15593, 20590, -25682, 30448, -17181, 18407, -18567, 17315, -7160,  4643,  -995, -3848,  4944, -8528, 12597, -17033, 10833, -13144, 15318, -17200,  9303, -9650,  9481, -8531,   784,  -156, -1629, 29807, },
	{  3217, -7528, 14351, -23920,  8982, -12313, 15425, -17451,  4297, -3280,   872,  3386, -4962,  9536, -15485, 22747, -15538, 20005, -24423, 28313, -15539, 16014, -15204, 12729, -4118,   721,  3917, -9811,  8441, -12469, 16834, -21315, 12813, -14710, 16147, -16897,  8357, -7665,  6227, -3879,   209,  2215, -5551, 10201, -2129,  3540, -6570, 20893, },
	{  2453, -4897,  7423, -8989,  1986,  -498, -2927,  9088, -4694,  8160, -12755, 18438, -12495, 15984, -19335, 22060, -11768, 11517, -9876,  6443,  -425, -3591,  8900, -15477, 11588, -15855, 20317, -24671, 14268, -15732, 16478, -16240,  7375, -5877,  3512,  -186, -2084,  4793, -8040, 11820, -8062, 10479, -13186, 16267, -2493,  3107, -4136,  7108, },
	{   866, -3660,  9500, -19687,  8860, -14398, 21552, -30038,  9791, -11932, 13493, -13892,  6211, -4145,   344,  5565, -6931, 12335, -18948, 26580, -17435, 21637, -25527, 28645, -15230, 15193, -13912, 11101, -3257,   -16,  4312, -9617,  7924, -11419, 15171, -19012, 11365, -13033, 14361, -15167,  7617, -7139,  5942, -3671,   -53,  1046, -3608, 28474, },
	{  3386, -7587, 13811, -21920,  7788, -9976, 11381, -11062,  1951,   -47, -3327,  8530, -7921, 12696, -18541, 25257, -16227, 19769, -22847, 24950, -12741, 11899, -9620,  5603,   197, -4259,  9389, -15508, 11219, -14943, 18724, -22300, 12679, -13769, 14220, -13818,  6171, -4779,  2614,   460, -2302,  5022, -8577, 13314, -2499,  3826, -6535, 17674, },
	{  1869, -3476,  4551, -3895,   -55,  2502, -7002, 14204, -6164,  9666, -14035, 19103, -12257, 14846, -16916, 17946, -8660,  7181, -4192,  -620,  3747, -8274, 13869, -20399, 13804, -17549, 21167, -24319, 13305, -13800, 13413, -11915,  4545, -2378,  -612,  4463, -4589,  7363, -10517, 13999, -8873, 10845, -12887, 14992, -2151,  2464, -2901,  3943, },
	{  1917, -5508, 12165, -22886,  9602, -14727, 20903, -27613,  8481, -9608,  9814, -8517,  2531,   616, -5496, 12348, -10641, 16108, -22413, 29248, -18070, 21224, -23688, 24998, -12323, 11056, -8453,  4306,   767, -4562,  9209, -14616, 10310, -13488, 16681, -19687, 11132, -12064, 12480, -12187,  5478, -4239,  2144,  1216,  -839,  2087, -5093, 26543, },
	{  3293, -7129, 12402, -18629,  6166, -7132,  6829, -4299,  -401,  3030, -7112, 12885, -10233, 14892, -20258, 26009, -15822, 18236, -19814, 20044, -9186,  7118, -3560, -1696,  4384, -8827, 14100, -20038, 13187, -16369, 19330, -21787, 11710, -11939, 11396, -9897,  3628, -1647, -1082,  4652, -4589,  7411, -10932, 15427, -2688,  3845, -6090, 14276, },
	{ -1990,  1655,  1032, -7762,  5135, -10365, 18091, -28595, 10460, -14330, 18478, -22440, 12776, -13475, 12801, -10184,  2520,  1581, -7416, 15086, -12272, 17778, -23835, 30093, -18038, 20594, -22368, 22971, -11002,  9533, -6901,  2958,  1198, -4600,  8708, -13465,  9384, -12237, 15197, -18152, 10485, -11751, 12783, -13464,  1700, -1589,  1078, 30518, },
	{  2697, -6795, 13789, -24324,  9660, -14064, 18915, -23501,  6680, -6764,  5656, -2814, -1164,  5149, -10753, 18071, -13519, 18691, -24287, 29901, -17491, 19420, -20335, 19797, -8678,  6295, -2574, -2606,  4642, -8699, 13382, -18532, 11959, -14617, 17053, -19044, 10168, -10322,  9822, -8484,  3041, -1154, -1656,  5811, -1528,  2916, -6070, 24088, },
	{  2982, -6241, 10299, -14370,  4253, -4005,  2101,  2369, -2603,  5756, -10252, 16198, -11773, 16019, -20572, 25016, -14386, 15551, -15571, 13969, -5133,  2008,  2564, -8681,  8168, -12692, 17759, -23129, 14234, -16677, 18642, -19844,  9988, -9360,  7884, -5412,   906,  1517, -4612,  8427, -6509,  9238, -12487, 16443, -2692,  3614, -5303, 10826, },
	{  -551, -1065,  5473, -14226,  7251, -12836, 20563, -30440, 10524, -13666, 16663, -18976,  9947, -9278,  7004, -2630, -2147,  7059, -13506, 21447, -15339, 20400, -25599, 30521, -17321, 18675, -18985, 17902, -7542,  5115, -1549, -3227,  4612, -8191, 12279, -16759, 10736, -13105, 15359, -17348,  9445, -9878,  9819, -9015,   870,  -286, -1400, 29907, },
	{  3184, -7490, 14351, -24041,  9075, -12516, 15798, -18067,  4531, -3612,  1316,  2826, -4629,  9163, -15101, 22393, -15405, 19953, -24495, 28558, -15774, 16386, -15733, 13430, -4557,  1242,  3327, -9174,  8116, -12161, 16571, -21129, 12778, -14752, 16287, -17156,  8555, -7939,  6584, -4321,   473,  1910, -5209,  9831, -2081,  3495, -6548, 21208, },
	{  2508, -5034,  7708, -9507,  2198,  -819, -2478,  8504, -4518,  7967, -12569, 18296, -12472, 16043, -19517, 22410, -12051, 11931, -10438,  7164,  -864, -3084,  8342, -14899, 11310, -15616, 20149, -24613, 14314, -15875, 16737, -16632,  7644, -6222,  3931,  -673, -1813,  4505, -7749, 11545, -7945, 10400, -13167, 16340, -2520,  3164, -4255,  7446, },
	{   744, -3441,  9170, -19261,  8745, -14306, 21537, -30180,  9892, -12133, 13832, -14410,  6578, -4634,   961,  4826, -6512, 11889, -18509, 26196, -17301, 21597, -25622, 28919, -15477, 15569, -14432, 11773, -3668,   462,  3781, -9055,  7642, -11158, 14954, -18868, 11345, -13085, 14503, -15422,  7813, -7418,  6321, -4176,    32,   930, -3427, 28640, },
	{  3381, -7606, 13909, -22190,  7933, -10242, 11825, -11742,  2195,  -375, -2911,  8034, -7644, 12413, -18288, 25079, -16208, 19855, -23079, 25371, -13067, 12357, -10222,  6350,  -244, -3762,  8857, -14972, 10969, -14735, 18588, -22269, 12733, -13909, 14462, -14177,  6414, -5090,  2992,    17, -2052,  4751, -8294, 13039, -2470,  3809, -6559, 18015, },
	{  1932, -3627,  4850, -4415,   149,  2208, -6614, 13731, -6034,  9544, -13949, 19095, -12319, 15008, -17215, 18422, -9004,  7646, -4786,   100,  3332, -7821, 13404, -19958, 13620, -17430, 21145, -24431, 13445, -14041, 13770, -12395,  4849, -2744,  -191,  4000, -4347,  7122, -10296, 13819, -8817, 10841, -12958, 15169, -2192,  2536, -3032,  4255, },
	{  1821, -5344, 11939, -22638,  9558, -14740, 21035, -27945,  8640, -9874, 10218, -9090,  2913,   133, -4918, 11695, -10295, 15773, -22129, 29066, -18061, 21332, -23950, 25449, -12659, 11514, -9039,  5016,   356, -4110,  8735, -14149, 10097, -13318, 16578, -19679, 11190, -12201, 12711, -12531,  5714, -4549,  2538,   723,  -762,  1990, -4964, 26766, },
	{  3313, -7197, 12582, -19017,  6348, -7441,  7310, -4996,  -164,  2728, -6750, 12482, -10029, 14715, -20146, 26013, -15912, 18450, -20185, 20608, -9579,  7630, -4191,  -954,  3968, -8386, 13661, -19636, 13026, -16273, 19327, -21907, 11846, -12164, 11722, -10330,  3900, -1974,  -706,  4237, -4369,  7190, -10725, 15260, -2677,  3855, -6153, 14629, },
	{ -2142,  1947,   544, -7031,  4887, -10059, 17755, -28286, 10412, -14345, 18599, -22721, 13026, -13867, 13366, -10944,  3004,   997, -6745, 14356, -11901, 17433, -23557, 29932, -18044, 20717, -22637, 23416, -11323,  9961, -7437,  3596,   835, -4205,  8299, -13067,  9206, -12098, 15121, -18166, 10554, -11903, 13048, -13886,  1782, -1724,  1356, 30543, },
	{  2631, -6691, 13671, -24257,  9684, -14175, 19175, -23991,  6883, -7074,  6096, -3403,  -792,  4704, -10251, 17543, -13267, 18485, -24171, 29927, -17605, 19665, -20742, 20391, -9078,  6803, -3185, -1905,  4259, -8301, 12995, -18187, 11827, -14547, 17068, -19169, 10298, -10532, 10125, -8890,  3300, -1472, -1273,  5362, -1463,  2842, -5993, 24361, },
	{  3022, -6349, 10541, -14841,  4458, -4332,  2585,  1702, -2389,  5498, -9965, 15912, -11653, 15954, -20604, 25196, -14577, 15874, -16053, 14634, -5563,  2537,  1945, -7993,  7806, -12335, 17439, -22884, 14171, -16698, 18771, -20105, 10195, -9654,  8269, -5889,  1188,  1197, -4264,  8066, -6333,  9079, -12367, 16390, -2700,  3648, -5398, 11178, },
	{  -694,  -800,  5048, -13624,  7062, -12627, 20378, -30349, 10551, -13776, 16900, -19387, 10266, -9735,  7616, -3409, -1678,  6522, -12926, 20864, -15073, 20195, -25498, 30572, -17448, 18930, -19391, 18478, -7921,  5584, -2103, -2602,  4276, -7848, 11950, -16473, 10631, -13056, 15390, -17485,  9581, -10100, 10151, -9495,   957,  -416, -1165, 30001, },
	{  3148, -7446, 14341, -24146,  9162, -12711, 16162, -18673,  4763, -3943,  1761,  2262, -4291,  8783, -14705, 22022, -15260, 19886, -24550, 28784, -15999, 16747, -16253, 14124, -4993,  1764,  2732, -8529,  7785, -11843, 16295, -20929, 12734, -14784, 16416, -17403,  8747, -8208,  6936, -4761,   737,  1603, -4863,  9453, -2031,  3448, -6521, 21520, },
	{  2563, -5169,  7989, -10023,  2411, -1142, -2024,  7911, -4339,  7768, -12373, 18140, -12440, 16091, -19685, 22746, -12327, 12338, -10995,  7882, -1303, -2572,  7777, -14308, 11023, -15365, 19967, -24537, 14351, -16007, 16985, -17014,  7909, -6563,  4349, -1162, -1539,  4212, -7452, 11261, -7823, 10313, -13138, 16401, -2546,  3219, -4372,  7786, },
	{   620, -3217,  8831, -18818,  8622, -14203, 21506, -30301,  9987, -12326, 14163, -14919,  6941, -5122,  1580,  4080, -6086, 11433, -18056, 25792, -17154, 21542, -25699, 29173, -15714, 15936, -14944, 12438, -4076,   941,  3246, -8485,  7355, -10888, 14726, -18710, 11318, -13128, 14636, -15667,  8004, -7692,  6697, -4681,   117,   811, -3242, 28799, },
	{  3373, -7620, 13998, -22445,  8072, -10503, 12263, -12418,  2438,  -704, -2491,  7529, -7361, 12121, -18020, 24884, -16176, 19927, -23296, 25776, -13385, 12808, -10818,  7095,  -687, -3261,  8318, -14424, 10710, -14517, 18439, -22221, 12777, -14038, 14694, -14527,  6654, -5398,  3370,  -428, -1800,  4475, -8005, 12753, -2438,  3789, -6578, 18353, },
	{  1994, -3777,  5149, -4937,   355,  1911, -6217, 13246, -5900,  9414, -13853, 19073, -12373, 15161, -17503, 18886, -9343,  8107, -5378,   823,  2913, -7361, 12927, -19502, 13425, -17298, 21109, -24525, 13576, -14273, 14117, -12869,  5151, -3110,   232,  3532, -4100,  6876, -10067, 13629, -8755, 10829, -13019, 15335, -2232,  2607, -3163,  4571, },
	{  1723, -5173, 11701, -22372,  9507, -14743, 21151, -28258,  8794, -10134, 10617, -9660,  3295,  -352, -4334, 11031, -9941, 15425, -21828, 28863, -18039, 21426, -24196, 25884, -12987, 11966, -9620,  5725,   -55, -3654,  8254, -13670,  9876, -13137, 16463, -19657, 11241, -12330, 12934, -12866,  5947, -4856,  2932,   227,  -684,  1890, -4830, 26984, },
	{  3331, -7261, 12754, -19394,  6527, -7746,  7788, -5693,    74,  2422, -6381, 12069, -9818, 14527, -20019, 25999, -15992, 18651, -20544, 21159, -9965,  8137, -4821,  -209,  3549, -7938, 13211, -19219, 12855, -16166, 19312, -22013, 11974, -12381, 12039, -10757,  4170, -2300,  -329,  3818, -4145,  6963, -10511, 15081, -2665,  3862, -6212, 14982, },
	{ -2295,  2241,    51, -6289,  4633, -9743, 17404, -27954, 10357, -14349, 18707, -22987, 13269, -14252, 13923, -11699,  3487,   409, -6066, 13614, -11521, 17075, -23262, 29749, -18037, 20825, -22891, 23845, -11637, 10383, -7969,  4234,   470, -3806,  7884, -12659,  9021, -11951, 15035, -18168, 10616, -12048, 13304, -14299,  1864, -1860,  1637, 30560, },
	{  2561, -6579, 13543, -24172,  9702, -14276, 19423, -24466,  7083, -7380,  6533, -3992,  -417,  4253, -9739, 17001, -13005, 18266, -24037, 29932, -17706, 19897, -21135, 20973, -9474,  7307, -3795, -1201,  3872, -7897, 12598, -17829, 11686, -14466, 17070, -19281, 10422, -10736, 10422, -9291,  3557, -1791,  -888,  4907, -1397,  2765, -5911, 24630, },
	{  3061, -6453, 10777, -15305,  4662, -4658,  3069,  1031, -2171,  5234, -9670, 15613, -11524, 15877, -20622, 25357, -14759, 16186, -16525, 15290, -5991,  3066,  1323, -7297,  7437, -11969, 17106, -22622, 14098, -16706, 18886, -20352, 10396, -9942,  8649, -6363,  1470,   876, -3913,  7699, -6151,  8914, -12237, 16326, -2706,  3680, -5489, 11532, },
	{  -837,  -530,  4615, -13007,  6865, -12408, 20177, -30235, 10570, -13877, 17125, -19787, 10579, -10186,  8226, -4188, -1205,  5978, -12334, 20263, -14795, 19975, -25379, 30601, -17563, 19172, -19784, 19042, -8294,  6050, -2657, -1974,  3936, -7499, 11613, -16175, 10517, -12999, 15411, -17609,  9710, -10316, 10478, -9971,  1043,  -548,  -926, 30087, },
	{  3108, -7396, 14321, -24234,  9244, -12898, 16517, -19269,  4992, -4272,  2206,  1693, -3948,  8395, -14297, 21633, -15104, 19805, -24588, 28991, -16213, 17098, -16764, 14810, -5427,  2286,  2134, -7876,  7447, -11517, 16007, -20712, 12680, -14806, 16534, -17638,  8933, -8472,  7284, -5199,  1002,  1293, -4512,  9066, -1980,  3398, -6490, 21829, },
	{  2616, -5302,  8268, -10535,  2624, -1467, -1566,  7308, -4155,  7562, -12168, 17970, -12399, 16127, -19840, 23066, -12595, 12737, -11546,  8596, -1743, -2057,  7204, -13706, 10728, -15102, 19770, -24444, 14377, -16127, 17221, -17384,  8168, -6901,  4765, -1650, -1264,  3916, -7148, 10969, -7695, 10219, -13100, 16450, -2569,  3272, -4487,  8128, },
	{   494, -2989,  8483, -18358,  8493, -14089, 21460, -30400, 10075, -12512, 14485, -15420,  7301, -5608,  2200,  3329, -5655, 10967, -17588, 25368, -16995, 21471, -25759, 29407, -15941, 16292, -15446, 13096, -4483,  1420,  2707, -7908,  7062, -10610, 14487, -18539, 11283, -13161, 14759, -15902,  8190, -7962,  7070, -5185,   202,   691, -3051, 28951, },
	{  3363, -7627, 14077, -22686,  8207, -10758, 12694, -13090,  2681, -1035, -2067,  7017, -7072, 11819, -17738, 24669, -16133, 19985, -23496, 26164, -13694, 13251, -11408,  7837, -1130, -2756,  7771, -13865, 10443, -14288, 18276, -22157, 12812, -14159, 14917, -14867,  6889, -5703,  3746,  -873, -1545,  4195, -7709, 12456, -2404,  3767, -6592, 18690, },
	{  2055, -3926,  5447, -5460,   562,  1610, -5814, 12749, -5760,  9276, -13746, 19038, -12418, 15303, -17780, 19338, -9677,  8565, -5969,  1547,  2491, -6894, 12440, -19031, 13221, -17154, 21057, -24603, 13698, -14495, 14455, -13334,  5450, -3474,   655,  3062, -3850,  6624, -9830, 13429, -8687, 10810, -13072, 15491, -2271,  2677, -3293,  4889, },
	{  1621, -4997, 11453, -22088,  9448, -14735, 21253, -28554,  8942, -10388, 11011, -10225,  3677,  -839, -3745, 10356, -9578, 15065, -21510, 28639, -18005, 21504, -24425, 26301, -13307, 12410, -10196,  6431,  -468, -3194,  7766, -13180,  9648, -12947, 16336, -19621, 11284, -12450, 13149, -13193,  6176, -5161,  3325,  -271,  -605,  1788, -4690, 27197, },
	{  3347, -7320, 12919, -19761,  6703, -8048,  8264, -6391,   314,  2112, -6006, 11645, -9599, 14327, -19878, 25966, -16061, 18839, -20889, 21697, -10346,  8640, -5450,   539,  3126, -7484, 12751, -18787, 12675, -16047, 19282, -22102, 12093, -12589, 12349, -11177,  4438, -2625,    49,  3395, -3918,  6730, -10287, 14891, -2650,  3867, -6267, 15333, },
	{ -2447,  2536,  -446, -5537,  4374, -9418, 17039, -27601, 10294, -14344, 18803, -23237, 13503, -14627, 14472, -12448,  3970,  -181, -5381, 12860, -11131, 16704, -22949, 29545, -18017, 20919, -23130, 24259, -11944, 10798, -8497,  4870,   104, -3403,  7462, -12240,  8829, -11795, 14937, -18157, 10671, -12184, 13553, -14705,  1945, -1995,  1922, 30570, },
	{  2488, -6462, 13403, -24069,  9713, -14368, 19659, -24926,  7278, -7682,  6969, -4580,   -41,  3797, -9219, 16445, -12733, 18032, -23886, 29916, -17795, 20115, -21514, 21541, -9863,  7807, -4404,  -495,  3481, -7486, 12192, -17458, 11536, -14374, 17061, -19379, 10538, -10933, 10712, -9686,  3813, -2110,  -501,  4446, -1329,  2686, -5824, 24894, },
	{  3098, -6554, 11008, -15762,  4864, -4984,  3555,   354, -1950,  4965, -9366, 15301, -11387, 15789, -20625, 25502, -14931, 16488, -16987, 15938, -6416,  3595,   698, -6594,  7062, -11593, 16760, -22343, 14014, -16703, 18988, -20586, 10591, -10223,  9024, -6834,  1751,   553, -3557,  7325, -5965,  8742, -12099, 16250, -2710,  3710, -5577, 11885, },
	{  -983,  -258,  4175, -12376,  6663, -12179, 19960, -30099, 10581, -13968, 17339, -20174, 10885, -10632,  8833, -4967,  -730,  5427, -11732, 19646, -14506, 19740, -25241, 30609, -17666, 19401, -20164, 19593, -8663,  6514, -3210, -1343,  3593, -7143, 11266, -15864, 10397, -12932, 15420, -17721,  9833, -10525, 10799, -10441,  1129,  -681,  -683, 30167, },
	{  3066, -7339, 14289, -24304,  9319, -13078, 16862, -19855,  5220, -4601,  2653,  1120, -3601,  7999, -13877, 21228, -14937, 19709, -24608, 29177, -16416, 17438, -17263, 15487, -5859,  2808,  1533, -7216,  7104, -11181, 15707, -20481, 12617, -14817, 16641, -17862,  9114, -8731,  7629, -5634,  1267,   982, -4156,  8671, -1927,  3345, -6453, 22133, },
	{  2668, -5432,  8544, -11045,  2837, -1792, -1103,  6697, -3967,  7350, -11952, 17787, -12348, 16152, -19982, 23372, -12855, 13129, -12091,  9307, -2183, -1539,  6624, -13092, 10424, -14828, 19558, -24333, 14393, -16237, 17445, -17742,  8422, -7235,  5178, -2139,  -988,  3616, -6838, 10668, -7560, 10117, -13053, 16489, -2591,  3323, -4600,  8471, },
	{   366, -2755,  8125, -17881,  8356, -13964, 21397, -30479, 10157, -12690, 14799, -15912,  7657, -6092,  2821,  2573, -5219, 10491, -17105, 24925, -16822, 21385, -25800, 29621, -16156, 16638, -15939, 13747, -4888,  1900,  2165, -7324,  6763, -10324, 14237, -18354, 11239, -13186, 14872, -16126,  8371, -8227,  7440, -5687,   287,   569, -2854, 29097, },
	{  3350, -7630, 14146, -22913,  8337, -11008, 13120, -13755,  2924, -1367, -1640,  6498, -6776, 11507, -17443, 24436, -16078, 20029, -23681, 26534, -13994, 13686, -11992,  8576, -1574, -2248,  7217, -13294, 10169, -14048, 18100, -22078, 12838, -14269, 15129, -15198,  7120, -6005,  4120, -1319, -1290,  3911, -7407, 12150, -2369,  3741, -6602, 19024, },
	{  2116, -4074,  5744, -5984,   771,  1305, -5404, 12239, -5616,  9132, -13629, 18989, -12455, 15434, -18046, 19778, -10005,  9017, -6557,  2272,  2066, -6420, 11943, -18545, 13007, -16997, 20991, -24663, 13810, -14708, 14784, -13791,  5746, -3836,  1079,  2588, -3597,  6367, -9585, 13218, -8612, 10783, -13115, 15637, -2308,  2745, -3422,  5210, },
	{  1517, -4815, 11194, -21784,  9382, -14716, 21341, -28830,  9085, -10636, 11398, -10785,  4057, -1327, -3150,  9671, -9208, 14694, -21176, 28394, -17958, 21568, -24637, 26701, -13618, 12847, -10766,  7135,  -881, -2730,  7271, -12680,  9413, -12748, 16197, -19570, 11319, -12562, 13355, -13511,  6401, -5463,  3717,  -771,  -526,  1683, -4545, 27403, },
	{  3360, -7374, 13075, -20116,  6875, -8346,  8737, -7088,   555,  1800, -5625, 11211, -9372, 14116, -19722, 25915, -16118, 19015, -21220, 22221, -10721,  9139, -6077,  1288,  2700, -7022, 12280, -18340, 12486, -15917, 19239, -22177, 12205, -12789, 12651, -11591,  4703, -2948,   428,  2968, -3687,  6492, -10056, 14689, -2633,  3869, -6318, 15684, },
	{  1504, -2600,  2833,  -948, -1194,  4110, -9085, 16659, -6807, 10223, -14328, 18886, -11736, 13728, -14994, 15013, -6596,  4451,  -773, -4689,  6047, -10732, 16319, -22620, 14659, -17985, 20998, -23353, 12328, -12242, 11207, -9019,  2752,  -263, -2997,  7034, -5906,  8630, -11630, 14829, -9067, 10719, -12313, 13792, -1888,  2024, -2130,  2211, },
	{  2412, -6338, 13252, -23947,  9717, -14450, 19881, -25371,  7469, -7981,  7401, -5168,   338,  3337, -8689, 15875, -12451, 17786, -23718, 29879, -17872, 20320, -21879, 22095, -10247,  8303, -5012,   214,  3087, -7069, 11776, -17073, 11379, -14272, 17040, -19464, 10647, -11123, 10995, -10075,  4066, -2429,  -113,  3980, -1260,  2604, -5731, 25153, },
	{  3132, -6651, 11233, -16212,  5063, -5307,  4041,  -326, -1727,  4691, -9055, 14978, -11240, 15690, -20613, 25629, -15093, 16780, -17438, 16576, -6838,  4122,    71, -5884,  6681, -11208, 16401, -22048, 13920, -16687, 19078, -20805, 10778, -10498,  9393, -7301,  2032,   229, -3199,  6945, -5774,  8564, -11952, 16162, -2713,  3737, -5663, 12240, },
	{ -1129,    18,  3727, -11730,  6454, -11939, 19728, -29940, 10585, -14050, 17542, -20548, 11186, -11072,  9435, -5746,  -252,  4871, -11119, 19013, -14206, 19491, -25085, 30595, -17757, 19617, -20531, 20133, -9026,  6974, -3763,  -710,  3246, -6781, 10911, -15542, 10268, -12855, 15418, -17820,  9949, -10727, 11113, -10906,  1215,  -814,  -434, 30240, },
	{  3020, -7277, 14247, -24358,  9388, -13249, 17197, -20430,  5444, -4928,  3099,   544, -3250,  7596, -13445, 20807, -14759, 19600, -24611, 29344, -16608, 17766, -17752, 16155, -6287,  3329,   929, -6549,  6754, -10837, 15395, -20234, 12546, -14818, 16736, -18073,  9288, -8984,  7968, -6066,  1531,   669, -3796,  8268, -1873,  3289, -6411, 22435, },
	{  2719, -5560,  8816, -11551,  3049, -2119,  -637,  6077, -3775,  7131, -11727, 17590, -12289, 16165, -20110, 23662, -13107, 13513, -12629, 10014, -2623, -1019,  6038, -12468, 10112, -14542, 19332, -24205, 14399, -16335, 17658, -18089,  8671, -7564,  5589, -2628,  -710,  3313, -6523, 10359, -7421, 10008, -12996, 16515, -2611,  3372, -4711,  8816, },
	{   236, -2517,  7757, -17386,  8212, -13828, 21319, -30536, 10232, -12859, 15103, -16395,  8010, -6573,  3443,  1811, -4777, 10007, -16609, 24463, -16638, 21283, -25823, 29814, -16361, 16973, -16422, 14389, -5291,  2379,  1620, -6733,  6459, -10029, 13976, -18155, 11188, -13200, 14974, -16340,  8547, -8487,  7805, -6188,   373,   446, -2653, 29237, },
	{  3334, -7626, 14206, -23125,  8462, -11251, 13539, -14415,  3165, -1699, -1209,  5972, -6474, 11186, -17134, 24185, -16012, 20058, -23849, 26887, -14285, 14112, -12569,  9310, -2018, -1736,  6657, -12712,  9886, -13798, 17911, -21983, 12856, -14370, 15331, -15518,  7347, -6303,  4493, -1765, -1032,  3624, -7098, 11834, -2331,  3713, -6608, 19355, },
	{  2177, -4220,  6040, -6508,   980,   998, -4988, 11718, -5466,  8980, -13501, 18926, -12483, 15555, -18299, 20207, -10327,  9465, -7143,  2998,  1638, -5941, 11435, -18044, 12783, -16828, 20909, -24706, 13913, -14910, 15103, -14239,  6039, -4197,  1503,  2111, -3340,  6104, -9333, 12998, -8531, 10749, -13150, 15772, -2344,  2812, -3549,  5535, },
	{  1410, -4627, 10924, -21463,  9308, -14686, 21414, -29087,  9222, -10878, 11779, -11340,  4436, -1817, -2551,  8977, -8829, 14310, -20826, 28127, -17897, 21616, -24833, 27083, -13921, 13275, -11330,  7835, -1295, -2264,  6769, -12170,  9170, -12539, 16046, -19506, 11346, -12665, 13552, -13821,  6623, -5762,  4108, -1273,  -445,  1577, -4395, 27604, },
	{  3371, -7424, 13224, -20459,  7043, -8640,  9206, -7784,   796,  1484, -5238, 10767, -9137, 13895, -19551, 25845, -16164, 19177, -21538, 22731, -11089,  9633, -6702,  2038,  2270, -6555, 11799, -17880, 12287, -15774, 19182, -22235, 12308, -12981, 12945, -11997,  4966, -3271,   808,  2538, -3453,  6248, -9817, 14476, -2614,  3868, -6366, 16033, },
	{  1568, -2753,  3130, -1453, -1001,  3841, -8742, 16265, -6707, 10144, -14302, 18955, -11846, 13944, -15352, 15546, -6964,  4931, -1366, -3992,  5659, -10324, 15922, -22273, 14536, -17940, 21063, -23560, 12518, -12533, 11609, -9537,  3068,  -630, -2588,  6599, -5688,  8425, -11456, 14710, -9048, 10758, -12433, 14023, -1936,  2103, -2266,  2504, },
	{  2333, -6209, 13089, -23807,  9714, -14522, 20091, -25800,  7656, -8275,  7830, -5755,   717,  2872, -8152, 15292, -12158, 17525, -23532, 29820, -17937, 20511, -22230, 22636, -10624,  8795, -5617,   924,  2689, -6646, 11350, -16676, 11212, -14160, 17006, -19536, 10749, -11305, 11271, -10458,  4318, -2746,   278,  3510, -1189,  2520, -5633, 25407, },
	{  3165, -6744, 11452, -16653,  5261, -5630,  4527, -1011, -1502,  4413, -8735, 14642, -11085, 15578, -20586, 25738, -15244, 17060, -17879, 17205, -7257,  4649,  -559, -5168,  6293, -10814, 16030, -21737, 13817, -16660, 19153, -21011, 10958, -10765,  9757, -7764,  2313,   -97, -2837,  6559, -5578,  8378, -11795, 16062, -2713,  3762, -5745, 12594, },
	{ -1277,   297,  3273, -11071,  6238, -11689, 19480, -29760, 10582, -14122, 17733, -20910, 11479, -11506, 10033, -6524,   227,  4310, -10497, 18365, -13895, 19227, -24911, 30560, -17836, 19819, -20884, 20659, -9384,  7430, -4314,   -75,  2896, -6414, 10547, -15207, 10132, -12770, 15406, -17908, 10059, -10922, 11420, -11366,  1300,  -948,  -182, 30305, },
	{  2971, -7208, 14194, -24394,  9451, -13411, 17522, -20993,  5667, -5253,  3546,   -35, -2895,  7186, -13002, 20368, -14569, 19475, -24596, 29490, -16789, 18083, -18230, 16814, -6712,  3849,   323, -5876,  6399, -10484, 15072, -19973, 12465, -14808, 16819, -18272,  9456, -9231,  8303, -6496,  1795,   354, -3432,  7858, -1816,  3231, -6364, 22732, },
	{  2768, -5686,  9084, -12053,  3260, -2446,  -167,  5449, -3580,  6906, -11492, 17379, -12221, 16167, -20223, 23936, -13350, 13888, -13159, 10716, -3062,  -496,  5446, -11832,  9792, -14246, 19092, -24059, 14395, -16422, 17858, -18424,  8914, -7888,  5997, -3115,  -431,  3007, -6203, 10041, -7275,  9891, -12930, 16531, -2629,  3420, -4820,  9163, },
	{   103, -2275,  7380, -16875,  8061, -13681, 21226, -30571, 10300, -13020, 15398, -16868,  8358, -7052,  4065,  1046, -4330,  9513, -16100, 23982, -16441, 21166, -25828, 29987, -16555, 17297, -16894, 15023, -5690,  2858,  1073, -6136,  6149, -9727, 13705, -17943, 11128, -13206, 15066, -16542,  8717, -8743,  8167, -6686,   460,   322, -2447, 29369, },
	{  3315, -7616, 14255, -23322,  8582, -11487, 13950, -15068,  3406, -2032,  -775,  5439, -6166, 10855, -16811, 23916, -15934, 20074, -24002, 27222, -14567, 14530, -13138, 10040, -2462, -1223,  6090, -12119,  9595, -13537, 17708, -21872, 12864, -14460, 15523, -15829,  7569, -6598,  4863, -2211,  -773,  3333, -6783, 11508, -2292,  3682, -6609, 19684, },
	{  2236, -4366,  6335, -7032,  1191,   688, -4565, 11185, -5312,  8820, -13363, 18849, -12502, 15666, -18541, 20622, -10643,  9908, -7726,  3725,  1207, -5456, 10919, -17529, 12549, -16646, 20813, -24731, 14006, -15103, 15412, -14679,  6327, -4556,  1927,  1631, -3081,  5837, -9074, 12768, -8444, 10706, -13175, 15897, -2378,  2877, -3676,  5861, },
	{  1300, -4433, 10644, -21123,  9228, -14646, 21471, -29325,  9353, -11113, 12153, -11889,  4814, -2307, -1948,  8274, -8443, 13915, -20460, 27840, -17824, 21649, -25012, 27447, -14214, 13695, -11887,  8531, -1709, -1794,  6262, -11650,  8921, -12320, 15883, -19428, 11365, -12759, 13740, -14122,  6840, -6059,  4498, -1777,  -364,  1469, -4239, 27799, },
	{  3379, -7468, 13364, -20791,  7208, -8930,  9672, -8479,  1039,  1166, -4845, 10313, -8894, 13662, -19366, 25756, -16199, 19327, -21841, 23227, -11450, 10121, -7323,  2789,  1838, -6081, 11309, -17406, 12079, -15621, 19111, -22279, 12402, -13164, 13230, -12395,  5226, -3592,  1188,  2105, -3216,  5999, -9570, 14252, -2594,  3864, -6409, 16382, },
	{  1632, -2906,  3429, -1962,  -805,  3567, -8391, 15857, -6603, 10058, -14265, 19011, -11948, 14152, -15700, 16070, -7329,  5409, -1961, -3290,  5265, -9908, 15512, -21909, 14401, -17881, 21113, -23751, 12700, -12816, 12003, -10049,  3382,  -998, -2176,  6159, -5464,  8213, -11274, 14580, -9024, 10791, -12545, 14245, -1984,  2181, -2400,  2800, },
	{  2251, -6073, 12916, -23648,  9704, -14585, 20288, -26213,  7839, -8565,  8255, -6341,  1098,  2403, -7606, 14695, -11856, 17251, -23329, 29740, -17988, 20688, -22565, 23162, -10995,  9281, -6220,  1636,  2289, -6217, 10915, -16265, 11037, -14038, 16960, -19593, 10844, -11479, 11540, -10835,  4567, -3063,   669,  3034, -1118,  2433, -5529, 25656, },
	{  3196, -6833, 11665, -17086,  5456, -5950,  5013, -1698, -1274,  4130, -8407, 14293, -10922, 15456, -20545, 25829, -15386, 17329, -18309, 17823, -7671,  5173, -1189, -4446,  5901, -10411, 15646, -21409, 13703, -16621, 19216, -21202, 11130, -11026, 10114, -8222,  2592,  -423, -2472,  6168, -5378,  8187, -11630, 15950, -2711,  3784, -5824, 12948, },
	{ -1425,   578,  2813, -10398,  6017, -11428, 19216, -29556, 10570, -14184, 17913, -21258, 11766, -11934, 10627, -7299,   708,  3743, -9865, 17701, -13573, 18949, -24718, 30502, -17902, 20009, -21224, 21172, -9737,  7881, -4863,   563,  2543, -6041, 10174, -14861,  9988, -12675, 15382, -17983, 10162, -11110, 11721, -11820,  1385, -1082,    76, 30363, },
	{  2919, -7133, 14129, -24413,  9507, -13565, 17836, -21545,  5886, -5576,  3992,  -616, -2537,  6769, -12549, 19914, -14368, 19337, -24564, 29615, -16959, 18387, -18696, 17463, -7134,  4368,  -285, -5197,  6038, -10123, 14737, -19697, 12375, -14787, 16890, -18458,  9618, -9472,  8633, -6922,  2059,    39, -3064,  7440, -1759,  3169, -6312, 23025, },
	{  2816, -5808,  9348, -12551,  3471, -2774,   306,  4814, -3381,  6675, -11248, 17155, -12143, 16158, -20323, 24194, -13585, 14256, -13683, 11413, -3500,    29,  4848, -11186,  9464, -13938, 18837, -23895, 14380, -16497, 18047, -18747,  9151, -8208,  6401, -3602,  -150,  2698, -5877,  9715, -7124,  9767, -12854, 16534, -2646,  3465, -4927,  9511, },
	{   -31, -2028,  6995, -16347,  7904, -13523, 21116, -30585, 10360, -13172, 15683, -17332,  8702, -7528,  4686,   277, -3878,  9011, -15577, 23482, -16232, 21033, -25814, 30139, -16738, 17609, -17356, 15648, -6087,  3336,   523, -5533,  5834, -9417, 13424, -17718, 11061, -13202, 15148, -16733,  8881, -8992,  8524, -7182,   546,   196, -2236, 29495, },
	{  3293, -7601, 14295, -23503,  8696, -11717, 14354, -15714,  3646, -2365,  -339,  4899, -5853, 10515, -16475, 23629, -15844, 20075, -24137, 27539, -14840, 14939, -13701, 10765, -2905,  -707,  5518, -11517,  9297, -13266, 17493, -21745, 12863, -14541, 15704, -16129,  7786, -6888,  5231, -2657,  -512,  3039, -6463, 11172, -2251,  3648, -6605, 20011, },
	{  2295, -4510,  6628, -7555,  1402,   375, -4136, 10640, -5154,  8654, -13215, 18759, -12513, 15766, -18770, 21024, -10952, 10345, -8305,  4451,   774, -4965, 10392, -17000, 12305, -16452, 20701, -24739, 14089, -15285, 15711, -15109,  6613, -4912,  2351,  1149, -2818,  5565, -8808, 12528, -8351, 10656, -13190, 16011, -2411,  2941, -3801,  6191, },
	{  1188, -4234, 10353, -20765,  9140, -14595, 21514, -29542,  9478, -11341, 12521, -12432,  5189, -2797, -1341,  7563, -8049, 13509, -20078, 27532, -17738, 21667, -25173, 27793, -14498, 14107, -12438,  9224, -2123, -1323,  5749, -11120,  8664, -12092, 15709, -19336, 11376, -12844, 13918, -14414,  7053, -6352,  4886, -2281,  -282,  1359, -4078, 27987, },
	{  3384, -7507, 13495, -21110,  7368, -9215, 10134, -9171,  1282,   846, -4447,  9850, -8645, 13419, -19166, 25648, -16222, 19464, -22130, 23708, -11805, 10604, -7941,  3541,  1403, -5602, 10809, -16918, 11862, -15455, 19026, -22306, 12488, -13338, 13506, -12786,  5482, -3912,  1569,  1669, -2976,  5745, -9315, 14017, -2571,  3858, -6448, 16729, },
	{  1695, -3058,  3728, -2474,  -608,  3289, -8032, 15434, -6493,  9964, -14218, 19054, -12041, 14350, -16038, 16584, -7690,  5886, -2556, -2583,  4867, -9483, 15090, -21529, 14256, -17810, 21148, -23925, 12874, -13091, 12390, -10556,  3695, -1366, -1762,  5713, -5237,  7995, -11084, 14440, -8992, 10816, -12648, 14457, -2030,  2258, -2535,  3100, },
	{  2166, -5931, 12731, -23470,  9687, -14637, 20471, -26610,  8017, -8850,  8677, -6925,  1479,  1931, -7053, 14086, -11545, 16964, -23108, 29638, -18028, 20851, -22886, 23673, -11359,  9763, -6821,  2348,  1886, -5783, 10472, -15842, 10855, -13905, 16903, -19637, 10931, -11646, 11801, -11206,  4814, -3379,  1062,  2554, -1045,  2344, -5420, 25899, },
	{  3225, -6918, 11871, -17511,  5649, -6269,  5499, -2389, -1044,  3842, -8072, 13934, -10749, 15321, -20489, 25902, -15516, 17587, -18727, 18431, -8082,  5695, -1821, -3719,  5503, -10000, 15250, -21065, 13579, -16570, 19265, -21378, 11295, -11280, 10465, -8676,  2870,  -749, -2104,  5770, -5173,  7988, -11456, 15827, -2708,  3804, -5899, 13303, },
	{ -1575,   862,  2346, -9712,  5790, -11158, 18937, -29331, 10551, -14237, 18080, -21593, 12046, -12355, 11215, -8073,  1190,  3172, -9223, 17023, -13240, 18656, -24507, 30423, -17956, 20184, -21549, 21672, -10083,  8329, -5410,  1201,  2188, -5663,  9794, -14504,  9837, -12570, 15348, -18045, 10258, -11291, 12014, -12268,  1470, -1217,   337, 30414, },
	{  2864, -7052, 14054, -24414,  9557, -13711, 18140, -22085,  6102, -5896,  4437, -1200, -2175,  6346, -12084, 19444, -14157, 19184, -24514, 29720, -17117, 18680, -19150, 18101, -7552,  4885,  -895, -4513,  5673, -9754, 14390, -19406, 12276, -14756, 16950, -18632,  9774, -9707,  8958, -7344,  2322,  -278, -2693,  7015, -1699,  3105, -6255, 23315, },
	{  2862, -5928,  9608, -13043,  3681, -3102,   781,  4171, -3178,  6438, -10995, 16918, -12057, 16137, -20409, 24436, -13811, 14614, -14198, 12104, -3938,   555,  4245, -10531,  9129, -13620, 18569, -23715, 14355, -16561, 18223, -19057,  9383, -8523,  6802, -4087,   130,  2386, -5546,  9382, -6967,  9636, -12769, 16526, -2661,  3507, -5031,  9860, },
	{  -168, -1777,  6600, -15804,  7739, -13355, 20990, -30577, 10414, -13316, 15959, -17785,  9041, -8000,  5306,  -495, -3422,  8501, -15042, 22964, -16010, 20885, -25782, 30270, -16909, 17910, -17806, 16263, -6480,  3812,   -28, -4924,  5515, -9100, 13132, -17480, 10985, -13189, 15219, -16913,  9040, -9237,  8876, -7676,   632,    69, -2019, 29615, },
	{  3268, -7580, 14324, -23669,  8805, -11940, 14751, -16353,  3884, -2698,   100,  4354, -5534, 10167, -16126, 23323, -15743, 20062, -24256, 27837, -15103, 15338, -14255, 11485, -3347,  -189,  4940, -10905,  8992, -12985, 17264, -21602, 12853, -14611, 15875, -16418,  7998, -7175,  5596, -3102,  -251,  2742, -6136, 10827, -2208,  3611, -6597, 20334, },
	{  2353, -4652,  6919, -8078,  1614,    59, -3701, 10085, -4990,  8480, -13057, 18654, -12514, 15855, -18987, 21413, -11255, 10777, -8880,  5177,   339, -4470,  9857, -16458, 12053, -16245, 20574, -24730, 14163, -15457, 15999, -15529,  6894, -5265,  2774,   665, -2553,  5288, -8535, 12279, -8251, 10598, -13197, 16114, -2442,  3003, -3924,  6522, },
	{  1073, -4030, 10051, -20388,  9044, -14533, 21541, -29740,  9597, -11562, 12881, -12969,  5563, -3288,  -731,  6843, -7649, 13091, -19681, 27204, -17639, 21670, -25317, 28119, -14773, 14510, -12981,  9911, -2536,  -849,  5231, -10581,  8400, -11855, 15524, -19230, 11379, -12921, 14087, -14696,  7262, -6641,  5272, -2786,  -199,  1247, -3912, 28170, },
	{  3387, -7541, 13618, -21416,  7525, -9496, 10592, -9862,  1525,   523, -4044,  9378, -8388, 13165, -18951, 25522, -16234, 19587, -22404, 24173, -12152, 11080, -8556,  4292,   966, -5118, 10300, -16416, 11636, -15279, 18928, -22318, 12565, -13503, 13774, -13169,  5736, -4229,  1949,  1231, -2733,  5486, -9053, 13771, -2547,  3849, -6484, 17074, },
	{  1759, -3211,  4027, -2988,  -408,  3006, -7664, 14999, -6378,  9862, -14161, 19084, -12127, 14539, -16367, 17088, -8047,  6359, -3151, -1872,  4463, -9050, 14656, -21132, 14101, -17727, 21168, -24083, 13038, -13356, 12770, -11056,  4006, -1735, -1345,  5263, -5005,  7770, -10885, 14289, -8954, 10833, -12743, 14660, -2075,  2334, -2668,  3404, },
	{  2078, -5782, 12535, -23274,  9662, -14679, 20640, -26990,  8190, -9130,  9094, -7507,  1862,  1456, -6493, 13465, -11224, 16664, -22871, 29515, -18054, 20999, -23191, 24168, -11716, 10238, -7418,  3061,  1481, -5343, 10020, -15407, 10663, -13762, 16833, -19667, 11011, -11805, 12055, -11569,  5058, -3693,  1455,  2071,  -971,  2253, -5306, 26138, },
	{  3251, -6998, 12070, -17926,  5840, -6585,  5984, -3082,  -812,  3550, -7729, 13562, -10569, 15175, -20418, 25957, -15637, 17834, -19133, 19028, -8488,  6215, -2453, -2987,  5100, -9580, 14842, -20705, 13445, -16507, 19300, -21540, 11453, -11526, 10810, -9125,  3147, -1076, -1734,  5368, -4964,  7784, -11273, 15691, -2702,  3821, -5972, 13657, },
	{ -1725,  1148,  1873, -9013,  5557, -10878, 18643, -29083, 10525, -14279, 18236, -21913, 12318, -12769, 11797, -8844,  1673,  2597, -8573, 16331, -12897, 18349, -24278, 30322, -17997, 20345, -21859, 22157, -10423,  8771, -5955,  1840,  1830, -5281,  9406, -14136,  9679, -12457, 15303, -18095, 10346, -11465, 12301, -12709,  1554, -1352,   603, 30459, },
	{  2806, -6964, 13967, -24397,  9600, -13847, 18432, -22611,  6315, -6214,  4882, -1786, -1810,  5916, -11609, 18958, -13934, 19017, -24447, 29804, -17263, 18960, -19592, 18728, -7965,  5400, -1505, -3823,  5302, -9377, 14033, -19100, 12169, -14715, 16998, -18793,  9923, -9936,  9277, -7763,  2584,  -596, -2318,  6583, -1638,  3039, -6192, 23600, },
	{  2907, -6045,  9863, -13531,  3890, -3431,  1259,  3521, -2972,  6195, -10733, 16667, -11962, 16104, -20481, 24662, -14028, 14963, -14705, 12788, -4374,  1083,  3637, -9866,  8786, -13292, 18286, -23517, 14320, -16614, 18386, -19355,  9608, -8832,  7199, -4571,   412,  2072, -5210,  9041, -6805,  9497, -12674, 16506, -2674,  3548, -5132, 10210, },
	{  -306, -1521,  6197, -15244,  7568, -13175, 20849, -30546, 10461, -13451, 16224, -18228,  9375, -8469,  5925, -1270, -2962,  7983, -14494, 22428, -15776, 20722, -25732, 30380, -17069, 18199, -18246, 16868, -6870,  4288,  -580, -4311,  5191, -8776, 12830, -17229, 10901, -13167, 15279, -17082,  9192, -9475,  9223, -8166,   719,   -59, -1798, 29727, },
	{  3240, -7552, 14343, -23818,  8908, -12156, 15139, -16984,  4121, -3030,   540,  3803, -5209,  9809, -15765, 23000, -15630, 20035, -24358, 28116, -15356, 15728, -14800, 12198, -3788,   331,  4357, -10283,  8679, -12693, 17023, -21444, 12834, -14672, 16034, -16696,  8205, -7457,  5958, -3547,    12,  2442, -5804, 10473, -2163,  3572, -6583, 20655, },
	{  2411, -4792,  7208, -8599,  1826,  -258, -3261,  9519, -4823,  8300, -12888, 18536, -12507, 15933, -19191, 21788, -11551, 11202, -9451,  5901,   -97, -3969,  9313, -15902, 11791, -16027, 20433, -24702, 14227, -15618, 16277, -15939,  7171, -5616,  3196,   179, -2286,  5007, -8255, 12020, -8145, 10533, -13194, 16205, -2472,  3063, -4046,  6856, },
	{   955, -3820,  9740, -19994,  8942, -14460, 21553, -29918,  9710, -11776, 13234, -13500,  5934, -3778,  -118,  6116, -7241, 12663, -19268, 26855, -17527, 21657, -25443, 28427, -15038, 14904, -13516, 10593, -2948,  -373,  4707, -10034,  8130, -11609, 15326, -19111, 11374, -12989, 14247, -14969,  7467, -6927,  5656, -3292,  -115,  1133, -3740, 28346, },
	{  3387, -7569, 13732, -21709,  7677, -9772, 11045, -10549,  1769,   198, -3636,  8896, -8123, 12901, -18722, 25378, -16235, 19696, -22663, 24623, -12492, 11551, -9166,  5042,   527, -4629,  9783, -15902, 11401, -15091, 18816, -22314, 12634, -13658, 14032, -13543,  5986, -4544,  2329,   791, -2487,  5223, -8783, 13514, -2520,  3837, -6515, 17418, },
	{  1822, -3363,  4326, -3506,  -207,  2719, -7289, 14549, -6257,  9753, -14093, 19100, -12204, 14718, -16684, 17582, -8399,  6830, -3746, -1158,  4055, -8610, 14211, -20719, 13935, -17630, 21173, -24224, 13194, -13614, 13141, -11549,  4315, -2102,  -927,  4807, -4769,  7540, -10678, 14127, -8910, 10843, -12829, 14854, -2119,  2409, -2801,  3710, },
	{  1987, -5628, 12328, -23059,  9631, -14710, 20796, -27353,  8358, -9406,  9507, -8085,  2244,   977, -5926, 12831, -10894, 16351, -22616, 29370, -18068, 21133, -23481, 24648, -12065, 10708, -8011,  3773,  1073, -4899,  9559, -14959, 10464, -13609, 16751, -19684, 11083, -11956, 12300, -11925,  5299, -4006,  1849,  1583,  -896,  2159, -5187, 26371, },
	{  3276, -7075, 12263, -18331,  6027, -6899,  6467, -3777,  -578,  3255, -7379, 13179, -10380, 15018, -20332, 25993, -15747, 18068, -19526, 19613, -8889,  6733, -3085, -2251,  4692, -9153, 14423, -20330, 13301, -16433, 19322, -21687, 11603, -11765, 11148, -9568,  3423, -1402, -1362,  4961, -4751,  7573, -11081, 15545, -2695,  3836, -6041, 14011, },
	{ -1876,  1437,  1394, -8303,  5318, -10589, 18333, -28812, 10491, -14312, 18379, -22220, 12582, -13175, 12373, -9611,  2157,  2018, -7915, 15624, -12543, 18028, -24032, 30199, -18025, 20493, -22155, 22628, -10756,  9209, -6497,  2479,  1469, -4893,  9010, -13756,  9513, -12334, 15246, -18132, 10428, -11631, 12579, -13143,  1638, -1487,   873, 30495, },
	{  2745, -6870, 13869, -24362,  9637, -13974, 18712, -23125,  6525, -6530,  5325, -2373, -1442,  5480, -11123, 18457, -13701, 18836, -24362, 29867, -17398, 19228, -20022, 19343, -8374,  5913, -2116, -3129,  4926, -8992, 13665, -18781, 12052, -14663, 17034, -18941, 10066, -10159,  9591, -8177,  2846,  -914, -1941,  6144, -1576,  2969, -6124, 23881, },
	{  2951, -6158, 10114, -14013,  4098, -3759,  1740,  2865, -2763,  5946, -10461, 16404, -11857, 16059, -20538, 24871, -14236, 15303, -15203, 13466, -4808,  1612,  3025, -9192,  8435, -12953, 17990, -23302, 14275, -16655, 18537, -19639,  9827, -9136,  7592, -5052,   694,  1756, -4870,  8693, -6638,  9352, -12571, 16474, -2685,  3587, -5231, 10562, },
	{  -445, -1262,  5786, -14668,  7389, -12985, 20692, -30494, 10500, -13577, 16479, -18660,  9704, -8933,  6542, -2046, -2498,  7458, -13934, 21874, -15531, 20544, -25663, 30468, -17217, 18475, -18673, 17463, -7256,  4761, -1133, -3693,  4862, -8444, 12519, -16965, 10810, -13135, 15329, -17239,  9339, -9708,  9566, -8653,   806,  -188, -1572, 29833, },
	{  3209, -7519, 14352, -23952,  9006, -12364, 15519, -17606,  4356, -3363,   983,  3247, -4879,  9443, -15390, 22660, -15506, 19994, -24443, 28376, -15599, 16108, -15337, 12905, -4228,   851,  3770, -9653,  8360, -12393, 16769, -21270, 12805, -14722, 16183, -16963,  8407, -7734,  6317, -3990,   275,  2139, -5466, 10109, -2117,  3529, -6565, 20972, },
	{  2467, -4931,  7494, -9119,  2039,  -578, -2815,  8943, -4650,  8112, -12710, 18404, -12490, 16000, -19382, 22149, -11840, 11621, -10017,  6623,  -535, -3465,  8761, -15334, 11519, -15796, 20276, -24658, 14281, -15769, 16544, -16339,  7443, -5964,  3617,  -308, -2016,  4721, -7968, 11752, -8033, 10460, -13182, 16286, -2500,  3121, -4166,  7193, },
	{   836, -3606,  9418, -19582,  8832, -14376, 21550, -30075,  9817, -11983, 13579, -14022,  6303, -4268,   498,  5381, -6827, 12225, -18840, 26486, -17403, 21628, -25552, 28716, -15292, 15288, -14043, 11270, -3360,   104,  4180, -9478,  7854, -11355, 15118, -18977, 11361, -13047, 14397, -15232,  7666, -7209,  6037, -3797,   -31,  1017, -3563, 28516, },
	{  3385, -7592, 13837, -21989,  7825, -10043, 11492, -11232,  2012,  -129, -3223,  8406, -7852, 12626, -18479, 25214, -16224, 19792, -22907, 25057, -12823, 12014, -9771,  5790,    87, -4135,  9257, -15376, 11157, -14892, 18691, -22294, 12694, -13805, 14281, -13909,  6232, -4857,  2708,   349, -2239,  4955, -8507, 13246, -2492,  3822, -6541, 17760, },
	{  1885, -3514,  4626, -4025,    -4,  2429, -6906, 14087, -6132,  9636, -14015, 19102, -12273, 14888, -16992, 18066, -8747,  7298, -4341,  -440,  3643, -8162, 13754, -20290, 13759, -17520, 21163, -24349, 13341, -13861, 13503, -12035,  4621, -2469,  -507,  4347, -4529,  7303, -10462, 13955, -8860, 10844, -12906, 15037, -2161,  2482, -2934,  4020, },
	{  1894, -5468, 12110, -22826,  9592, -14731, 20938, -27698,  8521, -9675,  9916, -8661,  2627,   496, -5352, 12186, -10555, 16025, -22344, 29205, -18069, 21252, -23755, 25112, -12407, 11171, -8600,  4484,   664, -4450,  9091, -14500, 10257, -13446, 16657, -19686, 11147, -12099, 12538, -12274,  5537, -4317,  2243,  1093,  -820,  2063, -5062, 26599, },
	{  3298, -7147, 12448, -18727,  6212, -7210,  6949, -4473,  -342,  2955, -7022, 12785, -10183, 14849, -20231, 26011, -15845, 18291, -19908, 20186, -9285,  7247, -3717, -1511,  4280, -8717, 13992, -19939, 13147, -16346, 19330, -21818, 11745, -11996, 11478, -10006,  3696, -1729,  -988,  4549, -4534,  7356, -10881, 15386, -2686,  3848, -6106, 14365, },
	{ -2028,  1728,   910, -7580,  5073, -10289, 18009, -28520, 10449, -14334, 18509, -22511, 12839, -13573, 12943, -10374,  2641,  1435, -7249, 14904, -12180, 17693, -23767, 30054, -18040, 20626, -22436, 23084, -11083,  9641, -7036,  3118,  1107, -4501,  8607, -13366,  9340, -12203, 15179, -18157, 10503, -11789, 12850, -13570,  1721, -1622,  1147, 30525, },
	{  2681, -6770, 13760, -24309,  9666, -14092, 18981, -23625,  6731, -6842,  5766, -2961, -1071,  5038, -10628, 17940, -13457, 18641, -24259, 29910, -17521, 19483, -20438, 19947, -8779,  6423, -2727, -2431,  4546, -8600, 13286, -18447, 11926, -14600, 17058, -19076, 10201, -10375,  9898, -8586,  3106, -1233, -1560,  5700, -1512,  2897, -6051, 24157, },
	{  2992, -6269, 10360, -14488,  4304, -4086,  2222,  2203, -2550,  5692, -10181, 16127, -11744, 16003, -20581, 25063, -14435, 15633, -15692, 14136, -5241,  2141,  2409, -8510,  8078, -12603, 17680, -23069, 14219, -16684, 18675, -19910, 10040, -9434,  7981, -5531,   976,  1437, -4525,  8337, -6465,  9199, -12458, 16431, -2694,  3623, -5327, 10914, },
	{  -587,  -999,  5367, -14077,  7205, -12785, 20518, -30419, 10532, -13694, 16723, -19080, 10027, -9393,  7157, -2825, -2030,  6925, -13362, 21303, -15274, 20350, -25576, 30535, -17354, 18740, -19088, 18047, -7637,  5232, -1687, -3071,  4529, -8106, 12197, -16689, 10710, -13094, 15368, -17384,  9480, -9935,  9902, -9136,   892,  -318, -1341, 29931, },
	{  3175, -7480, 14350, -24069,  9097, -12565, 15890, -18219,  4589, -3694,  1427,  2686, -4545,  9069, -15003, 22302, -15370, 19938, -24510, 28617, -15831, 16477, -15864, 13604, -4666,  1373,  3178, -9014,  8034, -12082, 16503, -21081, 12768, -14761, 16321, -17219,  8603, -8007,  6672, -4431,   539,  1833, -5123,  9737, -2069,  3484, -6542, 21287, },
	{  2522, -5068,  7778, -9636,  2252,  -900, -2365,  8357, -4474,  7918, -12521, 18258, -12465, 16056, -19560, 22495, -12121, 12033, -10578,  7343,  -974, -2956,  8201, -14752, 11239, -15554, 20105, -24595, 14324, -15909, 16800, -16729,  7711, -6308,  4036,  -795, -1744,  4432, -7675, 11475, -7915, 10379, -13161, 16356, -2527,  3178, -4285,  7531, },
	{   714, -3386,  9087, -19152,  8715, -14281, 21531, -30212,  9917, -12182, 13916, -14538,  6669, -4756,  1115,  4640, -6406, 11776, -18397, 26097, -17266, 21585, -25643, 28984, -15537, 15662, -14561, 11940, -3770,   582,  3647, -8913,  7571, -11091, 14898, -18830, 11339, -13097, 14537, -15484,  7861, -7487,  6416, -4302,    53,   900, -3381, 28680, },
	{  3379, -7610, 13932, -22255,  7968, -10308, 11935, -11912,  2256,  -457, -2806,  7908, -7574, 12341, -18222, 25032, -16201, 19874, -23135, 25474, -13147, 12470, -10371,  6537,  -355, -3637,  8723, -14836, 10905, -14682, 18552, -22258, 12745, -13942, 14521, -14265,  6474, -5167,  3087,   -94, -1989,  4682, -8223, 12968, -2462,  3804, -6564, 18100, },
	{  1947, -3664,  4925, -4546,   201,  2134, -6515, 13611, -6001,  9512, -13926, 19091, -12333, 15047, -17288, 18539, -9090,  7762, -4934,   281,  3227, -7707, 13285, -19846, 13572, -17398, 21138, -24456, 13479, -14100, 13857, -12515,  4925, -2836,   -85,  3883, -4285,  7061, -10239, 13773, -8802, 10839, -12974, 15211, -2202,  2554, -3065,  4334, },
	{  1797, -5302, 11881, -22574,  9546, -14742, 21065, -28025,  8679, -9940, 10319, -9233,  3009,    12, -4773, 11530, -10207, 15687, -22055, 29017, -18057, 21357, -24013, 25559, -12742, 11628, -9185,  5194,   253, -3996,  8616, -14030, 10043, -13274, 16550, -19674, 11203, -12234, 12768, -12615,  5773, -4626,  2637,   599,  -743,  1965, -4931, 26821, },
	{  3318, -7214, 12626, -19112,  6393, -7517,  7429, -5170,  -105,  2651, -6658, 12380, -9977, 14669, -20116, 26011, -15933, 18501, -20276, 20747, -9676,  7757, -4349,  -768,  3864, -8275, 13550, -19533, 12984, -16248, 19325, -21935, 11878, -12219, 11802, -10437,  3968, -2055,  -612,  4133, -4314,  7133, -10672, 15216, -2674,  3857, -6168, 14718, },
	{ -2180,  2020,   421, -6847,  4824, -9981, 17669, -28205, 10399, -14347, 18627, -22789, 13088, -13964, 13506, -11133,  3125,   850, -6576, 14172, -11807, 17345, -23485, 29888, -18043, 20746, -22702, 23525, -11402, 10067, -7571,  3756,   744, -4105,  8196, -12966,  9160, -12062, 15101, -18168, 10571, -11940, 13113, -13990,  1803, -1758,  1426, 30548, },
	{  2613, -6663, 13640, -24238,  9689, -14201, 19238, -24111,  6933, -7150,  6205, -3550,  -698,  4592, -10124, 17409, -13203, 18432, -24139, 29931, -17631, 19724, -20841, 20538, -9178,  6929, -3337, -1729,  4162, -8201, 12897, -18099, 11792, -14527, 17069, -19198, 10330, -10584, 10200, -8991,  3364, -1552, -1177,  5249, -1447,  2823, -5973, 24429, },
	{  3032, -6376, 10600, -14958,  4509, -4414,  2706,  1535, -2334,  5432, -9892, 15838, -11622, 15936, -20610, 25238, -14624, 15953, -16172, 14799, -5671,  2670,  1789, -7820,  7714, -12244, 17357, -22820, 14154, -16701, 18801, -20168, 10246, -9727,  8365, -6008,  1258,  1117, -4177,  7975, -6288,  9039, -12335, 16375, -2702,  3657, -5421, 11267, },
	{  -729,  -733,  4940, -13471,  7013, -12573, 20329, -30322, 10556, -13802, 16957, -19488, 10344, -9848,  7769, -3604, -1560,  6386, -12779, 20715, -15005, 20141, -25470, 30581, -17478, 18991, -19491, 18620, -8014,  5701, -2241, -2446,  4192, -7761, 11867, -16400, 10603, -13043, 15397, -17517,  9614, -10155, 10234, -9614,   978,  -449, -1106, 30023, },
	{  3138, -7434, 14337, -24169,  9183, -12759, 16252, -18823,  4820, -4025,  1872,  2120, -4206,  8687, -14604, 21926, -15222, 19867, -24561, 28838, -16054, 16836, -16382, 14296, -5102,  1894,  2583, -8367,  7701, -11763, 16224, -20876, 12721, -14791, 16447, -17463,  8794, -8275,  7023, -4870,   804,  1525, -4776,  9357, -2019,  3436, -6514, 21598, },
	{  2576, -5202,  8059, -10151,  2464, -1223, -1910,  7761, -4293,  7717, -12323, 18099, -12430, 16101, -19725, 22827, -12395, 12438, -11134,  8061, -1413, -2444,  7634, -14159, 10950, -15300, 19919, -24515, 14358, -16038, 17045, -17107,  7974, -6648,  4453, -1284, -1471,  4139, -7376, 11189, -7791, 10290, -13130, 16414, -2552,  3232, -4401,  7871, },
	{   589, -3161,  8745, -18705,  8591, -14175, 21496, -30328, 10010, -12374, 14244, -15045,  7031, -5243,  1735,  3893, -5979, 11317, -17940, 25688, -17115, 21526, -25716, 29233, -15772, 16026, -15070, 12603, -4178,  1061,  3111, -8342,  7283, -10819, 14667, -18668, 11310, -13137, 14668, -15727,  8051, -7760,  6791, -4807,   138,   781, -3194, 28837, },
	{  3371, -7622, 14018, -22507,  8107, -10568, 12371, -12587,  2499,  -787, -2385,  7402, -7290, 12047, -17951, 24832, -16166, 19943, -23347, 25875, -13463, 12919, -10966,  7281,  -798, -3135,  8182, -14285, 10644, -14461, 18399, -22206, 12786, -14069, 14751, -14613,  6713, -5475,  3464,  -539, -1736,  4405, -7932, 12680, -2430,  3784, -6582, 18438, },
	{  2009, -3814,  5224, -5068,   407,  1836, -6117, 13123, -5865,  9380, -13827, 19066, -12385, 15197, -17574, 19000, -9427,  8222, -5526,  1004,  2808, -7245, 12806, -19386, 13375, -17263, 21097, -24546, 13608, -14330, 14202, -12986,  5226, -3201,   338,  3415, -4038,  6813, -10008, 13580, -8739, 10825, -13033, 15375, -2242,  2625, -3196,  4650, },
	{  1698, -5130, 11640, -22303,  9493, -14742, 21178, -28334,  8832, -10198, 10716, -9801,  3391,  -474, -4187, 10863, -9851, 15336, -21750, 28809, -18032, 21447, -24255, 25990, -13068, 12078, -9765,  5902,  -159, -3539,  8133, -13549,  9820, -13091, 16432, -19649, 11252, -12361, 12989, -12948,  6004, -4932,  3030,   103,  -664,  1864, -4796, 27038, },
	{  3335, -7276, 12796, -19487,  6571, -7822,  7907, -5868,   134,  2344, -6288, 11964, -9764, 14478, -19985, 25992, -16010, 18699, -20631, 21295, -10061,  8263, -4979,   -22,  3444, -7825, 13097, -19112, 12811, -16138, 19306, -22036, 12004, -12434, 12118, -10863,  4237, -2381,  -235,  3713, -4089,  6905, -10456, 15034, -2661,  3864, -6226, 15070, },
	{ -2333,  2315,   -73, -6102,  4568, -9663, 17315, -27868, 10342, -14349, 18733, -23051, 13328, -14346, 14061, -11887,  3608,   262, -5895, 13427, -11424, 16984, -23186, 29700, -18033, 20850, -22953, 23950, -11714, 10487, -8101,  4393,   379, -3706,  7779, -12555,  8973, -11913, 15011, -18167, 10631, -12083, 13367, -14402,  1884, -1894,  1708, 30563, },
	{  2543, -6551, 13509, -24148,  9706, -14300, 19483, -24582,  7132, -7456,  6642, -4139,  -323,  4139, -9610, 16864, -12938, 18209, -24001, 29930, -17730, 19953, -21231, 21116, -9571,  7432, -3947, -1025,  3774, -7795, 12498, -17738, 11649, -14444, 17069, -19307, 10452, -10786, 10495, -9390,  3621, -1871,  -792,  4792, -1380,  2745, -5890, 24696, },
	{  3070, -6479, 10835, -15420,  4712, -4740,  3191,   862, -2116,  5167, -9595, 15536, -11491, 15857, -20624, 25395, -14803, 16263, -16641, 15453, -6098,  3199,  1167, -7122,  7344, -11876, 17021, -22554, 14078, -16706, 18913, -20412, 10446, -10013,  8743, -6481,  1540,   795, -3824,  7606, -6105,  8872, -12204, 16308, -2707,  3688, -5511, 11620, },
	{  -874,  -463,  4505, -12851,  6815, -12352, 20124, -30203, 10573, -13900, 17180, -19885, 10656, -10298,  8378, -4383, -1086,  5841, -12185, 20110, -14724, 19918, -25346, 30605, -17590, 19230, -19881, 19181, -8387,  6167, -2795, -1817,  3851, -7410, 11527, -16098, 10488, -12983, 15414, -17638,  9741, -10369, 10559, -10089,  1065,  -581,  -866, 30108, },
	{  3098, -7382, 14314, -24253,  9263, -12944, 16604, -19416,  5049, -4355,  2318,  1550, -3862,  8297, -14193, 21534, -15064, 19782, -24594, 29039, -16265, 17184, -16889, 14980, -5535,  2416,  1984, -7712,  7362, -11434, 15933, -20656, 12665, -14810, 16562, -17695,  8979, -8537,  7371, -5308,  1068,  1216, -4423,  8968, -1967,  3385, -6481, 21905, },
	{  2629, -5335,  8337, -10663,  2677, -1548, -1450,  7156, -4108,  7510, -12115, 17926, -12387, 16134, -19877, 23144, -12661, 12836, -11683,  8774, -1853, -1928,  7059, -13554, 10653, -15034, 19718, -24418, 14382, -16156, 17278, -17474,  8232, -6985,  4869, -1773, -1195,  3841, -7071, 10895, -7662, 10194, -13089, 16461, -2575,  3285, -4516,  8213, },
	{   462, -2931,  8394, -18240,  8459, -14058, 21446, -30422, 10097, -12557, 14564, -15544,  7390, -5729,  2355,  3140, -5547, 10849, -17468, 25259, -16953, 21451, -25771, 29462, -15996, 16380, -15571, 13260, -4585,  1540,  2572, -7762,  6988, -10539, 14425, -18494, 11273, -13168, 14788, -15959,  8236, -8029,  7163, -5310,   223,   661, -3002, 28988, },
	{  3360, -7628, 14095, -22744,  8240, -10821, 12801, -13257,  2742, -1118, -1960,  6888, -6999, 11742, -17666, 24613, -16120, 19997, -23544, 26258, -13770, 13360, -11554,  8022, -1241, -2629,  7633, -13723, 10375, -14229, 18233, -22139, 12820, -14187, 14971, -14951,  6947, -5779,  3840,  -984, -1482,  4125, -7634, 12381, -2395,  3761, -6595, 18773, },
	{  2071, -3963,  5522, -5591,   614,  1534, -5712, 12623, -5724,  9241, -13718, 19027, -12428, 15336, -17848, 19449, -9760,  8678, -6116,  1728,  2385, -6776, 12317, -18911, 13168, -17116, 21042, -24619, 13727, -14549, 14538, -13449,  5524, -3565,   761,  2944, -3787,  6560, -9769, 13377, -8669, 10804, -13084, 15529, -2280,  2694, -3325,  4969, },
	{  1595, -4952, 11389, -22013,  9432, -14731, 21277, -28624,  8979, -10451, 11108, -10365,  3772,  -961, -3597, 10186, -9487, 14974, -21428, 28580, -17994, 21522, -24480, 26403, -13385, 12520, -10339,  6607,  -571, -3078,  7643, -13056,  9590, -12898, 16302, -19609, 11293, -12479, 13201, -13273,  6232, -5237,  3423,  -396,  -585,  1762, -4655, 27249, },
	{  3350, -7334, 12959, -19851,  6746, -8123,  8382, -6565,   374,  2034, -5911, 11538, -9543, 14275, -19840, 25955, -16076, 18884, -20973, 21829, -10440,  8766, -5607,   726,  3020, -7369, 12634, -18677, 12629, -16016, 19273, -22122, 12122, -12640, 12425, -11281,  4505, -2706,   144,  3288, -3861,  6671, -10230, 14841, -2646,  3867, -6280, 15421, },
	{ -2485,  2610,  -571, -5347,  4308, -9336, 16945, -27509, 10277, -14341, 18825, -23297, 13560, -14720, 14608, -12635,  4090,  -329, -5208, 12670, -11032, 16609, -22869, 29490, -18010, 20940, -23187, 24359, -12019, 10901, -8628,  5028,    13, -3302,  7355, -12134,  8780, -11754, 14911, -18153, 10684, -12217, 13613, -14805,  1965, -2029,  1994, 30571, },
	{  2469, -6432, 13366, -24040,  9715, -14390, 19715, -25039,  7326, -7757,  7077, -4727,    54,  3682, -9087, 16304, -12663, 17972, -23846, 29909, -17816, 20168, -21607, 21681, -9959,  7932, -4556,  -318,  3383, -7383, 12089, -17363, 11498, -14350, 17057, -19402, 10566, -10981, 10783, -9784,  3876, -2190,  -404,  4330, -1312,  2666, -5801, 24959, },
	{  3107, -6579, 11065, -15875,  4914, -5065,  3676,   185, -1895,  4897, -9289, 15222, -11351, 15766, -20623, 25535, -14972, 16562, -17101, 16098, -6522,  3727,   541, -6417,  6967, -11497, 16671, -22271, 13992, -16700, 19012, -20642, 10638, -10292,  9117, -6951,  1822,   472, -3468,  7231, -5918,  8698, -12063, 16229, -2711,  3717, -5599, 11974, },
	{ -1019,  -189,  4064, -12216,  6611, -12120, 19904, -30061, 10583, -13989, 17391, -20269, 10961, -10743,  8984, -5162,  -610,  5289, -11580, 19489, -14432, 19679, -25204, 30608, -17690, 19456, -20257, 19729, -8754,  6629, -3348, -1185,  3506, -7053, 11178, -15785, 10365, -12913, 15421, -17747,  9863, -10576, 10878, -10558,  1151,  -714,  -621, 30186, },
	{  3054, -7324, 14280, -24319,  9337, -13121, 16947, -20000,  5276, -4683,  2764,   977, -3514,  7899, -13770, 21124, -14894, 19683, -24610, 29221, -16465, 17521, -17387, 15655, -5966,  2938,  1382, -7050,  7017, -11096, 15630, -20421, 12600, -14818, 16665, -17916,  9158, -8794,  7714, -5742,  1333,   904, -4067,  8571, -1914,  3331, -6443, 22209, },
	{  2681, -5465,  8612, -11172,  2890, -1874,  -987,  6543, -3920,  7296, -11897, 17739, -12334, 16156, -20015, 23446, -12919, 13226, -12226,  9484, -2293, -1410,  6478, -12937, 10347, -14757, 19503, -24303, 14395, -16262, 17499, -17830,  8485, -7317,  5281, -2261,  -918,  3541, -6760, 10591, -7526, 10091, -13039, 16497, -2596,  3336, -4628,  8557, },
	{   334, -2696,  8033, -17759,  8321, -13931, 21379, -30495, 10176, -12733, 14876, -16034,  7746, -6212,  2977,  2383, -5109, 10371, -16983, 24811, -16777, 21361, -25807, 29671, -16209, 16723, -16061, 13908, -4989,  2020,  2029, -7176,  6688, -10251, 14173, -18305, 11227, -13190, 14898, -16181,  8416, -8293,  7531, -5812,   309,   539, -2805, 29133, },
	{  3346, -7629, 14162, -22967,  8369, -11069, 13225, -13921,  2984, -1450, -1532,  6367, -6701, 11428, -17367, 24375, -16063, 20037, -23725, 26624, -14068, 13793, -12137,  8760, -1685, -2120,  7078, -13149, 10099, -13986, 18054, -22056, 12844, -14295, 15180, -15279,  7177, -6080,  4213, -1430, -1225,  3840, -7330, 12072, -2360,  3734, -6604, 19107, },
	{  2131, -4110,  5819, -6115,   823,  1229, -5301, 12110, -5579,  9094, -13598, 18974, -12463, 15465, -18110, 19887, -10086,  9130, -6704,  2454,  1959, -6301, 11817, -18421, 12952, -16956, 20972, -24675, 13837, -14759, 14864, -13904,  5820, -3927,  1185,  2469, -3533,  6302, -9523, 13164, -8593, 10775, -13125, 15672, -2317,  2762, -3454,  5291, },
	{  1490, -4768, 11128, -21706,  9364, -14710, 21361, -28896,  9120, -10697, 11494, -10924,  4152, -1450, -3001,  9499, -9114, 14599, -21090, 28329, -17944, 21581, -24688, 26798, -13695, 12954, -10908,  7310,  -985, -2614,  7146, -12554,  9353, -12696, 16160, -19556, 11326, -12588, 13405, -13589,  6457, -5538,  3815,  -897,  -505,  1657, -4508, 27454, },
	{  3363, -7387, 13113, -20203,  6917, -8420,  8854, -7262,   615,  1721, -5529, 11101, -9314, 14062, -19681, 25899, -16131, 19057, -21301, 22350, -10813,  9263, -6234,  1475,  2593, -6906, 12161, -18227, 12437, -15882, 19226, -22193, 12231, -12838, 12725, -11693,  4769, -3029,   523,  2861, -3629,  6431, -9997, 14637, -2629,  3869, -6330, 15771, },
	{  1520, -2638,  2907, -1074, -1146,  4043, -9000, 16562, -6782, 10204, -14322, 18904, -11764, 13783, -15084, 15147, -6688,  4571,  -921, -4516,  5951, -10631, 16221, -22534, 14629, -17975, 21016, -23406, 12376, -12316, 11308, -9149,  2831,  -355, -2895,  6925, -5852,  8579, -11587, 14800, -9063, 10729, -12344, 13851, -1900,  2044, -2164,  2284, },
	{  2393, -6307, 13212, -23914,  9717, -14469, 19935, -25480,  7517, -8055,  7508, -5315,   432,  3221, -8556, 15731, -12379, 17722, -23673, 29866, -17889, 20369, -21968, 22232, -10341,  8427, -5163,   391,  2988, -6964, 11670, -16975, 11338, -14245, 17032, -19483, 10674, -11169, 11064, -10171,  4129, -2508,   -15,  3863, -1242,  2583, -5707, 25217, },
	{  3141, -6674, 11288, -16323,  5113, -5388,  4162,  -497, -1671,  4622, -8975, 14895, -11202, 15663, -20608, 25657, -15131, 16851, -17550, 16734, -6943,  4254,   -87, -5705,  6584, -11110, 16309, -21972, 13895, -16682, 19098, -20858, 10823, -10565,  9485, -7417,  2103,   147, -3109,  6849, -5725,  8518, -11913, 16138, -2713,  3744, -5683, 12328, },
	{ -1166,    87,  3615, -11566,  6400, -11877, 19667, -29897, 10585, -14069, 17591, -20640, 11260, -11181,  9585, -5941,  -132,  4731, -10965, 18853, -14129, 19426, -25043, 30588, -17778, 19669, -20621, 20266, -9116,  7088, -3901,  -551,  3159, -6690, 10821, -15459, 10235, -12835, 15416, -17843,  9977, -10776, 11190, -11022,  1236,  -847,  -372, 30257, },
	{  3008, -7260, 14235, -24369,  9404, -13290, 17279, -20572,  5500, -5009,  3211,   400, -3162,  7494, -13336, 20699, -14712, 19570, -24609, 29382, -16655, 17846, -17873, 16321, -6394,  3459,   777, -6382,  6666, -10750, 15315, -20170, 12526, -14816, 16757, -18124,  9331, -9046,  8053, -6174,  1597,   590, -3706,  8166, -1859,  3275, -6400, 22509, },
	{  2731, -5592,  8883, -11677,  3102, -2201,  -520,  5921, -3727,  7076, -11669, 17538, -12273, 16167, -20139, 23732, -13169, 13607, -12762, 10190, -2732,  -888,  5891, -12310, 10033, -14469, 19273, -24170, 14399, -16358, 17709, -18174,  8732, -7645,  5691, -2750,  -640,  3237, -6444, 10280, -7385,  9980, -12980, 16520, -2616,  3384, -4739,  8903, },
	{   203, -2457,  7664, -17260,  8175, -13792, 21298, -30547, 10249, -12900, 15177, -16514,  8097, -6693,  3598,  1620, -4665,  9884, -16483, 24344, -16590, 21255, -25826, 29859, -16411, 17055, -16541, 14548, -5391,  2499,  1484, -6584,  6382, -9954, 13910, -18104, 11174, -13203, 14998, -16391,  8590, -8552,  7896, -6312,   395,   415, -2602, 29270, },
	{  3329, -7624, 14219, -23176,  8492, -11310, 13642, -14579,  3226, -1782, -1101,  5839, -6398, 11104, -17054, 24120, -15994, 20064, -23889, 26972, -14357, 14217, -12712,  9493, -2129, -1608,  6516, -12565,  9814, -13733, 17861, -21956, 12858, -14393, 15380, -15597,  7403, -6377,  4585, -1877,  -967,  3552, -7020, 11753, -2322,  3706, -6609, 19438, },
	{  2192, -4257,  6114, -6639,  1033,   921, -4882, 11585, -5428,  8941, -13468, 18908, -12489, 15584, -18361, 20312, -10406,  9576, -7289,  3180,  1530, -5820, 11307, -17917, 12725, -16783, 20887, -24714, 13937, -14960, 15181, -14350,  6111, -4287,  1609,  1991, -3276,  6038, -9269, 12941, -8510, 10739, -13157, 15804, -2353,  2828, -3581,  5616, },
	{  1383, -4579, 10855, -21380,  9289, -14677, 21429, -29148,  9256, -10937, 11873, -11477,  4531, -1939, -2401,  8802, -8733, 14212, -20736, 28057, -17880, 21626, -24879, 27176, -13995, 13381, -11470,  8009, -1399, -2147,  6643, -12041,  9108, -12485, 16006, -19488, 11351, -12689, 13600, -13897,  6677, -5837,  4206, -1399,  -425,  1550, -4356, 27653, },
	{  3373, -7435, 13259, -20543,  7085, -8713,  9323, -7958,   857,  1405, -5140, 10655, -9077, 13837, -19506, 25824, -16174, 19216, -21615, 22857, -11180,  9755, -6857,  2226,  2163, -6437, 11677, -17763, 12236, -15737, 19165, -22248, 12332, -13028, 13017, -12097,  5031, -3352,   903,  2430, -3394,  6186, -9756, 14421, -2610,  3867, -6377, 16121, },
	{  1584, -2791,  3205, -1580,  -952,  3773, -8655, 16164, -6682, 10123, -14294, 18970, -11872, 13997, -15440, 15678, -7056,  5051, -1515, -3817,  5561, -10221, 15821, -22183, 14503, -17926, 21077, -23609, 12565, -12605, 11708, -9666,  3146,  -722, -2486,  6490, -5632,  8372, -11412, 14679, -9043, 10767, -12462, 14079, -1948,  2123, -2299,  2578, },
	{  2313, -6175, 13047, -23769,  9712, -14539, 20141, -25905,  7703, -8348,  7937, -5902,   812,  2755, -8016, 15144, -12084, 17458, -23483, 29802, -17951, 20557, -22315, 22769, -10717,  8917, -5768,  1102,  2589, -6539, 11242, -16574, 11169, -14131, 16996, -19551, 10774, -11349, 11339, -10553,  4380, -2825,   375,  3391, -1172,  2499, -5607, 25469, },
	{  3173, -6766, 11506, -16762,  5310, -5710,  4649, -1182, -1445,  4343, -8653, 14556, -11045, 15549, -20577, 25762, -15280, 17129, -17988, 17360, -7361,  4780,  -716, -4988,  6196, -10714, 15935, -21656, 13789, -16651, 19170, -21060, 11002, -10831,  9847, -7879,  2383,  -178, -2746,  6462, -5529,  8331, -11755, 16035, -2713,  3768, -5765, 12683, },
	{ -1314,   367,  3159, -10904,  6184, -11625, 19415, -29711, 10579, -14138, 17779, -20998, 11552, -11614, 10182, -6718,   347,  4169, -10340, 18201, -13815, 19159, -24864, 30547, -17854, 19868, -20970, 20789, -9473,  7543, -4451,    85,  2808, -6321, 10455, -15122, 10097, -12747, 15401, -17928, 10085, -10970, 11496, -11480,  1322,  -981,  -118, 30320, },
	{  2959, -7190, 14179, -24401,  9465, -13451, 17602, -21132,  5722, -5334,  3657,  -180, -2806,  7083, -12890, 20256, -14520, 19442, -24590, 29523, -16833, 18160, -18348, 16977, -6818,  3979,   171, -5707,  6309, -10395, 14989, -19905, 12443, -14804, 16838, -18320,  9498, -9292,  8386, -6603,  1861,   276, -3341,  7754, -1802,  3216, -6351, 22806, },
	{  2780, -5717,  9150, -12178,  3313, -2528,   -49,  5291, -3530,  6849, -11432, 17324, -12202, 16166, -20250, 24002, -13410, 13981, -13291, 10891, -3172,  -365,  5297, -11672,  9711, -14170, 19030, -24020, 14392, -16442, 17906, -18506,  8974, -7969,  6098, -3237,  -361,  2930, -6122,  9960, -7238,  9861, -12912, 16533, -2634,  3431, -4847,  9250, },
	{    70, -2213,  7285, -16745,  8023, -13642, 21200, -30577, 10315, -13059, 15470, -16985,  8444, -7171,  4220,   854, -4217,  9388, -15971, 23858, -16390, 21134, -25826, 30027, -16602, 17376, -17011, 15180, -5790,  2977,   936, -5985,  6071, -9650, 13636, -17888, 11112, -13206, 15087, -16591,  8759, -8806,  8256, -6810,   481,   290, -2395, 29401, },
	{  3310, -7613, 14266, -23368,  8611, -11545, 14052, -15230,  3466, -2115,  -666,  5304, -6089, 10771, -16728, 23846, -15913, 20076, -24037, 27303, -14636, 14633, -13280, 10222, -2573, -1094,  5948, -11970,  9522, -13470, 17656, -21841, 12864, -14481, 15569, -15905,  7624, -6671,  4955, -2323,  -708,  3260, -6704, 11425, -2282,  3674, -6608, 19766, },
	{  2251, -4402,  6408, -7163,  1243,   610, -4458, 11050, -5273,  8779, -13327, 18828, -12506, 15692, -18599, 20724, -10721, 10018, -7871,  3907,  1099, -5334, 10788, -17398, 12489, -16598, 20786, -24735, 14028, -15149, 15488, -14787,  6399, -4645,  2033,  1511, -3015,  5770, -9008, 12709, -8421, 10694, -13179, 15926, -2387,  2893, -3707,  5943, },
	{  1272, -4384, 10572, -21035,  9206, -14634, 21483, -29381,  9385, -11170, 12246, -12025,  4908, -2430, -1797,  8097, -8345, 13815, -20366, 27765, -17804, 21655, -25054, 27535, -14286, 13799, -12026,  8705, -1812, -1677,  6134, -11518,  8857, -12264, 15841, -19407, 11368, -12781, 13785, -14196,  6894, -6132,  4595, -1903,  -343,  1442, -4199, 27846, },
	{  3380, -7478, 13397, -20872,  7248, -9002,  9788, -8652,  1099,  1086, -4746, 10198, -8833, 13602, -19317, 25731, -16206, 19362, -21915, 23349, -11540, 10242, -7478,  2977,  1730, -5962, 11185, -17285, 12025, -15580, 19091, -22287, 12424, -13208, 13300, -12494,  5290, -3672,  1283,  1996, -3156,  5936, -9507, 14194, -2588,  3863, -6419, 16469, },
	{  1648, -2944,  3503, -2089,  -756,  3498, -8302, 15752, -6576, 10035, -14254, 19023, -11972, 14202, -15785, 16199, -7420,  5529, -2109, -3114,  5166, -9802, 15408, -21815, 14366, -17865, 21123, -23796, 12744, -12886, 12101, -10176,  3460, -1090, -2073,  6048, -5408,  8159, -11227, 14546, -9016, 10798, -12571, 14299, -1995,  2201, -2434,  2875, },
	{  2230, -6038, 12871, -23605,  9700, -14599, 20335, -26314,  7884, -8637,  8361, -6487,  1193,  2286, -7469, 14544, -11779, 17181, -23275, 29716, -17999, 20730, -22647, 23291, -11086,  9402, -6371,  1814,  2188, -6109, 10805, -16160, 10992, -14006, 16947, -19606, 10866, -11522, 11606, -10928,  4629, -3142,   767,  2915, -1100,  2411, -5502, 25717, },
	{  3204, -6854, 11717, -17193,  5505, -6030,  5135, -1871, -1216,  4058, -8324, 14205, -10879, 15423, -20532, 25849, -15419, 17395, -18414, 17976, -7774,  5304, -1347, -4264,  5802, -10309, 15548, -21324, 13673, -16609, 19229, -21247, 11172, -11090, 10203, -8336,  2662,  -504, -2380,  6069, -5327,  8138, -11587, 15920, -2711,  3789, -5843, 13037, },
	{ -1463,   649,  2696, -10227,  5961, -11362, 19148, -29502, 10566, -14198, 17956, -21343, 11837, -12040, 10774, -7493,   829,  3601, -9705, 17533, -13491, 18877, -24667, 30484, -17917, 20054, -21306, 21299, -9824,  7994, -5000,   722,  2454, -5947, 10080, -14773,  9951, -12649, 15375, -18000, 10186, -11156, 11795, -11933,  1407, -1115,   141, 30377, },
	{  2906, -7113, 14111, -24415,  9520, -13603, 17913, -21681,  5940, -5656,  4103,  -762, -2446,  6664, -12433, 19798, -14317, 19300, -24553, 29643, -17000, 18462, -18811, 17623, -7239,  4497,  -438, -5026,  5947, -10031, 14651, -19625, 12351, -14781, 16906, -18503,  9658, -9532,  8715, -7028,  2125,   -41, -2972,  7334, -1744,  3154, -6298, 23098, },
	{  2828, -5839,  9413, -12674,  3524, -2856,   424,  4653, -3330,  6616, -11186, 17097, -12123, 16153, -20346, 24256, -13643, 14346, -13812, 11586, -3610,   160,  4698, -11023,  9381, -13860, 18771, -23852, 14375, -16515, 18092, -18826,  9210, -8287,  6502, -3723,   -80,  2620, -5795,  9633, -7085,  9735, -12833, 16533, -2650,  3475, -4953,  9598, },
	{   -65, -1965,  6897, -16213,  7863, -13482, 21086, -30585, 10374, -13209, 15753, -17446,  8787, -7646,  4841,    84, -3764,  8884, -15445, 23354, -16177, 20998, -25808, 30174, -16782, 17686, -17470, 15802, -6186,  3455,   386, -5381,  5755, -9339, 13352, -17660, 11042, -13200, 15166, -16779,  8921, -9054,  8612, -7306,   568,   164, -2182, 29526, },
	{  3287, -7596, 14303, -23546,  8724, -11773, 14454, -15875,  3705, -2448,  -230,  4764, -5773, 10429, -16389, 23554, -15820, 20073, -24168, 27615, -14907, 15039, -13840, 10946, -3016,  -577,  5374, -11365,  9222, -13196, 17437, -21711, 12861, -14559, 15748, -16202,  7840, -6960,  5322, -2768,  -447,  2965, -6381, 11086, -2240,  3639, -6603, 20092, },
	{  2310, -4545,  6701, -7686,  1455,   296, -4027, 10502, -5113,  8611, -13176, 18734, -12514, 15789, -18825, 21122, -11029, 10454, -8449,  4633,   666, -4842, 10259, -16866, 12243, -16401, 20671, -24738, 14109, -15329, 15784, -15215,  6683, -5000,  2457,  1028, -2752,  5496, -8740, 12467, -8326, 10642, -13193, 16037, -2419,  2956, -3832,  6273, },
	{  1159, -4184, 10278, -20672,  9116, -14580, 21522, -29594,  9509, -11397, 12611, -12567,  5283, -2920, -1189,  7383, -7950, 13405, -19980, 27452, -17715, 21669, -25211, 27876, -14568, 14209, -12574,  9396, -2226, -1204,  5620, -10986,  8599, -12034, 15664, -19311, 11377, -12864, 13961, -14485,  7106, -6425,  4983, -2407,  -261,  1331, -4037, 28033, },
	{  3385, -7516, 13527, -21187,  7408, -9286, 10249, -9344,  1342,   765, -4347,  9733, -8581, 13356, -19113, 25619, -16226, 19496, -22200, 23825, -11892, 10724, -8095,  3728,  1294, -5482, 10682, -16794, 11806, -15412, 19003, -22311, 12508, -13380, 13574, -12883,  5546, -3991,  1664,  1560, -2916,  5681, -9250, 13956, -2565,  3856, -6458, 16815, },
	{  1711, -3097,  3802, -2602,  -558,  3219, -7941, 15327, -6465,  9939, -14205, 19063, -12064, 14398, -16121, 16711, -7779,  6004, -2704, -2406,  4766, -9376, 14983, -21431, 14218, -17791, 21154, -23966, 12916, -13158, 12486, -10681,  3773, -1459, -1658,  5601, -5179,  7939, -11035, 14403, -8983, 10821, -12672, 14509, -2041,  2277, -2568,  3176, },
	{  2145, -5894, 12683, -23423,  9681, -14648, 20514, -26707,  8061, -8921,  8782, -7071,  1575,  1813, -6914, 13932, -11466, 16890, -23050, 29609, -18035, 20889, -22964, 23798, -11449,  9882, -6970,  2526,  1785, -5673, 10359, -15734, 10807, -13870, 16886, -19646, 10952, -11687, 11865, -11297,  4875, -3457,  1160,  2434, -1027,  2322, -5392, 25959, },
	{  3232, -6938, 11921, -17615,  5697, -6348,  5620, -2562,  -986,  3770, -7987, 13842, -10705, 15286, -20472, 25917, -15548, 17650, -18829, 18581, -8184,  5826, -1979, -3536,  5403, -9895, 15149, -20976, 13546, -16555, 19275, -21420, 11336, -11342, 10552, -8789,  2940,  -831, -2012,  5670, -5122,  7938, -11411, 15794, -2707,  3808, -5918, 13391, },
	{ -1612,   933,  2228, -9538,  5732, -11089, 18865, -29271, 10546, -14248, 18120, -21674, 12114, -12459, 11361, -8266,  1311,  3029, -9062, 16851, -13155, 18580, -24452, 30400, -17967, 20226, -21628, 21795, -10168,  8440, -5547,  1360,  2098, -5568,  9698, -14413,  9798, -12543, 15338, -18059, 10280, -11336, 12087, -12379,  1491, -1250,   403, 30426, },
	{  2850, -7030, 14033, -24411,  9568, -13746, 18214, -22218,  6156, -5976,  4548, -1346, -2084,  6239, -11966, 19324, -14102, 19144, -24499, 29743, -17155, 18751, -19262, 18258, -7656,  5014, -1047, -4341,  5580, -9660, 14302, -19331, 12250, -14747, 16963, -18674,  9812, -9765,  9038, -7449,  2388,  -358, -2600,  6907, -1684,  3089, -6239, 23386, },
	{  2874, -5958,  9672, -13166,  3734, -3184,   901,  4009, -3127,  6378, -10930, 16857, -12034, 16129, -20429, 24494, -13866, 14702, -14325, 12275, -4047,   687,  4094, -10366,  9043, -13539, 18499, -23667, 14347, -16576, 18265, -19133,  9440, -8601,  6902, -4208,   201,  2308, -5462,  9297, -6927,  9602, -12746, 16522, -2664,  3518, -5056,  9947, },
	{  -202, -1713,  6500, -15665,  7697, -13311, 20956, -30571, 10426, -13351, 16026, -17897,  9125, -8117,  5461,  -689, -3307,  8372, -14906, 22832, -15953, 20846, -25771, 30299, -16950, 17983, -17917, 16415, -6578,  3931,  -166, -4771,  5434, -9020, 13057, -17419, 10965, -13184, 15235, -16956,  9079, -9297,  8963, -7799,   654,    37, -1965, 29643, },
	{  3261, -7573, 14330, -23707,  8831, -11995, 14849, -16512,  3943, -2781,   210,  4217, -5453, 10078, -16037, 23244, -15716, 20057, -24283, 27908, -15167, 15436, -14392, 11664, -3458,   -59,  4795, -10750,  8915, -12913, 17205, -21564, 12849, -14627, 15916, -16488,  8050, -7245,  5687, -3213,  -185,  2667, -6053, 10739, -2197,  3602, -6594, 20415, },
	{  2368, -4687,  6991, -8208,  1667,   -20, -3591,  9944, -4949,  8436, -13016, 18626, -12513, 15875, -19039, 21508, -11330, 10884, -9023,  5358,   230, -4345,  9722, -16320, 11988, -16192, 20540, -24725, 14180, -15498, 16070, -15633,  6963, -5353,  2879,   544, -2487,  5218, -8465, 12215, -8225, 10583, -13197, 16138, -2450,  3018, -3955,  6606, },
	{  1044, -3978,  9975, -20292,  9019, -14516, 21546, -29787,  9626, -11616, 12970, -13103,  5656, -3411,  -578,  6662, -7547, 12985, -19579, 27118, -17613, 21668, -25350, 28198, -14840, 14609, -13115, 10082, -2639,  -730,  5100, -10445,  8333, -11795, 15475, -19202, 11378, -12939, 14128, -14765,  7314, -6713,  5368, -2913,  -178,  1219, -3869, 28214, },
	{  3387, -7548, 13647, -21490,  7563, -9566, 10705, -10034,  1586,   442, -3942,  9258, -8322, 13100, -18895, 25488, -16235, 19615, -22470, 24287, -12238, 11199, -8708,  4479,   857, -4996, 10172, -16289, 11578, -15233, 18902, -22318, 12583, -13543, 13839, -13263,  5798, -4308,  2044,  1121, -2672,  5421, -8986, 13708, -2540,  3846, -6492, 17160, },
	{  1775, -3249,  4102, -3118,  -358,  2935, -7571, 14887, -6348,  9836, -14145, 19089, -12147, 14585, -16447, 17213, -8135,  6477, -3300, -1694,  4362, -8941, 14546, -21030, 14060, -17704, 21170, -24120, 13078, -13422, 12863, -11180,  4083, -1827, -1241,  5149, -4946,  7713, -10834, 14249, -8944, 10836, -12765, 14709, -2086,  2353, -2702,  3480, },
	{  2056, -5744, 12484, -23222,  9655, -14687, 20680, -27082,  8233, -9200,  9198, -7651,  1957,  1336, -6352, 13307, -11142, 16587, -22808, 29481, -18059, 21034, -23265, 24290, -11804, 10356, -7566,  3239,  1379, -5232,  9905, -15296, 10614, -13725, 16813, -19673, 11029, -11844, 12117, -11659,  5119, -3771,  1553,  1949,  -952,  2230, -5277, 26197, },
	{  3258, -7018, 12119, -18028,  5887, -6664,  6105, -3255,  -753,  3477, -7642, 13467, -10522, 15137, -20398, 25967, -15665, 17894, -19232, 19175, -8588,  6345, -2611, -2803,  4999, -9474, 14738, -20613, 13410, -16490, 19307, -21578, 11491, -11587, 10895, -9236,  3216, -1157, -1641,  5267, -4912,  7732, -11226, 15656, -2701,  3825, -5989, 13746, },
	{ -1763,  1220,  1754, -8837,  5497, -10807, 18567, -29017, 10517, -14288, 18273, -21991, 12385, -12871, 11942, -9036,  1794,  2453, -8410, 16155, -12809, 18270, -24218, 30293, -18005, 20384, -21935, 22276, -10507,  8881, -6091,  1999,  1740, -5184,  9307, -14042,  9638, -12427, 15290, -18106, 10368, -11507, 12371, -12818,  1575, -1385,   670, 30468, },
	{  2791, -6941, 13944, -24390,  9610, -13880, 18503, -22741,  6368, -6293,  4992, -1933, -1718,  5807, -11488, 18834, -13877, 18973, -24427, 29822, -17298, 19028, -19701, 18883, -8068,  5529, -1658, -3650,  5208, -9281, 13942, -19022, 12140, -14703, 17008, -18831,  9959, -9993,  9356, -7867,  2650,  -676, -2224,  6474, -1623,  3022, -6176, 23670, },
	{  2918, -6074,  9926, -13652,  3942, -3513,  1379,  3357, -2920,  6133, -10666, 16603, -11936, 16094, -20497, 24716, -14081, 15049, -14830, 12958, -4483,  1215,  3485, -9698,  8699, -13208, 18213, -23465, 14310, -16625, 18425, -19427,  9664, -8909,  7298, -4691,   482,  1993, -5126,  8955, -6764,  9462, -12649, 16499, -2677,  3558, -5157, 10298, },
	{  -340, -1457,  6095, -15101,  7524, -13129, 20811, -30535, 10471, -13484, 16289, -18337,  9458, -8585,  6079, -1464, -2846,  7853, -14355, 22291, -15716, 20679, -25716, 30404, -17107, 18269, -18353, 17018, -6967,  4406,  -718, -4157,  5109, -8693, 12753, -17165, 10879, -13160, 15293, -17122,  9230, -9534,  9309, -8288,   741,   -91, -1742, 29754, },
	{  3233, -7545, 14346, -23853,  8933, -12209, 15235, -17140,  4180, -3114,   651,  3664, -5127,  9719, -15672, 22917, -15600, 20026, -24381, 28183, -15418, 15824, -14935, 12375, -3899,   461,  4211, -10126,  8600, -12619, 16961, -21402, 12827, -14685, 16073, -16764,  8256, -7526,  6048, -3657,    78,  2366, -5720, 10383, -2152,  3561, -6579, 20735, },
	{  2425, -4827,  7280, -8729,  1879,  -338, -3150,  9376, -4780,  8254, -12845, 18504, -12503, 15951, -19240, 21879, -11624, 11307, -9593,  6082,  -206, -3844,  9176, -15761, 11724, -15970, 20395, -24693, 14241, -15657, 16345, -16040,  7239, -5703,  3301,    58, -2219,  4936, -8184, 11954, -8118, 10515, -13192, 16227, -2479,  3077, -4076,  6940, },
	{   926, -3767,  9660, -19893,  8915, -14440, 21554, -29959,  9737, -11829, 13321, -13631,  6027, -3901,    36,  5933, -7138, 12555, -19162, 26764, -17498, 21651, -25472, 28501, -15102, 15001, -13648, 10763, -3051,  -254,  4576, -9895,  8062, -11546, 15275, -19079, 11371, -13004, 14286, -15035,  7517, -6998,  5751, -3418,   -95,  1104, -3697, 28389, },
	{  3387, -7576, 13759, -21780,  7714, -9840, 11157, -10720,  1829,   116, -3533,  8775, -8056, 12833, -18663, 25339, -16233, 19721, -22725, 24733, -12575, 11667, -9317,  5229,   417, -4506,  9652, -15772, 11340, -15042, 18786, -22310, 12650, -13696, 14095, -13635,  6048, -4623,  2424,   681, -2426,  5156, -8715, 13448, -2514,  3833, -6522, 17503, },
	{  1838, -3400,  4401, -3635,  -157,  2647, -7194, 14435, -6226,  9725, -14074, 19101, -12222, 14762, -16762, 17704, -8487,  6947, -3895,  -979,  3953, -8498, 14098, -20613, 13892, -17604, 21172, -24257, 13232, -13676, 13232, -11671,  4391, -2194,  -822,  4693, -4709,  7481, -10625, 14085, -8898, 10844, -12849, 14900, -2129,  2427, -2835,  3788, },
	{  1964, -5589, 12274, -23003,  9622, -14716, 20833, -27441,  8399, -9474,  9610, -8230,  2340,   857, -5783, 12671, -10810, 16271, -22549, 29331, -18069, 21164, -23551, 24766, -12152, 10824, -8159,  3951,   971, -4787,  9443, -14846, 10413, -13570, 16728, -19686, 11099, -11993, 12361, -12013,  5359, -4084,  1947,  1461,  -877,  2135, -5156, 26429, },
	{  3282, -7093, 12310, -18431,  6074, -6977,  6588, -3951,  -519,  3180, -7290, 13082, -10331, 14977, -20308, 25999, -15772, 18125, -19623, 19758, -8988,  6861, -3243, -2066,  4590, -9044, 14316, -20233, 13264, -16412, 19325, -21721, 11639, -11823, 11231, -9678,  3491, -1484, -1269,  4858, -4698,  7519, -11032, 15506, -2693,  3839, -6057, 14100, },
	{ -1914,  1510,  1274, -8123,  5257, -10515, 18254, -28741, 10481, -14319, 18413, -22294, 12647, -13275, 12516, -9802,  2278,  1873, -7749, 15446, -12453, 17946, -23967, 30165, -18030, 20528, -22227, 22743, -10838,  9317, -6632,  2639,  1379, -4796,  8910, -13660,  9470, -12302, 15230, -18139, 10448, -11671, 12648, -13251,  1658, -1521,   941, 30504, },
	{  2729, -6846, 13843, -24351,  9645, -14005, 18781, -23251,  6577, -6608,  5435, -2520, -1349,  5370, -11001, 18329, -13641, 18788, -24338, 29880, -17430, 19293, -20127, 19495, -8476,  6041, -2269, -2955,  4832, -8895, 13571, -18698, 12021, -14648, 17041, -18976, 10100, -10214,  9668, -8280,  2911,  -994, -1846,  6034, -1560,  2952, -6107, 23950, },
	{  2961, -6186, 10176, -14132,  4150, -3841,  1860,  2700, -2710,  5883, -10392, 16336, -11830, 16047, -20551, 24920, -14287, 15386, -15326, 13634, -4917,  1744,  2872, -9022,  8347, -12866, 17914, -23245, 14262, -16663, 18573, -19708,  9881, -9211,  7690, -5172,   764,  1676, -4784,  8604, -6595,  9314, -12543, 16464, -2688,  3596, -5255, 10649, },
	{  -480, -1197,  5682, -14522,  7344, -12936, 20650, -30477, 10508, -13607, 16541, -18766,  9785, -9048,  6696, -2241, -2381,  7325, -13792, 21733, -15468, 20497, -25643, 30487, -17252, 18543, -18778, 17610, -7351,  4879, -1272, -3538,  4779, -8360, 12439, -16897, 10786, -13125, 15340, -17276,  9375, -9765,  9650, -8774,   827,  -221, -1515, 29858, },
	{  3201, -7510, 14352, -23983,  9029, -12415, 15612, -17760,  4414, -3446,  1094,  3107, -4796,  9351, -15295, 22572, -15473, 19981, -24461, 28438, -15658, 16201, -15470, 13080, -4338,   981,  3622, -9494,  8279, -12316, 16704, -21224, 12797, -14733, 16218, -17028,  8457, -7803,  6406, -4100,   341,  2062, -5381, 10017, -2105,  3518, -6560, 21051, },
	{  2481, -4965,  7566, -9248,  2092,  -659, -2703,  8797, -4607,  8065, -12664, 18369, -12485, 16015, -19428, 22237, -11911, 11725, -10158,  6804,  -644, -3338,  8622, -15189, 11450, -15737, 20235, -24644, 14292, -15805, 16609, -16438,  7510, -6050,  3722,  -429, -1948,  4649, -7896, 11684, -8004, 10440, -13178, 16305, -2507,  3135, -4196,  7277, },
	{   805, -3551,  9336, -19476,  8803, -14353, 21546, -30111,  9842, -12033, 13664, -14152,  6395, -4390,   652,  5197, -6722, 12113, -18731, 26390, -17370, 21619, -25577, 28785, -15355, 15382, -14173, 11438, -3462,   223,  4047, -9337,  7784, -11290, 15064, -18941, 11356, -13060, 14433, -15296,  7716, -7279,  6132, -3924,   -10,   988, -3518, 28558, },
	{  3384, -7597, 13861, -22057,  7861, -10110, 11603, -11402,  2073,  -211, -3119,  8283, -7783, 12556, -18416, 25170, -16219, 19814, -22965, 25162, -12905, 12129, -9922,  5977,   -24, -4011,  9124, -15242, 11095, -14840, 18657, -22286, 12707, -13840, 14342, -13999,  6293, -4935,  2803,   238, -2177,  4887, -8436, 13178, -2485,  3818, -6547, 17845, },
	{  1900, -3552,  4701, -4155,    47,  2355, -6809, 13969, -6099,  9606, -13994, 19100, -12289, 14929, -17067, 18185, -8833,  7414, -4489,  -260,  3540, -8049, 13638, -20181, 13713, -17491, 21158, -24377, 13376, -13922, 13593, -12156,  4697, -2561,  -401,  4232, -4468,  7243, -10407, 13910, -8846, 10844, -12924, 15082, -2171,  2500, -2967,  4098, },
	{  1870, -5427, 12053, -22764,  9581, -14735, 20971, -27781,  8561, -9742, 10017, -8804,  2722,   375, -5208, 12023, -10469, 15942, -22273, 29160, -18067, 21280, -23821, 25225, -12492, 11286, -8747,  4661,   562, -4337,  8973, -14384, 10204, -13404, 16631, -19684, 11162, -12134, 12596, -12360,  5597, -4394,  2341,   970,  -801,  2039, -5029, 26655, },
	{  3303, -7164, 12493, -18824,  6257, -7287,  7069, -4647,  -283,  2879, -6932, 12685, -10132, 14805, -20204, 26013, -15868, 18345, -20001, 20328, -9383,  7375, -3875, -1325,  4177, -8607, 13882, -19839, 13108, -16323, 19330, -21849, 11779, -12052, 11560, -10114,  3764, -1811,  -894,  4445, -4480,  7301, -10830, 15345, -2683,  3850, -6122, 14453, },
	{ -2066,  1801,   788, -7398,  5011, -10213, 17925, -28443, 10437, -14339, 18540, -22582, 12902, -13672, 13084, -10564,  2762,  1289, -7081, 14723, -12088, 17608, -23698, 30015, -18042, 20658, -22504, 23196, -11163,  9748, -7170,  3277,  1017, -4403,  8505, -13267,  9296, -12169, 15160, -18161, 10521, -11828, 12916, -13676,  1741, -1656,  1216, 30531, },
	{  2664, -6744, 13731, -24293,  9673, -14120, 19047, -23748,  6782, -6919,  5876, -3108,  -978,  4927, -10503, 17809, -13395, 18590, -24231, 29917, -17549, 19544, -20540, 20096, -8879,  6550, -2880, -2256,  4451, -8501, 13190, -18361, 11894, -14583, 17062, -19108, 10234, -10428,  9974, -8688,  3170, -1313, -1465,  5588, -1496,  2879, -6032, 24225, },
	{  3002, -6296, 10420, -14606,  4356, -4168,  2343,  2036, -2496,  5627, -10110, 16056, -11714, 15988, -20590, 25108, -14483, 15714, -15813, 14303, -5348,  2273,  2255, -8338,  7988, -12515, 17601, -23009, 14204, -16689, 18708, -19976, 10092, -9508,  8077, -5651,  1047,  1357, -4439,  8247, -6421,  9159, -12428, 16418, -2696,  3631, -5351, 11002, },
	{  -622,  -933,  5261, -13927,  7157, -12733, 20472, -30397, 10539, -13722, 16783, -19183, 10107, -9507,  7310, -3019, -1913,  6791, -13218, 21158, -15207, 20299, -25551, 30549, -17386, 18804, -19190, 18191, -7732,  5350, -1826, -2915,  4445, -8020, 12116, -16618, 10684, -13082, 15376, -17418,  9514, -9990,  9986, -9256,   914,  -351, -1283, 29955, },
	{  3166, -7469, 14348, -24095,  9119, -12614, 15981, -18371,  4647, -3777,  1538,  2545, -4460,  8974, -14905, 22209, -15334, 19921, -24525, 28674, -15888, 16568, -15995, 13778, -4775,  1503,  3030, -8853,  7951, -12003, 16434, -21031, 12757, -14770, 16353, -17281,  8652, -8074,  6760, -4541,   605,  1756, -5037,  9643, -2056,  3472, -6535, 21365, },
	{  2536, -5102,  7849, -9765,  2305,  -981, -2251,  8209, -4429,  7869, -12473, 18220, -12457, 16068, -19603, 22580, -12190, 12135, -10718,  7523, -1083, -2828,  8060, -14605, 11168, -15492, 20060, -24577, 14334, -15942, 16862, -16824,  7777, -6393,  4140,  -917, -1676,  4359, -7601, 11404, -7885, 10357, -13154, 16372, -2533,  3191, -4314,  7616, },
	{   683, -3330,  9002, -19042,  8684, -14256, 21523, -30243,  9940, -12231, 13999, -14665,  6760, -4878,  1270,  4454, -6300, 11662, -18284, 25996, -17229, 21571, -25663, 29049, -15597, 15754, -14689, 12107, -3872,   702,  3514, -8771,  7500, -11024, 14841, -18791, 11333, -13108, 14571, -15546,  7909, -7555,  6510, -4429,    74,   870, -3335, 28720, },
	{  3378, -7614, 13955, -22319,  8003, -10373, 12044, -12081,  2317,  -540, -2701,  7782, -7504, 12269, -18156, 24984, -16193, 19893, -23189, 25576, -13227, 12583, -10520,  6723,  -466, -3512,  8589, -14700, 10840, -14628, 18515, -22247, 12756, -13975, 14579, -14353,  6534, -5244,  3181,  -205, -1926,  4613, -8151, 12897, -2454,  3799, -6569, 18184, },
	{  1963, -3702,  5000, -4676,   252,  2060, -6416, 13490, -5967,  9480, -13902, 19086, -12347, 15086, -17361, 18655, -9175,  7877, -5082,   461,  3123, -7592, 13167, -19732, 13524, -17366, 21129, -24480, 13512, -14159, 13944, -12633,  5001, -2927,    21,  3767, -4224,  7000, -10182, 13725, -8787, 10836, -12990, 15253, -2212,  2572, -3098,  4412, },
	{  1772, -5259, 11822, -22508,  9533, -14743, 21095, -28104,  8718, -10005, 10418, -9376,  3104,  -109, -4627, 11364, -10119, 15601, -21981, 28967, -18052, 21381, -24075, 25668, -12824, 11741, -9331,  5371,   151, -3882,  8495, -13911,  9988, -13229, 16522, -19669, 11216, -12267, 12824, -12699,  5831, -4703,  2735,   475,  -723,  1940, -4898, 26876, },
	{  3322, -7230, 12669, -19207,  6438, -7594,  7549, -5345,   -45,  2575, -6566, 12277, -9925, 14622, -20085, 26008, -15954, 18552, -20366, 20885, -9773,  7884, -4506,  -582,  3759, -8163, 13438, -19429, 12942, -16221, 19321, -21962, 11911, -12273, 11881, -10544,  4035, -2137,  -518,  4028, -4258,  7077, -10619, 15172, -2671,  3859, -6183, 14806, },
	{ -2218,  2094,   298, -6662,  4760, -9902, 17582, -28123, 10385, -14348, 18655, -22856, 13148, -14060, 13645, -11322,  3245,   703, -6406, 13987, -11712, 17256, -23412, 29843, -18042, 20773, -22766, 23633, -11481, 10173, -7704,  3915,   653, -4006,  8093, -12864,  9114, -12026, 15079, -18169, 10586, -11976, 13177, -14094,  1823, -1792,  1496, 30552, },
	{  2596, -6636, 13608, -24217,  9694, -14227, 19301, -24230,  6983, -7227,  6315, -3697,  -605,  4479, -9996, 17274, -13138, 18377, -24106, 29932, -17657, 19783, -20940, 20684, -9277,  7055, -3490, -1554,  4066, -8100, 12798, -18010, 11757, -14507, 17070, -19226, 10361, -10635, 10274, -9091,  3428, -1632, -1081,  5135, -1430,  2804, -5953, 24496, },
	{  3042, -6402, 10660, -15074,  4560, -4495,  2827,  1367, -2280,  5366, -9819, 15764, -11590, 15917, -20615, 25279, -14669, 16031, -16290, 14963, -5778,  2802,  1634, -7646,  7622, -12153, 17274, -22755, 14136, -16703, 18830, -20230, 10297, -9799,  8460, -6126,  1329,  1037, -4089,  7883, -6243,  8998, -12303, 16359, -2703,  3665, -5444, 11355, },
	{  -765,  -665,  4832, -13318,  6964, -12519, 20279, -30295, 10561, -13827, 17014, -19589, 10423, -9961,  7922, -3798, -1442,  6250, -12632, 20565, -14936, 20087, -25441, 30589, -17507, 19052, -19589, 18761, -8108,  5818, -2380, -2289,  4107, -7674, 11783, -16326, 10575, -13029, 15402, -17548,  9646, -10209, 10315, -9733,  1000,  -482, -1046, 30045, },
	{  3128, -7422, 14332, -24192,  9204, -12806, 16341, -18972,  4878, -4108,  1983,  1978, -4120,  8590, -14502, 21830, -15184, 19847, -24571, 28890, -16107, 16924, -16510, 14468, -5211,  2025,  2433, -8204,  7617, -11681, 16152, -20822, 12708, -14796, 16477, -17522,  8841, -8341,  7111, -4980,   870,  1448, -4688,  9260, -2006,  3423, -6506, 21675, },
	{  2589, -5236,  8129, -10279,  2518, -1304, -1795,  7611, -4247,  7666, -12272, 18057, -12420, 16110, -19764, 22908, -12462, 12538, -11272,  8239, -1523, -2315,  7491, -14009, 10877, -15235, 19870, -24493, 14365, -16068, 17104, -17200,  8039, -6733,  4557, -1406, -1402,  4065, -7300, 11116, -7760, 10267, -13120, 16427, -2558,  3246, -4430,  7957, },
	{   558, -3104,  8658, -18590,  8558, -14147, 21485, -30353, 10032, -12420, 14325, -15170,  7121, -5365,  1890,  3705, -5872, 11201, -17823, 25582, -17076, 21508, -25731, 29293, -15829, 16116, -15196, 12768, -4280,  1181,  2977, -8197,  7209, -10750, 14608, -18626, 11301, -13146, 14699, -15786,  8098, -7828,  6884, -4933,   159,   751, -3147, 28876, },
	{  3369, -7624, 14038, -22568,  8140, -10632, 12479, -12755,  2560,  -870, -2279,  7274, -7217, 11971, -17881, 24779, -16156, 19958, -23398, 25972, -13540, 13030, -11114,  7467,  -909, -3009,  8045, -14146, 10578, -14404, 18359, -22191, 12796, -14100, 14807, -14698,  6772, -5551,  3558,  -650, -1673,  4336, -7858, 12606, -2421,  3778, -6586, 18522, },
	{  2025, -3851,  5298, -5199,   459,  1761, -6017, 12999, -5830,  9346, -13801, 19057, -12397, 15233, -17643, 19113, -9511,  8337, -5674,  1185,  2702, -7128, 12685, -19269, 13324, -17228, 21085, -24566, 13638, -14386, 14287, -13102,  5301, -3292,   443,  3298, -3975,  6751, -9949, 13530, -8722, 10821, -13047, 15414, -2252,  2642, -3228,  4729, },
	{  1672, -5086, 11579, -22232,  9478, -14740, 21204, -28408,  8869, -10262, 10815, -9943,  3486,  -595, -4040, 10695, -9761, 15247, -21671, 28754, -18024, 21467, -24312, 26094, -13148, 12189, -9909,  6078,  -262, -3424,  8011, -13426,  9763, -13044, 16401, -19640, 11263, -12391, 13043, -13030,  6062, -5009,  3129,   -22,  -645,  1839, -4761, 27091, },
	{  3339, -7291, 12838, -19579,  6615, -7897,  8026, -6042,   194,  2267, -6195, 11858, -9709, 14428, -19951, 25985, -16028, 18746, -20718, 21430, -10156,  8389, -5136,   165,  3338, -7712, 12982, -19005, 12767, -16108, 19299, -22059, 12034, -12486, 12195, -10968,  4304, -2462,  -140,  3607, -4032,  6847, -10400, 14987, -2657,  3865, -6240, 15158, },
	{ -2371,  2388,  -197, -5914,  4504, -9582, 17224, -27781, 10326, -14348, 18757, -23114, 13387, -14440, 14198, -12074,  3728,   114, -5724, 13239, -11327, 16891, -23108, 29649, -18029, 20874, -23013, 24054, -11791, 10591, -8233,  4552,   287, -3605,  7674, -12451,  8926, -11874, 14987, -18165, 10645, -12117, 13430, -14503,  1904, -1927,  1779, 30566, },
	{  2525, -6522, 13474, -24123,  9709, -14323, 19542, -24698,  7181, -7531,  6751, -4286,  -229,  4026, -9480, 16725, -12870, 18151, -23964, 29927, -17752, 20008, -21326, 21258, -9669,  7558, -4100,  -848,  3677, -7693, 12396, -17645, 11612, -14421, 17067, -19332, 10481, -10836, 10567, -9489,  3685, -1951,  -695,  4677, -1363,  2726, -5868, 24762, },
	{  3080, -6504, 10893, -15535,  4763, -4821,  3312,   693, -2061,  5100, -9519, 15459, -11457, 15835, -20625, 25432, -14846, 16339, -16757, 15615, -6204,  3331,  1011, -6946,  7250, -11782, 16935, -22485, 14057, -16706, 18939, -20471, 10494, -10083,  8837, -6599,  1611,   714, -3736,  7513, -6059,  8829, -12169, 16289, -2709,  3695, -5533, 11708, },
	{  -910,  -394,  4396, -12693,  6765, -12295, 20071, -30170, 10576, -13924, 17234, -19982, 10733, -10410,  8530, -4578,  -967,  5703, -12035, 19957, -14652, 19860, -25312, 30608, -17616, 19288, -19976, 19319, -8479,  6282, -2934, -1659,  3765, -7321, 11441, -16021, 10458, -12966, 15417, -17666,  9772, -10421, 10639, -10206,  1086,  -614,  -805, 30128, },
	{  3087, -7368, 14306, -24271,  9282, -12989, 16691, -19563,  5106, -4437,  2429,  1407, -3775,  8198, -14088, 21433, -15022, 19759, -24600, 29087, -16316, 17269, -17015, 15150, -5643,  2547,  1834, -7547,  7276, -11350, 15858, -20598, 12650, -14813, 16589, -17751,  9024, -8602,  7457, -5417,  1134,  1138, -4335,  8869, -1954,  3372, -6472, 21981, },
	{  2642, -5367,  8406, -10791,  2730, -1629, -1335,  7004, -4062,  7457, -12061, 17880, -12375, 16141, -19913, 23221, -12726, 12934, -11819,  8952, -1963, -1799,  6915, -13401, 10577, -14966, 19666, -24391, 14386, -16183, 17334, -17564,  8296, -7068,  4972, -1895, -1126,  3767, -6994, 10820, -7628, 10169, -13078, 16471, -2580,  3298, -4544,  8299, },
	{   430, -2873,  8305, -18122,  8425, -14027, 21431, -30442, 10117, -12602, 14643, -15667,  7480, -5850,  2511,  2951, -5438, 10730, -17348, 25149, -16910, 21430, -25782, 29517, -16050, 16467, -15694, 13422, -4686,  1660,  2436, -7617,  6913, -10468, 14363, -18448, 11262, -13175, 14816, -16016,  8282, -8095,  7255, -5436,   245,   630, -2953, 29025, },
	{  3357, -7629, 14113, -22802,  8273, -10884, 12908, -13423,  2803, -1201, -1854,  6759, -6925, 11664, -17592, 24555, -16107, 20008, -23591, 26351, -13845, 13469, -11701,  8207, -1352, -2502,  7495, -13581, 10307, -14169, 18190, -22120, 12826, -14215, 15024, -15034,  7005, -5854,  3933, -1096, -1418,  4054, -7559, 12304, -2387,  3754, -6598, 18857, },
	{  2086, -4000,  5596, -5722,   666,  1458, -5610, 12496, -5689,  9205, -13689, 19015, -12438, 15370, -17914, 19560, -9842,  8792, -6263,  1909,  2279, -6658, 12193, -18790, 13115, -17077, 21026, -24635, 13755, -14603, 14621, -13564,  5599, -3655,   867,  2825, -3724,  6496, -9708, 13325, -8651, 10798, -13095, 15565, -2290,  2711, -3358,  5049, },
	{  1569, -4906, 11325, -21938,  9416, -14727, 21299, -28694,  9015, -10513, 11205, -10505,  3867, -1083, -3448, 10015, -9394, 14881, -21346, 28519, -17983, 21538, -24533, 26503, -13464, 12629, -10482,  6783,  -675, -2962,  7519, -12932,  9532, -12849, 16268, -19597, 11302, -12507, 13253, -13353,  6289, -5312,  3521,  -521,  -566,  1736, -4618, 27301, },
	{  3354, -7348, 12998, -19940,  6789, -8197,  8501, -6740,   434,  1956, -5816, 11430, -9486, 14223, -19802, 25943, -16091, 18928, -21056, 21961, -10534,  8890, -5764,   913,  2913, -7254, 12517, -18565, 12582, -15983, 19262, -22141, 12150, -12690, 12501, -11385,  4571, -2787,   239,  3182, -3803,  6611, -10173, 14791, -2642,  3868, -6293, 15509, },
	{ -2524,  2684,  -697, -5157,  4242, -9253, 16851, -27416, 10259, -14337, 18846, -23357, 13616, -14812, 14744, -12821,  4211,  -477, -5036, 12479, -10932, 16513, -22787, 29434, -18003, 20961, -23244, 24459, -12094, 11004, -8759,  5187,   -79, -3201,  7248, -12028,  8730, -11714, 14885, -18147, 10696, -12250, 13673, -14904,  1985, -2063,  2066, 30572, },
	{  2450, -6401, 13329, -24010,  9716, -14410, 19771, -25150,  7374, -7832,  7185, -4874,   148,  3567, -8955, 16162, -12593, 17911, -23804, 29900, -17835, 20220, -21698, 21820, -10056,  8056, -4708,  -141,  3284, -7279, 11985, -17267, 11459, -14325, 17052, -19423, 10594, -11029, 10854, -9881,  3940, -2269,  -307,  4214, -1294,  2645, -5778, 25024, },
	{  3115, -6603, 11121, -15988,  4964, -5146,  3798,    15, -1839,  4829, -9211, 15141, -11315, 15741, -20620, 25567, -15013, 16635, -17214, 16258, -6628,  3859,   384, -6240,  6872, -11401, 16582, -22198, 13968, -16696, 19035, -20697, 10685, -10361,  9209, -7068,  1892,   391, -3379,  7136, -5870,  8654, -12027, 16207, -2712,  3724, -5620, 12062, },
	{ -1056,  -120,  3952, -12055,  6559, -12060, 19846, -30023, 10584, -14010, 17442, -20363, 11036, -10853,  9134, -5357,  -491,  5150, -11427, 19332, -14358, 19618, -25165, 30605, -17713, 19510, -20349, 19865, -8845,  6744, -3487, -1027,  3420, -6963, 11090, -15704, 10333, -12895, 15421, -17772,  9892, -10627, 10957, -10674,  1172,  -747,  -559, 30204, },
	{  3043, -7309, 14269, -24333,  9354, -13164, 17031, -20144,  5332, -4765,  2876,   833, -3426,  7799, -13663, 21020, -14849, 19656, -24612, 29263, -16514, 17603, -17509, 15822, -6073,  3068,  1231, -6884,  6930, -11010, 15553, -20359, 12583, -14819, 16690, -17969,  9202, -8858,  7799, -5851,  1399,   826, -3977,  8471, -1900,  3317, -6432, 22284, },
	{  2693, -5497,  8680, -11299,  2943, -1955,  -870,  6388, -3872,  7241, -11841, 17690, -12320, 16160, -20047, 23519, -12982, 13322, -12361,  9661, -2403, -1280,  6332, -12781, 10269, -14686, 19447, -24271, 14397, -16287, 17553, -17917,  8547, -7400,  5384, -2383,  -849,  3465, -6681, 10514, -7491, 10064, -13025, 16504, -2601,  3348, -4656,  8644, },
	{   301, -2637,  7942, -17636,  8285, -13897, 21360, -30510, 10195, -12775, 14952, -16155,  7834, -6333,  3132,  2193, -4998, 10250, -16859, 24696, -16732, 21336, -25814, 29720, -16260, 16807, -16182, 14069, -5090,  2139,  1893, -7029,  6612, -10177, 14108, -18256, 11215, -13194, 14924, -16234,  8460, -8358,  7623, -5937,   330,   508, -2754, 29168, },
	{  3342, -7628, 14177, -23021,  8400, -11130, 13330, -14086,  3045, -1533, -1425,  6236, -6626, 11348, -17290, 24313, -16047, 20045, -23767, 26713, -14141, 13900, -12281,  8944, -1796, -1992,  6938, -13004, 10028, -13924, 18007, -22032, 12848, -14321, 15231, -15359,  7234, -6154,  4307, -1542, -1161,  3768, -7254, 11993, -2350,  3727, -6606, 19190, },
	{  2147, -4147,  5893, -6246,   875,  1152, -5197, 11980, -5542,  9057, -13566, 18959, -12470, 15496, -18174, 19994, -10167,  9242, -6850,  2635,  1852, -6181, 11690, -18296, 12896, -16914, 20952, -24687, 13863, -14810, 14944, -14016,  5893, -4017,  1291,  2350, -3469,  6236, -9460, 13109, -8573, 10767, -13134, 15706, -2326,  2779, -3486,  5372, },
	{  1464, -4721, 11060, -21626,  9346, -14703, 21379, -28961,  9154, -10758, 11589, -11063,  4247, -1572, -2851,  9325, -9020, 14503, -21003, 28263, -17929, 21594, -24737, 26894, -13770, 13062, -11049,  7485, -1088, -2497,  7021, -12426,  9293, -12644, 16123, -19540, 11333, -12614, 13454, -13667,  6512, -5613,  3913, -1022,  -485,  1631, -4471, 27504, },
	{  3366, -7400, 13150, -20289,  6960, -8494,  8972, -7436,   675,  1642, -5432, 10990, -9255, 14007, -19638, 25882, -16143, 19098, -21381, 22478, -10906,  9387, -6390,  1663,  2485, -6789, 12041, -18112, 12388, -15847, 19212, -22208, 12257, -12886, 12799, -11795,  4835, -3110,   618,  2753, -3571,  6370, -9938, 14584, -2624,  3869, -6342, 15859, },
	{  1536, -2677,  2981, -1200, -1097,  3976, -8915, 16464, -6758, 10184, -14316, 18922, -11792, 13837, -15174, 15281, -6780,  4691, -1069, -4342,  5854, -10529, 16122, -22448, 14599, -17964, 21033, -23459, 12424, -12389, 11409, -9279,  2910,  -446, -2793,  6817, -5798,  8528, -11544, 14771, -9058, 10739, -12374, 13909, -1912,  2064, -2198,  2357, },
	{  2373, -6274, 13172, -23879,  9717, -14488, 19988, -25587,  7563, -8128,  7616, -5462,   527,  3105, -8422, 15585, -12306, 17657, -23627, 29852, -17906, 20417, -22056, 22368, -10436,  8550, -5315,   569,  2888, -6858, 11564, -16876, 11296, -14218, 17024, -19502, 10699, -11215, 11134, -10267,  4192, -2587,    82,  3746, -1225,  2562, -5682, 25280, },
	{  3149, -6698, 11343, -16433,  5163, -5469,  4284,  -668, -1615,  4553, -8896, 14811, -11164, 15636, -20601, 25685, -15170, 16921, -17660, 16892, -7048,  4386,  -244, -5526,  6488, -11012, 16217, -21894, 13870, -16675, 19117, -20910, 10869, -10632,  9576, -7533,  2173,    66, -3018,  6753, -5677,  8472, -11875, 16113, -2713,  3750, -5704, 12417, },
	{ -1203,   157,  3501, -11402,  6347, -11815, 19606, -29853, 10584, -14087, 17639, -20731, 11333, -11290,  9735, -6135,   -13,  4591, -10809, 18691, -14052, 19361, -25000, 30580, -17798, 19720, -20709, 20398, -9206,  7202, -4038,  -392,  3071, -6598, 10730, -15376, 10201, -12814, 15414, -17866, 10005, -10825, 11267, -11137,  1258,  -881,  -309, 30273, },
	{  2996, -7243, 14222, -24378,  9420, -13331, 17361, -20713,  5556, -5091,  3322,   255, -3073,  7392, -13225, 20590, -14665, 19539, -24606, 29419, -16700, 17926, -17992, 16486, -6500,  3589,   626, -6214,  6577, -10662, 15235, -20105, 12506, -14814, 16779, -18174,  9373, -9108,  8137, -6282,  1663,   512, -3615,  8064, -1845,  3260, -6388, 22584, },
	{  2743, -5623,  8950, -11803,  3155, -2282,  -402,  5764, -3678,  7019, -11611, 17486, -12256, 16168, -20168, 23801, -13230, 13702, -12895, 10366, -2842,  -758,  5743, -12151,  9953, -14395, 19214, -24134, 14398, -16380, 17759, -18258,  8793, -7727,  5793, -2872,  -570,  3161, -6364, 10201, -7349,  9951, -12964, 16525, -2621,  3396, -4766,  8989, },
	{   170, -2397,  7570, -17133,  8138, -13756, 21275, -30556, 10267, -12940, 15251, -16633,  8184, -6813,  3754,  1429, -4554,  9761, -16356, 24225, -16541, 21226, -25828, 29903, -16460, 17136, -16659, 14707, -5491,  2619,  1347, -6435,  6305, -9879, 13842, -18051, 11159, -13204, 15021, -16442,  8633, -8616,  7986, -6437,   416,   384, -2551, 29304, },
	{  3325, -7622, 14232, -23225,  8523, -11370, 13745, -14742,  3286, -1865,  -992,  5706, -6321, 11022, -16974, 24053, -15974, 20068, -23928, 27057, -14428, 14322, -12855,  9676, -2240, -1480,  6374, -12417,  9742, -13669, 17811, -21929, 12861, -14416, 15428, -15675,  7458, -6451,  4678, -1988,  -902,  3479, -6942, 11672, -2312,  3698, -6609, 19520, },
	{  2207, -4293,  6188, -6770,  1085,   843, -4777, 11453, -5390,  8901, -13433, 18889, -12494, 15612, -18421, 20416, -10486,  9687, -7435,  3362,  1423, -5699, 11178, -17789, 12667, -16738, 20863, -24721, 13961, -15008, 15259, -14460,  6183, -4377,  1715,  1871, -3211,  5971, -9205, 12884, -8489, 10728, -13163, 15836, -2361,  2845, -3613,  5698, },
	{  1355, -4531, 10785, -21295,  9269, -14668, 21444, -29208,  9289, -10996, 11967, -11615,  4625, -2062, -2250,  8627, -8637, 14114, -20645, 27986, -17862, 21635, -24925, 27267, -14068, 13486, -11609,  8184, -1502, -2029,  6517, -11911,  9046, -12430, 15966, -19469, 11356, -12713, 13647, -13973,  6732, -5911,  4303, -1525,  -404,  1523, -4318, 27702, },
	{  3375, -7446, 13295, -20626,  7126, -8786,  9440, -8132,   917,  1326, -5042, 10542, -9017, 13780, -19460, 25803, -16183, 19254, -21691, 22981, -11270,  9878, -7013,  2414,  2055, -6319, 11555, -17645, 12184, -15699, 19148, -22259, 12356, -13074, 13088, -12197,  5096, -3432,   998,  2322, -3335,  6124, -9695, 14365, -2604,  3866, -6388, 16208, },
	{  1600, -2829,  3279, -1707,  -903,  3704, -8568, 16063, -6656, 10102, -14285, 18985, -11898, 14049, -15527, 15809, -7147,  5171, -1663, -3642,  5463, -10117, 15719, -22093, 14470, -17912, 21090, -23657, 12610, -12676, 11807, -9794,  3225,  -814, -2383,  6380, -5577,  8320, -11366, 14647, -9037, 10776, -12490, 14135, -1960,  2142, -2333,  2652, },
	{  2293, -6141, 13004, -23730,  9710, -14555, 20191, -26009,  7748, -8420,  8043, -6049,   907,  2638, -7880, 14995, -12009, 17390, -23433, 29782, -17964, 20601, -22399, 22901, -10810,  9039, -5919,  1280,  2489, -6432, 11134, -16472, 11126, -14100, 16985, -19566, 10798, -11393, 11406, -10648,  4443, -2905,   473,  3272, -1154,  2477, -5582, 25532, },
	{  3181, -6789, 11559, -16871,  5359, -5790,  4770, -1354, -1388,  4272, -8572, 14469, -11005, 15518, -20567, 25785, -15316, 17196, -18095, 17515, -7464,  4911,  -874, -4807,  6098, -10613, 15839, -21575, 13761, -16642, 19186, -21108, 11045, -10897,  9936, -7993,  2453,  -260, -2655,  6364, -5479,  8283, -11714, 16007, -2712,  3773, -5785, 12771, },
	{ -1351,   437,  3044, -10736,  6128, -11560, 19350, -29661, 10577, -14154, 17825, -21086, 11624, -11721, 10331, -6912,   468,  4027, -10182, 18035, -13735, 19090, -24817, 30534, -17871, 19916, -21056, 20918, -9561,  7656, -4589,   244,  2720, -6228, 10362, -15036, 10061, -12723, 15396, -17947, 10111, -11017, 11572, -11594,  1343, -1015,   -54, 30335, },
	{  2946, -7171, 14163, -24406,  9480, -13490, 17680, -21271,  5777, -5415,  3769,  -325, -2716,  6979, -12777, 20143, -14470, 19408, -24582, 29555, -16876, 18236, -18464, 17140, -6924,  4109,    19, -5537,  6219, -10305, 14905, -19837, 12421, -14799, 16856, -18367,  9538, -9352,  8469, -6709,  1927,   197, -3249,  7650, -1788,  3200, -6339, 22879, },
	{  2792, -5747,  9216, -12302,  3366, -2610,    69,  5132, -3481,  6791, -11372, 17269, -12183, 16164, -20275, 24067, -13469, 14073, -13422, 11065, -3281,  -234,  5148, -11511,  9629, -14093, 18966, -23979, 14389, -16461, 17954, -18587,  9033, -8049,  6200, -3359,  -291,  2853, -6040,  9879, -7200,  9830, -12893, 16534, -2638,  3442, -4874,  9337, },
	{    36, -2152,  7189, -16613,  7983, -13603, 21173, -30581, 10331, -13097, 15542, -17101,  8530, -7290,  4375,   662, -4104,  9263, -15840, 23734, -16338, 21101, -25823, 30066, -16648, 17455, -17127, 15336, -5889,  3097,   798, -5835,  5993, -9573, 13566, -17833, 11095, -13205, 15108, -16639,  8800, -8868,  8346, -6935,   503,   259, -2342, 29433, },
	{  3304, -7609, 14276, -23414,  8640, -11603, 14153, -15392,  3526, -2198,  -557,  5170, -6010, 10686, -16645, 23775, -15890, 20076, -24071, 27383, -14705, 14735, -13421, 10403, -2683,  -965,  5805, -11819,  9447, -13403, 17602, -21810, 12864, -14502, 15615, -15980,  7678, -6743,  5047, -2434,  -643,  3187, -6624, 11341, -2272,  3665, -6608, 19848, },
	{  2266, -4438,  6482, -7294,  1296,   532, -4351, 10914, -5234,  8738, -13290, 18806, -12509, 15717, -18657, 20825, -10798, 10127, -8016,  4088,   991, -5211, 10657, -17267, 12428, -16550, 20759, -24737, 14049, -15195, 15563, -14895,  6470, -4734,  2139,  1390, -2950,  5702, -8942, 12649, -8398, 10682, -13184, 15955, -2395,  2909, -3738,  6026, },
	{  1244, -4335, 10500, -20946,  9184, -14622, 21494, -29436,  9417, -11228, 12338, -12161,  5002, -2552, -1645,  7919, -8247, 13713, -20271, 27689, -17783, 21660, -25095, 27622, -14357, 13902, -12163,  8878, -1916, -1559,  6006, -11386,  8793, -12207, 15798, -19384, 11371, -12803, 13830, -14269,  6947, -6206,  4692, -2029,  -323,  1414, -4159, 27894, },
	{  3382, -7488, 13430, -20952,  7289, -9073,  9904, -8825,  1160,  1006, -4647, 10083, -8770, 13542, -19268, 25705, -16212, 19397, -21987, 23469, -11628, 10363, -7633,  3165,  1621, -5843, 11060, -17163, 11971, -15540, 19070, -22294, 12446, -13252, 13369, -12592,  5354, -3752,  1379,  1887, -3096,  5873, -9444, 14136, -2583,  3861, -6429, 16555, },
	{  1663, -2982,  3578, -2217,  -707,  3428, -8213, 15647, -6548, 10012, -14243, 19034, -11996, 14252, -15870, 16328, -7510,  5648, -2258, -2937,  5066, -9696, 15303, -21721, 14330, -17848, 21132, -23840, 12788, -12955, 12198, -10303,  3539, -1182, -1970,  5937, -5351,  8104, -11180, 14511, -9009, 10804, -12597, 14352, -2007,  2220, -2467,  2950, },
	{  2209, -6002, 12825, -23561,  9696, -14612, 20381, -26414,  7929, -8708,  8467, -6633,  1289,  2168, -7331, 14392, -11702, 17109, -23221, 29691, -18010, 20771, -22727, 23419, -11178,  9523, -6521,  1992,  2088, -6001, 10695, -16055, 10947, -13973, 16933, -19617, 10888, -11564, 11671, -11021,  4691, -3221,   865,  2795, -1082,  2389, -5475, 25778, },
	{  3211, -6876, 11769, -17300,  5553, -6110,  5256, -2043, -1159,  3987, -8240, 14115, -10837, 15390, -20519, 25867, -15452, 17460, -18519, 18129, -7877,  5435, -1505, -4083,  5703, -10206, 15449, -21239, 13642, -16597, 19242, -21292, 11214, -11154, 10291, -8450,  2731,  -586, -2288,  5970, -5276,  8088, -11544, 15890, -2710,  3794, -5862, 13126, },
	{ -1500,   720,  2580, -10056,  5904, -11295, 19079, -29446, 10562, -14212, 17998, -21427, 11907, -12145, 10921, -7687,   949,  3458, -9545, 17364, -13408, 18804, -24615, 30465, -17930, 20098, -21388, 21424, -9910,  8106, -5137,   882,  2366, -5853,  9985, -14684,  9914, -12624, 15367, -18016, 10210, -11202, 11869, -12045,  1428, -1149,   206, 30390, },
	{  2892, -7093, 14093, -24416,  9533, -13639, 17989, -21817,  5994, -5736,  4215,  -908, -2356,  6558, -12318, 19681, -14264, 19262, -24541, 29670, -17039, 18535, -18925, 17783, -7344,  4627,  -590, -4855,  5856, -9939, 14565, -19553, 12327, -14773, 16922, -18547,  9697, -9591,  8796, -7134,  2191,  -120, -2879,  7228, -1729,  3138, -6284, 23170, },
	{  2839, -5869,  9478, -12798,  3576, -2938,   543,  4493, -3280,  6557, -11123, 17038, -12101, 16149, -20368, 24317, -13699, 14436, -13941, 11759, -3719,   292,  4547, -10860,  9297, -13781, 18705, -23807, 14369, -16531, 18136, -18904,  9268, -8366,  6602, -3845,   -10,  2543, -5712,  9550, -7046,  9703, -12812, 16531, -2654,  3486, -4979,  9685, },
	{   -99, -1903,  6799, -16077,  7822, -13440, 21055, -30583, 10388, -13245, 15822, -17560,  8872, -7764,  4996,  -109, -3650,  8757, -15311, 23225, -16122, 20961, -25801, 30207, -16825, 17761, -17583, 15956, -6284,  3574,   248, -5229,  5675, -9260, 13279, -17601, 11024, -13197, 15185, -16825,  8961, -9115,  8700, -7429,   589,   133, -2128, 29556, },
	{  3281, -7591, 14311, -23588,  8751, -11829, 14554, -16035,  3765, -2531,  -120,  4627, -5694, 10342, -16303, 23478, -15795, 20071, -24198, 27690, -14973, 15140, -13979, 11126, -3126,  -448,  5230, -11212,  9146, -13126, 17380, -21675, 12859, -14577, 15791, -16274,  7893, -7032,  5414, -2880,  -382,  2891, -6300, 11001, -2230,  3630, -6601, 20173, },
	{  2324, -4581,  6774, -7817,  1508,   217, -3919, 10364, -5073,  8568, -13137, 18708, -12515, 15812, -18880, 21220, -11104, 10562, -8593,  4814,   557, -4718, 10126, -16731, 12180, -16350, 20640, -24737, 14127, -15372, 15856, -15320,  6754, -5089,  2562,   907, -2686,  5427, -8672, 12405, -8302, 10628, -13195, 16063, -2427,  2972, -3863,  6356, },
	{  1131, -4133, 10203, -20579,  9093, -14565, 21529, -29644,  9539, -11452, 12702, -12702,  5376, -3043, -1037,  7204, -7850, 13301, -19881, 27371, -17690, 21670, -25247, 27958, -14637, 14310, -12710,  9568, -2329, -1086,  5491, -10852,  8533, -11975, 15618, -19285, 11378, -12884, 14004, -14556,  7158, -6497,  5079, -2534,  -240,  1303, -3996, 28079, },
	{  3386, -7525, 13558, -21264,  7447, -9356, 10363, -9517,  1403,   684, -4246,  9615, -8517, 13293, -19060, 25588, -16230, 19527, -22269, 23942, -11979, 10843, -8249,  3916,  1185, -5361, 10556, -16669, 11750, -15369, 18979, -22314, 12528, -13421, 13641, -12979,  5609, -4071,  1759,  1451, -2855,  5616, -9185, 13895, -2559,  3854, -6467, 16901, },
	{  1727, -3135,  3877, -2731,  -508,  3148, -7849, 15218, -6436,  9914, -14191, 19071, -12085, 14446, -16204, 16837, -7869,  6123, -2853, -2228,  4665, -9268, 14875, -21332, 14180, -17770, 21159, -24006, 12957, -13225, 12581, -10806,  3851, -1551, -1554,  5489, -5121,  7883, -10985, 14366, -8974, 10825, -12696, 14560, -2052,  2296, -2601,  3251, },
	{  2123, -5857, 12634, -23375,  9676, -14659, 20557, -26802,  8104, -8991,  8886, -7216,  1670,  1694, -6774, 13777, -11386, 16816, -22992, 29579, -18042, 20927, -23041, 23923, -11538, 10001, -7120,  2704,  1684, -5564, 10247, -15626, 10760, -13835, 16869, -19654, 10972, -11727, 11929, -11388,  4936, -3536,  1258,  2313, -1008,  2299, -5364, 26019, },
	{  3238, -6959, 11971, -17719,  5745, -6427,  5741, -2735,  -928,  3697, -7901, 13749, -10660, 15250, -20455, 25931, -15578, 17712, -18931, 18731, -8285,  5956, -2137, -3353,  5302, -9791, 15047, -20887, 13513, -16540, 19284, -21461, 11375, -11404, 10639, -8901,  3009,  -912, -1920,  5570, -5069,  7887, -11365, 15761, -2705,  3813, -5936, 13480, },
	{ -1650,  1005,  2110, -9364,  5674, -11020, 18792, -29209, 10539, -14259, 18159, -21755, 12183, -12563, 11507, -8459,  1432,  2885, -8899, 16679, -13070, 18504, -24395, 30375, -17978, 20266, -21706, 21916, -10253,  8551, -5683,  1520,  2009, -5473,  9601, -14321,  9759, -12515, 15327, -18072, 10303, -11379, 12158, -12489,  1512, -1284,   470, 30437, },
	{  2836, -7009, 14012, -24408,  9579, -13780, 18287, -22350,  6209, -6056,  4659, -1493, -1993,  6132, -11848, 19203, -14047, 19102, -24483, 29765, -17192, 18822, -19373, 18416, -7759,  5143, -1200, -4168,  5488, -9566, 14213, -19255, 12223, -14737, 16975, -18714,  9849, -9823,  9118, -7554,  2453,  -437, -2506,  6800, -1669,  3072, -6224, 23458, },
	{  2885, -5987,  9736, -13288,  3786, -3267,  1020,  3847, -3075,  6317, -10865, 16794, -12010, 16122, -20447, 24551, -13921, 14790, -14452, 12447, -4156,   819,  3942, -10200,  8958, -13457, 18429, -23618, 14339, -16589, 18306, -19207,  9496, -8678,  7001, -4329,   271,  2230, -5379,  9212, -6887,  9568, -12723, 16517, -2668,  3528, -5082, 10035, },
	{  -236, -1649,  6400, -15526,  7654, -13266, 20922, -30564, 10438, -13385, 16092, -18008,  9208, -8235,  5616,  -882, -3192,  8243, -14770, 22698, -15895, 20805, -25759, 30327, -16991, 18056, -18027, 16567, -6676,  4050,  -304, -4618,  5353, -8939, 12982, -17356, 10944, -13179, 15250, -16999,  9117, -9357,  9050, -7921,   676,     5, -1909, 29672, },
	{  3254, -7567, 14335, -23745,  8857, -12049, 14946, -16670,  4003, -2864,   320,  4079, -5372,  9989, -15947, 23164, -15688, 20051, -24309, 27979, -15231, 15534, -14529, 11842, -3568,    71,  4649, -10595,  8837, -12840, 17145, -21525, 12844, -14643, 15956, -16558,  8102, -7316,  5777, -3325,  -119,  2592, -5970, 10651, -2186,  3592, -6590, 20495, },
	{  2382, -4722,  7064, -8339,  1720,   -99, -3481,  9803, -4907,  8391, -12974, 18597, -12512, 15895, -19090, 21602, -11404, 10990, -9166,  5539,   121, -4220,  9586, -16182, 11923, -16137, 20505, -24718, 14196, -15539, 16140, -15735,  7033, -5441,  2985,   422, -2420,  5148, -8396, 12151, -8199, 10566, -13197, 16161, -2458,  3033, -3985,  6689, },
	{  1014, -3926,  9897, -20194,  8994, -14498, 21549, -29832,  9655, -11670, 13058, -13235,  5749, -3533,  -425,  6480, -7446, 12879, -19476, 27032, -17585, 21665, -25382, 28276, -14906, 14708, -13249, 10253, -2742,  -611,  4970, -10309,  8266, -11733, 15426, -19172, 11377, -12956, 14169, -14834,  7365, -6785,  5464, -3039,  -157,  1190, -3827, 28259, },
	{  3387, -7556, 13676, -21564,  7602, -9635, 10819, -10205,  1647,   360, -3841,  9138, -8256, 13034, -18839, 25452, -16236, 19643, -22535, 24400, -12323, 11316, -8861,  4667,   747, -4874, 10042, -16161, 11519, -15186, 18874, -22318, 12601, -13582, 13904, -13357,  5861, -4387,  2139,  1011, -2611,  5355, -8919, 13644, -2534,  3843, -6500, 17246, },
	{  1790, -3287,  4177, -3247,  -308,  2863, -7478, 14776, -6318,  9809, -14128, 19093, -12167, 14630, -16527, 17337, -8223,  6595, -3449, -1515,  4260, -8831, 14435, -20928, 14019, -17680, 21172, -24156, 13117, -13486, 12956, -11303,  4161, -1919, -1136,  5036, -4887,  7656, -10782, 14209, -8933, 10839, -12787, 14758, -2097,  2371, -2735,  3557, },
	{  2033, -5706, 12433, -23169,  9648, -14696, 20720, -27174,  8275, -9269,  9301, -7796,  2053,  1217, -6210, 13149, -11060, 16509, -22745, 29445, -18063, 21068, -23338, 24410, -11891, 10474, -7715,  3417,  1277, -5121,  9791, -15184, 10565, -13687, 16793, -19677, 11048, -11882, 12179, -11748,  5179, -3850,  1652,  1828,  -934,  2206, -5247, 26255, },
	{  3264, -7037, 12167, -18130,  5934, -6742,  6226, -3429,  -695,  3403, -7555, 13372, -10475, 15098, -20377, 25977, -15693, 17953, -19331, 19322, -8689,  6474, -2769, -2619,  4897, -9367, 14634, -20519, 13374, -16471, 19313, -21615, 11529, -11646, 10980, -9347,  3285, -1239, -1548,  5165, -4858,  7679, -11178, 15620, -2699,  3829, -6007, 13834, },
	{ -1801,  1293,  1634, -8660,  5438, -10735, 18490, -28950, 10509, -14297, 18309, -22068, 12451, -12973, 12086, -9228,  1915,  2308, -8245, 15979, -12721, 18190, -24157, 30263, -18012, 20421, -22009, 22394, -10590,  8991, -6227,  2159,  1650, -5087,  9209, -13947,  9597, -12397, 15276, -18115, 10388, -11549, 12441, -12927,  1596, -1419,   738, 30478, },
	{  2776, -6918, 13920, -24382,  9619, -13912, 18574, -22870,  6420, -6372,  5103, -2079, -1626,  5699, -11367, 18709, -13819, 18928, -24407, 29838, -17332, 19096, -19809, 19037, -8171,  5657, -1810, -3477,  5115, -9185, 13850, -18942, 12111, -14690, 17017, -18869,  9995, -10049,  9435, -7970,  2715,  -755, -2130,  6364, -1607,  3004, -6159, 23741, },
	{  2929, -6102,  9989, -13773,  3994, -3595,  1499,  3194, -2868,  6071, -10598, 16537, -11910, 16083, -20512, 24769, -14133, 15134, -14955, 13128, -4591,  1347,  3332, -9530,  8611, -13123, 18140, -23411, 14299, -16636, 18463, -19498,  9719, -8985,  7396, -4812,   553,  1914, -5041,  8868, -6722,  9425, -12624, 16492, -2680,  3568, -5182, 10386, },
	{  -375, -1392,  5993, -14958,  7479, -13082, 20772, -30523, 10481, -13515, 16353, -18445,  9540, -8701,  6234, -1658, -2730,  7722, -14216, 22153, -15655, 20635, -25700, 30427, -17145, 18339, -18461, 17167, -7063,  4525,  -857, -4003,  5027, -8611, 12676, -17099, 10856, -13152, 15306, -17162,  9267, -9592,  9395, -8410,   762,  -123, -1686, 29781, },
	{  3225, -7536, 14349, -23887,  8958, -12261, 15330, -17296,  4239, -3197,   761,  3525, -5045,  9627, -15579, 22832, -15569, 20016, -24402, 28248, -15479, 15919, -15070, 12552, -4008,   591,  4064, -9969,  8521, -12544, 16898, -21359, 12820, -14698, 16110, -16831,  8307, -7596,  6138, -3768,   144,  2290, -5635, 10292, -2140,  3551, -6575, 20814, },
	{  2439, -4862,  7351, -8859,  1932,  -418, -3038,  9232, -4737,  8207, -12800, 18472, -12500, 15968, -19288, 21970, -11696, 11412, -9735,  6262,  -316, -3718,  9038, -15619, 11656, -15913, 20356, -24682, 14255, -15695, 16412, -16141,  7307, -5790,  3406,   -64, -2151,  4865, -8112, 11887, -8090, 10497, -13189, 16247, -2486,  3092, -4106,  7024, },
	{   896, -3714,  9580, -19790,  8888, -14419, 21553, -29999,  9764, -11880, 13407, -13762,  6119, -4023,   190,  5749, -7035, 12445, -19056, 26673, -17467, 21645, -25500, 28574, -15166, 15097, -13780, 10932, -3154,  -135,  4444, -9757,  7993, -11483, 15223, -19046, 11368, -13019, 14323, -15101,  7567, -7069,  5847, -3545,   -74,  1075, -3653, 28432, },
	{  3386, -7582, 13785, -21851,  7752, -9908, 11269, -10891,  1890,    35, -3430,  8652, -7989, 12765, -18603, 25298, -16231, 19746, -22787, 24842, -12659, 11783, -9469,  5416,   307, -4382,  9521, -15640, 11280, -14993, 18755, -22306, 12665, -13733, 14158, -13727,  6109, -4701,  2519,   570, -2364,  5089, -8646, 13381, -2506,  3830, -6529, 17589, },
	{  1853, -3438,  4476, -3765,  -106,  2575, -7098, 14320, -6195,  9696, -14055, 19102, -12240, 14804, -16840, 17826, -8574,  7064, -4043,  -799,  3850, -8387, 13984, -20507, 13848, -17577, 21170, -24289, 13269, -13739, 13323, -11793,  4468, -2286,  -717,  4578, -4649,  7422, -10571, 14042, -8886, 10844, -12868, 14947, -2140,  2445, -2868,  3865, },
	{  1941, -5549, 12220, -22945,  9612, -14722, 20869, -27527,  8440, -9541,  9712, -8374,  2435,   737, -5640, 12510, -10726, 16190, -22482, 29290, -18070, 21195, -23620, 24882, -12237, 10940, -8306,  4128,   869, -4675,  9326, -14731, 10362, -13529, 16705, -19687, 11116, -12029, 12420, -12101,  5419, -4161,  2046,  1338,  -858,  2111, -5125, 26486, },
	{  3287, -7111, 12356, -18530,  6120, -7055,  6708, -4125,  -460,  3105, -7201, 12983, -10282, 14935, -20283, 26005, -15797, 18181, -19719, 19901, -9088,  6990, -3402, -1881,  4487, -8936, 14209, -20136, 13225, -16391, 19328, -21754, 11675, -11881, 11314, -9788,  3560, -1566, -1175,  4756, -4643,  7465, -10982, 15467, -2691,  3842, -6074, 14188, },
	{ -1952,  1582,  1153, -7943,  5196, -10440, 18173, -28669, 10471, -14325, 18446, -22367, 12712, -13375, 12659, -9993,  2399,  1727, -7583, 15266, -12363, 17862, -23902, 30129, -18034, 20561, -22298, 22858, -10920,  9426, -6767,  2798,  1289, -4698,  8809, -13562,  9427, -12270, 15214, -18146, 10467, -11711, 12716, -13358,  1679, -1555,  1010, 30511, },
	{  2713, -6821, 13816, -24338,  9652, -14035, 18848, -23377,  6628, -6686,  5546, -2667, -1257,  5260, -10877, 18200, -13580, 18740, -24313, 29891, -17461, 19357, -20232, 19646, -8577,  6168, -2421, -2780,  4737, -8797, 13477, -18615, 11990, -14633, 17047, -19010, 10134, -10268,  9745, -8382,  2976, -1074, -1751,  5923, -1544,  2934, -6089, 24019, },
	{  2972, -6214, 10238, -14251,  4201, -3923,  1981,  2534, -2657,  5820, -10322, 16267, -11802, 16033, -20562, 24969, -14337, 15469, -15449, 13802, -5025,  1876,  2718, -8852,  8258, -12779, 17837, -23188, 14248, -16671, 18608, -19776,  9935, -9286,  7787, -5292,   835,  1597, -4698,  8516, -6552,  9276, -12515, 16454, -2690,  3605, -5279, 10737, },
	{  -516, -1131,  5578, -14375,  7298, -12886, 20607, -30459, 10517, -13637, 16602, -18871,  9866, -9164,  6850, -2435, -2264,  7193, -13650, 21591, -15404, 20449, -25622, 30505, -17287, 18609, -18882, 17756, -7447,  4997, -1410, -3383,  4696, -8276, 12359, -16829, 10761, -13115, 15350, -17313,  9410, -9822,  9735, -8895,   849,  -253, -1457, 29883, },
	{  3192, -7500, 14352, -24012,  9052, -12466, 15705, -17914,  4473, -3529,  1205,  2967, -4713,  9257, -15198, 22483, -15439, 19967, -24479, 28499, -15716, 16294, -15602, 13255, -4447,  1112,  3475, -9334,  8198, -12239, 16638, -21177, 12788, -14743, 16253, -17092,  8506, -7871,  6495, -4210,   407,  1986, -5295,  9924, -2093,  3507, -6554, 21130, },
	{  2494, -5000,  7637, -9378,  2145,  -739, -2590,  8651, -4563,  8016, -12617, 18333, -12479, 16029, -19473, 22324, -11981, 11828, -10298,  6984,  -754, -3211,  8482, -15044, 11380, -15677, 20192, -24629, 14304, -15840, 16673, -16535,  7578, -6136,  3826,  -551, -1881,  4577, -7823, 11615, -7975, 10420, -13172, 16323, -2514,  3150, -4226,  7362, },
	{   775, -3496,  9254, -19369,  8774, -14330, 21542, -30146,  9867, -12083, 13748, -14281,  6486, -4512,   806,  5012, -6617, 12002, -18620, 26294, -17336, 21609, -25600, 28852, -15416, 15476, -14303, 11606, -3565,   343,  3914, -9196,  7713, -11224, 15009, -18905, 11351, -13073, 14469, -15359,  7765, -7348,  6227, -4050,    11,   959, -3473, 28599, },
	{  3382, -7602, 13886, -22123,  7897, -10176, 11714, -11572,  2134,  -293, -3015,  8158, -7714, 12485, -18352, 25126, -16214, 19835, -23023, 25267, -12986, 12243, -10072,  6164,  -134, -3886,  8991, -15107, 11032, -14788, 18623, -22278, 12720, -13875, 14402, -14088,  6354, -5013,  2898,   128, -2114,  4819, -8366, 13108, -2477,  3813, -6553, 17930, },
	{  1916, -3589,  4776, -4285,    98,  2282, -6711, 13851, -6067,  9575, -13972, 19098, -12304, 14969, -17141, 18304, -8919,  7530, -4637,   -80,  3436, -7935, 13521, -20070, 13667, -17461, 21152, -24404, 13411, -13982, 13681, -12276,  4773, -2653,  -296,  4116, -4408,  7183, -10352, 13865, -8832, 10843, -12941, 15126, -2182,  2518, -3000,  4177, },
	{  1846, -5385, 11997, -22702,  9570, -14738, 21003, -27864,  8601, -9808, 10118, -8948,  2818,   254, -5063, 11859, -10382, 15858, -22202, 29114, -18064, 21307, -23886, 25338, -12576, 11400, -8893,  4839,   459, -4223,  8854, -14267, 10151, -13361, 16605, -19682, 11176, -12168, 12654, -12445,  5655, -4471,  2440,   846,  -781,  2014, -4997, 26711, },
	{  3308, -7181, 12538, -18921,  6303, -7364,  7190, -4821,  -223,  2804, -6841, 12584, -10081, 14760, -20175, 26014, -15891, 18397, -20093, 20468, -9481,  7502, -4033, -1140,  4073, -8497, 13772, -19738, 13067, -16298, 19329, -21879, 11813, -12108, 11641, -10222,  3832, -1892,  -800,  4341, -4424,  7246, -10778, 15302, -2680,  3853, -6137, 14541, },
	{ -2104,  1874,   666, -7215,  4949, -10136, 17841, -28365, 10425, -14342, 18570, -22652, 12964, -13770, 13225, -10754,  2883,  1143, -6913, 14540, -11995, 17521, -23628, 29974, -18043, 20688, -22571, 23306, -11243,  9855, -7304,  3437,   926, -4304,  8402, -13167,  9251, -12134, 15141, -18164, 10538, -11866, 12982, -13781,  1762, -1690,  1286, 30537, },
	{  2647, -6717, 13702, -24276,  9679, -14148, 19112, -23870,  6833, -6996,  5986, -3255,  -885,  4816, -10377, 17677, -13331, 18538, -24201, 29923, -17578, 19605, -20642, 20244, -8979,  6676, -3032, -2081,  4355, -8401, 13093, -18275, 11860, -14565, 17065, -19139, 10266, -10480, 10050, -8789,  3235, -1393, -1369,  5475, -1479,  2860, -6013, 24294, },
	{  3012, -6323, 10481, -14724,  4407, -4250,  2464,  1869, -2443,  5563, -10038, 15984, -11684, 15971, -20597, 25152, -14530, 15794, -15933, 14468, -5456,  2405,  2100, -8166,  7897, -12425, 17520, -22947, 14188, -16694, 18740, -20041, 10144, -9581,  8173, -5770,  1117,  1277, -4352,  8157, -6377,  9120, -12398, 16404, -2698,  3640, -5374, 11090, },
	{  -658,  -866,  5155, -13776,  7110, -12680, 20426, -30374, 10545, -13749, 16842, -19286, 10186, -9621,  7463, -3214, -1795,  6657, -13072, 21011, -15141, 20248, -25525, 30561, -17417, 18867, -19291, 18335, -7826,  5467, -1964, -2759,  4361, -7934, 12033, -16546, 10658, -13069, 15384, -17452,  9547, -10045, 10069, -9376,   935,  -384, -1224, 29978, },
	{  3157, -7458, 14345, -24121,  9141, -12663, 16072, -18522,  4705, -3860,  1649,  2403, -4376,  8879, -14805, 22116, -15298, 19904, -24538, 28730, -15944, 16658, -16124, 13951, -4884,  1633,  2881, -8691,  7868, -11924, 16365, -20980, 12745, -14777, 16385, -17342,  8699, -8141,  6848, -4651,   671,  1680, -4950,  9548, -2044,  3460, -6529, 21443, },
	{  2549, -5135,  7919, -9894,  2358, -1061, -2138,  8060, -4384,  7819, -12423, 18180, -12449, 16080, -19644, 22663, -12259, 12236, -10857,  7702, -1193, -2700,  7919, -14457, 11096, -15428, 20014, -24558, 14343, -15975, 16924, -16919,  7843, -6478,  4245, -1040, -1608,  4286, -7527, 11333, -7854, 10335, -13146, 16386, -2539,  3205, -4343,  7701, },
	{   652, -3274,  8917, -18931,  8654, -14229, 21515, -30272,  9964, -12279, 14081, -14792,  6850, -5000,  1425,  4267, -6193, 11548, -18170, 25895, -17192, 21557, -25682, 29111, -15656, 15845, -14817, 12273, -3974,   821,  3380, -8628,  7428, -10956, 14784, -18751, 11326, -13118, 14604, -15607,  7957, -7624,  6604, -4555,    95,   841, -3289, 28760, },
	{  3376, -7617, 13976, -22383,  8038, -10438, 12154, -12250,  2378,  -622, -2596,  7656, -7433, 12195, -18088, 24934, -16185, 19910, -23243, 25676, -13306, 12696, -10669,  6909,  -576, -3386,  8453, -14562, 10775, -14573, 18477, -22234, 12767, -14007, 14637, -14440,  6594, -5321,  3275,  -317, -1863,  4544, -8078, 12825, -2446,  3794, -6573, 18269, },
	{  1978, -3739,  5075, -4807,   304,  1985, -6317, 13369, -5934,  9447, -13878, 19080, -12360, 15124, -17432, 18771, -9259,  7993, -5230,   642,  3018, -7476, 13047, -19618, 13475, -17332, 21119, -24503, 13544, -14216, 14031, -12751,  5076, -3019,   126,  3650, -4162,  6938, -10125, 13678, -8771, 10833, -13005, 15294, -2222,  2590, -3131,  4491, },
	{  1748, -5216, 11762, -22440,  9520, -14743, 21123, -28182,  8756, -10070, 10518, -9518,  3200,  -231, -4481, 11198, -10030, 15513, -21905, 28916, -18046, 21404, -24136, 25777, -12906, 11854, -9476,  5548,    48, -3768,  8375, -13791,  9932, -13183, 16493, -19663, 11229, -12298, 12879, -12783,  5889, -4779,  2834,   351,  -704,  1915, -4864, 26930, },
	{  3327, -7246, 12712, -19301,  6483, -7670,  7669, -5519,    15,  2498, -6474, 12173, -9872, 14575, -20052, 26004, -15973, 18602, -20455, 21023, -9869,  8011, -4664,  -395,  3654, -8051, 13325, -19324, 12899, -16194, 19317, -21988, 11942, -12327, 11961, -10651,  4103, -2218,  -423,  3923, -4202,  7020, -10565, 15127, -2668,  3861, -6197, 14894, },
	{ -2256,  2167,   175, -6476,  4697, -9823, 17494, -28039, 10371, -14349, 18682, -22922, 13209, -14156, 13784, -11510,  3366,   556, -6236, 13801, -11617, 17166, -23338, 29797, -18040, 20800, -22829, 23739, -11559, 10278, -7837,  4075,   561, -3906,  7988, -12762,  9068, -11989, 15057, -18169, 10602, -12012, 13241, -14197,  1843, -1826,  1566, 30556, },
	{  2579, -6608, 13576, -24195,  9698, -14252, 19362, -24348,  7033, -7304,  6424, -3844,  -511,  4366, -9868, 17138, -13072, 18322, -24072, 29933, -17682, 19840, -21038, 20829, -9375,  7181, -3643, -1377,  3969, -7999, 12699, -17920, 11722, -14487, 17071, -19254, 10392, -10686, 10348, -9191,  3493, -1712,  -985,  5021, -1413,  2784, -5932, 24563, },
	{  3051, -6428, 10719, -15190,  4611, -4577,  2948,  1199, -2226,  5300, -9745, 15689, -11557, 15898, -20619, 25319, -14714, 16109, -16408, 15127, -5885,  2934,  1478, -7472,  7530, -12061, 17191, -22689, 14117, -16705, 18858, -20292, 10347, -9870,  8555, -6245,  1399,   956, -4001,  7791, -6197,  8956, -12271, 16343, -2705,  3673, -5466, 11443, },
	{  -801,  -598,  4724, -13163,  6915, -12464, 20229, -30266, 10566, -13852, 17070, -19688, 10501, -10074,  8074, -3993, -1323,  6114, -12483, 20415, -14866, 20031, -25411, 30596, -17536, 19112, -19687, 18902, -8201,  5934, -2518, -2132,  4022, -7586, 11698, -16251, 10546, -13014, 15407, -17579,  9678, -10263, 10397, -9852,  1022,  -515,  -986, 30066, },
	{  3118, -7409, 14327, -24213,  9224, -12852, 16429, -19121,  4935, -4190,  2095,  1836, -4034,  8493, -14400, 21732, -15144, 19827, -24580, 28941, -16161, 17011, -16637, 14639, -5319,  2155,  2284, -8040,  7532, -11599, 16080, -20768, 12694, -14802, 16506, -17580,  8887, -8407,  7198, -5089,   936,  1371, -4600,  9163, -1993,  3411, -6498, 21752, },
	{  2603, -5269,  8199, -10408,  2571, -1385, -1680,  7460, -4201,  7614, -12220, 18014, -12410, 16119, -19803, 22988, -12529, 12638, -11409,  8418, -1633, -2186,  7348, -13858, 10803, -15169, 19820, -24469, 14371, -16098, 17163, -17292,  8103, -6817,  4661, -1528, -1333,  3990, -7224, 11043, -7727, 10243, -13111, 16439, -2563,  3259, -4459,  8042, },
	{   526, -3046,  8571, -18475,  8526, -14118, 21473, -30377, 10054, -12466, 14405, -15295,  7211, -5486,  2045,  3517, -5764, 11084, -17706, 25476, -17036, 21490, -25746, 29350, -15885, 16204, -15322, 12932, -4382,  1300,  2842, -8053,  7136, -10680, 14548, -18583, 11292, -13154, 14729, -15844,  8144, -7895,  6977, -5059,   181,   721, -3099, 28914, },
	{  3366, -7626, 14058, -22627,  8174, -10695, 12587, -12922,  2621,  -952, -2173,  7146, -7145, 11896, -17810, 24725, -16145, 19972, -23448, 26068, -13617, 13141, -11261,  7652, -1019, -2882,  7908, -14006, 10511, -14346, 18318, -22175, 12804, -14129, 14862, -14783,  6831, -5627,  3652,  -762, -1609,  4265, -7784, 12531, -2413,  3773, -6589, 18606, },
	{  2040, -3889,  5373, -5330,   510,  1685, -5916, 12874, -5795,  9312, -13774, 19048, -12408, 15268, -17712, 19226, -9594,  8451, -5821,  1366,  2597, -7011, 12563, -19150, 13273, -17191, 21072, -24585, 13668, -14441, 14371, -13219,  5376, -3383,   549,  3180, -3913,  6687, -9890, 13480, -8705, 10816, -13060, 15453, -2261,  2660, -3261,  4809, },
	{  1647, -5041, 11516, -22160,  9463, -14738, 21229, -28482,  8906, -10325, 10913, -10084,  3581,  -717, -3893, 10526, -9670, 15156, -21591, 28697, -18015, 21486, -24369, 26198, -13228, 12300, -10053,  6255,  -365, -3309,  7888, -13304,  9706, -12996, 16369, -19631, 11274, -12421, 13096, -13112,  6119, -5085,  3227,  -146,  -625,  1813, -4726, 27144, },
	{  3343, -7306, 12878, -19670,  6659, -7973,  8145, -6217,   254,  2190, -6101, 11752, -9654, 14378, -19915, 25976, -16045, 18793, -20804, 21564, -10251,  8515, -5293,   352,  3232, -7598, 12867, -18896, 12721, -16078, 19291, -22081, 12064, -12538, 12272, -11073,  4371, -2543,   -46,  3501, -3975,  6789, -10344, 14939, -2654,  3866, -6253, 15246, },
	{ -2409,  2462,  -322, -5726,  4439, -9500, 17132, -27692, 10310, -14346, 18780, -23176, 13445, -14534, 14336, -12261,  3849,   -33, -5553, 13050, -11229, 16798, -23029, 29598, -18023, 20897, -23072, 24157, -11868, 10695, -8365,  4711,   196, -3504,  7568, -12346,  8877, -11835, 14963, -18161, 10658, -12151, 13491, -14604,  1924, -1961,  1850, 30568, },
	{  2506, -6492, 13439, -24097,  9711, -14346, 19601, -24812,  7230, -7607,  6860, -4433,  -135,  3911, -9349, 16586, -12802, 18092, -23926, 29922, -17774, 20062, -21421, 21400, -9766,  7683, -4252,  -672,  3579, -7590, 12294, -17552, 11575, -14398, 17065, -19356, 10510, -10884, 10640, -9587,  3749, -2031,  -598,  4562, -1346,  2706, -5846, 24828, },
	{  3089, -6529, 10951, -15649,  4813, -4902,  3433,   524, -2006,  5033, -9443, 15380, -11422, 15812, -20625, 25467, -14889, 16414, -16872, 15777, -6310,  3463,   854, -6770,  7156, -11688, 16848, -22415, 14036, -16705, 18964, -20529, 10543, -10153,  8931, -6716,  1681,   634, -3647,  7419, -6012,  8786, -12135, 16270, -2709,  3703, -5555, 11797, },
	{  -946,  -326,  4285, -12535,  6714, -12237, 20016, -30135, 10579, -13946, 17287, -20078, 10809, -10521,  8681, -4773,  -849,  5565, -11884, 19802, -14580, 19800, -25277, 30609, -17642, 19345, -20071, 19457, -8571,  6398, -3072, -1501,  3679, -7232, 11354, -15943, 10427, -12949, 15419, -17694,  9803, -10473, 10719, -10324,  1108,  -647,  -744, 30148, },
	{  3077, -7354, 14298, -24288,  9301, -13034, 16777, -19709,  5163, -4519,  2541,  1264, -3688,  8099, -13983, 21331, -14980, 19735, -24605, 29133, -16366, 17354, -17139, 15319, -5751,  2677,  1683, -7382,  7190, -11266, 15783, -20540, 12634, -14815, 16615, -17807,  9069, -8666,  7543, -5525,  1200,  1060, -4245,  8770, -1941,  3358, -6462, 22058, },
	{  2655, -5400,  8475, -10918,  2784, -1711, -1219,  6851, -4014,  7404, -12007, 17834, -12362, 16147, -19948, 23297, -12791, 13032, -11955,  9130, -2073, -1669,  6770, -13247, 10501, -14897, 19612, -24362, 14390, -16211, 17390, -17654,  8359, -7152,  5075, -2017, -1057,  3692, -6916, 10744, -7595, 10143, -13065, 16480, -2586,  3311, -4572,  8385, },
	{   398, -2814,  8215, -18002,  8391, -13996, 21414, -30461, 10137, -12646, 14721, -15790,  7569, -5971,  2666,  2762, -5328, 10611, -17227, 25038, -16867, 21408, -25791, 29569, -16104, 16553, -15817, 13585, -4787,  1780,  2301, -7470,  6839, -10396, 14300, -18401, 11251, -13180, 14844, -16071,  8327, -8161,  7348, -5561,   266,   600, -2904, 29061, },
	{  3354, -7630, 14130, -22858,  8305, -10946, 13014, -13589,  2863, -1284, -1747,  6629, -6851, 11586, -17518, 24496, -16093, 20019, -23636, 26443, -13920, 13578, -11846,  8391, -1463, -2375,  7356, -13437, 10238, -14109, 18145, -22099, 12833, -14242, 15077, -15116,  7063, -5930,  4027, -1207, -1354,  3983, -7483, 12228, -2378,  3748, -6600, 18940, },
	{  2101, -4037,  5670, -5853,   718,  1382, -5507, 12368, -5652,  9169, -13659, 19002, -12447, 15402, -17980, 19670, -9923,  8905, -6410,  2091,  2172, -6539, 12068, -18668, 13061, -17037, 21009, -24650, 13783, -14656, 14702, -13678,  5672, -3746,   973,  2706, -3660,  6432, -9647, 13272, -8632, 10791, -13105, 15601, -2299,  2728, -3390,  5130, },
	{  1543, -4861, 11260, -21862,  9399, -14722, 21320, -28762,  9050, -10575, 11302, -10645,  3962, -1205, -3299,  9843, -9301, 14788, -21262, 28457, -17971, 21553, -24586, 26603, -13541, 12738, -10624,  6959,  -778, -2846,  7395, -12806,  9472, -12799, 16233, -19584, 11311, -12534, 13304, -13432,  6345, -5388,  3619,  -646,  -546,  1710, -4582, 27352, },
	{  3357, -7361, 13037, -20028,  6832, -8272,  8619, -6914,   494,  1878, -5721, 11321, -9429, 14170, -19762, 25929, -16105, 18972, -21139, 22091, -10628,  9015, -5921,  1100,  2807, -7138, 12399, -18453, 12534, -15950, 19251, -22160, 12178, -12740, 12576, -11488,  4637, -2868,   333,  3075, -3745,  6552, -10115, 14740, -2638,  3868, -6306, 15596, },
};

int nextstate_441_160[441] = {
	0x00107000, 0x00206f00, 0x00306e01, 0x00406d00, 0x00506c00, 0x00606b01, 0x00706a00, 0x00806900, 
	0x00906801, 0x00a06700, 0x00b06600, 0x00c06501, 0x00d06400, 0x00e06301, 0x00f06200, 0x01006100, 
	0x01106001, 0x01205f00, 0x01305e00, 0x01405d01, 0x01505c00, 0x01605b00, 0x01705a01, 0x01805900, 
	0x01905801, 0x01a05700, 0x01b05600, 0x01c05501, 0x01d05400, 0x01e05300, 0x01f05201, 0x02005100, 
	0x02105000, 0x02204f01, 0x02304e00, 0x02404d01, 0x02504c00, 0x02604b00, 0x02704a01, 0x02804900, 
	0x02904800, 0x02a04701, 0x02b04600, 0x02c04500, 0x02d04401, 0x02e04300, 0x02f04201, 0x03004100, 
	0x03104000, 0x03203f01, 0x03303e00, 0x03403d00, 0x03503c01, 0x03603b00, 0x03703a00, 0x03803901, 
	0x03903800, 0x03a03701, 0x03b03600, 0x03c03500, 0x03d03401, 0x03e03300, 0x03f03200, 0x04003101, 
	0x04103000, 0x04202f00, 0x04302e01, 0x04402d00, 0x04502c01, 0x04602b00, 0x04702a00, 0x04802901, 
	0x04902800, 0x04a02700, 0x04b02601, 0x04c02500, 0x04d02400, 0x04e02301, 0x04f02200, 0x05002101, 
	0x05102000, 0x05201f00, 0x05301e01, 0x05401d00, 0x05501c00, 0x05601b01, 0x05701a00, 0x05801900, 
	0x05901801, 0x05a01700, 0x05b01601, 0x05c01500, 0x05d01400, 0x05e01301, 0x05f01200, 0x06001100, 
	0x06101001, 0x06200f00, 0x06300e00, 0x06400d01, 0x06500c00, 0x06600b01, 0x06700a00, 0x06800900, 
	0x06900801, 0x06a00700, 0x06b00600, 0x06c00501, 0x06d00400, 0x06e00300, 0x06f00201, 0x07000100, 
	0x07100000, 0x0721b801, 0x0731b700, 0x0741b601, 0x0751b500, 0x0761b400, 0x0771b301, 0x0781b200, 
	0x0791b100, 0x07a1b001, 0x07b1af00, 0x07c1ae00, 0x07d1ad01, 0x07e1ac00, 0x07f1ab01, 0x0801aa00, 
	0x0811a900, 0x0821a801, 0x0831a700, 0x0841a600, 0x0851a501, 0x0861a400, 0x0871a300, 0x0881a201, 
	0x0891a100, 0x08a1a001, 0x08b19f00, 0x08c19e00, 0x08d19d01, 0x08e19c00, 0x08f19b00, 0x09019a01, 
	0x09119900, 0x09219800, 0x09319701, 0x09419600, 0x09519501, 0x09619400, 0x09719300, 0x09819201, 
	0x09919100, 0x09a19000, 0x09b18f01, 0x09c18e00, 0x09d18d00, 0x09e18c01, 0x09f18b00, 0x0a018a01, 
	0x0a118900, 0x0a218800, 0x0a318701, 0x0a418600, 0x0a518500, 0x0a618401, 0x0a718300, 0x0a818200, 
	0x0a918101, 0x0aa18000, 0x0ab17f01, 0x0ac17e00, 0x0ad17d00, 0x0ae17c01, 0x0af17b00, 0x0b017a00, 
	0x0b117901, 0x0b217800, 0x0b317700, 0x0b417601, 0x0b517500, 0x0b617401, 0x0b717300, 0x0b817200, 
	0x0b917101, 0x0ba17000, 0x0bb16f00, 0x0bc16e01, 0x0bd16d00, 0x0be16c00, 0x0bf16b01, 0x0c016a00, 
	0x0c116901, 0x0c216800, 0x0c316700, 0x0c416601, 0x0c516500, 0x0c616400, 0x0c716301, 0x0c816200, 
	0x0c916100, 0x0ca16001, 0x0cb15f00, 0x0cc15e01, 0x0cd15d00, 0x0ce15c00, 0x0cf15b01, 0x0d015a00, 
	0x0d115900, 0x0d215801, 0x0d315700, 0x0d415600, 0x0d515501, 0x0d615400, 0x0d715301, 0x0d815200, 
	0x0d915100, 0x0da15001, 0x0db14f00, 0x0dc14e00, 0x0dd14d01, 0x0de14c00, 0x0df14b00, 0x0e014a01, 
	0x0e114900, 0x0e214800, 0x0e314701, 0x0e414600, 0x0e514501, 0x0e614400, 0x0e714300, 0x0e814201, 
	0x0e914100, 0x0ea14000, 0x0eb13f01, 0x0ec13e00, 0x0ed13d00, 0x0ee13c01, 0x0ef13b00, 0x0f013a01, 
	0x0f113900, 0x0f213800, 0x0f313701, 0x0f413600, 0x0f513500, 0x0f613401, 0x0f713300, 0x0f813200, 
	0x0f913101, 0x0fa13000, 0x0fb12f01, 0x0fc12e00, 0x0fd12d00, 0x0fe12c01, 0x0ff12b00, 0x10012a00, 
	0x10112901, 0x10212800, 0x10312700, 0x10412601, 0x10512500, 0x10612401, 0x10712300, 0x10812200, 
	0x10912101, 0x10a12000, 0x10b11f00, 0x10c11e01, 0x10d11d00, 0x10e11c00, 0x10f11b01, 0x11011a00, 
	0x11111901, 0x11211800, 0x11311700, 0x11411601, 0x11511500, 0x11611400, 0x11711301, 0x11811200, 
	0x11911100, 0x11a11001, 0x11b10f00, 0x11c10e01, 0x11d10d00, 0x11e10c00, 0x11f10b01, 0x12010a00, 
	0x12110900, 0x12210801, 0x12310700, 0x12410600, 0x12510501, 0x12610400, 0x12710301, 0x12810200, 
	0x12910100, 0x12a10001, 0x12b0ff00, 0x12c0fe00, 0x12d0fd01, 0x12e0fc00, 0x12f0fb00, 0x1300fa01, 
	0x1310f900, 0x1320f801, 0x1330f700, 0x1340f600, 0x1350f501, 0x1360f400, 0x1370f300, 0x1380f201, 
	0x1390f100, 0x13a0f000, 0x13b0ef01, 0x13c0ee00, 0x13d0ed01, 0x13e0ec00, 0x13f0eb00, 0x1400ea01, 
	0x1410e900, 0x1420e800, 0x1430e701, 0x1440e600, 0x1450e500, 0x1460e401, 0x1470e300, 0x1480e201, 
	0x1490e100, 0x14a0e000, 0x14b0df01, 0x14c0de00, 0x14d0dd00, 0x14e0dc01, 0x14f0db00, 0x1500da00, 
	0x1510d901, 0x1520d800, 0x1530d700, 0x1540d601, 0x1550d500, 0x1560d401, 0x1570d300, 0x1580d200, 
	0x1590d101, 0x15a0d000, 0x15b0cf00, 0x15c0ce01, 0x15d0cd00, 0x15e0cc00, 0x15f0cb01, 0x1600ca00, 
	0x1610c901, 0x1620c800, 0x1630c700, 0x1640c601, 0x1650c500, 0x1660c400, 0x1670c301, 0x1680c200, 
	0x1690c100, 0x16a0c001, 0x16b0bf00, 0x16c0be01, 0x16d0bd00, 0x16e0bc00, 0x16f0bb01, 0x1700ba00, 
	0x1710b900, 0x1720b801, 0x1730b700, 0x1740b600, 0x1750b501, 0x1760b400, 0x1770b301, 0x1780b200, 
	0x1790b100, 0x17a0b001, 0x17b0af00, 0x17c0ae00, 0x17d0ad01, 0x17e0ac00, 0x17f0ab00, 0x1800aa01, 
	0x1810a900, 0x1820a801, 0x1830a700, 0x1840a600, 0x1850a501, 0x1860a400, 0x1870a300, 0x1880a201, 
	0x1890a100, 0x18a0a000, 0x18b09f01, 0x18c09e00, 0x18d09d01, 0x18e09c00, 0x18f09b00, 0x19009a01, 
	0x19109900, 0x19209800, 0x19309701, 0x19409600, 0x19509500, 0x19609401, 0x19709300, 0x19809201, 
	0x19909100, 0x19a09000, 0x19b08f01, 0x19c08e00, 0x19d08d00, 0x19e08c01, 0x19f08b00, 0x1a008a00, 
	0x1a108901, 0x1a208800, 0x1a308701, 0x1a408600, 0x1a508500, 0x1a608401, 0x1a708300, 0x1a808200, 
	0x1a908101, 0x1aa08000, 0x1ab07f00, 0x1ac07e01, 0x1ad07d00, 0x1ae07c01, 0x1af07b00, 0x1b007a00, 
	0x1b107901, 0x1b207800, 0x1b307700, 0x1b407601, 0x1b507500, 0x1b607400, 0x1b707301, 0x1b807200, 
	0x00007101, 
};
#endif // HELIX_FEATURE_MMXFILTER_441_160

#ifdef HELIX_FEATURE_MMXFILTER_2_1
/*
 * inrate=22050 outrate=44100 up=2 dn=1
 */

ALIGN
filtwing filter_2_1[2] = {
	{  1015, -3733,  9309, -18926,  8413, -13538, 20073, -27689,  8913, -10686, 11802, -11691,  4835, -2493, -1556,  7643, -8000, 13348, -19786, 27091, -17437, 21282, -24704, 27242, -14185, 13762, -12066,  8835, -1925, -1517,  5933, -11284,  8731, -12137, 15725, -19313, 11340, -12778, 13815, -14266,  6953, -6219,  4714, -2060,  -317,  1407, -4149, 27905, },
	{  2368, -5386,  9287, -13391,  4096, -4049,  2489,  1477, -2214,  5166, -9442, 15171, -11169, 15361, -19920, 24453, -14200, 15520, -15758, 14436, -5531,  2589,  1798, -7743,  7630, -12113, 17180, -22602, 14028, -16563, 18656, -20022, 10176, -9661,  8305, -5956,  1237,  1134, -4190,  7984, -6291,  9040, -12334, 16371, -2701,  3654, -5415, 11244, },
};

int nextstate_2_1[2] = {
	0x00100000, 0x00000101, 
};
#endif // HELIX_FEATURE_MMXFILTER_2_1

#ifdef HELIX_FEATURE_MMXFILTER_441_320
/*
 * inrate=32000 outrate=44100 up=441 dn=320
 */

ALIGN
filtwing filter_441_320[441] = {
	{ -2562,  2758,  -822, -4966,  4176, -9169, 16755, -27322, 10241, -14333, 18866, -23415, 13672, -14903, 14879, -13006,  4331,  -625, -4863, 12287, -10832, 16417, -22704, 29377, -17994, 20980, -23299, 24558, -12168, 11105, -8889,  5346,  -171, -3099,  7141, -11920,  8680, -11672, 14857, -18141, 10707, -12281, 13733, -15003,  2005, -2097,  2138, 30572, },
	{  3124, -6627, 11177, -16100,  5014, -5227,  3919,  -156, -1783,  4760, -9133, 15060, -11278, 15716, -20617, 25599, -15053, 16708, -17327, 16417, -6733,  3991,   228, -6062,  6776, -11305, 16492, -22124, 13945, -16692, 19057, -20752, 10732, -10429,  9301, -7184,  1962,   310, -3289,  7041, -5822,  8609, -11989, 16185, -2712,  3731, -5641, 12151, },
	{  3032, -7293, 14259, -24346,  9371, -13207, 17114, -20287,  5389, -4846,  2987,   689, -3338,  7698, -13554, 20914, -14804, 19628, -24612, 29304, -16561, 17685, -17631, 15989, -6180,  3199,  1080, -6717,  6842, -10924, 15474, -20297, 12564, -14818, 16713, -18021,  9245, -8921,  7884, -5959,  1465,   747, -3887,  8370, -1886,  3303, -6422, 22360, },
	{   268, -2577,  7850, -17511,  8249, -13863, 21340, -30524, 10214, -12817, 15028, -16275,  7922, -6453,  3288,  2002, -4888, 10129, -16735, 24580, -16685, 21310, -25819, 29768, -16311, 16890, -16302, 14229, -5190,  2259,  1757, -6881,  6536, -10104, 14042, -18206, 11201, -13198, 14949, -16287,  8504, -8423,  7714, -6063,   352,   477, -2704, 29202, },
	{  2162, -4184,  5967, -6377,   928,  1075, -5092, 11849, -5504,  9018, -13534, 18943, -12477, 15526, -18237, 20101, -10247,  9354, -6997,  2817,  1745, -6061, 11563, -18171, 12840, -16871, 20931, -24697, 13888, -14861, 15024, -14128,  5966, -4107,  1397,  2230, -3405,  6171, -9397, 13054, -8552, 10758, -13142, 15739, -2335,  2795, -3518,  5453, },
	{  3368, -7412, 13187, -20375,  7001, -8567,  9089, -7610,   736,  1563, -5335, 10879, -9196, 13951, -19595, 25864, -16154, 19138, -21460, 22605, -10997,  9510, -6546,  1851,  2378, -6672, 11920, -17996, 12338, -15811, 19197, -22222, 12283, -12934, 12872, -11896,  4900, -3191,   713,  2646, -3512,  6309, -9878, 14530, -2619,  3868, -6354, 15946, },
	{  2353, -6242, 13131, -23844,  9716, -14505, 20040, -25694,  7610, -8202,  7723, -5609,   622,  2989, -8287, 15439, -12232, 17592, -23580, 29837, -17922, 20465, -22143, 22502, -10530,  8672, -5466,   747,  2789, -6752, 11457, -16776, 11255, -14189, 17016, -19519, 10725, -11260, 11202, -10363,  4255, -2667,   180,  3628, -1207,  2541, -5658, 25344, },
	{ -1240,   227,  3387, -11237,  6293, -11752, 19543, -29807, 10583, -14105, 17687, -20821, 11407, -11398,  9884, -6329,   107,  4451, -10653, 18529, -13974, 19294, -24956, 30571, -17817, 19770, -20797, 20529, -9295,  7316, -4176,  -234,  2984, -6506, 10639, -15292, 10167, -12792, 15410, -17887, 10032, -10874, 11344, -11252,  1279,  -914,  -245, 30289, },
	{  2756, -5655,  9017, -11928,  3208, -2364,  -285,  5607, -3629,  6963, -11552, 17433, -12239, 16168, -20196, 23869, -13290, 13795, -13027, 10541, -2952,  -627,  5595, -11992,  9873, -14321, 19153, -24097, 14397, -16401, 17809, -18342,  8854, -7808,  5895, -2993,  -500,  3084, -6283, 10121, -7312,  9921, -12947, 16528, -2625,  3408, -4793,  9076, },
	{  3320, -7619, 14244, -23274,  8552, -11429, 13848, -14906,  3346, -1948,  -884,  5573, -6244, 10939, -16893, 23985, -15954, 20071, -23965, 27140, -14498, 14426, -12997,  9858, -2351, -1351,  6233, -12268,  9669, -13603, 17760, -21901, 12863, -14439, 15476, -15752,  7514, -6524,  4771, -2100,  -838,  3406, -6863, 11590, -2302,  3690, -6609, 19602, },
	{  1328, -4482, 10715, -21210,  9248, -14657, 21458, -29267,  9321, -11055, 12060, -11752,  4719, -2184, -2099,  8451, -8540, 14015, -20553, 27914, -17844, 21642, -24969, 27358, -14141, 13591, -11749,  8358, -1606, -1912,  6389, -11781,  8984, -12376, 15925, -19449, 11361, -12736, 13694, -14047,  6786, -5985,  4401, -1651,  -384,  1496, -4279, 27750, },
	{  1616, -2868,  3354, -1834,  -854,  3636, -8480, 15960, -6629, 10080, -14275, 18998, -11923, 14101, -15614, 15940, -7238,  5290, -1812, -3466,  5364, -10013, 15616, -22002, 14436, -17897, 21102, -23705, 12655, -12746, 11905, -9922,  3304,  -906, -2280,  6270, -5521,  8266, -11321, 14614, -9030, 10783, -12518, 14190, -1972,  2162, -2367,  2726, },
	{  3189, -6811, 11612, -16979,  5408, -5870,  4892, -1526, -1331,  4201, -8490, 14382, -10963, 15487, -20557, 25808, -15351, 17263, -18202, 17670, -7568,  5042, -1031, -4627,  6000, -10512, 15743, -21492, 13732, -16632, 19202, -21155, 11088, -10962, 10025, -8108,  2522,  -341, -2563,  6266, -5428,  8235, -11672, 15979, -2712,  3779, -5804, 12860, },
	{  2933, -7152, 14146, -24410,  9493, -13528, 17759, -21408,  5831, -5495,  3880,  -471, -2627,  6874, -12663, 20029, -14420, 19373, -24574, 29586, -16918, 18312, -18581, 17301, -7029,  4238,  -133, -5367,  6129, -10214, 14821, -19767, 12398, -14793, 16873, -18413,  9579, -9412,  8551, -6816,  1993,   118, -3157,  7545, -1773,  3185, -6325, 22952, },
	{     2, -2090,  7092, -16481,  7944, -13564, 21145, -30584, 10346, -13135, 15613, -17217,  8616, -7409,  4531,   470, -3991,  9137, -15709, 23609, -16285, 21068, -25819, 30103, -16693, 17532, -17242, 15492, -5988,  3216,   661, -5684,  5914, -9495, 13495, -17776, 11078, -13204, 15128, -16687,  8841, -8930,  8435, -7058,   524,   228, -2289, 29464, },
	{  2281, -4474,  6555, -7425,  1349,   453, -4243, 10777, -5194,  8696, -13253, 18783, -12511, 15742, -18714, 20925, -10875, 10236, -8160,  4270,   883, -5088, 10525, -17134, 12367, -16501, 20730, -24739, 14069, -15241, 15637, -15002,  6542, -4823,  2245,  1270, -2884,  5633, -8875, 12589, -8375, 10669, -13187, 15983, -2403,  2925, -3770,  6108, },
	{  3383, -7498, 13463, -21031,  7329, -9144, 10019, -8998,  1221,   926, -4547,  9967, -8708, 13481, -19217, 25677, -16218, 19431, -22059, 23589, -11717, 10484, -7787,  3353,  1512, -5723, 10935, -17041, 11917, -15498, 19049, -22301, 12467, -13295, 13438, -12689,  5418, -3832,  1474,  1778, -3036,  5809, -9380, 14077, -2577,  3860, -6439, 16642, },
	{  2188, -5967, 12778, -23516,  9692, -14625, 20426, -26512,  7973, -8779,  8572, -6779,  1384,  2050, -7192, 14240, -11624, 17037, -23165, 29665, -18019, 20811, -22807, 23547, -11268,  9643, -6671,  2170,  1987, -5892, 10583, -15949, 10901, -13939, 16918, -19628, 10910, -11605, 11736, -11114,  4752, -3300,   964,  2675, -1063,  2367, -5448, 25839, },
	{ -1537,   791,  2463, -9885,  5847, -11227, 19008, -29389, 10557, -14225, 18040, -21510, 11976, -12250, 11068, -7880,  1070,  3316, -9385, 17194, -13324, 18730, -24562, 30445, -17943, 20141, -21469, 21548, -9997,  8217, -5274,  1041,  2277, -5758,  9890, -14594,  9876, -12597, 15358, -18031, 10234, -11247, 11942, -12157,  1449, -1183,   271, 30402, },
	{  2851, -5898,  9543, -12921,  3629, -3020,   662,  4332, -3229,  6498, -11059, 16978, -12079, 16143, -20389, 24377, -13756, 14525, -14070, 11931, -3829,   424,  4396, -10696,  9213, -13701, 18637, -23762, 14362, -16547, 18180, -18981,  9326, -8445,  6703, -3966,    60,  2465, -5629,  9466, -7007,  9670, -12791, 16529, -2657,  3497, -5005,  9773, },
	{  3275, -7586, 14318, -23629,  8778, -11885, 14653, -16194,  3825, -2614,   -10,  4491, -5614, 10255, -16215, 23401, -15769, 20067, -24228, 27764, -15038, 15239, -14117, 11305, -3237,  -318,  5085, -11059,  9069, -13056, 17323, -21639, 12856, -14595, 15833, -16346,  7946, -7103,  5505, -2991,  -316,  2816, -6218, 10914, -2219,  3621, -6599, 20254, },
	{  1102, -4082, 10128, -20484,  9069, -14549, 21536, -29693,  9568, -11507, 12792, -12836,  5470, -3165,  -884,  7024, -7749, 13197, -19782, 27288, -17665, 21670, -25283, 28040, -14705, 14410, -12846,  9740, -2433,  -967,  5361, -10717,  8467, -11915, 15571, -19258, 11379, -12903, 14046, -14626,  7210, -6569,  5176, -2660,  -220,  1275, -3954, 28125, },
	{  1743, -3173,  3952, -2860,  -459,  3077, -7757, 15109, -6407,  9888, -14176, 19077, -12106, 14493, -16285, 16963, -7958,  6241, -3002, -2051,  4564, -9159, 14766, -21233, 14141, -17749, 21164, -24045, 12998, -13291, 12676, -10931,  3928, -1643, -1450,  5376, -5063,  7827, -10935, 14328, -8965, 10829, -12720, 14610, -2064,  2315, -2635,  3327, },
	{  3245, -6979, 12021, -17823,  5792, -6506,  5863, -2908,  -870,  3624, -7815, 13656, -10615, 15213, -20437, 25945, -15608, 17773, -19032, 18880, -8387,  6086, -2295, -3170,  5201, -9686, 14945, -20796, 13479, -16524, 19293, -21501, 11414, -11465, 10725, -9013,  3078,  -994, -1827,  5469, -5017,  7835, -11319, 15726, -2704,  3817, -5954, 13569, },
	{  2821, -6986, 13990, -24403,  9590, -13814, 18360, -22481,  6262, -6135,  4771, -1639, -1901,  6024, -11729, 19081, -13991, 19060, -24465, 29785, -17228, 18891, -19483, 18572, -7862,  5272, -1352, -3996,  5395, -9472, 14123, -19178, 12196, -14726, 16987, -18754,  9887, -9880,  9198, -7659,  2519,  -517, -2412,  6692, -1654,  3056, -6208, 23529, },
	{  -271, -1586,  6299, -15385,  7611, -13221, 20886, -30556, 10450, -13418, 16159, -18118,  9292, -8352,  5770, -1076, -3077,  8113, -14632, 22564, -15836, 20764, -25746, 30354, -17030, 18128, -18137, 16718, -6773,  4169,  -442, -4465,  5272, -8857, 12907, -17293, 10923, -13173, 15265, -17041,  9155, -9416,  9137, -8044,   697,   -27, -1854, 29700, },
	{  2396, -4757,  7136, -8469,  1773,  -179, -3371,  9661, -4865,  8346, -12931, 18567, -12509, 15914, -19141, 21695, -11478, 11096, -9309,  5720,    12, -4095,  9450, -16042, 11857, -16082, 20470, -24711, 14212, -15579, 16209, -15838,  7102, -5529,  3090,   301, -2353,  5078, -8325, 12086, -8172, 10550, -13196, 16184, -2465,  3048, -4016,  6773, },
	{  3387, -7563, 13704, -21637,  7639, -9704, 10932, -10377,  1708,   279, -3738,  9017, -8190, 12968, -18781, 25416, -16236, 19670, -22599, 24512, -12407, 11434, -9014,  4854,   637, -4752,  9913, -16032, 11460, -15139, 18846, -22316, 12618, -13620, 13968, -13450,  5923, -4466,  2234,   901, -2549,  5289, -8852, 13579, -2527,  3840, -6507, 17332, },
	{  2010, -5667, 12381, -23115,  9639, -14703, 20758, -27264,  8317, -9337,  9405, -7941,  2148,  1097, -6068, 12991, -10977, 16431, -22681, 29408, -18066, 21101, -23410, 24530, -11979, 10591, -7863,  3595,  1175, -5010,  9675, -15072, 10515, -13649, 16772, -19681, 11065, -11919, 12240, -11837,  5239, -3928,  1750,  1706,  -915,  2183, -5217, 26313, },
	{ -1839,  1365,  1514, -8482,  5378, -10662, 18412, -28882, 10500, -14305, 18344, -22144, 12517, -13074, 12230, -9419,  2036,  2163, -8080, 15802, -12633, 18110, -24095, 30232, -18019, 20457, -22083, 22512, -10673,  9100, -6362,  2319,  1560, -4990,  9109, -13852,  9555, -12366, 15261, -18124, 10409, -11590, 12510, -13036,  1617, -1453,   805, 30487, },
	{  2940, -6130, 10052, -13893,  4046, -3677,  1620,  3029, -2815,  6009, -10530, 16471, -11884, 16072, -20525, 24820, -14185, 15219, -15079, 13297, -4700,  1479,  3179, -9361,  8524, -13038, 18065, -23357, 14287, -16645, 18501, -19569,  9773, -9061,  7495, -4932,   623,  1835, -4956,  8780, -6680,  9389, -12597, 16483, -2682,  3577, -5206, 10474, },
	{  3217, -7528, 14351, -23920,  8982, -12313, 15425, -17451,  4297, -3280,   872,  3386, -4962,  9536, -15485, 22747, -15538, 20005, -24423, 28313, -15539, 16014, -15204, 12729, -4118,   721,  3917, -9811,  8441, -12469, 16834, -21315, 12813, -14710, 16147, -16897,  8357, -7665,  6227, -3879,   209,  2215, -5551, 10201, -2129,  3540, -6570, 20893, },
	{   866, -3660,  9500, -19687,  8860, -14398, 21552, -30038,  9791, -11932, 13493, -13892,  6211, -4145,   344,  5565, -6931, 12335, -18948, 26580, -17435, 21637, -25527, 28645, -15230, 15193, -13912, 11101, -3257,   -16,  4312, -9617,  7924, -11419, 15171, -19012, 11365, -13033, 14361, -15167,  7617, -7139,  5942, -3671,   -53,  1046, -3608, 28474, },
	{  1869, -3476,  4551, -3895,   -55,  2502, -7002, 14204, -6164,  9666, -14035, 19103, -12257, 14846, -16916, 17946, -8660,  7181, -4192,  -620,  3747, -8274, 13869, -20399, 13804, -17549, 21167, -24319, 13305, -13800, 13413, -11915,  4545, -2378,  -612,  4463, -4589,  7363, -10517, 13999, -8873, 10845, -12887, 14992, -2151,  2464, -2901,  3943, },
	{  3293, -7129, 12402, -18629,  6166, -7132,  6829, -4299,  -401,  3030, -7112, 12885, -10233, 14892, -20258, 26009, -15822, 18236, -19814, 20044, -9186,  7118, -3560, -1696,  4384, -8827, 14100, -20038, 13187, -16369, 19330, -21787, 11710, -11939, 11396, -9897,  3628, -1647, -1082,  4652, -4589,  7411, -10932, 15427, -2688,  3845, -6090, 14276, },
	{  2697, -6795, 13789, -24324,  9660, -14064, 18915, -23501,  6680, -6764,  5656, -2814, -1164,  5149, -10753, 18071, -13519, 18691, -24287, 29901, -17491, 19420, -20335, 19797, -8678,  6295, -2574, -2606,  4642, -8699, 13382, -18532, 11959, -14617, 17053, -19044, 10168, -10322,  9822, -8484,  3041, -1154, -1656,  5811, -1528,  2916, -6070, 24088, },
	{  -551, -1065,  5473, -14226,  7251, -12836, 20563, -30440, 10524, -13666, 16663, -18976,  9947, -9278,  7004, -2630, -2147,  7059, -13506, 21447, -15339, 20400, -25599, 30521, -17321, 18675, -18985, 17902, -7542,  5115, -1549, -3227,  4612, -8191, 12279, -16759, 10736, -13105, 15359, -17348,  9445, -9878,  9819, -9015,   870,  -286, -1400, 29907, },
	{  2508, -5034,  7708, -9507,  2198,  -819, -2478,  8504, -4518,  7967, -12569, 18296, -12472, 16043, -19517, 22410, -12051, 11931, -10438,  7164,  -864, -3084,  8342, -14899, 11310, -15616, 20149, -24613, 14314, -15875, 16737, -16632,  7644, -6222,  3931,  -673, -1813,  4505, -7749, 11545, -7945, 10400, -13167, 16340, -2520,  3164, -4255,  7446, },
	{  3381, -7606, 13909, -22190,  7933, -10242, 11825, -11742,  2195,  -375, -2911,  8034, -7644, 12413, -18288, 25079, -16208, 19855, -23079, 25371, -13067, 12357, -10222,  6350,  -244, -3762,  8857, -14972, 10969, -14735, 18588, -22269, 12733, -13909, 14462, -14177,  6414, -5090,  2992,    17, -2052,  4751, -8294, 13039, -2470,  3809, -6559, 18015, },
	{  1821, -5344, 11939, -22638,  9558, -14740, 21035, -27945,  8640, -9874, 10218, -9090,  2913,   133, -4918, 11695, -10295, 15773, -22129, 29066, -18061, 21332, -23950, 25449, -12659, 11514, -9039,  5016,   356, -4110,  8735, -14149, 10097, -13318, 16578, -19679, 11190, -12201, 12711, -12531,  5714, -4549,  2538,   723,  -762,  1990, -4964, 26766, },
	{ -2142,  1947,   544, -7031,  4887, -10059, 17755, -28286, 10412, -14345, 18599, -22721, 13026, -13867, 13366, -10944,  3004,   997, -6745, 14356, -11901, 17433, -23557, 29932, -18044, 20717, -22637, 23416, -11323,  9961, -7437,  3596,   835, -4205,  8299, -13067,  9206, -12098, 15121, -18166, 10554, -11903, 13048, -13886,  1782, -1724,  1356, 30543, },
	{  3022, -6349, 10541, -14841,  4458, -4332,  2585,  1702, -2389,  5498, -9965, 15912, -11653, 15954, -20604, 25196, -14577, 15874, -16053, 14634, -5563,  2537,  1945, -7993,  7806, -12335, 17439, -22884, 14171, -16698, 18771, -20105, 10195, -9654,  8269, -5889,  1188,  1197, -4264,  8066, -6333,  9079, -12367, 16390, -2700,  3648, -5398, 11178, },
	{  3148, -7446, 14341, -24146,  9162, -12711, 16162, -18673,  4763, -3943,  1761,  2262, -4291,  8783, -14705, 22022, -15260, 19886, -24550, 28784, -15999, 16747, -16253, 14124, -4993,  1764,  2732, -8529,  7785, -11843, 16295, -20929, 12734, -14784, 16416, -17403,  8747, -8208,  6936, -4761,   737,  1603, -4863,  9453, -2031,  3448, -6521, 21520, },
	{   620, -3217,  8831, -18818,  8622, -14203, 21506, -30301,  9987, -12326, 14163, -14919,  6941, -5122,  1580,  4080, -6086, 11433, -18056, 25792, -17154, 21542, -25699, 29173, -15714, 15936, -14944, 12438, -4076,   941,  3246, -8485,  7355, -10888, 14726, -18710, 11318, -13128, 14636, -15667,  8004, -7692,  6697, -4681,   117,   811, -3242, 28799, },
	{  1994, -3777,  5149, -4937,   355,  1911, -6217, 13246, -5900,  9414, -13853, 19073, -12373, 15161, -17503, 18886, -9343,  8107, -5378,   823,  2913, -7361, 12927, -19502, 13425, -17298, 21109, -24525, 13576, -14273, 14117, -12869,  5151, -3110,   232,  3532, -4100,  6876, -10067, 13629, -8755, 10829, -13019, 15335, -2232,  2607, -3163,  4571, },
	{  3331, -7261, 12754, -19394,  6527, -7746,  7788, -5693,    74,  2422, -6381, 12069, -9818, 14527, -20019, 25999, -15992, 18651, -20544, 21159, -9965,  8137, -4821,  -209,  3549, -7938, 13211, -19219, 12855, -16166, 19312, -22013, 11974, -12381, 12039, -10757,  4170, -2300,  -329,  3818, -4145,  6963, -10511, 15081, -2665,  3862, -6212, 14982, },
	{  2561, -6579, 13543, -24172,  9702, -14276, 19423, -24466,  7083, -7380,  6533, -3992,  -417,  4253, -9739, 17001, -13005, 18266, -24037, 29932, -17706, 19897, -21135, 20973, -9474,  7307, -3795, -1201,  3872, -7897, 12598, -17829, 11686, -14466, 17070, -19281, 10422, -10736, 10422, -9291,  3557, -1791,  -888,  4907, -1397,  2765, -5911, 24630, },
	{  -837,  -530,  4615, -13007,  6865, -12408, 20177, -30235, 10570, -13877, 17125, -19787, 10579, -10186,  8226, -4188, -1205,  5978, -12334, 20263, -14795, 19975, -25379, 30601, -17563, 19172, -19784, 19042, -8294,  6050, -2657, -1974,  3936, -7499, 11613, -16175, 10517, -12999, 15411, -17609,  9710, -10316, 10478, -9971,  1043,  -548,  -926, 30087, },
	{  2616, -5302,  8268, -10535,  2624, -1467, -1566,  7308, -4155,  7562, -12168, 17970, -12399, 16127, -19840, 23066, -12595, 12737, -11546,  8596, -1743, -2057,  7204, -13706, 10728, -15102, 19770, -24444, 14377, -16127, 17221, -17384,  8168, -6901,  4765, -1650, -1264,  3916, -7148, 10969, -7695, 10219, -13100, 16450, -2569,  3272, -4487,  8128, },
	{  3363, -7627, 14077, -22686,  8207, -10758, 12694, -13090,  2681, -1035, -2067,  7017, -7072, 11819, -17738, 24669, -16133, 19985, -23496, 26164, -13694, 13251, -11408,  7837, -1130, -2756,  7771, -13865, 10443, -14288, 18276, -22157, 12812, -14159, 14917, -14867,  6889, -5703,  3746,  -873, -1545,  4195, -7709, 12456, -2404,  3767, -6592, 18690, },
	{  1621, -4997, 11453, -22088,  9448, -14735, 21253, -28554,  8942, -10388, 11011, -10225,  3677,  -839, -3745, 10356, -9578, 15065, -21510, 28639, -18005, 21504, -24425, 26301, -13307, 12410, -10196,  6431,  -468, -3194,  7766, -13180,  9648, -12947, 16336, -19621, 11284, -12450, 13149, -13193,  6176, -5161,  3325,  -271,  -605,  1788, -4690, 27197, },
	{ -2447,  2536,  -446, -5537,  4374, -9418, 17039, -27601, 10294, -14344, 18803, -23237, 13503, -14627, 14472, -12448,  3970,  -181, -5381, 12860, -11131, 16704, -22949, 29545, -18017, 20919, -23130, 24259, -11944, 10798, -8497,  4870,   104, -3403,  7462, -12240,  8829, -11795, 14937, -18157, 10671, -12184, 13553, -14705,  1945, -1995,  1922, 30570, },
	{  3098, -6554, 11008, -15762,  4864, -4984,  3555,   354, -1950,  4965, -9366, 15301, -11387, 15789, -20625, 25502, -14931, 16488, -16987, 15938, -6416,  3595,   698, -6594,  7062, -11593, 16760, -22343, 14014, -16703, 18988, -20586, 10591, -10223,  9024, -6834,  1751,   553, -3557,  7325, -5965,  8742, -12099, 16250, -2710,  3710, -5577, 11885, },
	{  3066, -7339, 14289, -24304,  9319, -13078, 16862, -19855,  5220, -4601,  2653,  1120, -3601,  7999, -13877, 21228, -14937, 19709, -24608, 29177, -16416, 17438, -17263, 15487, -5859,  2808,  1533, -7216,  7104, -11181, 15707, -20481, 12617, -14817, 16641, -17862,  9114, -8731,  7629, -5634,  1267,   982, -4156,  8671, -1927,  3345, -6453, 22133, },
	{   366, -2755,  8125, -17881,  8356, -13964, 21397, -30479, 10157, -12690, 14799, -15912,  7657, -6092,  2821,  2573, -5219, 10491, -17105, 24925, -16822, 21385, -25800, 29621, -16156, 16638, -15939, 13747, -4888,  1900,  2165, -7324,  6763, -10324, 14237, -18354, 11239, -13186, 14872, -16126,  8371, -8227,  7440, -5687,   287,   569, -2854, 29097, },
	{  2116, -4074,  5744, -5984,   771,  1305, -5404, 12239, -5616,  9132, -13629, 18989, -12455, 15434, -18046, 19778, -10005,  9017, -6557,  2272,  2066, -6420, 11943, -18545, 13007, -16997, 20991, -24663, 13810, -14708, 14784, -13791,  5746, -3836,  1079,  2588, -3597,  6367, -9585, 13218, -8612, 10783, -13115, 15637, -2308,  2745, -3422,  5210, },
	{  3360, -7374, 13075, -20116,  6875, -8346,  8737, -7088,   555,  1800, -5625, 11211, -9372, 14116, -19722, 25915, -16118, 19015, -21220, 22221, -10721,  9139, -6077,  1288,  2700, -7022, 12280, -18340, 12486, -15917, 19239, -22177, 12205, -12789, 12651, -11591,  4703, -2948,   428,  2968, -3687,  6492, -10056, 14689, -2633,  3869, -6318, 15684, },
	{  2412, -6338, 13252, -23947,  9717, -14450, 19881, -25371,  7469, -7981,  7401, -5168,   338,  3337, -8689, 15875, -12451, 17786, -23718, 29879, -17872, 20320, -21879, 22095, -10247,  8303, -5012,   214,  3087, -7069, 11776, -17073, 11379, -14272, 17040, -19464, 10647, -11123, 10995, -10075,  4066, -2429,  -113,  3980, -1260,  2604, -5731, 25153, },
	{ -1129,    18,  3727, -11730,  6454, -11939, 19728, -29940, 10585, -14050, 17542, -20548, 11186, -11072,  9435, -5746,  -252,  4871, -11119, 19013, -14206, 19491, -25085, 30595, -17757, 19617, -20531, 20133, -9026,  6974, -3763,  -710,  3246, -6781, 10911, -15542, 10268, -12855, 15418, -17820,  9949, -10727, 11113, -10906,  1215,  -814,  -434, 30240, },
	{  2719, -5560,  8816, -11551,  3049, -2119,  -637,  6077, -3775,  7131, -11727, 17590, -12289, 16165, -20110, 23662, -13107, 13513, -12629, 10014, -2623, -1019,  6038, -12468, 10112, -14542, 19332, -24205, 14399, -16335, 17658, -18089,  8671, -7564,  5589, -2628,  -710,  3313, -6523, 10359, -7421, 10008, -12996, 16515, -2611,  3372, -4711,  8816, },
	{  3334, -7626, 14206, -23125,  8462, -11251, 13539, -14415,  3165, -1699, -1209,  5972, -6474, 11186, -17134, 24185, -16012, 20058, -23849, 26887, -14285, 14112, -12569,  9310, -2018, -1736,  6657, -12712,  9886, -13798, 17911, -21983, 12856, -14370, 15331, -15518,  7347, -6303,  4493, -1765, -1032,  3624, -7098, 11834, -2331,  3713, -6608, 19355, },
	{  1410, -4627, 10924, -21463,  9308, -14686, 21414, -29087,  9222, -10878, 11779, -11340,  4436, -1817, -2551,  8977, -8829, 14310, -20826, 28127, -17897, 21616, -24833, 27083, -13921, 13275, -11330,  7835, -1295, -2264,  6769, -12170,  9170, -12539, 16046, -19506, 11346, -12665, 13552, -13821,  6623, -5762,  4108, -1273,  -445,  1577, -4395, 27604, },
	{  1568, -2753,  3130, -1453, -1001,  3841, -8742, 16265, -6707, 10144, -14302, 18955, -11846, 13944, -15352, 15546, -6964,  4931, -1366, -3992,  5659, -10324, 15922, -22273, 14536, -17940, 21063, -23560, 12518, -12533, 11609, -9537,  3068,  -630, -2588,  6599, -5688,  8425, -11456, 14710, -9048, 10758, -12433, 14023, -1936,  2103, -2266,  2504, },
	{  3165, -6744, 11452, -16653,  5261, -5630,  4527, -1011, -1502,  4413, -8735, 14642, -11085, 15578, -20586, 25738, -15244, 17060, -17879, 17205, -7257,  4649,  -559, -5168,  6293, -10814, 16030, -21737, 13817, -16660, 19153, -21011, 10958, -10765,  9757, -7764,  2313,   -97, -2837,  6559, -5578,  8378, -11795, 16062, -2713,  3762, -5745, 12594, },
	{  2971, -7208, 14194, -24394,  9451, -13411, 17522, -20993,  5667, -5253,  3546,   -35, -2895,  7186, -13002, 20368, -14569, 19475, -24596, 29490, -16789, 18083, -18230, 16814, -6712,  3849,   323, -5876,  6399, -10484, 15072, -19973, 12465, -14808, 16819, -18272,  9456, -9231,  8303, -6496,  1795,   354, -3432,  7858, -1816,  3231, -6364, 22732, },
	{   103, -2275,  7380, -16875,  8061, -13681, 21226, -30571, 10300, -13020, 15398, -16868,  8358, -7052,  4065,  1046, -4330,  9513, -16100, 23982, -16441, 21166, -25828, 29987, -16555, 17297, -16894, 15023, -5690,  2858,  1073, -6136,  6149, -9727, 13705, -17943, 11128, -13206, 15066, -16542,  8717, -8743,  8167, -6686,   460,   322, -2447, 29369, },
	{  2236, -4366,  6335, -7032,  1191,   688, -4565, 11185, -5312,  8820, -13363, 18849, -12502, 15666, -18541, 20622, -10643,  9908, -7726,  3725,  1207, -5456, 10919, -17529, 12549, -16646, 20813, -24731, 14006, -15103, 15412, -14679,  6327, -4556,  1927,  1631, -3081,  5837, -9074, 12768, -8444, 10706, -13175, 15897, -2378,  2877, -3676,  5861, },
	{  3379, -7468, 13364, -20791,  7208, -8930,  9672, -8479,  1039,  1166, -4845, 10313, -8894, 13662, -19366, 25756, -16199, 19327, -21841, 23227, -11450, 10121, -7323,  2789,  1838, -6081, 11309, -17406, 12079, -15621, 19111, -22279, 12402, -13164, 13230, -12395,  5226, -3592,  1188,  2105, -3216,  5999, -9570, 14252, -2594,  3864, -6409, 16382, },
	{  2251, -6073, 12916, -23648,  9704, -14585, 20288, -26213,  7839, -8565,  8255, -6341,  1098,  2403, -7606, 14695, -11856, 17251, -23329, 29740, -17988, 20688, -22565, 23162, -10995,  9281, -6220,  1636,  2289, -6217, 10915, -16265, 11037, -14038, 16960, -19593, 10844, -11479, 11540, -10835,  4567, -3063,   669,  3034, -1118,  2433, -5529, 25656, },
	{ -1425,   578,  2813, -10398,  6017, -11428, 19216, -29556, 10570, -14184, 17913, -21258, 11766, -11934, 10627, -7299,   708,  3743, -9865, 17701, -13573, 18949, -24718, 30502, -17902, 20009, -21224, 21172, -9737,  7881, -4863,   563,  2543, -6041, 10174, -14861,  9988, -12675, 15382, -17983, 10162, -11110, 11721, -11820,  1385, -1082,    76, 30363, },
	{  2816, -5808,  9348, -12551,  3471, -2774,   306,  4814, -3381,  6675, -11248, 17155, -12143, 16158, -20323, 24194, -13585, 14256, -13683, 11413, -3500,    29,  4848, -11186,  9464, -13938, 18837, -23895, 14380, -16497, 18047, -18747,  9151, -8208,  6401, -3602,  -150,  2698, -5877,  9715, -7124,  9767, -12854, 16534, -2646,  3465, -4927,  9511, },
	{  3293, -7601, 14295, -23503,  8696, -11717, 14354, -15714,  3646, -2365,  -339,  4899, -5853, 10515, -16475, 23629, -15844, 20075, -24137, 27539, -14840, 14939, -13701, 10765, -2905,  -707,  5518, -11517,  9297, -13266, 17493, -21745, 12863, -14541, 15704, -16129,  7786, -6888,  5231, -2657,  -512,  3039, -6463, 11172, -2251,  3648, -6605, 20011, },
	{  1188, -4234, 10353, -20765,  9140, -14595, 21514, -29542,  9478, -11341, 12521, -12432,  5189, -2797, -1341,  7563, -8049, 13509, -20078, 27532, -17738, 21667, -25173, 27793, -14498, 14107, -12438,  9224, -2123, -1323,  5749, -11120,  8664, -12092, 15709, -19336, 11376, -12844, 13918, -14414,  7053, -6352,  4886, -2281,  -282,  1359, -4078, 27987, },
	{  1695, -3058,  3728, -2474,  -608,  3289, -8032, 15434, -6493,  9964, -14218, 19054, -12041, 14350, -16038, 16584, -7690,  5886, -2556, -2583,  4867, -9483, 15090, -21529, 14256, -17810, 21148, -23925, 12874, -13091, 12390, -10556,  3695, -1366, -1762,  5713, -5237,  7995, -11084, 14440, -8992, 10816, -12648, 14457, -2030,  2258, -2535,  3100, },
	{  3225, -6918, 11871, -17511,  5649, -6269,  5499, -2389, -1044,  3842, -8072, 13934, -10749, 15321, -20489, 25902, -15516, 17587, -18727, 18431, -8082,  5695, -1821, -3719,  5503, -10000, 15250, -21065, 13579, -16570, 19265, -21378, 11295, -11280, 10465, -8676,  2870,  -749, -2104,  5770, -5173,  7988, -11456, 15827, -2708,  3804, -5899, 13303, },
	{  2864, -7052, 14054, -24414,  9557, -13711, 18140, -22085,  6102, -5896,  4437, -1200, -2175,  6346, -12084, 19444, -14157, 19184, -24514, 29720, -17117, 18680, -19150, 18101, -7552,  4885,  -895, -4513,  5673, -9754, 14390, -19406, 12276, -14756, 16950, -18632,  9774, -9707,  8958, -7344,  2322,  -278, -2693,  7015, -1699,  3105, -6255, 23315, },
	{  -168, -1777,  6600, -15804,  7739, -13355, 20990, -30577, 10414, -13316, 15959, -17785,  9041, -8000,  5306,  -495, -3422,  8501, -15042, 22964, -16010, 20885, -25782, 30270, -16909, 17910, -17806, 16263, -6480,  3812,   -28, -4924,  5515, -9100, 13132, -17480, 10985, -13189, 15219, -16913,  9040, -9237,  8876, -7676,   632,    69, -2019, 29615, },
	{  2353, -4652,  6919, -8078,  1614,    59, -3701, 10085, -4990,  8480, -13057, 18654, -12514, 15855, -18987, 21413, -11255, 10777, -8880,  5177,   339, -4470,  9857, -16458, 12053, -16245, 20574, -24730, 14163, -15457, 15999, -15529,  6894, -5265,  2774,   665, -2553,  5288, -8535, 12279, -8251, 10598, -13197, 16114, -2442,  3003, -3924,  6522, },
	{  3387, -7541, 13618, -21416,  7525, -9496, 10592, -9862,  1525,   523, -4044,  9378, -8388, 13165, -18951, 25522, -16234, 19587, -22404, 24173, -12152, 11080, -8556,  4292,   966, -5118, 10300, -16416, 11636, -15279, 18928, -22318, 12565, -13503, 13774, -13169,  5736, -4229,  1949,  1231, -2733,  5486, -9053, 13771, -2547,  3849, -6484, 17074, },
	{  2078, -5782, 12535, -23274,  9662, -14679, 20640, -26990,  8190, -9130,  9094, -7507,  1862,  1456, -6493, 13465, -11224, 16664, -22871, 29515, -18054, 20999, -23191, 24168, -11716, 10238, -7418,  3061,  1481, -5343, 10020, -15407, 10663, -13762, 16833, -19667, 11011, -11805, 12055, -11569,  5058, -3693,  1455,  2071,  -971,  2253, -5306, 26138, },
	{ -1725,  1148,  1873, -9013,  5557, -10878, 18643, -29083, 10525, -14279, 18236, -21913, 12318, -12769, 11797, -8844,  1673,  2597, -8573, 16331, -12897, 18349, -24278, 30322, -17997, 20345, -21859, 22157, -10423,  8771, -5955,  1840,  1830, -5281,  9406, -14136,  9679, -12457, 15303, -18095, 10346, -11465, 12301, -12709,  1554, -1352,   603, 30459, },
	{  2907, -6045,  9863, -13531,  3890, -3431,  1259,  3521, -2972,  6195, -10733, 16667, -11962, 16104, -20481, 24662, -14028, 14963, -14705, 12788, -4374,  1083,  3637, -9866,  8786, -13292, 18286, -23517, 14320, -16614, 18386, -19355,  9608, -8832,  7199, -4571,   412,  2072, -5210,  9041, -6805,  9497, -12674, 16506, -2674,  3548, -5132, 10210, },
	{  3240, -7552, 14343, -23818,  8908, -12156, 15139, -16984,  4121, -3030,   540,  3803, -5209,  9809, -15765, 23000, -15630, 20035, -24358, 28116, -15356, 15728, -14800, 12198, -3788,   331,  4357, -10283,  8679, -12693, 17023, -21444, 12834, -14672, 16034, -16696,  8205, -7457,  5958, -3547,    12,  2442, -5804, 10473, -2163,  3572, -6583, 20655, },
	{   955, -3820,  9740, -19994,  8942, -14460, 21553, -29918,  9710, -11776, 13234, -13500,  5934, -3778,  -118,  6116, -7241, 12663, -19268, 26855, -17527, 21657, -25443, 28427, -15038, 14904, -13516, 10593, -2948,  -373,  4707, -10034,  8130, -11609, 15326, -19111, 11374, -12989, 14247, -14969,  7467, -6927,  5656, -3292,  -115,  1133, -3740, 28346, },
	{  1822, -3363,  4326, -3506,  -207,  2719, -7289, 14549, -6257,  9753, -14093, 19100, -12204, 14718, -16684, 17582, -8399,  6830, -3746, -1158,  4055, -8610, 14211, -20719, 13935, -17630, 21173, -24224, 13194, -13614, 13141, -11549,  4315, -2102,  -927,  4807, -4769,  7540, -10678, 14127, -8910, 10843, -12829, 14854, -2119,  2409, -2801,  3710, },
	{  3276, -7075, 12263, -18331,  6027, -6899,  6467, -3777,  -578,  3255, -7379, 13179, -10380, 15018, -20332, 25993, -15747, 18068, -19526, 19613, -8889,  6733, -3085, -2251,  4692, -9153, 14423, -20330, 13301, -16433, 19322, -21687, 11603, -11765, 11148, -9568,  3423, -1402, -1362,  4961, -4751,  7573, -11081, 15545, -2695,  3836, -6041, 14011, },
	{  2745, -6870, 13869, -24362,  9637, -13974, 18712, -23125,  6525, -6530,  5325, -2373, -1442,  5480, -11123, 18457, -13701, 18836, -24362, 29867, -17398, 19228, -20022, 19343, -8374,  5913, -2116, -3129,  4926, -8992, 13665, -18781, 12052, -14663, 17034, -18941, 10066, -10159,  9591, -8177,  2846,  -914, -1941,  6144, -1576,  2969, -6124, 23881, },
	{  -445, -1262,  5786, -14668,  7389, -12985, 20692, -30494, 10500, -13577, 16479, -18660,  9704, -8933,  6542, -2046, -2498,  7458, -13934, 21874, -15531, 20544, -25663, 30468, -17217, 18475, -18673, 17463, -7256,  4761, -1133, -3693,  4862, -8444, 12519, -16965, 10810, -13135, 15329, -17239,  9339, -9708,  9566, -8653,   806,  -188, -1572, 29833, },
	{  2467, -4931,  7494, -9119,  2039,  -578, -2815,  8943, -4650,  8112, -12710, 18404, -12490, 16000, -19382, 22149, -11840, 11621, -10017,  6623,  -535, -3465,  8761, -15334, 11519, -15796, 20276, -24658, 14281, -15769, 16544, -16339,  7443, -5964,  3617,  -308, -2016,  4721, -7968, 11752, -8033, 10460, -13182, 16286, -2500,  3121, -4166,  7193, },
	{  3385, -7592, 13837, -21989,  7825, -10043, 11492, -11232,  2012,  -129, -3223,  8406, -7852, 12626, -18479, 25214, -16224, 19792, -22907, 25057, -12823, 12014, -9771,  5790,    87, -4135,  9257, -15376, 11157, -14892, 18691, -22294, 12694, -13805, 14281, -13909,  6232, -4857,  2708,   349, -2239,  4955, -8507, 13246, -2492,  3822, -6541, 17760, },
	{  1894, -5468, 12110, -22826,  9592, -14731, 20938, -27698,  8521, -9675,  9916, -8661,  2627,   496, -5352, 12186, -10555, 16025, -22344, 29205, -18069, 21252, -23755, 25112, -12407, 11171, -8600,  4484,   664, -4450,  9091, -14500, 10257, -13446, 16657, -19686, 11147, -12099, 12538, -12274,  5537, -4317,  2243,  1093,  -820,  2063, -5062, 26599, },
	{ -2028,  1728,   910, -7580,  5073, -10289, 18009, -28520, 10449, -14334, 18509, -22511, 12839, -13573, 12943, -10374,  2641,  1435, -7249, 14904, -12180, 17693, -23767, 30054, -18040, 20626, -22436, 23084, -11083,  9641, -7036,  3118,  1107, -4501,  8607, -13366,  9340, -12203, 15179, -18157, 10503, -11789, 12850, -13570,  1721, -1622,  1147, 30525, },
	{  2992, -6269, 10360, -14488,  4304, -4086,  2222,  2203, -2550,  5692, -10181, 16127, -11744, 16003, -20581, 25063, -14435, 15633, -15692, 14136, -5241,  2141,  2409, -8510,  8078, -12603, 17680, -23069, 14219, -16684, 18675, -19910, 10040, -9434,  7981, -5531,   976,  1437, -4525,  8337, -6465,  9199, -12458, 16431, -2694,  3623, -5327, 10914, },
	{  3175, -7480, 14350, -24069,  9097, -12565, 15890, -18219,  4589, -3694,  1427,  2686, -4545,  9069, -15003, 22302, -15370, 19938, -24510, 28617, -15831, 16477, -15864, 13604, -4666,  1373,  3178, -9014,  8034, -12082, 16503, -21081, 12768, -14761, 16321, -17219,  8603, -8007,  6672, -4431,   539,  1833, -5123,  9737, -2069,  3484, -6542, 21287, },
	{   714, -3386,  9087, -19152,  8715, -14281, 21531, -30212,  9917, -12182, 13916, -14538,  6669, -4756,  1115,  4640, -6406, 11776, -18397, 26097, -17266, 21585, -25643, 28984, -15537, 15662, -14561, 11940, -3770,   582,  3647, -8913,  7571, -11091, 14898, -18830, 11339, -13097, 14537, -15484,  7861, -7487,  6416, -4302,    53,   900, -3381, 28680, },
	{  1947, -3664,  4925, -4546,   201,  2134, -6515, 13611, -6001,  9512, -13926, 19091, -12333, 15047, -17288, 18539, -9090,  7762, -4934,   281,  3227, -7707, 13285, -19846, 13572, -17398, 21138, -24456, 13479, -14100, 13857, -12515,  4925, -2836,   -85,  3883, -4285,  7061, -10239, 13773, -8802, 10839, -12974, 15211, -2202,  2554, -3065,  4334, },
	{  3318, -7214, 12626, -19112,  6393, -7517,  7429, -5170,  -105,  2651, -6658, 12380, -9977, 14669, -20116, 26011, -15933, 18501, -20276, 20747, -9676,  7757, -4349,  -768,  3864, -8275, 13550, -19533, 12984, -16248, 19325, -21935, 11878, -12219, 11802, -10437,  3968, -2055,  -612,  4133, -4314,  7133, -10672, 15216, -2674,  3857, -6168, 14718, },
	{  2613, -6663, 13640, -24238,  9689, -14201, 19238, -24111,  6933, -7150,  6205, -3550,  -698,  4592, -10124, 17409, -13203, 18432, -24139, 29931, -17631, 19724, -20841, 20538, -9178,  6929, -3337, -1729,  4162, -8201, 12897, -18099, 11792, -14527, 17069, -19198, 10330, -10584, 10200, -8991,  3364, -1552, -1177,  5249, -1447,  2823, -5973, 24429, },
	{  -729,  -733,  4940, -13471,  7013, -12573, 20329, -30322, 10556, -13802, 16957, -19488, 10344, -9848,  7769, -3604, -1560,  6386, -12779, 20715, -15005, 20141, -25470, 30581, -17478, 18991, -19491, 18620, -8014,  5701, -2241, -2446,  4192, -7761, 11867, -16400, 10603, -13043, 15397, -17517,  9614, -10155, 10234, -9614,   978,  -449, -1106, 30023, },
	{  2576, -5202,  8059, -10151,  2464, -1223, -1910,  7761, -4293,  7717, -12323, 18099, -12430, 16101, -19725, 22827, -12395, 12438, -11134,  8061, -1413, -2444,  7634, -14159, 10950, -15300, 19919, -24515, 14358, -16038, 17045, -17107,  7974, -6648,  4453, -1284, -1471,  4139, -7376, 11189, -7791, 10290, -13130, 16414, -2552,  3232, -4401,  7871, },
	{  3371, -7622, 14018, -22507,  8107, -10568, 12371, -12587,  2499,  -787, -2385,  7402, -7290, 12047, -17951, 24832, -16166, 19943, -23347, 25875, -13463, 12919, -10966,  7281,  -798, -3135,  8182, -14285, 10644, -14461, 18399, -22206, 12786, -14069, 14751, -14613,  6713, -5475,  3464,  -539, -1736,  4405, -7932, 12680, -2430,  3784, -6582, 18438, },
	{  1698, -5130, 11640, -22303,  9493, -14742, 21178, -28334,  8832, -10198, 10716, -9801,  3391,  -474, -4187, 10863, -9851, 15336, -21750, 28809, -18032, 21447, -24255, 25990, -13068, 12078, -9765,  5902,  -159, -3539,  8133, -13549,  9820, -13091, 16432, -19649, 11252, -12361, 12989, -12948,  6004, -4932,  3030,   103,  -664,  1864, -4796, 27038, },
	{ -2333,  2315,   -73, -6102,  4568, -9663, 17315, -27868, 10342, -14349, 18733, -23051, 13328, -14346, 14061, -11887,  3608,   262, -5895, 13427, -11424, 16984, -23186, 29700, -18033, 20850, -22953, 23950, -11714, 10487, -8101,  4393,   379, -3706,  7779, -12555,  8973, -11913, 15011, -18167, 10631, -12083, 13367, -14402,  1884, -1894,  1708, 30563, },
	{  3070, -6479, 10835, -15420,  4712, -4740,  3191,   862, -2116,  5167, -9595, 15536, -11491, 15857, -20624, 25395, -14803, 16263, -16641, 15453, -6098,  3199,  1167, -7122,  7344, -11876, 17021, -22554, 14078, -16706, 18913, -20412, 10446, -10013,  8743, -6481,  1540,   795, -3824,  7606, -6105,  8872, -12204, 16308, -2707,  3688, -5511, 11620, },
	{  3098, -7382, 14314, -24253,  9263, -12944, 16604, -19416,  5049, -4355,  2318,  1550, -3862,  8297, -14193, 21534, -15064, 19782, -24594, 29039, -16265, 17184, -16889, 14980, -5535,  2416,  1984, -7712,  7362, -11434, 15933, -20656, 12665, -14810, 16562, -17695,  8979, -8537,  7371, -5308,  1068,  1216, -4423,  8968, -1967,  3385, -6481, 21905, },
	{   462, -2931,  8394, -18240,  8459, -14058, 21446, -30422, 10097, -12557, 14564, -15544,  7390, -5729,  2355,  3140, -5547, 10849, -17468, 25259, -16953, 21451, -25771, 29462, -15996, 16380, -15571, 13260, -4585,  1540,  2572, -7762,  6988, -10539, 14425, -18494, 11273, -13168, 14788, -15959,  8236, -8029,  7163, -5310,   223,   661, -3002, 28988, },
	{  2071, -3963,  5522, -5591,   614,  1534, -5712, 12623, -5724,  9241, -13718, 19027, -12428, 15336, -17848, 19449, -9760,  8678, -6116,  1728,  2385, -6776, 12317, -18911, 13168, -17116, 21042, -24619, 13727, -14549, 14538, -13449,  5524, -3565,   761,  2944, -3787,  6560, -9769, 13377, -8669, 10804, -13084, 15529, -2280,  2694, -3325,  4969, },
	{  3350, -7334, 12959, -19851,  6746, -8123,  8382, -6565,   374,  2034, -5911, 11538, -9543, 14275, -19840, 25955, -16076, 18884, -20973, 21829, -10440,  8766, -5607,   726,  3020, -7369, 12634, -18677, 12629, -16016, 19273, -22122, 12122, -12640, 12425, -11281,  4505, -2706,   144,  3288, -3861,  6671, -10230, 14841, -2646,  3867, -6280, 15421, },
	{  2469, -6432, 13366, -24040,  9715, -14390, 19715, -25039,  7326, -7757,  7077, -4727,    54,  3682, -9087, 16304, -12663, 17972, -23846, 29909, -17816, 20168, -21607, 21681, -9959,  7932, -4556,  -318,  3383, -7383, 12089, -17363, 11498, -14350, 17057, -19402, 10566, -10981, 10783, -9784,  3876, -2190,  -404,  4330, -1312,  2666, -5801, 24959, },
	{ -1019,  -189,  4064, -12216,  6611, -12120, 19904, -30061, 10583, -13989, 17391, -20269, 10961, -10743,  8984, -5162,  -610,  5289, -11580, 19489, -14432, 19679, -25204, 30608, -17690, 19456, -20257, 19729, -8754,  6629, -3348, -1185,  3506, -7053, 11178, -15785, 10365, -12913, 15421, -17747,  9863, -10576, 10878, -10558,  1151,  -714,  -621, 30186, },
	{  2681, -5465,  8612, -11172,  2890, -1874,  -987,  6543, -3920,  7296, -11897, 17739, -12334, 16156, -20015, 23446, -12919, 13226, -12226,  9484, -2293, -1410,  6478, -12937, 10347, -14757, 19503, -24303, 14395, -16262, 17499, -17830,  8485, -7317,  5281, -2261,  -918,  3541, -6760, 10591, -7526, 10091, -13039, 16497, -2596,  3336, -4628,  8557, },
	{  3346, -7629, 14162, -22967,  8369, -11069, 13225, -13921,  2984, -1450, -1532,  6367, -6701, 11428, -17367, 24375, -16063, 20037, -23725, 26624, -14068, 13793, -12137,  8760, -1685, -2120,  7078, -13149, 10099, -13986, 18054, -22056, 12844, -14295, 15180, -15279,  7177, -6080,  4213, -1430, -1225,  3840, -7330, 12072, -2360,  3734, -6604, 19107, },
	{  1490, -4768, 11128, -21706,  9364, -14710, 21361, -28896,  9120, -10697, 11494, -10924,  4152, -1450, -3001,  9499, -9114, 14599, -21090, 28329, -17944, 21581, -24688, 26798, -13695, 12954, -10908,  7310,  -985, -2614,  7146, -12554,  9353, -12696, 16160, -19556, 11326, -12588, 13405, -13589,  6457, -5538,  3815,  -897,  -505,  1657, -4508, 27454, },
	{  1520, -2638,  2907, -1074, -1146,  4043, -9000, 16562, -6782, 10204, -14322, 18904, -11764, 13783, -15084, 15147, -6688,  4571,  -921, -4516,  5951, -10631, 16221, -22534, 14629, -17975, 21016, -23406, 12376, -12316, 11308, -9149,  2831,  -355, -2895,  6925, -5852,  8579, -11587, 14800, -9063, 10729, -12344, 13851, -1900,  2044, -2164,  2284, },
	{  3141, -6674, 11288, -16323,  5113, -5388,  4162,  -497, -1671,  4622, -8975, 14895, -11202, 15663, -20608, 25657, -15131, 16851, -17550, 16734, -6943,  4254,   -87, -5705,  6584, -11110, 16309, -21972, 13895, -16682, 19098, -20858, 10823, -10565,  9485, -7417,  2103,   147, -3109,  6849, -5725,  8518, -11913, 16138, -2713,  3744, -5683, 12328, },
	{  3008, -7260, 14235, -24369,  9404, -13290, 17279, -20572,  5500, -5009,  3211,   400, -3162,  7494, -13336, 20699, -14712, 19570, -24609, 29382, -16655, 17846, -17873, 16321, -6394,  3459,   777, -6382,  6666, -10750, 15315, -20170, 12526, -14816, 16757, -18124,  9331, -9046,  8053, -6174,  1597,   590, -3706,  8166, -1859,  3275, -6400, 22509, },
	{   203, -2457,  7664, -17260,  8175, -13792, 21298, -30547, 10249, -12900, 15177, -16514,  8097, -6693,  3598,  1620, -4665,  9884, -16483, 24344, -16590, 21255, -25826, 29859, -16411, 17055, -16541, 14548, -5391,  2499,  1484, -6584,  6382, -9954, 13910, -18104, 11174, -13203, 14998, -16391,  8590, -8552,  7896, -6312,   395,   415, -2602, 29270, },
	{  2192, -4257,  6114, -6639,  1033,   921, -4882, 11585, -5428,  8941, -13468, 18908, -12489, 15584, -18361, 20312, -10406,  9576, -7289,  3180,  1530, -5820, 11307, -17917, 12725, -16783, 20887, -24714, 13937, -14960, 15181, -14350,  6111, -4287,  1609,  1991, -3276,  6038, -9269, 12941, -8510, 10739, -13157, 15804, -2353,  2828, -3581,  5616, },
	{  3373, -7435, 13259, -20543,  7085, -8713,  9323, -7958,   857,  1405, -5140, 10655, -9077, 13837, -19506, 25824, -16174, 19216, -21615, 22857, -11180,  9755, -6857,  2226,  2163, -6437, 11677, -17763, 12236, -15737, 19165, -22248, 12332, -13028, 13017, -12097,  5031, -3352,   903,  2430, -3394,  6186, -9756, 14421, -2610,  3867, -6377, 16121, },
	{  2313, -6175, 13047, -23769,  9712, -14539, 20141, -25905,  7703, -8348,  7937, -5902,   812,  2755, -8016, 15144, -12084, 17458, -23483, 29802, -17951, 20557, -22315, 22769, -10717,  8917, -5768,  1102,  2589, -6539, 11242, -16574, 11169, -14131, 16996, -19551, 10774, -11349, 11339, -10553,  4380, -2825,   375,  3391, -1172,  2499, -5607, 25469, },
	{ -1314,   367,  3159, -10904,  6184, -11625, 19415, -29711, 10579, -14138, 17779, -20998, 11552, -11614, 10182, -6718,   347,  4169, -10340, 18201, -13815, 19159, -24864, 30547, -17854, 19868, -20970, 20789, -9473,  7543, -4451,    85,  2808, -6321, 10455, -15122, 10097, -12747, 15401, -17928, 10085, -10970, 11496, -11480,  1322,  -981,  -118, 30320, },
	{  2780, -5717,  9150, -12178,  3313, -2528,   -49,  5291, -3530,  6849, -11432, 17324, -12202, 16166, -20250, 24002, -13410, 13981, -13291, 10891, -3172,  -365,  5297, -11672,  9711, -14170, 19030, -24020, 14392, -16442, 17906, -18506,  8974, -7969,  6098, -3237,  -361,  2930, -6122,  9960, -7238,  9861, -12912, 16533, -2634,  3431, -4847,  9250, },
	{  3310, -7613, 14266, -23368,  8611, -11545, 14052, -15230,  3466, -2115,  -666,  5304, -6089, 10771, -16728, 23846, -15913, 20076, -24037, 27303, -14636, 14633, -13280, 10222, -2573, -1094,  5948, -11970,  9522, -13470, 17656, -21841, 12864, -14481, 15569, -15905,  7624, -6671,  4955, -2323,  -708,  3260, -6704, 11425, -2282,  3674, -6608, 19766, },
	{  1272, -4384, 10572, -21035,  9206, -14634, 21483, -29381,  9385, -11170, 12246, -12025,  4908, -2430, -1797,  8097, -8345, 13815, -20366, 27765, -17804, 21655, -25054, 27535, -14286, 13799, -12026,  8705, -1812, -1677,  6134, -11518,  8857, -12264, 15841, -19407, 11368, -12781, 13785, -14196,  6894, -6132,  4595, -1903,  -343,  1442, -4199, 27846, },
	{  1648, -2944,  3503, -2089,  -756,  3498, -8302, 15752, -6576, 10035, -14254, 19023, -11972, 14202, -15785, 16199, -7420,  5529, -2109, -3114,  5166, -9802, 15408, -21815, 14366, -17865, 21123, -23796, 12744, -12886, 12101, -10176,  3460, -1090, -2073,  6048, -5408,  8159, -11227, 14546, -9016, 10798, -12571, 14299, -1995,  2201, -2434,  2875, },
	{  3204, -6854, 11717, -17193,  5505, -6030,  5135, -1871, -1216,  4058, -8324, 14205, -10879, 15423, -20532, 25849, -15419, 17395, -18414, 17976, -7774,  5304, -1347, -4264,  5802, -10309, 15548, -21324, 13673, -16609, 19229, -21247, 11172, -11090, 10203, -8336,  2662,  -504, -2380,  6069, -5327,  8138, -11587, 15920, -2711,  3789, -5843, 13037, },
	{  2906, -7113, 14111, -24415,  9520, -13603, 17913, -21681,  5940, -5656,  4103,  -762, -2446,  6664, -12433, 19798, -14317, 19300, -24553, 29643, -17000, 18462, -18811, 17623, -7239,  4497,  -438, -5026,  5947, -10031, 14651, -19625, 12351, -14781, 16906, -18503,  9658, -9532,  8715, -7028,  2125,   -41, -2972,  7334, -1744,  3154, -6298, 23098, },
	{   -65, -1965,  6897, -16213,  7863, -13482, 21086, -30585, 10374, -13209, 15753, -17446,  8787, -7646,  4841,    84, -3764,  8884, -15445, 23354, -16177, 20998, -25808, 30174, -16782, 17686, -17470, 15802, -6186,  3455,   386, -5381,  5755, -9339, 13352, -17660, 11042, -13200, 15166, -16779,  8921, -9054,  8612, -7306,   568,   164, -2182, 29526, },
	{  2310, -4545,  6701, -7686,  1455,   296, -4027, 10502, -5113,  8611, -13176, 18734, -12514, 15789, -18825, 21122, -11029, 10454, -8449,  4633,   666, -4842, 10259, -16866, 12243, -16401, 20671, -24738, 14109, -15329, 15784, -15215,  6683, -5000,  2457,  1028, -2752,  5496, -8740, 12467, -8326, 10642, -13193, 16037, -2419,  2956, -3832,  6273, },
	{  3385, -7516, 13527, -21187,  7408, -9286, 10249, -9344,  1342,   765, -4347,  9733, -8581, 13356, -19113, 25619, -16226, 19496, -22200, 23825, -11892, 10724, -8095,  3728,  1294, -5482, 10682, -16794, 11806, -15412, 19003, -22311, 12508, -13380, 13574, -12883,  5546, -3991,  1664,  1560, -2916,  5681, -9250, 13956, -2565,  3856, -6458, 16815, },
	{  2145, -5894, 12683, -23423,  9681, -14648, 20514, -26707,  8061, -8921,  8782, -7071,  1575,  1813, -6914, 13932, -11466, 16890, -23050, 29609, -18035, 20889, -22964, 23798, -11449,  9882, -6970,  2526,  1785, -5673, 10359, -15734, 10807, -13870, 16886, -19646, 10952, -11687, 11865, -11297,  4875, -3457,  1160,  2434, -1027,  2322, -5392, 25959, },
	{ -1612,   933,  2228, -9538,  5732, -11089, 18865, -29271, 10546, -14248, 18120, -21674, 12114, -12459, 11361, -8266,  1311,  3029, -9062, 16851, -13155, 18580, -24452, 30400, -17967, 20226, -21628, 21795, -10168,  8440, -5547,  1360,  2098, -5568,  9698, -14413,  9798, -12543, 15338, -18059, 10280, -11336, 12087, -12379,  1491, -1250,   403, 30426, },
	{  2874, -5958,  9672, -13166,  3734, -3184,   901,  4009, -3127,  6378, -10930, 16857, -12034, 16129, -20429, 24494, -13866, 14702, -14325, 12275, -4047,   687,  4094, -10366,  9043, -13539, 18499, -23667, 14347, -16576, 18265, -19133,  9440, -8601,  6902, -4208,   201,  2308, -5462,  9297, -6927,  9602, -12746, 16522, -2664,  3518, -5056,  9947, },
	{  3261, -7573, 14330, -23707,  8831, -11995, 14849, -16512,  3943, -2781,   210,  4217, -5453, 10078, -16037, 23244, -15716, 20057, -24283, 27908, -15167, 15436, -14392, 11664, -3458,   -59,  4795, -10750,  8915, -12913, 17205, -21564, 12849, -14627, 15916, -16488,  8050, -7245,  5687, -3213,  -185,  2667, -6053, 10739, -2197,  3602, -6594, 20415, },
	{  1044, -3978,  9975, -20292,  9019, -14516, 21546, -29787,  9626, -11616, 12970, -13103,  5656, -3411,  -578,  6662, -7547, 12985, -19579, 27118, -17613, 21668, -25350, 28198, -14840, 14609, -13115, 10082, -2639,  -730,  5100, -10445,  8333, -11795, 15475, -19202, 11378, -12939, 14128, -14765,  7314, -6713,  5368, -2913,  -178,  1219, -3869, 28214, },
	{  1775, -3249,  4102, -3118,  -358,  2935, -7571, 14887, -6348,  9836, -14145, 19089, -12147, 14585, -16447, 17213, -8135,  6477, -3300, -1694,  4362, -8941, 14546, -21030, 14060, -17704, 21170, -24120, 13078, -13422, 12863, -11180,  4083, -1827, -1241,  5149, -4946,  7713, -10834, 14249, -8944, 10836, -12765, 14709, -2086,  2353, -2702,  3480, },
	{  3258, -7018, 12119, -18028,  5887, -6664,  6105, -3255,  -753,  3477, -7642, 13467, -10522, 15137, -20398, 25967, -15665, 17894, -19232, 19175, -8588,  6345, -2611, -2803,  4999, -9474, 14738, -20613, 13410, -16490, 19307, -21578, 11491, -11587, 10895, -9236,  3216, -1157, -1641,  5267, -4912,  7732, -11226, 15656, -2701,  3825, -5989, 13746, },
	{  2791, -6941, 13944, -24390,  9610, -13880, 18503, -22741,  6368, -6293,  4992, -1933, -1718,  5807, -11488, 18834, -13877, 18973, -24427, 29822, -17298, 19028, -19701, 18883, -8068,  5529, -1658, -3650,  5208, -9281, 13942, -19022, 12140, -14703, 17008, -18831,  9959, -9993,  9356, -7867,  2650,  -676, -2224,  6474, -1623,  3022, -6176, 23670, },
	{  -340, -1457,  6095, -15101,  7524, -13129, 20811, -30535, 10471, -13484, 16289, -18337,  9458, -8585,  6079, -1464, -2846,  7853, -14355, 22291, -15716, 20679, -25716, 30404, -17107, 18269, -18353, 17018, -6967,  4406,  -718, -4157,  5109, -8693, 12753, -17165, 10879, -13160, 15293, -17122,  9230, -9534,  9309, -8288,   741,   -91, -1742, 29754, },
	{  2425, -4827,  7280, -8729,  1879,  -338, -3150,  9376, -4780,  8254, -12845, 18504, -12503, 15951, -19240, 21879, -11624, 11307, -9593,  6082,  -206, -3844,  9176, -15761, 11724, -15970, 20395, -24693, 14241, -15657, 16345, -16040,  7239, -5703,  3301,    58, -2219,  4936, -8184, 11954, -8118, 10515, -13192, 16227, -2479,  3077, -4076,  6940, },
	{  3387, -7576, 13759, -21780,  7714, -9840, 11157, -10720,  1829,   116, -3533,  8775, -8056, 12833, -18663, 25339, -16233, 19721, -22725, 24733, -12575, 11667, -9317,  5229,   417, -4506,  9652, -15772, 11340, -15042, 18786, -22310, 12650, -13696, 14095, -13635,  6048, -4623,  2424,   681, -2426,  5156, -8715, 13448, -2514,  3833, -6522, 17503, },
	{  1964, -5589, 12274, -23003,  9622, -14716, 20833, -27441,  8399, -9474,  9610, -8230,  2340,   857, -5783, 12671, -10810, 16271, -22549, 29331, -18069, 21164, -23551, 24766, -12152, 10824, -8159,  3951,   971, -4787,  9443, -14846, 10413, -13570, 16728, -19686, 11099, -11993, 12361, -12013,  5359, -4084,  1947,  1461,  -877,  2135, -5156, 26429, },
	{ -1914,  1510,  1274, -8123,  5257, -10515, 18254, -28741, 10481, -14319, 18413, -22294, 12647, -13275, 12516, -9802,  2278,  1873, -7749, 15446, -12453, 17946, -23967, 30165, -18030, 20528, -22227, 22743, -10838,  9317, -6632,  2639,  1379, -4796,  8910, -13660,  9470, -12302, 15230, -18139, 10448, -11671, 12648, -13251,  1658, -1521,   941, 30504, },
	{  2961, -6186, 10176, -14132,  4150, -3841,  1860,  2700, -2710,  5883, -10392, 16336, -11830, 16047, -20551, 24920, -14287, 15386, -15326, 13634, -4917,  1744,  2872, -9022,  8347, -12866, 17914, -23245, 14262, -16663, 18573, -19708,  9881, -9211,  7690, -5172,   764,  1676, -4784,  8604, -6595,  9314, -12543, 16464, -2688,  3596, -5255, 10649, },
	{  3201, -7510, 14352, -23983,  9029, -12415, 15612, -17760,  4414, -3446,  1094,  3107, -4796,  9351, -15295, 22572, -15473, 19981, -24461, 28438, -15658, 16201, -15470, 13080, -4338,   981,  3622, -9494,  8279, -12316, 16704, -21224, 12797, -14733, 16218, -17028,  8457, -7803,  6406, -4100,   341,  2062, -5381, 10017, -2105,  3518, -6560, 21051, },
	{   805, -3551,  9336, -19476,  8803, -14353, 21546, -30111,  9842, -12033, 13664, -14152,  6395, -4390,   652,  5197, -6722, 12113, -18731, 26390, -17370, 21619, -25577, 28785, -15355, 15382, -14173, 11438, -3462,   223,  4047, -9337,  7784, -11290, 15064, -18941, 11356, -13060, 14433, -15296,  7716, -7279,  6132, -3924,   -10,   988, -3518, 28558, },
	{  1900, -3552,  4701, -4155,    47,  2355, -6809, 13969, -6099,  9606, -13994, 19100, -12289, 14929, -17067, 18185, -8833,  7414, -4489,  -260,  3540, -8049, 13638, -20181, 13713, -17491, 21158, -24377, 13376, -13922, 13593, -12156,  4697, -2561,  -401,  4232, -4468,  7243, -10407, 13910, -8846, 10844, -12924, 15082, -2171,  2500, -2967,  4098, },
	{  3303, -7164, 12493, -18824,  6257, -7287,  7069, -4647,  -283,  2879, -6932, 12685, -10132, 14805, -20204, 26013, -15868, 18345, -20001, 20328, -9383,  7375, -3875, -1325,  4177, -8607, 13882, -19839, 13108, -16323, 19330, -21849, 11779, -12052, 11560, -10114,  3764, -1811,  -894,  4445, -4480,  7301, -10830, 15345, -2683,  3850, -6122, 14453, },
	{  2664, -6744, 13731, -24293,  9673, -14120, 19047, -23748,  6782, -6919,  5876, -3108,  -978,  4927, -10503, 17809, -13395, 18590, -24231, 29917, -17549, 19544, -20540, 20096, -8879,  6550, -2880, -2256,  4451, -8501, 13190, -18361, 11894, -14583, 17062, -19108, 10234, -10428,  9974, -8688,  3170, -1313, -1465,  5588, -1496,  2879, -6032, 24225, },
	{  -622,  -933,  5261, -13927,  7157, -12733, 20472, -30397, 10539, -13722, 16783, -19183, 10107, -9507,  7310, -3019, -1913,  6791, -13218, 21158, -15207, 20299, -25551, 30549, -17386, 18804, -19190, 18191, -7732,  5350, -1826, -2915,  4445, -8020, 12116, -16618, 10684, -13082, 15376, -17418,  9514, -9990,  9986, -9256,   914,  -351, -1283, 29955, },
	{  2536, -5102,  7849, -9765,  2305,  -981, -2251,  8209, -4429,  7869, -12473, 18220, -12457, 16068, -19603, 22580, -12190, 12135, -10718,  7523, -1083, -2828,  8060, -14605, 11168, -15492, 20060, -24577, 14334, -15942, 16862, -16824,  7777, -6393,  4140,  -917, -1676,  4359, -7601, 11404, -7885, 10357, -13154, 16372, -2533,  3191, -4314,  7616, },
	{  3378, -7614, 13955, -22319,  8003, -10373, 12044, -12081,  2317,  -540, -2701,  7782, -7504, 12269, -18156, 24984, -16193, 19893, -23189, 25576, -13227, 12583, -10520,  6723,  -466, -3512,  8589, -14700, 10840, -14628, 18515, -22247, 12756, -13975, 14579, -14353,  6534, -5244,  3181,  -205, -1926,  4613, -8151, 12897, -2454,  3799, -6569, 18184, },
	{  1772, -5259, 11822, -22508,  9533, -14743, 21095, -28104,  8718, -10005, 10418, -9376,  3104,  -109, -4627, 11364, -10119, 15601, -21981, 28967, -18052, 21381, -24075, 25668, -12824, 11741, -9331,  5371,   151, -3882,  8495, -13911,  9988, -13229, 16522, -19669, 11216, -12267, 12824, -12699,  5831, -4703,  2735,   475,  -723,  1940, -4898, 26876, },
	{ -2218,  2094,   298, -6662,  4760, -9902, 17582, -28123, 10385, -14348, 18655, -22856, 13148, -14060, 13645, -11322,  3245,   703, -6406, 13987, -11712, 17256, -23412, 29843, -18042, 20773, -22766, 23633, -11481, 10173, -7704,  3915,   653, -4006,  8093, -12864,  9114, -12026, 15079, -18169, 10586, -11976, 13177, -14094,  1823, -1792,  1496, 30552, },
	{  3042, -6402, 10660, -15074,  4560, -4495,  2827,  1367, -2280,  5366, -9819, 15764, -11590, 15917, -20615, 25279, -14669, 16031, -16290, 14963, -5778,  2802,  1634, -7646,  7622, -12153, 17274, -22755, 14136, -16703, 18830, -20230, 10297, -9799,  8460, -6126,  1329,  1037, -4089,  7883, -6243,  8998, -12303, 16359, -2703,  3665, -5444, 11355, },
	{  3128, -7422, 14332, -24192,  9204, -12806, 16341, -18972,  4878, -4108,  1983,  1978, -4120,  8590, -14502, 21830, -15184, 19847, -24571, 28890, -16107, 16924, -16510, 14468, -5211,  2025,  2433, -8204,  7617, -11681, 16152, -20822, 12708, -14796, 16477, -17522,  8841, -8341,  7111, -4980,   870,  1448, -4688,  9260, -2006,  3423, -6506, 21675, },
	{   558, -3104,  8658, -18590,  8558, -14147, 21485, -30353, 10032, -12420, 14325, -15170,  7121, -5365,  1890,  3705, -5872, 11201, -17823, 25582, -17076, 21508, -25731, 29293, -15829, 16116, -15196, 12768, -4280,  1181,  2977, -8197,  7209, -10750, 14608, -18626, 11301, -13146, 14699, -15786,  8098, -7828,  6884, -4933,   159,   751, -3147, 28876, },
	{  2025, -3851,  5298, -5199,   459,  1761, -6017, 12999, -5830,  9346, -13801, 19057, -12397, 15233, -17643, 19113, -9511,  8337, -5674,  1185,  2702, -7128, 12685, -19269, 13324, -17228, 21085, -24566, 13638, -14386, 14287, -13102,  5301, -3292,   443,  3298, -3975,  6751, -9949, 13530, -8722, 10821, -13047, 15414, -2252,  2642, -3228,  4729, },
	{  3339, -7291, 12838, -19579,  6615, -7897,  8026, -6042,   194,  2267, -6195, 11858, -9709, 14428, -19951, 25985, -16028, 18746, -20718, 21430, -10156,  8389, -5136,   165,  3338, -7712, 12982, -19005, 12767, -16108, 19299, -22059, 12034, -12486, 12195, -10968,  4304, -2462,  -140,  3607, -4032,  6847, -10400, 14987, -2657,  3865, -6240, 15158, },
	{  2525, -6522, 13474, -24123,  9709, -14323, 19542, -24698,  7181, -7531,  6751, -4286,  -229,  4026, -9480, 16725, -12870, 18151, -23964, 29927, -17752, 20008, -21326, 21258, -9669,  7558, -4100,  -848,  3677, -7693, 12396, -17645, 11612, -14421, 17067, -19332, 10481, -10836, 10567, -9489,  3685, -1951,  -695,  4677, -1363,  2726, -5868, 24762, },
	{  -910,  -394,  4396, -12693,  6765, -12295, 20071, -30170, 10576, -13924, 17234, -19982, 10733, -10410,  8530, -4578,  -967,  5703, -12035, 19957, -14652, 19860, -25312, 30608, -17616, 19288, -19976, 19319, -8479,  6282, -2934, -1659,  3765, -7321, 11441, -16021, 10458, -12966, 15417, -17666,  9772, -10421, 10639, -10206,  1086,  -614,  -805, 30128, },
	{  2642, -5367,  8406, -10791,  2730, -1629, -1335,  7004, -4062,  7457, -12061, 17880, -12375, 16141, -19913, 23221, -12726, 12934, -11819,  8952, -1963, -1799,  6915, -13401, 10577, -14966, 19666, -24391, 14386, -16183, 17334, -17564,  8296, -7068,  4972, -1895, -1126,  3767, -6994, 10820, -7628, 10169, -13078, 16471, -2580,  3298, -4544,  8299, },
	{  3357, -7629, 14113, -22802,  8273, -10884, 12908, -13423,  2803, -1201, -1854,  6759, -6925, 11664, -17592, 24555, -16107, 20008, -23591, 26351, -13845, 13469, -11701,  8207, -1352, -2502,  7495, -13581, 10307, -14169, 18190, -22120, 12826, -14215, 15024, -15034,  7005, -5854,  3933, -1096, -1418,  4054, -7559, 12304, -2387,  3754, -6598, 18857, },
	{  1569, -4906, 11325, -21938,  9416, -14727, 21299, -28694,  9015, -10513, 11205, -10505,  3867, -1083, -3448, 10015, -9394, 14881, -21346, 28519, -17983, 21538, -24533, 26503, -13464, 12629, -10482,  6783,  -675, -2962,  7519, -12932,  9532, -12849, 16268, -19597, 11302, -12507, 13253, -13353,  6289, -5312,  3521,  -521,  -566,  1736, -4618, 27301, },
	{ -2524,  2684,  -697, -5157,  4242, -9253, 16851, -27416, 10259, -14337, 18846, -23357, 13616, -14812, 14744, -12821,  4211,  -477, -5036, 12479, -10932, 16513, -22787, 29434, -18003, 20961, -23244, 24459, -12094, 11004, -8759,  5187,   -79, -3201,  7248, -12028,  8730, -11714, 14885, -18147, 10696, -12250, 13673, -14904,  1985, -2063,  2066, 30572, },
	{  3115, -6603, 11121, -15988,  4964, -5146,  3798,    15, -1839,  4829, -9211, 15141, -11315, 15741, -20620, 25567, -15013, 16635, -17214, 16258, -6628,  3859,   384, -6240,  6872, -11401, 16582, -22198, 13968, -16696, 19035, -20697, 10685, -10361,  9209, -7068,  1892,   391, -3379,  7136, -5870,  8654, -12027, 16207, -2712,  3724, -5620, 12062, },
	{  3043, -7309, 14269, -24333,  9354, -13164, 17031, -20144,  5332, -4765,  2876,   833, -3426,  7799, -13663, 21020, -14849, 19656, -24612, 29263, -16514, 17603, -17509, 15822, -6073,  3068,  1231, -6884,  6930, -11010, 15553, -20359, 12583, -14819, 16690, -17969,  9202, -8858,  7799, -5851,  1399,   826, -3977,  8471, -1900,  3317, -6432, 22284, },
	{   301, -2637,  7942, -17636,  8285, -13897, 21360, -30510, 10195, -12775, 14952, -16155,  7834, -6333,  3132,  2193, -4998, 10250, -16859, 24696, -16732, 21336, -25814, 29720, -16260, 16807, -16182, 14069, -5090,  2139,  1893, -7029,  6612, -10177, 14108, -18256, 11215, -13194, 14924, -16234,  8460, -8358,  7623, -5937,   330,   508, -2754, 29168, },
	{  2147, -4147,  5893, -6246,   875,  1152, -5197, 11980, -5542,  9057, -13566, 18959, -12470, 15496, -18174, 19994, -10167,  9242, -6850,  2635,  1852, -6181, 11690, -18296, 12896, -16914, 20952, -24687, 13863, -14810, 14944, -14016,  5893, -4017,  1291,  2350, -3469,  6236, -9460, 13109, -8573, 10767, -13134, 15706, -2326,  2779, -3486,  5372, },
	{  3366, -7400, 13150, -20289,  6960, -8494,  8972, -7436,   675,  1642, -5432, 10990, -9255, 14007, -19638, 25882, -16143, 19098, -21381, 22478, -10906,  9387, -6390,  1663,  2485, -6789, 12041, -18112, 12388, -15847, 19212, -22208, 12257, -12886, 12799, -11795,  4835, -3110,   618,  2753, -3571,  6370, -9938, 14584, -2624,  3869, -6342, 15859, },
	{  2373, -6274, 13172, -23879,  9717, -14488, 19988, -25587,  7563, -8128,  7616, -5462,   527,  3105, -8422, 15585, -12306, 17657, -23627, 29852, -17906, 20417, -22056, 22368, -10436,  8550, -5315,   569,  2888, -6858, 11564, -16876, 11296, -14218, 17024, -19502, 10699, -11215, 11134, -10267,  4192, -2587,    82,  3746, -1225,  2562, -5682, 25280, },
	{ -1203,   157,  3501, -11402,  6347, -11815, 19606, -29853, 10584, -14087, 17639, -20731, 11333, -11290,  9735, -6135,   -13,  4591, -10809, 18691, -14052, 19361, -25000, 30580, -17798, 19720, -20709, 20398, -9206,  7202, -4038,  -392,  3071, -6598, 10730, -15376, 10201, -12814, 15414, -17866, 10005, -10825, 11267, -11137,  1258,  -881,  -309, 30273, },
	{  2743, -5623,  8950, -11803,  3155, -2282,  -402,  5764, -3678,  7019, -11611, 17486, -12256, 16168, -20168, 23801, -13230, 13702, -12895, 10366, -2842,  -758,  5743, -12151,  9953, -14395, 19214, -24134, 14398, -16380, 17759, -18258,  8793, -7727,  5793, -2872,  -570,  3161, -6364, 10201, -7349,  9951, -12964, 16525, -2621,  3396, -4766,  8989, },
	{  3325, -7622, 14232, -23225,  8523, -11370, 13745, -14742,  3286, -1865,  -992,  5706, -6321, 11022, -16974, 24053, -15974, 20068, -23928, 27057, -14428, 14322, -12855,  9676, -2240, -1480,  6374, -12417,  9742, -13669, 17811, -21929, 12861, -14416, 15428, -15675,  7458, -6451,  4678, -1988,  -902,  3479, -6942, 11672, -2312,  3698, -6609, 19520, },
	{  1355, -4531, 10785, -21295,  9269, -14668, 21444, -29208,  9289, -10996, 11967, -11615,  4625, -2062, -2250,  8627, -8637, 14114, -20645, 27986, -17862, 21635, -24925, 27267, -14068, 13486, -11609,  8184, -1502, -2029,  6517, -11911,  9046, -12430, 15966, -19469, 11356, -12713, 13647, -13973,  6732, -5911,  4303, -1525,  -404,  1523, -4318, 27702, },
	{  1600, -2829,  3279, -1707,  -903,  3704, -8568, 16063, -6656, 10102, -14285, 18985, -11898, 14049, -15527, 15809, -7147,  5171, -1663, -3642,  5463, -10117, 15719, -22093, 14470, -17912, 21090, -23657, 12610, -12676, 11807, -9794,  3225,  -814, -2383,  6380, -5577,  8320, -11366, 14647, -9037, 10776, -12490, 14135, -1960,  2142, -2333,  2652, },
	{  3181, -6789, 11559, -16871,  5359, -5790,  4770, -1354, -1388,  4272, -8572, 14469, -11005, 15518, -20567, 25785, -15316, 17196, -18095, 17515, -7464,  4911,  -874, -4807,  6098, -10613, 15839, -21575, 13761, -16642, 19186, -21108, 11045, -10897,  9936, -7993,  2453,  -260, -2655,  6364, -5479,  8283, -11714, 16007, -2712,  3773, -5785, 12771, },
	{  2946, -7171, 14163, -24406,  9480, -13490, 17680, -21271,  5777, -5415,  3769,  -325, -2716,  6979, -12777, 20143, -14470, 19408, -24582, 29555, -16876, 18236, -18464, 17140, -6924,  4109,    19, -5537,  6219, -10305, 14905, -19837, 12421, -14799, 16856, -18367,  9538, -9352,  8469, -6709,  1927,   197, -3249,  7650, -1788,  3200, -6339, 22879, },
	{    36, -2152,  7189, -16613,  7983, -13603, 21173, -30581, 10331, -13097, 15542, -17101,  8530, -7290,  4375,   662, -4104,  9263, -15840, 23734, -16338, 21101, -25823, 30066, -16648, 17455, -17127, 15336, -5889,  3097,   798, -5835,  5993, -9573, 13566, -17833, 11095, -13205, 15108, -16639,  8800, -8868,  8346, -6935,   503,   259, -2342, 29433, },
	{  2266, -4438,  6482, -7294,  1296,   532, -4351, 10914, -5234,  8738, -13290, 18806, -12509, 15717, -18657, 20825, -10798, 10127, -8016,  4088,   991, -5211, 10657, -17267, 12428, -16550, 20759, -24737, 14049, -15195, 15563, -14895,  6470, -4734,  2139,  1390, -2950,  5702, -8942, 12649, -8398, 10682, -13184, 15955, -2395,  2909, -3738,  6026, },
	{  3382, -7488, 13430, -20952,  7289, -9073,  9904, -8825,  1160,  1006, -4647, 10083, -8770, 13542, -19268, 25705, -16212, 19397, -21987, 23469, -11628, 10363, -7633,  3165,  1621, -5843, 11060, -17163, 11971, -15540, 19070, -22294, 12446, -13252, 13369, -12592,  5354, -3752,  1379,  1887, -3096,  5873, -9444, 14136, -2583,  3861, -6429, 16555, },
	{  2209, -6002, 12825, -23561,  9696, -14612, 20381, -26414,  7929, -8708,  8467, -6633,  1289,  2168, -7331, 14392, -11702, 17109, -23221, 29691, -18010, 20771, -22727, 23419, -11178,  9523, -6521,  1992,  2088, -6001, 10695, -16055, 10947, -13973, 16933, -19617, 10888, -11564, 11671, -11021,  4691, -3221,   865,  2795, -1082,  2389, -5475, 25778, },
	{ -1500,   720,  2580, -10056,  5904, -11295, 19079, -29446, 10562, -14212, 17998, -21427, 11907, -12145, 10921, -7687,   949,  3458, -9545, 17364, -13408, 18804, -24615, 30465, -17930, 20098, -21388, 21424, -9910,  8106, -5137,   882,  2366, -5853,  9985, -14684,  9914, -12624, 15367, -18016, 10210, -11202, 11869, -12045,  1428, -1149,   206, 30390, },
	{  2839, -5869,  9478, -12798,  3576, -2938,   543,  4493, -3280,  6557, -11123, 17038, -12101, 16149, -20368, 24317, -13699, 14436, -13941, 11759, -3719,   292,  4547, -10860,  9297, -13781, 18705, -23807, 14369, -16531, 18136, -18904,  9268, -8366,  6602, -3845,   -10,  2543, -5712,  9550, -7046,  9703, -12812, 16531, -2654,  3486, -4979,  9685, },
	{  3281, -7591, 14311, -23588,  8751, -11829, 14554, -16035,  3765, -2531,  -120,  4627, -5694, 10342, -16303, 23478, -15795, 20071, -24198, 27690, -14973, 15140, -13979, 11126, -3126,  -448,  5230, -11212,  9146, -13126, 17380, -21675, 12859, -14577, 15791, -16274,  7893, -7032,  5414, -2880,  -382,  2891, -6300, 11001, -2230,  3630, -6601, 20173, },
	{  1131, -4133, 10203, -20579,  9093, -14565, 21529, -29644,  9539, -11452, 12702, -12702,  5376, -3043, -1037,  7204, -7850, 13301, -19881, 27371, -17690, 21670, -25247, 27958, -14637, 14310, -12710,  9568, -2329, -1086,  5491, -10852,  8533, -11975, 15618, -19285, 11378, -12884, 14004, -14556,  7158, -6497,  5079, -2534,  -240,  1303, -3996, 28079, },
	{  1727, -3135,  3877, -2731,  -508,  3148, -7849, 15218, -6436,  9914, -14191, 19071, -12085, 14446, -16204, 16837, -7869,  6123, -2853, -2228,  4665, -9268, 14875, -21332, 14180, -17770, 21159, -24006, 12957, -13225, 12581, -10806,  3851, -1551, -1554,  5489, -5121,  7883, -10985, 14366, -8974, 10825, -12696, 14560, -2052,  2296, -2601,  3251, },
	{  3238, -6959, 11971, -17719,  5745, -6427,  5741, -2735,  -928,  3697, -7901, 13749, -10660, 15250, -20455, 25931, -15578, 17712, -18931, 18731, -8285,  5956, -2137, -3353,  5302, -9791, 15047, -20887, 13513, -16540, 19284, -21461, 11375, -11404, 10639, -8901,  3009,  -912, -1920,  5570, -5069,  7887, -11365, 15761, -2705,  3813, -5936, 13480, },
	{  2836, -7009, 14012, -24408,  9579, -13780, 18287, -22350,  6209, -6056,  4659, -1493, -1993,  6132, -11848, 19203, -14047, 19102, -24483, 29765, -17192, 18822, -19373, 18416, -7759,  5143, -1200, -4168,  5488, -9566, 14213, -19255, 12223, -14737, 16975, -18714,  9849, -9823,  9118, -7554,  2453,  -437, -2506,  6800, -1669,  3072, -6224, 23458, },
	{  -236, -1649,  6400, -15526,  7654, -13266, 20922, -30564, 10438, -13385, 16092, -18008,  9208, -8235,  5616,  -882, -3192,  8243, -14770, 22698, -15895, 20805, -25759, 30327, -16991, 18056, -18027, 16567, -6676,  4050,  -304, -4618,  5353, -8939, 12982, -17356, 10944, -13179, 15250, -16999,  9117, -9357,  9050, -7921,   676,     5, -1909, 29672, },
	{  2382, -4722,  7064, -8339,  1720,   -99, -3481,  9803, -4907,  8391, -12974, 18597, -12512, 15895, -19090, 21602, -11404, 10990, -9166,  5539,   121, -4220,  9586, -16182, 11923, -16137, 20505, -24718, 14196, -15539, 16140, -15735,  7033, -5441,  2985,   422, -2420,  5148, -8396, 12151, -8199, 10566, -13197, 16161, -2458,  3033, -3985,  6689, },
	{  3387, -7556, 13676, -21564,  7602, -9635, 10819, -10205,  1647,   360, -3841,  9138, -8256, 13034, -18839, 25452, -16236, 19643, -22535, 24400, -12323, 11316, -8861,  4667,   747, -4874, 10042, -16161, 11519, -15186, 18874, -22318, 12601, -13582, 13904, -13357,  5861, -4387,  2139,  1011, -2611,  5355, -8919, 13644, -2534,  3843, -6500, 17246, },
	{  2033, -5706, 12433, -23169,  9648, -14696, 20720, -27174,  8275, -9269,  9301, -7796,  2053,  1217, -6210, 13149, -11060, 16509, -22745, 29445, -18063, 21068, -23338, 24410, -11891, 10474, -7715,  3417,  1277, -5121,  9791, -15184, 10565, -13687, 16793, -19677, 11048, -11882, 12179, -11748,  5179, -3850,  1652,  1828,  -934,  2206, -5247, 26255, },
	{ -1801,  1293,  1634, -8660,  5438, -10735, 18490, -28950, 10509, -14297, 18309, -22068, 12451, -12973, 12086, -9228,  1915,  2308, -8245, 15979, -12721, 18190, -24157, 30263, -18012, 20421, -22009, 22394, -10590,  8991, -6227,  2159,  1650, -5087,  9209, -13947,  9597, -12397, 15276, -18115, 10388, -11549, 12441, -12927,  1596, -1419,   738, 30478, },
	{  2929, -6102,  9989, -13773,  3994, -3595,  1499,  3194, -2868,  6071, -10598, 16537, -11910, 16083, -20512, 24769, -14133, 15134, -14955, 13128, -4591,  1347,  3332, -9530,  8611, -13123, 18140, -23411, 14299, -16636, 18463, -19498,  9719, -8985,  7396, -4812,   553,  1914, -5041,  8868, -6722,  9425, -12624, 16492, -2680,  3568, -5182, 10386, },
	{  3225, -7536, 14349, -23887,  8958, -12261, 15330, -17296,  4239, -3197,   761,  3525, -5045,  9627, -15579, 22832, -15569, 20016, -24402, 28248, -15479, 15919, -15070, 12552, -4008,   591,  4064, -9969,  8521, -12544, 16898, -21359, 12820, -14698, 16110, -16831,  8307, -7596,  6138, -3768,   144,  2290, -5635, 10292, -2140,  3551, -6575, 20814, },
	{   896, -3714,  9580, -19790,  8888, -14419, 21553, -29999,  9764, -11880, 13407, -13762,  6119, -4023,   190,  5749, -7035, 12445, -19056, 26673, -17467, 21645, -25500, 28574, -15166, 15097, -13780, 10932, -3154,  -135,  4444, -9757,  7993, -11483, 15223, -19046, 11368, -13019, 14323, -15101,  7567, -7069,  5847, -3545,   -74,  1075, -3653, 28432, },
	{  1853, -3438,  4476, -3765,  -106,  2575, -7098, 14320, -6195,  9696, -14055, 19102, -12240, 14804, -16840, 17826, -8574,  7064, -4043,  -799,  3850, -8387, 13984, -20507, 13848, -17577, 21170, -24289, 13269, -13739, 13323, -11793,  4468, -2286,  -717,  4578, -4649,  7422, -10571, 14042, -8886, 10844, -12868, 14947, -2140,  2445, -2868,  3865, },
	{  3287, -7111, 12356, -18530,  6120, -7055,  6708, -4125,  -460,  3105, -7201, 12983, -10282, 14935, -20283, 26005, -15797, 18181, -19719, 19901, -9088,  6990, -3402, -1881,  4487, -8936, 14209, -20136, 13225, -16391, 19328, -21754, 11675, -11881, 11314, -9788,  3560, -1566, -1175,  4756, -4643,  7465, -10982, 15467, -2691,  3842, -6074, 14188, },
	{  2713, -6821, 13816, -24338,  9652, -14035, 18848, -23377,  6628, -6686,  5546, -2667, -1257,  5260, -10877, 18200, -13580, 18740, -24313, 29891, -17461, 19357, -20232, 19646, -8577,  6168, -2421, -2780,  4737, -8797, 13477, -18615, 11990, -14633, 17047, -19010, 10134, -10268,  9745, -8382,  2976, -1074, -1751,  5923, -1544,  2934, -6089, 24019, },
	{  -516, -1131,  5578, -14375,  7298, -12886, 20607, -30459, 10517, -13637, 16602, -18871,  9866, -9164,  6850, -2435, -2264,  7193, -13650, 21591, -15404, 20449, -25622, 30505, -17287, 18609, -18882, 17756, -7447,  4997, -1410, -3383,  4696, -8276, 12359, -16829, 10761, -13115, 15350, -17313,  9410, -9822,  9735, -8895,   849,  -253, -1457, 29883, },
	{  2494, -5000,  7637, -9378,  2145,  -739, -2590,  8651, -4563,  8016, -12617, 18333, -12479, 16029, -19473, 22324, -11981, 11828, -10298,  6984,  -754, -3211,  8482, -15044, 11380, -15677, 20192, -24629, 14304, -15840, 16673, -16535,  7578, -6136,  3826,  -551, -1881,  4577, -7823, 11615, -7975, 10420, -13172, 16323, -2514,  3150, -4226,  7362, },
	{  3382, -7602, 13886, -22123,  7897, -10176, 11714, -11572,  2134,  -293, -3015,  8158, -7714, 12485, -18352, 25126, -16214, 19835, -23023, 25267, -12986, 12243, -10072,  6164,  -134, -3886,  8991, -15107, 11032, -14788, 18623, -22278, 12720, -13875, 14402, -14088,  6354, -5013,  2898,   128, -2114,  4819, -8366, 13108, -2477,  3813, -6553, 17930, },
	{  1846, -5385, 11997, -22702,  9570, -14738, 21003, -27864,  8601, -9808, 10118, -8948,  2818,   254, -5063, 11859, -10382, 15858, -22202, 29114, -18064, 21307, -23886, 25338, -12576, 11400, -8893,  4839,   459, -4223,  8854, -14267, 10151, -13361, 16605, -19682, 11176, -12168, 12654, -12445,  5655, -4471,  2440,   846,  -781,  2014, -4997, 26711, },
	{ -2104,  1874,   666, -7215,  4949, -10136, 17841, -28365, 10425, -14342, 18570, -22652, 12964, -13770, 13225, -10754,  2883,  1143, -6913, 14540, -11995, 17521, -23628, 29974, -18043, 20688, -22571, 23306, -11243,  9855, -7304,  3437,   926, -4304,  8402, -13167,  9251, -12134, 15141, -18164, 10538, -11866, 12982, -13781,  1762, -1690,  1286, 30537, },
	{  3012, -6323, 10481, -14724,  4407, -4250,  2464,  1869, -2443,  5563, -10038, 15984, -11684, 15971, -20597, 25152, -14530, 15794, -15933, 14468, -5456,  2405,  2100, -8166,  7897, -12425, 17520, -22947, 14188, -16694, 18740, -20041, 10144, -9581,  8173, -5770,  1117,  1277, -4352,  8157, -6377,  9120, -12398, 16404, -2698,  3640, -5374, 11090, },
	{  3157, -7458, 14345, -24121,  9141, -12663, 16072, -18522,  4705, -3860,  1649,  2403, -4376,  8879, -14805, 22116, -15298, 19904, -24538, 28730, -15944, 16658, -16124, 13951, -4884,  1633,  2881, -8691,  7868, -11924, 16365, -20980, 12745, -14777, 16385, -17342,  8699, -8141,  6848, -4651,   671,  1680, -4950,  9548, -2044,  3460, -6529, 21443, },
	{   652, -3274,  8917, -18931,  8654, -14229, 21515, -30272,  9964, -12279, 14081, -14792,  6850, -5000,  1425,  4267, -6193, 11548, -18170, 25895, -17192, 21557, -25682, 29111, -15656, 15845, -14817, 12273, -3974,   821,  3380, -8628,  7428, -10956, 14784, -18751, 11326, -13118, 14604, -15607,  7957, -7624,  6604, -4555,    95,   841, -3289, 28760, },
	{  1978, -3739,  5075, -4807,   304,  1985, -6317, 13369, -5934,  9447, -13878, 19080, -12360, 15124, -17432, 18771, -9259,  7993, -5230,   642,  3018, -7476, 13047, -19618, 13475, -17332, 21119, -24503, 13544, -14216, 14031, -12751,  5076, -3019,   126,  3650, -4162,  6938, -10125, 13678, -8771, 10833, -13005, 15294, -2222,  2590, -3131,  4491, },
	{  3327, -7246, 12712, -19301,  6483, -7670,  7669, -5519,    15,  2498, -6474, 12173, -9872, 14575, -20052, 26004, -15973, 18602, -20455, 21023, -9869,  8011, -4664,  -395,  3654, -8051, 13325, -19324, 12899, -16194, 19317, -21988, 11942, -12327, 11961, -10651,  4103, -2218,  -423,  3923, -4202,  7020, -10565, 15127, -2668,  3861, -6197, 14894, },
	{  2579, -6608, 13576, -24195,  9698, -14252, 19362, -24348,  7033, -7304,  6424, -3844,  -511,  4366, -9868, 17138, -13072, 18322, -24072, 29933, -17682, 19840, -21038, 20829, -9375,  7181, -3643, -1377,  3969, -7999, 12699, -17920, 11722, -14487, 17071, -19254, 10392, -10686, 10348, -9191,  3493, -1712,  -985,  5021, -1413,  2784, -5932, 24563, },
	{  -801,  -598,  4724, -13163,  6915, -12464, 20229, -30266, 10566, -13852, 17070, -19688, 10501, -10074,  8074, -3993, -1323,  6114, -12483, 20415, -14866, 20031, -25411, 30596, -17536, 19112, -19687, 18902, -8201,  5934, -2518, -2132,  4022, -7586, 11698, -16251, 10546, -13014, 15407, -17579,  9678, -10263, 10397, -9852,  1022,  -515,  -986, 30066, },
	{  2603, -5269,  8199, -10408,  2571, -1385, -1680,  7460, -4201,  7614, -12220, 18014, -12410, 16119, -19803, 22988, -12529, 12638, -11409,  8418, -1633, -2186,  7348, -13858, 10803, -15169, 19820, -24469, 14371, -16098, 17163, -17292,  8103, -6817,  4661, -1528, -1333,  3990, -7224, 11043, -7727, 10243, -13111, 16439, -2563,  3259, -4459,  8042, },
	{  3366, -7626, 14058, -22627,  8174, -10695, 12587, -12922,  2621,  -952, -2173,  7146, -7145, 11896, -17810, 24725, -16145, 19972, -23448, 26068, -13617, 13141, -11261,  7652, -1019, -2882,  7908, -14006, 10511, -14346, 18318, -22175, 12804, -14129, 14862, -14783,  6831, -5627,  3652,  -762, -1609,  4265, -7784, 12531, -2413,  3773, -6589, 18606, },
	{  1647, -5041, 11516, -22160,  9463, -14738, 21229, -28482,  8906, -10325, 10913, -10084,  3581,  -717, -3893, 10526, -9670, 15156, -21591, 28697, -18015, 21486, -24369, 26198, -13228, 12300, -10053,  6255,  -365, -3309,  7888, -13304,  9706, -12996, 16369, -19631, 11274, -12421, 13096, -13112,  6119, -5085,  3227,  -146,  -625,  1813, -4726, 27144, },
	{ -2409,  2462,  -322, -5726,  4439, -9500, 17132, -27692, 10310, -14346, 18780, -23176, 13445, -14534, 14336, -12261,  3849,   -33, -5553, 13050, -11229, 16798, -23029, 29598, -18023, 20897, -23072, 24157, -11868, 10695, -8365,  4711,   196, -3504,  7568, -12346,  8877, -11835, 14963, -18161, 10658, -12151, 13491, -14604,  1924, -1961,  1850, 30568, },
	{  3089, -6529, 10951, -15649,  4813, -4902,  3433,   524, -2006,  5033, -9443, 15380, -11422, 15812, -20625, 25467, -14889, 16414, -16872, 15777, -6310,  3463,   854, -6770,  7156, -11688, 16848, -22415, 14036, -16705, 18964, -20529, 10543, -10153,  8931, -6716,  1681,   634, -3647,  7419, -6012,  8786, -12135, 16270, -2709,  3703, -5555, 11797, },
	{  3077, -7354, 14298, -24288,  9301, -13034, 16777, -19709,  5163, -4519,  2541,  1264, -3688,  8099, -13983, 21331, -14980, 19735, -24605, 29133, -16366, 17354, -17139, 15319, -5751,  2677,  1683, -7382,  7190, -11266, 15783, -20540, 12634, -14815, 16615, -17807,  9069, -8666,  7543, -5525,  1200,  1060, -4245,  8770, -1941,  3358, -6462, 22058, },
	{   398, -2814,  8215, -18002,  8391, -13996, 21414, -30461, 10137, -12646, 14721, -15790,  7569, -5971,  2666,  2762, -5328, 10611, -17227, 25038, -16867, 21408, -25791, 29569, -16104, 16553, -15817, 13585, -4787,  1780,  2301, -7470,  6839, -10396, 14300, -18401, 11251, -13180, 14844, -16071,  8327, -8161,  7348, -5561,   266,   600, -2904, 29061, },
	{  2101, -4037,  5670, -5853,   718,  1382, -5507, 12368, -5652,  9169, -13659, 19002, -12447, 15402, -17980, 19670, -9923,  8905, -6410,  2091,  2172, -6539, 12068, -18668, 13061, -17037, 21009, -24650, 13783, -14656, 14702, -13678,  5672, -3746,   973,  2706, -3660,  6432, -9647, 13272, -8632, 10791, -13105, 15601, -2299,  2728, -3390,  5130, },
	{  3357, -7361, 13037, -20028,  6832, -8272,  8619, -6914,   494,  1878, -5721, 11321, -9429, 14170, -19762, 25929, -16105, 18972, -21139, 22091, -10628,  9015, -5921,  1100,  2807, -7138, 12399, -18453, 12534, -15950, 19251, -22160, 12178, -12740, 12576, -11488,  4637, -2868,   333,  3075, -3745,  6552, -10115, 14740, -2638,  3868, -6306, 15596, },
	{  2431, -6370, 13291, -23979,  9717, -14431, 19827, -25261,  7422, -7906,  7293, -5021,   243,  3452, -8822, 16019, -12522, 17849, -23762, 29890, -17854, 20270, -21789, 21958, -10151,  8180, -4860,    37,  3186, -7174, 11880, -17171, 11419, -14299, 17046, -19444, 10621, -11076, 10925, -9978,  4003, -2349,  -210,  4097, -1277,  2625, -5755, 25088, },
	{ -1092,   -51,  3840, -11893,  6506, -12000, 19787, -29982, 10585, -14030, 17492, -20456, 11111, -10963,  9285, -5552,  -372,  5011, -11274, 19173, -14282, 19555, -25126, 30601, -17736, 19564, -20441, 19999, -8936,  6859, -3625,  -869,  3333, -6872, 11000, -15623, 10301, -12875, 15420, -17797,  9921, -10677, 11035, -10791,  1194,  -780,  -497, 30222, },
	{  2706, -5529,  8748, -11425,  2996, -2037,  -754,  6233, -3824,  7186, -11784, 17640, -12305, 16163, -20079, 23591, -13045, 13418, -12495,  9838, -2513, -1149,  6185, -12625, 10191, -14615, 19390, -24238, 14398, -16312, 17606, -18004,  8609, -7482,  5487, -2506,  -779,  3389, -6603, 10437, -7456, 10036, -13011, 16510, -2606,  3360, -4684,  8730, },
	{  3338, -7627, 14192, -23073,  8431, -11191, 13435, -14251,  3105, -1616, -1317,  6104, -6550, 11267, -17212, 24250, -16030, 20052, -23809, 26801, -14213, 14006, -12425,  9127, -1907, -1865,  6798, -12858,  9957, -13861, 17959, -22008, 12852, -14345, 15282, -15439,  7291, -6229,  4400, -1653, -1096,  3696, -7176, 11914, -2341,  3720, -6607, 19273, },
	{  1437, -4674, 10993, -21545,  9327, -14695, 21397, -29024,  9188, -10818, 11684, -11201,  4341, -1694, -2702,  9152, -8925, 14407, -20915, 28196, -17914, 21605, -24786, 26989, -13846, 13169, -11190,  7660, -1192, -2381,  6895, -12298,  9232, -12592, 16085, -19524, 11340, -12640, 13503, -13744,  6568, -5688,  4011, -1148,  -465,  1604, -4433, 27554, },
	{  1552, -2715,  3056, -1326, -1049,  3908, -8829, 16365, -6733, 10164, -14309, 18939, -11819, 13891, -15263, 15414, -6872,  4811, -1218, -4167,  5756, -10427, 16023, -22361, 14568, -17952, 21048, -23510, 12471, -12461, 11509, -9408,  2989,  -538, -2691,  6708, -5743,  8477, -11501, 14741, -9054, 10749, -12404, 13966, -1924,  2084, -2232,  2430, },
	{  3157, -6721, 11398, -16544,  5212, -5549,  4406,  -839, -1558,  4483, -8815, 14727, -11125, 15607, -20594, 25712, -15207, 16991, -17770, 17048, -7152,  4517,  -401, -5347,  6391, -10913, 16124, -21816, 13843, -16668, 19136, -20961, 10913, -10699,  9666, -7648,  2243,   -15, -2928,  6656, -5628,  8425, -11835, 16088, -2713,  3756, -5724, 12505, },
	{  2984, -7226, 14208, -24387,  9436, -13372, 17442, -20854,  5611, -5172,  3434,   110, -2984,  7289, -13114, 20479, -14618, 19508, -24602, 29455, -16745, 18005, -18112, 16650, -6607,  3719,   474, -6045,  6488, -10573, 15154, -20040, 12486, -14811, 16799, -18223,  9415, -9170,  8220, -6389,  1729,   433, -3524,  7961, -1831,  3246, -6376, 22658, },
	{   136, -2336,  7475, -17004,  8100, -13719, 21251, -30564, 10283, -12980, 15325, -16751,  8271, -6932,  3909,  1238, -4442,  9637, -16229, 24104, -16491, 21196, -25828, 29946, -16508, 17217, -16777, 14865, -5591,  2738,  1210, -6285,  6227, -9803, 13774, -17998, 11144, -13206, 15044, -16493,  8675, -8679,  8077, -6562,   438,   353, -2499, 29337, },
	{  2221, -4329,  6261, -6901,  1138,   766, -4671, 11319, -5351,  8861, -13399, 18870, -12498, 15639, -18481, 20519, -10564,  9798, -7580,  3543,  1315, -5577, 11049, -17659, 12608, -16692, 20838, -24727, 13984, -15056, 15335, -14570,  6256, -4466,  1821,  1751, -3146,  5904, -9140, 12826, -8467, 10718, -13169, 15867, -2370,  2861, -3644,  5779, },
	{  3377, -7457, 13329, -20709,  7167, -8858,  9556, -8305,   978,  1246, -4944, 10428, -8956, 13721, -19413, 25780, -16191, 19291, -21767, 23104, -11361, 10000, -7168,  2602,  1946, -6200, 11432, -17525, 12132, -15660, 19130, -22269, 12379, -13119, 13159, -12296,  5161, -3512,  1093,  2214, -3276,  6062, -9633, 14309, -2599,  3865, -6399, 16295, },
	{  2272, -6107, 12960, -23689,  9707, -14570, 20240, -26112,  7794, -8493,  8149, -6195,  1003,  2521, -7743, 14846, -11933, 17321, -23381, 29762, -17977, 20645, -22483, 23032, -10903,  9160, -6070,  1458,  2389, -6325, 11025, -16369, 11082, -14070, 16973, -19580, 10821, -11436, 11473, -10742,  4505, -2984,   571,  3153, -1136,  2455, -5556, 25594, },
	{ -1388,   507,  2928, -10567,  6073, -11494, 19284, -29609, 10574, -14170, 17869, -21172, 11695, -11828, 10479, -7106,   588,  3885, -10024, 17869, -13654, 19020, -24768, 30519, -17887, 19963, -21140, 21045, -9649,  7769, -4726,   403,  2632, -6135, 10268, -14949, 10025, -12699, 15389, -17965, 10137, -11064, 11646, -11707,  1364, -1048,    11, 30349, },
	{  2804, -5778,  9282, -12427,  3419, -2692,   187,  4973, -3431,  6733, -11310, 17212, -12164, 16161, -20300, 24131, -13527, 14165, -13553, 11239, -3391,  -103,  4998, -11349,  9547, -14016, 18902, -23938, 14385, -16480, 18001, -18667,  9093, -8129,  6301, -3480,  -221,  2776, -5959,  9797, -7162,  9799, -12874, 16534, -2642,  3454, -4900,  9424, },
	{  3299, -7605, 14286, -23459,  8668, -11660, 14254, -15554,  3586, -2281,  -448,  5035, -5932, 10601, -16561, 23702, -15868, 20076, -24105, 27461, -14773, 14837, -13561, 10585, -2794,  -836,  5662, -11668,  9373, -13334, 17548, -21778, 12864, -14522, 15660, -16055,  7732, -6816,  5139, -2546,  -577,  3113, -6543, 11257, -2261,  3657, -6607, 19929, },
	{  1216, -4285, 10426, -20856,  9162, -14609, 21505, -29490,  9448, -11284, 12429, -12297,  5096, -2675, -1493,  7741, -8149, 13611, -20175, 27611, -17761, 21664, -25134, 27708, -14428, 14005, -12301,  9051, -2019, -1441,  5878, -11253,  8729, -12150, 15754, -19361, 11374, -12824, 13874, -14342,  7000, -6279,  4789, -2155,  -302,  1387, -4119, 27941, },
	{  1679, -3020,  3653, -2345,  -657,  3359, -8123, 15541, -6521,  9988, -14231, 19045, -12019, 14301, -15955, 16456, -7600,  5767, -2407, -2761,  4967, -9590, 15197, -21625, 14294, -17829, 21140, -23883, 12831, -13023, 12294, -10430,  3617, -1274, -1866,  5825, -5294,  8050, -11132, 14476, -9001, 10810, -12623, 14405, -2018,  2239, -2501,  3025, },
	{  3218, -6897, 11820, -17405,  5601, -6190,  5378, -2216, -1101,  3915, -8156, 14025, -10793, 15356, -20504, 25885, -15485, 17524, -18623, 18280, -7979,  5565, -1663, -3901,  5603, -10103, 15350, -21152, 13611, -16584, 19254, -21335, 11255, -11217, 10378, -8563,  2801,  -667, -2196,  5870, -5225,  8038, -11500, 15859, -2709,  3799, -5881, 13214, },
	{  2878, -7072, 14074, -24415,  9545, -13675, 18065, -21951,  6048, -5816,  4326, -1054, -2265,  6452, -12201, 19563, -14211, 19223, -24528, 29696, -17079, 18608, -19038, 17942, -7448,  4756,  -742, -4684,  5765, -9847, 14478, -19480, 12302, -14765, 16936, -18590,  9736, -9649,  8877, -7239,  2256,  -199, -2786,  7122, -1714,  3122, -6269, 23243, },
	{  -133, -1840,  6700, -15941,  7781, -13398, 21023, -30581, 10401, -13281, 15891, -17673,  8957, -7882,  5151,  -302, -3536,  8629, -15177, 23095, -16067, 20924, -25792, 30239, -16868, 17836, -17695, 16110, -6382,  3693,   110, -5077,  5595, -9180, 13206, -17541, 11005, -13193, 15202, -16869,  9001, -9176,  8788, -7553,   611,   101, -2074, 29585, },
	{  2339, -4616,  6846, -7947,  1561,   138, -3810, 10225, -5032,  8524, -13097, 18682, -12515, 15834, -18934, 21317, -11180, 10669, -8737,  4995,   448, -4594,  9992, -16595, 12117, -16298, 20607, -24734, 14145, -15415, 15928, -15425,  6824, -5177,  2668,   786, -2620,  5358, -8604, 12342, -8277, 10613, -13196, 16089, -2435,  2987, -3893,  6439, },
	{  3387, -7533, 13588, -21340,  7486, -9426, 10478, -9689,  1464,   604, -4145,  9497, -8452, 13229, -19006, 25556, -16232, 19557, -22337, 24058, -12066, 10962, -8402,  4104,  1076, -5240, 10428, -16543, 11693, -15324, 18954, -22316, 12547, -13462, 13708, -13074,  5673, -4150,  1854,  1341, -2794,  5551, -9119, 13833, -2553,  3851, -6475, 16988, },
	{  2101, -5820, 12585, -23325,  9669, -14669, 20599, -26897,  8147, -9061,  8990, -7361,  1766,  1575, -6634, 13621, -11305, 16740, -22932, 29548, -18049, 20963, -23116, 24046, -11627, 10120, -7269,  2883,  1582, -5453, 10133, -15517, 10712, -13799, 16851, -19661, 10991, -11766, 11992, -11479,  4997, -3615,  1357,  2192,  -990,  2276, -5335, 26079, },
	{ -1688,  1077,  1992, -9189,  5615, -10949, 18718, -29147, 10532, -14270, 18198, -21834, 12250, -12666, 11652, -8651,  1553,  2741, -8737, 16505, -12984, 18427, -24337, 30349, -17987, 20306, -21783, 22037, -10338,  8661, -5819,  1680,  1919, -5377,  9504, -14229,  9719, -12486, 15315, -18084, 10325, -11422, 12230, -12599,  1533, -1318,   536, 30448, },
	{  2896, -6016,  9800, -13410,  3838, -3349,  1140,  3684, -3024,  6256, -10799, 16731, -11986, 16113, -20464, 24607, -13975, 14877, -14579, 12618, -4265,   951,  3790, -10033,  8872, -13375, 18358, -23568, 14330, -16602, 18347, -19281,  9553, -8755,  7101, -4450,   342,  2151, -5295,  9127, -6846,  9533, -12699, 16512, -2671,  3538, -5107, 10123, },
	{  3247, -7560, 14340, -23782,  8883, -12103, 15043, -16827,  4062, -2947,   430,  3941, -5291,  9899, -15856, 23083, -15659, 20043, -24334, 28048, -15294, 15631, -14665, 12020, -3678,   201,  4504, -10439,  8758, -12767, 17085, -21485, 12839, -14658, 15995, -16627,  8154, -7387,  5868, -3436,   -54,  2517, -5887, 10562, -2175,  3582, -6587, 20575, },
	{   985, -3873,  9819, -20094,  8968, -14479, 21552, -29876,  9683, -11723, 13146, -13368,  5842, -3656,  -272,  6298, -7344, 12771, -19373, 26944, -17557, 21661, -25413, 28352, -14972, 14806, -13383, 10423, -2845,  -492,  4839, -10171,  8198, -11672, 15377, -19142, 11376, -12973, 14208, -14901,  7416, -6856,  5560, -3165,  -136,  1162, -3784, 28303, },
	{  1806, -3325,  4252, -3376,  -258,  2792, -7384, 14663, -6288,  9781, -14111, 19097, -12186, 14674, -16606, 17460, -8311,  6713, -3597, -1337,  4158, -8721, 14323, -20824, 13977, -17655, 21173, -24191, 13156, -13550, 13049, -11426,  4238, -2010, -1032,  4922, -4828,  7598, -10730, 14169, -8922, 10841, -12808, 14806, -2108,  2390, -2768,  3633, },
	{  3270, -7056, 12215, -18231,  5981, -6821,  6347, -3603,  -636,  3329, -7467, 13276, -10428, 15058, -20355, 25986, -15720, 18011, -19429, 19468, -8789,  6604, -2927, -2435,  4795, -9260, 14528, -20425, 13338, -16452, 19318, -21651, 11566, -11706, 11064, -9458,  3354, -1321, -1455,  5063, -4805,  7626, -11130, 15582, -2697,  3832, -6024, 13923, },
	{  2761, -6894, 13895, -24373,  9628, -13943, 18643, -22998,  6473, -6451,  5214, -2226, -1534,  5590, -11246, 18583, -13760, 18882, -24385, 29854, -17366, 19162, -19916, 19190, -8273,  5785, -1963, -3303,  5021, -9089, 13758, -18862, 12082, -14677, 17026, -18905, 10031, -10104,  9513, -8074,  2780,  -835, -2035,  6255, -1592,  2987, -6142, 23811, },
	{  -410, -1327,  5890, -14814,  7435, -13034, 20732, -30509, 10491, -13547, 16416, -18553,  9622, -8817,  6388, -1852, -2614,  7590, -14075, 22014, -15593, 20590, -25682, 30448, -17181, 18407, -18567, 17315, -7160,  4643,  -995, -3848,  4944, -8528, 12597, -17033, 10833, -13144, 15318, -17200,  9303, -9650,  9481, -8531,   784,  -156, -1629, 29807, },
	{  2453, -4897,  7423, -8989,  1986,  -498, -2927,  9088, -4694,  8160, -12755, 18438, -12495, 15984, -19335, 22060, -11768, 11517, -9876,  6443,  -425, -3591,  8900, -15477, 11588, -15855, 20317, -24671, 14268, -15732, 16478, -16240,  7375, -5877,  3512,  -186, -2084,  4793, -8040, 11820, -8062, 10479, -13186, 16267, -2493,  3107, -4136,  7108, },
	{  3386, -7587, 13811, -21920,  7788, -9976, 11381, -11062,  1951,   -47, -3327,  8530, -7921, 12696, -18541, 25257, -16227, 19769, -22847, 24950, -12741, 11899, -9620,  5603,   197, -4259,  9389, -15508, 11219, -14943, 18724, -22300, 12679, -13769, 14220, -13818,  6171, -4779,  2614,   460, -2302,  5022, -8577, 13314, -2499,  3826, -6535, 17674, },
	{  1917, -5508, 12165, -22886,  9602, -14727, 20903, -27613,  8481, -9608,  9814, -8517,  2531,   616, -5496, 12348, -10641, 16108, -22413, 29248, -18070, 21224, -23688, 24998, -12323, 11056, -8453,  4306,   767, -4562,  9209, -14616, 10310, -13488, 16681, -19687, 11132, -12064, 12480, -12187,  5478, -4239,  2144,  1216,  -839,  2087, -5093, 26543, },
	{ -1990,  1655,  1032, -7762,  5135, -10365, 18091, -28595, 10460, -14330, 18478, -22440, 12776, -13475, 12801, -10184,  2520,  1581, -7416, 15086, -12272, 17778, -23835, 30093, -18038, 20594, -22368, 22971, -11002,  9533, -6901,  2958,  1198, -4600,  8708, -13465,  9384, -12237, 15197, -18152, 10485, -11751, 12783, -13464,  1700, -1589,  1078, 30518, },
	{  2982, -6241, 10299, -14370,  4253, -4005,  2101,  2369, -2603,  5756, -10252, 16198, -11773, 16019, -20572, 25016, -14386, 15551, -15571, 13969, -5133,  2008,  2564, -8681,  8168, -12692, 17759, -23129, 14234, -16677, 18642, -19844,  9988, -9360,  7884, -5412,   906,  1517, -4612,  8427, -6509,  9238, -12487, 16443, -2692,  3614, -5303, 10826, },
	{  3184, -7490, 14351, -24041,  9075, -12516, 15798, -18067,  4531, -3612,  1316,  2826, -4629,  9163, -15101, 22393, -15405, 19953, -24495, 28558, -15774, 16386, -15733, 13430, -4557,  1242,  3327, -9174,  8116, -12161, 16571, -21129, 12778, -14752, 16287, -17156,  8555, -7939,  6584, -4321,   473,  1910, -5209,  9831, -2081,  3495, -6548, 21208, },
	{   744, -3441,  9170, -19261,  8745, -14306, 21537, -30180,  9892, -12133, 13832, -14410,  6578, -4634,   961,  4826, -6512, 11889, -18509, 26196, -17301, 21597, -25622, 28919, -15477, 15569, -14432, 11773, -3668,   462,  3781, -9055,  7642, -11158, 14954, -18868, 11345, -13085, 14503, -15422,  7813, -7418,  6321, -4176,    32,   930, -3427, 28640, },
	{  1932, -3627,  4850, -4415,   149,  2208, -6614, 13731, -6034,  9544, -13949, 19095, -12319, 15008, -17215, 18422, -9004,  7646, -4786,   100,  3332, -7821, 13404, -19958, 13620, -17430, 21145, -24431, 13445, -14041, 13770, -12395,  4849, -2744,  -191,  4000, -4347,  7122, -10296, 13819, -8817, 10841, -12958, 15169, -2192,  2536, -3032,  4255, },
	{  3313, -7197, 12582, -19017,  6348, -7441,  7310, -4996,  -164,  2728, -6750, 12482, -10029, 14715, -20146, 26013, -15912, 18450, -20185, 20608, -9579,  7630, -4191,  -954,  3968, -8386, 13661, -19636, 13026, -16273, 19327, -21907, 11846, -12164, 11722, -10330,  3900, -1974,  -706,  4237, -4369,  7190, -10725, 15260, -2677,  3855, -6153, 14629, },
	{  2631, -6691, 13671, -24257,  9684, -14175, 19175, -23991,  6883, -7074,  6096, -3403,  -792,  4704, -10251, 17543, -13267, 18485, -24171, 29927, -17605, 19665, -20742, 20391, -9078,  6803, -3185, -1905,  4259, -8301, 12995, -18187, 11827, -14547, 17068, -19169, 10298, -10532, 10125, -8890,  3300, -1472, -1273,  5362, -1463,  2842, -5993, 24361, },
	{  -694,  -800,  5048, -13624,  7062, -12627, 20378, -30349, 10551, -13776, 16900, -19387, 10266, -9735,  7616, -3409, -1678,  6522, -12926, 20864, -15073, 20195, -25498, 30572, -17448, 18930, -19391, 18478, -7921,  5584, -2103, -2602,  4276, -7848, 11950, -16473, 10631, -13056, 15390, -17485,  9581, -10100, 10151, -9495,   957,  -416, -1165, 30001, },
	{  2563, -5169,  7989, -10023,  2411, -1142, -2024,  7911, -4339,  7768, -12373, 18140, -12440, 16091, -19685, 22746, -12327, 12338, -10995,  7882, -1303, -2572,  7777, -14308, 11023, -15365, 19967, -24537, 14351, -16007, 16985, -17014,  7909, -6563,  4349, -1162, -1539,  4212, -7452, 11261, -7823, 10313, -13138, 16401, -2546,  3219, -4372,  7786, },
	{  3373, -7620, 13998, -22445,  8072, -10503, 12263, -12418,  2438,  -704, -2491,  7529, -7361, 12121, -18020, 24884, -16176, 19927, -23296, 25776, -13385, 12808, -10818,  7095,  -687, -3261,  8318, -14424, 10710, -14517, 18439, -22221, 12777, -14038, 14694, -14527,  6654, -5398,  3370,  -428, -1800,  4475, -8005, 12753, -2438,  3789, -6578, 18353, },
	{  1723, -5173, 11701, -22372,  9507, -14743, 21151, -28258,  8794, -10134, 10617, -9660,  3295,  -352, -4334, 11031, -9941, 15425, -21828, 28863, -18039, 21426, -24196, 25884, -12987, 11966, -9620,  5725,   -55, -3654,  8254, -13670,  9876, -13137, 16463, -19657, 11241, -12330, 12934, -12866,  5947, -4856,  2932,   227,  -684,  1890, -4830, 26984, },
	{ -2295,  2241,    51, -6289,  4633, -9743, 17404, -27954, 10357, -14349, 18707, -22987, 13269, -14252, 13923, -11699,  3487,   409, -6066, 13614, -11521, 17075, -23262, 29749, -18037, 20825, -22891, 23845, -11637, 10383, -7969,  4234,   470, -3806,  7884, -12659,  9021, -11951, 15035, -18168, 10616, -12048, 13304, -14299,  1864, -1860,  1637, 30560, },
	{  3061, -6453, 10777, -15305,  4662, -4658,  3069,  1031, -2171,  5234, -9670, 15613, -11524, 15877, -20622, 25357, -14759, 16186, -16525, 15290, -5991,  3066,  1323, -7297,  7437, -11969, 17106, -22622, 14098, -16706, 18886, -20352, 10396, -9942,  8649, -6363,  1470,   876, -3913,  7699, -6151,  8914, -12237, 16326, -2706,  3680, -5489, 11532, },
	{  3108, -7396, 14321, -24234,  9244, -12898, 16517, -19269,  4992, -4272,  2206,  1693, -3948,  8395, -14297, 21633, -15104, 19805, -24588, 28991, -16213, 17098, -16764, 14810, -5427,  2286,  2134, -7876,  7447, -11517, 16007, -20712, 12680, -14806, 16534, -17638,  8933, -8472,  7284, -5199,  1002,  1293, -4512,  9066, -1980,  3398, -6490, 21829, },
	{   494, -2989,  8483, -18358,  8493, -14089, 21460, -30400, 10075, -12512, 14485, -15420,  7301, -5608,  2200,  3329, -5655, 10967, -17588, 25368, -16995, 21471, -25759, 29407, -15941, 16292, -15446, 13096, -4483,  1420,  2707, -7908,  7062, -10610, 14487, -18539, 11283, -13161, 14759, -15902,  8190, -7962,  7070, -5185,   202,   691, -3051, 28951, },
	{  2055, -3926,  5447, -5460,   562,  1610, -5814, 12749, -5760,  9276, -13746, 19038, -12418, 15303, -17780, 19338, -9677,  8565, -5969,  1547,  2491, -6894, 12440, -19031, 13221, -17154, 21057, -24603, 13698, -14495, 14455, -13334,  5450, -3474,   655,  3062, -3850,  6624, -9830, 13429, -8687, 10810, -13072, 15491, -2271,  2677, -3293,  4889, },
	{  3347, -7320, 12919, -19761,  6703, -8048,  8264, -6391,   314,  2112, -6006, 11645, -9599, 14327, -19878, 25966, -16061, 18839, -20889, 21697, -10346,  8640, -5450,   539,  3126, -7484, 12751, -18787, 12675, -16047, 19282, -22102, 12093, -12589, 12349, -11177,  4438, -2625,    49,  3395, -3918,  6730, -10287, 14891, -2650,  3867, -6267, 15333, },
	{  2488, -6462, 13403, -24069,  9713, -14368, 19659, -24926,  7278, -7682,  6969, -4580,   -41,  3797, -9219, 16445, -12733, 18032, -23886, 29916, -17795, 20115, -21514, 21541, -9863,  7807, -4404,  -495,  3481, -7486, 12192, -17458, 11536, -14374, 17061, -19379, 10538, -10933, 10712, -9686,  3813, -2110,  -501,  4446, -1329,  2686, -5824, 24894, },
	{  -983,  -258,  4175, -12376,  6663, -12179, 19960, -30099, 10581, -13968, 17339, -20174, 10885, -10632,  8833, -4967,  -730,  5427, -11732, 19646, -14506, 19740, -25241, 30609, -17666, 19401, -20164, 19593, -8663,  6514, -3210, -1343,  3593, -7143, 11266, -15864, 10397, -12932, 15420, -17721,  9833, -10525, 10799, -10441,  1129,  -681,  -683, 30167, },
	{  2668, -5432,  8544, -11045,  2837, -1792, -1103,  6697, -3967,  7350, -11952, 17787, -12348, 16152, -19982, 23372, -12855, 13129, -12091,  9307, -2183, -1539,  6624, -13092, 10424, -14828, 19558, -24333, 14393, -16237, 17445, -17742,  8422, -7235,  5178, -2139,  -988,  3616, -6838, 10668, -7560, 10117, -13053, 16489, -2591,  3323, -4600,  8471, },
	{  3350, -7630, 14146, -22913,  8337, -11008, 13120, -13755,  2924, -1367, -1640,  6498, -6776, 11507, -17443, 24436, -16078, 20029, -23681, 26534, -13994, 13686, -11992,  8576, -1574, -2248,  7217, -13294, 10169, -14048, 18100, -22078, 12838, -14269, 15129, -15198,  7120, -6005,  4120, -1319, -1290,  3911, -7407, 12150, -2369,  3741, -6602, 19024, },
	{  1517, -4815, 11194, -21784,  9382, -14716, 21341, -28830,  9085, -10636, 11398, -10785,  4057, -1327, -3150,  9671, -9208, 14694, -21176, 28394, -17958, 21568, -24637, 26701, -13618, 12847, -10766,  7135,  -881, -2730,  7271, -12680,  9413, -12748, 16197, -19570, 11319, -12562, 13355, -13511,  6401, -5463,  3717,  -771,  -526,  1683, -4545, 27403, },
	{  1504, -2600,  2833,  -948, -1194,  4110, -9085, 16659, -6807, 10223, -14328, 18886, -11736, 13728, -14994, 15013, -6596,  4451,  -773, -4689,  6047, -10732, 16319, -22620, 14659, -17985, 20998, -23353, 12328, -12242, 11207, -9019,  2752,  -263, -2997,  7034, -5906,  8630, -11630, 14829, -9067, 10719, -12313, 13792, -1888,  2024, -2130,  2211, },
	{  3132, -6651, 11233, -16212,  5063, -5307,  4041,  -326, -1727,  4691, -9055, 14978, -11240, 15690, -20613, 25629, -15093, 16780, -17438, 16576, -6838,  4122,    71, -5884,  6681, -11208, 16401, -22048, 13920, -16687, 19078, -20805, 10778, -10498,  9393, -7301,  2032,   229, -3199,  6945, -5774,  8564, -11952, 16162, -2713,  3737, -5663, 12240, },
	{  3020, -7277, 14247, -24358,  9388, -13249, 17197, -20430,  5444, -4928,  3099,   544, -3250,  7596, -13445, 20807, -14759, 19600, -24611, 29344, -16608, 17766, -17752, 16155, -6287,  3329,   929, -6549,  6754, -10837, 15395, -20234, 12546, -14818, 16736, -18073,  9288, -8984,  7968, -6066,  1531,   669, -3796,  8268, -1873,  3289, -6411, 22435, },
	{   236, -2517,  7757, -17386,  8212, -13828, 21319, -30536, 10232, -12859, 15103, -16395,  8010, -6573,  3443,  1811, -4777, 10007, -16609, 24463, -16638, 21283, -25823, 29814, -16361, 16973, -16422, 14389, -5291,  2379,  1620, -6733,  6459, -10029, 13976, -18155, 11188, -13200, 14974, -16340,  8547, -8487,  7805, -6188,   373,   446, -2653, 29237, },
	{  2177, -4220,  6040, -6508,   980,   998, -4988, 11718, -5466,  8980, -13501, 18926, -12483, 15555, -18299, 20207, -10327,  9465, -7143,  2998,  1638, -5941, 11435, -18044, 12783, -16828, 20909, -24706, 13913, -14910, 15103, -14239,  6039, -4197,  1503,  2111, -3340,  6104, -9333, 12998, -8531, 10749, -13150, 15772, -2344,  2812, -3549,  5535, },
	{  3371, -7424, 13224, -20459,  7043, -8640,  9206, -7784,   796,  1484, -5238, 10767, -9137, 13895, -19551, 25845, -16164, 19177, -21538, 22731, -11089,  9633, -6702,  2038,  2270, -6555, 11799, -17880, 12287, -15774, 19182, -22235, 12308, -12981, 12945, -11997,  4966, -3271,   808,  2538, -3453,  6248, -9817, 14476, -2614,  3868, -6366, 16033, },
	{  2333, -6209, 13089, -23807,  9714, -14522, 20091, -25800,  7656, -8275,  7830, -5755,   717,  2872, -8152, 15292, -12158, 17525, -23532, 29820, -17937, 20511, -22230, 22636, -10624,  8795, -5617,   924,  2689, -6646, 11350, -16676, 11212, -14160, 17006, -19536, 10749, -11305, 11271, -10458,  4318, -2746,   278,  3510, -1189,  2520, -5633, 25407, },
	{ -1277,   297,  3273, -11071,  6238, -11689, 19480, -29760, 10582, -14122, 17733, -20910, 11479, -11506, 10033, -6524,   227,  4310, -10497, 18365, -13895, 19227, -24911, 30560, -17836, 19819, -20884, 20659, -9384,  7430, -4314,   -75,  2896, -6414, 10547, -15207, 10132, -12770, 15406, -17908, 10059, -10922, 11420, -11366,  1300,  -948,  -182, 30305, },
	{  2768, -5686,  9084, -12053,  3260, -2446,  -167,  5449, -3580,  6906, -11492, 17379, -12221, 16167, -20223, 23936, -13350, 13888, -13159, 10716, -3062,  -496,  5446, -11832,  9792, -14246, 19092, -24059, 14395, -16422, 17858, -18424,  8914, -7888,  5997, -3115,  -431,  3007, -6203, 10041, -7275,  9891, -12930, 16531, -2629,  3420, -4820,  9163, },
	{  3315, -7616, 14255, -23322,  8582, -11487, 13950, -15068,  3406, -2032,  -775,  5439, -6166, 10855, -16811, 23916, -15934, 20074, -24002, 27222, -14567, 14530, -13138, 10040, -2462, -1223,  6090, -12119,  9595, -13537, 17708, -21872, 12864, -14460, 15523, -15829,  7569, -6598,  4863, -2211,  -773,  3333, -6783, 11508, -2292,  3682, -6609, 19684, },
	{  1300, -4433, 10644, -21123,  9228, -14646, 21471, -29325,  9353, -11113, 12153, -11889,  4814, -2307, -1948,  8274, -8443, 13915, -20460, 27840, -17824, 21649, -25012, 27447, -14214, 13695, -11887,  8531, -1709, -1794,  6262, -11650,  8921, -12320, 15883, -19428, 11365, -12759, 13740, -14122,  6840, -6059,  4498, -1777,  -364,  1469, -4239, 27799, },
	{  1632, -2906,  3429, -1962,  -805,  3567, -8391, 15857, -6603, 10058, -14265, 19011, -11948, 14152, -15700, 16070, -7329,  5409, -1961, -3290,  5265, -9908, 15512, -21909, 14401, -17881, 21113, -23751, 12700, -12816, 12003, -10049,  3382,  -998, -2176,  6159, -5464,  8213, -11274, 14580, -9024, 10791, -12545, 14245, -1984,  2181, -2400,  2800, },
	{  3196, -6833, 11665, -17086,  5456, -5950,  5013, -1698, -1274,  4130, -8407, 14293, -10922, 15456, -20545, 25829, -15386, 17329, -18309, 17823, -7671,  5173, -1189, -4446,  5901, -10411, 15646, -21409, 13703, -16621, 19216, -21202, 11130, -11026, 10114, -8222,  2592,  -423, -2472,  6168, -5378,  8187, -11630, 15950, -2711,  3784, -5824, 12948, },
	{  2919, -7133, 14129, -24413,  9507, -13565, 17836, -21545,  5886, -5576,  3992,  -616, -2537,  6769, -12549, 19914, -14368, 19337, -24564, 29615, -16959, 18387, -18696, 17463, -7134,  4368,  -285, -5197,  6038, -10123, 14737, -19697, 12375, -14787, 16890, -18458,  9618, -9472,  8633, -6922,  2059,    39, -3064,  7440, -1759,  3169, -6312, 23025, },
	{   -31, -2028,  6995, -16347,  7904, -13523, 21116, -30585, 10360, -13172, 15683, -17332,  8702, -7528,  4686,   277, -3878,  9011, -15577, 23482, -16232, 21033, -25814, 30139, -16738, 17609, -17356, 15648, -6087,  3336,   523, -5533,  5834, -9417, 13424, -17718, 11061, -13202, 15148, -16733,  8881, -8992,  8524, -7182,   546,   196, -2236, 29495, },
	{  2295, -4510,  6628, -7555,  1402,   375, -4136, 10640, -5154,  8654, -13215, 18759, -12513, 15766, -18770, 21024, -10952, 10345, -8305,  4451,   774, -4965, 10392, -17000, 12305, -16452, 20701, -24739, 14089, -15285, 15711, -15109,  6613, -4912,  2351,  1149, -2818,  5565, -8808, 12528, -8351, 10656, -13190, 16011, -2411,  2941, -3801,  6191, },
	{  3384, -7507, 13495, -21110,  7368, -9215, 10134, -9171,  1282,   846, -4447,  9850, -8645, 13419, -19166, 25648, -16222, 19464, -22130, 23708, -11805, 10604, -7941,  3541,  1403, -5602, 10809, -16918, 11862, -15455, 19026, -22306, 12488, -13338, 13506, -12786,  5482, -3912,  1569,  1669, -2976,  5745, -9315, 14017, -2571,  3858, -6448, 16729, },
	{  2166, -5931, 12731, -23470,  9687, -14637, 20471, -26610,  8017, -8850,  8677, -6925,  1479,  1931, -7053, 14086, -11545, 16964, -23108, 29638, -18028, 20851, -22886, 23673, -11359,  9763, -6821,  2348,  1886, -5783, 10472, -15842, 10855, -13905, 16903, -19637, 10931, -11646, 11801, -11206,  4814, -3379,  1062,  2554, -1045,  2344, -5420, 25899, },
	{ -1575,   862,  2346, -9712,  5790, -11158, 18937, -29331, 10551, -14237, 18080, -21593, 12046, -12355, 11215, -8073,  1190,  3172, -9223, 17023, -13240, 18656, -24507, 30423, -17956, 20184, -21549, 21672, -10083,  8329, -5410,  1201,  2188, -5663,  9794, -14504,  9837, -12570, 15348, -18045, 10258, -11291, 12014, -12268,  1470, -1217,   337, 30414, },
	{  2862, -5928,  9608, -13043,  3681, -3102,   781,  4171, -3178,  6438, -10995, 16918, -12057, 16137, -20409, 24436, -13811, 14614, -14198, 12104, -3938,   555,  4245, -10531,  9129, -13620, 18569, -23715, 14355, -16561, 18223, -19057,  9383, -8523,  6802, -4087,   130,  2386, -5546,  9382, -6967,  9636, -12769, 16526, -2661,  3507, -5031,  9860, },
	{  3268, -7580, 14324, -23669,  8805, -11940, 14751, -16353,  3884, -2698,   100,  4354, -5534, 10167, -16126, 23323, -15743, 20062, -24256, 27837, -15103, 15338, -14255, 11485, -3347,  -189,  4940, -10905,  8992, -12985, 17264, -21602, 12853, -14611, 15875, -16418,  7998, -7175,  5596, -3102,  -251,  2742, -6136, 10827, -2208,  3611, -6597, 20334, },
	{  1073, -4030, 10051, -20388,  9044, -14533, 21541, -29740,  9597, -11562, 12881, -12969,  5563, -3288,  -731,  6843, -7649, 13091, -19681, 27204, -17639, 21670, -25317, 28119, -14773, 14510, -12981,  9911, -2536,  -849,  5231, -10581,  8400, -11855, 15524, -19230, 11379, -12921, 14087, -14696,  7262, -6641,  5272, -2786,  -199,  1247, -3912, 28170, },
	{  1759, -3211,  4027, -2988,  -408,  3006, -7664, 14999, -6378,  9862, -14161, 19084, -12127, 14539, -16367, 17088, -8047,  6359, -3151, -1872,  4463, -9050, 14656, -21132, 14101, -17727, 21168, -24083, 13038, -13356, 12770, -11056,  4006, -1735, -1345,  5263, -5005,  7770, -10885, 14289, -8954, 10833, -12743, 14660, -2075,  2334, -2668,  3404, },
	{  3251, -6998, 12070, -17926,  5840, -6585,  5984, -3082,  -812,  3550, -7729, 13562, -10569, 15175, -20418, 25957, -15637, 17834, -19133, 19028, -8488,  6215, -2453, -2987,  5100, -9580, 14842, -20705, 13445, -16507, 19300, -21540, 11453, -11526, 10810, -9125,  3147, -1076, -1734,  5368, -4964,  7784, -11273, 15691, -2702,  3821, -5972, 13657, },
	{  2806, -6964, 13967, -24397,  9600, -13847, 18432, -22611,  6315, -6214,  4882, -1786, -1810,  5916, -11609, 18958, -13934, 19017, -24447, 29804, -17263, 18960, -19592, 18728, -7965,  5400, -1505, -3823,  5302, -9377, 14033, -19100, 12169, -14715, 16998, -18793,  9923, -9936,  9277, -7763,  2584,  -596, -2318,  6583, -1638,  3039, -6192, 23600, },
	{  -306, -1521,  6197, -15244,  7568, -13175, 20849, -30546, 10461, -13451, 16224, -18228,  9375, -8469,  5925, -1270, -2962,  7983, -14494, 22428, -15776, 20722, -25732, 30380, -17069, 18199, -18246, 16868, -6870,  4288,  -580, -4311,  5191, -8776, 12830, -17229, 10901, -13167, 15279, -17082,  9192, -9475,  9223, -8166,   719,   -59, -1798, 29727, },
	{  2411, -4792,  7208, -8599,  1826,  -258, -3261,  9519, -4823,  8300, -12888, 18536, -12507, 15933, -19191, 21788, -11551, 11202, -9451,  5901,   -97, -3969,  9313, -15902, 11791, -16027, 20433, -24702, 14227, -15618, 16277, -15939,  7171, -5616,  3196,   179, -2286,  5007, -8255, 12020, -8145, 10533, -13194, 16205, -2472,  3063, -4046,  6856, },
	{  3387, -7569, 13732, -21709,  7677, -9772, 11045, -10549,  1769,   198, -3636,  8896, -8123, 12901, -18722, 25378, -16235, 19696, -22663, 24623, -12492, 11551, -9166,  5042,   527, -4629,  9783, -15902, 11401, -15091, 18816, -22314, 12634, -13658, 14032, -13543,  5986, -4544,  2329,   791, -2487,  5223, -8783, 13514, -2520,  3837, -6515, 17418, },
	{  1987, -5628, 12328, -23059,  9631, -14710, 20796, -27353,  8358, -9406,  9507, -8085,  2244,   977, -5926, 12831, -10894, 16351, -22616, 29370, -18068, 21133, -23481, 24648, -12065, 10708, -8011,  3773,  1073, -4899,  9559, -14959, 10464, -13609, 16751, -19684, 11083, -11956, 12300, -11925,  5299, -4006,  1849,  1583,  -896,  2159, -5187, 26371, },
	{ -1876,  1437,  1394, -8303,  5318, -10589, 18333, -28812, 10491, -14312, 18379, -22220, 12582, -13175, 12373, -9611,  2157,  2018, -7915, 15624, -12543, 18028, -24032, 30199, -18025, 20493, -22155, 22628, -10756,  9209, -6497,  2479,  1469, -4893,  9010, -13756,  9513, -12334, 15246, -18132, 10428, -11631, 12579, -13143,  1638, -1487,   873, 30495, },
	{  2951, -6158, 10114, -14013,  4098, -3759,  1740,  2865, -2763,  5946, -10461, 16404, -11857, 16059, -20538, 24871, -14236, 15303, -15203, 13466, -4808,  1612,  3025, -9192,  8435, -12953, 17990, -23302, 14275, -16655, 18537, -19639,  9827, -9136,  7592, -5052,   694,  1756, -4870,  8693, -6638,  9352, -12571, 16474, -2685,  3587, -5231, 10562, },
	{  3209, -7519, 14352, -23952,  9006, -12364, 15519, -17606,  4356, -3363,   983,  3247, -4879,  9443, -15390, 22660, -15506, 19994, -24443, 28376, -15599, 16108, -15337, 12905, -4228,   851,  3770, -9653,  8360, -12393, 16769, -21270, 12805, -14722, 16183, -16963,  8407, -7734,  6317, -3990,   275,  2139, -5466, 10109, -2117,  3529, -6565, 20972, },
	{   836, -3606,  9418, -19582,  8832, -14376, 21550, -30075,  9817, -11983, 13579, -14022,  6303, -4268,   498,  5381, -6827, 12225, -18840, 26486, -17403, 21628, -25552, 28716, -15292, 15288, -14043, 11270, -3360,   104,  4180, -9478,  7854, -11355, 15118, -18977, 11361, -13047, 14397, -15232,  7666, -7209,  6037, -3797,   -31,  1017, -3563, 28516, },
	{  1885, -3514,  4626, -4025,    -4,  2429, -6906, 14087, -6132,  9636, -14015, 19102, -12273, 14888, -16992, 18066, -8747,  7298, -4341,  -440,  3643, -8162, 13754, -20290, 13759, -17520, 21163, -24349, 13341, -13861, 13503, -12035,  4621, -2469,  -507,  4347, -4529,  7303, -10462, 13955, -8860, 10844, -12906, 15037, -2161,  2482, -2934,  4020, },
	{  3298, -7147, 12448, -18727,  6212, -7210,  6949, -4473,  -342,  2955, -7022, 12785, -10183, 14849, -20231, 26011, -15845, 18291, -19908, 20186, -9285,  7247, -3717, -1511,  4280, -8717, 13992, -19939, 13147, -16346, 19330, -21818, 11745, -11996, 11478, -10006,  3696, -1729,  -988,  4549, -4534,  7356, -10881, 15386, -2686,  3848, -6106, 14365, },
	{  2681, -6770, 13760, -24309,  9666, -14092, 18981, -23625,  6731, -6842,  5766, -2961, -1071,  5038, -10628, 17940, -13457, 18641, -24259, 29910, -17521, 19483, -20438, 19947, -8779,  6423, -2727, -2431,  4546, -8600, 13286, -18447, 11926, -14600, 17058, -19076, 10201, -10375,  9898, -8586,  3106, -1233, -1560,  5700, -1512,  2897, -6051, 24157, },
	{  -587,  -999,  5367, -14077,  7205, -12785, 20518, -30419, 10532, -13694, 16723, -19080, 10027, -9393,  7157, -2825, -2030,  6925, -13362, 21303, -15274, 20350, -25576, 30535, -17354, 18740, -19088, 18047, -7637,  5232, -1687, -3071,  4529, -8106, 12197, -16689, 10710, -13094, 15368, -17384,  9480, -9935,  9902, -9136,   892,  -318, -1341, 29931, },
	{  2522, -5068,  7778, -9636,  2252,  -900, -2365,  8357, -4474,  7918, -12521, 18258, -12465, 16056, -19560, 22495, -12121, 12033, -10578,  7343,  -974, -2956,  8201, -14752, 11239, -15554, 20105, -24595, 14324, -15909, 16800, -16729,  7711, -6308,  4036,  -795, -1744,  4432, -7675, 11475, -7915, 10379, -13161, 16356, -2527,  3178, -4285,  7531, },
	{  3379, -7610, 13932, -22255,  7968, -10308, 11935, -11912,  2256,  -457, -2806,  7908, -7574, 12341, -18222, 25032, -16201, 19874, -23135, 25474, -13147, 12470, -10371,  6537,  -355, -3637,  8723, -14836, 10905, -14682, 18552, -22258, 12745, -13942, 14521, -14265,  6474, -5167,  3087,   -94, -1989,  4682, -8223, 12968, -2462,  3804, -6564, 18100, },
	{  1797, -5302, 11881, -22574,  9546, -14742, 21065, -28025,  8679, -9940, 10319, -9233,  3009,    12, -4773, 11530, -10207, 15687, -22055, 29017, -18057, 21357, -24013, 25559, -12742, 11628, -9185,  5194,   253, -3996,  8616, -14030, 10043, -13274, 16550, -19674, 11203, -12234, 12768, -12615,  5773, -4626,  2637,   599,  -743,  1965, -4931, 26821, },
	{ -2180,  2020,   421, -6847,  4824, -9981, 17669, -28205, 10399, -14347, 18627, -22789, 13088, -13964, 13506, -11133,  3125,   850, -6576, 14172, -11807, 17345, -23485, 29888, -18043, 20746, -22702, 23525, -11402, 10067, -7571,  3756,   744, -4105,  8196, -12966,  9160, -12062, 15101, -18168, 10571, -11940, 13113, -13990,  1803, -1758,  1426, 30548, },
	{  3032, -6376, 10600, -14958,  4509, -4414,  2706,  1535, -2334,  5432, -9892, 15838, -11622, 15936, -20610, 25238, -14624, 15953, -16172, 14799, -5671,  2670,  1789, -7820,  7714, -12244, 17357, -22820, 14154, -16701, 18801, -20168, 10246, -9727,  8365, -6008,  1258,  1117, -4177,  7975, -6288,  9039, -12335, 16375, -2702,  3657, -5421, 11267, },
	{  3138, -7434, 14337, -24169,  9183, -12759, 16252, -18823,  4820, -4025,  1872,  2120, -4206,  8687, -14604, 21926, -15222, 19867, -24561, 28838, -16054, 16836, -16382, 14296, -5102,  1894,  2583, -8367,  7701, -11763, 16224, -20876, 12721, -14791, 16447, -17463,  8794, -8275,  7023, -4870,   804,  1525, -4776,  9357, -2019,  3436, -6514, 21598, },
	{   589, -3161,  8745, -18705,  8591, -14175, 21496, -30328, 10010, -12374, 14244, -15045,  7031, -5243,  1735,  3893, -5979, 11317, -17940, 25688, -17115, 21526, -25716, 29233, -15772, 16026, -15070, 12603, -4178,  1061,  3111, -8342,  7283, -10819, 14667, -18668, 11310, -13137, 14668, -15727,  8051, -7760,  6791, -4807,   138,   781, -3194, 28837, },
	{  2009, -3814,  5224, -5068,   407,  1836, -6117, 13123, -5865,  9380, -13827, 19066, -12385, 15197, -17574, 19000, -9427,  8222, -5526,  1004,  2808, -7245, 12806, -19386, 13375, -17263, 21097, -24546, 13608, -14330, 14202, -12986,  5226, -3201,   338,  3415, -4038,  6813, -10008, 13580, -8739, 10825, -13033, 15375, -2242,  2625, -3196,  4650, },
	{  3335, -7276, 12796, -19487,  6571, -7822,  7907, -5868,   134,  2344, -6288, 11964, -9764, 14478, -19985, 25992, -16010, 18699, -20631, 21295, -10061,  8263, -4979,   -22,  3444, -7825, 13097, -19112, 12811, -16138, 19306, -22036, 12004, -12434, 12118, -10863,  4237, -2381,  -235,  3713, -4089,  6905, -10456, 15034, -2661,  3864, -6226, 15070, },
	{  2543, -6551, 13509, -24148,  9706, -14300, 19483, -24582,  7132, -7456,  6642, -4139,  -323,  4139, -9610, 16864, -12938, 18209, -24001, 29930, -17730, 19953, -21231, 21116, -9571,  7432, -3947, -1025,  3774, -7795, 12498, -17738, 11649, -14444, 17069, -19307, 10452, -10786, 10495, -9390,  3621, -1871,  -792,  4792, -1380,  2745, -5890, 24696, },
	{  -874,  -463,  4505, -12851,  6815, -12352, 20124, -30203, 10573, -13900, 17180, -19885, 10656, -10298,  8378, -4383, -1086,  5841, -12185, 20110, -14724, 19918, -25346, 30605, -17590, 19230, -19881, 19181, -8387,  6167, -2795, -1817,  3851, -7410, 11527, -16098, 10488, -12983, 15414, -17638,  9741, -10369, 10559, -10089,  1065,  -581,  -866, 30108, },
	{  2629, -5335,  8337, -10663,  2677, -1548, -1450,  7156, -4108,  7510, -12115, 17926, -12387, 16134, -19877, 23144, -12661, 12836, -11683,  8774, -1853, -1928,  7059, -13554, 10653, -15034, 19718, -24418, 14382, -16156, 17278, -17474,  8232, -6985,  4869, -1773, -1195,  3841, -7071, 10895, -7662, 10194, -13089, 16461, -2575,  3285, -4516,  8213, },
	{  3360, -7628, 14095, -22744,  8240, -10821, 12801, -13257,  2742, -1118, -1960,  6888, -6999, 11742, -17666, 24613, -16120, 19997, -23544, 26258, -13770, 13360, -11554,  8022, -1241, -2629,  7633, -13723, 10375, -14229, 18233, -22139, 12820, -14187, 14971, -14951,  6947, -5779,  3840,  -984, -1482,  4125, -7634, 12381, -2395,  3761, -6595, 18773, },
	{  1595, -4952, 11389, -22013,  9432, -14731, 21277, -28624,  8979, -10451, 11108, -10365,  3772,  -961, -3597, 10186, -9487, 14974, -21428, 28580, -17994, 21522, -24480, 26403, -13385, 12520, -10339,  6607,  -571, -3078,  7643, -13056,  9590, -12898, 16302, -19609, 11293, -12479, 13201, -13273,  6232, -5237,  3423,  -396,  -585,  1762, -4655, 27249, },
	{ -2485,  2610,  -571, -5347,  4308, -9336, 16945, -27509, 10277, -14341, 18825, -23297, 13560, -14720, 14608, -12635,  4090,  -329, -5208, 12670, -11032, 16609, -22869, 29490, -18010, 20940, -23187, 24359, -12019, 10901, -8628,  5028,    13, -3302,  7355, -12134,  8780, -11754, 14911, -18153, 10684, -12217, 13613, -14805,  1965, -2029,  1994, 30571, },
	{  3107, -6579, 11065, -15875,  4914, -5065,  3676,   185, -1895,  4897, -9289, 15222, -11351, 15766, -20623, 25535, -14972, 16562, -17101, 16098, -6522,  3727,   541, -6417,  6967, -11497, 16671, -22271, 13992, -16700, 19012, -20642, 10638, -10292,  9117, -6951,  1822,   472, -3468,  7231, -5918,  8698, -12063, 16229, -2711,  3717, -5599, 11974, },
	{  3054, -7324, 14280, -24319,  9337, -13121, 16947, -20000,  5276, -4683,  2764,   977, -3514,  7899, -13770, 21124, -14894, 19683, -24610, 29221, -16465, 17521, -17387, 15655, -5966,  2938,  1382, -7050,  7017, -11096, 15630, -20421, 12600, -14818, 16665, -17916,  9158, -8794,  7714, -5742,  1333,   904, -4067,  8571, -1914,  3331, -6443, 22209, },
	{   334, -2696,  8033, -17759,  8321, -13931, 21379, -30495, 10176, -12733, 14876, -16034,  7746, -6212,  2977,  2383, -5109, 10371, -16983, 24811, -16777, 21361, -25807, 29671, -16209, 16723, -16061, 13908, -4989,  2020,  2029, -7176,  6688, -10251, 14173, -18305, 11227, -13190, 14898, -16181,  8416, -8293,  7531, -5812,   309,   539, -2805, 29133, },
	{  2131, -4110,  5819, -6115,   823,  1229, -5301, 12110, -5579,  9094, -13598, 18974, -12463, 15465, -18110, 19887, -10086,  9130, -6704,  2454,  1959, -6301, 11817, -18421, 12952, -16956, 20972, -24675, 13837, -14759, 14864, -13904,  5820, -3927,  1185,  2469, -3533,  6302, -9523, 13164, -8593, 10775, -13125, 15672, -2317,  2762, -3454,  5291, },
	{  3363, -7387, 13113, -20203,  6917, -8420,  8854, -7262,   615,  1721, -5529, 11101, -9314, 14062, -19681, 25899, -16131, 19057, -21301, 22350, -10813,  9263, -6234,  1475,  2593, -6906, 12161, -18227, 12437, -15882, 19226, -22193, 12231, -12838, 12725, -11693,  4769, -3029,   523,  2861, -3629,  6431, -9997, 14637, -2629,  3869, -6330, 15771, },
	{  2393, -6307, 13212, -23914,  9717, -14469, 19935, -25480,  7517, -8055,  7508, -5315,   432,  3221, -8556, 15731, -12379, 17722, -23673, 29866, -17889, 20369, -21968, 22232, -10341,  8427, -5163,   391,  2988, -6964, 11670, -16975, 11338, -14245, 17032, -19483, 10674, -11169, 11064, -10171,  4129, -2508,   -15,  3863, -1242,  2583, -5707, 25217, },
	{ -1166,    87,  3615, -11566,  6400, -11877, 19667, -29897, 10585, -14069, 17591, -20640, 11260, -11181,  9585, -5941,  -132,  4731, -10965, 18853, -14129, 19426, -25043, 30588, -17778, 19669, -20621, 20266, -9116,  7088, -3901,  -551,  3159, -6690, 10821, -15459, 10235, -12835, 15416, -17843,  9977, -10776, 11190, -11022,  1236,  -847,  -372, 30257, },
	{  2731, -5592,  8883, -11677,  3102, -2201,  -520,  5921, -3727,  7076, -11669, 17538, -12273, 16167, -20139, 23732, -13169, 13607, -12762, 10190, -2732,  -888,  5891, -12310, 10033, -14469, 19273, -24170, 14399, -16358, 17709, -18174,  8732, -7645,  5691, -2750,  -640,  3237, -6444, 10280, -7385,  9980, -12980, 16520, -2616,  3384, -4739,  8903, },
	{  3329, -7624, 14219, -23176,  8492, -11310, 13642, -14579,  3226, -1782, -1101,  5839, -6398, 11104, -17054, 24120, -15994, 20064, -23889, 26972, -14357, 14217, -12712,  9493, -2129, -1608,  6516, -12565,  9814, -13733, 17861, -21956, 12858, -14393, 15380, -15597,  7403, -6377,  4585, -1877,  -967,  3552, -7020, 11753, -2322,  3706, -6609, 19438, },
	{  1383, -4579, 10855, -21380,  9289, -14677, 21429, -29148,  9256, -10937, 11873, -11477,  4531, -1939, -2401,  8802, -8733, 14212, -20736, 28057, -17880, 21626, -24879, 27176, -13995, 13381, -11470,  8009, -1399, -2147,  6643, -12041,  9108, -12485, 16006, -19488, 11351, -12689, 13600, -13897,  6677, -5837,  4206, -1399,  -425,  1550, -4356, 27653, },
	{  1584, -2791,  3205, -1580,  -952,  3773, -8655, 16164, -6682, 10123, -14294, 18970, -11872, 13997, -15440, 15678, -7056,  5051, -1515, -3817,  5561, -10221, 15821, -22183, 14503, -17926, 21077, -23609, 12565, -12605, 11708, -9666,  3146,  -722, -2486,  6490, -5632,  8372, -11412, 14679, -9043, 10767, -12462, 14079, -1948,  2123, -2299,  2578, },
	{  3173, -6766, 11506, -16762,  5310, -5710,  4649, -1182, -1445,  4343, -8653, 14556, -11045, 15549, -20577, 25762, -15280, 17129, -17988, 17360, -7361,  4780,  -716, -4988,  6196, -10714, 15935, -21656, 13789, -16651, 19170, -21060, 11002, -10831,  9847, -7879,  2383,  -178, -2746,  6462, -5529,  8331, -11755, 16035, -2713,  3768, -5765, 12683, },
	{  2959, -7190, 14179, -24401,  9465, -13451, 17602, -21132,  5722, -5334,  3657,  -180, -2806,  7083, -12890, 20256, -14520, 19442, -24590, 29523, -16833, 18160, -18348, 16977, -6818,  3979,   171, -5707,  6309, -10395, 14989, -19905, 12443, -14804, 16838, -18320,  9498, -9292,  8386, -6603,  1861,   276, -3341,  7754, -1802,  3216, -6351, 22806, },
	{    70, -2213,  7285, -16745,  8023, -13642, 21200, -30577, 10315, -13059, 15470, -16985,  8444, -7171,  4220,   854, -4217,  9388, -15971, 23858, -16390, 21134, -25826, 30027, -16602, 17376, -17011, 15180, -5790,  2977,   936, -5985,  6071, -9650, 13636, -17888, 11112, -13206, 15087, -16591,  8759, -8806,  8256, -6810,   481,   290, -2395, 29401, },
	{  2251, -4402,  6408, -7163,  1243,   610, -4458, 11050, -5273,  8779, -13327, 18828, -12506, 15692, -18599, 20724, -10721, 10018, -7871,  3907,  1099, -5334, 10788, -17398, 12489, -16598, 20786, -24735, 14028, -15149, 15488, -14787,  6399, -4645,  2033,  1511, -3015,  5770, -9008, 12709, -8421, 10694, -13179, 15926, -2387,  2893, -3707,  5943, },
	{  3380, -7478, 13397, -20872,  7248, -9002,  9788, -8652,  1099,  1086, -4746, 10198, -8833, 13602, -19317, 25731, -16206, 19362, -21915, 23349, -11540, 10242, -7478,  2977,  1730, -5962, 11185, -17285, 12025, -15580, 19091, -22287, 12424, -13208, 13300, -12494,  5290, -3672,  1283,  1996, -3156,  5936, -9507, 14194, -2588,  3863, -6419, 16469, },
	{  2230, -6038, 12871, -23605,  9700, -14599, 20335, -26314,  7884, -8637,  8361, -6487,  1193,  2286, -7469, 14544, -11779, 17181, -23275, 29716, -17999, 20730, -22647, 23291, -11086,  9402, -6371,  1814,  2188, -6109, 10805, -16160, 10992, -14006, 16947, -19606, 10866, -11522, 11606, -10928,  4629, -3142,   767,  2915, -1100,  2411, -5502, 25717, },
	{ -1463,   649,  2696, -10227,  5961, -11362, 19148, -29502, 10566, -14198, 17956, -21343, 11837, -12040, 10774, -7493,   829,  3601, -9705, 17533, -13491, 18877, -24667, 30484, -17917, 20054, -21306, 21299, -9824,  7994, -5000,   722,  2454, -5947, 10080, -14773,  9951, -12649, 15375, -18000, 10186, -11156, 11795, -11933,  1407, -1115,   141, 30377, },
	{  2828, -5839,  9413, -12674,  3524, -2856,   424,  4653, -3330,  6616, -11186, 17097, -12123, 16153, -20346, 24256, -13643, 14346, -13812, 11586, -3610,   160,  4698, -11023,  9381, -13860, 18771, -23852, 14375, -16515, 18092, -18826,  9210, -8287,  6502, -3723,   -80,  2620, -5795,  9633, -7085,  9735, -12833, 16533, -2650,  3475, -4953,  9598, },
	{  3287, -7596, 14303, -23546,  8724, -11773, 14454, -15875,  3705, -2448,  -230,  4764, -5773, 10429, -16389, 23554, -15820, 20073, -24168, 27615, -14907, 15039, -13840, 10946, -3016,  -577,  5374, -11365,  9222, -13196, 17437, -21711, 12861, -14559, 15748, -16202,  7840, -6960,  5322, -2768,  -447,  2965, -6381, 11086, -2240,  3639, -6603, 20092, },
	{  1159, -4184, 10278, -20672,  9116, -14580, 21522, -29594,  9509, -11397, 12611, -12567,  5283, -2920, -1189,  7383, -7950, 13405, -19980, 27452, -17715, 21669, -25211, 27876, -14568, 14209, -12574,  9396, -2226, -1204,  5620, -10986,  8599, -12034, 15664, -19311, 11377, -12864, 13961, -14485,  7106, -6425,  4983, -2407,  -261,  1331, -4037, 28033, },
	{  1711, -3097,  3802, -2602,  -558,  3219, -7941, 15327, -6465,  9939, -14205, 19063, -12064, 14398, -16121, 16711, -7779,  6004, -2704, -2406,  4766, -9376, 14983, -21431, 14218, -17791, 21154, -23966, 12916, -13158, 12486, -10681,  3773, -1459, -1658,  5601, -5179,  7939, -11035, 14403, -8983, 10821, -12672, 14509, -2041,  2277, -2568,  3176, },
	{  3232, -6938, 11921, -17615,  5697, -6348,  5620, -2562,  -986,  3770, -7987, 13842, -10705, 15286, -20472, 25917, -15548, 17650, -18829, 18581, -8184,  5826, -1979, -3536,  5403, -9895, 15149, -20976, 13546, -16555, 19275, -21420, 11336, -11342, 10552, -8789,  2940,  -831, -2012,  5670, -5122,  7938, -11411, 15794, -2707,  3808, -5918, 13391, },
	{  2850, -7030, 14033, -24411,  9568, -13746, 18214, -22218,  6156, -5976,  4548, -1346, -2084,  6239, -11966, 19324, -14102, 19144, -24499, 29743, -17155, 18751, -19262, 18258, -7656,  5014, -1047, -4341,  5580, -9660, 14302, -19331, 12250, -14747, 16963, -18674,  9812, -9765,  9038, -7449,  2388,  -358, -2600,  6907, -1684,  3089, -6239, 23386, },
	{  -202, -1713,  6500, -15665,  7697, -13311, 20956, -30571, 10426, -13351, 16026, -17897,  9125, -8117,  5461,  -689, -3307,  8372, -14906, 22832, -15953, 20846, -25771, 30299, -16950, 17983, -17917, 16415, -6578,  3931,  -166, -4771,  5434, -9020, 13057, -17419, 10965, -13184, 15235, -16956,  9079, -9297,  8963, -7799,   654,    37, -1965, 29643, },
	{  2368, -4687,  6991, -8208,  1667,   -20, -3591,  9944, -4949,  8436, -13016, 18626, -12513, 15875, -19039, 21508, -11330, 10884, -9023,  5358,   230, -4345,  9722, -16320, 11988, -16192, 20540, -24725, 14180, -15498, 16070, -15633,  6963, -5353,  2879,   544, -2487,  5218, -8465, 12215, -8225, 10583, -13197, 16138, -2450,  3018, -3955,  6606, },
	{  3387, -7548, 13647, -21490,  7563, -9566, 10705, -10034,  1586,   442, -3942,  9258, -8322, 13100, -18895, 25488, -16235, 19615, -22470, 24287, -12238, 11199, -8708,  4479,   857, -4996, 10172, -16289, 11578, -15233, 18902, -22318, 12583, -13543, 13839, -13263,  5798, -4308,  2044,  1121, -2672,  5421, -8986, 13708, -2540,  3846, -6492, 17160, },
	{  2056, -5744, 12484, -23222,  9655, -14687, 20680, -27082,  8233, -9200,  9198, -7651,  1957,  1336, -6352, 13307, -11142, 16587, -22808, 29481, -18059, 21034, -23265, 24290, -11804, 10356, -7566,  3239,  1379, -5232,  9905, -15296, 10614, -13725, 16813, -19673, 11029, -11844, 12117, -11659,  5119, -3771,  1553,  1949,  -952,  2230, -5277, 26197, },
	{ -1763,  1220,  1754, -8837,  5497, -10807, 18567, -29017, 10517, -14288, 18273, -21991, 12385, -12871, 11942, -9036,  1794,  2453, -8410, 16155, -12809, 18270, -24218, 30293, -18005, 20384, -21935, 22276, -10507,  8881, -6091,  1999,  1740, -5184,  9307, -14042,  9638, -12427, 15290, -18106, 10368, -11507, 12371, -12818,  1575, -1385,   670, 30468, },
	{  2918, -6074,  9926, -13652,  3942, -3513,  1379,  3357, -2920,  6133, -10666, 16603, -11936, 16094, -20497, 24716, -14081, 15049, -14830, 12958, -4483,  1215,  3485, -9698,  8699, -13208, 18213, -23465, 14310, -16625, 18425, -19427,  9664, -8909,  7298, -4691,   482,  1993, -5126,  8955, -6764,  9462, -12649, 16499, -2677,  3558, -5157, 10298, },
	{  3233, -7545, 14346, -23853,  8933, -12209, 15235, -17140,  4180, -3114,   651,  3664, -5127,  9719, -15672, 22917, -15600, 20026, -24381, 28183, -15418, 15824, -14935, 12375, -3899,   461,  4211, -10126,  8600, -12619, 16961, -21402, 12827, -14685, 16073, -16764,  8256, -7526,  6048, -3657,    78,  2366, -5720, 10383, -2152,  3561, -6579, 20735, },
	{   926, -3767,  9660, -19893,  8915, -14440, 21554, -29959,  9737, -11829, 13321, -13631,  6027, -3901,    36,  5933, -7138, 12555, -19162, 26764, -17498, 21651, -25472, 28501, -15102, 15001, -13648, 10763, -3051,  -254,  4576, -9895,  8062, -11546, 15275, -19079, 11371, -13004, 14286, -15035,  7517, -6998,  5751, -3418,   -95,  1104, -3697, 28389, },
	{  1838, -3400,  4401, -3635,  -157,  2647, -7194, 14435, -6226,  9725, -14074, 19101, -12222, 14762, -16762, 17704, -8487,  6947, -3895,  -979,  3953, -8498, 14098, -20613, 13892, -17604, 21172, -24257, 13232, -13676, 13232, -11671,  4391, -2194,  -822,  4693, -4709,  7481, -10625, 14085, -8898, 10844, -12849, 14900, -2129,  2427, -2835,  3788, },
	{  3282, -7093, 12310, -18431,  6074, -6977,  6588, -3951,  -519,  3180, -7290, 13082, -10331, 14977, -20308, 25999, -15772, 18125, -19623, 19758, -8988,  6861, -3243, -2066,  4590, -9044, 14316, -20233, 13264, -16412, 19325, -21721, 11639, -11823, 11231, -9678,  3491, -1484, -1269,  4858, -4698,  7519, -11032, 15506, -2693,  3839, -6057, 14100, },
	{  2729, -6846, 13843, -24351,  9645, -14005, 18781, -23251,  6577, -6608,  5435, -2520, -1349,  5370, -11001, 18329, -13641, 18788, -24338, 29880, -17430, 19293, -20127, 19495, -8476,  6041, -2269, -2955,  4832, -8895, 13571, -18698, 12021, -14648, 17041, -18976, 10100, -10214,  9668, -8280,  2911,  -994, -1846,  6034, -1560,  2952, -6107, 23950, },
	{  -480, -1197,  5682, -14522,  7344, -12936, 20650, -30477, 10508, -13607, 16541, -18766,  9785, -9048,  6696, -2241, -2381,  7325, -13792, 21733, -15468, 20497, -25643, 30487, -17252, 18543, -18778, 17610, -7351,  4879, -1272, -3538,  4779, -8360, 12439, -16897, 10786, -13125, 15340, -17276,  9375, -9765,  9650, -8774,   827,  -221, -1515, 29858, },
	{  2481, -4965,  7566, -9248,  2092,  -659, -2703,  8797, -4607,  8065, -12664, 18369, -12485, 16015, -19428, 22237, -11911, 11725, -10158,  6804,  -644, -3338,  8622, -15189, 11450, -15737, 20235, -24644, 14292, -15805, 16609, -16438,  7510, -6050,  3722,  -429, -1948,  4649, -7896, 11684, -8004, 10440, -13178, 16305, -2507,  3135, -4196,  7277, },
	{  3384, -7597, 13861, -22057,  7861, -10110, 11603, -11402,  2073,  -211, -3119,  8283, -7783, 12556, -18416, 25170, -16219, 19814, -22965, 25162, -12905, 12129, -9922,  5977,   -24, -4011,  9124, -15242, 11095, -14840, 18657, -22286, 12707, -13840, 14342, -13999,  6293, -4935,  2803,   238, -2177,  4887, -8436, 13178, -2485,  3818, -6547, 17845, },
	{  1870, -5427, 12053, -22764,  9581, -14735, 20971, -27781,  8561, -9742, 10017, -8804,  2722,   375, -5208, 12023, -10469, 15942, -22273, 29160, -18067, 21280, -23821, 25225, -12492, 11286, -8747,  4661,   562, -4337,  8973, -14384, 10204, -13404, 16631, -19684, 11162, -12134, 12596, -12360,  5597, -4394,  2341,   970,  -801,  2039, -5029, 26655, },
	{ -2066,  1801,   788, -7398,  5011, -10213, 17925, -28443, 10437, -14339, 18540, -22582, 12902, -13672, 13084, -10564,  2762,  1289, -7081, 14723, -12088, 17608, -23698, 30015, -18042, 20658, -22504, 23196, -11163,  9748, -7170,  3277,  1017, -4403,  8505, -13267,  9296, -12169, 15160, -18161, 10521, -11828, 12916, -13676,  1741, -1656,  1216, 30531, },
	{  3002, -6296, 10420, -14606,  4356, -4168,  2343,  2036, -2496,  5627, -10110, 16056, -11714, 15988, -20590, 25108, -14483, 15714, -15813, 14303, -5348,  2273,  2255, -8338,  7988, -12515, 17601, -23009, 14204, -16689, 18708, -19976, 10092, -9508,  8077, -5651,  1047,  1357, -4439,  8247, -6421,  9159, -12428, 16418, -2696,  3631, -5351, 11002, },
	{  3166, -7469, 14348, -24095,  9119, -12614, 15981, -18371,  4647, -3777,  1538,  2545, -4460,  8974, -14905, 22209, -15334, 19921, -24525, 28674, -15888, 16568, -15995, 13778, -4775,  1503,  3030, -8853,  7951, -12003, 16434, -21031, 12757, -14770, 16353, -17281,  8652, -8074,  6760, -4541,   605,  1756, -5037,  9643, -2056,  3472, -6535, 21365, },
	{   683, -3330,  9002, -19042,  8684, -14256, 21523, -30243,  9940, -12231, 13999, -14665,  6760, -4878,  1270,  4454, -6300, 11662, -18284, 25996, -17229, 21571, -25663, 29049, -15597, 15754, -14689, 12107, -3872,   702,  3514, -8771,  7500, -11024, 14841, -18791, 11333, -13108, 14571, -15546,  7909, -7555,  6510, -4429,    74,   870, -3335, 28720, },
	{  1963, -3702,  5000, -4676,   252,  2060, -6416, 13490, -5967,  9480, -13902, 19086, -12347, 15086, -17361, 18655, -9175,  7877, -5082,   461,  3123, -7592, 13167, -19732, 13524, -17366, 21129, -24480, 13512, -14159, 13944, -12633,  5001, -2927,    21,  3767, -4224,  7000, -10182, 13725, -8787, 10836, -12990, 15253, -2212,  2572, -3098,  4412, },
	{  3322, -7230, 12669, -19207,  6438, -7594,  7549, -5345,   -45,  2575, -6566, 12277, -9925, 14622, -20085, 26008, -15954, 18552, -20366, 20885, -9773,  7884, -4506,  -582,  3759, -8163, 13438, -19429, 12942, -16221, 19321, -21962, 11911, -12273, 11881, -10544,  4035, -2137,  -518,  4028, -4258,  7077, -10619, 15172, -2671,  3859, -6183, 14806, },
	{  2596, -6636, 13608, -24217,  9694, -14227, 19301, -24230,  6983, -7227,  6315, -3697,  -605,  4479, -9996, 17274, -13138, 18377, -24106, 29932, -17657, 19783, -20940, 20684, -9277,  7055, -3490, -1554,  4066, -8100, 12798, -18010, 11757, -14507, 17070, -19226, 10361, -10635, 10274, -9091,  3428, -1632, -1081,  5135, -1430,  2804, -5953, 24496, },
	{  -765,  -665,  4832, -13318,  6964, -12519, 20279, -30295, 10561, -13827, 17014, -19589, 10423, -9961,  7922, -3798, -1442,  6250, -12632, 20565, -14936, 20087, -25441, 30589, -17507, 19052, -19589, 18761, -8108,  5818, -2380, -2289,  4107, -7674, 11783, -16326, 10575, -13029, 15402, -17548,  9646, -10209, 10315, -9733,  1000,  -482, -1046, 30045, },
	{  2589, -5236,  8129, -10279,  2518, -1304, -1795,  7611, -4247,  7666, -12272, 18057, -12420, 16110, -19764, 22908, -12462, 12538, -11272,  8239, -1523, -2315,  7491, -14009, 10877, -15235, 19870, -24493, 14365, -16068, 17104, -17200,  8039, -6733,  4557, -1406, -1402,  4065, -7300, 11116, -7760, 10267, -13120, 16427, -2558,  3246, -4430,  7957, },
	{  3369, -7624, 14038, -22568,  8140, -10632, 12479, -12755,  2560,  -870, -2279,  7274, -7217, 11971, -17881, 24779, -16156, 19958, -23398, 25972, -13540, 13030, -11114,  7467,  -909, -3009,  8045, -14146, 10578, -14404, 18359, -22191, 12796, -14100, 14807, -14698,  6772, -5551,  3558,  -650, -1673,  4336, -7858, 12606, -2421,  3778, -6586, 18522, },
	{  1672, -5086, 11579, -22232,  9478, -14740, 21204, -28408,  8869, -10262, 10815, -9943,  3486,  -595, -4040, 10695, -9761, 15247, -21671, 28754, -18024, 21467, -24312, 26094, -13148, 12189, -9909,  6078,  -262, -3424,  8011, -13426,  9763, -13044, 16401, -19640, 11263, -12391, 13043, -13030,  6062, -5009,  3129,   -22,  -645,  1839, -4761, 27091, },
	{ -2371,  2388,  -197, -5914,  4504, -9582, 17224, -27781, 10326, -14348, 18757, -23114, 13387, -14440, 14198, -12074,  3728,   114, -5724, 13239, -11327, 16891, -23108, 29649, -18029, 20874, -23013, 24054, -11791, 10591, -8233,  4552,   287, -3605,  7674, -12451,  8926, -11874, 14987, -18165, 10645, -12117, 13430, -14503,  1904, -1927,  1779, 30566, },
	{  3080, -6504, 10893, -15535,  4763, -4821,  3312,   693, -2061,  5100, -9519, 15459, -11457, 15835, -20625, 25432, -14846, 16339, -16757, 15615, -6204,  3331,  1011, -6946,  7250, -11782, 16935, -22485, 14057, -16706, 18939, -20471, 10494, -10083,  8837, -6599,  1611,   714, -3736,  7513, -6059,  8829, -12169, 16289, -2709,  3695, -5533, 11708, },
	{  3087, -7368, 14306, -24271,  9282, -12989, 16691, -19563,  5106, -4437,  2429,  1407, -3775,  8198, -14088, 21433, -15022, 19759, -24600, 29087, -16316, 17269, -17015, 15150, -5643,  2547,  1834, -7547,  7276, -11350, 15858, -20598, 12650, -14813, 16589, -17751,  9024, -8602,  7457, -5417,  1134,  1138, -4335,  8869, -1954,  3372, -6472, 21981, },
	{   430, -2873,  8305, -18122,  8425, -14027, 21431, -30442, 10117, -12602, 14643, -15667,  7480, -5850,  2511,  2951, -5438, 10730, -17348, 25149, -16910, 21430, -25782, 29517, -16050, 16467, -15694, 13422, -4686,  1660,  2436, -7617,  6913, -10468, 14363, -18448, 11262, -13175, 14816, -16016,  8282, -8095,  7255, -5436,   245,   630, -2953, 29025, },
	{  2086, -4000,  5596, -5722,   666,  1458, -5610, 12496, -5689,  9205, -13689, 19015, -12438, 15370, -17914, 19560, -9842,  8792, -6263,  1909,  2279, -6658, 12193, -18790, 13115, -17077, 21026, -24635, 13755, -14603, 14621, -13564,  5599, -3655,   867,  2825, -3724,  6496, -9708, 13325, -8651, 10798, -13095, 15565, -2290,  2711, -3358,  5049, },
	{  3354, -7348, 12998, -19940,  6789, -8197,  8501, -6740,   434,  1956, -5816, 11430, -9486, 14223, -19802, 25943, -16091, 18928, -21056, 21961, -10534,  8890, -5764,   913,  2913, -7254, 12517, -18565, 12582, -15983, 19262, -22141, 12150, -12690, 12501, -11385,  4571, -2787,   239,  3182, -3803,  6611, -10173, 14791, -2642,  3868, -6293, 15509, },
	{  2450, -6401, 13329, -24010,  9716, -14410, 19771, -25150,  7374, -7832,  7185, -4874,   148,  3567, -8955, 16162, -12593, 17911, -23804, 29900, -17835, 20220, -21698, 21820, -10056,  8056, -4708,  -141,  3284, -7279, 11985, -17267, 11459, -14325, 17052, -19423, 10594, -11029, 10854, -9881,  3940, -2269,  -307,  4214, -1294,  2645, -5778, 25024, },
	{ -1056,  -120,  3952, -12055,  6559, -12060, 19846, -30023, 10584, -14010, 17442, -20363, 11036, -10853,  9134, -5357,  -491,  5150, -11427, 19332, -14358, 19618, -25165, 30605, -17713, 19510, -20349, 19865, -8845,  6744, -3487, -1027,  3420, -6963, 11090, -15704, 10333, -12895, 15421, -17772,  9892, -10627, 10957, -10674,  1172,  -747,  -559, 30204, },
	{  2693, -5497,  8680, -11299,  2943, -1955,  -870,  6388, -3872,  7241, -11841, 17690, -12320, 16160, -20047, 23519, -12982, 13322, -12361,  9661, -2403, -1280,  6332, -12781, 10269, -14686, 19447, -24271, 14397, -16287, 17553, -17917,  8547, -7400,  5384, -2383,  -849,  3465, -6681, 10514, -7491, 10064, -13025, 16504, -2601,  3348, -4656,  8644, },
	{  3342, -7628, 14177, -23021,  8400, -11130, 13330, -14086,  3045, -1533, -1425,  6236, -6626, 11348, -17290, 24313, -16047, 20045, -23767, 26713, -14141, 13900, -12281,  8944, -1796, -1992,  6938, -13004, 10028, -13924, 18007, -22032, 12848, -14321, 15231, -15359,  7234, -6154,  4307, -1542, -1161,  3768, -7254, 11993, -2350,  3727, -6606, 19190, },
	{  1464, -4721, 11060, -21626,  9346, -14703, 21379, -28961,  9154, -10758, 11589, -11063,  4247, -1572, -2851,  9325, -9020, 14503, -21003, 28263, -17929, 21594, -24737, 26894, -13770, 13062, -11049,  7485, -1088, -2497,  7021, -12426,  9293, -12644, 16123, -19540, 11333, -12614, 13454, -13667,  6512, -5613,  3913, -1022,  -485,  1631, -4471, 27504, },
	{  1536, -2677,  2981, -1200, -1097,  3976, -8915, 16464, -6758, 10184, -14316, 18922, -11792, 13837, -15174, 15281, -6780,  4691, -1069, -4342,  5854, -10529, 16122, -22448, 14599, -17964, 21033, -23459, 12424, -12389, 11409, -9279,  2910,  -446, -2793,  6817, -5798,  8528, -11544, 14771, -9058, 10739, -12374, 13909, -1912,  2064, -2198,  2357, },
	{  3149, -6698, 11343, -16433,  5163, -5469,  4284,  -668, -1615,  4553, -8896, 14811, -11164, 15636, -20601, 25685, -15170, 16921, -17660, 16892, -7048,  4386,  -244, -5526,  6488, -11012, 16217, -21894, 13870, -16675, 19117, -20910, 10869, -10632,  9576, -7533,  2173,    66, -3018,  6753, -5677,  8472, -11875, 16113, -2713,  3750, -5704, 12417, },
	{  2996, -7243, 14222, -24378,  9420, -13331, 17361, -20713,  5556, -5091,  3322,   255, -3073,  7392, -13225, 20590, -14665, 19539, -24606, 29419, -16700, 17926, -17992, 16486, -6500,  3589,   626, -6214,  6577, -10662, 15235, -20105, 12506, -14814, 16779, -18174,  9373, -9108,  8137, -6282,  1663,   512, -3615,  8064, -1845,  3260, -6388, 22584, },
	{   170, -2397,  7570, -17133,  8138, -13756, 21275, -30556, 10267, -12940, 15251, -16633,  8184, -6813,  3754,  1429, -4554,  9761, -16356, 24225, -16541, 21226, -25828, 29903, -16460, 17136, -16659, 14707, -5491,  2619,  1347, -6435,  6305, -9879, 13842, -18051, 11159, -13204, 15021, -16442,  8633, -8616,  7986, -6437,   416,   384, -2551, 29304, },
	{  2207, -4293,  6188, -6770,  1085,   843, -4777, 11453, -5390,  8901, -13433, 18889, -12494, 15612, -18421, 20416, -10486,  9687, -7435,  3362,  1423, -5699, 11178, -17789, 12667, -16738, 20863, -24721, 13961, -15008, 15259, -14460,  6183, -4377,  1715,  1871, -3211,  5971, -9205, 12884, -8489, 10728, -13163, 15836, -2361,  2845, -3613,  5698, },
	{  3375, -7446, 13295, -20626,  7126, -8786,  9440, -8132,   917,  1326, -5042, 10542, -9017, 13780, -19460, 25803, -16183, 19254, -21691, 22981, -11270,  9878, -7013,  2414,  2055, -6319, 11555, -17645, 12184, -15699, 19148, -22259, 12356, -13074, 13088, -12197,  5096, -3432,   998,  2322, -3335,  6124, -9695, 14365, -2604,  3866, -6388, 16208, },
	{  2293, -6141, 13004, -23730,  9710, -14555, 20191, -26009,  7748, -8420,  8043, -6049,   907,  2638, -7880, 14995, -12009, 17390, -23433, 29782, -17964, 20601, -22399, 22901, -10810,  9039, -5919,  1280,  2489, -6432, 11134, -16472, 11126, -14100, 16985, -19566, 10798, -11393, 11406, -10648,  4443, -2905,   473,  3272, -1154,  2477, -5582, 25532, },
	{ -1351,   437,  3044, -10736,  6128, -11560, 19350, -29661, 10577, -14154, 17825, -21086, 11624, -11721, 10331, -6912,   468,  4027, -10182, 18035, -13735, 19090, -24817, 30534, -17871, 19916, -21056, 20918, -9561,  7656, -4589,   244,  2720, -6228, 10362, -15036, 10061, -12723, 15396, -17947, 10111, -11017, 11572, -11594,  1343, -1015,   -54, 30335, },
	{  2792, -5747,  9216, -12302,  3366, -2610,    69,  5132, -3481,  6791, -11372, 17269, -12183, 16164, -20275, 24067, -13469, 14073, -13422, 11065, -3281,  -234,  5148, -11511,  9629, -14093, 18966, -23979, 14389, -16461, 17954, -18587,  9033, -8049,  6200, -3359,  -291,  2853, -6040,  9879, -7200,  9830, -12893, 16534, -2638,  3442, -4874,  9337, },
	{  3304, -7609, 14276, -23414,  8640, -11603, 14153, -15392,  3526, -2198,  -557,  5170, -6010, 10686, -16645, 23775, -15890, 20076, -24071, 27383, -14705, 14735, -13421, 10403, -2683,  -965,  5805, -11819,  9447, -13403, 17602, -21810, 12864, -14502, 15615, -15980,  7678, -6743,  5047, -2434,  -643,  3187, -6624, 11341, -2272,  3665, -6608, 19848, },
	{  1244, -4335, 10500, -20946,  9184, -14622, 21494, -29436,  9417, -11228, 12338, -12161,  5002, -2552, -1645,  7919, -8247, 13713, -20271, 27689, -17783, 21660, -25095, 27622, -14357, 13902, -12163,  8878, -1916, -1559,  6006, -11386,  8793, -12207, 15798, -19384, 11371, -12803, 13830, -14269,  6947, -6206,  4692, -2029,  -323,  1414, -4159, 27894, },
	{  1663, -2982,  3578, -2217,  -707,  3428, -8213, 15647, -6548, 10012, -14243, 19034, -11996, 14252, -15870, 16328, -7510,  5648, -2258, -2937,  5066, -9696, 15303, -21721, 14330, -17848, 21132, -23840, 12788, -12955, 12198, -10303,  3539, -1182, -1970,  5937, -5351,  8104, -11180, 14511, -9009, 10804, -12597, 14352, -2007,  2220, -2467,  2950, },
	{  3211, -6876, 11769, -17300,  5553, -6110,  5256, -2043, -1159,  3987, -8240, 14115, -10837, 15390, -20519, 25867, -15452, 17460, -18519, 18129, -7877,  5435, -1505, -4083,  5703, -10206, 15449, -21239, 13642, -16597, 19242, -21292, 11214, -11154, 10291, -8450,  2731,  -586, -2288,  5970, -5276,  8088, -11544, 15890, -2710,  3794, -5862, 13126, },
	{  2892, -7093, 14093, -24416,  9533, -13639, 17989, -21817,  5994, -5736,  4215,  -908, -2356,  6558, -12318, 19681, -14264, 19262, -24541, 29670, -17039, 18535, -18925, 17783, -7344,  4627,  -590, -4855,  5856, -9939, 14565, -19553, 12327, -14773, 16922, -18547,  9697, -9591,  8796, -7134,  2191,  -120, -2879,  7228, -1729,  3138, -6284, 23170, },
	{   -99, -1903,  6799, -16077,  7822, -13440, 21055, -30583, 10388, -13245, 15822, -17560,  8872, -7764,  4996,  -109, -3650,  8757, -15311, 23225, -16122, 20961, -25801, 30207, -16825, 17761, -17583, 15956, -6284,  3574,   248, -5229,  5675, -9260, 13279, -17601, 11024, -13197, 15185, -16825,  8961, -9115,  8700, -7429,   589,   133, -2128, 29556, },
	{  2324, -4581,  6774, -7817,  1508,   217, -3919, 10364, -5073,  8568, -13137, 18708, -12515, 15812, -18880, 21220, -11104, 10562, -8593,  4814,   557, -4718, 10126, -16731, 12180, -16350, 20640, -24737, 14127, -15372, 15856, -15320,  6754, -5089,  2562,   907, -2686,  5427, -8672, 12405, -8302, 10628, -13195, 16063, -2427,  2972, -3863,  6356, },
	{  3386, -7525, 13558, -21264,  7447, -9356, 10363, -9517,  1403,   684, -4246,  9615, -8517, 13293, -19060, 25588, -16230, 19527, -22269, 23942, -11979, 10843, -8249,  3916,  1185, -5361, 10556, -16669, 11750, -15369, 18979, -22314, 12528, -13421, 13641, -12979,  5609, -4071,  1759,  1451, -2855,  5616, -9185, 13895, -2559,  3854, -6467, 16901, },
	{  2123, -5857, 12634, -23375,  9676, -14659, 20557, -26802,  8104, -8991,  8886, -7216,  1670,  1694, -6774, 13777, -11386, 16816, -22992, 29579, -18042, 20927, -23041, 23923, -11538, 10001, -7120,  2704,  1684, -5564, 10247, -15626, 10760, -13835, 16869, -19654, 10972, -11727, 11929, -11388,  4936, -3536,  1258,  2313, -1008,  2299, -5364, 26019, },
	{ -1650,  1005,  2110, -9364,  5674, -11020, 18792, -29209, 10539, -14259, 18159, -21755, 12183, -12563, 11507, -8459,  1432,  2885, -8899, 16679, -13070, 18504, -24395, 30375, -17978, 20266, -21706, 21916, -10253,  8551, -5683,  1520,  2009, -5473,  9601, -14321,  9759, -12515, 15327, -18072, 10303, -11379, 12158, -12489,  1512, -1284,   470, 30437, },
	{  2885, -5987,  9736, -13288,  3786, -3267,  1020,  3847, -3075,  6317, -10865, 16794, -12010, 16122, -20447, 24551, -13921, 14790, -14452, 12447, -4156,   819,  3942, -10200,  8958, -13457, 18429, -23618, 14339, -16589, 18306, -19207,  9496, -8678,  7001, -4329,   271,  2230, -5379,  9212, -6887,  9568, -12723, 16517, -2668,  3528, -5082, 10035, },
	{  3254, -7567, 14335, -23745,  8857, -12049, 14946, -16670,  4003, -2864,   320,  4079, -5372,  9989, -15947, 23164, -15688, 20051, -24309, 27979, -15231, 15534, -14529, 11842, -3568,    71,  4649, -10595,  8837, -12840, 17145, -21525, 12844, -14643, 15956, -16558,  8102, -7316,  5777, -3325,  -119,  2592, -5970, 10651, -2186,  3592, -6590, 20495, },
	{  1014, -3926,  9897, -20194,  8994, -14498, 21549, -29832,  9655, -11670, 13058, -13235,  5749, -3533,  -425,  6480, -7446, 12879, -19476, 27032, -17585, 21665, -25382, 28276, -14906, 14708, -13249, 10253, -2742,  -611,  4970, -10309,  8266, -11733, 15426, -19172, 11377, -12956, 14169, -14834,  7365, -6785,  5464, -3039,  -157,  1190, -3827, 28259, },
	{  1790, -3287,  4177, -3247,  -308,  2863, -7478, 14776, -6318,  9809, -14128, 19093, -12167, 14630, -16527, 17337, -8223,  6595, -3449, -1515,  4260, -8831, 14435, -20928, 14019, -17680, 21172, -24156, 13117, -13486, 12956, -11303,  4161, -1919, -1136,  5036, -4887,  7656, -10782, 14209, -8933, 10839, -12787, 14758, -2097,  2371, -2735,  3557, },
	{  3264, -7037, 12167, -18130,  5934, -6742,  6226, -3429,  -695,  3403, -7555, 13372, -10475, 15098, -20377, 25977, -15693, 17953, -19331, 19322, -8689,  6474, -2769, -2619,  4897, -9367, 14634, -20519, 13374, -16471, 19313, -21615, 11529, -11646, 10980, -9347,  3285, -1239, -1548,  5165, -4858,  7679, -11178, 15620, -2699,  3829, -6007, 13834, },
	{  2776, -6918, 13920, -24382,  9619, -13912, 18574, -22870,  6420, -6372,  5103, -2079, -1626,  5699, -11367, 18709, -13819, 18928, -24407, 29838, -17332, 19096, -19809, 19037, -8171,  5657, -1810, -3477,  5115, -9185, 13850, -18942, 12111, -14690, 17017, -18869,  9995, -10049,  9435, -7970,  2715,  -755, -2130,  6364, -1607,  3004, -6159, 23741, },
	{  -375, -1392,  5993, -14958,  7479, -13082, 20772, -30523, 10481, -13515, 16353, -18445,  9540, -8701,  6234, -1658, -2730,  7722, -14216, 22153, -15655, 20635, -25700, 30427, -17145, 18339, -18461, 17167, -7063,  4525,  -857, -4003,  5027, -8611, 12676, -17099, 10856, -13152, 15306, -17162,  9267, -9592,  9395, -8410,   762,  -123, -1686, 29781, },
	{  2439, -4862,  7351, -8859,  1932,  -418, -3038,  9232, -4737,  8207, -12800, 18472, -12500, 15968, -19288, 21970, -11696, 11412, -9735,  6262,  -316, -3718,  9038, -15619, 11656, -15913, 20356, -24682, 14255, -15695, 16412, -16141,  7307, -5790,  3406,   -64, -2151,  4865, -8112, 11887, -8090, 10497, -13189, 16247, -2486,  3092, -4106,  7024, },
	{  3386, -7582, 13785, -21851,  7752, -9908, 11269, -10891,  1890,    35, -3430,  8652, -7989, 12765, -18603, 25298, -16231, 19746, -22787, 24842, -12659, 11783, -9469,  5416,   307, -4382,  9521, -15640, 11280, -14993, 18755, -22306, 12665, -13733, 14158, -13727,  6109, -4701,  2519,   570, -2364,  5089, -8646, 13381, -2506,  3830, -6529, 17589, },
	{  1941, -5549, 12220, -22945,  9612, -14722, 20869, -27527,  8440, -9541,  9712, -8374,  2435,   737, -5640, 12510, -10726, 16190, -22482, 29290, -18070, 21195, -23620, 24882, -12237, 10940, -8306,  4128,   869, -4675,  9326, -14731, 10362, -13529, 16705, -19687, 11116, -12029, 12420, -12101,  5419, -4161,  2046,  1338,  -858,  2111, -5125, 26486, },
	{ -1952,  1582,  1153, -7943,  5196, -10440, 18173, -28669, 10471, -14325, 18446, -22367, 12712, -13375, 12659, -9993,  2399,  1727, -7583, 15266, -12363, 17862, -23902, 30129, -18034, 20561, -22298, 22858, -10920,  9426, -6767,  2798,  1289, -4698,  8809, -13562,  9427, -12270, 15214, -18146, 10467, -11711, 12716, -13358,  1679, -1555,  1010, 30511, },
	{  2972, -6214, 10238, -14251,  4201, -3923,  1981,  2534, -2657,  5820, -10322, 16267, -11802, 16033, -20562, 24969, -14337, 15469, -15449, 13802, -5025,  1876,  2718, -8852,  8258, -12779, 17837, -23188, 14248, -16671, 18608, -19776,  9935, -9286,  7787, -5292,   835,  1597, -4698,  8516, -6552,  9276, -12515, 16454, -2690,  3605, -5279, 10737, },
	{  3192, -7500, 14352, -24012,  9052, -12466, 15705, -17914,  4473, -3529,  1205,  2967, -4713,  9257, -15198, 22483, -15439, 19967, -24479, 28499, -15716, 16294, -15602, 13255, -4447,  1112,  3475, -9334,  8198, -12239, 16638, -21177, 12788, -14743, 16253, -17092,  8506, -7871,  6495, -4210,   407,  1986, -5295,  9924, -2093,  3507, -6554, 21130, },
	{   775, -3496,  9254, -19369,  8774, -14330, 21542, -30146,  9867, -12083, 13748, -14281,  6486, -4512,   806,  5012, -6617, 12002, -18620, 26294, -17336, 21609, -25600, 28852, -15416, 15476, -14303, 11606, -3565,   343,  3914, -9196,  7713, -11224, 15009, -18905, 11351, -13073, 14469, -15359,  7765, -7348,  6227, -4050,    11,   959, -3473, 28599, },
	{  1916, -3589,  4776, -4285,    98,  2282, -6711, 13851, -6067,  9575, -13972, 19098, -12304, 14969, -17141, 18304, -8919,  7530, -4637,   -80,  3436, -7935, 13521, -20070, 13667, -17461, 21152, -24404, 13411, -13982, 13681, -12276,  4773, -2653,  -296,  4116, -4408,  7183, -10352, 13865, -8832, 10843, -12941, 15126, -2182,  2518, -3000,  4177, },
	{  3308, -7181, 12538, -18921,  6303, -7364,  7190, -4821,  -223,  2804, -6841, 12584, -10081, 14760, -20175, 26014, -15891, 18397, -20093, 20468, -9481,  7502, -4033, -1140,  4073, -8497, 13772, -19738, 13067, -16298, 19329, -21879, 11813, -12108, 11641, -10222,  3832, -1892,  -800,  4341, -4424,  7246, -10778, 15302, -2680,  3853, -6137, 14541, },
	{  2647, -6717, 13702, -24276,  9679, -14148, 19112, -23870,  6833, -6996,  5986, -3255,  -885,  4816, -10377, 17677, -13331, 18538, -24201, 29923, -17578, 19605, -20642, 20244, -8979,  6676, -3032, -2081,  4355, -8401, 13093, -18275, 11860, -14565, 17065, -19139, 10266, -10480, 10050, -8789,  3235, -1393, -1369,  5475, -1479,  2860, -6013, 24294, },
	{  -658,  -866,  5155, -13776,  7110, -12680, 20426, -30374, 10545, -13749, 16842, -19286, 10186, -9621,  7463, -3214, -1795,  6657, -13072, 21011, -15141, 20248, -25525, 30561, -17417, 18867, -19291, 18335, -7826,  5467, -1964, -2759,  4361, -7934, 12033, -16546, 10658, -13069, 15384, -17452,  9547, -10045, 10069, -9376,   935,  -384, -1224, 29978, },
	{  2549, -5135,  7919, -9894,  2358, -1061, -2138,  8060, -4384,  7819, -12423, 18180, -12449, 16080, -19644, 22663, -12259, 12236, -10857,  7702, -1193, -2700,  7919, -14457, 11096, -15428, 20014, -24558, 14343, -15975, 16924, -16919,  7843, -6478,  4245, -1040, -1608,  4286, -7527, 11333, -7854, 10335, -13146, 16386, -2539,  3205, -4343,  7701, },
	{  3376, -7617, 13976, -22383,  8038, -10438, 12154, -12250,  2378,  -622, -2596,  7656, -7433, 12195, -18088, 24934, -16185, 19910, -23243, 25676, -13306, 12696, -10669,  6909,  -576, -3386,  8453, -14562, 10775, -14573, 18477, -22234, 12767, -14007, 14637, -14440,  6594, -5321,  3275,  -317, -1863,  4544, -8078, 12825, -2446,  3794, -6573, 18269, },
	{  1748, -5216, 11762, -22440,  9520, -14743, 21123, -28182,  8756, -10070, 10518, -9518,  3200,  -231, -4481, 11198, -10030, 15513, -21905, 28916, -18046, 21404, -24136, 25777, -12906, 11854, -9476,  5548,    48, -3768,  8375, -13791,  9932, -13183, 16493, -19663, 11229, -12298, 12879, -12783,  5889, -4779,  2834,   351,  -704,  1915, -4864, 26930, },
	{ -2256,  2167,   175, -6476,  4697, -9823, 17494, -28039, 10371, -14349, 18682, -22922, 13209, -14156, 13784, -11510,  3366,   556, -6236, 13801, -11617, 17166, -23338, 29797, -18040, 20800, -22829, 23739, -11559, 10278, -7837,  4075,   561, -3906,  7988, -12762,  9068, -11989, 15057, -18169, 10602, -12012, 13241, -14197,  1843, -1826,  1566, 30556, },
	{  3051, -6428, 10719, -15190,  4611, -4577,  2948,  1199, -2226,  5300, -9745, 15689, -11557, 15898, -20619, 25319, -14714, 16109, -16408, 15127, -5885,  2934,  1478, -7472,  7530, -12061, 17191, -22689, 14117, -16705, 18858, -20292, 10347, -9870,  8555, -6245,  1399,   956, -4001,  7791, -6197,  8956, -12271, 16343, -2705,  3673, -5466, 11443, },
	{  3118, -7409, 14327, -24213,  9224, -12852, 16429, -19121,  4935, -4190,  2095,  1836, -4034,  8493, -14400, 21732, -15144, 19827, -24580, 28941, -16161, 17011, -16637, 14639, -5319,  2155,  2284, -8040,  7532, -11599, 16080, -20768, 12694, -14802, 16506, -17580,  8887, -8407,  7198, -5089,   936,  1371, -4600,  9163, -1993,  3411, -6498, 21752, },
	{   526, -3046,  8571, -18475,  8526, -14118, 21473, -30377, 10054, -12466, 14405, -15295,  7211, -5486,  2045,  3517, -5764, 11084, -17706, 25476, -17036, 21490, -25746, 29350, -15885, 16204, -15322, 12932, -4382,  1300,  2842, -8053,  7136, -10680, 14548, -18583, 11292, -13154, 14729, -15844,  8144, -7895,  6977, -5059,   181,   721, -3099, 28914, },
	{  2040, -3889,  5373, -5330,   510,  1685, -5916, 12874, -5795,  9312, -13774, 19048, -12408, 15268, -17712, 19226, -9594,  8451, -5821,  1366,  2597, -7011, 12563, -19150, 13273, -17191, 21072, -24585, 13668, -14441, 14371, -13219,  5376, -3383,   549,  3180, -3913,  6687, -9890, 13480, -8705, 10816, -13060, 15453, -2261,  2660, -3261,  4809, },
	{  3343, -7306, 12878, -19670,  6659, -7973,  8145, -6217,   254,  2190, -6101, 11752, -9654, 14378, -19915, 25976, -16045, 18793, -20804, 21564, -10251,  8515, -5293,   352,  3232, -7598, 12867, -18896, 12721, -16078, 19291, -22081, 12064, -12538, 12272, -11073,  4371, -2543,   -46,  3501, -3975,  6789, -10344, 14939, -2654,  3866, -6253, 15246, },
	{  2506, -6492, 13439, -24097,  9711, -14346, 19601, -24812,  7230, -7607,  6860, -4433,  -135,  3911, -9349, 16586, -12802, 18092, -23926, 29922, -17774, 20062, -21421, 21400, -9766,  7683, -4252,  -672,  3579, -7590, 12294, -17552, 11575, -14398, 17065, -19356, 10510, -10884, 10640, -9587,  3749, -2031,  -598,  4562, -1346,  2706, -5846, 24828, },
	{  -946,  -326,  4285, -12535,  6714, -12237, 20016, -30135, 10579, -13946, 17287, -20078, 10809, -10521,  8681, -4773,  -849,  5565, -11884, 19802, -14580, 19800, -25277, 30609, -17642, 19345, -20071, 19457, -8571,  6398, -3072, -1501,  3679, -7232, 11354, -15943, 10427, -12949, 15419, -17694,  9803, -10473, 10719, -10324,  1108,  -647,  -744, 30148, },
	{  2655, -5400,  8475, -10918,  2784, -1711, -1219,  6851, -4014,  7404, -12007, 17834, -12362, 16147, -19948, 23297, -12791, 13032, -11955,  9130, -2073, -1669,  6770, -13247, 10501, -14897, 19612, -24362, 14390, -16211, 17390, -17654,  8359, -7152,  5075, -2017, -1057,  3692, -6916, 10744, -7595, 10143, -13065, 16480, -2586,  3311, -4572,  8385, },
	{  3354, -7630, 14130, -22858,  8305, -10946, 13014, -13589,  2863, -1284, -1747,  6629, -6851, 11586, -17518, 24496, -16093, 20019, -23636, 26443, -13920, 13578, -11846,  8391, -1463, -2375,  7356, -13437, 10238, -14109, 18145, -22099, 12833, -14242, 15077, -15116,  7063, -5930,  4027, -1207, -1354,  3983, -7483, 12228, -2378,  3748, -6600, 18940, },
	{  1543, -4861, 11260, -21862,  9399, -14722, 21320, -28762,  9050, -10575, 11302, -10645,  3962, -1205, -3299,  9843, -9301, 14788, -21262, 28457, -17971, 21553, -24586, 26603, -13541, 12738, -10624,  6959,  -778, -2846,  7395, -12806,  9472, -12799, 16233, -19584, 11311, -12534, 13304, -13432,  6345, -5388,  3619,  -646,  -546,  1710, -4582, 27352, },
};

int nextstate_441_320[441] = {
	0x00111400, 0x00211301, 0x00311201, 0x00411100, 0x00511001, 0x00610f01, 0x00710e01, 0x00810d00, 
	0x00910c01, 0x00a10b01, 0x00b10a00, 0x00c10901, 0x00d10801, 0x00e10701, 0x00f10600, 0x01010501, 
	0x01110401, 0x01210301, 0x01310200, 0x01410101, 0x01510001, 0x0160ff00, 0x0170fe01, 0x0180fd01, 
	0x0190fc01, 0x01a0fb00, 0x01b0fa01, 0x01c0f901, 0x01d0f801, 0x01e0f700, 0x01f0f601, 0x0200f501, 
	0x0210f400, 0x0220f301, 0x0230f201, 0x0240f101, 0x0250f000, 0x0260ef01, 0x0270ee01, 0x0280ed01, 
	0x0290ec00, 0x02a0eb01, 0x02b0ea01, 0x02c0e900, 0x02d0e801, 0x02e0e701, 0x02f0e601, 0x0300e500, 
	0x0310e401, 0x0320e301, 0x0330e201, 0x0340e100, 0x0350e001, 0x0360df01, 0x0370de00, 0x0380dd01, 
	0x0390dc01, 0x03a0db01, 0x03b0da00, 0x03c0d901, 0x03d0d801, 0x03e0d700, 0x03f0d601, 0x0400d501, 
	0x0410d401, 0x0420d300, 0x0430d201, 0x0440d101, 0x0450d001, 0x0460cf00, 0x0470ce01, 0x0480cd01, 
	0x0490cc00, 0x04a0cb01, 0x04b0ca01, 0x04c0c901, 0x04d0c800, 0x04e0c701, 0x04f0c601, 0x0500c501, 
	0x0510c400, 0x0520c301, 0x0530c201, 0x0540c100, 0x0550c001, 0x0560bf01, 0x0570be01, 0x0580bd00, 
	0x0590bc01, 0x05a0bb01, 0x05b0ba01, 0x05c0b900, 0x05d0b801, 0x05e0b701, 0x05f0b600, 0x0600b501, 
	0x0610b401, 0x0620b301, 0x0630b200, 0x0640b101, 0x0650b001, 0x0660af01, 0x0670ae00, 0x0680ad01, 
	0x0690ac01, 0x06a0ab00, 0x06b0aa01, 0x06c0a901, 0x06d0a801, 0x06e0a700, 0x06f0a601, 0x0700a501, 
	0x0710a400, 0x0720a301, 0x0730a201, 0x0740a101, 0x0750a000, 0x07609f01, 0x07709e01, 0x07809d01, 
	0x07909c00, 0x07a09b01, 0x07b09a01, 0x07c09900, 0x07d09801, 0x07e09701, 0x07f09601, 0x08009500, 
	0x08109401, 0x08209301, 0x08309201, 0x08409100, 0x08509001, 0x08608f01, 0x08708e00, 0x08808d01, 
	0x08908c01, 0x08a08b01, 0x08b08a00, 0x08c08901, 0x08d08801, 0x08e08701, 0x08f08600, 0x09008501, 
	0x09108401, 0x09208300, 0x09308201, 0x09408101, 0x09508001, 0x09607f00, 0x09707e01, 0x09807d01, 
	0x09907c01, 0x09a07b00, 0x09b07a01, 0x09c07901, 0x09d07800, 0x09e07701, 0x09f07601, 0x0a007501, 
	0x0a107400, 0x0a207301, 0x0a307201, 0x0a407101, 0x0a507000, 0x0a606f01, 0x0a706e01, 0x0a806d00, 
	0x0a906c01, 0x0aa06b01, 0x0ab06a01, 0x0ac06900, 0x0ad06801, 0x0ae06701, 0x0af06600, 0x0b006501, 
	0x0b106401, 0x0b206301, 0x0b306200, 0x0b406101, 0x0b506001, 0x0b605f01, 0x0b705e00, 0x0b805d01, 
	0x0b905c01, 0x0ba05b00, 0x0bb05a01, 0x0bc05901, 0x0bd05801, 0x0be05700, 0x0bf05601, 0x0c005501, 
	0x0c105401, 0x0c205300, 0x0c305201, 0x0c405101, 0x0c505000, 0x0c604f01, 0x0c704e01, 0x0c804d01, 
	0x0c904c00, 0x0ca04b01, 0x0cb04a01, 0x0cc04901, 0x0cd04800, 0x0ce04701, 0x0cf04601, 0x0d004500, 
	0x0d104401, 0x0d204301, 0x0d304201, 0x0d404100, 0x0d504001, 0x0d603f01, 0x0d703e01, 0x0d803d00, 
	0x0d903c01, 0x0da03b01, 0x0db03a00, 0x0dc03901, 0x0dd03801, 0x0de03701, 0x0df03600, 0x0e003501, 
	0x0e103401, 0x0e203300, 0x0e303201, 0x0e403101, 0x0e503001, 0x0e602f00, 0x0e702e01, 0x0e802d01, 
	0x0e902c01, 0x0ea02b00, 0x0eb02a01, 0x0ec02901, 0x0ed02800, 0x0ee02701, 0x0ef02601, 0x0f002501, 
	0x0f102400, 0x0f202301, 0x0f302201, 0x0f402101, 0x0f502000, 0x0f601f01, 0x0f701e01, 0x0f801d00, 
	0x0f901c01, 0x0fa01b01, 0x0fb01a01, 0x0fc01900, 0x0fd01801, 0x0fe01701, 0x0ff01601, 0x10001500, 
	0x10101401, 0x10201301, 0x10301200, 0x10401101, 0x10501001, 0x10600f01, 0x10700e00, 0x10800d01, 
	0x10900c01, 0x10a00b01, 0x10b00a00, 0x10c00901, 0x10d00801, 0x10e00700, 0x10f00601, 0x11000501, 
	0x11100401, 0x11200300, 0x11300201, 0x11400101, 0x11500000, 0x1161b801, 0x1171b701, 0x1181b601, 
	0x1191b500, 0x11a1b401, 0x11b1b301, 0x11c1b201, 0x11d1b100, 0x11e1b001, 0x11f1af01, 0x1201ae00, 
	0x1211ad01, 0x1221ac01, 0x1231ab01, 0x1241aa00, 0x1251a901, 0x1261a801, 0x1271a701, 0x1281a600, 
	0x1291a501, 0x12a1a401, 0x12b1a300, 0x12c1a201, 0x12d1a101, 0x12e1a001, 0x12f19f00, 0x13019e01, 
	0x13119d01, 0x13219c01, 0x13319b00, 0x13419a01, 0x13519901, 0x13619800, 0x13719701, 0x13819601, 
	0x13919501, 0x13a19400, 0x13b19301, 0x13c19201, 0x13d19101, 0x13e19000, 0x13f18f01, 0x14018e01, 
	0x14118d00, 0x14218c01, 0x14318b01, 0x14418a01, 0x14518900, 0x14618801, 0x14718701, 0x14818601, 
	0x14918500, 0x14a18401, 0x14b18301, 0x14c18200, 0x14d18101, 0x14e18001, 0x14f17f01, 0x15017e00, 
	0x15117d01, 0x15217c01, 0x15317b00, 0x15417a01, 0x15517901, 0x15617801, 0x15717700, 0x15817601, 
	0x15917501, 0x15a17401, 0x15b17300, 0x15c17201, 0x15d17101, 0x15e17000, 0x15f16f01, 0x16016e01, 
	0x16116d01, 0x16216c00, 0x16316b01, 0x16416a01, 0x16516901, 0x16616800, 0x16716701, 0x16816601, 
	0x16916500, 0x16a16401, 0x16b16301, 0x16c16201, 0x16d16100, 0x16e16001, 0x16f15f01, 0x17015e01, 
	0x17115d00, 0x17215c01, 0x17315b01, 0x17415a00, 0x17515901, 0x17615801, 0x17715701, 0x17815600, 
	0x17915501, 0x17a15401, 0x17b15301, 0x17c15200, 0x17d15101, 0x17e15001, 0x17f14f00, 0x18014e01, 
	0x18114d01, 0x18214c01, 0x18314b00, 0x18414a01, 0x18514901, 0x18614800, 0x18714701, 0x18814601, 
	0x18914501, 0x18a14400, 0x18b14301, 0x18c14201, 0x18d14101, 0x18e14000, 0x18f13f01, 0x19013e01, 
	0x19113d00, 0x19213c01, 0x19313b01, 0x19413a01, 0x19513900, 0x19613801, 0x19713701, 0x19813601, 
	0x19913500, 0x19a13401, 0x19b13301, 0x19c13200, 0x19d13101, 0x19e13001, 0x19f12f01, 0x1a012e00, 
	0x1a112d01, 0x1a212c01, 0x1a312b01, 0x1a412a00, 0x1a512901, 0x1a612801, 0x1a712700, 0x1a812601, 
	0x1a912501, 0x1aa12401, 0x1ab12300, 0x1ac12201, 0x1ad12101, 0x1ae12001, 0x1af11f00, 0x1b011e01, 
	0x1b111d01, 0x1b211c00, 0x1b311b01, 0x1b411a01, 0x1b511901, 0x1b611800, 0x1b711701, 0x1b811601, 
	0x00011501, 
};
#endif // HELIX_FEATURE_MMXFILTER_441_320

#ifdef HELIX_FEATURE_MMXFILTER_147_160
/*
 * inrate=48000 outrate=44100 up=147 dn=160
 */

ALIGN
filtwing filter_147_160[147] = {
	{   628, -5959, 16177, -29814, 10415, -10669,  5480,  7322, -6976, 13261, -18864, 21108, -8536,  2296,  8265, -21753, 17540, -21895, 21493, -14391,    -9, 10146, -21322, 30637, -17358, 15279, -8272, -3333,  8904, -16047, 21130, -22161,  8823, -3559, -4230, 13283, -10827, 13501, -13502,  9925, -1176, -4497, 11597, -19359,  3352, -4115,  4574, 27910, },
	{  1814, -7539, 17165, -28300,  8772, -7183,     2, 14087, -8520, 13901, -17680, 17296, -5161, -2258, 13131, -25500, 17969, -20042, 16868, -7157, -4414, 14378, -24096, 30614, -15440, 11311, -2640, -9652, 11666, -17543, 20566, -19053,  6020,   133, -8110, 16388, -11464, 12761, -11125,  5976,  1344, -7085, 13536, -19675,  3021, -3129,  2080, 27630, },
	{  2748, -8537, 17112, -25331,  6755, -3518, -5160, 19711, -9518, 13745, -15576, 12695, -1639, -6510, 17090, -27707, 17392, -17145, 11461,   249, -8445, 17694, -25463, 28903, -12720,  6821,  2996, -15283, 13716, -18035, 18880, -14964,  2949,  3733, -11453, 18516, -11452, 11335, -8196,  1806,  3714, -9198, 14660, -18903,  2545, -2057,  -147, 26838, },
	{  3402, -8952, 16109, -21183,  4504,   112, -9738, 23945, -9940, 12838, -12710,  7592,  1828, -10236, 19960, -28307, 15876, -13400,  5595,  7411, -11889, 19938, -25386, 25643, -9371,  2071,  8325, -19930, 14960, -17519, 16190, -10145,  -214,  7044, -14085, 19572, -10809,  9318, -4890, -2350,  5810, -10737, 14938, -17133,  1958,  -959, -2053, 25563, },
	{  3772, -8818, 14295, -16179,  2159,  3505, -13511, 26627, -9792, 11268, -9273,  2293,  5052, -13252, 21621, -27325, 13538, -9040,  -390, 13942, -14574, 21017, -23910, 21056, -5593, -2671, 13059, -23362, 15347, -16047, 12670, -4876, -3292,  9889, -15879, 19522, -9584,  6838, -1400, -6263,  7525, -11636, 14388, -14505,  1297,   106, -3603, 23845, },
	{  3870, -8198, 11843, -10665,  -142,  6489, -16316, 27695, -9113,  9154, -5484, -2903,  7864, -15418, 22028, -24873, 10535, -4329, -6161, 19501, -16373, 20904, -21157, 15433, -1607, -7142, 16952, -25419, 14877, -13725,  8532,   539, -6118, 12123, -16755, 18396, -7860,  4041,  2078, -9725,  8776, -11868, 13069, -11197,   601,  1086, -4772, 21743, },
	{  3726, -7181,  8950, -4992, -2273,  8923, -18055, 27177, -7967,  6638, -1566, -7712, 10125, -16648, 21205, -21139,  7056,   463, -11405, 23810, -17216, 19642, -17314,  9113,  2361, -11103, 19810, -26022, 13597, -10700,  4021,  5798, -8540, 13636, -16685, 16281, -5743,  1089,  5353, -12559,  9508, -11439, 11081, -7416,   -91,  1938, -5555, 19324, },
	{  3381, -5866,  5819,   508, -4126, 10706, -18694, 25190, -6441,  3879,  2256, -11885, 11734, -16913, 19245, -16376,  3310,  5068, -15850, 26671, -17083, 17333, -12625,  2464,  6092, -14348, 21502, -25172, 11598, -7156,  -607, 10615, -10434, 14361, -15696, 13316, -3359, -1850,  8250, -14625,  9695, -10396,  8555, -3386,  -743,  2627, -5959, 16668, },
	{  2885, -4363,  2650,  5538, -5618, 11781, -18264, 21925, -4640,  1042,  5777, -15219, 12630, -16234, 16300, -10886,  -487,  9238, -19275, 27971, -16011, 14135, -7372, -4137,  9387, -16715, 21964, -22954,  9006, -3302, -5092, 14733, -11708, 14276, -13862,  9685,  -847, -4616, 10619, -15830,  9344, -8813,  5648,   664, -1322,  3127, -6005, 13859, },
	{  2290, -2782,  -370,  9853, -6691, 12135, -16852, 17634, -2678, -1712,  8815, -17567, 12791, -14689, 12570, -4998, -4122, 12756, -21526, 27687, -14090, 10252, -1863, -10327, 12076, -18098, 21201, -19523,  5981,   642, -9189, 17941, -12307, 13404, -11306,  5604,  1653, -7060, 12342, -16131,  8488, -6795,  2532,  4515, -1800,  3427, -5728, 10985, },
	{  1649, -1225, -3082, 13265, -7316, 11795, -14595, 12614,  -671, -4235, 11225, -18843, 12242, -12396,  8290,   949, -7401, 15451, -22516, 25885, -11449,  5918,  3591, -15775, 14025, -18445, 19287, -15100,  2699,  4456, -12682, 20083, -12211, 11813, -8184,  1309,  4003, -9056, 13342, -15535,  7189, -4465,  -617,  7967, -2157,  3522, -5173,  8133, },
	{  1013,   219, -5361, 15656, -7488, 10826, -11672,  7183,  1265, -6399, 12902, -19024, 11041, -9514,  3720,  6622, -10156, 17203, -22232, 22713, -8258,  1386,  8691, -20201, 15147, -17765, 16357, -9954,  -651,  7932, -15392, 21067, -11444,  9605, -4682, -2959,  6076, -10504, 13581, -14099,  5530, -1959, -3625, 10847, -2379,  3420, -4392,  5386, },
	{  1474, -7114, 16974, -28932,  9323, -8285,  1667, 12113, -8101, 13790, -18149, 18566, -6224,  -878, 11720, -24505, 17946, -20731, 18389, -9420, -3088, 13164, -23389, 30805, -16122, 12599, -4388, -7766, 10886, -17188, 20863, -20124,  6919, -1003, -6965, 15531, -11337, 13065, -11923,  7225,   578, -6334, 13023, -19696,  3139, -3445,  2821, 27771, },
	{  2490, -8293, 17235, -26384,  7407, -4651, -3622, 18119, -9271, 13876, -16313, 14178, -2726, -5248, 15981, -27197, 17673, -18137, 13189, -2023, -7258, 16782, -25196, 29603, -13633,  8243,  1281, -13642, 13168, -17992, 19512, -16313,  3912,  2647, -10493, 17972, -11524, 11841, -9146,  3098,  3008, -8605, 14403, -19252,  2705, -2392,   506, 27135, },
	{  3231, -8885, 16511, -22566,  5213,  -989, -8406, 22802, -9871, 13193, -13662,  9198,   779, -9157, 19202, -28293, 16436, -14629,  7429,  5257, -10903, 19369, -25562, 26799, -10457,  3544,  6736, -18620, 14667, -17783, 17115, -11689,   758,  6067, -13360, 19364, -11071,  9995, -5936, -1087,  5201, -10329, 14943, -17776,  2148, -1296, -1503, 26005, },
	{  3688, -8914, 14930, -17789,  2882,  2497, -12446, 25973, -9897, 11816, -10379,  3926,  4096, -12409, 21243, -27791, 14336, -10432,  1444, 12021, -13837, 20812, -24508, 22592, -6788, -1229, 11681, -22447, 15320, -16597, 13829, -6527, -2365,  9073, -15422, 19654, -10018,  7642, -2482, -5098,  7043, -11430, 14643, -15395,  1506,  -215, -3166, 24418, },
	{  3867, -8436, 12654, -12395,   553,  5624, -15563, 27539, -9375,  9854, -6674, -1333,  7051, -14848, 22036, -25774, 11519, -5800, -4427, 17912, -15919, 21065, -22130, 17254, -2842, -5810, 15856, -24939, 15111, -14522,  9857, -1125, -5285, 11508, -16586, 18853, -8438,  4926,  1021, -8719,  8444, -11868, 13552, -12275,   817,   796, -4454, 22427, },
	{  3794, -7530,  9875, -6734, -1642,  8239, -17637, 27500, -8364,  7445, -2772, -6289,  9495, -16372, 21585, -22410,  8165, -1003, -9865, 22631, -17061, 20148, -18599, 11110,  1155, -9952, 19050, -25993, 14073, -11695,  5433,  4214, -7845, 13252, -16807, 17030, -6429,  2004,  4378, -11763,  9340, -11639, 11756, -8616,   119,  1692, -5355, 20098, },
	{  3506, -6296,  6795, -1147, -3591, 10231, -18614, 25948, -6945,  4744,  1103, -10682, 11313, -16934, 19962, -17934,  4478,  3687, -14582, 25953, -17226, 18146, -14141,  4522,  4982, -13436, 21111, -25585, 12282, -8290,   814,  9196, -9914, 14224, -16094, 14309, -4113,  -957,  7409, -14078,  9696, -10778,  9380, -4639,  -549,  2434, -5874, 17506, },
	{  3050, -4839,  3618,  4056, -5202, 11527, -18506, 23051, -5216,  1913,  4737, -14292, 12432, -16540, 17300, -12633,   674,  8015, -18341, 27740, -16437, 15202, -9030, -2133,  8431, -16088, 21954, -23774,  9858, -4508, -3742, 13554, -11386, 14388, -14510, 10861, -1625, -3793,  9954, -15555,  9508, -9352,  6573,  -571, -1153,  2994, -6027, 14735, },
	{  2480, -3271,   534,  8614, -6408, 12102, -17383, 19046, -3291,  -883,  7941, -16956, 12819, -15250, 13787, -6831, -3033, 11754, -20965, 27941, -14764, 11506, -3567, -8487, 11322, -17782, 21563, -20696,  6947,  -568, -7983, 17061, -12196, 13753, -12160,  6894,   894, -6351, 11886, -16136,  8802, -7455,  3502,  3364, -1665,  3356, -5845, 11871, },
	{  1848, -1696, -2289, 12320, -7172, 11970, -15370, 14217, -1286, -3492, 10557, -18567, 12484, -13173,  9650,  -867, -6441, 14718, -22348, 26594, -12329,  7284,  1938, -14196, 13510, -18449, 19991, -16551,  3725,  3309, -11683, 19545, -12314, 12374, -9194,  2639,  3304, -8496, 13115, -15812,  7631, -5207,   345,  6958, -2061,  3514, -5370,  9003, },
	{  1205,  -209, -4712, 15034, -7482, 11186, -12631,  8878,   683, -5778, 12469, -19084, 11475, -10453,  5141,  4925, -9373, 16769, -22453, 23823, -9288,  2786,  7177, -18963, 14893, -18081, 17356, -11597,   376,  6910, -14651, 20891, -11749, 10343, -5788, -1663,  5475, -10121, 13589, -14625,  6073, -2740, -2724, 10031, -2326,  3471, -4653,  6215, },
	{  1112, -6634, 16683, -29419,  9836, -9364,  3354, 10039, -7631, 13603, -18526, 19753, -7268,   524, 10229, -23368, 17826, -21316, 19827, -11655, -1733, 11869, -22550, 30833, -16724, 13831, -6126, -5824, 10042, -16739, 21051, -21095,  7787, -2141, -5773, 14584, -11148, 13302, -12663,  8447,  -198, -5541, 12435, -19613,  3243, -3750,  3587, 27863, },
	{  2205, -7993, 17264, -27317,  8033, -5783, -2036, 16401, -8971, 13934, -16972, 15605, -3812, -3942, 14772, -26536, 17863, -19042, 14864, -4306, -6021, 15772, -24792, 30150, -14480,  9632,  -455, -11917, 12545, -17852, 20045, -17584,  4861,  1540, -9470, 17329, -11536, 12289, -10054,  4385,  2280, -7960, 14067, -19503,  2853, -2723,  1189, 27385, },
	{  3033, -8764, 16832, -23858,  5909, -2106, -7003, 21515, -9748, 13481, -14554, 10775,  -288, -8016, 18331, -28128, 16915, -15793,  9241,  3054, -9849, 18691, -25603, 27822, -11496,  5010,  5098, -17201, 14294, -17954, 17956, -13182,  1733,  5051, -12557, 19052, -11277, 10623, -6959,   193,  4559, -9862, 14867, -18334,  2331, -1634,  -920, 26403, },
	{  3577, -8962, 15499, -19341,  3605,  1455, -11294, 25166, -9949, 12307, -11444,  5561,  3107, -11489, 20746, -28112, 15066, -11782,  3289, 10018, -13019, 20494, -24979, 24021, -7957,   231, 10230, -21405, 15211, -17061, 14924, -8155, -1418,  8202, -14880, 19683, -10403,  8412, -3559, -3895,  6520, -11161, 14823, -16215,  1711,  -543, -2693, 24952, },
	{  3840, -8633, 13417, -14099,  1261,  4710, -14711, 27230, -9591, 10512, -7845,   266,  6190, -14191, 21926, -26547, 12452, -7255, -2653, 16212, -15376, 21114, -22994, 18998, -4072, -4437, 14668, -24322, 15266, -15248, 11139, -2794, -4418, 10828, -16327, 19213, -8975,  5791,   -50, -7659,  8065, -11805, 13967, -13302,  1031,   495, -4098, 23079, },
	{  3841, -7849, 10772, -8483,  -988,  7496, -17114, 27679, -8723,  8225, -3980, -4813,  8805, -16005, 21853, -23576,  9242, -2480, -8256, 21318, -16813, 20551, -19796, 13065,   -67, -8738, 18182, -25825, 14477, -12635,  6827,  2596, -7104, 12795, -16840, 17693, -7086,  2915,  3372, -10898,  9121, -11779, 12377, -9786,   332,  1431, -5119, 20846, },
	{  3615, -6704,  7762, -2839, -3024,  9689, -18431, 26578, -7419,  5596,   -73, -9404, 10826, -16864, 20579, -19413,  5635,  2271, -13222, 25090, -17279, 18870, -15596,  6574,  3836, -12446, 20604, -25864, 12907, -9387,  2240,  7718, -9337, 14010, -16410, 15232, -4850,   -52,  6521, -13451,  9645, -11107, 10165, -5883,  -349,  2224, -5755, 18326, },
	{  3205, -5304,  4594,  2513, -4747, 11205, -18652, 24073, -5775,  2788,  3656, -13276, 12165, -16760, 18219, -14333,  1844,  6736, -17298, 27359, -16778, 16198, -10655,  -101,  7421, -15369, 21827, -24474, 10663, -5699, -2362, 12294, -11002, 14423, -15085, 11987, -2400, -2943,  9231, -15194,  9623, -9846,  7473, -1819,  -976,  2843, -6017, 15601, },
	{  2665, -3759,  1462,  7294, -6083, 12002, -17830, 20380, -3898,   -36,  7011, -16245, 12778, -15737, 14946, -8650, -1915, 10678, -20286, 28047, -15367, 12710, -5266, -6585, 10501, -17368, 21813, -21767,  7885, -1784, -6726, 16084, -12020, 14031, -12957,  8156,   124, -5602, 11363, -16054,  9072, -8082,  4465,  2180, -1519,  3267, -5934, 12757, },
	{  2046, -2175, -1457, 11280, -6985, 12084, -16075, 15772, -1905, -2718,  9823, -18187, 12662, -13888, 10975, -2699, -5435, 13898, -22059, 27167, -13151,  8625,   258, -12527, 12919, -18355, 20595, -17926,  4739,  2136, -10615, 18898, -12352, 12872, -10162,  3964,  2582, -7887, 12816, -16006,  8037, -5928,  1315,  5900, -1952,  3487, -5545,  9881, },
	{  1402,  -652, -4016, 14310, -7435, 11492, -13539, 10556,    87, -5116, 11961, -19041, 11852, -11348,  6553,  3181, -8531, 16242, -22556, 24817, -10277,  4184,  5610, -17612, 14557, -18303, 18271, -13191,  1408,  5843, -13826, 20602, -11993, 11030, -6871,  -349,  4839, -9682, 13525, -15078,  6588, -3514, -1800,  9150, -2259,  3505, -4896,  7059, },
	{   727, -6101, 16291, -29755, 10305, -10413,  5054,  7875, -7113, 13339, -18808, 20849, -8286,  1941,  8666, -22093, 17609, -21793, 21172, -13850,  -356, 10499, -21583, 30697, -17242, 14998, -7846, -3836,  9139, -16197, 21128, -21961,  8620, -3277, -4543, 13553, -10899, 13470, -13343,  9635,  -980, -4711, 11774, -19423,  3332, -4044,  4374, 27907, },
	{  1896, -7637, 17197, -28120,  8628, -6905,  -410, 14564, -8617, 13917, -17549, 16967, -4892, -2599, 13470, -25726, 17959, -19854, 16476, -6588, -4741, 14668, -24252, 30541, -15257, 10981, -2202, -10114, 11850, -17617, 20475, -18770,  5791,   416, -8389, 16588, -11486, 12674, -10917,  5660,  1533, -7266, 13652, -19653,  2989, -3049,  1898, 27587, },
	{  2808, -8589, 17067, -25050,  6589, -3235, -5536, 20089, -9571, 13701, -15381, 12316, -1368, -6818, 17352, -27810, 17307, -16885, 11022,   813, -8733, 17906, -25508, 28705, -12483,  6462,  3421, -15679, 13841, -18031, 18707, -14616,  2706,  4000, -11682, 18636, -11424, 11199, -7952,  1483,  3886, -9338, 14711, -18801,  2503, -1972,  -305, 26757, },
	{  3440, -8960, 15997, -20824,  4325,   384, -10059, 24207, -9948, 12740, -12463,  7188,  2087, -10495, 20131, -28286, 15724, -13083,  5135,  7941, -12124, 20063, -25321, 25333, -9093,  1702,  8713, -20240, 15020, -17438, 15947, -9751,  -456,  7281, -14254, 19607, -10734,  9142, -4626, -2662,  5957, -10830, 14925, -16959,  1909,  -875, -2185, 25446, },
	{  3788, -8786, 14127, -15768,  1978,  3751, -13762, 26767, -9758, 11123, -8992,  1886,  5285, -13450, 21697, -27187, 13328, -8687,  -846, 14408, -14745, 21050, -23742, 20656, -5291, -3028, 13391, -23571, 15341, -15897, 12370, -4461, -3521, 10084, -15980, 19473, -9468,  6632, -1130, -6548,  7638, -11678, 14313, -14272,  1244,   185, -3706, 23696, },
	{  3867, -8133, 11634, -10230,  -313,  6697, -16489, 27711, -9040,  8972, -5184, -3290,  8059, -15546, 22007, -24628, 10281, -3959, -6587, 19879, -16473, 20847, -20897, 14967, -1298, -7468, 17211, -25518, 14807, -13515,  8195,   953, -6320, 12266, -16783, 18267, -7709,  3817,  2340, -9968,  8851, -11858, 12938, -10920,   547,  1157, -4846, 21567, },
	{  3706, -7089,  8715, -4559, -2426,  9084, -18143, 27075, -7861,  6432, -1266, -8058, 10273, -16703, 21093, -20806,  6774,   828, -11778, 24083, -17240, 19500, -16980,  8609,  2659, -11380, 19983, -26007, 13467, -10443,  3665,  6188, -8706, 13720, -16641, 16081, -5567,   861,  5591, -12747,  9542, -11380, 10904, -7112,  -143,  1997, -5600, 19128, },
	{  3348, -5756,  5574,   915, -4255, 10814, -18699, 24981, -6311,  3661,  2540, -12173, 11829, -16893, 19052, -15976,  3017,  5407, -16152, 26827, -17033, 17116, -12237,  1950,  6364, -14563, 21582, -25048, 11417, -6868,  -960, 10959, -10555, 14383, -15583, 13058, -3169, -2071,  8453, -14749,  9687, -10292,  8343, -3073,  -790,  2672, -5975, 16457, },
	{  2842, -4243,  2411,  5898, -5716, 11834, -18189, 21627, -4493,   825,  6030, -15436, 12668, -16145, 16038, -10443,  -775,  9534, -19492, 28005, -15892, 13858, -6953, -4632,  9618, -16857, 21948, -22730,  8787, -2999, -5423, 15014, -11779, 14236, -13689,  9385,  -652, -4817, 10776, -15886,  9296, -8672,  5413,   970, -1362,  3158, -5995, 13639, },
	{  2242, -2660,  -591, 10149, -6756, 12133, -16706, 17270, -2523, -1916,  9024, -17704, 12774, -14537, 12257, -4538, -4389, 12995, -21648, 27601, -13910,  9931, -1437, -10776, 12253, -18162, 21093, -19215,  5735,   943, -9482, 18145, -12324, 13306, -11083,  5279,  1841, -7231, 12446, -16117,  8403, -6625,  2288,  4797, -1832,  3441, -5694, 10764, },
	{  1600, -1109, -3275, 13487, -7345, 11742, -14392, 12206,  -519, -4416, 11381, -18896, 12171, -12193,  7946,  1399, -7634, 15621, -22539, 25687, -11221,  5573,  4000, -16155, 14141, -18429, 19095, -14726,  2441,  4738, -12921, 20201, -12176, 11663, -7926,   977,  4174, -9188, 13388, -15454,  7073, -4276,  -855,  8210, -2179,  3521, -5120,  7917, },
	{   965,   323, -5515, 15796, -7483, 10728, -11425,  6758,  1408, -6547, 12999, -18993, 10924, -9273,  3364,  7039, -10342, 17296, -22159, 22418, -7996,  1036,  9061, -20493, 15198, -17672, 16095, -9537,  -906,  8180, -15564, 21093, -11358,  9414, -4403, -3279,  6221, -10590, 13568, -13956,  5390, -1764, -3846, 11041, -2391,  3405, -4324,  5181, },
	{  1562, -7226, 17031, -28788,  9189, -8011,  1249, 12616, -8211, 13825, -18040, 18256, -5960, -1225, 12080, -24767, 17960, -20569, 18016, -8857, -3423, 13475, -23578, 30773, -15959, 12282, -3951, -8244, 11087, -17286, 20799, -19865,  6696,  -718, -7255, 15753, -11374, 12995, -11728,  6915,   771, -6526, 13159, -19701,  3111, -3366,  2634, 27740, },
	{  2557, -8359, 17213, -26132,  7247, -4368, -4012, 18529, -9338, 13850, -16136, 13812, -2454, -5568, 16268, -27339, 17611, -17897, 12762, -1453, -7560, 17019, -25276, 29442, -13411,  7890,  1712, -14061, 13312, -18012, 19363, -15982,  3672,  2921, -10739, 18117, -11512, 11720, -8912,  2775,  3187, -8758, 14475, -19174,  2666, -2309,   340, 27065, },
	{  3276, -8906, 16418, -22229,  5037,  -712, -8746, 23101, -9893, 13110, -13429,  8799,  1043, -9433, 19402, -28311, 16304, -14328,  6972,  5801, -11156, 19521, -25531, 26522, -10190,  3176,  7138, -18958, 14748, -17725, 16892, -11307,   514,  6315, -13548, 19426, -11011,  9830, -5677, -1404,  5356, -10437, 14949, -17623,  2102, -1212, -1644, 25898, },
	{  3711, -8894, 14777, -17392,  2701,  2753, -12721, 26151, -9875, 11684, -10106,  3517,  4339, -12627, 21348, -27687, 14143, -10087,   984, 12510, -14029, 20874, -24370, 22218, -6491, -1592, 12033, -22688, 15334, -16467, 13545, -6116, -2599,  9282, -15545, 19631, -9914,  7444, -2212, -5393,  7168, -11488, 14586, -15179,  1454,  -134, -3278, 24278, },
	{  3870, -8380, 12456, -11964,   378,  5845, -15761, 27592, -9314,  9683, -6378, -1728,  7259, -14999, 22045, -25561, 11277, -5433, -4865, 18320, -16041, 21035, -21897, 16806, -2534, -6148, 16139, -25072, 15060, -14329,  9529,  -708, -5496, 11668, -16637, 18748, -8297,  4706,  1287, -8976,  8532, -11874, 13437, -12010,   763,   870, -4537, 22259, },
	{  3779, -7446,  9646, -6298, -1802,  8416, -17751, 27433, -8268,  7246, -2470, -6650,  9658, -16450, 21500, -22102,  7890,  -635, -10257, 22938, -17108, 20031, -18285, 10614,  1459, -10246, 19251, -26013, 13960, -11451,  5081,  4613, -8024, 13355, -16785, 16850, -6260,  1775,  4625, -11969,  9387, -11595, 11592, -8319,    66,  1755, -5409, 19907, },
	{  3476, -6190,  6552,  -730, -3728, 10356, -18644, 25770, -6821,  4528,  1394, -10990, 11425, -16937, 19792, -17552,  4187,  4036, -14907, 26146, -17199, 17951, -13767,  4008,  5263, -13672, 21220, -25494, 12117, -8009,   458,  9556, -10049, 14265, -16002, 14067, -3926, -1182,  7623, -14222,  9701, -10688,  9177, -4326,  -598,  2484, -5899, 17298, },
	{  3010, -4721,  3375,  4433, -5310, 11597, -18454, 22779, -5074,  1695,  5001, -14533, 12488, -16471, 17057, -12201,   383,  8326, -18585, 27812, -16338, 14942, -8618, -2637,  8675, -16253, 21967, -23580,  9649, -4208, -4082, 13856, -11473, 14367, -14355, 10572, -1430, -4001, 10126, -15632,  9472, -9221,  6344,  -261, -1196,  3029, -6025, 14517, },
	{  2433, -3148,   305,  8932, -6483, 12117, -17258, 18700, -3138, -1092,  8165, -17118, 12819, -15117, 13488, -6374, -3308, 12012, -21117, 27891, -14602, 11197, -3141, -8953, 11517, -17870, 21483, -20412,  6708,  -265, -8290, 17290, -12230, 13672, -11952,  6574,  1085, -6532, 12007, -16143,  8728, -7293,  3260,  3655, -1699,  3376, -5818, 11650, },
	{  1799, -1577, -2491, 12565, -7212, 11932, -15182, 13820, -1132, -3681, 10730, -18646, 12429, -12984,  9313,  -411, -6686, 14910, -22402, 26429, -12114,  6945,  2354, -14599, 13646, -18458, 19824, -16195,  3469,  3598, -11940, 19690, -12294, 12239, -8945,  2307,  3481, -8641, 13178, -15750,  7524, -5023,   103,  7215, -2086,  3517, -5323,  8785, },
	{  1157,  -100, -4879, 15199, -7488, 11101, -12396,  8456,   830, -5937, 12584, -19078, 11371, -10222,  4787,  5354, -9575, 16887, -22409, 23556, -9034,  2436,  7561, -19283, 14964, -18011, 17114, -11190,   118,  7170, -14844, 20945, -11678, 10163, -5514, -1989,  5628, -10222, 13594, -14500,  5940, -2546, -2952, 10241, -2340,  3460, -4589,  6006, },
	{  1204, -6759, 16766, -29311,  9711, -9097,  2931, 10566, -7754, 13657, -18440, 19464, -7009,   172, 10609, -23666, 17865, -21180, 19475, -11100, -2074, 12200, -22772, 30842, -16582, 13529, -5693, -6315, 10259, -16860, 21014, -20862,  7573, -1857, -6075, 14829, -11201, 13249, -12484,  8145,    -3, -5743, 12589, -19643,  3219, -3675,  3393, 27845, },
	{  2279, -8073, 17265, -27095,  7879, -5500, -2437, 16842, -9051, 13926, -16815, 15254, -3541, -4272, 15083, -26716, 17825, -18824, 14451, -3735, -6335, 16033, -24906, 30028, -14275,  9288,   -20, -12356, 12707, -17896, 19922, -17273,  4625,  1818, -9731, 17499, -11539, 12183, -9831,  4064,  2464, -8126, 14159, -19449,  2817, -2641,  1015, 27327, },
	{  3085, -8799, 16760, -23544,  5737, -1826, -7360, 21850, -9784, 13415, -14337, 10384,   -20, -8307, 18559, -28184, 16803, -15509,  8791,  3609, -10119, 18870, -25606, 27579, -11241,  4645,  5512, -17566, 14394, -17920, 17754, -12814,  1489,  5308, -12765, 19140, -11231, 10470, -6706,  -128,  4722, -9985, 14893, -18203,  2286, -1550, -1069, 26308, },
	{  3607, -8955, 15363, -18959,  3424,  1719, -11590, 25382, -9941, 12190, -11182,  5152,  3357, -11726, 20881, -28045, 14890, -11449,  2827, 10526, -13231, 20584, -24873, 23674, -7667,  -135, 10600, -21677, 15246, -16953, 14657, -7751, -1656,  8425, -15023, 19686, -10311,  8223, -3290, -4199,  6654, -11234, 14785, -16017,  1660,  -460, -2814, 24822, },
	{  3849, -8587, 13231, -13676,  1083,  4943, -14933, 27321, -9542, 10352, -7555,  -136,  6410, -14363, 21965, -26366, 12223, -6893, -3100, 16647, -15520, 21112, -22788, 18570, -3766, -4784, 14973, -24489, 15235, -15073, 10823, -2377, -4637, 11004, -16400, 19132, -8844,  5577,   219, -7929,  8164, -11827, 13870, -13050,   978,   572, -4191, 22919, },
	{  3831, -7772, 10550, -8046, -1153,  7688, -17255, 27648, -8637,  8033, -3678, -5186,  8983, -16105, 21797, -23295,  8976, -2110, -8664, 21659, -16883, 20460, -19505, 12581,   240, -9047, 18409, -25880, 14383, -12406,  6481,  3003, -7294, 12916, -16840, 17535, -6924,  2688,  3626, -11121,  9180, -11750, 12227, -9497,   279,  1498, -5182, 20661, },
	{  3589, -6604,  7522, -2413, -3168,  9831, -18487, 26433, -7304,  5384,   223, -9730, 10954, -16890, 20434, -19051,  5347,  2628, -13570, 25319, -17275, 18698, -15238,  6062,  4125, -12700, 20742, -25807, 12757, -9116,  1883,  8092, -9486, 14071, -16339, 15008, -4668,  -279,  6747, -13615,  9662, -11030,  9973, -5573,  -399,  2278, -5788, 18123, },
	{  3168, -5189,  4349,  2904, -4864, 11292, -18625, 23828, -5637,  2569,  3930, -13538, 12239, -16713, 17997, -13913,  1551,  7061, -17568, 27468, -16701, 15956, -10252,  -611,  7679, -15557, 21869, -24310, 10466, -5403, -2710, 12616, -11104, 14422, -14948, 11711, -2207, -3158,  9417, -15292,  9599, -9727,  7250, -1506, -1021,  2882, -6023, 15386, },
	{  2619, -3637,  1228,  7631, -6168, 12034, -17727, 20055, -3747,  -249,  7249, -16432, 12795, -15623, 14662, -8197, -2197, 10954, -20467, 28034, -15223, 12414, -4842, -7066, 10713, -17480, 21761, -21509,  7653, -1479, -7045, 16337, -12071, 13968, -12763,  7844,   317, -5793, 11500, -16082,  9009, -7929,  4225,  2479, -1556,  3291, -5915, 12536, },
	{  1997, -2055, -1668, 11549, -7036, 12061, -15905, 15389, -1750, -2914, 10012, -18292, 12623, -13715, 10648, -2240, -5691, 14111, -22142, 27037, -12951,  8292,   680, -12952, 13073, -18388, 20454, -17590,  4487,  2431, -10888, 19069, -12348, 12754, -9924,  3634,  2764, -8044, 12897, -15965,  7939, -5750,  1072,  6169, -1981,  3496, -5503,  9661, },
	{  1352,  -540, -4194, 14500, -7450, 11421, -13317, 10138,   237, -5285, 12095, -19062, 11763, -11129,  6201,  3620, -8747, 16382, -22541, 24579, -10034,  3835,  6006, -17960, 14649, -18256, 18051, -12797,  1150,  6114, -14040, 20684, -11938, 10863, -6603,  -679,  5001, -9797, 13548, -14972,  6462, -3322, -2033,  9376, -2277,  3498, -4837,  6847, },
	{   825, -6239, 16398, -29685, 10192, -10153,  4629,  8424, -7247, 13412, -18747, 20584, -8034,  1586,  9064, -22424, 17673, -21684, 20845, -13306,  -702, 10848, -21837, 30746, -17121, 14713, -7418, -4337,  9370, -16341, 21119, -21755,  8416, -2994, -4854, 13818, -10967, 13435, -13179,  9341,  -784, -4922, 11946, -19480,  3311, -3972,  4175, 27900, },
	{  1975, -7731, 17223, -27932,  8482, -6625,  -820, 15034, -8711, 13928, -17413, 16633, -4623, -2938, 13804, -25942, 17944, -19660, 16080, -6018, -5065, 14952, -24400, 30459, -15070, 10648, -1765, -10571, 12030, -17685, 20378, -18482,  5560,   698, -8664, 16782, -11504, 12584, -10706,  5343,  1721, -7444, 13763, -19625,  2956, -2968,  1718, 27541, },
	{  2867, -8638, 17017, -24762,  6421, -2952, -5909, 20458, -9620, 13652, -15180, 11935, -1097, -7122, 17607, -27904, 17217, -16619, 10580,  1377, -9018, 18112, -25545, 28497, -12241,  6101,  3844, -16068, 13962, -18020, 18528, -14264,  2464,  4266, -11908, 18749, -11393, 11060, -7707,  1160,  4057, -9474, 14758, -18693,  2461, -1888,  -462, 26673, },
	{  3477, -8965, 15879, -20460,  4145,   654, -10375, 24461, -9953, 12637, -12213,  6782,  2344, -10750, 20296, -28257, 15566, -12763,  4674,  8466, -12355, 20181, -25248, 25017, -8812,  1334,  9098, -20542, 15075, -17352, 15698, -9356,  -698,  7516, -14418, 19636, -10656,  8963, -4360, -2973,  6101, -10918, 14907, -16781,  1860,  -792, -2316, 25326, },
	{  3804, -8752, 13955, -15355,  1799,  3995, -14008, 26897, -9721, 10975, -8708,  1479,  5515, -13643, 21765, -27040, 13115, -8332, -1300, 14868, -14910, 21077, -23566, 20250, -4988, -3383, 13718, -23771, 15330, -15742, 12068, -4045, -3748, 10276, -16075, 19417, -9349,  6424,  -859, -6830,  7749, -11716, 14233, -14035,  1191,   263, -3808, 23545, },
	{  3863, -8065, 11422, -9794,  -484,  6902, -16655, 27717, -8965,  8789, -4884, -3675,  8250, -15669, 21980, -24376, 10025, -3590, -7009, 20251, -16566, 20783, -20631, 14497,  -990, -7791, 17463, -25608, 14731, -13301,  7856,  1365, -6520, 12405, -16806, 18132, -7557,  3593,  2600, -10206,  8923, -11844, 12804, -10640,   493,  1227, -4918, 21389, },
	{  3685, -6995,  8478, -4127, -2578,  9241, -18225, 26963, -7754,  6225,  -967, -8401, 10417, -16752, 20975, -20466,  6491,  1190, -12147, 24348, -17258, 19351, -16641,  8102,  2956, -11653, 20149, -25984, 13334, -10183,  3310,  6575, -8868, 13800, -16591, 15876, -5390,   632,  5828, -12930,  9572, -11317, 10723, -6806,  -195,  2056, -5642, 18929, },
	{  3313, -5644,  5329,  1319, -4381, 10918, -18696, 24765, -6179,  3443,  2822, -12457, 11920, -16868, 18852, -15571,  2724,  5744, -16448, 26974, -16977, 16894, -11846,  1436,  6632, -14772, 21654, -24917, 11234, -6578, -1312, 11299, -10672, 14400, -15466, 12796, -2977, -2291,  8652, -14868,  9676, -10185,  8128, -2759,  -837,  2716, -5989, 16244, },
	{  2798, -4122,  2172,  6254, -5812, 11883, -18108, 21324, -4345,   609,  6280, -15647, 12702, -16051, 15772, -9997, -1061,  9826, -19701, 28029, -15768, 13577, -6533, -5125,  9844, -16994, 21925, -22500,  8565, -2696, -5753, 15290, -11845, 14192, -13512,  9081,  -458, -5017, 10928, -15936,  9244, -8528,  5178,  1275, -1402,  3187, -5982, 13419, },
	{  2193, -2538,  -811, 10440, -6817, 12127, -16555, 16901, -2369, -2119,  9229, -17834, 12752, -14381, 11941, -4078, -4654, 13228, -21762, 27506, -13726,  9608, -1012, -11221, 12426, -18219, 20979, -18901,  5488,  1243, -9771, 18343, -12337, 13204, -10858,  4951,  2028, -7399, 12545, -16097,  8315, -6453,  2045,  5077, -1863,  3454, -5659, 10543, },
	{  1550,  -993, -3464, 13702, -7371, 11685, -14184, 11797,  -366, -4594, 11532, -18942, 12097, -11987,  7600,  1847, -7863, 15785, -22555, 25481, -10990,  5227,  4406, -16529, 14253, -18407, 18898, -14348,  2183,  5017, -13154, 20312, -12136, 11510, -7665,   644,  4343, -9316, 13429, -15367,  6955, -4087, -1093,  8451, -2200,  3518, -5066,  7701, },
	{   918,   426, -5666, 15929, -7476, 10627, -11176,  6332,  1550, -6693, 13091, -18956, 10804, -9029,  3008,  7451, -10524, 17383, -22078, 22116, -7731,   687,  9426, -20777, 15243, -17573, 15827, -9117, -1161,  8424, -15731, 21112, -11269,  9220, -4123, -3598,  6364, -10673, 13550, -13809,  5249, -1568, -4065, 11231, -2401,  3388, -4255,  4978, },
	{  1647, -7334, 17082, -28634,  9052, -7737,   831, 13113, -8317, 13855, -17926, 17941, -5695, -1571, 12436, -25021, 17969, -20399, 17639, -8291, -3755, 13781, -23759, 30730, -15791, 11962, -3514, -8717, 11284, -17377, 20728, -19600,  6473,  -434, -7543, 15971, -11408, 12921, -11531,  6604,   962, -6715, 13289, -19698,  3082, -3288,  2447, 27706, },
	{  2622, -8422, 17185, -25872,  7084, -4085, -4398, 18931, -9401, 13819, -15954, 13443, -2182, -5885, 16548, -27471, 17544, -17652, 12331,  -885, -7858, 17250, -25347, 29271, -13184,  7536,  2142, -14474, 13451, -18025, 19208, -15648,  3432,  3193, -10981, 18256, -11496, 11595, -8675,  2452,  3364, -8908, 14541, -19089,  2626, -2225,   176, 26993, },
	{  3320, -8925, 16320, -21885,  4860,  -436, -9081, 23391, -9912, 13024, -13193,  8398,  1306, -9705, 19595, -28319, 16166, -14022,  6514,  6341, -11405, 19667, -25491, 26237, -9919,  2808,  7537, -19289, 14823, -17662, 16663, -10923,   271,  6561, -13732, 19481, -10947,  9662, -5416, -1721,  5510, -10541, 14950, -17465,  2054, -1127, -1782, 25789, },
	{  3733, -8872, 14620, -16991,  2520,  3006, -12990, 26319, -9851, 11549, -9831,  3109,  4579, -12840, 21447, -27576, 13945, -9741,   525, 12993, -14216, 20928, -24224, 21837, -6193, -1953, 12380, -22921, 15344, -16332, 13257, -5704, -2831,  9488, -15662, 19601, -9807,  7244, -1941, -5685,  7289, -11541, 14525, -14958,  1402,   -54, -3389, 24136, },
	{  3871, -8322, 12254, -11532,   204,  6063, -15952, 27636, -9250,  9509, -6081, -2122,  7464, -15144, 22047, -25339, 11033, -5066, -5300, 18721, -16158, 20998, -21657, 16353, -2225, -6482, 16416, -25197, 15004, -14132,  9199,  -292, -5706, 11824, -16682, 18637, -8154,  4485,  1552, -9230,  8616, -11876, 13318, -11742,   709,   943, -4618, 22089, },
	{  3762, -7359,  9415, -5862, -1960,  8588, -17859, 27356, -8170,  7045, -2168, -7008,  9818, -16522, 21409, -21787,  7614,  -268, -10644, 23237, -17150, 19907, -17967, 10116,  1761, -10536, 19444, -26025, 13844, -11204,  4729,  5011, -8199, 13453, -16757, 16666, -6089,  1547,  4870, -12170,  9430, -11547, 11425, -8019,    14,  1817, -5460, 19714, },
	{  3445, -6083,  6308,  -315, -3863, 10477, -18667, 25584, -6696,  4312,  1683, -11293, 11532, -16934, 19616, -17165,  3895,  4382, -15227, 26330, -17166, 17750, -13390,  3493,  5542, -13902, 21321, -25395, 11947, -7727,   102,  9913, -10181, 14302, -15905, 13821, -3738, -1405,  7835, -14362,  9702, -10594,  8972, -4013,  -647,  2533, -5921, 17089, },
	{  2969, -4602,  3133,  4805, -5415, 11663, -18397, 22501, -4930,  1477,  5262, -14767, 12540, -16398, 16810, -11765,    92,  8634, -18822, 27874, -16234, 14677, -8205, -3139,  8916, -16413, 21973, -23378,  9437, -3906, -4421, 14154, -11555, 14341, -14195, 10279, -1236, -4208, 10294, -15703,  9432, -9088,  6113,    48, -1238,  3063, -6020, 14298, },
	{  2386, -3026,    79,  9244, -6555, 12127, -17128, 18349, -2985, -1300,  8385, -17274, 12814, -14979, 13186, -5916, -3581, 12265, -21261, 27832, -14436, 10885, -2715, -9415, 11707, -17952, 21396, -20122,  6467,    38, -8593, 17513, -12260, 13587, -11740,  6252,  1275, -6711, 12123, -16144,  8651, -7129,  3018,  3944, -1734,  3394, -5790, 11428, },
	{  1749, -1459, -2691, 12805, -7249, 11890, -14991, 13421,  -978, -3868, 10899, -18718, 12371, -12792,  8974,    44, -6927, 15096, -22447, 26256, -11896,  6604,  2768, -14997, 13777, -18460, 19651, -15835,  3213,  3886, -12192, 19828, -12271, 12101, -8694,  1974,  3657, -8782, 13238, -15684,  7415, -4838,  -137,  7469, -2110,  3520, -5274,  8567, },
	{  1109,     7, -5042, 15358, -7490, 11012, -12157,  8032,   976, -6094, 12695, -19066, 11265, -9989,  4431,  5780, -9772, 16998, -22357, 23282, -8778,  2085,  7941, -19596, 15030, -17935, 16867, -10781,  -139,  7427, -15032, 20993, -11604,  9980, -5238, -2314,  5780, -10320, 13594, -14371,  5805, -2351, -3178, 10447, -2354,  3448, -4524,  5798, },
	{  1296, -6881, 16842, -29194,  9585, -8828,  2509, 11088, -7873, 13706, -18349, 19170, -6749,  -179, 10984, -23954, 17898, -21037, 19119, -10542, -2414, 12527, -22985, 30840, -16434, 13223, -5259, -6802, 10472, -16975, 20971, -20622,  7357, -1572, -6374, 15068, -11250, 13192, -12300,  7840,   191, -5942, 12739, -19668,  3193, -3599,  3201, 27823, },
	{  2351, -8150, 17261, -26866,  7724, -5218, -2835, 17275, -9128, 13914, -16653, 14899, -3270, -4600, 15389, -26886, 17780, -18601, 14034, -3164, -6646, 16289, -25011, 29896, -14065,  8942,   415, -12790, 12865, -17934, 19791, -16958,  4388,  2096, -9989, 17663, -11538, 12073, -9605,  3743,  2647, -8289, 14245, -19390,  2781, -2558,   844, 27266, },
	{  3136, -8831, 16682, -23224,  5563, -1546, -7713, 22176, -9817, 13345, -14116,  9990,   247, -8594, 18780, -28230, 16686, -15220,  8338,  4161, -10384, 19043, -25600, 27327, -10983,  4279,  5923, -17924, 14490, -17880, 17547, -12443,  1246,  5563, -12968, 19221, -11182, 10315, -6451,  -448,  4884, -10103, 14915, -18066,  2241, -1465, -1216, 26209, },
	{  3636, -8944, 15223, -18573,  3244,  1980, -11881, 25588, -9929, 12069, -10917,  4744,  3606, -11958, 21009, -27970, 14710, -11112,  2366, 11029, -13438, 20667, -24759, 23321, -7376,  -501, 10965, -21941, 15276, -16840, 14385, -7345, -1893,  8644, -15162, 19682, -10217,  8031, -3021, -4501,  6787, -11304, 14742, -15814,  1609,  -378, -2934, 24690, },
	{  3857, -8539, 13042, -13251,   906,  5173, -15149, 27403, -9489, 10189, -7262,  -537,  6627, -14530, 21996, -26177, 11992, -6530, -3545, 17075, -15659, 21103, -22576, 18136, -3458, -5128, 15273, -24648, 15198, -14894, 10503, -1959, -4855, 11176, -16468, 19045, -8711,  5361,   487, -8196,  8260, -11844, 13768, -12795,   924,   647, -4281, 22757, },
	{  3820, -7694, 10327, -7608, -1318,  7875, -17389, 27608, -8549,  7839, -3376, -5557,  9157, -16200, 21733, -23007,  8707, -1741, -9068, 21991, -16948, 20362, -19209, 12094,   546, -9353, 18630, -25926, 14284, -12172,  6133,  3409, -7481, 13032, -16834, 17372, -6761,  2460,  3878, -11339,  9237, -11717, 12074, -9205,   225,  1563, -5242, 20475, },
	{  3562, -6503,  7280, -1989, -3311,  9968, -18536, 26279, -7186,  5172,   517, -10052, 11078, -16910, 20283, -18684,  5058,  2983, -13913, 25539, -17264, 18520, -14877,  5550,  4413, -12951, 20872, -25741, 12602, -8843,  1527,  8464, -9632, 14126, -16263, 14779, -4484,  -506,  6970, -13774,  9677, -10950,  9778, -5262,  -449,  2331, -5819, 17918, },
	{  3129, -5073,  4105,  3292, -4979, 11375, -18591, 23576, -5498,  2350,  4202, -13795, 12307, -16661, 17770, -13490,  1258,  7382, -17832, 27568, -16618, 15709, -9847, -1120,  7933, -15740, 21905, -24139, 10266, -5105, -3055, 12933, -11202, 14415, -14806, 11431, -2013, -3371,  9599, -15385,  9572, -9605,  7026, -1194, -1065,  2921, -6026, 15169, },
	{  2573, -3515,   995,  7964, -6251, 12061, -17618, 19724, -3596,  -461,  7483, -16613, 12807, -15503, 14375, -7743, -2477, 11225, -20641, 28012, -15075, 12115, -4418, -7543, 10920, -17587, 21702, -21244,  7420, -1175, -7361, 16585, -12117, 13901, -12566,  7529,   510, -5981, 11633, -16105,  8943, -7773,  3985,  2776, -1593,  3314, -5893, 12314, },
	{  1947, -1934, -1878, 11812, -7084, 12035, -15731, 15001, -1595, -3108, 10198, -18390, 12581, -13538, 10318, -1781, -5944, 14319, -22219, 26898, -12747,  7958,  1101, -13372, 13224, -18414, 20306, -17249,  4234,  2725, -11158, 19234, -12341, 12631, -9684,  3303,  2946, -8198, 12974, -15919,  7839, -5570,   829,  6435, -2008,  3503, -5460,  9441, },
	{  1303,  -428, -4370, 14684, -7464, 11346, -13092,  9720,   387, -5452, 12224, -19075, 11671, -10906,  5849,  4058, -8959, 16517, -22519, 24335, -9788,  3486,  6400, -18301, 14735, -18204, 17825, -12400,   892,  6382, -14248, 20760, -11879, 10693, -6333, -1008,  5161, -9908, 13566, -14861,  6334, -3128, -2265,  9598, -2294,  3490, -4777,  6635, },
	{   922, -6374, 16500, -29606, 10076, -9892,  4203,  8968, -7378, 13480, -18679, 20313, -7781,  1231,  9456, -22747, 17730, -21569, 20511, -12758, -1047, 11193, -22082, 30786, -16994, 14423, -6989, -4836,  9598, -16479, 21104, -21542,  8209, -2710, -5163, 14079, -11031, 13395, -13011,  9046,  -588, -5130, 12113, -19531,  3290, -3899,  3978, 27891, },
	{  2054, -7822, 17243, -27735,  8335, -6345, -1228, 15497, -8801, 13935, -17271, 16294, -4354, -3275, 14133, -26150, 17923, -19460, 15679, -5448, -5386, 15231, -24539, 30366, -14878, 10312, -1328, -11024, 12206, -17747, 20273, -18188,  5328,   979, -8936, 16970, -11518, 12490, -10492,  5024,  1909, -7619, 13869, -19591,  2923, -2887,  1540, 27492, },
	{  2924, -8684, 16960, -24467,  6251, -2669, -6277, 20819, -9666, 13599, -14976, 11551,  -827, -7424, 17855, -27988, 17122, -16348, 10136,  1938, -9299, 18312, -25573, 28281, -11996,  5738,  4264, -16452, 14077, -18004, 18343, -13907,  2220,  4529, -12129, 18857, -11358, 10918, -7459,   837,  4226, -9607, 14799, -18579,  2418, -1803,  -617, 26586, },
	{  3512, -8968, 15757, -20092,  3966,   923, -10687, 24705, -9955, 12531, -11960,  6376,  2600, -11001, 20453, -28218, 15404, -12439,  4212,  8988, -12581, 20292, -25166, 24692, -8529,   966,  9480, -20837, 15126, -17261, 15444, -8958,  -939,  7748, -14577, 19658, -10575,  8782, -4094, -3282,  6243, -11003, 14883, -16597,  1811,  -709, -2444, 25204, },
	{  3817, -8715, 13779, -14939,  1619,  4236, -14249, 27017, -9681, 10824, -8422,  1074,  5743, -13831, 21826, -26884, 12897, -7975, -1753, 15322, -15071, 21096, -23382, 19839, -4683, -3736, 14040, -23963, 15314, -15582, 11761, -3629, -3973, 10464, -16165, 19356, -9227,  6215,  -589, -7109,  7857, -11749, 14149, -13795,  1138,   341, -3907, 23392, },
	{  3857, -7995, 11207, -9358,  -653,  7104, -16814, 27713, -8887,  8603, -4583, -4057,  8439, -15787, 21945, -24117,  9767, -3220, -7428, 20614, -16654, 20712, -20359, 14024,  -682, -8110, 17709, -25689, 14651, -13083,  7515,  1777, -6717, 12539, -16823, 17992, -7402,  3367,  2859, -10441,  8992, -11826, 12665, -10358,   440,  1296, -4987, 21210, },
	{  3662, -6900,  8241, -3696, -2728,  9395, -18300, 26843, -7645,  6016,  -668, -8739, 10557, -16795, 20849, -20121,  6207,  1552, -12511, 24604, -17271, 19197, -16297,  7594,  3251, -11922, 20308, -25953, 13195, -9921,  2953,  6959, -9028, 13874, -16536, 15666, -5212,   404,  6061, -13108,  9600, -11251, 10540, -6500,  -246,  2113, -5682, 18730, },
	{  3278, -5532,  5084,  1720, -4505, 11018, -18688, 24541, -6046,  3225,  3102, -12735, 12006, -16838, 18647, -15162,  2430,  6077, -16737, 27111, -16916, 16667, -11452,   923,  6898, -14977, 21719, -24777, 11047, -6286, -1664, 11635, -10786, 14413, -15344, 12530, -2786, -2510,  8848, -14982,  9661, -10075,  7912, -2445,  -884,  2760, -6000, 16031, },
	{  2754, -4001,  1934,  6605, -5905, 11927, -18021, 21015, -4197,   393,  6527, -15852, 12732, -15951, 15501, -9550, -1347, 10114, -19903, 28045, -15639, 13292, -6112, -5615, 10067, -17124, 21895, -22262,  8340, -2392, -6080, 15560, -11908, 14143, -13331,  8775,  -263, -5214, 11077, -15981,  9190, -8382,  4941,  1578, -1442,  3215, -5968, 13199, },
	{  2144, -2417, -1028, 10726, -6876, 12117, -16400, 16529, -2214, -2320,  9431, -17959, 12726, -14221, 11622, -3618, -4917, 13456, -21868, 27402, -13539,  9283,  -588, -11661, 12595, -18271, 20857, -18581,  5239,  1541, -10056, 18534, -12346, 13098, -10629,  4623,  2214, -7565, 12639, -16072,  8225, -6280,  1802,  5354, -1893,  3466, -5623, 10322, },
	{  1500,  -879, -3651, 13911, -7395, 11624, -13973, 11385,  -214, -4771, 11680, -18982, 12019, -11777,  7252,  2294, -8089, 15943, -22563, 25268, -10755,  4880,  4810, -16896, 14359, -18378, 18695, -13966,  1925,  5295, -13383, 20415, -12092, 11353, -7402,   313,  4510, -9442, 13465, -15275,  6835, -3897, -1330,  8688, -2220,  3515, -5010,  7486, },
	{   871,   527, -5814, 16056, -7466, 10522, -10924,  5906,  1691, -6836, 13179, -18913, 10681, -8784,  2652,  7860, -10702, 17465, -21990, 21808, -7464,   339,  9788, -21053, 15283, -17468, 15556, -8696, -1414,  8666, -15892, 21125, -11176,  9022, -3841, -3915,  6504, -10752, 13528, -13658,  5107, -1372, -4282, 11416, -2411,  3370, -4186,  4775, },
	{  1732, -7438, 17127, -28471,  8913, -7460,   416, 13603, -8420, 13880, -17806, 17621, -5428, -1915, 12786, -25265, 17972, -20224, 17256, -7725, -4086, 14082, -23932, 30677, -15618, 11638, -3077, -9187, 11477, -17463, 20651, -19329,  6247,  -150, -7828, 16182, -11438, 12843, -11329,  6290,  1153, -6901, 13415, -19690,  3052, -3209,  2263, 27670, },
	{  2686, -8481, 17151, -25605,  6921, -3801, -4781, 19325, -9461, 13784, -15767, 13070, -1911, -6199, 16823, -27594, 17471, -17401, 11898,  -317, -8153, 17475, -25409, 29092, -12954,  7179,  2570, -14881, 13586, -18033, 19047, -15308,  3190,  3464, -11219, 18389, -11476, 11467, -8437,  2129,  3540, -9055, 14603, -18999,  2586, -2141,    14, 26917, },
	{  3362, -8940, 16217, -21537,  4682,  -162, -9412, 23673, -9928, 12933, -12953,  7996,  1568, -9973, 19781, -28318, 16024, -13713,  6055,  6878, -11649, 19806, -25443, 25944, -9646,  2439,  7933, -19613, 14894, -17593, 16429, -10535,    28,  6804, -13911, 19529, -10880,  9492, -5154, -2036,  5661, -10641, 14947, -17302,  2006, -1043, -1919, 25677, },
	{  3753, -8846, 14460, -16586,  2339,  3257, -13253, 26478, -9823, 11410, -9553,  2700,  4816, -13048, 21538, -27455, 13743, -9392,    67, 13470, -14397, 20976, -24071, 21450, -5894, -2313, 12722, -23146, 15348, -16192, 12965, -5291, -3063,  9690, -15773, 19565, -9697,  7042, -1671, -5975,  7409, -11591, 14459, -14734,  1350,    26, -3497, 23992, },
	{  3871, -8261, 12050, -11099,    30,  6277, -16137, 27670, -9183,  9333, -5783, -2514,  7665, -15284, 22041, -25110, 10785, -4697, -5732, 19114, -16268, 20955, -21410, 15895, -1916, -6814, 16687, -25312, 14943, -13931,  8867,   124, -5913, 11976, -16721, 18519, -8008,  4264,  1815, -9479,  8698, -11874, 13196, -11471,   655,  1015, -4696, 21917, },
	{  3745, -7271,  9183, -5427, -2117,  8757, -17960, 27271, -8070,  6842, -1867, -7361,  9973, -16588, 21310, -21466,  7336,    98, -11027, 23528, -17186, 19778, -17643,  9616,  2061, -10822, 19631, -26027, 13723, -10953,  4375,  5406, -8371, 13547, -16724, 16476, -5917,  1318,  5113, -12367,  9471, -11495, 11254, -7718,   -39,  1878, -5509, 19520, },
	{  3414, -5975,  6063,    98, -3996, 10593, -18684, 25391, -6569,  4096,  1970, -11591, 11635, -16926, 19433, -16773,  3603,  4726, -15541, 26505, -17127, 17544, -13009,  2979,  5819, -14127, 21415, -25288, 11774, -7442,  -253, 10266, -10309, 14334, -15803, 13570, -3549, -1628,  8044, -14496,  9700, -10496,  8765, -3700,  -695,  2580, -5941, 16879, },
	{  2927, -4483,  2891,  5174, -5518, 11724, -18333, 22216, -4785,  1259,  5521, -14996, 12587, -16319, 16557, -11327,  -198,  8937, -19052, 27927, -16126, 14408, -7789, -3639,  9154, -16567, 21972, -23170,  9223, -3605, -4757, 14446, -11634, 14311, -14031,  9984, -1041, -4413, 10458, -15769,  9390, -8952,  5881,   357, -1280,  3096, -6013, 14079, },
	{  2338, -2904,  -146,  9551, -6625, 12133, -16992, 17994, -2832, -1507,  8602, -17424, 12805, -14836, 12879, -5457, -3853, 12513, -21397, 27764, -14265, 10570, -2289, -9873, 11894, -18028, 21302, -19825,  6225,   340, -8893, 17730, -12285, 13498, -11525,  5929,  1465, -6887, 12235, -16140,  8571, -6963,  2775,  4231, -1767,  3411, -5760, 11206, },
	{  1699, -1342, -2888, 13038, -7284, 11845, -14795, 13018,  -825, -4052, 11064, -18784, 12308, -12596,  8633,   497, -7166, 15276, -22486, 26075, -11674,  6261,  3181, -15389, 13903, -18455, 19472, -15470,  2956,  4172, -12439, 19959, -12243, 11959, -8440,  1641,  3831, -8921, 13292, -15612,  7303, -4652,  -377,  7719, -2134,  3521, -5224,  8349, },
	{  1060,   113, -5203, 15510, -7491, 10921, -11916,  7608,  1121, -6248, 12801, -19048, 11154, -9752,  4076,  6203, -9966, 17103, -22298, 23001, -8519,  1735,  8318, -19902, 15091, -17853, 16614, -10369,  -395,  7681, -15215, 21033, -11525,  9794, -4961, -2637,  5929, -10413, 13590, -14237,  5668, -2155, -3402, 10649, -2367,  3435, -4459,  5592, },
	{  1386, -6999, 16911, -29068,  9455, -8557,  2088, 11603, -7989, 13750, -18252, 18871, -6487,  -529, 11354, -24234, 17925, -20887, 18757, -9982, -2752, 12848, -23191, 30828, -16281, 12913, -4824, -7286, 10681, -17084, 20921, -20376,  7139, -1287, -6671, 15302, -11295, 13131, -12113,  7534,   385, -6139, 12883, -19685,  3167, -3522,  3010, 27799, },
	{  2421, -8223, 17251, -26629,  7566, -4935, -3230, 17701, -9201, 13897, -16485, 14540, -2998, -4925, 15688, -27046, 17730, -18372, 13613, -2593, -6953, 16538, -25108, 29754, -13851,  8594,   848, -13219, 13019, -17966, 19655, -16638,  4150,  2372, -10243, 17820, -11533, 11959, -9377,  3421,  2828, -8449, 14327, -19324,  2743, -2475,   674, 27202, },
	{  3184, -8860, 16599, -22898,  5388, -1267, -8062, 22493, -9846, 13271, -13891,  9595,   513, -8878, 18994, -28266, 16564, -14927,  7884,  4711, -10646, 19209, -25585, 27067, -10721,  3912,  6331, -18275, 14581, -17834, 17334, -12067,  1002,  5816, -13166, 19296, -11128, 10156, -6194,  -768,  5043, -10218, 14931, -17924,  2195, -1380, -1360, 26108, },
	{  3663, -8931, 15079, -18183,  3063,  2240, -12166, 25785, -9915, 11944, -10649,  4335,  3852, -12186, 21130, -27885, 14525, -10773,  1905, 11528, -13640, 20743, -24637, 22960, -7083,  -865, 11325, -22198, 15300, -16721, 14109, -6937, -2130,  8860, -15295, 19671, -10119,  7838, -2752, -4800,  6916, -11369, 14695, -15607,  1558,  -297, -3051, 24555, },
	{  3863, -8489, 12850, -12824,   729,  5400, -15359, 27476, -9434, 10023, -6969,  -936,  6840, -14692, 22020, -25980, 11757, -6165, -3987, 17497, -15792, 21087, -22356, 17698, -3150, -5471, 15568, -24798, 15157, -14710, 10181, -1542, -5071, 11344, -16530, 18952, -8576,  5144,   754, -8459,  8354, -11858, 13662, -12537,   870,   722, -4368, 22593, },
	{  3808, -7613, 10102, -7171, -1481,  8059, -17516, 27558, -8458,  7643, -3074, -5925,  9328, -16289, 21663, -22712,  8437, -1372, -9469, 22315, -17007, 20258, -18906, 11603,   851, -9654, 18843, -25964, 14180, -11935,  5784,  3812, -7664, 13144, -16823, 17204, -6596,  2232,  4129, -11553,  9290, -11680, 11917, -8912,   172,  1628, -5300, 20287, },
	{  3534, -6400,  7038, -1567, -3452, 10102, -18578, 26117, -7066,  4958,   811, -10369, 11197, -16925, 20125, -18312,  4768,  3336, -14250, 25751, -17248, 18336, -14511,  5036,  4699, -13196, 20995, -25667, 12444, -8568,  1170,  8832, -9775, 14177, -16181, 14546, -4299,  -732,  7191, -13928,  9688, -10866,  9580, -4951,  -499,  2383, -5847, 17713, },
	{  3090, -4956,  3861,  3676, -5092, 11453, -18552, 23317, -5358,  2132,  4471, -14046, 12372, -16603, 17538, -13063,   966,  7700, -18090, 27659, -16530, 15458, -9440, -1627,  8183, -15916, 21933, -23960, 10063, -4807, -3400, 13246, -11296, 14404, -14660, 11147, -1819, -3583,  9779, -15473,  9541, -9480,  6800,  -882, -1110,  2958, -6028, 14952, },
	{  2527, -3393,   764,  8291, -6331, 12084, -17503, 19387, -3444,  -673,  7714, -16787, 12816, -15379, 14083, -7288, -2756, 11492, -20807, 27981, -14922, 11812, -3992, -8017, 11123, -17687, 21636, -20973,  7185,  -871, -7673, 16826, -12159, 13829, -12365,  7213,   702, -6167, 11762, -16123,  8874, -7615,  3744,  3071, -1629,  3336, -5870, 12093, },
	{  1898, -1815, -2084, 12069, -7129, 12005, -15552, 14611, -1441, -3301, 10380, -18482, 12534, -13357,  9985, -1324, -6194, 14521, -22287, 26750, -12540,  7622,  1520, -13787, 13369, -18435, 20152, -16902,  3980,  3018, -11423, 19393, -12330, 12504, -9440,  2971,  3125, -8348, 13047, -15868,  7736, -5389,   587,  6698, -2035,  3509, -5416,  9222, },
	{  1254,  -318, -4542, 14862, -7474, 11268, -12863,  9299,   535, -5616, 12349, -19083, 11574, -10681,  5495,  4493, -9168, 16646, -22490, 24083, -9539,  3136,  6790, -18635, 14817, -18145, 17593, -12000,   633,  6647, -14452, 20829, -11816, 10519, -6061, -1336,  5319, -10017, 13580, -14745,  6205, -2935, -2495,  9816, -2310,  3481, -4715,  6425, },
	{  1017, -6506, 16595, -29517,  9957, -9629,  3779,  9506, -7506, 13544, -18605, 20035, -7525,   877,  9845, -23062, 17781, -21446, 20172, -12208, -1390, 11534, -22320, 30815, -16862, 14129, -6558, -5331,  9822, -16612, 21081, -21322,  7999, -2426, -5469, 14334, -11092, 13351, -12839,  8748,  -393, -5337, 12277, -19575,  3267, -3825,  3782, 27879, },
	{  2130, -7909, 17256, -27530,  8185, -6064, -1633, 15952, -8888, 13936, -17124, 15952, -4083, -3609, 14455, -26348, 17896, -19254, 15274, -4877, -5705, 15504, -24670, 30263, -14681,  9974,  -891, -11473, 12378, -17803, 20163, -17888,  5095,  1260, -9205, 17152, -11529, 12391, -10275,  4705,  2095, -7791, 13971, -19550,  2888, -2805,  1363, 27440, },
	{  2979, -8726, 16899, -24166,  6081, -2387, -6642, 21171, -9709, 13542, -14767, 11164,  -557, -7722, 18096, -28063, 17021, -16073,  9690,  2497, -9576, 18504, -25592, 28056, -11748,  5375,  4683, -16830, 14188, -17982, 18152, -13547,  1977,  4791, -12345, 18958, -11320, 10772, -7210,   515,  4393, -9737, 14836, -18459,  2375, -1719,  -769, 26496, },
	{  3546, -8966, 15630, -19719,  3785,  1190, -10993, 24940, -9954, 12421, -11703,  5969,  2854, -11247, 20603, -28170, 15238, -12112,  3751,  9505, -12803, 20397, -25077, 24360, -8244,   598,  9857, -21125, 15171, -17164, 15186, -8558, -1179,  7976, -14731, 19674, -10491,  8598, -3827, -3590,  6383, -11084, 14855, -16408,  1761,  -625, -2569, 25079, },
	{  3830, -8675, 13600, -14520,  1440,  4474, -14483, 27128, -9637, 10670, -8135,   669,  5968, -14014, 21880, -26720, 12676, -7616, -2204, 15770, -15226, 21108, -23192, 19421, -4378, -4087, 14356, -24147, 15292, -15417, 11451, -3212, -4196, 10648, -16249, 19287, -9102,  6003,  -320, -7385,  7962, -11779, 14060, -13550,  1085,   419, -4004, 23236, },
	{  3850, -7923, 10991, -8921,  -821,  7302, -16968, 27701, -8806,  8415, -4282, -4436,  8623, -15899, 21903, -23850,  9505, -2850, -7844, 20970, -16736, 20635, -20080, 13546,  -374, -8426, 17949, -25761, 14566, -12861,  7172,  2187, -6912, 12669, -16834, 17845, -7245,  3141,  3116, -10672,  9058, -11805, 12523, -10073,   386,  1364, -5054, 21029, },
	{  3639, -6803,  8002, -3267, -2877,  9544, -18369, 26715, -7533,  5807,  -370, -9074, 10693, -16833, 20717, -19770,  5922,  1912, -12869, 24851, -17278, 19036, -15949,  7085,  3544, -12186, 20460, -25913, 13053, -9655,  2597,  7340, -9184, 13945, -16476, 15451, -5032,   176,  6292, -13282,  9624, -11181, 10354, -6192,  -298,  2169, -5719, 18529, },
	{  3242, -5418,  4839,  2118, -4627, 11114, -18673, 24311, -5911,  3007,  3381, -13008, 12088, -16802, 18436, -14750,  2137,  6408, -17021, 27240, -16850, 16435, -11054,   411,  7161, -15176, 21776, -24629, 10856, -5993, -2014, 11967, -10896, 14420, -15217, 12260, -2593, -2727,  9041, -15091,  9644, -9962,  7693, -2132,  -930,  2802, -6010, 15816, },
	{  2710, -3880,  1697,  6952, -5995, 11967, -17928, 20701, -4048,   178,  6770, -16052, 12757, -15846, 15226, -9101, -1632, 10398, -20099, 28051, -15505, 13003, -5690, -6102, 10286, -17249, 21857, -22018,  8114, -2088, -6404, 15825, -11966, 14089, -13146,  8467,   -69, -5409, 11222, -16020,  9132, -8233,  4703,  1880, -1480,  3241, -5952, 12978, },
	{  2095, -2296, -1244, 11006, -6932, 12102, -16240, 16152, -2060, -2520,  9629, -18076, 12696, -14056, 11300, -3158, -5177, 13680, -21967, 27289, -13347,  8955,  -164, -12097, 12759, -18316, 20729, -18256,  4990,  1839, -10337, 18719, -12351, 12987, -10397,  4294,  2398, -7727, 12730, -16042,  8132, -6105,  1558,  5628, -1923,  3477, -5584, 10101, },
	{  1451,  -765, -3835, 14113, -7416, 11560, -13758, 10971,   -63, -4945, 11822, -19015, 11938, -11564,  6903,  2738, -8312, 16095, -22563, 25046, -10518,  4532,  5212, -17257, 14461, -18344, 18486, -13580,  1667,  5570, -13607, 20512, -12045, 11193, -7138,   -18,  4676, -9563, 13497, -15179,  6712, -3706, -1565,  8921, -2240,  3511, -4954,  7273, },
};

int nextstate_147_160[147] = {
	0x00107001, 0x00206f01, 0x00306e01, 0x00406d01, 0x00506c01, 0x00606b01, 0x00706a01, 0x00806901, 
	0x00906801, 0x00a06701, 0x00b06601, 0x00c06502, 0x00d06401, 0x00e06301, 0x00f06201, 0x01006101, 
	0x01106001, 0x01205f01, 0x01305e01, 0x01405d01, 0x01505c01, 0x01605b01, 0x01705a02, 0x01805901, 
	0x01905801, 0x01a05701, 0x01b05601, 0x01c05501, 0x01d05401, 0x01e05301, 0x01f05201, 0x02005101, 
	0x02105001, 0x02204f02, 0x02304e01, 0x02404d01, 0x02504c01, 0x02604b01, 0x02704a01, 0x02804901, 
	0x02904801, 0x02a04701, 0x02b04601, 0x02c04501, 0x02d04401, 0x02e04302, 0x02f04201, 0x03004101, 
	0x03104001, 0x03203f01, 0x03303e01, 0x03403d01, 0x03503c01, 0x03603b01, 0x03703a01, 0x03803901, 
	0x03903802, 0x03a03701, 0x03b03601, 0x03c03501, 0x03d03401, 0x03e03301, 0x03f03201, 0x04003101, 
	0x04103001, 0x04202f01, 0x04302e01, 0x04402d02, 0x04502c01, 0x04602b01, 0x04702a01, 0x04802901, 
	0x04902801, 0x04a02701, 0x04b02601, 0x04c02501, 0x04d02401, 0x04e02301, 0x04f02201, 0x05002102, 
	0x05102001, 0x05201f01, 0x05301e01, 0x05401d01, 0x05501c01, 0x05601b01, 0x05701a01, 0x05801901, 
	0x05901801, 0x05a01701, 0x05b01602, 0x05c01501, 0x05d01401, 0x05e01301, 0x05f01201, 0x06001101, 
	0x06101001, 0x06200f01, 0x06300e01, 0x06400d01, 0x06500c01, 0x06600b02, 0x06700a01, 0x06800901, 
	0x06900801, 0x06a00701, 0x06b00601, 0x06c00501, 0x06d00401, 0x06e00301, 0x06f00201, 0x07000101, 
	0x07100001, 0x07209202, 0x07309101, 0x07409001, 0x07508f01, 0x07608e01, 0x07708d01, 0x07808c01, 
	0x07908b01, 0x07a08a01, 0x07b08901, 0x07c08801, 0x07d08702, 0x07e08601, 0x07f08501, 0x08008401, 
	0x08108301, 0x08208201, 0x08308101, 0x08408001, 0x08507f01, 0x08607e01, 0x08707d01, 0x08807c02, 
	0x08907b01, 0x08a07a01, 0x08b07901, 0x08c07801, 0x08d07701, 0x08e07601, 0x08f07501, 0x09007401, 
	0x09107301, 0x09207201, 0x00007102, 
};
#endif // HELIX_FEATURE_MMXFILTER_147_160

#define MKWORD(up, dn) ((up << 16) | dn)

int updn_list[] = {
	/* to 48000 */
#ifdef HELIX_FEATURE_MMXFILTER_6_1
	MKWORD(6, 1),
#endif
#ifdef HELIX_FEATURE_MMXFILTER_640_147
	MKWORD(640, 147),
#endif
#ifdef HELIX_FEATURE_MMXFILTER_3_1
	MKWORD(3, 1),
#endif
#ifdef HELIX_FEATURE_MMXFILTER_320_147
	MKWORD(320, 147),
#endif
#ifdef HELIX_FEATURE_MMXFILTER_3_2
	MKWORD(3, 2),
#endif
#ifdef HELIX_FEATURE_MMXFILTER_160_147
	MKWORD(160, 147),
#endif
	/* to 44100 */
#ifdef HELIX_FEATURE_MMXFILTER_441_80
	MKWORD(441, 80),
#endif
#ifdef HELIX_FEATURE_MMXFILTER_4_1
	MKWORD(4, 1),
#endif
#ifdef HELIX_FEATURE_MMXFILTER_441_160
	MKWORD(441, 160),
#endif
#ifdef HELIX_FEATURE_MMXFILTER_2_1
	MKWORD(2, 1),
#endif
#ifdef HELIX_FEATURE_MMXFILTER_441_320
	MKWORD(441, 320),
#endif
	/* 48000 to 44100 */
#ifdef HELIX_FEATURE_MMXFILTER_147_160
	MKWORD(147, 160),
#endif
	0
};

short (*filter_list[])[NWING] = {
	/* to 48000 */
#ifdef HELIX_FEATURE_MMXFILTER_6_1
	filter_6_1,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_640_147
	filter_640_147,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_3_1
	filter_3_1,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_320_147
	filter_320_147,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_3_2
	filter_3_2,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_160_147
	filter_160_147,
#endif
	/* to 44100 */
#ifdef HELIX_FEATURE_MMXFILTER_441_80
	filter_441_80,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_4_1
	filter_4_1,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_441_160
	filter_441_160,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_2_1
	filter_2_1,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_441_320
	filter_441_320,
#endif
	/* 48000 to 44100 */
#ifdef HELIX_FEATURE_MMXFILTER_147_160
	filter_147_160,
#endif
	0
};

int *nextstate_list[] = {
	/* to 48000 */
#ifdef HELIX_FEATURE_MMXFILTER_6_1
	nextstate_6_1,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_640_147
	nextstate_640_147,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_3_1
	nextstate_3_1,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_320_147
	nextstate_320_147,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_3_2
	nextstate_3_2,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_160_147
	nextstate_160_147,
#endif
	/* to 44100 */
#ifdef HELIX_FEATURE_MMXFILTER_441_80
	nextstate_441_80,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_4_1
	nextstate_4_1,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_441_160
	nextstate_441_160,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_2_1
	nextstate_2_1,
#endif
#ifdef HELIX_FEATURE_MMXFILTER_441_320
	nextstate_441_320,
#endif
	/* 48000 to 44100 */
#ifdef HELIX_FEATURE_MMXFILTER_147_160
	nextstate_147_160,
#endif
	0
};
