/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: wbmphdr.cpp,v 1.1.20.1 2004/07/09 01:53:03 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxtypes.h"
#include "hxcom.h"
#include "wbmphdr.h"

// pndebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE             
static char HX_THIS_FILE[] = __FILE__;
#endif
HX_RESULT ParseWBMPHeader(BYTE*       pBuf,
                          UINT32      ulSize,
                          REF(UINT32) rulWidth,
                          REF(UINT32) rulHeight,
                          REF(UINT32) rulHeaderSize)
{
    HX_RESULT retVal = HXR_FAIL;

    // Specification for WBMP header is found in Appendix A of
    // the Wireless Application Envinorment from the WAP Forum at:
    // http://www.wapforum.org/what/technical/SPEC-WAESpec-19990524.pdf
    if (pBuf && ulSize)
    {
        // Get bitmap type
        BYTE*     pBufStart  = pBuf;
        BYTE*     pBufLimit  = pBuf + ulSize;
        UINT32    ulType     = 0;
        UINT32    ulNumBytes = 0;
        HX_RESULT rv         = ParseMultiByteInteger(pBuf, pBufLimit - pBuf, ulType, ulNumBytes);
        if (SUCCEEDED(rv))
        {
            // Make sure we have type 0
            if (ulType == 0)
            {
                // Advance the buffer pointer
                pBuf += ulNumBytes;
                // Get the FixHeaderField
                if (pBuf < pBufLimit)
                {
                    UINT32 ulFixedHeader = *pBuf++;
                    // For now, we only support extension header type 00
                    if (ulFixedHeader == 0)
                    {
                        // Get the width
                        rv = ParseMultiByteInteger(pBuf, pBufLimit - pBuf, rulWidth, ulNumBytes);
                        if (SUCCEEDED(rv))
                        {
                            // Advance the pointer
                            pBuf += ulNumBytes;
                            // Get the height
                            rv = ParseMultiByteInteger(pBuf, pBufLimit - pBuf, rulHeight, ulNumBytes);
                            if (SUCCEEDED(rv))
                            {
                                // Advance the pointer
                                pBuf += ulNumBytes;
                                // Clear the return value
                                retVal = HXR_OK;
                                // Compute the number of bytes used
                                rulHeaderSize = pBuf - pBufStart;
                            }
                        }
                    }
                }
            }
        }
    }

    return retVal;
}


HX_RESULT ParseMultiByteInteger(BYTE* pBuf, INT32 lSize,
                                REF(UINT32) rulValue,
                                REF(UINT32) rulNumBytes)
{
    HX_RESULT retVal = HXR_FAIL;

    if (pBuf && lSize > 0)
    {
        // WBMP's multi-byte format reserves the most significant bit
        // as a continuation marker. If that bit = 0, then this byte
        // is the last byte. If that bit = 1, then there are additional
        // bytes. For instance, the value 0xA0 would be represented in
        // this multi-byte format as 0x81 0x20. To parse this format,
        // we have to find the last byte and then re-pack backwards from there.

        // Find the end of the multi-byte integer
        BYTE* pBufStart = pBuf;
        BYTE* pBufLimit = pBuf + lSize;
        rulValue        = 0;
        while (pBuf < pBufLimit)
        {
            rulValue = (rulValue << 7) | (*pBuf & 0x7F);
            if (!(*pBuf & 0x80))
            {
                break;
            }
            pBuf++;
        }
        // Assign the rulNumBytes out parameter
        rulNumBytes = pBuf - pBufStart + 1;
        // Clear the return value
        retVal = HXR_OK;
    }

    return retVal;
}

