# $Id: bogofilter.spec.in,v 1.85 2005/06/30 23:02:52 relson Exp $

# This .spec file will not build the static package by default.
# To do this, run either of the next rpm[build] commands:
#
# rpm --define 'bogostatic 1' --sign -bb bogofilter.spec
# rpmbuild --define 'bogostatic 1' --sign -bb bogofilter.spec
#
# To build with tdb, use:
#
# rpmbuild --define 'with_tdb 1' -bb bogofilter.spec
# rpmbuild --define 'with_tdb 1' --sign -bb bogofilter.spec

%define	name		bogofilter
%define	version		0.95.2
%define	release		1

%{!?bogostatic: %{expand: %%define bogostatic 0}}
%{!?with_tdb:%define with_tdb 0}

Summary:	Fast anti-spam filtering by Bayesian statistical analysis
Name:		%{name}
Version:	%{version}
Release:	%{release}
License:	GPL
Group:		Networking/Mail
URL:		http://bogofilter.sourceforge.net
Source0:	%{name}-%{version}.tar.gz

%define _requires_exceptions perl

Buildroot:	%{_tmppath}/%{name}-%{version}-root
Conflicts:	bogofilter-static

%description
Bogofilter is a Bayesian spam filter.  In its normal mode of
operation, it takes an email message or other text on standard input,
does a statistical check against lists of "good" and "bad" words, and
returns a status code indicating whether or not the message is spam.
Bogofilter is designed with fast algorithms (including Berkeley DB system),
coded directly in C, and tuned for speed, so it can be used for production
by sites that process a lot of mail.

%if %{with_tdb}
This version was built with tdb support.
%else
This version was built with Berkeley DB support.
%endif

%package static
Summary:	Statically linked
Group:		Networking/Mail
Conflicts:	bogofilter

%description static
Statically linked bogofilter, bogolexer, bogoutil, and bogotune

%prep
%setup -q
CFLAGS="$RPM_OPT_FLAGS" \
./configure \
  --prefix=%{_prefix} \
  --mandir=%{_mandir} \
  --sysconfdir=%{_sysconfdir} \
%if %{?bogostatic}
  --enable-static \
%endif
%if %{with_tdb}
  --with-database=tdb \
%endif
  --with-included-gsl

%build
make
make DESTDIR="%{buildroot}" check

%clean
[ -n "%{buildroot}" -a "%{buildroot}" != / ] && rm -rf %{buildroot}

%install
[ -n "%{buildroot}" -a "%{buildroot}" != / ] && rm -rf %{buildroot}
make DESTDIR=%{buildroot} install-strip

cp %{buildroot}%{_sysconfdir}/bogofilter.cf.example \
   %{buildroot}%{_sysconfdir}/bogofilter.cf

for n in xml html ; do
  install -d .inst/$n
  install -m644 doc/*.$n .inst/$n
done

for d in contrib ; do
  install -d %{buildroot}%{_datadir}/%{name}/$d
  files=$(find "$d" -maxdepth 1 -type f -print)
  for f in $files ; do
    case $f in
      *.c|*.o|*.obj|*/Makefile*) continue ;;
      *.1)
	cp -p $f %{buildroot}%{_mandir}/man1 ;;
      *)
	cp -p $f %{buildroot}%{_datadir}/%{name}/$d ;;
    esac
  done
done

%if %{bogostatic}
(
cd %{buildroot}%{_datadir}/%{name}
cp -p -r contrib contrib-static
rm contrib/bogogrep_static
rm contrib-static/bogogrep
strip contrib-static/bogogrep_static
)
%endif

%post

%post static
for file in bogofilter bogolexer bogoutil bogotune ; do
    if [ $1 -lt 2 ] ; then
        ln -s %{_bindir}/${file}_static %{_bindir}/${file} 
    fi
done

%postun static
for file in bogofilter bogolexer bogoutil bogotune ; do
    if [ $1 -eq 0 ] ; then
        rm -f %{_bindir}/${file}
        echo rm -f %{_bindir}/${file}
    fi
done

%files
%defattr(-,root,root)

%doc AUTHORS COPYING INSTALL
%doc GETTING.STARTED
%doc NEWS README* RELEASE.NOTES TODO
%doc doc/bogofilter-tuning.HOWTO.html
%doc doc/bogofilter-SA-2002-01
%doc doc/integrating*
%doc doc/programmer
%doc doc/README.*db doc/rpm.notes.BerkeleyDB
%doc .inst/html .inst/xml

%{_sysconfdir}/bogofilter.cf.example
%config(noreplace) %{_sysconfdir}/bogofilter.cf

%{_bindir}/bogofilter
%{_bindir}/bogolexer
%{_bindir}/bogotune
%{_bindir}/bogoutil
%{_bindir}/bogoupgrade
%{_bindir}/bf_copy
%{_bindir}/bf_compact
%{_bindir}/bf_tar

%{_mandir}/man1/bogofilter.1*
%{_mandir}/man1/bogolexer.1*
%{_mandir}/man1/bogotune.1*
%{_mandir}/man1/bogoutil.1*
%{_mandir}/man1/bogoupgrade.1*
%{_mandir}/man1/bf_compact.1*
%{_mandir}/man1/bf_copy.1*
%{_mandir}/man1/bf_tar.1*

%{_datadir}/%{name}/contrib/*

%if %{bogostatic}
%files static
%defattr(-,root,root)

%doc AUTHORS COPYING INSTALL
%doc GETTING.STARTED
%doc NEWS README* RELEASE.NOTES TODO
%doc doc/bogofilter-tuning.HOWTO.html
%doc doc/bogofilter-SA-2002-01
%doc doc/integrating*
%doc doc/programmer
%doc doc/README.*db doc/rpm.notes.BerkeleyDB
%doc .inst/html .inst/xml

%{_sysconfdir}/bogofilter.cf.example
%config(noreplace) %{_sysconfdir}/bogofilter.cf

%{_bindir}/bogofilter_static
%{_bindir}/bogolexer_static
%{_bindir}/bogotune_static
%{_bindir}/bogoutil_static
%{_bindir}/bogoupgrade
%{_bindir}/bf_copy
%{_bindir}/bf_compact
%{_bindir}/bf_tar

%{_mandir}/man1/bogofilter.1*
%{_mandir}/man1/bogolexer.1*
%{_mandir}/man1/bogotune.1*
%{_mandir}/man1/bogoutil.1*
%{_mandir}/man1/bogoupgrade.1*
%{_mandir}/man1/bf_compact.1*
%{_mandir}/man1/bf_copy.1*
%{_mandir}/man1/bf_tar.1*

%{_datadir}/%{name}/contrib-static/*
%endif

%changelog
