#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <locale.h>
#include <string.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <libxfce4mcs/mcs-client.h>
#include <libxfce4util/libxfce4util.h>

#include <libxfcegui4/libxfcegui4.h>
#include <libxfcegui4/netk-screen.h>
#include <libxfcegui4/netk-window.h>

#include "ls_icon.h"
#include "ls_iconbox.h"
#include "ls_iconboxwin.h"

#define LS_WRONG_ACTION(name, type, action) \
				DBG("action: \'%d\' wrong type:\'%d\' \
				  for:\'%s\'", action, type, name)
#define LS_WRONG_TYPE(name, type) \
				DBG("wrong type:\'%d\' for:\'%s\'", \
    				  type, name)
#define LS_WRONG_NAME(name)	DBG("wrong name:\'%s\'", name)

#define CHANNEL "xfibx"
#define CHANNEL_PANEL "xfce"

#define RCDIR "xfce4"
#define OLDRCDIR "settings"
#define RCFILE "ls-iconbox.rc"
#define OLDRCFILE "ls-iconbox.txt"

/* das main window
  LSIconBoxWin	*plsibw;
 */
McsClient *pmcsClient;
static gint nXOff;
static gint nYOff;
LSIconBoxWin *plsibw;
static SessionClient *client_session;
static gboolean session_managed = FALSE;

static GdkFilterReturn
client_event_filter (GdkXEvent * xevent, GdkEvent * event, gpointer data)
{
    if (mcs_client_process_event (pmcsClient, (XEvent *) xevent))
	return GDK_FILTER_REMOVE;
    else
	return GDK_FILTER_CONTINUE;
}

void
save_offset (gint nXOff, gint nYOff)
{
    char *szRcFile;
    FILE *pF;

    szRcFile = xfce_resource_save_location (XFCE_RESOURCE_CONFIG,
                                            RCDIR G_DIR_SEPARATOR_S RCFILE,
                                            TRUE);

    pF = fopen (szRcFile, "w");
    if (pF == NULL)
    {
	g_warning ("%s: Could not save position to file: %s", PACKAGE,
		   szRcFile);
	g_free (szRcFile);
	return;
    }

    fprintf (pF, "%d:%d\n", nXOff, nYOff);

    fclose (pF);

    g_free (szRcFile);

    return;
}

void
load_offset (gint * nXOff, gint * nYOff)
{
    char *szRcFile;
    FILE *pF;

    *nXOff = *nYOff = 0;

    szRcFile = xfce_resource_lookup (XFCE_RESOURCE_CONFIG,
                                     RCDIR G_DIR_SEPARATOR_S RCFILE);

    if (!szRcFile)
        szRcFile = xfce_get_userfile (OLDRCDIR, OLDRCFILE, NULL);

    pF = fopen (szRcFile, "r");
    if (pF == NULL)
    {
	g_message ("%s: Using default position", PACKAGE);
	g_free (szRcFile);
	return;
    }

    fscanf (pF, "%d:%d", nXOff, nYOff);

    fclose (pF);

    g_free (szRcFile);

    return;
}


static void
watch_mcs (Window window, Bool bStart, long lMask, void *pUserData)
{
    GdkWindow *pGdkWin;

    /* TODO get a clue about this function ;) */

    pGdkWin = gdk_window_lookup (window);

    if (bStart)
    {
	if (!pGdkWin)
	{
	    pGdkWin = gdk_window_foreign_new (window);
	}
	else
	{
	    g_object_ref (pGdkWin);
	}
	gdk_window_add_filter (pGdkWin, client_event_filter, pUserData);
    }
    else
    {
	g_assert (pGdkWin);
	gdk_window_remove_filter (pGdkWin, client_event_filter, pUserData);
	g_object_unref (pGdkWin);
    }

    return;
}

static void
notify_mcs (const char *szName,
	    const char *szChannelName,
	    McsAction mcsa, McsSetting * pmcsas, void *pUserData)
{
    LSIconBoxWin *plsibw;
    LSIconBox *plsib;

    g_return_if_fail (LS_IS_ICONBOXWIN (pUserData));
    plsibw = LS_ICONBOXWIN (pUserData);
    plsib = ls_iconboxwin_get_iconbox (plsibw);

    if (g_ascii_strcasecmp (CHANNEL, szChannelName) == 0)
    {
	switch (mcsa)
	{
	    case MCS_ACTION_NEW:
		/* FALL TROUGH */
	    case MCS_ACTION_CHANGED:
		switch (pmcsas->type)
		{
		    case MCS_TYPE_INT:
			if (strcmp (szName, "Window/HideOnEmpty") == 0)
			{
                            ls_iconboxwin_set_hide_on_empty (plsibw,
                                    pmcsas->data.v_int != 0);
			}
			else if (strcmp (szName, "Window/Offset/X") == 0)
			{
			    /*
			       if(pmcsas->data.v_int>=0)
			       ls_iconboxwin_set_offset(plsibw, pmcsas->data.v_int, -1);
			     */
			}
			else if (strcmp (szName, "Window/Offset/Y") == 0)
			{
			    /*
			       if(pmcsas->data.v_int>=0)
			       ls_iconboxwin_set_offset(plsibw, -1, pmcsas->data.v_int);
			     */
			}
			else if (strcmp (szName, "Window/Position/Vertical")
				 == 0)
			{
			    ls_iconboxwin_set_vertical_position (plsibw,
								 pmcsas->data.
								 v_int);
			}
			else if (strcmp (szName, "Window/Position/Horizontal")
				 == 0)
			{
			    ls_iconboxwin_set_horizontal_position (plsibw,
								   pmcsas->
								   data.
								   v_int);
			}
			else if (strcmp (szName, "Window/Orientation") == 0)
			{
                            ls_iconboxwin_set_offset (plsibw, 0, 0);

			    ls_iconboxwin_set_orientation (plsibw,
							   pmcsas->data.
							   v_int);
			}
			else if (strcmp (szName, "IconBar/Size") == 0)
			{
			}
			else if (strcmp (szName, "Icon/Show/SameWS/Minimized")
				 == 0)
			{
			    ls_iconbox_set_show_icon (plsib,
						      pmcsas->data.v_int, -1,
						      -1, -1, -1, -1);
			}
			else if (strcmp (szName, "Icon/Show/SameWS/Maximized")
				 == 0)
			{
			    ls_iconbox_set_show_icon (plsib,
						      -1, pmcsas->data.v_int,
						      -1, -1, -1, -1);
			}
			else if (strcmp
				 (szName,
				  "Icon/Show/SameWS/SkipTaskbar") == 0)
			{
			    ls_iconbox_set_show_icon (plsib,
						      -1, -1,
						      pmcsas->data.v_int, -1,
						      -1, -1);
			}
			else if (strcmp
				 (szName, "Icon/Show/OtherWS/Minimized") == 0)
			{
			    ls_iconbox_set_show_icon (plsib,
						      -1, -1, -1,
						      pmcsas->data.v_int, -1,
						      -1);
			}
			else if (strcmp
				 (szName, "Icon/Show/OtherWS/Maximized") == 0)
			{
			    ls_iconbox_set_show_icon (plsib,
						      -1, -1, -1, -1,
						      pmcsas->data.v_int, -1);
			}
			else if (strcmp
				 (szName,
				  "Icon/Show/OtherWS/SkipTaskbar") == 0)
			{
			    ls_iconbox_set_show_icon (plsib,
						      -1, -1, -1, -1, -1,
						      pmcsas->data.v_int);
			}
			else if (strcmp (szName, "Icon/Color/Use") == 0)
			{
			    ls_iconbox_set_use_color (plsib,
						      pmcsas->data.v_int);
			}
			else
			{
			    LS_WRONG_NAME (szName);
			}
			break;
		    default:
			LS_WRONG_TYPE (szName, pmcsas->type);
			break;
		}
		break;
	    case MCS_ACTION_DELETED:
		break;
	    default:
		LS_WRONG_ACTION (szName, pmcsas->type, mcsa);
		break;
	}
    }
    else if (g_ascii_strcasecmp (CHANNEL_PANEL, szChannelName) == 0)
    {
	switch (mcsa)
	{
	    case MCS_ACTION_NEW:
		/* FALL TROUGH */
	    case MCS_ACTION_CHANGED:
		switch (pmcsas->type)
		{
		    case MCS_TYPE_INT:

			if (strcmp (szName, "size") == 0)
			{
			    ls_iconbox_set_size (ls_iconboxwin_get_iconbox
						 (plsibw),
						 pmcsas->data.v_int);
			}
			else
			{
			    LS_WRONG_NAME (szName);
			}
			break;
		    default:
			LS_WRONG_TYPE (szName, pmcsas->type);
			break;
		}
		break;
	    case MCS_ACTION_DELETED:
		break;
	    default:
		LS_WRONG_ACTION (szName, pmcsas->type, mcsa);
		break;
	}
    }

    return;
}

static void
destroy_progress (GtkWidget * widget, void *pdata)
{
    ls_iconboxwin_get_offset (plsibw, &nXOff, &nYOff);
    save_offset (nXOff, nYOff);

    gtk_main_quit ();
    return;
}

static void
cb_save_yourself (gpointer data,
		  int save_style,
		  gboolean shutdown, int interact_style, gboolean fast)
{
    ls_iconboxwin_get_offset (plsibw, &nXOff, &nYOff);
    save_offset (nXOff, nYOff);
}

static void
cb_die (gpointer client_data)
{
    ls_iconboxwin_get_offset (plsibw, &nXOff, &nYOff);
    save_offset (nXOff, nYOff);

    if (pmcsClient)
	mcs_client_destroy (pmcsClient);

    pmcsClient = NULL;

    gtk_main_quit ();
}

int
main (int ncArg, char *aszArgv[])
{
    NetkScreen *pScreen;

    /* This is required for UTF-8 at least - Please don't remove it  */
    xfce_textdomain (GETTEXT_PACKAGE, LOCALEDIR, "UTF-8");

    gtk_set_locale ();
    gtk_init (&ncArg, &aszArgv);

    client_session = client_session_new (ncArg, aszArgv, NULL,
					 SESSION_RESTART_IF_RUNNING, 40);

    client_session->save_yourself = cb_save_yourself;
    client_session->die = cb_die;

    if (!(session_managed = session_init (client_session)))
    {
/*	g_message ("%s: Running without session manager", PACKAGE);*/
    }

    pScreen = netk_screen_get_default ();

    /*
     * Netk und XFCE work is done start with the gtk code
     */
    plsibw = LS_ICONBOXWIN (ls_iconboxwin_new (pScreen));

    g_signal_connect (G_OBJECT (plsibw), "destroy",
		      G_CALLBACK (destroy_progress), (gpointer) plsibw);

#if GTK_CHECK_VERSION(2,2,0)
    /* XRandR support */
    g_signal_connect_swapped (G_OBJECT (gdk_screen_get_default ()),
			      "size-changed",
			      G_CALLBACK (ls_iconboxwin_re_evaluate_position),
			      plsibw);
#endif

    ls_iconboxwin_show (plsibw);

    pmcsClient =
	mcs_client_new (GDK_DISPLAY (), XDefaultScreen (GDK_DISPLAY ()),
			notify_mcs, watch_mcs, plsibw);

    if (pmcsClient)
    {
	mcs_client_add_channel (pmcsClient, CHANNEL);
    }
    else
    {
	g_warning ("%s: cannot create mcs client channel:\'%s\'", PACKAGE,
		   CHANNEL);
    }

    if (pmcsClient)
    {
	mcs_client_add_channel (pmcsClient, CHANNEL_PANEL);
    }
    else
    {
	g_warning ("%s: cannot create mcs client channel:\'%s\'", PACKAGE,
		   CHANNEL_PANEL);
    }

    load_offset (&nXOff, &nYOff);
    ls_iconboxwin_set_offset (plsibw, nXOff, nYOff);

    netk_screen_force_update (pScreen);

    gtk_main ();

    return 0;
}
