/* $USAGI: util.h,v 1.5 2003/11/13 17:15:51 takamiya Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _UTIL_H
#define _UTIL_H

#include <asm/types.h>
#include <netinet/in.h>

extern const char *strmh(__u8 type);
extern const char *stricmp6(__u8 type);
extern const char *in6_straddr(const struct in6_addr *addr);

extern int in6_addr_get(struct in6_addr *addr, const char *str);
extern int in6_lladdr_get(struct in6_addr *addr, const char *ifname);

#if 0
extern int ip6_addr_unicast(struct in6_addr *a);
#endif
extern int mip6_addr_unicast_routable(struct in6_addr *a);

extern int mip6_fill_pad(unsigned char *data, int len, int padlen);

/*
 * caclulate padding length
 */
unsigned static inline int mip6_align_padlen(unsigned int len)
{
	return (8 - (len % 8));
}

#endif
