/* $USAGI: cn.c,v 1.3 2003/11/13 16:17:03 nakam Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Masahide NAKAMURA @USAGI
 */
#include <errno.h>
#include <netinet/in.h>

#include <mip6.h>
#include "mip6d.h"

static int cn_init(struct mip6d_handle *mp)
{
	return 0;
}

static void cn_fini(struct mip6d_handle *mp)
{
}

static int cn_observe(struct mip6d_handle *mp)
{
	return 0;
}

#if 0
static int cn_nlroute_input(struct mip6d_handle *mp, void *buf, ssize_t len)
{
	return 0;
}

static int cn_nlxfrm_input(struct mip6d_handle *mp, void *buf, ssize_t len)
{
	return 0;
}

static int cn_mh_input(struct mip6d_handle *mp, struct mip6_msg_info *msg_info,
		       struct mip6_mh_hdr *mh, ssize_t len)
{
	int err_code = 0;

	switch (mh->type) {
	case MIP6_MH_BRR:
		break;
	case MIP6_MH_HOTI:
		break;
	case MIP6_MH_COTI:
		break;
	case MIP6_MH_HOT:
		break;
	case MIP6_MH_COT:
		break;
	case MIP6_MH_BU:
		err_code = mip6d_bu_input(mp, msg_info, mh, len); /* XXX */
		break;
	case MIP6_MH_BA:
		break;
	case MIP6_MH_BE:
		break;
	default:
		err_code = -EINVAL;
		goto fin;
	}

 fin:
	return err_code;
}
#endif

static int cn_icmp_input(struct mip6d_handle *mp, struct mip6_msg_info *msg_info,
			 struct icmp6_hdr *icmp, ssize_t len)
{
	__dprintf("icmp6 type=%s\n\n", stricmp6(icmp->icmp6_type));

	switch(icmp->icmp6_type) {
	case ND_ROUTER_ADVERT:
	case ICMPV6_DHAAD_REQUEST:
	case ICMPV6_DHAAD_REPLY:
	case ICMPV6_MOBILE_PREFIX_SOLICIT:
	case ICMPV6_MOBILE_PREFIX_ADVERT:
		break;
	default:
		break;
	}

	return 0;
}

int cn_register(struct mip6d_handle *mp)
{
	mp->init = cn_init;
	mp->fini = cn_fini;
	mp->observe = cn_observe;
#if 0
	mp->nlroute_input = cn_nlroute_input;
	mp->nlxfrm_input = cn_nlxfrm_input;
	mp->mh_input = cn_mh_input;
#endif
	mp->icmp_input = cn_icmp_input;

	return 0;
}
