#ifndef _BC_H
#define _BC_H

#include <netinet/in.h>
#include "mip6.h"

extern int mip6_bc_lookup(struct in6_addr *hoa, struct mip6_bc_entry **bcep);
extern int mip6_bc_set(struct mip6_bc_entry *bce,
		       struct in6_addr *coa, __u16 lifetime, __u8 flags, __u16 seq);
extern int mip6_bc_add(struct in6_addr *hoa, struct in6_addr *coa,
		       __u16 lifetime, __u8 flags, __u16 seq, struct mip6_bc_entry **bcep);
extern int mip6_bc_del(struct mip6_bc_entry *bce);
extern void mip6_bc_dump(void);
extern void mip6_bc_update(void);
extern void mip6_bc_clear(void);
extern int mip6_bc_may_overflow(void);
extern void mip6_bc_fini(void);
extern int mip6_bc_init(void);

#endif
