/* $USAGI: mip6nl.h,v 1.5 2003/10/22 10:00:39 nakam Exp $ */

/*
 * Authors:
 *	Noriaki TAKAMIYA @USAGI
 *	Masahide NAKAMURA @USAGI
 */
#ifndef _MIP6NL_H
#define _MIP6NL_H

#include <asm/types.h>
#include <netinet/in.h>
#include <linux/netlink.h>
#include <linux/xfrm.h>

/* XFRM_INF needs 'u64', but where is 'u64' defined? --nakam */
#ifndef u64
#define u64 __u64
#endif

 /* for dummy using */
/*#define MIP6_SPI	(0)*/
#define MIP6_SPI	(~(__u32)0)

#define TMPL_MAX 3

struct mip6nl_parms {
	unsigned short int type;
	unsigned short int flag;

	int sock;

	/*
	 * selector's values
	 */
	struct mip6nl_parms_sel {
		struct in6_addr daddr;
		struct in6_addr saddr;
		__u8 proto;
		int ifindex;
	} sel;

	/* id's values */
	union {
		struct mip6nl_parms_id {
			__u8 proto;
			struct in6_addr daddr;
			struct in6_addr saddr;
		} ext;
		struct mip6nl_parms_id tmpls[TMPL_MAX];
	} id;

	/* policy's specific values */
	struct mip6nl_parms_pol {
		__u8 dir;
		__u32 index;

		__u32 priority;
		__u8 flags;
	} pol;

	int (*probe_handler_policy)(const struct mip6nl_parms *mp,
				    const struct xfrm_userpolicy_info *pol);
	int (*probe_handler_state)(const struct mip6nl_parms *mp,
				   const struct xfrm_usersa_info *sa);
	void (*error_handler)(const struct mip6nl_parms *mp,
			      const struct nlmsghdr *hdr, int error);

};

extern int mip6nl_make_msg(const struct mip6nl_parms *mp, void *buf,
			   unsigned short int *len);
extern int mip6nl_probe_msg(const struct mip6nl_parms *mp, void *buf,
			    unsigned int *lenp);
extern int mip6nl_verify(const struct mip6nl_parms *mp);
extern int mip6nl_talk(const struct mip6nl_parms *mp);
extern void mip6nl_init(struct mip6nl_parms *mp, int sock);
extern int mip6nl_open(struct mip6nl_parms *mp);
extern void mip6nl_close(struct mip6nl_parms *mp);

#endif
