/* $USAGI: libxfnl.h,v 1.3 2004/04/27 09:51:37 nakam Exp $ */

/*
 * Copyright (C)2004 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Masahide NAKAMURA @USAGI
 */

#ifndef __LIBXFNL_H
#define __LIBXFNL_H

#include <linux/netlink.h>
#include <linux/xfrm.h>

#define TMPL_MAX 6
#define ATT_MAX 2

/*
 * selector's values
 */
struct xfnl_sel {
	xfrm_address_t daddr;
	xfrm_address_t saddr;
	__u8 prefixlen_d;
	__u8 prefixlen_s;
	__u16 dport;
	__u16 sport;
	__u8 proto;
	int ifindex;
#define mh_type dport
};

/*
 * id's values
 */
struct xfnl_id {
	__u32 spi;
	__u8 proto;
	__u8 mode;
	xfrm_address_t daddr;
	xfrm_address_t saddr;
	__u8 level;
};

struct xfnl_att {
	__u16 type;

	struct xfrm_algo algo;
	char algo_key_buf[1024]; /* XXX */
	xfrm_address_t coaddr;
};

struct xfnl_handle {
	int sock;

	__u16 type;
	__u16 flag;
	__u16 family;
	struct xfnl_sel sel;

	/* policy's specific values */
	struct xfnl_policy {
		__u8 dir;
		__u32 index;
		__u8 action;
		__u32 priority;
		__u8 flags;

		int ntmpls;
		struct xfnl_id tmpls[TMPL_MAX];
	} pol;

	/* state's specific value */
	struct xfnl_state {
		struct xfnl_id id;

		int natts;
		struct xfnl_att atts[ATT_MAX];
	} st;

	int (*probe_policy_handler)(const struct xfnl_handle *xh,
				    const struct xfrm_userpolicy_info *pol, 
				    const struct xfrm_user_tmpl *tmpls,
				    int ntmpls);
	int (*probe_state_handler)(const struct xfnl_handle *xh,
				   const struct xfrm_usersa_info *st,
				   const struct xfnl_att *atts,
				   int natts);
	void (*error_handler)(const struct xfnl_handle *xh,
			      const struct nlmsghdr *hdr, int error,
			      unsigned int len);
};

int xfnl_make_msg(const struct xfnl_handle *xh, void *buf,
		  unsigned short int *len);
int xfnl_probe_msg(const struct xfnl_handle *xh, void *buf, int *lenp);
int xfnl_verify(const struct xfnl_handle *xh);
int xfnl_talk(const struct xfnl_handle *xh);
void xfnl_init(struct xfnl_handle *xh, int sock);
int xfnl_open(struct xfnl_handle *xh);
void xfnl_close(struct xfnl_handle *xh);

int nl_talk_sr(int sock, void *nlmsg, int nlmsg_len,
	       void *rnlmsg, int rnlmsg_max, int *rnlmsg_len);
int nl_talk(void *nlmsg, int nlmsg_len,
	    void *rnlmsg, int rnlmsg_max, int *rnlmsg_len);

#endif
