/*
 * Copyright (C) 2001 USAGI/WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* 
 * From: @(#)ctl.c	5.7 (Berkeley) 3/1/91
 */
char ctl_rcsid[] = 
  "$Id: ctl.c,v 1.11 1998/11/27 10:55:58 dholland Exp $";

/*
 * This file handles haggling with the various talk daemons to
 * get a socket to talk to. sockt is opened and connected in
 * the progress
 */

#if DEBUG
#include <features.h>
#define __USE_GNU
#endif
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "talk.h"

/* inet address of the remote machine */
#ifdef INET6
sa_family_t remote_family;
struct	addrinfo *his_machine_addrs;
#else
struct	sockaddr his_machine_addr;
#endif
socklen_t his_machine_addrlen;

u_short daemon_port;	/* port number of the talk daemon */

int	sockt;
int	invitation_waiting = 0;
u_short	invitation_port = 0;

struct CtlMessage msg;

void
open_sockt(void)
{
#ifdef INET6
	sockt = socket(remote_family, SOCK_STREAM, 0);
#else
	sockt = socket(AF_INET, SOCK_STREAM, 0);
#endif
	if (sockt <= 0)
		p_error("Bad socket (stream)");
}

#if DEBUG
/* print_addr is a debug print routine */
void
print_addr(struct sockaddr *addr, socklen_t addrlen)
{
	int i;
	switch(addr->sa_family){
	case AF_INET:
	    {
		struct sockaddr_in *sin = (struct sockaddr_in *)addr;
		int padlen = sizeof(*sin) - (socklen_t)&(((struct sockaddr_in*)NULL)->sin_zero);
		printf("sockaddr_in: ");
		if (addrlen < sizeof(*sin)) {
			printf("too short (%d)", addrlen);
			if (padlen < 0)
				break;
			printf(", ");
		}
		printf("family = %d, port = %d, addr = %s, zero = { ",
			sin->sin_family, ntohs(sin->sin_port), 
			inet_ntoa(sin->sin_addr));
		for (i = 0; i<padlen; i++)
			printf("%o ", (int)sin->sin_zero[i]);
		printf("}");
	    }
#ifdef INET6
	case AF_INET6:
	    {
		struct sockaddr_in6 *sin6 = (struct sockaddr_in6 *)addr;
		u_int32_t scopeid = 0;
		int is_old = 0;
		socklen_t sin6len;
		int garbage;
		char buf[256];

		printf("sockaddr_in6: ");
#ifdef __USAGI__
		if (addrlen < sizeof(struct __sockaddr_in6_rfc2133)) {
			printf("too short (%d)", addrlen);
			break;
		} else if (addrlen < sizeof(*sin6)) {
			is_old = 1;
			sin6len = sizeof(struct __sockaddr_in6_rfc2133);
			printf("old spec, ");
		} else {
			scopeid = sin6->sin6_scope_id;
			sin6len = sizeof(*sin6);
		}
#else
		if (addrlen < sizeof(*sin6)) {
			printf("too short (%d)", addrlen);
			break;
		} else {
			scopeid = sin6->sin6_scope_id;
			sin6len = sizeof(*sin6);
		}
#endif
		garbage = addrlen - sin6len;
		if (inet_ntop(AF_INET6, &sin6->sin6_addr, buf, sizeof(buf)))
			strcpy(buf, "???");	/*XXX do myself? */
		printf("family = %d, port = %d, flowinfo = %x, addr = %s",
			sin6->sin6_family, ntohs(sin6->sin6_port), 
			ntohl(sin6->sin6_flowinfo), buf);
		if (!is_old) {
			printf(", scope_id = %d", scopeid);
		}
	    }
#endif
	default:
	    {
		socklen_t i;
		char *p = (char *)addr;
		printf("unknown family; { ");
		for (i=0; i<addrlen; i++) {
			printf("%x ", (int)p[i]&0xff);
		}
		printf("}");
	    }
	}
	putchar('\n');
}
#endif /* 0 */
