/*
 * Copyright (C) 2002 USAGI/WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * Author:       
 *        Mitsuru KANDA  <mk@linux-ipv6.org>
 */
#ifndef __DTCP_H__
#define __DTCP_H__ 1

#include <net/if.h>

#define DTCP_MSG_PING        1
#define DTCP_MSG_TUNNEL      2
#define DTCP_MSG_QUIT        3

#define DTCP_HOST           1 /* "host" */
#define DTCP_NETWORK        2 /* "network" */
#define DTCP_TUNNEL_ONLY    3 /* "tunnelonly" */

#define DTCP_OK  0
#define DTCP_ERR 1

#define DTCP_PORT 20200

struct tunnel_config {
	int type;
	char dev[IFNAMSIZ];
	struct in_addr *in_c;
	struct in_addr *in_s;
	struct in6_addr *in6_c; 
	struct in6_addr *in6_s;
	struct in6_addr *in6_net;
	int plen;
	char netdev[IFNAMSIZ]; 
};

int send_ping(int sockfd);
int send_quit(int sockfd);

int do_write(int fd, const char *msg, size_t len);
int do_rcvchk(char *msg);

int detect_tuntype(char *tuntype);

#endif /* __DTCP_H__ */
