/*
 * $Id: vector.hxx,v 1.1 2002/02/15 23:44:28 skavish Exp $
 *
 * ==========================================================================
 *
 * The JGenerator Software License, Version 1.0
 *
 * Copyright (c) 2000 Dmitry Skavish (skavish@usa.net). All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *    "This product includes software developed by Dmitry Skavish
 *     (skavish@usa.net, http://www.flashgap.com/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The name "The JGenerator" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact skavish@usa.net.
 *
 * 5. Products derived from this software may not be called "The JGenerator"
 *    nor may "The JGenerator" appear in their names without prior written
 *    permission of Dmitry Skavish.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL DMITRY SKAVISH OR THE OTHER
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef VECTOR_H
#define VECTOR_H

/**
 * Simple unsynchronized vector.
 *
 * @author Dmitry Skavish
 */
template <class T>
class Vector {

    T*  objects;
    int capacity;
    int top;

#define INIT_CAPACITY 20

public:

    /**
     * Creates emtpy vector with default capacity.
     */
    Vector() {
        init( INIT_CAPACITY );
    }

    /**
     * Creates empty vector with specified capacity.
     *
     * @param capacity initial capacity
     */
    Vector( int capacity ) {
        init( capacity );
    }

    /**
     * Ensure capacity of this vector.<p>
     * Increases the capacity of this vector, if necessary, to ensure
     * that it can hold at least the number of objects specified by
     * the argument.
     *
     * @param cap    new capacity
     */
    void ensureCapacity( int cap ) {
        if( cap >= capacity ) {
            T* newObjs = new T[cap*2];
            memcpy(newObjs, objects, capacity*sizeof(T));
            capacity = cap*2;
            delete objects;
            objects = newObjs;
        }
    }

    /**
     * Adds the specified object to the end of this vector,
     * increasing its size by one. The capacity of this vector is
     * increased if its size becomes greater than its capacity.
     *
     * @param o      object to be added
     */
    void addElement( T o ) {
        ensureCapacity( top );
        objects[top++] = o;
    }

    /**
     * Sets the object at the specified <code>index</code> of this
     * vector to be the specified object. The previous object at that
     * position is discarded.
     *
     * @param o      new object to be set at the index
     * @param index  the specified index
     */
    void setElementAt( T o, int index ) {
        ensureCapacity( index );
        objects[index] = o;
        if( index >= top ) top = index+1;
    }

    /**
     * Returns the object at the specified index.
     *
     * @param index  the specified index
     * @return object at specified index
     */
    T elementAt( int index ) {
        /*if( index >= top ) {
            return NULL;
            //throw new ArrayIndexOutOfBoundsException( index + " >= " + top );
        }*/
        return objects[index];
    }

    /**
     * Returns size of the vector.
     *
     * @return size of the vector (number of objects in it)
     */
    int size() {
        return top;
    }

    /**
     * Resets vector.
     * <P>
     * Removes all objects from the vector, but does not change the capacity
     */
    void reset() {
        top = 0;
    }

    /**
     * Clears vector.
     * <P>
     * Removes all objects from the vector and fills it with nulls,
     * but does not change the capacity
     */
    void clear() {
        for( int i=0; i<capacity; i++ ) {
            objects[i] = NULL;
        }
        top = 0;
    }

private:

    void init( int capacity ) {
        init( capacity, 0 );
    }

    void init( int capacity, int top ) {
        this->top = top;
        if( capacity <= 0 ) capacity = 1;
        this->capacity = capacity;
        objects = new T[capacity];
    }

};

#endif



