/*
 * windows.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include "commands.h"

#define OKSTR     "[  OK  ]"
#define YESSTR    "[ YES  ]"
#define NOSTR     "[  NO  ]"
#define CANCELSTR "[CANCEL]"

WINDOW *create_newwin(int height, int width, int starty, int startx) {
    WINDOW *local_win;

    local_win = newwin(height, width, starty, startx);
    wattron(local_win, A_BOLD);
    box(local_win, 0 , 0);
    wattroff(local_win, A_BOLD);
    /* 0, 0 gives default characters for the vertical and horizontal
     * lines */
    wrefresh(local_win);            /* Show that box                */
    return local_win;
}


WINDOW *create_dialog(int height) {
    int x, y;

    getmaxyx(stdscr, y, x);
    return create_newwin(height, x - 6, (y - height) / 2, 3);
}


void destroy_win(WINDOW *local_win) {
    wborder(local_win, ' ', ' ', ' ',' ',' ',' ',' ',' ');
    wrefresh(local_win);
    delwin(local_win);
}


static void display_buttons(WINDOW *dialog, int buttons, int def) {
    set_color(dialog, White);
    wattron(dialog, A_BOLD);
    switch (buttons) { 
        case 1:
            wattron(dialog, A_REVERSE);
            mvwprintw(dialog, 4, 2, OKSTR);
            wattroff(dialog, A_REVERSE);
            break;
        case 3:
            if (def == 3) wattron(dialog, A_REVERSE);
            mvwprintw(dialog, 4, 34, CANCELSTR);
            if (def == 3) wattroff(dialog, A_REVERSE);
        case 2:
            if (def == 2) wattron(dialog, A_REVERSE);
            mvwprintw(dialog, 4, 18, NOSTR);
            if (def == 2) wattroff(dialog, A_REVERSE);
            if (def == 1) wattron(dialog, A_REVERSE);
            mvwprintw(dialog, 4, 2, YESSTR);
            if (def == 1) wattroff(dialog, A_REVERSE);
            break;
        default: break;
    }
    wattroff(dialog, A_BOLD);
}


static int dialog_cmd(WINDOW *dialog, int datas, int def) {
    unsigned int key;
    int          cont = CONT, button = def;

    while (cont == CONT) {
        display_buttons(dialog, datas, button);
        wrefresh(dialog);
        key = wgetch(stdscr);
        switch (key) {
            case KEY_UP:
            case KEY_LEFT:
                button--;
                if (button == 0) button = datas;
                break;
            case KEY_DOWN:
            case KEY_RIGHT:
                button++;
                if (button > datas) button = 1;
                break;
            case 10:
            case ' ':
                cont = STOP;
                break;
            default:
                fprintf(stderr, "");
        }
    }
    return button;
}


int yes_or_no(char *title, char *reason, int def) {
    WINDOW *dwin = create_dialog(10);
    int     res = def;

    set_color(dwin, Yellow);
    mvwprintw(dwin, 0, 1, "[ %s ]", title);
    mvwprintw(dwin, 2, 2, reason);
    wrefresh(dwin);
    res = dialog_cmd(dwin, 2, def);

    destroy_win(dwin);
    return res;
}


int yes_no_cancel(char *title, char *reason, int def) {
    WINDOW *dwin = create_dialog(10);
    int     res = def;

    set_color(dwin, Yellow);
    mvwprintw(dwin, 0, 1, "[ %s ]", title);
    mvwprintw(dwin, 2, 2, reason);
    wrefresh(dwin);
    res = dialog_cmd(dwin, 3, def);

    destroy_win(dwin);
    return res;
}

