/*
 * mogg_mod.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include "tmms.h"
#include "commands.h"
#include "modules.h"

static int parse_ogg(const char *datas, int *frame,
        int *mins, int *secs, int *rms, int *rss);

static Module OGG = {".ogg", "ogg123", "-k", "-d", "-v", SECONDS, &parse_ogg};


void register_ogg() {
    register_module(&OGG);
}


static int parse_ogg(const char *datas, int *frame,
        int *mins, int *secs, int *rms, int *rss) {
    int   r = 0;
    char *l = strstr(datas, "Time:");

    if (l == datas) {
        char total[30];
        char bitrate[12];
        int  cs, rcs;
        r = sscanf(datas, "Time: %d:%d.%d [%d:%d.%d] of %s , Bitrate: %s",
                mins, secs, &cs, rms, rss, &rcs, total, bitrate);
        *frame = 0;
    }

    return (r == 8);
}

