/*
 * mp3_mod.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include "tmms.h"
#include "commands.h"
#include "modules.h"

static int parse_mp3(const char *datas, int *frame,
        int *mins, int *secs, int *rms, int *rss);

static Module MP3 = {".mp3", "mpg123", "-k", "-o", "-v", FRAMES, &parse_mp3};


void register_mp3() {
    register_module(&MP3);
}


static int parse_mp3(const char *datas, int *frame,
        int *mins, int *secs, int *rms, int *rss) {
    int   r = 0;
    char *l = strstr(datas, "Frame#");

    if (l) {
        int rf, sc, rcs, n;
        r = sscanf(datas, "Frame# %d [%d], Time: %d:%d.%d [%d:%d.%d], [%d]",
                frame, &rf, mins, secs, &sc, rms, rss, &rcs, &n);
    }

    return (r == 9);
}

