/*
 * modules.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include "tmms.h"
#include "xmem.h"
#include "commands.h"
#include "modules.h"


ModList *mod_list = NULL;
static Module *cur_mod = NULL;


/* Modules management */
void register_module(Module *module) {
    ModList *l = mod_list;

    if (!l) {
        mod_list = xmalloc(sizeof(ModList));
        l = mod_list;
    } else {
        while (l->next != NULL) l = l->next;
        l->next = xmalloc(sizeof(ModList));
        l = l->next;
    }
    l->module = module;
    l->next = NULL;
}


int is_http(const char *entry) {
    if (strncmp(entry, "http://", 7) == 0)
        return TRUE;
    return FALSE;
}


int get_format(const char *entry) {
    ModList *l = mod_list;

    while (l) {
        if (strstr(entry, l->module->ext) != NULL) {
            return TRUE;
        }
        l = l->next;
    }
    return is_http(entry);;
}


int has_module(const char *entry) {
    ModList *l = mod_list;

    while (l) {
        if (strstr(entry, l->module->ext) != NULL) {
            cur_mod = l->module;
            return TRUE;
        }
        l = l->next;
    }
    if (is_http(entry)) {
        cur_mod = mod_list->module;
        return TRUE;
    }
    cur_mod = NULL;
    fprintf(stderr, "ERROR : MODULE NOT FOUND FOR %s !\n", entry);
    return FALSE;
}


Module *get_module() {
    return cur_mod;
};


void unload_module() {
    cur_mod = NULL;
}


char *get_command() {
    return cur_mod ? cur_mod->cmd : NULL;
}


char *get_option() {
    return cur_mod ? cur_mod->opt : NULL;
}


char *get_device() {
    return cur_mod ? cur_mod->dev : NULL;
}


char *get_posopt() {
    return cur_mod ? cur_mod->pos : NULL;
}


char *get_position(int frame, int seconds) {
    char *o = NULL;

    if (cur_mod) {
        int position = 0;
        char posstr[1024];
    
        if ((frame != 0) || (seconds != 0)) {
            switch (cur_mod->postype) {
                case FRAMES:  position = frame; break;
                case SECONDS: position = seconds; break;
                default: return NULL;
            }
            snprintf(posstr, 1023, "%d", position);
            o = xstrdup(posstr);
        }
    }

    return o;
}


void unregister_modules() {
    ModList *l = mod_list;

    while (l) {
        ModList *m = l->next;
        free(l);
        l = m;
    }
}
