/*
 * commands.c
 * Thomas Nemeth, le 08.01.2002
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include "defines.h"
#include <ncurses.h>
#include "xmem.h"
#include "commands.h"
#include "tmms.h"
#include "printlog.h"



void init_colors() {
    if ((has_colors() == TRUE) && (uses_color == TRUE)) {
        start_color();
        if (use_default_colors() == OK) {
            init_pair(Black,   COLOR_BLACK,   -1);
            init_pair(Red,     COLOR_RED,     -1);
            init_pair(Green,   COLOR_GREEN,   -1);
            init_pair(Yellow,  COLOR_YELLOW,  -1);
            init_pair(Blue,    COLOR_BLUE,    -1);
            init_pair(Magenta, COLOR_MAGENTA, -1);
            init_pair(Cyan,    COLOR_CYAN,    -1);
            init_pair(White,   COLOR_WHITE,   -1);
        } else {
            init_pair(Black,   COLOR_BLACK,   COLOR_WHITE);
            init_pair(Red,     COLOR_RED,     COLOR_BLACK);
            init_pair(Green,   COLOR_GREEN,   COLOR_BLACK);
            init_pair(Yellow,  COLOR_YELLOW,  COLOR_BLACK);
            init_pair(Blue,    COLOR_BLUE,    COLOR_BLACK);
            init_pair(Magenta, COLOR_MAGENTA, COLOR_BLACK);
            init_pair(Cyan,    COLOR_CYAN,    COLOR_BLACK);
            init_pair(White,   COLOR_WHITE,   COLOR_BLACK);
        }
    }
}


int command_loop(Cmdslst *cmds) {
    int i, cmd, found = -1;

    /* Lecture d'une commande au clavier */
    cmd = wgetch(stdscr);

    for (i = 0 ; cmds[i].key != 0 ; i++) {
        //fprintf(stderr, "[%d] ---> [%d]\n", i, cmds[i].key);
        if (cmds[i].key == cmd) {
            found = i;
            break;
        }
    }

    if (found == -1) {
#if DEBUG_LEVEL!=0
        printlog(1, "Touche reue : %d\n", cmd);
#else
        fprintf(stderr, "");
#endif
        //fprintf(stderr, "    ---> CODE=%d\n", cmd);
        return CONT;
    }

    return cmds[found].fct();
}


void set_color(WINDOW *win, int color) {
    if (uses_color) {
        wattron(win, COLOR_PAIR(color));
    }
}


char *robust_home(const char *user) {
    if (! user) {
        if (getenv("HOME"))
            return getenv("HOME");
        else if (getenv("USER") && getpwnam(getenv("USER")))
            return getpwnam(getenv("USER"))->pw_dir;
        else if (getenv("LOGNAME") && getpwnam(getenv("LOGNAME")))
            return getpwnam(getenv("LOGNAME"))->pw_dir;
        else if (getpwuid(getuid()))
            return getpwuid(getuid())->pw_dir;
    } else {
        if (getpwnam(user))
            return getpwnam(user)->pw_dir;
    }
    return "/";
}

