/*
 * NETMAJ - network mahjongg -  Copyright Notice
 *     Copyright (C) 1994, 1995, 1996 Koji Suzuki (suz@kt.rim.or.jp)
 *
 *  You can redistribute it and/or modify this software under the terms 
 * of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 *  This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the author be held liable for any damages
 * arising from the use of this software.
 * See the gpl.text for more details.
 *
 *  If you would like to do something with NETMAJ that this copyright
 * prohibits (such as distributing it with a commercial product,
 * using portions of the source in some other program, etc.), please
 * contact the author (preferably via email).  Arrangements can
 * probably be worked out.
 *
 *  Koji Suzuki   : suz@kt.rim.or.jp
 */

/* $Id: cui.c,v 1.25 1996/08/06 17:24:30 suz Exp $ */
#include <curses.h>
#define QUICK_LOG "netmaj.ql"

#define xaddstr(s)	xwaddstr(stdscr,s)
#ifdef USE_WCHAR
xwaddstr(win,s) WINDOW *win; char *s; {
	wchar_t ch;
	while (*s) {
		if (*s & 0x80) {
			ch =    (((wchar_t)(s[1])&0x7f)<<7) 
			      | ((wchar_t)(s[0])&0x7f)
			      | 0x30000000;
			waddwch(win,ch);
			s += 2;
		}
		else
			waddch(win,*s++);
	}
}
#else
#define xwaddstr	waddstr
#endif

#include "pai.h"
#include "global.h"
#include "result.h"

#ifdef ASCII_MESSAGE
char *esc_str = "[ESC]";
char *tie_str = "TIE";
char *pon_str = "PON";
char *kan_str = "KAN";
char *ron_str = "RON";
char *reach_str = "REACH";
char *tumo_str = "TUMO";
char *kei[9] =  {"--"," |","-+","-+","-+"," +"," +","-+","-+"};
char *keib[9] = {"--"," |","-+","-+","-+"," +"," +","-+","-+"};
char *select_str = " # ";
char *mt_rest_str = "REST";
char *title_str1 = "NetWork";
char *title_str2 = " Mahjongg";
#else
char *esc_str = "";
char *tie_str = "";
char *pon_str = "ݥ";
char *kan_str = "";
char *ron_str = "";
char *reach_str = "꡼";
char *tumo_str = "ĥ";
char *kei[9] =  {"","","","","","","","",""};
char *keib[9] = {"","","","","","","","",""};
char *select_str = " ";
char *mt_rest_str = "Ĥ";
char *title_str1 = "Σף";
char *title_str2 = "  ͣ";
#endif

#ifdef ASCII_MESSAGE
#define UI_INIT	"\
\n\
  [][][][][][][][][]\n\
[]                  []\n\
[]                  []\n\
[]     NETwork      []\n\
[]                  []\n\
[]      MAhJongg    []\n\
[]                  []\n\
[]                  []\n\
  [][][][][][][][][]\n\
"

#define UI_INIT_PLVIEW	"\
\n\
  [][][][][][][][][]\n\
[]                  []\n\
[]                  []\n\
[]     NETwork      []\n\
[]      MAhJongg    []\n\
[]                  []\n\
[]   -- plview --   []\n\
[]                  []\n\
  [][][][][][][][][]\n\
"

#define UI_CONNECTING	"\
\n\
   connecting now  \n\
"

#define UI_CONNECT	"\
\n\
   connection is established  \n\
"

#define UI_DISCONNECT	"\
\n\
   connection is broken  \n\
"
#else
#define UI_INIT	"\
\n\
  \n\
\n\
\n\
   Σţwork     \n\
\n\
     ͣhongg  \n\
\n\
\n\
  \n\
"

#define UI_INIT_PLVIEW	"\
\n\
  \n\
\n\
\n\
   Σţwork     \n\
     ͣhongg  \n\
\n\
  plview  \n\
\n\
  \n\
"

#define UI_CONNECTING	"\
\n\
   Ф³Ǥ  \n\
"

#define UI_CONNECT	"\
\n\
   Ф³Ǥޤ  \n\
"

#define UI_DISCONNECT	"\
\n\
   ̿Ǥޤ  \n\
"
#endif

#ifdef ASCII_MESSAGE
char talk_messages[9][60] = {"1","2","3","4","5","6","7","8","9"};
#else
char talk_messages[9][60] = {
    "ͤޤ",
    "Ϥ䤯Ƥ",
    "äȤޤäƤ",
    "ä",
    "ޤä",
    "ä",
    "ޤä",
    "Ϲ!",
    "㡼",
};
#endif

extern FILE *log;
extern int play_speed;
extern int auto_stop;
extern int auto_play;
extern int auto_after_reach;
void ui_term();
char *msgGets();

extern int readable_socket;
extern int readable_key;
WINDOW *wstack[10];
int wstack_cnt;


extern int rv_fixed;
extern pai_t *cur_hand;
extern int view_river_all;

int prog_kind;
int in_choice;
int in_res;
int help_index;
#define HELP_PLAY	5
#define HELP_CHOICE	10
#define HELP_RES	15

int key_mac[100];
int key_mac_cnt=0;

ungetstrx(str) unsigned char *str; {
	int len;
	int i;
	unsigned char *p;

	len = strlen(str);
	p = str;
	for (i=0; i<len; i++) {
		key_mac[key_mac_cnt++] = *p++;
	}
}

getchx() {
	fd_set fds;
	struct timeval to;
	int fd;
	u_char buf[100];
	u_char buf2[100];
	int buf_len;
	int ret,i,c;

	to.tv_sec = 0;
	to.tv_usec = 400000;
retry:
	if (key_mac_cnt) {
		ret = key_mac[0];
		key_mac_cnt--;
		for (i=0; i<key_mac_cnt; i++)
			key_mac[i] = key_mac[i+1];
		return ret;
	}
	buf_len = 0;
check:
	buf[buf_len++] = getch();
	buf[buf_len] = 0;
	switch(match_mac(buf,buf2)) {
	case 0: /* not match */
		ungetstrx(buf);
		goto retry;
	case 1: /* to be continue */
		FD_ZERO( &fds );
		FD_SET(0, &fds);
		if (select( 1, &fds, (fd_set *)0, (fd_set *)0, &to) == 1) {
			goto check;
		} else {
			ungetstrx(buf);
			goto retry;
		}
	case 2: /* match */
		ungetstrx(buf2);
		goto retry;
	}
}

match_mac(str,ret_str) u_char *str,*ret_str; {
	static u_char *macs[10];
	static u_char *macs_val[10];
	static int macs_num=-1;
	int i,j,n,ret;
	int len;
	len = strlen(str);
	if (macs_num == -1) {
		macs_num=0;
#ifndef NO_KEYPAD
		if (KU) {
			macs[macs_num] = KU;
			macs_val[macs_num++] = "k";
		}
		if (KD) {
			macs[macs_num] = KD;
			macs_val[macs_num++] = "j";
		}
		if (KL) {
			macs[macs_num] = KL;
			macs_val[macs_num++] = "h";
		}
		if (KR) {
			macs[macs_num] = KR;
			macs_val[macs_num++] = "l";
		}
		if (K1) {
			macs[macs_num] = K1;
			macs_val[macs_num++] = "\033";
		}
#endif
	}
	
	ret = 0;
	for (i=0;i<macs_num;i++) {
		for (j=0; j<len; j++) {
			if (macs[i][j] != str[j]) break;
		}
		if (j == len) {
			ret = 1;
			if (strlen(macs[i]) == len) {
				strcpy(ret_str,macs_val[i]);
				return 2;
			}
		}
	}
	return ret;
}

ui_init(gp,kind) global_t *gp; int kind; {
	initscr();
	noecho();
	cbreak();
#ifndef NO_KEYPAD
	if (KS) puts(KS);
#endif
	pf_param_strn(gp,"talk_1",talk_messages[0],50);
	pf_param_strn(gp,"talk_2",talk_messages[1],50);
	pf_param_strn(gp,"talk_3",talk_messages[2],50);
	pf_param_strn(gp,"talk_4",talk_messages[3],50);
	pf_param_strn(gp,"talk_5",talk_messages[4],50);
	pf_param_strn(gp,"talk_6",talk_messages[5],50);
	pf_param_strn(gp,"talk_7",talk_messages[6],50);
	pf_param_strn(gp,"talk_8",talk_messages[7],50);
	pf_param_strn(gp,"talk_9",talk_messages[8],50);
	ui_draw(gp,1);

	prog_kind = kind;
	switch(kind) {
	case PROG_NETMAJ:
	case PROG_NETMAJ1:
		popup(UI_INIT,30);
		break;
	case PROG_PLVIEW:
		popup(UI_INIT_PLVIEW,30);
		break;
	}
}

void ui_term() {
#ifndef NO_KEYPAD
	if (KE) puts(KE);
#endif
	move(LINES-1,0);
	clrtoeol();
	refresh();
	endwin();
}

ui_key() {
	int ret;
retry:
	ret = getchx();
	if (ret == ('L' & 0x1f)) {
		allrefresh(1);
		goto retry;
	}
	return ret;
}

ui_event_wait(gp,time_out) global_t *gp; {
	fd_set fds;
	struct timeval to,*top;
	int fd,fd2;
	int maxfd;

	if (key_mac_cnt) {
		readable_key = 1;
		return;
	}

	top = 0;
	fd = callback_fd(gp);
	fd2 = callback_fd2(gp);

	if (readable_socket) {
		return;	
	}
	if (fd == -1) {
		return 1;
	}

	FD_ZERO( &fds );
	FD_SET(0, &fds);
	maxfd = 0;
	if (fd >= 0) {
		FD_SET(fd, &fds);
		maxfd = fd;
	}
	if (fd2 >= 0) {
		FD_SET(fd2, &fds);
		if (maxfd < fd2) maxfd = fd2;
	}
	if (time_out >= 0) {
		to.tv_sec = time_out/10;
		to.tv_usec = (time_out % 10)*100000;
		top = &to;
	}
	select(maxfd+1, &fds, (fd_set *)0, (fd_set *)0, top);
	if (FD_ISSET( 0, &fds)) 
		readable_key = 1;
	if ( (fd>0 && FD_ISSET( fd, &fds)) || (fd2>0 && FD_ISSET( fd2, &fds)))
		readable_socket = 1;
}

ui_message_connect() {
	cleanup_wstack();
	popup(UI_CONNECT,20);
}

ui_message_connecting() {
	popup(UI_CONNECTING,50);
}

ui_message_disconnect() {
	popup(UI_DISCONNECT,20);
}

ui_message_naki(i,kind) {
	char *str = "";
	if (kind == 0) str = tie_str;
	else if (kind == 1) str = pon_str;
	else if (kind == 2) str = kan_str;
	comment(i,1,str,7);
}

ui_message_reach(i) {
	comment(i,1,reach_str,7);
}

ui_message_tumo(i) {
	comment(i,1,tumo_str,20);
}

ui_message_ron(i) {
	comment(i,1,ron_str,20);
}

ui_message_play(gp) global_t *gp; {
	help_index = HELP_PLAY;
}

ui_message_gend(gp) global_t *gp; {
	int i,c;
	char buf[1024];

	sprintf(buf," --- game end --- \n\n");
	for (i=0; i<4; i++) {
		sprintf(buf+strlen(buf),"   %10s p %4d t %2d %6d\n"
			,player[i].name,player[i].rpoint,player[i].tpoint
			,player[i].rpoint * 100 + player[i].tpoint * 500);
	}
	c = popup(buf,auto_play?play_speed*5:(-1));
	if (c == 'l') {
		FILE *fp;
		fp = fopen(QUICK_LOG,"a");
		if (fp) {
			log_game(gp,fp);
			fclose(fp);
		}
	}
	if (log) log_game(gp,log);
}

ui_message_player(gp) global_t *gp; {
	int i;
	char buf[1024];

	sprintf(buf," --- player list --- \n\n");
	for (i=0; i<4; i++) {
		sprintf(buf+strlen(buf),"   %10s  \n"
			,player[i].name);
	}
	popup(buf,20);
}

ui_key_wto(time_out) {
	fd_set fds;
	struct timeval to,*top;
	int ret = 0;

	if (key_mac_cnt) {
		return ui_key();
	}
	top = 0;
	FD_ZERO( &fds );
	FD_SET(0, &fds);
	if (time_out >= 0) {
		to.tv_sec = time_out/10;
		to.tv_usec = (time_out % 10)*100000;
		top = &to;
	}
	select( 1, &fds, (fd_set *)0, (fd_set *)0, top);
	if (FD_ISSET( 0, &fds)) ret = ui_key();
	return ret;
}

ui_menu(gp,c) global_t *gp; int c; {
	char buf[256];
	char *args[20];
	int ret;

	if (c == 'q') { /* quick advice */
		ungetstrx("\033jjjjjj\n");
		return 1;
	}
	else if (c == 't') { /* quick talk */
#if 1
		ungetstrx("\033\n");
#else
		comment(self,0,buf);
		msgTalk(gp,buf);
#endif
		return 1;
	}
	else if (c == 'r') { /* quick run auto */
		ungetstrx("\033j\n\n");
		return 1;
	} else if ('1' <= c && c <= '9') {
#if 1
		strcpy(buf,"\033\n");
		strcat(buf,talk_messages[c - '1']);
		ungetstrx(buf);
#else
		strcpy(buf,talk_messages[c - '1']);
		msgTalk(gp,buf);
		comment(self,1,buf,20);
#endif
		return 1;
	}
	else if (c == ('d'&0x1f) || c == ('r'&0x1f)) { 
		do_disconnect(gp);
		return 1;
	}

	if (c != 033) return 0;

#ifdef ASCII_MESSAGE
#define MENU_LINE "----------"
	args[0] = " talk     ";
	args[1] = " run auto ";
	args[2] = MENU_LINE;
	args[3] = auto_play
		 ?" !auto    "
		 :" auto     ";
	args[4] = auto_after_reach
		 ?" !auto(R) "
		 :" auto(R)  ";
	args[5] = MENU_LINE;
	args[6] = " advice   ";
	args[7] = " help     ";
	args[8] = " rule     ";
	args[9] = MENU_LINE;
	args[10]= " replay   ";
	args[11]= " exit     ";
#else
#define MENU_LINE ""
	args[0] = " ȡ       ";
	args[1] = " auto ¹    ";
	args[2] = MENU_LINE;
	args[3] = auto_play
		 ?" ư     "
		 :" ư⡼   ";
	args[4] = auto_after_reach
		 ?" ꡼ư "
		 :" ꡼弫ư ";
	args[5] = MENU_LINE;
	args[6] = " ɥХ   ";
	args[7] = " إ       ";
	args[8] = " 롼       ";
	args[9] = MENU_LINE;
	args[10]= " ƥ     ";
	args[11]= " λ         ";
#endif


	ret = menu(11,args,0);

	switch(ret) {
	case 0:
		comment(self,0,buf,0);
		msgTalk(gp,buf);
		break;
	case 1:
		comment(self,0,buf,0);
		execute_auto(buf);
		break;
	case 7:
		execute_help(gp);
		break;
	case 3:
		auto_play = !auto_play;
		break;
	case 4:
		auto_after_reach = !auto_after_reach;
		break;
	case 8:
		popup(rule_message(),-1);
		break;
	case 10:
		do_disconnect(gp);
		break;
	case 11:
		term();
		break;
	case 6:
		if (in_choice) {
			int save,ask;
			save = ask_attr;
			analize(gp,vself);
			ask = ask_attr;
			ask_attr = save;
			sprintf(buf,"--- advice in choice ---\n\n");
			if (T_GET(ask) == T_HN_TSM) {
				sprintf(buf+strlen(buf),"   %s\n",tumo_str);
			}
			else if (T_GET(ask) == T_RV_RCH) {
				sprintf(buf+strlen(buf),"   %s(%s)\n"
					,pai2str(ask_pai),reach_str);
			}
			else {
				sprintf(buf+strlen(buf),"   %s\n"
					,pai2str(ask_pai));
			}
			sprintf(buf+strlen(buf),"%s",analize_message(gp));
			popup(buf,-1);
				
		}
		else if (in_res) {
			int ask,how;
			int save;

			save = ask_attr;
			ask = analize_res(gp,&how);
			ask_attr = save;
			sprintf(buf,"--- advice in responce ---\n\n");
			if (ask == R_TIE) {
				sprintf(buf+strlen(buf),"   %s(%s)\n"
					,tie_str,pai2str(how));
			}
			else if (ask == R_RON) {
				sprintf(buf+strlen(buf),"   %s\n"
					,ron_str);
			}
			else if (ask == R_PON) {
				sprintf(buf+strlen(buf),"   %s\n"
					,pon_str);
			}
			else if (ask == R_KAN) {
				sprintf(buf+strlen(buf),"   %s\n"
					,kan_str);
			}
			else {
				sprintf(buf+strlen(buf),"   %s\n"
					,esc_str);
			}
			popup(buf,-1);
		}
		break;
	}
	return 1;
}

ui_draw(gp,redraw) global_t *gp; {
	int i,j;

	if (redraw) {
		clear();
		ch_play = 1;
	}
	if (ch_play) {
		for (i=0; i<5; i++) {
			for(j = 0;j < COLS-3; j+=2)
				mvaddstr(2+i*5,j,kei[0]);
		}

		for (i=2; i<23; i++) {
			if (i==2) 
				mvaddstr(i,10,kei[2]);
			else if (i==22) 
				mvaddstr(i,10,kei[4]);
			else if (i%5 == 2)
				mvaddstr(i,10,kei[3]);
			else
				mvaddstr(i,10,kei[1]);
		}
		mvaddstr(0,24,kei[1]);
		mvaddstr(1,24,kei[1]);
		mvaddstr(2,24,kei[4]);
		mvaddstr(0,54,kei[1]);
		mvaddstr(1,54,kei[1]);
		mvaddstr(2,54,kei[4]);
	}
	draw_status(gp);
	for (i=0; i<4; i++) {
		draw_player(gp,i);
		draw_river(gp,i);
		draw_hand(gp,i);
	}
	ch_point = 0;

	/* print talk message if LINES > 28 */
	if (LINES >= 26) {
	    mvprintw(24,0," 1: %-22s 2: %-22s 3: %-22s"
		,talk_messages[0] ,talk_messages[1] ,talk_messages[2]);
	}
	if (LINES >= 27) {
	    mvprintw(25,0," 4: %-22s 5: %-22s 6: %-22s"
		,talk_messages[3] ,talk_messages[4] ,talk_messages[5]);
	}
	if (LINES >= 28) {
	    mvprintw(26,0," 7: %-22s 8: %-22s 9: %-22s"
		,talk_messages[6] ,talk_messages[7] ,talk_messages[8]);
	}

	move(LINES-1,0);
	refresh();
	ch_play = 0;
}

draw_status(gp) global_t *gp; {

	if (!ch_dora && !ch_play) return;
	ch_dora = 0;

	move(0,0);
	xaddstr(bturn_names[big_turn]);
	printw(" %d ",small_turn+1);
	xaddstr(sturn_sfx);
	printw(" %d ",small_turn_cnt);
	xaddstr(sturn_cnt_sfx);
	printw(" ");
	xaddstr(rest_str);
	printw(" %d",rest_point);

	move(0,27);
	xaddstr(dora_str);
	printw("     ");
	xaddstr(pai2str(mt_dora(gp,0)));
	xaddstr(pai2str(mt_dora(gp,1)));
	xaddstr(pai2str(mt_dora(gp,2)));
	xaddstr(pai2str(mt_dora(gp,3)));
	xaddstr(pai2str(mt_dora(gp,4)));

	move(0,57);
	xaddstr(title_str1);
	clrtoeol();

	move(1,11);
	xaddstr(mt_rest_str);
	printw(" %3d",mt_rest(gp));

	move(1,27);
	xaddstr(uradora_str);
	printw(" ");
	xaddstr(pai2str(mt_uradora(gp,0)));
	xaddstr(pai2str(mt_uradora(gp,1)));
	xaddstr(pai2str(mt_uradora(gp,2)));
	xaddstr(pai2str(mt_uradora(gp,3)));
	xaddstr(pai2str(mt_uradora(gp,4)));

	move(1,57);
	xaddstr(title_str2);
	clrtoeol();
}


draw_player(gp,who) global_t *gp; {
	int i;
	int pp;

	if (!ch_play && !ch_point) return;

	pp = pplayer[who];
	move(pp * 5 + 3, 0);
	xaddstr(home_names[who]);
	printw(" %s",((who + small_turn)%4 == 0)?"<>":"");

	move(pp * 5 + 4, 0);
	xaddstr("          ");
	move(pp * 5 + 4, 0);
	xaddstr(player[pp].name);

	move(pp * 5 + 5, 0);
	printw("  %7d ",player[pp].gpoint);

	move(pp * 5 + 6, 0);
	printw("  %7d ",player[pp].ppoint);
}

draw_river(gp,who) global_t *gp; {
	int i,pai;
	int pp;
	int max;

	if (!ch_river[who] && !ch_play) return;
	ch_river[who] = 0;

	for (max=0; max <RIVER_MAX; max++) {
		if (!rv[who][max].in && !rv[who][max].out)
			break;
	}
	pp = pplayer[who];
	move(pp * 5 + 3, 12);
	for (i=0; i< max; i++) {
		pai = rv[who][i].in;
		if (pai && pai == rv[who][i].out) pai = P_INV3;
		else if (!view_river_all)
			pai = P_NULL;
		xaddstr(pai2str(pai));
	}
	clrtoeol();

	move(pp * 5 + 4, 12);
	for (i=0; i< max; i++) {
		pai = rv[who][i].out;
		if (!rv_fixed && rvp == &(rv[who][i]))
			standout();
		xaddstr(pai2str(pai));
		if (!rv_fixed && rvp == &(rv[who][i]))
			standend();
	}
	clrtoeol();

	move(pp * 5 + 5, 12);
	for (i=0; i< max; i++) {
		xaddstr(attr2str(rv[who][i].attr));
	}
	clrtoeol();
}

draw_hand(gp,who) global_t *gp; {
	int i,j,k,n;
	int pp,pai,naki;

	if (!ch_hand[who] && !ch_play) return;
	ch_hand[who] = 0;

	pp = pplayer[who];
	move(pp * 5 + 6, 12);
	for (i=0; i< hand[who].closed_num; i++) {
		if (cur_hand == &hand[who].closed[i])
			standout();
		xaddstr(pai2str(hand[who].closed[i]));
		if (cur_hand == &hand[who].closed[i])
			standend();
	}

	n = hand[who].closed_num;
	if (n!=14 && n!=11 && n!=8 && n!=5 && n != 2) {
		addstr("   ");
	}
	i++;

	naki = 0;
	for (j=3; j>=0; j--) {
		if (hand[who].opened_kind[j]) naki++;
		else addstr(" ");
	}
		
	if (naki) {
	    addstr("  ");
	    for (j=3; j>=0; j--) {
		if (hand[who].opened_kind[j]) {
		    addstr("/");
		    for (k=0; k<4; k++) {
			if (k==3 && (hand[who].opened_kind[j] == H_TIE 
			            || hand[who].opened_kind[j] == H_PON))
				break;
			pai = hand[who].opened[j][k];
			if (hand[who].opened_kind[j] == H_KAN_CLOSED
			    && (k==1 || k==2)) pai = P_INV;
			xaddstr(pai2str(pai));
			i++;
		    }
		}
	    }
	    addstr("/");
	}
	clrtoeol();
}

ui_res(gp,howp) global_t *gp; int *howp; {
	int c,i,j,n,ret,pai;
	char *args[25];
	int pais[25];
	char *args1[5];
	static char *st[2]={ "< >", "<T>" };
	int save;

	args1[0] = esc_str;
	args1[1] = tie_str;
	args1[2] = pon_str;
	args1[3] = kan_str;
	args1[4] = ron_str;

	save = help_index;
	help_index = HELP_RES;
	n = hand[vself].closed_num;
retry:
	*howp = 0;
	c = 0;

	if (auto_stop) {
		result_t y;
		if (!hand[vself].reach
			&& (T_GET(rvp->attr)!=T_HN_KAN )
			&& (T_GET(rvp->attr)!=T_HN_KAN_C)) {
			if (hand_can_pon(gp,vself,rvp->out)
			 || (hand_can_kan(gp,vself,rvp->out) == 2)
			 || ((cur_player+1)%4==vself
			      && hand_can_tiex(gp,vself,rvp->out)))
				c = ' ';
		}
		if (c == 0) {
			hand_insert(gp,vself,rvp->out);
			if (result_calc_yaku(gp,vself,&y) > 0)
			    c = ' ';
			hand_delete(gp,vself,rvp->out,0);
		}
	} 
	if (c != ' ') {
		c = ui_key_wto(play_speed);
	}

	if (c == 0 || c != ' ') {
		help_index = save;
		return R_ACK;
	}
	in_res = 1;
	ret = choice(gp,5,args1,st[0],0,-1 * n);
	in_res = 0;
	switch(ret) {
		case 0:
			help_index = save;
			return R_ACK;
		case 1:
			break;
		case 2:
			help_index = save;
			return R_PON;
		case 3:
			help_index = save;
			return R_KAN;
		case 4:
			help_index = save;
			return R_RON;
	}
	if ((cur_player+1)%4 != vself) goto retry;

	args[0] = esc_str;
	i = 1;
	for (j=0; j<n; j++) {
		pai = hand[vself].closed[j];
		if (i != 1 && P_KIND(pai) == P_KIND(pais[i-1]))
			continue;
		if (hand_can_tie(gp,vself,rvp->out,pai)) {
			pais[i] = pai;
			args[i] = pai2str(pai);
			i++;
		}
	}
	if (i == 1) goto retry;
	if (i == 2) {
		*howp = pais[1];
		help_index = save;
		return R_TIE;
	}
	in_res = 1;
	ret = choice(gp,i,args,st[1],0,-1 * n);
	in_res = 0;
	if (ret == 0) goto retry;
	*howp = pais[ret];
	help_index = save;
	return R_TIE;
}

ui_choice(gp) global_t *gp; {
	int i,j,n,ret,pai,oldpai,kan;
	char *args[25];
	int pais[25];
	int mode = 0;
	int save;
	static char *st[3]={ "< >", "<R>", "<K>" };

	save = help_index;
	help_index = HELP_CHOICE;
loop:
	n = hand[vself].closed_num;
	for (i=0; i<n; i++) {
		args[i] = pai2str(hand[vself].closed[i]);
	}
	args[i++] = reach_str;
	args[i++] = kan_str;
	args[i++] = tumo_str;
	in_choice = 1;
	ret = choice(gp,n+3,args,st[mode],n-1,n);
	in_choice = 0;
	if (ret < n) {
		ask_pai = hand[vself].closed[ret];
	}
	else if (ret == n) {
		mode = (mode==1)?0:1;
		ask_attr = (mode==1)?T_RV_RCH:T_RV;
		goto loop;
	}
	else if (ret == n+1) {
		args[0] = esc_str;
		oldpai = -1;
		n = hand[vself].closed_num;
		i = 1;
		for (j=0; j<n; j++) {
			pai = hand[vself].closed[j];
			kan = hand_can_kan(gp,vself,pai);
			if ((kan == 3 || kan == 1)
				 && P_KIND(pai) != oldpai) {
				pais[i] = pai;
				args[i] = pai2str(pai);
				i++;
				oldpai = P_KIND(pai);
			}
		}
		if (i == 1) goto loop;
		if (i == 2) {
			ask_attr = T_HN_KAN;
			ask_pai  = pais[1];
			help_index = save;
			return;
		}
		ret = choice(gp,i,args,st[2],0,-1 * n);
		if (ret == 0) goto loop;
		ask_pai = pais[ret];
		ask_attr = T_HN_KAN;
		help_index = save;
		return;
	}
	else if (ret == n+2) {
		ask_attr = T_HN_TSM;
	}
	help_index = save;
}


ui_result(gp) global_t *gp; {
	int p,i,c;
	int quick_log=0;
	int iy[4];
	char buf[1024];

	for (p=0; p<4; p++) if (result[p].flag) {
		result_cvt_to_int(result+p,iy);
		sprintf(buf,"-- %s --\n"
			,result_names[result[p].flag]);
		sprintf(buf+strlen(buf),"%s %5d %s %5d %s %5d %s %5d\n\n"
			,home_names[0],result[p].points[0]
			,home_names[1],result[p].points[1]
			,home_names[2],result[p].points[2]
			,home_names[3],result[p].points[3]);
		if (result[p].fan) {
			sprintf(buf+strlen(buf),"   %d %s %d %s\n\n"
				,result[p].fu,fu_sfx
				,result[p].fan,fan_sfx);
		}
		for (i=0; i<Y_MAX;i++) if (result_str[i] && Y_GET(iy,i)) {
			sprintf(buf+strlen(buf),"   %-16s   \n",result_str[i]);
		}
		if (result[p].dora)
			sprintf(buf+strlen(buf),"   %-16s %d\n"
				,dora_str,result[p].dora);
		if (result[p].uradora)
			sprintf(buf+strlen(buf),"   %-16s %d\n"
				,uradora_str,result[p].uradora);
		if (result[p].akadora)
			sprintf(buf+strlen(buf),"   %-16s %d\n"
				,akadora_str,result[p].akadora);
		c = popup(buf,auto_play?play_speed*5:(-1));
		if (c=='l') quick_log = 1;
	}
	if (quick_log) {
		FILE *fp;
		fp = fopen(QUICK_LOG,"a");
		if (fp) {
			log_play(gp,fp);
			fclose(fp);
		}
	}
	if (log) log_play(gp,log);
}


/*-----------------*/

comment(who,mode,buf,timeout) u_char *buf; {
	WINDOW *msg_win;
	WINDOW *msg_box=0;
	int i,j,c;
	int xsize,ysize,xbeg,ybeg;
	u_char *p;

	xsize = mode?(strlen(buf)+1)/2*2:40;
	ysize = 1;
	xbeg = 12;
	ybeg = who * 5 + 3;

	if (who != 4) {
		msg_box = newwin(ysize+2,xsize+4,ybeg-1,xbeg-2);
		wstack[wstack_cnt++] = msg_box;

		for(j = 0;j < xsize+4; j+=2) {
			mvwaddstr(msg_box,0,j,keib[0]);
			mvwaddstr(msg_box,ysize+1,j,keib[0]);
		}
		for (i=0; i<ysize+2; i++) {
			mvwaddstr(msg_box,i,0,keib[1]);
			mvwaddstr(msg_box,i,xsize+2,keib[1]);
		}
		mvwaddstr(msg_box, 0, 0     ,keib[5]);
		mvwaddstr(msg_box,ysize+1, 0,keib[6]);
		mvwaddstr(msg_box, 0,xsize+2,keib[7]);
		mvwaddstr(msg_box,ysize+1,xsize+2,keib[8]);
		touchwin(msg_box);
		wrefresh(msg_box);
	}

	msg_win = newwin(ysize,xsize,ybeg,xbeg);
	wstack[wstack_cnt++] = msg_win;
	wclear(msg_win);
	touchwin(msg_win);
	wmove(msg_win,0,0);
	if (mode) {
		xwaddstr(msg_win,buf);
		wrefresh(msg_win);
		ui_key_wto(timeout);
	} else {
		wrefresh(msg_win);
		p = buf;
		while((c=ui_key())!='\n') {
			if (c == '\b' || c == 0177) {
				if (p != buf) {
					p--;
					wmove(msg_win,0,p-buf);
					wdelch(msg_win);
				}
				if ((*p & 0x80) && p!=buf) {
					p--;
					wmove(msg_win,0,p-buf);
					wdelch(msg_win);
				}
			} else {
				if (c < 0x20) {
					*p++ = '^';
					waddch(msg_win,'^');
					c += 0x40;
				}
				*p++ = c;
				waddch(msg_win,c);
				if (c & 0x80) {
					c = ui_key();
					*p++ = c;
					waddch(msg_win,c);
				}
			}
			wrefresh(msg_win);
		}
		*p++ = 0;
	}
	delwin(msg_win);
	wstack_cnt--;
	if (msg_box) {
		delwin(msg_box);
		wstack_cnt--;
	}
	allrefresh(0);
}

popup(buf,time_out) u_char *buf; {
	WINDOW *msg_win;
	WINDOW *msg_box;
	int i,j,max_j,c;
	int xsize,ysize,xbeg,ybeg;
	u_char *p;

	i=1; max_j=0; j=0;
	p = buf;
	while(c = *p++) {
		if (c == '\n') {
			i++;
			if (j > max_j) max_j = j;
			j=0;
		}
		else
			j++;
	}

	xsize = (max_j+1)/2*2;
	ysize = i;

	if (ysize < 1) ysize = 2;

	xbeg = (COLS - xsize) /4 * 2 + 1;
	ybeg = (LINES -ysize) /2;

	msg_box = newwin(ysize+2,xsize+4,ybeg-1,xbeg-2);
	wstack[wstack_cnt++] = msg_box;

	for(j = 0;j < xsize+4; j+=2) {
		mvwaddstr(msg_box,0,j,keib[0]);
		mvwaddstr(msg_box,ysize+1,j,keib[0]);
	}
	for (i=0; i<ysize+2; i++) {
		mvwaddstr(msg_box,i,0,keib[1]);
		mvwaddstr(msg_box,i,xsize+2,keib[1]);
	}
	mvwaddstr(msg_box, 0, 0,keib[5]);
	mvwaddstr(msg_box,ysize+1, 0,keib[6]);
	mvwaddstr(msg_box, 0,xsize+2,keib[7]);
	mvwaddstr(msg_box,ysize+1,xsize+2,keib[8]);
	msg_win = newwin(ysize,xsize,ybeg,xbeg);
	wstack[wstack_cnt++] = msg_win;
	wclear(msg_win);

	touchwin(msg_box);
	touchwin(msg_win);
	wrefresh(msg_box);

	wmove(msg_win,0,0);
	i=0;
	p = buf;
	while(c = *p++) {
		if (c == '\n') {
			i++;
			wmove(msg_win,i,0);
		} else
			waddch(msg_win,c);
	}
	wrefresh(msg_win);

	c = ui_key_wto(time_out);
	delwin(msg_win);
	wstack_cnt--;
	delwin(msg_box);
	wstack_cnt--;
	allrefresh(0);
	return c;
}


choice(gp,argc,argv,st,cur,n) global_t *gp; int argc; u_char *argv[]; char *st; int cur; {
	WINDOW *choice_window;
	WINDOW *arrow_window=0;
	int xbase,xwidth,xsize,ysize,xbeg,ybeg;
	int i,j,c;
	int choiced = cur;

	ysize = 1;
	ybeg = 7 + self * 5;
	xbase = 12;
	xwidth = 3;
	xbeg = xbase;
	xsize = strlen(st) + 3;
	for (i=0; i<argc; i++) {
		xsize += strlen(argv[i]);
	}

	if (n < 0) {
		/*xsize += n * 3;*/
		xbeg -= n * 3;
	} else {
		xsize -= n * 3;
		xbeg += n * 3;
	}

	choice_window = newwin(ysize,xsize,ybeg,xbeg);
	touchwin(choice_window);
	wstack[wstack_cnt++] = choice_window;

	while(1) {
		if (arrow_window) {
			delwin(arrow_window);
			wstack_cnt--;
			touchwin(stdscr);
			refresh();
			arrow_window = 0;
		}
		wmove(choice_window,0,0);
		for (i=0; i<argc; i++) {
			if (i<n) {
				if (i==choiced) {
				    arrow_window = 
				     newwin(ysize,xwidth,ybeg,xbase+(xwidth*i));
				    touchwin(arrow_window);
				    wstack[wstack_cnt++] = arrow_window;
				    wmove(arrow_window,0,0);
				    wprintw(arrow_window,select_str);
				    wrefresh(arrow_window);
				} 
			} else {
				if (i==choiced)
					wstandout(choice_window);
				xwaddstr(choice_window,argv[i]);
				if (i==choiced)
					wstandend(choice_window);
			}
		}
		wprintw(choice_window," ");
		xwaddstr(choice_window,st);
		wclrtoeol(choice_window);
		wrefresh(choice_window);
retry:
		ui_event_wait(gp,-1);
		if (readable_socket) {
			callback(gp);
			goto retry;
		}
		if (!readable_key) {
			goto retry;
		}
		readable_key = 0;
		c=ui_key();

		if (ui_menu(gp,c)) {
			goto retry;
		}

		if (c == '\n' || c == ' ') {
			break;
		}
		else if (c == '.' || c == 'k' || c == 'x' || c == 'l') {
			choiced = (choiced + 1)%argc;
		}
		else if (c == ',' || c == 'j' || c == 'z' || c == 'h') {
			choiced = (choiced - 1 + argc)%argc;
		}
	}

	if (arrow_window) {
		delwin(arrow_window);
		wstack_cnt--;
	}
	delwin(choice_window);
	wstack_cnt--;
	touchwin(stdscr);
	refresh();
	return choiced;
}

menu(argc,argv,cur) int argc; u_char *argv[]; int cur; {
	WINDOW *msg_win;
	WINDOW *msg_box;
	int xsize,ysize,xbeg,ybeg;
	int i,j,c,max;
	int choiced = cur;

	max = 0;
	for (i=0; i<argc; i++) {
		if (strlen(argv[i]) > max)
			max = strlen(argv[i]);
	}
	xsize = max;
	ysize = argc;
	xbeg = (COLS - max) / 8 * 2 - 1;
	ybeg = (LINES - argc) /4;

	msg_box = newwin(ysize+2,xsize+4,ybeg-1,xbeg-2);
	wstack[wstack_cnt++] = msg_box;
	msg_win = newwin(ysize,xsize,ybeg,xbeg);
	wstack[wstack_cnt++] = msg_win;

	for(j = 0;j < xsize+4; j+=2) {
		mvwaddstr(msg_box,0,j,keib[0]);
		mvwaddstr(msg_box,ysize+1,j,keib[0]);
	}
	for (i=0; i<ysize+2; i++) {
		mvwaddstr(msg_box,i,0,keib[1]);
		mvwaddstr(msg_box,i,xsize+2,keib[1]);
	}
	mvwaddstr(msg_box, 0, 0,keib[5]);
	mvwaddstr(msg_box,ysize+1, 0,keib[6]);
	mvwaddstr(msg_box, 0,xsize+2,keib[7]);
	mvwaddstr(msg_box,ysize+1,xsize+2,keib[8]);

	touchwin(msg_box);
	wrefresh(msg_box);
	touchwin(msg_win);

	while(1) {
		for (i=0; i<argc; i++) {
			wmove(msg_win,i,0);
			if (i==choiced)
				wstandout(msg_win);
			xwaddstr(msg_win,argv[i]);
			if (i==choiced)
				wstandend(msg_win);
		}
		wrefresh(msg_win);
		c=ui_key();
		if (c == 033) {
			choiced = -1;
			break;
		}
		else if (c == '\n' || c == ' ') {
			break;
		}
		else if (c == '.' || c == 'j' || c == 'x') {
			choiced = (choiced + 1)%argc;
		}
		else if (c == ',' || c == 'k' || c == 'z') {
			choiced = (choiced - 1 + argc)%argc;
		}
	}

	delwin(msg_win);
	wstack_cnt--;
	delwin(msg_box);
	wstack_cnt--;
	allrefresh(0);
	return choiced;
}

allrefresh(force) {
	int i;
	if (force) {
		WINDOW *tmp;
		tmp = newwin(LINES,COLS,0,0);
		wclear(tmp);
		touchwin(tmp);
		wrefresh(tmp);
		delwin(tmp);
	}

	touchwin(stdscr);
	refresh();
	for (i=0; i< wstack_cnt; i++) {
		touchwin(wstack[i]);
		wrefresh(wstack[i]);
	}
}

cleanup_wstack() {
	int i;
	for (i=0; i< wstack_cnt; i++) {
		delwin(wstack[i]);
	}
	wstack_cnt = 0;
}

execute_help(gp) global_t *gp; {
	extern char *program;
	static char *pages[500];
	static int page_num;
	char *p;
	char buf[256];
	char file[256];
	char page[20*80];
	FILE *fp;
	int i,c,n;
	int cur_page,cur_top;

	if (p = getenv("NETMAJ_LIB")) {
		strcpy(file,p);
		strcat(file,"/");
		strcat(file,"netmaj.hlp");
	} else {
		sprintf(file,"%s/%s", NETMAJ_LIB, "netmaj.hlp");
	}


	if (page_num == 0) {
		fp = fopen(file,"r");
		if (!fp) return;

		page[0] = 0;
		for (page_num = 0; page_num < 500;page_num++) {
			for (i=0; i<20;) {
				if (!fgets(buf,80,fp)) {
					if (i > 0) page_num++;
					goto skip;
				}
				if (buf[0] == '#') continue;
				if (!strncmp(buf,"%%",2)) break;
				strcat(page,buf);
				i++;
			}
			pages[page_num] = malloc(strlen(page)+1);
			strcpy(pages[page_num],page);
			page[0] = 0;
		}
skip:
		if (page_num) {
			pages[page_num-1] = malloc(strlen(page));
			strcpy(pages[page_num-1],page);
		}
		fclose(fp);
	}

	if (page_num != 0) {
		cur_page = cur_top = 0;
		if (help_index < page_num)
			cur_page = cur_top = help_index;

		for (;;) {
			c = popup(pages[cur_page],-1);
			switch(c) {
			case 'p':
			case '\b':
				if (cur_page > cur_top) cur_page--;
				break;
			case '\033':
			case 'q':
				return;
			default:
				if (cur_page < page_num &&
					pages[cur_page+1][0]) cur_page++;
			}
		}
	}
}
