#TRUSTED 9462f856966b5faa1de42cd2d7bc39de7355dca332e6b3a3756c1cebe4bda42b57cfc3fd9b194ee8a9467590b5a9b625cd42c3e856b13dc4669c3459f822ef1069bc09444204f6da93c58268311245164d4f2d74ec48b86f157389d9d04eda79a3e9114c71ab533867277a47e828e6b5bde076b32ee83071b018b05b6919a2c40d6372baaf6c9d7b26043b94d779d80f0b0ed2ca5307763e75250f81f3e91761d42396f630ffcb49efdf80d695a151920b5c40b1ef69ec74e399eadfc287e6763dce80f797ac09f42098416ca7d4051c3acc32ea477b14b88cbf5b5085d79eaf06c70b469e72b8c6bc4f14ac0dc073aa2479a62c0fe2a36be4d650ebbe2558e39081a9ee837ff1326141e4bceadc0f0284d61b150e1a2018d9c2a8b721e3e0a24d62328f8aed3312e9bfd56851dfdc99ed8f0a36a02747da3a7562c74f13ddf907049669377cdd4e0a3a1d289348ee9e45870d14ac834a84e1efbe7bfabc7c20be528f1915e75ddb10fa7b8af5fe1025234fd6ef0540536f7d3c6f950d1985346304e26787337b5e15c9e53cae71bde59782ffdd446f39bddf2e2526796640a93260252fad85d64789a73c752e977f9be73a34cbb760f511509fe626b19d1a04f15b6890e642ca7ded8e8027fe3f27c765fd9cb0cec72559982529728e3136ba1bf4bee751ff5c9e231cd0204d7f27685c25a24794c6a8dbe61a81c37d89dab7
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15890);
 script_version ("1.1");
 name["english"] = "Hydra: VNC";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find VNC passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force VNC authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_ports("Services/vnc", 5900);
# We are not able to detect VNC... yet
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd == NULL) exit(0);

port = get_kb_item("Services/vnc");
if (! port) port = 5900;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-P"; argv[i++] = passwd;
if (empty)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "vnc";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/vnc/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to find the following VNC passwords:\n' + report);
