#TRUSTED 44005e7f1ef4d785bc6017e66f8556f86c02b5e0f3641e4ef558f547375b9d257eda70a1910a32639e25d4269ba950fcf59f06b45c04be6c1486d95e64eb185085dfefc6a1fdf6658324858cdc243fe18cdbf7b066d983d7cc32f17815a0cca882991d4fdc34afedd0a716f3537b9aae130a6f8ee706a0335ded89e1d9ba7e641a0d5b782d96025dc3e4138249155bada3713a97f0b756f9e111ec8ed0d36f20ff9d3e22c5d39444cdd1cddac8f103c97abae14bd29edcae2ae48a5375cd91ddfc74d01f86dc996fec34470ed36c565285e79863c92b97dc3bcc3a819948a69c5241cc3f9af5c6ac5d9708d5ad4c40eff4950922c24dd91f4098e9f86acb48c3f7bec6f5927283a2492ff2baf8fb6eb15685e7d9055845fcdd039df6525ea81b3b4931e7a16acf35b7c396e88aeeeebe657026fcd51d265b32f618b5be828f86deb06cb10984895b49456e2b5a1d072ec3da1d350932b0ff00ee11835c2b9dcb8ebe4733bae086c837900bd583c3a351d9ad8714f9b0819675104667b6f95c8dcb907c57e7fd98b1266d12df04596a92fde2716b84b7c6cdfd35c752d93541b125b135f42acd82e2c3ecc3f1122229e7917ad00607c610d1d7c0e2d9825ea2af88bd84bc056eb94cc934842bfb8efb59f0d83e0509ecb4d49f9b254fcfb1656ba88873b198a44a363dd6cb9eddacb14e9fa033a3f827a3c27564e9e9011f2c44
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15877);
 script_version ("1.2");
 name["english"] = "Hydra: LDAP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find LDAP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force LDAP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "DN : ", type: "entry", value: "");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ldap", 389);
 # find_service does not detect LDAP yet, so we rely upon amap
 # However find_services will detect the SSL layer for LDAPS
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "external_svc_ident.nasl");
 exit(0);
}

#

thorough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< thorough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/ldap");
if (! port) port = 389;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

dn = script_get_preference("DN : ");
if (! dn) exit(0);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ldap";
argv[i++] = dn;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/ldap/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the LDAP server:\n' + report);
