#TRUSTED a6f5955a29326aea352e088da84ac2b8ed6359d5992be59f0a0e1ae9462e22c379046c66169e9764451d9fa9b0a10d58fe7ece31528909350081b3546b6dc42d3fd3a05bd3ff52d4a184337d5a475423233c85fbbfae3598a9cd837b34810469c6cd976e25c271492a53907b3359e39654e3f7f8ed50439b71b32c8ca7d9721d13201ad9f8f2a549e1c415c0b41166e493873a1765921f651d1617d6173400473e587194b8a9caa23e5c34f6fb9e2cee3c70dfa98fadbac5707121b42a8a0a7002bda0c8bd914f43434916010a7d166d914432b4cff8d53972d1505251af4b0c659750a68b1c462d4970c3bc4a05981b50ef21cb77e5e0ce4aca3f0fa346f9a8acf600b7c8bd20098c05663d563a073c8d71ce211d5362db417ec00c7bb3eafc08854bb0ad372e4003160bcd402890adfcbacb92b573419b3638fdfbf802a5957db7ca3dcba93b5e19cbacae6d9632f707840edc8177a02b2a2a6fef07d7b317f4c94503efce64fe5f13d08d57589a737557d9ba451bd3a0b4c252adc13f14bdafb3489aa03e49d790a80f00990b3cd6c95a158d37acc630d9c638f7bee487047b4ecae7f1b15e7bde08f476b3f065a2c0a2f5b498da0bd44933aabc0dbd0353423cd54b8cf6f7b5637247c48c9446bdbd96a603f7ce6cc1b3be613fc8aa9c975b871896091d0c6b0eb33fefeb8d497a2de8d3f8ee921656764db591e26a988d
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15875);
 script_version ("1.2");
 name["english"] = "Hydra: ICQ";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find ICQ accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force ICQ authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/icq", 5190);
 script_dependencies("hydra_options.nasl", "find_service.nes");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/icq");
if (! port) port = 5190;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "icq";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/icq/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following ICQ accounts:\n' + report);
