#TRUSTED 22ae393431df6c5301d450f2e8a0078f7c5bb02a6fd02a99d9da4d4522e6da21379ffecc69f858ccb848b15310f851b6586492d0dfe0c7b487619d937f97c0364e1b23e2e9795b01de7101fcd3af654632d8d5f19e6dd52b9c7ba65338f7449dd8d729f2853e65e3a5a07060dcbb267567fbd152b45f659b321b6db0136064fd3fa104f31c4af797784dfefea843b0935b06aa040b408ef9b7c16cc10d54a210087358f676639c3ac7fecb14e34bd4dc8a1beb59386f3c1524a4f1e8e75ef25840d2da89d7970332d48f42cef2923e93db51ec61c2e78fc5ed3538dee009de315602b1cefc6454f6ca32784a257e3c01c0daef2ea3887c09ee4d211bfd1c9b3b4041c3fa2262a2dd84d8a00c501e7a4062501f5d18e0d2bb128aa001614312753a0d84e70d5040693057703ff5285e80e7839c4b2b32c6f88caa5a4b469f07b7475728b675e368578000289501cd2bd119cc7418a696fe6f8f1e5e8c9b9a2c8f7b5c2969073af3dd0c72d00a748564fc10a26d15daad12878844659fe13ae172c330f57be3fabeb6be4bf891cc7794b6e40de952d3d836aaccbe5c2cd91060adea252e313f26f42a2b9b20850309095f36441ec9e90c4c9a0dd7884ae258013b29e7da280cb7db155b7ddef0ac29d731914b96cb2d115038693b62a3cc53bb5b1240406387f76241c8be0f695f48eac7ece2797ad5de4545a9edc8c1d95a7b84
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15874);
 script_version ("1.2");
 name["english"] = "Hydra: HTTP proxy";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find HTTP proxy accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force HTTP proxy authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "Web site (optional) :", value: "", type: "entry");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/http_proxy", 3128);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/http_proxy");
if (! port) port = 3128;
if (! get_port_state(port)) exit(0);

# www.suse.com by default
opt = script_get_preference("Site (optional) :");
if (!opt) site = 'http://www.suse.com/';
else if (opt !~ '^(http|ftp)://') site = strcat('http://', opt);
else site = opt;
host = ereg_replace(string: site, pattern: '^(ftp|http://)([^/]+@)?([^/]+)/.*',
	replace: "\3");
if (host == site)
 req = 'GET '+site+' HTTP/1.0\r\n\r\n';
else
 req = 'GET '+site+' HTTP/1.1\r\nHost: '+host+'\r\n\r\n';
s = open_sock_tcp(port);
if (!s) exit(0);
send(socket: s, data: req);
r = recv_line(socket: s, length: 1024);
close(s);
if (r =~ "^HTTP/1\.[01] +[234]0[0-9] ") exit(0);	# Proxy is not protected

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "http-proxy";

if (opt) argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/http-proxy/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the HTTP proxy:\n' + report);
