#TRUSTED 6a359ba421b941d55c45e75269aae5735ad2050396f38549a808025db4ee01aa5cd4eaa297bce019f5a89b8e107399852e5c500c517a9653cc9bf3a64b1d6ead0977d42c83026f63a4e4a71743b0e95640c0436017a75ce53013a6960b921669db5b519db6e38e83b0064c77b80241b09af61e33fe5af0ace857a01e229fb23b4241df5df5d3caa8202252ee2d034289d72ef0cbc5d1cb47bafddb9c9550766956e26b52cc8a8cc4743b2c338c86a424ec9b8b4b206d7047f9a9b18857c60fd2f5330d881cf768e999a04344f28e0f3e61fad4b597a32e92525f84d13226af46acbf10548ec6cc9cb71186f0033e7d5ff68b2ba5b49d62756b6af73ee723c5d12ffd0c0448ad4c04333e0905e0bac1919646bfa2a144a890aef82f86671fc6b88d3889e666752a7efd50e1a3725dfc8adba1cacfc667269be1c2adfd9f8115bc107b41f6ef31f17ac8f79f909a1341085bd61012a837dad744e5ce28b27fbcc6fd3019c24ad1a09cb821c89f2525951a3faa19769fe85ab2e8581b5e65d77cf59911bf12ed3882825e3c5aaa399d62a2d73a9d60460423d38a7d7664593b1b8dbf4a9a0a6c251899c69a576128f91340658ea0e539053075de74a1903cb537cf7cd0b2ff9307794f14681e355e5a8b37254708b693af5df14e6ea1b9fcefac15cef1e1c10b3ff7a5e53987c4308f6e6aab823fabf84a176e325c165db2605b84
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15869);
 script_version ("1.2");
 name["english"] = "Hydra: Cisco";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Cisco passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force Cisco authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_ports("Services/telnet", 23);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd == NULL) exit(0);

port = get_kb_item("Services/telnet");
if (! port) port = 23;
if (! get_port_state(port)) exit(0);
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv(socket: soc, length: 1024);
close(soc);
if ("Password:" >!< r) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-P"; argv[i++] = passwd;
if (empty)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "cisco";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    # l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/cisco/'+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to find the following CISCO passwords:\n' + report);
