# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200408-25.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2004 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(14581);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200408-25");
 script_xref(name: "OSVDB", value: "8194");
 script_xref(name: "OSVDB", value: "8195");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200408-25
(MoinMoin: Group ACL bypass)


    MoinMoin contains two unspecified bugs, one allowing anonymous users
    elevated access when not using ACLs, and the other in the ACL handling in
    the PageEditor.
  
Impact

    Restrictions on anonymous users were not properly enforced. This could lead
    to unauthorized users gaining administrative access to functions such as
    "revert" and "delete". Sites are vulnerable whether or
    not they are using ACLs.
  
Workaround

    There is no known workaround.
  
References:
    https://sourceforge.net/project/shownotes.php?group_id=8482&release_id=254801
    http://www.osvdb.org/displayvuln.php?osvdb_id=8194
    http://www.osvdb.org/displayvuln.php?osvdb_id=8195


Solution: 
    All users should upgrade to the latest available version of MoinMoin, as
    follows:
    # emerge sync
    # emerge -pv ">=net-ww/moinmoin-1.2.3"
    # emerge ">=net-ww/moinmoin-1.2.3"
  

Risk Factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2004 Michel Arboi");
 script_name(english: "[GLSA-200408-25] MoinMoin: Group ACL bypass");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'MoinMoin: Group ACL bypass');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-www/moinmoin", unaffected: make_list("ge 1.2.3"), vulnerable: make_list("le 1.2.2")
)) { security_warning(0); exit(0); }
