/*
 * Decompiled with CFR 0.152.
 */
package viewer.histogram;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import viewer.zoomable.ActionPptyPrint;
import viewer.zoomable.ActionPptyRefresh;
import viewer.zoomable.ActionPptyStop;
import viewer.zoomable.ActionTimelineDelete;
import viewer.zoomable.ActionTimelineMark;
import viewer.zoomable.ActionTimelineMove;
import viewer.zoomable.ActionVportBackward;
import viewer.zoomable.ActionVportDown;
import viewer.zoomable.ActionVportForward;
import viewer.zoomable.ActionVportUp;
import viewer.zoomable.ActionYaxisTreeCollapse;
import viewer.zoomable.ActionYaxisTreeCommit;
import viewer.zoomable.ActionYaxisTreeExpand;
import viewer.zoomable.ActionZoomHome;
import viewer.zoomable.ActionZoomIn;
import viewer.zoomable.ActionZoomOut;
import viewer.zoomable.ActionZoomRedo;
import viewer.zoomable.ActionZoomUndo;
import viewer.zoomable.ModelTime;
import viewer.zoomable.RowAdjustments;
import viewer.zoomable.ScrollbarTime;
import viewer.zoomable.ToolBarStatus;
import viewer.zoomable.ViewportTimeYaxis;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class StatlineToolBar
extends JToolBar
implements ToolBarStatus {
    private Window root_window;
    private ViewportTimeYaxis canvas_vport;
    private JScrollBar y_scrollbar;
    private YaxisTree y_tree;
    private YaxisMaps y_maps;
    private ScrollbarTime time_scrollbar;
    private ModelTime time_model;
    private RowAdjustments row_adjs;
    private JButton mark_btn;
    private JButton move_btn;
    private JButton delete_btn;
    private JButton up_btn;
    private JButton down_btn;
    private JButton expand_btn;
    private JButton collapse_btn;
    private JButton commit_btn;
    private JButton backward_btn;
    private JButton forward_btn;
    private JButton zoomUndo_btn;
    private JButton zoomOut_btn;
    private JButton zoomHome_btn;
    private JButton zoomIn_btn;
    private JButton zoomRedo_btn;
    private JButton refresh_btn;
    private JButton print_btn;
    private JButton stop_btn;

    public StatlineToolBar(Window window, ViewportTimeYaxis viewportTimeYaxis, JScrollBar jScrollBar, YaxisTree yaxisTree, YaxisMaps yaxisMaps, ScrollbarTime scrollbarTime, ModelTime modelTime, RowAdjustments rowAdjustments) {
        this.root_window = window;
        this.canvas_vport = viewportTimeYaxis;
        this.y_scrollbar = jScrollBar;
        this.y_tree = yaxisTree;
        this.y_maps = yaxisMaps;
        this.time_scrollbar = scrollbarTime;
        this.time_model = modelTime;
        this.row_adjs = rowAdjustments;
        this.addButtons();
        this.canvas_vport.setToolBarStatus(this);
    }

    public void init() {
        this.initAllButtons();
    }

    protected URL getURL(String string) {
        URL uRL = null;
        uRL = this.getClass().getResource(string);
        return uRL;
    }

    private void addButtons() {
        Insets insets = new Insets(2, 2, 2, 2);
        Dimension dimension = new Dimension(5, 5);
        URL uRL = this.getURL("/images/Up24.gif");
        this.up_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Up");
        this.up_btn.setMargin(insets);
        this.up_btn.setToolTipText("Scroll Upward by half a screen");
        this.up_btn.addActionListener(new ActionVportUp(this.y_scrollbar));
        this.up_btn.setMnemonic(38);
        super.add(this.up_btn);
        uRL = this.getURL("/images/Down24.gif");
        this.down_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Down");
        this.down_btn.setMargin(insets);
        this.down_btn.setToolTipText("Scroll Downward by half a screen");
        this.down_btn.setMnemonic(40);
        this.down_btn.addActionListener(new ActionVportDown(this.y_scrollbar));
        super.add(this.down_btn);
        super.addSeparator(dimension);
        uRL = this.getURL("/images/Edit24.gif");
        this.mark_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("LabelMark");
        this.mark_btn.setMargin(insets);
        this.mark_btn.setToolTipText("Mark the timelines");
        this.mark_btn.addActionListener(new ActionTimelineMark(this.root_window, this, this.y_tree));
        super.add(this.mark_btn);
        uRL = this.getURL("/images/Paste24.gif");
        this.move_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("LabelMove");
        this.move_btn.setMargin(insets);
        this.move_btn.setToolTipText("Move the marked timelines");
        this.move_btn.addActionListener(new ActionTimelineMove(this.root_window, this, this.y_tree));
        super.add(this.move_btn);
        uRL = this.getURL("/images/Delete24.gif");
        this.delete_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("LabelDelete");
        this.delete_btn.setMargin(insets);
        this.delete_btn.setToolTipText("Delete the marked timelines");
        this.delete_btn.addActionListener(new ActionTimelineDelete(this.root_window, this, this.y_tree));
        super.add(this.delete_btn);
        super.addSeparator(dimension);
        uRL = this.getURL("/images/TreeExpand24.gif");
        this.expand_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("LabelExpand");
        this.expand_btn.setMargin(insets);
        this.expand_btn.setToolTipText("Expand the Y-axis tree label by 1 level");
        this.expand_btn.setMnemonic(69);
        this.expand_btn.addActionListener(new ActionYaxisTreeExpand(this, this.y_tree));
        super.add(this.expand_btn);
        uRL = this.getURL("/images/TreeCollapse24.gif");
        this.collapse_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("LabelCollapse");
        this.collapse_btn.setMargin(insets);
        this.collapse_btn.setToolTipText("Collapse the Y-axis tree label by 1 level");
        this.collapse_btn.setMnemonic(67);
        this.collapse_btn.addActionListener(new ActionYaxisTreeCollapse(this, this.y_tree));
        super.add(this.collapse_btn);
        uRL = this.getURL("/images/TreeCommit24.gif");
        this.commit_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("LabelCommit");
        this.commit_btn.setMargin(insets);
        this.commit_btn.setToolTipText("Commit changes and Redraw the TimeLines Display");
        this.commit_btn.setMnemonic(68);
        this.commit_btn.addActionListener(new ActionYaxisTreeCommit(this.root_window, this, this.canvas_vport, this.y_maps, this.row_adjs));
        super.addSeparator();
        super.addSeparator();
        uRL = this.getURL("/images/Backward24.gif");
        this.backward_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Backward");
        this.backward_btn.setMargin(insets);
        this.backward_btn.setToolTipText("Scroll Backward by half a screen");
        this.backward_btn.setMnemonic(37);
        this.backward_btn.addActionListener(new ActionVportBackward(this.time_scrollbar));
        super.add(this.backward_btn);
        uRL = this.getURL("/images/Forward24.gif");
        this.forward_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Forward");
        this.forward_btn.setMargin(insets);
        this.forward_btn.setToolTipText("Scroll Forward by half a screen");
        this.forward_btn.setMnemonic(39);
        this.forward_btn.addActionListener(new ActionVportForward(this.time_scrollbar));
        super.add(this.forward_btn);
        super.addSeparator(dimension);
        uRL = this.getURL("/images/WinUndo.gif");
        this.zoomUndo_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("ZoomUndo");
        this.zoomUndo_btn.setMargin(insets);
        this.zoomUndo_btn.setToolTipText("Undo the previous zoom operation");
        this.zoomUndo_btn.setMnemonic(85);
        this.zoomUndo_btn.addActionListener(new ActionZoomUndo(this, this.time_model));
        super.add(this.zoomUndo_btn);
        super.addSeparator(dimension);
        uRL = this.getURL("/images/ZoomOut24.gif");
        this.zoomOut_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("ZoomOut");
        this.zoomOut_btn.setMargin(insets);
        this.zoomOut_btn.setToolTipText("Zoom Out by 1 level in time");
        this.zoomOut_btn.setMnemonic(79);
        this.zoomOut_btn.addActionListener(new ActionZoomOut(this, this.time_model));
        super.add(this.zoomOut_btn);
        uRL = this.getURL("/images/Home24.gif");
        this.zoomHome_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("ZoomHome");
        this.zoomHome_btn.setMargin(insets);
        this.zoomHome_btn.setToolTipText("Reset zoom to the initial resolution in time");
        this.zoomHome_btn.setMnemonic(72);
        this.zoomHome_btn.addActionListener(new ActionZoomHome(this, this.time_model));
        super.add(this.zoomHome_btn);
        uRL = this.getURL("/images/ZoomIn24.gif");
        this.zoomIn_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("ZoomIn");
        this.zoomIn_btn.setMargin(insets);
        this.zoomIn_btn.setToolTipText("Zoom In iby 1 level in time");
        this.zoomIn_btn.setMnemonic(73);
        this.zoomIn_btn.addActionListener(new ActionZoomIn(this, this.time_model));
        super.add(this.zoomIn_btn);
        super.addSeparator(dimension);
        uRL = this.getURL("/images/WinRedo.gif");
        this.zoomRedo_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("ZoomRedo");
        this.zoomRedo_btn.setMargin(insets);
        this.zoomRedo_btn.setToolTipText("Redo the previous zoom operation");
        this.zoomRedo_btn.setMnemonic(82);
        this.zoomRedo_btn.addActionListener(new ActionZoomRedo(this, this.time_model));
        super.add(this.zoomRedo_btn);
        super.addSeparator(dimension);
        super.addSeparator();
        super.addSeparator();
        uRL = this.getURL("/images/Refresh24.gif");
        this.refresh_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("CanvasReDraw");
        this.refresh_btn.setMargin(insets);
        this.refresh_btn.setToolTipText("Redraw canvas to synchronize changes from Preference/Legend window or Yaxis label panel");
        this.refresh_btn.setMnemonic(68);
        this.refresh_btn.addActionListener(new ActionPptyRefresh(this.y_tree, this.commit_btn));
        super.add(this.refresh_btn);
        uRL = this.getURL("/images/Print24.gif");
        this.print_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Print");
        this.print_btn.setMargin(insets);
        this.print_btn.setToolTipText("Print the Statline window");
        this.print_btn.addActionListener(new ActionPptyPrint());
        super.add(this.print_btn);
        uRL = this.getURL("/images/Stop24.gif");
        this.stop_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Exit");
        this.stop_btn.setMargin(insets);
        this.stop_btn.setToolTipText("Exit the Statline window");
        this.stop_btn.addActionListener(new ActionPptyStop(this.root_window));
        super.add(this.stop_btn);
    }

    private void initAllButtons() {
        this.up_btn.setEnabled(true);
        this.down_btn.setEnabled(true);
        this.mark_btn.setEnabled(true);
        this.move_btn.setEnabled(false);
        this.delete_btn.setEnabled(false);
        this.resetYaxisTreeButtons();
        this.backward_btn.setEnabled(true);
        this.forward_btn.setEnabled(true);
        this.resetZoomButtons();
        this.refresh_btn.setEnabled(true);
        this.print_btn.setEnabled(false);
        this.stop_btn.setEnabled(true);
    }

    public void resetZoomButtons() {
        int n = this.time_model.getZoomLevel();
        this.zoomIn_btn.setEnabled(n < 30);
        this.zoomHome_btn.setEnabled(n != 0);
        this.zoomOut_btn.setEnabled(n > 0);
        this.zoomUndo_btn.setEnabled(!this.time_model.isZoomUndoStackEmpty());
        this.zoomRedo_btn.setEnabled(!this.time_model.isZoomRedoStackEmpty());
    }

    public void resetYaxisTreeButtons() {
        this.expand_btn.setEnabled(this.y_tree.isLevelExpandable());
        this.collapse_btn.setEnabled(this.y_tree.isLevelCollapsable());
        this.commit_btn.setEnabled(true);
    }

    public JButton getYaxisTreeCommitButton() {
        return this.commit_btn;
    }

    public JButton getPropertyRefreshButton() {
        return this.refresh_btn;
    }

    public JButton getTimelineMarkButton() {
        return this.mark_btn;
    }

    public JButton getTimelineMoveButton() {
        return this.move_btn;
    }

    public JButton getTimelineDeleteButton() {
        return this.delete_btn;
    }
}

