/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.DrawOrderComparator;
import base.drawable.Drawable;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import logformat.slog2.BufForObjects;
import logformat.slog2.input.TreeFloor;
import logformat.slog2.input.TreeNode;

public class TreeFloorList {
    private static final short NULL_DEPTH = -1;
    private static final DrawOrderComparator DRAWING_ORDER = new DrawOrderComparator();
    private TreeFloor[] floors = null;
    private short lowest_depth = (short)-1;

    protected void init(short s) {
        this.floors = new TreeFloor[s + 1];
        for (int i = this.floors.length - 1; i >= 0; --i) {
            this.floors[i] = new TreeFloor((short)i);
        }
        this.lowest_depth = s;
    }

    public BufForObjects getRoot() {
        return (BufForObjects)this.floors[this.floors.length - 1].firstKey();
    }

    public void put(BufForObjects bufForObjects, BufForObjects bufForObjects2) {
        short s = bufForObjects.getTreeNodeID().depth;
        this.floors[s].put(bufForObjects, bufForObjects2);
        if (s < this.lowest_depth) {
            this.lowest_depth = s;
        }
    }

    public TreeNode get(BufForObjects bufForObjects) {
        short s = bufForObjects.getTreeNodeID().depth;
        if (this.floors[s].size() == 0) {
            return null;
        }
        return (TreeNode)this.floors[s].get(bufForObjects);
    }

    public boolean contains(BufForObjects bufForObjects) {
        short s = bufForObjects.getTreeNodeID().depth;
        if (this.floors[s].size() == 0) {
            return false;
        }
        return this.floors[s].containsKey(bufForObjects);
    }

    public void remove(BufForObjects bufForObjects) {
        short s = bufForObjects.getTreeNodeID().depth;
        if (this.floors[s].size() > 0) {
            this.floors[s].remove(bufForObjects);
        }
    }

    public void updateLowestDepth() {
        for (int n = 0; n < this.floors.length; n = (int)((short)(n + 1))) {
            if (this.floors[n].size() <= 0) continue;
            this.lowest_depth = (short)n;
            break;
        }
    }

    public short getLowestDepth() {
        return this.lowest_depth;
    }

    public void removeAllChildFloorsBelow(short s) {
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            if (this.floors[s2].size() <= 0) continue;
            this.floors[s2].clear();
        }
        this.lowest_depth = s;
    }

    public TreeFloor getLowestFloor() {
        return this.floors[this.lowest_depth];
    }

    public TreeFloor getCoveringFloor(TimeBoundingBox timeBoundingBox) {
        for (int i = this.lowest_depth; i < this.floors.length; ++i) {
            if (!this.floors[i].covers(timeBoundingBox)) continue;
            return this.floors[i];
        }
        return this.floors[this.floors.length - 1];
    }

    public TreeFloor pruneToBarelyCoveringFloor(TimeBoundingBox timeBoundingBox) {
        for (int i = this.lowest_depth; i < this.floors.length; ++i) {
            if (this.floors[i].coversBarely(timeBoundingBox)) {
                return this.floors[i];
            }
            this.floors[i].pruneToBarelyCovering(timeBoundingBox);
        }
        return this.floors[this.floors.length - 1];
    }

    public Iterator iteratorOfAllDrawables(TimeBoundingBox timeBoundingBox, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            return new ForeItrOfDrawables(timeBoundingBox, bl, bl3, true);
        }
        return new BackItrOfDrawables(timeBoundingBox, bl, bl3, true);
    }

    public Iterator iteratorOfRealDrawables(TimeBoundingBox timeBoundingBox, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            return new ForeItrOfDrawables(timeBoundingBox, bl, bl3, false);
        }
        return new BackItrOfDrawables(timeBoundingBox, bl, bl3, false);
    }

    public Iterator iteratorOfLowestFloorShadows(TimeBoundingBox timeBoundingBox, boolean bl, boolean bl2) {
        return this.floors[this.lowest_depth].iteratorOfShadows(timeBoundingBox, bl, bl2);
    }

    public String toStubString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.floors.length - 1; i >= 0; --i) {
            stringBuffer.append(this.floors[i].toStubString() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.floors.length - 1; i >= 0; --i) {
            stringBuffer.append("\n" + this.floors[i].toStubString() + "\n");
            stringBuffer.append(this.floors[i].toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString(TimeBoundingBox timeBoundingBox) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iteratorOfRealDrawables(timeBoundingBox, bl, bl2, true);
        int n = 1;
        while (iterator.hasNext()) {
            stringBuffer.append(n + ", " + iterator.next() + "\n");
            ++n;
        }
        iterator = this.iteratorOfRealDrawables(timeBoundingBox, bl, bl2, false);
        while (iterator.hasNext()) {
            stringBuffer.append(n + ", " + iterator.next() + "\n");
            ++n;
        }
        Iterator iterator2 = this.iteratorOfLowestFloorShadows(timeBoundingBox, bl2, true);
        n = 1;
        while (iterator2.hasNext()) {
            stringBuffer.append(n + ", " + iterator2.next() + "\n");
            ++n;
        }
        iterator2 = this.iteratorOfLowestFloorShadows(timeBoundingBox, bl2, false);
        while (iterator2.hasNext()) {
            stringBuffer.append(n + ", " + iterator2.next() + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toFloorString(TimeBoundingBox timeBoundingBox) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.floors.length - 1; i >= 0; --i) {
            stringBuffer.append("\n" + this.floors[i].toStubString() + "\n");
            Iterator iterator = this.floors[i].iteratorOfDrawables(timeBoundingBox, bl, bl2, bl3);
            int n = 1;
            while (iterator.hasNext()) {
                stringBuffer.append("    " + n + ", " + iterator.next() + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ DrawOrderComparator access$000() {
        return DRAWING_ORDER;
    }

    private class BackItrOfDrawables
    implements Iterator {
        private static final boolean IS_BACK_ITR = false;
        private TreeMap map_obj2itr = new TreeMap(TreeFloorList.access$000());
        private Drawable this_floor_obj;
        private Iterator this_floor_itr;
        private Drawable next_floor_obj;
        private double next_floor_starttime;

        public BackItrOfDrawables(TimeBoundingBox timeBoundingBox, boolean bl, boolean bl2, boolean bl3) {
            for (int i = TreeFloorList.this.floors.length - 1; i >= TreeFloorList.this.lowest_depth; --i) {
                this.this_floor_itr = TreeFloorList.this.floors[i].iteratorOfDrawables(timeBoundingBox, bl, false, bl2);
                if (!this.this_floor_itr.hasNext()) continue;
                this.this_floor_obj = (Drawable)this.this_floor_itr.next();
                this.map_obj2itr.put(this.this_floor_obj, this.this_floor_itr);
            }
            if (bl3) {
                this.this_floor_itr = TreeFloorList.this.floors[TreeFloorList.this.lowest_depth].iteratorOfShadows(timeBoundingBox, false, bl2);
                if (this.this_floor_itr.hasNext()) {
                    this.this_floor_obj = (Shadow)this.this_floor_itr.next();
                    this.map_obj2itr.put(this.this_floor_obj, this.this_floor_itr);
                }
            }
            try {
                this.this_floor_obj = (Drawable)this.map_obj2itr.lastKey();
                this.this_floor_itr = (Iterator)this.map_obj2itr.remove(this.this_floor_obj);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.this_floor_obj = null;
                this.this_floor_itr = null;
                this.next_floor_obj = null;
                this.next_floor_starttime = Double.NEGATIVE_INFINITY;
            }
            try {
                this.next_floor_obj = (Drawable)this.map_obj2itr.lastKey();
                this.next_floor_starttime = this.next_floor_obj.getEarliestTime();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.next_floor_obj = null;
                this.next_floor_starttime = Double.NEGATIVE_INFINITY;
            }
        }

        public boolean hasNext() {
            return this.this_floor_obj != null;
        }

        public Object next() {
            Drawable drawable = this.this_floor_obj;
            this.this_floor_obj = null;
            try {
                if (this.this_floor_itr.hasNext()) {
                    this.this_floor_obj = (Drawable)this.this_floor_itr.next();
                    if (this.this_floor_obj.getEarliestTime() < this.next_floor_starttime) {
                        Iterator iterator = (Iterator)this.map_obj2itr.remove(this.next_floor_obj);
                        this.map_obj2itr.put(this.this_floor_obj, this.this_floor_itr);
                        this.this_floor_obj = this.next_floor_obj;
                        this.this_floor_itr = iterator;
                        this.next_floor_obj = (Drawable)this.map_obj2itr.lastKey();
                        this.next_floor_starttime = this.next_floor_obj.getEarliestTime();
                    }
                } else {
                    this.this_floor_obj = this.next_floor_obj;
                    if (this.this_floor_obj != null) {
                        this.this_floor_itr = (Iterator)this.map_obj2itr.remove(this.this_floor_obj);
                        this.next_floor_obj = (Drawable)this.map_obj2itr.lastKey();
                        this.next_floor_starttime = this.next_floor_obj.getEarliestTime();
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.next_floor_obj = null;
                this.next_floor_starttime = Double.NEGATIVE_INFINITY;
            }
            return drawable;
        }

        public void remove() {
        }
    }

    private class ForeItrOfDrawables
    implements Iterator {
        private static final boolean IS_FORE_ITR = true;
        private TreeMap map_obj2itr = new TreeMap(TreeFloorList.access$000());
        private Drawable this_floor_obj;
        private Iterator this_floor_itr;
        private Drawable next_floor_obj;
        private double next_floor_starttime;

        public ForeItrOfDrawables(TimeBoundingBox timeBoundingBox, boolean bl, boolean bl2, boolean bl3) {
            for (int i = TreeFloorList.this.floors.length - 1; i >= TreeFloorList.this.lowest_depth; --i) {
                this.this_floor_itr = TreeFloorList.this.floors[i].iteratorOfDrawables(timeBoundingBox, bl, true, bl2);
                if (!this.this_floor_itr.hasNext()) continue;
                this.this_floor_obj = (Drawable)this.this_floor_itr.next();
                this.map_obj2itr.put(this.this_floor_obj, this.this_floor_itr);
            }
            if (bl3) {
                this.this_floor_itr = TreeFloorList.this.floors[TreeFloorList.this.lowest_depth].iteratorOfShadows(timeBoundingBox, true, bl2);
                if (this.this_floor_itr.hasNext()) {
                    this.this_floor_obj = (Shadow)this.this_floor_itr.next();
                    this.map_obj2itr.put(this.this_floor_obj, this.this_floor_itr);
                }
            }
            try {
                this.this_floor_obj = (Drawable)this.map_obj2itr.firstKey();
                this.this_floor_itr = (Iterator)this.map_obj2itr.remove(this.this_floor_obj);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.this_floor_obj = null;
                this.this_floor_itr = null;
                this.next_floor_obj = null;
                this.next_floor_starttime = Double.POSITIVE_INFINITY;
            }
            try {
                this.next_floor_obj = (Drawable)this.map_obj2itr.firstKey();
                this.next_floor_starttime = this.next_floor_obj.getEarliestTime();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.next_floor_obj = null;
                this.next_floor_starttime = Double.POSITIVE_INFINITY;
            }
        }

        public boolean hasNext() {
            return this.this_floor_obj != null;
        }

        public Object next() {
            Drawable drawable = this.this_floor_obj;
            this.this_floor_obj = null;
            try {
                if (this.this_floor_itr.hasNext()) {
                    this.this_floor_obj = (Drawable)this.this_floor_itr.next();
                    if (this.next_floor_starttime < this.this_floor_obj.getEarliestTime()) {
                        Iterator iterator = (Iterator)this.map_obj2itr.remove(this.next_floor_obj);
                        this.map_obj2itr.put(this.this_floor_obj, this.this_floor_itr);
                        this.this_floor_obj = this.next_floor_obj;
                        this.this_floor_itr = iterator;
                        this.next_floor_obj = (Drawable)this.map_obj2itr.firstKey();
                        this.next_floor_starttime = this.next_floor_obj.getEarliestTime();
                    }
                } else {
                    this.this_floor_obj = this.next_floor_obj;
                    if (this.this_floor_obj != null) {
                        this.this_floor_itr = (Iterator)this.map_obj2itr.remove(this.this_floor_obj);
                        this.next_floor_obj = (Drawable)this.map_obj2itr.firstKey();
                        this.next_floor_starttime = this.next_floor_obj.getEarliestTime();
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.next_floor_obj = null;
                this.next_floor_starttime = Double.POSITIVE_INFINITY;
            }
            return drawable;
        }

        public void remove() {
        }
    }
}

