# Ming/Slide
# $Id: $
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

require 'ming/slide/slidemovie'
require 'ming/slide/slidepage'
require 'uconv'

$KCODE = 'e'

class SlideItem

  # Adaptor Pattern
  CODING_SYSTEM = 'euc'

  attr_reader :width, :height

  def initialize(page, component)
	@page = page
	@clip = page.clip
	@style = page.style
	@component = component
	@display_p = false
	@block = []
	@item = []

	@default_text_color = [0, 0, 0]

	initialize_hook

	__send__('init_' + @style)
  end

  def initialize_hook
  end

  def set_default_color(obj)
	r, g, b = @default_text_color
	obj.set_color(r, g, b)
  end

  def display
	@display_p = true

	pre_hook = 'display_pre_' + @style
	__send__(pre_hook) if respond_to?(pre_hook)

	@block.each do |b|
	  @item.push  @clip.add(b)
	end

	__send__('display_' + @style)

  end

  def displayed?
	@display_p
  end

  def convert(string)
	case CODING_SYSTEM
	  when 'e', 'euc'
	  return Uconv.euctou8(string)
	  else
	  raise
	end
  end

  def size(rect)
	lx, ly = rect[0]
	rx, ry = rect[1]

	[rx - lx, ry - ly]
  end

  def reduce_blank(idx, dx, dy)
	@page.reduce_blank(idx, dx, dy)
  end

  def origin_blank(idx)
	@page.blank[idx][0]
  end

end

class Headline < SlideItem 
  
  def initialize(page, component)
	@string = convert(component[0])
	@level = component[1]

	super(page, component)
  end

end

class TextBlock < SlideItem

  def initialize(page, component)
	@string = component

	super(page, component)
  end

end

class Verbatim < SlideItem
  
  def initialize(page, component)
	@page = page
	@component = component
	@string = convert(component)

	super(page, component)
  end

end

class ItemList < SlideItem

  def initialize(page, component)
	@string = convert(component[0])
	@level = component[1]

	super(page, component)
  end

end

class EnumList < SlideItem

  def initialize(page, component)
	@string = convert(component[0])
	@level = component[1]
	@counter = component[2]

	super(page, component)
  end

end

class DescList < SlideItem

  def initialize(page, component)
	@string = convert(component)

	super(page, component)
  end

end
