
#include <stdlib.h>

#include <qtimer.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "main.h"
#include "pref.h"
#include "misc.h"

#include "bubbles.h"

kfishBubble::kfishBubble( QCanvas *c, QCanvasPixmapArray *pa )
              : QObject( c )
              , QCanvasSprite( pa, c )
{
    // set the pixmap sequence
    setSequence( pa );

    setZ( 0 );
    // at first i set false, becouse i don't have width and height
    setAnimated( true );     // allow animation

    subdiv = 1;

    init();

    show();
    
}

void kfishBubble::slotAdvance()
{
    posy--;
    if ( posy < -4 )
    {
        // if the bubble is over the top of the widget, i start the positions again
        init();
    }
}

void kfishBubble::slotResized()
{
    subdiv = kfishPref::prefs() -> getPanelHeight() / 4;
    init();
    setAnimated( true );
}

void kfishBubble::advance( int phase )
{
    // change the bubble position and maybe the kind of bubble itself
    if (phase != 0)
        move(posx, posy, (int) posy / subdiv);
}

void kfishBubble::init()
{
    posx = rand() % kfishPref::prefs() -> getPanelWidth();
    posy = kfishPref::prefs() -> getPanelHeight() + rand() % kfishPref::prefs() -> getPanelHeight();
}

        
kfishBubbleManager::kfishBubbleManager( QCanvas *canvas, QObject *parent, const char *name )
              : QObject( parent , name )
			  , m_canvas( canvas )
{
    getAnimationFromFile( &m_bubbles, locate("data", "kfish/pics/bubbles.png"), 6, 7, 4, Vertical, 0, 0);

	m_timer = new QTimer( this, "Bubble Manager Timer" );	
   
    // set the number of bubble we will have
    m_numOfBubbles = kfishPref::prefs() -> getBubblesNumber();
	    
    for (int i = 0; i < m_numOfBubbles; i++)
        addBubble();

    m_timer -> start(20);
		    
	connect(m_canvas, SIGNAL( resized() ), SIGNAL( signalResized() ));
	connect(kfishApp, SIGNAL( signalSettingsChanged() ), SLOT( slotSettingsChanged() ));
}

kfishBubbleManager::~kfishBubbleManager()
{
    m_timer -> stop();
    delete m_timer;
}

void kfishBubbleManager::slotChangeNumberOfBubbles( int newnum )
{
    // get the number of bubbles
    int bubcount = int ( m_listBubble .count() );

    if ( newnum == bubcount )
        return;
    m_numOfBubbles = newnum;
    
    if ( newnum > bubcount )
    {
        for (int i=0; i < newnum - bubcount; i++)
            addBubble();
    }
    else
    {
        for (int i=0; i < bubcount - newnum; i++)
            delBubble();
    }
}

void kfishBubbleManager::slotSettingsChanged()
{
//    kdDebug(1210) << "void kfishBubbleManager::slotSettingsChanged()" << endl;
    slotChangeNumberOfBubbles( kfishPref::prefs() -> getBubblesNumber() );
}

bool kfishBubbleManager::addBubble()
{
    kfishBubble *newbub = new kfishBubble( m_canvas, m_bubbles );
    connect( m_timer, SIGNAL( timeout() ), newbub, SLOT( slotAdvance() ));
    connect( this, SIGNAL( signalResized() ), newbub, SLOT( slotResized() ));
   
    m_listBubble .append( newbub );
    return true;
}

bool kfishBubbleManager::delBubble()
{
    delete m_listBubble .first();
    return m_listBubble .removeFirst( );
}
