/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                                   *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 /*
  * Last modified: $Date: 2005/02/14 21:10:33 $ by $Author: juergenk $
  */
  
#ifndef _KAFFEINE_H_
#define _KAFFEINE_H_


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <kparts/part.h>

#include <qptrlist.h>
#include <qtimer.h>
#include <qsplitter.h>

#include "kaffeineiface.h"

class KToggleAction;
class KActionMenu;
class KRecentFilesAction;
class KToggleFullScreenAction;
class KMediaPart;
class PlayList;
class StartWindow;
class SystemTray;
class MRL;
class TabWidget;
class PlayerContainer;
#ifdef HAVE_LINUX_DVB_FRONTEND_H
class DvbPanel;
#endif

/**
 *
 * @author Jürgen Kofler <kaffeine@gmx.net>
 *
 */
class Kaffeine : public KMainWindow, public KaffeineIface
{
    Q_OBJECT
public:
    Kaffeine(const QStringList& urls = QStringList(), const QStringList& engineParameters = QStringList(), 
             const QString device = QString::null, bool instantPlay = false, bool fullscreen = false, bool wizard = false,
             QWidget* parent = 0, const char* name = 0);
    virtual ~Kaffeine();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load(const QStringList&);
    void load(const QString&);
    void loadTMP(const QStringList&); //load to temporary playlist
    
    void setDevice(const QString& device) { m_device = device; }
    
    /*
     * DCOP functions...
     */
    void openURL(QString url);
    void appendURL(QString url);
    void play();
    void playAudioCD();
    void playVCD();
    void playDVD();
    void pause();
    void stop();
    void next();
    void previous();
    bool isPlaying();
    QString title();
    QString getFileName();
    void random();
    void fullscreen();
    int getLength();
    int getTimePos();
    void posPlus();
    void posMinus();
    void volUp();
    void volDown();
    void mute();
    void quit();
    void dvbSetChannelNumber( int num );
    void dvbNext();
    void dvbPrevious();
    void dvbOSD();
    
public slots:
    void slotPlay(const MRL&);
    void slotLoadURLS(const QStringList&);
    void slotSwitchToPlayerWindow();

protected:
    void showEvent(QShowEvent*);
    void hideEvent(QHideEvent*); 

protected:
   void closeEvent(QCloseEvent*);
 //  void dragEnterEvent(QDragEnterEvent*);
 //  void dropEvent(QDropEvent*);
   void mouseDoubleClickEvent(QMouseEvent*);
   void mouseMoveEvent(QMouseEvent*);
   void mousePressEvent(QMouseEvent*);
   void resizeEvent(QResizeEvent*);
    
private slots:
    void slotOpenFile();
    void slotQuit();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void applyNewToolbarConfig();
    void slotFakeKeyEvent();
    void slotSetScreensaverTimeout(int);
    void slotChangeCaption(const QString&);
    void slotChangeStatusbar(const QString&);
    void slotChangePlaylistStatus(const QString&);
    void slotOpenURL();
    void slotOpenDirectory();
    void slotOpenDVD();
    void slotOpenVCD();
    void slotOpenAudioCD();
    void slotPlaylistPlay();
    void slotPlaylistNext();
    void slotPlaylistPrevious();
    void slotPlaylistNew();
    void slotPlaylistLoad();
    void slotPlaylistSaveAs();
    void slotPlaylistRemove();
    void slotRepeat();
    void slotShuffle();
    void slotPlayRecent(const KURL&);
    void slotMetaFromPlayer();
    void slotToggleFullscreen();
    void slotEscapeFullscreen();
    void slotToggleMinimalMode();
    void slotToggleTab();
    void slotPreferences();
    void slotOriginalAspect();
    void slotAutoresizeOff();
    void slotAutoresizeOriginal();
    void slotAutoresizeDouble();
    void slotAutoresizeTriple();
    void slotNewFrameSize(const QSize&);
    void slotCurrentTabChanged(QWidget*);
    void slotClearRecent();
    void slotLoadPart(const QString&);
    void slotLoadingCanceled(const QString&);
    void slotPlaybackFailed();
    void slotSystemTray(bool);
    void slotUseAlternateEncoding(bool);
    void slotAlternateEncoding(const QString&);
    void slotStop();
    void slotMute();
    void slotSleepAfterPlay();
    void slotSleepAfterPlayMenu();
    void slotQuitAfterPlay();
    void slotQuitAfterPlayMenu();
    void slotTogglePlaylistDockState();
    void slotShowGoTab(bool);
    void slotSetOSDTimeout(uint);
    void slotPauseVideo(bool);

private:
    void autoresize();
    void setupAccel();
    void setupActions();
    void loadConfig();
    void saveConfig();
    void hideToolbars(bool);
    QString askForOtherDevice(const QString&);
    void unloadCurrentPart();

private:
    KMediaPart* m_mediaPart;
    KParts::ReadOnlyPart* m_simplePart;
    PlayerContainer* m_playerContainer;
    PlayList* m_playlist;
    StartWindow* m_startWindow;
#ifdef HAVE_LINUX_DVB_FRONTEND_H
    DvbPanel *dvbPanel;
#endif
    TabWidget* m_tabWidget;
    SystemTray* m_systemTray;
    QSize m_videoSize;
    bool m_noResize;
    bool m_embedSystemTray;
    bool m_sleepInfo;
    uint m_osdDuration;
    uint m_autoResizeFactor;
    
    bool m_useAlternateEncoding;
    QString m_alternateEncoding;

    bool m_autoPaused;
    bool m_pauseVideo;
    
    bool m_haveKWin;
    
    QString m_currentPartService;
    
    QString m_device;
    QString m_filter;
    QStringList m_engineParameters;
    
    KRecentFilesAction* m_recent;
    KToggleFullScreenAction* m_fullscreen;
    KToggleAction* m_minimal;
    KToggleAction* m_shuffle;
    KToggleAction* m_repeat;
    KToggleAction* m_autoResizeOff;
    KToggleAction* m_autoResizeOriginal;
    KToggleAction* m_autoResizeDouble;
    KToggleAction* m_autoResizeTriple;
    KToggleAction* m_originalAspect;
    KActionMenu* m_playersMenu;
    KToggleAction* m_sleepAfterPlay;
    KToggleAction* m_quitAfterPlay;
    bool m_statusBarVisible;
    
    QTimer m_screensaverTimer;
    int m_screensaverTimeout;
    int m_haveXTest, m_xTestKeycode;
};

#include <ktabwidget.h>

class TabWidget : public KTabWidget
{

public:
  TabWidget(QWidget* parent = 0, const char* name = 0);
  virtual ~TabWidget() {}
  
  void showTabBar();  
  void hideTabBar();
  
};

#include <qvbox.h>

class PlayerContainer : public QVBox
{
  Q_OBJECT 
 
public:  
  PlayerContainer(QWidget* parent = 0, const char* name = 0);
  virtual ~PlayerContainer() {}

signals:
  void signalURLDropEvent(const QStringList&);
  
protected:
  void dragEnterEvent (QDragEnterEvent*);
  void dropEvent(QDropEvent*);
  
};  

#endif // _KAFFEINE_H_
